/*The header file NSXMLOptions.h declares the constants listed in the following table. These constants are input and output options for all NSXMLNode objects (unless otherwise indicated), including NSXMLDocument objects. You can specify these options (OR’ing multiple options) in the NSXMLNode methods initWithKind:options: and XMLStringWithOptions:.
Constant	
Description
NSXMLNodeOptionsNone	
No options are requested for this input or output action.

Available in Mac OS X v10.4 and later.
NSXMLNodeIsCDATA	
Specifies that a text node contains and is written out as a CDATA section.

Available in Mac OS X v10.4 and later.
NSXMLNodeExpandEmptyElement	
Requests that an element should be expanded when empty; for example, <flag></flag>. This is the default.

Available in Mac OS X v10.4 and later.
NSXMLNodeCompactEmptyElement	
Requests that an element should be contracted when empty; for example, <flag/>.

Available in Mac OS X v10.4 and later.
NSXMLNodeUseSingleQuotes	
Requests that NSXML use single quotes for the value of an attribute or namespace node.

Available in Mac OS X v10.4 and later.
NSXMLNodeUseDoubleQuotes	
Requests that NSXML use double quotes for the value of an attribute or namespace node. This is the default.

Available in Mac OS X v10.4 and later.
NSXMLNodePrettyPrint	
Print this node with extra space for readability. (Output)

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveNamespaceOrder	
Requests NSXML to preserve the order of namespace URI definitions as in the source XML. 

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveAttributeOrder	
Requests that NSXMLNode preserve the order of attributes as in the source XML. 

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveEntities	
Specifies that entities (&xyz;) should not be resolved for XML output of this node.

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveCharacterReferences	
Specifies that character references (&#nnn;) should not be resolved for XML output of this node.

Available in Mac OS X v10.4 and later.
NSXMLNodePreservePrefixes	
Requests NSXMLNode not to choose prefixes based on the closest namespace URI definition.

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveCDATA	
Requests that NSXMLNode preserve CDATA blocks where defined in the input XML. 

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveWhitespace	
Requests NSXMLNode to preserve whitespace characters (such as tabs and carriage returns) in the XML source that are not part of node content.

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveEmptyElements	
Specifies that empty elements in the input XML be preserved in their contracted or expanded form.

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveQuotes	
Specifies that the quoting style used in the input XML (single or double quotes) be preserved.

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveDTD	
Specifies that declarations in a DTD should be preserved until it the DTD is modified. For example, parameter entities are by default expanded; with this option, they are written out as they originally occur in the DTD.

Available in Mac OS X v10.4 and later.
NSXMLNodePreserveAll	
Turns on all preservation options: attribute and namespace order, entities, prefixes, CDATA, whitespace, quotes, and empty elements. You should try to turn on preservation options selectively because turning on all preservation options significantly affects performance.

Available in Mac OS X v10.4 and later.


The options with “Preserve” in their names are applicable only when external sources of XML are parsed; they have no effect on node objects that are programmatically created. Other options are used in initialization and output methods of NSXMLDocument; see the NSXMLDocument reference documentation for details.*/
enum {
NSXMLNodeOptionsNone	 =1,
NSXMLNodeIsCDATA	=3,
NSXMLNodeExpandEmptyElement =3,
NSXMLNodeCompactEmptyElement	=4,
NSXMLNodeUseSingleQuotes	=5,
NSXMLNodeUseDoubleQuotes	=6,
NSXMLNodePrettyPrint	=7,
NSXMLNodePreserveNamespaceOrder	=8,
NSXMLNodePreserveAttributeOrder	=9,
NSXMLNodePreserveEntities	=10 ,
NSXMLNodePreserveCharacterReferences	=11 ,
NSXMLNodePreservePrefixes	=12 ,
NSXMLNodePreserveCDATA	=13,
NSXMLNodePreserveWhitespace	=14,
NSXMLNodePreserveEmptyElements	=15,
NSXMLNodePreserveQuotes	=16,
NSXMLNodePreserveDTD	=17,
NSXMLNodePreserveAll	=18
};
