enum {
  kDeleteAfterDownload          = 0x00000001,
  kCreateCustomIcon             = 0x00000002,
  kAddMetaDataToFinderComment   = 0x00000004,
  kAdjustCreationDate           = 0x00000008,
  kSetFileTypeAndCreator        = 0x00000010,
  kRotateImage                  = 0x00000040,
  kDontEmbedColorSyncProfile    = 0x00000080
};

enum {
  kICAThumbnailFormatICA        = 'ica ',
  kICAThumbnailFormatJPEG       = 'jpeg',
  kICAThumbnailFormatTIFF       = 'tiff'
};

enum {
kICADirectory =1,
kICAFileImage=2,
kICAPropertyImageData=3,
kICADevice=4
};

enum {
  kExtendedNotificationPB       = 'extd',
  kMessageGetEventData          = 'mged',
  kEventClassPTPStandard        = 'PTPs',
  kEventClassPTPVendor          = 'PTPv'
};

enum {
  kICAEventCancelTransaction    = 'ecnt',
  kICAEventObjectAdded          = 'eoba',
  kICAEventObjectRemoved        = 'eobr',
  kICAEventStoreAdded           = 'esta',
  kICAEventStoreRemoved         = 'estr',
  kICAEventDeviceAdded          = 'edea',
  kICAEventDeviceRemoved        = 'eder',
  kICAEventDevicePropChanged    = 'edpc',
  kICAEventObjectInfoChanged    = 'eoic',
  kICAEventDeviceInfoChanged    = 'edic',
  kICAEventRequestObjectTransfer = 'erot',
  kICAEventStoreFull            = 'estf',
  kICAEventDeviceReset          = 'edvr',
  kICAEventStorageInfoChanged   = 'esic',
  kICAEventCaptureComplete      = 'ecpc',
  kICAEventUnreportedStatus     = 'eurs'
};




typedef int  ICAObject;
typedef int*       ICAProperty;

struct ICAMessage {
int messageType;
};
typedef struct ICAMessage ICAMessage;


struct ICAHeader{
int refcon;
int err;
};
typedef struct ICAHeader ICAHeader;


struct ICAObjectSendMessagePB{
ICAHeader  header;
int object;
ICAMessage message;
};
typedef struct ICAObjectSendMessagePB ICAObjectSendMessagePB;


struct ICAGetDeviceListPB{
int object;
};
typedef struct ICAGetDeviceListPB ICAGetDeviceListPB;

struct ICAGetChildCountPB{
int object;
int count;
};
typedef struct ICAGetChildCountPB ICAGetChildCountPB;

struct ICAObjectInfo{
int objectType;
int objectSubtype;
};
typedef struct ICAObjectInfo ICAObjectInfo;

struct ICAGetNthChildPB{
int parentObject;
int index;
int childObject;
ICAHeader  header;
ICAObjectInfo childInfo;
};
typedef struct ICAGetNthChildPB ICAGetNthChildPB;

struct ICACopyObjectPropertyDictionaryPB{
int object;
int * theDict;
 ICAHeader  header;
};
typedef struct ICACopyObjectPropertyDictionaryPB ICACopyObjectPropertyDictionaryPB;

struct ICAGetObjectInfoPB{
ICAHeader  header;
int object;
ICAObjectInfo objectInfo;
};
typedef struct ICAGetObjectInfoPB ICAGetObjectInfoPB;

struct ICADownloadFilePB{
int err;
int object;
int fileFSRef;
int dirFSRef;
 ICAHeader header;
int flags;
};
typedef struct ICADownloadFilePB ICADownloadFilePB;

struct ICAGetPropertyDataPB {
int actualSize;
int dataPtr;
int requestedSize;
int startByte;
int property;
};
typedef struct ICAGetPropertyDataPB     ICAGetPropertyDataPB;

struct ICAPropertyInfo {
int dataSize;
int propertyType;
int dataType;
};
typedef struct ICAPropertyInfo          ICAPropertyInfo;


struct ICAGetPropertyByTypePB {
ICAPropertyInfo propertyInfo;
int   property;
ICAHeader  header;
int object;
int propertyType;
};
typedef struct ICAGetPropertyByTypePB   ICAGetPropertyByTypePB;

struct ICAGetPropertyCountPB {
int object;
int count;
};
typedef struct ICAGetPropertyCountPB    ICAGetPropertyCountPB;

struct ICAGetNthPropertyPB {
ICAPropertyInfo propertyInfo;
int property;
int object;
int index;
};
typedef struct ICAGetNthPropertyPB      ICAGetNthPropertyPB;

struct ICARegisterEventNotificationPB {
ICAHeader  header;
int notifyProc;
int object;
int notifyType;
};
typedef struct ICARegisterEventNotificationPB ICARegisterEventNotificationPB;

struct ICAExtendedRegisterEventNotificationPB {
int extd;
int eventType;
int deviceObject;
int object;
};
typedef struct ICAExtendedRegisterEventNotificationPB ICAExtendedRegisterEventNotificationPB;

struct ICACopyObjectThumbnailPB {
ICAHeader  header;
int* thumbnailData;
int thumbnailFormat;
int object;
};
typedef struct ICACopyObjectThumbnailPB ICACopyObjectThumbnailPB;


//function

int ICAGetChildCount(int a, int b);
int ICAObjectSendMessage(int a, int b);
int ICAGetDeviceList(int a, int b);
int ICAGetNthChild (int a, int  b);
int ICACopyObjectPropertyDictionary(int a, int b);
int ICAGetObjectInfo(int a, int b);
int ICADownloadFile(int  a,int b);
int ICAGetPropertyData(int a,int b);
int ICAGetPropertyByType(int a,int b);
int ICAGetPropertyCount(int a,int b);
int ICAGetNthProperty(int a,int b);
int ICARegisterEventNotification(int a,int b);
int ICACopyObjectThumbnail(int a, int b);