#ifndef  MDITEM_H
#define  MDITEM_H

#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFDictionary.h>
#include <CoreFoundation/CFArray.h>

/*File System Metadata Attribute Keys

Metadata attribute keys that describe the file system attributes for a file.

const CFStringRef kMDItemDisplayName;
const CFStringRef kMDItemFSContentChangeDate;
const CFStringRef kMDItemFSCreationDate;
const CFStringRef kMDItemFSExists;
const CFStringRef kMDItemFSInvisible;
const CFStringRef kMDItemFSIsExtensionHidden;
const CFStringRef kMDItemFSIsReadable;
const CFStringRef kMDItemFSIsWriteable;
const CFStringRef kMDItemFSLabel;
const CFStringRef kMDItemFSName;
const CFStringRef kMDItemFSNodeCount;
const CFStringRef kMDItemFSOwnerGroupID;
const CFStringRef kMDItemFSOwnerUserID;
const CFStringRef kMDItemFSSize;
const CFStringRef kMDItemPath;
Constants
kMDItemDisplayName

The localized version of the file name. This is the localized version of the LaunchServices call LSCopyDisplayNameForURL()/LSCopyDisplayNameForRef(). A CFString.

Available in Mac OS X v10.4 and later.
kMDItemFSContentChangeDate

The date the file contents last changed. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemFSCreationDate

The date and time that the file was created. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemFSExists

This attribute is deprecated and was never implemented.

Deprecated in Mac OS X v10.4.
kMDItemFSInvisible

Indicates whether the file is invisible. A CFBoolean.

Available in Mac OS X v10.4 and later.
kMDItemFSIsExtensionHidden

Indicates whether the file extension of the file is hidden. A CFBoolean.

Available in Mac OS X v10.4 and later.
kMDItemFSIsReadable

This attribute is deprecated and was never implemented.

Deprecated in Mac OS X v10.4.
kMDItemFSIsWriteable

This attribute is deprecated and was never implemented.

Deprecated in Mac OS X v10.4.
kMDItemFSLabel

Index of the Finder label of the file. Possible values are 0 through 7. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSName

The file name of the item. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemFSNodeCount

Number of files in a directory. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSOwnerGroupID

The group ID of the owner of the file. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSOwnerUserID

The user ID of the owner of the file. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemFSSize

The size, in bytes, of the file on disk. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPath

The complete path to the file. A CFString.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
const CFStringRef kMDItemDisplayName;
const CFStringRef kMDItemFSContentChangeDate;
const CFStringRef kMDItemFSCreationDate;
const CFStringRef kMDItemFSExists;
const CFStringRef kMDItemFSInvisible;
const CFStringRef kMDItemFSIsExtensionHidden;
const CFStringRef kMDItemFSIsReadable;
const CFStringRef kMDItemFSIsWriteable;
const CFStringRef kMDItemFSLabel;
const CFStringRef kMDItemFSName;
const CFStringRef kMDItemFSNodeCount;
const CFStringRef kMDItemFSOwnerGroupID;
const CFStringRef kMDItemFSOwnerUserID;
const CFStringRef kMDItemFSSize;
const CFStringRef kMDItemPath;


/*Common Metadata Attribute Keys

Metadata attribute keys that are common to many file types.

const CFStringRef kMDItemAttributeChangeDate;
const CFStringRef kMDItemAudiences;
const CFStringRef kMDItemAuthors;
const CFStringRef kMDItemCity;
const CFStringRef kMDItemComment;
const CFStringRef kMDItemContactKeywords;
const CFStringRef kMDItemContentCreationDate;
const CFStringRef kMDItemContentModificationDate;
const CFStringRef kMDItemContentType;
const CFStringRef kMDItemContributors;
const CFStringRef kMDItemCopyright;
const CFStringRef kMDItemCountry;
const CFStringRef kMDItemCoverage;
const CFStringRef kMDItemCreator;
const CFStringRef kMDItemDescription;
const CFStringRef kMDItemDueDate;
const CFStringRef kMDItemDurationSeconds;
const CFStringRef kMDItemEmailAddresses;
const CFStringRef kMDItemEncodingApplications;
const CFStringRef kMDItemFinderComment;
const CFStringRef kMDItemFonts;
const CFStringRef kMDItemHeadline;
const CFStringRef kMDItemIdentifier;
const CFStringRef kMDItemInstantMessageAddresses;
const CFStringRef kMDItemInstructions;
const CFStringRef kMDItemKeywords;
const CFStringRef kMDItemKind;
const CFStringRef kMDItemLanguages;
const CFStringRef kMDItemLastUsedDate;
const CFStringRef kMDItemNumberOfPages;
const CFStringRef kMDItemOrganizations;
const CFStringRef kMDItemPageHeight;
const CFStringRef kMDItemPageWidth;
const CFStringRef kMDItemPhoneNumbers;
const CFStringRef kMDItemProjects;
const CFStringRef kMDItemPublishers;
const CFStringRef kMDItemRecipients;
const CFStringRef kMDItemRights;
const CFStringRef kMDItemSecurityMethod;
const CFStringRef kMDItemStarRating;
const CFStringRef kMDItemStateOrProvince;
const CFStringRef kMDItemTextContent;
const CFStringRef kMDItemTitle;
const CFStringRef kMDItemVersion;
const CFStringRef kMDItemWhereFroms;
Constants
kMDItemAttributeChangeDate

The date and time of the last change made to a metadata attribute. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemAudiences

The audience for which the file is intended. The audience may be determined by the creator or the publisher or by a third party. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemAuthors

The author, or authors, of the contents of the file. The order of the authors is preserved, but does not represent the main author or relative importance of the authors. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemCity

Identifies city of origin according to guidelines established by the provider. For example, "New York", "Cupertino", or "Toronto". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemComment

A comment related to the file. This differs from the Finder comment, kMDItemFinderComment. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemContactKeywords

A list of contacts that are associated with this document, not including the authors. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemContentCreationDate

The date that the contents of the file were created. This is different than the file creation date. Its can be used to store when the file contents were first created, or first modified. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemContentModificationDate

The date and time that the contents of the file were last modified. This is not necessarily the file modification date. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemContentType

The UTI pedigree of a file. For example, a jpeg image file will have a value of public.jpeg/public.image/public.data. The value of this attribute is set by the MDImporter. Changes to this value are lost when the file attributes are next imported. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemContributors

The entities responsible for making contributions to the content of the resource. Examples of a contributor include a person, an organization or a service. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemCopyright

The copyright owner of the file contents. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemCountry

The full, publishable name of the country or primary location where the intellectual property of the item was created, according to guidelines of the provider. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemCoverage

The extent or scope of the content of the resource. Coverage will typically include spatial location (a place name or geographic co-ordinates), temporal period (a period label, date, or date range) or jurisdiction (such as a named administrative entity). Recommended best practice is to select a value from a controlled vocabulary, and that, where appropriate, named places or time periods be used in preference to numeric identifiers such as sets of co-ordinates or date ranges. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemCreator

Application used to create the document content (e.g. "Word", "AppleWorks", etc.). A CFString.

Available in Mac OS X v10.4 and later.
kMDItemDescription

A description of the content of the resource. The description may include an abstract, table of contents, reference to a graphical representation of content or a free-text account of the content. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemDueDate

Date this item is due. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemDurationSeconds

The duration, in seconds, of the content of file. A value of 10.5 represents media that is 10 and 1/2 seconds long. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemEmailAddresses

Email addresses related to this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemEncodingApplications

Application used to convert the original content into it's current form. For example, a PDF file might have an encoding application set to "Distiller". A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemFinderComment

Finder comments for this file. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemFonts

Fonts used in this item. You should store the font's full name, the postscript name, or the font family name, based on the available information. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemHeadline

A publishable entry providing a synopsis of the contents of the file. For example, "Apple Introduces the iPod Photo". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemIdentifier

A formal identifier used to reference the resource within a given context. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemInstantMessageAddresses

Instant message addresses related to this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemInstructions

Editorial instructions concerning the use of the item, such as embargoes and warnings. For example, "Second of four stories". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemKeywords

Keywords associated with this file. For example, “Birthday”, “Important”, etc. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemKind

A description of the kind of item this file represents. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemLanguages

Indicates the languages of the intellectual content of the resource. Recommended best practice for the values of the Language element is defined by RFC 3066. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemLastUsedDate

The date and time that the file was last used. This value is updated automatically by LaunchServices everytime a file is opened by double clicking, or by asking LaunchServices to open a file. A CFDate.

Available in Mac OS X v10.4 and later.
kMDItemNumberOfPages

Number of pages in the document. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemOrganizations

The company or organization that created the document. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemPageHeight

Height of the document page, in points (72 points per inch). For PDF files this indicates the height of the first page only. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPageWidth

Width of the document page, in points (72 points per inch). For PDF files this indicates the width of the first page only. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemPhoneNumbers

Phone numbers related to this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemProjects

The list of projects that this file is part of. For example, if you were working on a movie all of the files could be marked as belonging to the project “My Movie”. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemPublishers

The entity responsible for making the resource available. For example, a person, an organization, or a service. Typically, the name of a publisher should be used to indicate the entity. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemRecipients

Recipients of this item. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
kMDItemRights

Provides a link to information about rights held in and over the resource. Contains a rights management statement for the resource, or reference a service providing such information. Rights information often encompasses Intellectual Property Rights (IPR), Copyright, and various Property Rights. If this attribute is absent, no assumptions can be made about the status of these and other rights with respect to the resource. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemSecurityMethod

The security or encryption method used for the file. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemStarRating

User rating of this item. For example, the stars rating of an iTunes track. A CFNumber.

Available in Mac OS X v10.4 and later.
kMDItemStateOrProvince

Identifies the province or state of origin according to guidelines established by the provider. For example, "CA", "Ontario", or "Sussex". A CFString.

Available in Mac OS X v10.4 and later.
kMDItemTextContent

Contains a text representation of the content of the document. Data in multiple fields should be combined using a whitespace character as a separator. An application's Spotlight importer provides the content of this attribute. Applications can search for values in this attribute, but are not able to read the content of this attribute directly. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemTitle

The title of the file. For example, this could be the title of a document, the name of an song, or the subject of an email message. A CFString.

Available in Mac OS X v10.4 and later.
kMDItemVersion

The version number of this file. A CFString

Available in Mac OS X v10.4 and later.
kMDItemWhereFroms

Describes where the file was obtained from. For example, a downloaded file may refer to the URL, files received by email may indicate the sender’s email address, message subject, etc. A CFArray of CFStrings.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
const CFStringRef kMDItemAttributeChangeDate;
const CFStringRef kMDItemAudiences;
const CFStringRef kMDItemAuthors;
const CFStringRef kMDItemCity;
const CFStringRef kMDItemComment;
const CFStringRef kMDItemContactKeywords;
const CFStringRef kMDItemContentCreationDate;
const CFStringRef kMDItemContentModificationDate;
const CFStringRef kMDItemContentType;
const CFStringRef kMDItemContributors;
const CFStringRef kMDItemCopyright;
const CFStringRef kMDItemCountry;
const CFStringRef kMDItemCoverage;
const CFStringRef kMDItemCreator;
const CFStringRef kMDItemDescription;
const CFStringRef kMDItemDueDate;
const CFStringRef kMDItemDurationSeconds;
const CFStringRef kMDItemEmailAddresses;
const CFStringRef kMDItemEncodingApplications;
const CFStringRef kMDItemFinderComment;
const CFStringRef kMDItemFonts;
const CFStringRef kMDItemHeadline;
const CFStringRef kMDItemIdentifier;
const CFStringRef kMDItemInstantMessageAddresses;
const CFStringRef kMDItemInstructions;
const CFStringRef kMDItemKeywords;
const CFStringRef kMDItemKind;
const CFStringRef kMDItemLanguages;
const CFStringRef kMDItemLastUsedDate;
const CFStringRef kMDItemNumberOfPages;
const CFStringRef kMDItemOrganizations;
const CFStringRef kMDItemPageHeight;
const CFStringRef kMDItemPageWidth;
const CFStringRef kMDItemPhoneNumbers;
const CFStringRef kMDItemProjects;
const CFStringRef kMDItemPublishers;
const CFStringRef kMDItemRecipients;
const CFStringRef kMDItemRights;
const CFStringRef kMDItemSecurityMethod;
const CFStringRef kMDItemStarRating;
const CFStringRef kMDItemStateOrProvince;
const CFStringRef kMDItemTextContent;
const CFStringRef kMDItemTitle;
const CFStringRef kMDItemVersion;
const CFStringRef kMDItemWhereFroms;



#endif 

