//inc
#ifndef QUICKTIMECOMPONENTS_H
#define  QUICKTIMECOMPONENTS_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef IMAGECOMPRESSION_H
#include <QuickTime/ImageCompression.h>
#endif

#ifndef  MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMEMUSIC_H
#include <QuickTime/QuickTimeMusic.h>
#endif



#include <HYS/QuickTime/QuickTimeComponents.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

#if PRAGMA_ONCE
#pragma once
#endif

/*SGGrabPict Values

Constants passed to SGGrabPict.

enum {
   grabPictOffScreen             = 1,
   grabPictIgnoreClip            = 2,
   grabPictCurrentImage          = 4
};
Declared In
QuickTimeComponents.h*/
enum {
   grabPictOffScreen             = 1,
   grabPictIgnoreClip            = 2,
   grabPictCurrentImage          = 4
};

/*If you include kQTFileTypeQuickTimeImage ('qtif') in the list of types passed to StandardGetFilePreview, all files that can be opened with graphics importers are included in the file list. The slow validate approach is not used in this case.*/
enum {
kQTFileTypeQuickTimeImage ='qtif' 
};

/*SGCompressInfo

Defines the characteristics of a buffer that contains a captured image that has been compressed.

struct SGCompressInfo {
   Ptr              buffer;
   unsigned long    bufferSize;
   UInt8            similarity;
   UInt8            reserved;
};
Fields
buffer
Discussion

Points to the buffer that contains the compressed image. This pointer must contain a 32-bit clean address.
bufferSize
Discussion

Specifies the number of bytes of image data in the buffer.
similarity
Discussion

Indicates the relative similarity of this image to the previous image in a sequence. A value of 0 indicates that the current frame is a key frame in the sequence. A value of 255 indicates that the current frame is identical to the previous frame. Values from 1 through 254 indicate relative similarity, ranging from very different (1) to very similar (254).
reserved
Discussion

Reserved; set to 0.
Discussion

Callback functions use this structure to exchange information about compressed images. For example, SGCompressCompleteBottleProc must format a compression information record whenever a video frame is compressed.
Related Functions
SGCompressCompleteBottleProc
SGCompressFrameComplete
SGGrabCompressComplete
SGGrabCompressCompleteBottleProc 
Declared In
QuickTimeComponents.h*/

typedef struct SGCompressInfo {
   Ptr              buffer;
   unsigned long    bufferSize;
   UInt8            similarity;
   UInt8            reserved;
}SGCompressInfo ;

/*Component Capability Flags for Clocks

The Component Manager allows a clock component to specify information about its capabilities in the componentFlags field of the component description structure. Apple has defined two component flags for clock components. These flags specify information about the capabilities of the clock component. The component author sets these flags in the componentFlags field of the component’s ComponentDescription structure. The following constants can be used to manipulate these flags. Clock component authors should set them appropriately for their clock.
enum {
    kClockRateIsLinear = 1,        /* clock keeps constant rate *
    kClockImplementsCallBacks = 2  /* clock supports callback events *
};


kClockRateIsLinear indicates that your clock maintains a constant rate. Most clocks that you deal with in the everyday world fall into this category. An example of a clock with an irregular rate is a clock that is dependent on the position of the Macintosh computer’s mouse; the clock’s rate might change depending upon where the user moves the mouse. Set this flag to 1 if your clock has a constant rate.

kClockImplementsCallBacks indicates that your clock supports callback events. Set this flag to 1 if your clock supports callback events.

You should set the componentFlags field appropriately in the component description structure that is associated with your clock component.*/

enum {
    kClockRateIsLinear = 1,        /* clock keeps constant rate */
    kClockImplementsCallBacks = 2  /* clock supports callback events */
};

/*SCParams Values

Constants passed to SCParams.

enum {
   scGetCompression              = 1,
   scShowMotionSettings          = 1L << 0,
   scSettingsChangedItem         = -1
};
Constants
scGetCompression

Undocumented 

Available in Mac OS X v10.0 and later.
scShowMotionSettings

Undocumented 

Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

enum {
   scGetCompression              = 1,
   scShowMotionSettings          = 1L << 0,
   scSettingsChangedItem         = -1
};

/*Video Digitizer Capabilities

Flags that indicate the input and output capabilities of a video digitizer.

enum {
   digiInDoesNTSC                = 1L << 0,
   /* digitizer supports NTSC input format *
   digiInDoesPAL                 = 1L << 1,
   /* digitizer supports PAL input format *
   digiInDoesSECAM               = 1L << 2,
   /* digitizer supports SECAM input format *
   digiInDoesGenLock             = 1L << 7,
   /* digitizer does genlock *
   digiInDoesComposite           = 1L << 8,
   /* digitizer supports composite input type *
   digiInDoesSVideo              = 1L << 9,
   /* digitizer supports S-Video input type *
   digiInDoesComponent           = 1L << 10,
   /* digitizer supports component = rgb,
   input type *
   digiInVTR_Broadcast           = 1L << 11,
   / digitizer can differentiate between the two *
   digiInDoesColor               = 1L << 12,
   / digitizer supports color *
   digiInDoesBW                  = 1L << 13,
   / digitizer supports black & white *
   / Digitizer Input Current Flags = these are valid only during active operating conditions,
   *
   digiInSignalLock              = 1L << 31 / digitizer detects input signal is locked,
   this bit = horiz lock || vertical lock *
};
enum {
   digiOutDoes1                  = 1L << 0,
   /* digitizer supports 1 bit pixels *
   digiOutDoes2                  = 1L << 1,
   /* digitizer supports 2 bit pixels *
   digiOutDoes4                  = 1L << 2,
   /* digitizer supports 4 bit pixels *
   digiOutDoes8                  = 1L << 3,
   /* digitizer supports 8 bit pixels *
   digiOutDoes16                 = 1L << 4,
   /* digitizer supports 16 bit pixels *
   digiOutDoes32                 = 1L << 5,
   /* digitizer supports 32 bit pixels *
   digiOutDoesDither             = 1L << 6,
   /* digitizer dithers in indexed modes *
   digiOutDoesStretch            = 1L << 7,
   /* digitizer can arbitrarily stretch *
   digiOutDoesShrink             = 1L << 8,
   /* digitizer can arbitrarily shrink *
   digiOutDoesMask               = 1L << 9,
   /* digitizer can mask to clipping regions *
   digiOutDoesDouble             = 1L << 11,
   /* digitizer can stretch to exactly double size *
   digiOutDoesQuad               = 1L << 12,
   /* digitizer can stretch exactly quadruple size /
   digiOutDoesQuarter            = 1L << 13,
   /* digitizer can shrink to exactly quarter size *
   digiOutDoesSixteenth          = 1L << 14,
   /* digitizer can shrink to exactly sixteenth size *
   digiOutDoesRotate             = 1L << 15,
   /* digitizer supports rotate transformations *
   digiOutDoesHorizFlip          = 1L << 16,
   /* digitizer supports horizontal flips Sx < 0 *
   digiOutDoesVertFlip           = 1L << 17,
   /* digitizer supports vertical flips Sy < 0 *
   digiOutDoesSkew               = 1L << 18,
   /* digitizer supports skew = shear,
twist,
   *
   digiOutDoesBlend              = 1L << 19,
   digiOutDoesWarp               = 1L << 20,
   digiOutDoesHW_DMA             = 1L << 21,
   /* digitizer not constrained to local device *
   digiOutDoesHWPlayThru         = 1L << 22,
   /* digitizer doesn't need time to play thru *
   digiOutDoesILUT               = 1L << 23,
   /* digitizer does inverse LUT for index modes *
   digiOutDoesKeyColor           = 1L << 24,
   /* digitizer does key color functions too *
   digiOutDoesAsyncGrabs         = 1L << 25,
   /* digitizer supports async grabs *
   digiOutDoesUnreadableScreenBits = 1L << 26,
   /* playthru doesn't generate readable bits on screen*
   digiOutDoesCompress           = 1L << 27,
   /* supports alternate output data types *
   digiOutDoesCompressOnly       = 1L << 28,
   /* can't provide raw frames anywhere *
   digiOutDoesPlayThruDuringCompress = 1L << 29,
   /* digi can do playthru while providing compressed data *
   digiOutDoesCompressPartiallyVisible = 1L << 30,
   /* digi doesn't need all bits visible on screen to do hardware compress *
   digiOutDoesNotNeedCopyOfCompressData = 1L << 31 /* digi doesn't need any bufferization when providing compressed data *
};
Constants
digiInDoesNTSC

The video digitizer supports National Television System Committee (NTSC) format input video signals. This flag is set to 1 if the digitizer component supports NTSC video. 

Available in Mac OS X v10.0 and later.
digiInDoesPAL

The video digitizer component supports Phase Alternation Line (PAL) format input video signals. This flag is set to 1 if the digitizer component supports PAL video. 

Available in Mac OS X v10.0 and later.
digiInDoesSECAM

The video digitizer component supports Systeme Electronique Couleur avec Memoire (SECAM) format input video signals. This flag is set to 1 if the digitizer component supports SECAM video. 

Available in Mac OS X v10.0 and later.
digiInDoesGenLock

The video digitizer component supports genlock; that is, the digitizer can derive its timing from an external time base. This flag is set to 1 if the digitizer component supports genlock. 

Available in Mac OS X v10.0 and later.
digiInDoesComposite

The video digitizer component supports composite input video. This flag is set to 1 if the digitizer component supports composite input. 

Available in Mac OS X v10.0 and later.
digiInDoesComponent

The video digitizer component supports RGB input video. This flag is set to 1 if the digitizer component supports RGB input. 

Available in Mac OS X v10.0 and later.
digiInVTR_Broadcast

The video digitizer component can distinguish between an input signal that emanates from a videotape player and a broadcast signal. This flag is set to 1 if the digitizer component can differentiate between the two different signal types. 

Available in Mac OS X v10.0 and later.
digiInDoesColor

The video digitizer component supports color input. This flag is set to 1 if the digitizer component can accept color input. 

Available in Mac OS X v10.0 and later.
digiInDoesBW

The video digitizer component supports grayscale input. This flag is set to 1 if the digitizer component can accept grayscale input. 

Available in Mac OS X v10.0 and later.
digiInSignalLock

The video digitizer component is locked onto the input signal. If this flag is set to 1, the digitizer component detects either vertical or horizontal signal lock. 

Available in Mac OS X v10.0 and later.
digiOutDoes1

The video digitizer component can work with pixel maps that contain 1-bit pixels. If this flag is set to 1, then the digitizer component can write images that contain 1-bit pixels. If this flag is set to 0, then the digitizer component cannot handle such images. 

Available in Mac OS X v10.0 and later.
digiOutDoes2

The video digitizer component can work with pixel maps that contain 2-bit pixels. If this flag is set to 1, then the digitizer component can write images that contain 2-bit pixels. If this flag is set to 0, then the digitizer component cannot handle such images. 

Available in Mac OS X v10.0 and later.
digiOutDoes4

The video digitizer component can work with pixel maps that contain 4-bit pixels. If this flag is set to 1, then the digitizer component can write images that contain 4-bit pixels. If this flag is set to 0, then the digitizer component cannot handle such images. 

Available in Mac OS X v10.0 and later.
digiOutDoes8

The video digitizer component can work with pixel maps that contain 8-bit pixels. If this flag is set to 1, then the digitizer component can write images that contain 8-bit pixels. If this flag is set to 0, then the digitizer component cannot handle such images. 

Available in Mac OS X v10.0 and later.
digiOutDoes16

The video digitizer component can work with pixel maps that contain 16-bit pixels. If this flag is set to 1, then the digitizer component can write images that contain 16-bit pixels. If this flag is set to 0, then the digitizer component cannot handle such images. 

Available in Mac OS X v10.0 and later.
digiOutDoes32

The video digitizer component can work with pixel maps that contain 32-bit pixels. If this flag is set to 1, then the digitizer component can write images that contain 32-bit pixels. If this flag is set to 0, then the digitizer component cannot handle such images. 

Available in Mac OS X v10.0 and later.
digiOutDoesDither

The video digitizer component supports dithering. If this flag is set to 1, the component supports dithering of colors. If this flag is set to 0, the digitizer component does not support dithering. 

Available in Mac OS X v10.0 and later.
digiOutDoesStretch

The video digitizer component can stretch images to arbitrary sizes. If this flag is set to 1, the digitizer component can stretch images. If this flag is set to 0, the digitizer component does not support stretching. 

Available in Mac OS X v10.0 and later.
digiOutDoesShrink

The video digitizer component can shrink images to arbitrary sizes. If this flag is set to 1, the digitizer component can shrink images. If this flag is set to 0, the digitizer component does not support shrinking. 

Available in Mac OS X v10.0 and later.
digiOutDoesMask

The video digitizer component can handle clipping regions. If this flag is set to 1, the digitizer component can mask to an arbitrary clipping region. If this flag is set to 0, the digitizer component does not support clipping regions. 

Available in Mac OS X v10.0 and later.
digiOutDoesDouble

The video digitizer component supports stretching to quadruple size when displaying the output video. The parameters for the stretch operation are specified in the matrix structure for the request; the component modifies the scaling attributes of the matrix (see the chapter "Movie Toolbox" in Inside Macintosh: QuickTime for information about transformation matrices). If this flag is set to 1, the digitizer component can stretch an image to exactly four times its original size, up to the maximum size specified by the maxDestHeight and maxDestWidth fields in the digitizer information structure. If this flag is set to 0, the digitizer component does not support stretching to quadruple size. 

Available in Mac OS X v10.0 and later.
digiOutDoesQuad

The video digitizer component supports stretching an image to 16 times its original size when displaying the output video. The parameters for the stretch operation are specified in the matrix structure for the request; the component modifies the scaling attributes of the matrix (see the chapter "Movie Toolbox" in Inside Macintosh: QuickTime for information about transformation matrices). If this flag is set to 1, the digitizer component can stretch an image to exactly 16 times its original size, up to the maximum size specified by the maxDestHeight and maxDestWidth fields in the digitizer information structure. If this flag is set to 0, the digitizer component does not support this capability. 

Available in Mac OS X v10.0 and later.
digiOutDoesQuarter

The video digitizer component can shrink an image to one-quarter of its original size when displaying the output video. The parameters for the shrink operation are specified in the matrix structure for the request; the component modifies the scaling attributes of the matrix (see the chapter "Movie Toolbox" in Inside Macintosh: QuickTime for information about transformation matrices). If this flag is set to 1, the digitizer component can shrink an image to exactly one-quarter of its original size, down to the minimum size specified by the minDestHeight and minDestWidth fields in the digitizer information structure. If this flag is set to 0, the digitizer component does not support this capability. 

Available in Mac OS X v10.0 and later.
digiOutDoesSixteenth

The video digitizer component can shrink an image to 1/16 of its original size when displaying the output video. The parameters for the shrink operation are specified in the matrix structure for the request; the digitizer component modifies the scaling attributes of the matrix (see the chapter "Movie Toolbox" in Inside Macintosh: QuickTime for information about transformation matrices). If this flag is set to 1, the digitizer component can shrink an image to exactly 1/16 of its original size, down to the minimum size specified by the minDestHeight and minDestWidth fields in the digitizer information structure. If this flag is set to 0, the digitizer component does not support this capability. 

Available in Mac OS X v10.0 and later.
digiOutDoesRotate

The video digitizer component can rotate an image when displaying the output video. The parameters for the rotation are specified in the matrix structure for an operation. If this flag is set to 1, the digitizer component can rotate the image. If this flag is set to 0, the digitizer component cannot rotate the resulting image. 

Available in Mac OS X v10.0 and later.
digiOutDoesHorizFlip

The video digitizer component can flip an image horizontally when displaying the output video. The parameters for the horizontal flip are specified in the matrix structure for an operation. If this flag is set to 1, the digitizer component can flip the image. If this flag is set to 0, the digitizer component cannot flip the resulting image. 

Available in Mac OS X v10.0 and later.
digiOutDoesVertFlip

The video digitizer component can flip an image vertically when displaying the output video. The parameters for the vertical flip are specified in the matrix structure for an operation. If this flag is set to 1, the digitizer component can flip the image. If this flag is set to 0, the digitizer component cannot flip the resulting image. 

Available in Mac OS X v10.0 and later.
digiOutDoesSkew

The video digitizer component can skew an image when displaying the output video. Skewing an image distorts it linearly along only a single axis; for example, drawing a rectangular image into a parallelogram-shaped region. The parameters for the skew operation are specified in the matrix structure for the request. If this flag is set to 1, the digitizer component can skew an image. If this flag is set to 0, the digitizer component does not support this capability. 

Available in Mac OS X v10.0 and later.
digiOutDoesBlend

The video digitizer component can blend the resulting image with a matte when displaying the output video. The matte is provided by the application by defining either an alpha channel or a mask plane. If this flag is set to 1, the digitizer component can blend. If this flag is set to 0, the digitizer component does not support this capability. 

Available in Mac OS X v10.0 and later.
digiOutDoesWarp

The video digitizer component can warp an image when displaying the output video. Warping an image distorts it along one or more axes, perhaps nonlinearly, in effect "bending" the result region. The parameters for the warp operation are specified in the matrix structure for the request. If this flag is set to 1, the digitizer component can warp an image. If this flag is set to 0, the digitizer component does not support this capability. 

Available in Mac OS X v10.0 and later.
digiOutDoesHWPlayThru

The video digitizer component does not need idle time in order to display its video. If this flag is set to 1, your application does not need to grant processor time to the digitizer component at normal display speeds. 

Available in Mac OS X v10.0 and later.
digiOutDoesILUT

The video digitizer component supports inverse lookup tables for indexed color modes. If this flag is set to 1, the digitizer component uses inverse lookup tables when appropriate. 

Available in Mac OS X v10.0 and later.
digiOutDoesKeyColor

The video digitizer component supports clipping by means of key colors. If this flag is set to 1, the digitizer component can clip to a region defined by a key color. 

Available in Mac OS X v10.0 and later.
digiOutDoesAsyncGrabs

The video digitizer component can operate asynchronously. If this flag is set to 1, your application can use the VDSetupBuffers and VDGrabOneFrameAsync functions (described on page 0-669 and page 0-671, respectively). 

Available in Mac OS X v10.0 and later.
digiOutDoesUnreadableScreenBits

The video digitizer may place pixels on the screen that cannot be used when compressing images. 

Available in Mac OS X v10.0 and later.
digiOutDoesCompress

The video digitizer component supports compressed source devices. These devices provide compressed data directly, without having to use the Image Compression Manager. See "Controlling Compressed Source Devices" beginning on page 0-657 for more information about the functions that applications can use to work with compressed source devices. 

Available in Mac OS X v10.0 and later.
digiOutDoesCompressOnly

The video digitizer component only provides compressed image data; the component cannot provide displayable data. This flag only applies to digitizers that support compressed source devices. 

Available in Mac OS X v10.0 and later.
digiOutDoesPlayThruDuringCompress

The video digitizer component can draw images on the screen at the same time that it is delivering compressed image data. This flag only applies to digitizers that support compressed source devices. 

Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


enum {
   digiInDoesNTSC                = 1L << 0,
   /* digitizer supports NTSC input format */
   digiInDoesPAL                 = 1L << 1,
   /* digitizer supports PAL input format */
   digiInDoesSECAM               = 1L << 2,
   /* digitizer supports SECAM input format */
   digiInDoesGenLock             = 1L << 7,
   /* digitizer does genlock */
   digiInDoesComposite           = 1L << 8,
   /* digitizer supports composite input type */
   digiInDoesSVideo              = 1L << 9,
   /* digitizer supports S-Video input type */
   digiInDoesComponent           = 1L << 10,
   /* digitizer supports component = rgb,
   input type */
   digiInVTR_Broadcast           = 1L << 11,
   /* digitizer can differentiate between the two */
   digiInDoesColor               = 1L << 12,
   /* digitizer supports color */
   digiInDoesBW                  = 1L << 13,
   /* digitizer supports black & white */
   /* Digitizer Input Current Flags = these are valid only during active operating conditions,
   */
   digiInSignalLock              = 1L << 31 /* digitizer detects input signal is locked,
   this bit = horiz lock || vertical lock */
};
enum {
   digiOutDoes1                  = 1L << 0,
   /* digitizer supports 1 bit pixels */
   digiOutDoes2                  = 1L << 1,
   /* digitizer supports 2 bit pixels */
   digiOutDoes4                  = 1L << 2,
   /* digitizer supports 4 bit pixels */
   digiOutDoes8                  = 1L << 3,
   /* digitizer supports 8 bit pixels */
   digiOutDoes16                 = 1L << 4,
   /* digitizer supports 16 bit pixels */
   digiOutDoes32                 = 1L << 5,
   /* digitizer supports 32 bit pixels */
   digiOutDoesDither             = 1L << 6,
   /* digitizer dithers in indexed modes */
   digiOutDoesStretch            = 1L << 7,
   /* digitizer can arbitrarily stretch */
   digiOutDoesShrink             = 1L << 8,
   /* digitizer can arbitrarily shrink */
   digiOutDoesMask               = 1L << 9,
   /* digitizer can mask to clipping regions */
   digiOutDoesDouble             = 1L << 11,
   /* digitizer can stretch to exactly double size */
   digiOutDoesQuad               = 1L << 12,
   /* digitizer can stretch exactly quadruple size */
   digiOutDoesQuarter            = 1L << 13,
   /* digitizer can shrink to exactly quarter size */
   digiOutDoesSixteenth          = 1L << 14,
   /* digitizer can shrink to exactly sixteenth size */
   digiOutDoesRotate             = 1L << 15,
   /* digitizer supports rotate transformations */
   digiOutDoesHorizFlip          = 1L << 16,
   /* digitizer supports horizontal flips Sx < 0 */
   digiOutDoesVertFlip           = 1L << 17,
   /* digitizer supports vertical flips Sy < 0 */
   digiOutDoesSkew               = 1L << 18,
   /* digitizer supports skew = shear,
twist,
   */
   digiOutDoesBlend              = 1L << 19,
   digiOutDoesWarp               = 1L << 20,
   digiOutDoesHW_DMA             = 1L << 21,
   /* digitizer not constrained to local device */
   digiOutDoesHWPlayThru         = 1L << 22,
   /* digitizer doesn't need time to play thru */
   digiOutDoesILUT               = 1L << 23,
   /* digitizer does inverse LUT for index modes */
   digiOutDoesKeyColor           = 1L << 24,
   /* digitizer does key color functions too */
   digiOutDoesAsyncGrabs         = 1L << 25,
   /* digitizer supports async grabs */
   digiOutDoesUnreadableScreenBits = 1L << 26,
   /* playthru doesn't generate readable bits on screen*/
   digiOutDoesCompress           = 1L << 27,
   /* supports alternate output data types */
   digiOutDoesCompressOnly       = 1L << 28,
   /* can't provide raw frames anywhere */
   digiOutDoesPlayThruDuringCompress = 1L << 29,
   /* digi can do playthru while providing compressed data */
   digiOutDoesCompressPartiallyVisible = 1L << 30,
   /* digi doesn't need all bits visible on screen to do hardware compress */
   digiOutDoesNotNeedCopyOfCompressData = 1L << 31 /* digi doesn't need any bufferization when providing compressed data */
};

/*VDGetDeviceNameAndFlags Values

Constants passed to VDGetDeviceNameAndFlags.

enum {
   vdDeviceFlagShowInputsAsDevices = (1 << 0),
   / Tell the Panel to promote Inputs to Devices*
   vdDeviceFlagHideDevice        = (1 << 1) /Omit this Device entirely from the list*
};
Declared In
QuickTimeComponents.h*/
enum {
   vdDeviceFlagShowInputsAsDevices = (1 << 0),
   /* Tell the Panel to promote Inputs to Devices*/
   vdDeviceFlagHideDevice        = (1 << 1) /* Omit this Device entirely from the list*/
};


/*DataHGetInfoFlags Values

Constants passed to DataHGetInfoFlags.

enum {
   kDataHInfoFlagNeverStreams    = 1 << 0,
   /*set if this data handler doesn't stream*
   kDataHInfoFlagCanUpdateDataRefs = 1 << 1,
   / set if this data handler might update data reference*
   kDataHInfoFlagNeedsNetworkBandwidth = 1 << 2 / set if this data handler may need to occupy the network*
};
Declared In
QuickTimeComponents.h*/
enum {
   kDataHInfoFlagNeverStreams    = 1 << 0,
   /* set if this data handler doesn't stream*/
   kDataHInfoFlagCanUpdateDataRefs = 1 << 1,
   /* set if this data handler might update data reference*/
   kDataHInfoFlagNeedsNetworkBandwidth = 1 << 2 /* set if this data handler may need to occupy the network*/
};


/*Video Output Component Flag

The following flag indicates that a video output component is not connected to a display and should not be included in a list of components that are available to the user.
enum {
    kQTVideoOutputDontDisplayToUser = 1L << 0
};*/
enum {
    kQTVideoOutputDontDisplayToUser = 1L << 0
};



/*Summary of Constants/* component type values *
#define MovieImportType                   'eat '    / movie data import *
#define MovieExportType                   'spit'    / movie data export *
 
/  componentFlags values for movie import and movie export components *
enum {
    canMovieImportHandles                = 1,    /*can import from handles *
    canMovieImportFiles                  = 2,    / can import from files *
    hasMovieImportUserInterface          = 4,    / import has user interface *
    canMovieExportHandles                = 8,    / can export to handles *
    canMovieExportFiles                  = 16,   / can export to files *
    hasMovieExportUserInterface          = 32,   / export has user interface *
    dontAutoFileMovieImport              = 64    / do not automatically
                                                      import movie files *
};
 
/  flags for MovieImportHandle and MovieImportFile *
enum {
    movieImportCreateTrack                 = 1,    / create a new track *
    movieImportInParallel                  = 2,    / paste imported data *
    movieImportMustUseTrack                = 4     / use specified track *
};
 
enum {
    movieImportResultUsedMultipleTracks    = 8,    / component used
                                                      several tracks *
};
 
enum {
    / movie data import components *
    kMovieImportHandleSelect                = 1,  /* import from handle *
    kMovieImportFileSelect                  = 2,  /* import from file *
    kMovieImportSetSampleDurationSelect     = 3,  /* set sample duration *
    kMovieImportSetSampleDescriptionSelect  = 4,  /* set sample description *
    kMovieImportSetMediaFileSelect          = 5,  /* set media file *
    kMovieImportSetDimensionsSelect         = 6,  /* set track dimensions *
    kMovieImportSetChunkSizeSelect          = 7,  /* set chunk size *
    kMovieImportSetProgressProcSelect       = 8,  /* set progress func *
    kMovieImportSetAuxiliaryDataSelect      = 9,  /* set additional data *
    kMovieImportSetFromScrapSelect          = 10, /* data from scrap *
    kMovieImportDoUserDialogSelect          = 11, /* invoke user dialog *
    kMovieImportSetDurationSelect           = 12  / set paste duration *
    
    / movie data export components *
    kMovieExportToHandleSelect             = 128  / export to handle *
    kMovieExportToFileSelect               = 129,  / export to file *
    kMovieExportDoUserDialogSelect         = 130,  / invoke user dialog *
    kMovieExportGetAuxiliaryDataSelect     = 131,  / get additional data *
    kMovieExportSetProgressProcSelect      = 132   /set progress function *
};*/


//#define MovieImportType                   'eat '    /* movie data import *
//#define MovieExportType                   'spit'    /* movie data export 
 
/*  componentFlags values for movie import and movie export components */
enum {
    canMovieImportHandles                = 1,    /* can import from handles */
    canMovieImportFiles                  = 2,    /* can import from files */
    hasMovieImportUserInterface          = 4,    /* import has user interface */
    canMovieExportHandles                = 8,    /* can export to handles */
    canMovieExportFiles                  = 16,   /* can export to files */
    hasMovieExportUserInterface          = 32,   /* export has user interface */
    dontAutoFileMovieImport              = 64    /* do not automatically
                                                      import movie files */
};
 
/*  flags for MovieImportHandle and MovieImportFile */
enum {
    movieImportCreateTrack                 = 1,    /* create a new track */
    movieImportInParallel                  = 2,    /* paste imported data */
    movieImportMustUseTrack                = 4     /* use specified track */
};
 
enum {
    movieImportResultUsedMultipleTracks    = 8,    /* component used
                                                      several tracks */
};
 
enum {
    /* movie data import components */
    kMovieImportHandleSelect                = 1,  /* import from handle */
    kMovieImportFileSelect                  = 2,  /* import from file */
    kMovieImportSetSampleDurationSelect     = 3,  /* set sample duration */
    kMovieImportSetSampleDescriptionSelect  = 4,  /* set sample description */
    kMovieImportSetMediaFileSelect          = 5,  /* set media file */
    kMovieImportSetDimensionsSelect         = 6,  /* set track dimensions */
    kMovieImportSetChunkSizeSelect          = 7,  /* set chunk size */
    kMovieImportSetProgressProcSelect       = 8,  /* set progress func */
    kMovieImportSetAuxiliaryDataSelect      = 9,  /* set additional data */
    kMovieImportSetFromScrapSelect          = 10, /* data from scrap */
    kMovieImportDoUserDialogSelect          = 11, /* invoke user dialog */
    kMovieImportSetDurationSelect           = 12 , /* set paste duration */
    
    /* movie data export components */
    kMovieExportToHandleSelect             = 128,  /* export to handle */
    kMovieExportToFileSelect               = 129,  /* export to file */
    kMovieExportDoUserDialogSelect         = 130,  /* invoke user dialog */
    kMovieExportGetAuxiliaryDataSelect     = 131,  /* get additional data */
    kMovieExportSetProgressProcSelect      = 132   /* set progress function */
};

/*Component Instance, Type, and Subtypetypedef ComponentInstance QTVideoOutputComponent;
enum {
    QTVideoOutputComponentType = FOUR_CHAR_CODE('vout'),
    QTVideoOutputComponentBaseSubType = FOUR_CHAR_CODE('base')
};*/
enum {
    QTVideoOutputComponentType = FOUR_CHAR_CODE('vout'),
    QTVideoOutputComponentBaseSubType = FOUR_CHAR_CODE('base')
};

/*movieExportDuration

Constants grouped with movieExportDuration.

enum {
   movieExportUseConfiguredSettings = 'ucfg',
   // pointer to Boolean
   movieExportWidth              = 'wdth',
   // pointer to Fixed
   movieExportHeight             = 'hegt',
   // pointer to Fixed
   movieExportDuration           = 'dura',
   // pointer to TimeRecord
   movieExportVideoFilter        = 'iflt',
   // pointer to QTAtomContainer
   movieExportTimeScale          = 'tmsc' // pointer to TimeScale
};
Constants
movieExportWidth

A fixed integer that represents a video track's image width in pixels. 

Available in Mac OS X v10.0 and later.
movieExportHeight

A fixed integer that represents a video track's image height in pixels. 

Available in Mac OS X v10.0 and later.
movieExportDuration

The TimeRecord structure for the whole movie. 

Available in Mac OS X v10.0 and later.
movieExportVideoFilter

A pointer to a QTAtomContainer handle that references a video track's filter atom container. 

Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
enum {
   movieExportUseConfiguredSettings = 'ucfg',
   /* pointer to Boolean*/
   movieExportWidth              = 'wdth',
   /* pointer to Fixed*/
   movieExportHeight             = 'hegt',
   /* pointer to Fixed*/
   movieExportDuration           = 'dura',
   /* pointer to TimeRecord*/
   movieExportVideoFilter        = 'iflt',
   /* pointer to QTAtomContainer*/
   movieExportTimeScale          = 'tmsc' /* pointer to TimeScale*/
};

/*MovieExportGetPropertyProc

Returns parameters that determine the appropriate format for movie export data.

typedef OSErr (*MovieExportGetPropertyProcPtr) (void *refcon, long trackID, OSType propertyType, void *propertyValue);

If you name your function MyMovieExportGetPropertyProc, you would declare it this way:

OSErr MyMovieExportGetPropertyProc (
   void      *refcon,
   long      trackID,
   OSType    propertyType,
   void      *propertyValue );
Parameters
refcon

Contains the value passed to MovieExportAddDataSource in the refCon parameter.
trackID

Specifies the value returned from MovieExportAddDataSource.
propertyType

Contains a pointer to the location of the requested property information.
propertyValue

Specifies the property being requested (see below). See these constants: 
scSoundSampleRateType
scSoundSampleSizeType
scSoundChannelCountType
scSoundCompressionType
movieExportWidth
movieExportHeight
movieExportVideoFilter
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
movieExportDuration
Return Value

See Error Codes. Your callback should return noErr if there is no error. If this function doesn't have a setting for a requested property, it should return an error. 
Discussion

This function is passed to MovieExportAddDataSource to define a new data source for an export operation. For example, a video export operation may call this function to determine the dimensions of the destination video track. The export component provides a default value for the property based on the source data format. For example, if no values for video track width and height properties were provided by the callback function, the dimensions of the source data would be used.
Declared In
QuickTimeComponents.h*/
typedef OSErr (*MovieExportGetPropertyProcPtr) (void *refcon, long trackID, OSType propertyType, void *propertyValue);

/*MovieExportGetPropertyUPP

Represents a type used by the Movie Components API.

typedef STACK_UPP_TYPE(MovieExportGetPropertyProcPtr) MovieExportGetPropertyUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(MovieExportGetPropertyProcPtr) MovieExportGetPropertyUPP;




/*MovieExportGetDataProc

Defines a data source for an export operation.

typedef OSErr (*MovieExportGetDataProcPtr) (void *refCon, MovieExportGetDataParams *params);

If you name your function MyMovieExportGetDataProc, you would declare it this way:

OSErr MyMovieExportGetDataProc (
   void                        *refCon,
   MovieExportGetDataParams    *params );
Parameters
refCon

Contains the value passed to MovieExportAddDataSource in the refCon parameter
params

The sample request is made through a MovieExportGetDataParams structure.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Discussion

This callback is passed to MovieExportAddDataSource to define a new data source for an export operation. The function is used by the exporting application to request source media data to be used in the export operation. For example, in a video export operation, frames of video data (either compressed or uncompressed) are provided. In a sound export operation, buffers of audio (either compressed or uncompressed) are provided.
Special Considerations

The data pointed to by dataPtr must remain valid until the next call to this function. The MovieExportGetDataProc callback is responsible for allocating and disposing of the memory associated with this data pointer.
Declared In
QuickTimeComponents.h*/
typedef OSErr (*MovieExportGetDataProcPtr) (void *refCon, MovieExportGetDataParams *params);
/*MovieExportGetDataUPP

Represents a type used by the Movie Components API.

typedef STACK_UPP_TYPE(MovieExportGetDataProcPtr) MovieExportGetDataUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(MovieExportGetDataProcPtr) MovieExportGetDataUPP;

/*MovieExportComponent

Represents a type used by the Movie Components API.

typedef ComponentInstance MovieExportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance MovieExportComponent;

/*Pointer Data Handler

The Pointer data handler adds to the complement of other QuickTime data handlers. Like the Handle Data Handler, the Pointer data handler supports references to data in memory; unlike the Handle data handler, the Pointer data handler does not require that data reside within a block allocated by the Macintosh Memory Manager. You just specify the memory address of the data and its length, and the Pointer data handler will do the rest.

The Pointer data handler allows you to submit data for use by QuickTime via direct memory address. However, it does not eliminate the use of handles in QuickTime��s data handler API. Data references themselves are still stored in handles on which QuickTime will call GetHandleSize. The API also requires that ancillary pieces of information about data references, such as their names and MIME types, are passed to QuickTime in handle blocks, not pointer blocks.

A pointer data ref record has the following definition:struct PointerDataRefRecord {
    void        *data;
    Size        dataLength;
};
typedef PointerDataRefRecord *PointerDataRefPtr;
typedef PointerDataRefPtr *PointerDataRef;


The code snippet in Listing 1-8 shows you how you can open media at a specific memory address as a QuickTime movie. The snippet does not include error checking.*/
struct PointerDataRefRecord {
    void        *data;
    Size        dataLength;
};
typedef struct PointerDataRefRecord PointerDataRefRecord  ;
typedef struct PointerDataRefRecord *PointerDataRefPtr;
typedef PointerDataRefPtr *PointerDataRef;



/*Standard Compression Constants

Constants that represent constants for Standard Compression.

enum {
   /*
   * Indicates the client is ready to use the ICM compression session
   * API to perform compression operations. StdCompression disables
   * frame reordering and multi pass encoding if this flag is cleared.
   */
   //scAllowEncodingWithCompressionSession = 1L << 8,
   /*
   * Indicates the client does not want the user to change the frame
   * reordering setting.
   */
   //scDisableFrameReorderingItem  = 1L << 9,
   /*
   * Indicates the client does not want the user to change the multi
   * pass encoding setting
   */
  // scDisableMultiPassEncodingItem = 1L << 10
//};
//enum {
   /*
   * Specifies if frame reordering can occur in encoding.
   */
   //scVideoAllowFrameReorderingType = 'bfra',
   /* pointer to Boolean*/
   /*
   * The settings to control multi pass encoding.
   */
   //scVideoMultiPassEncodingSettingsType = 'mpes' /* pointer to SCVideoMutiPassEncodingSettings struct*/
//};
/*enum {
   scListEveryCodec              = 1L << 1,
   scAllowZeroFrameRate          = 1L << 2,
   scAllowZeroKeyFrameRate       = 1L << 3,
   scShowBestDepth               = 1L << 4,
   scUseMovableModal             = 1L << 5,
   scDisableFrameRateItem        = 1L << 6,
   scShowDataRateAsKilobits      = 1L << 7
};
enum {
   scOKItem                      = 1,
   scCancelItem                  = 2,
   scCustomItem                  = 3
};
enum {
   scPositionRect                = 2,
   scPositionDialog              = 3,
   scSetTestImagePictHandle      = 4,
   scSetTestImagePictFile        = 5,
   scSetTestImagePixMap          = 6,
   scGetBestDeviceRect           = 7,
   scRequestImageSettings        = 10,
   scCompressImage               = 11,
   scCompressPicture             = 12,
   scCompressPictureFile         = 13,
   scRequestSequenceSettings     = 14,
   scCompressSequenceBegin       = 15,
   scCompressSequenceFrame       = 16,
   scCompressSequenceEnd         = 17,
   scDefaultPictHandleSettings   = 18,
   scDefaultPictFileSettings     = 19,
   scDefaultPixMapSettings       = 20,
   scGetInfo                     = 21,
   scSetInfo                     = 22,
   scNewGWorld                   = 23
};
enum {
   scPreferCropping              = 1 << 0,
   scPreferScaling               = 1 << 1,
   scPreferScalingAndCropping    = scPreferScaling | scPreferCropping,
   scDontDetermineSettingsFromTestImage = 1 << 2
};
enum {
   scSpatialSettingsType         = 'sptl',
   /* pointer to SCSpatialSettings struct*/
//   scTemporalSettingsType        = 'tprl',
   /* pointer to SCTemporalSettings struct*/
   //scDataRateSettingsType        = 'drat',
   /* pointer to SCDataRateSettings struct*/
   //scColorTableType              = 'clut',
   /* pointer to CTabHandle*/
   //scProgressProcType            = 'prog',
   /* pointer to ProgressRecord struct*/
   //scExtendedProcsType           = 'xprc',
   /* pointer to SCExtendedProcs struct*/
   //scPreferenceFlagsType         = 'pref',
   /* pointer to long*/
   //scSettingsStateType           = 'ssta',
   /* pointer to Handle*/
   //scSequenceIDType              = 'sequ',
   /* pointer to ImageSequence*/
   //scWindowPositionType          = 'wndw',
   /* pointer to Point*/
   //scCodecFlagsType              = 'cflg',
   /* pointer to CodecFlags*/
   //scCodecSettingsType           = 'cdec',
   /* pointer to Handle*/
   //scForceKeyValueType           = 'ksim',
   /* pointer to long*/
   //scCompressionListType         = 'ctyl',
   /* pointer to OSType Handle*/
   //scCodecManufacturerType       = 'cmfr',
   /* pointer to OSType*/
   //scAvailableCompressionListType = 'avai',
   /* pointer to OSType Handle*/
   //scWindowOptionsType           = 'shee',
   /* pointer to SCWindowSettings struct*/
   //scSoundVBRCompressionOK       = 'cvbr',
   /* pointer to Boolean*/
   //scSoundSampleRateChangeOK     = 'rcok',
   /* pointer to Boolean*/
   //scSoundCompressionType        = 'ssct',
   /* pointer to OSType*/
   //scSoundSampleRateType         = 'ssrt',
   /* pointer to UnsignedFixed*/
   //scSoundInputSampleRateType    = 'ssir',
   /* pointer to UnsignedFixed*/
   //scSoundSampleSizeType         = 'ssss',
   /* pointer to short*/
   //scSoundChannelCountType       = 'sscc' /* pointer to short*/
/*};
enum {
   scTestImageWidth              = 80,
   scTestImageHeight             = 80
};
enum {
   scUserCancelled               = 1
};
enum {
   scWindowRefKindCarbon         = 'carb' /* WindowRef*/
/*};
Constants
scVideoAllowFrameReorderingType

Pointer to Boolean. 

Available in Mac OS X v10.3 and later.
scSpatialSettingsType

A video track's SCSpatialSettings structure. 

Available in Mac OS X v10.0 and later.
scTemporalSettingsType

A video track's SCTemporalSettings structure. 

Available in Mac OS X v10.0 and later.
scDataRateSettingsType

A video track's SCDataRateSettings structure. 

Available in Mac OS X v10.0 and later.
scCodecSettingsType

Pointer to Handle. 

Available in Mac OS X v10.0 and later.
scForceKeyValueType

Pointer to long. 

Available in Mac OS X v10.0 and later.
scCodecManufacturerType

Pointer to OSType. 

Available in Mac OS X v10.0 and later.
scAvailableCompressionListType

Pointer to OSType Handle. 

Available in Mac OS X v10.2 and later.
scWindowOptionsType

Pointer to SCWindowSettings struct. 

Available in Mac OS X v10.3 and later.
scSoundVBRCompressionOK

Pointer to Boolean. 

Available in Mac OS X v10.2 and later.
scSoundSampleRateChangeOK

Pointer to Boolean. 

Available in Mac OS X v10.2 and later.
scSoundCompressionType

A sound track's compression type constant; see Codec Identifiers. 

Available in Mac OS X v10.0 and later.
scSoundSampleRateType

An UnsignedFixed value that represents a sound track's sampling rate. 

Available in Mac OS X v10.0 and later.
scSoundInputSampleRateType

Pointer to UnsignedFixed. 

Available in Mac OS X v10.2 and later.
scSoundSampleSizeType

A short integer that represents a sound track's sample size. 

Available in Mac OS X v10.0 and later.
scSoundChannelCountType

A short integer that represents a sound track's channel count. 

Available in Mac OS X v10.0 and later.*/
enum {
   /*
   * Indicates the client is ready to use the ICM compression session
   * API to perform compression operations. StdCompression disables
   * frame reordering and multi pass encoding if this flag is cleared.
   */
   scAllowEncodingWithCompressionSession = 1L << 8,
   /*
   * Indicates the client does not want the user to change the frame
   * reordering setting.
   */
   scDisableFrameReorderingItem  = 1L << 9,
   /*
   * Indicates the client does not want the user to change the multi
   * pass encoding setting
   */
   scDisableMultiPassEncodingItem = 1L << 10
};
enum {
   /*
   * Specifies if frame reordering can occur in encoding.
   */
   scVideoAllowFrameReorderingType = 'bfra',
   /* pointer to Boolean*/
   /*
   * The settings to control multi pass encoding.
   */
   scVideoMultiPassEncodingSettingsType = 'mpes' /* pointer to SCVideoMutiPassEncodingSettings struct*/
};
enum {
   scListEveryCodec              = 1L << 1,
   scAllowZeroFrameRate          = 1L << 2,
   scAllowZeroKeyFrameRate       = 1L << 3,
   scShowBestDepth               = 1L << 4,
   scUseMovableModal             = 1L << 5,
   scDisableFrameRateItem        = 1L << 6,
   scShowDataRateAsKilobits      = 1L << 7
};
enum {
   scOKItem                      = 1,
   scCancelItem                  = 2,
   scCustomItem                  = 3
};
enum {
   scPositionRect                = 2,
   scPositionDialog              = 3,
   scSetTestImagePictHandle      = 4,
   scSetTestImagePictFile        = 5,
   scSetTestImagePixMap          = 6,
   scGetBestDeviceRect           = 7,
   scRequestImageSettings        = 10,
   scCompressImage               = 11,
   scCompressPicture             = 12,
   scCompressPictureFile         = 13,
   scRequestSequenceSettings     = 14,
   scCompressSequenceBegin       = 15,
   scCompressSequenceFrame       = 16,
   scCompressSequenceEnd         = 17,
   scDefaultPictHandleSettings   = 18,
   scDefaultPictFileSettings     = 19,
   scDefaultPixMapSettings       = 20,
   scGetInfo                     = 21,
   scSetInfo                     = 22,
   scNewGWorld                   = 23
};
enum {
   scPreferCropping              = 1 << 0,
   scPreferScaling               = 1 << 1,
   scPreferScalingAndCropping    = scPreferScaling | scPreferCropping,
   scDontDetermineSettingsFromTestImage = 1 << 2
};
enum {
   scSpatialSettingsType         = 'sptl',
   /* pointer to SCSpatialSettings struct*/
   scTemporalSettingsType        = 'tprl',
   /* pointer to SCTemporalSettings struct*/
   scDataRateSettingsType        = 'drat',
   /* pointer to SCDataRateSettings struct*/
   scColorTableType              = 'clut',
   /* pointer to CTabHandle*/
   scProgressProcType            = 'prog',
   /* pointer to ProgressRecord struct*/
   scExtendedProcsType           = 'xprc',
   /* pointer to SCExtendedProcs struct*/
   scPreferenceFlagsType         = 'pref',
   /* pointer to long*/
   scSettingsStateType           = 'ssta',
   /* pointer to Handle*/
   scSequenceIDType              = 'sequ',
   /* pointer to ImageSequence*/
   scWindowPositionType          = 'wndw',
   /* pointer to Point*/
   scCodecFlagsType              = 'cflg',
   /* pointer to CodecFlags*/
   scCodecSettingsType           = 'cdec',
   /* pointer to Handle*/
   scForceKeyValueType           = 'ksim',
   /* pointer to long*/
   scCompressionListType         = 'ctyl',
   /* pointer to OSType Handle*/
   scCodecManufacturerType       = 'cmfr',
   /* pointer to OSType*/
   scAvailableCompressionListType = 'avai',
   /* pointer to OSType Handle*/
   scWindowOptionsType           = 'shee',
   /* pointer to SCWindowSettings struct*/
   scSoundVBRCompressionOK       = 'cvbr',
   /* pointer to Boolean*/
   scSoundSampleRateChangeOK     = 'rcok',
   /* pointer to Boolean*/
   scSoundCompressionType        = 'ssct',
   /* pointer to OSType*/
   scSoundSampleRateType         = 'ssrt',
   /* pointer to UnsignedFixed*/
   scSoundInputSampleRateType    = 'ssir',
   /* pointer to UnsignedFixed*/
   scSoundSampleSizeType         = 'ssss',
   /* pointer to short*/
   scSoundChannelCountType       = 'sscc' /* pointer to short*/
};
enum {
   scTestImageWidth              = 80,
   scTestImageHeight             = 80
};
enum {
   scUserCancelled               = 1
};
enum {
   scWindowRefKindCarbon         = 'carb' /* WindowRef*/
};

/*Audio Property Selectors

The following values are used as ComponentPropertyID selectors. Use these with the StandardCompressionSubTypeAudio ('scdi'/'audi') component. All property IDs are to be used in conjunction with the kQTPropertyClass_SCAudio property class. 
kQTSCAudioPropertyID_AvailableCompressionFormatList = 'acf#'

A read/listen C-style array of OSType values that specifies the list of available output compression formats. This list includes all the kAudioEncoderComponentType components and kSoundCompressor type components on the user��s system. You can restrict the list by using the kQTSCAudioPropertyID_CompressionFormatList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for this array.
kQTSCAudioPropertyID_ClientRestrictedCompressionFormatList = 'crf#'

A read/write/listen C-style array of OSType values that specifies a client-restricted set of output compression formats that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableCompressionFormatNamesList = 'cnm#'

A read/write CFArrayRef structure of CFStringRef structures that reference the human-readable names of each item in a kQTSCAudioPropertyID_AvailableCompressionFormatList. The caller assumes responsibility for calling CFRelease to dispose of the CFArrayRef structure.
kQTSCAudioPropertyID_HasLegacyCodecOptionsDialog = 'opn?'

Some compression formats have format-specific properties that are accessible only via a compressor-provided dialog. This constant specifies a read/listen Boolean value that lets you know if the current compression format has such a dialog.
kQTSCAudioPropertyID_ConstantBitRateFormatsOnly = '!vbr'

By default, constant as well as variable bit rate compression formats are shown in the available format list. This constant specifies a read/write/listen Boolean value that lets you restrict the available formats to constant bit rate formats by setting this property to TRUE.
kQTSCAudioPropertyID_AvailableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies a list of available output sample rates. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ClientRestrictedSampleRateList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_SampleRateRecommended = 'reco'

Clients not wishing to set an output sample rate manually may set the output rate to the recommended rate. Some compressors can perform rate conversion, and can pick optimal settings for a desired bitrate (AAC is one example). For other formats, the recommended rate is simply the closest output rate to the input rate that's allowed by the output format. kQTSCAudioPropertyID_SampleRateIsRecommended is read-only. To set the sample rate to recommended, a client sets the kQTSCAudioPropertyID_BasicDescription with mSampleRate = 0.0. To unset the sample rate as recommended, the client sets the kQTSCAudioPropertyID_BasicDescription with a non-zero mSampleRate field.
kQTSCAudioPropertyID_ApplicableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies which of the value ranges in the kQTSCAudioPropertyID_AvailableSampleRateList are currently applicable. The kQTSCAudioPropertyID_AvailableSampleRateList takes into account client restrictions, and a compression format's general sample rate restrictions. kQTSCAudioPropertyID_ApplicableSampleRateList further filters the list to just those sample rates that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedSampleRateList = 'crr#'

A read/write/listen C-style array of AudioValueRange values that specifies a client-restricted set of output sample rate ranges that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputMagicCookie = 'ikki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a ��magic cookie��), which some decompressors use to decode their input. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_MagicCookie = 'kuki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a ��magic cookie��), which some decompressors use to configure their output. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_ClientRestrictedLPCMBitsPerChannelList = 'crb#'

Specifies a client-restricted set of output bits per channel that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList = 'avb#'

A read/listen C-style array of UInt32 values that contains a list of available bits per audio channel. This list is specific to LPCM, and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_LPCMBitsPerChannelList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList = 'apb#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList are currently applicable. The kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList takes into account client restrictions, and LPCM��s general bits per channel restrictions. kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList further filters the list to just those bits per channel that are legal and valid given the current LPCM configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_LPCMBitsPerChannelList = 'sbc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of output bits per channel, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableNumChannelsList = 'anc#'

A read/listen C-style array of UInt32 values that contains a list of available numbers of channels. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_NumChannelsList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_NumChannelsList = 'snc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of numbers of channels that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputChannelLayout = 'icly'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the input description. AudioChannelLayout is a variable-size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for it.
kQTSCAudioPropertyID_InputChannelLayoutName = 'icln'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_InputChannelLayout structure, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ChannelLayout = 'clay'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the output description. AudioChannelLayout is a variable size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate.
kQTSCAudioPropertyID_ChannelLayoutName = 'clyn'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_ChannelLayout, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ClientRestrictedChannelLayoutTagList = 'crl#'

Specifies a client-restricted set of channel layout tags that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagList = 'acl#'

A read/listen C-style array of AudioChannelLayoutTag values that specifies a list of available audio channel layout tags. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ChannelLayoutTagList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ChannelLayoutTagList = 'cly#'

A read/write C-style array of AudioChannelLayoutTag values that specifies a client-restricted set of channel layout tags, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagNamesList = 'cln#'

A read-only CFArrayRef array that specifies the human-readable names for the AudioChannelLayoutTag values in a kQTSCAudioPropertyID_AvailableChannelLayoutTagList. Each element in the array is a CFStringRef structure. The caller is responsible for calling CFRelease to dispose of this array.
kQTSCAudioPropertyID_ApplicableChannelLayoutTagNamesList = 'apl#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableChannelLayoutTagList are currently applicable. The kQTSCAudioPropertyID_AvailableChannelLayoutTagList takes into account client restrictions, and the current output format��s general channel layout restrictions. kQTSCAudioPropertyID_ApplicableChannelLayoutTagList further filters the list to just those channel layouts that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedPCMFlags = 'crip'

Specifies a client-restricted set of flags corresponding to the mFormatFlags fields in an AudioStreamBasicDescription. Data type is a SCAudioFormatFlagsRestrictions struct. For instance, if a client wishes to specify to the StandardAudioCompression component that their file format requires little endian pcm data, the client may set this property, with formatFlagsMask set to kAudioFormatFlagIsBigEndian, and formatFlagsValues set to zero (indicating that the IsBigEndian bit should be interpreted as LittleEndian only).
kQTSCAudioPropertyID_DiscreteChannelsOK = 'dscr'

A read/write/listen Boolean value that lets you tell the StandardCompressionSubTypeAudio dialog to not show ��Discrete�� as an available option. Each AudioChannelLayout structure assigns specific spatial orientation to specific channels (for example, Channel 1 = Left). ��Discrete�� is a special channel layout that does not assign spatial characteristics to channels, but instead labels them as distinct outputs. For example, the first channel in the audio source is played through the first channel on the output device, the second channel in the source is played through the second channel, and so on. If this property is set to FALSE, the StandardCompressionSubTypeAudio dialog will not show ��Discrete�� as an available option.
kQTSCAudioPropertyID_LPCMSpecificFlagsMask = 'sffm'

A read/write/listen UInt32 value that specifies which flag fields in kQTSCAudioPropertyID_FormatSpecificFlags should be made available in the StandardCompressionSubTypeAudio dialog. For instance, a value of 0xFFFFFFFD (all bits except kAudioFormatFlagIsBigEndian set) tells the StandardCompressionSubTypeAudio component to disable any UI that would allow a choice between little and big endian. This selector is valid only for PCM formats and is ignored for others.
kQTSCAudioPropertyID_InputSoundDescription = 'isdh'

A read/write SoundDescriptionHandle value that specifies the current input description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_SoundDescription = 'osdh'

A read/write SoundDescriptionHandle value that specifies the current output description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_InputBasicDescription = 'isbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current input description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_BasicDescription = 'osbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current output description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_CodecSpecificSettingsArray = 'cdst'

A read/write CFArrayRef structure that designates a CFArray of CFDictionary structures, which describe various parameters specific to configuring a codec. This array of dictionaries, which is published by some compressors, can be parsed to generate UI information. When any value in the array changes, a client should call QTSetComponentProperty, passing the entire array.
kQTSCAudioPropertyID_SettingsState = scSettingsStateType

A read/write Handle value that is used to save the current state of the StandardCompressionSubTypeAudio component, so that its state may be restored at a later time with a single call. A StandardCompressionSubTypeAudio component can accept a saved settings state from a legacy StandardCompressionSubTypeSound component as write-only.
kQTSCAudioPropertyID_ExtendedProcs = scExtendedProcsType

A read/write/listen SCExtendedProcs value that is used to get or set an SCExtendedProcs structure.
kQTSCAudioPropertyID_PreferenceFlags = scPreferenceFlagsType

A read/write/listen SInt32 value that is used to specify dialog preferences such as scUseMovableModal.
kQTSCAudioPropertyID_WindowOptions = scWindowOptionsType

A read/write/listen SCWindowSettings structure that is used to set an SCWindowSettings structure, which tells the dialog about its parent window so that it can draw itself as a sheet on top of the parent.*/
/*Audio Property Selectors

The following values are used as ComponentPropertyID selectors. Use these with the StandardCompressionSubTypeAudio ('scdi'/'audi') component. All property IDs are to be used in conjunction with the kQTPropertyClass_SCAudio property class. 
kQTSCAudioPropertyID_AvailableCompressionFormatList = 'acf#'

A read/listen C-style array of OSType values that specifies the list of available output compression formats. This list includes all the kAudioEncoderComponentType components and kSoundCompressor type components on the user��s system. You can restrict the list by using the kQTSCAudioPropertyID_CompressionFormatList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for this array.
kQTSCAudioPropertyID_ClientRestrictedCompressionFormatList = 'crf#'

A read/write/listen C-style array of OSType values that specifies a client-restricted set of output compression formats that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableCompressionFormatNamesList = 'cnm#'

A read/write CFArrayRef structure of CFStringRef structures that reference the human-readable names of each item in a kQTSCAudioPropertyID_AvailableCompressionFormatList. The caller assumes responsibility for calling CFRelease to dispose of the CFArrayRef structure.
kQTSCAudioPropertyID_HasLegacyCodecOptionsDialog = 'opn?'

Some compression formats have format-specific properties that are accessible only via a compressor-provided dialog. This constant specifies a read/listen Boolean value that lets you know if the current compression format has such a dialog.
kQTSCAudioPropertyID_ConstantBitRateFormatsOnly = '!vbr'

By default, constant as well as variable bit rate compression formats are shown in the available format list. This constant specifies a read/write/listen Boolean value that lets you restrict the available formats to constant bit rate formats by setting this property to TRUE.
kQTSCAudioPropertyID_AvailableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies a list of available output sample rates. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ClientRestrictedSampleRateList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_SampleRateRecommended = 'reco'

Clients not wishing to set an output sample rate manually may set the output rate to the recommended rate. Some compressors can perform rate conversion, and can pick optimal settings for a desired bitrate (AAC is one example). For other formats, the recommended rate is simply the closest output rate to the input rate that's allowed by the output format. kQTSCAudioPropertyID_SampleRateIsRecommended is read-only. To set the sample rate to recommended, a client sets the kQTSCAudioPropertyID_BasicDescription with mSampleRate = 0.0. To unset the sample rate as recommended, the client sets the kQTSCAudioPropertyID_BasicDescription with a non-zero mSampleRate field.
kQTSCAudioPropertyID_ApplicableSampleRateList = 'avr#'

A read/listen C-style array of AudioValueRange values that specifies which of the value ranges in the kQTSCAudioPropertyID_AvailableSampleRateList are currently applicable. The kQTSCAudioPropertyID_AvailableSampleRateList takes into account client restrictions, and a compression format's general sample rate restrictions. kQTSCAudioPropertyID_ApplicableSampleRateList further filters the list to just those sample rates that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedSampleRateList = 'crr#'

A read/write/listen C-style array of AudioValueRange values that specifies a client-restricted set of output sample rate ranges that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputMagicCookie = 'ikki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a ��magic cookie��), which some decompressors use to decode their input. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_MagicCookie = 'kuki'

A read/write/listen opaque data structure that contains an untyped codec-specific data structure (a ��magic cookie��), which some decompressors use to configure their output. Cookies are variable size, so you must call QTGetComponentPropertyInfo to discover the size of the buffer you should allocate to hold the cookie.
kQTSCAudioPropertyID_ClientRestrictedLPCMBitsPerChannelList = 'crb#'

Specifies a client-restricted set of output bits per channel that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList = 'avb#'

A read/listen C-style array of UInt32 values that contains a list of available bits per audio channel. This list is specific to LPCM, and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_LPCMBitsPerChannelList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList = 'apb#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList are currently applicable. The kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList takes into account client restrictions, and LPCM��s general bits per channel restrictions. kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList further filters the list to just those bits per channel that are legal and valid given the current LPCM configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_LPCMBitsPerChannelList = 'sbc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of output bits per channel, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableNumChannelsList = 'anc#'

A read/listen C-style array of UInt32 values that contains a list of available numbers of channels. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_NumChannelsList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_NumChannelsList = 'snc#'

A read/write/listen C-style array of UInt32 values that contains a client-restricted set of numbers of channels that you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_InputChannelLayout = 'icly'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the input description. AudioChannelLayout is a variable-size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate for it.
kQTSCAudioPropertyID_InputChannelLayoutName = 'icln'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_InputChannelLayout structure, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ChannelLayout = 'clay'

A read/write/listen variable-size AudioChannelLayout structure that specifies the audio channel layout of the output description. AudioChannelLayout is a variable size structure, so you must use QTGetComponentPropertyInfo to discover the number of bytes you should allocate.
kQTSCAudioPropertyID_ChannelLayoutName = 'clyn'

A read-only CFStringRef structure that specifies the human-readable name for a kQTSCAudioPropertyID_ChannelLayout, if one exists. The caller is responsible for calling CFRelease to dispose of the resulting string.
kQTSCAudioPropertyID_ClientRestrictedChannelLayoutTagList = 'crl#'

Specifies a client-restricted set of channel layout tags that should be listed as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagList = 'acl#'

A read/listen C-style array of AudioChannelLayoutTag values that specifies a list of available audio channel layout tags. This list is specific to the compression format and takes into account any restrictions imposed by a client using the kQTSCAudioPropertyID_ChannelLayoutTagList property. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_ChannelLayoutTagList = 'cly#'

A read/write C-style array of AudioChannelLayoutTag values that specifies a client-restricted set of channel layout tags, which you should list as available. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold this array.
kQTSCAudioPropertyID_AvailableChannelLayoutTagNamesList = 'cln#'

A read-only CFArrayRef array that specifies the human-readable names for the AudioChannelLayoutTag values in a kQTSCAudioPropertyID_AvailableChannelLayoutTagList. Each element in the array is a CFStringRef structure. The caller is responsible for calling CFRelease to dispose of this array.
kQTSCAudioPropertyID_ApplicableChannelLayoutTagNamesList = 'apl#'

Specifies which of the values in the kQTSCAudioPropertyID_AvailableChannelLayoutTagList are currently applicable. The kQTSCAudioPropertyID_AvailableChannelLayoutTagList takes into account client restrictions, and the current output format��s general channel layout restrictions. kQTSCAudioPropertyID_ApplicableChannelLayoutTagList further filters the list to just those channel layouts that are legal and valid given the current codec configuration. Use QTGetComponentPropertyInfo to discover the number of bytes you should allocate to hold the array.
kQTSCAudioPropertyID_ClientRestrictedPCMFlags = 'crip'

Specifies a client-restricted set of flags corresponding to the mFormatFlags fields in an AudioStreamBasicDescription. Data type is a SCAudioFormatFlagsRestrictions struct. For instance, if a client wishes to specify to the StandardAudioCompression component that their file format requires little endian pcm data, the client may set this property, with formatFlagsMask set to kAudioFormatFlagIsBigEndian, and formatFlagsValues set to zero (indicating that the IsBigEndian bit should be interpreted as LittleEndian only).
kQTSCAudioPropertyID_DiscreteChannelsOK = 'dscr'

A read/write/listen Boolean value that lets you tell the StandardCompressionSubTypeAudio dialog to not show ��Discrete�� as an available option. Each AudioChannelLayout structure assigns specific spatial orientation to specific channels (for example, Channel 1 = Left). ��Discrete�� is a special channel layout that does not assign spatial characteristics to channels, but instead labels them as distinct outputs. For example, the first channel in the audio source is played through the first channel on the output device, the second channel in the source is played through the second channel, and so on. If this property is set to FALSE, the StandardCompressionSubTypeAudio dialog will not show ��Discrete�� as an available option.
kQTSCAudioPropertyID_LPCMSpecificFlagsMask = 'sffm'

A read/write/listen UInt32 value that specifies which flag fields in kQTSCAudioPropertyID_FormatSpecificFlags should be made available in the StandardCompressionSubTypeAudio dialog. For instance, a value of 0xFFFFFFFD (all bits except kAudioFormatFlagIsBigEndian set) tells the StandardCompressionSubTypeAudio component to disable any UI that would allow a choice between little and big endian. This selector is valid only for PCM formats and is ignored for others.
kQTSCAudioPropertyID_InputSoundDescription = 'isdh'

A read/write SoundDescriptionHandle value that specifies the current input description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_SoundDescription = 'osdh'

A read/write SoundDescriptionHandle value that specifies the current output description as a SoundDescriptionHandle (lowest possible version for the current format). When calling QTGetComponentProperty, the caller passes a pointer to an unallocated Handle and assumes responsibility for calling DisposeHandle when done.
kQTSCAudioPropertyID_InputBasicDescription = 'isbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current input description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_BasicDescription = 'osbd'

A read/write/DataProc/listen AudioStreamBasicDescription value that specifies that the current output description is an AudioStreamBasicDescription value.
kQTSCAudioPropertyID_CodecSpecificSettingsArray = 'cdst'

A read/write CFArrayRef structure that designates a CFArray of CFDictionary structures, which describe various parameters specific to configuring a codec. This array of dictionaries, which is published by some compressors, can be parsed to generate UI information. When any value in the array changes, a client should call QTSetComponentProperty, passing the entire array.
kQTSCAudioPropertyID_SettingsState = scSettingsStateType

A read/write Handle value that is used to save the current state of the StandardCompressionSubTypeAudio component, so that its state may be restored at a later time with a single call. A StandardCompressionSubTypeAudio component can accept a saved settings state from a legacy StandardCompressionSubTypeSound component as write-only.
kQTSCAudioPropertyID_ExtendedProcs = scExtendedProcsType

A read/write/listen SCExtendedProcs value that is used to get or set an SCExtendedProcs structure.
kQTSCAudioPropertyID_PreferenceFlags = scPreferenceFlagsType

A read/write/listen SInt32 value that is used to specify dialog preferences such as scUseMovableModal.
kQTSCAudioPropertyID_WindowOptions = scWindowOptionsType

A read/write/listen SCWindowSettings structure that is used to set an SCWindowSettings structure, which tells the dialog about its parent window so that it can draw itself as a sheet on top of the parent.*/
enum {
kQTSCAudioPropertyID_AvailableCompressionFormatList = 'acf#',
kQTSCAudioPropertyID_ClientRestrictedCompressionFormatList = 'crf#',
kQTSCAudioPropertyID_AvailableCompressionFormatNamesList = 'cnm#',
kQTSCAudioPropertyID_HasLegacyCodecOptionsDialog = 'opn?',
kQTSCAudioPropertyID_ConstantBitRateFormatsOnly = '!vbr',
kQTSCAudioPropertyID_AvailableSampleRateList = 'avr#',
kQTSCAudioPropertyID_SampleRateRecommended = 'reco',
kQTSCAudioPropertyID_ApplicableSampleRateList = 'avr#',
kQTSCAudioPropertyID_ClientRestrictedSampleRateList = 'crr#',
kQTSCAudioPropertyID_InputMagicCookie = 'ikki',
kQTSCAudioPropertyID_MagicCookie = 'kuki',
kQTSCAudioPropertyID_ClientRestrictedLPCMBitsPerChannelList = 'crb#',
kQTSCAudioPropertyID_AvailableLPCMBitsPerChannelList = 'avb#',
kQTSCAudioPropertyID_ApplicableLPCMBitsPerChannelList = 'apb#',
kQTSCAudioPropertyID_LPCMBitsPerChannelList = 'sbc#',
kQTSCAudioPropertyID_AvailableNumChannelsList = 'anc#',
kQTSCAudioPropertyID_NumChannelsList = 'snc#',
kQTSCAudioPropertyID_InputChannelLayout = 'icly',
kQTSCAudioPropertyID_InputChannelLayoutName = 'icln',
kQTSCAudioPropertyID_ChannelLayout = 'clay',
kQTSCAudioPropertyID_ChannelLayoutName = 'clyn',
kQTSCAudioPropertyID_ClientRestrictedChannelLayoutTagList = 'crl#',
kQTSCAudioPropertyID_AvailableChannelLayoutTagList = 'acl#',
kQTSCAudioPropertyID_ChannelLayoutTagList = 'cly#',
kQTSCAudioPropertyID_AvailableChannelLayoutTagNamesList = 'cln#',
kQTSCAudioPropertyID_ApplicableChannelLayoutTagNamesList = 'apl#',
kQTSCAudioPropertyID_ClientRestrictedPCMFlags = 'crip',
kQTSCAudioPropertyID_DiscreteChannelsOK = 'dscr',
kQTSCAudioPropertyID_LPCMSpecificFlagsMask = 'sffm',
kQTSCAudioPropertyID_InputSoundDescription = 'isdh',
kQTSCAudioPropertyID_SoundDescription = 'osdh',
kQTSCAudioPropertyID_InputBasicDescription = 'isbd',
kQTSCAudioPropertyID_BasicDescription = 'osbd',
kQTSCAudioPropertyID_CodecSpecificSettingsArray = 'cdst',
kQTSCAudioPropertyID_SettingsState = scSettingsStateType,
kQTSCAudioPropertyID_ExtendedProcs = scExtendedProcsType,
kQTSCAudioPropertyID_PreferenceFlags = scPreferenceFlagsType,
kQTSCAudioPropertyID_WindowOptions = scWindowOptionsType
};
/*Device Attribute Keys for Inputs and Outputs

The following dictionary keys may be used to parse CF dictionaries returned by kQTSGAudioPropertyID_DeviceListWithAttributes and kQTSGAudioPropertyID_DeviceAttributes IDs for SGAudioMediaType channels.
kQTAudioDeviceAttribute_DeviceInputID = 'inID'

A CFNumberRef that wraps an OSType value.
kQTAudioDeviceAttribute_DeviceInputDescription = 'inds'

A CFStringRef that is suitable for displaying to the user.
kQTAudioDeviceAttribute_DeviceOutputID = 'otID'

A CFNumberRef that wraps an OSType value.
kQTAudioDeviceAttribute_DeviceOutputDescription = 'otds'

A CFStringRef that is suitable for displaying to the user.*/
enum {
kQTAudioDeviceAttribute_DeviceInputID = 'inID',
kQTAudioDeviceAttribute_DeviceInputDescription = 'inds',
kQTAudioDeviceAttribute_DeviceOutputID = 'otID',
kQTAudioDeviceAttribute_DeviceOutputDescription = 'otds'
};
/*SGModalFilterProc

Undocumented

typedef Boolean (*SGModalFilterProcPtr) (DialogPtr theDialog, const EventRecord *theEvent, short *itemHit, long refCon);

If you name your function MySGModalFilterProc, you would declare it this way:

Boolean MySGModalFilterProc (
   DialogPtr            theDialog,
   const EventRecord    *theEvent,
   short                *itemHit,
   long                 refCon );
Parameters
theDialog

A pointer to a dialog box.
theEvent

Undocumented
itemHit

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

Return TRUE if the event was handled, FALSE otherwise.
Declared In
QuickTimeComponents.h*/
typedef Boolean (*SGModalFilterProcPtr) (DialogPtr theDialog, const EventRecord *theEvent, short *itemHit, long refCon);

/*SGModalFilterUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGModalFilterProcPtr) SGModalFilterUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGModalFilterProcPtr) SGModalFilterUPP;

/*ConstComponentListPtr

Represents a type used by the Sequence Grabber API.

typedef const Component * ConstComponentListPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef const Component * ConstComponentListPtr;

/*SGGetPause Values

Constants passed to SGGetPause.

enum {
   seqGrabUnpause                = 0,
   seqGrabPause                  = 1,
   seqGrabPauseForMenu           = 3
};
Declared In
QuickTimeComponents.h*/

enum {
   seqGrabUnpause                = 0,
   seqGrabPause                  = 1,
   seqGrabPauseForMenu           = 3
};


/*Types

The SGDeviceInputName structure is defined as follows:

This section describes each new structure that is available in QuickTime 6. 
struct SGDeviceInputName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            reserved; // zero
};
typedef struct SGDeviceInputName SGDeviceInputName;
enum {
   sgDeviceInputNameFlagInputUnavailable = (1 << 0)
};
struct SGDeviceInputListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceInputName               entry[1];
};
typedef struct SGDeviceInputListRecord  SGDeviceInputListRecord;
typedef SGDeviceInputListRecord *       SGDeviceInputListPtr;
typedef SGDeviceInputListPtr *          SGDeviceInputList;*/
struct SGDeviceInputName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            reserved; // zero
};
typedef struct SGDeviceInputName SGDeviceInputName;
enum {
   sgDeviceInputNameFlagInputUnavailable = (1 << 0)
};
struct SGDeviceInputListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceInputName               entry[1];
};
typedef struct SGDeviceInputListRecord  SGDeviceInputListRecord;
typedef SGDeviceInputListRecord *       SGDeviceInputListPtr;
typedef SGDeviceInputListPtr *          SGDeviceInputList;

/*The SGDeviceName structure is re-defined as follows:
struct SGDeviceName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            refCon;
   SGDeviceInputList               inputs; // list of inputs; formerly reserved to 0
};
typedef struct SGDeviceName SGDeviceName;
enum {
   sgDeviceNameFlagDeviceUnavailable = (1 << 0),
   sgDeviceNameFlagShowInputsAsDevices = (1 << 1)
};*/
struct SGDeviceName {
   Str63                           name;
   Handle                          icon;
   long                            flags;
   long                            refCon;
   SGDeviceInputList               inputs; // list of inputs; formerly reserved to 0
};
typedef struct SGDeviceName SGDeviceName;
enum {
   sgDeviceNameFlagDeviceUnavailable = (1 << 0),
   sgDeviceNameFlagShowInputsAsDevices = (1 << 1)
};

/*The SGDeviceListRecord structure is defined as follows:
struct SGDeviceListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceName                    entry[1];
};
typedef struct SGDeviceListRecord       SGDeviceListRecord;
typedef SGDeviceListRecord *            SGDeviceListPtr;
typedef SGDeviceListPtr *               SGDeviceList;
enum {
   sgDeviceListWithIcons       = (1 << 0),
   sgDeviceListDontCheckAvailability = (1 << 1),
   sgDeviceListIncludeInputs   = (1 << 2)
};


The new flag sgDeviceListIncludeInputs is passed to SGGetChannelDeviceList if the caller desires to get the list of inputs as well as the devices. If this flag is not passed, the old behavior of just listing devices is retained.*/
struct SGDeviceListRecord {
   short                           count;
   short                           selectedIndex;
   long                            reserved; //zero
   SGDeviceName                    entry[1];
};
typedef struct SGDeviceListRecord       SGDeviceListRecord;
typedef SGDeviceListRecord *            SGDeviceListPtr;
typedef SGDeviceListPtr *               SGDeviceList;
enum {
   sgDeviceListWithIcons       = (1 << 0),
   sgDeviceListDontCheckAvailability = (1 << 1),
   sgDeviceListIncludeInputs   = (1 << 2)
};

/*SGDeviceListPtr

Represents a type used by the Sequence Grabber API.

typedef SGDeviceListRecord * SGDeviceListPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef SGDeviceListRecord * SGDeviceListPtr;

/*SGDeviceList

Represents a type used by the Sequence Grabber API.

typedef SGDeviceListPtr * SGDeviceList;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef SGDeviceListPtr * SGDeviceList;

/*SGChannel

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SGChannel;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SGChannel;

/*SGDataProc

Undocumented

typedef OSErr (*SGDataProcPtr) (SGChannel c, Ptr p, long len, long *offset, long chRefCon, TimeValue time, short writeType, long refCon);

If you name your function MySGDataProc, you would declare it this way:

OSErr MySGDataProc (
   SGChannel    c,
   Ptr          p,
   long         len,
   long         *offset,
   long         chRefCon,
   TimeValue    time,
   short        writeType,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
p

Undocumented
len

Undocumented
offset

Undocumented
chRefCon

Undocumented
time

Undocumented
writeType

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef OSErr (*SGDataProcPtr) (SGChannel c, Ptr p, long len, long *offset, long chRefCon, TimeValue time, short writeType, long refCon);


/*SGDataUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGDataProcPtr) SGDataUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGDataProcPtr) SGDataUPP;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*SGAudioCallbackStruct

Used to call an SGAudioCallbackProc.

struct SGAudioCallbackStruct {
   SGAudioCallback    inputProc;
   void               *inputProcRefCon;
};
Fields
inputProc

An SGAudioCallbackProc.
inputProcRefCon

A reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Version Notes

Introduced in QuickTime 7.
Availability
Carbon status: Supported; C interface file: Movies.h*/
struct SGAudioCallbackStruct {
   SGAudioCallback    inputProc;
   void               *inputProcRefCon;
};
typedef  struct SGAudioCallbackStruct SGAudioCallbackStruct;


/*Dictionary Keys

The dictionary keys listed in this section are used with c ertain of the property IDs listed in ��SGAudio Component Property IDs��. They may be used to parse CF dictionaries returned by kQTSGAudioPropertyID_DeviceListWithAttributes and kQTSGAudioPropertyID_DeviceAttributes IDs for SGAudioMediaType channels.
kQTAudioDeviceAttribute_DeviceUIDKey = 'uid '

A CFStringRef containing a unique identifier for a device.
kQTAudioDeviceAttribute_DeviceNameKey = 'name'

A CFStringRef containing a device��s printable name, suitable for the user interface.
kQTAudioDeviceAttribute_DeviceManufacturerKey = 'manu'

A CFStringRef containing a device manufacturer��s printable name, suitable for the user interface.
kQTAudioDeviceAttribute_DeviceTransportTypeKey = 'tran'

A CFNumberRef that wraps an OSType; for example, '1394' for fw. See the file IOAudioTypes.h.
kQTAudioDeviceAttribute_DeviceAliveKey = 'aliv'

A CFBooleanRef value that is TRUE if the device is present.
kQTAudioDeviceAttribute_DeviceCanRecordKey = 'rec ' [last char = space]

A CFBooleanRef value that is TRUE if the device can be used for recording (some devices can only play back).
kQTAudioDeviceAttribute_DeviceCanPreviewKey = 'prev'

A CFBooleanRef value that is TRUE if the device can be used to preview a grabbed sequence.
kQTAudioDeviceAttribute_DeviceHoggedKey = 'hogg'

A CFNumberRef that wraps the unique process ID that is hogging the device, or ��1 if the device is currently not being hogged. The process ID comes from a call to getpid.
kQTAudioDeviceAttribute_DeviceInUseKey = 'used'

A CFBooleanRef value that is TRUE if the device is performing I/O in any process.
kQTAudioDeviceAttribute_DeviceSupportsHardwarePlaythruKey = 'hard'

A CFBooleanRef value that is TRUE if the device supports hardware playthrough of inputs to outputs.
kQTAudioDeviceAttribute_DefaultInputDeviceKey = 'dIn ' [last char = space]

A CFBooleanRef value that��s TRUE if the device is the user-selected default input in an audio MIDI setup.
kQTAudioDeviceAttribute_DefaultOutputDeviceKey = 'dOut'

A CFBooleanRef value that��s TRUE if the device is the user-selected default output in an audio MIDI setup.
kQTAudioDeviceAttribute_DefaultSystemOutputDeviceKey = 'sOut'

A CFBooleanRef value that��s TRUE if the device is the user-selected device where system alerts play.
kQTAudioDeviceAttribute_IsCoreAudioDeviceKey = 'hal!'

A CFBooleanRef value that��s TRUE if the device is a Core Audio device.*/
enum {
kQTAudioDeviceAttribute_DeviceUIDKey = 'uid ' ,
kQTAudioDeviceAttribute_DeviceNameKey = 'name' ,
kQTAudioDeviceAttribute_DeviceManufacturerKey = 'manu' ,
kQTAudioDeviceAttribute_DeviceTransportTypeKey = 'tran',
kQTAudioDeviceAttribute_DeviceAliveKey = 'aliv',
kQTAudioDeviceAttribute_DeviceCanRecordKey = 'rec ' ,
kQTAudioDeviceAttribute_DeviceCanPreviewKey = 'prev',
kQTAudioDeviceAttribute_DeviceHoggedKey = 'hogg',
kQTAudioDeviceAttribute_DeviceInUseKey = 'used',
kQTAudioDeviceAttribute_DeviceSupportsHardwarePlaythruKey = 'hard',
kQTAudioDeviceAttribute_DefaultInputDeviceKey = 'dIn ' ,
kQTAudioDeviceAttribute_DefaultOutputDeviceKey = 'dOut',
kQTAudioDeviceAttribute_DefaultSystemOutputDeviceKey = 'sOut',
kQTAudioDeviceAttribute_IsCoreAudioDeviceKey = 'hal!'
};

/*SGAudio Component Property IDs

This section lists the property IDs for SGAudioMediaType channels. Besides the IDs defined below, SGAudioMediaType channels respond to kComponentPropertyInfoList and kComponentPropertyClassPropertyInfo selectors, which return CFDataRef structures containing arrays of ComponentPropertyInfo structures as defined in the file ImageCompression.h.
kQTSGAudioPropertyID_DeviceListWithAttributes = '#dva'

Used with kQTPropertyClass_SGAudio in read and listen modes to get an array of CFDictionaryRef structures. Each dictionary represents the attributes of one audio device. See Dictionary Keys for a list of supported dictionary keys. If the device list changes (for example, if a device is hotplugged or unplugged), listeners of this property will be notified. The caller is responsible for calling CFRelease to release the resulting CFArray.
kQTSGAudioPropertyID_DeviceAttributes = 'deva'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read only mode to get a CFDictionaryRef structure representing the attributes of a specified audio device (record or preview). See Dictionary Keys for a list of supported dictionary keys. Not all keys are guaranteed to be present for a given device. The caller is responsible for calling CFRelease to release the resulting CFDictionary.
kQTSGAudioPropertyID_DeviceUID = 'uid ' [last character is space]

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get a CFString with an audio device��s unique ID for the current recording or preview or set the current recording or preview device to a specified audio device��s unique ID. You can obtain a list of devices on the user��s system with kQTSGAudioPropertyID_DeviceListWithAttributes. The caller is responsible for calling CFRelease to release the resulting CFString.
kQTSGAudioPropertyID_ChannelLayout = 'clay'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get or set an AudioChannelLayout structure representing the spatial or discrete channel layout. If used with kQTPropertyClass_SGAudio, the AudioChannelLayout refers to the channels in the resulting QuickTime movie sound track. If used with kQTPropertyClass_SGAudioRecordDevice, the AudioChannelLayout refers to the input channels on the record device. If used with kQTPropertyClass_SGAudioPreviewDevice, the AudioChannelLayout refers to the preview device��s output channels. AudioChannelLayout is a variable size structure, so before calling QTGetComponentProperty you should call QTGetComponentPropertyInfo to discover the size of the block of memory you must allocate to hold the result.
kQTSGAudioPropertyID_MagicCookie = 'kuki'

Used with kQTPropertyClass_SGAudio in read and write modes to access opaque data structures representing get or set compressor-specific out-of-band settings. This property is applicable only to compressed formats that use a cookie, such as AAC and AMR.
kQTSGAudioPropertyID_ChannelMap = 'cmap'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to access a C-style array of SInt32 structures that let a client enable or disable channels on a recording device, as well as reorder them or duplicate them to several output channels. This property need not be set if a client wishes to capture all channels from the record device; this is the default behavior. Each element in the SInt32 array represents one output bus (into the SGAudioChannel) from the record device. The value of each element is the zero-based source channel on the input device that should feed the specified output. Channel-disabling example: if you wish to capture just the 1st, 3rd, and 5th channels from a 6-channel input device, your channel map should be SInt32 map[3] = { 0, 2, 4 }. Channel-reordering example: if you wish to capture both channels from a stereo input device, but you know the left and right channels are reversed in the data source, set your channel map to SInt32 map[2] = { 1, 0 }. Channel-duplication example: if you wish to duplicate the second source channel into 4 outputs, set your channel map to SInt32 map[4] = { 1, 1, 1, 1 }. Empty channel example: if you need to produce a conformant stream of audio (such as a 6-channel stream to send to an external 5.1 AC3 encoder), but you have audio only for the L, R, and C channels (on record device channels 0, 1, and 2), you may set your channel map to SInt32 map[6] = { 0, 1, 2, -1, -1, -1 }. The last 3 channels will be filled with silence.
kQTSGAudioPropertyID_StreamFormat = 'frmt'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access AudioStreamBasicDescription structures that let you get or set the format of the audio as it will be written to the destination QuickTime movie track. When used with kQTPropertyClass_SGAudioRecordDevice, this property ID gets and sets the format of audio as it is physically recorded on the device. The format must be one of the formats passed in kQTSGAudioPropertyID_StreamFormatList. The mChannelsPerFrame of the StreamFormat read from the record device will not reflect channels that have been enabled or disabled with the ChannelMap property.
kQTSGAudioPropertyID_StreamFormatList = '#frm'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get an array of AudioStreamBasicDescription structures that describe valid combinations of settings supported by the physical device in its current configuration (sample rate, bit depth, number of channels).
kQTSGAudioPropertyID_InputSelection = 'inpt'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to get an OSType value that lets you change the current input selection in devices that allow switching between data sources, such as analog, adat, sdi, aes/ebu, and spdif. When the input selection changes, the StreamFormat of the device may change as well; in particular, the number of channels may change.
kQTSGAudioPropertyID_InputListWithAttributes = '#inp'

Used with kQTPropertyClass_SGAudioRecordDevice in read-only mode to get a CFArrayRef structure that represents the list of available input sources for a given device. A CFArrayRef of CFDictionaryRef values is returned, where each one represents the attributes of one input. See ��Dictionary Keys�� for a list of valid keys. The caller is responsible for calling CFRelease to release the returned array.
kQTSGAudioPropertyID_OutputSelection = 'otpt'

Used with kQTPropertyClass_SGAudioPreviewDevice in read and write modes to get an OSType value that lets you change the current output selection in devices that allow switching between output destinations, such as analog, adat, sdi, aes/ebu, and spdif. When the output selection changes, the StreamFormat of the device may change as well; in particular, the number of channels may change.
kQTSGAudioPropertyID_OutputListWithAttributes = '#otp'

Used with kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a CFArrayRef structure that represents the list of available output destinations for a given device. A CFArrayRef of CFDictionaryRef values is returned, where each one represents the attributes of one output. See ��Dictionary Keys�� for a list of valid keys. The caller is responsible for calling CFRelease to release the returned array.
kQTSGAudioPropertyID_SoundDescription = 'snds'

Used with kQTPropertyClass_SGAudio in read and write modes to get a SoundDescriptionHandle value for the sound description that describes the data written to a QuickTime movie track. A QTGetComponentProperty call allocates the SoundDescriptionHandle for you. The caller should declare the SoundDescriptionHandle and set it to NULL, then pass its address to QTGetComponentProperty. The caller must call DisposeHandle to dispose of the resulting SoundDescriptionHandle when done with it.
kQTSGAudioPropertyID_LevelMetersEnabled = 'lmet'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a Boolean value that controls metering. When used with kQTPropertyClass_SGAudioRecordDevice or kQTPropertyClass_SGAudioPreviewDevice, this property ID turns device level metering on or off. When used with kQTPropertyClass_SGAudio, it turns output level metering on or off. When level meters are enabled, you can use kQTSGAudioPropertyID_AveragePowerLevels to get instantaneous levels, or kQTSGAudioPropertyID_PeakHoldLevels to get peak-hold style meters, which are better for clipping detection. Level meters should be enabled only if you intend to poll for levels, because they place an added load on the CPU when enabled.
kQTSGAudioPropertyID_PeakHoldLevels = 'phlv'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a C-style array of Float32 values representing in dB the peak hold levels for each channel on a device or output. This property ID may be used only when level meters are enabled (by using kQTSGAudioPropertyID_LevelMetersEnabled). Poll for peak hold levels as often as you would like, to update the user interface or look for clipping. The number of elements in the Float32 array will be equal to the number of input channels on your record device for kQTPropertyClass_SGAudioRecordDevice, or the number of elements in your kQTSGAudioPropertyID_ChannelMap, if you've set one. It will be equal to the number of output channels on your preview device for kQTPropertyClass_SGAudioPreviewDevice and equal to the number of channels in your kQTSGAudioPropertyID_StreamFormat (format.mChannelsPerFrame) for kQTPropertyClass_SGAudio. If no channel mixdown is being performed between record device and output formats, then the kQTSGAudioPropertyID_PeakHoldLevels values for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudio will be equivalent. If you have requested hardware playthrough, level metering will be unavailable.
kQTSGAudioPropertyID_AveragePowerLevels = 'aplv'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read-only mode to get a C-style array of Float32 values representing in dB the average power levels for each channel on a device or output. This property ID may be used only when level meters are enabled (by using kQTSGAudioPropertyID_LevelMetersEnabled). Poll for average power levels as often as you would like, to update the user interface. The number of elements in the Float32 array will be equal to the number of input channels on your record device for kQTPropertyClass_SGAudioRecordDevice, or the number of elements in your kQTSGAudioPropertyID_ChannelMap, if you've set one. It will be equal to the number of output channels on your preview device for kQTPropertyClass_SGAudioPreviewDevice and equal to the number of channels in your kQTSGAudioPropertyID_StreamFormat (format.mChannelsPerFrame) for kQTPropertyClass_SGAudio. If no channel mixdown is being performed between record device and output formats, then the kQTSGAudioPropertyID_AveragePowerLevels values for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudio will be equivalent. If you have requested hardware playthrough, level metering will be unavailable.
kQTSGAudioPropertyID_Settings = 'setu'

Used with kQTPropertyClass_SGAudio in read and write modes to access UserData values. This property takes supersedes the SGGet/SetChannelSettings calls. An SGAudioMediaType channel accepts old-style 'soun' SGChannel settings in a QTSetComponentProperty call, but always produces new-style settings in a QTGetComponentProperty call.
kQTSGAudioPropertyID_MasterGain = 'mgan'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a Float32 value that represents the master gain on a physical recording device with 0.0 = minimum volume and 1.0 = the maximum volume of the device. With kQTPropertyClass_SGAudioPreviewDevice, this property gets or sets the master gain on the physical previewing device with 0.0 = minimum volume and 1.0 = the maximum volume of the device. With kQTPropertyClass_SGAudio, this property gets or sets the master gain (volume) of the recorded audio data in software (pre-mixdown) with minimum = 0.0, maximum = unbounded. Normally you wouldn't set the volume greater than 1.0, but if the source sound level provided by the device is too low, you may set a gain greater than 1.0 to boost the gain. Some devices cannot respond to this property setting.
kQTSGAudioPropertyID_PerChannelGain = 'cgan'

Used with kQTPropertyClass_SGAudioRecordDevice, kQTPropertyClass_SGAudio, and kQTPropertyClass_SGAudioPreviewDevice in read and write modes to access a C-style array of Float32 value that represents the gain of each channel on a physical recording device. The number of channels in the array for kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice is equal to the total number of channels on the device, which can be discovered using kQTSGAudioPropertyID_StreamFormat. The number and order of channels in the array for the kQTPropertyClass_SGAudio class must correspond to the valence of channels on the output (which is affected by a channel map, if you've set one). With kQTPropertyClass_SGAudio, this property gets and sets the gain (volume) of each channel of recorded audio data in software. Levels set on the record device or preview device must be in the range minimum = 0.0, maximum = 1.0. Levels set in software may be set to values greater than 1.0 in order to boost low signals. The caller may specify that a particular channel gain level should be left alone by setting the value to ��1.0. For instance, to set the gain of channels 1, 2, and 3 to 0.5 on a 6 channel device, pass the following array values in a SetProperty call: { 0.5, 0.5, 0.5, -1., -1., -1. }.
kQTSGAudioPropertyID_HardwarePlaythruEnabled = 'hard'

Used with kQTPropertyClass_SGAudioRecordDevice in read and write modes to access a Boolean value representing the state of hardware playthrough during seqGrabPreview or seqGrabPlayDuringRecord operations. Setting this value will have no effect if the record device and preview device are not the same. Some devices do not support hardware playthrough; devices report whether or not they support this feature through the kQTSGAudioPropertyID_DeviceListWithAttributes property.
kQTSGAudioPropertyID_ChunkSize = 'chnk'

Used with kQTPropertyClass_SGAudio in read and write modes to access a Float32 value representing the number of seconds of audio that the SGAudioChannel should buffer before writing.
kComponentPropertyInfoList = 'list'

Used with kComponentPropertyClassPropertyInfo in read-only mode as defined in the file ImageCompression.h.
kQTSGAudioPropertyID_DeviceAlive = 'aliv'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and listen modes to get a Boolean value telling whether or not a device is alive. If the device is hot unplugged, listeners of this property will be notified. If a record or preview operation is in progress it will be stopped, but it is left to the client to select a new device.
kQTSGAudioPropertyID_DeviceHogged = 'hogg'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read, write, and listen modes to get a Boolean value telling whether a device has become hogged or unhogged by another process. If so, listeners of this property will be notified. SGAudioMediaType channel does not hog devices, but a client that has reason to gain exclusive access to a device may set this property to TRUE.
kQTSGAudioPropertyID_DeviceInUse = 'used'

Used with kQTPropertyClass_SGAudioRecordDevice and kQTPropertyClass_SGAudioPreviewDevice in read and listen modes to get a Boolean value that tells whether a device is in use. If the device starts to be used (for instance, when another process starts performing I/O with it), listeners of this property will be notified.
kQTSGAudioPropertyID_MixerCoefficients = 'mixc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a C-style array of Float32 values representing a set of coefficients for mixdown. If you wish to perform a custom mixdown from the incoming record device channel valence (discoverable using a combination of kQTPropertyClass_SGAudioRecordDevice, kQTSGAudioPropertyID_StreamFormat, kQTPropertyClass_SGAudioRecordDevice, and kQTSGAudioPropertyID_ChannelMap) to a different output number of channels (using kQTPropertyClass_SGAudio and kQTSGAudioPropertyID_StreamFormat), you may specify your own set of mixer coefficients which will be set as volume values at each crosspoint in SGAudioMediaType��s internal matrix mixer. The value you pass is a two-dimensional array of Float32 values where the first dimension (rows) is the input channel and the second dimension (columns) is the output channel. Each Float32 value contains one gain level to apply.
kQTSGAudioPropertyID_PreMixCallback = '_mxc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a pre-mix SGAudioCallbackStruct. If you wish to receive a callback when new audio samples become available from a recording device (before they've been mixed down), set this property using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PreMixCallbackFormat = '_mcf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your pre-mix SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PostMixCallback = 'mx_c'

Used with kQTPropertyClass_SGAudio in read and write modes to access a post-mix SGAudioCallbackStruct. If you wish to receive a callback after audio samples have been mixed (the first step after they are received from a recording device by SGAudioMediaType channel), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PostMixCallbackFormat = 'm_cf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your post-mix SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PreConversionCallback = '_cvc'

Used with kQTPropertyClass_SGAudio in read and write modes to access a pre-conversion SGAudioCallbackStruct. If you wish to receive a callback just before audio samples are about to be sent through an audio converter (for format conversion or compression), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PreConversionCallbackFormat = '_ccf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your pre-conversion SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.
kQTSGAudioPropertyID_PostConversionCallback = 'cv_c'

Used with kQTPropertyClass_SGAudio in read and write modes to access a post-conversion SGAudioCallbackStruct. If you wish to receive a callback right after audio samples have been sent through an audio converter (for format conversion or compression), set this property ID using an SGAudioCallbackStruct containing a pointer to your SGAudioCallback function and a reference constant (RefCon). If you have previously registered a callback and no longer wish to receive it, call QTSetComponentProperty again, this time passing NULL for your inputProc and 0 for your inputRefCon.
kQTSGAudioPropertyID_PostConversionCallbackFormat = 'c_cf'

Used with kQTPropertyClass_SGAudio in read-only mode to get an AudioStreamBasicDescription structure representing the format of the audio that will be received by your post-conversion SGAudioCallback function. Note that the format may not be available until you've called SGPrepare.*/
enum {
kQTSGAudioPropertyID_DeviceListWithAttributes = '#dva',
kQTSGAudioPropertyID_DeviceAttributes = 'deva',
kQTSGAudioPropertyID_DeviceUID = 'uid ' ,
kQTSGAudioPropertyID_ChannelLayout = 'clay',
kQTSGAudioPropertyID_MagicCookie = 'kuki',
kQTSGAudioPropertyID_ChannelMap = 'cmap',
kQTSGAudioPropertyID_StreamFormat = 'frmt',
kQTSGAudioPropertyID_StreamFormatList = '#frm',
kQTSGAudioPropertyID_InputSelection = 'inpt',
kQTSGAudioPropertyID_InputListWithAttributes = '#inp',
kQTSGAudioPropertyID_OutputSelection = 'otpt',
kQTSGAudioPropertyID_OutputListWithAttributes = '#otp',
kQTSGAudioPropertyID_SoundDescription = 'snds',
kQTSGAudioPropertyID_LevelMetersEnabled = 'lmet',
kQTSGAudioPropertyID_PeakHoldLevels = 'phlv',
kQTSGAudioPropertyID_AveragePowerLevels = 'aplv',
kQTSGAudioPropertyID_Settings = 'setu',
kQTSGAudioPropertyID_MasterGain = 'mgan',
kQTSGAudioPropertyID_PerChannelGain = 'cgan',
kQTSGAudioPropertyID_HardwarePlaythruEnabled = 'hard',
kQTSGAudioPropertyID_ChunkSize = 'chnk',
//kComponentPropertyInfoList = 'list',
kQTSGAudioPropertyID_DeviceAlive = 'aliv',
kQTSGAudioPropertyID_DeviceHogged = 'hogg',
kQTSGAudioPropertyID_DeviceInUse = 'used',
kQTSGAudioPropertyID_MixerCoefficients = 'mixc',
kQTSGAudioPropertyID_PreMixCallback = '_mxc',
kQTSGAudioPropertyID_PreMixCallbackFormat = '_mcf',
kQTSGAudioPropertyID_PostMixCallback = 'mx_c',
kQTSGAudioPropertyID_PostMixCallbackFormat = 'm_cf',
kQTSGAudioPropertyID_PreConversionCallback = '_cvc',
kQTSGAudioPropertyID_PreConversionCallbackFormat = '_ccf',
kQTSGAudioPropertyID_PostConversionCallback = 'cv_c',
kQTSGAudioPropertyID_PostConversionCallbackFormat = 'c_cf'
};

/*SGAudio Component Property Classes

Every SGAudioMediaType channel uses standard QuickTime component property selectors to get, set, and listen to properties. Each component property takes a property class as well as a property ID. SGAudioMediaType channels use the property classes listed in this section.SGAudioMediaType                       = 'audi'
kQTPropertyClass_SGAudio                 = 'audo'
kQTPropertyClass_SGAudioRecordDevice     = 'audr'
kQTPropertyClass_SGAudioPreviewDevice    = 'audp'

'audo'

Used with properties that pertain to the SGChannel as a whole, or to the output of an SGAudioChannel (that is, with the resulting track in a QuickTime movie).
'audr'

Used with properties that pertain specifically to an SGAudioChannel recording device��s physical settings.
'audp'

Used with properties that pertain specifically to an SGAudioChannel preview device��s physical settings.

For the property IDs used with these classes. see ��SGAudio Component Property IDs��.*/
enum {
SGAudioMediaType                       = 'audi',
kQTPropertyClass_SGAudio                 = 'audo',
kQTPropertyClass_SGAudioRecordDevice     = 'audr',
kQTPropertyClass_SGAudioPreviewDevice    = 'audp'
};

/*QTComponentPropertyInfo

Stores information for component property functions.

struct ComponentPropertyInfo {
   ComponentPropertyClass    propClass;
   ComponentPropertyID       propID;
   ComponentValueType        propType;
   ByteCount                 propSize;
   UInt32                    propFlags;
};
Fields
propClass

A value of type OSType that specifies a property class:
kComponentPropertyClassPropertyInfo ('pnfo')

A QTComponentPropertyInfo structure that defines a property information class.
kComponentPropertyInfoList ('list')

An array of QTComponentPropertyInfo structures, one for each property.
kComponentPropertyCacheSeed ('seed')

A component property cache seed value.
kComponentPropertyExtendedInfo ('meta')

A CFDictionary with extended property information.
kComponentPropertyCacheFlags ('flgs')

One of the following two flags:
kComponentPropertyCacheFlagNotPersistent

Property metadata should not be saved in persistent cache.
kComponentPropertyCacheFlagIsDynamic

Property metadata should not be cached at all.
propID

A value of type OSType that specifies a property ID.
propType

The type of the property.
propSize

The size of the property in bytes.
propFlags

Component property flags.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: QuickTimeComponents.h
Platform Considerations

Associated functions: QTAddComponentPropertyListener, QTComponentPropertyListenerCollectionAddListener, QTComponentPropertyListenerCollectionHasListenersForProperty, QTComponentPropertyListenerCollectionNotifyListeners, QTComponentPropertyListenerCollectionRemoveListener, QTGetComponentProperty, QTGetComponentPropertyInfo, QTRemoveComponentPropertyListener, QTSetComponentProperty, QTComponentPropertyListenerFilterProc, QTComponentPropertyListenerProc*/
struct ComponentPropertyInfo {
   ComponentPropertyClass    propClass;
   ComponentPropertyID       propID;
   ComponentValueType        propType;
   ByteCount                 propSize;
   UInt32                    propFlags;
};

typedef  struct ComponentPropertyInfo ComponentPropertyInfo ;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*seqGrabAppendToFile

Constants grouped with seqGrabAppendToFile.

enum {
   seqGrabToDisk                 = 1,
   seqGrabToMemory               = 2,
   seqGrabDontUseTempMemory      = 4,
   seqGrabAppendToFile           = 8,
   seqGrabDontAddMovieResource   = 16,
   seqGrabDontMakeMovie          = 32,
   seqGrabPreExtendFile          = 64,
   seqGrabDataProcIsInterruptSafe = 128,
   seqGrabDataProcDoesOverlappingReads = 256,
   seqGrabDontPreAllocateFileSize = 512  /* Don't set the size of the file before capture unless the file has been pre-extended */
//};
//Declared In
//QuickTimeComponents.h*/

enum {
   seqGrabToDisk                 = 1,
   seqGrabToMemory               = 2,
   seqGrabDontUseTempMemory      = 4,
   seqGrabAppendToFile           = 8,
   seqGrabDontAddMovieResource   = 16,
   seqGrabDontMakeMovie          = 32,
   seqGrabPreExtendFile          = 64,
   seqGrabDataProcIsInterruptSafe = 128,
   seqGrabDataProcDoesOverlappingReads = 256,
   seqGrabDontPreAllocateFileSize = 512  /* Don't set the size of the file before capture unless the file has been pre-extended */
};
/*Two new usage flags have also been defined so that your application can indicate to the sequence grabber (and thus the VDIG) that it is not being used in a conventional recording mode.
enum {
    seqGrabRecord               = 1,
    seqGrabPreview              = 2,
    seqGrabPlayDuringRecord     = 4,
    seqGrabLowLatencyCapture    = 8, /* return the freshest frame
                                        possible, for live work
                                        (i.e. videoconferencing,  live
                                        broadcast, live image processing)
                                                                     */
 
   // seqGrabAlwaysUseTimeBase    = 16 /* Tell VDIGs to use TimebaseTime
        //                                always, rather than creating
       //                                 uniform frame durations,  for more
       //                                 accurate live sync with  audio */
//};*

enum {
    seqGrabRecord               = 1,
    seqGrabPreview              = 2,
    seqGrabPlayDuringRecord     = 4,
    seqGrabLowLatencyCapture    = 8, /* return the freshest frame
                                        possible, for live work
                                        (i.e. videoconferencing,  live
                                        broadcast, live image processing)
                                                                     */
 
    seqGrabAlwaysUseTimeBase    = 16 /* Tell VDIGs to use TimebaseTime
                                        always, rather than creating
                                        uniform frame durations,  for more
                                        accurate live sync with  audio */
};
typedef unsigned long SeqGrabUsageEnum;

/*SGChannel

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SGChannel;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SGChannel;

/*SeqGrabComponent

Represents a type used by the Sequence Grabber API.

typedef ComponentInstance SeqGrabComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance SeqGrabComponent;

/*Component Identifiers

Identify the types of components.

clockComponentType                 ='clok'
compressorComponentType            ='imco'
CreateFilePreviewComponentType     ='pmak'
DataHandlerType                    ='dhlr'
decompressorComponentType          ='imdc'
MediaHandlerType                   ='mhlr'
MovieControllerComponentType       ='play'
MovieExportType                    ='spit'
MovieImportType                    ='eat '
SeqGrabChannelType                 ='sgch'
SeqGrabComponentType               ='barg'
SeqGrabCompressionPanelType        ='cmpr'
SeqGrabPanelType                   ='sgpn'
SeqGrabSourcePanelType             ='sour'
ShowFilePreviewComponentType       ='pnot'
StandardCompressionSubType         ='imag'
StandardCompressionSubTypeSound    ='soun'
StandardCompressionType            ='scdi'
systemMicrosecondClock             ='micr'
systemMillisecondClock             ='mill'
systemSecondClock                  ='seco'
systemTickClock                    ='tick'
videoDigitizerComponentType        ='vdig'
Discussion

All components of the same type or subtype provide the same kinds of services and support a common application programming interface. Codecs have their own set of types.*/
enum {
clockComponentType                 ='clok',
compressorComponentType            ='imco',
CreateFilePreviewComponentType     ='pmak',
DataHandlerType                    = 'dhlr',
decompressorComponentType          ='imdc',
MediaHandlerType                   ='mhlr',
MovieControllerComponentType       ='play',
MovieExportType                    ='spit',
MovieImportType                    ='eat',
SeqGrabChannelType                 ='sgch',
SeqGrabComponentType               ='barg',
SeqGrabCompressionPanelType        ='cmpr',
SeqGrabPanelType                   ='sgpn',
SeqGrabSourcePanelType             ='sour',
ShowFilePreviewComponentType       ='pnot',
StandardCompressionSubType         ='imag',
StandardCompressionSubTypeSound    ='soun',
StandardCompressionType            ='scdi',
systemMicrosecondClock             ='micr',
systemMillisecondClock             ='mill',
systemSecondClock                  ='seco',
systemTickClock                    ='tick',
videoDigitizerComponentType        ='vdig'
};

/*MovieImportComponent

Represents a type used by the Movie Components API.

typedef ComponentInstance MovieImportComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance MovieImportComponent;

/*QTVideoOutputComponent

Represents a type used by the Video Components API.

typedef ComponentInstance QTVideoOutputComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance QTVideoOutputComponent;

/*VideoDigitizerError

Represents a type used by the Video Components API.

typedef ComponentResult VideoDigitizerError;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentResult VideoDigitizerError;

/*VideoDigitizerComponent

Represents a type used by the Video Components API.

typedef ComponentInstance VideoDigitizerComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance VideoDigitizerComponent;

/*Temporal Settings Request Type

Use the temporal settings request to retrieve or modify the current temporal compression parameters. These parameters govern sequence-compression operations.

You supply a pointer to a temporal settings structure. If you are retrieving these settings, the standard dialog component places the current settings into the specified structure; if you are changing the settings, place the new values into the structure. The component uses those values to update its settings.

The SCTemporalSettings data type defines the format and content of the temporal settings structure:typedef struct {
    CodecQ      temporalQuality;    / desired quality *
    Fixed       frameRate;          / frame rate *
    long        keyFrameRate;       / key frame rate *
} SCTemporalSettings;*/
typedef struct SCTemporalSettings {
    CodecQ      temporalQuality;    /* desired quality */
    Fixed       frameRate;          /* frame rate */
    long        keyFrameRate;       /* key frame rate */
} SCTemporalSettings;

/*Spatial Settings Request Type

Use the spatial settings request to retrieve or modify the current spatial compression parameters. These parameters control how each image is compressed.

You supply a pointer to a spatial settings structure. If you are retrieving these settings, the standard dialog component places the current settings into the specified structure; if you are changing the settings, place the new values into the structure. The component uses those values to update its settings.

The SCSpatialSettings data type defines the format and content of the spatial settings structure:
typedef struct {
    CodecType           codecType;         *compressor type *
    CodecComponent      codec;             / compressor *
    short               depth;             / pixel depth *
    CodecQ              spatialQuality;    / desired quality *
} SCSpatialSettings;

Field	
Description

codecType	
Specifies the default compressor type that is displayed in the pop-up menu of compressors in the dialog box. The standard image compression dialog component uses this field to return the compressor type that was selected by the user. You must set this parameter to one of the compressor types supported by the Image Compression Manager, or to nil. If you set the field to nil, the standard image compression dialog component uses as the default value the first compressor or compressor type that it retrieves from the Image Compression Manager.

codec	
Provides additional information about the default compressor that is displayed in the pop-up menu of compressors in the dialog box. If the user selects a specific compressor component, the standard image compression dialog component returns the appropriate compressor identifier in this field. Other options for this field are discussed below.

depth	
Specifies the default value of the pixel depth pop-up menu in the dialog box. This menu allows the user to select the color or gray scale resolution value to be used when compressing the image or image sequence. If you set this field to 0, the component chooses an appropriate depth for the default compressor you specified with the theCodec field. When the user clicks OK, the standard image compression dialog component sets this field to the pixel depth value selected by the user. Note that the standard image compression dialog component may adjust the depth value so that it corresponds to a value that is supported by the compressor that has been selected by the user. The depth returned could be 0 if the scShowBestDepth flag is set.

spatialQuality	
Specifies the default setting of the quality slider in the dialog box. This slider controls the spatial quality of the compressed image sequence, which influences the amount of spatial compression that can be achieved. Spatial compression eliminates redundant information within each frame in a sequence. When the user clicks OK, the standard image compression dialog component sets this field to the spatial quality value selected by the user. Note that the standard image compression dialog component may adjust the quality value so that it corresponds to a value that is supported by the compressor that has been selected by the user.


The scListEveryCodec bit in the flag in the scPreferenceFlagsType request influences the operation of the compressor list in the dialog box and, therefore, the way the component uses the codec field. Set the flag to 1 to have the list contain an entry for each compressor component in the system. If the flag is set to 1, the standard image compression dialog component uses this field along with the codecType field to select the default compressor that appears in the dialog box. To specify a default image compressor component, set this field to the appropriate compressor identifier. When the user clicks OK in the dialog box, the standard image compression dialog component returns the compressor identifier that corresponds to the selected image compressor component.

If you set the codec field to nil, the standard image compression dialog component uses as the default value the first compressor of the specified type that it retrieves from the Image Compression Manager. If you have set the flag to 0, the list contains only one entry for each type of compressor in the system. The standard image compression dialog component ignores this field when creating the list of compressor types. In this case, the standard image compression dialog component does not change the value of this field when the user clicks OK.

However, you may use the codec field to specify additional selection criteria by setting this field to one of the special compressor identifiers supported by the Image Compression Manager. The standard image compression dialog component may use this value when it validates the compression parameters selected by the user.*/
typedef struct {
    CodecType           codecType;         /* compressor type */
    CodecComponent      codec;             /* compressor */
    short               depth;             /* pixel depth */ 
    CodecQ              spatialQuality;    /* desired quality */
} SCSpatialSettings;

/*SCModalFilterProc

Filter routine called when a user event occurs in a sequence compression modal dialog box.

typedef Boolean (*SCModalFilterProcPtr) (DialogPtr theDialog, EventRecord *theEvent, short *itemHit, long refcon);

If you name your function MySCModalFilterProc, you would declare it this way:

Boolean MySCModalFilterProc (
   DialogPtr      theDialog,
   EventRecord    *theEvent,
   short          *itemHit,
   long           refcon );
Parameters
theDialog

A pointer to a dialog box.
theEvent

A pointer to an EventRecord structure that defines a user event.
itemHit

A pointer to an item ID number in the dialog box.
refcon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

Return TRUE if the event was handled, FALSE otherwise.
Declared In
QuickTimeComponents.h*/
typedef Boolean (*SCModalFilterProcPtr) (DialogPtr theDialog, EventRecord *theEvent, short *itemHit, long refcon);

/*SCModalHookProc

Called whenever the user selects an item in the dialog box.

typedef short (*SCModalHookProcPtr) (DialogPtr theDialog, short itemHit, void *params, long refcon);

If you name your function MySCModalHookProc, you would declare it this way:

short MySCModalHookProc (
   DialogPtr    theDialog,
   short        itemHit,
   void         *params,
   long         refcon );
Parameters
theDialog

A pointer to a dialog box.
itemHit

A pointer to an item ID number in the dialog box.
params

A pointer to your data area.
refcon

A reference constant that the client code supplies to your callback.
Return Value

Return TRUE if the event was handled, FALSE otherwise.
Discussion

You can use this callback to customize the operation of the standard image-compression dialog box. For example, you might want to support a custom button that activates a secondary dialog box. Another possibility would be to provide additional validation support when the user clicks OK.
Declared In
QuickTimeComponents.h*/
typedef short (*SCModalHookProcPtr) (DialogPtr theDialog, short itemHit, void *params, long refcon);


/*Extended Functions Request Type

Use the extended functions request to extend the interface provided in the standard image or sequence dialog boxes. You may specify a filter function, a hook function, and a custom button; you may retrieve the current settings for these options using the SCGetInfo function.

You supply a pointer to an extended functions structure. If you are retrieving these settings, the standard dialog component places the current settings into the specified structure; if you are changing the settings, place the new values into the structure; the component uses those values to update its settings. Set this pointer to nil to remove the current functions.

By default, none of these extended interface elements are used.

The SCExtendedProcs data type defines the format and content of the extended functions structure:
typedef struct {
    SCModalFilterProcPtr    filterProc;     * filter function *
    SCModalHookProcPtr      hookProc;       * hook function *
    long                    refcon;         * reference constant *
    Str31                   customName;     * custom button name *
} SCExtendedProcs;

Field	
Description

filterProc	
Contains a pointer to a modal-dialog filter function in your application. Because the compression dialog box is a movable modal dialog box, you must provide a filter to process update events for your application windows. The standard component calls your filter function before it processes the event. You can use this function to control events in the dialog box. For example, you might use the filter function to release processing time to other windows displayed by your application while the standard image compression dialog box is being displayed. If you do not want to specify a filter function, set this parameter to nil.

hookProc	
Contains a pointer to a dialog hook function in your application. The standard component calls your hook function whenever the user selects an item in the dialog box. You can use this function to customize the operation of the standard image compression dialog box. For example, you might want to support a custom button that activates a secondary dialog box. Another possibility would be to provide additional validation support when the user clicks OK. If you do not want to specify a hook function, set this parameter to nil.

refcon	
Specifies a reference constant that is to be passed to the dialog hook function and the modal-dialog filter function.

customName	
Specifies the string to be displayed in the custom button in the dialog box. If you are not using a custom button, set this parameter to nil.


This is how to declare a filter function named MyFilter:pascal Boolean MyFilter (DialogPtr theDialog,
    EventRecord *theEvent, short *itemHit, long refcon);


This is how to declare a hook function named MyHook:pascal short MyHook (DialogPtr theDialog,
    short *itemHit, SCParams *params, long refcon);


In both cases the refcon parameter accepts the reference constant that you supply in the refcon field of the extended functions structure.*/
typedef struct {
    SCModalFilterProcPtr    filterProc;     /* filter function */
    SCModalHookProcPtr      hookProc;       /* hook function */
    long                    refcon;         /* reference constant */ 
    Str31                   customName;     /* custom button name */ 
} SCExtendedProcs;

/*(SGGrabBottleProc

Undocumented

typedef ComponentResult (*SGGrabBottleProcPtr) (SGChannel c, short bufferNum, long refCon);

If you name your function MySGGrabBottleProc, you would declare it this way:

ComponentResult MySGGrabBottleProc (
   SGChannel    c,
   short        bufferNum,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef ComponentResult (*SGGrabBottleProcPtr) (SGChannel c, short bufferNum, long refCon);

/*SGGrabBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGGrabBottleProcPtr) SGGrabBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGGrabBottleProcPtr) SGGrabBottleUPP;

/*SGGrabCompleteBottleProc

Undocumented

typedef ComponentResult (*SGGrabCompleteBottleProcPtr) (SGChannel c, short bufferNum, Boolean *done, long refCon);

If you name your function MySGGrabCompleteBottleProc, you would declare it this way:

ComponentResult MySGGrabCompleteBottleProc (
   SGChannel    c,
   short        bufferNum,
   Boolean      *done,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
done

A pointer to a Boolean; return TRUE if the task was completed, FALSE otherwise.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef ComponentResult (*SGGrabCompleteBottleProcPtr) (SGChannel c, short bufferNum, Boolean *done, long refCon);

/*SGGrabCompleteBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGGrabCompleteBottleProcPtr) SGGrabCompleteBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGGrabCompleteBottleProcPtr) SGGrabCompleteBottleUPP;

/*SGDisplayBottleProc

Undocumented

typedef ComponentResult (*SGDisplayBottleProcPtr) (SGChannel c, short bufferNum, MatrixRecord *mp, RgnHandle clipRgn, long refCon);

If you name your function MySGDisplayBottleProc, you would declare it this way:

ComponentResult MySGDisplayBottleProc (
   SGChannel       c,
   short           bufferNum,
   MatrixRecord    *mp,
   RgnHandle       clipRgn,
   long            refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
mp

Undocumented
clipRgn

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef ComponentResult (*SGDisplayBottleProcPtr) (SGChannel c, short bufferNum, MatrixRecord *mp, RgnHandle clipRgn, long refCon);


/*SGDisplayBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGDisplayBottleProcPtr) SGDisplayBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGDisplayBottleProcPtr) SGDisplayBottleUPP;

/*SGCompressBottleProc

Undocumented

typedef ComponentResult (*SGCompressBottleProcPtr) (SGChannel c, short bufferNum, long refCon);

If you name your function MySGCompressBottleProc, you would declare it this way:

ComponentResult MySGCompressBottleProc (
   SGChannel    c,
   short        bufferNum,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef ComponentResult (*SGCompressBottleProcPtr) (SGChannel c, short bufferNum, long refCon);

/*SGCompressBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGCompressBottleProcPtr) SGCompressBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGCompressBottleProcPtr) SGCompressBottleUPP;

/*SGCompressCompleteBottleProc

Undocumented

typedef ComponentResult (*SGCompressCompleteBottleProcPtr) (SGChannel c, short bufferNum, Boolean *done, SGCompressInfo *ci, long refCon);

If you name your function MySGCompressCompleteBottleProc, you would declare it this way:

ComponentResult MySGCompressCompleteBottleProc (
   SGChannel         c,
   short             bufferNum,
   Boolean           *done,
   SGCompressInfo    *ci,
   long              refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
done

A pointer to a Boolean; return TRUE if the task was completed, FALSE otherwise.
ci

A pointer to a SGCompressInfo structure.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/
typedef ComponentResult (*SGCompressCompleteBottleProcPtr) (SGChannel c, short bufferNum, Boolean *done, SGCompressInfo *ci, long refCon);


/*SGCompressCompleteBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGCompressCompleteBottleProcPtr) SGCompressCompleteBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGCompressCompleteBottleProcPtr) SGCompressCompleteBottleUPP;

/*SGAddFrameBottleProc

Undocumented

typedef ComponentResult (*SGAddFrameBottleProcPtr) (SGChannel c, short bufferNum, TimeValue atTime, TimeScale scale, const SGCompressInfo *ci,
long refCon);

If you name your function MySGAddFrameBottleProc, you would declare it this way:

ComponentResult MySGAddFrameBottleProc (
   SGChannel               c,
   short                   bufferNum,
   TimeValue               atTime,
   TimeScale               scale,
   const SGCompressInfo    *ci,
   long                    refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
atTime

Undocumented
scale

The current time scale.
ci

A pointer to a SGCompressInfo structure.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/

typedef ComponentResult (*SGAddFrameBottleProcPtr) (SGChannel c, short bufferNum, TimeValue atTime, TimeScale scale, const SGCompressInfo *ci,
long refCon);


/*SGAddFrameBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGAddFrameBottleProcPtr) SGAddFrameBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGAddFrameBottleProcPtr) SGAddFrameBottleUPP;

/*SGTransferFrameBottleProc

Undocumented

typedef ComponentResult (*SGTransferFrameBottleProcPtr) (SGChannel c, short bufferNum, MatrixRecord *mp, RgnHandle clipRgn, long refCon);

If you name your function MySGTransferFrameBottleProc, you would declare it this way:

ComponentResult MySGTransferFrameBottleProc (
   SGChannel       c,
   short           bufferNum,
   MatrixRecord    *mp,
   RgnHandle       clipRgn,
   long            refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bufferNum

A buffer identifier provided by the sequence grabber component.
mp

Undocumented
clipRgn

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/

typedef ComponentResult (*SGTransferFrameBottleProcPtr) (SGChannel c, short bufferNum, MatrixRecord *mp, RgnHandle clipRgn, long refCon);


/*SGTransferFrameBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGTransferFrameBottleProcPtr) SGTransferFrameBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGTransferFrameBottleProcPtr) SGTransferFrameBottleUPP;

/*SGGrabCompressCompleteBottleProc

Undocumented

typedef ComponentResult (*SGGrabCompressCompleteBottleProcPtr) (SGChannel c, Boolean *done, SGCompressInfo *ci, TimeRecord *t, long refCon);

If you name your function MySGGrabCompressCompleteBottleProc, you would declare it this way:

ComponentResult MySGGrabCompressCompleteBottleProc (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *t,
   long              refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
queuedFrameCount

A pointer to the number of queued frames yet to be done. 0 means no frames. Some VDIGs may return 2 even if more than 2 frames are available, and some will return 1 if any number more than 0 are available.
ci

A pointer to a SGCompressInfo structure. When the compression operation is complete, this structure is filled with information about it.
t

A pointer to a TimeRecord structure. When the compression operation is complete, this structure is used to indicate what time the frame was grabbed.
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/

typedef ComponentResult (*SGGrabCompressCompleteBottleProcPtr) (SGChannel c, Boolean *done, SGCompressInfo *ci, TimeRecord *t, long refCon);

/*SGGrabCompressCompleteBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGGrabCompressCompleteBottleProcPtr) SGGrabCompressCompleteBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGGrabCompressCompleteBottleProcPtr) SGGrabCompressCompleteBottleUPP;

/*SGDisplayCompressBottleProc

Undocumented

typedef ComponentResult (*SGDisplayCompressBottleProcPtr) (SGChannel c, Ptr dataPtr, ImageDescriptionHandle desc, MatrixRecord *mp, RgnHandle clipRgn,
long refCon);

If you name your function MySGDisplayCompressBottleProc, you would declare it this way:

ComponentResult MySGDisplayCompressBottleProc (
   SGChannel                 c,
   Ptr                       dataPtr,
   ImageDescriptionHandle    desc,
   MatrixRecord              *mp,
   RgnHandle                 clipRgn,
   long                      refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
dataPtr

Undocumented
desc

Undocumented
mp

Undocumented
clipRgn

Undocumented
refCon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Your callback should return noErr if there is no error.
Declared In
QuickTimeComponents.h*/

typedef ComponentResult (*SGDisplayCompressBottleProcPtr) (SGChannel c, Ptr dataPtr, ImageDescriptionHandle desc, MatrixRecord *mp, RgnHandle clipRgn,
long refCon);

/*SGDisplayCompressBottleUPP

Represents a type used by the Sequence Grabber API.

typedef STACK_UPP_TYPE(SGDisplayCompressBottleProcPtr) SGDisplayCompressBottleUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SGDisplayCompressBottleProcPtr) SGDisplayCompressBottleUPP;

/*VideoBottles

Identifies the callback functions to be assigned to a sequence grabber channel.

struct VideoBottles {
   short                              procCount;
   SGGrabBottleUPP                    grabProc;
   SGGrabCompleteBottleUPP            grabCompleteProc;
   SGDisplayBottleUPP                 displayProc;
   SGCompressBottleUPP                compressProc;
   SGCompressCompleteBottleUPP        compressCompleteProc;
   SGAddFrameBottleUPP                addFrameProc;
   SGTransferFrameBottleUPP           transferFrameProc;
   SGGrabCompressCompleteBottleUPP    grabCompressCompleteProc;
   SGDisplayCompressBottleUPP         displayCompressProc;
};
Fields
procCount
Discussion

Specifies the number of callback functions that may be identified in the structure. Set this field to 9.
grabProc
Discussion

Identifies the SGGrabBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
grabCompleteProc
Discussion

Identifies the SGGrabCompleteBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
displayProc
Discussion

Identifies the SGDisplayBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
compressProc
Discussion

Identifies the SGCompressBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
compressCompleteProc
Discussion

Identifies the SGCompressCompleteBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
addFrameProc
Discussion

Identifies the SGAddFrameBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
transferFrameProc
Discussion

Identifies the SGTransferFrameBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
grabCompressCompleteProc
Discussion

Identifies the SGGrabCompressCompleteBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
displayCompressProc
Discussion

Identifies the SGDisplayCompressBottleProc function. If you are setting such a function, set this field so that it points to the function's entry point. If you are not setting such a function, set this field to NIL.
Related Functions
SGGetVideoBottlenecks
SGSetVideoBottlenecks 
Declared In
QuickTimeComponents.h*/

struct VideoBottles {
   short                              procCount;
   SGGrabBottleUPP                    grabProc;
   SGGrabCompleteBottleUPP            grabCompleteProc;
   SGDisplayBottleUPP                 displayProc;
   SGCompressBottleUPP                compressProc;
   SGCompressCompleteBottleUPP        compressCompleteProc;
   SGAddFrameBottleUPP                addFrameProc;
   SGTransferFrameBottleUPP           transferFrameProc;
   SGGrabCompressCompleteBottleUPP    grabCompressCompleteProc;
   SGDisplayCompressBottleUPP         displayCompressProc;
};

typedef struct VideoBottles  VideoBottles;

/*Data-Rate Settings Request Type

Use the data-rate settings request to retrieve or modify the current temporal compression parameters that govern the data rate. These parameters affect sequence-compression operations.

You supply a pointer to a data-rate settings structure. If you are retrieving these settings, the standard dialog component places the current settings into the specified structure; if you are changing the settings, place the new values into the structure; the component uses those values to update its settings.

The SCDataRateSettings data type defines the format and content of the data-rate settings structure:
typedef struct {
    long        dataRate;              / desired data rate *
    long        frameDuration;         / frame duration *
    CodecQ      minSpatialQuality;     / minimum value *
    CodecQ      minTemporalQuality;   / minimum value *
} SCDataRateSettings;

Field	
Description

dataRate	
Specifies the maximum number of bytes of compressed data your application wants to receive per second. Use this parameter to modulate the rate at which the component passes compressed data to your application. This can be useful to account for hardware limitations during sequence playback.

frameDuration	
Indicates the duration of each frame, in milliseconds. Set this parameter to 0 to allow the standard dialog component to calculate the duration based upon the frame rate you specify in an scTemporalSettingsType request. However, if you allow the user to specify a 0 frame rate (that is, you set thescAllowZeroFrameRate flag to 1 in your scPreferenceFlagsType request), you must set the frame duration each time you compress a frame, because the component does not have sufficient information to determine an appropriate rate.

minSpatialQuality	
Specifies the minimum acceptable spatial quality. In order to meet your specified data rate, the standard dialog component may have to adjust the spatial quality setting. Use this parameter to set a minimum level, which the component may not exceed.

minTemporalQuality	
Specifies the minimum acceptable temporal quality. As with spatial quality, in order to meet your specified data rate, the standard dialog component may have to adjust the temporal quality setting. Use this parameter to set a minimum level, which the component may not exceed.*/
typedef struct {
    long        dataRate;              /* desired data rate */
    long        frameDuration;         /* frame duration */
    CodecQ      minSpatialQuality;     /* minimum value */
    CodecQ      minTemporalQuality;    /* minimum value */
} SCDataRateSettings;

/*SCModalHookUPP

Represents a type used by the Movie Components API.

typedef STACK_UPP_TYPE(SCModalHookProcPtr) SCModalHookUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SCModalHookProcPtr) SCModalHookUPP;

/*SCParams

Provides data for the SCGetCompressionExtended function.

struct SCParams {
   long              flags;
   CodecType         theCodecType;
   CodecComponent    theCodec;
   CodecQ            spatialQuality;
   CodecQ            temporalQuality;
   short             depth;
   Fixed             frameRate;
   long              keyFrameRate;
   long              reserved1;
   long              reserved2;
};
Fields
flags
Discussion

Flags (see below). See these constants: 
scGetCompression
scShowMotionSettings
scSettingsChangedItem
theCodecType
Discussion

A compressor type; see Codec Identifiers.
theCodec
Discussion

An instance of a compressor component, obtained by calling OpenComponent or OpenDefaultComponent.
spatialQuality
Discussion

Constants (see below) that determine image spatial quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
temporalQuality
Discussion

Constants (see below) that determine image temporal quality.
depth
Discussion

Image data depth.
frameRate
Discussion

The frame rate.
keyFrameRate
Discussion

The key frame rate.
reserved1
Discussion

Reserved.
reserved2
Discussion

Reserved.
Related Functions
SCGetCompressionExtended 
Declared In
QuickTimeComponents.h*/

struct SCParams {
   long              flags;
   CodecType         theCodecType;
   CodecComponent    theCodec;
   CodecQ            spatialQuality;
   CodecQ            temporalQuality;
   short             depth;
   Fixed             frameRate;
   long              keyFrameRate;
   long              reserved1;
   long              reserved2;
};
typedef struct SCParams SCParams;

/*SCModalFilterProc

Filter routine called when a user event occurs in a sequence compression modal dialog box.

typedef Boolean (*SCModalFilterProcPtr) (DialogPtr theDialog, EventRecord *theEvent, short *itemHit, long refcon);

If you name your function MySCModalFilterProc, you would declare it this way:

Boolean MySCModalFilterProc (
   DialogPtr      theDialog,
   EventRecord    *theEvent,
   short          *itemHit,
   long           refcon );
Parameters
theDialog

A pointer to a dialog box.
theEvent

A pointer to an EventRecord structure that defines a user event.
itemHit

A pointer to an item ID number in the dialog box.
refcon

A reference constant that the client code supplies to your callback. You can use this reference to point to a data structure containing any information your callback needs.
Return Value

Return TRUE if the event was handled, FALSE otherwise.
Declared In
QuickTimeComponents.h*/

typedef Boolean (*SCModalFilterProcPtr) (DialogPtr theDialog, EventRecord *theEvent, short *itemHit, long refcon);


/*SCModalFilterUPP

Represents a type used by the Movie Components API.

typedef STACK_UPP_TYPE(SCModalFilterProcPtr) SCModalFilterUPP;
Declared In
QuickTimeComponents.h*/
typedef STACK_UPP_TYPE(SCModalFilterProcPtr) SCModalFilterUPP;

/*SGOutputRecord

Contains a sequence grabber output.

struct SGOutputRecord {
   long    data[1];
};
Fields
data
Discussion

An array of data.
Declared In
QuickTimeComponents.h*/

struct SGOutputRecord {
   long    data[1];
};
typedef struct SGOutputRecord SGOutputRecord;

/*SGOutput

Represents a type used by the Sequence Grabber API.

typedef SGOutputRecord * SGOutput;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef SGOutputRecord * SGOutput;

/*pnotComponent

Represents a type used by the Movie Components API.

typedef ComponentInstance pnotComponent;
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
typedef ComponentInstance pnotComponent;

//Function

/*SCAudioFillBuffer

Used is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format.

ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);
Parameters
ci

The clients connection to a StdAudio Compression component.
inInputDataProc

The proc address of the function that will be called to supply data in the kQTSCAudioPropertyID_InputBasicDescription format to SCAudio.
inInputDataProcRefCon

The client refcon that will be passed to the user-provided SCAudioInputDataProc function.
ioOutputDataPacketSize

On input, the number of desired packets. On output, the actual number of packets delivered (can be fewer than the input desired packets).
outOutputData

An AudioBufferList providing sufficiently large buffers to hold the requested number of packets.
outPacketDescription

An array of AudioStreamPacketDescriptions. If the requested output format requires external framing information??that is, a VBR format such as AAC?? allocate and pass an array of packet descriptions as large as the number of packets you are requesting.
Discussion

SCAudioFillBuffer preserves the same style API as the Core Audio AudioConverterFillComplexBuffer API, which is part of the AudioToolbox framework and resides in AudioConverter.h. 

This function has the same parameters as AudioConverterFillComplexBuffer, but internally it has an audio converter, a matrix mixer, and another audio converter. It is based on a pull model: You pull on the audio converter for some output, and specify the buffer in which you want to put it. You have already configured the format that it is going to return to you. You also provide it with an input proc and it will call back that input proc and specify however many samples of audio you have. For example, if you want five packets of AAC audio coming out the back end, and at the front end you happen to have PCM de-interleaved, the routine will ask you for the samples. The difference is you can now have different numbers of channels going in or out. For example, at the same time you are doing the compression from PCM to AAC, you can also go from 5.1 to stereo.

SCAudioFillBuffer is used to pull compressed frames from the StdAudio component in kQTSCAudioPropertyID_BasicDescription format. The StdAudio component can perform any combination of decompression/mixing/compression, combining the facilities of Core Audio AudioConverters and Matrix Mixer AudioUnits. The behavior of the SCAudioFillBuffer call (signalling end of data, and so on) is identical to the AudioConverter's AudioConverterFillComplexBuffer API.

One important difference between the AudioConverter and SCAudio component is that the SCAudio compression APIs can do mixing as well as n -> n channels conversion. If you want to compress, decompress, or transcode audio using the SCAudioFillBuffer interface, you configure the StandardCompressionSubTypeAudio component with the desired input and output formats (or use the SCRequestImageSettings API to present a dialog and let a user select an output format), then you call SCAudioFillBuffer, providing an SCAudioInputDataProc callback, which is called for audio in the specified source format.
Version Notes

Introduced in QuickTime 7.1 for Windows and QuickTime 7 for Mac OS X. 
Availability
Carbon status: Supported C interface file: QuickTimeComponents.h
Declared In
QuickTimeComponents.h*/
ComponentResult SCAudioFillBuffer (
   ComponentInstance ci,
   SCAudioInputDataProc inInputDataProc,
   void *inInputDataProcRefCon,
   UInt32 *ioOutputDataPacketSize,
   AudioBufferList *outOutputData,
   AudioStreamPacketDescription *outPacketDescription
);

/*SCRequestImageSettings

Displays the standard image dialog box to the user and shows default settings you have established.

ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to retrieve the user's preferences for compressing a single image; use SCRequestSequenceSettings when you are working with an image sequence. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestImageSettings (
   ComponentInstance    ci );

/*SGNewChannel

Creates a sequence grabber channel and assigns a channel component to the channel.

ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
channelType

The type of channel to open (see below). This value corresponds to the component subtype value of the channel component. See these constants: 
VideoMediaType
SoundMediaType
ref

A pointer to the frameChannel field in the SeqGrabFrameInfo structure that is to receive a reference to the channel that is added to the sequence grabber component. If the sequence grabber component successfully locates and connects to an appropriate channel component, the sequence grabber component returns a reference to the channel component into this field.
Return Value

See Error Codes. If the sequence grabber component cannot open a connection, it sets the result code to a nonzero value. It returns noErr if there is no error.
Discussion

The channel component is responsible for providing digitized data to the sequence grabber component. You specify the type of channel component to be added to the sequence grabber component, as shown in the following sample code:// SGNewChannel coding example
// See "Discovering QuickTime," page 263
void MakeMyGrabChannels (SeqGrabComponent    seqGrab,
                            SGChannel        *sgchanVideo,
                            SGChannel        *sgchanSound,
                            const Rect       *rect,
                            Boolean          bWillRecord)
{
    OSErr           nErr;
    long            lUsage;
    // figure out the usage
    lUsage =seqGrabPreview;                // always previewing
    if (bWillRecord)
        lUsage |=seqGrabRecord;            // sometimes recording
    // create a video channel
    nErr =SGNewChannel(seqGrab, VideoMediaType, sgchanVideo);
    if (nErr ==noErr) {
        // set boundaries for new video channel
        nErr =SGSetChannelBounds(*sgchanVideo, rect);
        // set usage for new video channel
        if (nErr ==noErr)
            nErr =SGSetChannelUsage(*sgchanVideo, lUsage |
                                        seqGrabPlayDuringRecord);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanVideo);
            *sgchanVideo =NIL;
        }
    }
    // create a sound channel
    nErr =SGNewChannel(seqGrab, SoundMediaType, sgchanSound);
    if (nErr ==noErr) {
        // set usage of new sound channel
        nErr =SGSetChannelUsage(*sgchanSound, lUsage);
        if (nErr !=noErr) {
            // clean up on failure
            SGDisposeChannel(seqGrab, *sgchanSound);
            *sgchanSound =NIL;
        }
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewChannel (
   SeqGrabComponent    s,
   OSType              channelType,
   SGChannel           *ref );

/*SGGetChannelRefCon

Returns a reference constant that was previously set by SGSetChannelRefCon.

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A pointer to the reference constant set by SGSetChannelRefCon, normally used to point to a data structure containing information your sequence grabber channel needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h&*/

ComponentResult SGGetChannelRefCon (
   SGChannel    c,
   long         *refCon );

/*SGSetChannelRefCon

Sets the value of a reference constant that is passed to your callback functions for channel components.

ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
refCon

A reference constant value that your component should pass to the callback functions that have been assigned to this channel. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelRefCon (
   SGChannel    c,
   long         refCon );


/*SGSetDataProc

Specifies a data function for use by the sequence grabber.

ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
proc

A pointer to your data function. To remove your data function, set this parameter to NIL.
refCon

A reference constant. The sequence grabber provides this value to your data callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetDataProc (
   SeqGrabComponent    s,
   SGDataUPP           proc,
   long                refCon );

/*SGGetChannelDeviceAndInputNames

Returns the sequence grabber's current device and input names.

ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
outDeviceName

The current device names for display to the user.
outInputName

The current input names for display to the user.
outInputNumber

A pointer to the number of currently selected inputs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a utility call that lets you find out the sequence grabber's current device and input names, instead of having to call GetDeviceList and walk it yourself. Pass NIL for parameters you are not interested in.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceAndInputNames (
   SGChannel    c,
   Str255       outDeviceName,
   Str255       outInputName,
   short        *outInputNumber );

/*SGGetChannelDeviceList

Retrieves a list of the devices that are valid for a specified channel.

ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
selectionFlags

Flags (see below) that control the data you are to return for each device. See these constants: 
sgDeviceListWithIcons
sgDeviceListDontCheckAvailability
sgDeviceListIncludeInputs
list

A pointer to a pointer to an SGDeviceListRecord structure. The channel creates this structure and returns a pointer to it in the field referred to by this parameter. Applications use SGDisposeDeviceList to dispose of the memory used by the list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function can be useful for retrieving the name of the current device. Retrieve the device list and use the selectedIndex field to determine which device is currently in use.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelDeviceList (
   SGChannel       c,
   long            selectionFlags,
   SGDeviceList    *list );

/*SGDisposeDeviceList

Disposes of a device list.

ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
list

A pointer to a pointer to an SGDeviceListRecord structure. The sequence grabber disposes of the memory used by this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeDeviceList (
   SeqGrabComponent    s,
   SGDeviceList        list );

/*SGGetSrcVideoBounds

Determines the size of the source video boundary rectangle.

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive information about your channel's source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

For video channel components that work with video digitizer components, the source video boundary rectangle corresponds to the video digitizer's active source rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetSrcVideoBounds (
   SGChannel    c,
   Rect         *r );

/*SGGetChannelSampleDescription

Retrieves a channel's sample description structure.

ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sampleDesc

A handle that is to receive the structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The channel returns a structure that is appropriate to the type of data being captured. For video channels, the channel component returns an ImageDescription structure; for sound channels, it receives a SoundDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelSampleDescription (
   SGChannel    c,
   Handle       sampleDesc );

/*SGGetChannelTimeScale

Lets the sequence grabber retrieve a channel's time scale.

ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
scale

A pointer to a time scale. Your channel component places information about its time scale into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The time scale you return typically corresponds to the time scale of the media that has been created by your channel. Applications may use this time scale in their data functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelTimeScale (
   SGChannel    c,
   TimeScale    *scale );

/*SGGetChannelBounds

Determines a channel's display boundary rectangle.

ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that is to receive information about your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelBounds (
   SGChannel    c,
   Rect         *bounds );

/*SGSetGWorld

Establishes the graphics port and device for a sequence grabber component.

ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
gp

The destination graphics port, which must be a color graphics port. The sequence grabber component always sets this parameter to a valid value. To use the current graphics port, the parameter is set to NIL.
gd

A handle to the destination graphics device. The sequence grabber component always sets this parameter to a valid value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function if you are working with any channels that collect visual data. If you are working only with data that has no visual representation, you do not need to call this function. The sequence grabber component performs this operation implicitly when you call SGInitialize and the component uses your application's current graphics port. To set it to a specified window, use code such as the following:// SGSetGWorld coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Special Considerations

You cannot call this function during a record or preview operation, or after you have prepared the sequence grabber component for a record or preview operation by calling SGPrepare. The window in which the sequence grabber is to draw video frames as defined by this function must be visible before you call SGPrepare; otherwise, the sequence grabber does not display the frames properly.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetGWorld (
   SeqGrabComponent    s,
   CGrafPtr            gp,
   GDHandle            gd );

/*SGSetChannelBounds

Specifies a channel's display boundary rectangle.

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
bounds

A pointer to a Rect structure that defines your channel's display boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelBounds (
   SGChannel     c,
   const Rect    *bounds);

/*SGInitialize

Initializes the sequence grabber component.

ComponentResult SGInitialize (
   SeqGrabComponent    s );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before you can call this function you must establish a connection to the sequence grabber component. Use OpenDefaultComponent or OpenComponent to establish a component connection, as shown below:// SGInitialize coding example
// See "Discovering QuickTime," page 262
SeqGrabComponent MakeMySequenceGrabber (WindowRef pMacWnd)
{
    SeqGrabComponent    seqGrab =NIL;
    OSErr               nErr =noErr;
    // open the default sequence grabber
    seqGrab =OpenDefaultComponent(SeqGrabComponentType, 0);
    if (seqGrab !=NIL) {
        // initialize the default sequence grabber component
        nErr =SGInitialize(seqGrab);
        if (nErr ==noErr) {
        // set its graphics world to the specified window
            nErr =SGSetGWorld(seqGrab, (CGrafPtr)pMacWnd, NIL);
        }
    }
    if (nErr && (seqGrab !=NIL)) {    // clean up on failure
        CloseComponent(seqGrab);
        seqGrab =NIL;
    }
    return seqGrab;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGInitialize (
   SeqGrabComponent    s );

/*(SGSetDataRef

Specifies the destination data reference for a record operation.

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the information that identifies the destination container.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to specify the destination for a record operation using a data reference, and to specify other options that govern the operation. This function is similar to SGSetDataOutput, and provides you with an alternative way to specify the destination.
Special Considerations

If you are performing a preview operation, you don't need to use this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataRef (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags );

/*SGGetSettings

Retrieves the current settings of all channels used by the sequence grabber.

ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A pointer to a space where the sequence grabber returns a pointer to a UserDataRecord structure that contains the configuration information. Your application is responsible for disposing of this structure when it is done with it.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetSettings (
   SeqGrabComponent    s,
   UserData            *ud,
   long                flags );

/*SGGetIndChannel

Collects information about all of the channel components currently in use by a sequence grabber component.

ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
index

Specifies an index value that identifies the channel to be queried. The first channel has an index value of 1.
ref

A pointer to a field to receive a value identifying your connection to the channel. If you do not want to receive this information, set this parameter to NIL.
chanType

A pointer to a field to receive the channel's subtype value (see below). This value indicates the media type supported by the channel component. See these constants: 
VideoMediaType
SoundMediaType
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetIndChannel (
   SeqGrabComponent    s,
   short               index,
   SGChannel           *ref,
   OSType              *chanType );

/*SGSetSettings

Configures a sequence grabber and its channels.

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the sequence grabber.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber disposes of any of its current channels before applying this configuration information. It then opens connections to new channels as appropriate.
Special Considerations

You can restore saved settings by using NewUserDataFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetSettings (
   SeqGrabComponent    s,
   UserData            ud,
   long                flags );

/*SGGetChannelSettings

Retrieves the current settings of a channel used by the sequence grabber.

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

On return, a pointer to a UserDataRecord structure that contains the configuration information.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            *ud,
   long                flags );

/*SGDisposeChannel

Removes a channel from a sequence grabber component.

ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The reference that identifies the channel you want to close. You obtain this reference from SGNewChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGDisposeChannel (
   SeqGrabComponent    s,
   SGChannel           c );

/*SGSetChannelSettings

Configures a sequence grabber channel.

ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
ud

A UserDataRecord structure that contains the configuration information to be used by the channel component.
flags

Reserved for Apple. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelSettings (
   SeqGrabComponent    s,
   SGChannel           c,
   UserData            ud,
   long                flags );

/*SGSetMaximumRecordTime

Limits the duration of a record operation

ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
ticks

The maximum duration for the record operation, in system ticks (sixtieths of a second). Set this parameter to 0 to remove the time limit from the operation.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By default, there is no time limit on a record operation. If you do not set a limit, a record operation will run until it exhausts the Operating System resources or you call SGStop. Memory and disk space are the two major limiting factors.
Special Considerations

You must call this function before you start a sequence grabber record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetMaximumRecordTime (
   SeqGrabComponent    s,
   unsigned long       ticks );

/*SGIdle

Provides processing time for sequence grabber components.

ComponentResult SGIdle (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After starting a preview or record operation, the application calls this function as often as possible. The sequence grabber component then calls your SGIdle function. This continues until the calling application stops the operation by calling SGStop.Your SGIdle function reports several status and error conditions by means of its result code. If your component returns a nonzero result code during a record operation, the application should call SGStop so that the sequence grabber component can store the data it has collected.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGIdle (
   SeqGrabComponent    s );

/*SGStartRecord

Instructs the sequence grabber component to begin collecting data from its channels.

ComponentResult SGStartRecord (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartRecord (
   SeqGrabComponent    s );

/*SGStop

Stops a preview or record operation.

ComponentResult SGStop (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

It is dangerous to allow an update event to occur during recording. Many digitizers capture directly to the screen, and an update event will result in data loss.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStop (
   SeqGrabComponent    s );

/*SGPause

Suspends or restarts a sequence grabber record or preview operation.

ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
pause

A constant (see below) that instructs your component to suspend or restart the current operation. See these constants: 
seqGrabUnpause
seqGrabPause
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component should not release any system resources or temporary memory associated with the current operation. You should be ready to restart the operation immediately.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPause (
   SeqGrabComponent    s,
   Byte                pause );

/*SGGetPause

Determines whether the sequence grabber is paused.

ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
paused

A pointer to a field that is to receive a constant (see below) that indicates whether the sequence grabber is currently paused. See these constants: 
seqGrabUnpause
seqGrabPause
seqGrabPauseForMenu
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetPause (
   SeqGrabComponent    s,
   Byte                *paused );

/*SGSetChannelUsage

Specifies how a channel is to be used by the sequence grabber component.

ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

Contains flags (see below) specifying how your channel is to be used. The sequence grabber component may set more than one of these flags to 1. It sets unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelUsage (
   SGChannel    c,
   long         usage );

/*SGSettingsDialog

Causes a sequence grabber to display its settings dialog box to the user.

ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
numPanels

The number of panel components to be listed in the panel component pop-up menu. You specify the panel components with the panelList parameter. You may use these parameters to limit the user's choice of panel components. If you set this parameter to 0 and the panelList parameter to NIL, the sequence grabber lists all available panel components.
panelList

A pointer to an array of component identifiers. The sequence grabber presents only these components in the panel component pop-up menu. You specify the number of identifiers in the array with the numPanels parameter. If you set this parameter to NIL, the sequence grabber lists all available panel components.
flags

Either set this to 0 or to seqGrabSettingsPreviewOnly (see below). See these constants: 
seqGrabSettingsPreviewOnly
proc

Specifies an SGModalFilterProc callback. Because the sequence grabber's settings dialog box is a movable modal dialog box, you must supply an event filter function to process update events in your window.
procRefNum

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. If the user clicks OK and the settings are acceptable to the panel and channel components, this function returns a result code of noErr.
Discussion

Because the user may change several channel configuration parameters, your application should retrieve new configuration information from the channel so that you can update any values you save, such as the channel's display boundaries or the channel device. In particular, the video rectangle for the channels may have to be adjusted.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSettingsDialog (
   SeqGrabComponent         s,
   SGChannel                c,
   short                    numPanels,
   ConstComponentListPtr    panelList,
   long                     flags,
   SGModalFilterUPP         proc,
   long                     procRefNum );

/*SGGetChannelPlayFlags

Retrieves the playback control flags that you set with SGSetChannelPlayFlags.

ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A pointer to a long integer that is to receive flags (see below) that influence channel playback. Set unused flags to 0. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelPlayFlags (
   SGChannel    c,
   long         *playFlags );

/*SGSetChannelPlayFlags

Adjusts the speed and quality with which the sequence grabber displays data from a channel.

ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
playFlags

A long integer that contains flags (see below) that influence channel playback. A sequence grabber component must use one of these values. See these constants: 
channelPlayNormal
channelPlayFast
channelPlayHighQuality
channelPlayAllData
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelPlayFlags (
   SGChannel    c,
   long         playFlags );

/*SGGetChannelUsage

Determines how the sequence grabber component is using a channel.

ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
usage

A pointer to a location that is to receive flags (see below) that specify how your channel is to be used. You may set more than one of these flags to 1. Set unused flags to 0. See these constants: 
seqGrabRecord
seqGrabPreview
seqGrabPlayDuringRecord
seqGrabLowLatencyCapture
seqGrabAlwaysUseTimeBase
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier. Flags added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGetChannelUsage (
   SGChannel    c,
   long         *usage );

/*SGPrepare

Instructs a sequence grabber to get ready to begin a preview or record operation.

ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
prepareForPreview

The sequence grabber component sets this parameter to TRUE to prepare for a preview operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
prepareForRecord

The sequence grabber component sets this parameter to TRUE to prepare for a record operation. The sequence grabber component may set both the prepareForPreview and prepareForRecord parameters to TRUE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you do not call this function before starting a record or preview operation, the sequence grabber component makes these preparations when you start the operation. You cannot call this function after you start a preview or record operation. If you call this function without subsequently starting a record or preview operation, you should call SGRelease. This allows the sequence grabber component to release any system resources it allocated when you called this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGPrepare (
   SeqGrabComponent    s,
   Boolean             prepareForPreview,
   Boolean             prepareForRecord );

/*SGStartPreview

Instructs the sequence grabber to begin processing data from its channels.

ComponentResult SGStartPreview (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your channel component should immediately present the data to the user in the appropriate format, according to your channel's configuration. Display video data in the destination display region; play sound data at the specified volume settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGStartPreview (
   SeqGrabComponent    s );

/*SGRelease

Instructs the sequence grabber to release any system resources it allocated when you called SGPrepare.

ComponentResult SGRelease (
   SeqGrabComponent    s );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record or preview operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGRelease (
   SeqGrabComponent    s );

/*MovieExportAddDataSource

Defines a data source for use with an export operation performed by MovieExportFromProceduresToDataRef.

ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The type of media provided by this data source. This normally corresponds to a QuickTime media type such as VideoMediaType or SoundMediaType.
scale

The time scale for time values passed to getDataProc parameter. If the source data is being taken from a QuickTime track, this value is typically the media's time scale.
trackID

An identifier for the data source. This identifier is returned from the call.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before starting an export operation, all the data sources must be defined by calling this function once for each data source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportAddDataSource (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    scale,
   long                         *trackID,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );


/*MovieExportNewGetDataAndPropertiesProcs

Returns MovieExportGetPropertyProc and MovieExportGetDataProc callbacks that can be passed to MovieExportAddDataSource to create a new data source.

ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
trackType

The format of the data to be generated by the returned MovieExportGetDataProc.
scale

The time scale returned from this function; this should be passed on to MovieExportAddDataSource with the procedures.
theMovie

The movie for this operation, supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
theTrack

The track for this operation. This track identifier is supplied by the Movie Toolbox.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exists in order to provide a standard way of getting data using this protocol out of a movie or track. The returned procedures must be disposed by calling MovieExportDisposeGetDataAndPropertiesProcs.
Special Considerations

This function is only implemented by movie data export components.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportNewGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   OSType                       trackType,
   TimeScale                    *scale,
   Movie                        theMovie,
   Track                        theTrack,
   TimeValue                    startTime,
   TimeValue                    duration,
   MovieExportGetPropertyUPP    *getPropertyProc,
   MovieExportGetDataUPP        *getDataProc,
   void                         **refCon );


/*MovieExportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theMovie

The movie containing the data to be exported.
onlyThisTrack

Specifies that the export component should only attempt to export the data from a single track. If this parameter is set to NIL, the exporter should attempt to export the entire movie, or all of the tracks in the movie that it can export. For example, an audio export component might export multiple audio tracks, mixing them if necessary. If this parameter is not NIL, the exporter should attempt to export only the specified track.
startTime

The movie time at which to begin the export operation. If you pass 0, the operation should start at the beginning of the movie or track.
duration

The duration, in movie timescale units, of the segment to be exported. To export the entire movie, or an entire track, pass in the value returned by GetMovieDuration or GetTrackDuration, minus the value passed in startTime, as described above.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box, otherwise FALSE. If the user cancels the dialog box, your component should revert to its settings as they were before executing this function.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDoUserDialog (
   MovieExportComponent    ci,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration,
   Boolean                 *canceled );

/*DisposeMovieExportGetPropertyUPP

Disposes of a MovieExportGetPropertyUPP pointer.

void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP );
Parameters
userUPP

A MovieExportGetPropertyUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetPropertyUPP (
   MovieExportGetPropertyUPP    userUPP );

/*DisposeMovieExportGetDataUPP

Disposes of a MovieExportGetDataUPP pointer.

void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP );
Parameters
userUPP

A MovieExportGetDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeMovieExportGetDataUPP (
   MovieExportGetDataUPP    userUPP );


/*MovieExportDisposeGetDataAndPropertiesProcs

Disposes of the memory associated with the procedures returned by MovieExportNewGetDataAndPropertiesProcs.

ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
getPropertyProc

A MovieExportGetPropertyProc callback that provides information about processing source samples.
getDataProc

A MovieExportGetDataProc callback that the export component uses to request sample data.
refCon

Passed to the procedures specified in the getPropertyProc and getDataProc parameters. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportDisposeGetDataAndPropertiesProcs (
   MovieExportComponent         ci,
   MovieExportGetPropertyUPP    getPropertyProc,
   MovieExportGetDataUPP        getDataProc,
   void                         *refCon );

/*NewMovieExportGetPropertyUPP

Allocates a Universal Procedure Pointer for the MovieExportGetPropertyProc callback.

MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetPropertyProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetPropertyUPP NewMovieExportGetPropertyUPP (
   MovieExportGetPropertyProcPtr    userRoutine );

/*NewMovieExportGetDataUPP

Allocates a Universal Procedure Pointer for the MovieExportGetDataProc callback.

MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieExportGetDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
MovieExportGetDataUPP NewMovieExportGetDataUPP (
   MovieExportGetDataProcPtr    userRoutine );

/*MovieExportFromProceduresToDataRef

Exports data provided by MovieExportAddDataSource to a specified location.

ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference for the export operation.
dataRefType

The type identifier for the data reference specified by dataRef.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function exports data provided by MovieExportAddDataSource to a location specified by dataRef and dataRefType. Typically dataRef contains a Macintosh file alias and dataRefType is set to rAliasType.
Special Considerations

Movie data export components that support export operations from procedures must set the canMovieExportFromProcedures flag in their component flags.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportFromProceduresToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType );

/*MovieImportGetSettingsAsAtomContainer

Retrieves the current settings from the movie import component.

ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the reference to the newly created atom container should be stored by the call.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings );

/*MovieExportGetSettingsAsAtomContainer

Retrieves the current settings from the movie export component.

ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the newly-created atom container should be stored by the call. The caller is responsible for disposing of the returned QT atom container.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can call this function to obtain a correctly formatted atom container to use with MovieExportSetSettingsFromAtomContainer. This might be done after a call to MovieExportDoUserDialog, for example, to apply the user-obtained settings to a series of exports.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings );

/*QTVideoOutputGetDisplayModeList

Returns a list of the display modes supported by a video output component.

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
outputs

A pointer to the QT atom container that lists the video modes supported by this component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After your software calls this function, it must dispose of the QT atom container returned by the function by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs );

/*VDIIDCGetFeatures

Places atoms in a QuickTime atom container that specify the current capabilities of a camera and the state of its IIDC features.

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container );
Parameters
ci

The component instance that identifies your connection to a video digitizer component. The digitizer's subtype must be vdSubtypeIIDC ('iidc').
container

Upon return, a pointer to a QuickTime atom container containing atoms of type vdIIDCAtomTypeFeature for each IIDC camera feature. If the camera has not implemented any IIDC features the container returns empty.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Discussion

The digitizer creates the container, and it is the responsibility of the client to ultimately delete it if the routine does not return an error. Since the values that this function retrieves might change underneath the client, they should not be cached but should be retrieved each time they are needed.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container );

/*DataHGetInfoFlags

Provides information about the operation of a data handler component.

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags );
Parameters
dh

A data handler component.
flags

Flags (see below) that provide information about the data handler. See these constants: 
kDataHInfoFlagNeverStreams
kDataHInfoFlagCanUpdateDataRefs
kDataHInfoFlagNeedsNetworkBandwidth
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult DataHGetInfoFlags (
   DataHandler    dh,
   UInt32         *flags );

/*VDGetDeviceNameAndFlags

Returns the current name and device visibility of a video digitizer.

VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
outName

The video digitizer device name.
outNameFlags

A pointer to a constant (see below) that determines whether to show or hide the VDIG device. See these constants: 
vdDeviceFlagShowInputsAsDevices
vdDeviceFlagHideDevice
Return Value

An error return of type ComponentResult. See Error Codes. Returns noErr if there is no error.
Discussion

This routine is designed to give the VDIG more control over how it is presented to the user, and to clarify the distinction between devices and inputs. Historically, the assumption has been that there is one component registered per device and that the component name is displayed. This function lets a component choose its name after registration. When this function is called, it is also a good time to check for hardware and register further VDIG components if needed, allowing for lazy initialization when the application needs to find a VDIG rather than initializing at every launch or replug.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDeviceNameAndFlags (
   VideoDigitizerComponent    ci,
   Str255                     outName,
   UInt32                     *outNameFlags );


/*VDGetNumberOfInputs

Returns the number of input video sources that a video digitizer component supports.

VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputs

A pointer to an integer that is to receive the number of input video sources supported by the specified component. Video digitizer components number video sources sequentially, starting at 0. So, if a digitizer component supports two inputs, this function sets the field referred to by the inputs parameter to 1.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetNumberOfInputs (
   VideoDigitizerComponent    ci,
   short                      *inputs );

/*VDGetInputName

Gets the name of a video input.

VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name );
Parameters
ci

Specifies the video digitizer component for this operation. Applications can obtain this reference from OpenComponent or OpenDefaultComponent.
videoInput

The input video source for this request. Video digitizer components number video sources sequentially, starting at 0. So, to request information about the first video source, an application sets this parameter to 0. Applications can get the number of video sources supported by a video digitizer component by calling VDGetNumberOfInputs.
name

The video input source's name string.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetInputName (
   VideoDigitizerComponent    ci,
   long                       videoInput,
   Str255                     name );


/*VDGetInput

Returns data that identifies the currently active input video source.

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
input

A pointer to a short integer that is to receive the identifier for the currently active input video source. Video digitizer components number video sources sequentially, starting at 0. So, if the first source is active, this function sets the field referred to by the input parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetInput (
   VideoDigitizerComponent    ci,
   short                      *input );

/*VDGetSoundInputDriver

Retrieves information about a video digitizer's sound input driver.

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
soundDriverName

A pointer to a string. The video digitizer returns the name of its sound input driver. If the digitizer does not have an associated driver, it returns a result code of digiUnimpErr.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDGetSoundInputDriver (
   VideoDigitizerComponent    ci,
   Str255                     soundDriverName );

/*VDGetDataRate

Retrieves information that describes the performance capabilities of a video digitizer.

VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
milliSecPerFrame

A pointer to a long integer. The video digitizer returns a value that indicates the number of milliseconds of synchronous overhead involved in digitizing a single frame. This value includes the average delay incurred between the time when the digitizer requests a frame from its associated device, and the time at which the device delivers the frame.
framesPerSecond

A pointer to a fixed value. The video digitizer supplies the maximum rate at which it can capture video. Note that this value may differ from the rate that the application set with VDSetFrameRate.
bytesPerSecond

A pointer to a long integer. Video digitizers that can return compressed image data return a value that indicates the approximate number of bytes per second that the digitizer is generating compressed data, given the current compression and frame rate settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetDataRate (
   VideoDigitizerComponent    ci,
   long                       *milliSecPerFrame,
   Fixed                      *framesPerSecond,
   long                       *bytesPerSecond );


/*VDGetImageDescription

Retrieves an ImageDescription structure from a video digitizer.

VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc );
Parameters
ci

Identifies the application's connection to the video digitizer component. An application obtains this value from OpenComponent or OpenDefaultComponent.
desc

A handle. The video digitizer fills this handle with an ImageDescription structure containing information about the digitizer's current compression settings. The digitizer resizes the handle appropriately. It is the application's responsibility to dispose of this handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetImageDescription (
   VideoDigitizerComponent    ci,
   ImageDescriptionHandle     desc );



/*VDGetCurrentFlags

Returns status information about a specified video digitizer component.

VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
inputCurrentFlag

A pointer to a long integer that is to receive the current input state flags for the video digitizer component; see Video Digitizer Capabilities.
outputCurrentFlag

A pointer to a long integer that is to receive the current output state flags for the video digitizer component; see Video Digitizer Capabilities.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is often more convenient than VDGetDigitizerInfo. For example, this function provides a simple mechanism for determining whether a video digitizer is receiving a valid input signal. An application can retrieve the current input state flags and test the high-order bit by examining the sign of the returned value. If the value is negative (that is, the high-order bit, digiInSignalLock, is set to 1), the digitizer component is receiving a valid input signal.
Special Considerations

All video digitizer components must support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetCurrentFlags (
   VideoDigitizerComponent    ci,
   long                       *inputCurrentFlag,
   long                       *outputCurrentFlag );




/*MovieExportSetSettingsFromAtomContainer

Sets the movie export component's current configuration from passed settings data.

ComponentResult MovieExportSetSettingsFromAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

A QT atom container that contains the settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The atom container may contain atoms other than those expected by the particular component type or may be missing certain atoms. This function uses only those settings it understands.

Here is sample code that overrides compression settings:// MovieExportSetSettingsFromAtomContainer coding example
ComponentInstance sc;
QTAtomContainer compressorData;
SCSpatialSettings ss;
sc =OpenDefaultComponent(StandardCompressionType,
                             StandardCompressionSubType);
ss.codecType =kCinepakCodecType;
ss.codec =NIL;
ss.depth =0;
ss.spatialQuality =codecHighQuality
err =SCSetInfo(sc, scSpatialSettingsType, &ss);
err =SCGetSettingsAsAtomContainer(sc, &compressorData);
MovieExportSetSettingsFromAtomContainer (qtvrExport, compressorData);

Special Considerations

Some movie export components treat sample descriptions as part of their settings. If your application attempts to set the sample description using MovieExportSetSampleDescription, and receives the badComponentSelector error, you may need to pass in the SampleDescription structure using this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetSettingsFromAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         settings );

/*SGGrabCompressComplete

Provides the default behavior for your grab-compress-complete function.

ComponentResult SGGrabCompressComplete (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *tr );
Parameters
c

The connection identifier for the channel for this operation. The sequence grabber provides this value to your grab-compress-complete function.
queuedFrameCount

A pointer to the number of queued frames yet to be done. 0 means no frames. Some VDIGs may return 2 even if more than 2 frames are available, and some will return 1 if any number more than 0 are available.
ci

A pointer to an SGCompressInfo structure. When the operation is complete, the function fills in this structure with information about the compression operation.
tr

A pointer to a TimeRecord structure. When the operation is complete, the function uses this structure to indicate when the frame was grabbed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By setting the SGGrabCompressCompleteBottleProc callback and calling this function, your application can determine how many frames are currently queued in the VDIG, which can be useful for real-time processing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabCompressComplete (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *tr );


/*SGGetTimeBase

Retrieves a reference to the time base that is being used by a sequence grabber component.

ComponentResult SGGetTimeBase (
   SeqGrabComponent    s,
   TimeBase            *tb );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
tb

A pointer to a time base identifier, such as that returned by NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetTimeBase (
   SeqGrabComponent    s,
   TimeBase            *tb );

/*SGGetVideoDigitizerComponent

Determines the video digitizer component that is providing source video to a video channel component.

ComponentInstance SGGetVideoDigitizerComponent (
   SGChannel    c );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
Return Value

A component instance that identifies the connection between your video channel component and its video digitizer component. If your video channel component does not use a video digitizer component, set this returned value to NIL.
Discussion

This function allows the sequence grabber component to determine the video digitizer component that is providing source video to your video channel component. For example, the sequence grabber component can use this function to obtain access to the video digitizer component so that the grabber component can set the digitizer's parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentInstance SGGetVideoDigitizerComponent (
   SGChannel    c );

/*SGGetAlignmentProc

Obtains information about the best screen positions for a sequence grabber's video image in terms of appearance and maximum performance.

ComponentResult SGGetAlignmentProc (
   SeqGrabComponent             s,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
alignmentProc

A pointer to an ICMAlignmentProcRecord structure. The sequence grabber places its alignment information into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetAlignmentProc (
   SeqGrabComponent             s,
   ICMAlignmentProcRecordPtr    alignmentProc );

/*SGSetVideoRect

Specifies a part of the source video image that is to be captured by a sequence grabber component.

ComponentResult SGSetVideoRect (
   SGChannel     c,
   const Rect    *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to the Rect structure that defines the portion of the source video image to be captured. This rectangle must lie within the boundaries of the source video boundary rectangle, which the sequence grabber can obtain by calling SGGetSrcVideoBounds. If you do not use this function to set a source rectangle, the sequence grabber component captures the entire video image, as defined by the source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetVideoRect (
   SGChannel     c,
   const Rect    *r );


/*SGGetVideoBottlenecks

Determines the callback functions that have been assigned to a video channel.

ComponentResult SGGetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
vb

A pointer to a VideoBottles structure. This function sets the fields of that structure to indicate the callback functions that have been assigned to this video channel. You must set the procCount field in the VideoBottles structure to 9.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );

/*NewSGDataUPP

Allocates a Universal Procedure Pointer for the SGDataProc callback.

SGDataUPP NewSGDataUPP (
   SGDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SGDataUPP NewSGDataUPP (
   SGDataProcPtr    userRoutine );

/*SGGetChannelTimeBase

Retrieves a reference to the time base that is being used by a sequence grabber channel.

ComponentResult SGGetChannelTimeBase (
   SGChannel    c,
   TimeBase     *tb );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
tb

A pointer to a time base identifier, such as that returned by NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelTimeBase (
   SGChannel    c,
   TimeBase     *tb );


/*SGSetFrameRate

Specifies a video channel's frame rate for recording.

ComponentResult SGSetFrameRate (
   SGChannel    c,
   Fixed        frameRate );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
frameRate

The desired frame rate. If this parameter is set to 0, use your channel's default frame rate. Typically, this corresponds to the fastest rate that your channel can support.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetFrameRate (
   SGChannel    c,
   Fixed        frameRate );

/*SGSetVideoBottlenecks

Assigns callback functions to a video channel.

ComponentResult SGSetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );
Parameters
c

The connection identifier for the video channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
vb

A pointer to a VideoBottles structure, which identifies the callback functions to be assigned to the video channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );



/*NewSGGrabCompressCompleteBottleUPP

Allocates a Universal Procedure Pointer for the SGGrabCompressCompleteBottleProc callback.

SGGrabCompressCompleteBottleUPP NewSGGrabCompressCompleteBottleUPP (
   SGGrabCompressCompleteBottleProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGGrabCompressCompleteBottleProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SGGrabCompressCompleteBottleUPP NewSGGrabCompressCompleteBottleUPP (
   SGGrabCompressCompleteBottleProcPtr    userRoutine );

/*SCGetInfo

Retrieves configuration information from the standard dialog component.

ComponentResult SCGetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
infoType

A constant (see below) that specifies the type of information you want to retrieve. See these constants: 
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
scColorTableType
scProgressProcType
scExtendedProcsType
scPreferenceFlagsType
scSettingsStateType
scSequenceIDType
scWindowPositionType
scCodecFlagsType
info

A pointer to a field that is to receive the information. The infoType constant descriptions (see below) include information about this field.
Return Value

See Error Codes. If the component cannot satisfy your request, it returns a result code of scTypeNotFoundErr. It returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );


/*SCSetInfo

Modifies the standard dialog component's configuration information.

ComponentResult SCSetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
infoType

A constant (see below) that specifies the type of information you want to set. See these constants: 
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
scColorTableType
scProgressProcType
scExtendedProcsType
scPreferenceFlagsType
scSettingsStateType
scSequenceIDType
scWindowPositionType
scCodecFlagsType
info

A pointer to a field that contains the new information. The infoType constant descriptions (see below) include information about this field.
Return Value

See Error Codes. If the component cannot satisfy your request, it returns a result code of scTypeNotFoundErr. It returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCSetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );

/*SCSetTestImagePixMap

Sets the dialog box's test image from a Picture structure that is stored in a PixMap structure.

ComponentResult SCSetTestImagePixMap (
   ComponentInstance    ci,
   PixMapHandle         testPixMap,
   Rect                 *testRect,
   short                testFlags );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
testPixMap

A handle to a PixMap structure that contains the new test image. Your application is responsible for creating this structure before calling the function. You must also dispose of the structure when you are done with it. You must clear the image or close your connection to the standard image-compression dialog component before you dispose of the structure.
testRect

A pointer to a Rect structure. This rectangle specifies, in the coordinate system of the source image, the area of interest or point of interest in the test image. The area of interest defines a portion of the test image that is to be shown to the user in the dialog box. Use this parameter to direct the component to a specific portion of the test image. The component uses the value of the testFlags parameter to determine how it transforms large images before displaying them to the user.
testFlags

Constants (see below) that specify how the component is to display a test image that is larger than the test image portion of the dialog box. If you set this parameter to 0, the component uses a default method of its own choosing. In all cases, the component centers the area or point of interest in the test image portion of the dialog box, and then displays some part of the test image. See these constants: 
scPreferCropping
scPreferScaling
scPreferScalingAndCropping
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCSetTestImagePixMap (
   ComponentInstance    ci,
   PixMapHandle         testPixMap,
   Rect                 *testRect,
   short                testFlags );

/*SCDefaultPixMapSettings

Derives default compression settings for an image that is stored in a pixel map.

ComponentResult SCDefaultPixMapSettings (
   ComponentInstance    ci,
   PixMapHandle         src,
   short                motion );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be analyzed.
motion

Specifies whether the image is part of a sequence. Set this parameter to TRUE if the image is part of a sequence; set it to FALSE if you are working with a single still image.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCDefaultPixMapSettings (
   ComponentInstance    ci,
   PixMapHandle         src,
   short                motion );

/*SCRequestSequenceSettings

Displays the standard sequence dialog box to the user and shows default settings you have established.

ComponentResult SCRequestSequenceSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use SCRequestSequenceSettings to retrieve the user's preferences for compressing an image sequence; use SCRequestImageSettings when you are working with a single image. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestSequenceSettings (
   ComponentInstance    ci );

/*SCPositionRect

Positions a rectangle on the screen.

ComponentResult SCPositionRect (
   ComponentInstance    ci,
   Rect                 *rp,
   Point                *where );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
rp

A pointer to a Rect structure. When you call the function, this structure should contain the rectangle's current global coordinates. The function adjusts the coordinates in the structure to reflect the rectangle's new position.
where

A pointer to a Point structure identifying the desired location of the upper-left corner of the rectangle in global coordinates. This parameter allows your application to position the rectangle on the screen.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCPositionRect (
   ComponentInstance    ci,
   Rect                 *rp,
   Point                *where );

/*SCCompressSequenceBegin

Initiates a sequence-compression operation.

ComponentResult SCCompressSequenceBegin (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed. This pixel map must contain the first image in the sequence.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire structure, set this parameter to NIL.
desc

A pointer to an image description handle. The standard dialog component creates an image description structure when it compresses the image, and returns a handle to that structure in the field referred to by this parameter. The component sizes the handle appropriately. If you do not want this information, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCCompressSequenceBegin (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc );

/*SCCompressSequenceFrame

Continues a sequence-compression operation.

ComponentResult SCCompressSequenceFrame (
   ComponentInstance    ci,
   PixMapHandle         src,
   const Rect           *srcRect,
   Handle               *data,
   long                 *dataSize,
   short                *notSyncFlag );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire pixel map, set this parameter to NIL.
data

A pointer to a handle. The standard compression component returns a handle to the compressed image data in the field referred to by this parameter. The component sizes that handle appropriately for the sequence.
dataSize

A pointer to a long integer. The standard compression component returns a value that indicates the number of bytes of compressed image data that it returns. Note that this value will differ from the size of the handle referred to by the data parameter, because the handle is allocated to accommodate the largest image in the sequence.
notSyncFlag

A pointer to a short integer that indicates whether the compressed frame is a key frame. If the frame is a key frame, the standard compression component sets the field referred to by this parameter to 0; otherwise, the component sets this field to mediaSampleNotSync. You may use this field to set the sampleFlags parameter of the AddMediaSample function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function once for each frame in the sequence, including the first frame.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCCompressSequenceFrame (
   ComponentInstance    ci,
   PixMapHandle         src,
   const Rect           *srcRect,
   Handle               *data,
   long                 *dataSize,
   short                *notSyncFlag );

/*SCCompressSequenceEnd

Ends a sequence-compression operation.

ComponentResult SCCompressSequenceEnd (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The standard dialog component disposes of any memory it used to compress the image sequence, including the data and image description buffers. You must call this function once for each sequence you start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressSequenceEnd (
   ComponentInstance    ci );

/*MovieImportFile

Imports data from a file, using a movie data import component.

ComponentResult MovieImportFile (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to the file that contains the data that is to be imported into the movie. This file's type value corresponds to your component's subtype value.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to add sample data to the target movie or to obtain information about the movie.
targetTrack

The track that is to receive the imported data. This track identifier is supplied by the Movie Toolbox and is valid only if the movieImportMustUseTrack flag in the inFlags parameter is set to 1.
usedTrack

A pointer to the track that received the imported data. Your component returns this track identifier to the Movie Toolbox. Your component needs to set this parameter only if you operate on a single track or if you create a new track. If you modify more than one track, leave the field referred to by this parameter unchanged.
atTime

The time corresponding to the location where your component is to place the imported data. This time value is expressed in the movie's time coordinate system.
addedDuration

A pointer to the duration of the data that your component added to the movie. Your component must specify this value in the movie's time coordinate system.
inFlags

Flags (see below) that specify control information governing the import operation. See these constants: 
movieImportCreateTrack
movieImportMustUseTrack
movieImportInParallel
outFlags

Flags (see below) that identify a field that is to receive status information about the import operation. Your component sets the appropriate flags in this field when the operation is complete. See these constants: 
movieImportResultUsedMultipleTracks
movieImportInParallel
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component must be prepared to perform this function at any time. You should not expect that any of your component's configuration functions will be called first. If your component can accept data from a file, be sure to set the canMovieImportFiles flag in the componentFlags field of your component's ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult MovieImportFile (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags );

/*SCSetSettingsFromAtomContainer

Sets the standard image-compression component's current configuration from data in a QT atom container.

ComponentResult SCSetSettingsFromAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      settings );
Parameters
ci

Standard compression component instance.
settings

A QT atom container reference to the settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The settings QT atom container may contain atoms other than those expected by the particular component type or may be missing certain atoms. The function will only use settings it understands.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCSetSettingsFromAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      settings );

/*SCGetSettingsAsAtomContainer

Places the current configuration from the standard image-compression component in a QT atom container.

ComponentResult SCGetSettingsAsAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      *settings );
Parameters
ci

The standard compression component instance.
settings

The address where the newly-created atom container should be stored.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetSettingsAsAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      *settings );

/*NewSCModalHookUPP

Allocates a Universal Procedure Pointer for the SCModalHookProc callback.

SCModalHookUPP NewSCModalHookUPP (
   SCModalHookProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSCModalHookProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


SCModalHookUPP NewSCModalHookUPP (
   SCModalHookProcPtr    userRoutine );

/*SCPositionDialog

Helps position a dialog box on the screen.

ComponentResult SCPositionDialog (
   ComponentInstance    ci,
   short                id,
   Point                *where );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
id

The resource number of a 'DLOG' resource. The function positions the dialog box that corresponds to this resource.
where

A pointer to a Point structure identifying the desired location of the upper-left corner of the dialog box in global coordinates. This parameter allows you to indicate how you want to position the dialog box on the screen.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


ComponentResult SCPositionDialog (
   ComponentInstance    ci,
   short                id,
   Point                *where );

/*SCGetCompressionExtended

Undocumented

ComponentResult SCGetCompressionExtended (
   ComponentInstance    ci,
   SCParams             *params,
   Point                where,
   SCModalFilterUPP     filterProc,
   SCModalHookUPP       hookProc,
   long                 refcon,
   StringPtr            customName );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
params

A pointer to an SCParams structure.
where

Undocumented
filterProc

A Universal Procedure Pointer that accesses a SCModalFilterProc callback.
hookProc

A Universal Procedure Pointer that accesses a SCModalHookProc callback.
refcon

A reference constant to be passed to your callbacks. Use this parameter to point to a data structure containing any information your callbacks need.
customName

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetCompressionExtended (
   ComponentInstance    ci,
   SCParams             *params,
   Point                where,
   SCModalFilterUPP     filterProc,
   SCModalHookUPP       hookProc,
   long                 refcon,
   StringPtr            customName );

/*VDGetBlackLevelValue

Returns the current black level value.

VideoDigitizerError VDGetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
blackLevel

A pointer to an integer field that is to receive the current black level value. Black level values range from 0 to 65,535, where 0 represents the maximum black value and 65,535 represents the minimum black value.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );

/*VDSetBlackLevelValue

Sets the current black level value.

VideoDigitizerError VDSetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
blackLevel

A pointer to an integer that contains the new black level value. Black level values range from 0 to 65,535, where 0 represents the maximum black value and 65,535 represents the minimum black value. The digitizer component returns the new value, so that the application can avoid using unsupported values in future requests.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDSetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );

/*MovieExportSetSampleDescription

Requests the format of the exported data.

ComponentResult MovieExportSetSampleDescription (
   MovieExportComponent       ci,
   SampleDescriptionHandle    desc,
   OSType                     mediaType );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
desc

A handle to a valid SampleDescription structure.
mediaType

The type of media the SampleDescription structure is for. For example, if the sample description was a sound description, this parameter would be set to SoundMediaType.
Return Value

See Error Codes. Returns badComponentSelector if you should be passing a QT atom container (see discussion, below). Returns noErr if there is no error.
Discussion

A movie export component may use all, some, or none of the settings from the SampleDescription structure.

If your application attempts to set the sample description using this function, and receives the badComponentSelector error, you may need to pass in the sample description using MovieExportSetSettingsFromAtomContainer. You can use MovieExportGetSettingsAsAtomContainer to obtain a correctly formatted atom container to modify.
Special Considerations

This function is not implemented by all movie export components, but is supported by the sound movie export component, for example.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetSampleDescription (
   MovieExportComponent       ci,
   SampleDescriptionHandle    desc,
   OSType                     mediaType );

/*SGUpdate

Informs your component about update events, to update its display.

ComponentResult SGUpdate (
   SeqGrabComponent    s,
   RgnHandle           updateRgn );
Parameters
s

An instance of the sequence grabber component connected to your channel component. The sequence grabber component provides this value through SGInitChannel.
updateRgn

Indicates the part of the window that has been changed. 
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can determine the part of the window that has been changed by examining the appropriate window record. For example, they may call the sequence grabber in this manner:SGUpdate (theSG, ((WindowPeek)updateWindow)->
updateRgn);

Special Considerations

Your application should avoid drawing where the sequence grabber is displaying video. Doing so may cause some video digitizer components to stop displaying video.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGUpdate (
   SeqGrabComponent    s,
   RgnHandle           updateRgn );

/*SGSetChannelVolume

Sets a channel's sound volume.

ComponentResult SGSetChannelVolume (
   SGChannel    c,
   short        volume );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
volume

The volume setting of your channel represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetChannelVolume (
   SGChannel    c,
   short        volume );

/*SGSetAdditionalSoundRates

Specifies a list of sound sample rates to be included in the sequence grabber's sound settings dialog box.

ComponentResult SGSetAdditionalSoundRates (
   SGChannel    c,
   Handle       rates );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
rates

A handle containing a list of unsigned 32-bit fixed-point values. The sequence grabber channel determines the number of sample rates contained in the handle, based on the size of the handle. If any of the requested rates are not supported directly by the available sound capture hardware, sound will be captured at one of the available hardware rates and then converted in software to the requested rate.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The sequence grabber channel makes a copy of the additional rates handle, so your application can immediately dispose of it after making this call.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetAdditionalSoundRates (
   SGChannel    c,
   Handle       rates );

/*SGGrabPict

Lets your application obtain a Picture structure from a sequence grabber component.

ComponentResult SGGrabPict (
   SeqGrabComponent    s,
   PicHandle           *p,
   const Rect          *bounds,
   short               offscreenDepth,
   long                grabPictFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
p

A pointer to a field that is to receive a handle to the Picture structure. If the function cannot create the structure, it sets this handle to NIL.
bounds

A pointer to the boundary region for the Picture structure. By default, this rectangle lies in the current graphics port. If you set the grabPictOffScreen flag in the grabPictFlags parameter to 1, the sequence grabber places the structure in an offscreen graphics world. In this case, the rectangle is interpreted in that offscreen world.
offscreenDepth

The pixel depth for the offscreen graphics world. This parameter is typically set to 0, which chooses the best available depth. If you set the grabPictOffScreen flag in the grabPictFlags parameter to 1, the sequence grabber places the Picture structure in an offscreen graphics world. You specify the pixel depth of this offscreen graphics world with this parameter. If you are displaying the picture, this parameter is ignored.
grabPictFlags

Contains flags (see below) that control the operation. See these constants: 
grabPictOffScreen
grabPictIgnoreClip
grabPictCurrentImage
Return Value

See Error Codes. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabPict (
   SeqGrabComponent    s,
   PicHandle           *p,
   const Rect          *bounds,
   short               offscreenDepth,
   long                grabPictFlags );

/*SGNewOutput

Creates a new sequence grabber output.

ComponentResult SGNewOutput (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags,
   SGOutput            *sgOut );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
dataRef

A handle to the destination container.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set the parameter to rAliasType.
whereFlags

Flags (see below) that control the record operation. You must set either seqGrabToDisk or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
sgOut

A pointer to a sequence grabber output. The sequence grabber component returns an output identifier that you can use with other sequence grabber component functions.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Once you have created the sequence grabber output, you can use SGSetChannelOutput to assign the output to a sequence grabber channel.
Version Notes

A sequence grabber output ties a sequence grabber channel to a specified data reference for the output of captured data. If you are capturing to a single movie file, you can continue to use SGSetDataOutput or SGSetDataRef to specify the sequence grabber's destination. However, if you want to capture movie data into several different files or data references, you must use sequence grabber outputs to do so. Even if you are using outputs, you must still use SGSetDataOutput or SGSetDataRef to identify where the sequence grabber should create the movie resource. You are responsible for creating outputs, assigning them to sequence grabber channels, and disposing of them when you are done.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGNewOutput (
   SeqGrabComponent    s,
   Handle              dataRef,
   OSType              dataRefType,
   long                whereFlags,
   SGOutput            *sgOut );

/*SGSetDataOutput

Specifies the movie file and options for a sequence grabber record operation.

ComponentResult SGSetDataOutput (
   SeqGrabComponent    s,
   const FSSpec        *movieFile,
   long                whereFlags );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
movieFile

A pointer to the FSSpec structure that identifies the movie file for this record operation.
whereFlags

Contains flags (see below) that control the record operation. You must set either seqGrabToDisk flag or seqGrabToMemory to 1. Set unused flags to 0. See these constants: 
seqGrabToDisk
seqGrabToMemory
seqGrabDontUseTempMemory
seqGrabAppendToFile
seqGrabDontAddMovieResource
seqGrabDontMakeMovie
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetDataOutput (
   SeqGrabComponent    s,
   const FSSpec        *movieFile,
   long                whereFlags );

/*SGGetVideoRect

Determines the portion of the source video image that is to be captured.

ComponentResult SGGetVideoRect (
   SGChannel    c,
   Rect         *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to a Rect structure that is to receive the dimensions of the rectangle that defines the portion of the source video image your component is going to capture.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetVideoRect (
   SGChannel    c,
   Rect         *r );

/*SGSetChannelOutput

Assigns an output to a channel.

ComponentResult SGSetChannelOutput (
   SeqGrabComponent    s,
   SGChannel           c,
   SGOutput            sgOut );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sgOut

Identifies the sequence grabber output for this operation. You obtain this identifier by calling SGNewOutput.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to assign an output to a channel. One output may be assigned to one or more channels. Note that when you call SGSetDataRef or SGSetDataOutput the sequence grabber component sets every channel to the specified file or container. If you want to use different outputs, you must use this function to assign the channels appropriately.
Version Notes

A sequence grabber output ties a sequence grabber channel to a specified data reference for the output of captured data. If you are capturing to a single movie file, you can continue to use SGSetDataOutput or SGSetDataRef to specify the sequence grabber's destination. However, if you want to capture movie data into several different files or data references, you must use sequence grabber outputs to do so. Even if you are using outputs, you must still use SGSetDataOutput or SGSetDataRef to identify where the sequence grabber should create the movie resource. You are responsible for creating outputs, assigning them to sequence grabber channels, and disposing of them when you are done.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelOutput (
   SeqGrabComponent    s,
   SGChannel           c,
   SGOutput            sgOut );

/*NewSGModalFilterUPP

Allocates a Universal Procedure Pointer for the SGModalFilterProc callback.

SGModalFilterUPP NewSGModalFilterUPP (
   SGModalFilterProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGModalFilterProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

SGModalFilterUPP NewSGModalFilterUPP (
   SGModalFilterProcPtr    userRoutine );

/*DisposeSGModalFilterUPP

Disposes of an SGModalFilterUPP pointer.

void DisposeSGModalFilterUPP (
   SGModalFilterUPP    userUPP );
Parameters
userUPP

An SGModalFilterUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeSGModalFilterUPP (
   SGModalFilterUPP    userUPP );

/*MovieImportDoUserDialog

Requests that a component display its user dialog box.

ComponentResult MovieImportDoUserDialog (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Handle                  theData,
   Boolean                 *canceled );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to a valid file specification. If the import request pertains to a file, the application must specify the source file with this parameter and set the theData parameter to NIL. If the request is for a handle, this parameter is set to NIL.
theData

A handle to the data to be imported. If the import request pertains to a handle, the application must specify the source of the data with this parameter, and set the theFile parameter to NIL. If the request is for a file, this parameter is set to NIL.
canceled

A pointer to a Boolean value. Your component should set this value to TRUE if the user cancels the dialog box; otherwise, set it to FALSE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If your component supports a user dialog box, be sure to set the hasMovieImportUserInterface flag in the componentFlags field of your component's ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportDoUserDialog (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Handle                  theData,
   Boolean                 *canceled );

/*PreviewShowData

Displays a preview if it does not handle events.

ComponentResult PreviewShowData (
   pnotComponent    p,
   OSType           dataType,
   Handle           data,
   const Rect       *inHere );
Parameters
p

Specifies your preview component. You obtain this identifier from OpenComponent.
dataType

The type of handle pointing to the data to be displayed in the preview.
data

A handle to the data, which is typically the same as the subtype of your preview component.
inHere

A pointer to a Rect structure that defines the area into which you draw the preview. The current port is set to the correct graphics port for drawing. You must not draw outside the given rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult PreviewShowData (
   pnotComponent    p,
   OSType           dataType,
   Handle           data,
   const Rect       *inHere );

/*SCCompressImage

Compresses an image that is stored in a PixMap structure.

ComponentResult SCCompressImage (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc,
   Handle                    *data );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire pixel map, set this parameter to NIL.
desc

A pointer to a handle to an ImageDescription structure. The standard dialog component creates an ImageDescription structure when it compresses the image, and returns a handle to that structure in the field referred to by this parameter. The component sizes that handle appropriately. Your application is responsible for disposing of that handle when you are done with it.
data

A pointer to a handle. The standard dialog component returns a handle to the compressed image data in the field referred to by this parameter. The component sizes that handle appropriately. Your application is responsible for disposing of that handle when you are done with it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressImage (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc,
   Handle                    *data );

/*NewSCModalFilterUPP

Allocates a Universal Procedure Pointer for the SCModalFilterProc callback.

SCModalFilterUPP NewSCModalFilterUPP (
   SCModalFilterProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSCModalFilterProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SCModalFilterUPP NewSCModalFilterUPP (
   SCModalFilterProcPtr    userRoutine );

/*
DisposeSGDataUPP

Disposes of an SGDataUPP pointer.

void DisposeSGDataUPP (
   SGDataUPP    userUPP );
Parameters
userUPP

An SGDataUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeSGDataUPP (
   SGDataUPP    userUPP );


#ifdef __cplusplus
}
#endif


#endif