#include <CommonPanels/CommonPanels.h>

/*NPickColor

Displays the Color Picker dialog.

OSErr NPickColor (
   NColorPickerInfo * theColorInfo
);
Parameters
theColorInfo

A pointer to a color picker parameter (NColorPickerInfo) data structure. On input, you specify information such as the location of the dialog. On output, the data structure specifies information such as whether the user changed the color. 
Return Value

A result code. See “Color Picker Result Codes”.
Discussion

The NPickColor function displays the standard dialog for color pickers. Use the color picker parameter data structure to specify information to and obtain information from the Color Picker Manager. 
Availability
Available in CarbonLib 1.0 and later when ColorPicker 2.1 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This call is identical to the unsupported function PickColor , but it replaces the older ColorSync 1.0 data types with new ColorSync 2.x profile references. When filling out the parameter block for a call to the function NPickColor, you must replace all profile handles with profile references. The optional color-changed proc you has also changed; a new data structure NCMColor replaces the CMColor data type and uses profile references.
Declared In
ColorPicker.h*/
OSErr NPickColor (
   NColorPickerInfo * theColorInfo
){};


/*NewUserEventUPP

Creates a universal procedure pointer (UPP) to an event filter callback.

UserEventUPP NewUserEventUPP (
   UserEventProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the UserEventUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/
UserEventUPP NewUserEventUPP (
   UserEventProcPtr userRoutine
){};


/*PickColor

Requests the user to choose a color from the standard color picker dialog box.

OSErr PickColor (
   ColorPickerInfo * theColorInfo
);
Parameters
theColorInfo

A pointer to the ColorPickerInfo (Old) structure, to specify information to and obtain information from the Color Picker Manager. 
Return Value

A result code. See “Color Picker Result Codes”.
Discussion

The PickColor function displays the standard modal dialog box for color pickers. When the user clicks the OK button, PickColor removes the dialog box and returns true in the newColorChosen field and the user’s selected color in the theColor field of theColorInfo. When the user clicks the Cancel button, PickColor removes the dialog box and returns false in the newColorChosen field. 
Availability
Available in CarbonLib 1.0 and later when ColorPicker 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/

OSErr PickColor (
   ColorPickerInfo * theColorInfo
){};



