#import <CoreData/NSEntityDescription.h>

 @implementation  NSEntityDescription 

/*entityForName:inManagedObjectContext:

Returns the entity with the specified name from the managed object model associated with the specified managed object context’s persistent store coordinator.

+ (NSEntityDescription *)entityForName:(NSString *)entityName inManagedObjectContext:(NSManagedObjectContext *)context
Parameters
entityName

The name of an entity.
context

The managed object context to use.
Return Value

The entity with the specified name from the managed object model associated with the context’s persistent store coordinator.
Discussion

This method is functionally equivalent to the following code example.NSManagedObjectModel *managedObjectModel = [[context persistentStoreCoordinator] managedObjectModel];
NSEntityDescription *entity = [[managedObjectModel entitiesByName]  objectForKey:entityName];
return entity;

Availability
Available in Mac OS X v10.4 and later.
See Also
– entitiesByName*/

+ (NSEntityDescription *)entityForName:(NSString *)entityName inManagedObjectContext:(NSManagedObjectContext *)context{}

/*insertNewObjectForEntityForName:inManagedObjectContext:

Creates, configures, and returns a new autoreleased instance of the class for the entity with a given name.

+ (NSManagedObject *)insertNewObjectForEntityForName:(NSString *)entityName inManagedObjectContext:(NSManagedObjectContext *)context
Parameters
entityName

The name of an entity.
context

The managed object context to use.
Return Value

A new fully configured instance of the class for the entity named entityName. The instance has its entity description set and is inserted it into context.
Discussion

Note that despite the word “new” in the method name, the object returned is autoreleased. (“New” in this case refers to an instance of a class other than the receiver, so the method name does not follow the usual Cocoa naming convention.)

This method makes it easier for you to create instances of a given entity without having to know the class used to represent the entity, which may be particularly useful early in the development life-cycle when classes and class names are volatile. It also takes care of the details of managed object creation.

The method is conceptually similar to the following code example.NSManagedObjectModel *managedObjectModel =
        [[context persistentStoreCoordinator] managedObjectModel];
NSEntityDescription *entity =
        [[managedObjectModel entitiesByName]  objectForKey:entityName];
NSString *className = [entity managedObjectClassName];
Class entityClass = [[NSBundle mainBundle] classNamed:className];
newObject = [[entityClass alloc]
        initWithEntity:entity insertIntoManagedObjectContext:  context];
return [newObject autorelease];


Note that, as the preceding code sample implies, in many applications there is no need to explicitly assign a new managed object to a specific persistent store—see assignObject:toPersistentStore:.
Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithEntity:insertIntoManagedObjectContext:*/

+ (NSManagedObject *)insertNewObjectForEntityForName:(NSString *)entityName inManagedObjectContext:(NSManagedObjectContext *)context{}


/*userInfo

Returns the user info dictionary of the receiver.

- (NSDictionary *)userInfo
Return Value

The receiver's user info dictionary.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setUserInfo:*/
- (NSDictionary *)userInfo{}


/*isAbstract

Returns a Boolean value that indicates whether the receiver represents an abstract entity.

- (BOOL)isAbstract
Return Value

YES if the receiver represents an abstract entity, otherwise NO.
Discussion

An abstract entity might be Shape, with concrete sub-entities such as Rectangle, Triangle, and Circle.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setAbstract:I*/
- (BOOL)isAbstract{}


/*relationshipsByName

Returns the relationships of the receiver in a dictionary, where the keys in the dictionary are the relationship names.

- (NSDictionary *)relationshipsByName
Return Value

The relationships of the receiver in a dictionary, where the keys in the dictionary are the relationship names and the values are instances of NSRelationshipDescription.
Availability
Available in Mac OS X v10.4 and later.
See Also
– attributesByName
– propertiesByName
– relationshipsWithDestinationEntity:*/
- (NSDictionary *)relationshipsByName{}




/*attributesByName

Returns the attributes of the receiver in a dictionary, where the keys in the dictionary are the attribute names.

- (NSDictionary *)attributesByName
Return Value

The attributes of the receiver in a dictionary, where the keys in the dictionary are the attribute names and the values are instances of NSAttributeDescription. .
Availability
Available in Mac OS X v10.4 and later.
See Also
– propertiesByName
– relationshipsByName
– relationshipsWithDestinationEntity:*/
- (NSDictionary *)attributesByName{}


/*name

Returns the entity name of the receiver.

- (NSString *)name
Return Value

The entity name of receiver.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setName:*/
- (NSString *)name{}








@end

