#ifndef CFHTTPMESSAGE_H
#define CFHTTPMESSAGE_H

#ifndef CFSTRING_H
#include <CoreFoundation/CFString.h>
#endif

#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

#ifndef  CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFHTTP Version Constants

Sets the HTTP version in a CFHTTPMessage request or response object.

const CFStringRef kCFHTTPVersion1_0;const CFStringRef kCFHTTPVersion1_1;
Constants
kCFHTTPVersion1_0

Specifies HTTP version 1.0.

Available in Mac OS X version 10.1 and later.
kCFHTTPVersion1_1

Specifies HTTP version 1.1.

Available in Mac OS X version 10.1 and later.
Discussion

The HTTP version constants are used when you call CFHTTPMessageCreateRequest and CFHTTPMessageCreateResponse to create a request or response message.
Declared In
CFNetwork/CFHTTPMessage.h*/
const CFStringRef kCFHTTPVersion1_0;
const CFStringRef kCFHTTPVersion1_1;

/*CFHTTPMessageRef

An opaque reference representing an HTTP message.

typedef struct __CFHTTPMessage *CFHTTPMessageRef;
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
typedef struct __CFHTTPMessage *CFHTTPMessageRef;

/*CFHTTPMessageCreateRequest

Creates and returns a CFHTTPMessage object for an HTTP request.

CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
requestMethod

The request method for the request. Use any of the request methods allowed by the HTTP version specified by httpVersion.
url

The URL to which the request will be sent.
httpVersion

The HTTP version for this message. Pass kCFHTTPVersion1_0 or kCFHTTPVersion1_1.
Return Value

A new CFHTTPMessage object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a CFHTTPMessage object that you can use to build an HTTP request. Continue building the request by callingCFHTTPMessageSetBody to set the message’s body. Call CFHTTPMessageCopyHeaderFieldValue to set the message’s headers.

If you are using a CFReadStream object to send the message, call CFReadStreamCreateForHTTPRequest to create a read stream for the request. If you are not using CFReadStream, call CFHTTPMessageCopySerializedMessage to make the message ready for transmission by serializing it.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFHTTPMessageRef CFHTTPMessageCreateRequest (
    CFAllocatorRef allocator,
    CFStringRef requestMethod,
    CFURLRef url,
    CFStringRef httpVersion
);

/*CFHTTPMessageCreateResponse

Creates and returns a CFHTTPMessage object for an HTTP response.

CFHTTPMessageRef CFHTTPMessageCreateResponse (
    CFAllocatorRef allocator,
    int statusCode,
    CFStringRef statusDescription,
    CFStringRef httpVersion
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
statusCode

The status code for this message response. The status code can be any of the status codes defined in section 6.1.1 of RFC 2616.
statusDescription

The description that corresponds to the status code. Pass NULL to use the standard description for the given status code, as found in RFC 2616.
httpVersion

The HTTP version for this message response. Pass kCFHTTPVersion1_0 or kCFHTTPVersion1_1.
Return Value

A new CFHTTPMessage object, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a CFHTTPMessage object that you can use to build an HTTP response. Continue building the response by callingCFHTTPMessageSetBody to set the message’s body. Call CFHTTPMessageSetHeaderFieldValue to set the message’s headers. Then call CFHTTPMessageCopySerializedMessage to make the message ready for transmission by serializing it.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFHTTPMessageRef CFHTTPMessageCreateResponse (
    CFAllocatorRef allocator,
    int statusCode,
    CFStringRef statusDescription,
    CFStringRef httpVersion
);


/*CFHTTPMessageCopyHeaderFieldValue

Gets the value of a header field from a CFHTTPMessage object.

CFStringRef CFHTTPMessageCopyHeaderFieldValue (
    CFHTTPMessageRef message,
    CFStringRef headerField
);
Parameters
message

The message to examine.
headerField

The header field to copy.
Return Value

A CFString object containing a copy of the field specified by headerField, or NULL if there was a problem creating the object of if the specified header does not exist. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFStringRef CFHTTPMessageCopyHeaderFieldValue (
    CFHTTPMessageRef message,
    CFStringRef headerField
);

/*CFHTTPMessageSetBody

Sets the body of a CFHTTPMessage object.

void CFHTTPMessageSetBody (
CFHTTPMessageRef message,
CFDataRef bodyData);
Parameters
message

The message to modify.
bodyData

The data that is to be set as the body of the message.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

void CFHTTPMessageSetBody (
CFHTTPMessageRef message,
CFDataRef bodyData);

/*CFHTTPMessageSetHeaderFieldValue

Sets the value of a header field in an HTTP message.

void CFHTTPMessageSetHeaderFieldValue (
CFHTTPMessageRef message,
CFStringRef headerField,
CFStringRef value);
Parameters
message

The message to modify.
headerField

The header field to set.
value

The value to set.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
void CFHTTPMessageSetHeaderFieldValue (
CFHTTPMessageRef message,
CFStringRef headerField,
CFStringRef value);

/*CFHTTPMessageCopyRequestURL

Gets the URL from a CFHTTPMessage object.

CFURLRef CFHTTPMessageCopyRequestURL (
    CFHTTPMessageRef request
);
Parameters
request

The message to examine. This must be a request message.
Return Value

A CFURLRef object containing the URL or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFURLRef CFHTTPMessageCopyRequestURL (
    CFHTTPMessageRef request
);

/*CFHTTPMessageCreateEmpty

Creates and returns a new, empty CFHTTPMessage object.

CFHTTPMessageRef CFHTTPMessageCreateEmpty (
    CFAllocatorRef allocator,
    Boolean isRequest
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
isRequest

A flag that determines whether to create an empty message request or an empty message response. Pass TRUE to create an empty request message; pass FALSE to create an empty response message.
Return Value

A new CFHTTPMessage object or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

Call CFHTTPMessageAppendBytes to store an incoming, serialized HTTP request or response message in the empty message object.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFHTTPMessageRef CFHTTPMessageCreateEmpty (
    CFAllocatorRef allocator,
    Boolean isRequest
);

/*CFHTTPMessageCopyVersion

Gets the HTTP version from a CFHTTPMessage object.

CFStringRef CFHTTPMessageCopyVersion (
    CFHTTPMessageRef message
);
Parameters
message

The message to examine.
Return Value

A CFString object or NULL, if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFStringRef CFHTTPMessageCopyVersion (
    CFHTTPMessageRef message
);

/*CFHTTPMessageCopyRequestMethod

Gets the request method from a CFHTTPMessage object.

CFStringRef CFHTTPMessageCopyRequestMethod (
    CFHTTPMessageRef request
);
Parameters
request

The message to examine. This must be a request message.
Return Value

A CFString object containing a copy of the message’s request method, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFStringRef CFHTTPMessageCopyRequestMethod (
    CFHTTPMessageRef request
);


/*CFHTTPMessageCopySerializedMessage

Serializes a CFHTTPMessage object.

CFDataRef CFHTTPMessageCopySerializedMessage (
    CFHTTPMessageRef request
);
Parameters
request

The message to serialize.
Return Value

A CFData object containing the serialized message, or NULL if there was a problem creating the object. Ownership follows the Create Rule.
Discussion

This function returns a copy of a CFHTTPMessage object in serialized format that is ready for transmission.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/

CFDataRef CFHTTPMessageCopySerializedMessage (
    CFHTTPMessageRef request
);

/*CFHTTPMessageCopyBody

Gets the body from a CFHTTPMessage object.

CFDataRef CFHTTPMessageCopyBody (
    CFHTTPMessageRef message
);
Parameters
message

The message to examine.
Return Value

A CFData object or NULL if there was a problem creating the object or if the there is no message body. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
CFDataRef CFHTTPMessageCopyBody (
    CFHTTPMessageRef message
);

/*CFHTTPMessageIsHeaderComplete

Determines whether a message header is complete.

Boolean CFHTTPMessageIsHeaderComplete (
    CFHTTPMessageRef message
);
Parameters
message

The message to verify.
function result

TRUE if the message header is complete, otherwise FALSE.
Discussion

After calling CFHTTPMessageAppendBytes, call this function to see if the message header is complete.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
Boolean CFHTTPMessageIsHeaderComplete (
    CFHTTPMessageRef message
);

/*CFHTTPMessageAppendBytes

Appends data to a CFHTTPMessage object.

Boolean CFHTTPMessageAppendBytes (
CFHTTPMessageRef message,
const UInt8 *newBytes,
CFIndex numBytes);
Parameters
message

The message to modify.
newBytes

A reference to the data to append.
numBytes

The length of the data pointed to by newBytes.
Return Value

TRUE if the data was successfully appended, otherwise FALSE.
Discussion

This function appends the data specified by newBytes to the specified message object which was created by calling CFHTTPMessageCreateEmpty. The data is an incoming serialized HTTP request or response received from a client or a server. While appending the data, this function deserializes it, removes any HTTP-based formatting that the message may contain, and stores the message in the message object. You can then call CFHTTPMessageCopyVersion, CFHTTPMessageCopyBody, CFHTTPMessageCopyHeaderFieldValue, and CFHTTPMessageCopyAllHeaderFields to get the message’s HTTP version, the message’s body, a specific header field, and all of the message’s headers, respectively.

If the message is a request, you can also call CFHTTPMessageCopyRequestURL and CFHTTPMessageCopyRequestMethod to get the message’s request URL and request method, respectively.

If the message is a response, you can also call CFHTTPMessageGetResponseStatusCode and CFHTTPMessageCopyResponseStatusLine to get the message’s status code and status line, respectively.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
Boolean CFHTTPMessageAppendBytes (
CFHTTPMessageRef message,
const UInt8 *newBytes,
CFIndex numBytes);

/*CFHTTPMessageGetResponseStatusCode

Gets the status code from a CFHTTPMessage object representing an HTTP response.

UInt32 CFHTTPMessageGetResponseStatusCode (
    CFHTTPMessageRef response
);
Parameters
response

The message to examine. This must be a response message.
function result

The status code as defined by RFC 2616, section 6.1.1.
Availability
Available in Mac OS X version 10.1 and later.
Declared In
CFNetwork/CFHTTPMessage.h*/
UInt32 CFHTTPMessageGetResponseStatusCode (
    CFHTTPMessageRef response
);


#ifdef __cplusplus
}
#endif

#endif