#ifndef CGPDFDICTIONARY_H
#define CGPDFDICTIONARY_H


#include <CoreGraphics/CGDataProvider.h> 
#include <CoreGraphics/CGGeometry.h> 
#include <CoreGraphics/CGPDFPage.h> 
#include <CoreFoundation/CFURL.h>

/*CGPDFDocumentRef

Defines an opaque type that encapsulates PDF drawing information.

typedef struct CGPDFDocument * CGPDFDocumentRef;
Discussion

CGPDFDocumentRef defines an opaque type Quartz uses to represent PDF (Portable Document Format) documents. 

Note that PDF documents may be encrypted, and that some operations may be restricted until a valid password is supplied—see the functions listed in “Managing Encryption”.

In Mac OS X version 10.2 and later, CGPDFDocumentRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct CGPDFDocument * CGPDFDocumentRef;

//function

/*CGPDFDocumentCreateWithProvider

Creates a Quartz PDF document using a data provider.

CGPDFDocumentRef CGPDFDocumentCreateWithProvider (
CGDataProviderRef provider
);
Parameters
provider

A data provider that supplies the PDF document data. 
Return Value

A new Quartz PDF document, or NULL if a document could not be created. You are responsible for releasing the object using CGPDFDocumentRelease. 
Discussion

For information about drawing a PDF document in a graphics context, see CGContextDrawPDFDocument.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFDocument.h*/

CGPDFDocumentRef CGPDFDocumentCreateWithProvider (
CGDataProviderRef provider
);

/*CGPDFDocumentGetPage

Returns a page from a Quartz PDF document.

CGPDFPageRef CGPDFDocumentGetPage (
   CGPDFDocumentRef document,
   size_t pageNumber
);
Parameters
document

A PDF document.
pageNumber

The number of the page requested.
Return Value

Return the PDF page corresponding to the specified page number, or NULL if no such page exists in the document. Pages are numbered starting at 1.
Availability
Available in Mac OS X version 10.3 and later.
Declared In
CGPDFDocument.h*/

CGPDFPageRef CGPDFDocumentGetPage (
   CGPDFDocumentRef document,
   size_t pageNumber
);

/*CGPDFDocumentCreateWithURL

Creates a Quartz PDF document using data specified by a URL.

CGPDFDocumentRef CGPDFDocumentCreateWithURL (
   CFURLRef url
);
Parameters
url

The URL address at which the PDF document data is located. 
Return Value

A new Quartz PDF document, or NULL if a document could not be created. You are responsible for releasing the object using CGPDFDocumentRelease.
Discussion

For information about drawing a PDF document in a graphics context, see CGContextDrawPDFDocument.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFDocument.h*/
CGPDFDocumentRef CGPDFDocumentCreateWithURL (
   CFURLRef url
);

/*CGPDFDocumentGetNumberOfPages

Returns the number of pages in a PDF document.

size_t CGPDFDocumentGetNumberOfPages (
   CGPDFDocumentRef document
);
Parameters
document

The PDF document to examine. 
Return Value

The total number of pages in the PDF document.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFDocument.h*/
size_t CGPDFDocumentGetNumberOfPages (
   CGPDFDocumentRef document
);

/*CGPDFDocumentGetMediaBox

Returns the media box of a page in a PDF document. (Deprecated in Mac OS X version 10.3 and later.)

CGRect CGPDFDocumentGetMediaBox (
   CGPDFDocumentRef document,
   int page
);
Parameters
document

The PDF document to examine. 
page

An integer that specifies the number of the page to examine.
Return Value

A rectangle that represents the media box for the specified page, expressed in default PDF user space units (points). 
Discussion

The replacement function for this one is CGPDFPageGetBoxRect, which gets the rectangle associated with a type of box (art, media, crop, bleed trim) that represents a content region or page dimensions of a PDF page. For more information see CGPDFPage Reference.

The media box defines the location and size of the physical medium on which the page is intended to be displayed or printed. For example, if the page size is 8.5 by 11 inches, this function returns the coordinate pairs (0,0) and (612,792).
Availability
Available in Mac OS X version 10.0 and later.
Deprecated in Mac OS X version 10.3 and later.
Declared In
CGPDFDocument.h*/
CGRect CGPDFDocumentGetMediaBox (
   CGPDFDocumentRef document,
   int page
);

/*CGPDFDocumentRelease

Decrements the retain count of a PDF document.

void CGPDFDocumentRelease (
   CGPDFDocumentRef document
);
Parameters
document

The PDF document to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the document parameter is NULL.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGPDFDocument.h*/
void CGPDFDocumentRelease (
   CGPDFDocumentRef document
);

#endif