#import <Foundation/NSScriptCommand.h>

@class NSDictionary;
@class NSScriptObjectSpecifier;
@class NSScriptClassDescription;

/*NSSaveOptions

The saveOptions method returns one of the following constants to indicate how to deal with saving any modified documents:

typedef enum {
   NSSaveOptionsYes = 0,
   NSSaveOptionsNo,
   NSSaveOptionsAsk
} NSSaveOptions;
Constants
NSSaveOptionsYes

Indicates a modified document should be saved on closing without asking the user.

Available in Mac OS X v10.0 and later.
NSSaveOptionsNo

Indicates a modified document should not be saved on closing.

Available in Mac OS X v10.0 and later.
NSSaveOptionsAsk

Indicates the user should be asked before saving any modified documents on closing. When no option is specified, this is the default.

Available in Mac OS X v10.0 and later.
Availability
Available in Mac OS X v10.0 and later.
Declared In
NSScriptStandardSuiteCommands.h*/
typedef enum {
   NSSaveOptionsYes = 0,
   NSSaveOptionsNo,
   NSSaveOptionsAsk
} NSSaveOptions;


//@interface NSCloneCommand : NSScriptCommand
//@end

@interface NSCloseCommand : NSScriptCommand 

/*saveOptions

Returns a constant indicating how to deal with closing any modified documents.

- (NSSaveOptions)saveOptions
Return Value

A constant indicating how to deal with closing any modified documents. The default value returned is NSSaveOptionsAsk. See “Constants” for a list of possible return values.
Availability
Available in Mac OS X v10.0 and later.*/
- (NSSaveOptions)saveOptions;

@end

//@interface NSCountCommand : NSScriptCommand 
//@end


//@interface NSCreateCommand : NSScriptCommand
//    @end


//@interface NSDeleteCommand : NSScriptCommand 
//@end

//@interface NSExistsCommand : NSScriptCommand 
//@end


//@interface NSGetCommand : NSScriptCommand 
//@end


//@interface NSMoveCommand : NSScriptCommand 
//@end


//@interface NSQuitCommand : NSScriptCommand 
//@end


//@interface NSSetCommand : NSScriptCommand 
//@end
