#ifndef TEXTEDIT_H
#define TEXTEDIT_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#include <HYS/HIToolbox/TextEdit.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif



/*Appendix D - Renamed and Relocated Text Routines
This appendix lists, in Table D-1, those Macintosh system software routines that 
have been renamed or relocated from one manager to another during the reorganization necessary for the creation of Inside Macintosh: Text. It also lists those calls that have been rendered obsolete by newer versions of themselves and are therefore removed 
from documentation.

Most of the changes have been to text-related routines: the International Utilities Package and the Binary-Decimal Conversion Package have been replaced by a new manager called Text Utilities. The Text Utilities include most of their routines and also several text-related routines that were formerly part of the Toolbox Utilities and Operating System Utilities.

Many text-related routines that were formerly part of the Script Manager have been moved to other managers, such as QuickDraw, the Font Manager, the Text Utilities, or the Menu Manager, to be documented alongside existing routines with similar capabilities. For example, all routines that measure and draw justified text have been moved from the Script Manager to QuickDraw, to be with the existing QuickDraw text-measuring and drawing routines.

Many other routines have not been moved, but their names have been changed to 
more clearly reflect their functions, to minimize ambiguous interpretations, and to expand abbreviations.

Some routines that are not related to text handling are listed here. They are former Script Manager or International Utilities routines dealing with international issues, such as IUMetric and WriteLocation. Those routines now belong to other managers, as noted in Table D-1.

Note 
Although obsolete routines are no longer documented, they may remain in system software and their declarations may be maintained in the interface files for backward compatibility. Renamed routines are no longer documented under their old names, other than within the table in this appendix. 
Table D-1 Renamed, relocated, and obsolete text and international routines (Continued)Old name	New name	Old location	New location
Char2Pixel	(obsolete; use CharToPixel)	 	QuickDraw
CharByte	(obsolete; use CharacterByteType)	Script Manager
CharType	(obsolete; use CharacterType)	 	Script Manager
Date2Secs	DateToSeconds	O.S. Utilities	(not moved)
DrawJust	(obsolete; use DrawJustified)	 	QuickDraw
EqualString	(unchanged)	O.S. Utilities	Text Utilities
FindScriptRun	(unchanged)	Script Manager	Text Utilities
FindWord	(obsolete; use FindWordBreaks)	 	Text Utilities
Font2Script	FontToScript	Script Manager	(not moved)
Format2Str	FormatRecToString	Script Manager	Text Utilities
FormatStr2X	StringToExtended	Script Manager	Text Utilities
FormatX2Str	ExtendedToString	Script Manager	Text Utilities
GetAppFont	(unchanged)	Script Manager	Font Manager
GetDefFontSize	(unchanged)	Script Manager	Font Manager
GetEnvirons	GetScriptManagerVariable	Script Manager	(not moved)
GetFormatOrder	(unchanged)	Script Manager	QuickDraw
GetIndString	(unchanged)	Toolbox Utilities	Text Utilities
GetMBarHeight	(unchanged)	Script Manager	Menu Manager
GetScript	GetScriptVariable	Script Manager	(not moved)
GetString	(unchanged)	Toolbox Utilities	Text Utilities
GetStylHandle	TEGetStyleHandle	TextEdit	(not moved)
GetStylScrap	TEGetStyleScrapHandle	TextEdit	(not moved)
GetSysFont	(unchanged)	Script Manager	Font Manager
GetSysJust	GetSysDirection	Script Manager	(not moved)
HiliteText	(unchanged)	Script Manager	QuickDraw
InitDateCache	(unchanged)	Script Manager	Text Utilities
IUClearCache	ClearIntlResourceCache	Intl. Utilities	Script Manager
IUCompPString	CompareString	Intl. Utilities	Text Utilities
IUCompString	(obsolete; use CompareString)	 	Text Utilities
IUDatePString	DateString	Intl. Utilities	Text Utilities
IUDateString	(obsolete; use DateString)	 	Text Utilities
IUEqualPString	IdenticalString	Intl. Utilities	Text Utilities
IUEqualString	(obsolete; use IdenticalString)	 	Text Utilities
IUGetIntl	GetIntlResource	Intl. Utilities	Script Manager
IUGetItlTable	GetIntlResourceTable	Intl. Utilities	Script Manager
IULangOrder	LanguageOrder	Intl. Utilities	Text Utilities
IULDateString	LongDateString	Intl. Utilities	Text Utilities
IULTimeString	LongTimeString	Intl. Utilities	Text Utilities
IUMagIDPString	IdenticalText	Intl. Utilities	Text Utilities
IUMagIDString	(obsolete; use IdenticalText)	 	TextUtilities
IUMagPString	CompareText	Intl. Utilities	Text Utilities
IUMagString	(obsolete; use CompareText)	 	Text Utilities
IUMetric	IsMetric	Intl. Utilities	O.S. Utilities
IUScriptOrder	ScriptOrder	Intl. Utilities	Text Utilities
IUSetIntl	(obsolete; for 'INTL' resources)	Intl. Utilities	Text Utilities
IUStringOrder	StringOrder	Intl. Utilities	Text Utilities
IUTextOrder	TextOrder	Intl. Utilities	Text Utilities
IUTimePString	TimeString	Intl. Utilities	Text Utilities
IUTimeString	(obsolete; use TimeString)	 	Text Utilities
KeyTrans	KeyTranslate	Event Manager	(not moved)
LongDate2Secs	LongDateToSeconds	Script Manager	O.S. Utilities
LongSecsToDate	LongSecondsToDate	Script Manager	O.S. Utilities
LowerText	(obsolete; use LowercaseText)	 	Text Utilities
MeasureJust	(obsolete; use MeasureJustified)	 	QuickDraw
Munger	(unchanged)	Toolbox Utilities	Text Utilities
NChar2Pixel	CharToPixel	Script Manager	QuickDraw
NDrawJust	DrawJustified	Script Manager	QuickDraw
NewString	(unchanged)	Toolbox Utilities	Text Utilities
NFindWord	(obsolete; use FindWordBreaks)	 	Text Utilities
NMeasureJust	MeasureJustified	Script Manager	QuickDraw
 
NPixel2Char	PixelToChar	Script Manager	QuickDraw
NPortionText	PortionLine	Script Manager	QuickDraw
NumToString	(unchanged)	Binary-Dec. Conv.	Text Utilities
ParseTable	(obsolete; use FillParseTable)	 	Script Manager
Pixel2Char	(obsolete; use PixelToChar)	 	QuickDraw
PortionText	(obsolete; use PortionLine)	 	QuickDraw
ReadLocation	(unchanged)	Script Manager	O.S. Utilities
RelString	(unchanged)	O.S. Utilities	Text Utilities
ReplaceText	(unchanged)	Script Manager	Text Utilities
Secs2Date	SecondsToDate	O.S. Utilities	(not moved)
SetClikLoop	TESetClickLoop	TextEdit	(not moved)
SetEnvirons	SetScriptManagerVariable	Script Manager	(not moved)
SetScript	SetScriptVariable	Script Manager	(not moved)
SetString	(unchanged)	Toolbox Utilities	Text Utilities
SetStylHandle	TESetStyleHandle	TextEdit	(not moved)
SetStylScrap	TEUseStyleScrap	TextEdit	(not moved)
SetSysJust	SetSysDirection	Script Manager	(not moved)
SetWordBreak	TESetWordBreak	TextEdit	(not moved)
Str2Format	StringToFormatRec	Script Manager	Text Utilities
String2Date	StringToDate	Script Manager	Text Utilities
String2Time	StringToTime	Script Manager	Text Utilities
StringToNum	(unchanged)	Binary-Dec. Conv.	Text Utilities
StripText	(obsolete; use StripDiacritics)	 	Text Utilities
StripUpperText	(obsolete; use UppercaseStripDiacritics)	Text Utilities
StyledLineBreak	(unchanged)	Script Manager	Text Utilities
TEGetScrapLen	TEGetScrapLength	TextEdit	(not moved)
TESetJust	TESetAlignment	TextEdit	(not moved)
TESetScrapLen	TESetScrapLength	TextEdit	(not moved)
TEStylInsert	TEStyleInsert	TextEdit	(not moved)
TEStylNew	TEStyleNew	TextEdit	(not moved)
TeStylPaste	TEStylePaste	TextEdit	(not moved)
TextBox	TETextBox	TextEdit	(not moved)
ToggleDate	(unchanged)	Script Manager	O.S. Utilities
Transliterate	(obsolete; use TransliterateText)	Script Manager
TruncString	(unchanged)	Script Manager	Text Utilities
TruncText	(unchanged)	Script Manager	Text Utilities
UpperText	(obsolete; use UppercaseText)	 	Text Utilities
UprString	UpperString	O.S. Utilities	Text Utilities
ValidDate	(unchanged)	Script Manager	O.S. Utilities
VisibleLength	(unchanged)	Script Manager	QuickDraw
WriteLocation	(unchanged)	Script Manager	O.S. Utilities*/
#define TEGetScrapLen() TEGetScrapLength()

/*TEPtr

Defines a pointer to a TextEdit record.

typedef TTERec* TEPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TERec* TEPtr;

/*TEClickLoopProcPtr

Defines a pointer to a click-loop callback.

typedef Boolean (*TEClickLoopProcPtr) (
   TEPtr pTE
);

If you name your function MyTEClickLoopProc, you would declare it like this:

Boolean TEClickLoopProcPtr (
   TEPtr pTE
);*/
typedef Boolean (*TEClickLoopProcPtr) (
   TEPtr pTE
);

/*TEClickLoopUPP

Defines a universal procedure pointer (UPP) to a click-loop callback.

typedef TEClickLoopProcPtr TEClickLoopUPP;
Discussion

For more information, see the description of the TEClickLoopUPP () callback function*/
typedef TEClickLoopProcPtr TEClickLoopUPP;


/*TERec

Stores display and editing information for TextEdit.

struct TERec {
   Rect destRect;
   Rect viewRect;
   Rect selRect;
   short lineHeight;
   short fontAscent;
   Point selPoint;
   short selStart;
   short selEnd;
   short active;
   WordBreakUPP wordBreak;
   TEClickLoopUPP clickLoop;
   long clickTime;
   short clickLoc;
   long caretTime;
   short caretState;
   short just;
   short teLength;
   Handle hText;
   long hDispatchRec;
   short clikStuff;
   short crOnly;
   short txFont;
   StyleField txFace;
   short txMode;
   short txSize;
   GrafPtr inPort;
   HighHookUPP highHook;
   CaretHookUPP caretHook;
   short nLines;
   short lineStarts[16001];
};
typedef struct TERec TERec;
typedef TERec * TEPtr;
Fields
destRect

The destination rectangle, in local coordinates. 
viewRect

The view rectangle, in local coordinates.
selRect

The selection rectangle, whose boundaries are defined in local coordinates. This value is the current selection range or insertion point.
lineHeight

The vertical spacing of lines of text. Vertical spacing may be fixed or it may vary from line to line, depending upon specific text attributes. If the value of lineHeight is greater than 0, this field specifies the fixed vertical distance from the ascent line of one line of text down to the ascent line of the next.

If the value of lineHeight is less than 1, then this field specifies the vertical distance from the ascent line of one line of text down to the ascent line of the next calculated independently for each line, based on the maximum value for any individual character attribute on that line.
fontAscent

The font ascent line. If the value of fontAscent is greater than 0, this field specifies how far above the base line the pen is positioned to begin drawing the caret or highlighting.

For single-spaced text, this is the height of the text in pixels (the height of the tallest characters in the font from the base line). If the value of fontAscent is less than 1, this field specifies the font ascent calculated independently for each line, based on maximum value for any individual character attribute on that line.
selPoint

The point selected with the mouse, in the local coordinates of the current graphics port. The assembly-language offset for this field is named teSelPoint. 
selStart

The byte offset of the beginning of a selection range. Note that byte offset 0 refers to the first byte in the text buffer.
selEnd

The byte offset of the end of a selection range. To include that byte, this value must be 1 greater than the position of the last byte offset of the text.
active

This field is used internally by TextEdit. It is set when an edit structure is activated through TEActivate and then reset when the edit structure is rendered inactive through TEDeactivate. To ensure future compatibility, use TEActivate or TEDeactivate to access this field.
wordBreak

A universal procedure pointer to the structure’s word selection break function. This function determines the word that is highlighted when the user double-clicks in the text and the position at which text is wrapped at the end of a line. 
clickLoop

A universal procedure pointer to the click loop function.The specified click loop function is called repeatedly by the TEClick function as long as the mouse button is held down within the text. 
clickTime

This field is for internal use only.
clickLoc

This field is for internal use only.
caretTime

This field is for internal use only.
caretState

This field is for internal use only.
just

The type of text alignment: default (according to primary line direction), left, center, or right.
teLength

The number of bytes in the text to be edited. For two-byte systems, potentially twice the number of characters. Initially set to zero. The maximum length is 32767 bytes.
hText

A handle to the text. Initially, it points to a zero-length block of text in the heap. 
hDispatchRec

A handle to the TextEdit dispatch structure. This field is for internal use only; do not modify this field, or copy it to another edit structure. Each edit structure has its own dispatch structure. Attempting to use the dispatch structure of one edit structure with another edit structure can cause TextEdit to crash.
clikStuff

This field is for internal use only. TextEdit sets this field to reflect whether the most recent mouse-down event occurred on the leading or trailing edge of a glyph. TextEdit uses this value in determining a caret position.
crOnly

A value specifying whether or not text wraps at the right edge of the destination rectangle. If crOnly is positive, text does wrap. Otherwise, new lines are displayed only at Carriage Returns.

If crOnly is negative, new lines are specified explicitly by Return characters only; text does not wrap at the edge of the destination rectangle. (This is useful in an application similar to a programming-language editor, where you may not want a single line of code to be split onto two lines.
txFont

The font of all the text in the edit structure, if the txSize field of this edit structure ≥ 0. If you change this value, the entire text of this edit structure has the new characteristic when it is redrawn also remember to change the lineHeight and fontAscent fields.

If the txSize field is –1, this field combines with txFace to hold a handle to the associated style structure.
txFace

The character attributes of all the text in an edit structure, if the txSize field of this edit structure ≥ 0. If you change this value, the entire text of this edit structure has the new characteristic when it is redrawn also, remember to change the lineHeight and fontAscent fields as well.

If the txSize field is –1, this field combines with txFont to hold a handle to the associated style structure.

txMode

The pen mode of all the text in the edit structure. If you change this value, the entire text of this edit structure has the new characteristic when it is redrawn; also, remember to change the lineHeight and fontAscent fields as well.
txSize

Depending on its value, txSize either contains the point size of all of the text or it acts as a flag indicating whether or not there is associated character attribute information. If txSize ≥ 0, this is a monostyled edit structure, that is, all text is set in a single font, size, and face, and the value of txSize is the size of the text. If txSize is –1, the edit structure contains associated character attribute information and the txFont and txFace fields combine to form a handle to the style structure.
inPort

A pointer to the graphics port associated with this edit structure. 
highHook

A pointer to the function that deals with text highlighting. In assembly language, the highHook field is located at the offset teHiHook. 
caretHook

A pointer to the function that controls the appearance of the caret. In assembly language, the caretHook field is located at the offset teCarHook. 
nLines

The number of lines in the text.
lineStarts

An array containing the character position of the first character in each line. It is declared to have 16001 elements to comply with Pascal range checking. This is a dynamic data structure, having only as many elements as needed. TextEdit calculates these values internally, so do not change the elements of the lineStarts array. Because this data structure grows and shrinks, the size of the edit structure changes.
Discussion

The edit structure, defined by the TERec data type, stores the display and editing information for TextEdit. Along with various subsidiary data structures, the style structure, defined by the TEStyleRec data type, stores the character attribute information for the text of the edit structure.

The edit structure contains display, storage, styling, and other information. Although some fields are used differently for multistyled edit structures and monostyled edit structures, the structure of an edit structure is the same whether the text is multistyled or monostyled. 
Availability
Available in Mac OS X v10.0 and later.*/
struct TERec {
   Rect destRect;
   Rect viewRect;
   Rect selRect;
   short lineHeight;
   short fontAscent;
   Point selPoint;
   short selStart;
   short selEnd;
   short active;
   WordBreakUPP wordBreak;
   TEClickLoopUPP clickLoop;
   long clickTime;
   short clickLoc;
   long caretTime;
   short caretState;
   short just;
   short teLength;
   Handle hText;
   long hDispatchRec;
   short clikStuff;
   short crOnly;
   short txFont;
   StyleField txFace;
   short txMode;
   short txSize;
   GrafPtr inPort;
   HighHookUPP highHook;
   CaretHookUPP caretHook;
   short nLines;
   short lineStarts[16001];
};
//typedef struct TERec TERec;
//typedef TERec * TEPtr;

/*TEHandle

Defines a handle to a TextEdit record pointer.

typedef TEPtr* TEHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef TEPtr* TEHandle;

/*Sets the text alignment as in:   
 teJustLeft                  = 0,
    teJustCenter                = 1,
    teJustRight                 = -1,
    teForceLeft                 = -2, // new names for the
                                 Justification (word alignment) styles 
    teFlushDefault              = 0, //flush according to the line
                                 direction 
    teCenter                    = 1, //center justify (word alignment) 
    teFlushRight                = -1,//flush right for all scripts */
enum {
teJustLeft                  = 0,
    teJustCenter                = 1,
    teJustRight                 = -1,
    teForceLeft                 = -2, /* new names for the
                                 Justification (word alignment) styles */
    teFlushDefault              = 0, /*flush according to the line
                                 direction */
    teCenter                    = 1, /*center justify (word alignment) */
    teFlushRight                = -1,/*flush right for all scripts */
};

/*CharsPtr

Defines a data type for a character pointer.

typedef char* CharsPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef char* CharsPtr;

/*CharsHandle

Defines a handle to a character pointer.

typedef CharsPtr* CharsHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef CharsPtr* CharsHandle;

//function

/*TETextBox

Draws the indicated text in a given rectangle, with the specified alignment. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TETextBox (
   const void * text,
   long length,
   const Rect * box,
   short just
);
Parameters
text

A pointer to the text to be drawn.
length

The number of bytes comprising the text.
box

A pointer to the rectangle where the text is to be drawn. The rectangle is specified in local coordinates (of the current graphics port) and must be at least as wide as the first character drawn. (A good rule of thumb is to make the rectangle at least 20 pixels wide. 
just

The kind of justification (alignment) used for the specified text.
Discussion

The TETextBox function provides you with an easy way to display static text to a user. It creates its own monostyled edit structure, which it deletes when finished with it, so you cannot edit the text it draws. The TETextBox function breaks a line of text correctly. You can specify how text is aligned in the box using any of the “Text Alignment Constants”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TETextBox (
   const void * text,
   long length,
   const Rect * box,
   short just
);

/*TEIdle

When called repeatedly, displays a blinking caret at the insertion point, if any exists, in the text of the specified edit structure of an active window. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEIdle (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure. 
Discussion

You need to call TEIdle only when the window containing the text is active; the caret is blinked only then. TextEdit observes a minimum blink interval, initially set to 32 ticks. No matter how often you call TEIdle, the time between blinks is never less than the minimum interval. (The user can adjust the minimum interval setting with the General Controls control panel.)

To maintain a constant frequency of blinking, you need to call TEIdle at least once each time through your main event loop. Call it more than once if your application does an unusually large amount of processing each time through the loop.

Call the Event Manager’s GetCaretTime function to get the blink rate. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEIdle (
   TEHandle hTE
);

/*TEUpdate

Draws the specified text within a given update rectangle. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEUpdate (
   const Rect * rUpdate,
   TEHandle hTE
);
Parameters
rUpdate

The update rectangle, given in the coordinates of the current graphics port, where the specified text is to be drawn. 
hTE

A handle to the edit structure containing the text to be drawn. 
Discussion

Call TEUpdate every time the Event Manager function WaitNextEvent reports an update event for a text editing window—after you call the Window Manager function BeginUpdate , and before you call the EndUpdate function. You also need to erase the update region with the EraseRect function. If you don’t, the caret can sometimes remain visible when the window is deactivated. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/

void TEUpdate (
   const Rect * rUpdate,
   TEHandle hTE
);

/*TEActivate

Activates the specified edit structure. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEActivate (
   TEHandle hTE
);
Parameters
hTE

A handle to the specified edit structure. 
Discussion

When your application receives notification of an activate event, it can call the TEActivate function, which activates an edit structure and highlights the selection range. If the selection range is an insertion point, TEActivate simply displays a caret there. Call this function every time the Event Manager function WaitNextEvent reports that the window containing the edit structure has become active.

If you do not call TEActivate before you call TEClick, TEIdle, or TESetSelect, the selection range is not highlighted, or, if the selection range is set to an insertion point, a caret is not displayed at the insertion point. However, if you have turned on outline highlighting through the TEFeatureFlag function for the edit structure, the text of the selection range is framed or a dimmed or an unblinking caret is displayed at the insertion point. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/

void TEActivate (
   TEHandle hTE
);

/*TEDeactivate

Deactivates the specified edit structure. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEDeactivate (
   TEHandle hTE
);
Parameters
hTE

A handle to the specified edit structure. 
Discussion

When the activate event flag is set to deactivate the window, your application can call the TEDeactivate function, which changes an edit structure’s status from active to inactive and removes the selection range highlighting or the caret.

However, if you turned on outline highlighting through the TEFeatureFlag function for the edit structure, the text of the selection range is framed or a dimmed or an unblinking caret is displayed at the insertion point when the structure is deactivated.

Call this function every time the Event Manager function WaitNextEvent reports that the window containing the edit structure has become inactive. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/

void TEDeactivate (
   TEHandle hTE
);

/*TEClick

Controls placement and highlighting of the selection range as determined by mouse events. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEClick (
   Point pt,
   Boolean fExtend,
   TEHandle h
);
Parameters
pt

The mouse location in local coordinates at the time the mouse button was pressed, obtainable from the event structure (in global coordinates). 
fExtend

A flag denoting the state of the Shift key at the time of the click as indicated by the Event Manager. If the Shift key was held down at the time of the click to extend the selection, pass a value of TRUE. 
h

A handle to the edit structure whose text is displayed in the view rectangle where the click occurred. 
Discussion

Call TEClick whenever a mouse-down event occurs in the view rectangle of the edit structure and the window associated with that edit structure is active. The TEClick function keeps control until the mouse button is released. Use the QuickDraw function GlobalToLocal to convert the global coordinates of the mouse location given in the event structure to the local coordinate system for pt.

The TEClick function removes highlighting of the old selection range unless the selection range is being extended. If the mouse moves, meaning that a drag is occurring, TEClick expands or shortens the selection range accordingly a character at a time. In the case of a double-click, the word where the cursor is positioned becomes the selection range. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEClick (
   Point pt,
   Boolean fExtend,
   TEHandle h
);

/*TEScroll

Scrolls the text within the view rectangle of the specified edit structure by the designated number of pixels. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEScroll (
   short dh,
   short dv,
   TEHandle hTE
);
Parameters
dh

The distance in pixels that the text is to be scrolled horizontally. A positive value moves the text to the right; a negative value moves the text to the left.
dv

The distance in pixels that the text is to be scrolled vertically. A positive value moves the text down; a negative value moves the text up.
hTE

A handle to the edit structure whose text is to be scrolled. 
Discussion

The TEScroll function updates the text on the screen automatically to reflect the new scroll position. The destination rectangle is offset by the amount scrolled. The TEScroll and TEPinScroll functions behave the same, except that TEPinScroll stops scrolling when the last line of text is scrolled into view. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEScroll (
   short dh,
   short dv,
   TEHandle hTE
);

/*TEKey

Replaces the selection range in the text of the specified edit structure with the input character and positions the insertion point just past the inserted character. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEKey (
   CharParameter key,
   TEHandle hTE
);
Parameters
key

The input character. 
hTE

A handle to the edit structure in whose text the character is to be entered. 
Discussion

The TextEdit function TEKey allows you to handle key-down events and enter text input through the keyboard. If the selection range is an insertion point, TEKey inserts the character. (Two-byte characters are passed one byte at a time.)

If the key parameter contains a backspace character, the selection range or the character immediately before the insertion point is deleted. When the primary line direction is right-to-left, the character to the right of the insertion point is deleted. When the primary line direction is left-to-right, the character to the left of the insertion point is deleted.

When the user deletes text up to the beginning of a set of character attributes, TEKey saves the attributes in the null scrap’s style scrap structure. The attributes are saved temporarily to be applied to characters inserted after the deletion. As soon as the user clicks in another area of the text, TEKey removes the attributes. TEKey redraws the text as necessary.

Call TEKey every time the Event Manager function WaitNextEvent reports a keyboard event that your application determines should be handled by TextEdit.

Because TEKey inserts every character passed in the key parameter, your application must filter all characters which aren’t actual text, such as keys typed in conjunction with the Command key. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEKey (
   CharParameter key,
   TEHandle hTE
);

/*TECut

Removes the current selection range from the text of the designated edit structure, redrawing the text as necessary. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TECut (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure containing the text to be cut. 
Discussion

For monostyled text, the TECut function writes the cut text to the private scrap.

For multistyled text, TECut writes the cut text to the private scrap and its character attributes to the style scrap it also writes both to the Scrap Manager’s desk scrap. For multistyled text, the TECut function removes the character attributes from the style structure’s style table when the text is cut.

For both monostyled and multistyled text, if the selection range is an insertion point, TextEdit deletes everything from the private scrap. When the selection range is an insertion point and the text is multistyled, TECut has no effect on the style scrap or the Scrap Manager’s desk scrap. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TECut (
   TEHandle hTE
);

/*TEToScrap

Copies the contents of the TextEdit private scrap to the desk scrap. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

OSErr TEToScrap ();
Return Value

A result code. See “TextEdit Result Codes”.
Discussion

You use the TEToScrap function to move monostyled text across applications or between an application and a desk accessory. Call the Scrap Manager function ZeroScrap to initialize the desk scrap or clear its contents before calling TEToScrap. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
OSErr TEToScrap ();

/*TECopy

Copies the text selection range from the edit structure, leaving the selection range intact. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TECopy (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure containing the text to be copied. 
Discussion

The TECopy function copies the text to the private scrap. For text of a monostyled edit structure, the text is written to the private scrap only. For text of a multistyled edit structure, the text is written to the TextEdit private scrap, the character attribute information is written to the TextEdit style scrap, and both are written to the Scrap Manager’s desk scrap. Anything previously in the private scrap is deleted before the copied text is written to it.

For both multistyled and monostyled text, if the selection range is an insertion point, TECopy empties the TextEdit private scrap. When the selection range is an insertion point and the text is multistyled, TECopy has no effect on the null scrap, the style scrap, or the Scrap Manager’s desk scrap. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TECopy (
   TEHandle hTE
);

/*TEPaste

Replaces the edit structure’s selected text with the contents of the private scrap and leaves an insertion point after the inserted text. If the selection range is an insertion point, TEPaste inserts the contents of the private scrap there. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEPaste (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure into which the text is to be pasted. 
Discussion

When you call TEPaste, after it pastes the text from the private scrap, it redraws all of the text as necessary. If the private scrap is empty, TEPaste deletes the selection range. If you call TEPaste for a multistyled edit structure, it pastes only the text in the private scrap. In this case, TEPaste ignores any associated character attribute information stored in the style scrap; instead, it applies the character attributes of the first character of the selection range being replaced to the text. If the selection range is an insertion point, TEPaste applies the character attributes of the character preceding the insertion point. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEPaste (
   TEHandle hTE
);

/*TEFromScrap

Copies the contents of the desk scrap to the TextEdit private scrap. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

OSErr TEFromScrap ();
Return Value

A result code. See “TextEdit Result Codes”.
Discussion

You use this function to move monostyled text across applications or between an application and a desk accessory. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
OSErr TEFromScrap ();

/*TENew

Creates and initializes a monostyled edit structure and allocates a handle to it. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

TEHandle TENew (
   const Rect * destRect,
   const Rect * viewRect
);
Parameters
destRect

A pointer to the destination rectangle for the new edit structure, specified in the local coordinates of the current graphics port. This is the area in which text is laid out. 
viewRect

A pointer to the view, or visible, rectangle for the new edit structure, specified in the local coordinates of the current graphics port. This is the area of the window in which text is actually displayed.
Return Value

A handle to the newly created edit structure. Your application needs to store the handle to the edit structure that is returned; many functions require it as an input parameter. See the description of the TEHandle data type.
Discussion

A monostyled edit structure is one in which all text is restricted to a single font, size, and style. Use the TENew function when the text is to be rendered in attributes that are consistent from character to character. Otherwise, use the TEStyleNew function.

Call TENew once for every edit structure you want allocated. Your application should store the handle to the edit structure that is returned; many functions require it as an input parameter. The edit structure assumes the drawing environment of the graphics port.

If your application contains more than one window where text editing occurs, you need to create an edit structure for each window.

Before this function is called, the window must be in the current graphics port. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
TEHandle TENew (
   const Rect * destRect,
   const Rect * viewRect
);

/*TEDispose

Removes a specified edit structure and releases all memory associated with it. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEDispose (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure for which the allocated memory should be released. 
Discussion

Call the TEDispose function only when you’re completely through with an edit structure.

Note that if your program retains a handle to text associated with the edit structure that you are destroying with TEDispose , the handle becomes invalid because the TEDispose function disposes of it, as well as the dispatch structure handle. If the structure is multistyled, TEDispose also disposes all of the style-related handles: STHandle, LHHandle, STScrpHandle, nullSTHandle, and TEStyleHandle.

To continue to refer to the text after you’ve destroyed the edit structure, you need to make a copy of the handle in the hText field of the edit structure using the Operating System Utilities HandToHand function before you call TEDispose.

In addition to disposing of the edit structure, the edit structure handle, and the dispatch structure handle, the TEDispose function destroys the null scrap associated with the edit structure and releases the memory used for it. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEDispose (
   TEHandle hTE
);

/*TEAutoView

Enables and disables automatic scrolling of the text in the specified edit structure. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEAutoView (
   Boolean fAuto,
   TEHandle hTE
);
Parameters
fAuto

A flag indicating whether to enable or disable automatic scrolling. A value of TRUE enables automatic scrolling; a value of FALSE disables automatic scrolling. 
hTE

A handle to the edit structure for which automatic scrolling is to be enabled or disabled. 
Discussion

The TEAutoView function does not actually scroll the text automatically: TESelView does. However, when fAuto is set to FALSE , a call to TESelView has no effect.

If there is a scroll bar associated with the edit structure, your application must manage scrolling of it. You can replace the default click loop function, which scrolls the text only, with a customized version that also updates the scroll bar.

You can also enable or disable automatic scrolling for an edit structure through the teFAutoScroll feature of the TEFeatureFlag function. For more information, see TEFeatureFlag. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEAutoView (
   Boolean fAuto,
   TEHandle hTE
);

/*TEDelete

Removes the selected range of text from the designated edit structure, redrawing the remaining text as necessary. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

void TEDelete (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure containing the text to be deleted. 
Discussion

When the TEDelete function deletes a selected range of text, it does not transfer the text to either the private scrap or the Scrap Manager’s desk scrap.

For multistyled structures, when you use TEDelete to delete a selected range of text, the associated character attributes are saved in the null scrap to be applied to characters entered after the text is deleted. When the user clicks in some other area of the text, the character attributes are removed from the null scrap. You can use TEDelete to implement the Clear command. The TEDelete function recalculates line starts and line heights. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
void TEDelete (
   TEHandle hTE
);

/*TEGetText

Returns a handle to the text of the specified edit structure. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

CharsHandle TEGetText (
   TEHandle hTE
);
Parameters
hTE

A handle to the edit structure containing the text whose handle you want returned. You pass this handle as an input parameter. 
Return Value

A handle to the text contained in the specified edit structure. See page 82 for a description of the CharsHandle data type.
Discussion

Given an edit structure that contains text, you can use the TEGetText function to get a handle to the text itself. The TEGetText function doesn’t make a copy of the text. Rather, it returns the handle to the text which is stored as a packed array of characters. (This handle belongs to TextEdit your application must not destroy it.) The teLength field of the edit structure contains the length of the text whose handle is returned.

The handle of type CharsHandle that is returned by TEGetText corresponds to the hText field of the TERec structure. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
CharsHandle TEGetText (
   TEHandle hTE
);

/*TEGetScrapLength

Returns the size of the TextEdit private scrap, in bytes. (Deprecated in Mac OS X v10.4. Use Multilingual Text Engine instead; see Handling Unicode Text Editing With MLTE.)

long TEGetScrapLength ();
Return Value

The size of the TextEdit private scrap, in bytes. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
TextEdit.h*/
long TEGetScrapLength ();

#ifdef __cplusplus
}
#endif

#endif