#ifndef  IOKIT_HID_IOHIDKEYS_H_
#define IOKIT_HID_IOHIDKEYS_H_

#include <sys/cdefs.h>
#include <IOKit/hidsystem/IOHIDParameter.h>

/*IOHIDElementCookie


Abstract data type used as a unique identifier for an element. 
typedef void * IOHIDElementCookie;  */
typedef void * IOHIDElementCookie;  

/*IOHIDElementType


Describes different types of HID elements. 
See Also:
IOHIDElementType
enum IOHIDElementType { 
    kIOHIDElementTypeInput_Misc = 1, 
    kIOHIDElementTypeInput_Button = 2, 
    kIOHIDElementTypeInput_Axis = 3, 
    kIOHIDElementTypeInput_ScanCodes = 4, 
    kIOHIDElementTypeOutput = 129, 
    kIOHIDElementTypeFeature = 257, 
    kIOHIDElementTypeCollection = 513 
};  
Discussion 

Used by the IOHIDFamily to identify the type of element processed. Represented by the key kIOHIDElementTypeKey in the dictionary describing the element.*/
enum IOHIDElementType { 
    kIOHIDElementTypeInput_Misc = 1, 
    kIOHIDElementTypeInput_Button = 2, 
    kIOHIDElementTypeInput_Axis = 3, 
    kIOHIDElementTypeInput_ScanCodes = 4, 
    kIOHIDElementTypeOutput = 129, 
    kIOHIDElementTypeFeature = 257, 
    kIOHIDElementTypeCollection = 513 
};  


/*IOHIDElementType


Describes different types of HID elements. 
See Also:
IOHIDElementType
typedef enum IOHIDElementType IOHIDElementType;  
Constants
kIOHIDElementTypeInput_Misc
Misc input data field or varying size.
kIOHIDElementTypeInput_Button
One bit input data field.
kIOHIDElementTypeInput_Axis
Input data field used to represent an axis.
kIOHIDElementTypeInput_ScanCodes
Input data field used to represent a scan code or usage selector.
kIOHIDElementTypeOutput
Used to represent an output data field in a report.
kIOHIDElementTypeFeature
Describes input and output elements not intended for consumption by the end user.
kIOHIDElementTypeCollection
Element used to identify a relationship between two or more elements.
Discussion 

Used by the IOHIDFamily to identify the type of element processed. Represented by the key kIOHIDElementTypeKey in the dictionary describing the element.*/
typedef enum IOHIDElementType IOHIDElementType;  



#endif 
