#ifndef PRINTING_H
#define PRINTING_H

#ifndef MACERRORS_H
#include <CarbonCore/MacErrors.h>
#endif

#ifndef  QUICKDRAW_H
//#include <QD/Quickdraw.h>
#endif

#ifndef  DIALOGS_H
#include <HIToolbox/Dialogs.h>
#endif


#include <HYS/Printing.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Printing Manager Result Codes 
iPrAbort	128	Application or user requested cancel
opNotImpl	2	Requested PrGeneral opcode not implemented in the current printer driver
noSuchRsl	1	Resolution requested with the PrGeneral procedure is not supported
noErr	0	No error
iPrSavPFil	-1	Problem saving print file
controlErr	-17	Unimplemented control instructions; the Device Manager returns this result code
iIOAbort	-27	I/O error
iMemFullErr	-108	There is not enough room in the heap zone
resNotFound	-192	The current printer driver does not support PrGeneral; you should clear this error with a call to PrSetError with a parameter value of 0; otherwise, PrError might still contain this error next time you check it 
PAPNoCCBs	-4096	There are no free connect control blocks (CCBs) available
PAPBadRefnum	-4097	Bad connection reference number
PAPActive	-4098	The request is already active
PAPTooBig	-4099	The write request is too big
PAPConnClosed	-4100	The connection is closed
PAPNoPrinter	-4101	The printer is not found, is closed, or is not selected
 	-8131	Printer not responding
manualFeedTOErr	-8132	A timeout occurred (that is, no communication has occurred with the printer for two minutes); this is usually caused by an extremely long imaging time or a dropped connection
generalPSErr	-8133	A PostScript error occurred during transmission of data to the printer; this is most often caused by a bug in the application-supplied PostScript code
zoomRangeErr	-8160	The print image enlarged by the user with the Page Setup dialog box overflows the available page resolution
errBadFontKeyType	-8976	Font found in printer is not Type 1, TrueType, or bitmapped font
errPSStateUnderflow	-8977	PostScript stack underflow while restoring graphics state
errNoPattern	-8978	The pixel pattern could not be found and could not be built
errBadConverterID	-8979	The 'PDEF' converter doesn't exist
errNoPagesSpooled	-8980	Application called PrOpenDoc and PrCloseDoc without calling PrOpenPage and PrClosePage in between
errNullColorInfo	-8981	The getColor function called with null GetColorInfo handle
errPSFileNameNull	-8982	The filename pointer for the spool file is null
errSpoolFolderIsAFile	-8983	The spool folder is a file instead of a folder
errBadConverterIndex	-8984	When saving a spool file to disk, the value fileTypeIndex field had no matching entry in the driver
errDidNotDownloadFont	-8985	A PostScript outline could not be found for a PostScript font, and there is no associated 'sfnt' resource
errBitmapFontMissing	-8986	Unable to build bitmap for font
errPSFileName	-8987	PostScript file isn't named
errCouldNotMakeNumberedFilename	-8989	Could not make a unique filename for the spool file
errBadSpoolFileVersion	-8990	Bad version number in header of spool file
errNoProcSetRes	-8991	The resource describing needed procedure sets is unavailable for the PostScript prolog
errInLineTimeout	-8993	The printer is not responding
errUnknownPSLevel	-8994	The PostScript level has an unknown value
errFontNotFound	-8995	Font query reply didn't match any fonts in list of PostScript names
errSizeListBad	-8996	The size list contained an entry that could not be reconciled with the typeface list
errFaceListBad	-8997	Entry could not be found in typeface list
errNotAKey	-8998	Key for desired font number and style could not be found in font table*/
enum {
iMemFullErr	=-108//	There is not enough room in the heap zone
};

/*Data Types
struct TPrint {         / print record /
   short    iPrVersion; / reserved /
   TPrInfo  prInfo;     / resolution of device & page rectangle /
   Rect     rPaper;     / paper rectangle /
   TPrStl   prStl;      / printer driver number & feed type /
   TPrInfo  prInfoPT;   / reserved /
   TPrXInfo prXInfo;    / reserved /
   TPrJob   prJob;      / information from the job dialog box / 
   short    printX[19]; / reserved /
};
typedef struct TPrint TPrint;
typedef TPrint TPPrint, THPrint;
struct TPrInfo {        / printer information record /
   short    iDev;       / reserved /
   short    iVRes;      / vertical resolution of printer, in dpi /
   short    iHRes;      / horizontal resolution of printer, in dpi /
   Rect     rPage;      / the page rectangle /
};
typedef struct TPrInfo TPrInfo;
typedef TPrInfo TPPrInfo;
struct TPrJob {         / print job record /
   short    iFstPage;   / first page of page range /
   short    iLstPage;   / last page of page range /
   short    iCopies;    / number of copies /
   char     bJDocLoop;  / printing method: draft or deferred /
   Boolean  fFromUsr;   / reserved /
   PrIdleProcPtr
            pIdleProc;  / pointer to an idle procedure /
   StringPtr
            pFileName;  / spool filename: NIL for default /
   short    iFileVol;   / spool file volume; set to 0 initially /
   char     bFileVers;  / spool file version; set to 0 initially /
   char     bJobX;      / reserved /
};
typedef struct TPrJob TPrJob;
typedef TPrJob TPPrJob;
struct TPrStl {      / printing style record /
   short    wDev;    / device number of printer /
   short    iPageV;  / reserved /
   short    iPageH;  / reserved /
   char     bPort;   / reserved /
   TFeed    feed;    / feed type /
};
typedef struct TPrStl TPrStl;
typedef TPrStl TPPrStl;
struct TPrStatus {         / printing status record /
   short       iTotPages;  / total pages in print file /
   short       iCurPage;   / current page number /
   short       iTotCopies; / total copies requested /
   short       iCurCopy;   / current copy number /
   short       iTotBands;  / reserved /
   short       iCurBand;   / reserved /
   Boolean     fPgDirty;   / TRUE if current page has been written to /
   Boolean     fImaging;   / reserved /
   THPrint     hPrint;     / handle to the active TPrint record /
   TPPrPort    pPrPort;    / pointer to the active printing graphics port /
   PicHandle   hPic;       / handle to the active picture /
};
typedef struct TPrStatus TPrStatus;
typedef TPrStatus TPPrStatus;
struct TPrDlg {               / print dialog box record /
   DialogRecord   Dlg;        / a dialog record /
   ModalFilterProcPtr
                  pFltrProc;  / pointer to event filter /
   PItemProcPtr   pItemProc;  / pointer to item-handling function /
   THPrint        hPrintUsr;  / handle to a TPrint record /
   Boolean        fDoIt;      / TRUE means user clicked OK /
   Boolean        fDone;      / TRUE means user clicked OK or Cancel /
   long           lUser1;     / storage for your application /
   long           lUser2;     / storage for your application /
   long           lUser3;     / storage for your application /
   long           lUser4;     / storage for your application /
};
typedef struct TPrDlg TPrDlg;
typedef TPrDlg TPPrDlg;
typedef pascal TPPrDlg (PDlgInitProcPtr)(THPrint hPrint);
truct TPrPort {         / printing graphics port record /
   GrafPort gPort;      / graphics port for printing /
   QDProcs  gProcs;     / procedures for printing in the graphics port /
   long     lGParam1;   / reserved /
   long     lGParam2;   / reserved /
   long     lGParam3;   / reserved /
   long     lGParam4;   / reserved /
   Boolean  fOurPtr;    / reserved /
   Boolean  fOurBits;   / reserved /
};
typedef struct TPrPort TPrPort;
typedef TPrPort TPPrPort;
enum {feedCut,feedFanfold,feedMechCut,feedOther};
typedef unsigned char TFeed;
enum {scanTB,scanBT,scanLR,scanRL};
typedef unsigned char TScan;
typedef Rect TPRect;
typedef pascal void (PrIdleProcPtr)(void);
typedef pascal void (PItemProcPtr)(DialogPtr theDialog, short item);
/ structures used by PrGeneral /
struct TGnlData {
   short iOpCode;    / opcode passed to PrGeneral /
   short iError;     / result code returned by PrGeneral /
   long  lReserved;  / more fields here depending on call /
};
typedef struct TGnlData TGnlData;
struct TGetRslBlk {        / get-resolution record /
   short    iOpCode;       / the getRslDataOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   short    iRgType;       / printer driver version number /
   TRslRg   xRslRg;        / x-direction resolution range /
   TRslRg   yRslRg;        / y-direction resolution range /
   short    iRslRecCnt;    / number of resolution records /
   TRslRec  rgRslRec[27];  / array of resolution records /
};
typedef struct TGetRslBlk TGetRslBlk;
struct TRslRg {   
   short    iMin;          / minimum resolution supported /
   short    iMax;          / maximum resolution supported /
};
typedef struct TRslRg TRslRg;
struct TRslRec {  
   short    iXRsl;         / discrete resolution, x direction /
   short    iYRsl;         / discrete resolution, y direction /
};
typedef struct TRslRec TRslRec;
struct TSetRslBlk {        / set-resolution record /
   short    iOpCode;       / the setRslOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   THPrint  hPrint;        / handle to the current TPrint record /
   short    iXRsl;         / x-direction resolution you want /
   short    iYRsl;         / y-direction resolution you want /
};
typedef struct TSetRslBlk TSetRslBlk;
struct TDftBitsBlk {       / draft bits record /
   short    iOpCode;       / draftBitsOp or noDraftBitsOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   THPrint  hPrint;        / handle to the current TPrint record /
};
typedef struct TDftBitsBlk TDftBitsBlk;
struct TGetRotnBlk {       / page orientation record /
   short    iOpCode;       / the getRotnOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   THPrint  hPrint;        / handle to current TPrint record /
   Boolean  fLandscape;    / TRUE if user selected landscape printing /
   char     bXtra;         / reserved /
};
typedef struct TGetRotnBlk TGetRotnBlk;*/



/*Constants
enum {
   iPrPgFst    = 1,     / page range constant--first page /
   iPrRelease  = 3,     / current version number of the printer driver /
   iPrPgFract  = 120,   / page scale factor /
   iPFMaxPgs   = 128,   / maximum pages in spool file /
   iPrPgMax    = 9999,  / page range constant--last page /

   / PrCtlCall constants for the iWhichCtl parameter /
   iPrBitsCtl     = 4,  / print a bitmap object /
   iPrIOCtl       = 5,  / perform text streaming /
   iPrEvtCtl      = 6,  / print object specified in lParam1 parameter /
   iPrDevCtl      = 7,  / device control command /

   / constants used with iPrBitsCtl (in the lParam1 parameter 
      of PrCtlCall) /
   lScreenBits    = 0,           / resolution is 80 x 72 dpi /
   lPaintBits     = 1,           / resolution is 72 x 72 dpi /
   lHiScreenBits  = 0x00000002,  / resolution is 160 x 144 dpi /
   lHiPaintBits   = 0x00000003,  / resolution is 144 x 144 dpi /

   / constants used with iPrEvtCtl (in the lParam3 parameter 
      of PrCtlCall) /
   lPrEvtAll      = 0x0002FFFD,  / the entire screen /
   lPrEvtTop      = 0x0001FFFD,  / the frontmost window /
/ constants used with iPrDevCtl (in the lParam1 parameter 
      of PrCtlCall) /
   lPrReset       = 0x00010000,  / reserved /
   lPrLineFeed    = 0x00030000,  / paper advance /
   lPrLFStd       = 0x0003FFFF,  / carriage return with line feed /
   lPrLFSixth     = 0x0003FFFF,  / used for low-level call for 
                                    ImageWriter /
   lPrPageEnd     = 0x00020000,  / end page /
   lPrDocOpen     = 0x00010000,  / open document for printing /
   lPrPageOpen    = 0x00040000,  / open page for printing /
   lPrPageClose   = 0x00020000,  / close page for printing /
   lPrDocClose    = 0x00050000,  / close document for printing /
bDraftLoop     = 0,           / draft-quality printing /
   bSpoolLoop     = 1,           / deferred printing /
   bUser1Loop     = 2,           / reserved /
   bUser2Loop     = 3,           / reserved /
iPrSavPFil     = -1,          / problem saving print file /
   iPrAbort       = 0x0080,      / the user pressed Command-period /

   iFMgrCtl       = 8,           / File Mgr's dialog-hook proc's control 
                                    number /
   pPrGlobals     = 0x00000944,     / PrVars low memory area /

   iPrDrvrRef     = -3, / reference number of printer driver /

   / opcodes used with PrGeneral /
   getRslDataOp   = 4,  / get resolutions for the current printer /
   setRslOp       = 5,  / set resolutions for a TPrint record /
   draftBitsOp    = 6,  / force enhanced draft-quality printing /
   noDraftBitsOp  = 7,  / cancel enhanced draft-quality printing /
   getRotnOp      = 8,  / get page orientation of a TPrint record /

   / result code from PrGeneral /
   noSuchRsl      = 1,  / resolution not supported /
};*/


enum {
   iPrPgFst    = 1,     /* page range constant--first page */
   iPrRelease  = 3,     /* current version number of the printer driver */
   iPrPgFract  = 120,   /* page scale factor */
   iPFMaxPgs   = 128,   /* maximum pages in spool file */
   iPrPgMax    = 9999,  /* page range constant--last page */

   /* PrCtlCall constants for the iWhichCtl parameter */
   iPrBitsCtl     = 4,  /* print a bitmap object */
   iPrIOCtl       = 5,  /* perform text streaming */
   iPrEvtCtl      = 6,  /* print object specified in lParam1 parameter */
   iPrDevCtl      = 7,  /* device control command */

   /* constants used with iPrBitsCtl (in the lParam1 parameter 
      of PrCtlCall) */
   lScreenBits    = 0,           /* resolution is 80 x 72 dpi */
   lPaintBits     = 1,           /* resolution is 72 x 72 dpi */
   lHiScreenBits  = 0x00000002,  /* resolution is 160 x 144 dpi */
   lHiPaintBits   = 0x00000003,  /* resolution is 144 x 144 dpi */

   /* constants used with iPrEvtCtl (in the lParam3 parameter 
      of PrCtlCall) */
   lPrEvtAll      = 0x0002FFFD,  /* the entire screen */
   lPrEvtTop      = 0x0001FFFD,  /* the frontmost window */
/* constants used with iPrDevCtl (in the lParam1 parameter 
      of PrCtlCall) */
   lPrReset       = 0x00010000,  /* reserved */
   lPrLineFeed    = 0x00030000,  /* paper advance */
   lPrLFStd       = 0x0003FFFF,  /* carriage return with line feed */
   lPrLFSixth     = 0x0003FFFF,  /* used for low-level call for 
                                    ImageWriter */
   lPrPageEnd     = 0x00020000,  /* end page */
   lPrDocOpen     = 0x00010000,  /* open document for printing */
   lPrPageOpen    = 0x00040000,  /* open page for printing */
   lPrPageClose   = 0x00020000,  /* close page for printing */
   lPrDocClose    = 0x00050000,  /* close document for printing */
bDraftLoop     = 0,           /* draft-quality printing */
   bSpoolLoop     = 1,           /* deferred printing */
   bUser1Loop     = 2,           /* reserved */
   bUser2Loop     = 3,           /* reserved */
iPrSavPFil     = -1,          /* problem saving print file */
   iPrAbort       = 0x0080,      /* the user pressed Command-period */

   iFMgrCtl       = 8,           /* File Mgr's dialog-hook proc's control 
                                    number */
   pPrGlobals     = 0x00000944,     /* PrVars low memory area */

   iPrDrvrRef     = -3, /* reference number of printer driver */

   /* opcodes used with PrGeneral */
   getRslDataOp   = 4,  /* get resolutions for the current printer */
   setRslOp       = 5,  /* set resolutions for a TPrint record */
   draftBitsOp    = 6,  /* force enhanced draft-quality printing */
   noDraftBitsOp  = 7,  /* cancel enhanced draft-quality printing */
   getRotnOp      = 8,  /* get page orientation of a TPrint record */

   /* result code from PrGeneral */
   noSuchRsl      = 1,  /* resolution not supported */
};


/*Data Types
struct TPrint {         / print record /
   short    iPrVersion; / reserved /
   TPrInfo  prInfo;     / resolution of device & page rectangle /
   Rect     rPaper;     / paper rectangle /
   TPrStl   prStl;      / printer driver number & feed type /
   TPrInfo  prInfoPT;   / reserved /
   TPrXInfo prXInfo;    / reserved /
   TPrJob   prJob;      / information from the job dialog box / 
   short    printX[19]; / reserved /
};
typedef struct TPrint TPrint;
typedef TPrint TPPrint, THPrint;
struct TPrInfo {        / printer information record /
   short    iDev;       / reserved /
   short    iVRes;      / vertical resolution of printer, in dpi /
   short    iHRes;      / horizontal resolution of printer, in dpi /
   Rect     rPage;      / the page rectangle /
};
typedef struct TPrInfo TPrInfo;
typedef TPrInfo TPPrInfo;
struct TPrJob {         / print job record /
   short    iFstPage;   / first page of page range /
   short    iLstPage;   / last page of page range /
   short    iCopies;    / number of copies /
   char     bJDocLoop;  / printing method: draft or deferred /
   Boolean  fFromUsr;   / reserved /
   PrIdleProcPtr
            pIdleProc;  / pointer to an idle procedure /
   StringPtr
            pFileName;  / spool filename: NIL for default /
   short    iFileVol;   / spool file volume; set to 0 initially /
   char     bFileVers;  / spool file version; set to 0 initially /
   char     bJobX;      / reserved /
};
typedef struct TPrJob TPrJob;
typedef TPrJob TPPrJob;
struct TPrStl {      / printing style record /
   short    wDev;    / device number of printer /
   short    iPageV;  / reserved /
   short    iPageH;  / reserved /
   char     bPort;   / reserved /
   TFeed    feed;    / feed type /
};
typedef struct TPrStl TPrStl;
typedef TPrStl TPPrStl;
struct TPrStatus {         / printing status record /
   short       iTotPages;  / total pages in print file /
   short       iCurPage;   / current page number /
   short       iTotCopies; / total copies requested /
   short       iCurCopy;   / current copy number /
   short       iTotBands;  / reserved /
   short       iCurBand;   / reserved /
   Boolean     fPgDirty;   / TRUE if current page has been written to /
   Boolean     fImaging;   / reserved /
   THPrint     hPrint;     / handle to the active TPrint record /
   TPPrPort    pPrPort;    / pointer to the active printing graphics port /
   PicHandle   hPic;       / handle to the active picture /
};
typedef struct TPrStatus TPrStatus;
typedef TPrStatus TPPrStatus;
struct TPrDlg {               / print dialog box record /
   DialogRecord   Dlg;        / a dialog record /
   ModalFilterProcPtr
                  pFltrProc;  / pointer to event filter /
   PItemProcPtr   pItemProc;  / pointer to item-handling function /
   THPrint        hPrintUsr;  / handle to a TPrint record /
   Boolean        fDoIt;      / TRUE means user clicked OK /
   Boolean        fDone;      / TRUE means user clicked OK or Cancel /
   long           lUser1;     / storage for your application /
   long           lUser2;     / storage for your application /
   long           lUser3;     / storage for your application /
   long           lUser4;     / storage for your application /
};
typedef struct TPrDlg TPrDlg;
typedef TPrDlg TPPrDlg;
typedef pascal TPPrDlg (PDlgInitProcPtr)(THPrint hPrint);
truct TPrPort {         / printing graphics port record /
   GrafPort gPort;      / graphics port for printing /
   QDProcs  gProcs;     / procedures for printing in the graphics port /
   long     lGParam1;   / reserved /
   long     lGParam2;   / reserved /
   long     lGParam3;   / reserved /
   long     lGParam4;   / reserved /
   Boolean  fOurPtr;    / reserved /
   Boolean  fOurBits;   / reserved /
};
typedef struct TPrPort TPrPort;
typedef TPrPort TPPrPort;
enum {feedCut,feedFanfold,feedMechCut,feedOther};
typedef unsigned char TFeed;
enum {scanTB,scanBT,scanLR,scanRL};
typedef unsigned char TScan;
typedef Rect TPRect;
typedef pascal void (PrIdleProcPtr)(void);
typedef pascal void (PItemProcPtr)(DialogPtr theDialog, short item);
/ structures used by PrGeneral /
struct TGnlData {
   short iOpCode;    / opcode passed to PrGeneral /
   short iError;     / result code returned by PrGeneral /
   long  lReserved;  / more fields here depending on call /
};
typedef struct TGnlData TGnlData;
struct TGetRslBlk {        / get-resolution record /
   short    iOpCode;       / the getRslDataOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   short    iRgType;       / printer driver version number /
   TRslRg   xRslRg;        / x-direction resolution range /
   TRslRg   yRslRg;        / y-direction resolution range /
   short    iRslRecCnt;    / number of resolution records /
   TRslRec  rgRslRec[27];  / array of resolution records /
};
typedef struct TGetRslBlk TGetRslBlk;
struct TRslRg {   
   short    iMin;          / minimum resolution supported /
   short    iMax;          / maximum resolution supported /
};
typedef struct TRslRg TRslRg;
struct TRslRec {  
   short    iXRsl;         / discrete resolution, x direction /
   short    iYRsl;         / discrete resolution, y direction /
};
typedef struct TRslRec TRslRec;
struct TSetRslBlk {        / set-resolution record /
   short    iOpCode;       / the setRslOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   THPrint  hPrint;        / handle to the current TPrint record /
   short    iXRsl;         / x-direction resolution you want /
   short    iYRsl;         / y-direction resolution you want /
};
typedef struct TSetRslBlk TSetRslBlk;
struct TDftBitsBlk {       / draft bits record /
   short    iOpCode;       / draftBitsOp or noDraftBitsOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   THPrint  hPrint;        / handle to the current TPrint record /
};
typedef struct TDftBitsBlk TDftBitsBlk;
struct TGetRotnBlk {       / page orientation record /
   short    iOpCode;       / the getRotnOp opcode /
   short    iError;        / result code returned by PrGeneral /
   long     lReserved;     / reserved /
   THPrint  hPrint;        / handle to current TPrint record /
   Boolean  fLandscape;    / TRUE if user selected landscape printing /
   char     bXtra;         / reserved /
};
typedef struct TGetRotnBlk TGetRotnBlk;*/

struct TRslRec {  
   short    iXRsl;         /* discrete resolution, x direction */
   short    iYRsl;         /* discrete resolution, y direction */
};
typedef struct TRslRec TRslRec;

struct TRslRg {   
   short    iMin;          /* minimum resolution supported */
   short    iMax;          /* maximum resolution supported */
};
typedef struct TRslRg TRslRg;


typedef pascal void (*PItemProcPtr)(DialogPtr theDialog, short item);

struct TPrPort {         /* printing graphics port record */
   GrafPort gPort;      /* graphics port for printing */
   QDProcs  gProcs;     /* procedures for printing in the graphics port */
   long     lGParam1;   /* reserved */
   long     lGParam2;   /* reserved */
   long     lGParam3;   /* reserved */
   long     lGParam4;   /* reserved */
   Boolean  fOurPtr;    /* reserved */
   Boolean  fOurBits;   /* reserved */
};
typedef struct TPrPort TPrPort;
typedef TPrPort *TPPrPort;


typedef pascal void (*PrIdleProcPtr)(void);


struct TPrJob {         /* print job record */
   short    iFstPage;   /* first page of page range */
   short    iLstPage;   /* last page of page range */
   short    iCopies;    /* number of copies */
   char     bJDocLoop;  /* printing method: draft or deferred */
   Boolean  fFromUsr;   /* reserved */
   PrIdleProcPtr
            pIdleProc;  /* pointer to an idle procedure */
   StringPtr
            pFileName;  /* spool filename: NIL for default */
   short    iFileVol;   /* spool file volume; set to 0 initially */
   char     bFileVers;  /* spool file version; set to 0 initially */
   char     bJobX;      /* reserved */
};
typedef struct TPrJob TPrJob;
typedef TPrJob *TPPrJob;


enum {feedCut,feedFanfold,feedMechCut,feedOther};
typedef unsigned char TFeed;


struct TPrStl {      /* printing style record */
   short    wDev;    /* device number of printer */
   short    iPageV;  /* reserved */
   short    iPageH;  /* reserved */
   char     bPort;   /* reserved */
   TFeed    feed;    /* feed type */
};
typedef struct TPrStl TPrStl;
typedef TPrStl *TPPrStl;


struct TPrInfo {        /* printer information record */
   short    iDev;       /* reserved */
   short    iVRes;      /* vertical resolution of printer, in dpi */
   short    iHRes;      /* horizontal resolution of printer, in dpi */
   Rect     rPage;      /* the page rectangle */
};
typedef struct TPrInfo TPrInfo;
typedef TPrInfo *TPPrInfo;


struct TPrint {         /* print record */
   short    iPrVersion; /* reserved */
   TPrInfo  prInfo;     /* resolution of device & page rectangle */
   Rect     rPaper;     /* paper rectangle */
   TPrStl   prStl;      /* printer driver number & feed type */
   TPrInfo  prInfoPT;   /* reserved */
   TPrXInfo prXInfo;    /* reserved */
   TPrJob   prJob;      /* information from the job dialog box */ 
   short    printX[19]; /* reserved */
};
typedef struct TPrint TPrint;
typedef TPrint *TPPrint, **THPrint;


struct TPrStatus {         /* printing status record */
   short       iTotPages;  /* total pages in print file */
   short       iCurPage;   /* current page number */
   short       iTotCopies; /* total copies requested */
   short       iCurCopy;   /* current copy number */
   short       iTotBands;  /* reserved */
   short       iCurBand;   /* reserved */
   Boolean     fPgDirty;   /* TRUE if current page has been written to */
   Boolean     fImaging;   /* reserved */
   THPrint     hPrint;     /* handle to the active TPrint record */
   TPPrPort    pPrPort;    /* pointer to the active printing graphics port */
   PicHandle   hPic;       /* handle to the active picture */
};
typedef struct TPrStatus TPrStatus;
typedef TPrStatus *TPPrStatus;
struct TPrDlg {               /* print dialog box record */
   DialogRecord   Dlg;        /* a dialog record */
   ModalFilterProcPtr
                  pFltrProc;  /* pointer to event filter */
   PItemProcPtr   pItemProc;  /* pointer to item-handling function */
   THPrint        hPrintUsr;  /* handle to a TPrint record */
   Boolean        fDoIt;      /* TRUE means user clicked OK */
   Boolean        fDone;      /* TRUE means user clicked OK or Cancel */
   long           lUser1;     /* storage for your application */
   long           lUser2;     /* storage for your application */
   long           lUser3;     /* storage for your application */
   long           lUser4;     /* storage for your application */
};
typedef struct TPrDlg TPrDlg;
typedef TPrDlg *TPPrDlg;
typedef pascal TPPrDlg (*PDlgInitProcPtr)(THPrint hPrint);
enum {scanTB,scanBT,scanLR,scanRL};
typedef unsigned char TScan;
typedef Rect *TPRect;


/* structures used by PrGeneral */
struct TGnlData {
   short iOpCode;    /* opcode passed to PrGeneral */
   short iError;     /* result code returned by PrGeneral */
   long  lReserved;  /* more fields here depending on call */
};
typedef struct TGnlData TGnlData;
struct TGetRslBlk {        /* get-resolution record */
   short    iOpCode;       /* the getRslDataOp opcode */
   short    iError;        /* result code returned by PrGeneral */
   long     lReserved;     /* reserved */
   short    iRgType;       /* printer driver version number */
   TRslRg   xRslRg;        /* x-direction resolution range */
   TRslRg   yRslRg;        /* y-direction resolution range */
   short    iRslRecCnt;    /* number of resolution records */
   TRslRec  rgRslRec[27];  /* array of resolution records */
};
typedef struct TGetRslBlk TGetRslBlk;

struct TSetRslBlk {        /* set-resolution record */
   short    iOpCode;       /* the setRslOp opcode */
   short    iError;        /* result code returned by PrGeneral */
   long     lReserved;     /* reserved */
   THPrint  hPrint;        /* handle to the current TPrint record */
   short    iXRsl;         /* x-direction resolution you want */
   short    iYRsl;         /* y-direction resolution you want */
};
typedef struct TSetRslBlk TSetRslBlk;
struct TDftBitsBlk {       /* draft bits record */
   short    iOpCode;       /* draftBitsOp or noDraftBitsOp opcode */
   short    iError;        /* result code returned by PrGeneral */
   long     lReserved;     /* reserved */
   THPrint  hPrint;        /* handle to the current TPrint record */
};
typedef struct TDftBitsBlk TDftBitsBlk;
struct TGetRotnBlk {       /* page orientation record */
   short    iOpCode;       /* the getRotnOp opcode */
   short    iError;        /* result code returned by PrGeneral */
   long     lReserved;     /* reserved */
   THPrint  hPrint;        /* handle to current TPrint record */
   Boolean  fLandscape;    /* TRUE if user selected landscape printing */
   char     bXtra;         /* reserved */
};
typedef struct TGetRotnBlk TGetRotnBlk;

//function

/*Opening and Closing the Printing Manager
pascal void PrOpen              (void); 
pascal void PrClose             (void); */
pascal void PrOpen              (void); 
pascal void PrClose             (void); 

/*Handling Printing Errors
pascal short PrError            (void); 
pascal void PrSetError          (short iErr);*/
pascal short PrError            (void); 

/*Displaying and Customizing the Print Dialog Boxes
pascal Boolean PrStlDialog      (THPrint hPrint); 
pascal Boolean PrJobDialog      (THPrint hPrint); 
pascal Boolean PrDlgMain        (THPrint hPrint, PDlgInitProcPtr pDlgInit); 
pascal TPPrDlg PrStlInit        (THPrint hPrint); 
pascal TPPrDlg PrJobInit        (THPrint hPrint); 
pascal void PrJobMerge          (THPrint hPrintSrc, THPrint hPrintDst); */
pascal Boolean PrStlDialog      (THPrint hPrint); 
pascal Boolean PrJobDialog      (THPrint hPrint); 

/*Printing a Document
pascal TPPrPort PrOpenDoc       (THPrint hPrint, TPPrPort pPrPort, Ptr pIOBuf); 
pascal void PrCloseDoc          (TPPrPort pPrPort); 
pascal void PrOpenPage          (TPPrPort pPrPort, TPRect pPageFrame); 
pascal void PrClosePage         (TPPrPort pPrPort); 
pascal void PrPicFile           (THPrint hPrint, TPPrPort pPrPort, Ptr pIOBuf,
                                 Ptr pDevBuf, TPrStatus *prStatus); */
pascal TPPrPort PrOpenDoc       (THPrint hPrint, TPPrPort pPrPort, Ptr pIOBuf); 
pascal void PrCloseDoc          (TPPrPort pPrPort); 
pascal void PrOpenPage          (TPPrPort pPrPort, TPRect pPageFrame); 
pascal void PrClosePage         (TPPrPort pPrPort); 
pascal void PrPicFile           (THPrint hPrint, TPPrPort pPrPort, Ptr pIOBuf,
                                 Ptr pDevBuf, TPrStatus *prStatus); 

/*Initializing and Validating TPrint Records
pascal void PrintDefault        (THPrint hPrint); 
pascal Boolean PrValidate       (THPrint hPrint); */
pascal void PrintDefault        (THPrint hPrint); 
pascal Boolean PrValidate       (THPrint hPrint);

/*Displaying and Customizing the Print Dialog Boxes
pascal Boolean PrStlDialog      (THPrint hPrint); 
pascal Boolean PrJobDialog      (THPrint hPrint); 
pascal Boolean PrDlgMain        (THPrint hPrint, PDlgInitProcPtr pDlgInit); 
pascal TPPrDlg PrStlInit        (THPrint hPrint); 
pascal TPPrDlg PrJobInit        (THPrint hPrint); 
pascal void PrJobMerge          (THPrint hPrintSrc, THPrint hPrintDst); */
pascal Boolean PrDlgMain        (THPrint hPrint, PDlgInitProcPtr pDlgInit);
pascal TPPrDlg PrJobInit        (THPrint hPrint);

#ifdef __cplusplus
}
#endif

#endif 
