#ifndef CICONTEXT_H
#define   CICONTEXT_H

#import <QuartzCore/CIImage.h>
#import <OpenGL/CGLTypes.h>

#include <HYS/QuartzCore/CIContext.h>
#include <Foundation/NSDate.h>
#include <AppKit/NSGraphicsContext.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSResponder.h>
#include <AppKit/NSEvent.h>
@class CIFilter;

@interface CIContext: NSObject

/*contextWithCGLContext:pixelFormat:options:

Creates a Core Image context from a CGL context, using the specified options and pixel format object.

+ contextWithCGLContext:(CGLContextObj)ctx pixelFormat:(CGLPixelFormatObj)pf options:(NSDictionary *)dict
Parameters
ctx

A CGL context (CGLContextObj) obtain by calling the CGL function CGLCreateContext. 
pf

A CGL pixel format object (CGLPixelFormatObj) created by calling the CGL function CGLChoosePixelFormat. This argument must be the same pixel format object used to create the CGL context. The pixel format object must be valid for the lifetime of the Core Image context. Don’t release the pixel format object until after you release the Core Image context. 
options

A dictionary that contains color space information. You can provide the keys kCIContextOutputColorSpace or kCIContextWorkingColorSpace along with a CGColorSpaceRef for each color space.
Discussion

After calling this method, Core Image draws content into the drawable object attached to the CGL context. A CGL context is an Mac OS X OpenGL context. For more information, see OpenGL Programming Guide for Mac OS X.

For best results, follow these guidelines when you use Core Image to render into an OpenGL context:
Ensure that the a single unit in the coordinate space of the OpenGL context represents a single pixel in the output device.
The Core Image coordinate space has the origin in the bottom left corner of the screen. You should configure the OpenGL context in the same way.
The OpenGL context blending state is respected by Core Image. If the image you want to render contains translucent pixels, it’s best to enable blending using a blend function with the parameters GL_ONE, GL_ONE_MINUS_SRC_ALPHA, as shown in the following code example.

Some typical initialization code for a view with width W and height H is:    glViewport (0, 0, W, H);
    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    glOrtho (0, W, 0, H, -1, 1);
    glMatrixMode (GL_MODELVIEW);
    glLoadIdentity ();
    glBlendFunc (GL_ONE, GL_ONE_MINUS_SRC_ALPHA);
    glEnable (GL_BLEND);

Availability
Mac OS X v10.4 and later.*/
+ contextWithCGLContext:(CGLContextObj)ctx pixelFormat:(CGLPixelFormatObj)pf options:(NSDictionary *)dict;

/*drawImage:inRect:fromRect:

Renders a region of an image to a rectangle in the context destination.

- (void)drawImage:(CIImage *)im inRect:(CGRect)dest fromRect:(CGRect)src
Parameters
im

A CIImage object.
dest

The rectangle in the context destination to draw into.
src

The region of the image to draw.
Discussion

You can call this method to force evaluation of the result after you apply a filter using one of the apply methods.
Availability
Mac OS X v10.4 and later.*/
- (void)drawImage:(CIImage *)im inRect:(CGRect)dest fromRect:(CGRect)src;

/*createCGImage:fromRect:

Creates a Quartz 2D image from a region of a CIImage object.

- (CGImageRef)createCGImage:(CIImage *)im fromRect:(CGRect)r
Parameters
im

A CIImage object.
r

The region of the image to render.
Return Value

A Quartz 2D (CGImageRef) image. You are responsible for releasing the returned image when you no longer need it.
Discussion

Renders a region of an image into a temporary buffer using the context, then creates and returns a Quartz 2D image with the results.
Availability
Mac OS X v10.4 and later.*/
- (CGImageRef)createCGImage:(CIImage *)im fromRect:(CGRect)r;

/*drawImage:atPoint:fromRect:

Renders a region of an image to a point in the context destination.

- (void)drawImage:(CIImage *)im atPoint:(CGPoint)p fromRect:(CGRect)src
Parameters
im

A CIImage object.
p

The point in the context destination to draw to.
src

The region of the image to draw.
Discussion

You can call this method to force evaluation of the result after you apply a filter using one of the apply methods.
Availability
Mac OS X v10.4 and later.*/
- (void)drawImage:(CIImage *)im atPoint:(CGPoint)p fromRect:(CGRect)src;

/*contextWithCGContext:options:

Creates a Core Image context from a Quartz context, using the specified options.

+ contextWithCGContext:(CGContextRef)ctx options:(NSDictionary *)dict
Parameters
ctx

A Quartz graphics context (CGContextRef) either obtained from the system or created using a Quartz function such as CGBitmapContextCreate. See Quartz 2D Programming Guide for information on creating Quartz graphics contexts.
dict

A dictionary that contains color space information. You can provide the keys kCIContextOutputColorSpace or kCIContextWorkingColorSpace along with a CGColorSpaceRef for each color space.
Discussion

After calling this method, Core Image draws content to the specified Quartz graphics context.
Availability
Mac OS X v10.4 and later.*/
+ contextWithCGContext:(CGContextRef)ctx options:(NSDictionary *)dict;

/*createCGLayerWithSize:info:

Creates a CGLayer object from the specified parameters.

- (CGLayerRef)createCGLayerWithSize:(CGSize)size info:(CFDictionaryRef)d
Parameters
size

The size, in default user space units, of the layer relative to the graphics context.
d

Reserved for future use. Pass NULL.
Return Value

A CGLayer (CGLayerRef) object. 
Discussion

After calling this method, Core Image draws content into the CGLayer object. Core Image creates a CGLayer by calling the Quartz 2D function CGLayerCreateWithContext, whose prototype is:CGLayerRef CGLayerCreateWithContext (
   CGContextRef context,
   CGSize size,
   CFDictionaryRef auxiliaryInfo
);


Core Image passes the CIContext object as the context parameter, the size as the size parameter, and the dictionary as the auxiliaryInfo parameter. For more information on CGLayer objects, see Quartz 2D Programming Guide and CGLayer Reference.
Availability
Mac OS X v10.4 and later.
See Also
+ imageWithCGLayer:
+ imageWithCGLayer:options:*/
- (CGLayerRef)createCGLayerWithSize:(CGSize)size info:(CFDictionaryRef)d;

/*Constants

The following constants define keys that can be passed in an options dictionary when you create a context.
Constant	
Description
kCIContextOutputColorSpace	
Specifies the color space to use for images before they are rendered to the context. By default, Core Image uses the GenericRGB color space, which leaves color matching to the system. You can specify a different output color space by providing a Quartz 2D CGColorSpace object (CGColorSpaceRef). (See Quartz 2D Programming Guide for information on creating and using CGColorspace objects.)
kCIContextWorkingColorSpace	
Specifies a color space to use for image operations. By default, Core Image assumes that processing nodes are 128 bits-per-pixel, linear light, premultiplied RGBA floating-point values that use the GenericRGB color space. You can specify a different working color space by providing a Quartz 2D CGColorSpace object (CGColorSpaceRef). Note that the working color space must be RGB-based. If you have YUV data as input (or other data that is not RGB-based), you can use ColorSync functions to convert to the working color space. (See Quartz 2D Programming Guide for information on creating and using CGColorspace objects.)
kCIContextUseSoftwareRenderer	
Specifies whether or not to require the software renderer. If that associated NSNumber object is YES, then the software renderer is required.*/
APPKIT_EXPORT NSString *kCIContextOutputColorSpace;
APPKIT_EXPORT NSString *kCIContextWorkingColorSpace;
APPKIT_EXPORT NSString *kCIContextUseSoftwareRenderer;

@end 




#endif