
#ifndef SECKEYCHAINITEM_H
#define SECKEYCHAINITEM_H

#include <Security/SecBase.h>
#include <Security/cssmapple.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*Keychain Item Class Constants

Specifies a keychain item’s class code.

typedef FourCharCode SecItemClass;
enum
{
   /SecKeychainItem.h *
   kSecInternetPasswordItemClass   = 'inet',
   kSecGenericPasswordItemClass    = 'genp',
   kSecAppleSharePasswordItemClass = 'ashp',
   kSecCertificateItemClass        =
   CSSM_DL_DB_RECORD_X509_CERTIFICATE,
};
enum
{
   /Record Types defined in The Open Group Application Name Space  *
   / cssmtype.h *
   CSSM_DL_DB_RECORD_PUBLIC_KEY =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 5,
   CSSM_DL_DB_RECORD_PRIVATE_KEY =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 6,
   CSSM_DL_DB_RECORD_SYMMETRIC_KEY =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 7,
   CSSM_DL_DB_RECORD_ALL_KEYS =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 8
};
Constants
kSecInternetPasswordItemClass

Indicates that the item is an Internet password.

Available in Mac OS X v10.2 and later.
kSecGenericPasswordItemClass

Indicates that the item is a generic password.

Available in Mac OS X v10.2 and later.
kSecAppleSharePasswordItemClass

Indicates that the item is an AppleShare password.

Available in Mac OS X v10.2 and later.
kSecCertificateItemClass

Indicates that the item is an X509 certificate.

Available in Mac OS X v10.2 and later.
CSSM_DL_DB_RECORD_PUBLIC_KEY

Indicates that the item is a public key of a public-private pair.

Available in Mac OS X v10.0 and later.
CSSM_DL_DB_RECORD_PRIVATE_KEY

Indicates that the item is a private key of a public-private pair.

Available in Mac OS X v10.0 and later.
CSSM_DL_DB_RECORD_SYMMETRIC_KEY

Indicates that the item is a private key used for symmetric-key encryption.

Available in Mac OS X v10.0 and later.
CSSM_DL_DB_RECORD_ALL_KEYS

The item can be any type of key; used for searches only.

Available in Mac OS X v10.0 and later.
Discussion

These enumerations define constants your application can use to specify the type of the keychain item you wish to create, dispose, add, delete, update, copy, or locate. You can also use these constants with the tag constant SecItemAttr.
Declared In
SecKeychainItem.h, cssmtype.h.*/
typedef FourCharCode SecItemClass;
enum
{
   /* SecKeychainItem.h */
   kSecInternetPasswordItemClass   = 'inet',
   kSecGenericPasswordItemClass    = 'genp',
   kSecAppleSharePasswordItemClass = 'ashp',
   kSecCertificateItemClass        =\
   CSSM_DL_DB_RECORD_X509_CERTIFICATE,
};

/*Keychain Item Attribute Constants

Specifies a keychain item’s attributes.

typedef FourCharCode SecItemAttr;
enum
{
   kSecCreationDateItemAttr        = 'cdat',
   kSecModDateItemAttr             = 'mdat',
   kSecDescriptionItemAttr         = 'desc',
   kSecCommentItemAttr             = 'icmt',
   kSecCreatorItemAttr             = 'crtr',
   kSecTypeItemAttr                = 'type',
   kSecScriptCodeItemAttr          = 'scrp',
   kSecLabelItemAttr               = 'labl',
   kSecInvisibleItemAttr           = 'invi',
   kSecNegativeItemAttr            = 'nega',
   kSecCustomIconItemAttr          = 'cusi',
   kSecAccountItemAttr             = 'acct',
   kSecServiceItemAttr             = 'svce',
   kSecGenericItemAttr             = 'gena',
   kSecSecurityDomainItemAttr      = 'sdmn',
   kSecServerItemAttr              = 'srvr',
   kSecAuthenticationTypeItemAttr  = 'atyp',
   kSecPortItemAttr                = 'port',
   kSecPathItemAttr                = 'path',
   kSecVolumeItemAttr              = 'vlme',
   kSecAddressItemAttr             = 'addr',
   kSecSignatureItemAttr           = 'ssig',
   kSecProtocolItemAttr            = 'ptcl',
   kSecCertificateType             = 'ctyp',
   kSecCertificateEncoding         = 'cenc',
   kSecCrlType                     = 'crtp',
   kSecCrlEncoding                 = 'crnc',
   kSecAlias                       = 'alis'
};
Constants
kSecCreationDateItemAttr

Identifies the creation date attribute. You use this tag to set or get a value of type UInt32 that indicates the date the item was created.

Available in Mac OS X v10.2 and later.
kSecModDateItemAttr

Identifies the modification date attribute. You use this tag to set or get a value of type UInt32 that indicates the last time the item was updated.

Available in Mac OS X v10.2 and later.
kSecDescriptionItemAttr

Identifies the description attribute. You use this tag to set or get a user-visible UTF-8 string describing this particular kind of item, for example “disk image password”.

Available in Mac OS X v10.2 and later.
kSecCommentItemAttr

Identifies the comment attribute. You use this tag to set or get a user-editable UTF-8 character string containing comments for this item.

Available in Mac OS X v10.2 and later.
kSecCreatorItemAttr

Identifies the creator attribute. You use this tag to set or get a value that represents the item’s creator.

Available in Mac OS X v10.2 and later.
kSecTypeItemAttr

Identifies the type attribute. You use this tag to set or get a value that represents the item’s type.

Available in Mac OS X v10.2 and later.
kSecScriptCodeItemAttr

Identifies the script code attribute. You use this tag to set or get a value of type ScriptCode that represents the script code for all strings. Use of this attribute is deprecated; string attributes should be stored in UTF-8 encoding.

Available in Mac OS X v10.2 and later.
kSecLabelItemAttr

Identifies the label attribute. You use this tag to set or get a user-editable string containing the label for this item. You should store a UTF-8 string. However, because some servers might store this string in a different format, you should be prepared to handle the situation if a retrieved string is not in UTF-8 format.

Available in Mac OS X v10.2 and later.
kSecInvisibleItemAttr

Identifies the invisible attribute. You use this tag to set or get a value of type Boolean that indicates whether the item is invisible.

Available in Mac OS X v10.2 and later.
kSecNegativeItemAttr

Identifies the negative attribute. You use this tag to set or get a value of type Boolean that indicates whether there is a valid password associated with this keychain item. This is useful if your application doesn’t want a password for some particular service to be stored in the keychain, but prefers that it always be entered by the user. The item, which is typically invisible and with zero-length data, acts as a placeholder.

Available in Mac OS X v10.2 and later.
kSecCustomIconItemAttr

Identifies the custom icon attribute. You use this tag to set or get a value of type Boolean that indicates whether the item has an application-specific icon. To do this, you must also set the attribute value identified by the tag kSecTypeItemAttr to a file type for which there is a corresponding icon in the desktop database, and set the attribute value identified by the tag kSecCreatorItemAttr to an appropriate application creator type. If a custom icon corresponding to the item’s type and creator can be found in the desktop database, it will be displayed by Keychain Access. Otherwise, default icons are used.

Available in Mac OS X v10.2 and later.
kSecAccountItemAttr

Identifies the account attribute. You use this tag to set or get a string that represents the user account. It also applies to generic and AppleShare passwords.

Available in Mac OS X v10.2 and later.
kSecServiceItemAttr

Identifies the service attribute. You use this tag to set or get a string that represents the service associated with this item, for example, “iTools”. This is unique to generic password attributes.

Available in Mac OS X v10.2 and later.
kSecGenericItemAttr

Identifies the generic attribute. You use this tag to set or get a value of untyped bytes that represents a user-defined attribute. This is unique to generic password attributes.

Available in Mac OS X v10.2 and later.
kSecSecurityDomainItemAttr

Identifies the security domain attribute. You use this tag to set or get a value that represents the Internet security domain. This is unique to Internet password attributes.

Available in Mac OS X v10.2 and later.
kSecServerItemAttr

Identifies the server attribute. You use this tag to set or get a string that represents the Internet server’s domain name or IP address. This is unique to Internet password attributes.

Available in Mac OS X v10.2 and later.
kSecAuthenticationTypeItemAttr

Identifies the authentication type attribute. You use this tag to set or get a value of type SecAuthenticationType that represents the Internet authentication scheme. For possible authentication values, see “Keychain Authentication Type Constants”. This is unique to Internet password attributes.

Available in Mac OS X v10.2 and later.
kSecPortItemAttr

Identifies the port attribute. You use this tag to set or get a value of type UInt32 that represents the Internet port number. This is unique to Internet password attributes.

Available in Mac OS X v10.2 and later.
kSecPathItemAttr

Identifies the path attribute. You use this tag to set or get a value that represents the path. This is unique to Internet password attributes.

Available in Mac OS X v10.2 and later.
kSecVolumeItemAttr

Identifies the volume attribute. You use this tag to set or get a value that represents the AppleShare volume. This is unique to AppleShare password attributes.

Available in Mac OS X v10.2 and later.
kSecAddressItemAttr

Identifies the address attribute. You use this tag to set or get a UTF-8 string that contains the AppleTalk zone name, or the IP or domain name that represents the server address. This is unique to AppleShare password attributes.

Available in Mac OS X v10.2 and later.
kSecSignatureItemAttr

Identifies the server signature attribute. You use this tag to set or get a value of type SecAFPServerSignature that represents the server signature block. This is unique to AppleShare password attributes.

Available in Mac OS X v10.2 and later.
kSecProtocolItemAttr

Identifies the protocol attribute. You use this tag to set or get a value of type SecProtocolType that represents the Internet protocol. For possible protocol type values, see “Keychain Protocol Type Constants”. This is unique to AppleShare and Internet password attributes.

Available in Mac OS X v10.2 and later.
kSecCertificateType

Indicates a CSSM_CERT_TYPE type.

Available in Mac OS X v10.2 and later.
kSecCertificateEncoding

Indicates a CSSM_CERT_ENCODING type.

Available in Mac OS X v10.2 and later.
kSecCrlType

Indicates a CSSM_CRL_TYPE type.

Available in Mac OS X v10.2 and later.
kSecCrlEncoding

Indicates a CSSM_CRL_ENCODING type.

Available in Mac OS X v10.2 and later.
kSecAlias

Indicates an alias.

Available in Mac OS X v10.2 and later.
Discussion

Not all of these attributes are used for all types of items. Which set of attributes exist for each type of item is documented in the “Data Storage Library Services” chapter of Common Security: CDSA and CSSM, version 2 (with corrigenda) from The Open Group (http://www.opengroup.org/security/cdsa.htm) for standard items and in the DL section of the Security Release Notes for Apple-defined item types (if any). 

To obtain information about a certificate, use the CDSA Certificate Library (CL) API. To obtain information about a key, use the SecKeyGetCSSMKey function and the CDSA Cryptographic Service Provider (CSP) API. 

For attributes for keys, see “Keychain Item Attribute Constants For Keys”.*/

typedef FourCharCode SecItemAttr;
enum
{
   kSecCreationDateItemAttr        = 'cdat',
   kSecModDateItemAttr             = 'mdat',
   kSecDescriptionItemAttr         = 'desc',
   kSecCommentItemAttr             = 'icmt',
   kSecCreatorItemAttr             = 'crtr',
   kSecTypeItemAttr                = 'type',
   kSecScriptCodeItemAttr          = 'scrp',
   kSecLabelItemAttr               = 'labl',
   kSecInvisibleItemAttr           = 'invi',
   kSecNegativeItemAttr            = 'nega',
   kSecCustomIconItemAttr          = 'cusi',
   kSecAccountItemAttr             = 'acct',
   kSecServiceItemAttr             = 'svce',
   kSecGenericItemAttr             = 'gena',
   kSecSecurityDomainItemAttr      = 'sdmn',
   kSecServerItemAttr              = 'srvr',
   kSecAuthenticationTypeItemAttr  = 'atyp',
   kSecPortItemAttr                = 'port',
   kSecPathItemAttr                = 'path',
   kSecVolumeItemAttr              = 'vlme',
   kSecAddressItemAttr             = 'addr',
   kSecSignatureItemAttr           = 'ssig',
   kSecProtocolItemAttr            = 'ptcl',
   kSecCertificateType             = 'ctyp',
   kSecCertificateEncoding         = 'cenc',
   kSecCrlType                     = 'crtp',
   kSecCrlEncoding                 = 'crnc',
   kSecAlias                       = 'alis'
};


//function

/*SecKeychainItemCopyContent

Copies the data and attributes stored in the given keychain item.

OSStatus SecKeychainItemCopyContent (
   SecKeychainItemRef itemRef,
   SecItemClass *itemClass,
   SecKeychainAttributeList *attrList,
   UInt32 *length,
   void **outData
);
Parameters
itemRef

A reference to the keychain item to modify.
itemClass

A pointer to the item’s class. You should pass NULL if it is not required. See “Keychain Item Class Constants” for valid constants.
attrList

A pointer to the list of attributes to get in this item on input; on output the attributes are filled in. You must call SecKeychainItemFreeContent when you no longer need the attributes and data.
length

On return, the length of the buffer pointed to by the outData parameter.
outData

On return, a pointer to a buffer containing the data in this item. You must call SecKeychainItemFreeContent when you no longer need the attributes and data.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

This function returns the data and attributes of a specific keychain item. You can use the SecKeychainSearchCopyNext function to search for a keychain item if you don’t already have the item’s reference object. To find and obtain data from a password keychain item, use the SecKeychainFindInternetPassword or SecKeychainFindGenericPassword function.

You should pair the SecKeychainItemModifyContent function with the SecKeychainItemCopyContent function when dealing with older Keychain Manager functions. The SecKeychainItemCopyAttributesAndData and SecKeychainItemModifyAttributesAndData functions handle more attributes than are support by the old Keychain Manager; however, passing them into older calls yields an invalid attribute error. 

If the keychain item data is encrypted, this function decrypts the data before returning it to you. If the calling application is not in the list of trusted applications, the user is prompted before access is allowed. If the access controls for this item do not allow decryption, the function returns the errSecAuthFailed result code.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/

OSStatus SecKeychainItemCopyContent (
   SecKeychainItemRef itemRef,
   SecItemClass *itemClass,
   SecKeychainAttributeList *attrList,
   UInt32 *length,
   void **outData
);

/*SecKeychainItemModifyContent

Updates an existing keychain item after changing its attributes and/or data.

OSStatus SecKeychainItemModifyContent (
   SecKeychainItemRef itemRef,
   const SecKeychainAttributeList *attrList,
   UInt32 length,
   const void *data
);
Parameters
itemRef

A reference to the keychain item to modify.
attrList

A pointer to the list of attributes to set. Pass NULL if you have no attributes to set.
length

The length of the buffer pointed to by the data parameter. Pass 0 if you pass NULL in the data parameter.
data

A pointer to a buffer containing the data to store. Pass NULL if you do not need to modify the data.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

The keychain item is written to the keychain’s permanent data store. If the keychain item has not previously been added to a keychain, a call to this function does nothing and returns noErr. 

You should pair the SecKeychainItemModifyContent function with the SecKeychainItemCopyContent function when dealing with older Keychain Manager functions. The SecKeychainItemCopyAttributesAndData and SecKeychainItemModifyAttributesAndData functions handle more attributes than are support by the old Keychain Manager; however, passing them into older calls yields an invalid attribute error. 
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/
OSStatus SecKeychainItemModifyContent (
   SecKeychainItemRef itemRef,
   const SecKeychainAttributeList *attrList,
   UInt32 length,
   const void *data
);

/*SecKeychainItemFreeContent

Releases the memory used by the keychain attribute list and/or the keychain data retrieved in a call to the SecKeychainItemCopyContent function.

OSStatus SecKeychainItemFreeContent (
   SecKeychainAttributeList *attrList,
   void *data
);
Parameters
attrList

A pointer to the attribute list to release. Pass NULL if there is no attribute list to release.
data

A pointer to the data buffer to release. Pass NULL if there is no data to release.
Return Value

A result code. See “Keychain Services Result Codes”.
Discussion

Because the SecKeychainFindInternetPassword and SecKeychainFindGenericPassword functions call the SecKeychainItemCopyContent function, you must call SecKeychainItemFreeContent to release the data buffers after calls to those functions as well. 

Because the SecKeychainItemCopyContent function does not allocate buffers until they are needed, you should not call the SecKeychainItemFreeContent function unless data is actually returned to you.
Availability
Available in Mac OS X v10.2 and later.
Declared In
SecKeychainItem.h*/
OSStatus SecKeychainItemFreeContent (
   SecKeychainAttributeList *attrList,
   void *data
);


#if defined(__cplusplus)
}
#endif

#endif 