#import <AppKit/NSAccessibility.h>

@implementation  NSObject (NSAccessibility)

/*accessibilityAttributeValue:

Returns the value of the receiver’s attribute attribute.

- (id)accessibilityAttributeValue:(NSString *)attribute
Discussion

User interface classes must implement this method. Subclasses should invoke the superclass’s implementation, if it exists, if attribute is not implemented in the subclass.
Availability
Available in Mac OS X v10.2 and later.*/
- (id)accessibilityAttributeValue:(NSString *)attribute{}

/*accessibilityAttributeNames

Returns an array of attribute names supported by the receiver.

- (NSArray *)accessibilityAttributeNames
Discussion

User interface classes must implement this method. Subclasses should invoke the superclass’s implementation, if it exists, and append additional attributes or remove unsupported attributes. Some attribute names are defined by Cocoa and are described in the “Constants” section.
Availability
Available in Mac OS X v10.2 and later.*/
- (NSArray *)accessibilityAttributeNames{}


/*accessibilityHitTest:

Returns the deepest descendant of the accessibility hierarchy that contains the point point, which is in lower-left relative screen coordinates.

- (id)accessibilityHitTest:(NSPoint)point
Discussion

You can assume the point has already been determined to lie within the receiver. Override this method to do deeper hit-testing by identifying which child element, if any, contains the point. NSMatrix, for example, identifies which of its cells contains point and propagates the hit-test to it. If point is not contained within one of the receiver’s children, either return self or, if available, invoke the superclass’s implementation. The default NSView and NSCell implementations test whether the receiver is an ignored element and, if so, return the receiver’s first unignored parent; otherwise they return self.
Availability
Available in Mac OS X v10.2 and later.*/
- (id)accessibilityHitTest:(NSPoint)point{}


/*accessibilitySetOverrideValue:forAttribute:

Overrides the receiver’s attribute attribute, or adds it if it does not exist, and sets its value to value.

- (BOOL)accessibilitySetOverrideValue:(id)value forAttribute:(NSString *)attribute
Discussion

This method is for changing the set of attributes on an instance, as an alternative to subclassing. The return value indicates if the override was successful.

This method only works on objects whose class already implements the NSAccessibility protocol. If the specified attribute is already supported by the object, the value specified by this method wins.

If the specified attribute does not exist it is created. This is done outside the NSAccessibility protocol, so accessibilityAttributeNames still returns the old list which does not contain the new attribute. Likewise, accessibilityAttributeValue does not return attributes created by the override process nor does it return their overridden values.

The values of overridden attributes are not settable by assistive applications.

If you need to undo the effect of using this method, call it again passing nil for the value.

Ensure that you invoke this method on the actual object that represents the user interface element. For example, in the case of NSButton, use the underlying NSButtonCell. The NSButton itself is ignored by accessibility.

This method works only on an object representing a single user interface element. So, for example, you cannot use it when a single object represents multiple user interface elements, as with NSSegmentedCell, which has only a single object but provides user interface elements for each segment).
Availability
Available in Mac OS X v10.4 and later.*/
- (BOOL)accessibilitySetOverrideValue:(id)value forAttribute:(NSString *)attribute{}


@end

int NSAccessibilityUnignoredAncestor(int a){};

/*NSAccessibilityPostNotification

Sends a notification to any observing assistive applications.

void NSAccessibilityPostNotification(id element, NSString *notification)
Discussion

Sends notification to any assistive applications that have registered to receive the notification from the user interface object element in your application. Accessibility notifications require special handling, so they cannot be posted using NSNotificationCenter.
Availability
Available in Mac OS X v10.2 and later.*/
void NSAccessibilityPostNotification(id element, NSString *notification){}

/*NSAccessibilityRoleDescription

Returns a standard description for a role and subrole.

NSString *NSAccessibilityRoleDescription(NSString *role, NSString *subrole)
Discussion

You should pass nil to this function if there is no subrole. This function returns a description of a standard role. For example, if you implement a button widget that does not inherit from NSButton, you should use NSAccessibilityRoleDescription to return a localized role description matching that returned by a standard button.
Availability
Available in Mac OS X v10.4 and later.*/
NSString *NSAccessibilityRoleDescription(NSString *role, NSString *subrole){};



/*NSAccessibilityRoleDescriptionForUIElement

Returns a standard role description for a user interface element.

NSString *NSAccessibilityRoleDescriptionForUIElement(id element)
Discussion

This function is like NSAccessibilityRoleDescription, but it queries element to get the role and subrole. NSAccessibilityRoleDescription is more efficient, but this function is useful for accessorizing base classes so that they properly handle derived classes, which may override the subrole or even the role.
Availability
Available in Mac OS X v10.4 and later.*/
NSString *NSAccessibilityRoleDescriptionForUIElement(id element){};


/*NSAccessibilityUnignoredChildren

Returns a list of unignored accessibility objects, descending the hierarchy if necessary.

NSArray *NSAccessibilityUnignoredChildren(NSArray *originalChildren)
Discussion

Returns a copy of originalChildren with any ignored objects in the array replaced by their unignored descendants.
Availability
Available in Mac OS X v10.2 and later.*/
NSArray *NSAccessibilityUnignoredChildren(NSArray *originalChildren){}

/*NSAccessibilityActionDescription

Returns a standard description for an action.

NSString *NSAccessibilityActionDescription(NSString *action)
Discussion

This function returns a standard description for action.
Availability
Available in Mac OS X v10.4 and later.*/
NSString *NSAccessibilityActionDescription(NSString *action){};



/*NSAccessibilityUnignoredDescendant

Returns an unignored accessibility object, descending the hierarchy if necessary.

id NSAccessibilityUnignoredDescendant(id element)
Discussion

Tests whether element is an ignored object, returning either element, if it is not ignored, or the first unignored descendant of element. Use this function only if you know there is a linear, one-to-one, hierarchy below element. Otherwise, if element has either no unignored children or multiple unignored children, this function fails and returns nil.
Availability
Available in Mac OS X v10.2 and later.*/
id NSAccessibilityUnignoredDescendant(id element){};






