#include <AppKit/NSWindow.h>

@implementation NSWindow (hys)
/*frameRectForContentRect:

Returns the receiver’s frame rectangle with a given content rectangle.

- (NSRect)frameRectForContentRect:(NSRect)windowContent
Parameters
windowContent

Content rectangle for the window expressed in screen coordinates.
Return Value

The receiver’s frame rectangle, expressed in screen coordinates, with windowContent.
Discussion

The receiver uses its current style mask in computing the frame rectangle. See “Constants” for a list of style mask values. The major advantage of this instance-method counterpart to frameRectForContentRect:styleMask: is that it allows you to take toolbars into account when converting between content and frame rectangles. (The toolbar is included in the frame rectangle but not the content rectangle.)
Availability
Available in Mac OS X v10.3 and later.
See Also
– contentRectForFrameRect:
+ frameRectForContentRect:styleMask:*/
- (NSRect)frameRectForContentRect:(NSRect)windowContent{}


/*setDisplaysWhenScreenProfileChanges:

Sets whether the window context should be updated when the screen profile changes.

- (void)setDisplaysWhenScreenProfileChanges:(BOOL)flag
Discussion

If flag is NO, the screen profile information for the window context never changes. This is the default setting. If flag is YES, the window context may be changed in the following situations:
A majority of the window is moved to a different screen whose profile is different than the previous screen.
The ColorSync profile of the current screen changes.

After the window context is updated, the window is told to display itself. If you need to update offscreen caches for the window, you should register to receive the NSWindowDidChangeScreenProfileNotification.
Availability
Available in Mac OS X v10.4 and later.
See Also
– displaysWhenScreenProfileChanges*/
- (void)setDisplaysWhenScreenProfileChanges:(BOOL)flag{}


/*setIgnoresMouseEvents:

Specifies whether the receiver is transparent to mouse clicks and other mouse events, allowing overlay windows.

- (void)setIgnoresMouseEvents:(BOOL)flag
Availability
Available in Mac OS X v10.2 and later.
See Also
– ignoresMouseEvents*/
- (void)setIgnoresMouseEvents:(BOOL)flag{}


/*addChildWindow:ordered:

childWin is ordered either above (NSWindowAbove) or below (NSWindowBelow) the receiver, and maintained in that relative place for subsequent ordering operations involving either window.

- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place
Discussion

While this attachment is active, moving childWin will not cause the receiver to move (as in sliding a drawer in or out), but moving the receiver will cause childWin to move.

Note that you should not create cycles between parent and child windows. For example, you should not add window B as child of window A, then add window A as a child of window B.
Availability
Available in Mac OS X v10.2 and later.
See Also
– removeChildWindow:
– childWindows
– parentWindow
– setParentWindow:*/
- (void)addChildWindow:(NSWindow *)childWin ordered:(NSWindowOrderingMode)place{}

/*attachedSheet

Returns the sheet attached to the receiver.

- (NSWindow *)attachedSheet
Return Value

The sheet attached to the receiver.
Discussion

If the receiver does not have a sheet attached, this method returns nil.
Availability
Available in Mac OS X v10.1 and later.*/
- (NSWindow *)attachedSheet{}


/*disableScreenUpdatesUntilFlush

Disables the receiver’s screen updates until the window is flushed.

- (void)disableScreenUpdatesUntilFlush
Discussion

This method can be invoked to synchronize hardware surface flushes with the window’s flushes. The receiver immediately disables screen updates using the function NSDisableScreenUpdates and re-enables screen updates when the window flushes. Sending this message multiple times during a window update cycle has no effect.
Availability
Available in Mac OS X v10.4 and later.*/
- (void)disableScreenUpdatesUntilFlush{}


@end