#import <DiscRecordingEngine/DRCoreErase.h>

/*DREraseCreate


Creates a new eraser. 
extern DREraseRef DREraseCreate(
    DRDeviceRef device) ;  
Parameters
device
A reference to the device to erase. If this parameter is not a valid DRDevice, the behavior is undefined.
Return Value

Returns a reference to a new DRErase opaque type. 
Availability
Introduced in Mac OS X v10.2*/
DREraseRef DREraseCreate(
    DRDeviceRef device) {};  


/*kDREraseStatusChangedNotification

extern const CFStringRef kDREraseStatusChangedNotification ;  
Discussion 

The notification sent when a DRErase object has updated status. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDREraseStatusChangedNotification ;  


/*kDREraseTypeKey

extern const CFStringRef kDREraseTypeKey ;  
Discussion 

This key points to a CFString object describing the type of erase to be performed. If this key is not present, a kDREraseTypeQuick erase type is assumed. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDREraseTypeKey ;  

/*kDREraseTypeComplete

extern const CFStringRef kDREraseTypeComplete ;  
Discussion 

A CFString object indicating the erase operation should erase every byte on the disc. This operation is slow, taking on the order of 30 minutes. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDREraseTypeComplete ;  


/*DREraseSetProperties


Sets the properties of the erase process. 
extern void DREraseSetProperties(
    DREraseRef erase,
    CFDictionaryRef properties) ;  
Parameters
erase
The erase process to set the properties of. If this parameter is not a valid DRErase object, the behavior is undefined.
properties
A CFDictionary object containing the erase properties. If this parameter is not a valid CFDictionary object the behavior is undefined.
Availability
Introduced in Mac OS X v10.2*/
void DREraseSetProperties(
    DREraseRef erase,
    CFDictionaryRef properties) {};  

/*DREraseStart


Begin the erase process. 
extern OSStatus DREraseStart(
    DREraseRef erase) ;  
Parameters
erase
The eraser object that should be started. If this parameter is not a valid DRErase oject, the behavior is undefined.
Return Value

An error code indicating if the erase could be started. 
Availability
Introduced in Mac OS X v10.2*/
OSStatus DREraseStart(
    DREraseRef erase){} ;  

/*kDREraseTypeQuick

extern const CFStringRef kDREraseTypeQuick ;  
Discussion 

A CFString object indicating the erase operation should do the minimal amount of work to make the disc appear blank. This operation typically takes only a minute or two. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDREraseTypeQuick ;  




