#import <Foundation/Foundation.h>

@implementation  NSMetadataQuery


/*setPredicate:

Sets the predicate used by the receiver to filter the query results.

-(void)setPredicate:(NSPredicate *)predicate
Parameters
predicate

A predicate to be used to filter query results.
Discussion

Invoking this method on a receiver running a query causes the existing query to stop, all current results are discarded, and a new query is started immediately.
Availability
Available in Mac OS X v10.4 and later.
See Also
 predicate*/
-(void)setPredicate:(NSPredicate *)predicate{}


/*setDelegate:

Sets the receiver’s delegate

-(void)setDelegate:(id)delegate
Parameters
delegate

An object to serve as the receiver’s delegate. Pass nil to remove the current delegate.
Availability
Available in Mac OS X v10.4 and later.
See Also
– delegate*/
-(void)setDelegate:(id)delegate{}


/*startQuery

Attempts to start the query.

-(BOOL)startQuery
Return Value

YES when successful; NO otherwise.
Discussion

A query can’t be started if the receiver is already running a query or no predicate has been specified.
Availability
Available in Mac OS X v10.4 and later.
See Also
– stopQuery
– isStarted*/
-(BOOL)startQuery{}


/*stopQuery

Stops the receiver’s current query from gathering any further results.

-(void)stopQuery
Discussion

The receiver first completes gathering any unprocessed results. If a query is stopped before the gathering phase finishes, it will not post an NSMetadataQueryDidStartGatheringNotification notification.

You would call this function to stop a query that is generating too many results to be useful but still want to access the available results. If the receiver is sent a startQuery message after performing this method, the existing results are discarded.
Availability
Available in Mac OS X v10.4 and later.
See Also
– startQuery
– isStopped*/
-(void)stopQuery{}


/*results

Returns an array containing the result objects for the receiver.

-(NSArray *)results
Return Value

Proxy array containing query result objects.
Discussion

The results array is a proxy object that is primarily intended for use with Cocoa bindings. While it is possible to copy the proxy array and receive a “snapshot” of the complete current query results, it is generally not recommended due to performance and memory issues. To access individual result array elements you should instead use the resultCount and resultAtIndex: methods.
Availability
Available in Mac OS X v10.4 and later.
See Also
– groupedResults*/
-(NSArray *)results{}



/*valueForAttribute:

Returns the receiver’s metadata attribute name specified by a given key.

-(id)valueForAttribute:(NSString *)key
Parameters
key

The name of a metadata attribute.
Return Value

The receiver’s metadata attribute name specified by key.
Availability
Available in Mac OS X v10.4 and later.*/
-(id)valueForAttribute:(NSString *)key{}


/*setSortDescriptors:

Sets the sort descriptors to be used by the receiver.

-(void)setSortDescriptors:(NSArray *)descriptors
Parameters
descriptors

Array of sort descriptors.
Discussion

Invoking this method on the receiver running a query causes the existing query to stop, all current results are discarded, and a new query is started immediately.
Availability
Available in Mac OS X v10.4 and later.
See Also
– sortDescriptors*/
-(void)setSortDescriptors:(NSArray *)descriptors{}



@end


@implementation NSMetadataItem 
@end
