#ifndef AGL_H
#define AGL_H

#include <AvailabilityMacros.h>
#include <Carbon/Carbon.h>
#include <OpenGL/gl.h>

#ifndef QD_H
#include <QD/QD.h>//hys
#endif

//#include <HYS/AGL/agl.h>



/*Renderer Properties

Specify constants that you can use to query renderer properties.

#define AGL_BUFFER_MODES 100
#define AGL_MIN_LEVEL 101
#define AGL_MAX_LEVEL 102
#define AGL_COLOR_MODES 103
#define AGL_ACCUM_MODES 104
#define AGL_DEPTH_MODES 105
#define AGL_STENCIL_MODES 106
#define AGL_MAX_AUX_BUFFERS 107
#define AGL_VIDEO_MEMORY 120
#define AGL_TEXTURE_MEMORY 121
#define AGL_RENDERER_COUNT 128
Constants
AGL_BUFFER_MODES

The associated value can be a bitwise OR of the any of the constants specified in “Buffer Mode Flags”.
AGL_MIN_LEVEL

The associated value specifies the minimum overlay buffer level. Negative values indicate an underlay buffer.

Available in Mac OS X v10.0 and later.
AGL_MAX_LEVEL

The associated value specifies the maximum overlay buffer level.

Available in Mac OS X v10.0 and later.
AGL_COLOR_MODES

The associated value can be a bitwise OR of any of the constants specified in “Color Modes”. 

Available in Mac OS X v10.0 and later.
AGL_ACCUM_MODES

The associated value can be a bitwise OR of any of the constants specified in “Color Modes”. 

Available in Mac OS X v10.0 and later.
AGL_DEPTH_MODES

The associated value can be the bitwise OR of any of the constants specified in “Bit Depths”.

Available in Mac OS X v10.0 and later.
AGL_STENCIL_MODES

The associated value can be the bitwise OR of any of the constants specified in “Bit Depths”.

Available in Mac OS X v10.0 and later.
AGL_MAX_AUX_BUFFERS

The associated value is the maximum number of auxiliary buffers that can be supported by the renderer.

Available in Mac OS X v10.0 and later.
AGL_VIDEO_MEMORY

The associated value is the amount of video memory.

Available in Mac OS X v10.0 and later.
AGL_TEXTURE_MEMORY

The associated value is the amount of texture memory.

Available in Mac OS X v10.0 and later.
AGL_RENDERER_COUNT

The associated value is the number of renderers.

Available in Mac OS X v10.3 and later.
Discussion

You can pass these constants to the function aglDescribeRenderer to find out the property value for a specific renderer.
Declared In
agl.h*/
#define AGL_BUFFER_MODES 100
#define AGL_MIN_LEVEL 101
#define AGL_MAX_LEVEL 102
#define AGL_COLOR_MODES 103
#define AGL_ACCUM_MODES 104
#define AGL_DEPTH_MODES 105
#define AGL_STENCIL_MODES 106
#define AGL_MAX_AUX_BUFFERS 107
#define AGL_VIDEO_MEMORY 120
#define AGL_TEXTURE_MEMORY 121
#define AGL_RENDERER_COUNT 128

/*AGLRendererInfo

Represents a pointer to an opaque renderer information object.

typedef struct __AGLRendererInfoRec *AGLRendererInfo;
Discussion

This data type points to a structure that AGL uses to maintain information about the renderers associated with a display. Use the functions described in “Getting Renderer Information” to create, access, and free a renderer information object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
typedef struct __AGLRendererInfoRec *AGLRendererInfo;

/*AGLPbuffer

Represents a pointer to an opaque pixel buffer object.

typedef struct __AGLPBufferRec  *AGLPbuffer;
Discussion

This data type points to a structure that AGL uses for hardware accelerated offscreen drawing. Use the functions described in “Managing Pixel Buffers” to create, manage, access, and free a pixel buffer object.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h*/
typedef struct __AGLPBufferRec  *AGLPbuffer;

/*Error Codes

Defines the error codes that can be returned by the aglGetError function.

#defineAGL_NO_ERROR
#define AGL_BAD_ATTRIBUTE 10000
#define AGL_BAD_PROPERTY 10001
#define AGL_BAD_PIXELFMT 10002
#define AGL_BAD_RENDINFO 10003
#define AGL_BAD_CONTEXT 10004
#define AGL_BAD_DRAWABLE 10005
#define AGL_BAD_GDEV 10006
#define AGL_BAD_STATE 10007
#define AGL_BAD_VALUE 10008
#define AGL_BAD_MATCH 10009
#define AGL_BAD_ENUM 10010
#define AGL_BAD_OFFSCREEN 10011
#define AGL_BAD_FULLSCREEN 10012
#define AGL_BAD_WINDOW 10013
#define AGL_BAD_POINTER 10014
#define AGL_BAD_MODULE 10015
#define AGL_BAD_ALLOC 10016
#define AGL_BAD_CONNECTION 10017
Constants
AGL_NO_ERROR

No error.
AGL_BAD_ATTRIBUTE

Invalid pixel format attribute.
AGL_BAD_PROPERTY

Invalid renderer property.
AGL_BAD_PIXELFMT

Invalid pixel format.
AGL_BAD_RENDINFO

Invalid renderer info.
AGL_BAD_CONTEXT

Invalid rendering context.
AGL_BAD_DRAWABLE

Invalid drawable object. A change of virtual screens (renderers) fails if the surface width and height cannot be set to the values requested, or if the creation of a drawable object or surfaces needed to support a pixel buffer fails for other reasons. 
AGL_BAD_GDEV

Invalid graphics device.
AGL_BAD_STATE

Invalid rendering context state.
AGL_BAD_VALUE

Invalid numerical value.
AGL_BAD_MATCH

Invalid share rendering context.
AGL_BAD_ENUM

Invalid enumerant.
AGL_BAD_OFFSCREEN

Invalid offscreen drawable object.
AGL_BAD_FULLSCREEN

Invalid full-screen drawable object.
AGL_BAD_WINDOW

Invalid window.
AGL_BAD_POINTER

Invalid pointer.
AGL_BAD_MODULE

Invalid code module.
AGL_BAD_ALLOC

Memory allocation failure.
AGL_BAD_CONNECTION

Unable to connect to the window server.
Discussion

Unlike many Carbon APIs, AGL functions don’t return result codes for specific error conditions. Instead, AGL functions that fail either return GL_FALSE or NULL. You can find out the specific nature of the error by calling the function aglGetError, which returns the appropriate error code. 
Declared In
agl.h*/
#define AGL_NO_ERROR 0
#define AGL_BAD_ATTRIBUTE 10000
#define AGL_BAD_PROPERTY 10001
#define AGL_BAD_PIXELFMT 10002
#define AGL_BAD_RENDINFO 10003
#define AGL_BAD_CONTEXT 10004
#define AGL_BAD_DRAWABLE 10005
#define AGL_BAD_GDEV 10006
#define AGL_BAD_STATE 10007
#define AGL_BAD_VALUE 10008
#define AGL_BAD_MATCH 10009
#define AGL_BAD_ENUM 10010
#define AGL_BAD_OFFSCREEN 10011
#define AGL_BAD_FULLSCREEN 10012
#define AGL_BAD_WINDOW 10013
#define AGL_BAD_POINTER 10014
#define AGL_BAD_MODULE 10015
#define AGL_BAD_ALLOC 10016
#define AGL_BAD_CONNECTION 10017

/*Context Options and Parameters

Define options and parameters that apply to a specific rendering context.

#define AGL_SWAP_RECT 200
#define AGL_BUFFER_RECT 202
#define AGL_SWAP_LIMIT 203
#define AGL_COLORMAP_TRACKING 210
#define AGL_COLORMAP_ENTRY 212
#define AGL_RASTERIZATION 220
#define AGL_SWAP_INTERVAL 222
#define AGL_STATE_VALIDATION 230
#define AGL_BUFFER_NAME 231
#define AGL_ORDER_CONTEXT_TO_FRONT 232
#define AGL_CONTEXT_SURFACE_ID 233
#define AGL_CONTEXT_DISPLAY_ID 234
#define AGL_SURFACE_ORDER 235
#define AGL_SURFACE_OPACITY 236
#define AGL_CLIP_REGION 254
#define AGL_FS_CAPTURE_SINGLE 255
#define AGL_SURFACE_BACKING_SIZE 304
#define AGL_ENABLE_SURFACE_BACKING_SIZE 305
#define AGL_SURFACE_VOLATILE 306
Constants
AGL_SWAP_RECT

Enable or set the swap rectangle. The associated parameter must contain four values: the x and y window coordinates of the swap rectangle, followed by its width and height. If enabled, the area of the window that is affected by the function aglSwapBuffers is restricted to a subrectangle of the entire window.
AGL_BUFFER_RECT

Enable or set the buffer rectangle. The associated parameter must contain four values: the x and y window coordinates of the buffer rectangle, relative to the structure bounds of the window, followed by its width and height. If enabled, the drawable rectangle of the window and all of its associated buffers are restricted to the specified rectangle. 

Available in Mac OS X v10.0 and later.
AGL_SWAP_LIMIT

Enable or disable the swap asynchronous limit. 

Available in Mac OS X v10.2 and later.
AGL_COLORMAP_TRACKING

Enable or disable color map tracking.

Available in Mac OS X v10.0 and later.
AGL_COLORMAP_ENTRY

The associated value is a color map entry specifies as {index, r, g, b}.

Available in Mac OS X v10.0 and later.
AGL_RASTERIZATION

Enable or disable all rasterization of 2D and 3D primitives. You can use this option to debug and characterize the performance of an OpenGL driver without actually rendering. 

Available in Mac OS X v10.0 and later.
AGL_SWAP_INTERVAL

The associated parameter contains one value: the current swap interval setting. A value of 0 specifies not to synchronize to the vertical retrace. All other values indicate to synchronize to the vertical retrace.

Available in Mac OS X v10.0 and later.
AGL_STATE_VALIDATION

Enables or disables state validation for multiscreen functionality. If enabled, the AGL library inspects the rendering context state each time that the function aglUpdateContext is called to ensure that it is in an appropriate state for switching between renderers. Normally, the state is inspected only when it is actually necessary to switch renderers. This option is useful when you want to use a single monitor system to test that an application will perform correctly on a multiple monitor system. 

Available in Mac OS X v10.0 and later.
AGL_BUFFER_NAME

The associated value is a buffer name. You can use this option to allow multiple OpenGL contexts to share a buffer.

Available in Mac OS X v10.0 and later.
AGL_ORDER_CONTEXT_TO_FRONT

Specifies to order the current rendering context in front of all the other contexts.

Available in Mac OS X v10.1 and later.
AGL_CONTEXT_SURFACE_ID

The associated value is the ID of the drawable surface for the rendering context. You can’t set this value because the system sets it. However, you can retrieve the value using the function aglGetInteger.

Available in Mac OS X v10.2 and later.
AGL_CONTEXT_DISPLAY_ID

The associated value is a list of the display IDs of all displays touched by the rendering context, up to a maximum of 32 displays. You can’t set this list of values because the system assigns display ID values. However, you can retrieve the value using the function aglGetInteger.

Available in Mac OS X v10.2 and later.
AGL_SURFACE_ORDER

The associated value is the position of the OpenGL surface relative to the window. A value of 1 means that the position is above the window; a value of –1 specifies a position that is below the window. 

Available in Mac OS X v10.2 and later.
AGL_SURFACE_OPACITY

The associated value specifies the opacity of the OpenGL surface. A value of 1 means the surface is opaque (the default); 0 means completely transparent.

Available in Mac OS X v10.2 and later.
AGL_CLIP_REGION

Enables or sets the drawable clipping region. The associated value is a rgnHandle data type that defines the clipping region.

Available in Mac OS X v10.2 and later.
AGL_FS_CAPTURE_SINGLE

Enables the capture of a single display for full-screen rendering. This option is disabled by default. 

Available in Mac OS X v10.2 and later.
AGL_SURFACE_BACKING_SIZE

The associated value specifies the width and height of surface backing size.

Available in Mac OS X v10.4 and later.
AGL_ENABLE_SURFACE_BACKING_SIZE

Enable or disable the surface backing-size override.

Available in Mac OS X v10.4 and later.
AGL_SURFACE_VOLATILE

Flags the surface as a candidate for deletion.

Available in Mac OS X v10.4 and later.
Declared In
agl.h*/
#define AGL_SWAP_RECT 200
#define AGL_BUFFER_RECT 202
#define AGL_SWAP_LIMIT 203
#define AGL_COLORMAP_TRACKING 210
#define AGL_COLORMAP_ENTRY 212
#define AGL_RASTERIZATION 220
#define AGL_SWAP_INTERVAL 222
#define AGL_STATE_VALIDATION 230
#define AGL_BUFFER_NAME 231
#define AGL_ORDER_CONTEXT_TO_FRONT 232
#define AGL_CONTEXT_SURFACE_ID 233
#define AGL_CONTEXT_DISPLAY_ID 234
#define AGL_SURFACE_ORDER 235
#define AGL_SURFACE_OPACITY 236
#define AGL_CLIP_REGION 254
#define AGL_FS_CAPTURE_SINGLE 255
#define AGL_SURFACE_BACKING_SIZE 304
#define AGL_ENABLE_SURFACE_BACKING_SIZE 305
#define AGL_SURFACE_VOLATILE 306

/*Renderer Attributes

Define options for managing renderers.

#define AGL_RENDERER_ID 70
#define AGL_SINGLE_RENDERER 71
#define AGL_NO_RECOVERY 72
#define AGL_ACCELERATED 73
#define AGL_CLOSEST_POLICY 74
#define AGL_ROBUST 75
#define AGL_BACKING_STORE 76
#define AGL_MP_SAFE 78
#define AGL_WINDOW 80
#define AGL_MULTISCREEN 81
#define AGL_VIRTUAL_SCREEN 82
#define AGL_COMPLIANT 83
#define AGL_PBUFFER 90
#define AGL_REMOTE_PBUFFER 91
Constants
AGL_RENDERER_ID

The associated value is a nonnegative integer that specifies the renderer that created the pixel format. If present, OpenGL renderers that match the specified ID are preferred. See “Renderer IDs” for possible values. You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_SINGLE_RENDERER

An associated value of GL_TRUE specifies that a single pixel format represents a single renderer for all screens. On systems with multiple screens, this option disables the ability of the AGL library to drive different monitors through different graphics accelerator cards with a single AGL rendering context. A value of GL_FALSE specifies that a list of pixel formats represent multiple renderers. 

Available in Mac OS X v10.0 and later.
AGL_NO_RECOVERY

An associated value of GL_TRUE specifies that failure recovery features are disabled for this pixel format. Normally, if an accelerated renderer cannot attach to a drawable object due to insufficient video memory, AGL automatically switches to another renderer. This attribute disables these features so that rendering will always be done by the chosen renderer. For example, with this option enabled, you won't get a software renderer as a fallback if a hardware-accelerated renderer runs out of resources.

Available in Mac OS X v10.0 and later.
AGL_ACCELERATED

An associated value of GL_TRUE specifies renderers that are attached to a hardware accelerated graphics device. It is usually impossible to support more than one graphics device if this option is set to GL_TRUE, because typically when a window spans more than one device, OpenGL uses the software renderer. You can pass this constant to the function aglDescribeRenderer to find out whether a particular renderer is hardware accelerated.

Available in Mac OS X v10.0 and later.
AGL_CLOSEST_POLICY

The associated value specifies a color buffer size. When set, this option alters the pixel format choosing policy such that a color buffer closest to the requested size is preferred, regardless of the actual color buffer depth of the supported graphics device.

Available in Mac OS X v10.0 and later.
AGL_ROBUST

An associated value of GL_TRUE specifies that AGL should consider only those renderers that do not have any failure modes associated with a lack of video card resources. You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_BACKING_STORE

An associated value of GL_TRUE specifies that AGL should consider only those renderers that have a back color buffer the full size of the drawable object (regardless of window visibility). When this option is set, AGL guarantees that the back buffer contents will be valid after a call to the aglSwapBuffers function. You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_MP_SAFE

An associated value of GL_TRUE specifies a renderer that is multiprocessor safe. This attribute is deprecated in Mac OS X because all renderers can accept commands for threads running on a second processor. However, this does not mean that all renderers are thread-safe or reentrant. You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_WINDOW

An associated value of GL_TRUE specifies that the pixel format can be used to render to an onscreen window. You can pass this constant to the function aglDescribeRenderer.
AGL_MULTISCREEN

An associated value of GL_TRUE specifies that the renderer is capable of driving multiple screens with the same rendering context. (A single window can span multiple screens.) You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_VIRTUAL_SCREEN

The associated value is an integer that specifies the virtual screen number of the pixel format. 

Available in Mac OS X v10.0 and later.
AGL_COMPLIANT

An associated value of GL_TRUE specifies a pixel format that is fully compliant with OpenGL. All Mac OS X renderers are OpenGL-compliant. You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_PBUFFER

The associated value is GL_TRUE if the renderer can render to a pixel buffer. You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.3 and later.
AGL_REMOTE_PBUFFER

An associated value of GL_TRUE specifies that the renderer can render offline to a pixel buffer.

Available in Mac OS X v10.3 and later.
Declared In
agl.h*/
#define AGL_RENDERER_ID 70
#define AGL_SINGLE_RENDERER 71
#define AGL_NO_RECOVERY 72
#define AGL_ACCELERATED 73
#define AGL_CLOSEST_POLICY 74
#define AGL_ROBUST 75
#define AGL_BACKING_STORE 76
#define AGL_MP_SAFE 78
#define AGL_WINDOW 80
#define AGL_MULTISCREEN 81
#define AGL_VIRTUAL_SCREEN 82
#define AGL_COMPLIANT 83
#define AGL_PBUFFER 90
#define AGL_REMOTE_PBUFFER 91

/*Buffer and Renderer Attributes

Specify attributes used to create a pixel format object.

#defineAGL_NONE
#define AGL_ALL_RENDERERS 1
#define AGL_BUFFER_SIZE 2
#define AGL_LEVEL 3
#define AGL_RGBA 4
#define AGL_DOUBLEBUFFER 5
#define AGL_STEREO 6
#define AGL_AUX_BUFFERS 7
#define AGL_RED_SIZE 8
#define AGL_GREEN_SIZE 9
#define AGL_BLUE_SIZE 10
#define AGL_ALPHA_SIZE 11
#define AGL_DEPTH_SIZE 12
#define AGL_STENCIL_SIZE 13
#define AGL_ACCUM_RED_SIZE 14
#define AGL_ACCUM_GREEN_SIZE 15
#define AGL_ACCUM_BLUE_SIZE 16
#define AGL_ACCUM_ALPHA_SIZE 17
#define AGL_PIXEL_SIZE 50
#define AGL_MINIMUM_POLICY 51
#define AGL_MAXIMUM_POLICY 52
#define AGL_OFFSCREEN 53
#define AGL_FULLSCREEN 54
#define AGL_SAMPLE_BUFFERS_ARB 55
#define AGL_SAMPLES_ARB 56
#define AGL_AUX_DEPTH_STENCIL 57
#define AGL_COLOR_FLOAT 58
#define AGL_MULTISAMPLE 59
#define AGL_SUPERSAMPLE 60
#define AGL_SAMPLE_ALPHA 61
Constants
AGL_NONE

Used to terminate a pixel format attribute list.
AGL_ALL_RENDERERS

Specifies to choose a pixel format from all available renderers, including debug and special-purpose renderers that are not OpenGL compliant.

Available in Mac OS X v10.0 and later.
AGL_BUFFER_SIZE

The associated value is a nonnegative integer that specifies the number of bits per color buffer. For RGBA pixel formats, the buffer size is the sum of the red, green, blue, and alpha sizes. For color index pixel formats, the buffer size is the size of the color indexes. The smallest color index buffer of at least the specified size is preferred. Ignored if the AGL_RGBA attribute is asserted.

Available in Mac OS X v10.0 and later.
AGL_LEVEL

The associated value is an integer that specifies the frame buffer level of the pixel format. Positive levels correspond to frame buffers that overlay the default buffer, and negative levels correspond to frame buffers that underlay the default level. Buffer level zero corresponds to the default frame buffer of the display. Buffer level one is the first overlay frame buffer, level two the second overlay frame buffer, and so on. Negative buffer levels correspond to underlay frame buffers.

Available in Mac OS X v10.0 and later.
AGL_RGBA

An associated value of GL_TRUE specifies that the color buffers store red, green, blue, and alpha values. In this case, only RGBA pixel formats are considered. A value of GL_FALSE specifies that they store color indexes. In this case, only color index pixel formats are considered.

Available in Mac OS X v10.0 and later.
AGL_DOUBLEBUFFER

An associated value of GL_TRUE specifies that color buffers exist in front-back pairs that can be swapped; double buffering is supported. Otherwise, only single-buffered pixel formats are considered.

Available in Mac OS X v10.0 and later.
AGL_STEREO

An associated value of GL_TRUE specifies that color buffers exist in left-right pairs; stereo buffering is supported, and only stereo pixel formats are considered. Otherwise, only monoscopic pixel formats are considered.

Available in Mac OS X v10.0 and later.
AGL_AUX_BUFFERS

The associated value is a nonnegative integer that specifies the number of auxiliary buffers that are available. A value of 0 indicates that no auxiliary buffers exist. Pixel formats with the smallest number of auxiliary buffers that meet or exceed the specified number are preferred.

Available in Mac OS X v10.0 and later.
AGL_RED_SIZE

The associated value is a nonnegative integer that specifies the number of red component bits. The value is 0 if the AGL_RGBA attribute is GL_FALSE. A red buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_GREEN_SIZE

The associated value is a nonnegative integer that specifies the number of green component bits. The value is 0 if the AGL_RGBA attribute is GL_FALSE. A green buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_BLUE_SIZE

The associated value is a nonnegative integer that specifies the number of blue component bits. The value is 0 if the AGL_RGBA attribute is GL_FALSE. A blue buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_ALPHA_SIZE

The associated value is a nonnegative integer that specifies the number of alpha component bits. The value is 0 if the AGL_RGBA attribute is GL_FALSE. An alpha buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_DEPTH_SIZE

The associated value is a nonnegative integer that specifies the number of bits in the depth buffer. A depth buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_STENCIL_SIZE

The associated value is a nonnegative integer that specifies the number of bits in the stencil buffer. The smallest stencil buffer of at least the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_ACCUM_RED_SIZE

The associated value is a nonnegative integer that specifies the number of bits of red stored in the accumulation buffer. A red accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_ACCUM_GREEN_SIZE

The associated value is a nonnegative integer that specifies the number of bits of green stored in the accumulation buffer. A green accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_ACCUM_BLUE_SIZE

The associated value is a nonnegative integer that specifies the number of bits of blue stored in the accumulation buffer. A blue accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_ACCUM_ALPHA_SIZE

The associated value is a nonnegative integer that specifies the number of bits of alpha stored in the accumulation buffer. An alpha accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
AGL_PIXEL_SIZE

The associated value is a nonnegative integer that specifies the number frame buffer bits per pixel. The pixel size is the number of bits required to store each pixel in the color buffer, including unused bits. If the pixel format has an alpha channel that is stored in a separate buffer, its size is not included in the pixel size.
AGL_MINIMUM_POLICY

Specifies never to choose smaller buffers than requested. This attribute alters the pixel-format-choosing policy for the color, depth, and accumulation buffers such that only buffers of size greater than or equal to the desired size are considered.

Available in Mac OS X v10.0 and later.
AGL_MAXIMUM_POLICY

Specifies to choose the largest buffers of the type requested. This attribute alters the pixel-format-choosing policy for the color, depth, and accumulation buffers such that, if a nonzero buffer size is requested, the largest available buffer is preferred.

Available in Mac OS X v10.0 and later.
AGL_OFFSCREEN

Enables or disables whether the pixel format can be used to render to an offscreen memory area. If enabled, only renderers that are capable of rendering to an offscreen memory area and have buffer depth exactly equal to the desired buffer depth are considered. If enabled, and if the drawable object currently attached to a rendering context is an offscreen drawable object, the associated values are the width, height, and row bytes of the offscreen memory area. If enabled, and if the drawable object is not an offscreen type, the width, height, and row bytes are each 0. When the AGL_OFFSCREEN attribute is present, the AGL_CLOSEST_POLICY attribute is implied. You can pass this constant to the function aglDescribeRenderer. 

Available in Mac OS X v10.0 and later.
AGL_FULLSCREEN

Enables or disables whether the pixel format can be used to render to a full-screen graphics device. If present, only renderers that are capable of full-screen rendering are chosen. Furthermore, the gdevs parameter must be set to a pointer to the GDevice on which full-screen rendering is desired and the ndev parameter must be set to 1.

If present, and if the drawable object that is currently attached to a rendering context is a full-screen drawable object, the associated values are the width, height, and refresh frequency of the full-screen device, rounded to the nearest integer. If present, and if the drawable object is not a full-screen type, the width, height, and refresh frequency are each 0. 

You can pass this constant to the function aglDescribeRenderer.

Available in Mac OS X v10.0 and later.
AGL_SAMPLE_BUFFERS_ARB

The associated value is the number of multisample buffers.
AGL_SAMPLES_ARB

The associated value is the number of samples per multisample buffer.
AGL_AUX_DEPTH_STENCIL

The associated value is the independent depth and/or the stencil buffers for the auxiliary buffer.

Available in Mac OS X v10.3 and later.
AGL_COLOR_FLOAT

Specifies that color buffers store floating point pixels instead of fixed point values.

Available in Mac OS X v10.3 and later.
AGL_MULTISAMPLE

Specifies a hint to the driver to prefer multisampling.

Available in Mac OS X v10.3 and later.
AGL_SUPERSAMPLE

Specifies a hint to the driver to prefer supersampling.

Available in Mac OS X v10.3 and later.
AGL_SAMPLE_ALPHA

Requests alpha filtering when multisampling.

Available in Mac OS X v10.3 and later.
Discussion

Each of these constants can be assigned to the the attribute array passed to the function aglChoosePixelFormat. They can also be passed to the function aglDescribePixelFormat.
Declared In
agl.h*/
#define AGL_NONE 0 //?
#define AGL_ALL_RENDERERS 1
#define AGL_BUFFER_SIZE 2
#define AGL_LEVEL 3
#define AGL_RGBA 4
#define AGL_DOUBLEBUFFER 5
#define AGL_STEREO 6
#define AGL_AUX_BUFFERS 7
#define AGL_RED_SIZE 8
#define AGL_GREEN_SIZE 9
#define AGL_BLUE_SIZE 10
#define AGL_ALPHA_SIZE 11
#define AGL_DEPTH_SIZE 12
#define AGL_STENCIL_SIZE 13
#define AGL_ACCUM_RED_SIZE 14
#define AGL_ACCUM_GREEN_SIZE 15
#define AGL_ACCUM_BLUE_SIZE 16
#define AGL_ACCUM_ALPHA_SIZE 17
#define AGL_PIXEL_SIZE 50
#define AGL_MINIMUM_POLICY 51
#define AGL_MAXIMUM_POLICY 52
#define AGL_OFFSCREEN 53
#define AGL_FULLSCREEN 54
#define AGL_SAMPLE_BUFFERS_ARB 55
#define AGL_SAMPLES_ARB 56
#define AGL_AUX_DEPTH_STENCIL 57
#define AGL_COLOR_FLOAT 58
#define AGL_MULTISAMPLE 59
#define AGL_SUPERSAMPLE 60
#define AGL_SAMPLE_ALPHA 61


/*AGLContext

Represents a pointer to an opaque AGL context object.

typedef struct __AGLContextRec  *AGLContext;
Discussion

This data type points to a structure that AGL uses to maintain state and other information associated with an OpenGL rendering context. Use the functions described in “Managing Contexts” and “Getting and Setting Context Options” to create, manage, access, and free an AGL context object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
typedef struct __AGLContextRec  *AGLContext;


/*AGLPixelFormat

Represents a pointer to an opaque pixel format object.

typedef struct __AGLPixelFormatRec *AGLPixelFormat;
Discussion

This data type points to a structure that AGL uses to maintain pixel format and virtual screen information for a given set of renderer and buffer options. Use the functions described in “Managing Pixel Format Objects” to create, manage, access, and free a pixel format object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
typedef struct __AGLPixelFormatRec *AGLPixelFormat;


/*AGLDevice

Defines a reference to a list of graphics devices.

typedef GDHandle AGLDevice;
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
typedef GDHandle AGLDevice;

/*AGLDrawable

Defines an opaque data type that represents a Carbon window.

typedef CGrafPtr AGLDrawable;
Discussion

This data type points to a structure that AGL uses to keep track of the information needed to transmit rendering operations from bits in memory to the onscreen pixels associated with a Carbon window. This data type is a CGrafPtr "under the hood." The Window Manager function GetWindowPort returns the CGrafPtr associated with a Carbon window. 

Note: The generic term drawable object is not the same as the AGLDrawable data type, which has a very specific meaning. A drawable object can be any rendering destination (pixel buffer, window, offscreen, and so on) while the the AGLDrawable data type is used specifically for a window rendering destination.

Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
typedef CGrafPtr AGLDrawable;

//function
/*aglChoosePixelFormat

Creates a pixel format object that satisfies the constraints of the specified buffer and renderer attributes.

AGLPixelFormat aglChoosePixelFormat (
   const AGLDevice *gdevs,
   GLint ndev,
   const GLint *attribs);
Parameters
gdevs

A pointer to an AGLDevice data type that contains an array of Mac OS graphics devices. AGL chooses pixel formats and renderers that are appropriate for these devices. To create a pixel format object that supports all devices on the system, pass NULL.
ndev

The number of graphics devices that your application supplies in the gdevs parameter. Pass 0 if you also pass NULL for the gdevs parameter.
attribs

A NULL terminated array that contains a list of buffer and renderer attributes. The existence of a Boolean attribute implies a true value. If an attribute is not Boolean in nature, you must supply the desired value immediately following the attribute. For information on the attributes that you can supply, see “Buffer and Renderer Attributes”. I
Return Value

A new pixel format object that contains pixel format information and a list of virtual screens. Returns NULL if the system cannot find a pixel format and virtual screen that satisfies the constraints of the buffer and renderer attributes.
Discussion

After a pixel format object is created successfully, the integer attributes are set to values that are as close to the desired value as can be provided by the system. Attribute values can differ for each virtual screen. You can use the AGL_MINIMUM_POLICY and AGL_MAXIMUM_POLICY attributes to control how the system chooses the setting. For more information on choosing attributes, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglCreateContext
aglDescribePixelFormat
aglDestroyPixelFormat*/

AGLPixelFormat aglChoosePixelFormat (
   const AGLDevice *gdevs,
   GLint ndev,
   const GLint *attribs);

/*aglCreateContext

Creates an AGL rendering context.

AGLContext aglCreateContext (
   AGLPixelFormat pix,
   AGLContext share);
Parameters
pix

A pixel format object creating by calling the function aglChoosePixelFormat.
share

The rendering context with which to share the OpenGL object state—including texture objects, programs and shader display lists, vertex array objects, vertex buffer objects, pixel buffer objects, and frame buffer objects—and the object state associated which each of these object types. Pass NULL to indicate that no sharing is to take place. 
Return Value

A new rendering context. The aglCreateContext function returns NULL if the function fails for any reason. You can call the function aglGetError to determine what the error is.
Discussion

If the pixel format object you supply is able to support multiple graphics devices, then the rendering context can render transparently across the supported devices. With a multiple-device rendering context, sharing is possible only when the relationship between the renderers and the graphics devices they support is the same for all rendering contexts that are shared. Normally you achieve the best results by using the same pixel format object for all shared rendering contexts. For more information, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglChoosePixelFormat
aglDestroyContext
aglSetDrawable*/

AGLContext aglCreateContext (
   AGLPixelFormat pix,
   AGLContext share);

/*aglGetError

Returns an AGL error code.

GLenum aglGetError (void);
Return Value

The value of the global AGL error flag. See “Error Codes” for a complete description of the error codes that can be returned.
Discussion

This function is similar to the OpenGL function glGetError. You call the function aglGetError whenever an AGL function returns TRUE to retrieve the error code associated with the error condition. Each error is assigned a numeric code and a symbolic name. When an error occurs, the error flag is set to the appropriate error code value. No other errors are recorded until aglGetError is called, the error code is returned, and the flag is reset to AGL_NO_ERROR. If a call to aglGetError returns AGL_NO_ERROR, this means that there has been no detectable error since the last call to aglGetError.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglErrorString*/
GLenum aglGetError (void);


/*aglGetCGLContext

Gets the CGL rendering context associated with an AGL rendering context.

GLboolean aglGetCGLContext (
   AGLContext ctx,
   void **cgl_ctx);
Parameters
ctx

An AGL rendering context.
cgl_ctx

On return, points to the CGL rendering context associated with the specified AGL rendering context.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You should use this function only when you absolutely need to use a non-AGL function that requires an CGL rendering context. You can cast the returned CGL rendering context to another data type as needed. Note that destroying the AGL rendering context also destroys the CGL rendering context, thus rendering the data reference returned by this function invalid.

Note: Always use the AGL version of a function when available, because there is additional work that AGL must perform to be compatible with Carbon.

Availability
Available in Mac OS X v10.4 and later.
Declared In
agl.h*/

GLboolean aglGetCGLContext (
   AGLContext ctx,
   void **cgl_ctx);

/*aglSetDrawable

Attaches a rendering context to a Carbon window.

GLboolean aglSetDrawable (
   AGLContext ctx,
   AGLDrawable draw);
Parameters
ctx

A rendering context returned by the function aglCreateContext.
draw

The drawable object—which must be a Carbon window—to attach to the AGL rendering context. You need to supply a CGrafPtr data type obtained from a valid window. The Window Manager function GetWindowPort returns the CGrafPtr associated with a Carbon window. To disable rendering for a rendering context, pass NULL. 
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

After calling this function, AGL directs subsequent OpenGL rendering calls to the specified rendering context to modify the window content. In addition, the function aglSetDrawable performs all of the actions performed by aglUpdateContext.

When a rendering context is initially attached to the window, its viewport is set to the full size of the window. If the rendering context is subsequently attached to the same window, its viewport is unaltered.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetDrawable*/
GLboolean aglSetDrawable (
   AGLContext ctx,
   AGLDrawable draw);

/*aglSetInteger

Sets the value of an option for a rendering context.

GLboolean aglSetInteger (
   AGLContext ctx,
   GLenum pname,
   const GLint *params);
Parameters
ctx

A rendering context.
pname

The rendering context option whose value you want to set. You can pass any of the constants listed in “Context Options and Parameters” that have an associated integer value.
params

A pointer to the value to set the parameter to.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

Use aglEnable to enable the option.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetInteger*/
GLboolean aglSetInteger (
   AGLContext ctx,
   GLenum pname,
   const GLint *params);

/*aglGetCGLPixelFormat

Gets the CGL pixel format object associated with an AGL pixel format.

GLboolean aglGetCGLPixelFormat (
   AGLPixelFormat pix,
   void **cgl_pix);
Parameters
pix

An AGL pixel format object.
cgl_pix

On return, points to the CGL pixel format object associated with the specified AGL pixel format.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You should use this function only when you absolutely need to pass a CGL pixel format object to a non-AGL function. You can cast the returned CGL pixel format object to another data type as needed. Note that destroying the AGL pixel format object also destroys the CGL pixel format object, thus making the data reference returned invalid.

Note: Always use the AGL version of a function when available, because there is additional work that AGL must perform to be compatible with Carbon.

Availability
Available in Mac OS X v10.4 and later.
Declared In
agl.h*/

GLboolean aglGetCGLPixelFormat (
   AGLPixelFormat pix,
   void **cgl_pix);


/*aglSetCurrentContext

Sets the specified rendering context as the current rendering context.

GLboolean aglSetCurrentContext (
   AGLContext ctx);
Parameters
ctx

The rendering context to set as the current rendering context. Pass NULL to release the current rendering context without assigning a new one.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

There can be only one current rendering context. Subsequent OpenGL rendering calls operate on the current rendering context to modify the drawable object associated with it. 

You can use AGL macros to bypass the current rendering context mechanism and maintain your own current rendering context.

A context is current on a per-thread basis. Multiple threads must serialize calls into the same context.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetCurrentContext*/
GLboolean aglSetCurrentContext (
   AGLContext ctx);

/*aglErrorString

Returns a string that describes the specified AGL error code.

const GLubyte *aglErrorString (
   GLenum code);
Parameters
code

An AGL error code returned by the function aglGetError. For a description of these constants, see “Error Codes”.
Return Value

An error string that describes the error code passed in the code parameter. If the code is invalid, returns the string “No such error code.”
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetError*/
const GLubyte *aglErrorString (
   GLenum code);

/*aglSurfaceTexture

Allows texturing from a drawable object that has an attached rendering context, using the surface contents as the source data for the texture.

void aglSurfaceTexture (
   AGLContext context,
   GLenum target,
   GLenum internalformat,
   AGLContext surfacecontext);
Parameters
context

A rendering context attached to the window that's the target of the texture operation.
target

A constant that specifies an OpenGL target texture. You can supply any of the texture targets defined by the OpenGL specification, including: 
GL_TEXTURE_2D, a texture whose dimensions are a power of two.
GL_TEXTURE_RECTANGLE_EXT, a texture whose dimensions are not a power of two.
GL_TEXTURE_CUBE_MAP, a mapped cube texture.
internalformat

A constant that specifies the internal color format of the texture— either GL_RGB or GL_RGBA.
surfacecontext

A rendering context that's attached to the window that's the source of the texture data.
Discussion

The aglSurfaceTexture function behaves similar to the function glTexImage2D. The texture target and internal format must be supported by the renderer of the target rendering context, and the geometry of the source drawable object must be compatible with the texture target. For example, if the texture target is GL_TEXTURE_2D, the window must conform to power-of-two dimensions.

Before calling this function you must use OpenGL calls to set up the OpenGL texture referred to by the target parameter. That is, enable texturing, generate a texture name, bind it to a texture target, and so forth. For more information, see OpenGL Programming Guide.

The target and source windows must use the same renderer (virtual screen) or the function fails, most typically by not texturing the target rendering context.

An error condition occurs if the surface rendering context is not attached to a windowed drawable object; the drawable object cannot be an offscreen area or pixel buffer. It’s also possible to get standard OpenGL errors similar to the errors that can occur for the function glTexImage2D. Use the function glError to query OpenGL errors.

Note: Although the function aglSurfaceTexture provides a flexible way to render to an offscreen texture and then use it as a source, you should consider using pixel buffer objects or OpenGL framebuffer objects instead. For details on using a hidden window as a texture source, see OpenGL Programming Guide for Mac OS X. This document also describes how to use pixel buffer objects and framebuffer objects as texture sources.

Availability
Available in Mac OS X v10.2 and later.
Declared In
agl.h*/

void aglSurfaceTexture (
   AGLContext context,
   GLenum target,
   GLenum internalformat,
   AGLContext surfacecontext);

/*aglDestroyContext

Frees the resources associated with a rendering context.

GLboolean aglDestroyContext (
   AGLContext ctx);
Parameters
ctx

The rendering context whose resources you want to release. 
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

This function frees all the resources used by the rendering context passed to it. If the rendering context that you pass is the current rendering context, the current context is set to NULL and there is no current rendering context after the function executes.

After you call this function, you must make sure that you do not use the destroyed rendering context. This includes using AGL macros in which the rendering context is explicitly passed to OpenGL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglCreateContext
aglUpdateContext*/

GLboolean aglDestroyContext (
   AGLContext ctx);

/*aglDestroyPixelFormat

Frees the memory associated with a pixel format object.

void aglDestroyPixelFormat (
   AGLPixelFormat pix);
Parameters
pix

The pixel format object whose resources you want to release. This must be a pixel format object returned by the functionaglChoosePixelFormat. AGL sets a AGL_BAD_PIXELFMT error if you pass the returned value from the function aglNextPixelFormat or the pix parameter is not a valid pixel format.
Discussion

A copy of the pixel format data is made by the aglCreateContext function, so your application can free a pixel format immediately after creating a rendering context with it. On the other hand, a pixel format object can be useful for enumerating virtual screens when multiple renderers are supported, so you may want to retain it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDescribePixelFormat*/

void aglDestroyPixelFormat (
   AGLPixelFormat pix);

/*aglSwapBuffers

Exchanges the front and back buffers of the specified rendering context.

void aglSwapBuffers (
   AGLContext ctx);
Parameters
ctx

The rendering context whose buffers you want to swap. AGL sets the AGL_BAD_CONTEXT error if the ctx parameter is not a valid AGL rendering context.
Discussion

The aglSwapBuffers function either swaps the buffers or copies the back buffer content to the front buffer. Before it returns, aglSwapBuffers invokes the OpenGL function glFlush.

To synchronize with a monitor retrace, set the current swap interval (AGL_SWAP_INTERVAL) to 1 by calling the function aglSetInteger. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
void aglSwapBuffers (
   AGLContext ctx);

/*aglUpdateContext

Notifies the rendering context that the window geometry has changed.

GLboolean aglUpdateContext (
   AGLContext ctx);
Parameters
ctx

The rendering context that needs updating. 
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You must call the aglUpdateContext function any time that the geometry of the drawable object changes. You should call this function after the completion of any move or resize action.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglSetDrawable*/
GLboolean aglUpdateContext (
   AGLContext ctx);

/*aglCreatePBuffer

Creates a pixel buffer of the specified size, compatible with the specified texture target.

GLboolean aglCreatePBuffer (
   GLint width,
   GLint height,
   GLenum target,
   GLenum internalFormat,
   long max_level,
   AGLPbuffer *pbuffer);
Parameters
width

The width, in pixels, of the pixel buffer.
height

The height, in pixels, of the pixel buffer.
target

A constant that specifies the type of the pixel buffer target texture. You can supply any of the texture targets defined by the OpenGL specification, including: 
GL_TEXTURE_2D, a texture whose dimensions are a power of two.
GL_TEXTURE_RECTANGLE_EXT, a texture whose dimensions are not a power of two.
GL_TEXTURE_CUBE_MAP, a mapped cube texture.
internalformat

A constant that specifies the internal color format of the pixel buffer, which can be GL_RGB or GL_RGBA. The format controls whether the alpha channel of the pixel buffer is used for texturing operations. 
max_level

The maximum level of mipmap detail allowable. Pass 0 for a pixel buffer that's not using mipmaps. The value passed should never exceed the actual maximum number of mipmap levels that can be represented with the given width and height.
pbuffer

On return, points to a new pixel buffer object.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

This function does not have any knowledge of OpenGL contexts or pixel format objects and does not specifically allocate the storage needed for the actual pixel buffer. These operations occur when you call the function aglSetPBuffer.

You can determine the dimensional limits of a pixel buffer by calling the OpenGL function glGetInteger. You can find the maximum size supported by querying GL_MAX_VIEWPORT_DIMS and the minimum size by querying GL_MIN_PBUFFER_VIEWPORT_DIMS_APPLE, which returns two integer values (similar to GL_MAX_VIEWPORT_DIMS). All pixel buffer dimensions that you request with the function aglCreatePBuffer should fall within these limits (inclusively) and should comply with any limitations imposed by the texture target you select.

The maximum viewport size supported in Mac OS X is quite large. You should take into consideration the amount of video or system memory required to support the requested pixel buffer size, including additional memory needed for multiple buffers and options such as multisampling.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h
See Also
aglDescribePBuffer
aglDestroyPBuffer*/
GLboolean aglCreatePBuffer (
   GLint width,
   GLint height,
   GLenum target,
   GLenum internalFormat,
   long max_level,
   AGLPbuffer *pbuffer);

/*aglGetVirtualScreen

Returns the current virtual screen number associated with a rendering context.

GLint aglGetVirtualScreen (
   AGLContext ctx);
Parameters
ctx

A rendering context.
Return Value

Returns the virtual screen number of the context. The value is always 0 on a single-monitor system and –1 if the function fails for any reason. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

The current virtual screen is set automatically by the function aglUpdateContext. The current virtual screen can change when a drawable object is moved or resized across graphics device boundaries. A change in the current virtual screen can affect the return values of some OpenGL functions and in most cases also means that the renderer has changed.

For detailed information on virtual screens, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglSetVirtualScreen*/

GLint aglGetVirtualScreen (
   AGLContext ctx);

/*aglSetPBuffer

Attaches a pixel buffer object to a rendering context.

GLboolean aglSetPBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint face,
   GLint level,
   GLint screen);
Parameters
ctx

A rendering context.
pbuffer

A pixel buffer object.
face

The cube map face to draw if the buffer texture target is type GL_TEXTURE_CUBE_MAP; otherwise pass 0.
level

The mipmap level to draw. This must not exceed the maximum mipmap level set when the pixel buffer object was created. Pass 0 for a texture target that does not support mipmaps.
screen

A virtual screen value. The virtual screen determines the renderer that OpenGL uses to draw to the pixel buffer object. For best performance, for a pixel buffer used as a texture source, you should supply the a virtual screen value that results in using the same renderer used by the context that's the texturing target.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

The first time you call this function for a specific pixel buffer object, the system creates the necessary buffers. The buffers are created to support the pixel formats used to create the rendering context. The storage requirements for pixel buffer objects, which can be quite large, are very similar to the requirements for windows or views with OpenGL contexts attached. All drawable objects compete for the same scarce resources. This function can fail is there is not enough contiguous VRAM for each buffer. It's best to code defensively with a scheme that reduces resource consumption without causing the application to resort to failure. Unless, of course, failure is the only viable alternative.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h
See Also
aglGetPBuffer*/
GLboolean aglSetPBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint face,
   GLint level,
   GLint screen);

/*aglTexImagePBuffer

Binds the contents of a pixel buffer to a data source for a texture object.

GLboolean aglTexImagePBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint source);
Parameters
ctx

A rendering context, which is the target context for the texture operation. This is the context that you plan to render content to. This is not the context attached to the pixel buffer.
pbuffer

A pixel buffer object.
source

The source buffer to texture from, which should be a valid OpenGL buffer such as GL_FRONT or GL_BACK and should be compatible with the buffer and renderer attributes that you used to create the rendering context attached to the pixel buffer. This means that the pixel buffer must possess the buffer in question for the texturing operation to succeed.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You must generate and bind a texture name (using standard OpenGL texturing calls) that is compatible with the pixel buffer texture target. Don't supply a texture object that was used previously for nonpixel buffer texturing operations unless a you first call the OpenGL function glDeleteTextures and then regenerate the texture name. 

If you modify the content of a pixel buffer that uses mipmap levels, you must call this function again before drawing with the pixel buffer, to ensure that the content is synchronized with OpenGL. For pixel buffers without mipmaps, simply rebind to the texture object to synchronize content.

No OpenGL texturing calls that modify a pixel buffer texture content are permitted (such as glTexSubImage2D or glCopyTexImage2D) with the pixel buffer texture as the destination. It is permitted to use texturing commands to read data from a pixel buffer texture, such as glCopyTexImage2D, with the pixel buffer texture as the source. It is also legal to use OpenGL functions such as glReadPixels to read the contents of a pixel buffer directly through the pixel buffer context.

Note that texturing with the aglTexImagePBuffer function can fail to produce the intended results without error in the same way other OpenGL texturing commands can normally fail. The function fails if you do not enable the proper texture target, set an incompatible filter mode, or other conditions described in the OpenGL specification.

You don't need to share a context when a pixel buffer object is a texture source. You can use independent pixel formats and OpenGL contexts for both the pixel buffer and the target drawable object without sharing resources, and still texture using a pixel buffer in the target context.

For details on how to use a pixel buffer object as a texture source, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h*/

GLboolean aglTexImagePBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint source);

/*aglDestroyPBuffer

Releases the resources associated with a pixel buffer object.

GLboolean aglDestroyPBuffer (
   AGLPbuffer pbuffer);
Parameters
pbuffer

The pixel buffer object whose resources you want to release.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

Call this function only after you no longer need to use the pixel buffer object. Before calling this function, you should delete all texture objects associated with the pixel buffer object. You do not need to make sure that all texturing commands have completed prior to calling this function, because the OpenGL framework manages texturing synchronization.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h
See Also
aglCreatePBuffer*/

GLboolean aglDestroyPBuffer (
   AGLPbuffer pbuffer);

/*aglQueryRendererInfo

Creates and returns a renderer information object that contains properties and values for all renderers driving the specified displays.

AGLRendererInfo aglQueryRendererInfo (
   const AGLDevice *gdevs,
   GLint ndev);
Parameters
gdevs

A pointer to a list of graphics devices to which you want to restrict the query. Pass NULL to obtain information for all graphics devices on the system. 
ndev

The number of graphics devices in gdev. Pass 0 if gdevs is NULL. AGL sets the AGL_BAD_DEVICE error if the ndev parameter is nonzero and the gdevs parameter is not an array of valid devices.
Return Value

A renderer information object that describes all renderers able to drive the devices specified by the gdevs parameter. The function returns NULL if it fails for any reason. If an error occurs, call the function aglGetError to determine what the error is. 
Discussion

This function normally returns a list of more than one renderer information object—one for each renderer found on the system. To access data in the first renderer information object tin the list, call the function aglDescribeRenderer. To access data in a renderer information object that is not the first one in the list, use aglNextRendererInfo. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDestroyRendererInfo*/
AGLRendererInfo aglQueryRendererInfo (
   const AGLDevice *gdevs,
   GLint ndev);

/*aglDescribeRenderer
Obtains the value associated with a renderer property.

GLboolean aglDescribeRenderer (
   AGLRendererInfo rend,
   GLint prop,
   GLint *value);
Parameters
rend

An opaque renderer information object that contains a description of the renderer capabilities you want to inspect. You obtain a renderer information object by calling the function aglQueryRendererInfo. 
prop

The renderer property whose value you want to obtain. See “Renderer Properties” for a list of the constants you can supply for this parameter. There are also a number of constants described in “Buffer and Renderer Attributes” that you can supply to this function.
value

On return, points to the value of the requested property.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglNextRendererInfo
aglDestroyRendererInfo*/


GLboolean aglDescribeRenderer (
   AGLRendererInfo rend,
   GLint prop,
   GLint *value);

/*aglSetFullScreen

Attaches an rendering context to a full screen graphics device.

GLboolean aglSetFullScreen (
   AGLContext ctx,
   GLsizei width,
   GLsizei height,
   GLsizei freq,
   GLint device);
Parameters
ctx

A rendering context.
width

The width, in pixels, of the graphics device. This value must be an exact match to the graphics device.
height

The height, in pixels, of the graphics device. This value must be an exact match to the graphics device.
freq

The refresh frequency of the graphics device, in Hertz. If you specify a frequency of 0, AGL uses the highest refresh frequency available for the specified width and height. If you specify a nonzero frequency, AGL chooses the closest frequency available for the given geometry. If a display provides only a 0 refresh frequency, AGL matches it with width and height regardless of the value of frequency passed.
device

This parameter is ignored in Mac OS X, where all devices that are compatible with the pixel format of the rendering context are considered when selecting a full screen graphics device.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

After calling this function, subsequent OpenGL rendering calls directed to the full-screen graphics device. The rendering context must be created with respect to a pixel format that supports a full-screen device, which you can request by passing AGL_FULLSCREEN to the function aglChoosePixelFormat. The aglSetFullScreen function also performs all of the actions performed by aglUpdateContext. The aglSetFullScreen function uses information obtained from the pixel format object use to create the rendering context to choose the color depth for full-screen display mode.

When a rendering context is initially attached to a full screen graphics device, its viewport is set to the full size of the device. If the rendering context is subsequently attached to the same device, its viewport is unaltered. To disable a rendering context, call aglSetDrawable with the draw parameter set to NULL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetDrawable*/
GLboolean aglSetFullScreen (
   AGLContext ctx,
   GLsizei width,
   GLsizei height,
   GLsizei freq,
   GLint device);

/*aglDestroyRendererInfo

Frees resources associated with a renderer information object.

void aglDestroyRendererInfo (
   AGLRendererInfo rend);
Parameters
rend

The renderer information object whose resources you want to release. 
Discussion

AGL sets a AGL_BAD_RENDINFO error if you pass an invalid renderer information object. You can check for this error by calling aglGetError.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglQueryRendererInfo*/
void aglDestroyRendererInfo (
   AGLRendererInfo rend);

/*aglNextRendererInfo

Returns the next renderer information object.

AGLRendererInfo aglNextRendererInfo (
   AGLRendererInfo rend);
Parameters
rend

A renderer information object that contains one or more renderer information objects. You obtain a renderer information object by calling the function aglQueryRendererInfo.
Return Value

The next renderer information object in the list. Returns NULL if the object is the last in the list or if the function fails for any reason. In case of a failure, call the function aglGetError to determine what the error is. 
Discussion

You typically use this function to iterate through a list of renderer information objects returned by the function aglQueryRendererInfo. Most systems have more than one renderer installed because support for different buffer depths is typically provided by separate renderers.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDescribeRenderer
aglDestroyRendererInfo*/
AGLRendererInfo aglNextRendererInfo (
   AGLRendererInfo rend);

/*aglEnable

Enables an option for a rendering context.

GLboolean aglEnable (
   AGLContext ctx,
   GLenum pname);
Parameters
ctx

A rendering context.
pname

The option you want to enable. You can pass any of the constants listed in “Context Options and Parameters” that specify they can be enabled or disabled.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

To set the value associated with a rendering context option, use the function aglSetInteger. For example, if you enable AGL_SWAP_RECT, you can specify the area of the window that is affected by the aglSwapBuffers function by setting the rectangle size with the function aglSetInteger.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDisable
aglIsEnabled*/
GLboolean aglEnable (
   AGLContext ctx,
   GLenum pname);

/*aglDisable

Disables an option for a rendering context.

GLboolean aglDisable (
   AGLContext ctx,
   GLenum pname);
Parameters
ctx

A rendering context.
pname

The capability that you want to disable. You can pass any of the constants listed in “Context Options and Parameters” that specify they can be enabled or disabled.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglEnable*/
GLboolean aglDisable (
   AGLContext ctx,
   GLenum pname);

#endif