#ifndef AUDIOHARDWARE_H
#define AUDIOHARDWARE_H


#include <AvailabilityMacros.h>
#include <CoreAudio/CoreAudioTypes.h>

#ifndef CFPLUGINCOM_H
#include <CoreFoundation/CFPlugInCOM.h>
#endif



#if defined(__cplusplus)
extern "C"
{
#endif

/*AudioDevice Properties


AudioObjectPropertySelector values that apply to AudioDevice objects. 
enum { 
    kAudioDevicePropertyPlugIn = 'plug', 
    kAudioDevicePropertyConfigurationApplication = 'capp', 
    kAudioDevicePropertyDeviceUID = 'uid ', 
    kAudioDevicePropertyModelUID = 'muid', 
    kAudioDevicePropertyTransportType = 'tran', 
    kAudioDevicePropertyRelatedDevices = 'akin', 
    kAudioDevicePropertyClockDomain = 'clkd', 
    kAudioDevicePropertyDeviceIsAlive = 'livn', 
    kAudioDevicePropertyDeviceHasChanged = 'diff', 
    kAudioDevicePropertyDeviceIsRunning = 'goin', 
    kAudioDevicePropertyDeviceIsRunningSomewhere = 'gone', 
    kAudioDevicePropertyDeviceCanBeDefaultDevice = 'dflt', 
    kAudioDevicePropertyDeviceCanBeDefaultSystemDevice = 'sflt', 
    kAudioDeviceProcessorOverload = 'over', 
    kAudioDevicePropertyHogMode = 'oink', 
    kAudioDevicePropertyLatency = 'ltnc', 
    kAudioDevicePropertyBufferFrameSize = 'fsiz', 
    kAudioDevicePropertyBufferFrameSizeRange = 'fsz#', 
    kAudioDevicePropertyUsesVariableBufferFrameSizes = 'vfsz', 
    kAudioDevicePropertyStreams = 'stm#', 
    kAudioDevicePropertySafetyOffset = 'saft', 
    kAudioDevicePropertyIOCycleUsage = 'ncyc', 
    kAudioDevicePropertyStreamConfiguration = 'slay', 
    kAudioDevicePropertyIOProcStreamUsage = 'suse', 
    kAudioDevicePropertyPreferredChannelsForStereo = 'dch2', 
    kAudioDevicePropertyPreferredChannelLayout = 'srnd', 
    kAudioDevicePropertyNominalSampleRate = 'nsrt', 
    kAudioDevicePropertyAvailableNominalSampleRates = 'nsr#', 
    kAudioDevicePropertyActualSampleRate = 'asrt' 
};  
Constants
kAudioDevicePropertyPlugIn
An OSStatus that contains any error codes generated by loading the IOAudio driver plug-in for the AudioDevice or kAudioHardwareNoError if the plug-in loaded successfully. This property only exists for IOAudio-based AudioDevices whose driver has specified a plug-in to load.
kAudioDevicePropertyConfigurationApplication
A CFString that contains the bundle ID for an application that provides a GUI for configuring the AudioDevice. By default, the value of this property is the bundle ID for Audio MIDI Setup. The caller is responsible for releasing the returned CFObject.
kAudioDevicePropertyDeviceUID
A CFString that contains a persistent identifier for the AudioDevice. An AudioDevice's UID is persistent across boots. The content of the UID string is a black box and may contain information that is unique to a particular instance of an AudioDevice's hardware or unique to the CPU. Therefore they are not suitable for passing between CPUs or for identifying similar models of hardware.
kAudioDevicePropertyModelUID
A CFString that contains a persistent identifier for the model of an AudioDevice. The identifier is unique such that the identifier from two AudioDevices are equal if and only if the two AudioDevices are the exact same model from the same manufacturer. Further, the identifier has to be the same no matter on what machine the AudioDevice appears.
kAudioDevicePropertyTransportType
A UInt32 whose value indicates how the AudioDevice is connected to the CPU. Constants for some of the values for this property can be found in .
kAudioDevicePropertyRelatedDevices
An array of AudioDeviceIDs for devices related to the AudioDevice. For IOAudio-based devices, a AudioDevices are related if they share the same IOAudioDevice object.
kAudioDevicePropertyClockDomain
A UInt32 whose value indicates the clock domain to which this AudioDevice belongs. AudioDevices that have the same value for this property are able to be synchronized in hardware. However, a value of 0 indicates that the clock domain for the device is unspecified and should be assumed to be separate from every other device's clock domain, even if they have the value of 0 as their clock domain as well.
kAudioDevicePropertyDeviceIsAlive
A UInt32 where a value of 1 means the device is ready and available and 0 means the device is usable and will most likely go away shortly.
kAudioDevicePropertyDeviceHasChanged
The type of this property is a UInt32, but it's value has no meaning. This property exists so that clients can listen to it and be told when the configuration of the AudioDevice has changed in ways that cannot otherwise be conveyed through other notifications. In response to this notification, clients should re-evaluate everything they need to know about the device, particularly the layout and values of the controls.
kAudioDevicePropertyDeviceIsRunning
A UInt32 where a value of 0 means the AudioDevice is not performing IO and a value of 1 means that it is. Note that the device can be running even if there are no active IOProcs such as by calling AudioDeviceStart() and passing a NULL IOProc. Note that the notification for this property is usually sent from the AudioDevice's IO thread.
kAudioDevicePropertyDeviceIsRunningSomewhere
A UInt32 where 1 means that the AudioDevice is running in at least one process on the system and 0 means that it isn't running at all.
kAudioDevicePropertyDeviceCanBeDefaultDevice
A UInt32 where 1 means that the AudioDevice is a possible selection for kAudioHardwarePropertyDefaultInputDevice or kAudioHardwarePropertyDefaultOutputDevice depending on the scope.
kAudioDevicePropertyDeviceCanBeDefaultSystemDevice
A UInt32 where 1 means that the AudioDevice is a possible selection for kAudioHardwarePropertyDefaultSystemOutputDevice.
kAudioDeviceProcessorOverload
A UInt32 where the value has no meaning. This property exists so that clients can be notified when the AudioDevice detects that an IO cycle has run past it's deadline. Note that the notification for this property is usually sent from the AudioDevice's IO thread.
kAudioDevicePropertyHogMode
A pid_t indicating the process that currently owns exclusive access to the AudioDevice or a value of -1 indicating that the device is currently available to all processes. If the AudioDevice is in a non-mixable mode, the HAL will automatically take hog mode on behalf of the first process to start an IOProc.
kAudioDevicePropertyLatency
A UInt32 containing the number of frames of latency in the AudioDevice. Note that input and output latency may differ. Further, the AudioDevice's AudioStreams may have additional latency so they should be queried as well. If both the device and the stream say they have latency, then the total latency for the stream is the device latency summed with the stream latency.
kAudioDevicePropertyBufferFrameSize
A UInt32 whose value indicates the number of frames in the IO buffers.
kAudioDevicePropertyBufferFrameSizeRange
An AudioValueRange indicating the minimum and maximum values, inclusive, for kAudioDevicePropertyBufferFrameSize.
kAudioDevicePropertyUsesVariableBufferFrameSizes
A UInt32 that, if implemented by a device, indicates that the sizes of the buffers passed to an IOProc will vary by a small amount. The value of this property will indicate the largest buffer that will be passed and kAudioDevicePropertyBufferFrameSize will indicate the smallest buffer that will get passed to the IOProc. The usage of this property is narrowed to only allow for devices whose buffer sizes vary by small amounts greater than kAudioDevicePropertyBufferFrameSize. It is not intended to be a license for devices to be able to send buffers however they please. Rather, it is intended to allow for hardware whose natural rhythms lead to this necessity.
kAudioDevicePropertyStreams
An array of AudioStreamIDs that represent the AudioStreams of the AudioDevice. Note that if a notification is received for this property, any cached AudioStreamIDs for the device become invalid and need to be re-fetched.
kAudioDevicePropertySafetyOffset
A UInt32 whose value indicates the number for frames in ahead (for output) or behind (for input the current hardware position that is safe to do IO.
kAudioDevicePropertyIOCycleUsage
A Float32 whose range is from 0 to 1. This value indicates how much of the client portion of the IO cycle the process will use. The client portion of the IO cycle is the portion of the cycle in which the device calls the IOProcs so this property does not the apply to the duration of the entire cycle.
kAudioDevicePropertyStreamConfiguration
This property returns the stream configuration of the device in an AudioBufferList (with the buffer pointers set to NULL) which describes the list of streams and the number of channels in each stream. This corresponds to what will be passed into the IOProc.
kAudioDevicePropertyIOProcStreamUsage
An AudioHardwareIOProcStreamUsage structure which details the stream usage of a given IO proc. If a stream is marked as not being used, the given IOProc will see a corresponding NULL buffer pointer in the AudioBufferList passed to it's IO proc. Note that the number of streams detailed in the AudioHardwareIOProcStreamUsage must include all the streams of that direction on the device. Also, when getting the value of the property, one must fill out the mIOProc field of the AudioHardwareIOProcStreamUsage with the address of the of the IOProc whose stream usage is to be retrieved.
kAudioDevicePropertyPreferredChannelsForStereo
An array of two UInt32s, the first for the left channel, the second for the right channel, that indicate the channel numbers to use for stereo IO on the device. The value of this property can be different for input and output and there are no restrictions on the channel numbers that can be used.
kAudioDevicePropertyPreferredChannelLayout
An AudioChannelLayout that indicates how each channel of the AudioDevice should be used.
kAudioDevicePropertyNominalSampleRate
A Float64 that indicates the current nominal sample rate of the AudioDevice.
kAudioDevicePropertyAvailableNominalSampleRates
An array of AudioValueRange structs that indicates the valid ranges for the nominal sample rate of the AudioDevice.
kAudioDevicePropertyActualSampleRate
A Float64 that indicates the current actual sample rate of the AudioDevice as measured by it's time stamps.
Discussion 

AudioDevices have four scopes: kAudioDevicePropertyScopeGlobal, kAudioDevicePropertyScopeInput, kAudioDevicePropertyScopeOutput, and kAudioDevicePropertyScopePlayThrough. They have a master element and an element for each channel in each stream numbered according to the starting channel number of each stream.*/
enum { 
    kAudioDevicePropertyPlugIn = 'plug', 
    kAudioDevicePropertyConfigurationApplication = 'capp', 
    kAudioDevicePropertyDeviceUID = 'uid ', 
    kAudioDevicePropertyModelUID = 'muid', 
    kAudioDevicePropertyTransportType = 'tran', 
    kAudioDevicePropertyRelatedDevices = 'akin', 
    kAudioDevicePropertyClockDomain = 'clkd', 
    kAudioDevicePropertyDeviceIsAlive = 'livn', 
    kAudioDevicePropertyDeviceHasChanged = 'diff', 
    kAudioDevicePropertyDeviceIsRunning = 'goin', 
    kAudioDevicePropertyDeviceIsRunningSomewhere = 'gone', 
    kAudioDevicePropertyDeviceCanBeDefaultDevice = 'dflt', 
    kAudioDevicePropertyDeviceCanBeDefaultSystemDevice = 'sflt', 
    kAudioDeviceProcessorOverload = 'over', 
    kAudioDevicePropertyHogMode = 'oink', 
    kAudioDevicePropertyLatency = 'ltnc', 
    kAudioDevicePropertyBufferFrameSize = 'fsiz', 
    kAudioDevicePropertyBufferFrameSizeRange = 'fsz#', 
    kAudioDevicePropertyUsesVariableBufferFrameSizes = 'vfsz', 
    kAudioDevicePropertyStreams = 'stm#', 
    kAudioDevicePropertySafetyOffset = 'saft', 
    kAudioDevicePropertyIOCycleUsage = 'ncyc', 
    kAudioDevicePropertyStreamConfiguration = 'slay', 
    kAudioDevicePropertyIOProcStreamUsage = 'suse', 
    kAudioDevicePropertyPreferredChannelsForStereo = 'dch2', 
    kAudioDevicePropertyPreferredChannelLayout = 'srnd', 
    kAudioDevicePropertyNominalSampleRate = 'nsrt', 
    kAudioDevicePropertyAvailableNominalSampleRates = 'nsr#', 
    kAudioDevicePropertyActualSampleRate = 'asrt' 
};

/*AudioObject


AudioObjectPropertySelector values that apply to all AudioObjects. 
enum { 
    kAudioObjectPropertyClass = 'clas', 
    kAudioObjectPropertyOwner = 'stdv', 
    kAudioObjectPropertyCreator = 'oplg', 
    kAudioObjectPropertyName = 'lnam', 
    kAudioObjectPropertyManufacturer = 'lmak', 
    kAudioObjectPropertyElementName = 'lchn', 
    kAudioObjectPropertyElementCategoryName = 'lccn', 
    kAudioObjectPropertyElementNumberName = 'lcnn', 
    kAudioObjectPropertyOwnedObjects = 'ownd', 
    kAudioObjectPropertyListenerAdded = 'lisa', 
    kAudioObjectPropertyListenerRemoved = 'lisr' 
};  
Constants
kAudioObjectPropertyClass
An AudioClassID that identifies the class of the AudioObject.
kAudioObjectPropertyOwner
An AudioObjectID that identifies the the AudioObject that owns the given AudioObject. Note that all AudioObjects are owned by some other AudioObject. The only exception is the AudioSystemObject, for which the value of this property is kAudioObjectUnknown.
kAudioObjectPropertyCreator
A CFString that contains the bundle ID of the plug-in that instantiated the object.
kAudioObjectPropertyObjectName
A CFString that contains the human readable name of the object. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyManufacturer
A CFString that contains the human readable name of the manufacturer of the hardware the AudioObject is a part of. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyElementName
A CFString that contains a human readable name for the given element in the given scope. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyElementCategoryName
A CFString that contains a human readable name for the category of the given element in the given scope. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyElementNumberName
A CFString that contains a human readable name for the number of the given element in the given scope. The caller is responsible for releasing the returned CFObject.
kAudioObjectPropertyOwnedObjects
An array of AudioObjectIDs that represent all the AudioObjects owned by the given object. The qualifier is an array of AudioClassIDs. If it is non-empty, the returned array of AudioObjectIDs will only refer to objects whose class is in the qualifier array or whose is a subclass of one in the qualifier array.
kAudioObjectPropertyListenerAdded
An AudioObjectPropertyAddress indicating the address to which a new listener was added. Note that this property is not for applications to use. Rather, this property is for the HAL shell to notify AudioObjects implemented by an AudioPlugIn when a listener is added.
kAudioObjectPropertyListenerRemoved
An AudioObjectPropertyAddress indicating the address to which a listener was removed. Note that this property is not for applications to use. Rather, this property is for the HAL shell to notify AudioObjects implemented by an AudioPlugIn when a listener is removed.
Discussion 

Property Selectors*/
enum { 
    kAudioObjectPropertyClass = 'clas', 
    kAudioObjectPropertyOwner = 'stdv', 
    kAudioObjectPropertyCreator = 'oplg', 
    kAudioObjectPropertyName = 'lnam', 
    kAudioObjectPropertyManufacturer = 'lmak', 
    kAudioObjectPropertyElementName = 'lchn', 
    kAudioObjectPropertyElementCategoryName = 'lccn', 
    kAudioObjectPropertyElementNumberName = 'lcnn', 
    kAudioObjectPropertyOwnedObjects = 'ownd', 
    kAudioObjectPropertyListenerAdded = 'lisa', 
    kAudioObjectPropertyListenerRemoved = 'lisr' 
};

/*AudioDevice Properties That Ought To Some Day Be Deprecated


AudioObjectPropertySelector values whose functionality is better provided by other selectors. 
enum { 
    kAudioDevicePropertyDeviceName = 'name', 
    kAudioDevicePropertyDeviceNameCFString = kAudioObjectPropertyName, 
    kAudioDevicePropertyDeviceManufacturer = 'makr', 
    kAudioDevicePropertyDeviceManufacturerCFString = kAudioObjectPropertyManufacturer, 
    kAudioDevicePropertyRegisterBufferList = 'rbuf', 
    kAudioDevicePropertyBufferSize = 'bsiz', 
    kAudioDevicePropertyBufferSizeRange = 'bsz#', 
    kAudioDevicePropertyChannelName = 'chnm', 
    kAudioDevicePropertyChannelNameCFString = kAudioObjectPropertyElementName, 
    kAudioDevicePropertyChannelCategoryName = 'ccnm', 
    kAudioDevicePropertyChannelCategoryNameCFString = kAudioObjectPropertyElementCategoryName, 
    kAudioDevicePropertyChannelNumberName = 'cnnm', 
    kAudioDevicePropertyChannelNumberNameCFString = kAudioObjectPropertyElementNumberName, 
    kAudioDevicePropertySupportsMixing = 'mix?', 
    kAudioDevicePropertyStreamFormat = 'sfmt', 
    kAudioDevicePropertyStreamFormats = 'sfm#', 
    kAudioDevicePropertyStreamFormatSupported = 'sfm?', 
    kAudioDevicePropertyStreamFormatMatch = 'sfmm', 
    kAudioDevicePropertyDataSourceNameForID = 'sscn', 
    kAudioDevicePropertyClockSourceNameForID = 'cscn', 
    kAudioDevicePropertyPlayThruDestinationNameForID = 'mddn', 
    kAudioDevicePropertyChannelNominalLineLevelNameForID = 'cnlv' 
};  
Constants
kAudioDevicePropertyDeviceName
A C-string that contains the human readable name of the AudioDevice. (kAudioObjectPropertyName: CFStrings are better for localization.)
kAudioDevicePropertyDeviceNameCFString
A CFStringRef that contains the human readable name of the AudioDevice. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyName: This is just another name for the inherited selector.)
kAudioDevicePropertyDeviceManufacturer
A C-string that contains the human readable name of the manufacturer of the AudioDevice. (kAudioObjectPropertyManufacturer: CFStrings are better for localization.)
kAudioDevicePropertyDeviceManufacturerCFString
A CFString that contains the human readable name of the manufacturer of the AudioDevice. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyManufacturer: This is just another name for the inherited selector.)
kAudioDevicePropertyRegisterBufferList
This property allows clients to register a fully populated AudioBufferList that matches the topology described by kAudioDevicePropertyStreamConfiguration for doing input using AudioDeviceRead(). The AudioBufferList will be registered with the call the AudioDeviceSetProperty() and will be unregistered with the call to AudioDeviceGetProperty(). If this property isn't implemented by the AudioDevice, it implies that the AudioDevice also doesn't support AudioDeviceRead(). (Aggregate devices make AudioDeviceRead() obsolete for the most part.)
kAudioDevicePropertyBufferSize
A UInt32 containing the size in bytes of the IO buffer for the AudioStream containing the element. (kAudioDevicePropertyBufferFrameSize: with multiple AudioStreams and the requirement that all streams' buffers represent the same amount of time, it doesn't make sense to set the buffer size in bytes since it will be different for each stream.)
kAudioDevicePropertyBufferSizeRange
An AudioValueRange specifying the minimum and maximum bytes size for the IO buffer for the AudioStream containing the given element. (kAudioDevicePropertyBufferFrameSizeRange: see kAudioDevicePropertyBufferSize.)
kAudioDevicePropertyChannelName
A CFString that contains a human readable name for the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementName: CFStrings are better for localization.)
kAudioDevicePropertyChannelNameCFString
A CFString that contains a human readable name for the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementName: This is just another name for the inherited selector.)
kAudioDevicePropertyChannelCategoryName
A CFString that contains a human readable name for the category of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementCategoryName: CFStrings are better for localization.)
kAudioDevicePropertyChannelCategoryNameCFString
A CFString that contains a human readable name for the category of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementCategoryName: This is just another name for the inherited selector.)
kAudioDevicePropertyChannelNumberName
A CFString that contains a human readable name for the number of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementNumberName: CFStrings are better for localization.)
kAudioDevicePropertyChannelNumberNameCFString
A CFString that contains a human readable name for the number of the given element in the given scope. The caller is responsible for releasing the returned CFObject. (kAudioObjectPropertyElementNumberName: This is just another name for the inherited selector.)
kAudioDevicePropertySupportsMixing
A UInt32 where a value of 1 means the AudioDevice supports mixing and a value of 0 means that it doesn't and that all IO is performed in each AudioStream's current physical format. This property is changed indirectly by changing to a format that doesn't support mixing, such as AC-3. (The HAL now vends it's format information with a flag indicating the mixability in order to better support devices with streams that are both mixable and non- mixable.)
kAudioDevicePropertyStreamFormat
An AudioStreamBasicDescription that describes the current data format for the AudioStream that contains the channel referred to by the element number. (kAudioStreamPropertyVirtualFormat: Managing format information is inherently an operation on AudioStreams, rather than AudioDevices. It is confusing for the client to work with formats at the AudioDevice level and has been shown to lead to programming mistakes by clients when working with devices that have multiple streams.)
kAudioDevicePropertyStreamFormats
An array of AudioStreamBasicDescriptions that describe the available data formats for the AudioStream that contains the channel referred to by the element number. (kAudioStreamPropertyAvailableVirtualFormats: Managing format information is inherently an operation on AudioStreams, rather than AudioDevices. It is confusing for the client to work with formats at the AudioDevice level and has been shown to lead to programming mistakes by clients when working with devices that have multiple streams.)
kAudioDevicePropertyStreamFormatSupported
An AudioStreamBasicDescription is passed in to query whether or not the format is supported. A kAudioDeviceUnsupportedFormatError will be returned if the format is not supported and kAudioHardwareNoError will be returned if it is supported. AudioStreamBasicDescription fields set to 0 will be ignored in the query, but otherwise values must match exactly. (kAudioStreamPropertyAvailableVirtualFormats: The proper and most robust way to find a format that the AudioStream can support is to get the list of available formats and look through that rather than using this property.)
kAudioDevicePropertyStreamFormatMatch
An AudioStreamBasicDescription is passed in and the AudioStream will modify it to describe the best match, in the AudioDevice's opinion, for the given format. (kAudioStreamPropertyAvailableVirtualFormats: The proper and most robust way to find a format that the AudioStream can support is to get the list of available formats and look through that rather than using this property.)
kAudioDevicePropertyDataSourceNameForID
This property translates the given data source item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyDataSourceNameForIDCFString: CFStrings are better for localization.)
kAudioDevicePropertyClockSourceNameForID
This property translates the given clock source item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyClockSourceNameForIDCFString: CFStrings are better for localization.)
kAudioDevicePropertyPlayThruDestinationNameForID
This property translates the given play through destination item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyPlayThruDestinationNameForIDCFString: CFStrings are better for localization.)
kAudioDevicePropertyChannelNominalLineLevelNameForID
This property translates the given nominal line level item ID into a human readable name using an AudioValueTranslation structure. The input data is the UInt32 holding the item ID to be translated and the output data is a buffer to hold the name as a null terminated c-string. (kAudioDevicePropertyChannelNominalLineLevelNameForIDCFString: CFStrings are better for localization.)
Discussion 

These selectors are still provided for backward compatibility. The description of the property will indicate in parentheses the better selectors to use and why.*/
enum { 
    kAudioDevicePropertyDeviceName = 'name', 
    kAudioDevicePropertyDeviceNameCFString = kAudioObjectPropertyName, 
    kAudioDevicePropertyDeviceManufacturer = 'makr', 
    kAudioDevicePropertyDeviceManufacturerCFString = kAudioObjectPropertyManufacturer, 
    kAudioDevicePropertyRegisterBufferList = 'rbuf', 
    kAudioDevicePropertyBufferSize = 'bsiz', 
    kAudioDevicePropertyBufferSizeRange = 'bsz#', 
    kAudioDevicePropertyChannelName = 'chnm', 
    kAudioDevicePropertyChannelNameCFString = kAudioObjectPropertyElementName, 
    kAudioDevicePropertyChannelCategoryName = 'ccnm', 
    kAudioDevicePropertyChannelCategoryNameCFString = kAudioObjectPropertyElementCategoryName, 
    kAudioDevicePropertyChannelNumberName = 'cnnm', 
    kAudioDevicePropertyChannelNumberNameCFString = kAudioObjectPropertyElementNumberName, 
    kAudioDevicePropertySupportsMixing = 'mix?', 
    kAudioDevicePropertyStreamFormat = 'sfmt', 
    kAudioDevicePropertyStreamFormats = 'sfm#', 
    kAudioDevicePropertyStreamFormatSupported = 'sfm?', 
    kAudioDevicePropertyStreamFormatMatch = 'sfmm', 
    kAudioDevicePropertyDataSourceNameForID = 'sscn', 
    kAudioDevicePropertyClockSourceNameForID = 'cscn', 
    kAudioDevicePropertyPlayThruDestinationNameForID = 'mddn', 
    kAudioDevicePropertyChannelNominalLineLevelNameForID = 'cnlv' 
};

/*AudioSystemObject Properties


AudioObjectPropertySelector values that apply to the AudioSystemObject. 
enum { 
    kAudioHardwarePropertyProcessIsMaster = 'mast', 
    kAudioHardwarePropertyIsInitingOrExiting = 'inot', 
    kAudioHardwarePropertyDevices = 'dev#', 
    kAudioHardwarePropertyDefaultInputDevice = 'dIn ', 
    kAudioHardwarePropertyDefaultOutputDevice = 'dOut', 
    kAudioHardwarePropertyDefaultSystemOutputDevice = 'sOut', 
    kAudioHardwarePropertyDeviceForUID = 'duid', 
    kAudioHardwarePropertySleepingIsAllowed = 'slep', 
    kAudioHardwarePropertyUnloadingIsAllowed = 'unld', 
    kAudioHardwarePropertyHogModeIsAllowed = 'hogr', 
    kAudioHardwarePropertyRunLoop = 'rnlp', 
    kAudioHardwarePropertyPlugInForBundleID = 'pibi' 
};  
Constants
kAudioHardwarePropertyProcessIsMaster
A UInt32 where 1 means that the current process contains the master instance of the HAL. The master instance of the HAL is the only instance in which plug-ins should save/restore their devices' settings.
kAudioHardwarePropertyIsInitingOrExiting
A UInt32 whose value will be non-zero if the HAL is either in the midst of initializing or in the midst of exiting the process.
kAudioHardwarePropertyDevices
An array of the AudioDeviceIDs that represent all the devices currently available to the system.
kAudioHardwarePropertyDefaultInputDevice
The AudioDeviceID of the default input AudioDevice.
kAudioHardwarePropertyDefaultOutputDevice
The AudioDeviceID of the default output AudioDevice.
kAudioHardwarePropertyDefaultOutputDevice
The AudioDeviceID of the output AudioDevice to use for system related sound from the alert sound to digital call progress.
kAudioHardwarePropertyDeviceForUID
Using an AudioValueTranslation structure, this property translates the input CFStringRef containing a UID into the AudioDeviceID that refers to the AudioDevice with that UID. This property will return kAudioDeviceUnknown if the given UID does not match any currently available AudioDevice.
kAudioHardwarePropertySleepingIsAllowed
A UInt32 where 1 means that the process will allow the CPU to idle sleep even if there is audio IO in progress. A 0 means that the CPU will not be allowed to idle sleep. Note that this property won't affect when the CPU is forced to sleep.
kAudioHardwarePropertyUnloadingIsAllowed
A UInt32 where 1 means that this process wants the HAL to unload itself after a period of inactivity where there are no IOProcs and no listeners registered with any AudioObject.
kAudioHardwarePropertyHogModeIsAllowed
A UInt32 where 1 means that this process wants the HAL to automatically take hog mode and 0 means that the HAL should not automatically take hog mode on behalf of the process. Processes that only ever use the default device are the sort of that should set this property's value to 0.
kAudioHardwarePropertyRunLoop
The CFRunLoopRef the HAL is currently attaching all of it's system notification handlers to. By default, the HAL will create and manage it's own thread for this job. Clients can set this property to tell the HAL to use a thread of the client's choosing. The caller is responsible for releasing the returned CFObject.
kAudioHardwarePropertyPlugInForBundleID
Using an AudioValueTranslation structure, this property translates the input CFString containing a bundle ID into the AudioObjectID of the AudioPlugIn that corresponds to it. This property will return kAudioObjectUnkown if the given bundle ID doesn't match any AudioPlugIns.
Discussion 

The AudioSystemObject has one scope, kAudioObjectPropertyScopeGlobal, and only a master element*/
enum { 
    kAudioHardwarePropertyProcessIsMaster = 'mast', 
    kAudioHardwarePropertyIsInitingOrExiting = 'inot', 
    kAudioHardwarePropertyDevices = 'dev#', 
    kAudioHardwarePropertyDefaultInputDevice = 'dIn ', 
    kAudioHardwarePropertyDefaultOutputDevice = 'dOut', 
    kAudioHardwarePropertyDefaultSystemOutputDevice = 'sOut', 
    kAudioHardwarePropertyDeviceForUID = 'duid', 
    kAudioHardwarePropertySleepingIsAllowed = 'slep', 
    kAudioHardwarePropertyUnloadingIsAllowed = 'unld', 
    kAudioHardwarePropertyHogModeIsAllowed = 'hogr', 
    kAudioHardwarePropertyRunLoop = 'rnlp', 
    kAudioHardwarePropertyPlugInForBundleID = 'pibi' 
};

/*AudioObjectID


AudioObject is the base class for all the objects in the HAL. 
typedef UInt32 AudioObjectID;  
Discussion 

AudioObjects have properties and can contain other AudioObjects.*/
typedef UInt32 AudioObjectID;


/*AudioObjectPropertySelector


An AudioObjectPropertySelector is a four char code that identifies, along with the AudioObjectPropertyScope and AudioObjectPropertyElement, a specific piece of information about an AudioObject. 
typedef UInt32 AudioObjectPropertySelector;  
Discussion 

The property selector specifies the general classification of the property such as volume, stream format, latency, etc. Note that each class has a different set of selectors. A subclass inherits it's super class's set of selectors, although it may not implement them all.*/
typedef UInt32 AudioObjectPropertySelector;

/*AudioDevicePropertyID


An AudioDevicePropertyID is an integer that identifies a specific piece of information about the object. 
typedef AudioObjectPropertySelector AudioDevicePropertyID;  */
typedef AudioObjectPropertySelector AudioDevicePropertyID;

/*AudioDeviceID


AudioDevice is the base class for all objects that represent an audio device. 
typedef AudioObjectID AudioDeviceID;  
Discussion 

AudioDevice is a subclass of AudioObject. AudioDevices normally contain AudioStreams and AudioControls, but may contain other things depending on the kind of AudioDevice (e.g. aggregate devices contain other AudioDevices).*/
typedef AudioObjectID AudioDeviceID;

/*AudioHardwarePropertyID


An AudioHardwarePropertyID is a integer that identifies a specific piece of information about the AudioSystemObject. 
typedef AudioObjectPropertySelector AudioHardwarePropertyID;  */
typedef AudioObjectPropertySelector AudioHardwarePropertyID;


/*AudioHardwarePropertyListenerProc


Clients register an AudioHardwarePropertyListenerProc with the AudioSystemObject in order to receive notifications when the properties of the object change. 
typedef OSStatus (*AudioHardwarePropertyListenerProc)(
    AudioHardwarePropertyID inPropertyID, 
    void*inClientData);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property that changed.
inClientData
A pointer to client data established when the listener proc was registered with the AudioSystemObject.
Return Value

The return value is currently unused and should always be 0. 
Discussion 

Note that the same functionality is provided by AudioObjectPropertyListenerProc.*/
typedef OSStatus (*AudioHardwarePropertyListenerProc)(
    AudioHardwarePropertyID inPropertyID, 
    void*inClientData);


/*AudioHardwareGetPropertyInfo


Retrieve information about the given property. 
extern OSStatus AudioHardwareGetPropertyInfo(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to query.
outSize
A pointer to a UInt32 that receives the size of the property data in bytes on exit. This can be NULL if the size information is not being requested.
outWritable
A pointer to a Boolean that receives indication of whether or not the given property can be set. This can be NULL if the writability is not being requested.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the functions AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and AudioObjectGetPropertyDataSize(). 
Availability
Introduced in Mac OS X v10.0.*/
extern OSStatus AudioHardwareGetPropertyInfo(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);  

/*AudioHardwareGetProperty


Queries an the AudioSystemObject to get the data of the given property and places it in the provided buffer. 
extern OSStatus AudioHardwareGetProperty(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to query.
ioDataSize
A UInt32 which on entry indicates the size of the buffer pointed to by outData and on exit indicates how much of the buffer was used.
outData
The buffer into which the AudioSystemObject will put the data for the given property.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/
extern OSStatus AudioHardwareGetProperty(
    AudioHardwarePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);


/*AudioDeviceGetProperty


Queries an the AudioDevice object to get the data of the given property and places it in the provided buffer. 
extern OSStatus AudioDeviceGetProperty(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  
Parameters
inDevice
The AudioDevice to query.
inChannel
The channel of the property to query where 0 is the master channel.
isInput
Which section of the AudioDevice to query.
inPropertyID
The AudioDevicePropertyID of the property to query.
ioPropertyDataSize
A UInt32 which on entry indicates the size of the buffer pointed to by outData and on exit indicates how much of the buffer was used.
outPropertyData
The buffer into which the object will put the data for the given property.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the function AudioObjectGetPropertyData(). 
Availability
Introduced in Mac OS X v10.0.*/
extern OSStatus AudioDeviceGetProperty(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*ioPropertyDataSize, 
    void*outPropertyData);  


/*AudioDeviceGetPropertyInfo


Retrieve information about the given property of an AudioDevice. 
extern OSStatus AudioDeviceGetPropertyInfo(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);  
Parameters
inDevice
The AudioDevice to query.
inChannel
The channel of the property to query where 0 is the master channel.
isInput
Which section of the AudioDevice to query.
inPropertyID
The AudioDevicePropertyID of the property to query.
outSize
A pointer to a UInt32 that receives the size of the property data in bytes on exit. This can be NULL if the size information is not being requested.
outWritable
A pointer to a Boolean that receives indication of whether or not the given property can be set. This can be NULL if the writability is not being requested.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by the functions AudioObjectHasProperty(), AudioObjectIsPropertySettable(), and AudioObjectGetPropertyDataSize(). 
Availability
Introduced in Mac OS X v10.0.*/
extern OSStatus AudioDeviceGetPropertyInfo(
    AudioDeviceID inDevice, 
    UInt32 inChannel, 
    Boolean isInput, 
    AudioDevicePropertyID inPropertyID, 
    UInt32*outSize, 
    Boolean*outWritable);

/*AudioHardwareAddPropertyListener


Registers the given AudioHardwarePropertyListenerProc to receive notifications when the given property changes. 
extern OSStatus AudioHardwareAddPropertyListener(
    AudioHardwarePropertyID inPropertyID, 
    AudioHardwarePropertyListenerProc inProc, 
    void*inClientData);  
Parameters
inPropertyID
The AudioHardwarePropertyID of the property to listen to.
inProc
AudioHardwarePropertyListenerProc to call.
inClientData
A pointer to client data that is passed to the listener when it is called.
Return Value

An OSStatus indicating success or failure. 
Discussion 

Note that the same functionality is provided by AudioObjectAddPropertyListener in conjunction with AudioObjectPropertyListenerProc. 
Availability
Introduced in Mac OS X v10.0.*/
extern OSStatus AudioHardwareAddPropertyListener(
    AudioHardwarePropertyID inPropertyID, 
    AudioHardwarePropertyListenerProc inProc, 
    void*inClientData);

#ifdef __cplusplus
}
#endif

#endif