#ifndef CFURL_H
#define CFURL_H

#include <CoreFoundation/CFBase.h>
#include <CoreFoundation/CFData.h>
#include <CoreFoundation/CFString.h>

#ifndef  FILES_H
//#include <CarbonCore/Files.h> //hys
#endif

//#include <HYS/CoreFoundation/CFURL.h>
#if defined(__cplusplus)
extern "C" {
#endif

struct FSRef;

/*Path Style

Options you can use to determine how CFURL functions parse a file system path name. 

enum CFURLPathStyle {
   kCFURLPOSIXPathStyle = 0,
   kCFURLHFSPathStyle = 1,
   kCFURLWindowsPathStyle = 2
};
typedef enum CFURLPathStyle CFURLPathStyle;
Constants
kCFURLPOSIXPathStyle

Indicates a POSIX style path name. Components are slash delimited. A leading slash indicates an absolute path; a trailing slash is not significant.

Available in Mac OS X v10.0 and later.
kCFURLHFSPathStyle

Indicates a HFS style path name. Components are colon delimited. A leading colon indicates a relative path, otherwise the first path component denotes the volume.

Available in Mac OS X v10.0 and later.
kCFURLWindowsPathStyle

Indicates a Windows style path name.

Available in Mac OS X v10.0 and later.*/
enum CFURLPathStyle {
   kCFURLPOSIXPathStyle = 0,
   kCFURLHFSPathStyle = 1,
   kCFURLWindowsPathStyle = 2
};
typedef enum CFURLPathStyle CFURLPathStyle;

/*Component Type

The types of components in a URL.

typedef enum {
   kCFURLComponentScheme = 1,
   kCFURLComponentNetLocation = 2,
   kCFURLComponentPath = 3,
   kCFURLComponentResourceSpecifier = 4,
   kCFURLComponentUser = 5,
   kCFURLComponentPassword = 6,
   kCFURLComponentUserInfo = 7,
   kCFURLComponentHost = 8,
   kCFURLComponentPort = 9,
   kCFURLComponentParameterString = 10,
   kCFURLComponentQuery = 11,
   kCFURLComponentFragment = 12
} CFURLComponentType;
typedef enum CFURLPathStyle CFURLPathStyle;
Constants
kCFURLComponentScheme

The URL’s scheme.

Available in Mac OS X v10.3 and later.
kCFURLComponentNetLocation

The URL’s network location.

Available in Mac OS X v10.3 and later.
kCFURLComponentPath

The URL’s path component.

Available in Mac OS X v10.3 and later.
kCFURLComponentResourceSpecifier

The URL’s resource specifier.

Available in Mac OS X v10.3 and later.
kCFURLComponentUser
Component Type

/*The types of components in a URL.

typedef enum {
   kCFURLComponentScheme = 1,
   kCFURLComponentNetLocation = 2,
   kCFURLComponentPath = 3,
   kCFURLComponentResourceSpecifier = 4,
   kCFURLComponentUser = 5,
   kCFURLComponentPassword = 6,
   kCFURLComponentUserInfo = 7,
   kCFURLComponentHost = 8,
   kCFURLComponentPort = 9,
   kCFURLComponentParameterString = 10,
   kCFURLComponentQuery = 11,
   kCFURLComponentFragment = 12
} CFURLComponentType;
typedef enum CFURLPathStyle CFURLPathStyle;
Constants
kCFURLComponentScheme

The URL’s scheme.

Available in Mac OS X v10.3 and later.
kCFURLComponentNetLocation

The URL’s network location.

Available in Mac OS X v10.3 and later.
kCFURLComponentPath

The URL’s path component.

Available in Mac OS X v10.3 and later.
kCFURLComponentResourceSpecifier

The URL’s resource specifier.

Available in Mac OS X v10.3 and later.
kCFURLComponentUser

The URL’s user.

Available in Mac OS X v10.3 and later.
kCFURLComponentPassword

The user’s password.

Available in Mac OS X v10.3 and later.
kCFURLComponentUserInfo

The user’s information.

Available in Mac OS X v10.3 and later.
kCFURLComponentHost

The URL’s host.

Available in Mac OS X v10.3 and later.
kCFURLComponentPort

The URL’s port.

Available in Mac OS X v10.3 and later.
kCFURLComponentParameterString

The URL’s parameter string.

Available in Mac OS X v10.3 and later.
kCFURLComponentQuery

The URL’s query.

Available in Mac OS X v10.3 and later.
kCFURLComponentFragment

The URL’s fragment.

Available in Mac OS X v10.3 and later.
Discussion

These constants are used by the CFURLGetByteRangeForComponent function.
Availability
Available in Mac OS X v10.3 and later.
The URL’s user.

Available in Mac OS X v10.3 and later.
kCFURLComponentPassword

The user’s password.

Available in Mac OS X v10.3 and later.
kCFURLComponentUserInfo

The user’s information.

Available in Mac OS X v10.3 and later.
kCFURLComponentHost

The URL’s host.

Available in Mac OS X v10.3 and later.
kCFURLComponentPort

The URL’s port.

Available in Mac OS X v10.3 and later.
kCFURLComponentParameterString

The URL’s parameter string.

Available in Mac OS X v10.3 and later.
kCFURLComponentQuery

The URL’s query.

Available in Mac OS X v10.3 and later.
kCFURLComponentFragment

The URL’s fragment.

Available in Mac OS X v10.3 and later.
Discussion

These constants are used by the CFURLGetByteRangeForComponent function.
Availability
Available in Mac OS X v10.3 and later.*/

typedef enum {
   kCFURLComponentScheme = 1,
   kCFURLComponentNetLocation = 2,
   kCFURLComponentPath = 3,
   kCFURLComponentResourceSpecifier = 4,
   kCFURLComponentUser = 5,
   kCFURLComponentPassword = 6,
   kCFURLComponentUserInfo = 7,
   kCFURLComponentHost = 8,
   kCFURLComponentPort = 9,
   kCFURLComponentParameterString = 10,
   kCFURLComponentQuery = 11,
   kCFURLComponentFragment = 12
} CFURLComponentType;

typedef enum CFURLPathStyle CFURLPathStyle;


/*CFURLRef

A reference to a CFURL object.

typedef const struct __CFURL *CFURLRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFURL *CFURLRef;


/*CFURLCopyPath

Returns the path portion of a given URL.

CFStringRef CFURLCopyPath (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The path of anURL, or NULL if the URL cannot be decomposed (doesn't conform to RFC 1808). Ownership follows the Create Rule.
Discussion

This function does not resolve the URL against its base and replaces all percent escape sequences. This function's return value includes any leading slash (giving the path the normal POSIX appearance), if present. If this behavior is not appropriate, use CFURLCopyStrictPath whose return value omits any leading slash. You may also want to use the function CFURLCopyFileSystemPath, which returns the URL's path as a file system path for the given path style. If the path is to be passed to file system calls, you may also want to use the function CFURLGetFileSystemRepresentation, which returns a C string.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyPath (
   CFURLRef anURL
);

/*CFURLCreateCopyAppendingPathComponent

Creates a copy of a given URL and appends a path component.

CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The CFURL object to which to append a path component. 
pathComponent

The path component to append to url. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components. Pass true if the new component indicates a directory, false otherwise. 
Return Value

A copy of url appended with pathComponent. Ownership follows the Create Rule.
Discussion

The isDirectory argument specifies whether or not the new path component points to a file or a to directory. Note that the URL syntax for a directory and for a file at otherwise the same location are slightly different—directory URLs must end in “/”. If you have the URL http://www.apple.com/foo/ and you append the path component bar, then if isDirectory is YES then the resulting URL is http://www.apple.com/foo/bar/, whereas if isDirectory is NO then the resulting URL is http://www.apple.com/foo/bar. This difference is particularly important if you resolve another URL against this new URL. file.html relative to http://www.apple.com/foo/bar is http://www.apple.com/foo/file.html, whereas file.html relative to http://www.apple.com/foo/bar/ is http://www.apple.com/foo/bar/file.html.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateCopyAppendingPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url,
   CFStringRef pathComponent,
   Boolean isDirectory
);

/*CFURLGetFSRef

Converts a given URL to a file or directory object.

Boolean CFURLGetFSRef (
   CFURLRef url,
   FSRef *fsRef
);
Parameters
url

The CFURL object to convert to a file or directory object.
fsRef

Upon return, contains the file or directory object representing url.
Return Value

true if the conversion was successful, otherwise false.
Special Considerations

The function cannot create an FSRef object if the path specified by url contains an alias. The function can, however, traverse symbolic links.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFSRef (
   CFURLRef url,
   struct FSRef *fsRef
);

/*CFURLCreateFromFSRef

Creates a URL from a given directory or file.

CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const FSRef *fsRef
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
fsRef

The file or directory representing the URL. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

CFURLRef CFURLCreateFromFSRef (
   CFAllocatorRef allocator,
   const struct FSRef *fsRef
);

/*CFURLCreateFromFileSystemRepresentation

Creates a new CFURL object for a file system entity using the native representation.

CFURLRef CFURLCreateFromFileSystemRepresentation (
   CFAllocatorRef allocator,
   const UInt8 *buffer,
   CFIndex bufLen,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
buffer

The character bytes to convert into a CFURL object. This should be the path as you would use in POSIX function calls.
bufLen

The number of bytes in the buffer. 
isDirectory

A Boolean value that specifies whether the string is treated as a directory path when resolving against relative path components—true if the pathname indicates a directory, false otherwise. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateFromFileSystemRepresentation (
   CFAllocatorRef allocator,
   const UInt8 *buffer,
   CFIndex bufLen,
   Boolean isDirectory
);

/*CFURLGetFileSystemRepresentation

Fills a buffer with the file system's native string representation of a given URL's path.

Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen
);
Parameters
url

The CFURL object whose native file system representation you want to obtain. 
resolveAgainstBase

Pass true to return an absolute path name. 
buffer

A pointer to a character buffer. On return, the buffer holds the native file system's representation of url. The buffer is null-terminated. This parameter must be at least maxBufLen in size for the file system in question to avoid failures for insufficiently large buffers.
maxBufLen

The maximum number of characters that can be written to buffer.
Return Value

true if successful, false if an error occurred. 
Discussion

No more than maxBufLen bytes are written to buffer. If url requires more than maxBufLen bytes to represent itself, including the terminating null byte, this function returns false. To avoid this possible failure, you should pass a buffer with size of at least the maximum path length for the file system in question.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLGetFileSystemRepresentation (
   CFURLRef url,
   Boolean resolveAgainstBase,
   UInt8 *buffer,
   CFIndex maxBufLen
);

/*CFURLCreateWithString

Creates a CFURL object using a given CFString object.

CFURLRef CFURLCreateWithString (
   CFAllocatorRef allocator,
   CFStringRef URLString,
   CFURLRef baseURL
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
URLString

The CFString object containing the URL string. 
baseURL

The URL to which URLString is relative. Pass NULL if URLString contains an absolute URL or if you want to create a relative URL. If URLString contains an absolute URL, baseURL is ignored. 
Return Value

A new CFURL object. Ownership follows the Create Rule.
Discussion

Any escape sequences in URLString will be interpreted using UTF-8. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateWithString (
   CFAllocatorRef allocator,
   CFStringRef URLString,
   CFURLRef baseURL
);

/*CFURLGetTypeID

Returns the type identifier for the CFURL opaque type.

CFTypeID CFURLGetTypeID ();
Return Value

The type identifier for the CFURL opaque type.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFTypeID CFURLGetTypeID ();

/*CFURLGetString

Returns the URL as a CFString object.

CFStringRef CFURLGetString (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to convert into a CFString object. 
Return Value

A string representation of anURL. Ownership follows the Get Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLGetString (
   CFURLRef anURL
);

/*CFURLCreateWithFileSystemPath

Creates a CFURL object using a local file system path string.

CFURLRef CFURLCreateWithFileSystemPath (
   CFAllocatorRef allocator,
   CFStringRef filePath,
   CFURLPathStyle pathStyle,
   Boolean isDirectory
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
filePath

The path string to convert to a CFURL object. 
pathStyle

The operating system path style used in filePath. See Path Style for a list of possible values. 
isDirectory

A Boolean value that specifies whether filePath is treated as a directory path when resolving against relative path components. Pass true if the pathname indicates a directory, false otherwise.
Return Value

A new CFURL object. Ownership follows the Create Rule.
Discussion

If filePath is not absolute, the resulting URL will be considered relative to the current working directory (evaluated when this function is being invoked). 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateWithFileSystemPath (
   CFAllocatorRef allocator,
   CFStringRef filePath,
   CFURLPathStyle pathStyle,
   Boolean isDirectory
);

/*CFURLHasDirectoryPath

Determines if a given URL's path represents a directory.

Boolean CFURLHasDirectoryPath (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

true if anURL represents a directory, false otherwise. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
Boolean CFURLHasDirectoryPath (
   CFURLRef anURL
);

/*CFURLCopyLastPathComponent

Returns the last path component of a given URL.

CFStringRef CFURLCopyLastPathComponent (
   CFURLRef url
);
Parameters
url

The CFURL object to examine. 
Return Value

The last path component of url. Ownership follows the Create Rule. 
Discussion

Note that if there is no last path component, this function returns an empty string. In the code sample shown in Listing 1, lastPathComponent is an empty string. 

Listing 1  Code sample illustrating CFURLCopyLastPathComponentCFStringRef urlString = CFSTR("http://www.apple.com");
CFURLRef url = CFURLCreateWithString(NULL, urlString, NULL);
CFStringRef lastPathComponent = CFURLCopyLastPathComponent (url);


If urlString were created with CFSTR("http://www.apple.com/"), then lastPathComponent would be a CFString object containing the character “/“.

See also CFURLCopyPathExtension.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyLastPathComponent (
   CFURLRef url
);

/*CFURLCreateStringByReplacingPercentEscapes

Creates a new string by replacing any percent escape sequences with their character equivalent.

CFStringRef CFURLCreateStringByReplacingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveEscaped
);
Parameters
allocator

The allocator to use to allocate memory for the new CFString object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
originalString

The CFString object to be copied and modified.
charactersToLeaveEscaped

Characters whose percent escape sequences, such as %20 for a space character, you want to leave intact. Pass NULL to specify that no percent escapes be replaced, or the empty string (CFSTR("")) to specify that all be replaced.
Return Value

A new CFString object, or NULL if the percent escapes cannot be converted to characters, assuming UTF-8 encoding. If no characters need to be replaced, this function returns the original string with its reference count incremented. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCreateStringByReplacingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveEscaped
);

/*CFURLCreateStringByAddingPercentEscapes

Creates a copy of a string, replacing certain characters with the equivalent percent escape sequence based on the specified encoding.

CFStringRef CFURLCreateStringByAddingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveUnescaped,
   CFStringRef legalURLCharactersToBeEscaped,
   CFStringEncoding encoding
);
Parameters
allocator

The allocator to use to allocate memory for the new CFString object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
originalString

The CFString object to copy. 
charactersToLeaveUnescaped

Characters whose percent escape sequencesyou want to leave intact. Pass NULL to specify that all escape sequences be replaced.
legalURLCharactersToBeEscaped

Legal characters to be escaped. Pass NULL to specify that all legal characters be replaced.
encoding

The encoding to use for the translation. If you are uncertain of the correct encoding, you should use UTF-8, which is the encoding designated by RFC 2396 as the correct encoding for use in URLs. 
Return Value

A copy of originalString replacing certain characters. If it does not need to be modified (no percent escape sequences are missing), this function may merely return originalString with its reference count incremented. Ownership follows the Create Rule.
Discussion

The characters escaped are all characters that are not legal URL characters (based on RFC 2396), plus any characters in legalURLCharactersToBeEscaped, less any characters in charactersToLeaveUnescaped. To simply correct any non-URL characters in an otherwise correct URL string, pass NULL for the allocator, charactersToLeaveEscaped, and legalURLCharactersToBeEscaped parameters, and kCFStringEncodingUTF8 as the encoding parameter.

It may be difficult to use this function to "clean up" unescaped or partially escaped URL strings where sequences are unpredictable and you cannot specify charactersToLeaveUnescaped. Instead, you can "pre-process" an URL string using CFURLCreateStringByReplacingPercentEscapesUsingEncoding then add the escape characters using CFURLCreateStringByAddingPercentEscapes, as shown in the following code fragment. CFStringRef originalURLString = CFSTR("http://online.store.com/storefront/?request=get-document&doi=10.1175%2F1520-0426(2005)014%3C1157:DODADSS%3E2.0.CO%3B2");
CFStringRef preprocessedString =
    CFURLCreateStringByReplacingPercentEscapesUsingEncoding(kCFAllocatorDefault, originalURLString, CFSTR(""), kCFStringEncodingUTF8);
CFStringRef urlString =
    CFURLCreateStringByAddingPercentEscapes(kCFAllocatorDefault, preprocessedString, NULL, NULL, kCFStringEncodingUTF8);
url = CFURLCreateWithString(kCFAllocatorDefault, urlString, NULL);

Availability
Available in CarbonLib v1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCreateStringByAddingPercentEscapes (
   CFAllocatorRef allocator,
   CFStringRef originalString,
   CFStringRef charactersToLeaveUnescaped,
   CFStringRef legalURLCharactersToBeEscaped,
   CFStringEncoding encoding
);

/*CFURLCreateWithBytes

Creates a CFURL object using a given character bytes.

CFURLRef CFURLCreateWithBytes (
   CFAllocatorRef allocator,
   const UInt8 *URLBytes,
   CFIndex length,
   CFStringEncoding encoding,
   CFURLRef baseURL
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
URLBytes

The character bytes to convert into a CFURL object. 
length

The number of bytes in URLBytes. 
encoding

The string encoding of the URLBytes string. This encoding is also used to interpret percent escape sequences. 
baseURL

The URL to which URLBytes is relative. Pass NULL if URLBytes contains an absolute URL or if you want to create a relative URL. If URLBytes contains an absolute URL, this parameter is ignored.
Return Value

A new CFURL object. Ownership follows the Create Rule.
Discussion

The specified string encoding will be used both to interpret URLBytes, and to interpret any percent-escapes within the string. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

CFURLRef CFURLCreateWithBytes (
   CFAllocatorRef allocator,
   const UInt8 *URLBytes,
   CFIndex length,
   CFStringEncoding encoding,
   CFURLRef baseURL
);

/*CFURLGetByteRangeForComponent

Returns the range of the specified component in the bytes of a URL.

CFRange CFURLGetByteRangeForComponent (
   CFURLRef anURL
   CFURLComponentType component,
   CFRange *rangeIncludingSeparators
);
Parameters
anURL

The URL containing component.
component

The type of component in anURL whose range you want to obtain. See Component Type for possible values.
rangeIncludingSeparators

Specifies the range of component including the sequences that separate component from the previous and next components. If there is no previous or next components, this function will match the range of the component itself. If anURL does not contain component, rangeIncludingSeparators is set to the location where the component would be inserted.
Return Value

The range of bytes for component in the buffer returned by the CFURLGetBytes function. If anURL does not contain component, the first part of the returned range is set to kCFNotFound.
Discussion

This function is intended to be used in conjunction with the CFURLGetBytes function, since the range returned is only applicable to the bytes returned by CFURLGetBytes.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
CFURL.h*/

CFRange CFURLGetByteRangeForComponent (
   CFURLRef anURL,
   CFURLComponentType component,
   CFRange *rangeIncludingSeparators
);

/*CFURLGetBytes

Returns by reference the byte representation of a URL object.

CFIndex CFURLGetBytes (
   CFURLRef anURL
   const UInt8 *buffer,
   CFIndex bufferLength,
);
Parameters
anURL

The URL object to convert to a byte representation.
buffer

The buffer where you want the bytes to be placed. If NULL the needed length is computed and returned. The returned bytes are the original bytes from which the URL was created. If the URL was created from a string, the bytes will be the bytes of the string encoded via UTF-8.
bufferLength

The number of bytes in buffer.
Return Value

Returns the number of bytes in buffer that were filled.
Availability
Available in Mac OS X v10.3 and later. 
Declared In
CFURL.h*/
CFIndex CFURLGetBytes (
   CFURLRef anURL,
   const UInt8 *buffer,
   CFIndex bufferLength
);

/*CFURLCopyFileSystemPath

Returns the path portion of a given URL.

CFStringRef CFURLCopyFileSystemPath (
   CFURLRef anURL,
   CFURLPathStyle pathStyle
);
Parameters
anURL

The CFURL object whose path you want to obtain. 
pathStyle

The operating system path style to be used to create the path. See Path Style for a list of possible values. 
Return Value

The URL's path in the format specified by pathStyle. Ownership follows the Create Rule.
Discussion

This function returns the URL's path as a file system path for a given path style. 
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

CFStringRef CFURLCopyFileSystemPath (
   CFURLRef anURL,
   CFURLPathStyle pathStyle
);

/*CFURLCopyAbsoluteURL

Creates a new CFURL object by resolving the relative portion of a URL against its base.

CFURLRef CFURLCopyAbsoluteURL (
   CFURLRef relativeURL
);
Parameters
relativeURL

The CFURL object to resolve. 
Return Value

A new CFURL object, or NULL if relativeURL cannot be made absolute. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCopyAbsoluteURL (
   CFURLRef relativeURL
);

/*CFURLCopyScheme

Returns the scheme portion of a given URL.

CFStringRef CFURLCopyScheme (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The scheme of anURL. Ownership follows the Create Rule.
Discussion

The URL scheme is the portion of the URL specifying the transport type. For example http, ftp, and rtsp are schemes. This function leaves any percent escape sequences intact. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyScheme (
   CFURLRef anURL
);

/*CFURLGetPortNumber

Returns the port number from a given URL.

SInt32 CFURLGetPortNumber (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The port number of anURL, or -1 if no port number exists. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/

SInt32 CFURLGetPortNumber (
   CFURLRef anURL
);

/*CFURLCopyHostName

Returns the host name of a given URL.

CFStringRef CFURLCopyHostName (
   CFURLRef anURL
);
Parameters
anURL

The CFURL object to examine. 
Return Value

The host name of anURL. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFStringRef CFURLCopyHostName (
   CFURLRef anURL
);

/*CFURLCreateCopyDeletingLastPathComponent

Creates a copy of a given URL with the last path component deleted.

CFURLRef CFURLCreateCopyDeletingLastPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url
);
Parameters
allocator

The allocator to use to allocate memory for the new CFURL object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
url

The CFURL object whose last path component you want to delete. 
Return Value

A copy of url with the last path component deleted. Ownership follows the Create Rule.
Availability
Available in CarbonLib v1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
CFURL.h*/
CFURLRef CFURLCreateCopyDeletingLastPathComponent (
   CFAllocatorRef allocator,
   CFURLRef url
);

#ifdef __cplusplus
}
#endif
#endif