#ifndef MACHELP_H
#define MACHELP_H

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef DIALOGS_H
#include <HIToolbox/Dialogs.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif


//#include <HYS/HIToolbox/MacHelp.h>
#include <APPLE/HIToolbox/MacHelp.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Constants
enum {
   #define gestaltHelpMgrAttr  'help'  /Gestalt selector/
   gestaltHelpMgrPresent      =  0     /if this bit is set, then /
                                       / Help Manager is present/
};
enum {
   hmBalloonHelpVersion    = 0x0002,   /Help Manager version/
   kBalloonWDEFID          = 126,      /resource ID of standard balloon /
                                       / 'WDEF' function/
   kHMHelpID               = -5696,    /ID of various Help Manager /
                                       / resources (in Pack14 range); /
                                       / also used for 'hfdr' resource ID/ 
   /Help menu constants/
   kHMAboutHelpItem        = 1,        /About Balloon Help menu item/
   kHMHelpMenuID           = -16490,   /Help menu resource ID/
   kHMShowBalloonsItem     = 3,        /Show/Hide Balloons menu item/
   
   /help item type for 'DITL' resources/
   HelpItem                = 1,        /help item/
         
   /option bits for help resources/
   hmDefaultOptions        = 0,        /use defaults/
   hmUseSubID              = 1,        /use subrange resource IDs /
                                       / for owned resources/
   hmAbsoluteCoords        = 2         /ignore coords of window /
                                       / origin and treat upper-left /
                                       / corner of window as 0,0/
};
enum {
   hmSaveBitsNoWindow      = 4,        /don't create window; save /
                                       / bits; no update event/
   hmSaveBitsWindow        = 8,        /save bits behind window and /
                                       / generate update event/
   hmMatchInTitle          = 16,       /match window by string /
                                       / anywhere in title string/
         
   /constants for hmmHelpType field of HMMessageRecord/
   khmmString              = 1,        /Pascal string/
   khmmPict                = 2,        /'PICT' resource ID/
   khmmStringRes           = 3,        /'STR#' res ID and index/
   khmmTEHandle            = 4,        /TextEdit handle/
   khmmPictHandle          = 5,        /picture handle/
   khmmTERes               = 6,        /'TEXT' and 'styl' resource ID/
   khmmSTRRes              = 7,        /'STR ' resource ID/
   /resource types for styled text in resources/
   #define kHMTETextResType    'TEXT'  /'TEXT' resource type/
   #define kHMTEStyleResType   'styl'  /'styl' resource type/
   /constants for whichState parameter when extracting help /
   / message records from 'hmnu' and 'hdlg' resources/
   kHMEnabledItem          = 0,        /enabled state for menu items; /
                                       / contrlHilite value of 0 for /
                                       / controls/
};
enum {
   kHMDisabledItem         = 1,        /disabled state for menu items; /
                                       / contrlHilite value of 255 for /
                                       / controls/
   kHMCheckedItem          = 2,        /enabled-and-checked state for /
                                       / menu items; contrlHilite /
                                       / value of 1 for controls that /
                                       / are "on"/
   kHMOtherItem            = 3,        /enabled-and-marked state for /
                                       / menu items; contrlHilite /
                                       / value between 2 and 253 for /
                                       / controls/
   
   /resource types for whichType parameter used when extracting /
   / help message/
   #define kHMMenuResType        'hmnu'   /menu help resource type/
   #define kHMDialogResType      'hdlg'   /dialog help resource type/
   #define kHMWindListResType    'hwin'   /window help resource type/
   #define kHMRectListResType    'hrct'   /rectangle help resource type/
   #define kHMOverrideResType    'hovr'   /help override resource type/
   #define kHMFinderApplResType  'hfdr'   /app icon help resource type/
   
   /constants for method parameter in HMShowBalloon/
   kHMRegularWindow        = 0,        /don't save bits; just update/
   kHMSaveBitsNoWindow     = 1,        /save bits; don't do update/
   kHMSaveBitsWindow       = 2         /save bits; do update event/
}; 
enum {
   /constants for help types in 'hmnu', 'hdlg', 'hrct', 'hovr', and /
   / 'hfdr' resources--useful only for walking these resources/
   kHMStringItem           = 1,        /Pascal string/
   kHMPictItem             = 2,        /'PICT' resource ID/
   kHMStringResItem        = 3,        /'STR#' resource ID & index/
   kHMTEResItem            = 6,        /'TEXT' & 'styl' resource ID/
   kHMSTRResItem           = 7,        /'STR ' resource ID/
   kHMSkipItem             = 256,      /don't display a balloon/
   kHMCompareItem          = 512,      /for 'hmnu', use help message /
                                       / if menu item matches string/
   kHMNamedResourceItem    = 1024,     /for 'hmnu', use menu item to /
                                       / get a named resource/
   kHMTrackCntlItem        = 2048      /reserved/
};*/
enum {
   kHMHelpMenuID           = -16490,
};

/*Help Tag Content Types

Identify the type of content contained in a help tag.

typedef UInt32 HMContentType;
enum {
   kHMNoContent = 'none',
   kHMCFStringContent = 'cfst',
   kHMCFStringLocalizedContent = ‘cfsl’,
   kHMPascalStrContent = 'pstr',
   kHMStringResContent = 'str#',
   kHMTEHandleContent = 'txth',
   kHMTextResContent = 'text',
   kHMStrResContent = 'str '
};
Constants
kHMNoContent

The help tag contains no content.

Available in Mac OS X v10.0 and later.
kHMCFStringContent

The help tag content is a CFString object.

Available in Mac OS X v10.0 and later.
kHMCFStringLocalizedContent

The help tag content is a localized string contained in the Localizeable.strings file. The content field of the help tag structure contains a CFString key which the Carbon Help Manager uses to retrieve the help tag string from the Localizable.strings file in the appropriate language folder.

Available in Mac OS X v10.2 and later.
kHMPascalStrContent

The help tag content is a Pascal string.

Available in Mac OS X v10.0 and later.
kHMStringResContent

The help tag content is a text string, stored in the list of strings in a resource of type 'STR#'.

Available in Mac OS X v10.0 and later.
kHMTEHandleContent

The help tag content is contained in a TextEdit record, referred to by a TextEdit handle. This type of help tag content is only supported in CarbonLib and in Mac OS X version 10.2 and later.

Available in Mac OS X v10.0 and later.
kHMTextResContent

The help tag content is styled text, described by the combination of a text resource ('TEXT') and a style resource ('styl'). This type of help tag content is only supported in CarbonLib and in Mac OS X version 10.2 and later.

Available in Mac OS X v10.0 and later.
kHMStrResContent

The help tag content is a text string stored in a resource of type 'STR '.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the contentType field of the HMHelpContent structure to identify the format of the help content contained in that structure.*/

typedef UInt32 HMContentType;
enum {
   kHMNoContent = 'none',
   kHMCFStringContent = 'cfst',
   kHMCFStringLocalizedContent = 'cfsl',
   kHMPascalStrContent = 'pstr',
   kHMStringResContent = 'str#',
   kHMTEHandleContent = 'txth',
   kHMTextResContent = 'text',
   kHMStrResContent = 'str '
};


/*Help Tag Display Locations

Specify which side of the hot rectangle to display the help tag.

typedef SInt16 HMTagDisplaySide;
enum {
   kHMDefaultSide = 0,
   kHMOutsideTopScriptAligned = 1,
   kHMOutsideLeftCenterAligned = 2,
   kHMOutsideBottomScriptAligned = 3,
   kHMOutsideRightCenterAligned = 4,
   kHMOutsideTopLeftAligned = 5,
   kHMOutsideTopRightAligned = 6,
   kHMOutsideLeftTopAligned = 7,
   kHMOutsideLeftBottomAligned = 8,
   kHMOutsideBottomLeftAligned = 9,
   kHMOutsideBottomRightAligned = 10,
   kHMOutsideRightTopAligned = 11,
   kHMOutsideRightBottomAligned = 12,
   kHMOutsideTopCenterAligned = 13,
   kHMOutsideBottomCenterAligned = 14,
   kHMInsideRightCenterAligned = 15,
   kHMInsideLeftCenterAligned = 16,
   kHMInsideBottomCenterAligned = 17,
   kHMInsideTopCenterAligned = 18,
   kHMInsideTopLeftCorner = 19,
   kHMInsideTopRightCorner = 20,
   kHMInsideBottomLeftCorner = 21,
   kHMInsideBottomRightCorner = 22,
   kHMAbsoluteCenterAligned = 23
};
Constants
kHMDefaultSide

Display the help tag at the default system location. The system default is below the hot rectangle, horizontally centered.

Available in Mac OS X v10.0 and later.
kHMOutsideTopScriptAligned

Display the help tag above the hot rectangle, aligned with the right or left side, depending upon the direction of the system script.

Available in Mac OS X v10.0 and later.
kHMOutsideLeftCenterAligned

Display the help tag to the left of the hot rectangle, centered vertically.

Available in Mac OS X v10.0 and later.
kHMOutsideBottomScriptAligned

Display the help tag below the hot rectangle, aligned with the right or left side, depending upon the direction of the system script.

Available in Mac OS X v10.0 and later.
kHMOutsideRightCenterAligned

Display the help tag to the right of the hot rectangle, centered vertically.

Available in Mac OS X v10.0 and later.
kHMOutsideTopLeftAligned

Display the help tag above the hot rectangle, with their left edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideTopRightAligned

Display the help tag above the hot rectangle, with their right edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideLeftTopAligned

Display the help tag to the left of the hot rectangle, with their top edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideLeftBottomAligned

Display the help tag to the left of the hot rectangle, with their bottom edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideBottomLeftAligned

Display the help tag below the hot rectangle, with their left edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideBottomRightAligned

Display the help tag below the hot rectangle, with their right edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideRightTopAligned

Display the help tag to the right of the hot rectangle, with their top edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideRightBottomAligned

Display the help tag to the right of the hot rectangle, with their bottom edges aligned.

Available in Mac OS X v10.0 and later.
kHMOutsideTopCenterAligned

Display the help tag above the hot rectangle, centered horizontally.

Available in Mac OS X v10.0 and later.
kHMOutsideBottomCenterAligned

Display the help tag below the hot rectangle, centered horizontally.

Available in Mac OS X v10.0 and later.
kHMInsideRightCenterAligned

Display the help tag inside the hot rectangle, with their right edges aligned and centered vertically.

Available in Mac OS X v10.0 and later.
kHMInsideLeftCenterAligned

Display the help tag inside the hot rectangle, with their left edges aligned and centered vertically.

Available in Mac OS X v10.0 and later.
kHMInsideBottomCenterAligned

Display the help tag inside the hot rectangle, with their bottom edges aligned and centered horizontally.

Available in Mac OS X v10.0 and later.
kHMInsideTopCenterAligned

Display the help tag inside the hot rectangle, with their top edges aligned and centered horizontally.

Available in Mac OS X v10.0 and later.
kHMInsideTopLeftCorner

Display the help tag inside the hot rectangle, with their top and left edges aligned.

Available in Mac OS X v10.0 and later.
kHMInsideTopRightCorner

Display the help tag inside the hot rectangle, with their top and right edges aligned.

Available in Mac OS X v10.0 and later.
kHMInsideBottomLeftCorner

Display the help tag inside the hot rectangle, with their bottom and left edges aligned.

Available in Mac OS X v10.0 and later.
kHMInsideBottomRightCorner

Display the help tag inside the hot rectangle, with their bottom and right edges aligned.

Available in Mac OS X v10.0 and later.
kHMAbsoluteCenterAligned

Display the help tag centered vertically and horizontally within the hot rectangle.

Available in Mac OS X v10.0 and later.
Discussion

The locations described by these constants are relative to the help tag’s hot rectangle, which defines, in global coordinates, the area on the screen with which the help tag is associated. These constants are used in the tagSide field of the HMHelpContentRec structure.*/
typedef SInt16 HMTagDisplaySide;
enum {
   kHMDefaultSide = 0,
   kHMOutsideTopScriptAligned = 1,
   kHMOutsideLeftCenterAligned = 2,
   kHMOutsideBottomScriptAligned = 3,
   kHMOutsideRightCenterAligned = 4,
   kHMOutsideTopLeftAligned = 5,
   kHMOutsideTopRightAligned = 6,
   kHMOutsideLeftTopAligned = 7,
   kHMOutsideLeftBottomAligned = 8,
   kHMOutsideBottomLeftAligned = 9,
   kHMOutsideBottomRightAligned = 10,
   kHMOutsideRightTopAligned = 11,
   kHMOutsideRightBottomAligned = 12,
   kHMOutsideTopCenterAligned = 13,
   kHMOutsideBottomCenterAligned = 14,
   kHMInsideRightCenterAligned = 15,
   kHMInsideLeftCenterAligned = 16,
   kHMInsideBottomCenterAligned = 17,
   kHMInsideTopCenterAligned = 18,
   kHMInsideTopLeftCorner = 19,
   kHMInsideTopRightCorner = 20,
   kHMInsideBottomLeftCorner = 21,
   kHMInsideBottomRightCorner = 22,
   kHMAbsoluteCenterAligned = 23
};

/*HMHelpContent

Contains a help tag message.

struct HMHelpContent {
   HMContentType contentType;
   union {
      CFStringRef tagCFString;
      Str255 tagString;
      HMStringResType tagStringRes;
      TEHandle tagTEHandle;
      SInt16 tagTextRes;
      SInt16 tagStrRes;
   } u;
};
Fields
contentType

A value that indicates the format of the help content contained in the structure. The help tag content formats that are allowed are described by the constants “Help Tag Content Types”.
tagCFString

If the value of the contentType field is kHMCFStringContent, a CFString specifying the help tag message. If the value of the contentType field is kHMCFStringLocalizedContent, a CFString containing the name of the localized help tag message in the Localizable.strings file. 
tagString

If the value of the contentType field is kHMPascalStrContent, a Pascal string specifying the help tag message.
tagStringRes

If the value of the contentType field is kHMStringResContent, a ‘STR#’ resource ID and an index number specifying the help tag message.
tagTEHandle

If the value of the contentType field is kHMTEHandleContent, a TextEdit handle specifying the help tag message. This type of help tag content is only supported in CarbonLib and in Mac OS X version 10.2 and later.
tagTextRes

If the value of the contentType field is kHMTextResContent, the resource ID of a ‘TEXT’ resource and a ‘styl’ resource describing the help tag message. This type of help tag content is only supported in CarbonLib and in Mac OS X version 10.2 and later.
tagStrRes

If the value of the contentType field is kHMStrResContent, a ‘STR ‘ resource ID, specifying the help tag message.
Discussion

The HMHelpContent structure is used in the content field of the HMHelpContentRec structure to hold the help content associated with a help tag. The HMHelpContent structure describes a single help message.*/
struct HMHelpContent {
   HMContentType contentType;
   union {
      CFStringRef tagCFString;
      Str255 tagString;
      HMStringResType tagStringRes;
      TEHandle tagTEHandle;
      SInt16 tagTextRes;
      SInt16 tagStrRes;
   } u;
};
typedef struct HMHelpContent HMHelpContent;

/*HMHelpContentRec

Describes a help tag.

struct HMHelpContentRec {
   SInt32 version;
   Rect absHotRect;
   HMTagDisplaySide tagSide;
   HMHelpContent content[2];
};
typedef struct HMHelpContentRec HMHelpContentRec;
Fields
version

The structure version. 
absHotRect

The hot rectangle for the help tag, expressed in global coordinates. The hot rectangle defines the area on the screen over which the user must hover the mouse to trigger the Carbon Help Manager to display the help tag. 

You may pass an empty rectangle—a rectangle with coordinates (0,0,0,0)—in this field. The Carbon Help Manager automatically substitutes the current location of the control, window, or menu item for the empty rectangle when the help tag is displayed.
tagSide

A value that specifies which side of the hot rectangle the help tag is displayed. For a description of the constants used here, see “Help Tag Display Locations”.
content

An array of two help tag content structures describing the help message for the tag. The first structure describes the content displayed by default in the help tag (the minimum content). The second structure describes additional content that is displayed in the help tag if the user holds down the Command key while the help tag is displayed (the maximum, or expanded, content).
Special Considerations

On Mac OS X version 10.1.x and earlier, you cannot supply an empty hot rectangle from a help tag callback. You can, however, supply an empty hot rectangle to the HMSetControlHelpContent, HMSetWindowHelpContent, and HMSetMenuItemHelpContent functions.

When you supply an empty hot rectangle for a control help tag, the Carbon Help Manager uses the function LocalToGlobal to convert the control’s bounds from window-local coordinates into global coordinates. LocalToGlobal only returns true global coordinates if the port origin is (0,0). If your application sets the port origin to a non-zero value, it should do so only temporarily; your application should never leave the port origin set to a non-zero value across calls to the event system that may attempt to display a help tag. Setting the port origin to a non-zero value typically prevents help tags from being displayed.
Availability
Available in Mac OS X v10.0 and later.*/

struct HMHelpContentRec {
   SInt32 version;
   Rect absHotRect;
   HMTagDisplaySide tagSide;
   HMHelpContent content[2];
};
typedef struct HMHelpContentRec HMHelpContentRec;



/*Content Request Types

Identify the type of request made to a help tag callback.

typedef SInt16 HMContentRequest;
enum {
   kHMSupplyContent =                 0,
   kHMDisposeContent =                 1
};
Constants
kHMSupplyContent

The help tag callback should supply help content.

Available in Mac OS X v10.0 and later.
kHMDisposeContent

The help tag callback should dispose of help content.

Available in Mac OS X v10.0 and later.
Discussion

These constants are passed to your help tag callback in the inRequest parameter to indicate the nature of the help tag content request. In particular, the Carbon Help Manager passes kHMSupplyContent when the user pauses with the mouse above a user interface object for which a help tag callback is registered. When the user moves the mouse away from the object, the Carbon Help Manager passes kHMDisposeContent to your callback.*/

typedef SInt16 HMContentRequest;
enum {
   kHMSupplyContent =                 0,
   kHMDisposeContent =                 1
};

/*Content Provided Types

Indicate whether or not help tag content has been supplied.

typedef SInt16 HMContentProvidedType;
enum {
   kHMContentProvided = 0,
   kHMContentNotProvided = 1,
   kHMContentNotProvidedDontPropagate = 2
};
Constants
kHMContentProvided

Help tag content has been provided.

Available in Mac OS X v10.0 and later.
kHMContentNotProvided

Help tag content was not provided. When your callback returns this constant, the Carbon Help Manager calls up to the next help tag callback in the hierarchy. If that callback also fails to provide help content, the Carbon Help Manager continues to propagate the request for help tag content until the request is fulfilled, the top of the hierarchy is reached, or a help tag callback tells the Carbon Help Manager to stop propagating the request.

Available in Mac OS X v10.0 and later.
kHMContentNotProvidedDontPropagate

Help tag content was not provided. When your callback returns this constant, the Carbon Help Manager assumes that there is no help content for the control, window, menu title, or menu item and does not propagate the request.

Available in Mac OS X v10.0 and later.
Discussion

Your help tag callback function should return one of these constants in its outContentProvided parameter.*/
typedef SInt16 HMContentProvidedType;
enum {
   kHMContentProvided = 0,
   kHMContentNotProvided = 1,
   kHMContentNotProvidedDontPropagate = 2
};


/*HMHelpContentPtr

A pointer to a help tag structure.

typedef HMHelpContentRec* HMHelpContentPtr;
Discussion

See HMHelpContentRec for more information.
Availability
Available in Mac OS X v10.0 and later.*/
typedef HMHelpContentRec* HMHelpContentPtr;

/*HMGetHelpMenu

Returns a reference to the Help menu.

extern OSStatus HMGetHelpMenu (
MenuRef *outHelpMenu,
MenuItemIndex         *outFirstCustomItemIndex
);
Parameters
outHelpMenu

On return, a pointer to a menu reference to the Help menu.
outFirstCustomItemIndex

On return, a pointer to the menu item index that will be used by the first application-supplied item added to the menu. This parameter may be NULL.
Return Value

A result code. See “Result Codes”.
Discussion

The HMGetHelpMenu function returns a reference to the Help menu, to which you can add your own custom menu items. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.*/
extern OSStatus HMGetHelpMenu (
MenuRef *outHelpMenu,
MenuItemIndex         *outFirstCustomItemIndex
);


#ifdef __cplusplus
}
#endif

#endif