#ifndef MENUS_H
#define MENUS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef PROCESSES_H
#include <HIServices/Processes.h>
#endif

#ifndef CARBONEVENTSCORE_H
#include <HIToolbox/CarbonEventsCore.h>
#endif

#ifndef HIOBJECT_H
#include <HIToolbox/HIObject.h>
#endif


#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef ATSTYPES_H
#include <ATS/ATSTypes.h>//hys
#endif


//#include <HYS/HIToolbox/Menus.h>
#include <APPLE/HIToolbox/Menus.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Contextual Menu Selection Type Constants

Indicates the type of item the user selected from a contextual menu.

enum {
   kCMNothingSelected = 0,
   kCMMenuItemSelected = 1,
   kCMShowHelpSelected = 3
};
Constants
kCMNothingSelected

The user did not choose an item from the contextual menu and the application should do no further processing of the event.

Available in Mac OS X v10.0 and later.
kCMMenuItemSelected

The user chose one of the application’s items from the menu. The application can examine the outMenuID and outMenuItem parameters of ContextualMenuSelect to see what the menu selection was, and it should then handle the selection appropriately.

Available in Mac OS X v10.0 and later.
kCMShowHelpSelected

The user chose the Help item from the menu. The application should open an Apple Help database to a section appropriate for the selection. If the application supports some other form of help, it should be presented instead.

Available in Mac OS X v10.0 and later.
Discussion

These constants are returned in the outUserSelectionType parameter of the function ContextualMenuSelect to specify what the user selected from the contextual menu. Contextual menu selection type constants are available with Appearance Manager 1.0 and later.*/
enum {
   kCMNothingSelected = 0,
   kCMMenuItemSelected = 1,
   kCMShowHelpSelected = 3
};

/*Contextual Menu Help Type Constants

Indicates what types of contextual menu help is available. 

enum {
   kCMHelpItemNoHelp = 0,
   kCMHelpItemAppleGuide = 1,
   kCMHelpItemOtherHelp = 2,
   kCMHelpItemRemoveHelp = 3
};
Constants
kCMHelpItemNoHelp

The application does not support any help. The Menu Manager will put an appropriate help string into the menu and disable it. 

Available in Mac OS X v10.0 and later.
kCMHelpItemAppleGuide

The application supports Apple Guide help. The Menu Manager will put the name of the main Guide file into the menu and enable it.

Available in Mac OS X v10.0 and later.
kCMHelpItemOtherHelp

The application supports some other form of help. In this case, the application must also pass a valid string into the inHelpItemString parameter of ContextualMenuSelect. This string will be the text of the help item in the menu, and the help item will be enabled.

Available in Mac OS X v10.0 and later.
kCMHelpItemRemoveHelp

The application does not support any help. The Menu Manager will remove the Help item from the contextual menu. 

Available in CarbonLib 1.6 and Mac OS X and later. Note however, that in CarbonLib, this constant is equivalent to kCMItemNoHelp, which only disables the Help item.

Available in Mac OS X v10.2 and later.
Discussion

You can pass these constants in the inHelpType parameter of the function ContextualMenuSelect to specify the kind of help the application supports. Contextual menu help type constants are available with Appearance Manager 1.0 and later.*/
enum {
   kCMHelpItemNoHelp = 0,
   kCMHelpItemAppleGuide = 1,
   kCMHelpItemOtherHelp = 2,
   kCMHelpItemRemoveHelp = 3
};

/*Redefined API Names

Some names defined in the Macintosh application programming interfaces conflict with identical names in the Windows API. In these cases, the QTML header file QTMLMapNames.h avoids these conflicts by redefining the affected names with the prefix Mac added.

In Table 2-2, names listed in the first column refer to the original Macintosh function or data structure name; the second column gives the redefined or newly mapped names.
Table 3-1  Redefined API names
Original Macintosh API name	
Mapped name

AnimatePalette	
MacAnimatePalette

AppendMenu	
MacAppendMenu

CloseDriver	
MacCloseDriver

CloseWindow	
MacCloseWindow

CompareString	
MacCompareString

CopyRgn	
MacCopyRgn

DeleteMenu	
MacDeleteMenu

DrawMenuBar	
MacDrawMenuBar

DrawText	
MacDrawText

EqualRect	
MacEqualRect

EqualRgn	
MacEqualRgn

FillRect	
MacFillRect

FillRgn	
MacFillRgn

FindWindow	
MacFindWindow

FlushInstructionCache	
MacFlushInstructionCache

FrameRect	
MacFrameRect

FrameRgn	
MacFrameRgn

GetClassInfo	
MacGetClassInfo

GetCurrentThread	
MacGetCurrentThread

GetCursor	
MacGetCursor

GetDoubleClickTime	
MacGetDoubleClickTime

GetFileSize	
MacGetFileSize

GetItem	
MacGetItem

GetMenu	
MacGetMenu

GetNextWindow	
MacGetNextWindow

GetParent	
MacGetParent

GetPath	
MacGetPath

GetPixel	
MacGetPixel

InsertMenu	
MacInsertMenu

InsertMenuItem	
MacInsertMenuItem

InsetRect	
MacInsetRect

InvertRect	
MacInvertRect

InvertRgn	
MacInvertRgn

IsWindowVisible	
MacIsWindowVisible

LineTo	
MacLineTo

LoadResource	
MacLoadResource

MoveWindow	
MacMoveWindow

OffsetRect	
MacOffsetRect

OffsetRgn	
MacOffsetRgn

OpenDriver	
MacOpenDriver

PaintRgn	
MacPaintRgn

Polygon	
MacPolygon

PtInRect	
MacPtInRect

Region	
MacRegion

ReplaceText	
MacReplaceText

ResizePalette	
MacResizePalette

SendMessage	
MacSendMessage

SetCursor	
MacSetCursor

SetItem	
MacSetItem

SetPort	
MacSetPort

SetRect	
MacSetRect

SetRectRgn	
MacSetRectRgn

ShowCursor	
MacShowCursor

ShowWindow	
MacShowWindow

StartSound	
MacStartSound

StopSound	
MacStopSound

TokenType	
MacTokenType

UnionRect	
MacUnionRect

UnionRgn	
MacUnionRgn

XorRgn	
MacXorRgn*/
#define MacAppendMenu AppendMenu
#define MacInsertMenu InsertMenu
#define MacDeleteMenu DeleteMenu
#define MacGetMenu GetMenu
#define MacInsertMenuItem InsertMenuItem

/*No Mark Marking Character Constant

Indicates that a menu item contains no marking characters.

enum {
   noMark = 0
};
Constants
noMark

No marking character to be associated with a menu or submenu item.

Available in Mac OS X v10.0 and later.
Discussion

You can pass this constant, as well as those character marking constants defined in the Font Manager, in the markChar parameter of the function SetItemMark and the marking character field of the menu resource (of type ‘ MENU’) and return these constants in the markChar parameter of the function GetItemMark to specify the mark of a specific menu item or the menu ID of the submenu associated with the menu item.*/

enum {
   noMark = 0
};


/*Data Types
struct MenuInfo {          /menu record/
         short       menuID;        /number that identifies the menu/
         short       menuWidth;     /width (in pixels) of the menu/
         short       menuHeight;    /height (in pixels) of the menu/
         Handle      menuProc;      /menu definition procedure/
         long        enableFlags;   /indicates whether menu and /
                                    / menu items are enabled/
         Str255      menuData;      /title of menu/
         /itemDefinitions/        /variable-length data that /
                                    / defines the menu items/
      };

typedef struct MenuInfo MenuInfo;         /pointer to a menu record/
typedef MenuInfo MenuPtr, MenuHandle;  /handle to a menu record/
struct MCEntry {           /menu color entry record/
         short       mctID;         /menu ID or 0 for menu bar/
         short       mctItem;       /menu item number or 0 for /
                                    / menu title/
         RGBColor    mctRGB1;       /usage depends on mctID and /
                                    / mctItem/
         RGBColor    mctRGB2;       /usage depends on mctID and /
                                    / mctItem/
         RGBColor    mctRGB3;       /usage depends on mctID and /
                                    / mctItem/
         RGBColor    mctRGB4;       /usage depends on mctID and /
                                    / mctItem/
         short       mctReserved;   /reserved/
      };

typedef struct MCEntry MCEntry;
typedef MCEntry MCEntryPtr;        /pointer to a menu color entry record/
                                    /menu color table/
typedef MCEntry MCTable[1], *MCTablePtr, **MCTableHandle;*/
struct MenuInfo {          //menu record/
         short       menuID;        //number that identifies the menu/
         short       menuWidth;     //width (in pixels) of the menu/
         short       menuHeight;    //height (in pixels) of the menu/
       Handle      menuProc;      //menu definition procedure/         long        enableFlags;   //indicates whether menu and /
                                   // menu items are enabled/
        Str255      menuData;      //title of menu/
         //itemDefinitions/        /variable-length data that /
                                    // defines the menu items/
     };

typedef struct MenuInfo MenuInfo;      //pointer to a menu record/
typedef MenuInfo MenuPtr;  //handle to a menu record/




/*Menu Definition IDs

Specify options used in menu item functions. 

enum {
   textMenuProc = 0,
   hMenuCmd = 27,
   hierMenu = -1,
   kInsertHierarchicalMenu = -1,
};
Constants
textMenuProc

The menu definition ID for menus that are not Appearance-compliant. When mapping is enabled, this constant is mapped to kMenuStdMenuProc, its Appearance-compliant equivalent. Not normally used. 

Available in Mac OS X v10.0 and later.
hMenuCmd

Deprecated. Use SetMenuItemHierarchicalMenu or SetMenuItemHierarchicalID to specify a hierarchical menu instead. 

Available in Mac OS X v10.0 and later.
hierMenu

Deprecated. Use kInsertHierarchicalMenu instead. 

Available in Mac OS X v10.0 and later.
kInsertHierarchicalMenu

Used with InsertMenu to insert a submenu or pop-up menu into the submenu portion of the current menu list.

Available in Mac OS X v10.0 and later.
kHIMenuAppendItem

Pass to InsertMenuItem, InsertMenuItemText, or InsertMenuItemTextWithCFString to indicate that the new menu item should be added to the end of the menu. Note that you can simply call AppendMenu, AppendMenuItemText, or AppendMenuItemTextWithCFString instead. 

Available in Mac OS X v10.3 and later.
Discussion

A menu definition ID is supplied to the menu resource or a menu-creation function such as NewMenu to specify which menu definition function to use in creating the menu. The menu definition ID contains the resource ID of the menu definition function.*/
enum {
   textMenuProc = 0,
   hMenuCmd = 27,
   hierMenu = -1,
   kInsertHierarchicalMenu = -1,
};



/*MenuItemID

Defines a menu item.

typedef UInt32 MenuItemID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuItemID;

/*Menu Definition Type Constants

Indicate the type of menu definition being used. 

enum {
   kMenuDefProcPtr = 0,
   kMenuDefClassID = 1
};
typedef UInt32 MenuDefType;
Constants
kMenuDefProcPtr

A custom menu definition using the older MDEF messaging model.

Available in Mac OS X v10.0 and later.
kMenuDefClassID

A custom menu definition using an HIView subclass.

Available in Mac OS X v10.3 and later.*/
enum {
   kMenuDefProcPtr = 0,
   kMenuDefClassID = 1
};
typedef UInt32 MenuDefType;

/*Menu Definition Feature Constants

Indicate menu definition features. 

enum {
   kThemeSavvyMenuResponse = 0x7473
};
Constants
kThemeSavvyMenuResponse

Indicates that the menu is Appearance theme–savvy.

Available in Mac OS X v10.0 and later.
Discussion

The Menu Manager may pass the kMenuThemeSavvyMsg constant in the message parameter of your menu definition function to determine if your custom menu is theme-savvy (that is, whether it draws using Appearance Manager functions). In response, your menu definition function may respond with this flag in the whichItem parameter.*/

enum {
   kThemeSavvyMenuResponse = 0x7473
};



/*Custom Menu Definition Message Constants

Indicate messages used for non-HIView–based custom menu definitions. 

enum {
   kMenuDrawMsg = 0,
   kMenuSizeMsg = 2,
   kMenuPopUpMsg = 3,
   kMenuCalcItemMsg = 5,
   kMenuThemeSavvyMsg = 7,
   kMenuInitMsg = 8,
   kMenuDisposeMsg = 9,
   kMenuFindItemMsg = 10,
   kMenuHiliteItemMsg = 11,
   kMenuDrawItemsMsg = 12,
   mDrawMsg = kMenuDrawMsg,
   mSizeMsg = kMenuSizeMsg,
   mPopUpMsg = kMenuPopUpMsg,
   mCalcItemMsg = kMenuCalcItemMsg
};
Constants
kMenuDrawMsg

Draw the menu in the specified rectangle.

Available in Mac OS X v10.0 and later.
kMenuSizeMsg

Calculate the dimensions of the menu rectangle and store them in the menu structure. 

Available in Mac OS X v10.0 and later.
kMenuPopUpMsg

Calculate the dimensions of the pop-up menu.

Available in Mac OS X v10.0 and later.
kMenuCalcItemMsg

Calculate the dimensions of the specified menu item.

Available in Mac OS X v10.0 and later.
kMenuThemeSavvyMsg

Identify whether your menu definition function is theme-compliant. If so, your menu definition function should respond by passing back kThemeSavvyMenuResponse in the whichItem parameter. The Menu Manager then draws the menu background as appropriate for the current theme.

Available in Mac OS X v10.0 and later.
kMenuInitMsg

Perform any initializations required for the menu. Return an error code in *whichItem to indicate success or failure. 

Available in Mac OS X v10.0 and later.
kMenuDisposeMsg

Dispose of the menu. 

Available in Mac OS X v10.0 and later.
kMenuFindItemMsg

Determine the item underneath the mouse. 

Available in Mac OS X v10.0 and later.
kMenuHiliteItemMsg

Highlight the specified menu item. 

Available in Mac OS X v10.0 and later.
kMenuDrawItemsMsg

Draw the specified menu items. 

Available in Mac OS X v10.0 and later.
mDrawMsg

Same as kMenuDrawMsg. Obsolete.

Available in Mac OS X v10.0 and later.
mSizeMsg

Same as kMenuSizeMsg. Obsolete.

Available in Mac OS X v10.0 and later.
mPopUpMsg

Same as kMenuPopUpMsg. Obsolete.

Available in Mac OS X v10.0 and later.
mCalcItemMsg

Same as kMenuCalcItemMsg. Obsolete.

Available in Mac OS X v10.0 and later.
Discussion

For applications running on Mac OS X v10.3 and later, Apple recommends creating custom menu definitions using HIView subclasses rather than MDEF messages. See Introducing HIView for more information.

The Menu Manager passes a value defined by one of these constants in the message parameter of your menu definition function specifying what action your function must perform. Other messages are reserved for internal use by Apple Computer, Inc. For more information on how to respond to the various messages, see MenuDefProcPtr.*/

enum {
   kMenuDrawMsg = 0,
   kMenuSizeMsg = 2,
   kMenuPopUpMsg = 3,
   kMenuCalcItemMsg = 5,
   kMenuThemeSavvyMsg = 7,
   kMenuInitMsg = 8,
   kMenuDisposeMsg = 9,
   kMenuFindItemMsg = 10,
   kMenuHiliteItemMsg = 11,
   kMenuDrawItemsMsg = 12,
   mDrawMsg = kMenuDrawMsg,
   mSizeMsg = kMenuSizeMsg,
   mPopUpMsg = kMenuPopUpMsg,
   mCalcItemMsg = kMenuCalcItemMsg
};

/*Unsupported Functions

This section lists functions that are unsupported in Mac OS X. Table A-1 provides information on what you should do in place of using these functions.
Table A-1  Porting notes for unsupported Menu Manager functions
Unsupported functions	
Porting notes

CheckItem	
CheckItem has been renamed to CheckMenuItem in Carbon. You can also use Set/GetItemMark or Set/GetMenuCommandMark. 

CountMItems	
CountMItems has been renamed to CountMenuItems in Carbon.

DisableItem	
Replaced by DisableMenuItem.

DisposeMBarHookUPP	
Accessing the MBarHook low-memory global variable is not supported in Carbon. Use the Carbon Event Manager to work with menu bar events instead.

DisposeMenuBarDefUPP	
The menu bar is not customizable in Carbon.

DisposeMenuHookUPP	
Accessing the MenuHook low-memory global variable is not supported in Carbon. Use the Carbon Event Manager to work with menu events instead.

EnableItem	
Replaced by EnableMenuItem.

GetMenuItemRefCon2	
To associate data with a menu item you should instead use the Get/SetMenuItemProperty functions available with the Mac OS 8.5 Menu Manager.

InitMenus	
InitMenus is not supported in Carbon. There is no need to initialize the Menu Manager because the shared library is loaded as needed.

InitProcMenu	
You must use the standard menu bar definition function (MBDF).

InvokeMBarHookUPP	
Accessing the MBarHook low-memory global variable is not supported in Carbon. Use the Carbon Event Manager to work with menu bar events instead.

InvokeMenuBarDefUPP	
The menu bar is not customizable in Carbon.

InvokeMenuHookUPP	
Accessing the MenuHook low-memory global variable is not supported in Carbon. Use the Carbon Event Manager to work with menu events instead.

NewMBarHookUPP	
Accessing the MBarHook low-memory global variable is not supported in Carbon. Use the Carbon Event Manager to work with menu bar events instead.

NewMenuBarDefUPP	
The menu bar is not customizable in Carbon.

NewMenuHookUPP	
Accessing the MenuHook low-memory global variable is not supported in Carbon. Use the Carbon Event Manager to work with menu events instead.

SetMenuFlash	
Use SetMenuFlashCount instead. Note that users cannot set the flash count on Mac OS X. 

SetMenuItemRefCon2	
To associate data with a menu item in Carbon, you should instead use the Get/SetMenuItemProperty functions.

SystemEdit	
Carbon does not support desk accessories.

SystemMenu	
Carbon does not support desk accessories.

appendmenu	
Use AppendMenuItemTextWithCFString instead.

getmenuitemtext	
Use GetMenuItemTextWithCFString instead.

insertmenuitem	
Use InsertMenuItemTextWithCFString instead.

menuselect	
Use MenuSelect instead.

newmenu	
Use CreateNewMenu instead.

setmenuitemtext	
Use SetMenuItemTextWithCFString instead.*/
#define DisableItem	DisableMenuItem
#define CheckItem	CheckMenuItem
#define CountMItems  CountMenuItems

/*Contextual Menu Gestalt Selector Constants

Determine which contextual menu features are available.

enum {
   gestaltContextualMenuAttr = 'cmnu',
   gestaltContextualMenuUnusedBit = 0,
   gestaltContextualMenuTrapAvailable = 1,
   gestaltContextualMenuHasAttributeAndModifierKeys = 2,
   gestaltContextualMenuHasUnicodeSupport = 3
};
Constants
gestaltContextualMenuAttr

The Gestalt selector passed to the Gestalt function to determine whether contextual menu functions are available. Produces a value whose bits you should test to determine whether the contextual menu functions are available.

Available in Mac OS X v10.0 and later.
gestaltContextualMenuUnusedBit

Available in Mac OS X v10.0 and later.
gestaltContextualMenuTrapAvailable

If this bit is set, the contextual menu functions are available to 68K applications. If this bit is not set, these functions are not available to 68K applications.

Available in Mac OS X v10.0 and later.
gestaltContextualMenuHasAttributeAndModifierKeys

The contextual menu supports attributes and modifier keys.

Available in Mac OS X v10.2 and later.
gestaltContextualMenuHasUnicodeSupport

The contextual menu supports Unicode text.

Available in Mac OS X v10.2 and later.
Discussion

Mac OS X and all versions of Mac OS that shipped with CarbonLib support contextual menus, so you need to check only to see if certain features are available.*/
enum {
   gestaltContextualMenuAttr = 'cmnu',
   gestaltContextualMenuUnusedBit = 0,
   gestaltContextualMenuTrapAvailable = 1,
   gestaltContextualMenuHasAttributeAndModifierKeys = 2,
   gestaltContextualMenuHasUnicodeSupport = 3
};

/*Modifier Key Mask Constants

Specify modifier keys used with menu item selections. 

enum {
   kMenuNoModifiers = 0,
   kMenuShiftModifier = (1 << 0),
   kMenuOptionModifier = (1 << 1),
   kMenuControlModifier = (1 << 2),
   kMenuNoCommandModifier = (1 << 3)
};
Constants
kMenuNoModifiers

If no bit is set, only the Command key is used in the keyboard equivalent.

Available in Mac OS X v10.0 and later.
kMenuShiftModifier

If this bit (bit 0) is set, the Shift key is used in the keyboard equivalent.

Available in Mac OS X v10.0 and later.
kMenuOptionModifier

If this bit (bit 1) is set, the Option key is used in the keyboard equivalent.

Available in Mac OS X v10.0 and later.
kMenuControlModifier

If this bit (bit 2) is set, the Control key is used in the keyboard equivalent.

Available in Mac OS X v10.0 and later.
kMenuNoCommandModifier

If this bit (bit 3) is set, the Command key is not used in the keyboard equivalent.

Available in Mac OS X v10.0 and later.
Discussion

You can use one or more of these mask constants to determine which modifier key(s) must be pressed along with a character key to create a keyboard equivalent for selecting a menu item. You set and obtain these constants by calling SetMenuItemModifiers and GetMenuItemModifiers, respectively.*/
enum {
   kMenuNoModifiers = 0,
   kMenuShiftModifier = (1 << 0),
   kMenuOptionModifier = (1 << 1),
   kMenuControlModifier = (1 << 2),
   kMenuNoCommandModifier = (1 << 3)
};

/*Contextual Menu Item Content Constants

Specify contents of menu items in contextual menus. 

enum {
   keyContextualMenuName = 'pnam',
   keyContextualMenuCommandID = 'cmcd',
   keyContextualMenuSubmenu = 'cmsb',
   keyContextualMenuAttributes = 'cmat',
   keyContextualMenuModifiers = 'cmmd'
};
Constants
keyContextualMenuName

The menu item text. In Mac OS X v10.1 and earlier, the data format must be either typeChar or typeIntlText. In Mac OS X v10.2 and later, you can also specify typeStyledText, typeAEText, typeUnicodeText, and typeCFStringRef. Note that if you specify typeCFStringRef, the Menu Manager releases the CFString reference after displaying the menu. If you need to hold onto the CFString reference, you should retain it before inserting it into the Apple event record (AERecord). 

Available in Mac OS X v10.2 and later.
keyContextualMenuCommandID

The menu item command ID. The data format for this parameter must be typeLongInteger.

Available in Mac OS X v10.2 and later.
keyContextualMenuSubmenu

The submenu of the menu item. You typically use this with the Apple Event Manager function AEPutDesc to add an entire AEDesc record (which contains the submenu) as the parameter data.

Available in Mac OS X v10.2 and later.
keyContextualMenuAttributes

Specifies the menu item attributes. The data format for this parameter must be typeLongInteger.

Available in Mac OS X v10.2 and later.
keyContextualMenuModifiers

Specifies the modifer keys for the menu item. The data format for this parameter must be typeLongInteger. By using this parameter along with the keyContextualMenuAttributes parameter, you can create dynamic contextual menu items that change according to the state of the modifier keys.

Available in Mac OS X v10.2 and later.
Discussion

You use these keyword constants to specify parameters in an Apple Event record (AERecord) that defines a contextual menu item. Typically you assign these values in your ExamineContext method of a contextual menu plugin.*/
enum {
   keyContextualMenuName = 'pnam',
   keyContextualMenuCommandID = 'cmcd',
   keyContextualMenuSubmenu = 'cmsb',
   keyContextualMenuAttributes = 'cmat',
   keyContextualMenuModifiers = 'cmmd'
};


/*Menu Glyph Constants

Specify menu glyphs.

enum {
   kMenuNullGlyph = 0x00,
   kMenuTabRightGlyph = 0x02,
   kMenuTabLeftGlyph = 0x03,
   kMenuEnterGlyph = 0x04,
   kMenuShiftGlyph = 0x05,
   kMenuControlGlyph = 0x06,
   kMenuOptionGlyph = 0x07,
   kMenuSpaceGlyph = 0x09,
   kMenuDeleteRightGlyph = 0x0A,
   kMenuReturnGlyph = 0x0B,
   kMenuReturnR2LGlyph = 0x0C,
   kMenuNonmarkingReturnGlyph = 0x0D,
   kMenuPencilGlyph = 0x0F,
   kMenuDownwardArrowDashedGlyph = 0x10,
   kMenuCommandGlyph = 0x11,
   kMenuCheckmarkGlyph = 0x12,
   kMenuDiamondGlyph = 0x13,
   kMenuAppleLogoFilledGlyph = 0x14,
   kMenuParagraphKoreanGlyph = 0x15,
   kMenuDeleteLeftGlyph = 0x17,
   kMenuLeftArrowDashedGlyph = 0x18,
   kMenuUpArrowDashedGlyph = 0x19,
   kMenuRightArrowDashedGlyph = 0x1A,
   kMenuEscapeGlyph = 0x1B,
   kMenuClearGlyph = 0x1C,
   kMenuLeftDoubleQuotesJapaneseGlyph = 0x1D,
   kMenuRightDoubleQuotesJapaneseGlyph = 0x1E,
   kMenuTrademarkJapaneseGlyph = 0x1F,
   kMenuBlankGlyph = 0x61,
   kMenuPageUpGlyph = 0x62,
   kMenuCapsLockGlyph = 0x63,
   kMenuLeftArrowGlyph = 0x64,
   kMenuRightArrowGlyph = 0x65,
   kMenuNorthwestArrowGlyph = 0x66,
   kMenuHelpGlyph = 0x67,
   kMenuUpArrowGlyph = 0x68,
   kMenuSoutheastArrowGlyph = 0x69,
   kMenuDownArrowGlyph = 0x6A,
   kMenuPageDownGlyph = 0x6B,
   kMenuAppleLogoOutlineGlyph = 0x6C,
   kMenuContextualMenuGlyph = 0x6D,
   kMenuPowerGlyph = 0x6E,
   kMenuF1Glyph = 0x6F,
   kMenuF2Glyph = 0x70,
   kMenuF3Glyph = 0x71,
   kMenuF4Glyph = 0x72,
   kMenuF5Glyph = 0x73,
   kMenuF6Glyph = 0x74,
   kMenuF7Glyph = 0x75,
   kMenuF8Glyph = 0x76,
   kMenuF9Glyph = 0x77,
   kMenuF10Glyph = 0x78,
   kMenuF11Glyph = 0x79,
   kMenuF12Glyph = 0x7A,
   kMenuF13Glyph = 0x87,
   kMenuF14Glyph = 0x88,
   kMenuF15Glyph = 0x89,
   kMenuControlISOGlyph = 0x8A,
   kMenuEjectGlyph = 0x8C
};
Constants
kMenuNullGlyph

The null character. Note that this glyph has no visible representation (that is, nothing appears in the menu). 

Available in Mac OS X v10.0 and later.
kMenuTabRightGlyph

The Tab-to-the-right key. Used in left to right script systems. 

Available in Mac OS X v10.0 and later.
kMenuTabLeftGlyph

The Tab-to-the-left key. Used in right to left script systems. 

Available in Mac OS X v10.0 and later.
kMenuEnterGlyph

The Enter key.

Available in Mac OS X v10.0 and later.
kMenuShiftGlyph

The Shift key.

Available in Mac OS X v10.0 and later.
kMenuControlGlyph

The Control key.

Available in Mac OS X v10.0 and later.
kMenuOptionGlyph

The Option key. 

Available in Mac OS X v10.0 and later.
kMenuSpaceGlyph

The Space bar. Note that this glyph has no visible representation (that is, nothing appears in the menu). 

Available in Mac OS X v10.0 and later.
kMenuDeleteRightGlyph

The Delete-to-the-right key. Used in right-to-left script systems.

Available in Mac OS X v10.0 and later.
kMenuReturnGlyph

The Return key for left-to-right script systems. 

Available in Mac OS X v10.0 and later.
kMenuReturnR2LGlyph

The Return key for right-to-left script systems. 

Available in Mac OS X v10.0 and later.
kMenuNonmarkingReturnGlyph

The nonmarking Return key. Note that this glyph has no visible representation (that is, nothing appears in the menu). 

Available in Mac OS X v10.0 and later.
kMenuPencilGlyph

The Pencil key. 

Available in Mac OS X v10.0 and later.
kMenuDownwardArrowDashedGlyph

The downward dashed arrow key. 

Available in Mac OS X v10.0 and later.
kMenuCommandGlyph

The Command key.

Available in Mac OS X v10.0 and later.
kMenuCheckmarkGlyph

The Check mark key.

Available in Mac OS X v10.0 and later.
kMenuDiamondGlyph

The diamond mark.

Available in Mac OS X v10.0 and later.
kMenuAppleLogoFilledGlyph

The filled Apple logo.

Available in Mac OS X v10.0 and later.
kMenuParagraphKoreanGlyph

Unassigned. (Paragraph glyph in Korean)

Available in Mac OS X v10.0 and later.
kMenuDeleteLeftGlyph

The Delete-to-the-left key.

Available in Mac OS X v10.0 and later.
kMenuLeftArrowDashedGlyph

The dashed left arrow key.

Available in Mac OS X v10.0 and later.
kMenuUpArrowDashedGlyph

The dashed up arrow key.

Available in Mac OS X v10.0 and later.
kMenuRightArrowDashedGlyph

The dashed right arrow key. 

Available in Mac OS X v10.0 and later.
kMenuEscapeGlyph

The Escape key. 

Available in Mac OS X v10.0 and later.
kMenuClearGlyph

The Clear key. 

Available in Mac OS X v10.0 and later.
kMenuLeftDoubleQuotesJapaneseGlyph

Unassigned. (Left double quotation marks in Japanese)

Available in Mac OS X v10.0 and later.
kMenuRightDoubleQuotesJapaneseGlyph

Unassigned (Right double quotation marks in Japanese)

Available in Mac OS X v10.0 and later.
kMenuTrademarkJapaneseGlyph

Unassigned. (Trademark in Japanese)

Available in Mac OS X v10.0 and later.
kMenuBlankGlyph

The blank key.

Available in Mac OS X v10.0 and later.
kMenuPageUpGlyph

The Page Up key.

Available in Mac OS X v10.0 and later.
kMenuCapsLockGlyph

The Caps Lock key. 

Available in Mac OS X v10.0 and later.
kMenuLeftArrowGlyph

The left arrow key. 

Available in Mac OS X v10.0 and later.
kMenuRightArrowGlyph

The right arrow key. 

Available in Mac OS X v10.0 and later.
kMenuNorthwestArrowGlyph

The northwest arrow key 

Available in Mac OS X v10.0 and later.
kMenuHelpGlyph

The Help key.

Available in Mac OS X v10.0 and later.
kMenuUpArrowGlyph

The up arrow key. 

Available in Mac OS X v10.0 and later.
kMenuSoutheastArrowGlyph

The southeast arrow key. 

Available in Mac OS X v10.0 and later.
kMenuDownArrowGlyph

The down arrow key.

Available in Mac OS X v10.0 and later.
kMenuPageDownGlyph

The Page Down key.

Available in Mac OS X v10.0 and later.
kMenuAppleLogoOutlineGlyph

The outlined Apple logo. 

Available in Mac OS X v10.0 and later.
kMenuContextualMenuGlyph

The contextual menu key 

Available in Mac OS X v10.0 and later.
kMenuPowerGlyph

The power key (that is, the startup key).

Available in Mac OS X v10.0 and later.
kMenuF1Glyph

The F1 key.

Available in Mac OS X v10.0 and later.
kMenuF2Glyph

The F2 key.

Available in Mac OS X v10.0 and later.
kMenuF3Glyph

The F3 key.

Available in Mac OS X v10.0 and later.
kMenuF4Glyph

The F4 key.

Available in Mac OS X v10.0 and later.
kMenuF5Glyph

The F5 key.

Available in Mac OS X v10.0 and later.
kMenuF6Glyph

The F6 key.

Available in Mac OS X v10.0 and later.
kMenuF7Glyph

The F7 key.

Available in Mac OS X v10.0 and later.
kMenuF8Glyph

The F8 key.

Available in Mac OS X v10.0 and later.
kMenuF9Glyph

The F9 key.

Available in Mac OS X v10.0 and later.
kMenuF10Glyph

The F10 key.

Available in Mac OS X v10.0 and later.
kMenuF11Glyph

The F11 key.

Available in Mac OS X v10.0 and later.
kMenuF12Glyph

The F12 key.

Available in Mac OS X v10.0 and later.
kMenuF13Glyph

The F13 key.

Available in Mac OS X v10.0 and later.
kMenuF14Glyph

The F14 key.

Available in Mac OS X v10.0 and later.
kMenuF15Glyph

The F15 key.

Available in Mac OS X v10.0 and later.
kMenuControlISOGlyph

The ISO standard control key.

Available in Mac OS X v10.0 and later.
kMenuEjectGlyph

The Eject key (available in Mac OS X v10.2 and later).

Available in Mac OS X v10.2 and later.
Discussion

Use these constants with GetMenuItemKeyGlyph and SetMenuItemKeyGlyph.*/

enum {
   kMenuNullGlyph = 0x00,
   kMenuTabRightGlyph = 0x02,
   kMenuTabLeftGlyph = 0x03,
   kMenuEnterGlyph = 0x04,
   kMenuShiftGlyph = 0x05,
   kMenuControlGlyph = 0x06,
   kMenuOptionGlyph = 0x07,
   kMenuSpaceGlyph = 0x09,
   kMenuDeleteRightGlyph = 0x0A,
   kMenuReturnGlyph = 0x0B,
   kMenuReturnR2LGlyph = 0x0C,
   kMenuNonmarkingReturnGlyph = 0x0D,
   kMenuPencilGlyph = 0x0F,
   kMenuDownwardArrowDashedGlyph = 0x10,
   kMenuCommandGlyph = 0x11,
   kMenuCheckmarkGlyph = 0x12,
   kMenuDiamondGlyph = 0x13,
   kMenuAppleLogoFilledGlyph = 0x14,
   kMenuParagraphKoreanGlyph = 0x15,
   kMenuDeleteLeftGlyph = 0x17,
   kMenuLeftArrowDashedGlyph = 0x18,
   kMenuUpArrowDashedGlyph = 0x19,
   kMenuRightArrowDashedGlyph = 0x1A,
   kMenuEscapeGlyph = 0x1B,
   kMenuClearGlyph = 0x1C,
   kMenuLeftDoubleQuotesJapaneseGlyph = 0x1D,
   kMenuRightDoubleQuotesJapaneseGlyph = 0x1E,
   kMenuTrademarkJapaneseGlyph = 0x1F,
   kMenuBlankGlyph = 0x61,
   kMenuPageUpGlyph = 0x62,
   kMenuCapsLockGlyph = 0x63,
   kMenuLeftArrowGlyph = 0x64,
   kMenuRightArrowGlyph = 0x65,
   kMenuNorthwestArrowGlyph = 0x66,
   kMenuHelpGlyph = 0x67,
   kMenuUpArrowGlyph = 0x68,
   kMenuSoutheastArrowGlyph = 0x69,
   kMenuDownArrowGlyph = 0x6A,
   kMenuPageDownGlyph = 0x6B,
   kMenuAppleLogoOutlineGlyph = 0x6C,
   kMenuContextualMenuGlyph = 0x6D,
   kMenuPowerGlyph = 0x6E,
   kMenuF1Glyph = 0x6F,
   kMenuF2Glyph = 0x70,
   kMenuF3Glyph = 0x71,
   kMenuF4Glyph = 0x72,
   kMenuF5Glyph = 0x73,
   kMenuF6Glyph = 0x74,
   kMenuF7Glyph = 0x75,
   kMenuF8Glyph = 0x76,
   kMenuF9Glyph = 0x77,
   kMenuF10Glyph = 0x78,
   kMenuF11Glyph = 0x79,
   kMenuF12Glyph = 0x7A,
   kMenuF13Glyph = 0x87,
   kMenuF14Glyph = 0x88,
   kMenuF15Glyph = 0x89,
   kMenuControlISOGlyph = 0x8A,
   kMenuEjectGlyph = 0x8C
};


/*Menu Item Icon Type Constants

Specify types of icons to attach to menu items. 

enum {
   kMenuNoIcon = 0,
   kMenuIconType = 1,
   kMenuShrinkIconType = 2,
   kMenuSmallIconType = 3,
   kMenuColorIconType = 4,
   kMenuIconSuiteType = 5,
   kMenuIconRefType = 6,
   kMenuCGImageRefType = 7,
   kMenuSystemIconSelectorType = 8,
   kMenuIconResourceType = 9
};
Constants
kMenuNoIcon

No icon.

Available in Mac OS X v10.0 and later.
kMenuIconType

Identifies an icon of type 'ICON'.

Available in Mac OS X v10.0 and later.
kMenuShrinkIconType

Identifies a 32-by-32-pixel icon of type 'ICON', shrunk (at display time) to 16-by-16.

Available in Mac OS X v10.0 and later.
kMenuSmallIconType

Identifies an icon of type 'SICN'.

Available in Mac OS X v10.0 and later.
kMenuColorIconType

Identifies an icon of type 'cicn'.

Available in Mac OS X v10.0 and later.
kMenuIconSuiteType

Identifies an icon suite.

Available in Mac OS X v10.0 and later.
kMenuIconRefType

Identifies an icon of type IconRef. This value is supported under Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
kMenuCGImageRefType

Identifies an icon of type CGImageRef.

Available in Mac OS X v10.0 and later.
kMenuSystemIconSelectorType

Identifies an OSType value that corresponds to an icon (type IconRef )registered with Icon Services under kSystemIconsCreator.

Available in Mac OS X v10.1 and later.
kMenuIconResourceType

Identifies a CFString that names an icon resource in the main bundle of the application.

Available in Mac OS X v10.1 and later.
Discussion

These constants specify the type of an icon attached to a menu item. They are passed in SetMenuItemIconHandle and obtained by GetMenuItemIconHandle. Menu item icon type constants are available with Appearance Manager 1.0 and later.*/
enum {
   kMenuNoIcon = 0,
   kMenuIconType = 1,
   kMenuShrinkIconType = 2,
   kMenuSmallIconType = 3,
   kMenuColorIconType = 4,
   kMenuIconSuiteType = 5,
   kMenuIconRefType = 6,
   kMenuCGImageRefType = 7,
   kMenuSystemIconSelectorType = 8,
   kMenuIconResourceType = 9
};

/*Menu Attribute Constants

Specify menu attributes.

typedef UInt32 MenuAttributes;
enum {
   kMenuAttrExcludesMarkColumn = (1 << 0),
   kMenuAttrAutoDisable = (1 << 2),
   kMenuAttrUsePencilGlyph = (1 << 3),
   kMenuAttrHidden = (1 << 4)
   kMenuAttrCondenseSeparators = (1 << 5)
   kMenuAttrDoNotCacheImage = (1 << 6)
   kMenuAttrDoNotUseUserCommandKeys = (1 << 7)
};
Constants
kMenuAttrExcludesMarkColumn

No column space is allocated for the mark character when this menu is drawn.

Available in Mac OS X v10.0 and later.
kMenuAttrAutoDisable

The menu title is automatically disabled when all of its menu items are disabled. 

Available in Mac OS X v10.0 and later.
kMenuAttrUsePencilGlyph

Use the pencil glyph from the Keyboard font (kMenuPencilGlyph) to draw the control modifier keys when drawing keyboard equivalents. Typically used only for Japanese input method menus. 

Available in Mac OS X v10.0 and later.
kMenuAttrHidden

Do not draw the menu title, even when the menu is inserted in the menu bar. This attribute is useful for specifying keyboard equivalent commands that don’t correspond with visible menu items. That is, you can add command key equivalents to to menu items and keep the menu itself from appearing in the menu.

Available in Mac OS X v10.2 and later.
kMenuAttrCondenseSeparators

Hides extra separators to avoid blank spaces in a menu. That is, if separators exists at the beginning or end of a menu, or if multiple contiguous separators exist, the Menu Manager marks the extra separator items as hidden. The Menu Manager checks for extra separators whenever it recalculates the menu size.

Available in Mac OS X v10.3 and later.
kMenuAttrDoNotCacheImage

Disables automatic caching of the menu image. Normally, the Menu Manager caches images of all HIView–based menus. (All standard menus are drawn using HIViews in Mac OS X v10.3 and later.) If you specify this attribute, the Menu Manager draws the menu each time it is displayed.

Available in Mac OS X v10.3 and later.
kMenuAttrDoNotUseUserCommandKeys

Disables substitution of command key equivalents from the NSUserKeysEquivalents dictionary. By default, the Menu Manager checks for matches in the dictionary for every menu item. Note that this attribute is effective only if you set it when you create the menu; After the Menu Manager searches the dictionary and sets the user command keys (which occurs in the CalcMenuSize, GetMenuItemCommandKey, GetItemCmd and before command key matching), you cannot retrieve the original command keys. Similarly, clearing this attribute does not restore the original command keys.

Available in Mac OS X v10.3 and later.
Discussion

Menu attributes control behavior of the entire menu. They are used with the ChangeMenuAttributes and GetMenuAttributes.*/
typedef UInt32 MenuAttributes;
enum {
   kMenuAttrExcludesMarkColumn = (1 << 0),
   kMenuAttrAutoDisable = (1 << 2),
   kMenuAttrUsePencilGlyph = (1 << 3),
   kMenuAttrHidden = (1 << 4),
   kMenuAttrCondenseSeparators = (1 << 5),
   kMenuAttrDoNotCacheImage = (1 << 6),
   kMenuAttrDoNotUseUserCommandKeys = (1 << 7)
};

/*MenuHandle

Abst_MenuHandle

typedef MenuPtr * MenuHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef MenuPtr * MenuHandle;

/*MenuBarHandle

A handle to a menu bar header.

typedef Handle MenuBarHandle;
Availability
Available in Mac OS X v10.0 and later.*/
typedef Handle MenuBarHandle;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuID

Defines a menu ID.

typedef SInt16 MenuID;typedef SInt16 MenuID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 MenuID;

/*MenuCommand

Specifies a menu item’s command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 MenuCommand;

/*Menu Item Data Flags

Indicate which fields of a MenuItemDataRec structure are to be copied or set. 

enum {
   kMenuItemDataText = (1 << 0),
   kMenuItemDataMark = (1 << 1),
   kMenuItemDataCmdKey = (1 << 2),
   kMenuItemDataCmdKeyGlyph = (1 << 3),
   kMenuItemDataCmdKeyModifiers = (1 << 4),
   kMenuItemDataStyle = (1 << 5),
   kMenuItemDataEnabled = (1 << 6),
   kMenuItemDataIconEnabled = (1 << 7),
   kMenuItemDataIconID = (1 << 8),
   kMenuItemDataIconHandle = (1 << 9),
   kMenuItemDataCommandID = (1 << 10),
   kMenuItemDataTextEncoding = (1 << 11),
   kMenuItemDataSubmenuID = (1 << 12),
   kMenuItemDataSubmenuHandle = (1 << 13),
   kMenuItemDataFontID = (1 << 14),
   kMenuItemDataRefcon = (1 << 15),
   kMenuItemDataAttributes = (1 << 16),
   kMenuItemDataCFString = (1 << 17),
   kMenuItemDataProperties = (1 << 18),
   kMenuItemDataIndent = (1 << 19),
   kMenuItemDataCmdVirtualKey = (1 << 20),
   kMenuItemDataAllDataVersionOne = 0x000FFFFF,
   kMenuItemDataAllDataVersionTwo = kMenuItemDataAllDataVersionOne
| kMenuItemDataCmdVirtualKey
};
enum {
   kMenuItemDataAllData = kMenuItemDataAllDataVersionTwo
};
typedef UInt64 MenuItemDataFlags;
Constants
kMenuItemDataText

Set or return the Str255 text of a menu using the MenuItemDataRec.text field. If getting the text, the text field must be initialized with a pointer to a Str255 variable before calling CopyMenuItemData. If both kMenuItemDataText and kMenuItemCFString are set on entry to CopyMenuItemData, the API will determine whether the menu text was most recently set using a Str255 or CFString, and return only that text format; the flags value for the other format will be cleared. Valid for both menu items and the menu title (if item number is 0).

Available in Mac OS X v10.0 and later.
kMenuItemDataMark

Set or return the mark character of a menu item using the MenuItemDataRec.mark field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKey

Set or return the command key of a menu using the MenuItemDataRec.cmdKey field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKeyGlyph

Set or return the command key glyph of a menu using the MenuItemDataRec.cmdKeyGlyph field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdKeyModifiers

Set or return the command key modifiers of a menu using the MenuItemDataRec.cmdKeyModifiers field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataStyle

Set or return the QuickDraw text style of a menu item using the MenuItemDataRec.style field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataEnabled

Set or return the enable state of a menu using the MenuItemDataRec.enabled field. Valid for both menu items and the menu itself (if the item number is zero). 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconEnabled

Set or return the enable state of the menu item icon using the MenuItemDataRec.iconEnabled field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconID

Set or return the icon resource ID of the menu item icon using the MenuItemDataRec.iconID field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataIconHandle

Set or return the icon handle of a menu item using the MenuItemDataRec.iconType and MenuItemDataRec.iconHandle field. You must initialize both fields if you are setting the handle; both fields are returned when obtaining the handle. 

The iconType field can contain one of the following constants: kMenuIconType, kMenuShrinkIconType, kMenuSmallIconType, kMenuColorIcontype, kMenuIconSuiteType, or kMenuIconRefType. The icon handle may be a handle to an 'ICON' resource, a 'SICN' resource, a 'cicn' resource, an icon suite, or an icon reference. Valid only for menu items. 

In Mac OS X v10.0 and later, the iconType field can also contain kMenuCGImageType, with the icon handle being of type CGImageRef.

In Mac OS X v10.1 and later, the iconType field can also contain kMenuSystemIconSelectorType or kMenuIconResource, which have icon handles of type OSType and CFStringRef respectively.

Available in Mac OS X v10.0 and later.
kMenuItemDataCommandID

Set or return the command ID of a menu using the MenuItemDataRec.cmdID field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataTextEncoding

Set or return the text encoding of a menu item using the MenuItemDataRec.encoding field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataSubmenuID

Set or return the menu ID of the submenu associated with this menu item using the MenuItemDataRec.submenuID field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataSubmenuHandle

Set or return the menu reference (MenuRef) of the submenu associated with this menu using the MenuItemDataRec.submenuHandle field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataFontID

Set or return the font ID associated with this menu item using the MenuItemDataRec.fomtID field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataRefcon

Set or return the reference constant associated with this menu item using the MenuItemDataRec.refcon field. If you specified a menu item index of 0, you can set or obtain the menu reference constant. 

Available in Mac OS X v10.0 and later.
kMenuItemDataAttributes

Set or return the attribute bits associated with this menu item using the MenuItemDataRec.attr field. If you specified a menu item index of 0, you can set or obtain a MenuAttributes bit field, not a MenuItemAttributes bit field.

Available in Mac OS X v10.0 and later.
kMenuItemDataCFString

Set or return the title of the menu item (as a Core Foundation string) using the MenuItemDataRec.cFText field. If you specified a menu item index of 0, you can set or obtain the menu title.

Available in Mac OS X v10.0 and later.
kMenuItemDataProperties

Set or return the properties of a menu using the MenuItemDataRec.properties field.

If setting properties, the properties field should contain a collection with the new properties; note that this will overwrite any existing properties with the same collection creator and tag.

If getting properties, you should set the properties field to either a valid collection or NULL. A valid collection is overwritten by the new properties. If you pass NULL, the CopyMenuItemData function allocates a new collection and returns it in the properties field. 

You can set this flag for both menu items and the menu itself (if the item number is zero).

Available in Mac OS X v10.0 and later.
kMenuItemDataIndent

Set or return the indent level of a menu item using the MenuItemDataRec.indent field. Valid only for menu items.

Available in Mac OS X v10.0 and later.
kMenuItemDataCmdVirtualKey

Set or return the virtual key code for this menu item using the MenuItemDataRec.cmdVirtualKey field. Valid only for menu items. 

Available in Mac OS X v10.0 and later.
kMenuItemDataAllDataVersionOne

Sets all flags, except for kMenuItemDataCmdVirtualKey.

Available in Mac OS X v10.0 and later.
kMenuItemDataAllDataVersionTwo

Sets all flags, including kMenuItemDataCmdVirtualKey.

Available in Mac OS X v10.0 and later.
Discussion

A MenuItemDataFlags value indicates which fields of a “MenuItemDataRec” structure should be used by the CopyMenuItemData or SetMenuItemData functions. All menu item data flags may be used when getting or setting the contents of a menu item; some may also be used when getting or setting information about the menu itself, if the item index given to CopyMenuItemData or SetMenuItemData is 0.*/
enum {
   kMenuItemDataText = (1 << 0),
   kMenuItemDataMark = (1 << 1),
   kMenuItemDataCmdKey = (1 << 2),
   kMenuItemDataCmdKeyGlyph = (1 << 3),
   kMenuItemDataCmdKeyModifiers = (1 << 4),
   kMenuItemDataStyle = (1 << 5),
   kMenuItemDataEnabled = (1 << 6),
   kMenuItemDataIconEnabled = (1 << 7),
   kMenuItemDataIconID = (1 << 8),
   kMenuItemDataIconHandle = (1 << 9),
   kMenuItemDataCommandID = (1 << 10),
   kMenuItemDataTextEncoding = (1 << 11),
   kMenuItemDataSubmenuID = (1 << 12),
   kMenuItemDataSubmenuHandle = (1 << 13),
   kMenuItemDataFontID = (1 << 14),
   kMenuItemDataRefcon = (1 << 15),
   kMenuItemDataAttributes = (1 << 16),
   kMenuItemDataCFString = (1 << 17),
   kMenuItemDataProperties = (1 << 18),
   kMenuItemDataIndent = (1 << 19),
   kMenuItemDataCmdVirtualKey = (1 << 20),
   kMenuItemDataAllDataVersionOne = 0x000FFFFF,
   kMenuItemDataAllDataVersionTwo = kMenuItemDataAllDataVersionOne
| kMenuItemDataCmdVirtualKey
};
enum {
   kMenuItemDataAllData = kMenuItemDataAllDataVersionTwo
};
typedef UInt64 MenuItemDataFlags;

/*MenuItemDataRec

Used with the SetMenuItemData and CopyMenuItemData functions to get or change aspects of a menu item.

struct MenuItemDataRec {
   MenuItemDataFlags whichData;
   StringPtr text;
   UniChar mark;
   UniChar cmdKey;
   UInt32 cmdKeyGlyph;
   UInt32 cmdKeyModifiers;
   Style style;
   Boolean enabled;
   Boolean iconEnabled;
   UInt8 filler1;
   SInt32 iconID;
   UInt32 iconType;
   Handle iconHandle;
   MenuCommand cmdID;
   TextEncoding encoding;
   MenuID submenuID;
   MenuRef submenuHandle;
   SInt32 fontID;
   UInt32 refcon;
   OptionBits attr;
   CFStringRef cfText;
   Collection properties;
   UInt32 indent;
   UInt16 cmdVirtualKey;
};
typedef struct MenuItemDataRec MenuItemDataRec;
typedef MenuItemDataRec * MenuItemDataPtr;
Fields
whichData

The fields to be set or obtained. You pass a bit mask as specified by “Menu Item Data Flags” to indicate which values you want to get or set. The values themselves are set or populated in the fields that follow. 
text

The menu item title, as an Str255 string. 
mark 

The menu item’s mark. 
cmdKey

The menu item’s command key. This can be either a character code or a virtual key code. 
cmdKeyGlyph

The menu item’s command key glyph.
cmdKeyModifiers

The menu item’s command key modifiers.
style

The menu item’s QuickDraw text style.
enabled

The menu item’s enable state.
iconEnabled

The enable state of the menu item icon.
filler1 

Reserved.
iconID

The icon resource ID of the menu item. 
iconHandle

The icon handle of the menu item. 
cmdID

The command ID for the menu item. 
encoding

The text encoding of the menu item.
submenuID

The menu ID of the submenu associated with this menu item. 
submenuHandle

The MenuRef of the submenu associated with this menu item. 
fontID

The font ID for the menu item.
refcon

The reference constant associated with this menu item. 
attr

The menu item’s attributes.
cfText

The menu item’s title, as a Core Foundation string. 
properties

A collection holding the menu item’s properties. 
indent

The menu item’s indent level. 
cmdVirtualKey

The menu item’s virtual key. 
Discussion

When using this structure withCopyMenuItemData or SetMenuItemData, the caller must first set the whichData field to a combination of MenuItemDataFlags indicating which specific data should be retrieved or set. Some fields also require initialization before calling CopyMenuItemData; see “Menu Item Data Flags” for details.
Availability
Available in Mac OS X v10.0 and later.*/
struct MenuItemDataRec {
   MenuItemDataFlags whichData;
   StringPtr text;
   UniChar mark;
   UniChar cmdKey;
   UInt32 cmdKeyGlyph;
   UInt32 cmdKeyModifiers;
   Style style;
   Boolean enabled;
   Boolean iconEnabled;
   UInt8 filler1;
   SInt32 iconID;
   UInt32 iconType;
   Handle iconHandle;
   MenuCommand cmdID;
   TextEncoding encoding;
   MenuID submenuID;
   MenuRef submenuHandle;
   SInt32 fontID;
   UInt32 refcon;
   OptionBits attr;
   CFStringRef cfText;
   Collection properties;
   UInt32 indent;
   UInt16 cmdVirtualKey;
};
typedef struct MenuItemDataRec MenuItemDataRec;
typedef MenuItemDataRec * MenuItemDataPtr;

/*MenuItemIndex

Specifies a particular menu item in a menu.

typedef UInt16 MenuItemIndex;
Discussion

The menu item index is one-based, so item 1 is the first menu item, item 2 is the second, and so on. Some functions allow you to pass an index of zero, which specifies the menu itself. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 MenuItemIndex;

/*MenuRef

Defines a menu.

typedef struct OpaqueMenuRef * MenuRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueMenuRef * MenuRef;

/*MenuCommand

Specifies a menu item’s command ID.

typedef UInt32 MenuCommand;
Availability
Available in Mac OS X v10.0 and later.*/

typedef UInt32 MenuCommand;


/*Menu Item Attribute Constants

Specify attributes for menu items. 

typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12)
   kMenuItemAttrAutoDisable = (1 << 13)
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};
Constants
kMenuItemAttrDisabled

This menu item is disabled.

Available in Mac OS X v10.0 and later.
kMenuItemAttrIconDisabled

This menu item’s icon is disabled. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSubmenuParentChoosable

The user can select the parent item of a submenu. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrDynamic

This menu item changes dynamically based on the state of the modifier keys. For example, holding down the command key might change the menu item from “Select widget” to “Select all widgets.”

When a menu item has alternate dynamic states, you should group them together sequentially in the menu and assign them the same command key. A collection of menu item alternates is called a dynamic group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrNotPreviousAlternate

This item is not part of the same dynamic group as the previous item. The Menu Manager determines which menu items belong to a dynamic group by examining the command keys of each item; if a menu item has the same command key as the previous item, the Menu Manager considers it to be part of the same dynamic group. 

However, in some cases you may have sequential items with the same command key (or no command key at all) that should not be considered part of the same dynamic group. To distinguish the separation, you should set this flag for the first menu item in the new group. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrHidden

The menu item is not drawn when displaying the menu. The item is also not included in command-key matching unless the kMenuItemAttrDynamic or kMenuItemIncludeInCmdKeyMatching attribute is set. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSeparator

The menu item is a separator; any text in the item is ignored. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrSectionHeader

The menu item is a menu section header; this item is disabled and not selectable. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrIgnoreMeta

Ignore the dash (-) metacharacter in this menu item. Dashes at the beginning of a menu item title traditionally signify that the menu item is a separator. However, in some cases you might want to display the dash in the title (for example, if you wanted the menu item to read “-40 degrees F.”)

Available in Mac OS X v10.0 and later.
kMenuItemAttrAutoRepeat

The IsMenuKeyEvent event function recognizes this menu item when it receives an autorepeat keyboard event. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrUseVirtualKey

When MenuEvent and IsMenuKeyEvent compare this menu item’s keyboard equivalent against a keyboard event, they use the item’s virtual keycode equivalent rather than its character code equivalent. 

Available in Mac OS X v10.0 and later.
kMenuItemAttrCustomDraw

This is a custom menu item. Setting this attribute causes custom menu item drawing Carbon events to be sent to your application. Available in CarbonLib 1.4 and Mac OS X v10.1 and later. 

Available in Mac OS X v10.1 and later.
kMenuItemAttrIncludeInCmdKeyMatching

If this attribute is set, functions such as MenuKey, MenuEvent and IsMenuKeyEvent examine this menu item during command key matching. Typically, visible items are examined and hidden items (unless they have the kMenuItemAttrDynamic attribute set) are ignored during command key matching. However, by setting this attribute, you can force hidden items to be included in the matching. Available in CarbonLib 1.6 and Mac OS X v10.2 and later. 

Available in Mac OS X v10.2 and later.
kMenuItemAttrAutoDisable

Disables the menu item if it does not respond to the kEventCommandUpdateStatus event . That is, if no kEventCommandUpdateStatus handler is installed on this item, or if all the handlers installed for the update event return eventNotHandledErr, this item is automatically disabled. This attribute is useful if your application uses the kEventCommandUpdateStatus event to enable menu items; for example you no longer have to install an update status handler on the application target to disable menu items when there are no document windows open. 

Available in Mac OS X v10.3 and later.
kMenuItemAttrUpdateSingleItem

Update only the menu item that matches when searching available command keys. Normally when the Menu Manager does command key matching, it sends a kEventMenuEnableItems event to the menu containing the matching item and then sends a kEventCommandUpdateStatus to each item in the menu. Doing so can be inefficient, since in most cases only the item that matches needs to be updated. By setting this attribute, only the matching item receives the update event and kEventMenuEnableItems is not sent to the menu. If your application enables menu items solely through kEventCommandUpdateStatus event handlers, you should set this attribute for your menu items.

Available in Mac OS X v10.3 and later.
Discussion

Menu item attributes control behavior of individual menu items. They are used with the GetMenuItemAttributes and ChangeMenuItemAttributes APIs.*/
typedef UInt32 MenuItemAttributes;
enum {
   kMenuItemAttrDisabled = (1 << 0),
   kMenuItemAttrIconDisabled = (1 << 1),
   kMenuItemAttrSubmenuParentChoosable = (1 << 2),
   kMenuItemAttrDynamic = (1 << 3),
   kMenuItemAttrNotPreviousAlternate = (1 << 4),
   kMenuItemAttrHidden = (1 << 5),
   kMenuItemAttrSeparator = (1 << 6),
   kMenuItemAttrSectionHeader = (1 << 7),
   kMenuItemAttrIgnoreMeta = (1 << 8),
   kMenuItemAttrAutoRepeat = (1 << 9),
   kMenuItemAttrUseVirtualKey = (1 << 10),
   kMenuItemAttrCustomDraw = (1 << 11),
   kMenuItemAttrIncludeInCmdKeyMatching = (1 << 12),
   kMenuItemAttrAutoDisable = (1 << 13),
   kMenuItemAttrUpdateSingleItem = (1 << 14)
};

/*MenuTrackingData

Contains information about the menu currently being displayed during menu tracking.

struct MenuTrackingData {
   MenuRef menu;
   MenuItemIndex itemSelected;
   MenuItemIndex itemUnderMouse;
   Rect itemRect;
   SInt32 virtualMenuTop;
   SInt32 virtualMenuBottom;
};
typedef struct MenuTrackingData MenuTrackingData;
typedef MenuTrackingData * MenuTrackingDataPtr;
Fields
menu

The menu. 
itemSelected

The index of the menu item that is currently selected. This field should either match the itemUnderMouse field, or should be zero if the item under the mouse cannot be selected (for example, if the item is disabled). 
itemUnderMouse

The index of the menu item that is currently under the mouse. 
itemRect

The Rect that defines the area of the menu item currently under the mouse. Note that the itemRect field is not supported in CarbonLib and is always set to be empty. It is, however, supported in Mac OS X. 
virtualMenuTop

The y-coordinate of the actual top of the menu. Because the user can scroll the menu, the menu top coordinate may be above the top of the visible screen (in which case it has a negative value).
virtualMenuBottom

The y-coordinate of the actual bottom of the menu. Because the user can scroll the menu, the menu bottom coordinate may be below the bottom of the visible screen 
Discussion

You can call GetMenuTrackingData to obtain this structure during menu tracking. 
Availability
Available in Mac OS X v10.0 and later.*/

struct MenuTrackingData {
   MenuRef menu;
   MenuItemIndex itemSelected;
   MenuItemIndex itemUnderMouse;
   Rect itemRect;
   SInt32 virtualMenuTop;
   SInt32 virtualMenuBottom;
};
typedef struct MenuTrackingData MenuTrackingData;
typedef MenuTrackingData * MenuTrackingDataPtr;


/*MDEFHiliteItemData

Contains information about which menu items should be highlighted and unhighlighted as the user moves through the menus. .

struct MDEFHiliteItemData {
   MenuItemIndex previousItem;
   MenuItemIndex newItem;
   void * context;
};
typedef struct MDEFHiliteItemData MDEFHiliteItemData;
typedef MDEFHiliteItemData * MDEFHiliteItemDataPtr;
typedef MDEFHiliteItemData HiliteMenuItemData;
typedef MDEFHiliteItemDataPtr HiliteMenuItemDataPtr;
Fields
previousItem

The menu item that was previously selected. This item needs to be redrawn in an unhighlighted state. This parameter can be zero if no item was previously selected. 
newItem

The menu item that is now selected. This item needs to be redrawn in a highlighted state. This parameter can be zero if no item is currently highlighted. 
context

The Core Graphics context the menu definition should draw into. The Menu Manager flushes the context after the menu definition returns. 
Discussion

This structure is used by menu definition functions, which receive a pointer to an MDEFHiliteItemData structure as the whichItem parameter during the kMenuHiliteItemMsg message. 
Availability
Available in Mac OS X v10.0 and later.*/
struct MDEFHiliteItemData {
   MenuItemIndex previousItem;
   MenuItemIndex newItem;
   void * context;
};
typedef struct MDEFHiliteItemData MDEFHiliteItemData;
typedef MDEFHiliteItemData * MDEFHiliteItemDataPtr;
typedef MDEFHiliteItemData HiliteMenuItemData;
typedef MDEFHiliteItemDataPtr HiliteMenuItemDataPtr;

/*MDEFDrawData

Contains information needed to draw a menu.

struct MDEFDrawData {
   MenuTrackingData trackingData;
   void * context;
};
typedef struct MDEFDrawData MDEFDrawData;
typedef MDEFDrawData * MDEFDrawDataPtr;
Fields
trackingData

A data structure containing information about the menu to be drawn. Your menu definition should fill in the virtualMenuTop and virtualMenuBottom fields of this structure while drawing the menu. 
context

The Core Graphics context that your menu definition should draw into. The Menu Manager flushes the context after returning from the menu definition.
Discussion

The Menu Manager passes this structure to your custom menu definition in the whichItem parameter of the kMenuDrawMsg message. 
Availability
Available in Mac OS X v10.1 and later.*/
struct MDEFDrawData {
   MenuTrackingData trackingData;
   void * context;
};
typedef struct MDEFDrawData MDEFDrawData;
typedef MDEFDrawData * MDEFDrawDataPtr;

/*MDEFFindItemData

Contains information used to determine which item the user has currently selected.

struct MDEFFindItemData {
   MenuTrackingData trackingData;
   void * context;
};
typedef struct MDEFFindItemData MDEFFindItemData;
typedef MDEFFindItemData * MDEFFindItemDataPtr;
Fields
trackingData

A data structure containing information about the menu to be drawn. Your menu definition should fill in the itemSelected , ItemUnderMouseand itemRect fields of this structure after determining which item is under the specified point. 
context

The Core Graphics context the menu definition should draw into if it needs to scroll the menu during the kMenuFindItemMsg message. The Menu Manager flushes the context after the menu definition returns. 
Discussion

The Menu Manager passes this structure to your custom menu definition in the whichItem parameter of the kMenuFindItemsMsg message.
Availability
Available in Mac OS X v10.1 and later.*/
struct MDEFFindItemData {
   MenuTrackingData trackingData;
   void * context;
};
typedef struct MDEFFindItemData MDEFFindItemData;
typedef MDEFFindItemData * MDEFFindItemDataPtr;

/*MenuDefProcPtr

Defines a pointer to a custom menu definition callback function. Your menu definition callback function draws the menu items in the menu, determines which item the user chose from the menu, and calculates the menu’s dimensions.

Not recommended

typedef void (*MenuDefProcPtr) (
   SInt16 message,
   MenuRef theMenu,
   Rect *menuRect,
   Point hitPt,
   SInt16 *whichItem
);

If you name your function MyMenuDefProc, you would declare it like this:

void *MyMenuDefProc (
   SInt16 message,
   MenuRef theMenu,
   Rect *menuRect,
   Point hitPt,
   SInt16 *whichItem
);
Parameters
message

A constant that identifies the operation the menu definition function should perform; see “Custom Menu Definition Message Constants” and “Obsolete Menu Definition Messages” for a description of the messages that your menu definition function can receive. Your menu definition function should not respond to any value other than these defined messages. Other messages are reserved for internal use by Apple Computer, Inc. 
theMenu

The menu that the operation should affect. This menu reference may refer to a regular menu or a popup menu. 
menuRect

A pointer to the rectangle (in global coordinates) in which the menu is located. 
hitPt

A mouse location (in global coordinates). The Menu Manager provides information in this parameter to the menu definition function when the kMenuFindItemsMsg or kMenuPopUpMsg messages are sent. 
whichItem

A pointer to a value that specifies the item number of the menu item to act upon, or a pointer to a data structure related to one or more menu items. The data pointed to depends on the message sent; see the discussion for specifics.
Discussion

Carbon does not let you store menu definitions as resources. If you need to upgrade legacy code, see the Carbon Porting Guide for information about converting your resource-based definitions. See the Carbon Porting Notes for this callback for additional information about changes to older messages and access to low-memory global data. 

On Mac OS X v10.3 and later, all standard menus are implemented as HIViews, and custom menus can be implemnented as custom HIViews. If you want to create custom menu definitions, you should subclass the HIMenuView class. See Introducing HIView in Carbon User Experience documentation for more information. 

When you define your menus, you specify the menu definition function the Menu Manager should use when managing them. You’ll usually want to use the standard menu definition function for your application. However, if you need a feature not provided by the standard menu definition function (for example, if you want to include more graphics in your menus), you can choose to write your own menu definition function. 

The menu definition function is responsible for drawing the contents of the menu and its menu items, determining whether the cursor is in a displayed menu, highlighting and unhighlighting menu items, and calculating a menu’s dimensions. To create an instance of your custom menu, call the CreateCustomMenu function. 

The Menu Manager calls your menu definition function whenever it needs your definition function to perform a certain action on a specific menu. The action your menu definition function should perform depends on the value of the message parameter. When the Menu Manager requests your menu definition function to perform an action on a menu, it provides your function with the appropriate menu reference. This allows your function to access the data in the menu structure and to use any data in the variable data portion of the menu structure to appropriately handle the menu items.

Your menu definition function should support the following messages:
kMenuInitMsg

The Menu Manager sends this message when creating a menu to give your menu definition a chance to perform any required initialization. If an error occurs during initialization, your menu definition should return a nonzero error code in the *whichItem parameter. This error is then returned by the function used to create the menu. 
kMenuDisposeMsg

Sent when a menu is destroyed. The Menu Manager sends this message to give your menu definition a chance to release or dispose of any related data.
kMenuFindItemMsg

Sent when the Menu Manager is displaying a menu and needs to know what item is under the mouse. 

The whichItem parameter points to a MenuTrackingData structure. On entry, the menu, virtualMenuTop, and virtualMenuBottom fields of this structure are valid. Your menu definition should determine which item, if any, contains the point passed to you in the hitPt parameter and fill in the itemUnderMouse, itemSelected, and itemRect fields. If an item is found, the menu definition should always fill in the itemUnderMouse and itemRect fields. The menu definition should only fill in the itemSelected field if the item is available for selection; if it is unavailable (because it is disabled, or for some other reason), the menu definition should set the itemSelected field to zero.

The index values placed in the itemUnderMouse and itemSelected fields should be less than or equal to the number of items returned by CountMenuItems on this menu. These values should also be identical if both are nonzero. The itemUnderMouse field should always be nonzero if the mouse is actually over an item.

The menu definition should not highlight the found item in response to this message, as the Menu Manager will send a separate kMenuHiliteItemMsg to request highlighting of the item.

If the menu definition supports scrolling, it should scroll the menu during this message, and update the virtualMenuTop and virtualMenuBottom fields of the MenuTrackingData to indicate the menu's new scrolled position.

If the menu definition uses QuickDraw to draw while scrolling, it should draw into the current port.

If the menu definition uses CoreGraphics to draw while scrolling, it should use the CGContextRef passed in the context field of the MDEFHiliteItemData structure. Menu definitions must use the ScrollMenuImage function, if available, to scroll the menu contents. (This function is available in CarbonLib 1.5 and later, and in Mac OS X 10.1 and later.) ScrollMenuImage properly supports scrolling the alpha channel in the menu's image data. Use of the QuickDraw function ScrollRect to scroll the menu contents will result in the alpha channel being set to 0xFF (opaque) and the menu will no longer be translucent.

The menu definition should not modify the menu field of the MenuTrackingData structure.
kMenuHiliteItemMsg

Sent when the Menu Manager is displaying a menu and needs to highlight a newly selected item. 

The whichItem parameter points to a MDEFHiliteItemData structure. The menu definition should unhighlight the item in the previousItem field, if non-zero, and highlight the item in the newItem field.

If the menu definition is using the Appearance Manager's menu drawing APIs, you should use the EraseMenuBackground function to erase the old menu contents before unhighlighting a menu item. This is necessary because the background of a menu is translucent in Aqua, and if the old highlight is not erased first, it will show through the new unhighlighted menu background.

If the menu definition uses QuickDraw to draw, it should draw into the current port. If it uses CoreGraphics to draw, it should use the CGContextRef passed in the context field of the MDEFHiliteItemData structure. 
kMenuDrawItemsMsg

Sent when the Menu Manager is displaying a menu and needs to redraw a portion of the menu. This message is used by the dynamic menu item support code in the Menu Manager; for example, if items five and six in a menu are a dynamic group, the Menu Manager will send a kMenuDrawItemsMsg message when the group's modifier key is pressed or released to redraw the appropriate item, but no other items in the menu.

The whichItem parameter for this message points to an MDEFDrawItemsData structure. The menu definition should redraw the items starting with firstItem and ending with lastItem, inclusive.

If the menu definition uses QuickDraw to draw, it should draw into the current port. If it uses CoreGraphics to draw, it should use the CGContextRef passed in the context field of the MDEFHiliteItemData structure.
kMenuDrawMsg

Sent when the Menu Manager is displaying a menu and needs to redraw the entire menu. 

The whichItem parameter is actually a pointer to a MenuTrackingData structure. On entry, the menu field of this structure is valid. The menu definition should draw the menu and, if it supports scrolling, should also fill in the virtualMenuTop and virtualMenuBottom fields of the structure to indicate the menu's initial unscrolled position; typically, virtualMenuTop would be set to the same value as the top coordinate of the menu bounds, and virtualMenuBottom would be set to virtualMenuTop plus the virtual height of the menu.

If the menu definition uses QuickDraw to draw, it should draw into the current port. If it uses CoreGraphics to draw, it should use the CGContextRef passed in the context field of the MDEFHiliteItemData structure.
kMenuSizeMsg

Sent when the Menu Manager needs to determine the size of a menu. 

The menu definition should calculate the width and height of the menu and store the sizes into the menu with SetMenuWidth and SetMenuHeight. If the gestaltMenuMgrSendsMenuBoundsToDefProc bit is set in the Menu Manager's Gestalt value, then the hitPt parameter sent with this message is the maximum width (hitPt.h) and height (hitPt.v) of the menu. The menu definition should ensure that the width and height that it places in the menu do not exceed these values. If the gestalt bit is not set, the menu definition should just use the main display device’s (GDevice) width and height as constraints on the menu's width and height.
kMenuPopUpMsg

Sent when the Menu Manager is about to display a popup menu. The Menu Manager uses the menu definition function to support pop-up menus that are not implemented as controls. If your menu definition function supports pop-up menus, it should respond appropriately to the kMenuPopUpMsg message.

The menu definition should calculate the appropriate menu bounds to contain the menu based on the requested menu location and selected item. It should write the menu’s bounds into the Rect structure passed by the menuRect parameter. If the gestaltMenuMgrSendsMenuBoundsToDefProc bit is set in the Menu Manager's Gestalt value, then the menuRect parameter on entry to this message contains a constraint rectangle, in global coordinates, outside of which the popup menu should not be positioned. The menu definition should take these constraint bounds into account as it calculates the menu bounds. If the gestalt bit is not set, the menu definition should use the bounds of the display device (GDevice) containing the menu's top left corner as a constraint on the menu's position. 

The hitPt parameter is the requested location for the top left corner of the menu. The coordinates of this parameter are swapped from their normal order; hitPt.h contains the vertical coordinate and hitPt.v contains the horizontal coordinate. 

On entry, the whichItem parameter points at a menu item index which is requested to be the initial selection when the menu is displayed. After calculating the menu's bounds, the menu definition should write the menu's virtual top coordinate into the location pointed at by the whichItem parameter. If displaying the menu at the requested location does not require scrolling, the virtual top will be the same as the menu bounds top; if the menu must scroll to fit in the requested location, the virtual top may be different.
kMenuCalcItemMsg

Sent when the Menu Manager needs to know the bounds of a menu item. 

The menu definition should calculate the size of the menu item specified by the whichItem parameter and store the bounds in the Rect structure specified by the menuRect parameter. Some sample menu definition code provided by Apple has previously shown an implementation of this message that always sets the top left corner of the item bounds to (0,0), regardless of the item's actual position in the menu. For best future compatibility, menu definitions should begin storing an item bounds that gives the item's actual position in the menu based on the menu's current virtual top. For example, if the virtual menu top starts at 20, then the menu definition would calculate an item bounds for the first item that starts at (0,20), an item bounds for the second item that starts at (0,40), and so on. The menu definition should call GetMenuTrackingDatato get the menu's current virtual position, and use zero for the menu top if GetMenuTrackingData returns an error.
kMenuThemeSavvyMsg

Sent by the Menu Manager to determine whether the menu definition uses the Appearance Manager menu-drawing functions to draw its menu. If it does, the menu definition should return kThemeSavvyMenuResponse in the location pointed to by whichItem. If the menu definition draws its own custom content without using the Appearance Manager menu-drawing functions, it should ignore this message.

The Menu Manager defines the data type MenuDefUPP to identify the universal procedure pointer for an application-defined menu definition function:

typedef UniversalProcPtr MenuDefUPP; 

You typically use the NewMenuDefProc function like this:

MenuDefUPP myMenuDefProc; 

myMenuDefProc = NewMenuDefProc(MyMenu); 
Carbon Porting Notes

Prior to Carbon, menu definitions needed to use several low-memory globals to communicate with the Menu Manager. These globals have all been replaced or made obsolete in Carbon, as follows:
MenuDisable 

MenuDisable is now set automatically by the Menu Manager using the value returned in the itemUnderMouse field of the MenuTrackingData structure passed to kMenuFindItemMsg.
TopMenuItem, AtMenuBottom

TopMenuItem and AtMenuBottom are now set automatically by the Menu Manager using the values returned in the virtualMenuTop and virtualMenuBottom fields of the MenuTrackingData structure passed to kMenuDrawMsg and kMenuFindItemMsg.
mbSaveLoc

This undocumented low-memory global was used by older menu definitions to store the bounding rect of the currently selected item and to avoid drawing glitches while the menu definition was scrolling the contents of a menu that had submenus. The Menu Manager now automatically sets the selected item bounds using the value returned in the itemRect field of the MenuTrackingData structure passed to kMenuFindItemMsg. In order to correctly support scrolling of menus with submenus, a menu definition should verify, before scrolling the menu contents, that no submenus of the scrolling menu are currently visible. A menu definition can use GetMenuTrackingData to verify this condition, as follows:Boolean SafeToScroll( MenuRef menuBeingScrolled )
 {
        MenuTrackingData lastMenuData;
        return GetMenuTrackingData( NULL, &lastMenuData ) ==  noErr
                           && lastMenuData.menu == menuBeingScrolled;
    }

If SafeToScroll returns false, the menu definition should not scroll the menu.*/


typedef void (*MenuDefProcPtr) (
   SInt16 message,
   MenuRef theMenu,
   Rect *menuRect,
   Point hitPt,
   SInt16 *whichItem
);


/*MenuDefUPP

Defines a universal procedure pointer to a menu definition function. 

Not recommended

typedef MenuDefProcPtr MenuDefUPP;
Discussion

For more information, see the description of the MenuDefProcPtr callback.
Version Notes

In Mac OS X 10.3 and later, you should use HIView-based menu definitions instead.*/
typedef MenuDefProcPtr MenuDefUPP;



/*MenuDefSpec

Defines the type of menu definition.

struct MenuDefSpec {
   MenuDefType defType
   union {
      MenuDefUPP defProc;
      struct {
         CFStringRef classID;
         EventRef initEvent;
      } view;
   } u;
};
typedef struct MenuDefSpec MenuDefSpec;
typedef MenuDefSpec * MenuDefSpecPtr;
Fields
defType

The type of menu definition. See “Menu Definition Type Constants” for a list of possible values. 
u.defproc

If the defType field is kMenuDefProcPtr, the menu definition is a older procedure pointer–based definition. This field then contains a UPP to the menu definition function. 
u.view.classID

If the defType field is kMenuDefClassID, the menu definition is HIView–based. This field then contains the ID of the HIView subclass that defines this menu. 
u.view.initEvent

If the defType field is kMenuDefClassID, the menu definition is HIView–based. This field then contains the initialization event for the HIView subclass if one exists. Otherwise, it is NULL.
Version Notes

HIView-based menu definitions are available in Mac OS X 10.3 and later. 
Availability
Available in Mac OS X v10.0 and later.*/
struct MenuDefSpec {
   MenuDefType defType;
   union {
      MenuDefUPP defProc;
      struct {
         CFStringRef classID;
         EventRef initEvent;
      } view;
   } u;
};
typedef struct MenuDefSpec MenuDefSpec;
typedef MenuDefSpec * MenuDefSpecPtr;

#include <APPLE/HIToolbox/Menus_E.h>

//functions


/*EnableMenuCommand

Enables the menu item with a specified command ID.

void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be enabled. If more than one item has this command ID, only the first will be enabled. 
Discussion

If you have access to the menu item index, in most cases you should use EnableMenuItem instead, as that function is faster and requires no searching. For example, when receiving a kEventCommandUpdateStatus event, the HICommand structure contains both the menu item’s command ID and index. If you wanted to enable the menu item, you should call EnableMenuItem.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);

/*DeleteMenuItem

Deletes an item from a menu. 

void DeleteMenuItem (
   MenuRef theMenu,
   short item
);
Parameters
theMenu

The menu from which you want to delete the menu item. 
item

The item number of the menu item to delete. If you specify 0 or a number greater than the last item in the menu, DeleteMenuItem does not delete any item from the menu. 
Discussion

The DeleteMenuItem function deletes a specified menu item from a menu. You should not delete items from an existing menu unless the user expects the menu (such as a menu that lists open documents) to change. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DeleteMenuItem (
   MenuRef theMenu,
   short item
);

/*AppendMenuItemTextWithCFString

Appends a new menu item with text from a CFString.

OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);
Parameters
menu

The menu to which to append the new item. 
inString

The text of the new item. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
outNewItem

On exit, the index of the new item. May be NULL if the caller does not need this information. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The Menu Manager will make its own copy of the CFString before returning from this function. Modifying the string after calling AppendMenuItemTextWithCFString will have no effect on the menu item's actual text. The caller may release the string after the call.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus AppendMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID,
   MenuItemIndex * outNewItem
);

/*CopyMenuItemTextAsCFString

Returns a CFString containing the text of a menu item.

OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);
Parameters
menu

The menu containing the item. 
item

The item whose text you want to copy. 
outString

On exit, a CFString containing the item's text. The caller must release this string when it is no longer needed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemTextAsCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef * outString
);

/*DisableMenuItem

Disables a menu item or a menu.

void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be disabled. 
item

The index of the menu item that you wish to disable. Pass 0 to specify the menu title (disabling the entire menu). 
Discussion

The DisableMenuItem function disables a menu item (and any associated icon) so that the user cannot choose the item from the menu. 

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the EnableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Note that the implementation of Carbon on Mac OS 8.1 only supports disabling menu items less than or equal to 31.
Declared In
Menus.h*/
void DisableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);

/*EnableMenuItem

Enables a menu item or a menu.

void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the item to be enabled. 
item

The item number of the menu item that you wish to enable. If you pass 0, EnableMenuItem enables the menu title and all items in the menu that were not previously individually disabled. 
Discussion

The EnableMenuItem function enables a menu item so that the user can choose the item from the menu. If the menu item has an associated icon, that icon is also enabled, unless the icon was previously individually disabled with the function DisableMenuItemIcon.

Note that EnableMenuItem calls the InvalMenuBar function to update the menu bar the next time through the event loop.

See also the DisableMenuItem and IsMenuItemEnabled functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void EnableMenuItem (
   MenuRef theMenu,
   MenuItemIndex item
);

/*SetMenuBar

Sets the current menu list to a specified menu list.

void SetMenuBar (
   MenuBarHandle mbar
);
Parameters
mbar

A handle to a menu list that specifies the menus for a menu bar. You should specify a handle returned by GetMenuBar or GetNewMBar. 
Discussion

The SetMenuBar function copies the given menu list to the current menu list. As with GetMenuBar , SetMenuBar doesn’t copy the menu structures, just the menu list (which contains handles to the menu structures).

You can use SetMenuBar to restore a menu list that you previously saved using GetMenuBar or to set the current menu list to a menu list created from a nib file or from GetNewMBar. 

The SetMenuBar function sets the current menu list and calls InvalMenuBar so the menu bar can be updated the next time through the event loop; if you want to redraw the menu bar immediately, call the DrawMenuBar function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void SetMenuBar (
   MenuBarHandle mbar
);

/*CountMenuItems

Obtains the number of menu items in a menu

UInt16 CountMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to count. 
Return Value

The number of menu items in the menu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
UInt16 CountMenuItems (
   MenuRef theMenu
);

/*ReleaseMenu

Decrements the retain count of a menu.

OSStatus ReleaseMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to DisposeMenu.
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRelease instead of ReleaseMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ReleaseMenu (
   MenuRef inMenu
);

/*CreateNewMenu

Creates a new, untitled, empty menu.

OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inMenuID

The menu ID to use for the new menu. Note that zero is a valid ID in Carbon. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to create new menus on-the-fly, you should not use functions like CreateNewMenu that create menus programmatically. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

CreateNewMenu is preferred over NewMenu because it allows you to specify the menu's attributes and it does not require you to specify a Str255-based menu title. To set the menu title, you should use SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateNewMenu (
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);

/*RetainMenu

Increments the reference count of a menu.

OSStatus RetainMenu (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose reference count you want to increment. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

RetainMenu does not create a new menu. It simply adds one to the reference count. 
Version Notes

In Mac OS X v10.2 and later, all menus are Core Foundation CFTypes, so you can optionally call CFRetain instead of RetainMenu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus RetainMenu (
   MenuRef inMenu
);

/*SetMenuItemIconHandle

Sets a menu item’s icon.

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set an icon. 
inItem

The menu index of the item. 
inIconType

Pass a value representing the type of icon ('ICON', 'cicn', 'SICN', icon suite, or IconRef) you wish to attach; see “Menu Item Icon Type Constants” for descriptions of possible values. 
inIconHandle

Pass a handle to the icon you wish to attach to a menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemIconHandle function sets the icon of a menu item with an icon handle instead of a resource ID. SetMenuItemIconHandle allows you to set icons of type 'ICON', 'cicn', 'SICN', IconRef, CGImageRef, as well as icon suites. To set resource-based icons for a menu item, call SetItemIcon. 

With the exception of types IconRef and CGImageRef,disposing of the menu will not dispose of the icon handles set by this function. The Menu Manager retains IconRef, CGImageRef icons and releases them when the menu is disposed or the menu item is removed. For all other icon types, your application should dispose of the icons when you dispose of the menu, to prevent memory leaks.

See also the function GetMenuItemIconHandle. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr SetMenuItemIconHandle (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inIconType,
   Handle inIconHandle
);

/*SetMenuItemProperty

Associates data with a menu item.

OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);
Parameters
menu

The menu containing the item with which you wish to associate data. 
item

The index number of the menu item or 0 if the data is to be associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature, as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code that identifies the property to set. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data, but may coincide if you wish.
propertySize

The size of the data. 
propertyData

A pointer to the data. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the SetMenuItemProperty function to associate arbitrary data, tagged with an identifying code, with a menu item.

See also the GetMenuItemProperty and RemoveMenuItemProperty functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 propertySize,
   const void * propertyData
);

/*GetIndMenuItemWithCommandID

Finds a menu item with a specified command ID.

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);
Parameters
inMenu

The menu in which to begin searching for items with the specified command ID. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID for which to search. 
inItemIndex

The 1-based index of the menu item to retrieve. In CarbonLib 1.0.x, this parameter must be 1. In CarbonLib 1.1 and Mac OS X 1.0, this parameter may vary from 1 to the number of menu items with the specified command ID. 
outMenu

On exit, the menu containing the menu item with the specified command ID.
outIndex

On exit, the item index of the menu item with the specified command ID. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

This API searches the specified menu and its submenus for the n'th menu item with the specified command ID. You often want to use this function in conjunction with CountMenuItemsWithCommandID.
Version Notes

In CarbonLib 1.1 and earlier, only the first menu item will be returned. In CarbonLib 1.2 and Mac OS X v10.0 and later, this API will iterate over all menu items with the specified command ID and return the itemIndex’th one. 

In Mac OS X v10.0 and CarbonLib 1.0 through 1.4, this function searches only top-level menus (that is, those that are visible in the menu bar) and submenus of top-level menus. It does not search hierarchical menus that are in the menu bar but are not submenus of a top-level menu. For example, it does not search menus that are inserted for use in a popup menu. In Mac OS X v10.1 and later, and CarbonLib 1.5 and later, this function also searches hierarchical menus. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus GetIndMenuItemWithCommandID (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UInt32 inItemIndex,
   MenuRef * outMenu,
   MenuItemIndex * outIndex
);

/*GetMenuItemProperty

Obtains a piece of data that has been previously associated with a menu item.

OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
menu

The menu containing the item to be examined for associated data. 
item

The index number of the menu item or 0 if the data is associated with the menu as a whole. 
propertyCreator

A four-character code. Pass your program’s signature (also called a creator), as registered through Apple Developer Technical Support. If your program is of a type that would not normally have a signature (for example, a plug-in), you should still register and use a signature in this case, even though your program’s file may not have the same creator code as the signature that you register. The 'macs' property signature is reserved for the system and may not be used. 
propertyTag

A four-character code. Pass the application-defined code identifying the data.
bufferSize

The size of the data to be obtained. If this is unknown, use the function GetMenuItemPropertySize to get the data’s size. If the size specified in the bufferSize parameter does not match the actual size of the property, GetMenuItemProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the actual size of the associated data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You may use the function GetMenuItemProperty to obtain a copy of data previously set with the function SetMenuItemProperty.

See also the RemoveMenuItemProperty function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemProperty (
   MenuRef menu,
   MenuItemIndex item,
   OSType propertyCreator,
   OSType propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);

/*SetMenuCommandMark

Locates the menu item with a specified command ID and sets its mark character.

OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);
Parameters
inMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
inCommandID

The command ID of the menu item to be modified. If more than one item has this command ID, only the first will be modified. 
inMark

The new mark character. While this is a Unicode character, only the low byte is currently used as the mark character, and it is interpreted using the application text encoding. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If you have access to the menu item index, in most cases you should use SetItemMark instead, as that function is faster and requires no searching.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuCommandMark (
   MenuRef inMenu,
   MenuCommand inCommandID,
   UniChar inMark
);

/*DrawMenuBar

Draws the menu bar based on the current menu list.

void DrawMenuBar ();
Discussion

The DrawMenuBar function draws (or redraws) the menu bar according to the current menu list. Note that most Menu Manager calls that affect the menu bar call InvalMenuBar so that the menu bar is redrawn the next time through the event loop; however, you can call DrawMenuBar if you want the changes to appear immediately. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DrawMenuBar ();

/*InsertMenu

Inserts an existing menu into the current menu list. 

void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);
Parameters
theMenu

The menu to insert. 
beforeID

An integer that indicates where in the current menu list the menu should be inserted. InsertMenu inserts the menu into the current menu list before the menu whose menu ID is specified in the beforeID parameter. If the number in the beforeID parameter is 0 (or it isn’t the ID of any menu in the menu list), InsertMenu adds the new menu after all others (except before the Help menu). If the menu is already in the current menu list or the menu list is already full, InsertMenu does nothing. 

To insert a submenu into the current menu list, specify –1 or the equivalent constant kInsertHierarchicalMenu for the beforeID parameter. The submenus in the submenu portion of the menu list do not have to be currently associated with a hierarchical menu item; you can store submenus in the menu list and later specify that a menu item has a submenu if needed. However, note that during command key matching the Menu Manager scans all menus in the menu list for modifiers, including submenus that are not associated with any menu item. 

You can also specify –1 for the beforeID parameter to insert a pop-up menu into the current menu list. However, if you use the standard pop-up control definition function, the pop-up control automatically inserts the menu into the current menu list according to the needs of the pop-up control.

Discussion

Menus inserted using this function are added to a menu list attached to the current root menu. To obtain or set this root menu, call AcquireRootMenu and SetRootMenu respectively. 

Inserting a menu in the root menu (menu bar) increments its reference count; removing the menu decrements its reference count. 


To change a menu title, call SetMenuItemTextWithCFString. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenu (
   MenuRef theMenu,
   MenuID beforeID
);


/*SetMenuItemCommandID

Sets a menu item’s command ID. 

OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);
Parameters
inMenu

The menu that contains the menu item whose command ID you want to set. 
inItem

The menu index of the item. 
inCommandID

An integer representing the command ID that you wish to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use a menu item’s command ID as a position-independent method of signalling a specific action in an application. See Carbon Event Manager Programming Guide for more information about command IDs. 

Note that Apple reserves all command IDs that contain all lowercase letters; your application is free to use any command ID containing uppercase characters.

See also the function GetMenuItemCommandID. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemCommandID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuCommand inCommandID
);

/*GetMenuHandle

Obtains a menu reference corresponding to a menu ID. 

MenuRef GetMenuHandle (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose reference you want to obtain. (Note that this is not the resource ID, although you often assign the menu ID so that it matches the resource ID.) You assign a menu ID in a nib file or in the 'MENU' resource of a menu. If you do not define your menus in nib files or in ‘MENU’' resources, you can assign a menu ID using NewMenu or SetMenuID. 
Return Value

The menu corresponding to the specified ID. If the specified menu is not in the current menu list, GetMenuHandle returns NULL. See the description of the MenuRef data type.
Discussion

You can also call this function as GetMenuRef (menuID);.

Use the GetMenuHandle function to obtain the menu reference for any of your application’s pull-down menus or submenus in the current menu list, other than the Help menu. You can also use the Help Manager function HMGetHelpMenuHandle to get a handle for your application’s Help menu. 
Special Considerations

To get a menu reference for a pop-up menu that you create using the pop-up control definition function, call the Control Manager functions GetControlData and GetControlDataSize, passing the tag constant kControlPopupButtonMenuRefTag in the tagName parameter to specify the menu reference.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef GetMenuHandle (
   MenuID menuID
);

/*GetNewMBar

Reads in the definition of a menu bar from an 'MBAR' resource. 

Not recommended

MenuBarHandle GetNewMBar (
   short menuBarID
);
Parameters
menuBarID

The resource ID of an 'MBAR' resource that specifies the menus for a menu bar. 
Return Value

A handle to the menu list. (If the resource isn’t already in memory, GetNewMBar reads it into memory.) If GetNewMBar can’t read the resource, GetNewMBar returns NULL. See the description of the MenuBarHandle data type.
Discussion

Unless you must support legacy code, you should not use functions like GetNewMBar that rely on menus and menu bars stored as resources. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services functions CreateMenuFromNib , CreateMenuBarFromNib, or SetMenuBarFromNibto create them. 

The GetNewMBar function reads in the definition of a menu bar and its associated menus from an ' MBAR ' resource. The ' MBAR ' resource identifies the order of menus contained in its menu bar. For each menu, it also specifies the menu’s resource ID. The GetNewMBar function reads in each menu from the ' MENU ' resource with the resource ID specified in the ' MBAR ' resource.

The GetNewMBar function creates a menu list for the menu bar defined by the ' MBAR ' resource and returns a handle to the menu list. GetNewMBar uses GetMenu to read in each individual menu.

After reading in menus from an ' MBAR ' resource, use SetMenuBar to make the menu list created by GetNewMBar the current menu list. Then use DrawMenuBar to update the menu bar.

To release the memory occupied by a menu list, use the function DisposeMenuBar 
Special Considerations

The GetNewMBar function first saves the current menu list and then clears the current menu list and your application’s menu color information table. It then creates a new menu list. Before returning a handle to the new menu list, the GetNewMBar function restores the current menu list to the previously saved menu list, but GetNewMBar does not restore the previous menu color information table. To save and then restore your application’s current menu color information table, call the function GetMCInfo before GetNewMBar and call SetMCInfo afterward.

While you supply only the resource ID of an 'MBAR' resource to the GetNewMBar function, your application often needs to use the menu IDs defined in each of your menus’ 'MENU' resources. Most Menu Manager functions require either a menu ID or a handle to a menu structure to perform operations on a specific menu. For menus in the current menu list, you can use the GetMenuHandle function to get the handle to a menu structure for a menu with a given menu ID.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuBarHandle GetNewMBar (
   short menuBarID
);

/*HiliteMenu

Highlights or unhighlights menu titles.

void HiliteMenu (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu whose title should be highlighted. If the menu title of the specified menu is already highlighted, HiliteMenu does nothing. If the menu ID is 0 or the specified menu ID isn’t in the current menu list, HiliteMenu unhighlights whichever menu title is currently highlighted (if any). 
Discussion

The IsMenuKeyEvent, MenuSelect, MenuEvent, and MenuKey functions highlight the title of the menu containing the item chosen by the user. After performing the chosen task, your application should unhighlight the menu title by calling HiliteMenu and passing 0 in the menuID parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void HiliteMenu (
   MenuID menuID
);

/*DisableMenuCommand

Disables the menu item with a specified command ID.

void DisableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);
Parameters
theMenu

The menu in which to begin searching for the item. Pass NULL to begin searching with the root menu. The search will descend into all submenus of this menu. 
commandID

The command ID of the menu item to be disabled. If more than one item has this command ID, only the first will be disabled. 
Discussion

If you have access to the menu item index, in most cases you should use DisableMenuItem instead, as that function is faster and requires no searching. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableMenuCommand (
   MenuRef inMenu,
   MenuCommand inCommandID
);

/*DeleteMenuItems

Deletes multiple menu items.

OSStatus DeleteMenuItems (
   MenuRef inMenu,
   MenuItemIndex inFirstItem,
   ItemCount inNumItems
);
Parameters
inMenu

The menu from which to delete items. 
inFirstItem

The first item to delete. 
inNumItems

The number of items to delete. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call this function rather than calling DeleteMenuItem multiple times.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus DeleteMenuItems (
   MenuRef inMenu,
   MenuItemIndex inFirstItem,
   ItemCount inNumItems
);

/*SetMenuItemTextWithCFString

Sets the text of a menu item to the text contained in a CFString.

OSStatus SetMenuItemTextWithCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef inString
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose text you want to set. 
inString

The CFString containing the new menu item text. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the CFString is mutable, the Menu Manager will make its own copy of the CFString before returning from SetMenuItemTextWithCFString. Modifying the string after calling SetMenuItemTextWithCFString will have no effect on the item's actual text. 

If the CFString is immutable, the Menu Manager increments the reference count of the string before returning. 

The caller may release the string after calling SetMenuItemTextWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemTextWithCFString (
   MenuRef inMenu,
   MenuItemIndex inItem,
   CFStringRef inString
);

/*GetMenuItemHierarchicalMenu

Returns the submenu attached to a menu item.

OSStatus GetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef * outHierMenu
);
Parameters
inMenu

The parent menu. 
inItem

The parent item. 
outHierMenu

On exit, the item's submenu, or NULL if it does not have one.
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

GetMenuItemHierarchicalMenu will return the submenu attached to a menu item regardless of how the submenu was specified. If the submenu was specified by menu ID (using SetItemCmd or SetMenuItemHierarchicalID), GetMenuItemHierarchicalMenu will return the currently installed menu with that ID, if any. The only case where GetMenuItemHierarchicalMenu will fail to return the item's submenu is when the submenu is specified by menu ID, but the submenu is not currently inserted in the menu bar.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuItemHierarchicalMenu (
   MenuRef inMenu,
   MenuItemIndex inItem,
   MenuRef * outHierMenu
);

/*DisableMenuItemIcon

Disables the icon associated with a menu item.

void DisableMenuItemIcon (
   MenuRef theMenu,
   MenuItemIndex item
);
Parameters
theMenu

The menu containing the icon to be disabled. 
item

The index of the menu item containing the icon. 
Discussion

Your application can use the DisableMenuItemIcon function to dim individual menu item icons. The menu item that contains the icon is unaffected by calling DisableMenuItemIcon. That is, if DisableMenuItemIcon disables an enabled menu item’s icon, the menu item itself will remain enabled. Calling DisableMenuItemIcon on the icon of a menu item that is currently disabled will cause the icon to be disabled once the menu item is re-enabled.

See also the functions EnableMenuItemIcon and IsMenuItemIconEnabled. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableMenuItemIcon (
   MenuRef theMenu,
   MenuItemIndex item
);

/*NewMenu

Creates an empty menu with a specified title and menu ID. 

Not recommended

MenuRef NewMenu (
   MenuID menuID,
   ConstStr255Param menuTitle
);
Parameters
menuID

The ID for the menu. The menu ID is a number that identifies the menu. Menu IDs in Carbon can be any value, but Apple recommends that the ID be either zero or positive. A menu ID of zero is a valid ID. IDs of submenus should similarly be zero or a positive value. 
menuTitle

The title of the new menu. Note that in most cases you should store the titles of menus in resources, so that your menu titles can be more easily localized. 
Return Value

A menu reference. If the NewMenu function is unable to create the menu structure, it returns NULL. See the description of the MenuRef data type.
Discussion

Unless you must support legacy code, you should not use functions like NewMenu. If you need to create menus programmatically, you can call CreateNewMenu; otherwise you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them. 

The NewMenu function creates a menu with the specified title, assigns it the specified menu ID, and returns a handle to the menu structure. It sets up the menu structure to use the standard menu definition function (and it reads the standard menu definition function into memory if it isn’t already there). NewMenu does not insert the newly created menu into the current menu list.

After creating a menu with NewMenu, use AppendMenu , InsertMenuItem , AppendResMenu , or InsertResMenu to add menu items to the menu. To add a menu created by NewMenu to the current menu list, use InsertMenu. In Carbon, you do not need to call DrawMenuBar to update the menu bar, as the Menu Manager automatically invalidates andredraws the menu bar.

Menus in a resource must not be purgeable nor should the resource lock bit be set. Do not define a “circular” hierarchical menu—that is, a hierarchical menu in which a submenu has a submenu whose submenu is a hierarchical menu higher in the chain. 
Special Considerations

To release the memory associated with a menu that you created using NewMenu, first call DeleteMenu to remove the menu from the current menu list and to remove any entries for this menu in your application’s menu color information table then call DisposeMenu to dispose of the menu structure. Note that in Carbon, the Menu Manager automatically invalidates and redraws the menu bar after disposing of a menu. 
Version Notes

Note that if you are running on Mac OS 8.1 and earlier, the menu ID of a submenu must be within the range 0 to 255. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef NewMenu (
   MenuID menuID,
   ConstStr255Param menuTitle
);

/*MenuSelect

Allows the user to choose a menu item from a menu in the menu bar.

long MenuSelect (
   Point startPt
);
Parameters
startPt

The location of the cursor at the time the mouse button was first pressed, in global coordinates. Your application retrieves this point from the kEventParamMouseLocation parameter of a Carbon event, or the where field of the EventRecord structure. 
Return Value

If the user chooses an enabled menu item (including any item from a submenu), the MenuSelect function returns a value as its function result that indicates which menu and menu item the user chose. The high-order word of the function result contains the menu ID of the menu, and the low-order word contains the item number of the menu item chosen by the user. 
Discussion

If your application uses Carbon events, you probably don’t need to use this function. The standard event handler installed by the Carbon Event Manager function RunApplicationEventLoop calls MenuSelect for you to begin tracking when the user clicks in a menu. If you do not call RunApplicationEventLoop, however, you will need to use this function to initiate menu tracking. 

When the user presses the mouse button while the cursor is in the menu bar, your application receives a mouse-down event. To handle mouse-down events in the menu bar, pass the location of the cursor at the time of the mouse-down event as the startPt parameter to MenuSelect. The MenuSelect function displays and removes menus as the user moves the cursor over menu titles in the menu bar, and it handles all user interaction until the user dismisses the menu.

As the user drags the cursor through the menu bar, the MenuSelect function highlights the title of the menu the cursor is currently over and displays all items in that menu. If the user moves the cursor so that it is over a different menu, the MenuSelect function removes the previous menu and unhighlights its menu title.

The MenuSelect function highlights and unhighlights menu items as the user drags the cursor over the items in a menu. The MenuSelect function highlights a menu item if the item is enabled and the cursor is currently over it; it removes such highlighting when the user moves the cursor to another menu item. The MenuSelect function does not highlight disabled menu items.

If the user chooses an enabled menu item (including any item from a submenu), the MenuSelect function returns a value as its function result that indicates which menu and menu item the user chose. The high-order word of the function result contains the menu ID of the menu, and the low-order word contains the item number of the menu item chosen by the user.The MenuSelect function leaves the menu title highlighted; after performing the chosen task your application should unhighlight the menu title using the HiliteMenu function.

If the user chooses an item from a submenu, MenuSelect returns the menu ID of the submenu in the high-order word and the item chosen by the user in the low-order word of its function result. The MenuSelect function also highlights the title of the menu in the menu bar that the user originally displayed in order to begin traversing to the submenu. After performing the chosen task, your application should unhighlight the menu title.

If the user releases the mouse button while the cursor is over a disabled item, in the menu bar, or outside of any menu, the MenuSelect function returns 0 in the high-order word of its function result and the low-order word is undefined. If it is necessary for your application to find the item number of the disabled item, your application can call MenuChoice to return the menu ID and menu item.

Note that MenuSelect sends a number of Carbon events during menu tracking:
kEventMenuBeginTracking when tracking begins, before displaying any menus. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring. 
kEventMenuEndTracking after tracking was completed. 
kEventMenuChangeTrackingMode when the user switches from the mouse to the keyboard to navigate through menus, or vice versa. 
kÉventMenuOpening is sent to each menu that the user opens, just before it opens. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring.
kEventMenuClosed is sent to each menu that the user closes.
kEventMenuPopulate is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuEnableItems is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventCommandUpdateStatus is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuTargetItem is sent to a menu when the mouse passes over a menu item or if the keyboard is used to select a menu item. This event is sent for both enabled and disabled menu items, and is also sent when the mouse is over a menu title. 
kEventCommandProcess is sent to a menu when the user chooses one of its menu items. 

For more details about these Carbon events, see the Carbon Event Manager Reference. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Carbon does not support desk accessories, so MenuSelect cannot be used in Mac OS X to pass keyboard equivalents to desk accessories.
Declared In
Menus.h */

long MenuSelect (
   Point startPt
);

/*MenuKey

Maps a character key with the command key to determine the keyboard equivalent of a menu item in a menu in the current menu list. 

Not recommended

long MenuKey (
   CharParameter ch
);
Parameters
ch

The 1-byte character that represents the key pressed by the user in combination with the Command key. 
Return Value

A value containing the menu ID and menu item that corresponds to the given character.If the given character does not map to an enabled menu item in the current menu list, MenuKey returns 0 in its high-order word and the low-order word is undefined. 
Discussion

Note that unless your application uses the WaitNextEvent event model, you should use the Carbon event–based IsMenuKeyEvent instead. Even when using the WaitNextEvent model, you should probably use MenuEvent, as that function supports the Shift, Option, and Control modifier keys in addition to the Command key

The MenuKey function determines whether the key combination maps to a current menu item when the user presses another key while holding down the Command key.

MenuKey does not distinguish between uppercase and lowercase letters. This allows a user to invoke a keyboard equivalent command, such as the Copy command, by pressing the Command key and “c” or “C”. For consistency between applications, you should define the keyboard equivalents of your commands so that they appear in uppercase in your menus.

You should not define menu items with identical keyboard equivalents. The MenuKey function scans the menus from right to left and the items from top to bottom. If you have defined more than one menu item with identical keyboard equivalents, MenuKey returns the first one it finds.

If the given character maps to an enabled menu item in the current menu list, MenuKey highlights the menu title of the chosen menu, returns the menu ID in the high-order word of its function result, and returns the chosen menu item in the low-order word of its function result. After performing the chosen task, your application should unhighlight the menu title using the HiliteMenu function.

The MenuKey function first searches the regular portion of the current menu list for a menu item with a keyboard equivalent matching the given key. If it doesn’t find one there, it searches the submenu portion of the current menu list. If the given key maps to a menu item in a submenu, MenuKey highlights the menu title in the menu bar that the user would normally pull down to begin traversing to the submenu. Your application should perform the desired command and then unhighlight the menu title.

You shouldn’t assign a Command–Shift–number key sequence to a menu item as its keyboard equivalent Command–Shift–number key sequences are reserved for use as ' FKEY ' resources. Command–Shift–number key sequences are not returned to your application, but instead are processed by the Event Manager. The Event Manager invokes the ' FKEY ' resource with a resource ID that corresponds to the number that activates it.

Apple reserves the Command-key codes 0x1B through 0x20 to indicate meanings other than keyboard equivalents. MenuKey ignores these character codes and returns a function result of 0 if you specify any of these values in the ch parameter. Your application should not use these character codes for its own use 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Carbon does not support desk accessories, so MenuKey cannot be used in OS X to pass keyboard equivalents to desk accessories.
Declared In
Menus.h*/
long MenuKey (
   CharParameter ch
);

/*DeleteMenu

Deletes an existing menu from the current menu list. 

void DeleteMenu (
   MenuID menuID
);
Parameters
menuID

The menu ID of the menu to delete from the current menu list. If the menu list does not contain a menu with the specified menu ID, DeleteMenu does nothing. 
Discussion

The DeleteMenu function deletes the menu identified by the specified menu ID from the current menu list. DeleteMenu decrements the reference count of the menu, and if the reference count reaches zero, the memory occupied by the menu is released. To explicitly release the memory occupied by the menu, use DisposeMenu.

The DeleteMenu function first checks the submenu portion of the current menu list for a menu ID with the specified ID. If it finds such a menu, it deletes that menu and returns. If DeleteMenu doesn’t find the menu in the submenu portion, it checks the regular portion of the current menu list. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void DeleteMenu (
   MenuID menuID
);

/*DisposeMenu

Decrements the retain count of a menu.

void DisposeMenu (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose retain count to decrement. If the retain count falls to zero, the menu is destroyed. 
Discussion

The reference that you pass in the theMenu parameter is not valid after DisposeMenu returns. This function is identical to ReleaseMenu.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void DisposeMenu (
   MenuRef theMenu
);


/*AppendMenu

Appends one or more items to a menu previously created.

Not recommended

void AppendMenu (
   MenuRef menu,
   ConstStr255Param data
);
Parameters
menu

The menu to which you wish to append the menu item or items. 
data

A Pascal string that defines the characteristics of the new menu item or items. Note that in most cases you should store the text of a menu item in a resource, so that your menu items can be more easily localized. The AppendMenu function appends the menu items in the order in which they are listed in the data parameter. 
Discussion

Note that unless you are supporting legacy code, you should use the AppendMenuItemTextWithCFString function instead. 

The AppendMenu function appends any defined menu items to a previously-created menu. The menu items are added to the end of the menu. You specify the text of any menu items and their characteristics in the data parameter. You can embed metacharacters in the string to define various characteristics of a menu item. 

Table 1 lists the metacharacters that you can specify in the data parameter:
Table 1  Metacharacters available to pass in AppendMenu
Metacharacter	
Description

; or Return	
Separates menu items.

^	
When followed by an icon number, defines the icon for the item. If the keyboard equivalent field contains 0x1C, this number is interpreted as a text encoding.

!	
When followed by a character, defines the mark for the item. If the keyboard equivalent field contains 0x1B or the equivalent constant hMenuCmd, this value is interpreted as the menu ID of a submenu of this menu item. 

<	
When followed by one or more of the characters B, I, U, O, and S, defines the character style of the item to Bold, Italic, Underline, Outline, or Shadow, respectively.

/	
When followed by a character, defines the keyboard equivalent for the item. When followed by 0x1B or the equivalent constant hMenuCmd, specifies that this menu item has a submenu. To specify that the menu item has a text encoding, small icon, or reduced icon, use the SetItemCmd function to set the keyboard equivalent field to 0x1C, 0x1D, or 0x1E, respectively. 

(	
Defines the menu item as disabled. 


You can specify any, all, or none of these metacharacters in the text string. The metacharacters that you specify aren’t displayed in the menu item. (To use any of these metacharacters in the text of a menu item, first use AppendMenu, specifying at least one character as the item’s text, and then use the function SetMenuItemText to set the item’s text to the desired string.)

If you add menu items using the AppendMenu function, you should define the text and any marks or keyboard equivalents in resources for easier localization. 

You can specify the first character that defines the text of a menu item as a hyphen to create a divider line. The string in the data parameter can be blank (containing one or more spaces), but it should not be an empty string. 

If you do not define a specific characteristic of a menu item, the AppendMenu function assigns the default characteristic to the menu item. If you do not define any characteristic other than the text for a menu item, the AppendMenu function inserts the menu item so that it appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent.

You can use AppendMenu to append items to a menu regardless of whether the menu is in the current menu list. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void AppendMenu (
   MenuRef menu,
   ConstStr255Param data
);

/*CreateStandardFontMenu

Creates a standard font menu.

OSStatus CreateStandardFontMenu (
   MenuRef menu,
   MenuItemIndex afterItem,
   MenuID firstHierMenuID,
   OptionBits options,
   ItemCount * outHierMenuCount
);
Parameters
menu

The menu to which you want to add the font items. 
afterItem

The item number of the menu item after which the new menu items are to be added. If you want to insert the new items before the first menu items, specify 0. If you want to insert the items after the last item in the menu, specify a number greater than or equal to the last item in the menu. Otherwise, specify the item number for the menu item after which you want to insert new items. 
firstHierMenuID

The first menu ID to use if any hierarchical menus are created. This ID is incremented for each additional hierarchical menu. 
options

An option bits structure that specifies the behavior for the Font menu. Specify the Hierarchical Font Menu Option Constant if you want to construct a hierarchical font menu. 
outHierMenuCount

On return, this parameter contains the number of hierarchical menus attached to the standard font menu. This value may be NULL if the hierarchical menus count is not useful. For example, if the only submenus in your application are those created by CreateStandardFontMenu, then you don’t need to worry about the hierarchical menu count, as any existing submenu must be a font menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You should use this function instead of the functions AppendResMenu or InsertResMenu to designate objects in the font database as menu items in the Font menu. The fonts objects will appear by name. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CreateStandardFontMenu (
   MenuRef menu,
   MenuItemIndex afterItem,
   MenuID firstHierMenuID,
   OptionBits options,
   ItemCount * outHierMenuCount
);

/*GetMenuItemText

Obtains the text of a menu item. 

Not recommended

void GetMenuItemText (
   MenuRef theMenu,
   short item,
   Str255 itemString
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
itemString

On output, the menu item’s text string. 
Discussion

Unless you need to support legacy code, you should use the CopyMenuItemTextAsCFString instead. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void GetMenuItemText (
   MenuRef theMenu,
   short item,
   Str255 itemString
);

/*GetFontFamilyFromMenuSelection

Gets the font family reference and style from the menu identifier and menu item number returned by the function MenuSelect.

OSStatus GetFontFamilyFromMenuSelection (
   MenuRef menu,
   MenuItemIndex item,
   FMFontFamily * outFontFamily,
   FMFontStyle * outStyle
);
Parameters
menu

A menu handle. 
item

A menu item index. 
outFontFamily

A pointer to the font family reference associated with the menu item. 
outStyle

A pointer to the font style associated with the menu item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You use this function to obtain information from a font menu created using CreateStandardFontMenu, AppendResMenu, InsertFontResMenu, InsertIntlResMenu, or InsertResMenu.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetFontFamilyFromMenuSelection (
   MenuRef menu,
   MenuItemIndex item,
   FMFontFamily * outFontFamily,
   FMFontStyle * outStyle
);

/*CheckMenuItem

Adds or removes a check mark from a menu item.

void CheckMenuItem (
   MenuRef theMenu,
   short item,
   Boolean checked
);
Parameters
theMenu

The menu containing the menu item to check or uncheck. 
item

The menu index of the item to check or uncheck. 
checked

Pass true to add a check, false to remove it. 
Discussion

You can also add or remove a check mark using the SetItemMark function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void CheckMenuItem (
   MenuRef theMenu,
   short item,
   Boolean checked
);

/*GetItemMark

Returns a menu item’s mark.

void GetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter * markChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
markChar

On output, an integer representing the mark of the menu item or its submenu (item has a submenu). See the Font Manager for a list of character marking constants that this function can obtain. This parameter is set to 0 if the menu item has neither mark nor submenu. 
Discussion

You should call GetMenuItemHierarchicalID instead of GetItemMark to obtain the menu ID of a menu item’s submenu. However, you can still use GetItemMark to obtain the mark of a menu item.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void GetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter * markChar
);

/*AppendResMenu

Searches all resource files open to your application for a given resource type and appends the names of any resources it finds to a specified menu. 

Not recommended

void AppendResMenu (
   MenuRef theMenu,
   ResType theType
);
Parameters
theMenu

The menu to which to append the names of any resources of a given type that AppendResMenu finds. 
theType

A four-character code that identifies the resource type for which to search. 
Discussion

Unless you must support legacy code, you should not use functions like AppendResMenu ,which assumes that menu items to append are stored in resources.

If you want to insert fonts into a menu, you should call CreateStandardFontMenu instead. 

The AppendResMenu function searches all resource files open to your application for resources of the type defined by the parameter theType. It appends the names of any resources it finds of the given type to the end of the specified menu. AppendResMenu appends the names of found resources in alphabetical order; it does not alphabetize items already in the menu. The AppendResMenu function does not add resources with names that begin with a period (.) or a percent sign (%) to the menu.

AppendResMenu assigns default characteristics to each menu item. Each appended menu item appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent.

Note that for applications using CarbonLib, you no longer need to call AppendResMenu add resources of type ' DRVR ' to your Apple menu; CarbonLib does this for you automatically. 

If you specify that AppendResMenu append resources of type ' FONT ' or ' FOND ', the Menu Manager performs special processing for any resources it finds that have font numbers greater than 0x4000. If the script system associated with the font name is installed in the system, AppendResMenu stores information in the itemDefinitions array (in the itemIcon and itemCmd fields for that item) in the menu structure. This allows the Menu Manager to display the font name in the correct script. 
Special Considerations

The AppendResMenu function calls the Resource Manager function SetResLoad (specifying true in the load parameter) before returning. The AppendResMenu function reads the resource data of the resources it finds into memory. If your application does not want the Resource Manager to read resource data into memory when your application calls other functions that read resources, you need to call SetResLoad and specify false in the load parameter after AppendResMenu returns.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void AppendResMenu (
   MenuRef theMenu,
   ResType theType
);

/*GetMenu

Creates a menu from the specified menu and extended menu resources.

Not recommended

MenuRef GetMenu (
   short resourceID
);
Parameters
resourceID

The resource ID of the menu and extended menu that defines the characteristics of the menu. You typically use the same number for a menu’s resource ID as the number that you specify for the menu ID in the menu resource. 
Return Value

The new menu. You can use the returned menu handle to refer to this menu in most Menu Manager functions. If GetMenu is unable to read the menu or menu definition function from the resource file, GetMenu returns null. See the description of the MenuRef data type.
Discussion

Unless you must support legacy code, you should not use functions like GetMenu that rely on menus stored as resources. Instead, you should define menus in Interface Builder, store them as nib files, and then call the Interface Builder Services function CreateMenuFromNib to create them.

GetMenu reads the menu definition function into memory (if not already present) and stores a handle to the menu definition function in the menu structure. GetMenu does not insert the newly created menu into the current menu list.

You typically use the GetMenu function only when you create submenus; you can create all your pull-down menus at once using the function GetNewMBar, and you can create pop-up menus using the standard pop-up menu button control definition function. 

After reading the 'MENU' resource, GetMenu searches for an extended menu resource and an 'mctb' resource with the same resource ID as the 'MENU' resource. If the specified 'mctb' resource exists, GetMenu uses SetMCEntries to add the entries defined by the resource to the application’s menu color information table. If the 'mctb' resource does not exist, GetMenu uses the default colors specified in the menu bar entry of the application’s menu color information. If neither a menu bar entry nor a 'mctb' resource exists, GetMenu uses the standard colors for the menu.

Storing the definitions of your menus in resources (especially menu titles and menu items) makes your application easier to localize.

After creating a menu with GetMenu or NewMenu , use InsertMenuItem , AppendMenu , or InsertResMenu to add menu items to the menu. To add a menu created by GetMenu to the current menu list, use InsertMenu. To update the menu bar with any new menu titles, use DrawMenuBar.

Menus in a resource must not be purgeable nor should the resource lock bit be set. Do not define a “circular” hierarchical menu—that is, a hierarchical menu in which a submenu has a submenu whose submenu is a hierarchical menu higher in the chain. 
Special Considerations

To release the memory associated with a menu that you created using GetMenu, first call DeleteMenu to remove the menu from the current menu list and to remove any entries for this menu in your application’s menu color information table then call DisposeMenu to dispose of the menu structure.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

In Carbon, the GetMenu function always returns a newly created MenuRef. Prior to Carbon, GetMenu would first check if the menu was already in memory. If so, GetMenu would return the in-memory copy. This behavior is no longer supported.

Carbon does not support custom menu definitions stored in 'MDEF' resources. If you want to specify a custom menu definition for GetMenu, you must compile your definition function directly in your application and then register the function by calling RegisterMenuDefinition. When GetMenu gets a resourceID value that doesn't recognize, it checks a special mapping table to find the pointer that's registered for the resourceID parameter. It then calls that function to implement your menu. 
Declared In
Menus.h*/

MenuRef GetMenu (
   short resourceID
);

/*ChangeMenuAttributes

Changes the attributes of a menu.

OSStatus ChangeMenuAttributes (
   MenuRef menu,
   MenuAttributes setTheseAttributes,
   MenuAttributes clearTheseAttributes
);
Parameters
menu

The menu whose attributes you want to change. 
setTheseAttributes

The attributes to add to the menu. See “Menu Attribute Constants” for a list of possible values. 
clearTheseAttributes

The attributes to remove from the menu. See “Menu Attribute Constants” for a list of possible values. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ChangeMenuAttributes (
   MenuRef menu,
   MenuAttributes setTheseAttributes,
   MenuAttributes clearTheseAttributes
);


/*SetMenuTitle

Sets the title of a menu. 

Not Recommended

OSStatus SetMenuTitle (
   MenuRef menu,
   ConstStr255Param title
);
Parameters
menu

The menu whose title you want to set. 
title

A string containing the menu title to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Unless you need to support legacy code, you should use the SetMenuTitleWithCFString function instead. 
Availability
Not recommended. Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuTitle (
   MenuRef menu,
   ConstStr255Param title
);

/*HideMenuBar

Conceals the menu bar.

void HideMenuBar ();
Discussion

The HideMenuBar function makes the menu bar invisible and unselectable by the user. You can use this function to enable full-screen display; however, in Mac OS X v10.2 and later, you should call the SetSystemUIMode function (available in MacApplication.h) instead. 

Note that calling this function causes the kEventMenuBarHidden event to be sent to the application target (if your application has registered for the event).

Also see the ShowMenuBar and IsMenuBarVisible functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void HideMenuBar ();

/*ShowMenuBar

Displays the menu bar.

void ShowMenuBar ();
Discussion

The ShowMenuBar function makes the menu bar visible and selectable by the user. 

Note that calling this function also causes a kEventMenuBarShown event to be sent to the application target (if your application has registered for the event). 

See also the HideMenuBar and IsMenuBarVisible functions. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void ShowMenuBar ();

/*GetMBarHeight

Determines the current height of the menu bar.

short GetMBarHeight ();
Return Value

The current height, in pixels, of the menu bar. 
Discussion

The GetMBarHeight function determines the menu bar height based on factors such as the current script system and theme. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
short GetMBarHeight ();

/*AcquireRootMenu

Get the menu whose contents are displayed in the menubar.

MenuRef AcquireRootMenu ();
Return Value

The current root menu. See page for a description of the MenuRef data type. If no root menu currently exists, the Menu Manager creates one and returns its menu reference.
Discussion

This function increments the reference count of the root menu. The caller should call ReleaseMenu when done with the menu. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuRef AcquireRootMenu ();

/*ScrollMenuImage

Scrolls a portion of the menu image.

OSStatus ScrollMenuImage (
   MenuRef inMenu,
   const Rect * inScrollRect,
   int inHScroll,
   int inVScroll,
   CGContextRef inContext
);
Parameters
inMenu

The menu to scroll. 
inScrollRect

The bounds of the area to scroll. 
inHScroll

The distance to scroll horizontally, in pixels. 
inVScroll

The distance to scroll vertically, in pixels. 
inContext

The Core Graphics context to scroll. If you pass NULL, the function creates a context based on the current port. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Scrolling menus on Mac OS X using ScrollRect or other QuickDraw functions destroys the alpha channel data, so you should use ScrollMenuImage instead. 
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X 10.1 and later.
Declared In
Menus.h*/
OSStatus ScrollMenuImage (
   MenuRef inMenu,
   const Rect * inScrollRect,
   int inHScroll,
   int inVScroll,
   CGContextRef inContext
);

/*EraseMenuBackground

Erases the menu background to prepare for additional drawing.

OSStatus EraseMenuBackground (
   MenuRef inMenu,
   const Rect * inEraseRect,
   CGContextRef inContext
);
Parameters
inMenu

The menu whose background you want to erase. 
inEraseRect

The bounds of the area to erase, in the local coordinates of the current port. 
inContext

The Core Graphics context to erase. If set to NULL, this function creates a new context based on the current port. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Typically you use this function only if you are implementing message-based custom menu definition functions. HIView-based custom menus and normal application code do not need to call EraseMenuBackground. 

Before calling the Appearance Manager function DrawThemeMenuBackground, you must erase the current menu background. Themes such as Aqua draw the menu background using an alpha channel, so if the old background is not erased, portions of the old image will show through the menu background.
Availability
Available in CarbonLib 1.5 and later.
Available in Mac OS X 10.1 and later.
Declared In
Menus.h*/
OSStatus EraseMenuBackground (
   MenuRef inMenu,
   const Rect * inEraseRect,
   CGContextRef inContext
);

/*GetMenuAttributes

Gets the attributes of a menu.

OSStatus GetMenuAttributes (
   MenuRef menu,
   MenuAttributes * outAttributes
);
Parameters
menu

The menu. 
outAttributes

On exit, contains the attributes of the menu. See “Menu Attribute Constants” for a list of possible values. 
Return Value

A result code. See “Menu Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuAttributes (
   MenuRef menu,
   MenuAttributes * outAttributes
);

/*SetItemCmd

Sets the value of the keyboard equivalent field of a menu item.

Not recommended

void SetItemCmd (
   MenuRef theMenu,
   short item,
   CharParameter cmdChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
cmdChar

The value to set for the item’s keyboard equivalent field. The Menu Manager uses this value to map keyboard equivalents to menu s or to define special characteristics of the menu item. 

To indicate that the menu item has a submenu, specify 0x1B in the cmdChar parameter; specify a value of 0x1C to indicate that the item has a special text encoding; specify a value of 0x1D to indicate that the Menu Manager should reduce the item’s 'ICON' resource to the size of a small icon; and specify a value of 0x1E to indicate that the item has an 'SICN' resource.

The values 0x01 through 0x1A, as well as 0x1F and 0x21, are reserved for use by Apple. You should not use any of these reserved values in the cmdChar parameter.
Discussion

You should call SetMenuItemCommandKey , SetMenuItemHierarchicalID , and SetMenuItemTextEncoding instead of SetItemCmd to set a menu item’s keyboard equivalent and text encoding and to indicate that a menu item has a submenu.

You usually define the keyboard equivalents and other characteristics of your menu items in the 'MENU' resource rather than using the SetItemCmd function. The SetItemCmd function sets the value in the keyboard equivalent field of the specified menu item to the value specified by the cmdChar parameter (you can specify 0 if the item doesn’t have a keyboard equivalent, submenu, text encoding, reduced icon, or small icon). If you specify that the item has a submenu, you should provide the menu ID of the submenu as the item’s marking character. If you specify that the item has a special text encoding, you must provide the text encoding in the icon field of the menu item. If you specify that the item has an 'SICN' or a reduced 'ICON' resource, you must provide the icon number in the icon field of the item. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemCmd (
   MenuRef theMenu,
   short item,
   CharParameter cmdChar
);

/*SetMenuItemModifiers

Sets the modifier key(s) that must be pressed with a character key to select a particular menu item.

OSErr SetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inModifiers
);
Parameters
inMenu

The menu that contains the menu item for which you wish to set the modifier key(s). 
inItem

The menu index of the item. 
inModifiers

A value representing the modifier key(s) to be used in selecting the menu item; see “Modifier Key Mask Constants”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call the SetMenuItemModifiers function to change the modifier key(s) you can include with a character key to create your keyboard equivalent. For example, you can change Command-x to Command-Option-Shift-x. By default, the Command key is always specified; you can remove it by calling SetMenuItemModifiers with the kMenuNoCommandModifier mask constant, or (if you are using a nib file) by unchecking the appropriate command checkbox in the Interface Builder menu item inspector. 

See also the function GetMenuItemModifiers. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 inModifiers
);

/*GetMenuWidth

Obtains the width of the menu, in pixels. 

SInt16 GetMenuWidth (
   MenuRef menu
);
Parameters
menu

The menu whose width you want to obtain. 
Return Value

The width of the menu, in pixels. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

SInt16 GetMenuWidth (
   MenuRef menu
);

/*SetItemMark

Sets the mark of a menu item.

void SetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter markChar
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
markChar

The mark of the menu item or its submenu (if the item has a submenu). To set the submenu associated with this menu item, specify the menu ID of the submenu in the markChar parameter. You can pass the character marking constants defined in the Font Manager. Pass 0 (noMark)if the menu item has neither mark nor submenu. 
Discussion

You should call SetMenuItemHierarchicalID instead of SetItemMark to set the menu ID of a menu item’s submenu. However, you can still use SetItemMark to set the mark of a menu item. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemMark (
   MenuRef theMenu,
   short item,
   CharParameter markChar
);

/*IsMenuSizeInvalid

Determines if a menu's size is invalid and should be recalculated.

Boolean IsMenuSizeInvalid (
   MenuRef inMenu
);
Parameters
inMenu

The menu whose size you want to examine. 
Return Value

Set to true if the menu size is invalid, false otherwise.
Discussion

Prior to Carbon, the technique for determining if a menu's size is invalid was to check if the width or height was -1. This technique is not always reliable in Carbon due to implementation changes in the Menu Manager, so you should use IsMenuSizeInvalid instead.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

Boolean IsMenuSizeInvalid (
   MenuRef inMenu
);

/*SetMenuItemHierarchicalID

Attaches a submenu to a menu item. 

OSErr SetMenuItemHierarchicalID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuID inHierID
);
Parameters
inMenu

The menu that contains the menu item to which you wish to attach a submenu. 
inItem

The menu index of the item. 
inHierID

An integer representing the menu ID of the submenu you wish to attach. This menu should be inserted into the menu list by calling InsertMenu with the kInsertHierarchicalMenu constant. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The SetMenuItemHierarchicalID function should be called instead of setting the keyboard equivalent to 0x1B. You should call SetMenuItemHierarchicalID instead of SetItemMark to set the menu ID of a menu item’s submenu. However, you can still use SetItemMark to set the mark of a menu item. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSErr SetMenuItemHierarchicalID (
   MenuRef inMenu,
   SInt16 inItem,
   MenuID inHierID
);

/*SetMenuItemIndent

Sets the indent level of a menu item.

OSStatus SetMenuItemIndent (
   MenuRef inMenu,
   MenuItemIndex inItem,
   UInt32 inIndent
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose indent level you want to set. 
inIndent

The new indent level of the item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

The indent level of an item is an amount of extra space added to the left of the item's icon or checkmark. The level is simply a number, starting at zero, which the Menu Manager multiplies by a constant to get the indent in pixels. The default indent level is zero.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemIndent (
   MenuRef inMenu,
   MenuItemIndex inItem,
   UInt32 inIndent
);

/*SetMenuTitleWithCFString

Sets the title of a menu to the text contained in a CFString.

OSStatus SetMenuTitleWithCFString (
   MenuRef inMenu,
   CFStringRef inString
);
Parameters
inMenu

The menu whose title you want to set. 
inString

The string containing the new menu title text. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the string is mutable, the Menu Manager will make its own copy of the CFString before returning from SetMenuTitleWithCFString. Modifying the string after calling SetMenuTitleWithCFString will then have no effect on the menu's actual title. 

If the string is immutable, the Menu Manager simply increments the string’s reference count. 

The caller may release the string after calling SetMenuTitleWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus SetMenuTitleWithCFString (
   MenuRef inMenu,
   CFStringRef inString
);

/*CreateCustomMenu

Creates a new, untitled, empty menu using a custom menu definition function.

OSStatus CreateCustomMenu (
   const MenuDefSpec * inDefSpec,
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);
Parameters
inDefSpec

A data structure that specifies a custom menu definition function. 
inMenuID

The menu ID to use for the new menu. 
inMenuAttributes

The menu attributes to use for the new menu. See “Menu Attribute Constants” for a list of possible values. 
outMenuRef

On exit, contains the new menu. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

Similar to CreateNewMenu, but also allows you to create a menu from a custom menu definition function This definition can be procedure pointer–based or HIView-based, which you specify in the MenuDefSpec structure. (Note that HIView–based menus are available only in Mac OS X v10.3 and later.)
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus CreateCustomMenu (
   const MenuDefSpec * inDefSpec,
   MenuID inMenuID,
   MenuAttributes inMenuAttributes,
   MenuRef * outMenuRef
);

/*NewMenuDefUPP

Creates a new univeral procedure pointer to your custom menu definition. 

Not recommended

MenuDefUPP NewMenuDefUPP (
   MenuDefProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the MenuDefUPP data type.
Availability
Not recommended. Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

Apple discourages you from writing and using your own menu definition functions and encourages you to use the system-supplied menu definition function instead. New features that have previously been missing are now available in the system-supplied menu definition function. Since Appearance Manager 1.0 (in Mac OS 8.0), for example, the system-supplied menu definition function has supported extended menu item command key modifiers and glyphs. And in Carbon, the system-supplied menu definition function supports dynamic items, which allow the contents of a menu item to be redrawn while the menu is displayed in response to the user pressing a modifier key on the keyboard.
Declared In
Menus.h*/
MenuDefUPP NewMenuDefUPP (
   MenuDefProcPtr userRoutine
);

/*SetMenuItemCommandKey

Sets the keyboard equivalent of a menu item.

OSStatus SetMenuItemCommandKey (
   MenuRef inMenu,
   MenuItemIndex inItem,
   Boolean inSetVirtualKey,
   UInt16 inKey
);
Parameters
inMenu

The menu containing the item. 
inItem

The item whose keyboard equivalent you want to set. 
inSetVirtualKey

Indicates whether to set the item's character code (false) or virtual keycode equivalent. (true).
inKey

The character code or virtual keycode equivalent to set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

A menu item's keyboard equivalent may be either a character code or a virtual keycode. The character code is always used to draw the item's keyboard equivalent in the menu, but either may be used for keyboard equivalent matching by MenuEvent and IsMenuKeyEvent, depending on whether the kMenuItemAttrUseVirtualKey item attribute is set. If SetMenuItemCommandKey is used to set the virtual keycode equivalent for a menu item, it also automatically sets the kMenuItemAttrUseVirtualKey item attribute. To make the menu item stop using the virtual keycode equivalent and use the character code equivalent instead, use ChangeMenuItemAttributes to clear the kMenuItemAttrUseVirtualKey item attribute.
Version Notes

Prior to Mac OS X v10.3, passing a character code in the range 0x1A to 0x21 (the range of command key metacharacters such as hMenuCmd) returned an error. In Mac OS X v10.3 and later, the Menu Manager interprets codes in this range as the ASCII character for that value, and displays the appropriate command key glyph. For example, passing hMenuCmd would set the keyboard equivalent to be command-Escape, because the value of hMenuCmd (0x1B) is the character code for the Escape character. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSStatus SetMenuItemCommandKey (
   MenuRef inMenu,
   MenuItemIndex inItem,
   Boolean inSetVirtualKey,
   UInt16 inKey
);

/*GetMenuTrackingData

Gets information about the menu currently selected by the user.

OSStatus GetMenuTrackingData (
   MenuRef theMenu,
   MenuTrackingData * outData
);
Parameters
menu

The menu about which to get tracking information. Pass NULL to get information about the most recently opened menu; for example, if the user has selected a menu that contains a submenu, and the submenu is open, then GetMenuTrackingData returns the submenu not its parent menu. 
outData

On exit, contains tracking data about the menu. 
Return Value

A result code. See “Menu Manager Result Codes”. If the menu is not currently open, menuNotFoundErr is returned.
Discussion

You can call this function only during menu tracking. As the standard menu definition automatically handles tracking, you would probably need this function only when writing a custom menu definition.

This function replaces direct access to the pre-Carbon low-memory globals TopMenuItem, AtMenuBottom, MenuDisable, and mbSaveLoc. See the Carbon Porting Notes for MenuDefProcPtr for more information. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus GetMenuTrackingData (
   MenuRef theMenu,
   MenuTrackingData * outData
);

/*GetMenuHeight

Obtains the height of a menu, in pixels. 

SInt16 GetMenuHeight (
   MenuRef menu
);
Parameters
menu

The menu whose height you want to obtain. 
Return Value

The height of the menu, in pixels. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

SInt16 GetMenuHeight (
   MenuRef menu
);

/*CalcMenuSize

Recalculates the horizontal and vertical dimensions of a menu.

void CalcMenuSize (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose dimensions need recalculating. 
Discussion

The CalcMenuSize function uses the menu definition function of the specified menu to calculate the dimensions of the menu. In most cases, your application does not need to use the CalcMenuSize function. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

void CalcMenuSize (
   MenuRef theMenu
);

/*SetMenuHeight

Set the height of a menu.

void SetMenuHeight (
   MenuRef menu,
   SInt16 height
);
Parameters
menu

The menu whose height you want to set. 
height

The height of the menu, in pixels. 
Discussion

Calling CalcMenuSize on the menu overwrites the menu height you set with this function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetMenuHeight (
   MenuRef menu,
   SInt16 height
);

/*GetMenuType

Gets the display type (pulldown, hierarchical, or popup) of a menu.

OSStatus GetMenuType (
   MenuRef theMenu,
   UInt16 * outType
);
Parameters
theMenu

The menu whose type to get. 
outType

On exit, the type of the menu. The returned value will be one of the Appearance Manager ThemeMenuType constants: kThemeMenuTypePullDown, kThemeMenuTypePopUp, or kThemeMenuTypeHierarchical. The kThemeMenuTypeInactive bit is never set. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can call this function only when the menu is displayed. If the menu is not currently open, an error is returned. The display type of a menu may vary from one menu tracking session to another; for example, the same menu might be displayed as a pulldown menu and as a popup menu.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h 
GetMenuWidth*/
OSStatus GetMenuType (
   MenuRef theMenu,
   UInt16 * outType
);

/*CopyMenuItemData

Obtains multiple menu item attributes at once. 

OSStatus CopyMenuItemData (
   MenuRef inMenu,
   MenuItemID inItem,
   Boolean inIsCommandID,
   MenuItemDataPtr ioData
);
Parameters
menu

The menu whose attributes you want to get. Note that if you pass true for the inIsCommandID parameter, you can pass NULL here, in which case the Menu Manager searches the root menu for the first menu that matches the specified command ID. 
item

The menu item index or the command ID of the menu item. 
isCommandID

A Boolean value indicating whether the value passed for the inItem parameter is a command ID or a menu item index. Pass true to indicate a command ID, false to indicate that it is a menu item index. If you pass true, the Menu Manager returns the data for the first menu item that matches the specified command ID. 
outData

A pointer to a MenuItemDataRec structure. Before calling, you should set the whichData field to indicate what data you want to obtain. (Individual fields may also require initialization before calling.) On return, the structure contains the data you requested. For more details on the types of data you can obtain, see “Menu Item Data Flags”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

You can use this function to obtain multiple menu item attributes simultaneously, which is often more efficient than making several different calls. For example, a menu definition function could use CopyMenuItemData to obtain all the individual attributes necessary for drawing a menu all at once. 

This function returns copies of the data in the menu, so you should release any data in the MenuItemDataRec structure that was allocated dynamically (such as the CFString item text). 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus CopyMenuItemData (
   MenuRef inMenu,
   MenuItemID inItem,
   Boolean inIsCommandID,
   MenuItemDataPtr ioData
);


/*IsMenuItemEnabled

Reports whether a given menu or menu item is enabled.

Boolean IsMenuItemEnabled (
   MenuRef menu,
   MenuItemIndex item
);
Parameters
menu

The menu containing the item to be examined. 
item

The item number of the menu item. Pass 0 to specify the menu title and determine whether the menu as a whole is enabled. 
Return Value

Returns true if the menu item is currently enabled; otherwise, false. 
Discussion

Your application can use the IsMenuItemEnabled function to determine whether specific menu items, even those with item numbers greater than 31, are currently enabled and can therefore be selected by the user.

Note that this function ignores the enable state of the menu when returning the enable state of a menu item. For example, if you call IsMenuItemEnabled on an enabled item while its parent menu is disabled, the function still returns true.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
Boolean IsMenuItemEnabled (
   MenuRef menu,
   MenuItemIndex item
);

/*SetMenuWidth

Sets the width of a menu.

void SetMenuWidth (
   MenuRef menu,
   SInt16 width
);
Parameters
menu

The menu whose width you want to set.
width

The width of the menu, in pixels. 
Discussion

Calling CalcMenuSize on the menu overwrites the menu width you set with this function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetMenuWidth (
   MenuRef menu,
   SInt16 width
);

/*SetMenuItemText

Sets menu item text to a specified string.

Not recommended

void SetMenuItemText (
   MenuRef theMenu,
   short item,
   ConstStr255Param itemString
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
itemString

The menu item’s text string. This parameter must not be NULL or an empty (zero-length) string. Do not use meta–font characters in this parameter. 

Your menu item text string must be limited to 250 bytes. 251 or more bytes will cause the Menu Manager to crash.
Discussion

The SetMenuItemText function does not recognize any metacharacters used by AppendMenu and InsertMenuItem. 

If you set the text of a menu item using the SetMenuItemText function, you should store the text in a string resource so that your application can be more easily localized. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes

n Carbon, you should use the SetMenuItemTextWithCFString function instead.
Declared In
Menus.h*/

void SetMenuItemText (
   MenuRef theMenu,
   short item,
   ConstStr255Param itemString
);

/*GetMenuItemModifiers

Obtains the modifier keys that must be pressed with a character key to select a particular menu item.

OSErr GetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 * outModifiers
);
Parameters
inMenu

The menu that contains the menu item for which you wish to get the modifier key(s). 
inItem

The menu index of the item. 
outModifiers

A pointer to an unsigned 8-bit value. On return, the bits of the value are set to indicate the modifier keys that can be used in selecting the menu item; see “Modifier Key Mask Constants”. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

See also the function SetMenuItemModifiers. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/

OSErr GetMenuItemModifiers (
   MenuRef inMenu,
   SInt16 inItem,
   UInt8 * outModifiers
);

/*InsertMenuItem

Inserts one or more items into a menu previously created. 

Not recommended

void InsertMenuItem (
   MenuRef theMenu,
   ConstStr255Param itemString,
   short afterItem
);
Parameters
theMenu

The menu to which you wish to add the menu item or items. 
itemString

A string that defines the characteristics of the new menu items. Note that in most cases you should store the text of a menu item in a nib file or resource, so that your menu items can be more easily localized. You can specify the contents of the itemString parameter using metacharacters; the function InsertMenuItem accepts the same metacharacters as the AppendMenu function. However, if you specify multiple items, the InsertMenuItem function inserts the items in the reverse of their order in the itemString parameter. 
afterItem

The item number of the menu item after which the new menu items are to be added. Specify 0 in the afterItem parameter to insert the new items before the first menu item; specify the item number of a current menu item to insert the new menu items after it; specify a number greater than or equal to the last item in the menu to append the new items to the end of the menu. 
Discussion

Note that unless you are supporting legacy code, you should use the InsertMenuItemTextWithCFString function instead. 

If you do not define a specific characteristic of a menu item, the InsertMenuItem function assigns the default characteristic to the menu item. If you do not define any characteristic other than the text for a menu item, the InsertMenuItem function inserts the menu item so that it appears in the menu as an enabled item, without an icon or a mark, in the plain character style, and without a keyboard equivalent. 

You can use InsertMenuItem to insert items into a menu regardless of whether the menu is in the current menu list. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void InsertMenuItem (
   MenuRef theMenu,
   ConstStr255Param itemString,
   short afterItem
);

/*SetItemIcon

Sets a menu item’s icon or text encoding.

void SetItemIcon (
   MenuRef theMenu,
   short item,
   short iconIndex
);
Parameters
theMenu

The menu containing the item. 
item

The menu index of the item. 
iconIndex

An integer representing the icon number or text encoding for the specified menu item. If the menu item’s keyboard equivalent field does not contain 0x1C, the SetItemIcon function sets the icon number of the item’s icon to the number defined in this parameter. The icon number you specify should be a value from 1 through 255 (or from 1 through 254 if the item has a small or reduced icon) or 0 if the item does not have an icon.

The Menu Manager adds 256 to the icon number to generate the resource ID of the 'cicn' or 'ICON' resource that describes the icon of the menu item. For example, if you specify 5 as the value of the iconIndex parameter, when the Menu Manager needs to draw the item, it looks for an icon resource with resource ID 261.

If the menu item’s keyboard equivalent field contains 0x1C, the SetItemIcon function sets the text encoding of the menu item to the number defined in the iconIndex parameter. The Menu Manager displays the menu item using the specified text encoding if the corresponding script system is installed.

You can specify 0 in the iconIndex parameter to indicate that the item uses the current system script and does not have an icon number.
Discussion

In most cases, you should use SetMenuItemTextEncoding rather than SetItemIcon to set the menu item’s text encoding.

The SetItemIcon function sets the icon number (for resource-based icons) or text encoding of the specified menu item to the value in the iconIndex parameter. To use handle-based icons, call SetMenuItemIconHandle. Usually you display menu items in the current system script; however, if needed, you can use the SetItemIcon function to set the text encoding of a menu item. For an item’s text encoding to be set, the keyboard equivalent field of the item must contain 0x1C. If the keyboard equivalent field contains any other value, the SetItemIcon function interprets the specified number as the item’s icon number. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void SetItemIcon (
   MenuRef theMenu,
   short item,
   short iconIndex
);

/*PopUpMenuSelect

Displays a pop-up menu without using the standard pop-up control definition function.

long PopUpMenuSelect (
   MenuRef menu,
   short top,
   short left,
   short popUpItem
);
Parameters
menu

The pop-up menu to be displayed. 
top

The y-coordinate of the top-left corner of the selected menu item when the menu opens. This value should be in global coordinates. 
left

The x-coordinate of the top-left corner of the selected menu item when the menu opens. This value should be in global coordinates.
popUpItem

The index of the menu item to display at the global point (top, left). If you pass zero, the first menu item is positioned at the indicated point. 
Return Value

The menu ID of the chosen menu in the high 16-bit word of the function result and the chosen menu item index value in the low 16-bit word. If no item was selected, the result is zero. 
Discussion

If your application uses the standard pop-up control definition function, your application does not need to use the PopUpMenuSelect function. PopUpMenuSelect uses the location specified by the top and left parameters to determine where to display the specified item of the pop-up menu. PopUpMenuSelect displays the pop-up menu so that the menu item specified in the popUpItem parameter appears highlighted at the specified location. 

The PopUpMenuSelect function highlights and unhighlights menu items and handles all user interaction until the user releases the mouse button. 

Note that PopUpMenuSelect sends a number of Carbon events during menu tracking (these are the same as those sent for MenuSelect):
kEventMenuBeginTracking when tracking begins, before displaying any menus. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring. 
kEventMenuEndTracking after tracking was completed. 
kEventMenuChangeTrackingMode when the user switches from the mouse to the keyboard to navigate through menus, or vice versa. 
kÉventMenuOpening is sent to each menu that the user opens, just before it opens. An event handler for this event may return userCanceledErr to prevent menu tracking from occurring.
kEventMenuClosed is sent to each menu that the user closes.
kEventMenuPopulate is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuEnableItems is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventCommandUpdateStatus is sent to a menu just before it is opened in a menu tracking session. This event is sent only once per menu tracking session.
kEventMenuTargetItem is sent to a menu when the mouse passes over a menu item or if the keyboard is used to select a menu item. This event is sent for both enabled and disabled menu items, and is also sent when the mouse is over a menu title. 
kEventCommandProcess is sent to a menu when the user chooses one of its menu items. 

For more details about these Carbon events, see the Carbon Event Manager Programming Guide. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
long PopUpMenuSelect (
   MenuRef menu,
   short top,
   short left,
   short popUpItem
);

/*GetMenuID

Obtains the ID of a menu.

MenuID GetMenuID (
   MenuRef menu
);
Parameters
menu
Return Value

The menu ID of the menu. See the description of the MenuID data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
MenuID GetMenuID (
   MenuRef menu
);

/*ContextualMenuSelect

Displays a contextual menu.

OSStatus ContextualMenuSelect (
   MenuRef inMenu,
   Point inGlobalLocation,
   Boolean inReserved,
   UInt32 inHelpType,
   ConstStr255Param inHelpItemString,
   const AEDesc * inSelection,
   UInt32 * outUserSelectionType,
   SInt16 * outMenuID,
   MenuItemIndex * outMenuItem
);
Parameters
inMenu

The menu containing application commands to display. The caller creates this menu based on the current context, the mouse location, and the current selection (if it was the target of the mouse). If you pass NULL, only system commands are displayed. 
inGlobalLocation

The location (in global coordinates) of the mouse near which the menu is to be displayed. 
inReserved

Reserved for future use. Pass false for this parameter. 
inHelpType

An identifier specifying the type of help provided by the application; see “Contextual Menu Help Type Constants”. 
inHelpItemString

The string containing the text to be displayed for the help menu item. This string is unused unless you also pass the constant kCMOtherHelp in the inHelpType parameter. 
inSelection

A pointer to an object specifier for the current selection. This allows the system to examine the selection and add special system commands accordingly. Passing a value of NULL indicates that no selection should be examined, and most likely, no special system actions will be included. 
outUserSelectionType

A pointer to an unsigned 32-bit value. On return, the value indicates what the user selected from the contextual menu; see “Contextual Menu Selection Type Constants” for a list of possible values.
outMenuID

A pointer to a signed 16-bit value. On return, if outUserSelectionType is set to kCMMenuItemSelected, the value is set to the menu ID of the chosen item. 
outMenuItem

A pointer to an unsigned 16-bit value. On return, if outUserSelectionType is set to kCMMenuItemSelected, the value is set to the index of the menu item chosen. 
Return Value

A result code. See “Menu Manager Result Codes”. Returns userCanceledErr and sets outUserSelectionType to kCMNothingSelected if the user selects an item that requires no additional actions on your part.
Discussion

If your application uses the standard window handler, you may want to install handlers for the kEventWindowContextualMenuSelect or kEventControlContextualMenuClick events and call ContextualMenuSelect from within your handler. The standard window handler automatically detects contextual menu clicks and sends the kEventWindowContextualMenuSelect and kEventControlContextualMenuClick events. 

If the IsShowContextualMenuEvent function returns true or you receive the appropriate contextual menu Carbon event, you should call the ContextualMenuSelect function after generating your own menu and preparing an Apple Event descriptor ( AEDesc) that describes the item for which your application is displaying a contextual menu. This descriptor may contain an object specifier or raw data and will be passed to all contextual menu plug-ins.

The system will add other items before displaying the contextual menu, and it will remove those items before returning, leaving the menu in its original state.

After all the system commands are added, the contextual menu is displayed and tracked. If the user selects one of the system items, it is handled by the system and the call returns as though the user didn’t select anything from the menu. If the user selects any other item (or no item at all), the Menu Manager passes back appropriate values in the parameters outUserSelectionType, outMenuID, and outMenuItem.

Your application should provide visual feedback indicating the item that was clicked upon. For example, a click on an icon should highlight the icon, while a click on editable text should not eliminate the current selection. 

If the outUserSelectionType parameter contains kCMMenuItemSelected, you should look at the outMenuID and outMenuItem parameters to determine what menu item the user chose and handle it appropriately. If the outUserSelectionType parameter contains kCMShowHelpSelected, you should open the proper help sequence.
Availability
Available in CarbonLib 1.0 and later when Contextual Menus 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus ContextualMenuSelect (
   MenuRef inMenu,
   Point inGlobalLocation,
   Boolean inReserved,
   UInt32 inHelpType,
   ConstStr255Param inHelpItemString,
   const AEDesc * inSelection,
   UInt32 * outUserSelectionType,
   SInt16 * outMenuID,
   MenuItemIndex * outMenuItem
);

/*DisableAllMenuItems

Disables all items in a menu.

void DisableAllMenuItems (
   MenuRef theMenu
);
Parameters
theMenu

The menu whose items you want to disable. 
Discussion

This function is equivalent to older code that masked the enableFlags field of the MenuInfo structure (now opaque in Carbon) with 0x01. It disables all items (including items past item 31) but does not affect the state of the menu title.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
void DisableAllMenuItems (
   MenuRef theMenu
);

/*InsertMenuItemTextWithCFString

Inserts a new menu item with text from a CFString.

OSStatus InsertMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemIndex inAfterItem,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID
);
Parameters
menu

The menu in which to insert the new item. 
inString

The text of the new item. 
inAfterItem

The item after which to insert the new item. Pass zero to insert the item at the beginning of the menu. If the index value is greater than the number of items in the menu, the item is inserted at the end of the menu. 
inAttributes

The attributes of the new item. 
inCommandID

The command ID of the new item. 
Return Value

A result code. See “Menu Manager Result Codes”.
Discussion

If the CFString is mutable, the Menu Manager will make its own copy of the CFString before returning from InsertMenuItemWithCFString. Modifying the string after calling InsertMenuItemTextWithCFString will have no effect on the menu item's actual text. 

If the CFString is immutable, the Menu Manager increments the reference count of the string before returning. 

The caller may release the string after calling InsertMenuItemTextWithCFString.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
Menus.h*/
OSStatus InsertMenuItemTextWithCFString (
   MenuRef inMenu,
   CFStringRef inString,
   MenuItemIndex inAfterItem,
   MenuItemAttributes inAttributes,
   MenuCommand inCommandID
);

#ifdef __cplusplus
}
#endif

#endif
