#ifndef IOKIT_IOMESSAGE_H
#define IOKIT_IOMESSAGE_H

#include <IOKit/IOReturn.h>
#include <IOKit/IOTypes.h>
//#include <HYS/IOKit/IOMessage.h>
#include <APPLE/IOKit/IOMessage.h>

/*IOMessage messages

See Also:
kIOMessageServiceIsTerminated
kIOMessageServiceIsSuspended
kIOMessageServiceIsResumed
kIOMessageServiceIsRequestingClose
kIOMessageServiceIsAttemptingOpen
kIOMessageServiceWasClosed
kIOMessageServiceBusyStateChange
kIOMessageServicePropertyChange
kIOMessageCanDevicePowerOff
kIOMessageDeviceWillPowerOff
kIOMessageDeviceWillNotPowerOff
kIOMessageDeviceHasPoweredOn
kIOMessageCanSystemPowerOff
kIOMessageSystemWillPowerOff
kIOMessageSystemWillNotPowerOff
kIOMessageCanSystemSleep
kIOMessageSystemWillSleep
kIOMessageSystemWillNotSleep
kIOMessageSystemHasPoweredOn
kIOMessageSystemWillRestart
kIOMessageSystemWillPowerOn
#define kIOMessageServiceIsTerminated iokit_common_msg( 0x010) //! 0xe0000010 The service is terminated
#define kIOMessageServiceIsSuspended iokit_common_msg( 0x020) //! 0xe0000020 The service is suspended
#define kIOMessageServiceIsResumed iokit_common_msg( 0x030) //! 0xe0000030 The service is resumed
#define kIOMessageServiceIsRequestingClose iokit_common_msg( 0x100) //! 0xe0000100 The service is requesting close
#define kIOMessageServiceIsAttemptingOpen iokit_common_msg( 0x101) //! 0xe0000101 The service is attempting to open
#define kIOMessageServiceWasClosed iokit_common_msg( 0x110) //! 0xe0000110 The service has closed
#define kIOMessageServiceBusyStateChange iokit_common_msg(0x120) //! 0xe0000120 The busy state of the service has 
    changed
#define kIOMessageServicePropertyChange iokit_common_msg( 0x130) //! 0xe0000130 A property of the service has changed
#define kIOMessageCanDevicePowerOff iokit_common_msg( 0x200) //! 0xe0000200 The device can power off
#define kIOMessageDeviceWillPowerOff iokit_common_msg( 0x210) //! 0xe0000210 The device will power off
#define kIOMessageDeviceWillNotPowerOff iokit_common_msg( 0x220) //! 0xe0000220 The device will not power off
#define kIOMessageDeviceHasPoweredOn iokit_common_msg( 0x230) //! 0xe0000230 The device has powered on
#define kIOMessageCanSystemPowerOff iokit_common_msg( 0x240) //! 0xe0000240 The system can power off
#define kIOMessageSystemWillPowerOff iokit_common_msg( 0x250) //! 0xe0000250 The system will power off
#define kIOMessageSystemWillNotPowerOff iokit_common_msg( 0x260) //! 0xe0000260 The system will not power off
#define kIOMessageCanSystemSleep iokit_common_msg( 0x270) //! 0xe0000270 The system can sleep
#define kIOMessageSystemWillSleep iokit_common_msg( 0x280) //! 0xe0000280 The system will sleep
#define kIOMessageSystemWillNotSleep iokit_common_msg( 0x290) //! 0xe0000290 The system will not sleep
#define kIOMessageSystemHasPoweredOn iokit_common_msg( 0x300) //! 0xe0000300 The system has powered on
#define kIOMessageSystemWillRestart iokit_common_msg( 0x310) //! 0xe0000310 The system will restart
#define kIOMessageSystemWillPowerOn iokit_common_msg( 0x320) //! 0xe0000320 The system will power on*/
#define kIOMessageServiceIsTerminated iokit_common_msg( 0x010) //! 0xe0000010 The service is terminated
#define kIOMessageServiceIsSuspended iokit_common_msg( 0x020) //! 0xe0000020 The service is suspended
#define kIOMessageServiceIsResumed iokit_common_msg( 0x030) //! 0xe0000030 The service is resumed
#define kIOMessageServiceIsRequestingClose iokit_common_msg( 0x100) //! 0xe0000100 The service is requesting close
#define kIOMessageServiceIsAttemptingOpen iokit_common_msg( 0x101) //! 0xe0000101 The service is attempting to open
#define kIOMessageServiceWasClosed iokit_common_msg( 0x110) //! 0xe0000110 The service has closed
#define kIOMessageServiceBusyStateChange iokit_common_msg(0x120) //! 0xe0000120 The busy state of the service has changed
#define kIOMessageServicePropertyChange iokit_common_msg( 0x130) //! 0xe0000130 A property of the service has changed
#define kIOMessageCanDevicePowerOff iokit_common_msg( 0x200) //! 0xe0000200 The device can power off
#define kIOMessageDeviceWillPowerOff iokit_common_msg( 0x210) //! 0xe0000210 The device will power off
#define kIOMessageDeviceWillNotPowerOff iokit_common_msg( 0x220) //! 0xe0000220 The device will not power off
#define kIOMessageDeviceHasPoweredOn iokit_common_msg( 0x230) //! 0xe0000230 The device has powered on
#define kIOMessageCanSystemPowerOff iokit_common_msg( 0x240) //! 0xe0000240 The system can power off
#define kIOMessageSystemWillPowerOff iokit_common_msg( 0x250) //! 0xe0000250 The system will power off
#define kIOMessageSystemWillNotPowerOff iokit_common_msg( 0x260) //! 0xe0000260 The system will not power off
#define kIOMessageCanSystemSleep iokit_common_msg( 0x270) //! 0xe0000270 The system can sleep
#define kIOMessageSystemWillSleep iokit_common_msg( 0x280) //! 0xe0000280 The system will sleep
#define kIOMessageSystemWillNotSleep iokit_common_msg( 0x290) //! 0xe0000290 The system will not sleep
#define kIOMessageSystemHasPoweredOn iokit_common_msg( 0x300) //! 0xe0000300 The system has powered on
#define kIOMessageSystemWillRestart iokit_common_msg( 0x310) //! 0xe0000310 The system will restart
#define kIOMessageSystemWillPowerOn iokit_common_msg( 0x320) //! 0xe0000320 The system will power on






#endif