#ifndef ATSUNICODETYPES_H
#define ATSUNICODETYPES_H

#ifndef ATSLAYOUTTYPES_H
#include <ATS/ATSLayoutTypes.h>
#endif

#ifndef FONTS_H
#include <QD/Fonts.h>
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>
#endif

#ifndef SFNTTYPES_H
#include <ATS/SFNTTypes.h>
#endif

#ifndef SFNTLAYOUTTYPES_H
#include <ATS/SFNTLayoutTypes.h>
#endif

#ifndef ATSTYPES_H
#include <ATS/ATSTypes.h>
#endif

//#include <HYS/QD/ATSUnicodeTypes.h>
#include <APPLE/QD/ATSUnicodeTypes.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Vertical Character Types

Specify the glyph orientation of font tracking settings or a style run.

typedef UInt16 ATSUVerticalCharacterType;
enum {
   kATSUStronglyHorizontal = 0,
   kATSUStronglyVertical = 1
};
Constants
kATSUStronglyHorizontal

Specifies a horizontal orientation.

Available in Mac OS X v10.0 and later.
kATSUStronglyVertical

Specifies a vertical orientation.

Available in Mac OS X v10.0 and later.
Discussion

You can pass a constant of type ATSUVerticalCharacterType to the functions ATSUCountFontTracking and ATSUGetIndFontTracking to specify the glyph orientation of font tracking settings, since font tracking settings differ depending upon glyph orientations.

You can also use one of these constants to set or obtain the glyph orientation of a style run; see the functions ATSUSetAttributes and ATSUGetAttribute, respectively.*/
typedef UInt16 ATSUVerticalCharacterType;
enum {
   kATSUStronglyHorizontal = 0,
   kATSUStronglyVertical = 1
};


/*ATSUTextMeasurement

Represents measurements needed by ATSUI to lay out text, such as outline metrics and line width, ascent, descent.

typedef Fixed ATSUTextMeasurement;
Discussion

The ATSUTextMeasurement type is defined as a Fixed value, with a limit of 32K. You must ensure that your measurements are converted to Fixed values before passing them to ATSUI functions that use this type. 

ATSUI uses fractional Fixed values instead of short values used in QuickDraw Text. Fractional Fixed values provide exact outline metrics and line specifications such as line width, ascent, descent, and so on.
Availability
Available in Mac OS X v10.0 and later.*/
typedef Fixed ATSUTextMeasurement;


/*ATSUAttributeValuePtr

Represents a pointer to a style run or text layout attribute value of unknown size.

typedef void* ATSUAttributeValuePtr;
Discussion

Each attribute value pointed to by ATSUAttributeValuePtr is identified by an attribute tag and the size (in bytes) of the attribute value. 

You pass the ATSUAttributeValuePtr type to functions that set or clear attribute values in style and text layout objects. The ATSUAttributeValuePtr type is passed back by functions that query style and text layout objects for their attribute values. You must dereference this pointer and cast it to the appropriate data type to obtain the actual attribute value. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef void* ATSUAttributeValuePtr;




/*ATSUTextLayout

Represents a reference to an opaque text layout structure that contains information about a text layout.

typedef struct OpaqueATSUTextLayout* ATSUTextLayout;
Discussion

The basic building block upon which ATSUI operates is a text layout object (ATSUTextLayout). A text layout object ties one or more paragraphs of text together with style attributes that may apply to characters, lines, or the entire layout. The text layout object itself contains information about line and layout attributes, including justification, rotation, direction, and others. Character style information is contained in a style object, which is only associated with, not contained by, a text layout object. For more information on text layout objects, see Inside Mac OS X: Rendering Unicode Text With ATSUI.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueATSUTextLayout* ATSUTextLayout;

/*ATSUStyle

Represents a reference to an opaque structure that contains information about a style object. 

typedef struct OpaqueATSUStyle *ATSUStyle;
Discussion

A style object is an opaque structure encapsulating the following character-level style settings
style attributes: including font ID, font size, font color, kerning control, optical alignment, verticality, and with-stream (left-right) and cross-stream (up-down) shifting (as for superscripts and subscripts)
font features: including ligatures, swashes, and alternate glyph forms
font variations: such as continually varying font weight, width, or slant
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueATSUStyle *ATSUStyle;

/*Attribute Tags

Specify attributes that can be applied to a style object, a text layout object, or a line in a text layout object.

typedef UInt32 ATSUAttributeTag;
enum {
   kATSULineWidthTag = 1L,
   kATSULineRotationTag = 2L,
   kATSULineDirectionTag = 3L,
   kATSULineJustificationFactorTag = 4L,
   kATSULineFlushFactorTag = 5L,
   kATSULineBaselineValuesTag = 6L,
   kATSULineLayoutOptionsTag = 7L,
   kATSULineAscentTag = 8L,
   kATSULineDescentTag = 9L,
   kATSULineLangRegionTag = 10L,
   kATSULineTextLocatorTag = 11L,
   kATSULineTruncationTag = 12L,
   kATSULineFontFallbacksTag = 13L,
   kATSULineDecimalTabCharacterTag = 14L,
   kATSULayoutOperationOverrideTag = 15L,
   kATSULineHighlightCGColorTag  = 17L,
   kATSUMaxLineTag = 18L,
   kATSULineLanguageTag = 10L,
   kATSUCGContextTag = 32767L,
   kATSUQDBoldfaceTag = 256L,
   kATSUQDItalicTag = 257L,
   kATSUQDUnderlineTag = 258L,
   kATSUQDCondensedTag = 259L,
   kATSUQDExtendedTag = 260L,
   kATSUFontTag = 261L,
   kATSUSizeTag = 262L,
   kATSUColorTag = 263L,
   kATSULangRegionTag = 264L,
   kATSUVerticalCharacterTag = 265L,
   kATSUImposeWidthTag = 266L,
   kATSUBeforeWithStreamShiftTag = 267L,
   kATSUAfterWithStreamShiftTag = 268L,
   kATSUCrossStreamShiftTag = 269L,
   kATSUTrackingTag = 270L,
   kATSUHangingInhibitFactorTag = 271L,
   kATSUKerningInhibitFactorTag = 272L,
   kATSUDecompositionFactorTag = 273L,
   kATSUBaselineClassTag = 274L,
   kATSUPriorityJustOverrideTag = 275L,
   kATSUNoLigatureSplitTag = 276L,
   kATSUNoCaretAngleTag = 277L,
   kATSUSuppressCrossKerningTag = 278L,
   kATSUNoOpticalAlignmentTag = 279L,
   kATSUForceHangingTag = 280L,
   kATSUNoSpecialJustificationTag = 281L,
   kATSUStyleTextLocatorTag = 282L,
   kATSUStyleRenderingOptionsTag = 283L,
   kATSUAscentTag         = 284L,
   kATSUDescentTag = 285L,
   kATSULeadingTag = 286L,
   kATSUGlyphSelectorTag = 287L,
   kATSURGBAlphaColorTag     = 288L,
   kATSUFontMatrixTag = 289L,
   kATSUStyleUnderlineCountOptionTag = 290L,
   kATSUStyleUnderlineColorOptionTag = 291L,
   kATSUStyleStrikeThroughTag    = 292L,
   kATSUStyleStrikeThroughCountOptionTag = 293L,
   kATSUStyleStrikeThroughColorOptionTag = 294L,
   kATSUStyleDropShadowTag = 295L,
   kATSUStyleDropShadowBlurOptionTag = 296L,
   kATSUStyleDropShadowOffsetOptionTag = 297L,
   kATSUStyleDropShadowColorOptionTag = 298L,
   kATSUMaxStyleTag = 299L,
   kATSULanguageTag = 264L,
   kATSUMaxATSUITagValue = 65535L
};
Constants
kATSULineWidthTag

Specifies the desired width of a line of text, in typographic points, of the line when drawn as justified or right-aligned text. The associated value is of type ATSUTextMeasurement and has a default value of 0.

Available in Mac OS X v10.0 and later.
kATSULineRotationTag

Specifies the angle by which the entire line should be rotated. The associated value is a Fixed value that specifies degrees in a right-hand coordinate system, and has a default value of 0.

Available in Mac OS X v10.0 and later.
kATSULineDirectionTag

Specifies a left-to-right or right-to-left direction for the glyphs in a text layout object, regardless of their natural direction as specified in the font. The associated value is Boolean (kATSURightToLeftBaseDirection or kATSULeftToRightBaseDirection) and has a default value of GetSysDirection(). See “Glyph Direction Selectors” for more information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSULineJustificationFactorTag

Specifies how ATSUI should typographically fit a line of text to a given width (or height, in the case of vertical text). The associated value is a Fract value between 0 and 1 and has a default value of kATSUNoJustification. See “Line Justification Selectors” for information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSULineFlushFactorTag

Specifies how ATSUI should place text in relation to one or both margins, which are the left and right sides (or top and bottom sides) of the text area. The associated value is a Fract value between 0 and 1 and has a default value of kATSUStartAlignment. See “Line Alignment Selectors” for information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSULineBaselineValuesTag

Specifies the positions of different baseline types with respect to one another in a line of text. The associated value is of type BslnBaselineRecord and contains default values all of which are 0. The values are calculated from other style attributes such as font and point size.

Available in Mac OS X v10.0 and later.
kATSULineLayoutOptionsTag

Specifies how ATSUI should manipulate basic attributes of a line or the text layout object, such as whether a line should have optical hangers or whether the last line of a text layout object should be justified. The associated value is of type ATSLineLayoutOptions and has a default value of kATSLineNoLayoutOptions. See “Line Layout Attribute Tags” for information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSULineAscentTag

Specifies line ascent. The associated value is of type ATSUTextMeasurement and has a default value of kATSUseLineHeight. See “Line Height and Font Tracking Selectors” for information on the values that can be associated with this tag. 

Available in Mac OS X v10.0 and later.
kATSULineDescentTag

Specifies line descent. The associated value is of type ATSUTextMeasurement and has a default value of kATSUseLineHeight. See “Line Height and Font Tracking Selectors” for information on the values that can be associated with this tag. 

Available in Mac OS X v10.0 and later.
kATSULineLangRegionTag

Specifies line language region.The associated value is a region code (see the Script Manager reference for a list of region codes) and has a default value of kTextRegionDontCare.

Available in Mac OS X v10.0 and later.
kATSULineTextLocatorTag

Specifies line text location. The associated value is of type TextBreakLocatorRef and has a default value of NULL. 

Available in Mac OS X v10.0 and later.
kATSULineTruncationTag

Specifies where in a line truncation should occur. The associated value is of type ATSULineTruncation and has a default value of kATSUTruncateNone. See “Line Truncation Selectors” for the values that can be associated with the line truncation tag.

Available in Mac OS X v10.0 and later.
kATSULineFontFallbacksTag

Specifies line font fallbacks. The associated value is of type ATSUFontFallbacks. See “Font Fallback Methods” for information on the values that can be associated with this tag.

Available in Mac OS X v10.1 and later.
kATSULineDecimalTabCharacterTag

Specifies the current setting for the decimal separator, and affects the behavior of decimal tabs for a text layout (not an individual line). The associated value is of type CFStringRef. The CFString object (CFStringRef) is retained by the style object in which it is set. The default value is the user setting in System Preferences.

Available in Mac OS X version 10.3 and later.
kATSULineHighlightCGColorTag

Specifies the current setting of the highlight color and opacity. The associated value is of type CGColorRef. This can be set as a line or layout control. The CGColor object (CGColorRef) is retained by the text layout object in which it is set.

Available in Mac OS X version 10.3 and later.
kATSULayoutOperationOverrideTag

Specifies to override a layout operation. The associated value is of type ATSULayoutOperationOverrideSpecifier and has a default value of NULL.

Available starting with Mac OS X version 10.2.
kATSUMaxLineTag

A convenience tag that specifies the upper limit of the text layout attribute tags.

Available in Mac OS X v10.0 and later.
kATSULineLanguageTag

Not recommended. Instead use kATSULineLangRegionTag.

Available in Mac OS X v10.0 and later.
kATSUCGContextTag

Specifies to use a Quartz context. When you use this tag to set up a Quartz context, ATSUI uses an 8-bit, sub-pixel rendering. This method of rendering positions glyph origins on fractional points, which results in superior rendering compared to ATSUI’s default 4-bit pixel-aligned rendering. The attribute has a default value of NULL; you must provide a pointer to a CGContext. The CGContext is not retained by the text layout object; if the context is desrtoyed, the text layout contains an invalid CGContext. Available only in Mac OS X.

Available in Mac OS X v10.0 and later.
kATSUQDBoldfaceTag

Specifies a boldface text style. Text style attribute tags are included for compatibility with the Style type used by the QuickDraw function TextFace. If a font variant for this text style exists, ATSUI uses that variant. Otherwise, the variant is generated algorithmically. The associated value is of type Boolean and has a default value of false.

Available in Mac OS X v10.0 and later.
kATSUQDItalicTag

Specifies an italic text style. Text style attribute tags are included for compatibility with the Style type used by the QuickDraw function TextFace. If a font variant for this text style exists, ATSUI uses that variant. Otherwise, the variant is generated. The associated value is of type Boolean and has a default value of false.

Available in Mac OS X v10.0 and later.
kATSUQDUnderlineTag

Specifies an underline text style. Text style attribute tags are included for compatibility with the Style type used by the QuickDraw function TextFace. If a font variant for this text style exists, ATSUI uses that variant. Otherwise, the variant is generated. The associated value is of type Boolean and has a default value of false.

Available in Mac OS X v10.0 and later.
kATSUQDCondensedTag

Specifies a condensed text style. Text style attribute tags are included for compatibility with the Style type used by the QuickDraw function TextFace. If a font variant for this text style exists, ATSUI uses that variant. Otherwise, the variant is generated. The associated value is of type Boolean and has a default value of false.

Available in Mac OS X v10.0 and later.
kATSUQDExtendedTag

Specifies an extended text style. Text style attribute tags are included for compatibility with the Style type used by the QuickDraw function TextFace. If a font variant for this text style exists, ATSUI uses that variant. Otherwise, the variant is generated The associated value is of type Boolean and has a default value of false.

Available in Mac OS X v10.0 and later.
kATSUFontTag

Specifies a unique value that identifies a font to the font management system. The associated value is of type ATSUFontID and has a default value of GetScriptVariable (smSystemScript, smScriptAppFond).

Available in Mac OS X v10.0 and later.
kATSUSizeTag

Specifies the font size of the text in the style run. The associated value, in typographic points (72 per inch), is of type Fixed and has a default value of GetScriptVariable (smSystemScript, smScriptAppFondSize).

Available in Mac OS X v10.0 and later.
kATSUColorTag

Specifies the color of the glyphs in a style run. The associated value is of type RGBColor and has a default value of (0,0,0).

Available in Mac OS X v10.0 and later.
kATSULangRegionTag

Specifies a language region. The associated value is a region code (see the Script Manager reference for a list of region codes) and has a default value of GetScriptManagerVariable (smRegionCode).

Available in Mac OS X v10.0 and later.
kATSUVerticalCharacterTag

Specifies which direction (vertical or horizontal) glyphs should be drawn. The associated value is of type ATSUVerticalCharacterType and has a default value of kATSUStronglyHorizontal. See “Vertical Character Types” for more information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSUImposeWidthTag

Specifies an imposed width. The associated value is of type ATSUTextMeasurement and has a default value of 0; all glyphs use their own font defined advance widths.

Available in Mac OS X v10.0 and later.
kATSUBeforeWithStreamShiftTag

Specifies a uniform shift parallel to the baseline of the positions of individual pairs or sets of glyphs in the style run that’s applied before (to the left) the glyphs of the style run. The associated value is of type Fixed and has a default value of 0. Starting with Mac OS version 10.3, glyphs cannot be negatively shifted such that later glyphs appear before earlier glyphs. In other words, ATSUI limits the shift to a value that is, at most, the advance of the previous glyph.

Available in Mac OS X v10.0 and later.
kATSUAfterWithStreamShiftTag

Specifies a uniform shift parallel to the baseline of the positions of individual pairs or sets of glyphs in the style run that’s applied after (to the right) the glyphs of the style run. The associated value is of type Fixed and has a default value of 0. Starting with Mac OS version 10.3, glyphs cannot be negatively shifted such that later glyphs appear before earlier glyphs. In other words, ATSUI limits the shift to a value that is, at most, the advance of the current glyph.

Available in Mac OS X v10.0 and later.
kATSUCrossStreamShiftTag

Specifies the distance to raise or lower glyphs in the style run perpendicular to the text stream. This shift is vertical for horizontal text and horizontal for vertical text. The associated value (in points, 72 per inch) is of type Fixed and has a default value of 0.

Available in Mac OS X v10.0 and later.
kATSUTrackingTag

Specifies the relative proportion of font-defined adjustments to apply to interglyph positions. The associated value is of type Fixed and has a default value of kATSNoTracking. See “Line Height and Font Tracking Selectors” for information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSUHangingInhibitFactorTag

Specifies to what degree punctuation glyphs can hang beyond the end of a line for justification purposes. The associated value is a Fract value between 0 and 1 and has a default value of 0.

Available in Mac OS X v10.0 and later.
kATSUKerningInhibitFactorTag

Specfies how much to inhibit kerning; that is, the increase or decrease the space between glyphs. The associated value is a Fract value between 0 and 1 and has a default value of 0.

Available in Mac OS X v10.0 and later.
kATSUDecompositionFactorTag

Specifies the fractional adjustment to the font-specified threshold at which ligature decomposition occurs during justification. The associated value is a Fract value between -1.0 and 1.0 and has a default value of 0 (no adjustment to the font-specified threshold).

Available in Mac OS X v10.0 and later.
kATSUBaselineClassTag

Specfies the preferred baseline (such as Roman, hanging, or ideographic centered) to use for text of a given font in a style run. The associated value is of type BslnBaselineClass (see SFNTLayoutTypes.h) and has a default value of kBSLNRomanBaseline. You can set the value to kBSLNNoBaselineOverride to use intrinsic baselines.

Available in Mac OS X v10.0 and later.
kATSUPriorityJustOverrideTag

Specfies the degree to which ATSUI should override justification behavior for glyphs in the style run. The associated value is of type ATSJustWidthDeltaEntryOverride. The default values in this structure are all 0.

Available in Mac OS X v10.0 and later.
kATSUNoLigatureSplitTag

Specifies whether or not ligatures and compound characters in a style have divisible components. The associated value is a Boolean and has a default value of false; ligatures and compound characters have divisible components.

Available in Mac OS X v10.0 and later.
kATSUNoCaretAngleTag

Specfies whether the text caret or edges of a highlighted area are always parallel to the slant of the style run’s text or always perpendicular to the baseline. The associated value is a Boolean and has a default value of false; use the character's angularity to determine its boundaries.

Available in Mac OS X v10.0 and later.
kATSUSuppressCrossKerningTag

Specifies whether or not to suppress cross kerning. The associated value is a Boolean and has a default value of false; do not suppress automatic cross kerning (defined by font).

Available in Mac OS X v10.0 and later.
kATSUNoOpticalAlignmentTag

Specfies the amount to which ATSUI should adjust glyph positions at the ends of lines to give a more even visual appearance to margins. The associated value is a Boolean and has a default value of false; do not suppress character's automatic optical positional alignment

Available in Mac OS X v10.0 and later.
kATSUForceHangingTag

Specifies to treat glyphs in a style run as hanging punctuation, whether or not the font designer intended them to be. The associated value is a Boolean and has a default value of false; do not force the character's to hang beyond the line boundaries

Available in Mac OS X v10.0 and later.
kATSUNoSpecialJustificationTag

Specifies whether processes (such as glyph stretching and ligature decomposition) that occur at the end of the justification process should be applied. The associated value is a Boolean and has a default value of false; perform post-compensation justification if needed

Available in Mac OS X v10.0 and later.
kATSUStyleTextLocatorTag

Specifies style text locator. The associated value is of type TextBreakLocatorRef and has a default value of NULL—region derived locator or the default Text Utilities locator. 

Available in Mac OS X v10.0 and later.
kATSUStyleRenderingOptionsTag

Specifies style rendering options. The associated value is of type ATSUStyleRenderingOptions and has a default value of kATSStyleApplyHints—ATS glyph rendering uses hinting. See “Style Rendering Options” for more information on the values that can be associated with this tag.

Available in Mac OS X v10.0 and later.
kATSUAscentTag

Specifies the ascent value of a style’s font. The associated value is of type ATSUTextMeasurement and has a default value of the ascent value of the style object’s font with the current point size.

Available starting with Mac OS X version 10.2.
kATSUDescentTag

Specifies the descent value of a style’s font. The associated value is of type ATSUTextMeasurement and has a default value of the descent value of the style object’s font with the current point size. The leading value is not included as par of the descent.

Available starting with Mac OS X version 10.2.
kATSULeadingTag

Specifies the leading value of a style’s font. The associated value is of type ATSUTextMeasurement and has a default value of the leading value of the style object’s font with the current point size.

Available starting with Mac OS X version 10.2.
kATSUGlyphSelectorTag

Specifies a glyph collection. The associated value is an address to an ATSUGlyphSelector data structure. Using this tag allows you access to characters in the fonts that otherwise would not be accessible. You can choose the variant glyph by providing a font-specific glyph ID or a CID. For more information on CID conventions, see http://www.adobe.com. You can get the variant glyph information from an input method through the Text Services Manager using the Carbon event key, kEventParamTextInputGlyphInfoArray.

Available starting with Mac OS X version 10.2.
kATSURGBAlphaColorTag

Specifies RGB color with an alpha channel. The associated value is of type ATSURGBAlphaColor and has a default value of (0,0,0,1).

Available starting with Mac OS X version 10.2.
kATSUFontMatrixTag

Specifies a font transformation matrix. The associated value is of type CGAffineTransform. (See the Quartz 2D reference documentation for more information on this data type.) You can use a font matrix to achieve effects through ATSUI at a style-run level that were previously available only by changing settings directly in a CGContext. When you use the tag kATSUFontMatrixTag, you associate a font transformation matrix with an ATSUStyle object. You can set the values in the font transformation matrix to achieve such effects as reversing glyphs across the X-axes and rotating glyphs Note that ATSUI’s layout uses the transformed metrics so layout will be effected and in some cases the effects might be unexpected. For example, for a transformation that mirrors the glyph across the Y-axes the metrics are in reverse and glyphs are rendered on top of each other.

Available starting with Mac OS X version 10.2. 
kATSUStyleUnderlineCountOptionTag

Specifies the number of strokes to be drawn for an underline. The associated value is of type ATSUStyleLineCountType. The default value is kATSUStyleSingleLineCount. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleUnderlineColorOptionTag

Specifies the color of the strokes to draw for an underlined run of text. The associated value is of type CGColorRef. The default value is NULL. If NULL, the text color is used. The CGColor object (CGColorRef) is retained by the style object in which it is set. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleStrikeThroughTag

Specifies strikethrough style. The associated value is of type Boolean. The default value is false. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleStrikeThroughCountOptionTag

Specifies the number of strokes to be drawn for a strikethrough. The associated value is of type ATSUStyleLineCountType. The default value is kATSUStyleSingleLineCount. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleStrikeThroughColorOptionTag

Specifies the color of the strokes to draw for a strikethrough style. The associated value is of type CGColorRef. The CGColor object (CGColorRef) is retained by the style object in which it is set. The default value is NULL. If NULL, the text color is used. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleDropShadowTag

Specifies the text should be drawn with a drop shadow. The associated value is of type Boolean. The default value is false. Only takes effect if a CGContext is used for drawing. If you set this style attribute, you also need to set the drop shadow color using the tag kATSUStyleDropShadowColorOptionTag.

Available in Mac OS X version 10.3 and later.
kATSUStyleDropShadowBlurOptionTag

Specifies the amount of blur for a drop shadow. The associated value is of type float. The default value is 0.0. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleDropShadowColorOptionTag

Specifies the color and opacity of a drop shadow. The associated value is of type CGColoreRef. The default value is NULL. You need to set the CGColoreRef to a value other than NULL if you want to see the drop shadow. May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUStyleDropShadowOffsetOptionTag

Specifies the amount of offset from the text to be used when drawing a drop shadow. The associated value is of type CGSize. The default value is (3.0, -3.0). May be set as a style attribute.

Available in Mac OS X version 10.3 and later.
kATSUMaxStyleTag

A convenience tag that specfies the upper limit of style attribute tags. 

Available in Mac OS X v10.0 and later.
kATSULanguageTag

This tag is obsolete. Instead use kATSULangRegionTag.

Available in Mac OS X v10.0 and later.
kATSUMaxATSUITagValue

Specfies this maximum Apple ATSUI reserved tag value. If you define a tag, it must have a value larger than the value of this tag. 

Available in Mac OS X v10.0 and later.
Discussion

An attribute tag cannot be used in versions of the Mac OS that are earlier than the version in which the tag was introduced. For example, a tag available in Mac OS version 10.2 cannot be used in Mac OS version 10.1 or earlier. You can call the function Gestalt to check version information for ATSUI.

Attribute tags indicatesthe particular type of attribute under consideration: font, size, color, and so on. Each style run may have at most one attribute with a given attribute tag (that is, a style run can't have more than one font or size) but may have none.

Some of the constants specify attributes that are applied to a style run, while other attributes are applied to an entire text layout object or to just a line in a text layout object. The constant descriptions assume horizontal text. If you set or get the an attribute that has been set for vertical text, you should interpret the constant descriptions accordingly.

Most of the constants in this section are described in further detail in Inside Mac OS X: Rendering Unicode Text With ATSUI. Where appropriate, that document provides illustrations that show the effect of applying an attribute. It also describes how to write code that sets style, line, and layout attributes. 

A style run may have at most one style attribute with a given attribute tag. That is, a style run can't have more than one font or size attribute set but the style run does not need to have any attribute set explicitly. 

When you set an attribute value for a line, the value overrides the attribute value set for the text layout object that contains the line. This is true even if you set line attributes before you set attributes for the entire text layout object that contains the line.

You can create your own attribute tag as long as your tag is outside those values reserved by Apple— 0 to 65,535 (0 to 0x0000FFFF). See Rendering Unicode Text With ATSUI for information on creating and registering your own attribute tags.*/
typedef UInt32 ATSUAttributeTag;
enum {
   kATSULineWidthTag = 1L,
   kATSULineRotationTag = 2L,
   kATSULineDirectionTag = 3L,
   kATSULineJustificationFactorTag = 4L,
   kATSULineFlushFactorTag = 5L,
   kATSULineBaselineValuesTag = 6L,
   kATSULineLayoutOptionsTag = 7L,
   kATSULineAscentTag = 8L,
   kATSULineDescentTag = 9L,
   kATSULineLangRegionTag = 10L,
   kATSULineTextLocatorTag = 11L,
   kATSULineTruncationTag = 12L,
   kATSULineFontFallbacksTag = 13L,
   kATSULineDecimalTabCharacterTag = 14L,
   kATSULayoutOperationOverrideTag = 15L,
   kATSULineHighlightCGColorTag  = 17L,
   kATSUMaxLineTag = 18L,
   kATSULineLanguageTag = 10L,
   kATSUCGContextTag = 32767L,
   kATSUQDBoldfaceTag = 256L,
   kATSUQDItalicTag = 257L,
   kATSUQDUnderlineTag = 258L,
   kATSUQDCondensedTag = 259L,
   kATSUQDExtendedTag = 260L,
   kATSUFontTag = 261L,
   kATSUSizeTag = 262L,
   kATSUColorTag = 263L,
   kATSULangRegionTag = 264L,
   kATSUVerticalCharacterTag = 265L,
   kATSUImposeWidthTag = 266L,
   kATSUBeforeWithStreamShiftTag = 267L,
   kATSUAfterWithStreamShiftTag = 268L,
   kATSUCrossStreamShiftTag = 269L,
   kATSUTrackingTag = 270L,
   kATSUHangingInhibitFactorTag = 271L,
   kATSUKerningInhibitFactorTag = 272L,
   kATSUDecompositionFactorTag = 273L,
   kATSUBaselineClassTag = 274L,
   kATSUPriorityJustOverrideTag = 275L,
   kATSUNoLigatureSplitTag = 276L,
   kATSUNoCaretAngleTag = 277L,
   kATSUSuppressCrossKerningTag = 278L,
   kATSUNoOpticalAlignmentTag = 279L,
   kATSUForceHangingTag = 280L,
   kATSUNoSpecialJustificationTag = 281L,
   kATSUStyleTextLocatorTag = 282L,
   kATSUStyleRenderingOptionsTag = 283L,
   kATSUAscentTag         = 284L,
   kATSUDescentTag = 285L,
   kATSULeadingTag = 286L,
   kATSUGlyphSelectorTag = 287L,
   kATSURGBAlphaColorTag     = 288L,
   kATSUFontMatrixTag = 289L,
   kATSUStyleUnderlineCountOptionTag = 290L,
   kATSUStyleUnderlineColorOptionTag = 291L,
   kATSUStyleStrikeThroughTag    = 292L,
   kATSUStyleStrikeThroughCountOptionTag = 293L,
   kATSUStyleStrikeThroughColorOptionTag = 294L,
   kATSUStyleDropShadowTag = 295L,
   kATSUStyleDropShadowBlurOptionTag = 296L,
   kATSUStyleDropShadowOffsetOptionTag = 297L,
   kATSUStyleDropShadowColorOptionTag = 298L,
   kATSUMaxStyleTag = 299L,
   kATSULanguageTag = 264L,
   kATSUMaxATSUITagValue = 65535L
};


/*ATSUFontID

Represents the unique identifier of a font to the font management system in ATSUI.

typedef FMFont ATSUFontID;
Discussion

You pass the ATSUFontID type with functions that set and obtain font information. The ATSUFontID type is passed back by functions that count fonts installed on a users’s system. The ATSUFontID type can be also used to set and get the font in a style run; see “Attribute Tags”. 

An ATSUFontID specifies a font family and instance. This value is not guaranteed to remain constant if the system is restarted. You should obtain the font’s unique name and store that information in documents for which you need persistent font information.
Availability
Available in Mac OS X v10.0 and later.*/
typedef FMFont ATSUFontID;

#ifdef __cplusplus
}
#endif

#endif
