#ifndef MEDIAHANDLERS_H
#define MEDIAHANDLERS_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Media Task Flags

Constants that represent flags for media tasks.

enum {
   mDidDraw                      = 1 << 0,
   mNeedsToDraw                  = 1 << 2,
   mDrawAgain                    = 1 << 3,
   mPartialDraw                  = 1 << 4,
   mWantIdleActions              = 1 << 5
};
enum {
   mMustDraw                     = 1 << 3,
   mAtEnd                        = 1 << 4,
   mPreflightDraw                = 1 << 5,
   mSyncDrawing                  = 1 << 6,
   mPrecompositeOnly             = 1 << 9,
   mSoundOnly                    = 1 << 10,
   mDoIdleActionsBeforeDraws     = 1 << 11,
   mDisableIdleActions           = 1 << 12
};
enum {
   mOpaque                       = 1L << 0,
   mInvisible                    = 1L << 1
};
Declared In
MediaHandlers.h*/
enum {
   mDidDraw                      = 1 << 0,
   mNeedsToDraw                  = 1 << 2,
   mDrawAgain                    = 1 << 3,
   mPartialDraw                  = 1 << 4,
   mWantIdleActions              = 1 << 5
};
enum {
   mMustDraw                     = 1 << 3,
   mAtEnd                        = 1 << 4,
   mPreflightDraw                = 1 << 5,
   mSyncDrawing                  = 1 << 6,
   mPrecompositeOnly             = 1 << 9,
   mSoundOnly                    = 1 << 10,
   mDoIdleActionsBeforeDraws     = 1 << 11,
   mDisableIdleActions           = 1 << 12
};
enum {
   mOpaque                       = 1L << 0,
   mInvisible                    = 1L << 1
};


/*Data Handler Flags

Constants that represent data handler flags.

enum {
   handlerHasSpatial             = 1 << 0,
   handlerCanClip                = 1 << 1,
   handlerCanMatte               = 1 << 2,
   handlerCanTransferMode        = 1 << 3,
   handlerNeedsBuffer            = 1 << 4,
   handlerNoIdle                 = 1 << 5,
   handlerNoScheduler            = 1 << 6,
   handlerWantsTime              = 1 << 7,
   handlerCGrafPortOnly          = 1 << 8,
   handlerCanSend                = 1 << 9,
   handlerCanHandleComplexMatrix = 1 << 10,
   handlerWantsDestinationPixels = 1 << 11,
   handlerCanSendImageData       = 1 << 12,
   handlerCanPicSave             = 1 << 13
};
Declared In
MediaHandlers.h*/
enum {
   handlerHasSpatial             = 1 << 0,
   handlerCanClip                = 1 << 1,
   handlerCanMatte               = 1 << 2,
   handlerCanTransferMode        = 1 << 3,
   handlerNeedsBuffer            = 1 << 4,
   handlerNoIdle                 = 1 << 5,
   handlerNoScheduler            = 1 << 6,
   handlerWantsTime              = 1 << 7,
   handlerCGrafPortOnly          = 1 << 8,
   handlerCanSend                = 1 << 9,
   handlerCanHandleComplexMatrix = 1 << 10,
   handlerWantsDestinationPixels = 1 << 11,
   handlerCanSendImageData       = 1 << 12,
   handlerCanPicSave             = 1 << 13
};


/*MediaGetName

Returns the name of the media type.

ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
name

The name of the media type; for example, the video media handler returns the string 'video'.
requestedLanguage

The language in which you want the name returned; see Localization Codes.
actualLanguage

A pointer to the actual language in which the name is returned; see Localization Codes
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage );

/*GetMovieCompleteParams

Defines the layout of the complete movie parameter structure used by MediaInitialize.

struct GetMovieCompleteParams {
   short              version;
   Movie              theMovie;
   Track              theTrack;
   Media              theMedia;
   TimeScale          movieScale;
   TimeScale          mediaScale;
   TimeValue          movieDuration;
   TimeValue          trackDuration;
   TimeValue          mediaDuration;
   Fixed              effectiveRate;
   TimeBase           timeBase;
   short              volume;
   Fixed              width;
   Fixed              height;
   MatrixRecord       trackMovieMatrix;
   CGrafPtr           moviePort;
   GDHandle           movieGD;
   PixMapHandle       trackMatte;
   QTAtomContainer    inputMap;
};
Fields
version
Discussion

Specifies the version of this structure. This field is always set to 1.
theMovie
Discussion

Identifies the movie that contains the current media's track. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain information about the movie that is using your media.
theTrack
Discussion

Identifies the track that contains the current media. This track identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain information about the track that contains your media. For example, you might call GetTrackNextInterestingTime to examine the track's edit list.
theMedia
Discussion

Identifies the current media. This media identifier is supplied by the Movie Toolbox. Your derived media handler can use this identifier to read samples or sample descriptions from the current media, using GetMediaSample and GetMediaSampleDescription. 
movieScale
Discussion

Specifies the time scale of the movie that contains the current media's track. If the Movie Toolbox changes the movie's time scale, the toolbox calls your derived media handler's MediaSetMovieTimeScale function.
mediaScale
Discussion

Specifies the time scale of the current media. If the Movie Toolbox changes your media's time scale, the toolbox calls your derived media handler's MediaSetMediaTimeScale function.
movieDuration
Discussion

Contains the movie's duration. This value is expressed in the movie's time scale.
trackDuration
Discussion

Contains the track's duration. This value is expressed in the movie's time scale.
mediaDuration
Discussion

Contains the media's duration. This value is expressed in the media's time scale.
effectiveRate
Discussion

Contains the media's effective rate. This rate ties the media's time scale to the passage of absolute time, and does not necessarily correspond to the movie's rate. This value takes into account any master time bases that may be serving the media's time base. The value of this field indicates the number of time units (in the media's time scale) that pass each second. This rate is represented as a 32-bit, fixed-point number. The high-order 16 bits contain the integer portion, and the low-order 16 bits contain the fractional portion. The rate is negative when time is moving backward for the media. Whenever the Movie Toolbox changes your media's effective rate, it calls your derived media handler's MediaSetRate function.
timeBase
Discussion

Identifies the media's time base.
volume
Discussion

Contains the media's current volume setting. This value is represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer portion; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. If QuickTime changes your media's volume, it calls your derived media handler's MediaGSetVolume function.
width
Discussion

Indicates the width, in pixels, of the track rectangle. This field, along with the height field, specifies a rectangle that surrounds the image that is displayed when the current media is played. This value corresponds to the x coordinate of the lower-right corner of the rectangle and is expressed as a fixed-point number. If the Movie Toolbox modifies this rectangle, the toolbox calls your derived media handler's MediaSetDimensions function. Note that your media need not present only a rectangular image. The Movie Toolbox can use a clipping region to cause your media's image to be displayed in a region of arbitrary shape, and it can use a matte to control the image's transparency. The toolbox calls your derived media handler's MediaSetClip function whenever it changes your media's clipping region. The trackMatte field in this structure specifies a matte region.
height
Discussion

Indicates the height, in pixels, of the track rectangle. This value corresponds to the y coordinate of the lower-right corner of the rectangle and is expressed as a fixed-point number.
trackMovieMatrix
Discussion

Specifies the matrix that transforms your media's pixels into the movie's coordinate system. The Movie Toolbox obtains this matrix by concatenating the track matrix and the movie matrix. You should use this matrix whenever you are displaying graphical data from your media. Whenever the Movie Toolbox modifies this matrix, it calls your derived media handler's MediaSetMatrix function.
moviePort
Discussion

Indicates the movie's graphics port. Whenever the Movie Toolbox changes the movie's graphics world, it calls your derived media handler's MediaSetGWorld function.
movieGD
Discussion

Specifies the movie's graphics device. Whenever the Movie Toolbox changes the movie's graphics world, it calls your derived media handler's MediaSetGWorld function.
trackMatte
Discussion

Identifies the matte region assigned to the track that uses your media. This field contains a handle to a pixel map that contains a blend matte. Your component is not responsible for disposing of this matte. If there is no matte, this field is set to NIL.
inputMap
Discussion

A reference to the media's input map. The media input map should not be modified or disposed.
Related Functions
MediaInitialize 
Declared In
MediaHandlers.h*/

struct GetMovieCompleteParams {
   short              version;
   Movie              theMovie;
   Track              theTrack;
   Media              theMedia;
   TimeScale          movieScale;
   TimeScale          mediaScale;
   TimeValue          movieDuration;
   TimeValue          trackDuration;
   TimeValue          mediaDuration;
   Fixed              effectiveRate;
   TimeBase           timeBase;
   short              volume;
   Fixed              width;
   Fixed              height;
   MatrixRecord       trackMovieMatrix;
   CGrafPtr           moviePort;
   GDHandle           movieGD;
   PixMapHandle       trackMatte;
   QTAtomContainer    inputMap;
};
typedef struct GetMovieCompleteParams GetMovieCompleteParams;

/*MediaEQSpectrumBandsRecord

Provides data for MediaGetSoundEqualizerBands and MediaSetSoundEqualizerBands.

struct MediaEQSpectrumBandsRecord {
   short               count;
   UnsignedFixedPtr    frequency;
};
Fields
count
Discussion

Number of frequencies in this structure.
frequency
Discussion

Pointer to array of frequencies.
Related Functions
MediaGetSoundEqualizerBands
MediaSetSoundEqualizerBands 
Declared In
MediaHandlers.h*/
struct MediaEQSpectrumBandsRecord {
   short               count;
   UnsignedFixedPtr    frequency;
};

typedef struct  MediaEQSpectrumBandsRecord   MediaEQSpectrumBandsRecord;
typedef  MediaEQSpectrumBandsRecord * MediaEQSpectrumBandsRecordPtr;

//function

/*MediaSetGraphicsMode

Sets the graphics mode and blend color of any media handler.

ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
mode

The graphics mode of the media handler; see Graphics Transfer Modes.
opColor

A pointer to the color for use in blending and transparent operations. The media handler passes this color to QuickDraw as appropriate when you draw in addPin, subPin, blend, transparent, or graphicsModeStraightAlphaBlend mode.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor );


/*MediaSetPublicInfo

Undocumented

ComponentResult MediaSetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            dataSize );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
infoSelector

Undocumented
infoDataPtr

Undocumented
dataSize

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            dataSize );

/*MediaGetPublicInfo

Undocumented

ComponentResult MediaGetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            *ioDataSize );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
infoSelector

Undocumented
infoDataPtr

Undocumented
ioDataSize

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/

ComponentResult MediaGetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            *ioDataSize );

/*MediaSetActive

Enables and disables media.

ComponentResult MediaSetActive (
   MediaHandler    mh,
   Boolean         enableMedia );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
enableMedia

A Boolean value that indicates whether your media is enabled or disabled. If this parameter is set to TRUE, your media is enabled; if the parameter is FALSE, your media is disabled.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your derived media handler should support this function if you perform your own scheduling or if your media handler uses significant amounts of temporary storage. If you are doing your own scheduling (that is, you have set the handlerNoScheduler flag to 1 in the flags parameter of the MediaSetHandlerCapabilities function), your media handler needs to keep account of the media's active state so that you can properly respond to Movie Toolbox requests. When your media is disabled, you may choose to dispose of temporary storage you have allocated, so that the storage is available to other programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetActive (
   MediaHandler    mh,
   Boolean         enableMedia );

/*MediaInitialize

Prepares a derived media handler component to provide access to its media.

ComponentResult MediaInitialize (
   MediaHandler              mh,
   GetMovieCompleteParams    *gmc );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
gmc

A pointer to a GetMovieCompleteParams structure. You can obtain information about the current media from this structure. You should copy any values you need to save into your derived media handler's local data area. Because this data structure is owned by the Movie Toolbox, you do not need to worry about disposing of any of the data in it.
Return Value

See Error Codes. Returns noErr if there is no error. If you return an error, the Movie Toolbox disables the track that uses your media. In cases where your media has just been created, the Movie Toolbox immediately disposes of your media.
Discussion

This function gives your media handler an opportunity to get ready to support the Movie Toolbox. As part of these preparations, your derived media handler should report its capabilities to the base media handler by calling MediaSetHandlerCapabilities. You may choose to examine the data in the GetMovieCompleteParams structure; you may also save values from this structure. If you save references to structures (such as the matte pixel map), do not dispose of the memory associated with these structures. The Movie Toolbox owns these structures.

Note that the Movie Toolbox may call other functions supported by your media handler before it calls your MediaInitialize function. In particular, it may call your MediaGetMediaInfo and MediaPutMediaInfo functions. However, before the Movie Toolbox tries to do anything with the data in your media, it will call your MediaInitialize function. The Movie Toolbox loads the movie's data using functions that are supported by the base media handler; your media handler does not have to support those functions.
Special Considerations

All derived media handlers should support this function. In addition, if your media handler saves values from the GetMovieCompleteParams structure that may change, be sure to support the corresponding functions that allow the Movie Toolbox to report changes to your media handler. For example, if your handler saves the movie time scale from the movieScale field, you should also support the MediaSetMovieTimeScale function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaInitialize (
   MediaHandler              mh,
   GetMovieCompleteParams    *gmc );

/*MediaSetSoundLevelMeteringEnabled

Enables or disables sound level metering for a media handler.

ComponentResult MediaSetSoundLevelMeteringEnabled (
   MediaHandler    mh,
   Boolean         enable );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
enable

Pass TRUE to enable sound level metering, FALSE to disable it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundLevelMeteringEnabled (
   MediaHandler    mh,
   Boolean         enable );

/*MediaSetSoundEqualizerBands

Sets sound equalizer bands for a media handler.

ComponentResult MediaSetSoundEqualizerBands (
   MediaHandler                     mh,
   MediaEQSpectrumBandsRecordPtr    spectrumInfo );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
spectrumInfo

A pointer to a MediaEQSpectrumBandsRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundEqualizerBands (
   MediaHandler                     mh,
   MediaEQSpectrumBandsRecordPtr    spectrumInfo );

/*MediaDoIdleActions

Forces a media handler to perform its idle-time actions.

ComponentResult MediaDoIdleActions (
   MediaHandler    mh );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaDoIdleActions (
   MediaHandler    mh );

/*MediaGetSoundEqualizerBandLevels

Gets the sound equalizer band levels for a media handler.

ComponentResult MediaGetSoundEqualizerBandLevels (
   MediaHandler    mh,
   UInt8           *bandLevels );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
bandLevels

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetSoundEqualizerBandLevels (
   MediaHandler    mh,
   UInt8           *bandLevels );

/*MediaSetHandlerCapabilities

Lets a derived media handler report its capabilities to the base media handler.

ComponentResult MediaSetHandlerCapabilities (
   MediaHandler    mh,
   long            flags,
   long            flagsMask );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
flags

Flags (see below) that specify the capabilities of your derived media handler. This parameter contains a number of flags, each of which corresponds to a particular feature. You may work with more than one flag at a time. Be sure to set unused flags to 0. See these constants: 
handlerHasSpatial
handlerCanClip
handlerCanMatte
handlerCanTransferMode
handlerNeedsBuffer
handlerNoIdle
handlerNoScheduler
handlerWantsTime
handlerCGrafPortOnly
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the base media handler to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single flag without altering the settings of other flags.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your media handler may call this function at any time. In general, you should call it from your MediaInitialize function , so that you report your capabilities to the base media handler before the Movie Toolbox starts working with your media. You may call this function again later, in response to changing conditions. For example, if your media handler receives a matrix that it cannot accommodate from the MediaSetMatrix function, you can allow the base media handler to handle your drawing by calling this function and setting the handlerNeedsBuffer flag in both the flags parameter and the flagsMask parameter to 1.
Special Considerations

Note that this function is provided by the base media handler; your media handler does not support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetHandlerCapabilities (
   MediaHandler    mh,
   long            flags,
   long            flagsMask );


#ifdef __cplusplus
}
#endif
#endif