#ifndef QUICKTIMEVRFORMAT_H
#define QUICKTIMEVRFORMAT_H

#ifndef __QUICKTIMEVRFORMAT__
#define __QUICKTIMEVRFORMAT__

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMEVR_H
#include <QuickTime/QuickTimeVR.h>
#endif

//#include <HYS/QuickTime/QuickTimeVRFormat.h>
#include <APPLE/QuickTime/QuickTimeVRFormat.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

/*Node Location Flag
enum {
    kQTVRSameFile                               = 0
};*/
enum {
    kQTVRSameFile                               = 0
};

/*Panorama Sample Flag
enum {
    kQTVRPanoFlagHorizontal                     = 1 << 0,
    kQTVRPanoFlagAlwaysWrap                     = 1 << 2
};*/
enum {
    kQTVRPanoFlagHorizontal                     = 1 << 0,
    kQTVRPanoFlagAlwaysWrap                     = 1 << 2
};

/*Many of the atom structures contain two version fields, majorVersion and minorVersion. The values of these fields correspond to the constants kQTVRMajorVersion and kQTVRMinorVersion found in the header file QuickTimeVRFormat.h. For QuickTime 2.0 files, these values are 2 and 0.*/
#define kQTVRMajorVersion (2)
#define kQTVRMinorVersion (0)

/*getTrackResolution
public short getTrackResolution()
kQTVRFullTrackRes = kQTVRFullRes, kQTVRHalfTrackRes = kQTVRHalfRes, kQTVRQuarterTrackRes = kQTVRQuarterRes, kQTVRPreviewTrackRes = 0x8000*/
enum {
kQTVRPreviewTrackRes = 0x8000
};

/*Track Reference Types
enum {
kQTVRImageTrackRefType      = FOUR_CHAR_CODE('imgt'),
kQTVRHotSpotTrackRefType    = FOUR_CHAR_CODE('hott')
};*/
enum {
kQTVRImageTrackRefType      = FOUR_CHAR_CODE('imgt'),
kQTVRHotSpotTrackRefType    = FOUR_CHAR_CODE('hott')
};

/*maging Property Valid Flags
enum {
    kQTVRValidCorrection                        = 1 << 0,
    kQTVRValidQuality                           = 1 << 1,
    kQTVRValidDirectDraw                        = 1 << 2,
    kQTVRValidFirstExtraProperty                = 1 << 3
};*/
enum {
    kQTVRValidCorrection                        = 1 << 0,
    kQTVRValidQuality                           = 1 << 1,
    kQTVRValidDirectDraw                        = 1 << 2,
    kQTVRValidFirstExtraProperty                = 1 << 3
};

/*Controller Subtype and ID
enum {
    kQTControllerType                           = FOUR_CHAR_CODE('ctyp').
    kQTControllerID                             = 1
};*/
enum {
    kQTControllerType                           = FOUR_CHAR_CODE('ctyp'),
    kQTControllerID                             = 1
};

/*VR Media

This section describes the QuickTime VR world and node information atom containers, which can be obtained by calling the QuickTime VR Manager routines QTVRGetVRWorld and QTVRGetNodeInfo. Those routines, as well as a complete discussion of QuickTime VR and how your application can create QuickTime VR movies, are described in detail in Programming With QuickTime VR, available at http://developer.apple.com/documentation/Quicktime/Quicktime.html. 

Many atom types contained in the VR world and node information atom containers are unique within their container. For example, each has a single header atom. Most parent atoms within an atom container are unique as well, such as the node parent atom in the VR world atom container or the hot spot parent atom in the node information atom container. For these one-time-only atoms, the atom ID is always set to 1. Unless otherwise mentioned in the descriptions of the atoms that follow, assume that the atom ID is 1.

Note that many atom structures contain two version fields, majorVersion and minorVersion. The values of these fields correspond to the constants kQTVRMajorVersion and kQTVRMinorVersion found in the header file QuickTimeVRFormat.h. For QuickTime 2.0 files, these values are 2 and 0.

QuickTime provides a number of routines for both creating and accessing atom containers. 

Some of the leaf atoms within the VR world and node information atom containers contain fields that specify the ID of string atoms that are siblings of the leaf atom. For example, the VR world header atom contains a field for the name of the scene. The string atom is a leaf atom whose atom type is kQTVRStringAtomType ('vrsg'). Its atom ID is that specified by the referring leaf atom. 

A string atom contains a string. The structure of a string atom is defined by the QTVRStringAtom data type:
typedef struct QTVRStringAtom {
    UInt16                              stringUsage;
    UInt16                              stringLength;
    unsigned char                       theString[4];
} QTVRStringAtom, *QTVRStringAtomPtr;

Field descriptions
stringUsage

The string usage. This field is unused.
stringLength

The length, in bytes, of the string.
theString

The string. The string atom structure is extended to hold this string.

Each string atom may also have a sibling leaf atom called the string encoding atom. The string encoding atom’s atom type is kQTVRStringEncodingAtomType ('vrse'). Its atom ID is the same as that of the corresponding string atom. The string encoding atom contains a single variable, TextEncoding, a UInt32, as defined in the header file TextCommon.h. The value of TextEncoding is handed, along with the string, to the routine QTTextToNativeText for conversion for display on the current machine. The routine QTTextToNativeText is found in the header file Movies.h.

Note: The header file TextCommon.h contains constants and routines for generating and handling text encodings. <8bat>u*/
typedef struct QTVRStringAtom {
    UInt16                              stringUsage;
    UInt16                              stringLength;
    unsigned char                       theString[4];
} QTVRStringAtom, *QTVRStringAtomPtr;


/*VR World Header Atom Structuretypedef 
struct QTVRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRWorldHeaderAtom, *QTVRWorldHeaderAtomPtr;*/
struct QTVRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
};
typedef struct  QTVRWorldHeaderAtom QTVRWorldHeaderAtom;
typedef QTVRWorldHeaderAtom *QTVRWorldHeaderAtomPtr;


/*VR World Atom Types
enum {
    kQTVRWorldHeaderAtomType    = FOUR_CHAR_CODE('vrsc'),
    kQTVRImagingParentAtomType  = FOUR_CHAR_CODE('imgp'),
    kQTVRPanoImagingAtomType    = FOUR_CHAR_CODE('impn'),
    kQTVRObjectImagingAtomType  = FOUR_CHAR_CODE('imob'),
    kQTVRNodeParentAtomType     = FOUR_CHAR_CODE('vrnp'),
    kQTVRNodeIDAtomType         = FOUR_CHAR_CODE('vrni'),
    kQTVRNodeLocationAtomType   = FOUR_CHAR_CODE('nloc')
};*/
enum {
    kQTVRWorldHeaderAtomType    = FOUR_CHAR_CODE('vrsc'),
    kQTVRImagingParentAtomType  = FOUR_CHAR_CODE('imgp'),
    kQTVRPanoImagingAtomType    = FOUR_CHAR_CODE('impn'),
    kQTVRObjectImagingAtomType  = FOUR_CHAR_CODE('imob'),
    kQTVRNodeParentAtomType     = FOUR_CHAR_CODE('vrnp'),
    kQTVRNodeIDAtomType         = FOUR_CHAR_CODE('vrni'),
    kQTVRNodeLocationAtomType   = FOUR_CHAR_CODE('nloc')
};



/*VR World Header Atom Structure

The VR world header atom is a leaf atom. Its atom type is kQTVRWorldHeaderAtomType ('vrsc'). It contains the name of the scene and the default node ID to be used when the file is first opened as well as fields reserved for future use. 

The structure of a VR world header atom is defined by the QTVRWorldHeaderAtom data type:
typedef struct VRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
} VRWorldHeaderAtom, *QTVRWorldHeaderAtomPtr;
QT
QT

Field descriptions
majorVersion

The major version number of the file format.
minorVersion

The minor version number of the file format.
nameAtomID

The ID of the string atom that contains the name of the scene. That atom should be a sibling of the VR world header atom. The value of this field is 0 if no name string atom exists.
defaultNodeID

The ID of the default node (that is, the node to be displayed when the file is first opened).
vrWorldFlags

A set of flags for the VR world. This field is unused.
reserved1

Reserved. This field must be 0.
reserved2

Reserved. This field must be 0.*/

struct VRWorldHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    QTAtomID                            nameAtomID;
    UInt32                              defaultNodeID;
    UInt32                              vrWorldFlags;
    UInt32                              reserved1;
    UInt32                              reserved2;
};
typedef struct  VRWorldHeaderAtom VRWorldHeaderAtom;
typedef VRWorldHeaderAtom *VRWorldHeaderAtomPtr;

/*Node Header Atom Structuretypedef 
struct QTVRNodeHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              nodeType;
    QTAtomID                            nodeID;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRNodeHeaderAtom, *QTVRNodeHeaderAtomPtr;*/
struct QTVRNodeHeaderAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              nodeType;
    QTAtomID                            nodeID;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    UInt32                              reserved1;
    UInt32                              reserved2;
};

typedef struct QTVRNodeHeaderAtom QTVRNodeHeaderAtom;
typedef QTVRNodeHeaderAtom  *QTVRNodeHeaderAtomPtr;


/*Hot Spot Information Atom Structuretypedef 
struct QTVRHotSpotInfoAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              hotSpotType;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    SInt32                              cursorID[3];
    Float32                             bestPan;
    Float32                             bestTilt;
    Float32                             bestFOV;
    FloatPoint                          bestViewCenter;
    Rect                                hotSpotRect;
    UInt32                              flags;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRHotSpotInfoAtom, *QTVRHotSpotInfoAtomPtr;*/

struct QTVRHotSpotInfoAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              hotSpotType;
    QTAtomID                            nameAtomID;
    QTAtomID                            commentAtomID;
    SInt32                              cursorID[3];
    Float32                             bestPan;
    Float32                             bestTilt;
    Float32                             bestFOV;
    FloatPoint                          bestViewCenter;
    Rect                                hotSpotRect;
    UInt32                              flags;
    UInt32                              reserved1;
    UInt32                              reserved2;
};
typedef struct QTVRHotSpotInfoAtom  QTVRHotSpotInfoAtom;
typedef QTVRHotSpotInfoAtom  *QTVRHotSpotInfoAtomPtr;

/*Angle Range Atom Structuretypedef 
struct QTVRAngleRangeAtom {
    Float32                             minimumAngle;
    Float32                             maximumAngle;
} QTVRAngleRangeAtom, *QTVRAngleRangeAtomPtr*/
typedef struct QTVRAngleRangeAtom {
    Float32                             minimumAngle;
    Float32                             maximumAngle;
} QTVRAngleRangeAtom, *QTVRAngleRangeAtomPtr;

/*Cubic View Atom Structure
struct QTVRCubicViewAtom {
    Float32         minPan;
    Float32         maxPan;
    Float32         minTilt;
    Float32         maxTilt;
    Float32         minFieldOfView;
    Float32         maxFieldOfView;
 
    Float32         defaultPan;
    Float32         defaultTilt;
    Float32         defaultFieldOfView;
};
typedef struct QTVRCubicViewAtom    QTVRCubicViewAtom;*/
struct QTVRCubicViewAtom {
    Float32         minPan;
    Float32         maxPan;
    Float32         minTilt;
    Float32         maxTilt;
    Float32         minFieldOfView;
    Float32         maxFieldOfView;
 
    Float32         defaultPan;
    Float32         defaultTilt;
    Float32         defaultFieldOfView;
};
typedef struct QTVRCubicViewAtom    QTVRCubicViewAtom;

/*Sample Description Header Structure
typedef struct QTVRSampleDescription {
    UInt32                              size;
    UInt32                              type;
    UInt32                              reserved1;
    UInt16                              reserved2;
    UInt16                              dataRefIndex;
    UInt32                              data;
} QTVRSampleDescription, *QTVRSampleDescriptionPtr, **QTVRSampleDescriptionHandle;*/
typedef struct QTVRSampleDescription {
    UInt32              descSize;              
    UInt32              descType;  
    UInt32                              size;
    UInt32                              type;
    UInt32                              reserved1;
    UInt16                              reserved2;
    UInt16                              dataRefIndex;
    UInt32                              data;
} QTVRSampleDescription, *QTVRSampleDescriptionPtr, **QTVRSampleDescriptionHandle;

/*Cubic Face Data Atom Structure
struct QTVRCubicFaceData {
    float   orientation[4];
    float   center[2];
    float   aspect;
    float   skew;
};
typedef struct QTVRCubicFaceData    QTVRCubicFaceData;*/

struct QTVRCubicFaceData {
    float   orientation[4];
    float   center[2];
    float   aspect;
    float   skew;
};
typedef struct QTVRCubicFaceData    QTVRCubicFaceData;

/*Panorama Tracks

A movie’s panorama track is a track that contains information about the panoramic nodes in a scene. The media type of the panorama track is 'pano'. Each sample in a panorama track corresponds to a single panoramic node. This sample parallels the corresponding sample in the QTVR track. Panorama tracks do not have a sample description (although QuickTime requires that you specify a dummy sample description when you call AddMediaSample to add a sample to a panorama track). The sample itself contains an atom container that includes a panorama sample atom and other optional atoms.
Panorama Sample Atom Structure

A panorama sample atom has an atom type of kQTVRPanoSampleDataAtomType ('pdat'). It describes a single panorama, including track reference indexes of the scene and hot spot tracks and information about the default viewing angles and the source panoramic image. 

The structure of a panorama sample atom is defined by the QTVRPanoSampleAtom data type:typedef struct QTVRPanoSampleAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    UInt32                              imageRefTrackIndex;
    UInt32                              hotSpotRefTrackIndex;
    Float32                             minPan;
    Float32                             maxPan;
    Float32                             minTilt;
    Float32                             maxTilt;
    Float32                             minFieldOfView;
    Float32                             maxFieldOfView;
    Float32                             defaultPan;
    Float32                             defaultTilt;
    Float32                             defaultFieldOfView;
    UInt32                              imageSizeX;
    UInt32                              imageSizeY;
    UInt16                              imageNumFramesX;
    UInt16                              imageNumFramesY;
    UInt32                              hotSpotSizeX;
    UInt32                              hotSpotSizeY;
    UInt16                              hotSpotNumFramesX;
    UInt16                              hotSpotNumFramesY;
    UInt32                              flags;
    OSType                              panoType;
    UInt32                              reserved2;
} QTVRPanoSampleAtom, *QTVRPanoSampleAtomPtr;

majorVersion

The major version number of the file format.
minorVersion

The minor version number of the file format.
imageRefTrackIndex

The index of the image track reference. This is the index returned by the AddTrackReference function when the image track is added as a reference to the panorama track. There can be more than one image track for a given panorama track and hence multiple references. (A panorama track might have multiple image tracks if the panoramas have different characteristics, which could occur if the panoramas were shot with different size camera lenses.) The value in this field is 0 if there is no corresponding image track.
hotSpotRefTrackIndex

The index of the hot spot track reference.
minPan

The minimum pan angle, in degrees. For a full panorama, the value of this field is usually 0.0.
maxPan

The maximum pan angle, in degrees. For a full panorama, the value of this field is 360.0.
minTilt

The minimum tilt angle, in degrees. For a high-FOV cylindrical panorama, a typical value for this field is –42.5.
maxTilt

The maximum tilt angle, in degrees. For a high-FOV cylindrical panorama, a typical value for this field is +42.5.
minFieldOfView

The minimum vertical field of view, in degrees. For a high-resolution panorama, a typical value for this field is 5.0. The value in this field is 0 for the default minimum field of view, which is 5 percent of the maximum field of view. 
maxFieldOfView

The maximum vertical field of view, in degrees. For a high-resolution panorama, a typical value for this field is 85.0. The value in this field is 0 for the default maximum field of view, which is maxTilt – minTilt.
defaultPan

The default pan angle, in degrees.
defaultTilt

The default tilt angle, in degrees.
defaultFieldOfView

The default vertical field of view, in degrees.
imageSizeX

The width, in pixels, of the panorama stored in the highest resolution image track.
imageSizeY

The height, in pixels, of the panorama stored in the highest resolution image track. 
imageNumFramesX

The number of frames into which the panoramic image is diced horizontally. The width of each frame (which is imageSizeX/imageNumFramesX) should be divisible by 4.
imageNumFramesY

The number of frames into which the panoramic image is diced vertically. The height of each frame (which is imageSizeY/imageNumFramesY) should be divisible by 4. 
hotSpotSizeX

The width, in pixels, of the panorama stored in the highest resolution hot spot image track.
hotSpotSizeY

The height, in pixels, of the panorama stored in the highest resolution hot spot image track.
hotSpotNumFramesX

The number of frames into which the panoramic image is diced horizontally for the hot spot image track. 
hotSpotNumFramesY

The number of frames into which the panoramic image is diced vertically for the hot spot image track. 
flags

A set of panorama flags. kQTVRPanoFlagHorizontal has been superseded by the panoType field. It is only used when the panoType field is nil to indicate a horizontally-oriented cylindrical panorama. 
panoType

An OSType describing the type of panorama. Types supported are 
kQTVRHorizontalCylinder
kQTVRVerticalCylinder
kQTVRCube
reserved2

Reserved. This field must be 0*/
typedef struct QTVRPanoSampleAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    UInt32                              imageRefTrackIndex;
    UInt32                              hotSpotRefTrackIndex;
    Float32                             minPan;
    Float32                             maxPan;
    Float32                             minTilt;
    Float32                             maxTilt;
    Float32                             minFieldOfView;
    Float32                             maxFieldOfView;
    Float32                             defaultPan;
    Float32                             defaultTilt;
    Float32                             defaultFieldOfView;
    UInt32                              imageSizeX;
    UInt32                              imageSizeY;
    UInt16                              imageNumFramesX;
    UInt16                              imageNumFramesY;
    UInt32                              hotSpotSizeX;
    UInt32                              hotSpotSizeY;
    UInt16                              hotSpotNumFramesX;
    UInt16                              hotSpotNumFramesY;
    UInt32                              flags;
    OSType                              panoType;
    UInt32                              reserved2;
} QTVRPanoSampleAtom, *QTVRPanoSampleAtomPtr;

/*Panorama-Imaging Atom 

A panorama-imaging atom describes the default imaging characteristics for all the panoramic nodes in a scene. This atom overrides QuickTime VR’s own defaults. 

The panorama-imaging atom has an atom type of kQTVRPanoImagingAtomType ('impn'). Generally, there is one panorama-imaging atom for each imaging mode, so the atom ID, while it must be unique for each atom, is ignored. QuickTime VR iterates through all the panorama-imaging atoms. 

The structure of a panorama-imaging atom is defined by the QTVRPanoImagingAtom data type:
typedef struct QTVRPanoImagingAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    UInt32                              imagingMode;
    UInt32                              imagingValidFlags;
    UInt32                              correction;
    UInt32                              quality;
    UInt32                              directDraw;
    UInt32                              imagingProperties[6];
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRPanoImagingAtom, *VRPanoImagingAtomPtr;*/
typedef struct QTVRPanoImagingAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    UInt32                              imagingMode;
    UInt32                              imagingValidFlags;
    UInt32                              correction;
    UInt32                              quality;
    UInt32                              directDraw;
    UInt32                              imagingProperties[6];
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRPanoImagingAtom, *VRPanoImagingAtomPtr;

/*Track Reference Entry Structure

Since there are no fields in the pano sample data atom to indicate the presence of low-resolution image tracks, a separate sibling atom must be added to the panorama sample atom container. The track reference array atom contains an array of track reference entry structures that specify information about any low-resolution image tracks contained in a movie. Its atom type is kQTVRTrackRefArrayAtomType ('tref'). 

A track reference entry structure is defined by the QTVRTrackRefEntry data type:
typedef struct QTVRTrackRefEntry {
    UInt32                              trackRefType;
    UInt16                              trackResolution;
    UInt32                              trackRefIndex;
} QTVRTrackRefEntry;

trackRefType

The track reference type. 
trackResolution

The track resolution. 
trackRefIndex

The index of the track reference.

The number of entries in the track reference array atom is determined by dividing the size of the atom by sizeof (QTVRTrackRefEntry).

kQTVRPreviewTrackRes is a special value for the trackResolution field in the QTVRTrackRefEntry structure. This is used to indicate the presence of a special preview image track.*/
typedef struct QTVRTrackRefEntry {
    UInt32                              trackRefType;
    UInt16                              trackResolution;
    UInt32                              trackRefIndex;
} QTVRTrackRefEntry;

/*Node Location Atom Structure

The node location atom is the only child atom defined for the node ID atom. Its atom type is kQTVRNodeLocationAtomType ('nloc'). A node location atom describes the type of a node and its location. 

The structure of a node location atom is defined by the QTVRNodeLocationAtom data type:typedef struct QTVRNodeLocationAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              nodeType;
    UInt32                              locationFlags;
    UInt32                              locationData;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRNodeLocationAtom, *QTVRNodeLocationAtomPtr;

majorVersion

The major version number of the file format.
minorVersion

The minor version number of the file format.
nodeType

The node type. This field should contain either kQTVRPanoramaType or kQTVRObjectType.
locationFlags

The location flags. This field must contain the value kQTVRSameFile, indicating that the node is to be found in the current file. In future, these flags may indicate that the node is in a different file or at some URL location. 
locationData

The location of the node data. When the locationFlags field is kQTVRSameFile, this field should be 0. The nodes are found in the file in the same order that they are found in the node list.
reserved1

Reserved. This field must be 0.
reserved2

Reserved. This field must be 0.*/
typedef struct QTVRNodeLocationAtom {
    UInt16                              majorVersion;
    UInt16                              minorVersion;
    OSType                              nodeType;
    UInt32                              locationFlags;
    UInt32                              locationData;
    UInt32                              reserved1;
    UInt32                              reserved2;
} QTVRNodeLocationAtom, *QTVRNodeLocationAtomPtr;



#endif
#endif