#ifndef __KPI_INTERFACE__
#define __KPI_INTERFACE__
#include <sys/kernel_types.h>


/*protocol_family_t


Storage type for the protocol family. 
typedef u_int32_t protocol_family_t;  */
typedef u_int32_t protocol_family_t; 

//func

/*ifnet_release

errno_t ifnet_release(
    ifnet_t interface);  
Parameters
interface
The interface to decrement the reference count of and possibly free.
Return Value

May return EINVAL if the interface is not valid. 
Discussion 

Release a reference of the ifnet, this may trigger a free if the reference count reaches 0.*/
errno_t ifnet_release(
    ifnet_t interface);  

/*ifnet_find_by_name

errno_t ifnet_find_by_name(
    const char *ifname,
    ifnet_t *interface);  
Parameters
ifname
The name of the interface, including any unit number (i.e. "en0").
interface
A pointer to an interface reference. This will be filled in if a matching interface is found.
Return Value

0 on success otherwise the errno error. 
Discussion 

Find an interface by the name including the unit number. Caller must call ifnet_release on any non-null interface return value.*/
errno_t ifnet_find_by_name(
    const char *ifname,
    ifnet_t *interface);  


#endif
