#ifndef SYS_CONTROL_H
#define SYS_CONTROL_H

//#include <HYS/sys/kern_control.h>
#include <sys/appleapiopts.h>
//hys /define
#ifndef   SYS_KERNELTYPES_H
#include <sys/kernel_types.h> //hys
#endif
#include <stdio.h>//hys
#include <string.h> //hys
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
//#include <xorg/misc.h>//min
#include <asm-generic/errno-base.h>//ENOMEM
#include <asm-generic/errno.h>//ENOBUFS
#include <bits/errno.h>//ENOTSUP
#include <sys/errno.h>//EJUSTRETURN
#include <sys/signal.h>//sig_t
#include <APPLE/sys/kern_control.h>

/*CTLIOCGINFO

#define CTLIOCGINFO _IOWR(
    'N', 3, struct ctl_info) // get id from name 
Discussion 

The CTLIOCGINFO ioctl can be used to convert a kernel control name to a kernel control id.*/
#define CTLIOCGINFO _IOWR('N', 3, struct ctl_info) // get id from name 

/*ctl_info

struct ctl_info { 
    u_int32_t ctl_id; //Kernel Controller ID 
    char ctl_name[96  ]; // Kernel Controller Name (a C string) 
};  
Fields
ctl_id
The kernel control id, filled out upon return.
ctl_name
The kernel control name to find.
Discussion 

This structure is used with the CTLIOCGINFO ioctl to translate from a kernel control name to a control id.*/
struct ctl_info { 
    u_int32_t ctl_id; //Kernel Controller ID 
    char ctl_name[96 ]; // Kernel Controller Name (a C string) 
};


/*kern_ctl_ref

typedef void * kern_ctl_ref;  
Discussion 

A control reference is used to track an attached kernel control. Registering a kernel control will create a kernel control reference. This reference is required for sending data or removing the kernel control. This reference will be passed to callbacks for that kernel control.*/
typedef void * kern_ctl_ref;

/*ctl_connect_func

typedef errno_t (*ctl_connect_func)(
    kern_ctl_ref kctlref, 
    struct sockaddr_ctl *sac, 
    void **unitinfo);  
Parameters
kctlref
The control ref for the kernel control the client is connecting to.
sac
The address used to connect to this control. The field sc_unit contains the unit number of the kernel control instance the client is connecting to. If CTL_FLAG_REG_ID_UNIT was set when the kernel control was registered, sc_unit is the ctl_unit of the kern_ctl_reg structure. If CTL_FLAG_REG_ID_UNIT was not set when the kernel control was registered, sc_unit is the dynamically allocated unit number of the new kernel control instance that is used for this connection.
unitinfo
A place for the kernel control to store a pointer to per-connection data.
Discussion 

The ctl_connect_func is used to receive notification of a client connecting to the kernel control.*/
typedef errno_t (*ctl_connect_func)(
    kern_ctl_ref kctlref, 
    struct sockaddr_ctl *sac, 
    void **unitinfo);  

/*ctl_disconnect_func

typedef errno_t (*ctl_disconnect_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo);  
Parameters
kctlref
The control ref for the kernel control instance the client has disconnected from.
unit
The unit number of the kernel control instance the client has disconnected from.
unitinfo
The unitinfo value specified by the connect function when the client connected.
Discussion 

The ctl_disconnect_func is used to receive notification that a client has disconnected from the kernel control. This usually happens when the socket is closed. If this is the last socket attached to your kernel control, you may unregister your kernel control from this callback.*/
typedef errno_t (*ctl_disconnect_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo);  

/*ctl_send_func

typedef errno_t (*ctl_send_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo, 
    mbuf_t m,
    int flags);  
Parameters
kctlref
The control ref of the kernel control.
unit
The unit number of the kernel control instance the client has connected to.
unitinfo
The unitinfo value specified by the connect function when the client connected.
m
The data sent by the client to the kernel control in an mbuf chain.
flags
The flags specified by the client when calling send/sendto/sendmsg (MSG_OOB/MSG_DONTROUTE).
Discussion 

The ctl_send_func is used to receive data sent from the client to the kernel control.*/
typedef errno_t (*ctl_send_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo, 
    mbuf_t m,
    int flags);  

/*ctl_setopt_func

typedef errno_t (*ctl_setopt_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo, 
    int opt,
    void *data,
    size_t len);  
Parameters
kctlref
The control ref of the kernel control.
unit
The unit number of the kernel control instance.
unitinfo
The unitinfo value specified by the connect function when the client connected.
opt
The socket option.
data
A pointer to the socket option data. The data has already been copied in to the kernel for you.
len
The length of the socket option data.
Discussion 

The ctl_setopt_func is used to handle set socket option calls for the SYSPROTO_CONTROL option level.*/
typedef errno_t (*ctl_setopt_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo, 
    int opt,
    void *data,
    size_t len);  

/*ctl_getopt_func

typedef errno_t (*ctl_getopt_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo, 
    int opt,
    void *data,
    size_t *len);  
Parameters
kctlref
The control ref of the kernel control.
unit
The unit number of the kernel control instance.
unitinfo
The unitinfo value specified by the connect function when the client connected.
opt
The socket option.
data
A buffer to copy the results in to. May be NULL, see discussion.
len
A pointer to the length of the buffer. This should be set to the length of the buffer used before returning.
Discussion 

The ctl_getopt_func is used to handle client get socket option requests for the SYSPROTO_CONTROL option level. A buffer is allocated for storage and passed to your function. The length of that buffer is also passed. Upon return, you should set *len to length of the buffer used. In some cases, data may be NULL. When this happens, *len should be set to the length you would have returned had data not been NULL. If the buffer is too small, return an error.*/
typedef errno_t (*ctl_getopt_func)(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *unitinfo, 
    int opt,
    void *data,
    size_t *len);  

/*kern_ctl_reg

struct kern_ctl_reg { 
    //control information 
    char ctl_name[96  ]; 
    u_int32_t ctl_id; 
    u_int32_t ctl_unit;  
    // control settings 
    u_int32_t ctl_flags; 
    u_int32_t ctl_sendsize; 
    u_int32_t ctl_recvsize;  
    // Dispatch functions 
    ctl_connect_func ctl_connect; 
    ctl_disconnect_func ctl_disconnect; 
    ctl_send_func ctl_send; 
    ctl_setopt_func ctl_setopt; 
    ctl_getopt_func ctl_getopt; 
};  
Fields
ctl_name
A Bundle ID string of up to MAX_KCTL_NAME bytes (including the ending zero). This string should not be empty.
ctl_id
The control ID may be dynamically assigned or it can be a 32-bit creator code assigned by DTS. For a DTS assigned creator code the CTL_FLAG_REG_ID_UNIT flag must be set. For a dynamically assigned control ID, do not set the CTL_FLAG_REG_ID_UNIT flag. The value of the dynamically assigned control ID is set to this field when the registration succeeds.
ctl_unit
A separate unit number to register multiple units that share the same control ID with DTS assigned creator code when the CTL_FLAG_REG_ID_UNIT flag is set. This field is ignored for a dynamically assigned control ID.
ctl_flags
CTL_FLAG_PRIVILEGED and/or CTL_FLAG_REG_ID_UNIT.
ctl_sendsize
Override the default send size. If set to zero, the default send size will be used, and this default value is set to this field to be retrieved by the caller.
ctl_recvsize
Override the default receive size. If set to zero, the default receive size will be used, and this default value is set to this field to be retrieved by the caller.
ctl_connect
Specify the function to be called whenever a client connects to the kernel control. This field must be specified.
ctl_disconnect
Specify a function to be called whenever a client disconnects from the kernel control.
ctl_send
Specify a function to handle data send from the client to the kernel control.
ctl_setopt
Specify a function to handle set socket option operations for the kernel control.
ctl_getopt
Specify a function to handle get socket option operations for the kernel control.
Discussion 

This structure defines the properties of a kernel control being registered.*/
struct kern_ctl_reg { 
    //control information 
    char ctl_name[96  ]; 
    u_int32_t ctl_id; 
    u_int32_t ctl_unit;  
    // control settings 
    u_int32_t ctl_flags; 
    u_int32_t ctl_sendsize; 
    u_int32_t ctl_recvsize;  
    // Dispatch functions 
    ctl_connect_func ctl_connect; 
    ctl_disconnect_func ctl_disconnect; 
    ctl_send_func ctl_send; 
    ctl_setopt_func ctl_setopt; 
    ctl_getopt_func ctl_getopt; 
};  

//typedef  struct kern_ctl_reg kern_ctl_reg;

/*CTL_FLAG_PRIVILEGED

#define CTL_FLAG_PRIVILEGED 0x1 
Discussion 

The CTL_FLAG_PRIVILEGED flag is passed in ctl_flags. If this flag is set, only privileged processes may attach to this kernel control*/
#define CTL_FLAG_PRIVILEGED 0x1 

/*kern_ctl_ref

typedef void * kern_ctl_ref;  
Discussion 

A control reference is used to track an attached kernel control. Registering a kernel control will create a kernel control reference. This reference is required for sending data or removing the kernel control. This reference will be passed to callbacks for that kernel control.*/
typedef void * kern_ctl_ref;  

/*ctl_enqueuedata

errno_t ctl_enqueuedata(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *data,
    size_t len,
    u_int32_t flags);  
Parameters
kctlref
The control reference of the kernel control.
unit
The unit number of the kernel control instance.
data
A pointer to the data to send.
len
The length of data to send.
flags
Send flags. CTL_DATA_NOWAKEUP and CTL_DATA_EOR are currently the only supported flags.
Return Value

0 - Data was enqueued to be read by the client. EINVAL - Invalid parameters. EMSGSIZE - The buffer is too large. ENOBUFS - The queue is full or there are no free mbufs. 
Discussion 

Send data from the kernel control to the client.*/
errno_t ctl_enqueuedata(
    kern_ctl_ref kctlref,
    u_int32_t unit,
    void *data,
    size_t len,
    u_int32_t flags);  

/*ctl_deregister

errno_t ctl_deregister(
    kern_ctl_ref kctlref);  
Parameters
kctlref
The control reference of the control to unregister.
Return Value

0 - Kernel control was unregistered. EINVAL - The kernel control reference was invalid. EBUSY - The kernel control has clients still attached. 
Discussion 

Unregister a kernel control. A kernel extension must unregister it's kernel control(s) before unloading. If a kernel control has clients attached, this call will fail.*/
errno_t ctl_deregister(
    kern_ctl_ref kctlref);  

/*ctl_register

errno_t ctl_register(
    struct kern_ctl_reg *userkctl,
    kern_ctl_ref *kctlref);  
Parameters
userkctl
A structure defining the kernel control to be attached. Each callback is optional.
kctlref
Upon successful return, the kctlref will contain a reference to the attached kernel control. This reference is used to unregister the kernel control. This reference will also be passed in to the callbacks each time they are called.
Return Value

0 - Kernel control was registered. EINVAL - The registration structure was not valid. ENOMEM - There was insufficient memory. EEXIST - A controller with that id/unit is already registered. 
Discussion 

Register a kernel control. This will enable clients to connect to the kernel control using a PF_SYSTEM socket.*/
errno_t ctl_register(
    struct kern_ctl_reg *userkctl,
    kern_ctl_ref *kctlref);  


#endif