#include <AudioUnit/AudioUnit.h>

/*AudioUnitInitialize

Initializes an audio unit instance.

ComponentResult AudioUnitInitialize(
AudioUnit           ci
)
Parameters
ci

The audio unit to be initialized.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitInitialize(
AudioUnit           ci
){
printf ("AudioUnitInitialize",ci);
};

/*AudioUnitRender

Performs the action on a buffer of audio data.

ComponentResult AudioUnitRender(
   AudioUnit                     ci,
   AudioUnitRenderActionFlags*   ioActionFlags,
   const AudioTimeStamp*         inTimeStamp,
   UInt32                        inOutputBusNumber,
   UInt32                        inNumberFrames,
   AudioBufferList*              ioData
)
Parameters
ci

The audio unit to be changed.
ioActionFlags

Flags that provide information on the render; see “Render Action Flags”.
inTimeStamp

The time the render is begun.
inOutputBusNumber

The bus on which the output will be placed.
inNumberFrames

The number of frames to be rendered.
ioData

The audio data, before and after the render.
Availability
Available in Mac OS X v10.2 and later.*/

ComponentResult AudioUnitRender(
   AudioUnit                     ci,
   AudioUnitRenderActionFlags*   ioActionFlags,
   const AudioTimeStamp*         inTimeStamp,
   UInt32                        inOutputBusNumber,
   UInt32                        inNumberFrames,
   AudioBufferList*              ioData
){
printf ("AudioUnitRender",*ioActionFlags,inTimeStamp,inOutputBusNumber,inNumberFrames,ioData);
};
//work
/*AudioUnitGetProperty

Returns the size of the data for a specified property.

ComponentResult AudioUnitGetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   void*                 outData,
   UInt32*               ioDataSize
)
Parameters
ci

The audio unit on which the property is to be queried.
inID

The property to be queried upon.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
outData

A pointer to the data corresponding to the property.
ioDataSize

The expected data size and the actual data size returned.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitGetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   void*                 outData,
   UInt32*               ioDataSize
){
printf ("AudioUnitGetProperty",ci,inID,inScope,inElement,outData,*ioDataSize);
};

/*AudioUnitGetPropertyInfo

Returns the size of the data that will be returned when calling AudioUnitGetProperty for the specified property.

ComponentResult AudioUnitGetPropertyInfo(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   UInt32*               outDataSize,
   Boolean*              outWritable
)
Parameters
ci

The audio unit on which the property is to be queried.
inID

The property to be queried upon.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
outDataSize

The size, in bytes, of the property.
outWritable

A boolean showing if the property is writable.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitGetPropertyInfo(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   UInt32*               outDataSize,
   Boolean*              outWritable
){
printf ("AudioUnitGetPropertyInfo",ci,inID,inScope,inElement,outDataSize,outWritable);
};

//work
/*AudioUnitUninitialize

Uninitializes an audio unit instance.

ComponentResult AudioUnitUninitialize(
AudioUnit ci
)
Parameters
ci

The audio unit to be uninitialized.
Availability
Available in Mac OS X v10.0 and later.*/

ComponentResult AudioUnitUninitialize(
AudioUnit ci
){
printf ("AudioUnitUninitialize",ci);
};

/*AudioUnitSetProperty

Sets a property’s value to the supplied value.

ComponentResult AudioUnitSetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   const void*           inData,
   UInt32                inDataSize
)
Parameters
ci

The audio unit on which the property is to be applied.
inID

The property to be modified.
inScope

The scope in which the property is applicable.
inElement

Further specifies the scope of the property.
inData

A pointer to the data to be applied to the property.
inDataSize

The size of the data being passed in.
Availability
Available in Mac OS X v10.0 and later.*/
ComponentResult AudioUnitSetProperty(
   AudioUnit             ci,
   AudioUnitPropertyID   inID,
   AudioUnitScope        inScope,
   AudioUnitElement      inElement,
   const void*           inData,
   UInt32                inDataSize
){
printf ("AudioUnitSetProperty",ci,inID,inScope,inElement,inData,inDataSize);
};
