#include <OSServices/OSServices.h>




/*OTInetHostToString

Converts an an address in InetHost format into a character string in dotted-decimal notation. (Deprecated in Mac OS X v10.4.)

void OTInetHostToString (
   InetHost host,
   char * str
);
Parameters
host
str

A pointer to a C string containing an IP address in dotteddecimal notation (for example, “12.13.14.15”). You must allocate storage for this string and provide the pointer to the function.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

void OTInetHostToString (
   InetHost host,
   char * str
){};


/*OTInetGetInterfaceInfo

Returns internet address information about the local host. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
);
Parameters
info
val

An index into the local host’s array of configured IP interfaces. Specify 0 for information about the first interface. Specify kDefaultInetInterface to get information about the primary interface.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, in principle a given host can receive packets simultaneously through more than one network interface. For each IP interface configured for the local host, the OTInetGetInterfaceInfo function provides the internet address and subnet mask, a default gateway (that is, a gateway, if any exists, that can be used to route any packet to all destinations outside the locally connected subnet), and a domain name server, if any is known. The function also returns the version number of the OTInetGetInterfaceInfo function and, if available, the broadcast address for each interface. If the broadcast address is not available, you can determine it from the internet address and subnet mask.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetGetInterfaceInfo function never returns information for more than one interface.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
){};


/*InitOpenTransportInContext

Initializes the parts of Open Transport for use by the application or code resource. (Deprecated in Mac OS X v10.4.)

OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
);
Parameters
flags

Tells Open Transport whether your code is an application or a plug-in.
outClientContext

Returns the client context pointer. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

In Carbon, the InitOpenTransportInContext function acts like the pre-Carbon InitOpenTransport function, except that it takes parameters that specify initialization context explicitly.

Use the flags parameter to tell Open Transport whether your code is an application or some other target (for example, a plug-in that runs in an application context but is not the application itself). The second parameter returns the client context pointer, which you must pass to other asset-creation routines. For more information, see Understanding Open Transport Asset Tracking at http://developer.apple.com/technotes/tn/tn1173.html.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus InitOpenTransportInContext (
   OTInitializationFlags flags,
   OTClientContextPtr * outClientContext
){};

/*OTOpenEndpointInContext

Opens an endpoint that operates synchronously. (Deprecated in Mac OS X v10.4.)

EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
info
err
clientContext
Return Value

See the description of the EndpointRef data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
EndpointRef OTOpenEndpointInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   TEndpointInfo * info,
   OSStatus * err,
   OTClientContextPtr clientContext
){};


/*OTCreateConfiguration

Creates a structure defining a provider’s configuration. (Deprecated in Mac OS X v10.4.)

Modified

OTConfigurationRef OTCreateConfiguration (
   const char * path
);
Parameters
path

A pointer to a character string describing the provider.
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCreateConfiguration function creates a configuration structure that defines the software modules, hardware ports, and options that Open Transport is to use when you call a function to open a provider. This is a private structure, defined by the OTConfiguration data type . To create one, you use the path parameter to pass the OTCreateConfiguration function a string describing the provider service desired.

The simplest possible value of the path parameter is a single protocol module name of the highest-level protocol you want to use; for example, “tcp.” If you do not specify a complete communications path, the Open Transport software uses default settings to construct the rest of the path. For example, if you specify “adsp” for the path parameter, Open Transport defaults to using the AppleTalk DataStream Protocol (ADSP) protocol module layered above the Datagram Delivery Protocol (DDP) protocol module and with LocalTalk on the default port, which is the printer port.

If you want to identify a particular port in the configuration string, you use the port name to do so (described in the section “About Port Information,” beginning on page 6-5). More typically, however, you leave this value blank— for example, using a string with only “adsp” or “adsp, ddp,” which configures the provider with whatever port is specified in the control panel.

To specify more than one protocol module, separate the module names with commas. You can also specify values for options by putting them in parentheses after the protocol name; for example, “adsp, ddp (Checksum=1)” specifies that ADSP is to run on top of DDP and that the checksum option is enabled.

If Open Transport cannot parse the list that you pass in the path parameter, the OTCreateConfiguration function returns ((OTConfiguration*)-1L). If there is insufficient memory to create an OTConfiguration structure, the OTCreateConfiguration function returns NULL.

The OTCreateConfiguration function returns a pointer to the configuration structure it creates. You pass this pointer as a parameter to the open-provider functions such as the OTOpenEndpoint or OTOpenMapper functions.
Availability
Modified in Carbon. Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

Passing inline options to OTCreateConfiguration-for example, OTCreateConfiguration("tcp(NoDelay=1)")-is not supported on Mac OS X. Instead, you should explicitly set any options using the function OTOptionManagement.

Declared In
OpenTransport.h*/

OTConfigurationRef OTCreateConfiguration (
   const char * path
){};


/*OTCloseProvider

Closes a provider of any type—endpoint, mapper, or service provider. (Deprecated in Mac OS X v10.4.)

OSStatus OTCloseProvider (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTCloseProvider function closes the provider that you specify in the ref parameter. Closing the provider deletes all memory reserved for it in the system heap, deletes its resources, and cancels any provider functions that are currently executing.

Open Transport does not guarantee that all outstanding functions have completed before it closes the provider. It is ultimately your responsibility to make sure that all provider functions that you care about have finished executing, before you close and delete a provider.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTCloseProvider (
   ProviderRef ref
){};



/*CloseOpenTransportInContext

Unregisters your application or code resource connection to Open Transport. (Deprecated in Mac OS X v10.4.)

void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
);
Parameters
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Carbon Porting Notes

The CloseOpenTransportinContext function acts like the pre-Carbon CloseOpenTransport function except that it takes an additional parameter, an OTClientContextPtr, which can be NULL for applications. Other types of clients must provide a valid client context pointer.
Declared In
OpenTransport.h*/
void CloseOpenTransportInContext (
   OTClientContextPtr clientContext
){};

/*OTGetEndpointInfo

Obtains information about an endpoint that has been opened. (Deprecated in Mac OS X v10.4.)

OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
);
Parameters
ref
info
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTGetEndpointInfo function returns information about
the maximum size of buffers used to specify an endpoint’s address and option values
the maximum size of normal and expedited data you can transfer using this endpoint or, for transaction-based endpoints, the maximum size of requests and replies
the size of data you can transfer when initiating or tearing down a connection
the services supported by the endpoint
any additional characteristics of this endpoint
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTGetEndpointInfo (
   EndpointRef ref,
   TEndpointInfo * info
){};



/*OTAllocMemInContext

Allocates memory using an explicit client context. (Deprecated in Mac OS X v10.4.)

void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
);
Parameters
size
clientContext
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void * OTAllocMemInContext (
   OTByteCount size,
   OTClientContextPtr clientContext
){};


/*OTOptionManagement

Determines an endpoint’s current or default option values or changes these values. (Deprecated in Mac OS X v10.4.)

OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
);
Parameters
ref
req
ret
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

To use the OTOptionManagement function, you must have opened an endpoint using the OTOpenEndpoint or OTAsyncOpenEndpoint functions.

You use the OTOptionManagement function to negotiate, retrieve, or verify an endpoint’s protocol options. If the endpoint is in asynchronous mode and you have not installed a notifier function, it is not possible to determine when the function completes.

The action taken by the OTOptionManagement function is determined by the setting of the req->flags field. The following bulleted items describe the different operations that you can perform and the flag settings that you use to specify these operations.
To negotiate values for the endpoint, you must call the OTOptionManagement function, specifying T_NEGOTIATE for the req->flags field. The endpoint provider evaluates the requested options, negotiates the values, and returns the resulting values in the option management structure pointed to by the ret->opt.buf field. The status field of each returned option is set to a constant that indicates the result of the negotiation. These constants are described by the “Open Transport Flags and Status Codes” enumeration.

For any protocol specified, you can negotiate for the default values of all options supported by the endpoint by specifying the value T_ALLOPT for the name field of the TOption structure. This might be useful if you want to change current settings or if negotiations for other values have failed. The success of the negotiations depends partly on the state of the endpoint—that is, simply because these are default values does not guarantee a completely successful negotiation. When the function returns, the resulting values are returned, option by option, in the buffer pointed to by the ret->opt.buf field.
To retrieve an endpoint’s default option values, call the OTOptionManagement function, specifying T_DEFAULT for the req->flags field. You must also specify the name of the option (but not its value) in the TOption structure that you create for each of the options you are interested in.

When the function returns, it passes the default values for the options back to you in the buffer pointed to by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.

When getting an endpoint’s default option values, you can specify T_ALLOPT for the option name. This returns all supported options for the specified level with their default values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To retrieve an endpoint’s current option values, call the OTOptionManagement function, specifying T_CURRENT for the req->flags field. For each option in the buffer referenced by the req->opt.buf field, specify the name of the option you are interested in. The function ignores any option valuesyou specify.

When the function returns, it passes the current values for the options back to you in the buffer referenced by the ret->opt.buf field. For each option, the status field contains T_NOTSUPPORT if the protocol does not support the option, T_READONLY if the option is read-only, and T_SUCCESS in all other cases. The overall result of the request is returned in the ret->flags field. The meaning of this result is described by the “Open Transport Flags and Status Codes” enumeration.

When retrieving an endpoint’s current option values, you can specify T_ALLOPT for the option name. The function returns all supported options for the specified protocol, with their current values. In this case, you must set the opt.maxlen field to the maximum size required to hold an endpoint’s option information. The info.opt field of the TEndpointInfo structure specifies the maximum size of a buffer used to hold option information for an endpoint.
To check whether an endpoint provider supports certain options or option values, you must call the OTOptionManagement function, specifying T_CHECK for the req->flags field. Checking options or their values does not change the current settings of an endpoint’s options.
To check whether an option is supported, set the name field of the TOption structure to the option name, but do not specify an option value. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set to T_SUCCESS if the option is supported, T_NOTSUPPORT if it is not supported or needs additional client privileges, and T_READONLY if it is read-only.
To check whether an option value is supported, set the name field of the TOption structure to the option name, and set the value field to the value you want to check. When the function returns, the status field for the corresponding TOption structure in the buffer pointed to by the ret->opt.buf field is set as it would be if you had specified the T_NEGOTIATE flag. The overall result of the option checks is returned in the ret->flags field, which contains the single worst result of the option checks. The meaning of this result is described by the Open Transport Flags and Status Codes enumeration.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTOptionManagement (
   EndpointRef ref,
   TOptMgmt * req,
   TOptMgmt * ret
){};



/*OTFreeMem

Frees memory allocated with the OTAllocMem function. (Deprecated in Mac OS X v10.4.)

void OTFreeMem (
   void * mem
);
Parameters
mem
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTFreeMem (
   void * mem
){};


/*OTNextOption

Locates the next TOption structure in a buffer. (Deprecated in Mac OS X v10.4.)

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
);
Parameters
buffer

A pointer to the buffer containing the option to be found.
buflen

A long specifying the size of the buffer containing the option to be found.
prevOptPtr
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTNextOption function allows you to parse through a buffer containing TOption structures describing an endpoint’s option values. Within the buffer, TOption structures are aligned to long-word boundaries. This function takes into account this padding when it calculates the beginning address of the next TOption structure and it returns that address in the prevOptPtr parameter.

The first time you call the option, set the prevOptPtr parameter to the beginning address of the buffer. When the function returns, the prevOptPtr parameter points to the next (second) option in the buffer. You can continue this process, specifying the value returned for the prevOptPtr parameter by the previous invocation of the function, each time you call the function to obtain the beginning address of each option in the buffer.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTNextOption (
   UInt8 * buffer,
   UInt32 buflen,
   TOption ** prevOptPtr
){};


/*OTBufferDataSize

Obtains the size of the no-copy receive buffer. (Deprecated in Mac OS X v10.4.)

OTByteCount OTBufferDataSize (
   OTBuffer * buffer
);
Parameters
buffer
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
OTByteCount OTBufferDataSize (
   OTBuffer * buffer
){};


/*OTStrLength

Returns the length of a C string. (Deprecated in Mac OS X v10.4.)

OTByteCount OTStrLength (
   const char * str
);
Parameters
str
Return Value

See the description of the OTByteCount data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTByteCount OTStrLength (
   const char * str
){};


/*OTInstallNotifier

Installs a notifier function. (Deprecated in Mac OS X v10.4.)

OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
);
Parameters
ref
proc

For C++ applications, the proc parameter must point to either a C function or a static member function. See OTNotifyUPP data type.
contextPtr

A context pointer for your use. The provider passes this value unchanged to your notifier function when it calls the function.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTInstallNotifier function installs a notifier function for the provider that you specify. Changing a provider’s mode of execution does not affect the notifier function. The notifier function remains installed until you remove it using the OTRemoveNotifier function or until you close the provider.

Before calling the OTInstallNotifier function, you must open the provider for which you want to install the notifier. If you open a provider asynchronously (for example, with the OTAsyncOpenEndpoint function), you must pass a pointer to a notifier function as a parameter to the function used to open the provider. In this case, you don’t need to call the OTInstallNotifier function unless you want to install a different notifier function. If you do, you must call the OTRemoveNotifier function before calling the OTInstallNotifier function.

Opening a provider synchronously (for example, with the OTOpenEndpoint function) opens the provider but does not install a notifier function for it. If you need a notifier function for a provider opened synchronously, you must call the OTInstallNotifier function. This notifier would not return completion events, but would return asynchronous events advising you of the arrival of data, of changes in flow-control restrictions, and so on.

Call the OTInstallNotifier function only when no provider functions are executing for the provider that you specify. Otherwise, the OTInstallNotifier function returns the result code kOTStateChangeErr.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTInstallNotifier (
   ProviderRef ref,
   OTNotifyUPP proc,
   void * contextPtr
){};

/*OTReleaseBuffer

Returns the no-copy receive buffer to the system. (Deprecated in Mac OS X v10.4.)

void OTReleaseBuffer (
   OTBuffer * buffer
);
Parameters
buffer
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
void OTReleaseBuffer (
   OTBuffer * buffer
){};

/*OTSetSynchronous

Sets a provider’s mode of execution to synchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetSynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetSynchronous function causes all provider functions to run synchronously when using the provider that you specify.

Changing a provider’s mode of execution does not affect its notifier function, if any is installed for this provider; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetSynchronous (
   ProviderRef ref
){};



/*OTInitDNSAddress

Fills in a DNSAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
);
Parameters
addr
str

A pointer to a domain name string. This string can be just a host name (otteam), a partially qualified domain name (for example, “otteam.ssw”), a fully qualified domain name (for example, “otteam.ssw.apple.com.”), or an internet address in dotteddecimal format (for example, “17.202.99.99”), and can optionally include the port number (for example, “otteam.ssw.apple.com:25” or “17.202.99.99:25”).
Return Value

See the description of the OTByteCount data type.
Discussion

This function fills in the fAddressType field of the DNSAddress structure with the value AF_DNS, fills in the fName field with the address string you specify, and returns the size of the resulting DNSAddress structure as an unsigned integer. You can use the DNSAddress structure to provide an address when you use a UDP or TCP endpoint. If you do so, the domain name resolver resolves the address for you automatically.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
){};



/*OTSetNonBlocking

Disallows a provider from waiting if it cannot currently complete a function that sends or receives data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetNonBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetNonBlocking function causes provider functions to return a result code immediately, instead of waiting for a function that sends or receives data to complete. When you open a provider, its mode of operation is set to nonblocking by default.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetNonBlocking (
   ProviderRef ref
){};


/*OTUseSyncIdleEvents

Allows synchronous idle events to be sent to your notifier. (Deprecated in Mac OS X v10.4.)

OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
);
Parameters
ref
useEvents
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUseSyncIdleEvents (
   ProviderRef ref,
   Boolean useEvents
){};


/*OTReadBuffer

Copies data out of a no-copy receive buffer. (Deprecated in Mac OS X v10.4.)

Boolean OTReadBuffer (
   OTBufferInfo * buffer,
   void * dest,
   OTByteCount * len
);
Parameters
buffer
dest
len
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
Boolean OTReadBuffer (
   OTBufferInfo * buffer,
   void * dest,
   OTByteCount * len
){};

/*OTBind

Assigns an address to an endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
);
Parameters
ref
reqAddr

If you specify NIL for the reqAddr parameter, Open Transport chooses a protocol address for you and requests 0 as the endpoint’s maximum number of concurrent outstanding connect indications.

If you want Open Transport to assign an address for you, setthe addr.len field of the TBind structure to 0.
retAddr

You can set this parameter to nil if you do not care to know what address the endpoint is bound to or what the negotiated value of qlen is.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTBind function to request an address that an endpoint be bound to. You can either use the reqAddr parameter to request that the endpoint be bound to a specific address or allow the endpoint provider to assign an address dynamically by passing nil for this parameter. Consult the documentation for the top-level protocol you are using to determine whether it is preferable to have the address assigned dynamically. The function returns the address to which the endpoint is actually bound in the retAddr parameter. This might be different from the address you requested, if you requested a specific address.

If you are binding a connection-oriented endpoint, you must use the reqAddr->qlen field to specify the number of connection requests that may be outstanding for this endpoint. The retAddr->qlen field specifies, on return, the actual number of connection requests allowed for the endpoint. This number might be smaller than the number you requested. Note that when the endpoint is actually connected, the number might be further decreased by negotiations taking place at that time.

If you call the OTBind function asynchronously and you have not installed a notifier function, the only way to determine when the function completes is to poll the endpoint using the OTGetEndpointState function. This function returns a kOTStateChangeErr until the bind completes. When the endpoint is bound, the state is either T_UNBND if the bind failed, or T_IDLE if it succeeded.

You can cancel an asynchronous bind that is still in progress by calling the OTUnbind function.

You must not bind more than one connectionless endpoint to a single address. Some connection-oriented protocols let you bind two or more endpoints to the same address. In such instances, you must use only one of the endpoints to listen for connection requests for that address. When binding the endpoint listening for a connection, you must set the reqAddr->qlen field of the OTBind function to a value greater than or equal to 1. When binding the other endpoints, you must set the reqAddr->qlen field to 0.

If you accept a connection for an endpoint that is also listening for connection requests, the address of that endpoint is deemed “busy” for the duration of the connection, and you must not bind another endpoint for listening to that same address. This requirement prevents more than one endpoint bound to the same address from accepting connection requests. If you have to bind another listening endpoint to the same address, you must first use the OTUnbind function to unbind the first endpoint or use the OTCloseProvider function to close it.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTBind (
   EndpointRef ref,
   TBind * reqAddr,
   TBind * retAddr
){};


/*OTRcv

Reads data sent using a connection-oriented transactionless protocol. (Deprecated in Mac OS X v10.4.)

OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
);
Parameters
ref
buf

A pointer to a memory location where the incoming data is to be copied. You must allocate this buffer before you call the function.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You call the OTRcv function to read data sent by the peer to which you are connected. If the OTRcv function succeeds, it returns an integer (OTStatus) specifying the number of bytes received. The function places the data read into the buffer referenced by the buf parameter. If the function fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure. You can call this function to receive either normal or expedited data. If the data is expedited, the T_EXPEDITED flag is set in the flags parameter.

If T_MORE is set in the flags parameter when the function returns, this means that the buffer you allocated is too small to contain the data to be read and that you must call the OTRcv function again. If you have read x bytes with the first call, the next call to the OTRcv function begins to read at the (x + 1) byte. Of course, if you need it, you must copy the data in the buffer to another location before calling the function again. Each call to this function that returns with the T_MORE flag set means that you must call the function again to get more data. When you have read all the data, the OTRcv function returns with the T_MORE flag not set. If the endpoint does not support the concept of a TSDU (Transport Service Data Unit), the T_MORE flag is not meaningful and should be ignored. To determine whether the endpoint supports TSDUs, examine the tsdu field of the TEndpointInfo structure. A value of T_INVALID means that the endpoint does not support it.

Some protocols allow you to send zero-length data to signal the end of a logical unit. In this case, if you request more than 0 bytes when calling the OTRcv function, the function returns 0 bytes only to signal the end of a TSDU.

If the OTRcv function returns and the T_EXPEDITED bit is set in the flags parameter, this means that you are about to read expedited data. If the number of bytes of expedited data exceeds the number of bytes you specified in the reqCount parameter, both the T_EXPEDITED and the T_MORE bits are set. You must call the OTRcv function until the T_MORE flag is not set to retrieve the rest of the expedited data.

If you are calling the OTRcv function repeatedly to read normal data and a call to the function returns T_EXPEDITED in the flags parameter, the next call to the OTRcv function that returns without the T_EXPEDITED flag set returns normal data at the place it was interrupted. It is your responsibility to remember where that was and to continue processing normal data. You can determine how much normal data you read by maintaining a running total of the number of bytes returned in the OTStatus result.

If the endpoint is in asynchronous mode or is not blocking, the function returns with the kOTNoDataErr result if no data is available. If you have installed a notifier, the endpoint provider calls your notifier and passes T_DATA or T_EXDATA for the code parameter when there is data available. If you have not installed a notifier, you may poll for these events using the OTLook function. Once you receive a T_DATA or T_EXDATA event, you should continue in a loop, calling the OTRcv function until it returns with the kOTNoDataErr result.

If the endpoint is in synchronous mode and is blocking, the endpoint waits for data if none is currently available. You should avoid calling the OTRcv function this way because it might cause processing to hang if no data is available. If you are doing other operations in synchronous mode, you should put the endpoint in nonblocking mode before calling the OTRcv function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTRcv (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags * flags
){};



/*OTSnd

Sends data to a remote peer. (Deprecated in Mac OS X v10.4.)

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
);
Parameters
ref
buf

A pointer to the data being sent. If you are sending data that is not stored contiguously, this is a pointer to an OTData structure that describes the first data fragment.
nbytes
flags
Return Value

See the description of the OTResult data type.
Discussion

You use the OTSnd function to send data to a remote peer. Before you use this function, you must establish a connection with the peer.

If the OTSnd function succeeds, it returns an integer (OSStatus) specifying the number of bytes that were actually sent. If it fails, it returns a negative integer corresponding to a result code that indicates the reason for the failure.

You specify the data to be sent by passing a pointer to the data (buf) and byspecifying the size of the data (nbytes). The maximum size of the data you can send is specified by the tsdu field of the TEndpointInfo structure for the endpoint.

Some protocols use expedited data for control or attention messages. To determine whether the endpoint supports this service, examine the etsdu field of the TEndpointInfo structure. A positive integer for the etsdu field indicates the maximum size in bytes of expedited data that you can send. To send expedited data, you must set the T_EXPEDITED bit of the flags parameter.

If you want to break up the data sent into smaller logical units, you can set the T_MORE bit of the flags parameter to indicate that you are using additional calls to the OTSnd function to send more data that belongs to the same logical unit. To indicate that the last data unit is being sent, you must specify 0 for nbytes and turn off the T_MORE flag. This is the only circumstance under which it is permitted to send a zero-length data unit. If the endpoint does not support the sending of zero-length data, the OTSnd function fails with the kOTBadDataErr result.

If the endpoint is in blocking mode, the OTSnd function returns after it actually sends the data. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSnd function returns with the kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it returns a T_GODATA event to let you know that it is possible to send data.

The following table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSnd function.
Table A-1  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
The function returns immediately. The kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTResult OTSnd (
   EndpointRef ref,
   void * buf,
   OTByteCount nbytes,
   OTFlags flags
){};

/*OTConnect

Requests a connection to a remote peer. (Deprecated in Mac OS X v10.4.)

OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
);
Parameters
ref
sndCall
rcvCall

This parameter is only meaningful for synchronous calls to the OTConnect function. See TCall data type.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous mode, the OTConnect function returns after the connection is established and fills in the fields of the TCall structure (referenced by the rcvCall parameter) with the actual values associated with this connection. These might be different from the values you specified using the sndCall parameter.

If the OTConnect function returns with the kOTLookErr result, this might be either because of a pending T_LISTEN or T_DISCONNECT event. That is, either a connection request from another endpoint has interrupted execution of the function, or the remote endpoint has rejected the connection. If you don’t have a notifier installed, you can call the OTLook function to identify the event that caused the kOTLookErr result. If the event is T_LISTEN, you must accept or reject the incoming request and then continue processing the OTConnect function by calling OTRcvConnect. If the event is T_DISCONNECT, you must call the OTRcvDisconnect function to clear the error condition—that is, to deallocate memory and place the endpoint in the correct state.

If the endpoint is in asynchronous mode, the OTConnect function returns before the connection is established with a kOTNoDataErr result to indicate that the connection is in progress. When the connection is established, the endpoint provider calls your notifier, passing T_CONNECT for the code parameter. In response, you must call the OTRcvConnect function to read the connection parameters that would have been returned using the rcvCall parameter if the endpoint were in synchronous mode.

It is possible that the remote address returned in the addr field of the rcvCall parameter is not the same as the address you requested using the sndCall->addr field. This happens when the connection is accepted for a different endpoint than the one receiving the connection request.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTConnect (
   EndpointRef ref,
   TCall * sndCall,
   TCall * rcvCall
){};

/*OTSetBlocking

Allows a provider to wait or block until it is able to send or receive data. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetBlocking (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetBlocking function causes provider functions that send or receive data to wait if current conditions prevent them from completing an operation. By default, a provider is in nonblocking mode, in which case, if a provider function were unable to complete sending or receiving data, it would return immediately with a result that would tell you why the operation was unable to complete.

If a provider is in blocking mode and you call the OTCloseProvider function to close the provider, Open Transport gives each Streams module up to 15 seconds to process outgoing commands. It is recommended that you call the OTSetNonBlocking function before you call the OTCloseProvider function.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetBlocking (
   ProviderRef ref
){};


/*NewOTNotifyUPP

Creates a new universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the OTNotifyUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTNotifyUPP NewOTNotifyUPP (
   OTNotifyProcPtr userRoutine
){};


/*OTMemzero

Initializes the specified memory range to 0. (Deprecated in Mac OS X v10.4.)

void OTMemzero (
   void * dest,
   OTByteCount nBytes
);
Parameters
dest
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

void OTMemzero (
   void * dest,
   OTByteCount nBytes
){};


/*OTAtomicAdd32

Atomically adds a 32-bit value to a memory location. (Deprecated in Mac OS X v10.4.)

SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
);
Parameters
toAdd
dest
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
SInt32 OTAtomicAdd32 (
   SInt32 toAdd,
   SInt32 * dest
){};

/*OTGetTimeStamp

Obtains the current timestamp. (Deprecated in Mac OS X v10.4.)

void OTGetTimeStamp (
   OTTimeStamp * currentTime
);
Parameters
currentTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTGetTimeStamp (
   OTTimeStamp * currentTime
){};



/*OTLIFOEnqueue

Places a link at the front of a LIFO list. (Deprecated in Mac OS X v10.4.)

void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
);
Parameters
list
link
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLIFOEnqueue (
   OTLIFO * list,
   OTLink * link
){};


/*OTLIFODequeue

Removes the first link in a LIFO list and returns a pointer to it. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFODequeue (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFODequeue (
   OTLIFO * list
){};


/*OTLIFOStealList

Removes all links in a LIFO list and returns a pointer to the first link in the list. (Deprecated in Mac OS X v10.4.)

OTLink * OTLIFOStealList (
   OTLIFO * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTLink * OTLIFOStealList (
   OTLIFO * list
){};


/*OTReverseList

Reverses the order in which entries are linked in a list. (Deprecated in Mac OS X v10.4.)

OTLink * OTReverseList (
   OTLink * list
);
Parameters
list
Return Value

See the description of the OTLink data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OTLink * OTReverseList (
   OTLink * list
){};

/*NSLGetServiceFromURL

Gets the service portion of a URL.

OSStatus NSLGetServiceFromURL (
char* theURL,
char** svcString,
UInt16* svcLen);
Parameters
theURL

On input, a pointer to a null-terminated string containing a URL.
svcString

On input, a pointer to the address of a string in memory. On output, svcString points to the service portion of the URL specified by theURL.
svcLen

On input, a pointer to an unsigned 16-bit value. On output, svcLen points to the length in bytes of svcString.
function result

A value of noErr indicates that svcString points to the service portion of the URL specified by theURL.
Discussion

This utility function gets the service portion of a URL. For example, if the URL is http://www.apple.com, the service portion of that URL is http.
Availability
Available in Mac OS X v10.0 and later.*/

OSStatus NSLGetServiceFromURL (
char* theURL,
char** svcString,
UInt16* svcLen){};

/*NSLLibraryPresent

Determines whether the Network Services Location Manager is present.

Boolean NSLLibraryPresent (void);
Parameters
function result

TRUE if the Network Services Location Manager is present.
Discussion

This utility function returns TRUE when the Network Services Location Manager is available. The Network Services Location Manager is always present in Mac OS X, so for applications that only run on Mac OS X do not need to call this function.
Availability
Available in Mac OS X v10.0 and later.*/
Boolean NSLLibraryPresent (void){};

/*NSLCloseNavigationAPI

Closes a session with the Network Services Location Manager.

void NSLCloseNavigationAPI (NSLClientRef theClient);
Parameters
theClient

On input, a value of type NSLClientRef, obtained by previously calling NSLOpenNavigationAPI, that identifies the session that is to be closed.
Discussion

This function closes the Network Services Location Manager session identified by theClient. If your application calls this function while a search is in progress, any data that would have been returned is lost.
Special Considerations

Your application is responsible for reclaiming memory that it allocates for services lists, parameter blocks, and search request references. Your application should reclaim memory by calling NSLDisposeServicesList, NSLDeleteRequest, and NSLFreeTypedDataPtr, respectively.
Availability
Available in Mac OS X v10.0 and later.*/
void NSLCloseNavigationAPI (NSLClientRef theClient){};

/*NSLMakeNewNeighborhood

Creates a neighborhood for use in searches.

NSLNeighborhood NSLMakeNewNeighborhood (
char * name,
char * protocolList);
Parameters
name

On input, NULL to create a neighborhood that can be used to obtain a list of default neighborhoods when calling NSLStartNeighborhoodLookup, or a pointer to a null-terminated string containing the name of a neighborhood in which searches are to be conducted.
protocolList

On input, NULL, which creates a neighborhood that will cause all available protocols to participate in any search that uses it. For compatibility with earlier versions of the Network Services Location Manager, protocolList can be a pointer to a comma-separated, null-terminated list of protocols (such as NBP,SLP) that are to participate in a search conducted with the resulting neighborhood. The constants kDSProtocolType, kNBPProtocolType, and kSLPProtocolType can be used to build a protocol list. However, searches conducted using the resulting neighborhood will not be limited to the protocols that were specified.
function result

An NSLNeighborhood value that can be used in subsequent calls to Network Services Location Manager functions, or NULL if a neighborhood value could not be created. This might happen, for example, if there is not enough memory.
Discussion

This utility function creates a neighborhood that can be provided as a parameter to other Network Services Location Manager functions such as NSLStartNeighborhoodLookup, NSLStartServicesLookup, NSLStandardRegisterURL, and NSLStandardDeregisterURL.

When you have no further use for a neighborhood, you can reclaim the memory allocated to it by calling NSLFreeNeighborhood.
Special Considerations

Specifying protocols in the protocolList parameter is deprecated. If you specify protocols when other protocols are available, any use of the resulting neighborhood will not be limited to the protocols you specified.
Availability
Available in Mac OS X v10.0 and later.*/
NSLNeighborhood NSLMakeNewNeighborhood (
char * name,
char * protocolList){};


/*NSLGetNextURL

Gets the position of the next URL in a result buffer.

Boolean NSLGetNextUrl (
NSLClientAsyncInfoPtr infoPtr,
char ** urlPtr,
long * urlLength);
Parameters
infoPtr

On input, a pointer to an NSLClientAsyncInfo structure whose resultBuffer field may contain another URL.
urlPtr

On output, if another URL was found in the resultBuffer field, a pointer to the beginning of the URL.
urlLength

On output, the length of the URL pointed to by urlPtr.
function result

A Boolean value. A value of TRUE indicates that urlPtr points to the next URL in the resultBuffer field pointed to by infoPtr. A value of FALSE indicates that there are no more URLs in the resultBuffer field.
Discussion

This utility function obtains the starting position and the length of the next URL in a result buffer. Typically, the URLs were placed in the result buffer by a previous call to NSLStartServicesLookup.*/
Boolean NSLGetNextUrl (
NSLClientAsyncInfoPtr infoPtr,
char ** urlPtr,
long * urlLength){};

/*NSLHexDecodeText

Decodes the encoded portion of a URL.

OSStatus NSLHexDecodeText (
char* encodedText,
UInt16 encodedTextLen,
char* decodedTextBuffer,
UInt16* decodedTextBufferLen,
Boolean* textChanged);
Parameters
encodedText

On input, a pointer to a buffer containing the portion of a URL that has been encoded.
encodedTextLen

On input, a value of type UInt16 that specifies the length of the buffer pointed to by encodedText.
decodedTextBuffer

On input, a pointer to a buffer in which the decoded text is to be stored. On output, the buffer contains the decoded text.
decodedTextBufferLen

On input, a pointer to a value of type UInt16 containing the maximum length of decodedTextBuffer. On output, decodedTextBufferLen points to the length of the decoded text pointed to by decodedTextBuffer.
textChanged

On input, a pointer to a Boolean value. On output, textChanged points to a value that is TRUE if decoding occurred or that is FALSE if no decoding was required.
function result

A value of noErr indicates that this utility function returned successfully. See “Network Services Location Manager Result Codes” for other possible result codes.
Discussion

This utility function decodes the portion of a URL that was previously encoded by NSLHexEncodeText. If this utility function returns noErr, the buffer pointed to by decodedTextBuffer contains the decoded copy of the buffer pointed to by encodedTextBuffer, or it contains an exact copy of the buffer pointed to by encodedTextBuffer. Use the textChanged parameter to determine whether any decoding actually took place.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLHexDecodeText (
char* encodedText,
UInt16 encodedTextLen,
char* decodedTextBuffer,
UInt16* decodedTextBufferLen,
Boolean* textChanged){};


/*NSLOpenNavigationAPI

Opens a session with the Network Services Location Manager.

OSStatus NSLOpenNavigationAPI (
NSLClientRef * newRef);
Parameters
newRef

On input, a pointer to a value of type NSLClientRef in which the Network Services Location Manager places a client reference. Pass the client reference to NSLPrepareRequest and NSLCloseNavigationAPI.
function result

A value of noErr indicates that the session was opened successfully. If NSLOpenNavigationAPI returns any of the following error codes, your application should not call any other Network Services Location Manager functions: kNSLNotInitialized, kNSLInsufficientSysVer, kNSLInsufficientOTVer, kNSLPluginLoadFailed, or kNSL68kContextNotSupported.
Discussion

This function opens a session with the Network Services Location Manager and returns a client reference that your application later uses to prepare search requests and to close the Network Services Location Manager session. You must call NSLOpenNavigationAPI before calling any other Network Services Location Manager functions.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLOpenNavigationAPI (
NSLClientRef * newRef){};

/*NSLContinueLookup

Continues a search.

NSLError NSLContinueLookup (
NSLClientAsyncInfo *asyncInfo);
Parameters
asyncInfo

On input, a pointer to the NSLClientAsyncInfo structure for this search.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, NSLContinueLookip returned successfully. Possible errors include kNSLNotInitialized, kNSLNoContextAvailable, kNSLBadClientInfoPtr, kNSLCannotContinueLookup, and kNSLBufferTooSmallForData. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function is deprecated in Mac OS X and returns without performing any work. In Mac OS X, asynchronous searches continue automatically when the application’s notification routine returns. For compatibility with earlier versions of the Network Services Location Manager, applications can continue to call this function, but doing so is not necessary.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLContinueLookup (
NSLClientAsyncInfo *asyncInfo){};


/*NSLFreeTypedDataPtr

Frees memory allocated for a request parameter block.

NSLTypedDataPtr NSLFreeTypedDataPtr (
NSLTypedDataPtr nslTypeData);
Parameters
nslTypeData

On input, a value of type NSLTypedDataPtr, obtained by previously calling NSLMakeServicesRequestPB.
function result

A value of type NSLTypedDataPtr whose value is NULL.
Discussion

This utility function frees memory that was allocated when your application previously called NSLMakeServicesRequestPB. Your application should free the memory allocated for a request parameter block when it has no further use for the parameter block.
Availability
Available in Mac OS X v10.0 and later.*/
NSLTypedDataPtr NSLFreeTypedDataPtr (
NSLTypedDataPtr nslTypeData){};



/*NSLGetNextNeighborhood

Gets the position of the next neighborhood in a result buffer.

Boolean NSLGetNextNeighborhood (
NSLClientAsyncInfoPtr infoPtr,
NSLNeighborhood * neighborhood,
long * neighborhoodLength);
Parameters
infoPtr

On input, a pointer to an NSLClientAsyncInfo structure whose resultBuffer field may contain another neighborhood.
neighborhood

On input, a pointer to a value of type NSLNeighborhood. On output, neighborhood points to the next neighborhood in the resultBuffer field of the NSLClientAsyncInfo structure pointed to by infoPtr.
neighborhoodLength

On output, the length of the neighborhood pointed to by neighborhood.
function result

A Boolean value. A value of TRUE indicates that neighborhood points to the next neighborhood in the resultBuffer field pointed to by infoPtr. A value of FALSE indicates that there are no more neighborhoods in the resultBuffer field.
Discussion

This utility function provides the starting position and the length of the next neighborhood in a result buffer. Typically, the neighborhoods were placed in the result buffer by a previous call to NSLStartNeighborhoodLookup.

If you want to get a copy of the neighborhood, call NSLCopyNeighborhood. If you want to get the name from the neighborhood, call NSLGetNameFromNeighborhood.
Availability
Available in Mac OS X v10.0 and later.*/
Boolean NSLGetNextNeighborhood (
NSLClientAsyncInfoPtr infoPtr,
NSLNeighborhood * neighborhood,
long * neighborhoodLength){};



/*NSLDisposeServicesList

Disposes of a services list.

void NSLDisposeServicesList (
NSLServicesList theList);
Parameters
theList

On input, a value of type NSLServicesList, previously created by calling NSLMakeNewServicesList, that is to be disposed of.
Discussion

This utility function reclaims memory by disposing of a services list. Once you’ve incorporated the information in a services list into a request parameter block by passing the services list to NSLMakeServicesRequestPB, you can dispose of the services list. 

Calling NSLCloseNavigationAPI does not reclaim memory allocated for services lists, so your application should dispose of services lists before it closes a Network Services Location Manager session.
Availability
Available in Mac OS X v10.0 and later.*/
void NSLDisposeServicesList (
NSLServicesList theList){};

/*NSLGetNameFromNeighborhood

Locates the name in a neighborhood.

void NSLGetNameFromNeighborhood (
NSLNeighborhood neighborhood,
char ** name,
long * length);
Parameters
neighborhood

On input, a value of type NSLNeighborhood containing the name that is to be located.
name

On input, the address of a pointer. On output, name contains the address of a pointer to the name in the neighborhood parameter.
length

On input, a pointer to a location in memory. On output, length points to the length in bytes of the name in the neighborhood parameter.
Discussion

This utility function locates the null-terminated name in the neighborhood specified by the neighborhood parameter so that your application can, for example, display the name. Use the value pointed to by length to determine the length of the name.
Availability
Available in Mac OS X v10.0 and later.*/
void NSLGetNameFromNeighborhood (
NSLNeighborhood neighborhood,
char ** name,
long * length){};



/*NSLDeleteRequest

Deletes a request reference.

NSLError NSLDeleteRequest (
NSLRequestRef ref);
Parameters
ref

On input, the value of type NSLRequestRef, obtained by previously calling NSLPrepareRequest, that is to be deleted.
function result

An NSLError structure whose theErr field contains the result code. If the value of the theErr field is noErr, the request reference was deleted. Other possible values are kNSLNotInitialized and kNSLBadReferenceErr. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function deletes the specified request reference and deallocates memory associated with it, including the NSLClientAsyncInfo structure associated with the request reference. If a search using the specified request reference is in progress when this function is called, the search is canceled and any outstanding I/O is lost.

This function does not deallocate memory associated with services lists or request parameter blocks. To deallocate memory for services lists, call NSLDisposeServicesList; to deallocate memory for parameter blocks, call NSLFreeTypedDataPtr.
Availability
Available in Mac OS X v10.0 and later.*/

NSLError NSLDeleteRequest (
NSLRequestRef ref){};


/*NSLPrepareRequest

Creates a search request.

NSLError NSLPrepareRequest (
NSLClientNotifyUPP notifier,
void * contextPtr,
NSLClientRef theClient,
NSLRequestRef * ref,
char * bufPtr,
unsigned long bufLen,
NSLClientAsyncInfoPtr * infoPtr);
Parameters
notifier

On input, a value of type NSLClientNotifyUPP that points to your application’s notification routine, or NULL. Your notification routine will be called when data is available, when the search is complete, or when an error occurs.
contextPtr

On input, an untyped pointer to arbitrary data that the Network Services Location Manager will pass to your application’s notification routine when that routine is called. Your application can use contextPtr to associate any particular execution of your notification routine with any particular search request.
theClient

On input, a value of type NSLClientRef obtained by previously calling NSLOpenNavigationAPI that identifies the Network Services Location Manager session for which this request is being prepared.
ref

On input, a pointer to a value of type NSLRequestRef in which the resulting search request reference is to be placed.
bufPtr

On input, a pointer to the buffer in which search results are to be placed.
bufLen

On input, the length of the buffer pointed to by bufPtr.
infoPtr

On output, the NSLClientAsyncInfo structure pointed to by infoPtr contains default instructions for how the search is to be conducted. Your application can change the defaults before it starts the search.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, the request was created. Other possible values include kNSLNotInitialized, kNSLDuplicateSearchInProgress, kNSLBadClientInfoPtr, and kNSLErrNullPtrError (if the value of infoPtr is NULL). Call NSLErrorToString to get a problem and a solution string.
Discussion

This function creates a search request that your application later provides as a parameter when it calls NSLStartNeighborhoodLookup or NSLStartServicesLookup. Searches are conducted asynchronously.

Your application’s notification routine will be called when the result buffer contains data, the result buffer is full, when the search is complete, or when an error occurs. Your application can cause your application’s notification routine to be called at a specified interval, when a specified number of items is in the result buffer, or when a specified amount of time has elapsed by modifying the value of the alertInterval, alertThreshold, and maxSearchTime fields, respectively, of the NSLClientAsyncInfo structure pointed to by infoPtr.

If this function returns a result code of kNSLDuplicateSearchInProgress, a search is in progress that is using a request reference that is identical to the newly created request reference. Your application can ignore this warning and use the newly created request reference, delete the newly created request reference, or cancel the search that is using the identical request reference.
Special Considerations

When your application no longer needs the request reference, it should call NSLDeleteRequest to reclaim memory associated with it.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLPrepareRequest (
NSLClientNotifyUPP notifier,
void * contextPtr,
NSLClientRef theClient,
NSLRequestRef * ref,
char * bufPtr,
unsigned long bufLen,
NSLClientAsyncInfoPtr * infoPtr){};


/*NSLStartNeighborhoodLookup

Starts a search for neighborhoods.

NSLError NSLStartNeighborhoodLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLClientAsyncInfo *asyncInfo);
Parameters
ref

On input, a value of type NSLRequestRef created by previously calling NSLPrepareRequest.
neighborhood

On input, NULL or an NSLNeighborhood value created by previously calling NSLMakeNewNeighborhood. Passing NULL or a neighborhood parameter that was created with a name parameter whose value was NULL causes this function to get the default neighborhoods. If neighborhood was created with a value of name that is the name of a neighborhood, this function gets names related to that neighborhood. For example, if neighborhood was created with name set to “apple.com”, this function gets the subdomains of apple.com.
asyncInfo

On input, a pointer to an NSLClientAsyncInfo structure. Neighborhoods that are found will be stored in the structure’s resultBuffer field.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, this function successfully started a neighborhood search. Possible errors are kNSLNotInitialized, kNSLSearchAlreadyInProgress, kNSLNoPluginsForSearch, kNSLBufferTooSmallForData, and kNSLNullNeighborhoodPtr. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function starts a search for neighborhoods that your application can use to define the scope of a subsequent service search. The result of the search is returned to your application in the resultBuffer field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter when the Network Services Location Manager calls your application’s notification routine. Call NSLGetNextNeighborhood to process the data in the result buffer. To cancel an ongoing search, call NSLCancelRequest. To delete a search request reference, call NSLDeleteRequest.

When the Network Services Location Manager calls your application’s notification routine, it should check the value of the searchState field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter. The searchState field will contain one of these values: kNSLSearchStateBufferFull, kNSLSearchStateOnGoing, kNSLSearchStateComplete, or kNSLSearchStateStalled.

If the value of the searchState field is kNSLSearchStatausBufferFull, your application’s notification routine should process the data returned in the resultBuffer field of the NSLClientAsyncInfo structure and return.

If the value of the searchState field is kNSLSearchStateOnGoing, the threshold set by the value of the alertInterval field or the alertThreshold field of the NSLClientAsyncInfo structure has been reached. Your application’s notification routine should process the data returned in the resultBuffer field of the NSLClientAsyncInfo structure and return.

If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartNeighborhoodLookup is noErr, the search is complete. Your application’s notification routine should process the data returned in resultBuffer and return. If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartNeighborhoodLookup is not noErr, the error is a fatal error and the search has ended.

If the value of the searchState field is kNSLSearchStateStalled, the threshold set by the value of the alertInterval field or the maxSearchTime field of the NSLClientAsyncInfo structure has been reached and there is no data in the result buffer. The Network Services Location Manager plug-ins that are processing this neighborhood search request are waiting to receive data from a server and may eventually time out. You can cancel the request by calling NSLCancelRequest.

If the value of NSLError.theErr returned by this function is kNSLBufferTooSmallForData, the value of the maxBufferSize field of the NSLClientAsyncInfo structure is too small to hold data that would otherwise have been returned. Your notification routine can cancel the search, modify the size of the buffer, and restart the search, or it can ignore the error and return, thereby resuming the search even though some data has been lost.
Special Considerations

For any request reference, only one neighborhood or service search can be in progress at any one time.

If this function returns an error, the resultBuffer field of the NSLClientAsyncInfo structure may still contain valid data that was collected before the error occurred. Your notification routine should process the data in the result buffer and return, thereby continuing the search.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLStartNeighborhoodLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLClientAsyncInfo *asyncInfo){};

/*NSLErrorToString

Obtains information about an error.

OSStatus NSLErrorToString (
NSLError theErr,
char * errorString,
char * solutionString);
Parameters
theErr

On input, an NSLError structure whose theErr field contains a Network Services Location Manager result code.
errorString

On input, a pointer to the buffer in which this function is to place a null-terminated string containing a description of the problem that caused the error. The length of errorString should be 256 bytes.
solutionString

On input, a pointer to the buffer in which this function is to place a null-terminated string containing a possible solution to the problem. The length of solutionString should be 256 bytes.
function result

A value of noErr indicates that this function returned successfully. If the value of the theContext field of the NSLError structure that was passed to this function is zero and the theErr field contains a result code that is not within the range of Network Services Location Manager result codes, this function returns kNSLBadReferenceErr.
Discussion

This function obtains the error and solution strings for the result code stored in the theErr field of an NSLError structure.Your application can use the strings to display an appropriate error message.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLErrorToString (
NSLError theErr,
char * errorString,
char * solutionString){};

/*NSLMakeNewServicesList

Creates a services list.

NSLServicesList NSLMakeNewServicesList (
char* initialServiceList);
Parameters
initialServiceList

On input, a pointer to a comma-delimited, null-terminated string of service names, such as http,ftp.
function result

A value of type NSLServicesList. This function returns NULL if it can’t create the services list because, for example, there is not enough memory or because the Network Services Location Manager is not initialized.
Discussion

This function creates a services list and fills it with the names of the services specified by the initialServiceList parameter. After creating the services list, you can add the names of additional services by calling NSLAddServiceToServicesList.
Special Considerations

When you have no further use for the services list, you should reclaim the memory allocated to it by calling NSLDisposeServicesList.
Availability
Available in Mac OS X v10.0 and later.*/
NSLServicesList NSLMakeNewServicesList (
char* initialServiceList){};



/*NSLStandardDeregisterURL

Deregisters a service.

OSStatus NSLStandardDeregisterURL (
NSLPath urlToDeregister,
NSLNeighborhood neighborhoodToDeregisterIn);
Parameters
urlToDeregister

On input, a value of type NSLPath specifying the URL that is to be deregistered.
neighborhoodToDeregisterIn

On input, a value of type NSLNeighborhood specifying the neighborhood in which to deregister the service, or NULL. If NULL is specified, the Network Services Location Manager determines the neighborhood from which the service is deregistered.
function result

A value of noErr indicates that the service was deregistered. A value of kNSLBadURLSyntax indicates that the URL contains characters that are not allowed, such as spaces. To encode characters that are not allowed, call NSLHexEncodeText.
Discussion

This function deregisters the service specified by urlToDeregister. An application that registers services by calling NSLStandardRegisterURL should call this function as part of its standard shutdown procedure.
Special Considerations

You do not have to call NSLOpenNavigationAPI before calling this function.

This function is available in version 1.1 of the Network Services Location Manager and later, and supersedes the NSLDeRegisterService function, which was provided in version 1.0.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLStandardDeregisterURL (
NSLPath urlToDeregister,
NSLNeighborhood neighborhoodToDeregisterIn){};

/*NSLMakeServicesRequestPB

Creates a request parameter block.

OSStatus NSLMakeServicesRequestPB (
NSLServicesList serviceList,
NSLTypedDataPtr * newDataPtr);
Parameters
serviceList

On input, a value of type NSLServicesList created by previously calling NSLMakeNewServicesList.
newDataPtr

On input, the address of the NSLTypedDataPtr at which the resulting parameter block is to be placed.
function result

A value of noErr indicates that the parameter block was created successfully. Possible errors include kNSLBadDomainErr.
Discussion

This utility function creates a parameter block formatted properly for use with subsequent calls to NSLStartServicesLookup.
Availability
Available in Mac OS X v10.0 and later.*/

OSStatus NSLMakeServicesRequestPB (
NSLServicesList serviceList,
NSLTypedDataPtr * newDataPtr){};

/*NSLFreeNeighborhood

Disposes of an NSLNeighborhood value.

NSLNeighborhood NSLFreeNeighborhood (NSLNeighborhood neighborhood);
Parameters
neighborhood

On input, the NSLNeighborhood value, obtained by previously calling NSLMakeNewNeighborhood, that is to be disposed of.
function result

An NSLNeighborhood whose value is NULL.
Discussion

This utility function disposes of an NSLNeighborhood value and reclaims the memory that was allocated to it.
Availability
Available in Mac OS X v10.0 and later.*/
NSLNeighborhood NSLFreeNeighborhood (NSLNeighborhood neighborhood){};


/*NSLStartServicesLookup

Starts a search for services.

NSLError NSLStartServicesLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLTypedDataPtr requestData,
NSLClientAsyncInfo *asyncInfo);
Parameters
ref

On input, a value of type NSLRequestRef containing a request reference obtained by previously calling NSLPrepareRequest.
neighborhood

On input, NULL or an NSLNeighborhood value created by previously calling NSLMakeNewNeighborhood. Passing NULL or a neighborhood created with a name parameter whose value was NULL causes this function to start a search for top-level services.
requestData

On input, a value of type NSLTypedDataPtr that describes the search parameters. To format requestData properly, call NSLMakeServicesRequestPB.
asyncInfo

On input, a pointer to a NSLClientAsyncInfo structure obtained by previously calling NSLPrepareRequest.
function result

An NSLError structure whose theErr field contains the result code. If the value of NSLError.theErr is noErr, this function successfully started a service search. Other possible values are kNSLNotInitialized, kNSLSearchAlreadyInProgress, kNSLNoPluginsForSearch, kNSLNullNeighborhoodPtr, and kNSLBufferTooSmallForData. Call NSLErrorToString to get a problem and a solution string.
Discussion

This function starts a service search. The result of the search is returned to your application in the resultBuffer field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter when the Network Services Location Manager calls your application’s notification routine. Call NSLGetNextURL to process the data in the result buffer. To cancel an ongoing search, call NSLCancelRequest. To delete a search request reference, call NSLDeleteRequest.

When the Network Services Location Manager calls your application’s notification routine, it should check the value of the searchState field of the NSLClientAsyncInfo structure pointed to by the asyncInfo parameter. The searchState field will contain one of these values: kNSLSearchStateBufferFull, kNSLSearchStateOnGoing, kNSLSearchStateComplete, or kNSLSearchStateStalled.

If the value of the searchState field is kNSLSearchStatausBufferFull, your application’s notification routine should process the data in the resultBuffer field of the NSLClientAsyncInfo structure and return.

If the value of the searchState field is kNSLSearchStateOnGoing, the threshold set by the value of the alertInterval field or the alertThreshold field of the NSLClientAsyncInfo structure has been reached. Your application’s notification routine should process the data in the resultBuffer field and return.

If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartServicesLookup is noErr, the search is complete. Your application’s notification routine should process the data returned in resultBuffer and return. If the value of the searchState field is kNSLSearchStateComplete and the value of NSLError.theErr returned by NSLStartServicesLookup is not noErr, the error is a fatal error and the search has ended.

If the value of the searchState field is kNSLSearchStateStalled, the threshold set by the value of the alertInterval field or the maxSearchTime field of the NSLClientAsyncInfo structure has been reached and there is no data in the result buffer. The Network Services Location Manager plug-ins that are processing this request are waiting to receive data from a server and may eventually time out. You can cancel the request by calling NSLCancelRequest. If the value of the searchState field is noErr, your application’s notification routine should ignore the notification and return immediately, thereby resuming the search.

If the value of NSLError.theErr returned by this function is kNSLBufferTooSmallForData, the value of the maxBufferSize field of the NSLClientAsyncInfo structure is too small to hold data that would otherwise have been placed in the result buffer. Your application’s notification routine can cancel the search, modify the size of the buffer, and start the lookup again, or it can ignore the error and return, thereby resuming the search even though some data has been lost.
Special Considerations

For any request reference, only one neighborhood or service search can be ongoing at any one time.

If this function returns an error, the resultBuffer field of the NSLClientAsyncInfo structure may still contain valid data that was collected before the error occurred. Your notification routine should process the data in the result buffer and return, thereby continuing the search.
Availability
Available in Mac OS X v10.0 and later.*/
NSLError NSLStartServicesLookup (
NSLRequestRef ref,
NSLNeighborhood neighborhood,
NSLTypedDataPtr requestData,
NSLClientAsyncInfo *asyncInfo){};


/*NSLStandardRegisterURL

Registers the URL of a service.

OSStatus NSLStandardRegisterURL (
NSLPath urlToRegister,
NSLNeighborhood neighborhoodToRegisterIn);
Parameters
urlToRegister

On input, a value of type NSLPath specifying the URL to register.
neighborhoodToRegisterIn

On input, a value of type NSLNeighborhood specifying the neighborhood in which to register the service, or NULL. If NULL is specified, the Network Services Location Manager determines the neighborhood in which the URL is registered.
function result

A value of noErr indicates that the service was registered. A value of kNSLBadURLSyntax indicates that the URL contains characters that are not allowed, such as spaces. To encode characters that are not allowed, call NSLHexEncodeText.
Discussion

This function registers the specified URL with the Network Services Location Manager.

Applications that provide a network service typically call this function as part of their startup procedure. They also call NSLStandardDeregisterURL as part of their shutdown procedure.
Special Considerations

You do not have to call NSLOpenNavigationAPI before calling this function.

This function is available in version 1.1 and later of the Network Services Location Manager, and supersedes the NSLRegisterService function, which was provided in version 1.0.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLStandardRegisterURL (
NSLPath urlToRegister,
NSLNeighborhood neighborhoodToRegisterIn){};

/*NSLHexEncodeText

Encodes a portion of a URL.

OSStatus NSLHexEncodeText (
char* rawText,
UInt16 rawTextLen,
char* newTextBuffer,
UInt16* newTextBufferLen,
Boolean* textChanged);
Parameters
rawText

On input, a pointer to a character array containing the portion of a URL that is to be encoded. For example, if the URL is afp://17.221.40.66?NAME=Kevs G3, the portion of the URL that contains a character that is not allowed is Kevs G3. In this example, the space character is not allowed.
rawTextLen

On input, a value of type UInt16 containing the length in bytes of the rawText parameter.
newTextBuffer

On input, a pointer to a buffer. On output, the buffer contains the encoded text.
newTextBufferLen

On input, a pointer to a value of type UInt16. On output, newTextBufferLen points to the length of the encoded text in the buffer pointed to by newTextBuffer.
textChanged

On input, a pointer to a Boolean value. On output, textChanged points to a value that is TRUE if encoding occurred or that is FALSE if no encoding was required.
function result

A value of noErr indicates that this utility function returned successfully. See “Network Services Location Manager Result Codes” for other possible result codes.
Discussion

This utility function uses the US ASCII character set to encode characters that are not allowed in URLs. Hexadecimal values from 01 to 1F, from 80 to FF, and 7F are not allowed. In addition, the following characters are not allowed:

< > " # { } | \ ^ ~ [ ]

This utility function also encodes the following characters that are reserved for URL syntax:

; / ? : @ = % &

If this utility function returns noErr, the buffer pointed to by newTextBuffer contains the encoded copy of the buffer pointed to by rawText, or it contains an exact copy of the buffer pointed to by rawText. Use the textChanged parameter to determine whether any encoding actually took place.

Call NSLHexDecodeText to decode a string that has been encoded.
Special Considerations

The NSLStandardRegisterURL function returns an error if a URL you try to register contains characters that need to be encoded.
Availability
Available in Mac OS X v10.0 and later.*/
OSStatus NSLHexEncodeText (
char* rawText,
UInt16 rawTextLen,
char* newTextBuffer,
UInt16* newTextBufferLen,
Boolean* textChanged){};


/*OTDestroyTimerTask

Disposes of a timer task. (Deprecated in Mac OS X v10.4.)

void OTDestroyTimerTask (
   OTTimerTask timerTask
);
Parameters
timerTask
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/

void OTDestroyTimerTask (
   OTTimerTask timerTask
){};

/*OTInitInetAddress

Fills in an InetAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

void OTInitInetAddress (
   InetAddress * addr,
   InetPort port,
   InetHost host
);
Parameters
addr
port
host
Discussion

This function fills in the fAddressType field of the InetAddress structure with the value AF_INET. You use the InetAddress structure when providing a TCP or UDP address to the Open Transport functions OTConnect, OTSndURequest, and OTBind. You are not required to use the OTInitInetAddress function when creating an InetAddress structure; this function is provided for your convenience only.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/
void OTInitInetAddress (
   InetAddress * addr,
   InetPort port,
   InetHost host
){};

/*OTCancelTimerTask

Cancels a task that was already scheduled for execution. (Deprecated in Mac OS X v10.4.)

Boolean OTCancelTimerTask (
   OTTimerTask timerTask
);
Parameters
timerTask
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/
Boolean OTCancelTimerTask (
   OTTimerTask timerTask
){};


/*OTGetEndpointState

Obtains the current state of an endpoint. (Deprecated in Mac OS X v10.4.)

OTResult OTGetEndpointState (
   EndpointRef ref
);
Parameters
ref
Return Value

See the description of the OTResult data type.
Discussion

The OTGetEndpointState function returns an integer greater than or equal to 0 indicating the state of the specified endpoint. The endpoint state enumeration describes possible endpoint states and lists their decimal value.

If the function fails, it returns a negative integer specifying the error code. You must open an endpoint before you can determine its state.

You might need to know an endpoint’s state in order to determine whether a function has completed or whether the endpoint is in an appropriate state for the function that you want to call next.

This function returns endpoint state information immediately, whether the endpoint is in synchronous or asynchronous mode.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTGetEndpointState (
   EndpointRef ref
){};

/*OTAtomicTestBit

Tests a bit in a byte and returns its current state. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicTestBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicTestBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
){};



/*OTScheduleTimerTask

Schedules a timer task to be executed at the specified time. (Deprecated in Mac OS X v10.4.)

Boolean OTScheduleTimerTask (
   OTTimerTask timerTask,
   OTTimeout milliSeconds
);
Parameters
timerTask
milliSeconds
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProtocol.h*/

Boolean OTScheduleTimerTask (
   OTTimerTask timerTask,
   OTTimeout milliSeconds
){};


/*OTAtomicSetBit

Sets a specified bit in a byte. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicSetBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicSetBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
){};

/*OTInetStringToAddress

Resolves a domain name to its equivalent internet addresses. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetStringToAddress (
   InetSvcRef ref,
   char * name,
   InetHostInfo * hinfo
);
Parameters
ref
name

A pointer to the domain name you want to resolve. This can be a host name, a partially qualified domain name, a fully qualified domain name, or an internet address in dotted-decimal format.
hinfo
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, a single host can be associated with multiple internet addresses. You can use the OTInetStringToAddress function to return multiple addresses for multihomed hosts.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetStringToAddress function never returns more than one address.

If you specify an internet address in dotted-decimal format for the hinfo parameter, the OTInetStringToAddress function places that address in the InetHostInfo.name field instead of a canonical domain name.

If you call the OTInetStringToAddress function asynchronously, the TCP/IP service provider calls your notifier function with the T_DNRSTRINGTOADDRCOMPLETE completion event code when the function completes. The cookie parameter to the notifier function contains the pointer you specified in the hinfo parameter. If you had more than one simultaneous outstanding call to the OTInetStringToAddress function, you can use this information to determine which call has completed execution.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/
OSStatus OTInetStringToAddress (
   InetSvcRef ref,
   char * name,
   InetHostInfo * hinfo
){};

/*OTAsyncOpenEndpoint
Opens an endpoint and installs a notifier callback function for the endpoint.

C INTERFACE
OSStatus OTAsyncOpenEndpoint( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OTNotifyProcPtr proc, 
                     void* contextPtr);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
config 
A pointer to an endpoint configuration structure that specifies the endpoint's characteristics. You obtain a value for the config parameter by calling the OTCreateConfiguration function. The OTAsyncOpenEndpoint function disposes of the configuration structure before returning. 
oflag 
Reserved; must be set to 0. 
info 
A pointer to a TEndpointInfo structure to be filled in by the OTAsyncOpenEndpoint function. Specify NULL for this parameter if you do not want the OTAsyncOpenEndpoint function to return endpoint information. 
proc 
A pointer to a notifier callback function for this endpoint. If you do not provide a notifier function, your application cannot receive completion events, including the event advising you that the endpoint has been created. Never pass a universal procedure pointer as the proc parameter. 
contextPtr 
A pointer for your use. The endpoint passes this pointer value when calling the notifier function you specify in the proc parameter. You might use the contextPtr parameter to pass your notifier function information about the endpoint, for example. 
function result 
An error code. See Discussion. 
DISCUSSION
The OTAsyncOpenEndpoint function opens an endpoint having the characteristics specified by the config parameter. How processing proceeds depends on this result code.

If the result code is any except kOTNoError, an error occurred and Open Transport does not queue the function for execution. The OTAsyncOpenEndpoint function creates no endpoint and does not call the notifier function that you specified in the proc parameter.

If the result code is kOTNoError, the OTAsyncOpenEndpoint function has queued the operation for execution. When it completes it calls the notifier function that you specified in the proc parameter, passing the event T_OPENCOMPLETE for the code parameter, a result code in the result parameter, and the endpoint reference for the newly created endpoint in the cookie parameter. For information about notifier functions, see "Application-Defined Notifier Functions" and "Event Codes". 

An endpoint created by the OTAsyncOpenEndpoint function operates in asynchronous mode, does not block, and does not acknowledge sends. To change these default settings, you can call the OTSetSynchronous function, OTSetBlocking function and the OTAckSends function. 

The initial state of an endpoint is T_UNBND, meaning that the endpoint is not bound to a protocol address. Before using the endpoint to transfer data, you must bind it to a protocol address by calling the OTBind function.

SPECIAL CONSIDERATIONS
The first time you open a provider of any kind, Open Transport allocates needed resources at system task time, calling the ScheduleSystemTask function to do this. To allow this processing to take place, you need to call SystemTask or WaitNextEvent from a foreground task while waiting for the endpoint to be created.

The OTAsyncOpenEndpoint function disposes of the configuration structure returned by the OTCreateConfiguration function. If you want to use the same configuration to open additional endpoints, you must obtain a valid copy of the configuration structure by calling the OTCloneConfiguration function before you call the OTAsyncOpenEndpoint function. For more information, see "Configuring and Opening a Provider".

SEE ALSO
The OTOpenEndpoint function.*/
OSStatus OTAsyncOpenEndpoint( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OTNotifyProcPtr proc, 
                     void* contextPtr){};

/*OTCreateTimerTask
Creates a task to be scheduled.

C INTERFACE
pascal long OTCreateTimerTask(OTProcessProcPtr proc, void* arg);
C++ INTERFACES 
None. C++ applications use the C interface to this function.

PARAMETERS
proc 
A procedure pointer referencing the task to be created. 
arg 
A pointer to a user-defined value to be passed to the task when it executes. 
function result 
A 32-bit value identifying the task that was created. You must pass this value for the timerTask parameter of the OTScheduleTimerTask function. 
DISCUSSION
The OTCreateTimerTask function creates a task that you can schedule later with the function OTScheduleTimerTask.

SEE ALSO
The OTScheduleTimerTask function.

The OTCancelTimerTask function.

The OTDestroyTimerTask function.*/
pascal long OTCreateTimerTask(OTProcessProcPtr proc, void* arg){};


/*OTAtomicClearBit

Clears a bit in a byte. (Deprecated in Mac OS X v10.4.)

Boolean OTAtomicClearBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
);
Parameters
bytePtr
bitNumber
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTAtomicClearBit (
   UInt8 * bytePtr,
   OTByteCount bitNumber
){};


/*OTDestroyConfiguration

Deletes an OTConfiguration structure. (Deprecated in Mac OS X v10.4.)

void OTDestroyConfiguration (
   OTConfigurationRef cfig
);
Parameters
cfig
Discussion

The OTDestroyConfiguration function deletes the OTConfiguration structure that you specify in the cfig parameter and releases all associated memory.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTDestroyConfiguration (
   OTConfigurationRef cfig
){};


/*OTUnbind

Dissociates an endpoint from its address or cancels an asynchronous call to the OTBind function. (Deprecated in Mac OS X v10.4.)

OSStatus OTUnbind (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If you call the OTUnbind function asynchronously and you have not installed a notifier function, the only way to determine that the endpoint has been unbound is to use the OTGetEndpointState function to poll the state of the endpoint. The function returns the kOTStateChangeErr result when the OTUnbind function returns. If the function succeeds, the state of the endpoint is T_UNBND. If it fails, its state is T_IDLE.

After you unbind an endpoint, you can no longer use it to send or receive information. You can use the OTCloseProvider function to deallocate memory reserved for the endpoint, or you can use the OTBind function to associate it with another address and then resume transferring data or establishing a connection.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTUnbind (
   EndpointRef ref
){};



/*InitOpenTransport
Initializes the parts of Open Transport for use by the application or code resource.

C INTERFACE 
OSStatus InitOpenTransport(void);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
function result 
An error code. See Appendix B. 
DISCUSSION
Call this function before using other Open Transport functions. 

If you need to know whether Open Transport is present at start-up time, but you don't need to use it (e.g. an installer),you can use the Gestalt function and its Open Transport selectors as described in "The Gestalt Selector and Response Bits". However, for normal applications, your calling the InitOpenTransport function is sufficient to test for the presence of Open Transport.

To initialize only the parts of Open Transport that handle ports and implement the Open Transport utility functions call the InitOpenTransportUtilities function.

SPECIAL CONSIDERATIONS 
You must make sure that your A5 world is correctly initialized for 68000 code resources.

If your program uses the Apple Shared Library Manager (ASLM), you must call the InitLibraryManager function to initialize ASLM before calling the InitOpenTransport function. To initialize ASLM, use the InitLibraryManager function, described in the Apple Shared Library Manager Developer's Guide.

For applications, Open Transport patches the ExitToShell trap when you call the function InitOpenTransport. The patch calls the function CloseOpenTransport if Open Transport is still active when your application quits.

SEE ALSO
"The Gestalt Selector and Response Bits".

"Initializing and Closing Open Transport". 

The CloseOpenTransport function.*/
OSStatus InitOpenTransport(void){};

/*OTAsyncOpenInternetServices
C INTERFACE
OSStatus OTAsyncOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OTNotifyProcPtr proc,
                                         
C++ INTERFACE
None. C++ clients use the C interface to this function.

PARAMETERS
cfig 
A pointer to a network configuration structure. You can obtain the default configuration by using the constant kDefaultInternetServicesPath for this parameter. 
oflag 
Reserved. Must be set to 0. 
proc 
A pointer to your notifier function. The TCP/IP service provider passes the internet services reference to your notifier function in the cookie parameter. 
contextPtr 
A pointer for your use. The TCP/IP service provider passes this value unchanged to your notifier function. 
function result 
A result code. See Appendix B for additional information. 
DISCUSSION
You must open a TCP/IP service provider before calling any TCP/IP services functions other than the address utility functions. You must provide the Internet services reference when calling any of these non-utility functions. The OTAsyncOpenInternetServices function runs asynchronously and sets the mode of the TCP/IP service provider as asynchronous.

For information on how to specify options using the cfig parameter, see Table 11-2.

SEE ALSO
The OTOpenInternetServices function.*/
OSStatus OTAsyncOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OTNotifyProcPtr proc,
                                           int contextPtr/*hys*/){};
                                         
/*CloseOpenTransport
Unregisters your application or code resource connection to Open Transport.

C INTERFACE 
void CloseOpenTransport(void);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

DISCUSSION
The CloseOpenTransport function tells Open Transport that your application or code resource has finished using it. You can call this function only at system task time. You must not call this function if you have any outstanding network I/O in progress, such as an outstanding asynchronous operation.

When your application finishes using Open Transport, you have the option of using this function to unload Open Transport without stopping execution if your application has other tasks to perform that do not require Open Transport. If you are writing an application, you are not required to use this function, but it is strongly recommended that you do so.

If you are writing a code resource, a CFM code fragment, or a shared library, you must call the CloseOpenTransport function before unloading from memory.

System software cannot unload the Open Transport kernel until the last software module on your computer that called the InitOpenTransport function has also called the CloseOpenTransport function.

SPECIAL CONSIDERATIONS 
If your client uses the Apple Shared Library Manager, be sure you call the CleanupLibraryManager function after calling the CloseOpenTransport function. 

SEE ALSO
The InitOpenTransport function. 

The InitOpenTransportUtilities function. 

"Getting Started With Open Transport" in Networking With Open Transport.*/
void CloseOpenTransport(void){};


/*OTRcvConnect

Reads the status of an outstanding or completed asynchronous call to theOTConnect function. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvConnect (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTRcvConnect function to determine the status of a previously issued OTConnect call. If you want to retrieve information about the connection, you must allocate buffers for the addr field and, if required, the opt and udata fields before you make the call.

If the endpoint is synchronous and blocking, the OTRcvConnect function waits for the connection to be accepted or rejected. If the connection is accepted, the function returns with a kOTNoError result. If the connection is rejected, the function returns with a kOTLookErr result. In this case, you should call the OTLook function to verify that a T_DISCONNECT event is the reason for the kOTLookErr, and then you should call the OTRcvDisconnect function to clear the event.

If the endpoint is asynchronous or nonblocking, the OTRcvConnect function returns with the kOTNoDataErr result if the connection has not yet been established.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvConnect (
   EndpointRef ref,
   TCall * call
){};





/*OTCloneConfiguration

Copies an OTConfiguration structure. (Deprecated in Mac OS X v10.4.)

OTConfigurationRef OTCloneConfiguration (
   OTConfigurationRef cfig
);
Parameters
cfig
Return Value

See the description of the OTConfigurationRef data type.
Discussion

The OTCloneConfiguration function copies the OTConfiguration structure that you specify in the cfig parameter and returns a pointer to the copy. Because the internal format of an OTConfiguration structure is private, you must use the OTCloneConfiguration function to obtain two identical structures. For example, you can use this function when another application passes you a configuration structure that you want to reuse but for which you do not have the original configuration string. By cloning the structure, you have access to an additional copy of the configuration even without knowing its configuration string.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTConfigurationRef OTCloneConfiguration (
   OTConfigurationRef cfig
){};


/*OTLook

Determines the current asynchronous event pending for an endpoint. (Deprecated in Mac OS X v10.4.)

OTResult OTLook (
   EndpointRef ref
);
Parameters
ref
Return Value

See the description of the OTResult data type.
Discussion

You use the OTLook function in one of two cases. First, if the endpoint is in synchronous mode, you can call the OTLook function to poll for incoming data or connection requests. Second, certain asynchronous events might cause a synchronous function to fail with the result kOTLookErr. For example, if you call OTAccept and the endpoint gets a T_DISCONNECT event, the OTAccept function returns with kOTLookErr. In this case, you need to call the OTLook function to determine what event caused the original function to fail. Table 3-7 on page 3-26 lists the functions that might return the kOTLookErr result and the events that can cause these functions to fail.

The OTLook function returns an integer value that specifies the asynchronous event pending for the endpoint specified by the ref parameter. On error, OTLook returns a negative integer corresponding to a result code.

If there are multiple events pending, the OTLook function first looks for one ofthe following events: T_LISTEN, T_CONNECT, T_DISCONNECT, T_UDERR, or T_ORDREL. If it finds more than one of these, it returns them to you in first-in, first-out order. After processing these events, the OTLook function looks for the T_DATA, T_REQUEST, and T_REPLY events. If it finds more than one of these, it returns them to you in first-in, first-out order. You cannot use the OTLook function to poll for completion events.

Unless you are operating exclusively in synchronous mode, it is recommended that you use notifier functions to get information about pending events for an endpoint.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTResult OTLook (
   EndpointRef ref
){};


/*OTSndOrderlyDisconnect

Initiates or completes an orderly disconnection. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndOrderlyDisconnect (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You call the OTSndOrderlyDisconnect function to initiate an orderly release of a connection and to indicate to the peer endpoint that you have no more data to send. After calling this function, you must not send any more data over the connection. However, you can still continue to receive data if the peer endpoint has not yet called the OTSndOrderlyDisconnect function.

This function is a service that is not supported by all protocols. If it is supported, the servtype field of the TEndpointInfo structure has the value T_COTS_ORD or T_TRANS_ORD.

The OTSndOrderlyDisconnect function behaves exactly the same in all modes of operation.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSndOrderlyDisconnect (
   EndpointRef ref
){};

/*OTRcvDisconnect

Identifies the cause of a connection break or of a connection rejection, acknowledges and clears the corresponding disconnection event. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvDisconnect (
   EndpointRef ref,
   TDiscon * discon
);
Parameters
ref
discon
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Calling the OTRcvDisconnect function clears the corresponding disconnection event and retrieves any user data sent with the disconnection.

If you do not care about data returned with the disconnection and do not needto know the reason for the disconnection nor the sequence ID, you may specify a nil pointer for the discon parameter. In this case, the provider discards any user data associated with the disconnection.

The OTRcvDisconnect function behaves in the same way for all modes of operation. If there is no disconnection request pending, the function returns with the kOTNoDisconnectErr result. If there is a disconnection request pending, the function returns either the kOTNoError or kOTBufferOverflowErr result. In the latter instance, you need to check the discon field of the TEndpointInfo structure for your endpoint and make sure that the buffer referenced by the udata.buf field is at least as big as the value specified for the discon field.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvDisconnect (
   EndpointRef ref,
   TDiscon * discon
){};



/*OTRcvOrderlyDisconnect

Acknowledges a request for an orderly disconnect. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvOrderlyDisconnect (
   EndpointRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTRcvOrderlyDisconnect function is a service that is not supported by all protocols. If it is, the servtype field of the TEndpointInfo structure has the value T_COTS_ORD or T_TRANS_ORD for the endpoint.

After using the OTRcvOrderlyDisconnect function to acknowledge receipt of a disconnection request, there will not be any more data to receive. Calls to the OTRcv function (for a transactionless connection) or to the OTRcvRequest function (for a transaction-based connection) after acknowledging a disconnection request fail with the kOTOutStateErr result. If the endpoint supports a remote orderly disconnect, you can still send data over the connection if you have not yet called the OTSndOrderlyDisconnect function.

The OTRcvOrderlyDisconnect function behaves in the same way in all modes of operation. If there is no disconnection request pending, the function returns with the kOTNoReleaseErr result. It there is a disconnection request pending, the function returns either the kOTNoError or kOTBufferOverflowErr result. In the latter instance, you need to check the discon field of theTEndpointInfo structure for your endpoint and make sure that the buffer referenced by the udata.buf field is at least as big as the value specified for the discon field.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvOrderlyDisconnect (
   EndpointRef ref
){};


/*OTEnterNotifier

Limits the notifications that can be sent to your notifier. (Deprecated in Mac OS X v10.4.)

Boolean OTEnterNotifier (
   ProviderRef ref
);
Parameters
ref
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
Boolean OTEnterNotifier (
   ProviderRef ref
){};


/*OTSndDisconnect

Tears down an open connection (abortive disconnect) or rejects an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndDisconnect (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

There are two functions that you can use to tear down a connection: OTSndDisconnect for an abortive disconnect, or OTSndOrderlyDisconnect for an orderly disconnect. It is recommended that you use the OTSndOrderlyDisconnect function for tearing down a connection whenever possible and that you use the OTSndDisconnect function only for rejecting incoming connection requests.

If the endpoint is in asynchronous mode, the OTSndDisconnect function returns immediately with a result of kOTNoError to indicate that the disconnection process has begun and that your notifier function will be called when the process completes.

When the connection has been broken, the provider issues a T_DISCONNECTCOMPLETE event. If you have installed a notifier function, Open Transport calls your notifier and passes this event in the code parameter. The cookie parameter contains the call parameter. If you have not installed a notifier function, you cannot determine when this function completes.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTSndDisconnect (
   EndpointRef ref,
   TCall * call
){};


/*OTListen

Listens for an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTListen (
   EndpointRef ref,
   TCall * call
);
Parameters
ref
call
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You use the OTListen function to listen for incoming connection requests. On return, the function fills in the TCall structure referenced by the call parameter with information about the connection request. After retrieving the connection request using the OTListen function, you can reject the request using the OTSndDisconnect function, or you can accept the request using the OTAccept function.

If the endpoint is in synchronous mode and is blocking, the OTListen function returns when a connection request has arrived. If the endpoint is in asynchronous mode or is not blocking, the OTListen function returns any pending connection requests or returns the kOTNoDataErr result if there are no pending connection requests. You can also call the OTListen function from within a notifier function in response to the T_LISTEN event. In this case, the function returns a result immediately.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTListen (
   EndpointRef ref,
   TCall * call
){};
/*OTLeaveNotifier

Allows Open Transport to resume sending primary and completion events. (Deprecated in Mac OS X v10.4.)

void OTLeaveNotifier (
   ProviderRef ref
);
Parameters
ref
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTLeaveNotifier (
   ProviderRef ref
){};


/*OTAckSends

Specifies that a provider make an internal copy of data being sent and that it notify you when it has finished sending data. (Deprecated in Mac OS X v10.4.)

OSStatus OTAckSends (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

By default, providers make an internal copy of data before sending it and they do not acknowledge sends. If you use the OTAckSends function to specify that the provider acknowledge sends and you call a function that sends data, the provider does not copy the data before sending it. Instead, it reads data directly from your buffer while sending. For this reason, you must not change the contents of your buffer until the provider is no longer using it. The provider lets you know that it has finished using the buffer by calling your notifier function and passing T_MEMORYRELEASED event code for the code parameter, a pointer to the buffer that was sent in the cookie parameter, and the size of the buffer in the result parameter.

If you have not installed a notifier function for the provider, this function returns the kOTAccessErr result.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTAckSends (
   ProviderRef ref
){};


/*OTIoctl

Sends a module-specific command to an Open Transport protocol module. (Deprecated in Mac OS X v10.4.)

SInt32 OTIoctl (
   ProviderRef ref,
   UInt32 cmd,
   void * data
);
Parameters
ref
cmd

A routine selector for the module-specific command.
data

Data to be used by the module-specific command, or a pointer to such data. The interpretation of the data parameter is command specific.
Discussion

The OTIoctl function sends a module-specific command to an Open Transport protocol module. The OTIoctl function runs synchronously or asynchronously, matching the provider’s mode of execution.

If the OTIoctl function completes synchronously without error, it returns 0 or a positive integer. The positive integer’s meaning is command specific. If the OTIoctl function fails while executing synchronously, its return value is a negative integer corresponding to an Open Transport result code.

If the OTIoctl function runs asynchronously, it returns immediately with a return value kOTNoError or another Open Transport result code. When the function completes execution, Open Transport calls the notifier function you specify, passing the event code kStreamIoctlEvent and a result parameter indicating the result of the completed OTIoctl function. If the value of the result parameter is greater than 0, the corresponding result code is defined by the command; otherwise, the value of the result parameter corresponds to an Open Transport result code.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

SInt32 OTIoctl (
   ProviderRef ref,
   UInt32 cmd,
   void * data
){};


/*OTAccept

Accepts an incoming connection request. (Deprecated in Mac OS X v10.4.)

OSStatus OTAccept (
   EndpointRef listener,
   EndpointRef worker,
   TCall * call
);
Parameters
listener
worker
call
Return Value

A result code. See “Open Transport Result Codes”.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTAccept (
   EndpointRef listener,
   EndpointRef worker,
   TCall * call
){};

/*OTOpenEndpoint
Opens an endpoint. This function is synchronous, and creates an endpoint that operates synchronously.

C INTERFACE 
EndpointRef OTOpenEndpoint ( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OSStatus* err);
C++ INTERFACE 
None. C++ applications use the C interface to this function.

PARAMETERS 
config 
A pointer to an endpoint configuration structure that specifies the endpoint's characteristics. You obtain a value for the config parameter by calling the OTCreateConfiguration function. The OTOpenEndpoint function disposes of the configuration structure before returning. 
oflag 
Reserved; must be set to 0. 
info 
A pointer to a TEndpointInfo structure to be filled in by the OTOpenEndpoint function. Specify NULL for this parameter if you do not want the OTOpenEndpoint function to provide endpoint information. 
err 
A pointer to the result code for this function. 
function result 
An endpoint reference for the endpoint that has been created or NULL if the endpoint has not been created. 
DISCUSSION
The OTOpenEndpoint function opens an endpoint having the configuration specified by the config parameter. The function returns an endpoint reference, by which you refer to the created endpoint when calling provider functions. If the OTOpenEndpoint function fails, its return value is kOTInvalidEndpointRef. 

The function creates an endpoint that is synchronous, does not block, and does not acknowledge sends. To change these settings, you can call the OTSetAsynchronous function, the OTSetBlocking function and the OTAckSends function. 

The initial state of an endpoint is T_UNBND, meaning that the endpoint is not bound to an address. Before using the endpoint to transfer data, you must bind it to an address by calling the OTBind function.

To close and delete an endpoint, call the OTCloseProvider function.

SPECIAL CONSIDERATIONS 
The OTOpenEndpoint function can only be called at system task time because it is a synchronous function. 

The OTOpenEndpoint function disposes of the configuration structure passed in as a parameter. If you want to use the same configuration to open additional endpoints, you must obtain a copy of the configuration structure before calling the OTOpenEndpoint function, by calling the OTCloneConfiguration function. 

SEE ALSO
"Creating a Configuration Structure". 

"Reusing Provider Configurations". 

The OTAsyncOpenEndpoint function.

"Endpoint States".*/
EndpointRef OTOpenEndpoint ( OTConfiguration* config, 
                     OTOpenFlags oflag, 
                     TEndpointInfo* info, 
                     OSStatus* err){};


/*OTMemcpy

Copies data from one memory location to another; the source and destination locations must not overlap. (Deprecated in Mac OS X v10.4.)

void OTMemcpy (
   void * dest,
   const void * src,
   OTByteCount nBytes
);
Parameters
dest
src
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTMemcpy (
   void * dest,
   const void * src,
   OTByteCount nBytes
){};



/*OTOpenMapperInContext

Creates a synchronous mapper provider and returns a mapper reference. (Deprecated in Mac OS X v10.4.)

MapperRef OTOpenMapperInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   OSStatus * err,
   OTClientContextPtr clientContext
);
Parameters
config
oflag
err
clientContext
Return Value

See the description of the MapperRef data type.
Discussion

Applications may pass a NULL pointer but non-applications must always pass a valid client context pointer.

You receive a client context pointer when you call the function InitOpenTransportInContext. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

MapperRef OTOpenMapperInContext (
   OTConfigurationRef config,
   OTOpenFlags oflag,
   OSStatus * err,
   OTClientContextPtr clientContext
){};



/*OTLookupName

Finds and returns all addresses that correspond to a particular name or name pattern, or confirms that a name is registered. (Deprecated in Mac OS X v10.4.)

OSStatus OTLookupName (
   MapperRef ref,
   TLookupRequest * req,
   TLookupReply * reply
);
Parameters
ref
req
reply
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

You can use the OTLookupName function to find out whether a name is registered and what address is associated with that name. You use the req parameter to supply the information needed for the search: what name should be looked up and, optionally, what node contains that information, how many matches you expect to find, and how long the search should continue before the function returns. On return, the reply parameter contains the names field that points to the buffer where the matching entries are stored and the rspcount field that specifies the number of matching entries.

For each registered name found, the OTLookupName function stores the following information in the buffer referenced by the names field of the reply parameter:unsigned short addrLen; / length of address that follows/
unsigned short nameLen; / length of name that follows /
unsigned char addr[]; / address /
unsigned char name[]; / name, padded to quad-word boundary/


If you are searching for names using a name pattern and you expect that more than one name will be returned to you, you need to parse the reply buffer to extract the matching names.

If you call the OTLookupName function asynchronously, the mapper provider calls your notifier function passing one of two completion codes for the code parameter (T_LKUPNAMERESULT or T_LKUPNAMECOMPLETE) and passing the reply parameter in the cookie parameter. The mapper provider passes the T_LKUPNAMERESULT code each time it stores a name in the reply buffer, and it passes the T_LKUPNAMECOMPLETE code when it is done. When you receive this event, examine the rspcount field to determine whether there is a last name to retrieve from the reply buffer. The use of both codes is a feature that gives you a choice about how to process multiple names when searching for names matching a pattern.
If you decide to allocate a buffer that is large enough to contain all the names returned, you can ignore the T_LKUPNAMERESULT code and call a function that parses the buffer once the OTLookupName function has completed—that is, once the provider calls your notifier function using the T_LKUPNAMECOMPLETE event.
If you want to save memory or if you don’t know how large a buffer to allocate, you can use the following method to process the names returned. Each time that the T_LKUPNAMERESULT event is passed, you must do something with the reply from the reply buffer. You can copy it somewhere, or you can delete it if it isn’t a name you’re interested in. Then, from inside your notifier you must set the reply->names.len field or the reply->rspcount field back to 0 (thus allowing the mapper provider to overwrite the original name). This tells the mapper provider that you are ready to receive another name. Accordingly, when the mapper provider has inserted another name into your reply buffer, it calls your notifier passing the T_LKUPNAMERESULT code, and you can process the new entry as you have processed the first entry. This method also saves you the trouble of having to parse through the buffer to extract name and address information.

The cookie parameter to the notifier contains the reply parameter.

The format of the names and protocol addresses are specific to the underlying protocol. Consult the documentation supplied for your protocol for more information.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/

OSStatus OTLookupName (
   MapperRef ref,
   TLookupRequest * req,
   TLookupReply * reply
){};

/*OTSndUData

Sends data using a connectionless transactionless endpoint. (Deprecated in Mac OS X v10.4.)

OSStatus OTSndUData (
   EndpointRef ref,
   TUnitData * udata
);
Parameters
ref
udata

A pointer to a TUnitData structure that specifies thedata to be sent and its destination. 
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

If the endpoint is in synchronous, blocking mode, the OTSndUData function returns immediately. If flow-control restrictions prevent its sending the data, it retries the operation until it is able to send it. If the endpoint is in nonblocking mode, the OTSndUData function returns a kOTFlowErr result if flow-control restrictions prevent the data from being sent. When the endpoint provider is able to send the data, it calls your notifier function, passing T_GODATA for the code parameter. You can then call the OTSndUData function from your notifier to send the data. You can also retrieve this event by polling the endpoint using the OTLook function.

Some endpoint providers are not able to detect immediately whether you specified incorrect address or option information. In such cases, the provider calls your notifier function when it detects the error, passing the T_UDERR for the code parameter to advise you that an error has occurred. You can determine the cause of this event by calling the OTRcvUDErr function and examining the value of the uderr->error parameter. It is important that you call the OTRcvUDErr function even if you are not interested in examining the cause of the error. Failing to do this leaves the endpoint in an invalid state for doing other sends and makes the endpoint provider unable to deallocate memory reserved for internal buffers associated with the send.

The next table shows how the endpoint’s mode of execution and blocking status affects the behavior of the OTSndUData function.
Table A-2  
	
Blocking	
Nonblocking

Synchronous	
The function returns when the provider lifts flow-control restrictions The kOTFlowErr result is never returned.	
The function returns immediately. the kOTFlowErr result might be returned

Asynchronous	
The function returns immediately. The kOTFlowErr result is never returned.	
the function returns immediately. the kOTFlowErr result might be returned.

Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSndUData (
   EndpointRef ref,
   TUnitData * udata
){};

/*OTRcvUData

Reads data sent by a client using a connectionless transactionless protocol. (Deprecated in Mac OS X v10.4.)

OSStatus OTRcvUData (
   EndpointRef ref,
   TUnitData * udata,
   OTFlags * flags
);
Parameters
ref
udata
flags
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

When the OTRcvUData function returns, it passes a pointer to a TUnitData structure containing information about the data read and a pointer to a flags variable that is set to indicate whether there is more data to be retrieved. If the buffer pointed to by the udata->udata.buf field is not large enough to hold the current data unit, the endpoint provider fills the buffer and sets the flags parameter to T_MORE to indicate that you must call the OTRcvUData function again to receive additional data. Subsequent calls to the OTRcvUData function return 0 for the length of the address and option buffers until you receive the full data unit. The last unit to be received does not have the T_MORE flag set.

If the endpoint is in asynchronous mode or is not blocking and data is not available, the OTRcvUData function fails with the kOTNoDataErr result. The endpoint provider uses the T_DATA event to notify the endpoint when data becomes available. You can use a notifier function or the OTLook function to retrieve the event. Once you get the T_DATA event, you should continue calling the OTRcvUData function until it returns the kOTNoDataErr result.

It is possible that the provider generates an erroneous T_DATA event. This is the case when the provider calls your notifier, passing T_DATA for the code parameter; but when you execute the OTRcvUData function, it returns with a kOTNoDataErr result. If this happens, you should continue normal processing and assume that the next T_DATA event is genuine.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTRcvUData (
   EndpointRef ref,
   TUnitData * udata,
   OTFlags * flags
){};


/*OTOpenInternetServices
Opens the TCP/IP service provider and returns an internet services reference. 

C INTERFACE
InetSvcRef OTOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OSStatus *
C++ INTERFACE
None. C++ clients use the C interface to this function.

PARAMETERS
cfig 
A pointer to a network configuration structure. You can obtain the default configuration by using the constant kDefaultInternetServicesPath for this parameter. 
oflag 
Reserved. Must be set to 0. 
err 
A pointer to the function result. 
function result 
An internet services reference. 
DISCUSSION
You must open a TCP/IP service provider before calling any TCP/IP service functions other than the address utility functions. The return value of this function is the internet services reference. You must provide the internet services reference when calling any of these non-utility functions. The OTOpenInternetServices function runs synchronously and also sets the mode of the TCP/IP service provider as synchronous.

If you want to set an option as part of the configuration string, you should translate the option's constant name, given in the header files, into a string that the configuration functions can parse. For the TCP/IP options, Table 11-2 provides the constant name used in "Options" and the value to used in the configuration string

SEE ALSO
The OTAsyncOpenInternetServices function.*/

InetSvcRef OTOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OSStatus *err){};

/*OTElapsedMicroseconds

Calculates the time elapsed in microseconds since a specified time. (Deprecated in Mac OS X v10.4.)

UInt32 OTElapsedMicroseconds (
   OTTimeStamp * startTime
);
Parameters
startTime
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
UInt32 OTElapsedMicroseconds (
   OTTimeStamp * startTime
){};


/*DisposeOTNotifyUPP

Disposes of a universal procedure pointer (UPP) to a notification callback. (Deprecated in Mac OS X v10.4.)

void DisposeOTNotifyUPP (
   OTNotifyUPP userUPP
);
Parameters
userUPP
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void DisposeOTNotifyUPP (
   OTNotifyUPP userUPP
){};


/*OTSetAsynchronous

Sets a provider’s mode of execution to asynchronous. (Deprecated in Mac OS X v10.4.)

OSStatus OTSetAsynchronous (
   ProviderRef ref
);
Parameters
ref
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

The OTSetAsynchronous function causes all functions for the provider specified in the ref parameter to run asynchronously. You must install a notifier function for the provider if it needs to receive completion events. You can install a notifier function either before or after calling the OTSetAsynchronous function.

Changing a provider’s mode of execution does not affect its notifier function, if any; the notifier function remains installed.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OSStatus OTSetAsynchronous (
   ProviderRef ref
){};


/*OTTimeStampInMilliseconds

Calculates the time elapsed in milliseconds since since a specified time. (Deprecated in Mac OS X v10.4.)

UInt32 OTTimeStampInMilliseconds (
   OTTimeStamp * delta
);
Parameters
delta
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
UInt32 OTTimeStampInMilliseconds (
   OTTimeStamp * delta
){};




/*OTSubtractTimeStamps

Subtracts one timestamp value from another. (Deprecated in Mac OS X v10.4.)

OTTimeStamp * OTSubtractTimeStamps (
   OTTimeStamp * result,
   OTTimeStamp * startTime,
   OTTimeStamp * endEnd
);
Parameters
result
startTime
endEnd
Return Value

See the description of the OTTimeStamp data type.
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
OTTimeStamp * OTSubtractTimeStamps (
   OTTimeStamp * result,
   OTTimeStamp * startTime,
   OTTimeStamp * endEnd
){};


/*OTMemset

Sets the specified memory range to a specific value. (Deprecated in Mac OS X v10.4.)

void OTMemset (
   void * dest,
   OTUInt8Param toSet,
   OTByteCount nBytes
);
Parameters
dest
toSet
nBytes
Availability
Available in CarbonLib 1.0 and later when OpenTransport 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransport.h*/
void OTMemset (
   void * dest,
   OTUInt8Param toSet,
   OTByteCount nBytes
){};






































