#define C_LANG

#ifndef QUARTZCORE_H
#include <QuartzCore/QuartzCore.h>
#endif



/*CVDisplayLinkRelease

Releases a display link.

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to release. This function is NULL-safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

void CVDisplayLinkRelease (
   CVDisplayLinkRef displayLink
){
//TODO
};


/*CVDisplayLinkCreateWithActiveCGDisplays

Creates a display link capable of being used with all active displays.

CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

CVDisplayLinkCreateWithActiveCGDisplays determines the displays actively used by the host computer and creates a display link compatible with all of them. For most applications, calling this function is the most convenient way to create a display link. After creation, you can assign the display link to any active display by calling CVDisplayLinkSetCurrentCGDisplay.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkCreateWithActiveCGDisplays (
   CVDisplayLinkRef *displayLinkOut){
//TODO
};

/*CVBufferRelease

Releases a Core Video buffer. 

void CVBufferRelease (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to release.
Discussion

Like CFRelease CVBufferRelease decrements the retain count of a Core Video buffer. If that count consequently becomes zero the memory allocated to the object is deallocated and the object is destroyed. Unlike CFRelease, you can pass NULL to CVBufferRelease without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
void CVBufferRelease (CVBufferRef buffer){
//TODO
};


/*CVDisplayLinkSetOutputCallback

Set the renderer output callback function.

CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo
);
Parameters
displayLink

The display link whose output callback you want to set. 
callback

The callback function to set for this display link. See CVDisplayLinkOutputCallback for more information about implementing this function. 
userInfo

A pointer to user data.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

The display link invokes this callback whenever it wants you to output a frame. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetOutputCallback (
   CVDisplayLinkRef displayLink,
   CVDisplayLinkOutputCallback callback,
   void *userInfo){
//TODO
};


/*CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext

Selects the display link most optimal for the current renderer of an OpenGL context.

CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat
);
Parameters
displayLink

The display link for which you want to set the current display.
cglContext

The OpenGL context to retrieve the current renderer from.
cglPixelFormat

The OpenGL pixel format used to create the passed-in OpenGL context.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

This function chooses the display with the lowest refresh rate. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplayFromOpenGLContext (
   CVDisplayLinkRef displayLink,
   CGLContextObj cglContext,
   CGLPixelFormatObj cglPixelFormat){
//TODO
};



/*CVDisplayLinkStart

Activates a display link.

CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to activate. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Calling this function starts the display link thread, which then periodically calls back to your application to request that you display frames. If the specified display link is already running, CVDisplayLinkStart returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStart (
   CVDisplayLinkRef displayLink){
//TODO
};


/*CVOpenGLTextureGetTarget

Returns the texture target (for example, GL_TEXTURE_2D) of an OpenGL texture.

GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose target you want to obtain. 
Return Value

The OpenGL texture target.
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
GLenum CVOpenGLTextureGetTarget (
   CVOpenGLTextureRef image){
//TODO
};


/*CVOpenGLTextureGetCleanTexCoords

Returns the texture coordinates for the part of the image that should be displayed.

void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]
);
Parameters
image

The Core Video OpenGL texture whose clean tex coordinates you want to obtain.
lowerLeft

On return, the GLFloat array hold the s and t texture coordinates of the lower-left corner of the image.
lowerRight

On return, the GLFloat array hold the s and t texture coordinates of the lower-right corner of the image.
upperRight

On return, the GLFloat array hold the s and t texture coordinates of the upper-right corner of the image.
upperLeft

On return, the GLFloat array hold the s and t texture coordinates of the upper-left corner of the image.
Discussion

This function automatically takes into account whether or not the texture is flipped. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/
void CVOpenGLTextureGetCleanTexCoords (
   CVOpenGLTextureRef image,
   GLfloat lowerLeft[2],
   GLfloat lowerRight[2],
   GLfloat upperRight[2],
   GLfloat upperLeft[2]){
//TODO
};


/*CVOpenGLTextureGetName

Returns the texture target name of a CoreVideo OpenGL texture. 

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image
);
Parameters
image

The Core Video OpenGL texture whose texture target name you want to obtain.
Return Value

The target name of the texture. 
Discussion

See the OpenGL specification for more information about texture targets.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

GLuint CVOpenGLTextureGetName (
   CVOpenGLTextureRef image){
//TODO
};


/*CVImageBufferGetCleanRect

Returns the source rectangle of a Core Video image buffer that represents the clean aperture of the buffer in encoded pixels. 

CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer
);
Parameters
imageBuffer

The image buffer that you want to retrieve the display size from.
Return Value

A CGRect structure returning the nominal display size of the buffer. Returns a rectangle of zero size if called with either a non-CVImageBufferRef type or NULL.
Discussion

The clean aperture size is smaller than the full size of the image. For example, an NTSC DV frame would return a CGRect structure with an origin of (8,0) and a size of (704,480). Note that the origin of this rectangle is always in the lower-left corner. This is the same coordinate system as that used by Quartz and Core Image.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVImageBuffer.h*/
CGRect CVImageBufferGetCleanRect (
   CVImageBufferRef imageBuffer){
//TODO
};


/*CVDisplayLinkCreateWithOpenGLDisplayMask

Creates a display link from an OpenGL display mask.

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
mask

The OpenGL display mask describing the available displays.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Using this function avoids having to call the Core Graphics function CGOpenGLDisplayMaskToDisplayID.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithOpenGLDisplayMask (
   CGOpenGLDisplayMask mask,
   CVDisplayLinkRef *displayLinkOut){
//TODO
};

/*CVDisplayLinkStop

Stops a display link.

CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink
);
Parameters
displayLink

The display link to stop.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

If the specified display link is already stopped, CVDisplayLinkStop returns an error.

In Mac OS X v.10.4 and later, the display link thread is automatically stopped if the user employs Fast User Switching. The display link is restarted when switching back to the original user. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkStop (
   CVDisplayLinkRef displayLink){
//TODO
};

/*CVDisplayLinkSetCurrentCGDisplay

Sets the current display of a display link. 

CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID
);
Parameters
displayLink

The display link whose display you want to set. 
displayID

The ID of the display to be set. 
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Although it is safe to call this function on a running display link, a discontinuity may appear in the video timestamp. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
CVReturn CVDisplayLinkSetCurrentCGDisplay (
   CVDisplayLinkRef displayLink,
   CGDirectDisplayID displayID){
//TODO
}

;/*CVOpenGLTextureRelease

Releases a Core Video OpenGL texture.

void CVOpenGLTextureRelease (
   CVOpenGLTextureRef texture
);
Parameters
texture

The Core Video OpenGL texture that you want to release.
Discussion

This function is equivalent to CFRelease, but NULL safe.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVOpenGLTexture.h*/

void CVOpenGLTextureRelease (
   CVOpenGLTextureRef texture){
//TODO
};


/*CVPixelBufferUnlockBaseAddress

Unlocks the base address of the pixel buffer. 

CVReturn CVPixelBufferUnlockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags unlockFlags
   );
Parameters
pixelBuffer

The pixel buffer whose base address you want to unlock.
unlockFlags

No options currently defined; pass 0.
Return Value

A Core Video result code. See “Result Codes” for possible values.
Discussion

Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

CVReturn CVPixelBufferUnlockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags unlockFlags
   ){};


/*CVPixelBufferLockBaseAddress

Locks the base address of the pixel buffer. 

CVReturn CVPixelBufferLockBaseAddress (
   CVPixelBufferRef pixelBuffer,
   CVOptionFlags lockFlags
   );
Parameters
pixelBuffer

The pixel buffer whose base address you want to lock.
lockFlags

No options currently defined; pass 0.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

CVReturn CVPixelBufferLockBaseAddress (CVPixelBufferRef pixelBuffer,CVOptionFlags lockFlags){
//TODO
};


;/*CVPixelBufferGetBytesPerRow

Returns the number of bytes per row of the pixel buffer.

size_t CVPixelBufferGetBytesPerRow (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose bytes-per-row value you want to obtain.
Return Value

The number of bytes per row of the image data. For planar buffers this function returns a rowBytes value such that bytesPerRow * height covers the entire image including all planes.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
size_t CVPixelBufferGetBytesPerRow (
   CVPixelBufferRef pixelBuffer
){};

/*CVPixelBufferGetBaseAddress

Returns the base address of the pixel buffer.

void * CVPixelBufferGetBaseAddress (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose base address you want to obtain.
Return Value

The base address of the pixels. For chunky buffers, this returns a pointer to the pixel at (0,0) in the buffer For planar buffers this returns a pointer to a PlanarComponentInfo structure (as defined by QuickTime in ImageCodec.h).
Discussion

Retrieving the base address for a pixel buffer requires that the buffer base address be locked via a successful call to CVPixelBufferLockBaseAddress. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
void * CVPixelBufferGetBaseAddress (
   CVPixelBufferRef pixelBuffer
){}

;
/*CVPixelBufferGetWidth

Returns the width of the pixel buffer.

size_t CVPixelBufferGetWidth (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose width you want to obtain.
Return Value

The width of the buffer, in pixels.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/
size_t CVPixelBufferGetWidth (
   CVPixelBufferRef pixelBuffer
){}

;/*CVPixelBufferGetHeight

Returns the height of the pixel buffer.

size_t CVPixelBufferGetHeight (
   CVPixelBufferRef pixelBuffer
);
Parameters
pixelBuffer

The pixel buffer whose height you want to obtain.
Return Value

The buffer height, in pixels.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVPixelBuffer.h*/

size_t CVPixelBufferGetHeight (
   CVPixelBufferRef pixelBuffer
){}

;
/*CVBufferRetain

Retains a Core Video buffer.

CVBufferRef CVBufferRetain (CVBufferRef buffer);
Parameters
buffer

The Core Video buffer that you want to retain.
Return Value

For convenience, the same Core Video buffer you wanted to retain.
Discussion

Like CFRetain, CVBufferRetain increments the retain count of a Core Video buffer. Unlike CFRetain, you can pass NULL to CVBufferRetain without causing a crash. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVBuffer.h*/
CVBufferRef CVBufferRetain (CVBufferRef buffer){};


/*CVDisplayLinkIsRunning

Indicates whether a given display link is running. 

Boolean CVDisplayLinkIsRunning (
   CVDisplayLink displayLink
);
Parameters
displayLink

The display link whose run state you want to determine. 
Return Value

Returns true if the display link is running, false otherwise. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/
Boolean CVDisplayLinkIsRunning (
   CVDisplayLinkRef  displayLink
){};



/*CVDisplayLinkCreateWithCGDisplay

Creates a display link for a single display.

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
);
Parameters
displayID

The Core Graphics ID of the target display.
displayLinkOut

On return, displayLinkOut points to the newly created display link.
Return Value

A Core Video result code. See “Result Codes” for possible values. 
Discussion

Use this call to create a display link for a single display. 
Availability
Available in Mac OS X v10.4 and later. 
Declared In
CVDisplayLink.h*/

CVReturn CVDisplayLinkCreateWithCGDisplay (
   CGDirectDisplayID displayID,
   CVDisplayLinkRef *displayLinkOut
){};

/*Image Buffer Attachment Keys

Specify attachment types associated with image buffers.

const CFStringRef   kCVImageBufferCGColorSpaceKey;
const CFStringRef   kCVImageBufferGammaLevelKey;
const CFStringRef   kCVImageBufferCleanApertureKey;
const CFStringRef   kCVImageBufferPreferredCleanApertureKey;
const CFStringRef   kCVImageBufferCleanApertureWidthKey;
const CFStringRef   kCVImageBufferCleanApertureHeightKey;
const CFStringRef   kCVImageBufferCleanApertureHorizontalOffsetKey;
const CFStringRef   kCVImageBufferCleanApertureVerticalOffsetKey;
const CFStringRef   kCVImageBufferFieldCountKey;
const CFStringRef   kCVImageBufferFieldDetailKey;
const CFStringRef   kCVImageBufferFieldDetailTemporalTopFirst;
const CFStringRef   kCVImageBufferFieldDetailTemporalBottomFirst;
const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineEarly;
const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineLate;
const CFStringRef   kCVImageBufferPixelAspectRatioKey;
const CFStringRef   kCVImageBufferPixelAspectRatioHorizontalSpacingKey;
const CFStringRef   kCVImageBufferPixelAspectRatioVerticalSpacingKey;
const CFStringRef   kCVImageBufferDisplayDimensionsKey;
const CFStringRef   kCVImageBufferDisplayWidthKey;
const CFStringRef   kCVImageBufferDisplayHeightKey;
const CFStringRef   kCVImageBufferYCbCrMatrixKey;
const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_709_2;
const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_601_4;
const CFStringRef   kCVImageBufferYCbCrMatrix_SMPTE_240M_1995;
Constants
kCVImageBufferCGColorSpaceKey

The color space for the buffer (type CGColorSpaceRef).

Available in Mac OS X v10.3 and later.
kCVImageBufferGammaLevelKey

The gamma level for this buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureKey

The clean aperture for the buffer (type CFDictionary , containing the clean aperture width, height, and horizontal and vertical offset key-value pairs).

Available in Mac OS X v10.3 and later.
kCVImageBufferPreferredCleanApertureKey

The preferred clean aperture for the buffer (type CFDictionary , containing the clean aperture width, height, and horizontal and vertical offset key-value pairs).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureWidthKey

The clean aperture width (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureHeightKey

The clean aperture height (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureHorizontalOffsetKey

The clean aperture horizontal offset (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferCleanApertureVerticalOffsetKey

The clean aperture vertical offset (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldCountKey

The field count for the buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailKey

Specific information about the field of a video frame in the buffer (type CFDictionary, containing the temporal bottom first and top first and spacial first-line-early and first-line-late keys). 

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailTemporalTopFirst

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailTemporalBottomFirst

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailSpatialFirstLineEarly

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferFieldDetailSpatialFirstLineLate

(type CFString).

Available in Mac OS X v10.3 and later.
kCVImageBufferPixelAspectRatioKey

The pixel aspect ratio of the buffer (type CFDictionary, containing the horizontal and vertical spacing keys).

Available in Mac OS X v10.3 and later.
kCVImageBufferPixelAspectRatioHorizontalSpacingKey

The horizontal component of the buffer aspect ratio (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferPixelAspectRatioVerticalSpacingKey

The vertical component of the buffer aspect ratio (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferDisplayDimensionsKey

The buffer display dimensions (type CFDictionary containing the buffer display width and height keys).

Available in Mac OS X v10.3 and later.
kCVImageBufferDisplayWidthKey

The buffer display width (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferDisplayHeightKey

The buffer display height (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrixKey

The type of conversion matrix used for this buffer when converting from YCbCr to RGB images (type CFString). The value for this key should be one of the following constants: kCVImageBufferYCbCrMatrix_ITU_R_709_2, kCVImageBufferYCbCrMatrix_ITU_R_601_4, or kCVImageBufferYCbCrMatrix_SMPTE_240M_1995.

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrix_ITU_R_709_2

Specifies the YCbCr to RGB conversion matrix for HDTV digital television (ITU R 709) images. 

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrix_ITU_R_601_4

Specifies the YCbCr to RGB conversion matrix for standard digital television ( ITU R 601) images. 

Available in Mac OS X v10.3 and later.
kCVImageBufferYCbCrMatrix_SMPTE_240M_1995

Specifies the YCbCR to RGB conversion matrix for 1920 x 1135 HDTV (SMPTE 240M 1995). 

Available in Mac OS X v10.3 and later.
Discussion

Image buffer attachment keys are stored in a Core Foundation dictionary associated with an image buffer. Note that some of these keys are stored in subdictionaries keyed by a higher-level attribute. For example, the kCVImageBufferDisplayWidthKey and kCVImageBufferDisplayHeightKey attributes are stored in a Core Foundation dictionary keyed to the kCVImageBufferDisplayDimensionsKey attribute.*/
 const CFStringRef   kCVImageBufferCGColorSpaceKey;
 const CFStringRef   kCVImageBufferGammaLevelKey;
 const CFStringRef   kCVImageBufferCleanApertureKey;
 const CFStringRef   kCVImageBufferPreferredCleanApertureKey;
 const CFStringRef   kCVImageBufferCleanApertureWidthKey;
 const CFStringRef   kCVImageBufferCleanApertureHeightKey;
 const CFStringRef   kCVImageBufferCleanApertureHorizontalOffsetKey;
 const CFStringRef   kCVImageBufferCleanApertureVerticalOffsetKey;
 const CFStringRef   kCVImageBufferFieldCountKey;
 const CFStringRef   kCVImageBufferFieldDetailKey;
 const CFStringRef   kCVImageBufferFieldDetailTemporalTopFirst;
 const CFStringRef   kCVImageBufferFieldDetailTemporalBottomFirst;
 const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineEarly;
 const CFStringRef   kCVImageBufferFieldDetailSpatialFirstLineLate;
 const CFStringRef   kCVImageBufferPixelAspectRatioKey;
 const CFStringRef   kCVImageBufferPixelAspectRatioHorizontalSpacingKey;
 const CFStringRef   kCVImageBufferPixelAspectRatioVerticalSpacingKey;
 const CFStringRef   kCVImageBufferDisplayDimensionsKey;
 const CFStringRef   kCVImageBufferDisplayWidthKey;
 const CFStringRef   kCVImageBufferDisplayHeightKey;
 const CFStringRef   kCVImageBufferYCbCrMatrixKey;
 const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_709_2;
 const CFStringRef   kCVImageBufferYCbCrMatrix_ITU_R_601_4;
 const CFStringRef   kCVImageBufferYCbCrMatrix_SMPTE_240M_1995;

/*Pixel Buffer Attribute Keys

Specify attributes associated with a pixel buffer. 

const CFStringRef kCVPixelBufferPixelFormatTypeKey;
   const CFStringRef kCVPixelBufferMemoryAllocatorKey;
   const CFStringRef kCVPixelBufferWidthKey;
   const CFStringRef kCVPixelBufferHeightKey;
   const CFStringRef kCVPixelBufferExtendedPixelsLeftKey;
   const CFStringRef kCVPixelBufferExtendedPixelsTopKey;
   const CFStringRef kCVPixelBufferExtendedPixelsRightKey;
   const CFStringRef kCVPixelBufferExtendedPixelsBottomKey;
   const CFStringRef kCVPixelBufferBytesPerRowAlignmentKey;
   const CFStringRef kCVPixelBufferCGBitmapContextCompatibilityKey;
   const CFStringRef kCVPixelBufferCGImageCompatibilityKey;
   const CFStringRef kCVPixelBufferOpenGLCompatibilityKey;
Constants
kCVPixelBufferPixelFormatTypeKey

The pixel format for this buffer (type CFNumber, or type CFArray containing an array of CFNumber types (actually type OSType)). For a listing of common pixel formats, see the QuickTime Ice Floe Dispatch 20.

Available in Mac OS X v10.3 and later.
kCVPixelBufferMemoryAllocatorKey

The allocator used with this buffer (type CFAllocatorRef). 

Available in Mac OS X v10.3 and later.
kCVPixelBufferWidthKey

The width of the pixel buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferHeightKey

The height of the pixel buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsLeftKey

The number of pixels padding the left of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsTopKey

The number of pixels padding the top of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsRightKey

The number of pixels padding the right of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferExtendedPixelsBottomKey

The number of pixels padding the bottom of the image (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferBytesPerRowAlignmentKey

Indicates the number of bytes per row in the pixel buffer (type CFNumber).

Available in Mac OS X v10.3 and later.
kCVPixelBufferCGBitmapContextCompatibilityKey

Indicates whether the pixel buffer is compatible with Core Graphics bitmap contexts (type CFBoolean).

Available in Mac OS X v10.3 and later.
kCVPixelBufferCGImageCompatibilityKey

Indicates whether the pixel buffer is compatible with CGImage types (type CFBoolean).

Available in Mac OS X v10.3 and later.
kCVPixelBufferOpenGLCompatibilityKey

Indicates whether the pixel buffer is compatible with OpenGL contexts (type CFBoolean).

Available in Mac OS X v10.3 and later.
Discussion

You specify these keys in a Core Foundation dictionary when calling functions such as CVPixelBufferCreate*/
 const CFStringRef kCVPixelBufferPixelFormatTypeKey;
const CFStringRef kCVPixelBufferMemoryAllocatorKey;
const CFStringRef kCVPixelBufferWidthKey;
 const CFStringRef kCVPixelBufferHeightKey;
const CFStringRef kCVPixelBufferExtendedPixelsLeftKey;
 const CFStringRef kCVPixelBufferExtendedPixelsTopKey;
 const CFStringRef kCVPixelBufferExtendedPixelsRightKey;
 const CFStringRef kCVPixelBufferExtendedPixelsBottomKey;
 const CFStringRef kCVPixelBufferBytesPerRowAlignmentKey;
 const CFStringRef kCVPixelBufferCGBitmapContextCompatibilityKey;
 const CFStringRef kCVPixelBufferCGImageCompatibilityKey;
 const CFStringRef kCVPixelBufferOpenGLCompatibilityKey;

