#include <QuickTime/QuickTime.h>

/*Data Types and Constants

All of the new data types and constants in this header file are listed alphabetically, with links to documentation and abstracts, if available.ICMCompressionFrameOptionsRef	
ICMCompressionPassModeFlags	
ICMCompressionSessionOptionsRef	
ICMCompressionSessionRef	
ICMCompressorSessionRef	
ICMCompressorSourceFrameRef	
ICMDataRateLimit	
ICMDecompressionFrameOptionsRef	
ICMDecompressionSessionOptionsRef	
ICMDecompressionSessionRef	
ICMDecompressionTrackingCallback	
ICMDecompressionTrackingCallbackRecord	
ICMDecompressionTrackingFlags	
ICMEncodedFrameOutputCallback	
ICMEncodedFrameOutputRecord	
ICMEncodedFrameRef	
ICMFieldMode	
ICMFrameType	
ICMMultiPassCopyDataAtTimeStampCallback	
ICMMultiPassGetTimeStampCallback	
ICMMultiPassReleaseCallback	
ICMMultiPassSetDataAtTimeStampCallback	
ICMMultiPassStorageCallbacks	
ICMMultiPassStorageCreationFlags	
ICMMultiPassStorageRef	
ICMMultiPassStorageStep	
ICMMutableEncodedFrameRef	
ICMNonScheduledDisplayTime	
ICMSourceTrackingCallback	
ICMSourceTrackingCallbackRecord	
ICMSourceTrackingFlags	
ICMValidTimeFlags	
MediaSampleFlags	
QTVisualContextImageAvailableCallback	
QTVisualContextRef	
codecCompletionDecoded	Codec has decoded this frame; if it is cancelled and rescheduled, set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags.
codecCompletionNotDisplayable	The frame may still be scheduled for decode, but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames..
codecCompletionNotDrawn	Set in conjunction with codecCompletionDest to indicate that the frame was not drawn.
codecInfoDoesMultiPass	Codec can perform multi-pass compression.
codecInfoDoesReorder	Codec can rearrange frames during compression.
icmFrameAlreadyDecoded	
icmFrameTimeDecodeImmediately	
icmFrameTimeDoNotDisplay	
icmFrameTimeHasDecodeTime	Indicates that decodeTime is valid.
icmFrameTimeIsNonScheduledDisplayTime	
kDVCPROHD1080i50CodecType	
kDVCPROHD1080i60CodecType	
kDVCPROHD720pCodecType	
kH264CodecType	
kICMCompressionFrameOptionsPropertyID_-
ForceKeyFrame	Boolean, ReadWrite.
kICMCompressionFrameOptionsPropertyID_FrameType	ICMFrameType, ReadWrite.
kICMCompressionPassMode_NoSourceFrames	
kICMCompressionPassMode_-
NotReadyToOutputEncodedFrames	
kICMCompressionPassMode_OutputEncodedFrames	
kICMCompressionPassMode_ReadFromMultiPassStorage	
kICMCompressionPassMode_WriteToMultiPassStorage	
kICMCompressionSessionOptionsPropertyID_-
AllowAsyncCompletion	Enables the compressor to call the encoded-frame callback from a different thread. By default this option is FALSE, which means that the compressor must call the encoded-frame callback from the same thread as ICMCompressionSessionEncodeFrame and ICMCompressionSession-
CompleteFrames. Also 'asok'.
kICMCompressionSessionOptionsPropertyID_-
AllowFrameReordering	Enables frame reordering. To encode B-frames a compressor must reorder frames, which may mean that the order in which they are emitted and stored (the decode order) may be different from the order in which they are presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must enable frame reordering by passing TRUE in this property. Also 'b ok'.
kICMCompressionSessionOptionsPropertyID_-
AllowFrameTimeChanges	Enables the compressor to modify frame times, improving its performance. Some compressors are able to identify and coalesce runs of identical frames and emit single frames with longer duration, or emit frames at a different frame rate from the original. By default, this flag is set to FALSE, which forces the compressor to emit one encoded frame for every source frame and to preserve frame display times. This option replaces the practice of having compressors return special high similarity values to indicate that frames can be dropped. Also '+ ok'.
kICMCompressionSessionOptionsPropertyID_-
AllowTemporalCompression	Enables temporal compression of P-frames and B-frames. By default, temporal compression is disabled. Also 'p ok'.
kICMCompressionSessionOptionsPropertyID_-
AverageDataRate	The long-term desired average data rate in bytes per second. This is not an absolute limit. The default data rate is zero, indicating that the setting of kICMCompressionSessionOptionsPropertyID_-
Quality should determine the size of compressed data. Data rate settings have effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'aver'.
kICMCompressionSessionOptionsPropertyID_-
CPUTimeBudget	UInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
CleanAperture	Native-endian CleanApertureImageDescription-
Extension, ReadWrite.
kICMCompressionSessionOptionsPropertyID_ColorTable	The color table for compression, used with indexed-color depths. Clients who are passed this property are responsible for disposing the returned CTabHandle. Also 'clut'.
kICMCompressionSessionOptionsPropertyID_-
CompressorComponent	Sets a specific compressor component or component instance to be used, or passes one of the wildcards anyCodec, bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. Pass this option to force the Image Compression Manager to use a specific compressor component or compressor component instance. To allow the Image Compression Manager to choose the compressor component, set the compressorComponent to anyCodec (the default), bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. If you pass in a component instance that you opened, the ICM will not close that instance; you must do so after the compression session is released. Also 'imco'.
kICMCompressionSessionOptionsPropertyID_-
CompressorSettings	A handle containing compressor settings. The compressor will be configured with these settings (by a call to ImageCodecSetSettings) during the ICMCompressionSessionCreate process. Also 'cost'.
kICMCompressionSessionOptionsPropertyID_-
DataRateLimitCount	UInt32, Read.
kICMCompressionSessionOptionsPropertyID_-
DataRateLimits	Zero, one, or two hard limits on data rate. Each hard limit is described by a data size in bytes and a duration in seconds. It requires that the total size of compressed data for any contiguous segment of that duration (in decode time) must not exceed the data size. By default, no data rate limits are set. When setting this property, the inPropValueSize parameter should be the number of data rate limits multiplied by sizeof(ICMDataRateLimit). Data rate settings have an effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'hard'.
kICMCompressionSessionOptionsPropertyID_Depth	UInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
DurationsNeeded	Indicates that durations of emitted frames are needed. If this option is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default, this flag is FALSE, so frames will not be delayed in order to calculate durations. If you pass encoded frames to AddMediaSampleFromEncodedFrame, you must set this flag to TRUE. Also 'need'.
kICMCompressionSessionOptionsPropertyID_-
ExpectedFrameRate	Fixed, ReadWrite.
kICMCompressionSessionOptionsPropertyID_FieldInfo	FieldInfoImageDescription-
Extension2, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MaxDataRateLimits	UInt32, Read.
kICMCompressionSessionOptionsPropertyID_-
MaxFrameDelayCount	The maximum frame delay count is the maximum number of frames that a compressor is allowed to hold before it must output a compressed frame. This value limits the number of frames that may be held in the compression window. If the maximum frame delay count is M, then before the call to encode frame N returns, frame N-M must have been emitted. The default value is kICMUnlimitedFrameDelayCount, which sets no limit on the compression window. Also 'cwin'.
kICMCompressionSessionOptionsPropertyID_-
MaxFrameDelayTime	TimeValue64, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MaxKeyFrameInterval	The maximum interval between key frames, also known as the key frame rate. Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames. This differs from previous practice, in which a key frame rate of zero disabled temporal compression. Also 'kyfr'.
kICMCompressionSessionOptionsPropertyID_-
MaxPartialSyncFrameInterval	SInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MultiPassStorage	A multipass compression client must provide a storage location for multipass data. Pass ICMMultiPassStorageCreate-
WithTemporaryFile to make the ICM store multipass data in a temporary file. Pass ICMMultiPassStorageCreate-
WithCallbacks to manage the storage yourself. Note that the amount of multipass data to be stored can be substantial; it could be greater than the size of the output movie file. If this property is not NULL, the client must call ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass around groups of calls to ICMCompressionSessionEncodeFrame. By default, this property is NULL and multipass compression is not enabled. The compression session options object retains the multipass storage object when one is set. Also 'imps'.
kICMCompressionSessionOptionsPropertyID_-
PixelAspectRatio	Native-endian PixelAspectRatioImageDescription-
Extension, ReadWrite.
kICMCompressionSessionOptionsPropertyID_Quality	The compression quality. This value is always used to set the spatial quality; if temporal compression is enabled, it is also used to set temporal quality. The default quality is codecNormalQuality. Also 'qual'.
kICMCompressionSessionOptionsPropertyID_-
ScalingMode	OSType, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
SourceFrameCount	UInt64, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
WasCompressed	Indicates that the source was previously compressed. This property is an optional information hint to the compressor; by default it is FALSE. Also 'wasc'.
kICMCompressionSessionPropertyID_-
CompressorPixelBufferAttributes	The compressor's pixel buffer attributes for the compression session. You can use these to create a pixel buffer pool for source pixel buffers. This is not the same as the sourcePixelBufferAttributes property passed to ICMCompressionSessionCreate. Getting this property does not change its retain count. Also 'batt'.
kICMCompressionSessionPropertyID_ImageDescription	The image description for a compression session. For some codecs, the image description may not be available before the first frame is compressed. Multiple calls to retrieve this property will return the same handle. The ICM will dispose of this handle when the compression session is disposed; the caller must not dispose of it. Also 'idsc'.
kICMCompressionSessionPropertyID_PixelBufferPool	A pool that can provide ideal source pixel buffers for a compression session. The compression session creates this pixel buffer pool based on the compressor's pixel buffer attributes and any pixel buffer attributes passed in to ICMCompressionSessionCreate. If the source pixel buffer attributes and the compressor pixel buffer attributes can not be reconciled, the pool is based on the source pixel buffer attributes and the ICM converts each CVPixelBuffer internally. Also 'pool'.
kICMCompressionSessionPropertyID_TimeScale	The time scale for the compression session. Also 'tscl'.
kICMDecompressionFrameOptionsPropertyID_-
DestinationPixelBuffer	CVPixelBufferRef, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_Accuracy	CodecQ, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
DecompressorComponent	DecompressorComponent, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
DisplayOrderRequired	Boolean, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
FieldMode	ICMFieldMode, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
MaxBufferCount	UInt32, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
OutputAheadTime	TimeRecord, ReadWrite.
kICMDecompressionSessionPropertyID_-
NonScheduledDisplayDirection	Fixed, ReadWrite.
kICMDecompressionSessionPropertyID_-
NonScheduledDisplayTime	ICMNonScheduledDisplayTime, ReadWrite.
kICMDecompressionSessionPropertyID_PixelBufferPool	CVPixelBufferPoolRef, Read.
kICMDecompressionSessionPropertyID_-
PixelBufferPoolIsShared	Boolean, Read.
kICMDecompressionTracking_EmittingFrame	
kICMDecompressionTracking_FrameDecoded	
kICMDecompressionTracking_FrameDropped	
kICMDecompressionTracking_FrameNeedsRequeueing	
kICMDecompressionTracking_LastCall	
kICMDecompressionTracking_ReleaseSourceData	
kICMFieldMode_BothFields	
kICMFieldMode_BottomFieldOnly	
kICMFieldMode_DeinterlaceFields	
kICMFieldMode_TopFieldOnly	
kICMFrameType_B	
kICMFrameType_I	
kICMFrameType_P	
kICMFrameType_Unknown	
kICMImageDescriptionPropertyID_ClassicTrackHeight	Fixed, Read.
kICMImageDescriptionPropertyID_ClassicTrackWidth	Fixed, Read.
kICMImageDescriptionPropertyID_CleanAperture	Native-endian CleanApertureImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_DisplayHeight	SInt32, Read.
kICMImageDescriptionPropertyID_DisplayWidth	SInt32, Read.
kICMImageDescriptionPropertyID_EncodedHeight	SInt32, ReadWrite.
kICMImageDescriptionPropertyID_EncodedWidth	SInt32, ReadWrite.
kICMImageDescriptionPropertyID_FieldInfo	FieldInfoImageDescription-
Extension2, ReadWrite.
kICMImageDescriptionPropertyID_GammaLevel	Fixed, ReadWrite.
kICMImageDescriptionPropertyID_NCLCColorInfo	Native-endian NCLCColorInfoImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_PixelAspectRatio	Native-endian PixelAspectRatioImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_-
ProductionDisplayHeight	SInt32, Read.
kICMImageDescriptionPropertyID_-
ProductionDisplayWidth	SInt32, Read.
kICMImageDescriptionPropertyID_RowBytes	SInt32, ReadWrite.
kICMMultiPassStorageCallbacksVersionOne	
kICMMultiPassStorage_DoNotDeleteWhenDone	
kICMMultiPassStorage_GetFirstTimeStamp	
kICMMultiPassStorage_GetLastTimeStamp	
kICMMultiPassStorage_GetNextTimeStamp	
kICMMultiPassStorage_GetPreviousTimeStamp	
kICMScalingMode_Letterbox	The clean aperture of the source frames is scaled to fit inside the clean aperture of the destination, preserving the original display aspect ratio. If the display aspect ratios are different, the source frames are centered with black bars above and below, or to the left and right.
kICMScalingMode_StretchCleanAperture	The clean aperture of the source frames is scaled to the clean aperture of the destination.
kICMScalingMode_StretchProductionAperture	The full width and height of source frames is scaled to the full width and height of the destination. This is the default if no other scaling mode is specified.
kICMScalingMode_Trim	The clean aperture of the source frames is scaled to cover the clean aperture of the destination, preserving the original display aspect ratio. If the display aspect ratios are different, the source frames are centered and cropped.
kICMSourceTracking_CopiedPixelBuffer	
kICMSourceTracking_FrameTimeWasChanged	
kICMSourceTracking_FrameWasDropped	
kICMSourceTracking_FrameWasEncoded	
kICMSourceTracking_FrameWasMerged	
kICMSourceTracking_LastCall	
kICMSourceTracking_ReleasedPixelBuffer	
kICMUnlimitedCPUTimeBudget	No CPU time limit on compression.
kICMUnlimitedFrameDelayCount	No limit on the number of frames in the compression window.
kICMUnlimitedFrameDelayTime	No time limit on the frames in the compression window.
kICMValidTime_DecodeDurationIsValid	
kICMValidTime_DecodeTimeStampIsValid	
kICMValidTime_DisplayDurationIsValid	The time value passed in displayDuration is valid.
kICMValidTime_DisplayOffsetIsValid	
kICMValidTime_DisplayTimeStampIsValid	The time value passed in displayTimeStamp is valid.
kQTPropertyClass_ICMCompressionFrameOptions	
kQTPropertyClass_ICMCompressionSession	Class identifier for compression session properties. Also 'icse'.
kQTPropertyClass_ICMCompressionSessionOptions	Class identifier for compression session option object properties. Also 'icso'.
kQTPropertyClass_ICMDecompressionFrameOptions	
kQTPropertyClass_ICMDecompressionSession	
kQTPropertyClass_ICMDecompressionSessionOptions	
kQTPropertyClass_ImageDescription	Class identifier for image description properties.
kQTVisualContextExpectedReadAheadKey	A CFNumberRef that defines the number of seconds ahead of real time that the client expects to pull images out of a visual context.
kQTVisualContextOutputColorSpaceKey	
kQTVisualContextPixelBufferAttributesKey	A CFDictionaryRef that defines the dictionary containing pixel buffer attributes. See kICMCompressionSessionPropertyID_-
PixelBufferPool in ICM Compression Session Properties.
kQTVisualContextTargetDimensionsKey	A CFDictionaryRef that defines the dictionary containing kQTVisualContextTargetDimensions_-
WidthKey and kQTVisualContextTargetDimensions_-
HeightKey values (see below).
kQTVisualContextTargetDimensions_HeightKey	A CFNumberRef that defines the height, in pixels, of the rendering target.
kQTVisualContextTargetDimensions_WidthKey	A CFNumberRef that defines the width, in pixels, of the rendering target.
kQTVisualContextTypeKey	
kQTVisualContextType_OpenGLTexture	The value of kQTVisualContextTypeKey for OpenGL texture visual contexts.
kQTVisualContextType_PixelBuffer	The value of kQTVisualContextTypeKey for pixel buffer visual contexts.
kQTVisualContextWorkingColorSpaceKey	

Movies.h

A variety of new functions in Movies.h support high-resolution audio, a new metadata format, a new sample table API, the ability to create movies from properties, and other features of QuickTime 7.
Functions

All of the new functions in this header file are listed alphabetically, with links to documentation and abstracts, if available.AddMediaSample2	Adds sample data and a description to a media.
AddMediaSampleFromEncodedFrame	Adds sample data and description from an encoded frame to a media.
AddSampleTableToMedia	Adds a sample table to a media.
CopyMediaMutableSampleTable	Obtains information about sample references in a media in the form of a sample table.
DisposeQTTrackPropertyListenerUPP	Disposes a track property listener UPP.
ExtendMediaDecodeDurationToDisplayEndTime	Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.
GetMediaAdvanceDecodeTime	Returns the advance decode time of a media.
GetMediaDataSizeTime64	Determines the size, in bytes, of the sample data in a media segment.
GetMediaDecodeDuration	Returns the decode duration of a media.
GetMediaDisplayDuration	Returns the display duration of a media.
GetMediaDisplayEndTime	Returns the display end time of a media.
GetMediaDisplayStartTime	Returns the display start time of a media.
GetMediaNextInterestingDecodeTime	Searches for decode times of interest in a media.
GetMediaNextInterestingDisplayTime	Searches for display times of interest in a media.
GetMediaSample2	Retrieves sample data from a media file.
GetMovieAudioBalance	Returns the balance value for the audio mix of a movie currently playing.
GetMovieAudioContext	Returns the current audio context for a movie.
GetMovieAudioFrequencyLevels	Returns the current frequency meter levels of a movie mix.
GetMovieAudioFrequencyMeteringBandFrequencies	Returns the chosen middle frequency for each band in the configured frequency metering of a particular movie mix.
GetMovieAudioFrequencyMeteringNumBands	Returns the number of frequency bands being metered for a movie's specified audio mix.
GetMovieAudioGain	Returns the gain value for the audio mix of a movie currently playing.
GetMovieAudioMute	Returns the mute value for the audio mix of a movie currently playing.
GetMovieAudioVolumeLevels	Returns the current volume meter levels of a movie.
GetMovieAudioVolumeMeteringEnabled	Returns the enabled or disabled status of volume metering of a particular audio mix of a movie.
GetMovieVisualBrightness	Returns the brightness adjustment for the movie.
GetMovieVisualContext	Returns the current visual context for a movie.
GetMovieVisualContrast	Returns the contrast adjustment for the movie.
GetMovieVisualHue	Returns the hue adjustment for the movie.
GetMovieVisualSaturation	Returns the color saturation adjustment for the movie.
GetTrackAudioGain	Returns the gain value for the audio mix of a track currently playing.
GetTrackAudioMute	Returns the mute value for the audio mix of a track currently playing.
GetTrackAudioVolumeLevels	
GetTrackAudioVolumeMeteringEnabled	
GetTrackEditRate64	Returns the rate of the track edit of a specified track at an indicated time.
InvokeQTTrackPropertyListenerUPP	Invokes the specified property listener of a track.
MediaContainsDisplayOffsets	Tests whether a media contains display offsets.
MediaDecodeTimeToSampleNum	Finds the sample for a specified decode time.
MediaDisplayTimeToSampleNum	Finds the sample number for a specified display time.
MovieAudioExtractionBegin	Begins a movie audio extraction session.
MovieAudioExtractionEnd	Ends a movie audio extraction session.
MovieAudioExtractionFillBuffer	Extracts audio from a movie.
MovieAudioExtractionGetProperty	Gets a property of a movie audio extraction session.
MovieAudioExtractionGetPropertyInfo	Gets information about a property of a movie audio extraction session.
MovieAudioExtractionSetProperty	Sets a property of a movie audio extraction session.
NewMovieFromProperties	Creates a new movie using movie properties.
NewQTTrackPropertyListenerUPP	Creates a new callback to monitor a track property.
QTAddTrackPropertyListener	Installs a callback to monitor a track property.
QTAudioContextCreateForAudioDevice	Creates a QTAudioContext object that encapsulates a connection to a CoreAudio output device.
QTAudioContextRelease	
QTAudioContextRetain	
QTCopyMediaMetaData	Retains a media's metadata object and returns it.
QTCopyMovieMetaData	Retains a movie's metadata object and returns it.
QTCopyTrackMetaData	Retains a track's metadata object and returns it.
QTGetTrackProperty	Returns the value of a specific track property.
QTGetTrackPropertyInfo	Returns information about the properties of a track.
QTMetaDataAddItem	Adds an inline metadata item to the metadata storage format.
QTMetaDataGetItemCountWithKey	
QTMetaDataGetItemProperty	Returns a property of a metadata item.
QTMetaDataGetItemPropertyInfo	Returns information about a property of a metadata item.
QTMetaDataGetItemValue	Returns the value of a metadata item from an item identifier.
QTMetaDataGetNextItem	Returns the next metadata item corresponding to a specified key.
QTMetaDataGetProperty	Returns a property of a metadata object.
QTMetaDataGetPropertyInfo	Returns information about a property of a metadata object.
QTMetaDataRelease	Decrements the retain count of a metadata object.
QTMetaDataRemoveItem	Removes a metadata item from a storage format.
QTMetaDataRemoveItemsWithKey	Removes metadata items with a specific key from the storage format.
QTMetaDataRetain	Increments the retain count of a metadata object.
QTMetaDataSetItem	Sets the value of the metadata item from the item identifier.
QTMetaDataSetItemProperty	Sets a property of a metadata item.
QTMetaDataSetProperty	Sets a property of a metadata object.
QTRemoveTrackPropertyListener	Removes a track property monitoring callback
QTSampleTableAddSampleDescription	Adds a sample description to a sample table, returning a sample description ID that can be used to refer to it.
QTSampleTableAddSampleReferences	Adds sample references to a sample table.
QTSampleTableCopySampleDescription	Retrieves a sample description from a sample table.
QTSampleTableCreateMutable	Creates a new, empty sample table.
QTSampleTableCreateMutableCopy	Copies a sample table.
QTSampleTableGetDataOffset	Returns the data offset of a sample.
QTSampleTableGetDataSizePerSample	Returns the data size of a sample.
QTSampleTableGetDecodeDuration	Returns the decode duration of a sample.
QTSampleTableGetDisplayOffset	Returns the offset from decode time to display time of a sample.
QTSampleTableGetNextAttributeChange	Finds the next sample number at which one or more of a set of given sample attributes change.
QTSampleTableGetNumberOfSamples	Returns the number of samples in a sample table.
QTSampleTableGetProperty	Returns the value of a specific sample table property.
QTSampleTableGetPropertyInfo	Returns information about the properties of a sample table.
QTSampleTableGetSampleDescriptionID	Returns the sample description ID of a sample.
QTSampleTableGetSampleFlags	Returns the media sample flags of a sample.
QTSampleTableGetTimeScale	Returns the timescale of a sample table.
QTSampleTableGetTypeID	Returns the CFTypeID value for the current sample table.
QTSampleTableRelease	Decrements the retain count of a sample table.
QTSampleTableReplaceRange	Replaces a range of samples in a sample table with a range of samples from another sample table.
QTSampleTableRetain	Increments the retain count of a sample table.
QTSampleTableSetProperty	Sets the value of a specific sample table property.
QTSampleTableSetTimeScale	Changes the timescale of a sample table.
QTSetTrackProperty	Sets the value of a specific track property.
QTSoundDescriptionConvert	Converts a sound description from one version to another.
QTSoundDescriptionCreate	Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.
QTSoundDescriptionGetProperty	Gets a particular property of a sound description.
QTSoundDescriptionGetPropertyInfo	Gets information about a particular property of a sound description.
QTSoundDescriptionSetProperty	Sets a particular property of a sound description.
SampleNumToMediaDecodeTime	Finds the decode time for a specified sample.
SampleNumToMediaDisplayTime	Finds the display time for a specified sample.
SetMovieAudioBalance	Sets the balance level for the mixed audio output of a movie.
SetMovieAudioContext	Targets a movie to render into an audio context.
SetMovieAudioFrequencyMeteringNumBands	Configures frequency metering for a particular audio mix in a movie.
SetMovieAudioGain	Sets the audio gain level for the mixed audio output of a movie, altering the perceived volume of the movie's playback.
SetMovieAudioMute	Sets the mute value for the audio mix of a movie currently playing.
SetMovieAudioVolumeMeteringEnabled	Enables or disables volume metering of a particular audio mix of a movie.
SetMovieVisualBrightness	Sets the brightness adjustment for the movie.
SetMovieVisualContext	Targets a movie to render into a visual context.
SetMovieVisualContrast	Sets the contrast adjustment for the movie.
SetMovieVisualHue	Sets the hue adjustment for the movie.
SetMovieVisualSaturation	Sets the color saturation adjustment for the movie.
SetTrackAudioGain	Sets the audio gain level for the audio output of a track, altering the perceived volume of the track's playback.
SetTrackAudioMute	Mutes or unmutes the audio output of a track.
SetTrackAudioVolumeMeteringEnabled	
TrackTimeToMediaDisplayTime	Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.*/
const CFStringRef kQTVisualContextOutputColorSpaceKey;
const CFStringRef  kQTVisualContextTargetDimensions_WidthKey;	//A CFNumberRef that defines the width, in pixels, of the rendering target.
const CFStringRef kQTVisualContextTargetDimensions_HeightKey;	//A CFNumberRef that defines the height, in pixels, of the rendering target.
const CFStringRef kQTVisualContextTargetDimensionsKey; //	A CFDictionaryRef that defines the dictionary containing kQTVisualContextTargetDimensions_-
const CFStringRef kQTVisualContextPixelBufferAttributesKey; //	A CFDictionaryRef that defines the dictionary containing pixel buffer attributes. See kICMCompressionSessionPropertyID_-
const CFStringRef kQTVisualContextWorkingColorSpaceKey;	

/*GraphicsImportGetDestinationColorSyncProfileRef

Retrieves a ColorSync profile from a graphics importer component.

GraphicsImportGetDestinationColorSyncProfileRef (
   GraphicsImportComponent   ci,
   CMProfileRef              *destinationProfileRef);
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
destinationProfileRef

On return, a pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ComponentResult  GraphicsImportGetDestinationColorSyncProfileRef (
   GraphicsImportComponent   ci,
  CMProfileRef              *destinationProfileRef){
printf ("GraphicsImportGetDestinationColorSyncProfileRef",ci,*destinationProfileRef);
};


/*GraphicsImportSetOverrideSourceColorSyncProfileRef

Sets the override ColorSync profile for a graphics importer component.

ComponentResult GraphicsImportSetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newOverrideSourceProfileRef);
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
newOverrideSourceProfileRef

A pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newOverrideSourceProfileRef){
printf ("GraphicsImportSetOverrideSourceColorSyncProfileRef",ci,newOverrideSourceProfileRef);
};


/*GraphicsImportGetOverrideSourceColorSyncProfileRef

Retrieves the override ColorSync profile for a graphics importer component.

ComponentResult GraphicsImportGetOverrideSourceColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              *outOverrideSourceProfileRef );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
outOverrideSourceProfileRef

A pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetOverrideSourceColorSyncProfileRef
(   GraphicsImportComponent   ci,    CMProfileRef              *outOverrideSourceProfileRef ){
printf ("GraphicsImportGetOverrideSourceColorSyncProfileRef", ci , *outOverrideSourceProfileRef);
};


/*GraphicsImportGetFlags

Returns the current flags of a graphics importer component.

ComponentResult GraphicsImportGetFlags (
   GraphicsImportComponent    ci,
   long                       *flags );
Parameters
ci

The component instance that identifies your connection to a graphics importer component.
flags

Pointer to a long integer to receive the current flags (see below). See these constants: 
kGraphicsImporterDontDoGammaCorrection
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetFlags (
   GraphicsImportComponent    ci,
   long                       *flags ){

printf ("GraphicsImportGetFlags" ,  ci , *flags);
};




/*GraphicsImportSetDestinationColorSyncProfileRef

Sets the ColorSync profile for a graphics importer component.

ComponentResult GraphicsImportSetDestinationColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newDestinationProfileRef);
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
newDestinationProfileRef

A pointer to an opaque struct containing a ColorSync profile.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetDestinationColorSyncProfileRef
(
   GraphicsImportComponent   ci,
   CMProfileRef              newDestinationProfileRef){

printf ("GraphicsImportSetDestinationColorSyncProfileRef", ci , newDestinationProfileRef);
};


/*GraphicsImportGetNaturalBounds

Returns the bounding rectangle of an imported image.

ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
naturalBounds

A pointer to a Rect structure that describes the size of the bounding rectangle for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to determine the native size of the image associated with a graphics importer component. The natural bounds are always zero-based. This is a convenience function that simply calls GraphicsImportGetImageDescription and extracts the width and height fields.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetNaturalBounds (
   GraphicsImportComponent    ci,
   Rect                       *naturalBounds ){
printf ("GraphicsImportGetNaturalBounds", ci , *naturalBounds);
};


/*NewICMProgressUPP

Allocates a Universal Procedure Pointer for the ICMProgressProc callback.

ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMProgressUPP NewICMProgressUPP (
   ICMProgressProcPtr    userRoutine ){
printf ("NewICMProgressUPP" , userRoutine);
};


/*GetGraphicsImporterForDataRef

Locates and opens a graphics importer component that can be used to draw the image from specified data reference.

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi );
Parameters
dataRef

The data reference to be drawn using a graphics importer component.
dataRefType

The type of data reference pointed to by the dataRef parameter; see Data References. For alias-based data references, the dataRef handle contains an AliasRecord and dataRefType is set to rAliasType.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found, this parameter will be set to NIL. If GetGraphicsImporterForDataRef is able to locate a graphics importer for the data reference, the returned graphics importer ComponentInstance will already be set up to draw from the specified data reference to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function tries to locate a graphics importer component for the specified data reference by checking the file extension (such as .GIF or .JPG), the Macintosh file type, and the MIME type of the file. The file extension is retrieved from the data reference by using DataHGetFileName to call the data handler associated with the data reference. If a graphics importer cannot be found using the file's type, file extension, or MIME type, GetGraphicsImporterForDataRef asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming; to bypass it, call GetGraphicsImporterForDataRefWithFlags instead.
Special Considerations

The caller of GetGraphicsImporterForDataRef is responsible for closing the returned ComponentInstance using CloseComponent. You must call CloseComponent when you are finished with the importer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetGraphicsImporterForDataRef (
   Handle               dataRef,
   OSType               dataRefType,
   ComponentInstance    *gi ){
printf ("GetGraphicsImporterForDataRef", dataRef ,dataRefType, *gi);
};


/*GraphicsExportDoExport

Performs a graphics export operation.

ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
actualSizeWritten

Points to a variable to receive the number of bytes written. If you are not interested in this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function , you must specify an input image, using one of the GraphicsExportSetInput... functions, and a destination for the output image file, using one of the GraphicsExportSetOutput... functions.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportDoExport (
   GraphicsExportComponent    ci,
   unsigned long              *actualSizeWritten ){
printf ("GraphicsExportDoExport", ci , *actualSizeWritten);
};



/*GraphicsImportSetQuality

Sets the image quality value for an imported image.

ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
quality

Contains a constant (see below) that defines the desired image quality for decompression. Values for this parameter are on the same scale as compression quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The quality parameter controls how precisely the decompressor decompresses the image data. Some decompressors may choose to ignore some image data to improve decompression speed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetQuality (
   GraphicsImportComponent    ci,
   CodecQ                     quality ){
printf ("GraphicsImportSetQuality", ci , quality);
};


/*GraphicsExportSetProgressProc

Installs a progress function in a graphics export operation.

ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is always implemented by the base graphics exporter.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetProgressProc (
   GraphicsExportComponent     ci,
   ICMProgressProcRecordPtr    progressProc ){
printf ("GraphicsExportSetProgressProc", ci , progressProc);
};


/*GraphicsExportSetCompressionQuality

Defines the compression quality for a graphics export operation.

ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
spatialQuality

A constant (see below) that defines the currently specified quality value. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This setting is only supported by lossy compression methods.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetCompressionQuality (
   GraphicsExportComponent    ci,
   CodecQ                     spatialQuality ){
printf ("GraphicsExportSetCompressionQuality", ci , spatialQuality);
};


/*GraphicsExportSetOutputFile

Defines the output file for a graphics export operation.

ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
theFile

an FSSpec structure that identifies the file.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputFile (
   GraphicsExportComponent    ci,
   const FSSpec               *theFile ){
printf ("GraphicsExportSetOutputFile", ci , *theFile);
};


/*GraphicsImportSetBoundsRect

Defines the rectangle in which to draw an imported image.

ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure that describes the bounding rectangle into which the image will be drawn.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You use this function to define the rectangle into which the graphics image should be drawn. The function creates a transformation matrix to map the image's natural bounds to the specified bounds and then calls GraphicsImportSetMatrix.
Special Considerations

Because this function affects the transformation matrix, you should use GraphicsImportSetMatrix instead of this function if you also need to specify more complex transformations of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetBoundsRect (
   GraphicsImportComponent    ci,
   const Rect                 *bounds ){
printf ("GraphicsImportSetBoundsRect", ci , *bounds);
};


/*GraphicsExportSetInputGraphicsImporter

Specifies that the source image for a graphics export operation is to be drawn by a graphics importer instance.

ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
grip

The source graphics importer component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

It is the caller's responsibility to dispose of the graphics importer.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetInputGraphicsImporter (
   GraphicsExportComponent    ci,
   GraphicsImportComponent    grip ){
printf ("GraphicsExportSetInputGraphicsImporter", ci , grip);
};


/*GraphicsImportSetGWorld

Sets the graphics port and device for drawing an imported image.

ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
port

A pointer to the CGrafPort structure that defines the destination graphics port or graphics world. Set to NIL to use the current port.
gd

A handled to the GDevice structure that defines the destination graphics device. Set to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's device.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics world is initialized to the current port and device when the graphics importer component is opened. Use this function to select another port or device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetGWorld (
   GraphicsImportComponent    ci,
   CGrafPtr                   port,
   GDHandle                   gd ){
printf ("GraphicsImportSetGWorld", ci , port , gd);
};

/*GraphicsImportSetProgressProc

Installs a progress procedure to call while drawing an imported image.

ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
progressProc

Points to an ICMProgressProc callback. If you pass a value of -1, QuickTime provides a standard progress function. If you want to remove the existing progress function, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets a progress function that will be installed in the image decompression sequence used to draw the image.
Special Considerations

If your progress function does any drawing, you should take care to set a safe graphics state before doing so, and to restore the graphics state afterwards. In particular, the current graphics device may be an offscreen device.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetProgressProc (
   GraphicsImportComponent     ci,
   ICMProgressProcRecordPtr    progressProc ){
printf ("GraphicsImportSetProgressProc", ci , progressProc);
};


/*GraphicsImportDraw

Draws an imported image.

ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the image currently in use by the graphics import component to the graphics port and device specified by GraphicsImportSetGWorld. GraphicsImportDraw takes into account all settings previously specified for the image, such as the source rectangle, transformation matrix, clipping region, graphics mode, and image quality.
Special Considerations

The base graphics importer's drawing function uses the results of GraphicsImportGetImageDescription and GraphicsImportGetDataOffsetAndSize to create a decompression sequence, which it uses to draw the image. Subsequent draw operations with the same connection may reuse the decompression sequence. Other graphics importers may override this behavior.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDraw (
   GraphicsImportComponent    ci ){
printf ("GraphicsImportDraw" , ci);
};


/*GraphicsExportGetMIMETypeList

Returns MIME types and other information about the graphics format in a graphics export operation.

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Receives a newly-created QuickTime atom container that contains information about the graphics format.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container that contains the format's name, as a string in an atom of type 'desc' (kMimeInfoDescriptionTag), and optionally the MIME type as a string in an atom of type 'mime'[atom] (kMimeInfoMimeTypeTag).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportGetMIMETypeList (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr ){
printf ("GraphicsExportGetMIMETypeList",ci , qtAtomContainerPtr);
};



/*GraphicsExportGetDefaultFileNameExtension

Returns the suggested file name extension for a graphics export operation.

ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
fileNameExtension

Points to a location to receive the file name extension.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

File name extensions are returned as upper-case big-endian four-character codes. For example, the extension .png would be returned as 'PNG ' (0x504E4720).
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetDefaultFileNameExtension (
   GraphicsExportComponent    ci,
   OSType                     *fileNameExtension ){
printf ("GraphicsExportGetDefaultFileNameExtension ",ci,*fileNameExtension);
};


/*QTVisualContextRelease

Releases a visual context object.

void QTVisualContextRelease (
   QTVisualContextRef visualContext
);
Parameters
visualContext

A reference to a visual context object. If you pass NULL, nothing happens.
Discussion

When the retain count decreases to zero, the visual context is disposed.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
void QTVisualContextRelease (
   QTVisualContextRef visualContext){
printf ("QTVisualContextRelease", visualContext);
};

/*QTVisualContextSetAttribute

Sets a visual context attribute.

OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue );
Parameters
visualContext

The visual context.
attributeKey

Identifier of attribute to set
attributeValue

The value of the attribute to set, or NULL to remove a value. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTVisualContextSetAttribute (
   QTVisualContextRef visualContext,
   CFStringRef attributeKey,
   CFTypeRef attributeValue ){
printf ("QTVisualContextSetAttribute",visualContext,attributeKey,attributeValue);
};


/*QTOpenGLTextureContextCreate
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Creates a new OpenGL texture context for a specified OpenGL context and pixel format.

OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext );
Parameters
allocator

The allocator used to create the texture context.
cglContext

A pointer to an opaque CGLPContextObj structure representing the OpenGL context used to create textures. You can create this structure using CGLCreateContext.
cglPixelFormat

The pixel format object that specifies buffer types and other attributes of the new context.
attributes

A dictionary of attributes.
newTextureContext

A pointer to a variable to receive the new OpenGL texture context.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus QTOpenGLTextureContextCreate (
   CFAllocatorRef               allocator,
   CGLContextObj                cglContext,
   CGLPixelFormatObj            cglPixelFormat,
   CFDictionaryRef              attributes,
   QTOpenGLTextureContextRef    *newTextureContext ){
printf ("QTOpenGLTextureContextCreate", allocator,cglContext,cglPixelFormat,attributes,*newTextureContext);
};


/*NewICMDataUPP

Allocates a Universal Procedure Pointer for the ICMDataProc callback.

ICMDataUPP NewICMDataUPP (
   ICMDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ICMDataUPP NewICMDataUPP (
   ICMDataProcPtr    userRoutine ){
printf ("NewICMDataUPP",userRoutine);
};

/*CompressPicture

Compresses a single-frame image stored as a picture structure and places the result in another picture.

OSErr CompressPicture (
   PicHandle    srcPicture,
   PicHandle    dstPicture,
   CodecQ       quality,
   CodecType    cType );
Parameters
srcPicture

A handle to the source image, stored as a picture.
dstPicture

A handle to the destination for the compressed image. The compressor resizes this handle for the result data.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

You must set this parameter to a valid compressor identifier; see Codec Identifiers. If the value passed in is 0, or 'raw ', and the source picture is compressed, the destination picture is created as an uncompressed picture and does not require QuickTime for its display.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function compresses only image data. Any other types of data in the picture, such as text, graphics primitives, and previously compressed images, are not modified in any way and are passed through to the destination picture. This function supports parameters governing image quality and compressor type. The compressor infers the other compression parameters from the image data in the source picture.
Special Considerations

If a picture with multiple pixel maps and other graphical objects is passed, the pixel maps will be compressed individually and the other graphic objects will not be affected. This function does not use the graphics port.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr CompressPicture (
   PicHandle    srcPicture,
   PicHandle    dstPicture,
   CodecQ       quality,
   CodecType    cType ){
printf ("CompressPicture",srcPicture,dstPicture,quality,cType);
};

/*GetImageDescriptionExtension

Returns a new handle with the data from a specified image description extension.

OSErr GetImageDescriptionExtension (
   ImageDescriptionHandle    desc,
   Handle                    *extension,
   long                      idType,
   long                      index );
Parameters
desc

A handle to the appropriate ImageDescription structure.
extension

A pointer to a field to receive a handle to the returned data. The GetImageDescriptionExtension function returns the extended data for the image described by the ImageDescription structure referred to by the desc parameter. The function correctly sizes the handle for the data it returns.
idType

Specifies the extension's type value. Use this parameter to determine the data type of the extension. This parameter contains a four-character code, similar to an OSType field value.
index

The index of the extension to retrieve. This is a number between 1 and the count returned by CountImageDescriptionExtensionType.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows the application to get a copy of a specified image description extension. Note that each compressor type may have its own format for the extended data that is stored with an image. The extended data is similar in concept to the user data that applications can associate with QuickTime movies. Once you have added extended data to an image, you cannot delete it.
Special Considerations

The Image Compression Manager allocates a new handle and passes it back in the extension parameter. Your application should dispose of the handle when it is no longer needed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetImageDescriptionExtension (
   ImageDescriptionHandle    desc,
   Handle                    *extension,
   long                      idType,
   long                      index ){
printf ("GetImageDescriptionExtension",desc,*extension,idType,index);
};


/*NewICMFlushUPP

Allocates a Universal Procedure Pointer for the ICMFlushProc callback.

ICMFlushUPP NewICMFlushUPP (
   ICMFlushProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewICMFlushProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/


ICMFlushUPP NewICMFlushUPP (
   ICMFlushProcPtr    userRoutine ){
printf ("NewICMFlushUPP",userRoutine);
};


/*DisposeICMProgressUPP

Disposes of an ICMProgressUPP pointer.

void DisposeICMProgressUPP (
   ICMProgressUPP    userUPP );
Parameters
userUPP

An ICMProgressUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void DisposeICMProgressUPP (
   ICMProgressUPP    userUPP ){
printf ("DisposeICMProgressUPP ",userUPP);
};

/*GraphicsImportSetImageIndex

Specifies the image index for an imported image.

ComponentResult GraphicsImportSetImageIndex (
   GraphicsImportComponent    ci,
   unsigned long              imageIndex );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageIndex

The image index. Image indexes are one-based; 0 is considered a special index by some importers, and treated the same as 1 by others. The default image index is 1.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The base graphics importer ensures that the image index is no greater than the image count returned by GraphicsImportGetImageCount.
Special Considerations

The base graphics importer implements this function. Format-specific importers should delegate it.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetImageIndex (
   GraphicsImportComponent    ci,
   unsigned long              imageIndex ){
printf ("GraphicsImportSetImageIndex",ci,imageIndex);
};


/*GraphicsImportGetImageCount

Returns the number of images in an imported image file.

ComponentResult GraphicsImportGetImageCount (
   GraphicsImportComponent    ci,
   unsigned long              *imageCount );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageCount

Points to a variable to receive the number of images.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Most image file formats don't support multiple images. Of the image formats supported by QuickTime 4, however, TIFF files can support multiple images, Photoshop files can contain multiple layers and FlashPix files can contain multiple resolutions. The base graphics importer returns a count of 1.
Special Considerations

Format-specific importers for multiple-image formats should override this function; other importers should delegate it.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetImageCount (
   GraphicsImportComponent    ci,
   unsigned long              *imageCount ){
printf ("GraphicsImportGetImageCount",ci,*imageCount);
};


/*ICMSetPixelFormatInfo

Lets you define your own pixel format.

OSErr ICMSetPixelFormatInfo (
   OSType                   PixelFormat,
   ICMPixelFormatInfoPtr    theInfo );
Parameters
PixelFormat

A pixel format constant. See Pixel Formats.
theInfo

A pointer to an ICMPixelFormatInfo structure containing a definition of the new pixel format.
Return Value

Returns paramErr if the format is already defined. See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr ICMSetPixelFormatInfo (
   OSType                   PixelFormat,
   ICMPixelFormatInfoPtr    theInfo ){
printf ("ICMSetPixelFormatInfo",PixelFormat,theInfo);
};


/*SetDSequenceFlags

Sets data loading flags.

OSErr SetDSequenceFlags (
   ImageSequence    seqID,
   long             flags,
   long             flagsMask );
Parameters
seqID

The unique sequence identifier assigned by CompressSequenceBegin or DecompressSequenceBegin.
flags

Flags (see below) for data loading. See these constants: 
codecDSequenceSingleField
flagsMask

Use this field to preserve the state of any flags you do not wish to alter. If a flag (see below) is set in this field, and is not set in the flags parameter, it will not be changed from its current setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr SetDSequenceFlags (
   ImageSequence    seqID,
   long             flags,
   long             flagsMask ){
printf ("SetDSequenceFlags",seqID,flags,flagsMask);
};

/*ICMImageDescriptionSetProperty

Sets a particular property of a image description handle.

OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress );
Parameters
inDesc

The image description handle being modified.
inPropClass

The class of property being set.
inPropID

The ID of the property being set.
inPropValueSize

The size of property value.
inPropValueAddress

Points to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionSetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstComponentValuePtr inPropValueAddress ){
printf ("ICMImageDescriptionSetProperty",inDesc,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*QTNewGWorld

Creates an offscreen graphics world that may have a non-Macintosh pixel format.

OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags );
Parameters
offscreenGWorld

On return, a pointer to the offscreen graphics world created by this routine.
PixelFormat

The new graphics world's pixel format; see Pixel Formats. This function won't work with planar pixel formats; use QTNewGWorldFromPtr instead. See the ICMPixelFormatInfo structure for a discussion of planar and chunky formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the PixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the PixelFormat parameter. If you set the PixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the PixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the PixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

Constants (see below) that identify options available to your application. You can set a combination of these flags. If you don't wish to use any of them, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world where the base address for the offscreen pixel image is unpurgeable, the graphics world uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure, it uses memory in your application heap, and it allows graphics accelerators to cache the offscreen pixel image. See these constants: 
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr QTNewGWorld (
   GWorldPtr      *offscreenGWorld,
   OSType         PixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags ){
printf ("QTNewGWorld",*offscreenGWorld,PixelFormat,*boundsRect,cTable,aGDevice,flags);
};

/*ICMDecompressionSessionOptionsSetProperty

Sets the value of a specific property of a decompression session options object.

OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress );
Parameters
options

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsSetProperty (
   ICMDecompressionSessionOptionsRef   options,
   ComponentPropertyClass              inPropClass,
   ComponentPropertyID                 inPropID,
   ByteCount                           inPropValueSize,
   ConstComponentValuePtr              inPropValueAddress ){
printf ("ICMDecompressionSessionOptionsSetProperty",options,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*ICMImageDescriptionGetProperty

Returns a particular property of a image description handle.

OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inDesc

The image description handle being interrogated.
inPropClass

The class of property being requested.
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

Points to the buffer to receive the property value.
outPropValueSizeUsed

Points to a variable to receive the actual size of returned property value. (This can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns a particular property of a image description handle.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMImageDescriptionGetProperty (
   ImageDescriptionHandle inDesc,
   ComponentPropertyClass inPropClass,
   ComponentPropertyID inPropID,
   ByteCount inPropValueSize,
   ComponentValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed ){
printf ("ICMImageDescriptionGetProperty ",inDesc,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};


/*ICMDecompressionSessionOptionsCreate

Creates a decompression session options object.

OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a decompression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionOptionsCreate (
   CFAllocatorRef                      allocator,
   ICMDecompressionSessionOptionsRef   *options ){
printf (" ICMDecompressionSessionOptionsCreate",allocator,*options);
};


/*ICMDecompressionSessionCreate

Creates a session for decompressing video frames.

OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
desc

An image description for the source frames. 
decompressionOptions

A decompression session options reference. This reference is returned by ICMDecompressionSessionOptionsCreate. The session will retain the object. You may change some options during the session by modifying the object. You may also pass NULL.
destinationPixelBufferAttributes

Requirements for emitted pixel buffers. You may pass NULL.
trackingCallback

A pointer to a structure that designates a callback to be called for information about queued frames and pixel buffers containing decompressed frames. See ICMDecompressionTrackingCallbackRecord and ICMDecompressionTrackingCallbackProc.
decompressionSessionOut

A pointer to a variable to receive a reference to the new decompression session. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Frames are returned through calls to the callback pointed to by trackingCallback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionCreate (
   CFAllocatorRef                       allocator,
   ImageDescriptionHandle               desc,
   ICMDecompressionSessionOptionsRef    decompressionOptions,
   CFDictionaryRef                      destinationPixelBufferAttributes,
   ICMDecompressionTrackingCallbackRecord    *trackingCallback,
   ICMDecompressionSessionRef                *decompressionSessionOut ){
printf (" ICMDecompressionSessionCreate",allocator,desc,decompressionOptions,destinationPixelBufferAttributes,*trackingCallback,*decompressionSessionOut);
};



/*QTGetComponentProperty

Returns the value of a specific component property.

ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ComponentValuePtr         outPropValueAddress,
   ByteCount                 *outPropValueSizeUsed ){
printf ("QTGetComponentProperty",inComponent,inPropClass,inPropID,inPropValueSize,outPropValueAddress, *outPropValueSizeUsed);
};

/*QTGetComponentPropertyInfo

Returns information about the properties of a component.

ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
outPropType

A pointer to memory allocated to hold the property type on return. This pointer may be NULL.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. This pointer may be NULL.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTGetComponentPropertyInfo (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ComponentValueType        *outPropType,
   ByteCount                 *outPropValueSize,
   UInt32                    *outPropertyFlags ){
printf ("QTGetComponentPropertyInfo",inComponent,inPropClass,inPropID,*outPropType,*outPropValueSize,*outPropertyFlags);
};



/*DecompressSequenceFrameWhen

Queues a frame for decompression and specifies the time at which decompression will begin.

OSErr DecompressSequenceFrameWhen (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc,
   const ICMFrameTimeRecord      *frameTime );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address. 
dataSize

The size of the data buffer.
inFlags

Contains flags (see below) that provide further control information. See these constants: 
codecFlagNoScreenUpdate
codecFlagDontOffscreen
codecFlagOnlyScreenUpdate
outFlags

Contains status flags (see below). The decompressor updates these flags at the end of the decompression operation. See these constants: 
codecFlagUsedNewImageBuffer
codecFlagUsedImageBuffer
codecFlagDontUseNewImageBuffer
codecFlagInterlaceUpdate
codecFlagCatchUpDiff
asyncCompletionProc

Points to an ICMCompletionProcRecord structure. The compressor calls your completion function when an asynchronous decompression operation is complete. You can cause the decompression to be performed asynchronously by specifying a completion function. If you specify asynchronous operation, you must not read the decompressed image until the decompressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous decompression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the decompressor does not call your completion function.
frameTime

Points to an ICMFrameTimeRecord structure, which contains the frame's time information, including the time at which the frame should be displayed, its duration, and the movie's playback rate. This parameter can be NIL, in which case the decompression operation will happen immediately.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The following code snippet shows this function being used to execute one frame of a visual effect.// DecompressSequenceFrameWhen coding example
// See "Discovering QuickTime," page 310
// Decompress a single step of the effect sequence.
OSErr RunEffect(TimeValue lTime, int nNumberOfSteps)
{
    OSErr               nErr =noErr;
    ICMFrameTimeRecord  ftr;
    // Set the timebase time to the step of the sequence to be rendered
    SetTimeBaseValue(timeBase, lTime, nNumberOfSteps);
    ftr.value.lo            =lTime;
    ftr.value.hi            =0;
    ftr.scale               =nNumberOfSteps;
    ftr.base                =0;
    ftr.duration            =nNumberOfSteps;
    ftr.rate                =0;
    ftr.recordSize          =sizeof(ftr);
    ftr.frameNumber         =1;
    ftr.flags               =icmFrameTimeHasVirtualStartTimeAndDuration;
    ftr.virtualStartTime.lo     =0;
    ftr.virtualStartTime.hi     =0;
    ftr.virtualDuration         =nNumberOfSteps;
    HLock(hEffectDesc);
    DecompressSequenceFrameWhen(gEffectSequenceID,
                                StripAddress(*hEffectDesc),
                                GetHandleSize(hEffectDesc),
                                0,
                                0,
                                NIL,
                                &ftr);
    HUnlock(hEffectDesc);
}

Special Considerations

If the current decompressor component does not support scheduled asynchronous decompression, the Image Compression Manager returns an error code of codecCantWhenErr. In this case, the application will need to reissue the request with the frameTime parameter set to NIL. If the decompressor cannot service your request at a particular time (for example, if its queue is full), the Image Compression Manager returns an error code of codecCantQueueErr. The best way to determine whether a decompressor component supports this function is to call the function and test the result code. A decompressor's ability to honor the request may change based on screen depth, clipping settings, and so on.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceFrameWhen (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc,
   const ICMFrameTimeRecord      *frameTime ){
printf ("DecompressSequenceFrameWhen",seqID,data,dataSize,inFlags,*outFlags,asyncCompletionProc,*frameTime);
};

/*InverseMatrix

Creates a new matrix that is the inverse of a specified matrix.

Boolean InverseMatrix (
   const MatrixRecord    *m,
   MatrixRecord          *im );
Parameters
m

A pointer to the source MatrixRecord structure for the operation.
im

A pointer to a MatrixRecord structure that is to receive the new matrix. The function updates this structure so that it contains a matrix that is the inverse of that specified by the m parameter.
Return Value

A Boolean value of TRUE if InverseMatrix was able to create an inverse matrix, FALSE otherwise.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

Boolean InverseMatrix (
   const MatrixRecord    *m,
   MatrixRecord          *im ){
printf ("InverseMatrix",*m,*im);
};


/*QTSetComponentProperty

Sets the value of a specific component property.

ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTSetComponentProperty (
   ComponentInstance         inComponent,
   ComponentPropertyClass    inPropClass,
   ComponentPropertyID       inPropID,
   ByteCount                 inPropValueSize,
   ConstComponentValuePtr    inPropValueAddress ){
printf ("QTSetComponentProperty",inComponent,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*QTVisualContextCopyImageForTime

Retrieves an image buffer from the visual context, indexed by the provided time.

OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage
);
Parameters
visualContext

The visual context.
allocator

Allocator used to create new CVImageBufferRef.
timeStamp

Time in question. Pass NULL to request the image at the current time.
newImage

Points to variable to receive the new image.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You should not request image buffers further ahead of the current time than the read-ahead time specified with the kQTVisualContextExpectedReadAheadKey attribute. You may skip images by passing later times, but you may not pass an earlier time than passed to a previous call to this function.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/
OSStatus QTVisualContextCopyImageForTime (
   QTVisualContextRef visualContext,
   CFAllocatorRef allocator,
   const CVTimeStamp *timeStamp,
   CVImageBufferRef *newImage){
printf ("QTVisualContextCopyImageForTime",visualContext,allocator,*timeStamp,*newImage);
};




/*QTVisualContextTask

Enables the visual context to release internally held resources for later use.

void QTVisualContextTask (
   QTVisualContextRef visualContext
);
Parameters
visualContext

The visual context.
Discussion

For optimal resource management, this function should be called in every rendering pass. It should be called after old images have been released, new images have been used and all rendering has been flushed to the screen. The call is not mandatory.
Version Notes

Introduced in QuickTime 7
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

void QTVisualContextTask (
   QTVisualContextRef visualContext){
printf ("QTVisualContextTask ",visualContext);
};


/*QTVisualContextIsNewImageAvailable

Queries whether a new image is available for a given time.

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp
);
Parameters
visualContext

The visual context.
timeStamp

Time in question.
Return Value

A Boolean.
Discussion

This function returns TRUE if there is a image available for the specified time that is different from the last image retrieved from QTVisualContextCopyImageForTime.
Version Notes

Introduced in QuickTime 7 for Mac OS X and in QuickTime 7.1 for Windows.
Availability
Carbon status: Supported C interface file: ImageCompression.h
Declared In
ImageCompression.h*/

Boolean QTVisualContextIsNewImageAvailable (
   QTVisualContextRef visualContext,
   const CVTimeStamp *timeStamp){
printf ("QTVisualContextIsNewImageAvailable",visualContext,*timeStamp);
};



/*QTAddComponentPropertyListener

Installs a callback to monitor a component property.

ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData );
Parameters
inComponent

A component instance, which you can get by calling OpenComponent or OpenDefaultComponent.
inPropClass

A value (see below) of type OSType that specifies a property class: kComponentPropertyClassPropertyInfo ('pnfo') A QTComponentPropertyInfo structure that defines a property information class. kComponentPropertyInfoList ('list') An array of QTComponentPropertyInfo structures, one for each property. kComponentPropertyCacheSeed ('seed') A component property cache seed value. kComponentPropertyExtendedInfo ('meta') A CFDictionary with extended property information. kComponentPropertyCacheFlags ('flgs') One of the following two flags: kComponentPropertyCacheFlagNotPersistent Property metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamic Property metadata should not be cached at all. See these constants: 
kComponentPropertyClassPropertyInfo
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyExtendedInfo
kComponentPropertyCacheFlags
kComponentPropertyCacheFlagNotPersistent
kComponentPropertyCacheFlagIsDynamic
inPropID

A value of type OSType that specifies a property ID.
inDispatchProc

A Universal Procedure Pointer to a QTComponentPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. You may pass NULL in this parameter.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ComponentResult QTAddComponentPropertyListener (
   ComponentInstance                 inComponent,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   QTComponentPropertyListenerUPP    inDispatchProc,
   void                              *inUserData ){
printf ("QTAddComponentPropertyListener",inComponent,inPropClass,inPropID,inDispatchProc,inUserData);
};


/*GraphicsImportGetSourceRect

Returns the current source rectangle for an imported image.

ComponentResult GraphicsImportGetSourceRect (
   GraphicsImportComponent    ci,
   Rect                       *sourceRect );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
sourceRect

A pointer to a Rect structure that defines the source rectangle currently specified for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the current source rectangle, as specified by GraphicsImportSetSourceRect. The default source rectangle is the image's natural bounds.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetSourceRect (
   GraphicsImportComponent    ci,
   Rect                       *sourceRect ){
printf ("GraphicsImportGetSourceRect",ci,*sourceRect);
};


/*ICMDecompressionSessionRelease

Decrements the retain count of a decompression session.

void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMDecompressionSessionRelease (
   ICMDecompressionSessionRef    session ){
printf ("ICMDecompressionSessionRelease",session);
};


/*ICMDecompressionSessionSetNonScheduledDisplayTime

Sets the display time for a decompression session, and requests display of the non-scheduled queued frame at that display time, if there is one.

OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
displayTime

A display time. Usually this is the display time of a non-scheduled queued frame. 
displayTimeScale

The timescale according to which displayTime should be interpreted. 
flags

Reserved; set to 0. 
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMDecompressionSessionSetNonScheduledDisplayTime (
   ICMDecompressionSessionRef   session,
   TimeValue64                  displayTime,
   TimeScale                    displayTimeScale,
   UInt32                       flags ){
printf ("ICMDecompressionSessionSetNonScheduledDisplayTime",session,displayTime,displayTimeScale,flags);
};



/*ICMDecompressionSessionDecodeFrame

Queues a frame for decompression.

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon );
Parameters
session

A decompression session reference. This reference is returned by ICMDecompressionSessionCreate. 
data

A pointer to the compressed data for this frame. The data must remain in this location until ICMDecompressionTrackingCallbackProc is called with the kICMDecompressionTracking_ReleaseSourceData flag set in decompressionTrackingFlags.
dataSize

The number of bytes of compressed data. You may not pass 0 in this parameter. 
frameOptions

A reference to a frame decompression options object containing options for this frame. You can create this object by calling ICMDecompressionFrameOptionsCreate.
frameTime

A pointer to a structure describing the frame's timing information. 
sourceFrameRefCon

Your reference value for the frame. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMDecompressionSessionDecodeFrame (
   ICMDecompressionSessionRef         session,
   const UInt8                        *data,
   ByteCount                          dataSize,
   ICMDecompressionFrameOptionsRef    frameOptions,
   const ICMFrameTimeRecord           *frameTime,
   void                               *sourceFrameRefCon ){
printf ("ICMDecompressionSessionDecodeFrame",session,*data,dataSize,frameOptions,*frameTime,sourceFrameRefCon);
};

/*ICMDecompressionSessionOptionsRelease

Decrements the retain count of a decompression session options object.

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options );
Parameters
options

A reference to a decompression session options object. This reference is returned by ICMDecompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMDecompressionSessionOptionsRelease (
   ICMDecompressionSessionOptionsRef   options ){
printf ("ICMDecompressionSessionOptionsRelease ",options);
};


/*AlignWindow

Moves a specified window to the nearest optimal alignment position.

void AlignWindow (
   WindowRef                    wp,
   Boolean                      front,
   const Rect                   *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
wp

Points to the window to be aligned.
front

The frontmost window. If the front parameter is TRUE and the window specified in the wp parameter isn't the active window, AlignWindow makes it the active window.
alignmentRect

A pointer to a rectangle in window coordinates that allows you to align the window to a rectangle within the window. Set this parameter to NIL to align using the bounds of the window.
alignmentProc

Points to a function that allows you to provide your own alignment behavior. Set this parameter to NIL to use the standard behavior.
Discussion

For a specification of your alignment function, see ICMAlignmentProc.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void AlignWindow (
   WindowRef                    wp,
   Boolean                      front,
   const Rect                   *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc ){
printf ("AlignWindow ",wp,front,*alignmentRect,alignmentProc);
};


/*TransformRect

Transforms the upper-left and lower-right points of a rectangle through a specified matrix.

Boolean TransformRect (
   const MatrixRecord    *m,
   Rect                  *r,
   FixedPoint            *fpp );
Parameters
m

The matrix for this operation.
r

A pointer to the Rect structure that defines the rectangle to be transformed. The function returns the updated coordinates into the structure referred to by this parameter.
fpp

A pointer to an array of four fixed points. The TransformRect function returns the coordinates of the four corners of the rectangle after the transformation operation. If you do not want this information, set this parameter to NIL.
Return Value

If the resulting rectangle has been rotated or skewed (that is, the transformation involves operations other than scaling and translation), the function returns FALSE, updates the rectangle specified by the r parameter to define the boundary box of the resulting rectangle, and places the coordinates of the corners of the resulting rectangle in the points specified by the fpp parameter. If the transformed rectangle and its boundary box are the same, the function returns TRUE.
Discussion

This function does not return any error codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

Boolean TransformRect (
   const MatrixRecord    *m,
   Rect                  *r,
   FixedPoint            *fpp ){
printf ("TransformRec",*m,*r,*fpp);
};



/*DragAlignedWindow

Drags the specified window along an optimal alignment grid.

void DragAlignedWindow (
   WindowRef                    wp,
   Point                        startPt,
   Rect                         *boundsRect,
   Rect                         *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
wp

A window pointer to the window to be dragged.
startPt

A point that is equal to the point where the mouse button was pressed (in global coordinates, as stored in the where field of the event structure). DragAlignedWindow pulls a gray outline of the window around the screen, following the movements of the mouse until the button is released.
boundsRect

Points to the boundary rectangle in global coordinates. If the mouse button is released when the mouse position is outside the limits of the boundary rectangle, DragAlignedWindow returns without moving the window or making it the active window. For a document window, the boundary rectangle typically is four pixels in from the menu bar and from the other edges of the screen, to ensure that there won't be less than a four-pixel-square area of the title bar visible on the screen.
alignmentRect

Points to a rectangle in window coordinates that allows you to align the window to a rectangle within the window. Set this parameter to NIL to align using the bounds of the window.
alignmentProc

A pointer to your alignment behavior function; see ICMAlignmentProc. Pass NIL to use the standard behavior.
Discussion

The following code sample illustrates the use of DragAlignedWindow:// DragAlignedWindow coding example
// See "Discovering QuickTime," page 265
Boolean IsQuickTimeInstalled (void)
{
    OSErr       nErr;
    long        lResult;
    nErr =Gestalt(gestaltQuickTime, &lResult);
    return (nErr ==noErr);
}
void MyInitialize (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    MaxApplZone();
    EnterMovies();
}
WindowRef MakeMyWindow (void)
{
    WindowRef   pMacWnd;
    Rect        rectWnd ={0, 0, 120, 160};
    Rect        rectBest;
    // figure out the best monitor for the window
    GetBestDeviceRect(NIL, &rectBest);
    // put the window in the top left corner of that monitor
    OffsetRect(&rectWnd, rectBest.left + 10, rectBest.top + 50);
    // create the window
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pGrabber",
                            TRUE, noGrowDocProc, (WindowRef)-1,
                            TRUE, 0);
    // set the port to the new window
    SetPort(pMacWnd);
    return pMacWnd;
}
main (void)
{
    WindowRef           pMacWnd;
    SeqGrabComponent    seqGrab;
    SGChannel           sgchanVideo, sgchanSound;
    Boolean             bDone =FALSE;
    OSErr               nErr;
    MyInitialize();
    pMacWnd =MakeMyWindow();
    seqGrab =MakeMySequenceGrabber(pMacWnd);
    if (seqGrab ==NIL)
        return;
    MakeMyGrabChannels(seqGrab, &sgchanVideo, &sgchanSound,
                         &pMacWnd->
portRect, FALSE);
    nErr =SGStartPreview(seqGrab);
    while (!bDone) {
        ICMAlignmentProcRecord  apr;
        short                   nPart;
        WindowRef               pWhichWnd;
        EventRecord             er;
        GetNextEvent(everyEvent, &er);
        switch (er.what) {
            case nullEvent:     // give the sequence grabber time
                nErr =SGIdle(seqGrab);
                if (nErr !=noErr)
                    bDone =TRUE;
                break;
            case updateEvt:
                if (er.message ==(long)pMacWnd) {
                    // inform the sequence grabber of the update
                    SGUpdate(seqGrab,((WindowPeek)
                                     pMacWnd)->
updateRgn);
                    // and swallow the update event
                    BeginUpdate(pMacWnd);
                    EndUpdate(pMacWnd);
                }
                break;
            case mouseDown:
                nPart =FindWindow(er.where, &pWhichWnd);
                if (pWhichWnd !=pMacWnd)
                    break;
                switch (nPart) {
                    case inContent:
                        // pause until mouse button is released
                        SGPause(seqGrab, TRUE);
                        while (StillDown())
                            SGPause(seqGrab, FALSE);
                            break;
                    case inGoAway:
                        bDone =TrackGoAway(pMacWnd, er.where);
                        break;
                    case inDrag:
                        // pause when dragging window so video
                        // doesn't draw in the wrong place
                        SGPause(seqGrab, TRUE);
                        SGGetAlignmentProc(seqGrab, &apr);
                        DragAlignedWindow(pMacWnd,
                                            er.where,
                                            &screenBits.bounds,
                                            NIL, &alignProc);
                        SGPause(seqGrab, FALSE);
                        break;
                    }
                break;
        }
    }
    // clean up
    SGStop(seqGrab);
    CloseComponent(seqGrab);
    DisposeWindow(pMacWnd);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void DragAlignedWindow (
   WindowRef                    wp,
   Point                        startPt,
   Rect                         *boundsRect,
   Rect                         *alignmentRect,
   ICMAlignmentProcRecordPtr    alignmentProc ){
printf ("DragAlignedWindow",wp,startPt,*boundsRect,*alignmentRect,alignmentProc);
};


/*NewStdPixUPP

Allocates a Universal Procedure Pointer for the StdPixProc callback.

StdPixUPP NewStdPixUPP (
   StdPixProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewStdPixProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
StdPixUPP NewStdPixUPP (
   StdPixProcPtr    userRoutine ){
printf ("NewStdPixUPP",userRoutine);
};



/*DisposeStdPixUPP

Disposes of a StdPixUPP pointer.

void DisposeStdPixUPP (
   StdPixUPP    userUPP );
Parameters
userUPP

A StdPixUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void DisposeStdPixUPP (
   StdPixUPP    userUPP ){
printf ("DisposeStdPixUPP",userUPP);
};

/*MapMatrix

Alters an existing matrix so that it defines a transformation from one rectangle to another.

void MapMatrix (
   MatrixRecord    *matrix,
   const Rect      *fromRect,
   const Rect      *toRect );
Parameters
matrix

A pointer to a matrix structure. The MapMatrix function modifies this matrix so that it performs a transformation in the rectangle specified by the toRect parameter that is analogous to the transformation it currently performs in the rectangle specified by the fromRect parameter.
fromRect

A pointer to the source Rect structure.
toRect

A pointer to the destination Rect structure.
Discussion

MapMatrix affects only the scaling and translation attributes of the matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void MapMatrix (
   MatrixRecord    *matrix,
   const Rect      *fromRect,
   const Rect      *toRect ){
printf ("MapMatrix",*matrix,*fromRect,*toRect);
};

/*GetMaxCompressionSize

Determines the maximum size an image will be after compression.

OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size );
Parameters
src

A handle to the source image. The source image must be stored in a pixel map structure. The compressor uses only the image's size and pixel depth to determine the maximum size of the compressed image.
srcRect

A pointer to a rectangle defining the portion of the source image that is to be compressed. You may set this parameter to NIL if you are interested only in information about quality settings. GetCompressionTime then uses the bounds of the source pixel map.
colorDepth

The depth at which the image is to be compressed. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by GetCodecInfo.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

You must set this parameter to a valid compressor type constant; see Codec Identifiers.
codec

A compressor identifier. Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). You can also specify a component instance. This may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
size

A pointer to a field to receive the size, in bytes, of the compressed image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the maximum resulting size for the specified image and parameters. Your application may then use this information to allocate memory for the compression operation. The following code sample illustrates its use:// GetMaxCompressionSize coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetMaxCompressionSize (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecQ                 quality,
   CodecType              cType,
   CompressorComponent    codec,
   long                   *size ){
printf ("GetMaxCompressionSize",src,*srcRect,colorDepth,quality,cType,codec,*size);
};

/*CompressImage

Compresses a single-frame image that is currently stored as a pixel map structure.

OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data );
Parameters
src

A handle to the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

A compressor type; see Codec Identifiers.
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned image description structure. Your application should store this image description with the compressed image data.
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. The Image Compression Manager places the actual size of the compressed image into the dataSize field of the ImageDescription structure structure referred to by the desc parameter. This pointer must contain a 32-bit clean address.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The following code sample illustrates the process of compressing and decompressing a pixel map.// CompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CompressImage (
   PixMapHandle              src,
   const Rect                *srcRect,
   CodecQ                    quality,
   CodecType                 cType,
   ImageDescriptionHandle    desc,
   Ptr                       data ){
printf ("CompressImage",src,*srcRect,quality,cType,desc,data);
};


/*DecompressImage

Decompresses a single-frame image into a pixel map structure.

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask );
Parameters
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
desc

A handle to the ImageDescription structure that describes the compressed image.
dst

A handle to the pixel map where the decompressed image is to be displayed. Set the current graphics port to the port that contains this pixel map.
srcRect

A pointer to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by (0,0) and ((**desc).width,(**desc).height). If you want to decompress the entire source image, set this parameter to NIL. If the parameter is NIL, the rectangle is set to the rectangle structure of the ImageDescription structure.
dstRect

A pointer to the rectangle into which the decompressed image is to be loaded. The compressor scales the source image to fit into this destination rectangle.
mode

The transfer mode for the operation, as listed in Graphics Transfer Modes.
mask

A handle to a clipping region in the destination coordinate system. If specified, the compressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Note that DecompressImage is invoked through the StdPix function. The following code sample illustrates the process of compressing and decompressing a pixel map.// DecompressImage coding example
// See "Discovering QuickTime," page 286
PicHandle GetQTCompressedPict (PixMapHandle hpmImage)
{
    long                    lMaxCompressedSize =0;
    Handle                  hCompressedData =NIL;
    Ptr                     pCompressedData;
    ImageDescriptionHandle  hImageDesc =NIL;
    OSErr                   nErr;
    PicHandle               hpicPicture =NIL;
    Rect                    rectImage =(**hpmImage).bounds;
    CodecType               dwCodecType =kJPEGCodecType;
    CodecComponent          codec =(CodecComponent)anyCodec;
    CodecQ                  dwSpatialQuality =codecNormalQuality;
    short                   nDepth =0;          // let ICM choose depth
    nErr =GetMaxCompressionSize(hpmImage, &rectImage, nDepth,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        (CompressorComponent)codec,
                                        &lMaxCompressedSize);
    if (nErr !=noErr)
        return NIL;
 
    hImageDesc =(ImageDescriptionHandle)NewHandle(4);
    hCompressedData =NewHandle(lMaxCompressedSize);
    if ((hCompressedData !=NIL) && (hImageDesc !=NIL)) {
        MoveHHi(hCompressedData);
        HLock(hCompressedData);
        pCompressedData =StripAddress(*hCompressedData);
 
        nErr =CompressImage(hpmImage,
                                        &rectImage,
                                        dwSpatialQuality,
                                        dwCodecType,
                                        hImageDesc,
                                        pCompressedData);
 
        if (nErr ==noErr) {
            ClipRect(&rectImage);
            hpicPicture =OpenPicture(&rectImage);
            nErr =DecompressImage(pCompressedData,
                                        hImageDesc,
                                        hpmImage,
                                        &rectImage,
                                        &rectImage,
                                        srcCopy,
                                        NIL);
            ClosePicture();
        }
        if (theErr || (GetHandleSize((Handle)hpicPicture) ==
                                            sizeof(Picture))) {
            KillPicture(hpicPicture);
            hpicPicture =NIL;
        }
    }
    if (hImageDesc !=NIL)
        DisposeHandle((Handle)hImageDesc);
    if (hCompressedData !=NIL)
        DisposeHandle(hCompressedData);
    return hpicPicture;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressImage (
   Ptr                       data,
   ImageDescriptionHandle    desc,
   PixMapHandle              dst,
   const Rect                *srcRect,
   const Rect                *dstRect,
   short                     mode,
   RgnHandle                 mask ){
printf ("DecompressImage ",desc,dst,*srcRect,*dstRect,mode,mask);
};







/*QTGetPixMapHandleRowBytes

Gets the rowBytes value for a pixel map accessed by a handle.

long QTGetPixMapHandleRowBytes (
   PixMapHandle    pm );
Parameters
pm

A handle to a PixMap structure.
Return Value

The rowBytes value.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

long QTGetPixMapHandleRowBytes (
   PixMapHandle    pm ){
printf ("QTGetPixMapHandleRowBytes ",pm);
};


/*GraphicsImportCreateCGImage

Imports an image as a Core Graphics CGImage.

ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
imageRefOut

A reference to the CG image to be created.
flags

A flag that determines the settings to use.
kGraphicsImportCreateCGImageUsingCurrentSettings

Use the current settings.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: ImageCompression.h*/
ComponentResult GraphicsImportCreateCGImage (
   GraphicsImportComponent    ci,
   CGImageRef                 *imageRefOut,
   UInt32                     flags ){
printf ("GraphicsImportCreateCGImage ",ci,*imageRefOut,flags);
};



/*GetGraphicsImporterForFile

Locates and opens a graphics importer component that can be used to draw a specified file.

OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi );
Parameters
theFile

The file to be drawn using a graphics importer component.
gi

On return, contains a pointer to the ComponentInstance of the graphics importer. If no graphics importer can be found for the specified file, the gi will be set to NIL. If GetGraphicsImporterForFile is able to locate a graphics importer for the file, the returned graphics importer ComponentInstance will already be set up to draw the specified file to the current port.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function first tries to locate a graphics importer component for the specified file based on its file type. If it is unable to locate a graphics importer component based on the Macintosh file type, or the call is made on a non-Macintosh file, GetGraphicsImporterForFile will try to locate a graphics importer component based on the file extension (such as .JPG or .GIF). If a graphics importer cannot be found using the file's type or extension, GetGraphicsImporterForFile asks each graphics importer to validate the file, until it either finds an importer that can handle the file or exhausts the list of possible importers. This validation attempt can be quite time-consuming. To bypass the validation attempt, call GetGraphicsImporterForFileWithFlags instead. The following code sample illustrates the use of GetGraphicsImporterForFile:// Get a graphics importer for the image file, determine the natural size
// of the image, and draw the image
// See "Discovering QuickTime," page 274
void drawFile(const FSSpec *fss, const Rect *boundsRect)
    {
        GraphicsImportComponent gi;
        GetGraphicsImporterForFile(fss, &gi);
        GraphicsImportSetBoundsRect(gi, boundsRect);
        GraphicsImportDraw(gi);
        CloseComponent(gi);
    }

Special Considerations

The caller of GetGraphicsImporterForFile is responsible for closing the returned ComponentInstance using CloseComponent.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetGraphicsImporterForFile (
   const FSSpec         *theFile,
   ComponentInstance    *gi ){
printf ("GetGraphicsImporterForFile ",*theFile,*gi);
};

/*MakeImageDescriptionForPixMap

Fills out an ImageDescription structure corresponding to a PixMap structure.

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh );
Parameters
pixmap

A handle to a PixMap structure.
idh

The handle of an ImageDescription structure. On entry, this parameter normally points to an ImageDescription structure whose contents are NIL. On return, the structure is correctly filled out for the selected PixMap.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr MakeImageDescriptionForPixMap (
   PixMapHandle              pixmap,
   ImageDescriptionHandle    *idh ){
printf ("MakeImageDescriptionForPixMap ",pixmap,*idh);
};


 void 
CustomGetFilePreview(
  FileFilterYDUPP          fileFilter,
  short                    numTypes,
  ConstSFTypeListPtr       typeList,
  StandardFileReply *      reply,
  short                    dlgID,
  Point                    where,
  DlgHookYDUPP             dlgHook,
  ModalFilterYDUPP         filterProc,
  ActivationOrderListPtr   activeList,
  ActivateYDUPP            activateProc,
  void *                   yourDataPtr){
printf ("CustomGetFilePreview",fileFilter,numTypes,typeList,reply,dlgID,where,dlgHook,filterProc,activeList,activateProc,yourDataPtr);
};

void 
StandardGetFilePreview(
  FileFilterUPP        fileFilter,
  short                numTypes,
  ConstSFTypeListPtr   typeList,
  StandardFileReply *  reply){
printf ("StandardGetFilePreview ",fileFilter,numTypes,typeList,reply);
} ;

OSErr
InvokeICMFlushUPP(
  Ptr          data,
  long         bytesAdded,
  long         refcon,
  ICMFlushUPP  userUPP){
printf ("InvokeICMFlushUPP",data,bytesAdded,refcon,userUPP);
};

OSErr
InvokeICMProgressUPP(
  short           message,
  Fixed           completeness,
  long            refcon,
  ICMProgressUPP  userUPP){
printf ("InvokeICMProgressUPP ",message,completeness,refcon,userUPP);
};

OSErr
InvokeICMDataUPP(
  Ptr *       dataP,
  long        bytesNeeded,
  long        refcon,
  ICMDataUPP  userUPP){
printf ("InvokeICMDataUPP ",dataP,bytesNeeded,refcon,userUPP);
};

void 
SFGetFilePreview(
  Point                where,
  ConstStr255Param     prompt,
  FileFilterUPP        fileFilter,
  short                numTypes,
  ConstSFTypeListPtr   typeList,
  DlgHookUPP           dlgHook,
  SFReply *            reply){
printf ("SFGetFilePreview ",where,prompt,fileFilter,numTypes,typeList,dlgHook,reply);
};




















