#include <QuickTime/QuickTime.h>


/*ExitMoviesOnThread

Indicates to QuickTime that the client will no longer be using QuickTime on the current thread.

OSErr ExitMoviesOnThread (void);
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a previous call to EnterMoviesOnThread was not made.
Discussion

This function should be called before exiting from a spawned thread that uses QuickTime. It undoes the setup performed by EnterMoviesOnThread. Each call to EnterMoviesOnThread should be matched with a call to this function. This function should not be called on a thread without a previous call to EnterMoviesOnThread.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExitMoviesOnThread (void){
printf ("ExitMoviesOnThread");
};


/*EnterMoviesOnThread

Indicates that the client will be using QuickTime on the current thread.

OSErr EnterMoviesOnThread (UInt32 inFlags);
Parameters
inFlags

Flag (see below) indicating how the executing thread will use QuickTime. Setting the thread mode is a convenience provided by this function. Pass 0 for the default options. See these constants: 
kQTEnterMoviesFlagDontSetComponentsThreadMode
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. This function returns an appropriate operating system or QuickTime error if the operation couldn't be completed. This might occur because a second call on the thread was made that used incompatible flags (for example, the first call required a shared state but a subsequent call required a private state).
Discussion

This function is analogous to EnterMovies. It initializes QuickTime and prepares QuickTime for calls from its thread. Unlike EnterMovies, this function allows the client to indicate if its access to QuickTime requires sharing of QuickTime state with the main thread. The default is to maintain a private state. 
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr EnterMoviesOnThread (UInt32 inFlags){
printf ("EnterMoviesOnThread ", inFlags);
};

/*MCDoAction

Invokes a movie controller component and makes it perform a specified action.

ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
action

The action to be taken. See Movie Controller Actions.
params

A pointer to the parameter data appropriate to the action. See Movie Controller Actions for information about the parameters required for each supported action.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCDoAction (
   MovieController    mc,
   short              action,
   void               *params ){
printf ("MCDoAction", mc , action , params);
};


/*QTSoundDescriptionGetProperty

Gets a particular property of a sound description.

OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed);
Parameters
inDesc

The sound description being interrogated.
inPropClass

The class of the property being requested. 
inPropID

The ID of the property being requested.
inPropValueSize

The size of the property value buffer.
outPropValueAddress

A pointer to the property value buffer.
outPropValueSizeUsed

The actual size of the returned property value (can be NULL). 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionGetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
QTPropertyValuePtr         outPropValueAddress,
ByteCount                  *outPropValueSizeUsed){
printf ("QTSoundDescriptionGetProperty", inDesc , inPropClass, inPropID, inPropValueSize, outPropValueAddress, *outPropValueSizeUsed);
};


/*QTNewAlias

Creates a Mac OS alias to a file.

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal );
Parameters
fss

A pointer to an FSSpec structure that specifies a file.
alias

On return, a pointer to a handle to a new AliasRecord structure that defines an alias to the file. If the function was unable to create an alias, the handle is set to NIL. This function does not create relative aliases. For further information about Mac OS file aliases, see Chapter 4 of Inside Macintosh: Files.
minimal

If you pass TRUE, the function writes in the AliasRecord structure only the target name, parent directory ID, volume name and creation date, and volume mounting information. If you pass FALSE, it fills out the structure fully.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTNewAlias (
   const FSSpec    *fss,
   AliasHandle     *alias,
   Boolean         minimal ){
printf ("QTNewAlias",*fss,*alias, minimal);
};




/*QTLockContainer

Locks an atom container in memory.

OSErr QTLockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be locked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to lock an atom container before calling QTGetAtomDataPtr to directly access a leaf atom's data. When you have finished accessing a leaf atom's data, you should call QTUnlockContainer. You may make nested pairs of calls to QTLockContainer and QTUnlockContainer; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTLockContainer (
   QTAtomContainer    container ){
printf ("QTLockContainer", container);
};

/*QTFindChildByIndex

Retrieves an atom by index from the child list of the specified parent atom.

QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
index

The index of the atom to be retrieved.
id

A pointer to an uninitialized QTAtomID data structure. On return, if the atom specified by index was found, the QTAtomID data structure contains the atom's ID. If you don't want this function to return the atom's ID, set the value of the id parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and index within that type from a parent atom's child list. The following code illustrates one way to use it:// QTFindChildByIndex coding example
if ((propertyAtom =QTFindChildByIndex (sprite, kParentAtomIsContainer,
    kSpritePropertyImageIndex, 1, NIL)) ==0)
    FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
        kSpritePropertyImageIndex, 1, 1, sizeof(short),&imageIndex,
        NIL));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTAtom QTFindChildByIndex (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   short              index,
   QTAtomID           *id ){
printf ("QTFindChildByIndex",container,parentAtom, atomType, index, *id);
};


/*QTGetAtomDataPtr

Retrieves a pointer to the atom data for a specified leaf atom.

OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be retrieved.
dataSize

On return, contains a pointer to the length, in bytes, of the leaf atom's data.
atomData

On return, contains a pointer to the leaf atom's data.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function in retrieve a pointer to a leaf atom's data so that you can access the data directly.
Special Considerations

To ensure that the pointer returned in the atomData parameter will remain valid if memory is moved, you should call QTLockContainer before you call this function. If you call QTLockContainer, you should call QTUnlockContainer when you have finished using the atomData pointer. If you pass a locked atom container to a function that resizes atom containers, the function returns an error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomDataPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   long               *dataSize,
   Ptr                *atomData ){
printf ("QTGetAtomDataPtr", container, atom, *dataSize, *atomData);
};



/*QTUnlockContainer

Unlocks an atom container in memory.

OSErr QTUnlockContainer (
   QTAtomContainer    container );
Parameters
container

The atom container to be unlocked.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You should call this function to unlock an atom container when you have finished accessing a leaf atom's data. You may make nested pairs of calls to QTLockContainer and this function; you don't need to check the current state of the container first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTUnlockContainer (
   QTAtomContainer    container ){
printf ("QTUnlockContainer" , container);
};





/*QTDisposeAtomContainer

Disposes of an atom container.

OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData );
Parameters
atomData

The atom container to be disposed of.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to dispose of an atom container data structure that was created by QTNewAtomContainer or QTCopyAtom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDisposeAtomContainer (
   QTAtomContainer    atomData ){
printf ("QTDisposeAtomContainer",atomData);
};


/*NewMovieFromProperties

Creates a new movie using movie properties.

OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie );
Parameters
inputPropertyCount

The number of properties in the array passed in inputProperties.
inputProperties

A pointer to a property array describing how to instantiate the movie. See QTNewMoviePropertyElement.
outputPropertyCount

The number of properties in the array passed in outputProperties.
outputProperties

A pointer to a property array to receive output parameters. See QTNewMoviePropertyElement. You may pass NULL if you don't want this information. The caller is responsible for calling the appropriate routines to dispose of any property values returned here. Since callers specify the property classes and IDs, they know who to call to dispose of the property values.
theMovie

A pointer to a variable that receives the new movie.
Return Value

An error code. Returns memFullErr if the function could not allocate memory, paramErr if inputProperties or theMovie is NULL, or noErr if there is no error.
Discussion

This function can be used in all the cases where an existing NewMovieFrom... call is used. When calling this function, you supply a set of input properties that describe the information required to instantiate the movie (its data reference, audio context, visual context, and so on). You can also supply a set of output properties that you may be interested in; for example, information about whether the data reference was changed. See New Movie Property Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus NewMovieFromProperties (
ItemCount                    inputPropertyCount,
QTNewMoviePropertyElement    *inputProperties,
ItemCount                    outputPropertyCount,
QTNewMoviePropertyElement    *outputProperties,
Movie                        *theMovie ){
printf ("NewMovieFromProperties", inputPropertyCount,*inputProperties,outputPropertyCount,*outputProperties,*theMovie);
};

/*GoToBeginningOfMovie

Repositions a movie to play from its start.

void GoToBeginningOfMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Discussion

If the movie is in preview mode, the function goes to the start of the preview segment of the movie. In all other cases, this function goes to the start of the movie, where the movie time value is 0. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GoToBeginningOfMovie (
   Movie    theMovie ){
printf ("GoToBeginningOfMovie", theMovie);
};


/*GetMovieTimeBase

Returns a movie's time base.

TimeBase GetMovieTimeBase (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's TimeBaseRecord structure.
Special Considerations

The Movie Toolbox disposes of a movie's time base when you dispose of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase GetMovieTimeBase (
   Movie    theMovie ){
printf ("GetMovieTimeBase", theMovie);
};



/*StopMovie

Stops the playback of a movie.

void StopMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void StopMovie (
   Movie    theMovie ){
printf ("StopMovie", theMovie);
};



/*GetTrackMedia

Determines the media that contains a track's sample data.

Media GetTrackMedia (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The media identifier for the media that contains the track's sample data. If the function could not locate the media, it sets this returned value to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Media GetTrackMedia (
   Track    theTrack ){
printf ("GetTrackMedia", theTrack);
};



/*SetTimeBaseFlags

Sets the contents of the control flags of a time base.

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
timeBaseFlags

The control flags for this time base (see below). You may set only one flag to 1. Be sure to set unused flags to 0. See these constants: 
loopTimeBase
palindromeLoopTimeBase
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseFlags (
   TimeBase    tb,
   long        timeBaseFlags ){
printf ("SetTimeBaseFlags",tb,timeBaseFlags);
};


/*MoviesTask

Services active movies.

void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. If you set this parameter to NIL, the Movie Toolbox services all of your active movies.
maxMilliSecToUse

Determines the maximum number of milliseconds that MoviesTask can work before returning. If this parameter is 0, MoviesTask services every active movie exactly once and then returns. If the parameter is nonzero, MoviesTask services as many movies as it can in the allotted time before returning. Once the MoviesTask function starts servicing a movie, it cannot stop until it has completely met the requirements of the movie. Consequently, the MoviesTask function may execute for a longer time than that specified in maxMilliSecToUse. However, the function does not start servicing a new movie if the time specified by maxMilliSecToUse has elapsed. The preferred way to use MoviesTask is to set the maxMilliSecToUse parameter to 0; however, if you just want to play one movie, you can call MoviesTask on that one. If your rate is 0, MoviesTask draws that frame and no other.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You should call MoviesTask as often as possible from your application's main event loop. Note that you should call this function after you have performed your own event processing. MoviesTask services only active movies, and only enabled tracks within those active movies.
Special Considerations

Note that the MoviesTask function services only your movies. Your application must give other applications the opportunity to call MoviesTask for their movies.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MoviesTask (
   Movie    theMovie,
   long     maxMilliSecToUse ){
printf ("MoviesTask",theMovie,maxMilliSecToUse);
};


/*UpdateMovie

Ensures that the Movie Toolbox properly displays your movie after it has been uncovered.

OSErr UpdateMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application should call this function during window updating. Don't call MoviesTask at this time; you will observe better display behavior if you call it at the end of your update processing.

This function does not actually update the movie's graphics world. Rather, it invalidates the movie's display state so that the Movie Toolbox redraws the movie the next time you call MoviesTask. If you need to force a movie to be redrawn outside of a window update sequence, your application can call this function and then call MoviesTask to service the movie. The Movie Toolbox determines the portion of the screen to update by examining the graphics port's visible region.

The following code snippet uses this function in a Macintosh Window Manager update sequence:// UpdateMovie coding example
#include <Events.h>
#include <ToolUtils.h>
#include "Movies.h"
void DoUpdate (WindowRef theWindow, Movie theMovie)
{
    BeginUpdate (theWindow);
    UpdateMovie (theMovie);
    EndUpdate (theWindow);
} // DoUpdate

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr UpdateMovie (
   Movie    theMovie ){
printf ("UpdateMovie",theMovie);
};


/*GetMovieTime

Returns a movie's current time both as a time value and in a time structure.

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
currentTime

A pointer to a TimeRecord structure. The function updates this time structure to contain the movie's current time. If you don't want this information, set this parameter to NIL.
Return Value

The time value of the current time.
Discussion

This function returns the movie's current time value in two formats: as a time value and in a time structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieTime (
   Movie         theMovie,
   TimeRecord    *currentTime ){
printf ("GetMovieTime", theMovie,*currentTime);
};

/*SetMovieVisualContext

Targets a movie to render into a visual context.

OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext;
Parameters
movie

The movie.
visualContext

The visual context that the movie will render into. May be NULL..
Return Value

An error code. Returns noErr if there is no error. Returns memFullErr if memory cannot be allocated. Returns kQTVisualContextNotAllowed if the movie is not able to render using a visual context. Returns paramErr if the movie is NULL.
Discussion

When SetMovieVisualContext succeeds, it will retain the QTVisualContext object for its own use. If visualContext is NULL, the movie will not render any visual media. SetMovieVisualContext will fail if a different movie is already using the visual context, so you should first disassociate the other movie by calling SetMovieVisualContext with a NULL visualContext. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieVisualContext (
   Movie      movie,
   QTVisualContextRef    visualContext){
printf ("SetMovieVisualContext", movie,visualContext);
};


/*SetMovieGWorld

Establishes a movie's display coordinate system by setting the graphics world for displaying the movie.

void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

Points to the movie's CGrafPort structure or graphics world. Set this parameter to NIL to use the current graphics port.
gdh

A handle to the movie's GDevice structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

When you use this function, the Movie Toolbox remembers the current background color and background pattern. These are used for erasing in the default movie uncover function; see SetMovieCoverProcs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    port,
   GDHandle    gdh ){
printf (" SetMovieGWorld", theMovie,port, gdh);
};




/*MovieAudioExtractionFillBuffer

Extracts audio from a movie.

OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList            *ioData,
   UInt32                     *outFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
ioNumFrames

A pointer to the number of PCM frames to be extracted.
ioData

A pointer to an AudioBufferList allocated by the caller to hold the extracted audio data.
outFlags

A bit flag that indicates when extraction is complete: kMovieAudioExtractionComplete The extraction process is complete. Value is (1L << 0). See these constants: 
Return Value

An error code. Returns noErr if there is no error.
Discussion

You call this function repeatedly; each call continues extracting audio where the last call left off. The function will extract as many of the requested PCM frames as it can, given the limits of the buffer supplied and the limits of the input movie. ioNumFrames will be updated with the exact number of valid frames being returned. When there is no more audio to extract from the movie, the function will continue to return noErr but will return no further audio data. In this case, the outFlags parameter will have its kMovieAudioExtractionComplete bit set. It is possible that the kMovieAudioExtractionComplete bit will accompany the last buffer of valid data.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionFillBuffer (
   MovieAudioExtractionRef    session,
   UInt32                     *ioNumFrames,
   AudioBufferList           *ioData,
   UInt32                     *outFlags ){
printf ("MovieAudioExtractionFillBuffer", session,*ioNumFrames,*ioData,*outFlags);
};


/*MovieAudioExtractionGetPropertyInfo

Gets information about a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetPropertyInfo (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   QTPropertyValueType        *outPropType,
   ByteCount                  *outPropValueSize,
   UInt32                     *outPropertyFlags ){
printf ("MovieAudioExtractionGetPropertyInfo",session,inPropClass,inPropID,*outPropType,*outPropValueSize, *outPropertyFlags);
};

/*SetMovieSelection

Sets a movie's current selection.

void SetMovieSelection (
   Movie        theMovie,
   TimeValue    selectionTime,
   TimeValue    selectionDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
selectionTime

A time value specifying the starting point of the current selection.
selectionDuration

A time value that specifies the duration of the current selection.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieSelection (
   Movie        theMovie,
   TimeValue    selectionTime,
   TimeValue    selectionDuration ){
printf ("SetMovieSelection", theMovie, selectionTime, selectionDuration);
};

/*AddMediaSampleReference

Works with samples that have already been added to a movie data file.

OSErr AddMediaSampleReference (
   Media                      theMedia,
   long                       dataOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOffset

The offset into the movie data file. This parameter is used differently by each data handler. For example, for the standard HFS data handler, this parameter specifies the offset into the file. This parameter contains either data you add yourself or the data offset returned by GetMediaSampleReference.
size

The number of bytes of sample data to be identified by the reference. This parameter indicates the total number of bytes in the sample data, not the number of bytes per sample. Use numberOfSamples to indicate the number of samples that are contained in the reference.
durationPerSample

The duration of each sample in the reference. You must specify this parameter in the media's time scale. For example, if you are referring to sound that was sampled at 22 kHz in a media that contains a sound track with the same time scale, to add a reference to a single sample you would set durationPerSample to 1. Similarly, if you are referring to video that was recorded at 10 frames per second in a video media that has a time scale of 60, you would set this parameter to 6 to add a reference to a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a sound description structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the reference. For details, see AddMediaSample. If the media does not require a SampleDescription structure, set this parameter to NIL.
sampleFlags

Contains flags (see below) that control the operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the reference to the media, the AddMediaSampleReference function returns the time where the reference was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function does not add sample data to the file or device that contains a media. Rather, it defines references to sample data that you previously added to a movie data file. Instead of actually writing out samples to disk, this function writes out references to existing samples, which you specify in dataOffset and the size parameter. As with AddMediaSample, your application specifies the media for the operation. Note that one reference may refer to more than one sample; all the samples described by a reference must be the same size. This function does not update the movie data file as part of the add operation. Therefore, your application does not have to call BeginMediaEdits before calling AddMediaSampleReference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddMediaSampleReference (
   Media                      theMedia,
   long                       dataOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime ){
printf ("AddMediaSampleReference",theMedia,dataOffset,size,durationPerSample,sampleDescriptionH,numberOfSamples,sampleFlags,*sampleTime);
};


/*DisposeMatte

Disposes of a matte obtained from the GetTrackMatte function.

void DisposeMatte (
   PixMapHandle    theMatte );
Parameters
theMatte

Handle to the matte to be disposed. Your application obtains this handle from GetTrackMatte.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMatte (
   PixMapHandle    theMatte ){
printf ("DisposeMatte",theMatte);
};


/*SetMovieAudioContext

Targets a movie to render into an audio context.

OSStatus SetMovieAudioContext (
   Movie      movie,
   QTAudioContextRef    audioContext;
Parameters
movie

The movie.
audioContext

The audio context that the movie will render into.
Return Value

An error code. Returns noErr if there is no error. .
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioContext (
   Movie      movie,
   QTAudioContextRef    audioContext){
printf ("SetMovieAudioContext",movie,audioContext);
};

/*GetTrackMatte

Retrieves a copy of a track's matte.

PixMapHandle GetTrackMatte (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to a PixMap structure that represents the specified track's matte. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

The matte defines which of the track's pixels are displayed in a movie, and it is valid for the entire duration of the movie.
Special Considerations

You should use DisposeMatte to dispose of the matte when you are finished with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
PixMapHandle GetTrackMatte (
   Track    theTrack ){
printf ("GetTrackMatte",theTrack);
};


/*SetTrackMatte

Sets a track's matte.

void SetTrackMatte (
   Track           theTrack,
   PixMapHandle    theMatte );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
theMatte

A handle to the matte. The Movie Toolbox makes a copy of the matte, including its ColorTable structure and pixels. Consequently, your application must dispose of the matte when you are done with it. Set this parameter to NIL to remove the track's matte.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This matte defines which of the track's pixels are displayed in a movie. You must specify the matte in a PixMap structure. The Movie Toolbox displays the weighted average of the track and its destination based on the corresponding pixel in the matte.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackMatte (
   Track           theTrack,
   PixMapHandle    theMatte ){
printf ("SetTrackMatt",theTrack,theMatte);
};


/*ConvertFileToMovieFile

Converts a file to a movie file and supports a user settings dialog box for import operations.

OSErr ConvertFileToMovieFile (
   const FSSpec         *inputFile,
   const FSSpec         *outputFile,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp,
   MovieProgressUPP     proc,
   long                 refCon );
Parameters
inputFile

A pointer to the file system specification for the file to be converted into a movie file.
outputFile

A pointer to the file specification for the destination movie file.
creator

The creator value for the file if it is a new one.
scriptTag

The script in which the movie file should be converted. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
resID

A pointer to a field that is to receive the resource ID of the file to be converted. If you don't want to receive the resource ID, set this parameter to NIL.
flags

Contains flags (see below) that control movie file conversion and determine whether or not the user settings dialog box appears. See these constants: 
createMovieFileDeleteCurFile
movieToFileOnlyExport
movieFileSpecValid
showUserSettingsDialog
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, it will be used by ConvertFileToMovieFile. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
proc

Points to your progress callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function. See MovieProgressProc for the interface your progress callback must support.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify an input file and convert it to a movie file. Because some conversions may take a nontrivial amount of time, you can pass a standard movie progress function in the proc and refCon parameters.
Special Considerations

Once you are finished working with a movie, you should release the resources used by the movie by calling DisposeMovie. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr ConvertFileToMovieFile (
   const FSSpec         *inputFile,
   const FSSpec         *outputFile,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp,
   MovieProgressUPP     proc,
   long                 refCon ){
printf ("ConvertFileToMovieFile",*inputFile,*outputFile,creator,scriptTag,*resID,flags,userComp,proc,refCon);
};


/*QTSoundDescriptionSetProperty

Sets a particular property of a sound description.

OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress );
Parameters
inDesc

The sound description being modified.
inPropClass

The class of the property being set. 
inPropID

The ID of the property being set.
inPropValueSize

The size of the property value buffer.
inPropValueAddress

A pointer to the property value buffer. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

The following constants identify sound description properties.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionSetProperty (
SoundDescriptionHandle     inDesc,
QTPropertyClass            inPropClass,
QTPropertyID               inPropID,
ByteCount                  inPropValueSize,
ConstQTPropertyValuePtr   inPropValueAddress ){
printf ("QTSoundDescriptionSetProperty",inDesc,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};

/*QTRemoveMoviePropertyListener

Removes a movie property monitoring callback.

OSErr QTRemoveMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTMoviePropertyListenerProc callback.
inUserData

User data to be passed to the callback.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTRemoveMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData ){
printf ("QTRemoveMoviePropertyListener",inMovie,inPropClass,inPropID,inListenerProc,inUserData);
};


/*QTAddTrackPropertyListener

Installs a callback to monitor a track property.

OSErr QTAddTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTTrackPropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine installs a callback to monitor a track property.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTAddTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData ){
printf ("QTAddTrackPropertyListener ",inTrack,inPropClass,inPropID,inListenerProc,inUserData);
};

/*QTRemoveTrackPropertyListener

Removes a track property monitoring callback

OSErr QTRemoveTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTTrackPropertyListenerProc callback. 
inUserData

User data to be passed to the callback. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine removes a track property monitoring callback.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTRemoveTrackPropertyListener (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTTrackPropertyListenerUPP inListenerProc,
   void *inUserData ){
printf ("QTRemoveTrackPropertyListener",inTrack,inPropClass,inPropID,inListenerProc,inUserData);
};

/*QTGetTrackProperty

Returns the value of a specific track property.

OSErr QTGetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   QTPropertyValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns the value of a specific track property. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   QTPropertyValuePtr outPropValueAddress,
   ByteCount *outPropValueSizeUsed ){
printf ("QTGetTrackProperty",inTrack,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};



/*QTGetTrackPropertyInfo

Returns information about the properties of a track.

OSErr QTGetTrackPropertyInfo (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTPropertyValueType *outPropType,
   ByteCount *outPropValueSize,
   UInt32 *outPropertyFlags );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return. 
outPropertyFlags

A pointer to memory allocated to hold property flags on return. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine returns information about the properties of a track.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetTrackPropertyInfo (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   QTPropertyValueType *outPropType,
   ByteCount *outPropValueSize,
   UInt32 *outPropertyFlags ){
printf ("QTGetTrackPropertyInfo",inTrack,inPropClass,inPropID,*outPropType,*outPropValueSize, *outPropertyFlags);
};

/*QTSetTrackProperty

Sets the value of a specific track property.

OSErr QTSetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstQTPropertyValuePtr inPropValueAddress );
Parameters
inTrack

The track for this operation.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the property value.
inPropValueAddress

A pointer to the the property value.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine sets the value of a specific track property.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTSetTrackProperty (
   Track inTrack,
   QTPropertyClass inPropClass,
   QTPropertyID inPropID,
   ByteCount inPropValueSize,
   ConstQTPropertyValuePtr inPropValueAddress ){
printf ("QTSetTrackProperty",inTrack,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*SetMovieVolume

Sets a movie's current volume but does not store the setting in the movie.

void SetMovieVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The current volume setting of the movie represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You can use the constants shown below. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The setting made by this function is not persistent. To store a volume setting in the movie, call SetMoviePreferredVolume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieVolume (
   Movie    theMovie,
   short    volume ){
printf ("SetMovieVolume",theMovie,volume);
};


/*QTAddMoviePropertyListener

Installs a callback to monitor a movie property.

OSErr QTAddMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inListenerProc

A Universal Procedure Pointer to a QTMoviePropertyListenerProc callback.
inUserData

A pointer to user data that will be passed to the callback.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTAddMoviePropertyListener (
   Movie                         inMovie,
   QTPropertyClass               inPropClass,
   QTPropertyID                  inPropID,
   QTMoviePropertyListenerUPP    inListenerProc,
   void                          *inUserData ){
printf ("QTAddMoviePropertyListener",inMovie,inPropClass,inPropID,inListenerProc,inUserData);
};


/*SpriteMediaSetSpriteProperty

Sets the specified property of a sprite or sprite track.

ComponentResult SpriteMediaSetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );
Parameters
mh

The sprite media handler for this operation.
spriteID

The ID of the sprite for this operation. Pass 'Trck' to set the properties of a whole sprite track.
propertyType

A constant (see below) that specifies the property whose value should be set. See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpriteTrackPropertyAllSpritesHitTestingMode
kSpriteTrackPropertyPreferredDepthInterpretationMode
propertyValue

A pointer to the new value of the selected property. The type of data you pass for this parameter depends on the property type.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Function introduced in QuickTime 3 or earlier. The kSpriteTrackPropertyAllSpritesHitTestingMode and kSpriteTrackPropertyPreferredDepthInterpretationMode constants were added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaSetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue ){
printf ("SpriteMediaSetSpriteProperty",mh,spriteID,propertyType,propertyValue);
};


/*SpriteMediaGetSpriteProperty

Retrieves the value of the specified sprite or sprite track property.

ComponentResult SpriteMediaGetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue );
Parameters
mh

The sprite media handler for this operation.
spriteID

The ID of the sprite for this operation. Pass 'Trck' to return the properties of a whole sprite track.
propertyType

A constant (see below) that specifies the property whose value should be retrieved. See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpriteTrackPropertyAllSpritesHitTestingMode
kSpriteTrackPropertyPreferredDepthInterpretationMode
propertyValue

On return, a pointer to the value of the property; the data type of that value depends on the property.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Function introduced in QuickTime 3 or earlier. The kSpriteTrackPropertyAllSpritesHitTestingMode and kSpriteTrackPropertyPreferredDepthInterpretationMode constants were added in QuickTime 6.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaGetSpriteProperty (
   MediaHandler    mh,
   QTAtomID        spriteID,
   long            propertyType,
   void            *propertyValue ){
printf ("SpriteMediaGetSpriteProperty",mh,spriteID,propertyType,propertyValue);
};



/*SpriteMediaHitTestAllSprites

Determines whether any sprites are at a specified location.

ComponentResult SpriteMediaHitTestAllSprites (
   MediaHandler    mh,
   long            flags,
   Point           loc,
   QTAtomID        *spriteHitID );
Parameters
mh

The sprite media handler for this operation.
flags

Specifies flags (see below) that control the hit testing operation. See these constants: 
spriteHitTestBounds
spriteHitTestImage
spriteHitTestInvisibleSprites
spriteHitTestIsClick
spriteHitTestLocInDisplayCoordinates
loc

A point in the coordinate system of the sprite track's movie to test for the existence of a sprite.
spriteHitID

A pointer to a short integer. On return, this integer contains the ID of the frontmost sprite at the location specified by loc. If no sprite exists at the location, the function sets the value of this parameter to 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to determine whether any sprites exist at a specified location in the coordinate system of a sprite track's movie. You can pass flags to this function to control the hit testing operation more precisely. For example, you may want the hit test operation to detect a sprite whose bounding box contains the specified location.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult SpriteMediaHitTestAllSprites (
   MediaHandler    mh,
   long            flags,
   Point           loc,
   QTAtomID        *spriteHitID ){
printf ("SpriteMediaHitTestAllSprites ",mh,flags,loc,*spriteHitID);
};

/*QTSetMovieProperty

Sets the value of a specific movie property.

OSErr QTSetMovieProperty (
   Movie                      inMovie,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the property value.
inPropValueAddress

A pointer to the the property value.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTSetMovieProperty (
   Movie                      inMovie,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress ){
printf ("QTSetMovieProperty ",inMovie,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*GetTrackEnabled

Determines whether a track is currently enabled.

Boolean GetTrackEnabled (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

TRUE if the specified track is currently enabled, FALSE otherwise.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean GetTrackEnabled (
   Track    theTrack ){
printf (" GetTrackEnabled ",theTrack);
};



/*PutUserDataIntoHandle

Returns a handle to a user data structure.

OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h );
Parameters
theUserData

The user data structure.
h

A handle to the UserDataRecord structure pointed to by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutUserDataIntoHandle (
   UserData    theUserData,
   Handle      h ){
printf (" PutUserDataIntoHandle",theUserData,h);
};


/*NewUserDataFromHandle

Creates a new user data structure from a handle.

OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData );
Parameters
h

A handle to the data structure specified in theUserData.
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserDataFromHandle (
   Handle      h,
   UserData    *theUserData ){
printf ("NewUserDataFromHandle",h,*theUserData);
};


/*DisposeUserData

Disposes of a user data structure created by NewUserData.

OSErr DisposeUserData (
   UserData    theUserData );
Parameters
theUserData

The user data structure that is to be disposed of. It is acceptable but unnecessary to pass NIL in this parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DisposeUserData (
   UserData    theUserData ){
printf ("DisposeUserData",theUserData);
};

/*SetMoviePlayHints

Provides information to the Movie Toolbox that can influence movie playback.

void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
flags

The optimizations that can be used with this movie. Each bit in the flags parameter corresponds to a specific optimization (see below). Be sure to set unused flags to 0. See these constants: 

hintsScrubMode

hintsUseSoundInterp

hintsAllowInterlace

hintsAllowBlacklining

hintsDontPurge

hintsInactive

hintsHighQuality
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the Movie Toolbox to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single optimization without altering the settings of other flags.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function accepts a flag in which you specify optimizations that the Movie Toolbox can use during movie playback. These optimizations apply to all of the media structures used by the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePlayHints (
   Movie    theMovie,
   long     flags,
   long     flagsMask ){
printf ("SetMoviePlayHints ",theMovie,flags,flagsMask);
};

/*SetTimeBaseMasterTimeBase

Assigns a master time base to a time base.

void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
master

The master time base to be assigned to this time base. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the slave time scale. This parameter allows you to set an offset between the time base and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or another time base. Don't use this function to assign a master time base to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterTimeBase (
   TimeBase            slave,
   TimeBase            master,
   const TimeRecord    *slaveZero ){
printf ("SetTimeBaseMasterTimeBase",slave,master,*slaveZero);
};

/*EnterMovies

Initializes the Movie Toolbox and creates a private storage area for your application.

OSErr EnterMovies ( void );
Return Value

Be sure to check the value returned by this function before using any other facilities of the Movie Toolbox. See Error Codes. Returns noErr if there is no error.
Discussion

Before calling any Movie Toolbox functions, you must use EnterMovies to initialize the toolbox. Your application may call EnterMovies multiple times. The following code sample demonstrates how your application can call the Gestalt Manager to determine whether the Movie Toolbox is installed, using the selector gestaltQuickTime ('qtim'), before calling EnterMovies://Using the Gestalt Manager with the Movie Toolbox
#include <GestaltEqu.h>
#include <Movies.h>
Boolean IsQuickTimeInstalled (void)
{
    short   error;
    long    result;
 
    error =Gestalt (gestaltQuickTime, &result);
    return (error ==noErr);
}
void main (void)
{
    Boolean qtInstalled;
    .
    .
    .
    qtInstalled =IsQuickTimeInstalled ();
}
// EnterMovies coding example
// See "Discovering QuickTime," page 242
void MyInitMovieToolbox (void)
{
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    EnterMovies();
}
void main (void)
{
    MyInitMovieToolbox();
    CreateMyCoolMovie();
}

Special Considerations

You should initialize any other Macintosh managers your application uses before calling EnterMovies. You do not need to balance calls to EnterMovies with calls to ExitMovies; you need to call ExitMovies only if you finish with the Movie Toolbox long before your application is ready to quit.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In\
Movies.h*/
OSErr EnterMovies ( void ){
printf ("EnterMovies");
};



/*MovieAudioExtractionSetProperty

Sets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_SummaryChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the property value.
inPropValueAddress

A const void pointer that points to the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionSetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   ConstQTPropertyValuePtr    inPropValueAddress ){
printf ("MovieAudioExtractionSetProperty ",session,inPropClass,inPropID,inPropValueSize,inPropValueAddress);
};


/*MovieAudioExtractionBegin

Begins a movie audio extraction session.

OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
flags

Reserved; must be 0.
outSession

A pointer to an opaque session object.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function before doing any movie audio extraction, because you will pass the object returned by outSession to the other movie audio extraction functions. The format of the extracted audio defaults to the summary channel layout of the movie (all right channels mixed together, all left surround channels mixed together, and so on.), 32-bit float, de-interleaved, with the sample rate set to the highest sample rate found in the movie. You can set the audio format to be something else, as long as it is uncompressed and you do it before your first call to MovieAudioExtractionFillBuffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionBegin (
   Movie                      m,
   UInt32                     flags,
   MovieAudioExtractionRef    *outSession ){
printf ("MovieAudioExtractionBegin",m,flags,*outSession);
};



/*BeginMediaEdits

Starts a media-editing session.

OSErr BeginMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use EndMediaEdits to end a media-editing session. You must call BeginMediaEdits before you add samples to a media with the AddMediaSample function. You must also call BeginMediaEdits before calling InsertTrackSegment if you wish InsertTrackSegment to copy media samples instead of copying the segment by reference.// BeginMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr BeginMediaEdits (
   Media    theMedia ){
printf ("BeginMediaEdits",theMedia);
};


/*DisposeTimeBase

Disposes of a time base once you are finished with it.

void DisposeTimeBase (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTimeBase (
   TimeBase    tb ){
printf ("DisposeTimeBase",tb);
};


/*CreateShortcutMovieFile

Creates a movie file that just contains a reference to another movie.

OSErr CreateShortcutMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   Handle          targetDataRef,
   OSType          targetDataRefType );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains movie file creation flags (see below). See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
targetDataRef

A handle to the data referred to by the movie that this function creates.
targetDataRefType

The type of the data referred to by the movie that this function creates; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateShortcutMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   Handle          targetDataRef,
   OSType          targetDataRefType ){
printf ("CreateShortcutMovieFile",*fileSpec,creator,scriptTag,createMovieFileFlags,targetDataRef,targetDataRefType);
};



/*NewTextMediaUPP

Allocates a Universal Procedure Pointer for the TextMediaProc callback.

TextMediaUPP NewTextMediaUPP (
   TextMediaProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewTextMediaProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TextMediaUPP NewTextMediaUPP (
   TextMediaProcPtr    userRoutine ){
printf ("NewTextMediaUPP",userRoutine);
};


/*DisposeTextMediaUPP

Disposes of a TextMediaUPP pointer.

void DisposeTextMediaUPP (
   TextMediaUPP    userUPP );
Parameters
userUPP

A TextMediaUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeTextMediaUPP (
   TextMediaUPP    userUPP ){
printf ("DisposeTextMediaUPP",userUPP);
};

/*TextMediaSetTextProc

Specifies a custom function to be called whenever a text sample is displayed in a movie.

ComponentResult TextMediaSetTextProc (
   MediaHandler    mh,
   TextMediaUPP    TextProc,
   long            refcon );
Parameters
mh

The text media handler obtained by GetMediaHandler.
TextProc

A Universal Procedure Pointer that points to a TextMediaProc callback.
refcon

Indicates a reference constant that will be passed to your callback. Use this parameter to point to a data structure containing any information your function needs. Set this parameter to 0 if you don't need it.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaSetTextProc (
   MediaHandler    mh,
   TextMediaUPP    TextProc,
   long            refcon ){
printf ("TextMediaSetTextProc",mh,TextProc,refcon);
};

/*MovieSearchText

Searches for text in a movie.

OSErr MovieSearchText (
   Movie        theMovie,
   Ptr          text,
   long         size,
   long         searchFlags,
   Track        *searchTrack,
   TimeValue    *searchTime,
   long         *searchOffset );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
text

The text to be searched for.
size

The size of the text.
searchFlags

Flags (see below) that narrow the search process. See these constants: 
searchTextDontGoToFoundTime
searchTextDontHiliteFoundText
searchTextOneTrackOnly
searchTextEnabledTracksOnly
searchTrack

On return, a pointer to the found track.
searchTime

On return, a pointer to the found time.
searchOffset

On return, a pointer to the found offset to the text.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr MovieSearchText (
   Movie        theMovie,
   Ptr          text,
   long         size,
   long         searchFlags,
   Track        *searchTrack,
   TimeValue    *searchTime,
   long         *searchOffset ){
printf ("MovieSearchText",theMovie,text,size,searchFlags,*searchTrack,*searchTime,*searchOffset);
};


/*LoadTrackIntoRam

Loads a track's data into memory.

OSErr LoadTrackIntoRam (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to load. You must specify this time value in the movie's time coordinate system.
duration

The length of the segment to load. Use GetTrackDuration to determine the length of the entire movie. Note that the media handler may load more data than you specify.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

If the track does not fit, the function returns an error. See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr LoadTrackIntoRam (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration,
   long         flags ){
printf ("LoadTrackIntoRam",theTrack,time,duration,flags);
};


/*MediaTimeToSampleNum

Lets you find the sample that contains the data for a specified time.

void MediaTimeToSampleNum (
   Media        theMedia,
   TimeValue    time,
   long         *sampleNum,
   TimeValue    *sampleTime,
   TimeValue    *sampleDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
time

The time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The Movie Toolbox returns the sample number that identifies the sample that contains data for the time specified by the time parameter.
sampleTime

A pointer to a time value. The MediaTimeToSampleNum function updates this time value to indicate the starting time of the sample that contains data for the time specified by the time parameter. This time value is expressed in the media's time scale. Set this parameter to NIL if you don't want this information.
sampleDuration

A pointer to a time value. The Movie Toolbox returns the duration of the sample that contains data for the time specified by the time parameter. This time value is expressed in the media's time scale. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void MediaTimeToSampleNum (
   Media        theMedia,
   TimeValue    time,
   long         *sampleNum,
   TimeValue    *sampleTime,
   TimeValue    *sampleDuration ){
printf ("MediaTimeToSampleNum",theMedia,time,*sampleTime,*sampleDuration);
};




/*NewTrackMedia

Creates a media for a new track.

Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack.
mediaType

The type of media to create; see Media Identifiers. The Movie Toolbox uses this value to find the correct media handler for the new media. If the Movie Toolbox cannot locate an appropriate media handler, it returns an error.
timeScale

Defines the media's time coordinate system.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If you are creating a new media that refers to existing media data, you can use the GetMediaDataRef function to obtain information about the existing data reference. You can then supply information about that reference to this function. Set this parameter to NIL to use the file that is associated with the movie or if the movie does not have a movie file. For example, if you have created the movie using CreateMovieFile or NewMovieFromFile, the Movie Toolbox assumes that the movie's data resides in the file specified at that time. If you have created the movie using the NewMovieFromScrap or NewMovie functions, the movie does not have a movie file.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set this parameter to rAliasType. See Inside Macintosh: Files for more information about aliases and the Alias Manager.
Return Value

A media identifier, referring to the actual data samples used by the track. If the function cannot create a new media, it sets the returned value to NIL.
Discussion

The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewTrackMedia coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Media NewTrackMedia (
   Track        theTrack,
   OSType       mediaType,
   TimeScale    timeScale,
   Handle       dataRef,
   OSType       dataRefType ){
printf ("NewTrackMedia",theTrack,mediaType,timeScale,dataRef,dataRefType);
};


/*MovieAudioExtractionGetProperty

Gets a property of a movie audio extraction session.

OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed);
Parameters
session

The session object returned by MovieAudioExtractionBegin.
inPropClass

Pass the following constant to define the property class: Property of an audio presentation; value is 'audi'.
inPropID

Pass one of these constants to define the property ID: kAudioPropertyID_ChannelLayout The summary audio channel layout of a movie, or any other grouping of audio streams. All like-labeled channels are combined, without duplicates. For example, if there is a stereo (L/R) track, 5 single-channel tracks marked Left, Right, Left Surround, Right Surround and Center, and a 4-channel track marked L/R/Ls/Rs, then the summary AudioChannelLayout will be L/R/Ls/Rs/C, not L/R/L/R/Ls/Rs/C/L/R/Ls/Rs. The value of this constant is 'clay'. See these constants: 
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

The actual size of the property value.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionGetProperty (
   MovieAudioExtractionRef    session,
   QTPropertyClass            inPropClass,
   QTPropertyID               inPropID,
   ByteCount                  inPropValueSize,
   QTPropertyValuePtr         outPropValueAddress,
   ByteCount                  *outPropValueSizeUsed){
printf ("MovieAudioExtractionGetProperty",session,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};

/*sertMediaIntoTrack

Inserts a reference to a media segment into a track.

OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack or GetMovieTrack.
trackStart

A time value specifying where the segment is to be inserted. This time value must be expressed in the movie's time scale. If you set this parameter to -1, the media data is added to the end of the track.
mediaTime

A time value specifying the starting point of the segment in the media. This time value must be expressed in the media's time scale.
mediaDuration

A time value specifying the duration of the media's segment. This time value must be expressed in the media's time scale.
mediaRate

The media's rate. A value of 1.0 indicates the media's natural playback rate. This value should be positive and not 0.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the segment in the media by providing a starting time and duration. You specify the point in the destination track by providing a time in the track. InsertMediaIntoTrack then inserts the media segment into the track at the specified location. The Movie Toolbox determines the duration of the segment in the track based on the media rate and duration information you provide.

Use this function after you have added samples to a media. If you play the track before you call this function, the track does not contain the new media data.

Here's an example of using this function to add atom containers to a track://InsertMediaIntoTrack coding example
long descSize;
QTVRSampleDescriptionHandle qtvrSampleDesc;
 
// Create a QTVR sample description handle
descSize =sizeof(QTVRSampleDescription) + GetHandleSize((Handle) vrWorld)
                            - sizeof(UInt32);
qtvrSampleDesc =(QTVRSampleDescriptionHandle) NewHandleClear (descSize);
(*qtvrSampleDesc)->
size =descSize;
(*qtvrSampleDesc)->
type =kQTVRQTVRType;
 
// Copy the VR world atom container data into the QTVR sample description
BlockMove (*((Handle) vrWorld), &((*qtvrSampleDesc)->
data),
                            GetHandleSize((Handle) vrWorld));
// Now add it to the QTVR track's media
err =BeginMediaEdits (qtvrMedia);
err =AddMediaSample (qtvrMedia, (Handle) nodeInfo, 0,
    GetHandleSize((Handle) nodeInfo), duration,
    (SampleDescriptionHandle) qtvrSampleDesc, 1, 0, &sampleTime);
err =EndMediaEdits (qtvrMedia);
InsertMediaIntoTrack (qtvrTrack, trackTime, sampleTime, duration, 1L<<16);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMediaIntoTrack (
   Track        theTrack,
   TimeValue    trackStart,
   TimeValue    mediaTime,
   TimeValue    mediaDuration,
   Fixed        mediaRate ){
printf ("InsertMediaIntoTrack",theTrack,trackStart,mediaTime,mediaTime,mediaRate);
};



/*GetMediaDuration

Returns the duration of a media.

TimeValue GetMediaDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's duration.
Discussion

The following code sample illustrates the use of GetMediaDuration:// GetMediaDuration coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMediaDuration (
   Media    theMedia ){
printf ("GetMediaDuration",theMedia);
};



/*EndMediaEdits

Ends a media-editing session.

OSErr EndMediaEdits (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code sample illustrates the use of EndMediaEdits:// EndMediaEdits coding example
// See "Discovering QuickTime," page 89
void CreateMyVideoTrack (Movie movie)
{
    Track   track;
    Media   media;
    Rect    rect ={0, 0, 100, 320};
    track =NewMovieTrack(movie,
                FixRatio(rect.right, 1),
                FixRatio(rect.bottom, 1),
                kNoVolume);
    media =NewTrackMedia(track,
                VideoMediaType,
                600,                            // video time scale
                NIL, NIL);
    BeginMediaEdits(media);
    MyAddVideoSamplesToMedia(media, &rect);     // assemble data
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                0,                              // track start time
                0,                              // media start time
                GetMediaDuration(media),
                kFix1);                         // normal speed
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndMediaEdits (
   Media    theMedia ){
printf ("EndMediaEdits",theMedia);
};





/*GetMediaTrack

Determines the track that uses a specified media.

Track GetMediaTrack (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The track identifier of the track that uses the specified media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMediaTrack (
   Media    theMedia ){
printf ("GetMediaTrack ",theMedia);
};


/*CloseMovieStorage

Closes an open movie storage container.

OSErr CloseMovieStorage (
   DataHandler    dh );
Parameters
dh

The data handler component that was returned by a previous call to CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 6. Supersedes CloseMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CloseMovieStorage (
   DataHandler    dh ){
printf ("CloseMovieStorage",dh);
};


/*AddMovieToStorage

Adds a movie to a storage container that was created by CreateMovieStorage.

OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function calls PutMovieIntoStorage internally. If you are writing a custom data handler, make sure it implements DataHGetDataRef. Also implement DataHScheduleData64 and DataHGetFileSize64, or DataHScheduleData and DataHGetFileSize if the data handler does not support 64-bit file offsets, plus DataHWrite64, or DataHWrite if it does not support 64-bit offsets.
Version Notes

Introduced in QuickTime 6. Supersedes AddMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr AddMovieToStorage (
   Movie          theMovie,
   DataHandler    dh ){
printf ("AddMovieToStorage",theMovie,dh);
};



/*MovieAudioExtractionEnd

Ends a movie audio extraction session.

OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session );
Parameters
session

The session object returned by MovieAudioExtractionBegin.
Return Value

An error code. Returns noErr if there is no error.
Discussion

You must call this function when movie audio extraction is complete.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus MovieAudioExtractionEnd (
   MovieAudioExtractionRef    session ){
printf ("MovieAudioExtractionEnd",session);
};



/*NewMovieFromDataRef

Creates a movie from any device with a corresponding data handler.

OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
m

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
flags

Flags (see below) that control the operation of this function. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
id

A pointer to the field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the id parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The toolbox then returns the movie's resource ID number in the field referred to by the id parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
dataRef

The default data reference. This parameter contains a handle to the information that identifies the file to be used to resolve any data references and as a starting point for any Alias Manager searches. The type of information stored in the handle depends upon the value of the dataRefType parameter. For example, if your application is loading the movie from a file, you would refer to the file's alias in this parameter and set the dataRefType parameter to rAliasType. If you do not want to identify a default data reference, set the parameter to NIL.
dataRefType

The type of data reference. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is intended for use by specialized applications that need to instantiate movies from devices not visible to the file system. Most applications should continue to use NewMovieFromFile. You are not restricted to instantiating a movie from a file stored on a Macintosh HFS volume. With this function, you can instantiate a movie from any device.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromDataRef (
   Movie     *m,
   short     flags,
   short     *id,
   Handle    dataRef,
   OSType    dataRefType ){
printf ("NewMovieFromDataRef",*m,flags,*id,dataRef,dataRefType);
};


/*CreateMovieStorage

Creates an empty storage location to hold a movie and opens a data handler to the stored movie with write permission.

OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie container. Your application must use this value when calling other Movie Toolbox functions. If you pass NIL, the Movie Toolbox creates the movie container but does not open it.
newmovie

A pointer to a field that is to receive the returned identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you pass NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are writing a custom data handler, make sure it supports DataHGetDataRef. It must also support DataHWrite64, or DataHWrite if 64-bit offsets are not supported.
Version Notes

Introduced in QuickTime 6. Supersedes CreateMovieFile.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr CreateMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   OSType         creator,
   ScriptCode     scriptTag,
   long           createMovieFileFlags,
   DataHandler    *outDataHandler,
   Movie          *newmovie ){
printf ("CreateMovieStorage",dataRef,dataRefType,creator,scriptTag,createMovieFileFlags,*outDataHandler,*newmovie);
};



/*AddMediaSample2

Adds sample data and a description to a media.

OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataIn

A handle to the sample data. The function adds this data to the media specified by theMedia. You specify the number of bytes of sample data with the size parameter.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
decodeDurationPerSample

The duration of each sample to be added, representing the amount of time that passes while the sample data is being displayed. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60. Note that this is the duration per sample, regardless of the number of samples being added.
displayOffset

A 64-bit time value that specifies the offset between the decode time (the start time of the track plus the duration of all previous samples) and the display time. This value is normally zero unless the sample is frame reordering compressed video.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output. You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Flags that control the add operation; set unused flags to 0: mediaSampleNotSync Indicates that the sample to be added is not a sync sample. Set this flag to 1 if the sample is not a sync sample; set it to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
sampleDecodeTimeOut

A pointer to a time value that represents the sample decode time. After adding the sample data to the media, the function returns in this parameter the time where the sample was inserted. If you don't want to receive this information, set this parameter to NIL.
Return Value

An error code. Returns noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

Your application specifies the sample and the media for the operation. This function updates the media so that it contains the sample data. One call to this function can add several samples to a media. This function replaces AddMediaSample; it adds 64-bit support and support for frame reordering video compression (display offset).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AddMediaSample2 (
   Media                      theMedia,
   const UInt8                *dataIn,
   ByteCount                  size,
   TimeValue64                decodeDurationPerSample,
   TimeValue64                displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  numberOfSamples,
   MediaSampleFlags           sampleFlags,
   TimeValue64                *sampleDecodeTimeOut ){
printf ("AddMediaSample2 ",theMedia,*dataIn,size,decodeDurationPerSample,displayOffset,sampleDescriptionH,numberOfSamples,sampleFlags,*sampleDescriptionH);
};




/*QTNewDataReferenceFromFullPathCFString

Creates an alias data reference from a CFString that represents the full pathname of a file.

OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
filePath

A CFString that represents the full pathname of a file.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You need to specify the syntax of the pathname as one of the QTPathStyle constants. The new alias data reference created can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFullPathCFString (
   CFStringRef    filePath,
   QTPathStyle    pathStyle,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){
printf ("QTNewDataReferenceFromFullPathCFString",filePath,pathStyle,flags,*outDataRef,*outDataRefType);
};


/*QTSoundDescriptionCreate

Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.

OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie
ByteCount                      inMagicCookieSize
QTSoundDescriptionKind         inRequestedKind
SoundDescriptionHandle         *outSoundDesc );
Parameters
inASBD

A description of the format.
inLayout

The audio channel layout (can be NULL if there isn't one).
inLayoutSize

The size of the audio channel layout (should be 0 if inLayout is NULL).
inMagicCookie

The magic cookie for the decompressor (can be NULL if the decompressor doesn't require one).
inMagicCookieSize

The size of the magic cookie (should be 0 if the inMagicCookie parameter is NULL).
inRequestedKind

The kind of sound description to create. 
outSoundDesc

The resulting sound description. The caller must dispose of it with DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSoundDescriptionCreate (
AudioStreamBasicDescription    *inASBD,
AudioChannelLayout             *inLayout,
ByteCount                      inLayoutSize,
void                           *inMagicCookie,
ByteCount                      inMagicCookieSize,
QTSoundDescriptionKind         inRequestedKind,
SoundDescriptionHandle         *outSoundDesc ){
printf ("QTSoundDescriptionCreate",*inASBD,*inLayout,inLayoutSize,inMagicCookie,inMagicCookieSize,inRequestedKind,*outSoundDesc);
};





/*DisposeMovie

Frees any memory being used by a movie, including the memory used by the movie's tracks and media structures.

void DisposeMovie (
   Movie    theMovie );
Parameters
theMovie

Identifies the movie to be freed. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Your application should call this function when it is done working with a movie, as shown in the following example:// DisposeMovie coding example
// See "Discovering QuickTime," page 85
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile | createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See "Creating a Track," below
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovie (
   Movie    theMovie ){
printf ("DisposeMovie",theMovie);
};



/*NewMovieTrack

Creates a new movie track, without a media.

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
width

A fixed number denoting the display width of the track, in pixels.
height

A fixed number denoting the display height of the track, in pixels. Together, the height and width parameters define the track's display rectangle. The upper-left corner of this rectangle lies at (0,0) in the movie's rectangle. The height and width parameters therefore establish the lower-right corner of the track's display rectangle. If you are creating a track that is not displayed, such as a sound track, set the height and width parameters to 0.
trackVolume

The volume setting of the track as a 16-bit, fixed-point number. The high-order 8 bits specify the integer portion; the low-order 8 bits specify the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. Set this parameter to kFullVolume to play the track at its full, natural volume. Set this parameter to kNoVolume to set the volume to 0. See these constants: 
Return Value

The identifier of the new track.
Discussion

Immediately after creating a new track, you should call NewTrackMedia to create a media for the track; a track without a media is of no use. The following code sample creates a new sprite track and media, then calls BeginMediaEdits to prepare to add samples to the media:// NewMovieTrack coding example
// See "Discovering QuickTime," page 349
#define kSpriteMediaTimeScale           600
track =NewMovieTrack(movie, ((long)lTrackWidth << 16),
                            ((long)lTrackHeight << 16), 0);
media =NewTrackMedia(track, SpriteMediaType,
                            kSpriteMediaTimeScale, NIL, 0);
FailOSErr(BeginMediaEdits(media));

Special Considerations

When you add a track to a movie, the Movie Toolbox automatically adjusts the display Rect structure of the movie. You may want to detect these changes by calling GetMovieBox so that you can adjust the size of the movie's display window.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track NewMovieTrack (
   Movie    theMovie,
   Fixed    width,
   Fixed    height,
   short    trackVolume ){
printf ("NewMovieTrack ",theMovie,width,height,trackVolume);
};


/*GetMoviesError

Returns the contents of the current error value and resets the current error value to 0.

OSErr GetMoviesError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the current error value.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The following code sample shows a typical use:// GetMoviesError coding example
// See "Discovering QuickTime," page 256
OSErr QTUtils_SaveMovie (Movie theMovie)
{
    StandardFileReply   mySFReply;
    StringPtr   myPrompt =QTUtils_ConvertCToPascalString(kSavePrompt);
    StringPtr   myFileName =
                    QTUtils_ConvertCToPascalString(kSaveMovieFileName);
    OSErr       myErr =noErr;
    if (theMovie ==NIL)
        return(invalidMovie);
    StandardPutFile(myPrompt, myFileName, &mySFReply);
    if (mySFReply.sfGood) {
        FlattenMovieData(   theMovie,
                            flattenAddMovieToDataFork,
                            &mySFReply.sfFile,
                            FOUR_CHAR_CODE('TVOD'),
                            smSystemScript,
                            createMovieFileDeleteCurFile);
        myErr =GetMoviesError();
    }
    free(myPrompt);
    free(myFileName);
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesError ( void ){
printf ("GetMoviesError");
};





/*PrerollMovie

Prepares a portion of a movie for playback.

OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
Rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

When your application calls PrerollMovie, the Movie Toolbox tells the appropriate media handlers to prepare to play the movie. The media handlers may then load the movie data and perform any other necessary preparations to play the movie, such as allocating sound channels and starting up image-decompression sequences. In this manner, you can eliminate playback stutter when the movie starts playing.

If your application uses QuickTime's Movie Toolbox to play back movies, there are two choices for how to preroll the movie. Like the movie controller, the Movie Toolbox provides a single function call, StartMovie, which will both preroll the movie and start it playing. Unlike the movie controller, the Movie Toolbox function doesn't allow you to specific the rate to play the movie at, but instead assumes the movie's preferred rate.

Calling StartMovie, just like the movie controller's preroll and play action, first prerolls the movie and then sets it playing. If your application requires more control, the Movie Toolbox provides lower level functions that give you more control:// PrerollMovie coding example
StartMovie(theMovie);
TimeValue timeNow;
Fixed playRate;
timeNow =GetMovieTime(theMovie, NIL);
playRate =GetMoviePreferredRate(theMovie);
PrePrerollMovie(theMovie, timeNow, playRate, NIL, NIL);
PrerollMovie(theMovie, timeNow, playRate);
SetMovieRate(theMovie, playRate);

Special Considerations

You should always call PrePrerollMovie before calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrerollMovie (
   Movie        theMovie,
   TimeValue    time,
   Fixed        Rate ){
printf ("PrerollMovie",theMovie,time,Rate);
};



/*GetTrackDuration

Returns the duration of a track.

TimeValue GetTrackDuration (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The duration of the specified track, expressed in the time scale of the movie that contains the track.
Discussion

The duration corresponds to the ending time of the track in the movie's time coordinate system (remember that all tracks start at movie time 0).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackDuration (
   Track    theTrack ){
printf (" GetTrackDuration",theTrack);
};


/*GetMediaSampleDescription

Retrieves a SampleDescription structure from a media.

void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to retrieve. This index corresponds to the structure itself, not to the samples in the media. Index numbers start with 1.
descH

Specifies a handle that is to receive the SampleDescription structure. The Movie Toolbox correctly resizes this handle for the returned structure. If there is no description for the specified index, the function returns this handle unchanged. Your application must allocate and dispose of this handle.
Discussion

The Movie Toolbox identifies a media's sample descriptions with an index value, ranging from 1 to the number of sample descriptions in the media. Sample description indexes provide a convenient way to access each sample description in a media. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Special Considerations

The format of sample descriptions differs by media type. Sample descriptions for image data are defined by ImageDescription structures. Sample descriptions for sound are defined by SoundDescription structures. Sample descriptions for text are defined by TextDescription structures.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH ){
printf ("GetMediaSampleDescription",theMedia,index,descH);
};


/*SampleNumToMediaDecodeTime

Finds the decode time for a specified sample.

void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void SampleNumToMediaDecodeTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration ){
printf ("SampleNumToMediaDecodeTime",theMedia,logicalSampleNum,*sampleDecodeTime,*sampleDecodeDuration);
};


/*MediaDecodeTimeToSampleNum

Finds the sample for a specified decode time.

void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
decodeTime

A 64-bit time value that represents the decode time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a variable that is to receive the sample number. The function returns the sample number that identifies the sample that contains data for the specified decode time, or 0 if it is not found.
sampleDecodeTime

A pointer to a time value. The function updates this time value to indicate the decode time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDecodeDuration

A pointer to a time value. The function updates this time value to indicate the decode duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDecodeTime is out of the decode time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDecodeTimeToSampleNum (
   Media          theMedia,
   TimeValue64    decodeTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDecodeTime,
   TimeValue64    *sampleDecodeDuration ){
printf ("MediaDecodeTimeToSampleNum",theMedia,decodeTime,*sampleNum,*sampleDecodeTime,*sampleDecodeDuration);
};



/*GetMediaSample2

Retrieves sample data from a media file.

OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
dataOut

A pointer to a buffer to receive sample data. The buffer must be large enough to contain at least maxDataSize bytes. If you do not want to receive sample data, pass NULL.
maxDataSize

The maximum number of bytes allocated to hold the sample data.
size

A pointer to memory where the function returns the number of bytes of sample data returned in the memory area specified by dataOut. Set this parameter to NULL if you are not interested in this information.
decodeTime

The starting time of the sample to be retrieved in decode time. You must specify this value in the media's time scale.
sampleDecodeTime

A pointer to a time value in decode time. The function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NULL.
decodeDurationPerSample

A pointer to a time value in decode time. The Movie Toolbox returns the duration of each sample in the media. Set this parameter to NULL if you don't want this information.
displayOffset

A pointer to a time value. The function updates this time value to indicate the display offset of the returned sample. This time value is expressed in the media's time scale. Set this parameter to NULL if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NULL.
sampleFlags

A pointer to a short integer in which the function returns flags that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NULL: mediaSampleNotSync This flag is set to 1 if the sample is not a sync sample and to 0 if the sample is a sync sample. See these constants: 
mediaSampleNotSync
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, maxSizeToGrowTooSmall if the sample data is larger than maxDataSize, or noErr if there is no error.
Discussion

Whereas GetMediaSample takes a resizable Handle and a maxSizeToGrow parameter, GetMediaSample2 takes a pointer and a maxDataSize parameter. If you want to read a sample into a Handle, you can use the following code:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr GetMediaSample2 (
   Media                      theMedia,
   UInt8                      *dataOut,
   ByteCount                  maxDataSize,
   ByteCount                  *size,
   TimeValue64                decodeTime,
   TimeValue64                *sampleDecodeTime,
   TimeValue64                *decodeDurationPerSample,
   TimeValue64                *displayOffset,
   SampleDescriptionHandle    sampleDescriptionH,
   ItemCount                  *sampleDescriptionIndex,
   ItemCount                  maxNumberOfSamples,
   ItemCount                  *numberOfSamples,
   MediaSampleFlags           *sampleFlags ){
printf ("GetMediaSample2",theMedia,*dataOut,maxDataSize,*size,decodeTime,*sampleDecodeTime,*decodeDurationPerSample,*displayOffset,sampleDescriptionH,*sampleDescriptionIndex,maxNumberOfSamples,*numberOfSamples,*sampleFlags);
};


/*GetMediaNextInterestingDecodeTime

Searches for decode times of interest in a media.

void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
interestingTimeFlags

Flags that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, or nextTimeSyncSample flags to 1. Set unused flags to 0: nextTimeMediaSample Set this flag to 1 to search for the next sample. nextTimeMediaEdit Set this flag to 1 to search for the next group of samples. nextTimeSyncSample Set this flag to 1 to search for the next sync sample. nextTimeEdgeOK Set this flag to 1 to accept information about elements that begin or end at the time specified by the decodeTime parameter. When this flag is set the function returns valid information about the beginning and end of a media. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
decodeTime

Specifies the starting point for the search in decode time. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingDecodeTime

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NULL if you are not interested in this information.
interestingDecodeDuration

On return, a pointer to a 64-bit time value in decode time. The Movie Toolbox returns the duration of the interesting time in the media's time coordinate system. Set this parameter to NULL if you don't want this information; this lets the function works faster.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void GetMediaNextInterestingDecodeTime (
   Media          theMedia,
   short          interestingTimeFlags,
   TimeValue64    decodeTime,
   Fixed          rate,
   TimeValue64    *interestingDecodeTime,
   TimeValue64    *interestingDecodeDuration ){
printf ("GetMediaNextInterestingDecodeTime",theMedia,interestingTimeFlags,decodeTime,rate,*interestingDecodeTime,*interestingDecodeDuration);
};



/*GetTrackMovie

Determines the movie that contains a specified track.

Movie GetTrackMovie (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The identifier of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Movie GetTrackMovie (
   Track    theTrack ){
printf ("GetTrackMovie",theTrack);
};

/*GetMediaTimeScale

Determines a media's time scale.

TimeScale GetMediaTimeScale (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

The media's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMediaTimeScale (
   Media    theMedia ){
printf ("GetMediaTimeScale ",theMedia);
};



/*GetMediaSampleCount

Determines the number of samples in a media.

long GetMediaSampleCount (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

The number of samples in the media.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMediaSampleCount (
   Media    theMedia ){
printf ("GetMediaSampleCount ",theMedia);
};


/*GetMediaDisplayDuration

Returns the display duration of a media.

TimeValue64 GetMediaDisplayDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's display duration. A media's display duration is its display end time minus its display start time. For media without nonzero display offsets, the decode duration and display duration are the same.
Discussion

When inserting media with display offsets into a track, use display time:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDisplayDuration (
   Media    theMedia ){
printf ("GetMediaDisplayDuratio",theMedia);
};


/*GetTrackNextInterestingTime

Searches for times of interest in a track.

void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works more quickly.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. In this case, sync samples don't rely on preceding frames for content. You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackNextInterestingTime (
   Track        theTrack,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration ){
printf ("GetTrackNextInterestingTime ",theTrack,interestingTimeFlags,time,rate,*interestingTime,*interestingDuration);
};


/*GetTrackEditRate

Returns the rate of the track edit of a specified track at an indicated time.

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime );
Parameters
theTrack

The track identifier for which the rate of a track edit (at the time given in the atTime parameter) is to be determined.
atTime

Indicates a time value at which the rate of a track edit (of a track identified in the parameter theTrack) is to be determined.
Return Value

The rate of the track edit of the specified track at the specified time.
Discussion

This function is useful if you are stepping through track edits directly in your application or if you are a client of QuickTime's base media handler.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetTrackEditRate (
   Track        theTrack,
   TimeValue    atTime ){
printf ("GetTrackEditRate",theTrack,atTime);
};


/*CopyMediaMutableSampleTable

Obtains information about sample references in a media in the form of a sample table.

OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
startDecodeTime

A 64-bit time value that represents the starting decode time of the sample references to be retrieved. You must specify this value in the media's time scale.
sampleStartDecodeTime

A pointer to a time value. The function updates this time value to indicate the actual decode time of the first returned sample reference. If you are not interested in this information, set this parameter to NULL. The returned time may differ from the time you specified with the startDecodeTime parameter. This will occur if the time you specified falls in the middle of a sample.
maxNumberOfSamples

A 64-bit signed integer that contains the maximum number of sample references to be returned. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate to the media.
maxDecodeDuration

A 64-bit time value that represents the maximum decode duration to be returned. The function does not return samples with greater decode duration than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media.
sampleTableOut

A reference to an opaque sample table object. When you are done with the returned sample table, release it with QTSampleTableRelease.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

To find out how many samples were returned in the sample table, call QTSampleTableGetNumberOfSamples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr CopyMediaMutableSampleTable (
   Media                      theMedia,
   TimeValue64                startDecodeTime,
   TimeValue64                *sampleStartDecodeTime,
   SInt64                     maxNumberOfSamples,
   TimeValue64                maxDecodeDuration,
   QTMutableSampleTableRef    *sampleTableOut ){
printf ("CopyMediaMutableSampleTable",theMedia,startDecodeTime,*sampleStartDecodeTime,maxNumberOfSamples,maxDecodeDuration,*sampleTableOut);
};


/*QTSampleTableGetNumberOfSamples

Returns the number of samples in a sample table.

SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object.
Return Value

A 64-bit signed integer that contains the number of samples, or 0 if sampleTable is NULL.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
SInt64 QTSampleTableGetNumberOfSamples (
   QTSampleTableRef    sampleTable ){
printf ("QTSampleTableGetNumberOfSamples",sampleTable);
};


/*QTSampleTableGetDecodeDuration

Returns the decode duration of a sample.

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the decode duration of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 QTSampleTableGetDecodeDuration (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetDecodeDuration",sampleTable,sampleNum);
};

/*GetMovieRate

Returns a movie's playback rate.

Fixed GetMovieRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The rate at which the movie is currently playing, expressed as a 32-bit fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. A value of 1 indicates normal speed, a value of 2 indicates double speed, -2 means the movie is playing backward at double speed, and so on. A value of 0 means the movie is paused or stopped.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Fixed GetMovieRate (   Movie    theMovie ){
printf ("GetMovieRate",theMovie);
};

/*MCGetControllerBoundsRect

Returns a movie controller's boundary rectangle.

ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that is to receive the coordinates of the movie controller's boundary rectangle. If there is insufficient screen space to display the controller, the function may return an empty structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCGetControllerBoundsRect (
   MovieController    mc,
   Rect               *bounds ){
printf ("MCGetControllerBoundsRect ",mc,*bounds);
};


/*StartMovie

Starts the movie playing from the current movie time.

void StartMovie (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

You are not required to call this function to start a movie. It is included in the QuickTime API for convenience. Before playing the movie, the Movie Toolbox makes the movie active, prerolls the movie, and sets the movie to its preferred playback rate. You can use SetMoviePreferredRate to change this setting. 
Special Considerations

A movie's current time is saved when a movie is stored in a movie file. Therefore, your application should appropriately position a movie before playing the movie. Use GoToBeginningOfMovie to set a movie to play from its start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void StartMovie (
   Movie    theMovie ){
printf ("StartMovie ",theMovie);
};


/*MCDraw

Responds to an update event.

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the update event has occurred.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCDraw (
   MovieController    mc,
   WindowRef          w ){
printf ("MCDraw ",mc,w);
};

/*GetMovieNaturalBoundsRect

Gets a movie's natural boundary rectangle.

void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
naturalBounds

A pointer to a Rect structure that represents the movie's bounding rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieNaturalBoundsRect (
   Movie    theMovie,
   Rect     *naturalBounds ){
printf ("GetMovieNaturalBoundsRect",theMovie,*naturalBounds);
};



/*MCClick

Lets a controller respond when the user clicks in a movie controller window.

ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
where

The location of the click. This value is expressed in the local coordinates of the window specified by the w parameter. Your application must convert this value from the global coordinates returned in the EventRecord structure.
when

Indicates when the user pressed the mouse button. You obtain this value from the EventRecord structure.
modifiers

Specifies modifier flags for the event. You obtain this value from the EventRecord structure.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClick (
   MovieController    mc,
   WindowRef          w,
   Point              where,
   long               when,
   long               modifiers ){
printf ("MCClick ",mc,w,where,when,modifiers);
};


/*DisposeMovieController

Disposes of a movie controller.

void DisposeMovieController (
   ComponentInstance    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from the Component Manager's OpenComponent or OpenDefaultComponent function, or from the NewMovieController function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function is implemented by the Movie Toolbox, not by movie controller components. If you are creating your own movie controller component, you do not have to support this function. The following code snippet illustrates its use:// DisposeMovieController coding example
// See "Discovering QuickTime," page 221
// Resource identifiers
#define IDM_OPEN         101
char            szMovieFile[MAX_PATH];              // Name of movie file
Movie           movie;                              // Movie object
MovieController mc;                                 // Movie controller
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    ...
    ...
    InitializeQTML(0);                          // Initialize QuickTime
    EnterMovies();                              // Initialize Toolbox
    ...
    //  Main message loop
    ...
    ExitMovies();                               // Terminate Toolbox
    TerminateQTML();                            // Terminate QuickTime
}  // end WinMain
//
LRESULT CALLBACK WndProc (HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
    MSG             msg;
    EventRecord     er;
 
    . . .                                       // Fill in contents of MSG structure
 
    WinEventToMacEvent(&msg, &er);                  // Convert message to a QT event
    MCIsPlayerEvent(mc, (const EventRecord *)&er);  // Pass event to movie controller
 
    switch (iMsg) {
        case WM_CREATE:
            CreatePortAssociation(hwnd, NIL, 0L);  // Register window with QT
            break;
        case WM_COMMAND:
            switch (LOWORD(wParam)) {
                case IDM_OPEN:
                    MyCloseMovie();                 // Close previous movie, if any
 
                    if (MyGetFile(szMovieFile))         // Get file name from user
                        MyOpenMovie(hwnd, szMovieFile); // Open the movie
                    break;
                    . . .
                default:
                    return DefWindowProc(hwnd, iMsg, wParam, lParam);
            }  // end switch (LOWORD(wParam))
            break;
        case WM_CLOSE:
            DestroyPortAssociation(GetNativeWindowPort(hwnd));  // Unregister window
            break;
        . . .
        default:
            return DefWindowProc(hwnd, iMsg, wParam, lParam);
 
    }  // end switch (iMsg)
 
    return 0;
}  // end WndProc
//
BOOL MyGetFile (char *lpszMovieFile)
{
    OPENFILENAME         ofn;
 
    // Fill in contents of OPENFILENAME structure
                ...
                ...
 
     if (GetOpenFileName(&ofn))                     // Let user select file
        return TRUE;
    else
        return FALSE;
}  // end MyGetFile
//
void MyOpenMovie (HWND hwnd, char szFileName[255])
{
    short   nFileRefNum =0;
    FSSpec  fss;
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);   // Set graphics port
    NativePathNameToFSSpec(szFileName, &fss, 0);    // Convert pathname and make FSSpec
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);    // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,     // Get movie from file
                    NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                    // Close movie file
 
    mc =NewMovieController(movie, ...);            // Make movie controller
        ...
        ...
 
}  // end MyOpenMovie
//
void MyCloseMovie (void)
{
    if (mc)                                     // Destroy movie controller, if any
        DisposeMovieController(mc);
 
    if (movie)                                  // Destroy movie object, if any
        DisposeMovie(movie);
}  // end MyCloseMovie

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieController (
   ComponentInstance    mc ){
printf ("DisposeMovieController",mc);
};


/*SetTrackEnabled

Enables or disables a track.

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
isEnabled

Enables or disables the track. Set this parameter to TRUE to enable the track. Set this parameter to FALSE to disable the track.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox services only enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackEnabled (
   Track      theTrack,
   Boolean    isEnabled ){
printf ("SetTrackEnabled",theTrack,isEnabled);
};


/*SetMovieRate

Sets a movie's playback rate.

void SetMovieRate (
   Movie    theMovie,
   Fixed    rate );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
rate

The new movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates. This value immediately changes the rate at which the movie is playing. A value of 1 starts the movie playing at normal speed, a value of 2 causes the movie to play at double speed, -2 starts the movie playing backward at double speed, and so on. A value of 0 stops the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Use this function to change the speed at which a movie is playing. You do not normally use this function to start and stop movies; use the higher level functions StartMovie and StopMovie instead. If you start a movie using this function, you should call PrePrerollMovie and PrerollMovie first, to set up any network connections, buffers, and data structures necessary to play the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieRate (
   Movie    theMovie,
   Fixed    rate ){
printf ("SetMovieRate",theMovie,rate);
};


/*QTMetaDataRelease

Decrements the retain count of a metadata object.

void QTMetaDataRelease ( QTMetaDataRef inMetaData );
Discussion

This function releases a metadata object by decrementing its reference count. When the count becomes 0 the memory allocated to the object is freed and the object is destroyed. If you retain a metadata object you are responsible for releasing it when you no longer need it.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTMetaDataRelease ( QTMetaDataRef inMetaData ){
printf ("QTMetaDataRelease",inMetaData);
};


/*QTMetaDataGetItemProperty

Returns a property of a metadata item.

OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
inPropValueSize

Size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the item's property value.
outPropValueSizeUsed

On return, the actual size of buffer space used.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the property being asked about, buffersTooSmall if the allocated buffer is too small to hold the property, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemProperty (
QTMetaDataRef         inMetaData,
QTMetaDataItem        inItem,
QTPropertyClass       inPropClass,
QTPropertyID          inPropID,
ByteCount             inPropValueSize,
QTPropertyValuePtr    outPropValueAddress,
ByteCount             *outPropValueSizeUsed ){
printf ("QTMetaDataGetItemProperty",inMetaData,inItem,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};

/*QTMetaDataGetItemPropertyInfo

Returns information about a property of a metadata item.

OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags );
Parameters
inMetaData

The metadata object for this operation.
inItem

The opaque, unique UInt64 identifier of the metadata item for this operation. Your application obtains this item identifier from such functions as QTMetaDataAddItem and QTMetaDataGetNextItem.
inPropClass

The class of the property being asked about.
inPropID

The ID of the property being asked about.
outPropType

A pointer to the type of the returned property's value.
outPropValueSize

A pointer to the size of the returned property's value.
outPropFlags

On return, a pointer to flags representing the requested information about the item's property.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, errPropNotSupported if the metatada object does not support the item property being asked about, or noErr if there is no error. See Metadata Error Codes.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetItemPropertyInfo (
QTMetaDataRef          inMetaData,
QTMetaDataItem         inItem,
QTPropertyClass        inPropClass,
QTPropertyID           inPropID,
QTPropertyValueType    *outPropType,
ByteCount              *outPropValueSize,
UInt32                 *outPropFlags ){
printf ("QTMetaDataGetItemPropertyInfo",inMetaData,inItem,inPropClass,inPropID,*outPropType,*outPropValueSize,*outPropFlags);
};


/*OpenMovieFile

Opens a specified movie file.

OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission );
Parameters
fileSpec

A pointer to the FSSpec structure for the movie file to be opened.
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. This reference number refers to the file fork that contains the movie resource. If the movie is stored in the data fork of the file, the returned reference number corresponds to the data fork.
permission

The permission level for the file (see below). If your application is only going to play the movie that is stored in the file, you can open the file with read permission. If you plan to add data to the file or change data in the file, you should open the file with write permission. See these constants: 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application must open a movie file before reading movie data from it or writing movie data to it. You can open a movie file more than once; be sure to call CloseMovieFile once for each time you call this function. Note that opening the movie file with write permission does not prevent other applications from reading data from the movie file.

If the specified file has a resource fork, this function opens the resource fork and returns a file reference number to the resource fork. If the movie file does not have a resource fork (that is, it is a single-fork movie file), this function opens the data fork instead. In this case, your application cannot use AddMovieResource with the movie file.

The following is an example of using OpenMovieFile:// OpenMovieFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by OpenMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr OpenMovieFile (
   const FSSpec    *fileSpec,
   short           *resRefNum,
   SInt8           permission ){
printf ("OpenMovieFile ",*fileSpec,*resRefNum,permission);
};


/*GetTimeBaseMasterClock

Determines the clock component that is assigned to a time base.

ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
Return Value

A reference to a component instance. If a clock component is not assigned to the time base, the returned reference is NIL. In this case, the time base relies on another time base for its time source. Use GetTimeBaseMasterTimeBase to obtain the time base reference to that master time base.
Discussion

This function returns a reference to a component instance of the clock component that provides a time source to the specified time base. Every time base derives its time from either a clock component or from another time base. If a time base derives its time from a clock component, use this function to obtain the component instance of the clock component.
Special Considerations

The Component Manager allows a single component to serve multiple client applications at the same time. Each client application has a unique connection to the component, identified by a component instance. Don't close this connection; the time base is using it to maintain its time source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance GetTimeBaseMasterClock (
   TimeBase    tb ){
printf ("GetTimeBaseMasterClock",tb);
};

/*DisposeSpriteWorld

Disposes of a sprite world.

void DisposeSpriteWorld (
   SpriteWorld    theSpriteWorld );
Parameters
theSpriteWorld

The sprite world to dispose of. It is safe to pass NIL to this function.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You call this function to dispose of a sprite world created by NewSpriteWorld. This function also disposes of all of the sprites associated with the sprite world. This function does not dispose of the graphics worlds associated with the sprite world. Here is an example of using it:// DisposeSpriteWorld coding example
// See "Discovering QuickTime," page 347
#define kNumSprites             4
#define kNumSpaceShipImages     24
SpriteWorld                 gSpriteWorld =NIL;
Sprite                      gSprites[kNumSprites];
Handle                      gCompressedPictures[kNumSpaceShipImages];
ImageDescriptionHandle      gImageDescriptions[kNumSpaceShipImages];
void MyDisposeEverything (void)
{
    short           nIndex;
    // dispose of the sprite world and associated graphics world
    if (gSpriteWorld)
        DisposeSpriteWorld(gSpriteWorld);
 
    // dispose of each sprite's image data
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        if (gCompressedPictures[nIndex])
            DisposeHandle(gCompressedPictures[nIndex]);
        if (gImageDescriptions[nIndex])
            DisposeHandle((Handle)gImageDescriptions[nIndex]);
    }
    DisposeGWorld(spritePlane);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeSpriteWorld (
   SpriteWorld    theSpriteWorld ){
printf ("DisposeSpriteWorld",theSpriteWorld);
};


/*GetMoviePreferredRate

Returns a movie's default playback rate.

Fixed GetMoviePreferredRate (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's default playback rate.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Fixed GetMoviePreferredRate (
   Movie    theMovie ){
printf ("GetMoviePreferredRate",theMovie);
};



/*QTMetaDataGetNextItem

Returns the next metadata item corresponding to a specified key.

OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem );
Parameters
inMetaData

The metadata object for this operation.
inMetaDataFormat

The metadata storage format used by the object passed in inMetaData. The format may be UserData storage, iTunes metadata storage, or QuickTime metadata storage. Not all objects will include all forms of storage, and other storage formats may appear in the future. Pass kQTMetaDataStorageFormatWildcard to target all storage formats.
inCurrentItem

The opaque, unique UInt64 identifier of the current metadata item to start the search. Your application obtains this item identifier from such functions as QTMetaDataAddItem.
inKeyFormat

The format of the key.
inKeyPtr

A pointer to the key of the item to be fetched next. You may pass NULL in this parameter if you are not interested in any specific key.
inKeySize

The size of the key in bytes.
outNextItem

The ID of the next metadata item after the item specified by inCurrentItem that has the specified key.
Return Value

Returns kQTMetaDataInvalidMetaDataErr if the metadata object or its reference is invalid, kQTMetaDataInvalidItemErr if the metatada item ID is invalid, kQTMetaDataInvalidStorageFormatErr if the metatada storage format is invalid, kQTMetaDataInvalidKeyErr if the key or its format is invalid, kQTMetaDataNoMoreItemErr if the last item has been fetched, or noErr if there is no error. See Metadata Error Codes.
Discussion

If the item designated by inCurrentItem is kQTMetaDataItemUninitialized, the function returns the first item with the specified key in the storage format. If it refers to a valid item in the storage format, the function will return the next item with the key after the item designated by inCurrentItem.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTMetaDataGetNextItem (
QTMetaDataRef              inMetaData,
QTMetaDataStorageFormat    inMetaDataFormat,
QTMetaDataItem             inCurrentItem,
QTMetaDataKeyFormat        inKeyFormat,
const UInt8                *inKeyPtr,
ByteCount                  inKeySize,
QTMetaDataItem             *outNextItem ){
printf ("QTMetaDataGetNextItem",inMetaData,inMetaDataFormat,inCurrentItem,inKeyFormat,*inKeyPtr,inKeySize,*outNextItem);
};



/*QTCopyMovieMetaData

Retains a movie's metadata object and returns it.

OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
outMetaData

A pointer to an opaque metadata object wrapper associated with the movie passed in inMovie.
Return Value

Returns invalidMovie if the movie passed in inMovie is invalid, or noErr if there is no error. 
Discussion

This function returns the metadata object associated with a movie. The object has retain/release semantics. It has already been retained before returning, but you should call QTMetaDataRelease when you are done. Because the movie can be disposed of at any time, the QTMetaDataRef may be valid when the movie no longer exists. In this case, the function will fail with a kQTMetaDataInvalidMetaDataErr error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTCopyMovieMetaData (
Movie            inMovie,
QTMetaDataRef    *outMetaData ){
printf ("QTCopyMovieMetaData",inMovie,*outMetaData);
};



/*GetMovieTimeScale

Returns the time scale of a movie.

TimeScale GetMovieTimeScale (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A long integer that contains the movie's time scale.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeScale GetMovieTimeScale (
   Movie    theMovie ){
printf ("GetMovieTimeScale",theMovie);
};


/*GetMovieIndTrackType

Searches for all of a movie's tracks that share a given media type or media characteristic.

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
index

The index value of the track for this operation. This is not that same as the track's index value in the movie. Rather, this parameter is an index into the set of tracks that meet your other selection criteria.
trackType

Contains either a media type or a media characteristic value. The toolbox applies this value to the search, and returns information about tracks that meet this criterion. You indicate whether you have specified a media type or characteristic value by setting the flags parameter appropriately.
flags

Contains flags (see below) that control the search operation. Note that you may not set both movieTrackMediaType and movieTrackCharacteristic to 1. See these constants: 
movieTrackMediaType
movieTrackCharacteristic
movieTrackEnabledOnly
Return Value

A track identifier.
Discussion

The toolbox returns the track identifier that corresponds to the track that meets your selection criteria. If the toolbox cannot find a matching track, in returns a value of NIL. Note that the index parameter does not work the same way that is does in GetMovieIndTrack. With GetMovieIndTrackType, the index parameter specifies an index into the set of tracks that meet your other selection criteria. For example, in order to find the third track that supports the sound characteristic, you would call the function in the following manner:theTrack =GetMovieIndTrackType (theMovie, 3, AudioMediaCharacteristic, movieTrackCharacteristic);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Track GetMovieIndTrackType (
   Movie     theMovie,
   long      index,
   OSType    trackType,
   long      flags ){
printf ("GetMovieIndTrackType",theMovie,index,trackType,flags);
};




/*GetMediaDecodeDuration

Returns the decode duration of a media.

TimeValue64 GetMediaDecodeDuration (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's decode duration. A media's decode duration is the sum of the decode durations of its samples.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 GetMediaDecodeDuration (
   Media    theMedia ){
printf ("GetMediaDecodeDuration",theMedia);
};



/*TrackTimeToMediaDisplayTime

Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.

TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack );
Parameters
value

A 64-bit time value that represents the track's time value; it must be expressed in the time scale of the movie that contains the track.
theTrack

A track identifier, which your application obtains from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A 64-bit time value that represents the corresponding time in media display time, in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 TrackTimeToMediaDisplayTime (
   TimeValue64    value,
   Track          theTrack ){
printf ("TrackTimeToMediaDisplayTime",value,theTrack);
};



/*QTSampleTableGetDataSizePerSample

Returns the data size of a sample.

ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The size of the sample in bytes. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
ByteCount QTSampleTableGetDataSizePerSample (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetDataSizePerSample",sampleTable,sampleNum);
};



/*QTSampleTableGetSampleFlags

Returns the media sample flags of a sample.

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A constant that describes characteristics of the sample (see below). Returns 0 if sampleTable is NULL or if the sample number is out of range.
Discussion

This function can return one or more of the following constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

MediaSampleFlags QTSampleTableGetSampleFlags (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetSampleFlags",sampleTable,sampleNum);
};

/*QTSampleTableCopySampleDescription

Retrieves a sample description from a sample table.

OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleDescriptionID

The sample description ID.
mediaSampleDescriptionIndexOut

A pointer to a variable to receive a media sample description index. If the sample description came from a media, this is the index that could be passed to GetMediaSampleDescription to retrieve the same sample description handle. The index will be 0 if the sample description did not come directly from a media. Pass NULL if you do not want to receive this information.
sampleDescriptionHOut

A pointer to a variable to receive a newly allocated sample description handle. Pass NULL if you do not want one. The caller is responsible for disposing the returned sample description handle using DisposeHandle.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableCopySampleDescription (
   QTSampleTableRef           sampleTable,
   QTSampleDescriptionID      sampleDescriptionID,
   long                       *mediaSampleDescriptionIndexOut,
   SampleDescriptionHandle    *sampleDescriptionHOut ){
printf ("QTSampleTableCopySampleDescription",sampleTable,sampleDescriptionID,*mediaSampleDescriptionIndexOut,*sampleDescriptionHOut);
};





/*SampleNumToMediaDisplayTime

Finds the display time for a specified sample.

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
logicalSampleNum

A 64-bit signed integer that contains the sample number.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

void SampleNumToMediaDisplayTime (
   Media          theMedia,
   SInt64         logicalSampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration ){
printf ("SampleNumToMediaDisplayTime ",theMedia,logicalSampleNum,*sampleDisplayTime,*sampleDisplayDuration);
};

/*QTSampleTableGetProperty

Returns the value of a specific sample table property.

OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
sampleTable

A reference to an opaque sample table object.
inPropClass

Pass the following constant to define the property class: kQTPropertyClass_SampleTable = 'qtst' Property of a sample table. See these constants: 
kQTPropertyClass_SampleTable
inPropID

Pass one of these constants to define the property ID: kQTSampleTablePropertyID_TotalDecodeDuration = 'tded' The total decode duration of all samples in the sample table. Read-only. kQTSampleTablePropertyID_MinDisplayOffset = '<ddd' The least display offset in the table. Negative offsets are less than positive offsets. Read-only. kQTSampleTablePropertyID_MaxDisplayOffset = '>ddd' The greatest display offset in the table. Positive offsets are greater than negative offsets. Read-only. kQTSampleTablePropertyID_MinRelativeDisplayTime = '<dis' The least display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. kQTSampleTablePropertyID_MaxRelativeDisplayTime = '>dis' The greatest display time of all samples in the table, relative to the decode time of the first sample in the table. Read-only. See these constants: 
kQTSampleTablePropertyID_TotalDecodeDuration
kQTSampleTablePropertyID_MinDisplayOffset
kQTSampleTablePropertyID_MaxDisplayOffset
kQTSampleTablePropertyID_MinRelativeDisplayTime
kQTSampleTablePropertyID_MaxRelativeDisplayTime
inPropValueSize

The size of the buffer allocated to receive the property value.
outPropValueAddress

A pointer to the buffer allocated to receive the property value.
outPropValueSizeUsed

On return, the actual size of the property value written to the buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus QTSampleTableGetProperty (
   QTSampleTableRef      sampleTable,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed ){
printf ("QTSampleTableGetProperty",sampleTable,inPropClass,inPropID,inPropValueSize,outPropValueAddress,*outPropValueSizeUsed);
};


/*QTSampleTableRelease

Decrements the retain count of a sample table.

void QTSampleTableRelease (
   QTSampleTableRef    sampleTable );
Parameters
sampleTable

A reference to an opaque sample table object. If you pass NULL in this parameter, nothing happens.
Discussion

If the retain count decreases to zero, the sample table is disposed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void QTSampleTableRelease (
   QTSampleTableRef    sampleTable ){
printf ("QTSampleTableRelease ",sampleTable);
};


/*MediaDisplayTimeToSampleNum

Finds the sample number for a specified display time.

void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
displayTime

A 64-bit time value that represents the display time for which you are retrieving sample information. You must specify this value in the media's time scale.
sampleNum

A pointer to a long integer that is to receive the sample number. The function returns the sample number that identifies the sample for the specified display time, or 0 if it is not found.
sampleDisplayTime

A pointer to a time value. The function updates this time value to indicate the display time of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
sampleDisplayDuration

A pointer to a time value. The function updates this time value to indicate the display duration of the sample specified by the logicalSampleNum parameter. This time value is expressed in the media's time scale. Set this parameter to NULL if you do not want this information.
Discussion

You can access this function's error returns through GetMoviesError and GetMoviesStickyError. It returns paramErr if there is a bad parameter value, invalidTime if sampleDisplayTime is out of the display time range, or noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
void MediaDisplayTimeToSampleNum (
   Media          theMedia,
   TimeValue64    displayTime,
   SInt64         *sampleNum,
   TimeValue64    *sampleDisplayTime,
   TimeValue64    *sampleDisplayDuration ){
printf ("MediaDisplayTimeToSampleNum",theMedia,displayTime,*sampleNum,*sampleDisplayTime,*sampleDisplayDuration);
};


/*GetMediaAdvanceDecodeTime

Returns the advance decode time of a media.

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
Return Value

A 64-bit time value that represents the media's advance decode time. A media's advance decode time is the absolute value of the greatest-magnitude negative display offset of its samples, or 0 if there are no samples with negative display offsets. This is the amount that the decode time axis must be adjusted ahead of the display time axis to ensure that no sample's adjusted decode time is later than its display time. For media without nonzero display offsets, the advance decode time is 0.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

TimeValue64 GetMediaAdvanceDecodeTime (
   Media    theMedia ){
printf ("GetMediaAdvanceDecodeTime",theMedia);
};

/*GetTrackDimensions

Determines a track's source rectangle.

void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A pointer to a fixed-point number. The Movie Toolbox returns the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A pointer to a fixed-point number. The Movie Toolbox returns the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackDimensions (
   Track    theTrack,
   Fixed    *width,
   Fixed    *height ){
printf (" GetTrackDimensions",theTrack,*width,*height);
};


/*QTSampleTableGetDisplayOffset

Returns the offset from decode time to display time of a sample.

TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

A 64-bit time value that represents the offset from decode time to display time of the sample. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
TimeValue64 QTSampleTableGetDisplayOffset (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf (" QTSampleTableGetDisplayOffset ",sampleTable,sampleNum);
};


/*QTSampleTableGetSampleDescriptionID

Returns the sample description ID of a sample.

QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum );
Parameters
sampleTable

A reference to an opaque sample table object.
sampleNum

A 64-bit signed integer that represents the sample number. The first sample's number is 1.
Return Value

The sample's sample description ID. Returns 0 if sampleTable is NULL or if the sample number is out of range.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
QTSampleDescriptionID QTSampleTableGetSampleDescriptionID (
   QTSampleTableRef    sampleTable,
   SInt64              sampleNum ){
printf ("QTSampleTableGetSampleDescriptionID",sampleTable,sampleNum);
};


/*GetMediaQuality

Returns a media's quality level value.

short GetMediaQuality (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A short integer whose bits indicate quality constants (see below). More than one of these bits may be set to 1.
Discussion

The Movie Toolbox uses this quality value to influence which track of a movie it selects to play on a given computer. This even applies to sound media. The low-order 6 bits specify pixel depths and the upper 2 bits specify quality levels. If a bit is set to 1, the media can be played at the corresponding depth and quality level.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
short GetMediaQuality (
   Media    theMedia ){
printf ("GetMediaQuality",theMedia);
};


/*QTNextChildAnyType

Returns the next atom in the child list of the specified parent atom.

OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
currentChild

The last atom retrieved by this function. To retrieve the first atom in the child list, set the value of currentChild to 0.
nextChild

A pointer to an uninitialized QT atom data structure. On return, the data structure contains the offset of the next atom in the child list after the atom specified by currentChild, or 0 if the atom specified by currentChild was the last atom in the list.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to iterate through all the atoms in a parent atom's child list, regardless of their types and IDs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNextChildAnyType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtom             currentChild,
   QTAtom             *nextChild ){
printf ("QTNextChildAnyType",container,parentAtom,currentChild,*nextChild);
};



/*QTGetAtomTypeAndID

Retrieves an atom's type and ID.

OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id );
Parameters
container

The atom container that contains the atom.
atom

The atom whose type and ID should be retrieved.
atomType

A pointer to an atom type. On return, this parameter points to the type of the specified atom. You can pass NIL for this parameter if you don't need this information.
id

A pointer to an atom ID. On return, this parameter points to the ID of the specified atom. You can pass NIL for this parameter if you don't need this information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetAtomTypeAndID (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomType         *atomType,
   QTAtomID           *id ){
printf ("QTGetAtomTypeAndID",container,atom,*atomType,*id);
};



/*SetMovieActive

Activates or deactivates a movie.

void SetMovieActive (
   Movie      theMovie,
   Boolean    active );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
active

Activates or deactivates the movie. Set this parameter to TRUE to activate the movie; set this parameter to FALSE to deactivate the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieActive (
   Movie      theMovie,
   Boolean    active ){
printf ("SetMovieActive",theMovie,active);
};



/*IsMovieDone

Determines if a particular movie has completely finished playing.

Boolean IsMovieDone (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

Returns TRUE if the specified movie has finished playing, otherwise returns FALSE.
Discussion

A movie with a positive rate (playing forward) is considered done when its movie time reaches the movie end time. Conversely, a movie with a negative rate (playing backward) is considered done when its movie time reaches the movie start time. If your application has changed the movie's active segment, the status returned by this function is relative to the active segment, rather than to the entire movie. You can use SetMovieActiveSegment to change a movie's active segment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Boolean IsMovieDone (
   Movie    theMovie ){
printf ("IsMovieDone",theMovie);
};


/*GetMovieBox

Returns a movie's boundary rectangle, which is a rectangle that encompasses all of the movie's enabled tracks.

void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle. GetMovieBox returns the coordinates of the movie's boundary rectangle into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The movie box is in the coordinate system of the movie's graphics world and defines the movie's boundaries over the entire duration of the movie. The movie's boundary rectangle defines the size and shape of the movie before the Movie Toolbox applies the display clipping region. The following code sample illustrates the use of GetMovieBox:// GetMovieBox coding example
// See "Discovering QuickTime," page 218
void main (void)
{
    WindowRef       pMacWnd;
    Rect            rectWnd;
    Rect            rectMovie;
    Movie           movie;
    Boolean         bDone =FALSE;
    OSErr           nErr;
    EventRecord     er;
    WindowRef       pWhichWnd;
    short           nPart;
    InitGraf(&qd.thePort);
    InitFonts();
    InitWindows();
    InitMenus();
    TEInit();
    InitDialogs(NIL);
    nErr =EnterMovies();
    if (nErr !=noErr)
        return;
 
    SetRect(&rectWnd, 100, 100, 200, 200);
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pMovie", FALSE,
                            noGrowDocProc, (WindowRef)-1, TRUE, 0);
    SetPort(pMacWnd);
    movie =GetMovie();
    if (movie ==NIL)
        return;
 
    GetMovieBox(movie, &rectMovie);
    OffsetRect(&rectMovie, -rectMovie.left, -rectMovie.top);
    SetMovieBox(movie, &rectMovie);
 
    SizeWindow(pMacWnd, rectMovie.right, rectMovie.bottom, TRUE);
    ShowWindow(pMacWnd);
    SetMovieGWorld(movie, (CGrafPtr)pMacWnd, NIL);
 
    StartMovie(movie);
 
    . . .
 
    DisposeMovie(movie);
    DisposeWindow(pMacWnd);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieBox (
   Movie    theMovie,
   Rect     *boxRect ){
printf ("GetMovieBox",theMovie,*boxRect);
};


/*NewMovieController

Locates a movie controller component and assigns a movie to that controller.

ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags );
Parameters
theMovie

The movie to be associated with the movie controller.
movieRect

A pointer to the Rect structure that is to define the display boundaries of the movie and its controller.
someFlags

Contains flags (see below) that control the operation. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by the movieRect parameter and scales the movie to fit in that rectangle. The control portion of the controller is also placed within that rectangle. You may control how the movie and the control are drawn by setting one or more flags to 1. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcWithBadge
mcNotVisible
mcWithFrame
Return Value

The ID of the new controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentInstance NewMovieController (
   Movie         theMovie,
   const Rect    *movieRect,
   long          someFlags ){
printf ("NewMovieController",theMovie,*movieRect,someFlags);
};


/*DisposeMovieDrawingCompleteUPP

Disposes of a MovieDrawingCompleteUPP pointer.

void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP );
Parameters
userUPP

A MovieDrawingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieDrawingCompleteUPP (
   MovieDrawingCompleteUPP    userUPP ){
printf ("DisposeMovieDrawingCompleteUPP",userUPP);
};


/*NewMovieDrawingCompleteUPP

Allocates a Universal Procedure Pointer for the MovieDrawingCompleteProc callback.

MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieDrawingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieDrawingCompleteUPP NewMovieDrawingCompleteUPP (
   MovieDrawingCompleteProcPtr    userRoutine ){
printf ("NewMovieDrawingCompleteUPP",userRoutine);
};

/*QTNewDataReferenceFromCFURL

Creates a URL data reference from a CFURL.

OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType );
Parameters
url

A reference to a Core Foundation struct that represents the URL to which you want a URL data reference. These structs contain two parts: the string and a base URL, which may be empty. With a relative URL, the string alone does not fully specify the address; with an absolute URL it does.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See “Error Codes” in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Carbon status: Supported; C interface file: Movies.h*/
OSErr QTNewDataReferenceFromCFURL (
   CFURLRef    url,
   UInt32      flags,
   Handle      *outDataRef,
   OSType      *outDataRefType ){
printf ("QTNewDataReferenceFromCFURL",url,flags,*outDataRef,*outDataRefType);
};

long 
GetMovieTrackCount(Movie theMovie){
printf ("GetMovieTrackCount ",theMovie);
};

Track 
GetMovieIndTrack(
  Movie   theMovie,
  long    index){
printf ("GetMovieIndTrack",theMovie,index);
};

void 
GetMediaHandlerDescription(
  Media     theMedia,
  OSType *  mediaType,
  Str255    creatorName,
  OSType *  creatorManufacturer){
printf ("GetMediaHandlerDescription",theMedia,mediaType,creatorName,creatorManufacturer);
};

void 
SetMovieTimeScale(
  Movie       theMovie,
  TimeScale   timeScale){
printf ("SetMovieTimeScale",theMovie,timeScale);
};





























