#define C_LANG 1

#ifndef QUICKTIME_H
#include <QuickTime/QuickTime.h>
#endif








/*DecompressSequenceBegin

Obsolete. See DecompressSequenceBeginS.

OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceBegin (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec ){};

/*DecompressSequenceFrameS

Queues a frame for decompression and specifies the size of the compressed data; new applications should use DecompressSequenceFrameWhen.

OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address.
dataSize

The size of the data buffer.
inFlags

Contains flags (see below) that provide further control information. See these constants: 
codecFlagNoScreenUpdate
codecFlagDontOffscreen
codecFlagOnlyScreenUpdate
outFlags

Contains status flags (see below). The decompressor updates these flags at the end of the decompression operation. See these constants: 
codecFlagUsedNewImageBuffer
codecFlagUsedImageBuffer
codecFlagDontUseNewImageBuffer
codecFlagInterlaceUpdate
codecFlagCatchUpDiff
asyncCompletionProc

Points to an ICMCompletionProcRecord structure. The compressor calls your completion function when an asynchronous decompression operation is complete. You can cause the decompression to be performed asynchronously by specifying a completion function. If you specify asynchronous operation, you must not read the decompressed image until the decompressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous decompression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the decompressor does not call your completion function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function accepts the same parameters as the DecompressSequenceFrame function, with the addition of the dataSize parameter.
Special Considerations

New applications should use DecompressSequenceFrameWhen.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DecompressSequenceFrameS (
   ImageSequence                 seqID,
   Ptr                           data,
   long                          dataSize,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc ){};


/*CDSequenceEnd

Indicates the end of processing for an image sequence.

OSErr CDSequenceEnd (
   ImageSequence    seqID );
Parameters
seqID

Contains the unique sequence identifier that was returned by DecompressSequenceBegin or CompressSequenceBegin.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceEnd (
   ImageSequence    seqID ){};


/*SetIdentityMatrix

Sets the contents of a matrix so that it performs no transformation.

void SetIdentityMatrix (
   MatrixRecord    *matrix );
Parameters
matrix

A pointer to a MatrixRecord structure. The function updates the contents of this matrix so that the matrix describes the identity matrix.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void SetIdentityMatrix (
   MatrixRecord    *matrix ){};

/*RotateMatrix

Modifies the contents of a matrix so that it defines a rotation operation.

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY );
Parameters
m

A pointer to a MatrixRecord structure.
degrees

The number of degrees of rotation.
aboutX

The x coordinate of the anchor point of rotation.
aboutY

The y coordinate of the anchor point of rotation.
Discussion

This function updates the contents of a matrix so that the matrix describes a rotation operation; that is, it concatenates the rotation transformations onto whatever was initially in the matrix structure. You specify the direction and amount of rotation with the degrees parameter. You specify the point of rotation with the aboutX and aboutY parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void RotateMatrix (
   MatrixRecord    *m,
   Fixed           degrees,
   Fixed           aboutX,
   Fixed           aboutY ){};


/*TranslateMatrix

Adds a translation value to a specified matrix.

void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV );
Parameters
m

A pointer to the MatrixRecord structure for this operation.
deltaH

The value to be added to the x coordinate translation value.
deltaV

The value to be added to the y coordinate translation value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
void TranslateMatrix (
   MatrixRecord    *m,
   Fixed           deltaH,
   Fixed           deltaV ){};

/*GraphicsImportSetMatrix

Defines the transformation matrix to use for drawing an imported image.

ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
matrix

A pointer to a matrix structure that specifies how to transform the image during decompression. For example, you can use a transformation matrix to scale or rotate the image. To set the matrix to identity, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function establishes the transformation matrix to be applied to an image, which determines where and how it will be drawn.
Special Considerations

This function affects the bounding rectangle defined for the image. You can specify where an image will be drawn by setting either a transformation matrix or a bounding rectangle, but it is usually more convenient for applications to set a bounding rectangle using the GraphicsImportSetBoundsRect function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetMatrix (
   GraphicsImportComponent    ci,
   const MatrixRecord         *matrix ){};

/*GraphicsImportGetBoundsRect

Returns the bounding rectangle for drawing an imported image.

ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
bounds

A pointer to a Rect structure describing the bounding rectangle that has been defined for the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This is a convenience function. It is implemented by calling GraphicsImportGetMatrix and GraphicsImportGetNaturalBounds and using the results to calculate the drawing rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetBoundsRect (
   GraphicsImportComponent    ci,
   Rect                       *bounds ){};


/*GraphicsImportSetSourceRect

Sets the source rectangle to use for an imported image.

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
sourceRect

A pointer to a Rect structure defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the source image. Set to NIL to use the entire image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides a way to use only a portion of the source image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetSourceRect (
   GraphicsImportComponent    ci,
   const Rect                 *sourceRect ){};



/*GraphicsImportSetFlags

Sets the flags for a graphics importer component.

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
flags

The new flags (see below) to use. See these constants: 
kGraphicsImporterDontDoGammaCorrection
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetFlags (
   GraphicsImportComponent    ci,
   long                       flags ){};

/*GraphicsImportSetClip

Defines the clipping region for drawing an imported image.

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
clipRgn

A handle to a MacRegion structure that defines the clipping region in the destination coordinate system. Set to NIL to disable clipping. The graphics import component makes a copy of this region.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Because all drawing operations ignore the port clipping region, you must use this function to clip an image. The graphics importer component draws only that portion of the image that lies within the specified clipping region.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetClip (
   GraphicsImportComponent    ci,
   RgnHandle                  clipRgn ){};

/*ICMCompressorSourceFrameGetFrameOptions

Retrieves the frame compression options for a source frame.

ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A compression session frame options reference representing options for this frame. A frame options object is created by ICMCompressionFrameOptionsCreate.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressionFrameOptionsRef ICMCompressorSourceFrameGetFrameOptions (
   ICMCompressorSourceFrameRef   sourceFrame ){};


/*ICMCompressionSessionOptionsGetAllowTemporalCompression

Retrieves the allow temporal compression flag.

Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if temporal compression is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionSessionOptionsGetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options ){};


/*ICMCompressionFrameOptionsGetForceKeyFrame

Retrieves the force key frame flag.

Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

Returns TRUE if frames are forced to be compressed as key frames, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
Boolean ICMCompressionFrameOptionsGetForceKeyFrame (
   ICMCompressionFrameOptionsRef   options ){};

/*ICMCompressorSourceFrameRetain

Increments the retain count of a source frame object.

ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Return Value

A reference to the object passed in sourceFrame, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMCompressorSourceFrameRef ICMCompressorSourceFrameRetain (
   ICMCompressorSourceFrameRef    sourceFrame ){};


/*ICMCompressorSourceFrameRelease

Decrements the retain count of a source frame object.

void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressorSourceFrameRelease (
   ICMCompressorSourceFrameRef    sourceFrame ){};

/*ICMCompressorSourceFrameGetDisplayNumber

Retrieves a source frames display number.

long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

The display number of the source frame.
Discussion

The ICM tags source frames with display numbers in the order that they are passed to ICMCompressionSessionEncodeFrame. The first display number is 1. Compressors may compare these numbers to work out whether prediction is forward or backward, even when display times are not provided. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
long ICMCompressorSourceFrameGetDisplayNumber (
   ICMCompressorSourceFrameRef   sourceFrame ){};
/*ICMCompressionSessionOptionsGetAllowFrameReordering

Retrieves the allow frame reordering flag.

Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns TRUE if frame reordering is allowed, FALSE otherwise.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/


Boolean ICMCompressionSessionOptionsGetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options ){};


/*ICMCompressorSourceFrameGetDisplayTimeStampAndDuration

Retrieves the display time stamp and duration of a source frame.

OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
displayTimeStampOut

A pointer to the source frame's display time stamp.
displayDurationOut

A pointer to the source frame's display duration.
timeScaleOut

A pointer to the source frame's display time scale.
validTimeFlagsOut

A pointer to one of these display time flags for the source frame: kICMValidTime_DisplayTimeStampIsValid = 1L<<0 The value of displayTimeStamp is valid. kICMValidTime_DisplayDurationIsValid = 1L<<1 The value of displayDuration is valid. See these constants: 
kICMValidTime_DisplayTimeStampIsValid
kICMValidTime_DisplayDurationIsValid
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressorSourceFrameGetDisplayTimeStampAndDuration (
   ICMCompressorSourceFrameRef    sourceFrame,
   TimeValue64                    *displayTimeStampOut,
   TimeValue64                    *displayDurationOut,
   TimeScale                      *timeScaleOut,
   ICMValidTimeFlags              *validTimeFlagsOut ){};


/*ICMCompressionSessionOptionsGetProperty

Retrieves the value of a specific property of a compression session options object.

OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
outPropType

A pointer to the type of the returned property's value.
outPropValueAddress

A pointer to a variable to receive the returned property's value.
outPropValueSizeUsed

On return, a pointer to the number of bytes actually used to store the property.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsGetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ComponentValuePtr                 outPropValueAddress,
   ByteCount                         *outPropValueSizeUsed ){};


/*ICMEncodedFrameCreateMutable

Called by a compressor to create an encoded-frame token corresponding to a given source frame.

OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
bufferSize

The size of the frame buffer in bytes.
frameOut

On return, a reference to an encoded frame object with write capabilities.
Return Value

An error code. Returns noErr if there is no error.
Discussion

The encoded frame will initially show 0 for mediaSampleFlags; if the frame is not a key frame, the compressor must call ICMEncodedFrameSetMediaSampleFlags to set mediaSampleNotSync. If the frame is droppable, the compressor should set mediaSampleDroppable. If the frame is a partial key frame, the compressor should set mediaSamplePartialSync.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameCreateMutable (
   ICMCompressorSessionRef       session,
   ICMCompressorSourceFrameRef   sourceFrame,
   ByteCount                     bufferSize,
   ICMMutableEncodedFrameRef     *frameOut ){};


/*ICMEncodedFrameGetDataPtr

Gets the data buffer for an encoded frame.

UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

A pointer to the object's data buffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
UInt8 *ICMEncodedFrameGetDataPtr (
   ICMEncodedFrameRef   frame ){};

/*ICMCompressorSourceFrameGetPixelBuffer

Retrieves a source frames pixel buffer.

CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame );
Parameters
sourceFrame

A reference to a frame that has been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

A reference to the pixel buffer containing the source frame's image being compressed.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
CVPixelBufferRef ICMCompressorSourceFrameGetPixelBuffer (
   ICMCompressorSourceFrameRef   sourceFrame ){};


/*ICMEncodedFrameSetDataSize

Sets the data size of the compressed frame in an encoded frame's buffer.

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize );
Parameters
frame

A reference to an encoded frame object with write capabilities.
dataSize

The data size of the compressed frame in the encoded frame object's buffer.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetDataSize (
   ICMMutableEncodedFrameRef   frame,
   ByteCount                   dataSize ){};


/*ICMEncodedFrameSetMediaSampleFlags

Sets the media sample flags for an encoded frame.

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags );
Parameters
frame

A reference to an encoded frame object with write capabilities.
mediaSampleFlags

The object's media sample flags. These flags are listed in the header file Movies.h.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMEncodedFrameSetMediaSampleFlags (
   ICMMutableEncodedFrameRef   frame,
   MediaSampleFlags            mediaSampleFlags ){};



/*ICMEncodedFrameSetFrameType

Sets the frame type for an encoded frame.

OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType );
Parameters
frame

A reference to an encoded frame object with write capabilities.
frameType

The frame type to be set: kICMFrameType_I = 'I' An I frame. kICMFrameType_P = 'P' A P frame. kICMFrameType_B = 'B' A B frame. kICMFrameType_Unknown = 0 A frame of unknown type. See these constants: 
kICMFrameType_I
kICMFrameType_P
kICMFrameType_B
kICMFrameType_Unknown
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameSetFrameType (
   ICMMutableEncodedFrameRef   frame,
   ICMFrameType                frameType ){};


/*ICMCompressorSessionEmitEncodedFrame

Called by a compressor to output an encoded frame corresponding to one or more source frames.

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] );
Parameters
session

A reference to the compression session between the ICM and an image compressor component.
encodedFrame

A reference to an encoded frame object with write capabilities.
numberOfSourceFrames

The number of source frames encoded in the encoded frame.
sourceFrames

References to frames that have been passed in sourceFrameRefCon to ICMCompressionSessionEncodeFrame.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Encoded frames may correspond to more than one source frame only if allowFrameTimeChanges is set in the compression session's compressionSessionOptions.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressorSessionEmitEncodedFrame (
   ICMCompressorSessionRef       session,
   ICMMutableEncodedFrameRef     encodedFrame,
   long                          numberOfSourceFrames,
   ICMCompressorSourceFrameRef   sourceFrames[] ){};

/*ICMEncodedFrameRelease

Decrements the retain count of an encoded frame object.

void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame );
Parameters
frame

A reference to an encoded frame object. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMEncodedFrameRelease (
   ICMEncodedFrameRef    frame ){};


/*ICMCompressionSessionOptionsRelease

Decrements the retain count of a compression session options object.

void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the object is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
void ICMCompressionSessionOptionsRelease (
   ICMCompressionSessionOptionsRef    options ){};



/*ICMCompressionFrameOptionsGetFrameType

Retrieves the frame type setting.

ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options );
Parameters
options

A compression frame options reference. This reference is returned by ICMCompressionFrameOptionsCreate.
Return Value

On return, one of the frame types listed below.
Discussion

This function can return one of these constants:
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ICMFrameType ICMCompressionFrameOptionsGetFrameType (
   ICMCompressionFrameOptionsRef   options ){};


/*ICMCompressionSessionOptionsRetain

Increments the retain count of a compression session options object.

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options );
Parameters
options

A reference to a compression session options object. This reference is returned by ICMCompressionSessionOptionsCreate. If you pass NULL, nothing happens.
Return Value

A copy of the object reference passed in options, for convenience.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ICMCompressionSessionOptionsRef ICMCompressionSessionOptionsRetain (
   ICMCompressionSessionOptionsRef    options ){};
/*ICMCompressionSessionOptionsGetMaxKeyFrameInterval

Retrieves the maximum key frame interval.

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
Return Value

Returns the maximum key frame interval.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

SInt32 ICMCompressionSessionOptionsGetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options ){};



/*PutMovieIntoHandle

Creates a new movie resource.

OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
publicMovie

The handle that is to receive the new movie resource. The function resizes the handle if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this handle to store a QuickTime movie in a specialized storage format.
Special Considerations

Note that you cannot use this new movie with other Movie Toolbox functions, except for NewMovieFromHandle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoHandle (
   Movie     theMovie,
   Handle    publicMovie ){};


/*NewMovieFromHandle

Creates a movie in memory from a movie resource or a handle you obtained from PutMovieIntoHandle.

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
h

A handle to the movie resource from which the movie is to be loaded.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromHandle. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The toolbox sets the value to TRUE if any references were changed. Set the dataRefWasChanged parameter to NIL if you don't want to receive this information.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromHandle. To change the graphics world for the new movie, your application should use SetMovieGWorld.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr NewMovieFromHandle (
   Movie      *theMovie,
   Handle     h,
   short      newMovieFlags,
   Boolean    *dataRefWasChanged ){};

/*DetachMovieFromCurrentThread

Detaches a movie from the current thread.

OSErr DetachMovieFromCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr DetachMovieFromCurrentThread (Movie m){};


/*AttachMovieToCurrentThread

Attaches a movie to the current thread.

OSErr AttachMovieToCurrentThread (Movie m);
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr AttachMovieToCurrentThread (Movie m){};



/*GetCodecInfo

Returns information about a single compressor component.

OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec );
Parameters
info

A pointer to a CodecInfo structure. GetCodecInfo returns detailed information about the appropriate compressor component in this structure.
cType

Set this parameter to a valid compressor type constant; see Codec Identifiers. If you want information about any compressor of the type specified by this parameter, set the codec parameter to 0. The Image Compression Manager then returns information about the first compressor it finds of the type you have specified.
codec

Set this parameter to the component identifier of the specific compressor for the request, or to 0 for any compressor. Component identifiers are available in the CodecNameSpecList structure returned by GetCodecNameList.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCodecInfo (
   CodecInfo         *info,
   CodecType         cType,
   CodecComponent    codec ){};



/*ImageCodecGetParameterList

Returns a parameter description atom container for a specified effect component instance.

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription );
Parameters
ci

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
parameterDescription

The returned atom container for this component instance.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns the parameter description for the effect specified by the component instance ci, as a handle containing an 'atms' resource of ID 1. The handle should be detached if it has been read in from a resource. Each parameter of the effect is described in the parameter description, with details of its name, type, legal values and hints about how a user interface to the parameter should be constructed.
Special Considerations

The calling application is responsible for disposing of the QT atom container returned in parameterDescription. The application should do this by calling QTDisposeAtomContainer once it has finished using the parameter description.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecGetParameterList (
   ComponentInstance    ci,
   QTAtomContainer      *parameterDescription ){};


/*QTGetEffectSpeed

Returns the speed of the effect, expressed in frames per second.

OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS );
Parameters
parameters

Contains parameter values for the effect.
pFPS

The speed of the effect is returned in this parameter, expressed in frames per second. Effects can also return the pre-defined constant effectIsRealtime (see below) as their speed. See these constants: 
effectIsRealtime
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The value returned should not be treated as an absolute measurement of effect performance. In particular, most effects only return one value, regardless of parameter settings and hardware. This value is an estimate of execution speed on a reference hardware platform. Actual performance will vary depending on hardware, configuration and parameter options.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectSpeed (
   QTAtomContainer    parameters,
   Fixed              *pFPS ){};


/*QTCountChildrenOfType

Returns the number of atoms of a given type in the child list of the specified parent atom.

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
childType

The atom type for this operation. To retrieve the total number of atoms in the child list, set this parameter to 0. 
Return Value

The number of atoms of a given type in the child list of the specified parent atom.
Discussion

You can call this function to determine the number of atoms of a specified type in a parent atom's child list. If the total number of atoms in the parent atom's child list is 0, the parent atom is a leaf atom.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short QTCountChildrenOfType (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         childType ){};


/*MovieImportGetSettingsAsAtomContainer

Retrieves the current settings from the movie import component.

ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the reference to the newly created atom container should be stored by the call.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportGetSettingsAsAtomContainer (
   MovieImportComponent    ci,
   QTAtomContainer         *settings ){};


/*MovieExportGetSettingsAsAtomContainer

Retrieves the current settings from the movie export component.

ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

The address where the newly-created atom container should be stored by the call. The caller is responsible for disposing of the returned QT atom container.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Applications can call this function to obtain a correctly formatted atom container to use with MovieExportSetSettingsFromAtomContainer. This might be done after a call to MovieExportDoUserDialog, for example, to apply the user-obtained settings to a series of exports.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportGetSettingsAsAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         *settings ){};



/*GraphicsExportGetSettingsAsAtomContainer

Retrieves the current settings from a graphics exporter component.

ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
qtAtomContainerPtr

Points to a variable to receive a new QuickTime atom container containing the current graphics exporter component settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Special Considerations

The caller is responsible for disposing of the returned atom container.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportGetSettingsAsAtomContainer (
   GraphicsExportComponent    ci,
   void                       *qtAtomContainerPtr ){};


/*GraphicsImportGetExportSettingsAsAtomContainer

Retrieves settings for image files exported by the graphics importer.

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
qtAtomContainerPtr

A pointer to a QuickTime atom container that is to receive the settings information.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a new QuickTime atom container which holds information about how images will be saved by GraphicsImportExportImageFile.
Special Considerations

It is the responsibility of the caller to dispose of this atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetExportSettingsAsAtomContainer (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr ){};


/*QTVideoOutputGetDisplayModeList

Returns a list of the display modes supported by a video output component.

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
outputs

A pointer to the QT atom container that lists the video modes supported by this component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After your software calls this function, it must dispose of the QT atom container returned by the function by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult QTVideoOutputGetDisplayModeList (
   QTVideoOutputComponent    vo,
   QTAtomContainer           *outputs ){};


/*VDIIDCGetFeatures

Places atoms in a QuickTime atom container that specify the current capabilities of a camera and the state of its IIDC features.

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container );
Parameters
ci

The component instance that identifies your connection to a video digitizer component. The digitizer's subtype must be vdSubtypeIIDC ('iidc').
container

Upon return, a pointer to a QuickTime atom container containing atoms of type vdIIDCAtomTypeFeature for each IIDC camera feature. If the camera has not implemented any IIDC features the container returns empty.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Discussion

The digitizer creates the container, and it is the responsibility of the client to ultimately delete it if the routine does not return an error. Since the values that this function retrieves might change underneath the client, they should not be cached but should be retrieved each time they are needed.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDIIDCGetFeatures (
   VideoDigitizerComponent    ci,
   QTAtomContainer            *container ){};


/*SetMovieDrawingCompleteProc

Assigns a drawing-complete function to a movie.

void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon );
Parameters
theMovie

The movie for this operation.
flags

Contains flags (see below) that control when your drawing complete function is called. See these constants: 
movieDrawingCallWhenChanged
movieDrawingCallAlways
proc

A pointer to your MovieDrawingCompleteProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

The reference constant you supplied when your application called your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls this function based upon guidelines you establish when you assign the function to the movie. 
Special Considerations

Some media handlers may take less efficient playback paths when a drawing-complete function is used, so it should be used only when absolutely necessary.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieDrawingCompleteProc (
   Movie                      theMovie,
   long                       flags,
   MovieDrawingCompleteUPP    proc,
   long                       refCon ){};

/*MCIdle

Performs idle processing for a movie controller.

ComponentResult MCIdle (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCIdle (
   MovieController    mc ){};



/*QTNewDataReferenceFromFSRef

Creates an alias data reference from a file specification.

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType );
Parameters
fileRef

A pointer to an opaque file system reference.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

You can use File Manager functions to construct a file specification for a file to which you want the new alias data reference to point. Then you can pass the reference to other Movie Toolbox functions that take a data reference. To construct a file specification, the file must already exist. To create an alias data reference for a file that does not exist yet, such as a new file to be created by a Movie Toolbox function, call QTNewDataReferenceFromFSRefCFString.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromFSRef (
   const FSRef    *fileRef,
   UInt32          flags,
   Handle          *outDataRef,
   OSType          *outDataRefType ){};


/*CanQuickTimeOpenDataRef

Determines whether referenced data can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags );
Parameters
dataRef

A handle to the referenced data.
dataRefType

The type of data reference pointed to by dataRef; see Data References.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given area of data. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenDataRef (
   Handle     dataRef,
   OSType     dataRefType,
   Boolean    *outCanOpenWithGraphicsImporter,
   Boolean    *outCanOpenAsMovie,
   Boolean    *outPreferGraphicsImporter,
   UInt32     inFlags ){};


/*QTInstallNextTaskNeededSoonerCallback

Installs a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback.
scale

The time scale that QuickTime will use when reporting the duration until the next time QuickTime needs to be called, via QTGetTimeUntilNextTask.
flags

Unused; set to 0.
refcon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This routine installs a callback procedure that specifies when QuickTime next needs to be tasked. The callback procedure may be called at interrupt time or from another Mac OS X thread, so you must be careful not to cause race conditions. You can install or uninstall multiple callback procedures if necessary; they will be called in sequence. You can also install the same callback multiple times with different refcon values, in which case it will be called once with each refcon value.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTInstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   TimeScale                            scale,
   unsigned long                        flags,
   void                                *refcon ){};


/*QTGetTimeUntilNextTask

Reports the duration until the next time QuickTime needs to run a task.

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale );
Parameters
duration

A pointer to the duration until the next time QuickTime needs access to the processor. If the returned duration is 0, QuickTime needs to run a task immediately.
scale

The time scale in which to express the returned duration. For example, pass 60 if you want the duration value expressed in ticks (60ths of a second).
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Periodically, applications have to give processing time to QuickTime by calling a function such as MCIsPlayerEvent. Instead of routinely calling MCIsPlayerEvent 10 to 20 times per second, you can call QTGetTimeUntilNextTask to determine when QuickTime next needs access to the processor. The result is a more efficent use of processor resources. To handle cases when QuickTime may need to run a task earlier than projected by this function, you can install a QTNextTaskNeededSoonerCallbackProc callback.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr QTGetTimeUntilNextTask (
   long    *duration,
   long    scale ){};


/*QTUninstallNextTaskNeededSoonerCallback

Removes a QTNextTaskNeededSoonerCallbackProc callback.

OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon );
Parameters
callbackProc

A Universal Procedure Pointer to a QTNextTaskNeededSoonerCallbackProc callback that you installed by a previous call to QTInstallNextTaskNeededSoonerCallback.
refcon

A pointer to the reference constant that you passed when the callback was installed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You pass this routine both a pointer to a callback procedure and a pointer to its reference constant, so you can uninstall one instance of a callback that you installed more than once with different refcon values.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr QTUninstallNextTaskNeededSoonerCallback (
   QTNextTaskNeededSoonerCallbackUPP    callbackProc,
   void                                *refcon ){};



/*QTGetMovieProperty

Returns the value of a specific movie property.

OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
inPropValueSize

The size of the buffer allocated to hold the property value.
outPropValueAddress

A pointer to the buffer allocated to hold the property value.
outPropValueSizeUsed

On return, the actual size of the value written to the buffer.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTGetMovieProperty (
   Movie                 inMovie,
   QTPropertyClass       inPropClass,
   QTPropertyID          inPropID,
   ByteCount             inPropValueSize,
   QTPropertyValuePtr    outPropValueAddress,
   ByteCount             *outPropValueSizeUsed ){};


/*QTGetMoviePropertyInfo

Returns information about the properties of a movie.

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags );
Parameters
inMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
inPropClass

A property class.
inPropID

A property ID.
outPropType

A pointer to memory allocated to hold the property type on return.
outPropValueSize

A pointer to memory allocated to hold the size of the property value on return.
outPropertyFlags

A pointer to memory allocated to hold property flags on return.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetMoviePropertyInfo (
   Movie                  inMovie,
   QTPropertyClass        inPropClass,
   QTPropertyID           inPropID,
   QTPropertyValueType    *outPropType,
   ByteCount              *outPropValueSize,
   UInt32                 *outPropertyFlags ){};



/*CanQuickTimeOpenFile

Determines whether a file can be opened using a graphics importer or opened in place as a movie.

OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags );
Parameters
fileSpec

Points to an FSSpec structure that identifies a file. To ask about a particular file type or file name suffix in general, pass NIL.
fileType

Contains the file type if already known, or 0 if not known. If fileSpec is provided and fileType is 0, QuickTime will determine the file type. If you pass NIL in fileSpec and 0 in fileNameExtension, you must pass a file type here.
fileNameExtension

Contains the file name suffix if already known, or 0 if not known. The file name suffix should be encoded as an uppercase four character code with trailing spaces; for instance, the suffix ".png" should be encoded as 'PNG ', or 0x504E4720. If fileSpec is provided and fileNameExtension is 0, QuickTime will examine fileSpec to determine the file name suffix. If you pass NIL in fileSpec and 0 in fileType, you must pass a file name suffix here.
outCanOpenWithGraphicsImporter

Points to a Boolean that will be set to TRUE if the file can be opened using a graphics importer and FALSE otherwise. If you do not want this information, pass NIL.
outCanOpenAsMovie

Points to a Boolean that will be set to TRUE if the file can be opened as a movie and FALSE otherwise. If you do not want this information, pass NIL.
outPreferGraphicsImporter

Points to a boolean which will be set to true if the file can be opened using a graphics importer and opened as a movie, but, other factors being equal, QuickTime prefers a graphics importer. For example, QuickTime recommends using a graphics importer for single-frame GIF files and opening as a movie for multiple-frame GIF files. If you do not want this information, pass NIL. Passing a valid pointer disables the kQTDontUseDataToFindImporter and kQTDontLookForMovieImporterIfGraphicsImporterFound flags, if set.
inFlags

Flags (see below) that modify search behavior. Pass 0 for default behavior. See these constants: 
kQTDontUseDataToFindImporter
kQTDontLookForMovieImporterIfGraphicsImporterFound
kQTAllowOpeningStillImagesAsMovies
kQTAllowImportersThatWouldCreateNewFile
kQTAllowAggressiveImporters
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function determines whether QuickTime can open a given file or, in general, files of a given type. You should pass NIL in parameters that do not interest you, since that will allow QuickTime to perform a faster determination.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CanQuickTimeOpenFile (
   FSSpecPtr    fileSpec,
   OSType       fileType,
   OSType       fileNameExtension,
   Boolean      *outCanOpenWithGraphicsImporter,
   Boolean      *outCanOpenAsMovie,
   Boolean      *outPreferGraphicsImporter,
   UInt32       inFlags ){};


/*QTNewDataReferenceFromURLCFString

Creates a URL data reference from a CFString that represents a URL string.

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
urlString

A CFString that represents a URL string.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

The new URL data reference returned can be passed to other Movie Toolbox calls that take a data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTNewDataReferenceFromURLCFString (
   CFStringRef    urlString,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){};


/*CreateMovieControl

Creates a movie control object to pass to the Mac OS Control Manager.

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl );
Parameters
theWindow

The window in which the control is placed.
localRect

A pointer to a Rect structure that describes in local coordinates the window in which the movie control is placed. If NIL is passed, the movie control is positioned at 0,0 within the window; it will have the natural dimensions of the movie plus the height of the movie controls if they are visible. If 0 height and width is passed, this parameter is interpreted as an anchor point and the top left point of the movie control will be located at this position with height and width as in the NIL case. For all other cases of rectangles, the movie control is centered within the rectangle by default and is sized to fit within it while maintaining the movie's aspect ratio.
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
options

Constants (see below) that determine parts of the movie control's appearance. See these constants: 
kMovieControlOptionHideController
kMovieControlOptionLocateTopLeft
kMovieControlOptionEnableEditing
kMovieControlOptionHandleEditingHI
kMovieControlOptionSetKeysEnabled
kMovieControlOptionManuallyIdled
returnedControl

A handle to a ControlRecord struct. This defines a movie control, suitable for passing to Mac OS Control Manager functions.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes. This routine returns an error if there is a problem with one of the parameters or if an error occurred while creating the underlying movie controller or the custom control itself. If an error is returned, the value of returnedControl is undefined.
Discussion

The Carbon Movie Control is implemented as a custom control, which installs an event handler to handle the Carbon Events sent to controls. When a Carbon Movie Control is created for a movie, a movie controller is also created. The movie control then directs user interface events to the controller. The application can install event handlers on the Carbon Movie Control to handle such things as contextual menu clicks or to intercept events to do special processing. Control Manager calls can be made as well.
Special Considerations

The control can be deleted by calling the Mac OS function DisposeControl. Note that the control is automatically disposed of if the enclosing window is destroyed. Note, too, that the underlying movie controller is disposed of when the control is deleted.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/

OSErr CreateMovieControl (
   WindowRef     theWindow,
   Rect          *localRect,
   Movie         theMovie,
   UInt32        options,
   ControlRef    *returnedControl){};



/*GetMovieAudioFrequencyLevels

Returns the current frequency meter levels of a movie mix.

OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
pAveragePowerLevels

A pointer to a QTAudioFrequencyLevels structure (page 325).
Return Value

An error code. Returns noErr if there is no error.
Discussion

In the structure pointed to by pAveragePowerLevels, the numChannels field must be set to the number of channels in the movie mix being metered and the numBands field must be set to the number of bands being metered (as previously configured). Enough memory for the structure must be allocated to hold 32-bit values for all bands in all channels. This function returns the current frequency meter levels in the level field of the structure, with all the band levels for the first channel first, all the band levels for the second channel next and so on.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus GetMovieAudioFrequencyLevels (
   Movie                     m,
   FourCharCode              whatMixToMeter,
   QTAudioFrequencyLevels    *pAveragePowerLevels ){};


/*SetMovieAudioFrequencyMeteringNumBands

Configures frequency metering for a particular audio mix in a movie.

OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromProperties, NewMovieFromFile, and NewMovieFromHandle.
whatMixToMeter

The applicable mix of audio channels in the movie; see Movie Audio Mixes.
ioNumBands

A pointer to memory that stores the number of bands being metered. On calling this function, you specify the number of frequency bands you want to meter. If that number is higher than is possible (determined by factors such as the sample rate of the audio being metered), the function will return the number of bands it is actually going to meter. You can pass NIL or a pointer to 0 to disable metering.
Return Value

An error code. Returns noErr if there is no error.
Discussion

See GetMovieAudioFrequencyMeteringNumBands.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSStatus SetMovieAudioFrequencyMeteringNumBands (
   Movie           m,
   FourCharCode    whatMixToMeter,
   UInt32          *ioNumBands ){};



/*GetMovieUserData

Obtains access to a movie's user data list.

UserData GetMovieUserData (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The UserDataRecord structure for the movie. If the function could not locate the movie's user data, it sets this return value to NIL.
Discussion

This function returns a reference to the movie's user data list, which is valid until you dispose of the movie. When you save the movie, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetMovieUserData (
   Movie    theMovie ){};



/*GetMovieDuration

Returns the duration of a movie.

TimeValue GetMovieDuration (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The duration of the designated movie.
Discussion

This function returns a time value, expressed in the movie's time scale, that is calculated to be the maximum durations of all the tracks in the movie. The following code sample illustrates its use:// GetMovieDuration coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetMovieDuration (
   Movie    theMovie ){};


/*NewMovie

Creates a new movie in memory.

Movie NewMovie (
   long    flags );
Parameters
flags

Flags (see below) that specify control information for the new movie. Be sure to set unused flags to 0.
Return Value

The identifier for the new movie. If NewMovie fails, the returned identifier is set to NIL. You can use GetMoviesError to obtain the error result, or noErr if there was no error. See Error Codes.
Discussion

You can use NewMovie to create a new empty movie, which contains no tracks. The Movie Toolbox initializes the data structures for the new movie. Your application assigns the data to the movie by calling the functions that are described in NewMovieTrack.

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovie. To change the graphics world for the new movie, your application should use SetMovieGWorld. The default QuickTime movie time scale is 600 units per second; however, this number may change in the future. The default time scale was chosen because it is convenient for working with common video frame rates of 30, 25, 24, 15, 12, 10, and 8.
Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie NewMovie (
   long    flags ){};



/*GetUserDataText

Retrieves language-tagged text from an item in a user data list.

OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data. The GetUserDataText function resizes this handle as appropriate. Your application must dispose of the handle when you are done with it.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
itlRegionTag

The language code of the text to be retrieved. See Localization Codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, and the item's type value and language code. The Movie Toolbox retrieves the specified text from the user data item.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag ){};


/*QTFindChildByID

Retrieves an atom by ID from the child list of the specified parent atom.

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index );
Parameters
container

The atom container that contains the parent atom.
parentAtom

The parent atom for this operation.
atomType

The type of the atom to be retrieved.
id

The ID of the atom to be retrieved.
index

A pointer to an uninitialized short integer. On return, if the atom specified by the id parameter was found, the integer contains the atom's index. If you don't want this function to return the atom's index, set the value of the index parameter to NIL.
Return Value

The found atom.
Discussion

You call this function to search for and retrieve an atom by its type and ID from a parent atom's child list. The following code shows how you can use this function to insert a copy of container B's atoms as children of the 'abcd' atom in container A:// QTFindChildByID coding example
QTAtom targetAtom;
targetAtom =QTFindChildByID (containerA, kParentAtomIsContainer, 'abcd',
    1000, NIL);
FailOSErr (QTInsertChildren (containerA, targetAtom, containerB));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

QTAtom QTFindChildByID (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              *index ){};


/*QTSetAtomData

Changes the data of a leaf atom.

OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData );
Parameters
container

The atom container that contains the atom to be modified.
atom

The atom to be modified.
dataSize

The length, in bytes, of the data pointed to by the atomData parameter.
atomData

A pointer to the new data for the atom.
Return Value

Only leaf atoms contain data; this function returns an error if you pass it to a nonleaf atom. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to replace a leaf atom's data with new data. The atom container specified by the container parameter should not be locked. The following code illustrates using this function to update an atom container that describes a sprite:// QTSetAtomData coding example
OSErr SetSpriteData (QTAtomContainer sprite, Point *location,
    short *visible, short *layer, short *imageIndex)
{
    OSErr err =noErr;
    QTAtom propertyAtom;
 
    // if the sprite's visible property has a new value
    if (visible)
    {
        // retrieve the atom for the visible property
        // -- if none exists, insert one
        if ((propertyAtom =QTFindChildByIndex (sprite,
            kParentAtomIsContainer, kSpritePropertyVisible, 1,
            NIL)) ==0)
            FailOSErr (QTInsertChild (sprite, kParentAtomIsContainer,
                kSpritePropertyVisible, 1, 1, sizeof(short), visible,
                NIL))
 
        // if an atom does exist, update its data
        else
            FailOSErr (QTSetAtomData (sprite, propertyAtom,
                sizeof(short), visible));
    }

Special Considerations

This function may move memory; if the pointer specified by the atomData parameter is a dereferenced handle, you should lock the handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTSetAtomData (
   QTAtomContainer    container,
   QTAtom             atom,
   long               dataSize,
   void               *atomData ){};



/*MovieExportSetSettingsFromAtomContainer

Sets the movie export component's current configuration from passed settings data.

ComponentResult MovieExportSetSettingsFromAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         settings );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
settings

A QT atom container that contains the settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The atom container may contain atoms other than those expected by the particular component type or may be missing certain atoms. This function uses only those settings it understands.

Here is sample code that overrides compression settings:// MovieExportSetSettingsFromAtomContainer coding example
ComponentInstance sc;
QTAtomContainer compressorData;
SCSpatialSettings ss;
sc =OpenDefaultComponent(StandardCompressionType,
                             StandardCompressionSubType);
ss.codecType =kCinepakCodecType;
ss.codec =NIL;
ss.depth =0;
ss.spatialQuality =codecHighQuality
err =SCSetInfo(sc, scSpatialSettingsType, &ss);
err =SCGetSettingsAsAtomContainer(sc, &compressorData);
MovieExportSetSettingsFromAtomContainer (qtvrExport, compressorData);

Special Considerations

Some movie export components treat sample descriptions as part of their settings. If your application attempts to set the sample description using MovieExportSetSampleDescription, and receives the badComponentSelector error, you may need to pass in the SampleDescription structure using this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetSettingsFromAtomContainer (
   MovieExportComponent    ci,
   QTAtomContainer         settings ){};


/*GetMediaHandler

Obtains a reference to a media handler component.

MediaHandler GetMediaHandler (
   Media    theMedia );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
Return Value

A media handler component instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MediaHandler GetMediaHandler (
   Media    theMedia ){};


/*TextMediaAddTextSample

Adds a single block of styled text to an existing media.

ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime );
Parameters
mh

The media handler for the text media obtained by GetMediaHandler.
text

A pointer to a block of text.
size

Indicates the size of the text block, in bytes.
fontNumber

The number for the font in which to display the text.
fontSize

Indicates the size of the font.
textFace

Indicates the typeface or style of the text (that is, bold, italic, and so on).
textColor

A pointer to an RGBColor structure specifying the color of the text. Passing NIL for this parameter in defaults to black.
backColor

A pointer to an RGBColor structure specifying the text background color. Passing NIL for this parameter in defaults to white.
textJustification

Indicates the justification of the text (see below). See these constants: 
textBox

A pointer to a Rect structure that defines the box within which the text is to be displayed. The box is relative to the track bounds.
displayFlags

Contains the text display flags (see below). See these constants: 
dfDontDisplay
dfDontAutoScale
dfClipToTextBox
dfShrinkTextBoxToFit
dfScrollIn
dfScrollOut
dfHorizScroll
dfReverseScroll
dfContinuousScroll
dfFlowHoriz
dfContinuousKaraoke
dfDropShadow
dfAntiAlias
dfKeyedText
dfInverseHilite
dfTextColorHilite
scrollDelay

Indicates the delay in scrolling associated with the setting of the dfScrollIn and dfScrollOut display flags. If the value of the scrollDelay parameter is greater than 0 and the dfScrollIn flag is set, the text pauses when it has scrolled all the way in for the amount of time specified by scrollDelay. If the dfScrollOut flag is set, the pause occurs first before the text scrolls out. If both these flags are set, the pause occurs at the midpoint between scrolling in and scrolling out.
hiliteStart

The beginning of the text to be highlighted.
hiliteEnd

The end of the text to be highlighted. If the hiliteEnd parameter is greater than the hiliteStart parameter, then the text is highlighted from the selection specified by hiliteStart to hiliteEnd. To specify additional highlighting, you can use TextMediaAddHiliteSample.
rgbHiliteColor

Contains a pointer to an RGBColor structure that defines the color for highlighting. If this parameter is not NIL, then the specified color is used when highlighting the text indicated by the hiliteStart and hiliteEnd parameters. Otherwise, the default system highlight color is used.
duration

A time value that specifies how long the text sample should last. This duration is expressed in the media's time base.
sampleTime

Contains a pointer to a time value. The actual media time at which the sample was added is returned here.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Special Considerations

Be sure to turn on the dfDropShadow display flag after you call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
ComponentResult TextMediaAddTextSample (
   MediaHandler     mh,
   Ptr              text,
   unsigned long    size,
   short            fontNumber,
   short            fontSize,
   Style            textFace,
   RGBColor         *textColor,
   RGBColor         *backColor,
   short            textJustification,
   Rect             *textBox,
   long             displayFlags,
   TimeValue        scrollDelay,
   short            hiliteStart,
   short            hiliteEnd,
   RGBColor         *rgbHiliteColor,
   TimeValue        duration,
   TimeValue        *sampleTime ){};



/*MCSetVisible

Lets your application control the visibility of a movie controller.

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
visible

Set to TRUE to cause the controller to be visible, or FALSE to make the controller invisible.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetVisible (
   MovieController    mc,
   Boolean            visible ){};


/*MCIsControllerAttached

Returns a value that indicates whether a movie controller is attached to its movie.

ComponentResult MCIsControllerAttached (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is attached, the returned value is set to 1. If the controller is not attached, the returned value is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsControllerAttached (
   MovieController    mc ){};



/*SGGrabCompressComplete

Provides the default behavior for your grab-compress-complete function.

ComponentResult SGGrabCompressComplete (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *tr );
Parameters
c

The connection identifier for the channel for this operation. The sequence grabber provides this value to your grab-compress-complete function.
queuedFrameCount

A pointer to the number of queued frames yet to be done. 0 means no frames. Some VDIGs may return 2 even if more than 2 frames are available, and some will return 1 if any number more than 0 are available.
ci

A pointer to an SGCompressInfo structure. When the operation is complete, the function fills in this structure with information about the compression operation.
tr

A pointer to a TimeRecord structure. When the operation is complete, the function uses this structure to indicate when the frame was grabbed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

By setting the SGGrabCompressCompleteBottleProc callback and calling this function, your application can determine how many frames are currently queued in the VDIG, which can be useful for real-time processing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGGrabCompressComplete (
   SGChannel         c,
   UInt8             *queuedFrameCount,
   SGCompressInfo    *ci,
   TimeRecord        *tr ){};




/*SGGetTimeBase

Retrieves a reference to the time base that is being used by a sequence grabber component.

ComponentResult SGGetTimeBase (
   SeqGrabComponent    s,
   TimeBase            *tb );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
tb

A pointer to a time base identifier, such as that returned by NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetTimeBase (
   SeqGrabComponent    s,
   TimeBase            *tb ){};


/*SGGetVideoDigitizerComponent

Determines the video digitizer component that is providing source video to a video channel component.

ComponentInstance SGGetVideoDigitizerComponent (
   SGChannel    c );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
Return Value

A component instance that identifies the connection between your video channel component and its video digitizer component. If your video channel component does not use a video digitizer component, set this returned value to NIL.
Discussion

This function allows the sequence grabber component to determine the video digitizer component that is providing source video to your video channel component. For example, the sequence grabber component can use this function to obtain access to the video digitizer component so that the grabber component can set the digitizer's parameters.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentInstance SGGetVideoDigitizerComponent (
   SGChannel    c ){};

/*SGGetAlignmentProc

Obtains information about the best screen positions for a sequence grabber's video image in terms of appearance and maximum performance.

ComponentResult SGGetAlignmentProc (
   SeqGrabComponent             s,
   ICMAlignmentProcRecordPtr    alignmentProc );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
alignmentProc

A pointer to an ICMAlignmentProcRecord structure. The sequence grabber places its alignment information into this structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetAlignmentProc (
   SeqGrabComponent             s,
   ICMAlignmentProcRecordPtr    alignmentProc ){};

/*SGSetVideoRect

Specifies a part of the source video image that is to be captured by a sequence grabber component.

ComponentResult SGSetVideoRect (
   SGChannel     c,
   const Rect    *r );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
r

A pointer to the Rect structure that defines the portion of the source video image to be captured. This rectangle must lie within the boundaries of the source video boundary rectangle, which the sequence grabber can obtain by calling SGGetSrcVideoBounds. If you do not use this function to set a source rectangle, the sequence grabber component captures the entire video image, as defined by the source video boundary rectangle.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You cannot call this function during a record operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetVideoRect (
   SGChannel     c,
   const Rect    *r ){};



/*SGGetVideoBottlenecks

Determines the callback functions that have been assigned to a video channel.

ComponentResult SGGetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
vb

A pointer to a VideoBottles structure. This function sets the fields of that structure to indicate the callback functions that have been assigned to this video channel. You must set the procCount field in the VideoBottles structure to 9.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb ){};


/*NewSGDataUPP

Allocates a Universal Procedure Pointer for the SGDataProc callback.

SGDataUPP NewSGDataUPP (
   SGDataProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGDataProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SGDataUPP NewSGDataUPP (
   SGDataProcPtr    userRoutine ){};


/*SGGetChannelTimeBase

Retrieves a reference to the time base that is being used by a sequence grabber channel.

ComponentResult SGGetChannelTimeBase (
   SGChannel    c,
   TimeBase     *tb );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
tb

A pointer to a time base identifier, such as that returned by NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGGetChannelTimeBase (
   SGChannel    c,
   TimeBase     *tb ){};


/*SGSetFrameRate

Specifies a video channel's frame rate for recording.

ComponentResult SGSetFrameRate (
   SGChannel    c,
   Fixed        frameRate );
Parameters
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
frameRate

The desired frame rate. If this parameter is set to 0, use your channel's default frame rate. Typically, this corresponds to the fastest rate that your channel can support.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetFrameRate (
   SGChannel    c,
   Fixed        frameRate ){};

/*SGSetVideoBottlenecks

Assigns callback functions to a video channel.

ComponentResult SGSetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb );
Parameters
c

The connection identifier for the video channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
vb

A pointer to a VideoBottles structure, which identifies the callback functions to be assigned to the video channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SGSetVideoBottlenecks (
   SGChannel       c,
   VideoBottles    *vb ){};

/*NewSGGrabCompressCompleteBottleUPP

Allocates a Universal Procedure Pointer for the SGGrabCompressCompleteBottleProc callback.

SGGrabCompressCompleteBottleUPP NewSGGrabCompressCompleteBottleUPP (
   SGGrabCompressCompleteBottleProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSGGrabCompressCompleteBottleProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SGGrabCompressCompleteBottleUPP NewSGGrabCompressCompleteBottleUPP (
   SGGrabCompressCompleteBottleProcPtr    userRoutine ){};




/*RectMatrix

Creates a matrix that performs the translate and scale operation described by the relationship between two rectangles.

void RectMatrix (
   MatrixRecord    *matrix,
   const Rect      *srcRect,
   const Rect      *dstRect );
Parameters
matrix

A pointer to a MatrixRecord structure. This function updates the contents of this matrix so that the matrix describes a transformation from points in the rectangle specified by the srcRect parameter to points in the rectangle specified by the dstRect parameter. The previous contents of the matrix are ignored.
srcRect

A pointer to the source Rect structure.
dstRect

A pointer to the destination Rect structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void RectMatrix (
   MatrixRecord    *matrix,
   const Rect      *srcRect,
   const Rect      *dstRect ){};




/*DecompressSequenceBeginS

Sends a sample image to a decompressor.

OSErr DecompressSequenceBeginS (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   Ptr                       data,
   long                      dataSize,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec );
Parameters
seqID

A pointer to a field to receive the unique identifier for the sequence you are creating. You should use this identifier for subsequent calls relating to this decompression sequence.
desc

A handle to the ImageDescription structure that describes the compressed image.
data

Points to the compressed image data. This pointer must contain a 32-bit clean address. Ideally, you should pass a pointer to the first frame of the compressed image data, which lets the Image Compression Manager do a better job of preflighting the decompression sequence. If the image data is not available at the time of this call, you can pass NIL for this parameter and 0 for dataSize. If you pass NIL here, then your first call to DecompressSequenceFrameWhen may require more setup time.
dataSize

The size of the data buffer, or 0 if you passed NIL in the data parameter.
port

Points to the CGrafPort structure for the destination image.
gdh

A handle to the GDevice structure for the destination image. You can pass NIL if the GDevice is implicit in the port selection (for example, if it is an offscreen graphics world).
srcRect

A pointer to a Rect structure that defines the portions of the image to decompress. Pass NIL if you want to decompress the entire source image. You can call SetDSequenceSrcRect to change the source rectangle for an active decompression sequence.
matrix

Points to a MatrixRecord structure that specifies how to transform the image during decompression. Pass NIL to use the identity matrix. Your application can change the matrix for an active sequence by calling SetDSequenceMatrix.
mode

The transfer mode for the operation. See Graphics Transfer Modes. Your application can change the transfer mode for an active sequence by calling SetDSequenceTransferMode.
mask

A handle to a clipping region in the destination coordinate system. If specified, the compressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL. Your application can change the clipping mask for an active sequence by calling SetDSequenceMask.
flags

Buffer allocation flags (see below). See these constants: 
codecFlagUseScreenBuffer
codecFlagUseImageBuffer
accuracy

A constant (see below) that defines the desired compression accuracy. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
codec

A decompressor identifier. Specify a particular decompressor by setting this parameter to its identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
Return Value

See Error Codes. Returns codecWouldOffscreenErr if codecFlagDontUseImageBuffer is set and the codec requires an offscreen buffer to decompress to the destination port. Returns noErr if there is no error.
Discussion

This function lets you pass a compressed sample so a codec can perform preflighting before the first DecompressSequenceFrameWhen call. To decompress a series of images, call it once to preflight the decompressor, make calls to DecompressSequenceFrameWhen to decompress each image in the sequence, then call CDSequenceEnd when you are done.
Version Notes

Introduced in QuickTime 1.6.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressSequenceBeginS (
   ImageSequence             *seqID,
   ImageDescriptionHandle    desc,
   Ptr                       data,
   long                      dataSize,
   CGrafPtr                  port,
   GDHandle                  gdh,
   const Rect                *srcRect,
   MatrixRecordPtr           matrix,
   short                     mode,
   RgnHandle                 mask,
   CodecFlags                flags,
   CodecQ                    accuracy,
   DecompressorComponent     codec ){};

/*GetTimeBaseTime

Obtains the current time value from a time base.

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from the NewTimeBase function.
s

The time scale in which to return the current time value. Set this parameter to 0 to retrieve the time in the preferred time scale of the time base.
tr

A pointer to a time structure that is to receive the current time value. This is an optional parameter. If you don't want the time value represented in a time structure, set this parameter to NIL.
Return Value

The time base's current time.
Discussion

This function returns a time value that contains the current time from the specified time base in the specified time scale. The function returns this value even if you specify a time structure with the tr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue GetTimeBaseTime (
   TimeBase      tb,
   TimeScale     s,
   TimeRecord    *tr ){};


/*SetTimeBaseMasterClock

Assigns a clock component to a time base.

void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero );
Parameters
slave

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
clockMeister

The clock component to be assigned to this time base. Your application can obtain this component identifier from FindNextComponent.
slaveZero

A pointer to the time, in the clock's time scale, that corresponds to a 0 time value for the slave time base. This parameter allows you to set an offset between the time base and the clock component. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A time base derives its time from either a clock component or from another time base. Don't use this function to assign a clock to a movie's time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseMasterClock (
   TimeBase            slave,
   Component           clockMeister,
   const TimeRecord    *slaveZero ){};






/*NewMovieFromFile

Creates a new movie in memory from a movie file or from any type of file for which QuickTime provides an import component (AIFF, JPEG, MPEG-4, etc).

OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged );
Parameters
theMovie

A pointer to a field that is to receive the new movie's identifier. If the function cannot load the movie, the returned identifier is set to NIL.
resRefNum

The movie file from which the movie is to be loaded. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that specifies the resource containing the movie data that is to be loaded. If the field referred to by the resId parameter is set to 0, the Movie Toolbox loads the first movie resource it finds in the specified file. The Movie Toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. An enumerated constant (see below) is available. See these constants: 
movieInDataForkResID
resName

A pointer to a character string that is to receive the name of the movie resource that is loaded. If you set the resName parameter to NIL, the Movie Toolbox does not return the resource name.
newMovieFlags

Flags (see below) that control the operation of NewMovieFromFile. Be sure to set unused flags to 0. See these constants: 
newMovieActive
newMovieDontResolveDataRefs
newMovieDontAskUnresolvedDataRefs
dataRefWasChanged

A pointer to a Boolean value. The Movie Toolbox sets the value to TRUE if any references were changed. Use UpdateMovieResource to preserve these changes. Set this parameter to NIL if you don't want to receive this information. See NewMovieTrack for more information about data references.
Return Value

If the Movie Toolbox cannot completely resolve all data references, it sets the current error value to couldNotResolveDataRef. You can access error returns such as this through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox sets many movie characteristics to default values. If you want to change these defaults, your application must call other Movie Toolbox functions. For example, the Movie Toolbox sets the movie's graphics world to the one that is active when you call NewMovieFromFile. To change the graphics world for the new movie, your application should use SetMovieGWorld.

The following is an example of using this function:// NewMovieFromFile coding example
// See "Discovering QuickTime," page 385
Movie MyGetMovie (void)
{
    OSErr                   nErr;
    SFTypeList              types ={MovieFileType, 0, 0, 0};
    StandardFileReply       sfr;
    Movie                   movie =NIL;
    short                   nFileRefNum;
    StandardGetFilePreview(NIL, 1, types, &sfr);
    if (sfr.sfGood) {
        nErr =OpenMovieFile(&sfr.sfFile, &nFileRefNum, fsRdPerm);
        if (nErr ==noErr) {
            short           nResID =0;         //We want the first movie.
            Str255          strName;
            Boolean         bWasChanged;
 
            nErr =NewMovieFromFile(&movie, nFileRefNum, &nResID, strName,
                                    newMovieActive, &bWasChanged);
            CloseMovieFile(nFileRefNum);
        }
    }
    return movie;
}

Special Considerations

The Movie Toolbox automatically sets the movie's graphics world based on the current graphics port. Be sure that your application's graphics port is valid before you call this function, even if the movie is sound-only; you can use GetGWorld to check for a valid port, or you can use NewGWorld to create a port. The graphics port must remain valid for the life of the movie or until you set another valid graphics port for the movie using SetMovieGWorld.
Special Considerations

This function works with some files that don't contain movie resources. When it encounters a file that does not contain a movie resource, it tries to find a movie import component that can understand the data and create a movie. It also works for MPEG, uLaw (.AU), and Wave (.WAV) file types. In some cases, the data in a file is already sufficiently well formatted for QuickTime or its components to understand. For example, the AIFF movie data import component can understand AIFF sound files and import the sound data into a QuickTime movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewMovieFromFile (
   Movie        *theMovie,
   short        resRefNum,
   short        *resId,
   StringPtr    resName,
   short        newMovieFlags,
   Boolean      *dataRefWasChanged ){};


/*CloseMovieFile

Closes an open movie file.

OSErr CloseMovieFile (
   short    resRefNum );
Parameters
resRefNum

The movie file to close. Your application obtains this reference number from OpenMovieFile.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code shows a typical use of CloseMovieFile.// CloseMovieFile coding example
// See "Discovering QuickTime," page 50
void OpenMovie (HWND hwnd, char *szFileName)
{
    short   nFileRefNum =0;
    FSSpec  fss;
    // Convert path to FSSpec
    NativePathNameToFSSpec(szFileName, &fss, 0);
    // Set graphics port
    SetGWorld((CGrafPtr)GetNativeWindowPort(hwnd), NIL);
    OpenMovieFile(&fss, &nFileRefNum, fsRdPerm);   // Open movie file
    NewMovieFromFile(&movie, nFileRefNum, NIL,    // Get movie from file
                        NIL, newMovieActive, NIL);
    CloseMovieFile(nFileRefNum);                   // Close movie file
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CloseMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CloseMovieFile (
   short    resRefNum ){};

/*CreateMovieFile

Creates a movie file, creates an empty movie which references the file, and opens the movie file with write permission.

OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Controls movie file creation flags (see below). See these constants: 
createMovieFileDontCreateResFile
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
newMovieActive
resRefNum

A pointer to a field that is to receive the file reference number for the opened movie file. Your application must use this value when calling other Movie Toolbox functions that work with movie files. If you set this parameter to NIL, the Movie Toolbox creates the movie file but does not open the file.
newmovie

A pointer to a field that is to receive the identifier of the new movie. CreateMovieFile returns the identifier of the new movie. If the function could not create a new movie, it sets this returned value to NIL. If you set this parameter to NIL, the Movie Toolbox does not create a movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how CreateMovieFile may be used to create and open a QuickTime movie file.// CreateMovieFile coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);   // See "Discovering QuickTime," page 244
    CreateMySoundTrack(movie);   // See "Discovering QuickTime," page 250
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by CreateMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CreateMovieFile (
   const FSSpec    *fileSpec,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags,
   short           *resRefNum,
   Movie           *newmovie ){};

/*AddMovieResource

Adds a movie resource to a specified resource file.

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to add to the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file to which the resource is to be added. Your application obtains this value from the OpenMovieFile function.
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by resId is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. AddMovieResource assigns resource ID numbers sequentially, starting at 128. If resId is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value. Set resId to movieInDataForkResID to add the new resource to the movie file's data fork (see below). See these constants: 
movieInDataForkResID
resName

Points to a character string that contains the name of the movie resource. If you set resName to NIL, the toolbox creates an unnamed resource.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function adds the movie to the file, effectively saving any changes you have made to the movie. To use this function with single-fork movie files, pass movieInDataForkResID as the resId parameter. After updating the movie file, AddMovieResource clears the movie changed flag, indicating that the movie has not been changed.// AddMovieResource coding example
// See "Discovering QuickTime," page 243
void CreateMyCoolMovie (void)
{
    StandardFileReply   sfr;
    Movie               movie =NIL;
    FSSpec              fss;
    short               nFileRefNum =0;
    short               nResID =movieInDataForkResID;
    StandardPutFile("\pEnter movie file name:", "\puntitled.mov", &sfr);
    if (!sfr.sfGood)
        return;
    CreateMovieFile(&sfr.sfFile,
                    FOUR_CHAR_CODE('TVOD'),
                    smCurrentScript,
                    createMovieFileDeleteCurFile |
                     createMovieFileDontCreateResFile,
                    &nFileRefNum,
                    &movie);
    CreateMyVideoTrack(movie);      // See next section
    CreateMySoundTrack(movie);      // See next section
    AddMovieResource(movie, nFileRefNum, &nResID, NIL);
    if (nFileRefNum !=0)
        CloseMovieFile(nFileRefNum);
    DisposeMovie(movie);
}

Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by AddMovieToStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               *resId,
   ConstStr255Param    resName ){};



/*SetMovieBox

Sets a movie's boundary rectangle.

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
boxRect

A pointer to a rectangle that contains the coordinates of the new boundary rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox changes the rectangle by modifying the translation and scale values of the movie's matrix to accommodate the new boundary rectangle.

The movie box might not have its upper-left corner set at (0,0) in its display window when the movie is first loaded. Consequently, your application may need to adjust the position of the movie box so that it appears in the appropriate location within your application's document window. If you don't reset the movie position, the movie might not be visible when it starts playing. The following sample code demonstrates how to do this://Zeroing the boundary rectangle with SetMovieBox
GetMovieBox (movie, &movieBox);
OffsetRect (&movieBox, -movieBox.left, -movieBox.top);
SetMovieBox (movie, &movieBox);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieBox (
   Movie         theMovie,
   const Rect    *boxRect ){};


/*ClearMoviesStickyError

Clears the sticky error value.

void ClearMoviesStickyError ( void );
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The Movie Toolbox saves the same result code in the sticky error value. Your application clears the sticky error value by calling ClearMoviesStickyError. The Movie Toolbox then places the first nonzero result code from any toolbox function used by your application into the sticky error value. The Movie Toolbox does not update the sticky error value until your application clears it again.
Special Considerations

Many Movie Toolbox functions don't return an error as a function result; you must use GetMoviesError to obtain the result code. Even if a function explicitly returns an error as a function result, that result is also available using GetMoviesError. The Movie Toolbox does not place a result code into the sticky error value until the field has been cleared. Your application is responsible for clearing the sticky error value to ensure that it does not contain a stale result code.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ClearMoviesStickyError ( void ){};


/*GetTrackVolume

Returns a track's current volume setting.

short GetTrackVolume (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's current volume setting. The values returned in the high and low words range from 0x0000 (silence) to 0x0100 (full volume). You can use constants (see below) to test for full volume and no volume.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackVolume (
   Track    theTrack ){};


/*GetMediaDataRef

Returns a copy of a specified data reference.

OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

The index value that corresponds to the data reference. It must be less than or equal to the value that is returned by GetMediaDataRefCount.
dataRef

A pointer to a field that is to receive a handle to the data reference. The media handler returns a handle to information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter. If the function cannot locate the specified data reference, the handler sets this returned value to NIL. Set the dataRef parameter to NIL if you are not interested in this information.
dataRefType

A pointer to a field that is to receive the type of data reference. If the data reference is an alias, the media handler sets this value to 'alis'. Set the dataRefType parameter to NIL if you are not interested in this information.
dataRefAttributes

A pointer to a field that is to receive the reference's attribute flags (see below). Unused flags are set to 0. See these constants: 
dataRefSelfReference
dataRefWasNotResolved
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to retrieve information about a data reference. For example, you might want to verify the condition of a movie's data references after loading the movie from its movie file. You could use this function to check each data reference.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRef (
   Media     theMedia,
   short     index,
   Handle    *dataRef,
   OSType    *dataRefType,
   long      *dataRefAttributes ){};


/*InsertTrackSegment

Copies data into a track.

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. This function places a copy of the segment, which is obtained from the source track, into this destination track. The media for the destination track must be opened for writing by calling BeginMediaEdits in order for the data to be copied. If the media is not opened for writing, the segment will be copied by reference. At the end of the editing session, your application must call EndMediaEdits if it has called BeginMediaEdits.
srcIn

The start of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
srcDuration

The duration of the segment in the source track. This time value must be expressed in the time scale of the movie that contains the source track.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the time scale of the movie that contains the destination track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are copying data between tracks, make sure that the two tracks are of the same type. For example, you cannot copy a segment from a sound track into a video track. If you have assigned a progress function to the movie that contains the destination track, the Movie Toolbox calls that progress function during long copy operations.
Special Considerations

If you copy a segment without calling BeginMediaEdits on the destination track's media, the data can be copied later by flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr InsertTrackSegment (
   Track        srcTrack,
   Track        dstTrack,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn ){};

/*CopyTrackSettings

Copies many settings from one track to another, overwriting the destination settings.

OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstTrack

The destination track for this operation. The CopyTrackSettings function uses the settings from the source track, which you specify with the srcTrack parameter, to replace the current settings of this track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function copies matrix information, track volume, the clipping region, user data, matte information, media language, quality, user data, and other media-specific settings (such as sound balance and video graphics mode). It does not copy any alternate group information pertaining to the track. This function does not copy the track's contents. To work with track contents, you should use segment-editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CopyTrackSettings (
   Track    srcTrack,
   Track    dstTrack ){};

/*GetMoviesStickyError

Returns the contents of the sticky error value.

OSErr GetMoviesStickyError ( void );
Return Value

See Error Codes. Returns noErr if there is no error in the sticky error value.
Discussion

The sticky error value contains the first nonzero result code from any Movie Toolbox function that you called after having cleared the sticky error with ClearMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMoviesStickyError ( void ){};


/*UpdateMovieResource

Replaces the contents of a movie resource in a specified movie file.

OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie you wish to place in the movie file. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
resRefNum

Identifies the movie file that contains the resource to be changed. Your application obtains this value from OpenMovieFile.
resId

The resource to be changed. This value is obtained from a previous call to NewMovieFromFile, NewMovieFromDataRef, or AddMovieResource. If you specify a single-fork movie file by passing the movieInDataForkResID constant, the Movie Toolbox places the movie resource into the file's data fork.
resName

Points to a new name for the resource. If you don't want to change the resource's name, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the movie that is to be placed into the resource. This function can accommodate single-fork movie files. After updating the movie file, this function clears the movie changed flag.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by UpdateMovieInStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr UpdateMovieResource (
   Movie               theMovie,
   short               resRefNum,
   short               resId,
   ConstStr255Param    resName ){};



/*SetTrackLayer

Sets a track's layer.

void SetTrackLayer (
   Track    theTrack,
   short    layer );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
layer

The track's layer number. Layers are numbered from -32,768 through 32,767. When you create a new track, the Movie Toolbox sets its track number to 0.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackLayer (
   Track    theTrack,
   short    layer ){};


/*GetTrackLayer

Retrieves a track's layer.

short GetTrackLayer (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's layer number.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetTrackLayer (
   Track    theTrack ){};



/*GetTrackOffset

Determines the time difference between the start of a track and the start of the movie that contains the track.

TimeValue GetTrackOffset (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The time difference between the start of the specified track and the start of the movie that contains the track.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetTrackOffset (
   Track    theTrack ){};

/*SetMovieTimeValue

Sets a movie's time value.

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
newtime

The new time value. You must ensure that the time value is in the movie's time scale.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieTimeValue (
   Movie        theMovie,
   TimeValue    newtime ){};

/*GetTrackSegmentDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world during a specified segment.

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The starting time of the track segment to consider. This time value must be expressed in the movie's time coordinate system. The duration parameter specifies the length of the segment.
duration

The length of the segment to consider. Set this parameter to 0 to consider an instant in time.
Return Value

A handle to the region the specified track occupies in its movie's graphics world during a specified segment. If the track does not have a spatial representation during the specified segment, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Discussion

This function allocates the region and returns a handle to it. This region is valid for the specified segment.
Special Considerations

Your application must dispose of the returned region when you are done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetTrackSegmentDisplayBoundsRgn (
   Track        theTrack,
   TimeValue    time,
   TimeValue    duration ){};


/*GetMovieGWorld

Returns a movie's graphics world.

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
port

A pointer to a field that is to receive a pointer to a CGrafPort structure. Set this parameter to NIL if you don't want this information.
gdh

A pointer to a field that is to receive a handle to a GDevice structure. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieGWorld (
   Movie       theMovie,
   CGrafPtr    *port,
   GDHandle    *gdh ){};



/*GetMovieMatrix

Retrieves a movie's transformation matrix.

void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to a MatrixRecord structure, where GetMovieMatrix returns the movie's matrix.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieMatrix (
   Movie           theMovie,
   MatrixRecord    *matrix ){};


/*GetTrackMatrix

Retrieves a track's transformation matrix.

void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure. The GetTrackMatrix function returns the track's matrix into the structure referred to by this parameter.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetTrackMatrix (
   Track           theTrack,
   MatrixRecord    *matrix ){};


/*ConcatMatrix

Concatenates two matrices, combining the transformations described by both matrices into a single matrix.

void ConcatMatrix (
   const MatrixRecord    *a,
   MatrixRecord          *b );
Parameters
a

A pointer to the source matrix.
b

A pointer to the destination matrix. The ConcatMatrix function performs a matrix multiplication operation on the two matrices and leaves the result in the matrix specified by this parameter.
Discussion

This is a matrix multiplication operation, as a result of which [B] =[B] x [A]. Note that matrix multiplication is not commutative.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void ConcatMatrix (
   const MatrixRecord    *a,
   MatrixRecord          *b ){};


/*TrackTimeToMediaTime

Converts a track's time value to a time value that is appropriate to the track's media, using the track's edit list.

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack );
Parameters
value

The track's time value; must be expressed in the time scale of the movie that contains the track.
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The track's time value, but in the media's time coordinate system. If the track time corresponds to empty space, this function returns a value of -1.
Discussion

This function maps the track time through the track's edit list to come up with the media time. This time value contains the track's time value according to the media's time coordinate system. If the time you specified lies outside of the movie's active segment or corresponds to empty space in the track, this function returns a value of -1. Hence you can use it to determine whether a specified track edit is empty.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

TimeValue TrackTimeToMediaTime (
   TimeValue    value,
   Track        theTrack ){};



/*GetMediaSample

Returns a sample from a movie data file.

OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOut

A handle. The GetMediaSample function returns the sample data into this handle. The function increases the size of this handle, if necessary. You can specify the handle's maximum size with the maxSizeToGrow parameter.
maxSizeToGrow

The maximum number of bytes of sample data to be returned. The GetMediaSample function does not increase the handle specified by the dataOut parameter to a size greater than you specify with this parameter. Set this value to 0 to enforce no limit on the number of bytes to be returned.
size

A pointer to a long integer. The GetMediaSample function updates the field referred to by the size parameter with the number of bytes of sample data returned in the handle specified by the dataOut parameter. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. The GetMediaSample function updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. The GetMediaSample function returns the sample description corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want a SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. The GetMediaSample function returns an index value to the SampleDescription structure that corresponds to the returned sample data. You can retrieve the structure by calling GetMediaSampleDescription and passing this index in the descH parameter. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media, and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. The GetMediaSample function updates the field referred to by this parameter with the number of samples it actually returns. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSample returns flags (see below) that describe the sample. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSample (
   Media                      theMedia,
   Handle                     dataOut,
   long                       maxSizeToGrow,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags ){};

/*SetMediaSampleDescription

Changes the contents of a particular SampleDescription structure of a specified media.

OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
index

The index of the SampleDescription structure to be changed. This index corresponds to the SampleDescription structure itself, not the samples in the media. This long integer must be between 1 and the largest SampleDescription index.
descH

The handle to the SampleDescription structure. If there is no description for the specified index, the function returns this handle unchanged.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaSampleDescription (
   Media                      theMedia,
   long                       index,
   SampleDescriptionHandle    descH ){};


/*GetTrackDisplayBoundsRgn

Determines the region a track occupies in a movie's graphics world.

RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A handle to the region the specified track occupies in a movie's graphics world.
Discussion

This function allocates the region and returns a handle to the region. If the track does not have a spatial representation at the current movie time, the function returns an empty region. If the function could not satisfy your request, it sets the returned handle to NIL.
Special Considerations

Your application must dispose of the returned region when you are done with it. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
RgnHandle GetTrackDisplayBoundsRgn (
   Track    theTrack ){};


/*FCompressImage

Compresses a single-frame image that is currently stored as a pixel map structure, with added control over the compression process.

OSErr FCompressImage (
   PixMapHandle                src,
   const Rect                  *srcRect,
   short                       colorDepth,
   CodecQ                      quality,
   CodecType                   cType,
   CompressorComponent         codec,
   CTabHandle                  ctable,
   CodecFlags                  flags,
   long                        bufferSize,
   ICMFlushProcRecordPtr       flushProc,
   ICMProgressProcRecordPtr    progressProc,
   ImageDescriptionHandle      desc,
   Ptr                         data );
Parameters
src

A handle to the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress.
colorDepth

The depth at which the image is likely to be viewed. Compressors may use this as an indication of the color or grayscale resolution of the compressed image. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by the GetCodecInfo function.
quality

A constant (see below) that defines the desired compressed image quality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
cType

A compressor type. You must set this parameter to a valid compressor type constant.
codec

A compressor identifier. Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
ctable

A handle to a custom color lookup table. Your program may use this parameter to indicate a custom color lookup table to be used with this image. If the value of the colorDepth parameter is less than or equal to 8 and the custom color lookup table is different from that of the source pixel map (that is, the ctSeed field values differ in the two pixel maps), the compressor remaps the colors of the image to the custom colors. If you set the colorDepth parameter to 16, 24, or 32, the compressor stores the custom color table with the compressed image. The compressor may use the table to specify the best colors to use when displaying the image at lower bit depths. The compressor ignores the ctable parameter when colorDepth is set to 33, 34, 36, or 40. If you set this parameter to NIL, the compressor uses the color lookup table from the source pixel map.
flags

Contains a flag (see below) that indicates whether or not the image was previously compressed. See these constants: 
codecFlagWasCompressed
bufferSize

The size of the buffer to be used by the data-unloading function specified by the flushProc parameter. If you have not specified a data-unloading function, set this parameter to 0.
flushProc

Points to an ICMDataProc data-unloading callback. If there is not enough memory to store the compressed image, the compressor calls a function you provide that unloads some of the compressed data. If you have not provided a data-unloading callback, set this parameter to NIL. In this case, the compressor writes the entire compressed image into the memory location specified by the data parameter.
progressProc

Points to an ICMProgressProc progress callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress callback, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned ImageDescription structure. Your application should store this image description with the compressed image data.
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. If there is not sufficient memory to store the compressed image, you may choose to write the compressed data to mass storage during the compression operation. Use the flushProc parameter to identify your data-unloading function to the compressor. This pointer must contain a 32-bit clean address. The Image Compression Manager places the actual size of the compressed image into the dataSize field of the ImageDescription structure referenced by the desc parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function acts like CompressImage, but gives your application additional control over the parameters that guide the compression operation.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr FCompressImage (
   PixMapHandle                src,
   const Rect                  *srcRect,
   short                       colorDepth,
   CodecQ                      quality,
   CodecType                   cType,
   CompressorComponent         codec,
   CTabHandle                  ctable,
   CodecFlags                  flags,
   long                        bufferSize,
   ICMFlushProcRecordPtr       flushProc,
   ICMProgressProcRecordPtr    progressProc,
   ImageDescriptionHandle      desc,
   Ptr                         data ){};


/*AddMediaSample

Adds sample data and a description to a media.

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataIn

A handle to the sample data. The AddMediaSample function adds this data to the media specified by the parameter theMedia. You specify the number of bytes of sample data with the size parameter. You can use the inOffset parameter to specify a byte offset into the data referred to by this handle.
inOffset

Specifies an offset into the data referred to by the handle contained in the dataIn parameter. Set this parameter to 0 if there is no offset.
size

The number of bytes of sample data to be added to the media. This parameter indicates the total number of bytes in the sample data to be added to the media, not the number of bytes per sample. Use the numberOfSamples parameter to indicate the number of samples that are contained in the sample data.
durationPerSample

The duration of each sample to be added. You must specify this parameter in the media's time scale. For example, if you are adding sound that was sampled at 22 kHz to a media that contains a sound track with the same time scale, you would set durationPerSample to 1. Similarly, if you are adding video that was recorded at 10 frames per second to a video media that has a time scale of 600, you would set this parameter to 60 to add a single sample.
sampleDescriptionH

A handle to a SampleDescription structure. Some media structures may require sample descriptions. There are different descriptions for different types of samples. For example, a media that contains compressed video requires that you supply an ImageDescription structure. A media that contains sound requires that you supply a SoundDescription structure. If the media does not require a SampleDescription structure, set this parameter to NIL.
numberOfSamples

The number of samples contained in the sample data to be added to the media. The Movie Toolbox considers the value of this parameter as well as the value of the size parameter when it determines the size of each sample that it adds to the media. You should set the value of this parameter so that the resulting sample size represents a reasonable compromise between total data retrieval time and the overhead associated with input and output (I/O). You should also consider the speed of the data storage device; CD-ROM devices are much slower than hard disks, for example, and should therefore have a smaller sample size. For a video media, set a sample size that corresponds to the size of a frame. For a sound media, choose a number of samples that corresponds to between 0.5 and 1.0 seconds of sound. In general, you should not create groups of sound samples that are less than 2 KB in size or greater than 15 KB. Typically, a sample size of about 8 KB is reasonable for most storage devices.
sampleFlags

Contains flags (see below) that control the add operation. Set unused flags to 0. See these constants: 
mediaSampleNotSync
sampleTime

A pointer to a time value. After adding the sample data to the media, the AddMediaSample function returns the time where the sample was inserted in the time value referred to by this parameter. If you don't want to receive this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application specifies the sample and the media for the operation. AddMediaSample updates the media so that it contains the sample data. One call to this function can add several samples to a media; however, all the samples must be the same size. Samples are always appended to the end of the media. Furthermore, the media duration is extended each time a sample is added.// AddMediaSample coding example
// See "Discovering QuickTime," page 250
#define kSoundSampleDuration    1
#define kSyncSample             0
#define kTrackStart             0
#define kMediaStart             0
#define kFix1                   0x00010000
void CreateMySoundTrack (Movie movie)
{
    Track                       track;
    Media                       media;
    Handle                      hSound =NIL;
    SoundDescriptionHandle      hSoundDesc =NIL;
    long                        lDataOffset;
    long                        lDataSize;
    long                        lNumSamples;
    hSound =GetResource(soundListRsrc, 128);
    if (hSound ==NIL)
        return;
    hSoundDesc =(SoundDescriptionHandle)NewHandle(4);
 
    CreateMySoundDescription(hSound,
                            hSoundDesc,
                            &lDataOffset,
                            &lNumSamples,
                            &lDataSize);
 
    track =NewMovieTrack(movie, 0, 0, kFullVolume);
    media =NewTrackMedia(track, SoundMediaType,
                                FixRound((**hSoundDesc).sampleRate),
                                NIL, 0);
    BeginMediaEdits(media);
    AddMediaSample(media,
                    hSound,
                    lDataOffset,        // offset in data
                    lDataSize,
                    kSoundSampleDuration,   // duration of each sound
                                            //  sample
                    (SampleDescriptionHandle)hSoundDesc,
                    lNumSamples,
                    kSyncSample,        // self-contained samples
                    NIL);
    EndMediaEdits(media);
    InsertMediaIntoTrack(track,
                            kTrackStart,    // track start time
                            kMediaStart,    // media start time
                            GetMediaDuration(media),
                            kFix1);
    if (hSoundDesc !=NIL)
        DisposeHandle((Handle)hSoundDesc);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr AddMediaSample (
   Media                      theMedia,
   Handle                     dataIn,
   long                       inOffset,
   unsigned long              size,
   TimeValue                  durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       numberOfSamples,
   short                      sampleFlags,
   TimeValue                  *sampleTime ){};


/*GraphicsImportGetImageDescription

Returns image description information for an imported image.

ComponentResult GraphicsImportGetImageDescription (
   GraphicsImportComponent    ci,
   ImageDescriptionHandle     *desc );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
desc

Points to a handle to an ImageDescription structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns an ImageDescription structure containing information such as the format of the compressed data, its bit depth, natural bounds, and resolution.
Special Considerations

The caller is responsible for disposing of the returned image description handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetImageDescription (
   GraphicsImportComponent    ci,
   ImageDescriptionHandle     *desc ){};




/*ScaleMatrix

Modifies the contents of a matrix so that it defines a scaling operation.

void ScaleMatrix (
   MatrixRecord    *m,
   Fixed           scaleX,
   Fixed           scaleY,
   Fixed           aboutX,
   Fixed           aboutY );
Parameters
m

A pointer to a MatrixRecord structure. The ScaleMatrix function updates the contents of this matrix so that the matrix describes a scaling operation; that is, it concatenates the respective transformations onto whatever was initially in the matrix structure. You specify the magnitude of the scaling operation with the scaleX and scaleY parameters. You specify the anchor point with the aboutX and aboutY parameters.
scaleX

The scaling factor applied to x coordinates.
scaleY

The scaling factor applied to y coordinates.
aboutX

The x coordinate of the anchor point.
aboutY

The y coordinate of the anchor point.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void ScaleMatrix (
   MatrixRecord    *m,
   Fixed           scaleX,
   Fixed           scaleY,
   Fixed           aboutX,
   Fixed           aboutY ){};


/*QTNewGWorldFromPtr

Wraps a graphics world and pixel map structure around an existing block of memory containing an image.

OSErr QTNewGWorldFromPtr (
   GWorldPtr      *gw,
   OSType         pixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags,
   void           *baseAddr,
   long           rowBytes );
Parameters
gw

On entry, a pointer that isn't going to change during the lifetime of the allocated graphics world. On return, this pointer references the offscreen graphics world created by this function.
pixelFormat

The new graphics world's pixel format; see Pixel Formats.
boundsRect

A pointer to the boundary rectangle and port rectangle for the offscreen pixel map. This becomes the boundary rectangle for the GDevice structure, if this function creates one. If you specify 0 in the pixelFormat parameter, the function interprets the boundaries in global coordinates that it uses to determine which screens intersect the rectangle. It then uses the pixel format, color table, and GDevice structure from the screen with the greatest pixel depth from among all screens whose boundary rectangles intersect this rectangle. Typically, your application supplies this parameter with the port rectangle for the onscreen window into which your application will copy the pixel image from this offscreen world.
cTable

A handle to a ColorTable structure. If you pass NIL in this parameter, the function uses the default color table for the pixel format that you specify in the pixelFormat parameter. If you set the pixelFormat parameter to 0, the function ignores the cTable parameter and instead copies and uses the color table of the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. If you use this function on a computer that supports only basic QuickDraw, you may specify only NIL in this parameter.
aGDevice

A handle to a GDevice structure that is used only when you specify the noNewDevice flag in the flags parameter, in which case the function attaches this structure to the new offscreen graphics world. If you set the pixelFormat parameter to 0, or if you do not set the noNewDevice flag, the function ignores this parameter, so you should set it to NIL. If you set the pixelFormat parameter to 0, the function uses the GDevice structure for the graphics device with the greatest pixel depth among all graphics devices whose boundary rectangles intersect the rectangle that you specify in the boundsRect parameter. You should pass NIL in this parameter if the computer supports only basic QuickDraw. Generally, your application should never create GDevice structures for offscreen graphics worlds.
flags

A constant (see below) that identifies an option available to your application. If you don't wish to use this option, pass 0 in this parameter. In this case the default behavior is to create an offscreen graphics world that uses an existing GDevice structure (if you pass 0 in the depth parameter) or creates a new GDevice structure. Most constants used in creating a GWorld are irrelevant for this function, as its purpose is to wrap a GWorld around an existing block of pixels rather than to define and create a pixmap. See these constants: 
baseAddr

The base address for the pixel data. 
rowBytes

The total size of the pixel data divided by the height of the pixel map. In other words, the number of bytes in one row of pixels or the number of bytes between vertically adjacent pixels.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function wraps a GWorld around an existing pixel map. Note that it does not copy the pixmap. A subsequent call to DisposeGWorld will not dispose of the pixel map; it will only dispose of the GWorld wrapper. It is the caller's responsibility to dispose of the pixel map.

You can use this call to allocate an offscreen graphics world using special memory (such as on a video card). If you have an image in memory that belong to something else (a hardware screen buffer, a 3D card, or another file format or program), you can use this function to wrap a graphics world around the image and then use QuickTime calls on that graphics world to compress it, scale it, draw to it, and so on. If your new graphics world has a planar pixel format, you must use this call instead of QTNewGWorld.
Special Considerations

Do not unlock the pixels of the allocated graphics world. If your original pixels are from another graphics world then you must ensure that the source pixels are locked.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr QTNewGWorldFromPtr (
   GWorldPtr      *gw,
   OSType         pixelFormat,
   const Rect     *boundsRect,
   CTabHandle     cTable,
   GDHandle       aGDevice,
   GWorldFlags    flags,
   void           *baseAddr,
   long           rowBytes ){};


/*ICMCompressionSessionCompleteFrames

Forces a compression session to complete encoding frames.

OSStatus ICMCompressionSessionCompleteFrames (
   ICMCompressionSessionRef    session,
   Boolean                     completeAllFrames,
   TimeValue64                 completeUntilDisplayTimeStamp,
   TimeValue64                 nextDisplayTimeStamp );
Parameters
session

A reference to a video compression session, returned by a previous call to ICMCompressionSessionCreate.
completeAllFrames

Pass TRUE to direct the session to complete all pending frames.
completeUntilDisplayTimeStamp

A 64-bit time value that represents the display time up to which to complete frames. This value is ignored if completeAllFrames is TRUE.
nextDisplayTimeStamp

A 64-bit time value that represents the display time of the next frame that should be passed to EncodeFrame. This value is ignored unless ICMCompressionSessionOptionsSetDurationsNeeded set TRUE and kICMValidTime_DisplayDurationIsValid was 0 in validTimeFlags in the last call to ICMCompressionSessionEncodeFrame.
Return Value

Returns an error code, or 0 if there is no error. The function may return before frames are completed if the encoded frame callback routine returns an error.
Discussion

Call this function to force a compression session to complete encoding frames. Set completeAllFrames to direct the session to complete all pending frames. If completeAllFrames is false, only frames with display time stamps up to and including the time passed in completeUntilDisplayTimeStamp will be encoded. If ICMCompressionSessionOptionsSetDurationsNeeded set TRUE and you are passing valid display timestamps but not display durations to ICMCompressionSessionEncodeFrame, pass in nextDisplayTimeStamp the display timestamp of the next frame that would be passed to EncodeFrame.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionCompleteFrames (
   ICMCompressionSessionRef    session,
   Boolean                     completeAllFrames,
   TimeValue64                 completeUntilDisplayTimeStamp,
   TimeValue64                 nextDisplayTimeStamp ){};


/*ICMCompressionSessionRelease

Decrements the retain count of a compression session.

void ICMCompressionSessionRelease (
   ICMCompressionSessionRef    session );
Parameters
session

A compression session reference. This reference is returned by ICMCompressionSessionCreate. If you pass NULL, nothing happens.
Discussion

If the retain count drops to 0, the session is disposed. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

void ICMCompressionSessionRelease (
   ICMCompressionSessionRef    session ){};

/*ICMCompressionSessionOptionsCreate

Creates a compression session options object.

OSStatus ICMCompressionSessionOptionsCreate (
   CFAllocatorRef                    allocator,
   ICMCompressionSessionOptionsRef   *options );
Parameters
allocator

An allocator. Pass NULL to use the default allocator.
options

On return, a reference to a new compression session options object.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsCreate (
   CFAllocatorRef                    allocator,
   ICMCompressionSessionOptionsRef   *options ){};


/*ICMEncodedFrameGetDecodeDuration

Retrieves an encoded frame's decode duration.

TimeValue64 ICMEncodedFrameGetDecodeDuration (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's decode duration.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeValue64 ICMEncodedFrameGetDecodeDuration (
   ICMEncodedFrameRef   frame ){};


/*ICMEncodedFrameGetDisplayTimeStamp

Retrieves an encoded frame's display time stamp.

TimeValue64 ICMEncodedFrameGetDisplayTimeStamp (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's display time stamp.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeValue64 ICMEncodedFrameGetDisplayTimeStamp (
   ICMEncodedFrameRef   frame ){};


/*ICMEncodedFrameGetMediaSampleFlags

Retrieves the media sample flags for an encoded frame.

MediaSampleFlags ICMEncodedFrameGetMediaSampleFlags (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The object's media sample flags. These flags are listed in the header file Movies.h.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
MediaSampleFlags ICMEncodedFrameGetMediaSampleFlags (
   ICMEncodedFrameRef   frame ){};

/*ICMEncodedFrameGetDecodeTimeStamp

Retrieves an encoded frame's decode time stamp.

TimeValue64 ICMEncodedFrameGetDecodeTimeStamp (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's decode time stamp.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeValue64 ICMEncodedFrameGetDecodeTimeStamp (
   ICMEncodedFrameRef   frame ){};



/*ICMEncodedFrameGetValidTimeFlags

Retrieves an encoded frame's flags indicating which of its time stamps and durations are valid.

ICMValidTimeFlags ICMEncodedFrameGetValidTimeFlags (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

One of the constants listed below.
Discussion

This function returns one of these values:
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

ICMValidTimeFlags ICMEncodedFrameGetValidTimeFlags (
   ICMEncodedFrameRef   frame ){};


/*ICMEncodedFrameGetDisplayOffset

Retrieves an encoded frame's display offset.

TimeValue64 ICMEncodedFrameGetDisplayOffset (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The encoded frame's display offset. This is the time offset from decode time stamp to display time stamp.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

TimeValue64 ICMEncodedFrameGetDisplayOffset (
   ICMEncodedFrameRef   frame ){};

/*ICMEncodedFrameGetDataSize

Gets the data size of the compressed frame in an encoded frame's buffer.

ByteCount ICMEncodedFrameGetDataSize (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The logical size in bytes of the encoded frame's data buffer, which may be less than the physical size of the buffer.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
ByteCount ICMEncodedFrameGetDataSize (
   ICMEncodedFrameRef   frame ){};



/*ICMEncodedFrameGetTimeScale

Retrieves the timescale of an encoded frame.

TimeScale ICMEncodedFrameGetTimeScale (
   ICMEncodedFrameRef   frame );
Parameters
frame

A reference to an encoded frame object.
Return Value

The time scale of an encoded frame. This is always the same as the time scale of the compression session.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
TimeScale ICMEncodedFrameGetTimeScale (
   ICMEncodedFrameRef   frame ){};


/*ICMCompressionSessionEncodeFrame

Presents video frames to a compression session.

OSStatus ICMCompressionSessionEncodeFrame (
   ICMCompressionSessionRef           session,
   CVPixelBufferRef                   pixelBuffer,
   TimeValue64                        displayTimeStamp,
   TimeValue64                        displayDuration,
   ICMValidTimeFlags                  validTimeFlags,
   ICMCompressionFrameOptionsRef      frameOptions,
   ICMSourceTrackingCallbackRecord    *sourceTrackingCallback,
   void                               *sourceFrameRefCon );
Parameters
session

A reference to a video compression session, returned by a previous call to ICMCompressionSessionCreate.
pixelBuffer

A reference to a buffer containing a source image to be compressed, which must have a nonzero reference count. The session will retain it as long as necessary. The client should not modify the pixel buffer's pixels until the pixel buffer release callback is called. In a multipass encoding session pass, where the compressor suggested the flag kICMCompressionPassMode_NoSourceFrames, you may pass NULL in this parameter.
displayTimeStamp

A 64-bit time value that represents the display time of the frame, using the time scale passed to ICMCompressionSessionCreate. If you pass a valid value, set the kICMValidTime_DisplayTimeStampIsValid flag in the validTimeFlags parameter (below).
displayDuration

A 64-bit time value that represents the display duration of the frame, using the time scale passed to ICMCompressionSessionCreate. If you pass a valid value, set the kICMValidTime_DisplayDurationIsValid flag in the validTimeFlags parameter (below).
validTimeFlags

Flags to indicate which of the values passed in displayTimeStamp and displayDuration are valid: kICMValidTime_DisplayTimeStampIsValid The time value passed in displayTimeStamp is valid. kICMValidTime_DisplayDurationIsValid The time value passed in displayDuration is valid. See these constants: 
kICMValidTime_DisplayTimeStampIsValid
kICMValidTime_DisplayDurationIsValid
frameOptions

Options for this frame. Currently not used; pass NULL.
sourceTrackingCallback

A pointer to a callback to be notified about the status of this source frame. Pass NULL if you do not require notification.
sourceFrameRefCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

Returns an error code, or 0 if there is no error. Encoded frames may or may not be output before the function returns.
Discussion

The session will retain the pixel buffer as long as necessary, and the client should not modify the pixel data until the session releases it. The most practical way to deal with this is by allocating pixel buffers from a pool. The client may fill in both, either, or neither of displayTimeStamp and displayDuration, but should set the appropriate flags to indicate which are valid. If the client needs to track the progress of a source frame, it should provide a source tracking callback. If multipass compression is enabled, calls to this function must be bracketed by calls to ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionEncodeFrame (
   ICMCompressionSessionRef           session,
   CVPixelBufferRef                   pixelBuffer,
   TimeValue64                        displayTimeStamp,
   TimeValue64                        displayDuration,
   ICMValidTimeFlags                  validTimeFlags,
   ICMCompressionFrameOptionsRef      frameOptions,
   ICMSourceTrackingCallbackRecord    *sourceTrackingCallback,
   void                               *sourceFrameRefCon ){};


/*ICMCompressionSessionOptionsSetAllowTemporalCompression

Enables temporal compression.

OSStatus ICMCompressionSessionOptionsSetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowTemporalCompression );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
allowTemporalCompression

Pass TRUE to enable temporal compression, FALSE to disable it.
Return Value

An error code. Returns noErr if there is no error.
Discussion

By default, temporal compression is disabled. If you want temporal compression for P-frames or B-frames you must call this function and pass TRUE. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsSetAllowTemporalCompression (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowTemporalCompression ){};

/*ICMCompressionSessionOptionsSetAllowFrameReordering

Enables frame reordering.

OSStatus ICMCompressionSessionOptionsSetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameReordering );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
allowFrameReordering

Pass TRUE to enable frame reordering, FALSE to disable it.
Return Value

An error code. Returns noErr if there is no error.
Discussion

To encode B-frames a compressor must reorder frames, which means that the order in which they will be emitted and stored (the decode order) is different from the order in which they were presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must call this function, passing TRUE. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionOptionsSetAllowFrameReordering (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameReordering ){};



/*ICMCompressionSessionOptionsSetMaxKeyFrameInterval

Sets the maximum interval between key frames.

OSStatus ICMCompressionSessionOptionsSetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options,
   SInt32                            maxKeyFrameInterval );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
maxKeyFrameInterval

The maximum interval between key frames, also known as the key frame rate.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMCompressionSessionOptionsSetMaxKeyFrameInterval (
   ICMCompressionSessionOptionsRef   options,
   SInt32                            maxKeyFrameInterval ){};


/*ICMCompressionSessionOptionsSetProperty

Sets the value of a specific property of a compression session options object.

OSStatus ICMCompressionSessionOptionsSetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ConstComponentValuePtr            inPropValueAddress );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
inPropClass

Pass the following constant to define the property class: kComponentPropertyClassPropertyInfo = 'pnfo' The property information class. See these constants: 
kComponentPropertyClassPropertyInfo
inPropID

Pass one of these constants to define the property ID: kComponentPropertyInfoList = 'list' An array of CFData values, one for each property. kComponentPropertyCacheSeed = 'seed' A property cache seed value. kComponentPropertyCacheFlags = 'flgs' One of the kComponentPropertyCache flags: kComponentPropertyCacheFlagNotPersistentProperty metadata should not be saved in persistent cache. kComponentPropertyCacheFlagIsDynamicProperty metadata should not cached at all. kComponentPropertyExtendedInfo = 'meta' A CFDictionary with extended property information. See these constants: 
kComponentPropertyInfoList
kComponentPropertyCacheSeed
kComponentPropertyCacheFlags
kComponentPropertyExtendedInfo
inPropValueSize

The size of the property value to be set.
inPropValueAddress

A pointer to the value of the property to be set.
Return Value

An error code. Returns noErr if there is no error.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionOptionsSetProperty (
   ICMCompressionSessionOptionsRef   options,
   ComponentPropertyClass            inPropClass,
   ComponentPropertyID               inPropID,
   ByteCount                         inPropValueSize,
   ConstComponentValuePtr            inPropValueAddress ){};


/*ICMCompressionSessionOptionsSetAllowFrameTimeChanges

Allows the compressor to modify frame times.

OSStatus ICMCompressionSessionOptionsSetAllowFrameTimeChanges (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameTimeChanges );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
allowFrameTimeChanges

Pass TRUE to let the compressor to modify frame times, FALSE to prohibit it.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Some compressors are able to identify and coalesce runs of identical frames and output single frames with longer durations, or output frames at a different frame rate from the original. This feature is controlled by the allow frame time changes flag. By default, this flag is set to false, which forces compressors to emit one encoded frame for every source frame and preserve frame display times.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h
ICMCompressionSessionOptio*/

OSStatus ICMCompressionSessionOptionsSetAllowFrameTimeChanges (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           allowFrameTimeChanges ){};


/*ICMCompressionSessionOptionsSetDurationsNeeded

Indicates that the durations of outputted frames must be calculated.

OSStatus ICMCompressionSessionOptionsSetDurationsNeeded (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           decodeDurationsNeeded );
Parameters
options

A compression session options reference. This reference is returned by ICMCompressionSessionOptionsCreate.
decodeDurationsNeeded

Pass TRUE to indicate that durations must be calculated, FALSE otherwise.
Return Value

An error code. Returns noErr if there is no error.
Discussion

If this flag is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default this flag is 0, so frames will not be delayed in order to calculate durations.
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionOptionsSetDurationsNeeded (
   ICMCompressionSessionOptionsRef   options,
   Boolean                           decodeDurationsNeeded ){};

/*ICMEncodedFrameGetImageDescription

Retrieves the image description of an encoded frame.

OSStatus ICMEncodedFrameGetImageDescription (
   ICMEncodedFrameRef       frame,
   ImageDescriptionHandle   *imageDescOut );
Parameters
frame

A reference to an encoded frame object.
imageDescOut

A pointer to a handle containing the encoded frame's image description. The caller should not dispose of this handle.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This function returns the same image description handle as ICMCompressionSessionGetImageDescription. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/
OSStatus ICMEncodedFrameGetImageDescription (
   ICMEncodedFrameRef       frame,
   ImageDescriptionHandle   *imageDescOut ){};


/*DeleteTrackSegment

Removes a specified segment from a track.

OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
startTime

A time value specifying the starting point of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
duration

A time value that specifies the duration of the segment to be deleted. This time value must be expressed in the time scale of the movie that contains the source track.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackSegment (
   Track        theTrack,
   TimeValue    startTime,
   TimeValue    duration ){};


/*ExtendMediaDecodeDurationToDisplayEndTime

Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.

OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged );
Parameters
theMedia

The media for this operation. You obtain this media identifier from such functions as NewTrackMedia and GetTrackMedia.
mediaChanged

A pointer to a Boolean that returns TRUE if any samples in the media were adjusted, FALSE otherwise. If you don't want to receive this information, set this parameter to NULL.
Return Value

An error code. Returns memFullErr if it could not allocate memory, paramErr if there was an invalid parameter, or noErr if there is no error. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result.
Discussion

After adding a complete, well-formed set of samples to a media, the media's display end time should be the same as the media's decode end time (also called the media decode duration). However, this is not necessarily the case after individual sample-adding operations, and hence it is possible for a media to be left with a display end time later than its decode end time (if adding a sequence of frames is aborted halfway, for example).
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr ExtendMediaDecodeDurationToDisplayEndTime (
   Media      theMedia,
   Boolean    *mediaChanged ){};


/*QTGetDataReferenceFullPathCFString

Returns the full pathname of the target of the data reference as a CFString.

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath );
Parameters
dataRef

An alias data reference to which you want a new data reference that points to the directory.
dataRefType

The type the input data reference; must be AliasDataHandlerSubType.
pathStyle

A constant (see below) that identifies the syntax of the pathname. See these constants: 
kQTNativeDefaultPathStyle
kQTPOSIXPathStyle
kQTHFSPathStyle
kQTWindowsPathStyle
outPath

A pointer to a CFStringRef entity where a reference to the newly created CFString will be returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters was NIL or the value of dataRefType is not AliasDataHandlerSubType.
Discussion

This function creates a new CFString that represents the full pathname of the target pointed to by the input data reference, which must be an alias data reference.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/

OSErr QTGetDataReferenceFullPathCFString (
   Handle         dataRef,
   OSType         dataRefType,
   QTPathStyle    pathStyle,
   CFStringRef    *outPath ){};




/*QTNewDataReferenceFromFSRefCFString

Creates an alias data reference from a file reference pointing to a directory and a file name.

OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType );
Parameters
directoryRef

A pointer to an opaque file specification that specifies the directory of the newly created alias data reference.
fileName

A reference to a CFString that specifies the name of the file.
flags

Currently not used; pass 0.
outDataRef

A pointer to a handle in which the newly created alias data reference is returned.
outDataRefType

A pointer to memory in which the OSType of the newly created data reference is returned.
Return Value

See Error Codes in the QuickTime API Reference. Returns noErr if there is no error. Returns paramErr if either of the output parameters is NIL
Discussion

This function is useful for creating an alias data reference to a file that does not exist yet. Note that you cannot construct an FSRef for a nonexistent file. You can use File Manager functions to construct an FSRef for the directory. Depending on where your file name comes from, you may already have it in a form of CFString, or you may have to call CFString functions to create a new CFString for the file name. Then you can pass the new alias data reference to other Movie Toolbox functions that take a data reference. If you already have an FSRef for the file you want, you can call QTNewDataReferenceFromFSRef instead.
Version Notes

Introduced in QuickTime 6.4.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h*/
OSErr QTNewDataReferenceFromFSRefCFString (
   const FSRef    *directoryRef,
   CFStringRef    fileName,
   UInt32         flags,
   Handle         *outDataRef,
   OSType         *outDataRefType ){};


/*ICMCompressionSessionCreate

Creates a compression session for a specified codec type.

OSStatus ICMCompressionSessionCreate (
   CFAllocatorRef                     allocator,
   int                                width,
   int                                height,
   CodecType                          cType,
   TimeScale                          timescale,
   ICMCompressionSessionOptionsRef    compressionOptions,
   CFDictionaryRef                    sourcePixelBufferAttributes,
   ICMEncodedFrameOutputRecord        *encodedFrameOutputRecord,
   ICMCompressionSessionRef           *compressionSessionOut );
Parameters
allocator

An allocator for the session. Pass NULL to use the default allocator. 
width

The width of frames. Pass 0 to let the compressor control the width.
height

The height of frames. Pass 0 to let the compressor control the height.
cType

The codec type. 
timescale

The timescale to be used for all time stamps and durations used in the session. 
compressionOptions

A reference to a settings object that configures the session. You create such an object by calling ICMCompressionSessionOptionsCreate. You can then use these constants to set its properties: kICMUnlimitedFrameDelayCount No limit on the number of frames in the compression window. kICMUnlimitedFrameDelayTime No time limit on the frames in the compression window. kICMUnlimitedCPUTimeBudget No CPU time limit on compression. 
sourcePixelBufferAttributes

Required attributes for source pixel buffers, used when creating a pixel buffer pool for source frames. If you do not want the ICM to create one for you, pass NULL. Using pixel buffers not allocated by the ICM may increase the chance that it will be necessary to copy image data. 
encodedFrameOutputRecord

The callback that will receive encoded frames. 
compressionSessionOut

Points to a variable to receive the created session object. 
Return Value

An error code. Returns noErr if there is no error.
Discussion

Some compressors do not support arbitrary source dimensions, and may override the suggested width and height. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
ImageCompression.h*/

OSStatus ICMCompressionSessionCreate (
   CFAllocatorRef                     allocator,
   int                                width,
   int                                height,
   CodecType                          cType,
   TimeScale                          timescale,
   ICMCompressionSessionOptionsRef    compressionOptions,
   CFDictionaryRef                    sourcePixelBufferAttributes,
   ICMEncodedFrameOutputRecord        *encodedFrameOutputRecord,
   ICMCompressionSessionRef           *compressionSessionOut ){};






/*GraphicsExportSetInputGWorld

Specifies that the source image for a graphics export operation is a graphics world.

ComponentResult GraphicsExportSetInputGWorld (
   GraphicsExportComponent    ci,
   GWorldPtr                  gworld );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
gworld

The source graphics world. It must be a real graphics world; you may not pass an ordinary color GrafPort. 
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to specify a source before you call GraphicsExportDoExport. The source can be a QuickTime graphics importer component instance, a QuickDraw Picture, a graphics world, a PixMap structure, or a piece of compressed data described by an ImageDescription structure. Compressed data can be in a file, handle, pointer, or other data reference. The application must make sure that the source is not disposed of before the graphics exporter instance is closed or given a new source. All of the get and set functions for these sources are implemented by the base graphics exporter; format-specific importers should delegate all of them.
Special Considerations

The graphics exporter will never dispose the graphics world.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsExportSetInputGWorld (
   GraphicsExportComponent    ci,
   GWorldPtr                  gworld ){};



/*GraphicsImportSetDataHandle

Specifies the handle that references imported graphics data.

ComponentResult GraphicsImportSetDataHandle (
   GraphicsImportComponent    ci,
   Handle                     h );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
h

Specifies a handle containing graphics data. The format of the data in the handle is the same as that found in a file.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The graphics importer component doesn't make a copy of this data. Therefore, you must not dispose this handle until the graphics importer has been closed.
Special Considerations

Graphics importer components use QuickTime data handler components to obtain their data. Applications, however, will use graphics importer functions rather than directly calling a data handler. Besides GraphicsImportSetDataHandle, these functions include GraphicsImportGetDataFile, GraphicsImportSetDataFile, GraphicsImportGetDataHandle, GraphicsImportSetDataReference, GraphicsImportSetDataReferenceOffsetAndLimit, and GraphicsImportGetDataReferenceOffsetAndLimit. These functions allow the data source to be a file, a handle, or a QuickTime data reference. You only need to use these functions if you open the graphics importer component directly. You don't need to call them if you use one of the GetGraphicsImporter... functions such as GetGraphicsImporterForDataRef. The GetGraphicsImporter... functions automatically open the graphics importer component and set its data source.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportSetDataHandle (
   GraphicsImportComponent    ci,
   Handle                     h ){};


/*MCActivate

Lets a controller respond to activate, deactivate, suspend, and resume events.

ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the event has occurred.
activate

The nature of the event. Set this parameter to TRUE for activate and resume events. Set it to FALSE for deactivate and suspend events.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCActivate (
   MovieController    mc,
   WindowRef          w,
   Boolean            activate ){};





/*MCIsPlayerEvent

Handles all events for a movie controller.

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
e

A pointer to the current EventRecord structure.
Return Value

A long integer indicating whether the movie controller component handled the event. The component sets this long integer to 1 if it handled the event. Your application should then skip the rest of its event loop and wait for the next event. The return value is 0 otherwise. Your application must then handle the event as part of its normal event processing.
Discussion

The movie controller component does everything necessary to support the movie controller and its associated movie. For example, the component calls MoviesTask for each movie. The movie controller component also handles suspend and resume events. It treats suspend events as deactivate requests and resume events as activate requests.

The following sample code shows how to convert Windows messages to Macintosh events and then pass those events to the QuickTime movie controller, using this function:// MCIsPlayerEvent coding example
// See "Discovering QuickTime," page 240
MovieController   mc;                   // Movie controller for movie
LRESULT CALLBACK WndProc
        (HWND       hwnd,               // Handle to window
         UINT       iMsg,               // Message type
         WPARAM     wParam,             // Message-dependent parameter
         LPARAM     lParam)             // Message-dependent parameter
{
    MSG             msg;                // Windows message structure
    EventRecord     er;                 // Macintosh event record
    DWORD           dwPos;              // Mouse coordinates of message
    msg.hwnd        =hwnd;             // Window handle
    msg.message     =iMsg;             // Message type
    msg.wParam      =wParam;           // Word-length parameter
    msg.lParam      =lParam;           // Long-word parameter
 
    msg.time =GetMessageTime();        // Get time of message
    dwPos  =GetMessagePos();           // Get mouse position
    msg.pt.x =LOWORD(dwPos);           // Extract x coordinate
    msg.pt.y =HIWORD(dwPos);           // Extract y coordinate
 
    WinEventToMacEvent(&msg, &er);      // Convert to event
    MCIsPlayerEvent(mc, &er);           // Pass event to QuickTime
 
    switch (iMsg) {                     // Dispatch on message type
 
        . . .       // Handle message according to type
 
    }  // end switch (iMsg)
 
}  // end WndProc

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCIsPlayerEvent (
   MovieController      mc,
   const EventRecord    *e ){};


/*GetMovieNextInterestingTime

Searches for times of interest in a movie's enabled tracks.

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit, nextTimeTrackEdit and nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeTrackEdit
nextTimeSyncSample
nextTimeStep
nextTimeEdgeOK
nextTimeIgnoreActiveSegment
numMediaTypes

The number of media types in the table referred to by the whichMediaType parameter. Set this parameter to 0 to search all media types.
whichMediaTypes

A pointer to an array of media type constants (see below). You can use this parameter to limit the search to a specified set of media types. Each entry in the table referred to by this parameter identifies a media type to be included in the search. You use the numMediaTypes parameter to indicate the number of entries in the table. Set this parameter to NIL to search all media types. See these constants: 
VisualMediaCharacteristic
AudioMediaCharacteristic
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the movie's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the movie's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. If you are not interested in this information, set this parameter to NIL.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the movie's time coordinate system. Set this parameter to NIL if you don't want this information; in this case, the function works faster.
Discussion

The following code sample shows the use of GetMovieNextInterestingTime to return, through the time parameter, the starting time of the first video sample of the specified QuickTime movie. The trick here is to set the nextTimeEdgeOK flag, to indicate that you want to get the starting time of the beginning of the movie. If this function encounters an error, it returns a (bogus) starting time of -1, as shown below:static OSErr QTStep_GetStartTimeOfFirstVideoSample (Movie theMovie,
                                                    TimeValue *theTime)
{
    short           myFlags;
    OSType          myTypes[1];
 
    *theTime =kBogusStartingTime;               // a bogus starting time
    if (theMovie ==NIL)
        return(invalidMovie);
 
    myFlags =nextTimeMediaSample + nextTimeEdgeOK;
                                 // we want the first sample in the movie
    myTypes[0] =VisualMediaCharacteristic;      // we want video samples
    GetMovieNextInterestingTime(theMovie, myFlags, 1, myTypes,
                                      (TimeValue)0, fixed1, theTime, NIL);
    return(GetMoviesError());
}

Special Considerations

This function examines only the movie's enabled tracks.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMovieNextInterestingTime (
   Movie           theMovie,
   short           interestingTimeFlags,
   short           numMediaTypes,
   const OSType    *whichMediaTypes,
   TimeValue       time,
   Fixed           rate,
   TimeValue       *interestingTime,
   TimeValue       *interestingDuration ){};





/*SCGetInfo

Retrieves configuration information from the standard dialog component.

ComponentResult SCGetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
infoType

A constant (see below) that specifies the type of information you want to retrieve. See these constants: 
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
scColorTableType
scProgressProcType
scExtendedProcsType
scPreferenceFlagsType
scSettingsStateType
scSequenceIDType
scWindowPositionType
scCodecFlagsType
info

A pointer to a field that is to receive the information. The infoType constant descriptions (see below) include information about this field.
Return Value

See Error Codes. If the component cannot satisfy your request, it returns a result code of scTypeNotFoundErr. It returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info ){};


/*FlattenMovie

Creates a new movie file containing a specified movie.

void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

A pointer to the file system specification for the movie file to be created.
creator

The creator value for the new file.
scriptTag

The script in which the movie file should be created. Set this parameter to the Script Manager constant smSystemScript to use the system script; set it to smCurrentScript to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
resId

A pointer to a field that contains the resource ID number for the new resource. If the field referred to by the resId parameter is set to 0, the Movie Toolbox assigns a unique resource ID number to the new resource. The toolbox then returns the movie's resource ID number in the field referred to by the resId parameter. The Movie Toolbox assigns resource ID numbers sequentially, starting at 128. If the resId parameter is set to NIL, the Movie Toolbox assigns a unique resource ID number to the new resource and does not return that resource's ID value.
resName

Points to a character string with the name of the movie resource. If you set the resName parameter to NIL, the toolbox creates an unnamed resource.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The file created by FlattenMovie also contains all the data for the movie; that is, the Movie Toolbox resolves any data references and includes the corresponding movie data in the new movie file.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void FlattenMovie (
   Movie               theMovie,
   long                movieFlattenFlags,
   const FSSpec        *theFile,
   OSType              creator,
   ScriptCode          scriptTag,
   long                createMovieFileFlags,
   short               *resId,
   ConstStr255Param    resName ){};

/*MCSetControllerBoundsRect

Lets you change the position and size of a movie controller.

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
bounds

A pointer to a Rect structure that contains the new boundary Rect structure for the movie controller.
Return Value

See Error Codes. Returns a value of controllerBoundsNotExact if the boundary rectangle has been changed but does not correspond to the rectangle you specified. In this case, the new boundary rectangle is always smaller than the requested rectangle. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerBoundsRect (
   MovieController    mc,
   const Rect         *bounds ){};


/*MCSetControllerPort

Lets your application set the graphics port for a movie controller.

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
gp

A pointer to the new graphics port for the movie controller. Set this parameter to NIL to use the current graphics port.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Movie controller components use MCSetControllerPort each time you create a new movie controller. Hence, your component must be set to a valid port before creating a new movie controller. You can use this function to place a movie and its associated movie controller in different graphics ports. If you are using an attached controller, both the controller and the movie's graphics ports are changed. If you are using a detached controller, this function changes only the graphics port of the control portion of the controller. You must use SetMovieGWorld followed by MCMovieChanged to change other portions.pascal ComponentResult MCSetControllerPort (MovieController mc,
                                            CGrafPtr gp);

Special Considerations

The movie controller component may use the foreground and background colors from the graphics port at the time this function is called to colorize the movie controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerPort (
   MovieController    mc,
   CGrafPtr           gp ){};


/*SCSetInfo

Modifies the standard dialog component's configuration information.

ComponentResult SCSetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
infoType

A constant (see below) that specifies the type of information you want to set. See these constants: 
scSpatialSettingsType
scTemporalSettingsType
scDataRateSettingsType
scColorTableType
scProgressProcType
scExtendedProcsType
scPreferenceFlagsType
scSettingsStateType
scSequenceIDType
scWindowPositionType
scCodecFlagsType
info

A pointer to a field that contains the new information. The infoType constant descriptions (see below) include information about this field.
Return Value

See Error Codes. If the component cannot satisfy your request, it returns a result code of scTypeNotFoundErr. It returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCSetInfo (
   ComponentInstance    ci,
   OSType               infoType,
   void                 *info ){};


/*MCGetIndMovie

Lets your application to retrieve the movie reference for a movie that is associated with a movie controller.

Movie MCGetIndMovie (
   MovieController    mc,
   short              index );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
index

Index for the movie. When set to 0, this call duplicates the action of the previous call to this function.
Return Value

The movie identifier for the movie that is assigned to the specified controller, or NIL if there is no movie assigned to the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCGetIndMovie (
   MovieController    mc,
   short              index ){};

/*MCGetControllerPort

Returns a movie controller's color graphics port.

CGrafPtr MCGetControllerPort (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A pointer to the movie controller's CGrafPort structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
CGrafPtr MCGetControllerPort (
   MovieController    mc ){};


/*MCGetWindowRgn

Determines the window region that is actually in use by a controller and its movie.

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
Return Value

A handle to the MacRegion structure for the window that is actually in use. Your application must dispose of this structure.
Discussion

The region returned by this function contains only the visible portions of the controller and its movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

RgnHandle MCGetWindowRgn (
   MovieController    mc,
   WindowRef          w ){};



/*SCSetTestImagePixMap

Sets the dialog box's test image from a Picture structure that is stored in a PixMap structure.

ComponentResult SCSetTestImagePixMap (
   ComponentInstance    ci,
   PixMapHandle         testPixMap,
   Rect                 *testRect,
   short                testFlags );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
testPixMap

A handle to a PixMap structure that contains the new test image. Your application is responsible for creating this structure before calling the function. You must also dispose of the structure when you are done with it. You must clear the image or close your connection to the standard image-compression dialog component before you dispose of the structure.
testRect

A pointer to a Rect structure. This rectangle specifies, in the coordinate system of the source image, the area of interest or point of interest in the test image. The area of interest defines a portion of the test image that is to be shown to the user in the dialog box. Use this parameter to direct the component to a specific portion of the test image. The component uses the value of the testFlags parameter to determine how it transforms large images before displaying them to the user.
testFlags

Constants (see below) that specify how the component is to display a test image that is larger than the test image portion of the dialog box. If you set this parameter to 0, the component uses a default method of its own choosing. In all cases, the component centers the area or point of interest in the test image portion of the dialog box, and then displays some part of the test image. See these constants: 
scPreferCropping
scPreferScaling
scPreferScalingAndCropping
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCSetTestImagePixMap (
   ComponentInstance    ci,
   PixMapHandle         testPixMap,
   Rect                 *testRect,
   short                testFlags ){};


/*SCDefaultPixMapSettings

Derives default compression settings for an image that is stored in a pixel map.

ComponentResult SCDefaultPixMapSettings (
   ComponentInstance    ci,
   PixMapHandle         src,
   short                motion );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be analyzed.
motion

Specifies whether the image is part of a sequence. Set this parameter to TRUE if the image is part of a sequence; set it to FALSE if you are working with a single still image.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCDefaultPixMapSettings (
   ComponentInstance    ci,
   PixMapHandle         src,
   short                motion ){};


/*GetMoviePosterPict

Creates a QuickDraw picture that contains a movie's poster.

PicHandle GetMoviePosterPict (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePosterPict (
   Movie    theMovie ){};


/*SCRequestSequenceSettings

Displays the standard sequence dialog box to the user and shows default settings you have established.

ComponentResult SCRequestSequenceSettings (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use SCRequestSequenceSettings to retrieve the user's preferences for compressing an image sequence; use SCRequestImageSettings when you are working with a single image. Both functions manipulate the compression settings that the component stores for you.

The component derives the current settings when you may supply an image to the component from which it can derive default settings. If you have not set any defaults, but you do supply a test image for the dialog, the component examines the test image and derives appropriate default values based upon its characteristics. If you have not set any defaults and do not supply a test image, the component uses its own default values.
Special Considerations

You may modify the settings by using SCSetInfo. You may customize the dialog boxes by specifying a modal-dialog hook function or a custom button. You may use the custom button to invoke an ancillary dialog box that is specific to your application.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCRequestSequenceSettings (
   ComponentInstance    ci ){};


/*SCPositionRect

Positions a rectangle on the screen.

ComponentResult SCPositionRect (
   ComponentInstance    ci,
   Rect                 *rp,
   Point                *where );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
rp

A pointer to a Rect structure. When you call the function, this structure should contain the rectangle's current global coordinates. The function adjusts the coordinates in the structure to reflect the rectangle's new position.
where

A pointer to a Point structure identifying the desired location of the upper-left corner of the rectangle in global coordinates. This parameter allows your application to position the rectangle on the screen.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCPositionRect (
   ComponentInstance    ci,
   Rect                 *rp,
   Point                *where ){};


/*GetCompressionTime

Determines the estimated amount of time required to compress a given image.

OSErr GetCompressionTime (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecType              cType,
   CompressorComponent    codec,
   CodecQ                 *spatialQuality,
   CodecQ                 *temporalQuality,
   unsigned long          *compressTime );
Parameters
src

A handle to the source image. The source image must be stored in a pixel map structure. The compressor uses only the bit depth of this image to determine the compression time. You may set this parameter to NIL if you are interested only in information about quality settings.
srcRect

A pointer to a rectangle defining the portion of the source image to compress. You may set this parameter to NIL if you are interested only in information about quality settings. GetCompressionTime then uses the bounds of the source pixel map.
colorDepth

The depth at which the image is to be compressed. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by the GetCodecInfo function
cType

You must set this parameter to a valid compressor type constant; see Codec Identifiers.
codec

Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). You can also specify a component instance. This may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
spatialQuality

A pointer to a field containing a constant (see below) that defines the desired compressed image quality. The Image Compression Manager sets this field to the closest actual quality that the compressor can achieve. If you are not interested in this information, pass NIL in this parameter. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
temporalQuality

A pointer to a field containing a constant (see below) that defines the desired temporal quality. Use this value only with images that are part of image sequences. The Image Compression Manager sets this field to the closest actual quality that the compressor can achieve. If you are not interested in this information, pass NIL in this parameter.
compressTime

A pointer to a field to receive the compression time in milliseconds. If the compressor cannot determine the amount of time required to compress the image or if the compressor does not support this function, this field is set to 0. If you are not interested in this information, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows you to verify that the quality settings you desire are supported by a given compressor component. You specify the compression characteristics, including compression type and quality, along with the image. The Image Compression Manager returns the maximum compression time for the specified image and parameters. Note that some compressors may not support this function. If the component you specify does not support this function, the Image Compression Manager returns a time value of 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCompressionTime (
   PixMapHandle           src,
   const Rect             *srcRect,
   short                  colorDepth,
   CodecType              cType,
   CompressorComponent    codec,
   CodecQ                 *spatialQuality,
   CodecQ                 *temporalQuality,
   unsigned long          *compressTime ){};


/*CopyMovieSettings

Copies many settings from one movie to another, overwriting the destination settings in the process.

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dstMovie

The destination movie for this operation. The CopyMovieSettings function uses the settings from the source movie, which is specified by the srcMovie parameter, to replace the current settings of this movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to copy certain important settings from one movie to another. It copies the preferred rate and volume, source clipping region, matrix information, and user data; it does not copy the movie's contents. To work with movie contents, you should use segment editing functions.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr CopyMovieSettings (
   Movie    srcMovie,
   Movie    dstMovie ){};

/*SetMovieMatrix

Sets a movie's transformation matrix.

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
matrix

A pointer to the MatrixRecord structure for the movie. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox uses a movie's matrix to map a movie from its display coordinate system to its graphics world.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieMatrix (
   Movie                 theMovie,
   const MatrixRecord    *matrix ){};


/*SetMovieClipRgn

Establishes a movie's clipping region.

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
theClip

A handle to the movie's clipping region. The Movie Toolbox makes a copy of this region. Your application must dispose of the region referred to by this parameter when you are done with it. Set this parameter to NIL to disable clipping for the movie.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The clipping region is saved with the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieClipRgn (
   Movie        theMovie,
   RgnHandle    theClip ){};



/*SCCompressSequenceBegin

Initiates a sequence-compression operation.

ComponentResult SCCompressSequenceBegin (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed. This pixel map must contain the first image in the sequence.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire structure, set this parameter to NIL.
desc

A pointer to an image description handle. The standard dialog component creates an image description structure when it compresses the image, and returns a handle to that structure in the field referred to by this parameter. The component sizes the handle appropriately. If you do not want this information, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCCompressSequenceBegin (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc ){};


/*SCCompressSequenceFrame

Continues a sequence-compression operation.

ComponentResult SCCompressSequenceFrame (
   ComponentInstance    ci,
   PixMapHandle         src,
   const Rect           *srcRect,
   Handle               *data,
   long                 *dataSize,
   short                *notSyncFlag );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire pixel map, set this parameter to NIL.
data

A pointer to a handle. The standard compression component returns a handle to the compressed image data in the field referred to by this parameter. The component sizes that handle appropriately for the sequence.
dataSize

A pointer to a long integer. The standard compression component returns a value that indicates the number of bytes of compressed image data that it returns. Note that this value will differ from the size of the handle referred to by the data parameter, because the handle is allocated to accommodate the largest image in the sequence.
notSyncFlag

A pointer to a short integer that indicates whether the compressed frame is a key frame. If the frame is a key frame, the standard compression component sets the field referred to by this parameter to 0; otherwise, the component sets this field to mediaSampleNotSync. You may use this field to set the sampleFlags parameter of the AddMediaSample function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must call this function once for each frame in the sequence, including the first frame.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCCompressSequenceFrame (
   ComponentInstance    ci,
   PixMapHandle         src,
   const Rect           *srcRect,
   Handle               *data,
   long                 *dataSize,
   short                *notSyncFlag ){};


/*SCCompressSequenceEnd

Ends a sequence-compression operation.

ComponentResult SCCompressSequenceEnd (
   ComponentInstance    ci );
Parameters
ci

Identifies your application's connection to a standard image-compression component. You obtain this identifier from OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The standard dialog component disposes of any memory it used to compress the image sequence, including the data and image description buffers. You must call this function once for each sequence you start.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressSequenceEnd (
   ComponentInstance    ci ){};


/*PutMovieIntoTypedHandle

Takes a movie, or a single track from within that movie, and converts it into a handle of a specified type.

OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
targetTrack

The track to convert.
handleType

The type of the new data.
publicMovie

The actual handle in which to place the new data.
start

The start time of the segment of the movie or track to be converted.
dur

The duration of the segment of the movie or track to be converted.
flags

Condition of the conversion. Set this parameter to 0.
userComp

Indicates a component or component instance of the movie export component you want to perform the conversion. Otherwise, set this parameter to 0 for the Movie Toolbox to choose the appropriate component. If you pass in a component instance, this function will use it. This allows you to communicate directly with the component before using this function to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this function.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieIntoTypedHandle (
   Movie                theMovie,
   Track                targetTrack,
   OSType               handleType,
   Handle               publicMovie,
   TimeValue            start,
   TimeValue            dur,
   long                 flags,
   ComponentInstance    userComp ){};


/*LoadMovieIntoRam

Loads a movie's data into memory.

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to load.
duration

The length of the segment to load. Use GetMovieDuration to determine the length of the entire movie. Note that the Movie Toolbox may load more data than you specify due to the way the data is loaded.
flags

Flags (see below) that give you explicit control over what is loaded into memory and how long to keep it around. You can set these flags in any combination.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr LoadMovieIntoRam (
   Movie        theMovie,
   TimeValue    time,
   TimeValue    duration,
   long         flags ){};



/*DecompressSequenceFrame

Obsolete. See DecompressSequenceFrameS.

OSErr DecompressSequenceFrame (
   ImageSequence                 seqID,
   Ptr                           data,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DecompressSequenceFrame (
   ImageSequence                 seqID,
   Ptr                           data,
   CodecFlags                    inFlags,
   CodecFlags                    *outFlags,
   ICMCompletionProcRecordPtr    asyncCompletionProc ){};

/*MovieImportFile

Imports data from a file, using a movie data import component.

ComponentResult MovieImportFile (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags );
Parameters
ci

A movie data import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to the file that contains the data that is to be imported into the movie. This file's type value corresponds to your component's subtype value.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to add sample data to the target movie or to obtain information about the movie.
targetTrack

The track that is to receive the imported data. This track identifier is supplied by the Movie Toolbox and is valid only if the movieImportMustUseTrack flag in the inFlags parameter is set to 1.
usedTrack

A pointer to the track that received the imported data. Your component returns this track identifier to the Movie Toolbox. Your component needs to set this parameter only if you operate on a single track or if you create a new track. If you modify more than one track, leave the field referred to by this parameter unchanged.
atTime

The time corresponding to the location where your component is to place the imported data. This time value is expressed in the movie's time coordinate system.
addedDuration

A pointer to the duration of the data that your component added to the movie. Your component must specify this value in the movie's time coordinate system.
inFlags

Flags (see below) that specify control information governing the import operation. See these constants: 
movieImportCreateTrack
movieImportMustUseTrack
movieImportInParallel
outFlags

Flags (see below) that identify a field that is to receive status information about the import operation. Your component sets the appropriate flags in this field when the operation is complete. See these constants: 
movieImportResultUsedMultipleTracks
movieImportInParallel
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your component must be prepared to perform this function at any time. You should not expect that any of your component's configuration functions will be called first. If your component can accept data from a file, be sure to set the canMovieImportFiles flag in the componentFlags field of your component's ComponentDescription structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult MovieImportFile (
   MovieImportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags ){};


/*SetMovieDefaultDataRef

Sets a movie's default data reference and type.

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dataRef

A handle to the data reference. The type of information to be placed in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMovieDefaultDataRef (
   Movie     theMovie,
   Handle    dataRef,
   OSType    dataRefType ){};



/*GetSoundDescriptionExtension

Gets the current extension to a SoundDescription structure.

OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType );
Parameters
desc

A handle to a SoundDescription structure.
extension

A pointer to a handle that, on return, contains the extension.
idType

A four-byte signature that identifies the type of data in the extension.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr GetSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    *extension,
   OSType                    idType ){};


/*SCSetSettingsFromAtomContainer

Sets the standard image-compression component's current configuration from data in a QT atom container.

ComponentResult SCSetSettingsFromAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      settings );
Parameters
ci

Standard compression component instance.
settings

A QT atom container reference to the settings.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The settings QT atom container may contain atoms other than those expected by the particular component type or may be missing certain atoms. The function will only use settings it understands.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCSetSettingsFromAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      settings ){};


/*SCGetSettingsAsAtomContainer

Places the current configuration from the standard image-compression component in a QT atom container.

ComponentResult SCGetSettingsAsAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      *settings );
Parameters
ci

The standard compression component instance.
settings

The address where the newly-created atom container should be stored.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The caller is responsible for disposing of the returned QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetSettingsAsAtomContainer (
   ComponentInstance    ci,
   QTAtomContainer      *settings ){};


/*AddSoundDescriptionExtension

Adds an extension to a SoundDescription structure.

OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType );
Parameters
desc

A handle to the SoundDescription structure to add the extension to.
extension

The handle containing the extension data.
idType

A four-byte signature identifying the type of data being added to the SoundDescription.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Two extensions are defined to the SoundDescription record. The first is the slope, intercept, minClip, and maxClip parameters for audio, represented as an atom of type 'flap'. The second extension is the ability to store data specific to a given audio codec, using a SoundDescriptionV1 structure.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddSoundDescriptionExtension (
   SoundDescriptionHandle    desc,
   Handle                    extension,
   OSType                    idType ){};



/*AddUserDataText

Places language-tagged text into an item in a user data list.

OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A handle to the data to be added to the user data list.
udType

The type that is to be assigned to the new item.
index

The item to which the text is to be added. This parameter must specify an item in the user data list identified by theUserData.
itlRegionTag

The region code of the text to be added. If there is already text with this region code in the item, the function replaces the existing text with the data specified by the data parameter. See Inside Macintosh: Text for more information about language and region codes.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You specify the user data list and item, the data to be added, the data's type value, and the language code of the data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddUserDataText (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index,
   short       itlRegionTag ){};


/*NewSCModalHookUPP

Allocates a Universal Procedure Pointer for the SCModalHookProc callback.

SCModalHookUPP NewSCModalHookUPP (
   SCModalHookProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSCModalHookProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


SCModalHookUPP NewSCModalHookUPP (
   SCModalHookProcPtr    userRoutine ){};


/*SCPositionDialog

Helps position a dialog box on the screen.

ComponentResult SCPositionDialog (
   ComponentInstance    ci,
   short                id,
   Point                *where );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
id

The resource number of a 'DLOG' resource. The function positions the dialog box that corresponds to this resource.
where

A pointer to a Point structure identifying the desired location of the upper-left corner of the dialog box in global coordinates. This parameter allows you to indicate how you want to position the dialog box on the screen.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/


ComponentResult SCPositionDialog (
   ComponentInstance    ci,
   short                id,
   Point                *where ){};

/*QTVRUpdate

Forces an immediate update of a QuickTime VR movie image.

OSErr QTVRUpdate (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
imagingMode

An imaging mode. You can specify kQTVRCurrentMode (see below) to use the current imaging mode. See these constants: 
kQTVRCurrentMode
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function immediately updates the image for the QuickTime VR movie specified by the qtvr parameter, without waiting for the next call to MoviesTask in your application's main event loop. If you plan to call this function repeatedly for a movie instance, then for improved performance you should bracket those calls with calls to QTVRBeginUpdateStream and QTVREndUpdateStream.
Special Considerations

If you call this function after calling QTVRBeginUpdateStream but before calling QTVREndUpdateStream, the imagingMode parameter passed to it must be the same as the imagingMode parameter passed to QTVRBeginUpdateStream. If you do not specify the same imaging mode to those two functions, an error will result.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRUpdate (
   QTVRInstance       qtvr,
   QTVRImagingMode    imagingMode ){};


/*QTVRNudge

Turns one step in a particular direction and displays the new view.

OSErr QTVRNudge (
   QTVRInstance        qtvr,
   QTVRNudgeControl    direction );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
direction

The direction of the nudge (see below). Any value of the direction parameter that is not predefined is mapped to the closest defined value. See these constants: 
kQTVRRight
kQTVRUpRight
kQTVRUp
kQTVRUpLeft
kQTVRLeft
kQTVRDown
kQTVRDownRight
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function adjusts the current view of the movie specified by the qtvr parameter as indicated by the direction parameter. In particular, it turns one step in the indicated direction and displays the new view. For example, to move to the next view that is right and up from the current view, set the direction parameter to kQTVRUpRight (that is, pi/4 radians, or 45 degrees). For objects, if no view is located at the adjacent object view defined by the nudge direction and wrapping is off in the desired direction, then this function remains at the current view and returns the result code constraintReachedErr. For objects, this function is useful for changing to an adjacent view without having to know the new pan and tilt angles. The direction of the nudge is affected by the current control settings.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRNudge (
   QTVRInstance        qtvr,
   QTVRNudgeControl    direction ){};


/*QTVRGetQTVRTrack

Obtains a QTVR track contained in a QuickTime movie to use in the QTVRGetQTVRInstance call.

Track QTVRGetQTVRTrack (
   Movie     theMovie,
   SInt32    index );
Parameters
theMovie

A QuickTime movie.
index

The index of the desired QTVR track.
Return Value

A track identifier for the QTVR track that has the index specified by the index parameter in the QuickTime movie specified by the theMovie parameter. If there is no such track, or the movie is not a QTVR movie, this function returns the value NIL.
Discussion

Here's an example of using this function to help get an instance of a QTVR movie running in a movie controller:// QTVRGetQTVRTrack coding example
// See "Discovering QuickTime," page 390
QTVRInstance MyGetQTVRInstanceFromMC (MovieController mc)
{
    Track               track =NIL;
    QTVRInstance        qtvrinstance =NIL;
    Movie               movie =NIL;
    //Get the movie from the movie controller.
    movie =MCGetMovie(mc);
    if (movie !=NIL) {
        //Get the first QTVR track in the movie.
        track =QTVRGetQTVRTrack(movie, 1);
        //Get a QTVR instance for that QTVR track.
        if (track !=NIL) {
            QTVRGetQTVRInstance(qtvrinstance, track, mc);
            //Set our units to be degrees.
            if (qtvrinstance !=NIL)
                QTVRSetAngularUnits(qtvrinstance, kQTVRDegrees);
        }
    }
    return qtvrinstance;
}

Version Notes

Introduced in QuickTime 3 or earlier. QuickTime VR 2.1 supports files with at most one QTVR track; hence the value for the index parameter of a movie made with QuickTime VR 2.1 is always 1. Panorama and object movies made with QuickTime VR version 1.0 have no QTVR track. This function returns the track ID of the panorama track for version 1.0 panorama movies and the track ID of the image video track for version 1.0 object movies. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
Track QTVRGetQTVRTrack (
   Movie     theMovie,
   SInt32    index ){};



/*QTVRGetQTVRInstance

Obtains an instance of a QuickTime VR movie.

OSErr QTVRGetQTVRInstance (
   QTVRInstance       *qtvr,
   Track              qtvrTrack,
   MovieController    mc );
Parameters
qtvr

On return, an instance of the specified QuickTime VR movie.
qtvrTrack

A QTVR track contained in a QuickTime movie. You can obtain a reference to this track by calling QTVRGetQTVRTrack.
mc

An identifier for the movie controller to be associated with the new QuickTime VR movie instance. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If qtvrTrack does not specify a QTVR track, this function returns NIL in the qtvr parameter and an error code as its function result. See Error Codes. Returns noErr if there is no error.
Discussion

You need a QuickTime VR movie instance to call most other QuickTime VR functions. This function returns, in the qtvr parameter, an instance of the QuickTime VR movie specified by the qtvrTrack parameter. Here's an example of code that gets a QTVR instance:// QTVRGetQTVRInstance coding example
// See "Discovering QuickTime," page 390
QTVRInstance MyGetQTVRInstanceFromMC (MovieController mc)
{
    Track               track =NIL;
    QTVRInstance        qtvrinstance =NIL;
    Movie               movie =NIL;
    //Get the movie from the movie controller.
    movie =MCGetMovie(mc);
    if (movie !=NIL) {
        //Get the first QTVR track in the movie.
        track =QTVRGetQTVRTrack(movie, 1);
        //Get a QTVR instance for that QTVR track.
        if (track !=NIL) {
            QTVRGetQTVRInstance(qtvrinstance, track, mc);
            //Set our units to be degrees.
            if (qtvrinstance !=NIL)
                QTVRSetAngularUnits(qtvrinstance, kQTVRDegrees);
        }
    }
    return qtvrinstance;
}

Special Considerations

It's not necessary to dispose of a QuickTime VR movie instance.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRGetQTVRInstance (
   QTVRInstance       *qtvr,
   Track              qtvrTrack,
   MovieController    mc ){};



/*QTVRSetAngularUnits

Sets the type of unit used when specifying QTVR angles.

OSErr QTVRSetAngularUnits (
   QTVRInstance        qtvr,
   QTVRAngularUnits    units );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
units

A constant (see below) that indicates the type of angular units to use. See these constants: 
kQTVRDegrees
kQTVRRadians
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function sets the type of angular units to be used in all subsequent QuickTime VR Manager calls for the QuickTime VR movie specified by the qtvr parameter to the unit type specified by the units parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetAngularUnits (
   QTVRInstance        qtvr,
   QTVRAngularUnits    units ){};

/*NewQTVRImagingCompleteUPP

Allocates a Universal Procedure Pointer for the QTVRImagingCompleteProc callback.

QTVRImagingCompleteUPP NewQTVRImagingCompleteUPP (
   QTVRImagingCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRImagingCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
QTVRImagingCompleteUPP NewQTVRImagingCompleteUPP (
   QTVRImagingCompleteProcPtr    userRoutine ){};


/*NewQTVRBackBufferImagingUPP

Allocates a Universal Procedure Pointer for the QTVRBackBufferImagingProc callback.

QTVRBackBufferImagingUPP NewQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRBackBufferImagingProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVRBackBufferImagingUPP NewQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingProcPtr    userRoutine ){};


/*QTVRGetCurrentNodeID

Obtains the current node of a movie.

UInt32 QTVRGetCurrentNodeID (
   QTVRInstance    qtvr );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
Return Value

The ID of the current node of the specified movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
UInt32 QTVRGetCurrentNodeID (
   QTVRInstance    qtvr ){};


/*DisposeQTVRBackBufferImagingUPP

Disposes of a QTVRBackBufferImagingUPP pointer.

void DisposeQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingUPP    userUPP );
Parameters
userUPP

A QTVRBackBufferImagingUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
void DisposeQTVRBackBufferImagingUPP (
   QTVRBackBufferImagingUPP    userUPP ){};


/*Disposes of a QTVRImagingCompleteUPP pointer.

void DisposeQTVRImagingCompleteUPP (
   QTVRImagingCompleteUPP    userUPP );
Parameters
userUPP

A QTVRImagingCompleteUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

void DisposeQTVRImagingCompleteUPP (
   QTVRImagingCompleteUPP    userUPP ){};



/*SetQuickTimePreference

Sets a particular preference in the QuickTime preferences.

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom );
Parameters
preferenceType

The type of preference to set (see below); also see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A QT atom containing the preference information.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    preferenceAtom ){};


/*QTInsertChild

Creates a new child atom of the specified parent atom.

OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
atomType

The type of the new atom to be inserted.
id

The ID of the new atom to be inserted. This ID must be unique among atoms of the same type for the specified parent. If you set this parameter to 0, the function assigns a unique ID to the atom.
index

The index of the new atom among atoms with the same parent. To insert the first atom for the specified parent, you should set this parameter to 1. To insert an atom as the last atom in the child list, you should set this parameter to 0. Index values greater than the index of the last atom in the child list plus 1 are invalid.
dataSize

The size of the data for the new atom. If the new atom is to be a parent atom or if you want to add the atom's data later, you should pass 0 for this parameter. To create the new atom as a leaf atom that contains data, you should specify the data using the data parameter and and its size using the dataSize parameter.
data

A pointer to a buffer containing the data for the new atom. If you set the value of the dataSize parameter to 0, you should pass NIL for this parameter.
newAtom

A pointer to data of type QTAtom. On return, this parameter points to the newly created atom. You can pass NIL for this parameter if you don't need a reference to the newly created atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new child atom. The new child atom has the specified atom type and atom ID, and is inserted into its parent atom's child list at the specified index. Any existing atoms at the same index or greater are moved toward the end of the child list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChild (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomType         atomType,
   QTAtomID           id,
   short              index,
   long               dataSize,
   void               *data,
   QTAtom             *newAtom ){};


/*QTNewAtomContainer

Creates a new atom container.

OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData );
Parameters
atomData

A pointer to an unallocated atom container data structure. On return, this parameter points to an allocated atom container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates a new, empty atom container structure. Once you have created an atom container, you can manipulate it using the atom container functions. The following example illustrates using this function to create a new QT atom container and add an atom:// QTNewAtomContainer coding example
QTAtom firstAtom;
QTAtomContainer container;
OSErr err
err =QTNewAtomContainer (&container);
if (!err)
    err =QTInsertChild (container, kParentAtomIsContainer, 'abcd',
        1000, 1, 0, NIL, &firstAtom);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTNewAtomContainer (
   QTAtomContainer    *atomData ){};

/*GetQuickTimePreference

Retrieves a particular preference from the QuickTime preferences.

OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom );
Parameters
preferenceType

A preference type to be retrieved (see below); see Atom ID Codes. See these constants: 
ConnectionSpeedPrefsType
BandwidthManagementPrefsType
preferenceAtom

A pointer to the returned preference atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following sample code shows how to retrieve the connection speed setting from the QuickTime preferences:struct ConnectionSpeedPrefsRecord {
   long connectionSpeed;
};
typedef struct ConnectionSpeedPrefsRecord ConnectionSpeedPrefsRecord;
. . .
OSErr                       err;
QTAtomContainer             prefs;
QTAtom                      prefsAtom;
long                        dataSize;
Ptr                         atomData;
ConnectionSpeedPrefsRecord  prefrec;
err =GetQuickTimePreference(ConnectionSpeedPrefsType, &amp;prefs);
if (err ==noErr) {
    prefsAtom =QTFindChildByID(prefs, kParentAtomIsContainer,
                                  ConnectionSpeedPrefsType, 1, nil);
    if (!prefsAtom) {
        // set the default setting to 28.8kpbs
        prefrec.connectionSpeed =kDataRate288ModemRate;
    } else {
        err =QTGetAtomDataPtr(prefs, prefsAtom, &dataSize,
                                                         &atomData);
        if (dataSize !=sizeof(ConnectionSpeedPrefsRecord)) {
            // the prefs record wasn't the right size,
            // so it must be corrupt -- set to the default
            prefrec.connectionSpeed =kDataRate288ModemRate;
        } else {
            // everything was fine -- read the connection speed
            prefrec =*(ConnectionSpeedPrefsRecord *)atomData;
        }
    }
    QTDisposeAtomContainer(prefs);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetQuickTimePreference (
   OSType             preferenceType,
   QTAtomContainer    *preferenceAtom ){};


/*DeleteTrackReference

Removes a track reference from a track.

OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference.
index

The index value of the reference to be deleted. You obtain this index value when you create the track reference.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function deletes a track reference from a track. If there are additional track references with higher index values, the toolbox automatically renumbers those references, decrementing their index values by 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index ){};


/*GetTrackReference

Retrieves the track identifier contained in an existing track reference.

Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References.
index

The index value of the reference found. You obtain this index value when you create the track reference.
Return Value

The track identifier for the specified track. If the toolbox cannot locate the track reference corresponding to your specifications, it returns a value of NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Track GetTrackReference (
   Track     theTrack,
   OSType    refType,
   long      index ){};

/*GetTrackReferenceCount

Determines how many track references of a given type exist for a track.

long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference; see Data References. The toolbox determines the number of track references of this type.
Return Value

A long integer that specifies the number of track references of the specified type in the track. If there are no references of the type you have specified, the function returns a value of 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackReferenceCount (
   Track     theTrack,
   OSType    refType ){};

/*GetNextTrackReferenceType

Determines all of the track reference types that are defined for a given track.

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refType

The type of reference. Set this parameter to 0 to retrieve the first track reference type. On subsequent requests, use the previous value returned by this function.
Return Value

An OSType containing the next track reference type value defined for the track; see Data References.
Discussion

There is no implied ordering of the values returned by this function . When you reach the end of the track's reference types, this function sets the returned value to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSType GetNextTrackReferenceType (
   Track     theTrack,
   OSType    refType ){};


/*GetMovieImporterForDataRef

Gets the movie importer component for a movie.

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer );
Parameters
dataRefType

The type of data reference; see Data References.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
flags

Flags (see below) that modify this function's behavior. See these constants: 
kGetMovieImporterDontConsiderGraphicsImporters
importer

A pointer to an importer component that can import the movie. Returns NIL if no importer can be found.
Return Value

If this function is allowed to use async calls (by being passed kGetMovieImporterUseAsyncCalls in the flags parameter), it returns notEnoughDataErr if it would block. You can access this error return through GetMoviesError and GetMoviesStickyError, as well as in the function result. For other errors, see Error Codes.
Discussion

You can use GetMovieImporterForDataRef to determine if a file can be opened by QuickTime as a movie (for example, in a drag-and-drop operation) as illustrated below:AliasHandle            alias;
MovieImportComponent   mi;
NewAliasMinimal(&reply.sfFile, &alias);
GetMovieImporterForDataRef(rAliasType, (Handle)alias,
kGetMovieImporterDontConsiderGraphicsImporters, &mi);
DisposeHandle((Handle)alias);
if (mi !=NIL) {
    // this file can be opened as a movie
    . . .
    }

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetMovieImporterForDataRef (
   OSType       dataRefType,
   Handle       dataRef,
   long         flags,
   Component    *importer ){};


/*MediaGetName

Returns the name of the media type.

ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
name

The name of the media type; for example, the video media handler returns the string 'video'.
requestedLanguage

The language in which you want the name returned; see Localization Codes.
actualLanguage

A pointer to the actual language in which the name is returned; see Localization Codes
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetName (
   MediaHandler    mh,
   Str255          name,
   long            requestedLanguage,
   long            *actualLanguage ){};

/*GetUserData

Returns a specified user data item.

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData function.
data

A handle that is to receive the data from the specified item. GetUserData resizes this handle as appropriate to accommodate the item. Your application is responsible for releasing this handle when you are done with it. Set this parameter to NIL if you don't want to retrieve the user data item. This can be useful if you want to verify that a user data item exists, but you don't need to work with the item's contents.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserData (
   UserData    theUserData,
   Handle      data,
   OSType      udType,
   long        index ){};



/*GetTrackUserData

Obtains access to a track's user data list.

UserData GetTrackUserData (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

A reference to the specified track's user data. If the function could not locate the track's user data, it sets this returned value to NIL.
Discussion

This function returns a reference to the track's user data list, which is valid until you dispose of the track. When you save the track, the Movie Toolbox saves the user data as well.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
UserData GetTrackUserData (
   Track    theTrack ){};


/*GetTimeBaseFlags

Obtains the control flags of a time base.

long GetTimeBaseFlags (
   TimeBase    tb );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

Control flags (see below). Unused flags are set to 0.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

long GetTimeBaseFlags (
   TimeBase    tb ){};


/*SetUserDataItem

Sets an item in a user data list.

OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this item reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer to the data item to be set in a user data list.
size

The size of the information pointed to by the data parameter.
udType

The type value assigned to the new item.
index

The item's index value. This parameter must specify an item in the user data list identified by theUserData. An index value of 0 or 1 implies the first item, which is created if it doesn't already exist.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index ){};


/*RemoveUserData

Removes an item from a user data list.

OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling GetMovieUserData, GetTrackUserData, or GetMediaUserData.
udType

The item's type value.
index

The item's index value. This parameter must specify an item in the user data list identified by the theUserData parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

After the Movie Toolbox removes the item, it renumbers the remaining items of that type so that their index values are sequential and start at 1.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr RemoveUserData (
   UserData    theUserData,
   OSType      udType,
   long        index ){};



/*CountUserDataType

Determines the number of items of a given type in a user data list.

short CountUserDataType (
   UserData    theUserData,
   OSType      udType );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData functions.
udType

The type. The Movie Toolbox determines the number of items of this type in the user data list.
Return Value

The number of items of the given type in the user data list.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short CountUserDataType (
   UserData    theUserData,
   OSType      udType ){};


/*GetUserDataItem

Returns a specified user data item.

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index );
Parameters
theUserData

The user data list for this operation. You obtain this list reference by calling the GetMovieUserData, GetTrackUserData, or GetMediaUserData.
data

A pointer that is to receive the data from the specified item.
size

The size of the item.
udType

The item's type value; see User Data Identifiers.
index

The item's index value. This parameter must specify an item in the user data list identified by the parameter theUserData.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr GetUserDataItem (
   UserData    theUserData,
   void        *data,
   long        size,
   OSType      udType,
   long        index ){};


/*SetMoviePreferredVolume

Sets a movie's preferred volume setting.

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
volume

The preferred volume setting of the movie. The volume parameter must contain a 16-bit, fixed-point number that contains the movie's default volume. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You may find the constants shown below useful. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

A movie's tracks may have their own volume settings. Use SetTrackVolume to set the volume of an individual track. A track's volume is scaled by the movie's volume to produce the track's final volume.
Special Considerations

After calling this function you must save the changes it has made, for example by updating or flattening the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMoviePreferredVolume (
   Movie    theMovie,
   short    volume ){};


/*GetMovieVolume

Returns a movie's current volume setting.

short GetMovieVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The current volume setting for the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMovieVolume (
   Movie    theMovie ){};


/*GetMoviePreferredVolume

Returns a movie's preferred volume setting.

short GetMoviePreferredVolume (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The movie's preferred volume setting.
Discussion

A movie's tracks have their own volume settings. A track's volume is scaled by the movie's volume to produce the track's final volume. On Macintosh computers, the movie's volume is further scaled by the sound volume that the user controls from the Sound control panel.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

short GetMoviePreferredVolume (
   Movie    theMovie ){};


/*MCPositionController

Controls the position of a movie and its controller on the computer display.

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
movieRect

A pointer to a Rect structure that specifies the coordinates of the movie's boundary Rect structure.
controllerRect

A pointer to a Rect structure that specifies the coordinates of the controller's boundary Rect structure. The movie controller component always centers the control portion of the controller inside this rectangle. The movie controller component only uses this parameter when the control portion of the controller is detached from the movie. If you are working with an attached controller, you can set this parameter to NIL.
someFlags

Flags (see below) that control how the movie is drawn. If you set these flags to 0, the movie controller component centers the movie in the rectangle specified by movieRect and scales the movie to fit in that rectangle. See these constants: 
mcTopLeftMovie
mcScaleMovieToFit
mcPositionDontInvalidate
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPositionController (
   MovieController    mc,
   const Rect         *movieRect,
   const Rect         *controllerRect,
   long               someFlags ){};


/*MCSetControllerAttached

Lets your application control whether a movie controller is attached to its movie or detached from it.

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
attach

The action for this function. Set the attach parameter to TRUE to cause the controller to be attached to its movie. Set this parameter to FALSE to detach the controller from its movie.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCSetControllerAttached (
   MovieController    mc,
   Boolean            attach ){};


/*MCGetVisible

Returns a value that indicates whether or not a movie controller is visible.

ComponentResult MCGetVisible (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

If the controller is visible, the function result is set to 1. If the controller is not showing, the function result is set to 0. You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCGetVisible (
   MovieController    mc ){};


/*MCUndo

Lets your application discard the effects of the most recent edit operation.

ComponentResult MCUndo (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCUndo (
   MovieController    mc ){};


/*MCCut

Returns a copy of the current movie selection from the movie associated with a specified controller and then removes the current movie selection from the source movie.

Movie MCCut (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the current movie selection.
Discussion

Your application is responsible for the returned movie. MCCut returns a movie containing the current selection from the movie associated with the specified controller. If the user has not made a selection, the returned movie reference is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

Movie MCCut (
   MovieController    mc ){};


/*(MCCopy

Returns a copy of the current movie selection from the movie associated with a specified controller.

Movie MCCopy (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A copy of the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
Movie MCCopy (
   MovieController    mc ){};



/*MCPaste

Inserts a specified movie at the current movie time in the movie associated with a specified controller.

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
srcMovie

The movie to be inserted into the current selection in the movie associated with the movie controller specified by the mc parameter. If you set this parameter to NIL, the movie controller component retrieves the source movie from the scrap.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCPaste (
   MovieController    mc,
   Movie              srcMovie ){};

/*MCClear

Removes the current movie selection from the movie associated with a specified controller.

ComponentResult MCClear (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCClear (
   MovieController    mc ){};


/*PutMovieOnScrap

Places a movie into the Macintosh scrap.

OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieScrapFlags

Flags (see below) that control the operation. Be sure to set unused flags to 0. See these constants: 
movieScrapDontZeroScrap
movieScrapOnlyPutMovie
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PutMovieOnScrap (
   Movie    theMovie,
   long     movieScrapFlags ){};


/*MCGetControllerInfo

Determines the current status of a movie controller and its associated movie, for menu highlighting.

ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
someFlags

A pointer to flags (see below) that specify the current status and capabilities of the controller. More than one flag may be set to 1. See these constants: 
mcInfoUndoAvailable
mcInfoCutAvailable
mcInfoCopyAvailable
mcInfoPasteAvailable
mcInfoClearAvailable
mcInfoHasSound
mcInfoIsPlaying
mcInfoIsLooping
mcInfoIsInPalindrome
mcInfoEditingEnabled
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can use the information returned by this function to control your application's menu highlighting.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCGetControllerInfo (
   MovieController    mc,
   long               *someFlags ){};

/*MCEnableEditing

Enables and disables editing for a movie controller.

ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
enabled

Specifies whether to enable or disable editing for the controller. Set this parameter to TRUE to enable editing; set it to FALSE to disable editing.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Once editing is enabled for a controller, the user may edit the movie associated with the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCEnableEditing (
   MovieController    mc,
   Boolean            enabled ){};


/*MCSetActionFilterWithRefCon

Establishes an action filter function for a movie controller.

ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
blob

A pointer to your MCActionFilterWithRefConProc callback. Set this parameter to NIL to remove an existing callback.
refCon

A reference constant value. The movie controller component passes this reference constant to your action filter callback each time it calls it. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The movie controller component calls your action filter function each time the component receives an action for its movie controller. Your filter function is then free to handle the action or to refer it back to the movie controller component. If you refer it back to the movie controller component, the component handles the action.

If your filter function handles an action, you can handle the action in any way you desire. For example, your filter function could change the operation of movie controller buttons. More commonly, applications use the action filter function to monitor actions of the controller. For instance, your filter function might enable you to find out when the user clicks the play button, so that your application can enable appropriate menu selections. Alternatively, you can use the filter function to detect when the user resizes the movie.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetActionFilterWithRefCon (
   MovieController                mc,
   MCActionFilterWithRefConUPP    blob,
   long                           refCon ){};



/*NewMCActionFilterWithRefConUPP

Allocates a Universal Procedure Pointer for the MCActionFilterWithRefConProc callback.

MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMCActionFilterWithRefConProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
MCActionFilterWithRefConUPP NewMCActionFilterWithRefConUPP (
   MCActionFilterWithRefConProcPtr    userRoutine ){};


/*SetMovieProgressProc

Attaches a progress function to a movie.

void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
p

Points to your MovieProgressProc callback. To remove a movie's progress function, set this parameter to NIL. Set this parameter to -1 for the Movie Toolbox to provide a default progress function.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

The Movie Toolbox calls your function only during long operations. It ensures that your progress function is called regularly, but not too often.

The following Movie Toolbox functions use progress functions: ConvertFileToMovieFile, CutMovieSelection, CopyMovieSelection, AddMovieSelection, and InsertMovieSegment.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieProgressProc (
   Movie               theMovie,
   MovieProgressUPP    p,
   long                refcon ){};

/*ExitMovies

Automatically called when an application quits.

void ExitMovies ( void );
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You only need to call this function if you finish with the Movie Toolbox long before your application is ready to quit. When you call ExitMovies, the Movie Toolbox releases the private storage (which may be significant) that was allocated when you called EnterMovies. As a general rule, your application seldom uses this function; the following code illustrates an exception:// ExitMovies coding example
// See "Discovering QuickTime," page 225
int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
                      LPSTR lpCmdLine, int nCmdShow)
{
    MSG         msg;
    HANDLE      hAccelTable;
 
    if  (!hPrevInstance)                   // Is there a previous instance?
        if (!(InitApplication(hInstance)))      // Register window class
            return FALSE;                       // Report failure
 
    if (InitializeQTML(0) !=0) {                       // Initialize QTML
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (InitializeQTML(0) !=0)
 
    if (EnterMovies() !=0) {                       // Initialize QuickTime
        MessageBox(hwnd, "QuickTime not available",     // Notify user
                            "", MB_OK);
        return FALSE;                                   // Report failure
    }  // end if (EnterMovies() !=0)
 
    if (!(InitInstance(hInstance, nCmdShow)))         // Create main window
        return FALSE;                                 // Report failure
 
    hAccelTable =LoadAccelerators(hInstance,     // Load accelerator table
                    MAKEINTRESOURCE(IDR_ACCELSIMPLESDI));
 
    //  Main message loop
 
    while (GetMessage(&msg, NIL, 0, 0))        // Retrieve next message
        if (!TranslateAccelerator(msg.hwnd,    // Check for kbd accelerator
                        hAccelTable, &msg)) {
            TranslateMessage(&msg);     // Convert virtual key to character
            DispatchMessage(&msg);      // Send message to window procedure
        }  // end if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg))
 
    ExitMovies();                                   // Terminate Toolbox
    TerminateQTML();                                // Terminate QuickTime
 
    return msg.wParam;
}  // end WinMain

Special Considerations

Before calling ExitMovies, be sure that you have closed your connections to any components that use the Movie Toolbox, such as movie controllers, sequence grabbers, and so on.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ExitMovies ( void ){};


/*QTGetPixelSize

Returns the bits per pixel for a given pixel format.

short QTGetPixelSize (
   OSType    PixelFormat );
Parameters
PixelFormat

A constant that identifies the pixel format; see Pixel Formats. This function returns meaningful information only for non-planar formats.
Return Value

The bits per pixel. Returns 0 if the format is unknown.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

short QTGetPixelSize (
   OSType    PixelFormat ){};


/*ImageCodecEffectConvertEffectSourceToFormat

Undocumented

ComponentResult ImageCodecEffectConvertEffectSourceToFormat (
   ComponentInstance         effect,
   EffectSourcePtr           sourceToConvert,
   ImageDescriptionHandle    requestedDesc );
Parameters
effect

An effect component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
sourceToConvert

Undocumented
requestedDesc

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ComponentResult ImageCodecEffectConvertEffectSourceToFormat (
   ComponentInstance         effect,
   EffectSourcePtr           sourceToConvert,
   ImageDescriptionHandle    requestedDesc ){};


/*QTGetPixMapPtrRowBytes

Gets the rowBytes value for a pixel map accessed by a pointer.

long QTGetPixMapPtrRowBytes (
   PixMapPtr    pm );
Parameters
pm

A pointer to a PixMap structure.
Return Value

The rowBytes value.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

long QTGetPixMapPtrRowBytes (
   PixMapPtr    pm ){};

/*CompSub

Undocumented

void CompSub (
   wide    *src,
   wide    *dst );
Parameters
src

Undocumented
dst

Undocumented
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

void CompSub (
   wide    *src,
   wide    *dst ){};


/*QTDoTween

Runs a tween component.

OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon );
Parameters
tween

The tween to be run.
atTime

A value that defines the time to run the tween.
result

A handle to the result of the tweening operation.
resultSize

A pointer to the size of the result.
tweenDataProc

A Universal Procedure Pointer that accesses a TweenerDataProc callback.
tweenDataRefCon

A pointer to a reference constant to be passed to your callback. Use this constant to point to a data structure containing any information your function needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTDoTween (
   QTTweener         tween,
   TimeValue         atTime,
   Handle            result,
   long              *resultSize,
   TweenerDataUPP    tweenDataProc,
   void              *tweenDataRefCon ){};


/*QTVRSetPanAngle

Sets the pan angle of a QuickTime VR movie.

OSErr QTVRSetPanAngle (
   QTVRInstance    qtvr,
   float           panAngle );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
panAngle

The desired pan angle of the specified movie. This value is constrained by the maximum and minimum pan angles of the movie. If the angle falls outside of those constraints and the control setting kQTVRWrapPan is disabled, the angle is set to the minimum or maximum, whichever is closer. If wrapping is enabled, the pan angle is clipped to fall within the constraints. Pan angle values are also clipped if the requested pan angle, when combined with the current tilt angle and field of view, would cause an image to lie outside the current constraints.
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code constraintReachedErr if wrapping is off and the angle is set to the minimum or maximum constraint value.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetPanAngle (
   QTVRInstance    qtvr,
   float           panAngle ){};


/*QTVRSetTiltAngle

Sets the tilt angle of a QuickTime VR movie.

OSErr QTVRSetTiltAngle (
   QTVRInstance    qtvr,
   float           tiltAngle );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
tiltAngle

The desired tilt angle of the specified movie. This value is constrained by the maximum and minimum tilt angles of the movie. If the angle falls outside of those constraints and the control setting kQTVRWrapTilt is disabled, the angle is set to the minimum or maximum, whichever is closer. If wrapping is enabled, the tilt angle is clipped to fall within the constraints. Tilt angle values are also clipped if the requested tilt angle, when combined with the current pan angle and field of view, would cause an image to lie outside the current constraints. 
Return Value

See Error Codes. Returns noErr if there is no error. This function returns the result code constraintReachedErr if wrapping is off and the angle is set to the minimum or maximum constraint value.
Special Considerations

The pan and tilt angles are subject to the current pan and tilt range constraints, as imposed by the viewing limits and the current field of view. Accordingly, if you want to change the field of view, you should do so before adjusting the pan or tilt angles. Otherwise, the pan and tilt angles are clipped against the current field of view, which may result in an incorrect view when you alter the field of view.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetTiltAngle (
   QTVRInstance    qtvr,
   float           tiltAngle ){};

/*QTVRGetControlSetting

Obtains the current state of a control setting for an object node.

OSErr QTVRGetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               *enable );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
setting

A control setting (see below). See these constants: 
kQTVRWrapPan
kQTVRWrapTilt
kQTVRCanZoom
kQTVRReverseHControl
kQTVRReverseVControl
kQTVRSwapHVControl
kQTVRTranslation
enable

On entry, a pointer to a Boolean value. On return, that value is set to TRUE if the specified control setting is currently enabled for the specified object node or to FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, through the enable parameter, the current state of the control setting specified by the setting parameter for the object node specified by the qtvr parameter. If enable is TRUE, the specified setting is currently enabled; otherwise, the setting is disabled.
Special Considerations

QTVRGetControlSetting is valid only for object nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetControlSetting (
   QTVRInstance          qtvr,
   QTVRControlSetting    setting,
   Boolean               *enable ){};


/*QTVRGetNodeType

Obtains the type of a movie node.

OSType QTVRGetNodeType (
   QTVRInstance    qtvr,
   UInt32          nodeID );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

A node ID. Pass kQTVRCurrentNode for the current node.
Return Value

The type of the node specified by the nodeID parameter in the QuickTime VR movie specified by the qtvr parameter.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSType QTVRGetNodeType (
   QTVRInstance    qtvr,
   UInt32          nodeID ){};

/*QTVRGetBackBufferSettings

Obtains information about the resolution, pixel format, and size of the back buffer maintained internally by QuickTime VR for caching a panoramic image in a particular pixel format.

OSErr QTVRGetBackBufferSettings (
   QTVRInstance    qtvr,
   UInt32          *geometry,
   UInt16          *resolution,
   UInt32          *cachePixelFormat,
   SInt16          *cacheSize );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
geometry

The type and orientation of the panorama data (see below). See these constants: 
kQTVRUseMovieGeometry
kQTVRVerticalCylinder
resolution

On entry, a pointer to an unsigned short integer. On return, that integer is set to the index of the current image resolution (see below). See these constants: 
kQTVRDefaultRes
kQTVRFullRes
kQTVRHalfRes
kQTVRQuarterRes
cachePixelFormat

On entry, a pointer to a long integer. On return, that long integer is set to the pixel format of the current panorama back buffer (see below). See these constants: 
cacheSize

On entry, a pointer to a short integer. On return, that integer is set to a value that describes the size of the current panorama back buffer. See these constants: 
kQTVRMinimumCache
kQTVRSuggestedCache
kQTVRFullCache
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, through the resolution parameter, the index of the current resolution for the QuickTime VR movie specified by the qtvr parameter. The index indicates which bit in the mask value returned by QTVRGetAvailableResolutions specifies the current resolution. For example, if the returned index is 1, the base resolution is being used. If the returned index is 2, then a resolution of half the base resolution is being used. This function also returns the pixel format and the cache size in the cachePixelFormat and cacheSize parameters, respectively.

The QuickTime VR file might not contain an image track corresponding to the resolution indicated by the resolution value returned. The QuickTime VR Manager may have set a lower resolution because memory is low, or the resolution may have been set by a call to QTVRSetBackBufferPrefs.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetBackBufferSettings (
   QTVRInstance    qtvr,
   UInt32          *geometry,
   UInt16          *resolution,
   UInt32          *cachePixelFormat,
   SInt16          *cacheSize ){};


/*QTVRGetVRWorld

Obtains the VR world atom container for a movie.

OSErr QTVRGetVRWorld (
   QTVRInstance       qtvr,
   QTAtomContainer    *VRWorld );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
VRWorld

On return, a pointer to an atom container that contains information about the specified movie.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the VRWorld parameter, a pointer to an atom container that contains general scene information about the QuickTime VR movie specified by the qtvr parameter, as well as a list of all the nodes in that movie. You can use the QuickTime atom functions to extract atoms from that container.
Special Considerations

The VR world atom container returned by this function is a copy of the atom container maintained internally by the QuickTime VR Manager. You should dispose of the VR world atom container by calling QTDisposeAtomContainer when you're finished using it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetVRWorld (
   QTVRInstance       qtvr,
   QTAtomContainer    *VRWorld ){};


/*QTCopyAtomDataToPtr

Copies the specified leaf atom's data to a buffer.

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
sizeOrLessOK

Specifies whether the function may copy fewer bytes than the number of bytes specified by the size parameter. The buffer may be larger than the amount of atom data if you set the value of this parameter to TRUE. You can determine the size of an atom's data by calling QTGetAtomDataPtr.
size

The length, in bytes, of the buffer pointed to by the targetPtr parameter.
targetPtr

A pointer to a buffer. On return, the buffer contains the atom data.
actualSize

A pointer to a long integer which, on return, contains the number of bytes copied to the buffer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing a data buffer, to retrieve a copy of a leaf atom's data. The buffer must be large enough to contain the atom's data.
Special Considerations

This function may move memory.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTCopyAtomDataToPtr (
   QTAtomContainer    container,
   QTAtom             atom,
   Boolean            sizeOrLessOK,
   long               size,
   void               *targetPtr,
   long               *actualSize ){};


/*QTVRGetNodeInfo

Obtains the node information atom container that describes a node and all the hot spots in the node.

OSErr QTVRGetNodeInfo (
   QTVRInstance       qtvr,
   UInt32             nodeID,
   QTAtomContainer    *nodeInfo );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
nodeID

A node ID. Set this parameter to kQTVRCurrentNode to receive information about the current node.
nodeInfo

On return, a pointer to an atom container that contains information about the specified node.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns, in the nodeInfo parameter, a pointer to an atom container that contains information about the node specified by the nodeID parameter in the movie specified by the qtvr parameter. The atom container includes information about all the hot spots contained in that node. You can use the QuickTime atom functions to extract atoms from that container. You can also use those functions to access the hot spot atom list. All hot spot atoms are contained in the hot spot parent atom.
Special Considerations

The node information atom container returned by this function is a copy of the atom container maintained internally by the QuickTime VR Manager. You should dispose of the node information atom container, by calling QTDisposeAtomContainer, when you're finished using it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetNodeInfo (
   QTVRInstance       qtvr,
   UInt32             nodeID,
   QTAtomContainer    *nodeInfo ){};


/*MCSetUpEditMenu

Correctly highlights and names the items in your application's Edit menu.

ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
modifiers

The current modifiers from the mouse-down or key-down event to which you are responding.
mh

A menu handler for your current Edit menu. The first six items in your Edit menu should be the standard editing commands: Undo, a blank line, Cut, Copy, Paste, and Clear.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCSetUpEditMenu (
   MovieController    mc,
   long               modifiers,
   MenuRef            mh ){};


/*DeleteMovieFile

Deletes a movie file.

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec );
Parameters
fileSpec

A pointer to the file system specification for the movie file to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier. Superseded in QuickTime 6 by DeleteMovieStorage.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr DeleteMovieFile (
   const FSSpec    *fileSpec ){};


/*FlattenMovieData

Creates a new movie and a file that contains all the movie data.

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Contains flags (see below) that control the process of adding movie data to the new movie file. These flags affect how the toolbox adds movies to the new movie file later. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenFSSpecPtrIsDataRefRecordPtr
flattenForceMovieResourceBeforeMovieData
theFile

This parameter usually contains a pointer to the file system specification for the movie file to be created. In place of a FSSpec pointer, QuickTime lets you pass a pointer to a data reference structure to receive the flattened movie data.
creator

The creator value for the new file.
scriptTag

Contains constants (see below) that specify the script in which the movie file should be created. See Inside Macintosh: Text for more information about scripts and script tags. See these constants: 
createMovieFileFlags

Contains flags (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets this returned identifier to NIL.
Discussion

This function will take any movie and optionally make it self-contained, interleaved, and Fast Start. Unlike FlattenMovie, this function does not add the new movie resource to the new movie file; instead, FlattenMovieData returns the new movie to your application. Your application must dispose of the returned movie. You can use this function to create a single-fork movie file, by setting the flattenAddMovieToDataFork flag in the movieFlattenFlags parameter to 1. The Movie Toolbox then places the movie into the data fork of the movie file. Instead of flattening to a file, you can specify a data reference to flatten a movie to. The following two code samples show flattening a movie to a data location and to a file:// FlattenMovieData used to flatten a movie to a data location
// create a 0-length handle
    myHandle =NewHandleClear(mySize);
    if (myHandle ==NIL)
        goto bail;
 
// fill in the data reference record
    myDataRefRec.dataRefType =HandleDataHandlerSubType;
    myDataRefRec.dataRef =NewHandle(sizeof(Handle));
    if (myDataRefRec.dataRef ==NIL)
        goto bail;
    *((Handle *)*(myDataRefRec.dataRef)) =myHandle;
    myFlags =flattenFSSpecPtrIsDataRefRecordPtr;
    myFile =(FSSpec *)&myDataRefRec;
    // flatten the source movie into the handle
    myMemMovie =FlattenMovieData(mySrcMovie, myFlags, myFile, 0L,
                                  smSystemScript, 0L);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork |
        flattenForceMovieResourceBeforeMovieData,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
    Movie aMovie;
    aMovie =FlattenMovieData(theMovie,
        flattenAddMovieToDataFork,
        &theOutputFile, OSTypeConst('TVOD'), smSystemScript,
        createMovieFileDeleteCurFile | createMovieFileDontCreateResFile);
 
    DisposeMovie(aMovie);
// FlattenMovieData used to flatten a movie to a Fast Start file
// See "Discovering QuickTime," page 257
myErr =OpenMovieFile(&myTempSpec, &myTempResRefNum, fsRdPerm);
if (myErr !=noErr)
    goto bail;
myErr =NewMovieFromFile(&myTempMovie, myTempResRefNum, NIL, 0, 0, 0);
if (myErr !=noErr)
    goto bail;
SetMovieProgressProc(myTempMovie, (MovieProgressUPP)-1, 0L);
// flatten the temporary file into a new movie file; put the movie
// resource first so that progressive downloading is possible
myPanoMovie =FlattenMovieData(
                        myTempMovie,
                        flattenDontInterleaveFlatten
                        | flattenAddMovieToDataFork
                        | flattenForceMovieResourceBeforeMovieData,
                        &myDestSpec,
                        FOUR_CHAR_CODE('TVOD'),
                        smSystemScript,
                        createMovieFileDeleteCurFile
                        | createMovieFileDontCreateResFile);

Special Considerations

Through the SetTrackLoadSettings function, the Movie Toolbox allows you to set a movie's preloading guidelines when you create the movie. The preload information is preserved when you save or flatten the movie (using either FlattenMovie or FlattenMovieData). In flattened movies, the tracks that are to be preloaded are stored at the start of the movie, rather than being interleaved with the rest of the movie data. This greatly improves preload performance because it is not necessary for the device storing the movie data to seek during retrieval of the data to be preloaded. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

Movie FlattenMovieData (
   Movie           theMovie,
   long            movieFlattenFlags,
   const FSSpec    *theFile,
   OSType          creator,
   ScriptCode      scriptTag,
   long            createMovieFileFlags ){};


/*SetMovieCoverProcs

Sets the callbacks invoked when a movie is covered or uncovered.

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
uncoverProc

Points to a MovieRgnCoverProc callback. This function is called whenever one of your movie's tracks is removed from the screen or resized, revealing a previously hidden screen region. If you want to remove this uncover function, set this parameter to NIL. When the uncoverProc parameter is NIL the function uses the default uncover function, which erases the uncovered area.
coverProc

Points to a MovieRgnCoverProc callback. The Movie Toolbox calls this function whenever one of your movies covers a portion of the screen. If you want to remove the cover function, set this parameter to NIL. When the coverProc parameter is NIL the function uses the default cover function, which does nothing.
refcon

Specifies a reference constant. Use this parameter to point to a data structure containing any information your callbacks need.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If a movie with semi-transparent tracks has a movie uncover procedure, set with this function, the uncover procedure is called before each frame to fill or erase the background.
Version Notes

Before QuickTime 1.6.1, the Movie Toolbox performed the erase, which limited a cover procedure-aware application's options.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetMovieCoverProcs (
   Movie               theMovie,
   MovieRgnCoverUPP    uncoverProc,
   MovieRgnCoverUPP    coverProc,
   long                refcon ){};







/*NewMovieRgnCoverUPP

Allocates a Universal Procedure Pointer for the MovieRgnCoverProc callback.

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieRgnCoverProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

MovieRgnCoverUPP NewMovieRgnCoverUPP (
   MovieRgnCoverProcPtr    userRoutine ){};


/*QTVRSetBackBufferImagingProc

Installs or removes a QTVR back buffer imaging procedure.

OSErr QTVRSetBackBufferImagingProc (
   QTVRInstance                qtvr,
   QTVRBackBufferImagingUPP    backBufferImagingProc,
   UInt16                      numAreas,
   QTVRAreaOfInterest          areasOfInterest[],
   SInt32                      refCon );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
backBufferImagingProc

A Universal Procedure Pointer for a QTVRBackBufferImagingProc callback. To remove a previously installed back buffer imaging procedure, pass NIL.
numAreas

The number of area of interest structures in the array pointed to by the areasOfInterest parameter.
areasOfInterest[]

A pointer to an array of QTVRAreaOfInterest structures. Each structure defines a rectangular areas about which you want your back buffer imaging procedure to be notified. Your procedure is called for each area of interest as it becomes visible or not visible. You indicate when you want your procedure to be called for a particular area of interest by setting flags in the flags field in the corresponding area of interest structure. The width of the area of interest is limited by the size of the back buffer. If the back buffer is less than the full cache size, then the area of interest can be no wider than half the size of the back buffer. (For vertical cylinder geometries, limiting factor would be the height of the buffer.) For a full cache back buffer, the width of the area of interest can be the full size of the buffer. If the width limit is exceeded, this function returns constraintReachedErr. 
refCon

A reference constant. This value is passed to the specified back buffer imaging callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the procedure specified by the backBufferImagingProc parameter as a back buffer imaging procedure for the panoramic node specified by the qtvr parameter. You can use that procedure to draw directly into the back buffer. Coordinates in the back buffer are dependent on the current correction mode; as a result, you need to indicate the area you're interested in drawing into by specifying a pan angle and tilt angle to determine the upper-left corner of the area and a height and width relative to that corner. Specifying a height and width instead of a second pair of pan and tilt angles for the bottom-right coordinate allows the rectangle to wrap around the edge of the panorama.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRSetBackBufferImagingProc (
   QTVRInstance                qtvr,
   QTVRBackBufferImagingUPP    backBufferImagingProc,
   UInt16                      numAreas,
   QTVRAreaOfInterest          areasOfInterest[],
   SInt32                      refCon ){};

/*QTVRRefreshBackBuffer

Refreshes the QTVR back buffer.

OSErr QTVRRefreshBackBuffer (
   QTVRInstance    qtvr,
   UInt32          flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function refreshes some or all of the back buffer associated with the QuickTime VR movie specified by the qtvr parameter by reloading the appropriate data from the diced frames in the panorama image track. You can call this function either in a back buffer imaging procedure or elsewhere in your application. If you call this function in a back buffer imaging procedure, only the current rectangle (that is, the rectangle specified by the procedure's drawRect parameter) is refreshed. If you call this function outside of a back buffer imaging procedure, all areas of interest specified in the most recent call to QTVRSetBackBufferImagingProc are refreshed.
Special Considerations

This function is valid only for panoramic nodes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRRefreshBackBuffer (
   QTVRInstance    qtvr,
   UInt32          flags ){};












/*MediaSetGraphicsMode

Sets the graphics mode and blend color of any media handler.

ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
mode

The graphics mode of the media handler; see Graphics Transfer Modes.
opColor

A pointer to the color for use in blending and transparent operations. The media handler passes this color to QuickDraw as appropriate when you draw in addPin, subPin, blend, transparent, or graphicsModeStraightAlphaBlend mode.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetGraphicsMode (
   MediaHandler      mh,
   long              mode,
   const RGBColor    *opColor ){};


/*SetSpriteProperty

Sets the specified property of a sprite.

OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue );
Parameters
theSprite

The sprite for this operation.
propertyType

The property you want to modify (see below). See these constants: 
kSpritePropertyMatrix
kSpritePropertyImageDescription
kSpritePropertyImageDataPtr
kSpritePropertyVisible
kSpritePropertyLayer
kSpritePropertyGraphicsMode
kSpritePropertyCanBeHitTested
propertyValue

The new value of the property. Depending on the property type, you set the propertyValue parameter to either a pointer to the property value or the property value itself, cast as a void pointer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You animate a sprite by modifying its properties, using this function. It invalidates the sprite's sprite world as needed. Here is sample code that uses this function to modify a sprite's properties:// SetSpriteProperty coding example
// See "Discovering QuickTime," page 345
#define kNumSprites             4
#define kNumSpaceShipImages     24
Rect            gBounceBox;
Sprite          gSprites[kNumSprites];
Rect            gDestRects[kNumSprites];
Point           gDeltas[kNumSprites];
short           gCurrentImages[kNumSprites];
Handle          gCompressedPictures[kNumSpaceShipImages];
void MyMoveSprites (void)
{
    short           nIndex;
    MatrixRecord    matrix;
 
    SetIdentityMatrix(&matrix);
    // for each sprite
    for (nIndex =0; nIndex < kNumSprites; nIndex++) {
        // modify the sprite's matrix
        OffsetRect(&gDestRects[nIndex], gDeltas[nIndex].h,
                    gDeltas[nIndex].v);
 
        if ((gDestRects[nIndex].right >
=gBounceBox.right) ||
            (gDestRects[nIndex].left <=gBounceBox.left))
            gDeltas[nIndex].h =-gDeltas[nIndex].h;
 
        if ((gDestRects[nIndex].bottom >
=gBounceBox.bottom) ||
            (gDestRects[nIndex].top <=gBounceBox.top))
            gDeltas[nIndex].v =-gDeltas[nIndex].v;
 
        matrix.matrix[2][0] =((long)gDestRects[nIndex].left << 16);
        matrix.matrix[2][1] =((long)gDestRects[nIndex].top << 16);
 
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyMatrix,
                            &matrix);
 
        // change the sprite's image
        gCurrentImages[nIndex]++;
        if (gCurrentImages[nIndex] >
=(kNumSpaceShipImages *
                                        (nIndex+1)))
            gCurrentImages[nIndex] =0;
        SetSpriteProperty(gSprites[nIndex], kSpritePropertyImageDataPtr,
            *gCompressedPictures[gCurrentImages[nIndex] / (nIndex+1)]);
    }
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetSpriteProperty (
   Sprite    theSprite,
   long      propertyType,
   void      *propertyValue ){};


/*DisposeSprite

Disposes of a sprite.

void DisposeSprite (
   Sprite    theSprite );
Parameters
theSprite

The sprite to be disposed of.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You call this function to dispose of a sprite created by NewSprite. The image description handle and image data pointer associated with the sprite are not disposed of by this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeSprite (
   Sprite    theSprite ){};





/*GetCompressedPixMapInfo

Retrieves information about a compressed image.

OSErr GetCompressedPixMapInfo (
   PixMapPtr                 pix,
   ImageDescriptionHandle    *desc,
   Ptr                       *data,
   long                      *bufferSize,
   ICMDataProcRecord         *dataProc,
   ICMProgressProcRecord     *progressProc );
Parameters
pix

Points to a structure that holds encoded compressed image data.
desc

A pointer to a field that is to receive a handle to the ImageDescription structure that defines the compressed image. If you are not interested in this information, specify NIL in this parameter.
data

A pointer to a field that is to receive a pointer to the compressed image data. If the entire compressed image cannot be stored at this location, you can define a data-loading function for this operation. If you are not interested in this information, you may specify NIL in this parameter.
bufferSize

A pointer to a field that is to receive the size of the buffer to be used by the data-loading function specified by the dataProc parameter. If there is no data-loading function defined for this operation, this parameter is ignored. If you are not interested in this information, you may specify NIL in this parameter.
dataProc

A pointer to an ICMDataProc callback. If there is not enough memory to store the compressed image, the decompressor calls a function you provide that loads more compressed data. If there is no data-loading function for this image, the function sets the dataProc field in the function structure to NIL. If you are not interested in this information, specify NIL in this parameter.
progressProc

A pointer to an ICMProgressProc callback. During a decompression operation, the decompressor may occasionally call a function you provide in order to report its progress. If there is no progress function for this image, the function sets the progressProc field in the function structure to NIL. If you pass a value of -1, QuickTime provides a standard progress function. If you are not interested in progress information, specify NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCompressedPixMapInfo (
   PixMapPtr                 pix,
   ImageDescriptionHandle    *desc,
   Ptr                       *data,
   long                      *bufferSize,
   ICMDataProcRecord         *dataProc,
   ICMProgressProcRecord     *progressProc ){};


/*SetImageDescriptionCTable

Updates the custom ColorTable structure for an image.

OSErr SetImageDescriptionCTable (
   ImageDescriptionHandle    desc,
   CTabHandle                ctable );
Parameters
desc

Contains a handle to the appropriate ImageDescription structure. The function updates the size of the structure to accommodate the new ColorTable structure and removes the old color table, if one is present.
ctable

A handle to the new ColorTable structure. The function loads this color table into the ImageDescription structure referred to by the desc parameter. Set this parameter to NIL to remove a ColorTable structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function does not change the image data, just the color table.
Special Considerations

This function is rarely used. Typically, you supply the color table when your application compresses an image, and the Image Compression Manager stores the ColorTable structure with the image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr SetImageDescriptionCTable (
   ImageDescriptionHandle    desc,
   CTabHandle                ctable ){};


/*CompressSequenceBegin

Signals the beginning of the process of compressing a sequence of frames.

OSErr CompressSequenceBegin (
   ImageSequence             *seqID,
   PixMapHandle              src,
   PixMapHandle              prev,
   const Rect                *srcRect,
   const Rect                *prevRect,
   short                     colorDepth,
   CodecType                 cType,
   CompressorComponent       codec,
   CodecQ                    spatialQuality,
   CodecQ                    temporalQuality,
   long                      keyFrameRate,
   CTabHandle                ctable,
   CodecFlags                flags,
   ImageDescriptionHandle    desc );
Parameters
seqID

A pointer to a field to receive the unique identifier for this sequence. You must supply this identifier to all subsequent Image Compression Manager functions that relate to this sequence.
src

A handle to a pixel map that will contain the image to be compressed. The image must be stored in a pixel map structure.
prev

A handle to a pixel map that will contain a previous image. The compressor uses this buffer to store a previous image against which the current image (stored in the pixel map referred to by the src parameter) is compared when performing temporal compression. This pixel map must be created at the same depth and with the same color table as the source image. The compressor manages the contents of this pixel map based upon several considerations, such as the key frame rate and the degree of difference between compared images. If you want the compressor to allocate this pixel map or if you do not want to perform temporal compression (that is, you have set the value of the temporalQuality parameter to 0), set this parameter to NIL.
srcRect

A pointer to a rectangle defining the portion of the image to compress. The compressor applies this rectangle to the image stored in the buffer referred to by the src parameter.
prevRect

A pointer to a rectangle defining the portion of the previous image to use for temporal compression. The compressor uses this portion of the previous image as the basis of comparison with the current image. The compressor ignores this parameter if you have not provided a buffer for previous images. This rectangle must be the same size as the source rectangle, which is specified with the srcRect parameter.
colorDepth

The depth at which the sequence is likely to be viewed. Compressors may use this as an indication of the color or grayscale resolution of the compressed images. If you set this parameter to 0, the Image Compression Manager determines the appropriate value for the source image. Values of 1, 2, 4, 8, 16, 24, and 32 indicate the number of bits per pixel for color images. Values of 34, 36, and 40 indicate 2-bit, 4-bit, and 8-bit grayscale, respectively, for grayscale images. Your program can determine which depths are supported by a given compressor by examining the compressor information structure returned by the GetCodecInfo function.
cType

You must set this parameter to a valid compressor type constant. See Codec Identifiers.
codec

Specify a particular compressor by setting this parameter to its compressor identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
spatialQuality

A pointer to a field containing a constant (see below) that defines the desired compressed image quality. You can change the value of this parameter for an active sequence by calling SetCSequenceQuality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
temporalQuality

A pointer to a field containing a constant (see below) that defines the desired temporal quality. This parameter governs the level of compression you desire with respect to information between successive frames in the sequence. Set to 0 if you do not want temporal compression. You can change the value of this parameter for an active sequence by calling SetCSequenceQuality.
keyFrameRate

Specifies the maximum number of frames allowed between key frames. The compressor determines the optimum placement for key frames based upon the amount of redundancy between adjacent images in the sequence. Consequently, the compressor may insert key frames more frequently than you have requested. However, the compressor never places fewer key frames than is indicated by the setting of the keyFrameRate parameter. The compressor ignores this parameter if you have not requested temporal compression (that is, you have set the temporalQuality parameter to 0). If you pass in 0 in this parameter, this indicates that there are no key frames in the sequence. If you pass in any other number, it specifies the number of non-key frames between key frames. Set this parameter to 1 to specify all key frames, to 2 to specify every other frame as a key frame, to 3 to specify every third frame as a key frame, and so forth. Your application may change the key frame rate for an active sequence by calling SetCSequenceKeyFrameRate.
ctable

A handle to a custom color lookup table. Your program may use this parameter to indicate a custom color lookup table to be used with this image. If the value of the colorDepth parameter is less than or equal to 8 and the custom color lookup table is different from that of the source pixel map (that is, the ctSeed field values differ in the two pixel maps), the compressor remaps the colors of the image to the custom colors. If you set the colorDepth parameter to 16, 24, or 32, the compressor stores the custom color table with the compressed image. The compressor may use the table to specify the best colors to use when displaying the image at lower bit depths. The compressor ignores the ctable parameter when colorDepth is set to 33, 34, 36, or 40. If you set this parameter to NIL, the compressor uses the color lookup table from the source pixel map.
flags

Contains flags (see below) that provide further control information. You must set either codecFlagUpdatePrevious or codecFlagUpdatePreviousComp to 1. Set unused flags to 0. See these constants: 
codecFlagUpdatePrevious
codecFlagUpdatePreviousComp
codecFlagWasCompressed
desc

A handle that is to receive a formatted ImageDescription structure. The Image Compression Manager resizes this handle for the returned image description structure. Your application should store this image description with the compressed sequence. During the compression operation, the Image Compression Manager and the compressor component update the contents of this image description. Consequently, you should not store the image description until the sequence has been completely processed.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The Image Compression Manager prepares for a sequence-compression operation by reserving appropriate system resources. Hence you must call CompressSequenceBegin before you call CompressSequenceFrame.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr CompressSequenceBegin (
   ImageSequence             *seqID,
   PixMapHandle              src,
   PixMapHandle              prev,
   const Rect                *srcRect,
   const Rect                *prevRect,
   short                     colorDepth,
   CodecType                 cType,
   CompressorComponent       codec,
   CodecQ                    spatialQuality,
   CodecQ                    temporalQuality,
   long                      keyFrameRate,
   CTabHandle                ctable,
   CodecFlags                flags,
   ImageDescriptionHandle    desc ){};


/*CDSequenceNewDataSource

Creates a new data source.

OSErr CDSequenceNewDataSource (
   ImageSequence              seqID,
   ImageSequenceDataSource    *sourceID,
   OSType                     sourceType,
   long                       sourceInputNumber,
   Handle                     dataDescription,
   ICMConvertDataFormatUPP    transferProc,
   void                       *refCon );
Parameters
seqID

The unique sequence identifier that was returned by the DecompressSequenceBegin function.
sourceID

Returns the new data source identifier.
sourceType

A four-character code describing how the input will be used. This code is usually derived from the information returned by the codec. For example, if a mask plane was passed, this field might contain 'mask'.
sourceInputNumber

More than one instance of a given source type may exist. The first occurrence should have a source input number of 1, the second a source input number of 2, and so on.
dataDescription

A handle to a data structure describing the input data. For compressed image data, this is an ImageDescriptionHandle.
transferProc

A routine that allows the application to transform the type of the input data to the kind of data preferred by the codec. The client of the codec passes the source data in the form most convenient for it. If the codec needs the data in another form, it can negotiate with the client or directly with the Image Compression Manager to obtain the required data format.
refCon

A reference constant to be passed to the transfer procedure. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function returns a sourceID parameter which must be passed to all other functions that reference the source. All data sources are automatically disposed when the sequence they are associated with is disposed.// CDSequenceNewDataSource coding example
// See "Discovering QuickTime," page 309
{
    ImageSequenceDataSource     lSrc1 =0;
    // Store a description of the first GWorld in hImageDesc1
    nErr =MakeImageDescriptionForPixMap(GetGWorldPixMap(gWorld1),
                    &hImageDesc1);
    // Create a source from the GWorld description.
    nErr =CDSequenceNewDataSource(gEffectSequenceID,
                                    &lSrc1,
                                    'srcA',
                                    1,
                                    (Handle)hImageDesc1,
                                    NIL,
                                    0);
    // Set the data for source srcA to be the pixMap of gWorld1
    CDSequenceSetSourceData(lSrc1,
                            GetPixBaseAddr(GetGWorldPixMap(gWorld1)),
                            (**hImageDesc1).dataSize);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceNewDataSource (
   ImageSequence              seqID,
   ImageSequenceDataSource    *sourceID,
   OSType                     sourceType,
   long                       sourceInputNumber,
   Handle                     dataDescription,
   ICMConvertDataFormatUPP    transferProc,
   void                       *refCon ){};


/*CDSequenceSetSourceData

Sets data in a new frame to a specific data source.

OSErr CDSequenceSetSourceData (
   ImageSequenceDataSource    sourceID,
   void                       *data,
   long                       dataSize );
Parameters
sourceID

Contains the source identifier of the data source.
data

Points to the data. This pointer must contain a 32-bit clean address.
dataSize

The size of the data buffer.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is called to set data in a new frame to a specific source. For example, as a new frame of compressed data arrives at a source, CDSequenceSetSourceData will be called.// CDSequenceSetSourceData coding example
// See "Discovering QuickTime," page 309
{
    ImageSequenceDataSource     lSrc1 =0;
    // Store a description of the first GWorld in hImageDesc1
    nErr =MakeImageDescriptionForPixMap(GetGWorldPixMap(gWorld1),
                    &hImageDesc1);
    // Create a source from the GWorld description.
    nErr =CDSequenceNewDataSource(gEffectSequenceID,
                                    &lSrc1,
                                    'srcA',
                                    1,
                                    (Handle)hImageDesc1,
                                    NIL,
                                    0);
    // Set the data for source srcA to be the pixMap of gWorld1
    CDSequenceSetSourceData(lSrc1,
                            GetPixBaseAddr(GetGWorldPixMap(gWorld1)),
                            (**hImageDesc1).dataSize);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceSetSourceData (
   ImageSequenceDataSource    sourceID,
   void                       *data,
   long                       dataSize ){};



/*CompressSequenceFrame

Compresses one of a sequence of frames.

OSErr CompressSequenceFrame (
   ImageSequence                 seqID,
   PixMapHandle                  src,
   const Rect                    *srcRect,
   CodecFlags                    flags,
   Ptr                           data,
   long                          *dataSize,
   UInt8                         *similarity,
   ICMCompletionProcRecordPtr    asyncCompletionProc );
Parameters
seqID

Unique sequence identifier that was returned by CompressSequenceBegin.
src

A handle to a pixel map that contains the image to be compressed. The image must be stored in a pixel map structure.
srcRect

A pointer to a rectangle defining the portion of the image to compress. The compressor applies this rectangle to the image stored in the buffer referred to by the src parameter.
flags

Specifies flags (see below) that provide further control information. You must set either codecFlagUpdatePrevious or codecFlagUpdatePreviousComp to 1. Set unused flags to 0. See these constants: 
codecFlagUpdatePrevious
codecFlagWasCompressed
codecFlagUpdatePreviousComp
codecFlagForceKeyFrame
codecFlagLiveGrab
data

Points to a location to receive the compressed image data. It is your program's responsibility to make sure that this location can receive at least as much data as indicated by the GetMaxCompressionSize function. The Image Compression Manager places the actual size of the compressed image into the field referred to by the dataSize parameter. This pointer must contain a 32-bit clean address.
dataSize

A pointer to a field that is to receive the size, in bytes, of the compressed image.
similarity

A pointer to a field that is to receive a similarity value. The CompressSequenceFrame function returns a value that indicates the similarity of the current frame to the previous frame. A value of 0 indicates that the current frame is a key frame in the sequence. A value of 255 indicates that the current frame is identical to the previous frame. Values from 1 through 254 indicate relative similarity, ranging from very different (1) to very similar (254).
asyncCompletionProc

Points to an ICMCompletionProc callback. The compressor calls your completion function when an asynchronous compression operation is complete. You can cause the compression to be performed asynchronously by specifying a completion function if the compressor supports asynchronous compression.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The Image Compression Manager prepares for a sequence-compression operation by reserving appropriate system resources. Hence you must call CompressSequenceBegin before you call CompressSequenceFrame.
Special Considerations

If you specify asynchronous operation, you must not read the compressed data until the compressor indicates that the operation is complete by calling your completion function. Set asyncCompletionProc to NIL to specify synchronous compression. If you set asyncCompletionProc to -1, the operation is performed asynchronously but the compressor does not call your completion function. If the asyncCompletionProc parameter is not NIL, the following conditions are in effect: the pixels in the source image must stay valid until the completion function is called with its codecCompletionSource flag, and the resulting compressed data is not valid until it is called with its codecCompletionDest flag set.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CompressSequenceFrame (
   ImageSequence                 seqID,
   PixMapHandle                  src,
   const Rect                    *srcRect,
   CodecFlags                    flags,
   Ptr                           data,
   long                          *dataSize,
   UInt8                         *similarity,
   ICMCompletionProcRecordPtr    asyncCompletionProc ){};



/*SetCSequencePrev

Allows the application to set the pixel map and boundary rectangle used by the previous frame in temporal compression.

OSErr SetCSequencePrev (
   ImageSequence    seqID,
   PixMapHandle     prev,
   const Rect       *prevRect );
Parameters
seqID

The unique sequence identifier assigned by CompressSequenceBegin or DecompressSequenceBegin.
prev

A handle to the new previous image buffer. You must allocate this buffer using the same pixel depth and ColorTable structure as the source image buffer that you specified with the src parameter when you called CompressSequenceBegin. The compressor uses this buffer to store a previous image against which the current image is compared when performing temporal compression. The compressor manages the contents of this buffer based upon several considerations, such as the key frame rate and the degree of difference between compared images. The current image is stored in the buffer referred to by the src parameter to CompressSequenceBegin. 
prevRect

A pointer to a Rect structure that defines the portion of the previous image to use for temporal compression. The compressor uses this portion of the previous image as the basis of comparison with the current image. This rectangle must be the same size as the source rectangle you specify with the srcRect parameter to CompressSequenceBegin. To get the boundary of a source pixel map, set this parameter to NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When you start compressing a sequence, you may assign a previous frame buffer and rectangle with the prev and prevRect parameters to CompressSequenceBegin. If you specified a NIL value for the prev parameter, the compressor allocates an offscreen buffer for the previous frame. In either case you may use this function to assign a new previous frame buffer.
Special Considerations

This is a very specialized function; your application should not need to call it under most circumstances.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr SetCSequencePrev (
   ImageSequence    seqID,
   PixMapHandle     prev,
   const Rect       *prevRect ){};



/*NewSpriteWorld

Creates a new sprite world.

OSErr NewSpriteWorld (
   SpriteWorld    *newSpriteWorld,
   GWorldPtr      destination,
   GWorldPtr      spriteLayer,
   RGBColor       *backgroundColor,
   GWorldPtr      background );
Parameters
newSpriteWorld

A pointer to a field that is to receive the new sprite world's identifier. On return, this field contains the identifier for the newly created sprite world.
destination

A pointer to a CGrafPort structure that defines the graphics world to be used as the destination.
spriteLayer

A pointer to a CGrafPort structure that defines the graphics world to be used as the sprite layer.
backgroundColor

A pointer to an RGBColor structure that defines the color to be used as the background color. If you pass a background graphics world to this function by setting the background parameter, you can set this parameter to NIL.
background

A pointer to a CGrafPort structure that defines the graphics world to be used as the background. If you pass a background color to this function by setting the backgroundColor parameter, you can set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to create a new sprite world with associated destination and sprite layer graphics worlds, and either a background color or a background graphics world. Once created, you can manipulate the sprite world and add sprites to it using other sprite Movie Toolbox functions.

The newSpriteWorld, destination, and spriteLayer parameters are all required. You should specify a background color, a background graphics world, or both. You should not pass NIL for both parameters. If you specify both a background graphics world and a background color, the sprite world is filled with the background color before the background sprites are drawn. If no background color is specified, black is the default. If you specify a background graphics world, it should have the same dimensions and depth as the graphics world specified by spriteLayer. If you draw to the graphics worlds associated with a sprite world using standard QuickDraw and QuickTime functions, your drawing is erased by the sprite world's background color. The sprite world created by this function has an identity matrix and does not have a clip shape.

Here is an example of creating a sprite world:// NewSpriteWorld coding example
// See "Discovering QuickTime," page 166
GWorldPtr       pSpritePlane =NIL;
SpriteWorld     spriteWorld =NIL;
Rect            rectBounce;
RGBColor        rgbcBackground;
void CreateSpriteStuff (Rect *pWndRect, CGrafPtr pMacWnd)
{
    OSErr       nErr;
    Rect        rect;
    // calculate the size of the destination
    rect =*pWndRect;
    OffsetRect(&rect, -rect.left, -rect.top);
    rectBounce =rect;
    InsetRect(&rectBounce, 16, 16);
    // create a sprite graphics world with a bit depth of 16
    NewGWorld(&pSpritePlane, 16, &rect, NIL, NIL, useTempMem);
    if (pSpritePlane ==NIL)
        NewGWorld(&pSpritePlane, 16, &rect, NIL, NIL, 0);
    if (pSpritePlane !=NIL) {
        LockPixels(pSpritePlane->
portPixMap);
        rgbcBackground.red =
        rgbcBackground.green =
        rgbcBackground.blue =0;
        // create a sprite world
        nErr =NewSpriteWorld(&spriteWorld, (CGrafPtr)pMacWnd,
            pSpritePlane, &rgbcBackground, NIL);
    }
}

Special Considerations

Before calling this function, you should lock the pixel maps of the sprite layer and background graphics worlds. These graphics worlds must remain valid and locked for the lifetime of the sprite world. The sprite world does not own the graphics worlds that are associated with it; it is the caller's responsibility to dispose of the graphics worlds when they are no longer needed.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewSpriteWorld (
   SpriteWorld    *newSpriteWorld,
   GWorldPtr      destination,
   GWorldPtr      spriteLayer,
   RGBColor       *backgroundColor,
   GWorldPtr      background ){};


/*NewSprite

Creates a new sprite in a specified sprite world.

OSErr NewSprite (
   Sprite                    *newSprite,
   SpriteWorld               itsSpriteWorld,
   ImageDescriptionHandle    idh,
   Ptr                       imageDataPtr,
   MatrixRecord              *matrix,
   Boolean                   visible,
   short                     layer );
Parameters
newSprite

A pointer to field that is to receive the new sprite's identifier. On return, this field contains the identifier of the newly created sprite.
itsSpriteWorld

The sprite world with which the new sprite should be associated.
idh

A handle to an ImageDescription structure of the sprite's image.
imageDataPtr

A pointer to the sprite's image data.
matrix

A pointer to the sprite's MatrixRecord structure. If you pass NIL, an identity matrix is assigned to the sprite.
visible

Specifies whether the sprite is visible.
layer

The sprite's layer. Sprites with lower layer values appear in front of sprites with higher layer values. If you want to create a sprite that is drawn to the background graphics world, you should specify the constant kBackgroundSpriteLayerNum for the layer parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The visible parameter, the layer parameter, and the newSprite and itsSpriteWorld parameters are required. You can defer assigning image data to the sprite by passing NIL for both the idh and imageDataPtr parameters. If you choose to defer assigning image data, you must call SetSpriteProperty to assign the image description handle and image data to the sprite before the next call to SpriteWorldIdle.
Special Considerations

The caller owns the image description handle and the image data pointer; it is the caller's responsibility to dispose of them after it disposes of a sprite.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewSprite (
   Sprite                    *newSprite,
   SpriteWorld               itsSpriteWorld,
   ImageDescriptionHandle    idh,
   Ptr                       imageDataPtr,
   MatrixRecord              *matrix,
   Boolean                   visible,
   short                     layer ){};


/*GetCSequenceMaxCompressionSize

Determines the maximum size an image will be after compression for a given compression sequence.

OSErr GetCSequenceMaxCompressionSize (
   ImageSequence    seqID,
   PixMapHandle     src,
   long             *size );
Parameters
seqID

Contains the unique sequence identifier that was returned by the CompressSequenceBegin function.
src

A handle to the source PixMap structure. The compressor uses only the image's size and pixel depth to determine the maximum size of the compressed image.
size

A pointer to a field to receive the maximum size, in bytes, of the compressed image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is similar to GetMaxCompressionSize, but operates on a compression sequence instead of requiring the application to pass individual parameters about the source image.
Special Considerations

Before calling GetCSequenceMaxCompressionSize you must have already started a compression sequence with CompressSequenceBegin
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetCSequenceMaxCompressionSize (
   ImageSequence    seqID,
   PixMapHandle     src,
   long             *size ){};


/*SpriteWorldIdle

Allows a sprite world to update its invalid areas.

OSErr SpriteWorldIdle (
   SpriteWorld    theSpriteWorld,
   long           flagsIn,
   long           *flagsOut );
Parameters
theSpriteWorld

The sprite world for this operation.
flagsIn

Contains flags (see below) describing actions that may take place during the idle. For the default behavior, set this parameter to 0. See these constants: 
kOnlyDrawToSpriteWorld
flagsOut

On return, a pointer to flags (see below) describing actions that took place during the idle period. This parameter is optional; if you do not need the information, set it to NIL. See these constants: 
kSpriteWorldDidDraw
kSpriteWorldNeedsToDraw
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This is the only sprite function that causes drawing to occur; you should call it as often as is necessary. Typically, you would make changes in perspective for a number of sprites and then call SpriteWorldIdle to redraw the changed sprites.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SpriteWorldIdle (
   SpriteWorld    theSpriteWorld,
   long           flagsIn,
   long           *flagsOut ){};


/*GraphicsImportGetAsPicture

Creates a QuickDraw picture handle to an imported image.

ComponentResult GraphicsImportGetAsPicture (
   GraphicsImportComponent    ci,
   PicHandle                  *picture );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
picture

Points to a handle to a Picture structure that is to receive the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates a new QuickDraw picture handle containing the image currently in use by the graphics import component. If possible, the image will remain in the compressed format. For example, if the image is from a JFIF file, the picture will contain compressed JPEG data. It is the responsibility of the caller to dispose of the picture handle.
Special Considerations

Graphics import components can save data in several formats, including QuickDraw pictures and QuickTime Image files. This capability is only needed by applications that perform file format translation. Applications that only wish to draw the image can use GraphicsImportDraw.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportGetAsPicture (
   GraphicsImportComponent    ci,
   PicHandle                  *picture ){};

/*MediaSetPublicInfo

Undocumented

ComponentResult MediaSetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            dataSize );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
infoSelector

Undocumented
infoDataPtr

Undocumented
dataSize

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            dataSize ){};


/*MediaGetPublicInfo

Undocumented

ComponentResult MediaGetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            *ioDataSize );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
infoSelector

Undocumented
infoDataPtr

Undocumented
ioDataSize

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/

ComponentResult MediaGetPublicInfo (
   MediaHandler    mh,
   OSType          infoSelector,
   void            *infoDataPtr,
   Size            *ioDataSize ){};


/*TransformRgn

Applies a specified matrix to a region.

OSErr TransformRgn (
   MatrixRecordPtr    matrix,
   RgnHandle          rgn );
Parameters
matrix

Points to the matrix for this operation. The TransformRgn function currently supports only translation and scaling operations.
rgn

A handle to the MacRegion structure to be transformed. The function transforms each point in the region according to the specified matrix
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr TransformRgn (
   MatrixRecordPtr    matrix,
   RgnHandle          rgn ){};


/*GetMoviePict

Creates a QuickDraw picture from a specified movie at a specified time.

PicHandle GetMoviePict (
   Movie        theMovie,
   TimeValue    time );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The movie time from which the image is to be taken.
Return Value

A handle to a Picture structure. If the function could not create the picture, the returned handle is set to NIL.
Discussion

This function uses only those movie tracks that are currently enabled and would therefore be used in playback. Your application may call this function even if the movie is inactive.
Special Considerations

Your application must dispose of this picture handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetMoviePict (
   Movie        theMovie,
   TimeValue    time ){};


/*ConvertMovieToFile

Takes a specified movie (or a single track within that movie) and converts it into a specified file and type, supporting a Save As dialog box.

OSErr ConvertMovieToFile (
   Movie                theMovie,
   Track                onlyTrack,
   FSSpec               outputFile,
   OSType               fileType,
   OSType               creator,
   ScriptCode           scriptTag,
   short                resID,
   long                 flags,
   ComponentInstance    userComp );
Parameters
theMovie

The source movie for this conversion operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
onlyTrack

The track within the source movie for this conversion operation. To specify all tracks, set the value of this parameter to 0.
outputFile

A pointer to the file specification for the destination file.
fileType

The data type of the destination file for the movie specified in the parameter theMovie.
creator

The creator value for the output file if it is a new one.
scriptTag

The script into which the movie should be converted if the output file is a new one. Use the Script Manager constant smSystemScript to use the system script; use the smCurrentScript constant to use the current script. See Inside Macintosh: Text for more information about scripts and script tags.
resID

A pointer to a field that is to receive the resource ID of the open movie. If you don't want to receive this information, set the resID parameter to NIL.
flags

Contains flags (see below) that control whether and how the Save As dialog box appears. See these constants: 
showUserSettingsDialog
movieToFileOnlyExport
movieFileSpecValid
userComp

If you want a particular movie export component to perform the conversion, you may pass the component or an instance of that component in this parameter. Otherwise, set it to 0 to allow the Movie Toolbox to use the appropriate component. If you pass in a component instance, it is used by ConvertMovieToFile. This allows you to communicate directly with the component before making this call to establish any conversion parameters. If you pass in a component ID, an instance is created and closed within this call.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Your application controls whether a Save As dialog box appears by setting the value of the flags parameter. The dialog box lets the user specify the file name and type. Supported types include standard QuickTime movies, flattened movies, single-fork flattened movies, and any format that is supported by a movie data export component. The following code snippets show how to call ConvertMovieToFile to provide a simple export capability and how to save a sound-only QuickTime movie as a WAV file.// Providing an export capability with ConvertMovieToFile
err =ConvertMovieToFile (theMovie,     / identifies movie /
                    NIL,                / all tracks /
                    NIL,                / no output file /
                    0,                  / no file type /
                    0,                  / no creator /
                    -1,                 / script /
                    NIL,                / no resource ID /
                    createMovieFileDeleteCurFile |
                        showUserSettingsDialog |
                        movieToFileOnlyExport,
                    0);                 / no specific component /
// Saving a sound-only QuickTime movie as a WAVE file
// See "Discovering QuickTime," page 257
void SndSnip_SaveSoundMovieAsWAVEFile (Movie theMovie)
{
    StandardFileReply   myReply;
    // have the user select the name and location of the new WAVE file
    StandardPutFile("\pSave sound movie file as:",
                                           "\pUntitled.wav", &myReply);
    if (!myReply.sfGood)
        return;
    // use the default progress procedure, if any
    SetMovieProgressProc(theMovie, (MovieProgressUPP)-1L, 0);
    // export the movie into a file
    ConvertMovieToFile( theMovie,               // the movie to convert
                        NIL,                   // all tracks in the movie
                        &myReply.sfFile,        // the output file
                        kQTFileTypeWave,        // the output file type
                        FOUR_CHAR_CODE('TVOD'), // the output file creator
                        smSystemScript,         // the script
                        NIL,                   // no resource ID
                                                //   to be returned
                        0L,                     // no flags
                        NIL);                  // no specific component
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr ConvertMovieToFile (
   Movie                theMovie,
   Track                onlyTrack,
   FSSpec               *outputFile,
   OSType               fileType,
   OSType               creator,
   ScriptCode           scriptTag,
   short                *resID,
   long                 flags,
   ComponentInstance    userComp ){};

/*DrawTrimmedPictureFile

Draws an image that is stored as a picture file into the current graphics port and trims that image to fit a specified region.

OSErr DrawTrimmedPictureFile (
   short                       srcRefnum,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc );
Parameters
srcRefnum

A file reference number for the source PICT file.
frame

A pointer to the rectangle into which the decompressed image is to be loaded.
trimMask

A handle to a clipping region in the destination coordinate system. The decompressor applies this mask to the destination image and ignores any image data that fall outside the specified region. Set this parameter to NIL if you do not want to clip the source image. In this case, this function acts like DrawPictureFile.
doDither

Indicates whether to dither the image. Use this parameter if you want the image to be dithered when it is displayed on a lower-resolution screen (see below). See these constants: 
defaultDither
forceDither
suppressDither
progressProc

A pointer to an ICMProgressProc callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress function, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to save part of a picture, since the image data that is not within the trim region is ignored and is not included in the destination picture file. All the remaining objects in the resulting object are clipped.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DrawTrimmedPictureFile (
   short                       srcRefnum,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc ){};


/*DrawTrimmedPicture

Draws an image that is stored as a picture into the current graphics port and trims that image to fit a specified region.

OSErr DrawTrimmedPicture (
   PicHandle                   srcPicture,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc );
Parameters
srcPicture

A handle to the source image, stored as a picture.
frame

A pointer to the rectangle into which the decompressed image is to be loaded.
trimMask

A handle to a clipping region in the destination coordinate system. The decompressor applies this mask to the destination image and ignores any image data that fall outside the specified region. Set this parameter to NIL if you do not want to clip the source image.
doDither

Indicates whether to dither the image. Use this parameter if you want the image to be dithered when it is displayed on a lower-resolution screen (see below). See these constants: 
defaultDither
forceDither
suppressDither
progressProc

A pointer to an ICMProgressProc callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress function, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function works with compressed image data; the source data stays compressed. The function trims the image to fit the specified clipping region. Note that if you just use a clip while making a picture, the data (though not visible) is still stored in the picture.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr DrawTrimmedPicture (
   PicHandle                   srcPicture,
   const Rect                  *frame,
   RgnHandle                   trimMask,
   short                       doDither,
   ICMProgressProcRecordPtr    progressProc ){};


/*GetPictureFileHeader

Extracts the picture frame and file header from a specified picture file.

OSErr GetPictureFileHeader (
   short             refNum,
   Rect              *frame,
   OpenCPicParams    *header );
Parameters
refNum

A file reference number for the source PICT file.
frame

A pointer to a rectangle that is to receive the picture frame rectangle of the picture file. This function places the picFrame rectangle from the picture structure into the rectangle referred to by the frame parameter. If you are not interested in this information, pass NIL in this parameter.
header

A pointer to an OpenCPicParams structure. The GetPictureFileHeader function places the header from the specified picture file into this structure. If you are not interested in this information, pass NIL in this parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your program can use the information returned in the header parameter to determine how to draw an image without having to read the picture file.
Special Considerations

Note that this function always returns a version 2 header. If the source file is a version 1 PICT file, the GetPictureFileHeader function converts the header into version 2 format before returning it to your application. See Inside Macintosh: Imaging With QuickDraw for more information about picture headers.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr GetPictureFileHeader (
   short             refNum,
   Rect              *frame,
   OpenCPicParams    *header ){};



/*SCGetCompressionExtended

Undocumented

ComponentResult SCGetCompressionExtended (
   ComponentInstance    ci,
   SCParams             *params,
   Point                where,
   SCModalFilterUPP     filterProc,
   SCModalHookUPP       hookProc,
   long                 refcon,
   StringPtr            customName );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
params

A pointer to an SCParams structure.
where

Undocumented
filterProc

A Universal Procedure Pointer that accesses a SCModalFilterProc callback.
hookProc

A Universal Procedure Pointer that accesses a SCModalHookProc callback.
refcon

A reference constant to be passed to your callbacks. Use this parameter to point to a data structure containing any information your callbacks need.
customName

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult SCGetCompressionExtended (
   ComponentInstance    ci,
   SCParams             *params,
   Point                where,
   SCModalFilterUPP     filterProc,
   SCModalHookUPP       hookProc,
   long                 refcon,
   StringPtr            customName ){};


/*NewQTVRMouseOverHotSpotUPP

Allocates a Universal Procedure Pointer for the QTVRMouseOverHotSpotProc callback.

QTVRMouseOverHotSpotUPP NewQTVRMouseOverHotSpotUPP (
   QTVRMouseOverHotSpotProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTVRMouseOverHotSpotProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

QTVRMouseOverHotSpotUPP NewQTVRMouseOverHotSpotUPP (
   QTVRMouseOverHotSpotProcPtr    userRoutine ){};

/*QTVRSetMouseOverHotSpotProc

Installs or removes a mouse over hot spot procedure.

OSErr QTVRSetMouseOverHotSpotProc (
   QTVRInstance               qtvr,
   QTVRMouseOverHotSpotUPP    mouseOverHotSpotProc,
   SInt32                     refCon,
   UInt32                     flags );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
mouseOverHotSpotProc

A Universal Procedure Pointer for a QTVRMouseOverHotSpotProc callback. To remove a previously installed QTVRMouseOverHotSpotUPP callback, set mouseOverHotSpotProc to NIL.
refCon

A reference constant. This value is passed to the specified mouse over hot spot callback. Use this parameter to point to a data structure containing any information your callback needs.
flags

Unused. Set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function installs the routine specified by the mouseOverHotSpotProc parameter as a mouse over hot spot procedure for the QuickTime VR movie specified by the qtvr parameter. Subsequent user actions (such as moving the cursor over an enabled hot spot in that movie) cause the callback routine to be executed. The reference constant specified by the refCon parameter is passed unchanged to your callback routine.
Special Considerations

Your mouse over hot spot procedure is called only for enabled hot spots.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRSetMouseOverHotSpotProc (
   QTVRInstance               qtvr,
   QTVRMouseOverHotSpotUPP    mouseOverHotSpotProc,
   SInt32                     refCon,
   UInt32                     flags ){};


/*QTVRGetHotSpotType

Obtains the type of a QuickTime VR hot spot.

OSErr QTVRGetHotSpotType (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   OSType          *hotSpotType );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
hotSpotID

A hot spot ID.
hotSpotType

On entry, a pointer to a long integer. On return, that long integer contains the type of the hot spot specified by the hot spot ID.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function gets the type of a hot spot whose ID you specify. In combination with the kQTVRGetHotSpotTypeSelector intercept selector (see QTVRInstallInterceptProc), this allows an application to change a hot spot's type dynamically. For example, an application can take an existing movie and cause VR to display the cursors for a type of hotspot different from the one the movie was originally authored with. In combination with intercepting kQTVRTriggerHotSpotSelector, this would allow an Internet plugin to override undefined or link hotspots in movies to make them appear and act as though they are URL links instead. If kQTVRTriggerHotSpotSelector is not intercepted, VR will attempt to act on the hotspot in the normal way; by storing both link and URL data in a file, the exact behavior can be determined at runtime by an application to allow linking to either another node locally or a remote URL link, depending on system configuration or other arbitrary considerations.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/

OSErr QTVRGetHotSpotType (
   QTVRInstance    qtvr,
   UInt32          hotSpotID,
   OSType          *hotSpotType ){};


/*QTVRReplaceCursor

Replaces any of the standard QuickTime VR cursors with your own custom cursor.

OSErr QTVRReplaceCursor (
   QTVRInstance        qtvr,
   QTVRCursorRecord    *cursRecord );
Parameters
qtvr

An instance of a QuickTime VR movie. You can get this value by calling QTVRGetQTVRInstance.
cursRecord

A pointer to a QTVRCursorRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function replaces one or more of the standard QuickTime VR cursors associated with the instance specified by the qtvr parameter with the cursors specified in the cursor record pointed to by the cursRecord parameter. If the type field of the specified cursor record is kQTVRUseDefaultCursor, the default cursor for the given resource ID is reloaded; in this case, the handle field of that record should be set to NIL.
Special Considerations

This function replaces the standard cursors only for the specified QuickTime VR movie instance. To replace the standard cursors for all QuickTime VR movie instances you create, you need to call this function for each such instance.
Version Notes

Introduced in QuickTime 3 or earlier. Note that QuickTime VR 2.1 makes a copy of the cursor handle specified in the cursor record. The application is responsible for disposing of its own cursor handle.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeVR.h*/
OSErr QTVRReplaceCursor (
   QTVRInstance        qtvr,
   QTVRCursorRecord    *cursRecord ){};


/*VDGetBlackLevelValue

Returns the current black level value.

VideoDigitizerError VDGetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
blackLevel

A pointer to an integer field that is to receive the current black level value. Black level values range from 0 to 65,535, where 0 represents the maximum black value and 65,535 represents the minimum black value.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
VideoDigitizerError VDGetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel ){};

/*VDSetBlackLevelValue

Sets the current black level value.

VideoDigitizerError VDSetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel );
Parameters
ci

The video digitizer component for the request. Applications obtain this reference from OpenComponent or OpenDefaultComponent.
blackLevel

A pointer to an integer that contains the new black level value. Black level values range from 0 to 65,535, where 0 represents the maximum black value and 65,535 represents the minimum black value. The digitizer component returns the new value, so that the application can avoid using unsupported values in future requests.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

VideoDigitizerError VDSetBlackLevelValue (
   VideoDigitizerComponent    ci,
   unsigned short             *blackLevel ){};



/*NewUserData

Creates a new user data structure.

OSErr NewUserData (
   UserData    *theUserData );
Parameters
theUserData

A pointer to a pointer to a new UserDataRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error. If the function fails, theUserData is set to NIL.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr NewUserData (
   UserData    *theUserData ){};


/*BeginFullScreen

Begins full-screen mode for a specified graphics device.

OSErr BeginFullScreen (
   Ptr          *restoreState,
   GDHandle     whichGD,
   short        *desiredWidth,
   short        *desiredHeight,
   WindowRef    *newWindow,
   RGBColor     *eraseColor,
   long         flags );
Parameters
restoreState

On exit, a pointer to a block of private state data that contains information on how to return from full-screen mode. This value is passed to EndFullScreen to enable it to return the monitor to its previous state.
whichGD

A handle to the graphics device to put into full-screen mode. Set this parameter to NIL to select the main screen.
desiredWidth

On entry, a pointer to a short integer that contains the desired width, in pixels, of the images to be displayed. On exit, that short integer is set to the actual number of pixels that can be displayed horizontally. Set this parameter to 0 to leave the width of the display unchanged.
desiredHeight

On entry, a pointer to a short integer that contains the desired height, in pixels, of the images to be displayed. On exit, that short integer is set to the actual number of pixels that can be displayed vertically. Set this parameter to 0 to leave the height of the display unchanged.
newWindow

On entry, a window-creation value. If this parameter is NIL, no window is created for you. If this parameter has any other value, BeginFullScreen creates a new window that is large enough to fill the entire screen and returns a pointer to that window in this parameter. You should not dispose of that window yourself; instead, EndFullScreen will do so.
eraseColor

The color to use when erasing the full-screen window created by BeginFullScreen if newWindow is not NIL on entry. If this parameter is NIL, BeginFullScreen uses black when initially erasing the window's content area.
flags

A set of bit flags (see below) that control certain aspects of the full-screen mode. See these constants: 
fullScreenHideCursor
fullScreenAllowEvents
fullScreenDontChangeMenuBar
fullScreenPreflightSize
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function returns, in the restoreState parameter, a pointer to a block of private state information that indicates how to return from full-screen mode. You pass that pointer as a parameter to the EndFullScreen function. The following sample code contains functions that illustrate how to play a QuickTime movie full screen. It prompts the user for a movie, opens that movie, configures it to play full screen, associates a movie controller, and lets the controller handle events. Your application would call QTFullScreen_EventLoopAction in its event loop (on the Mac OS) or when it gets idle events (on Windows).enum {
    fullScreenHideCursor            =1L << 0,
    fullScreenAllowEvents           =1L << 1,
    fullScreenDontChangeMenuBar     =1L << 2,
    fullScreenPreflightSize         =1L << 3
};
// QTFullScreen_PlayOnFullScreen
// Prompt the user for a movie and play it full screen.
OSErr QTFullScreen_PlayOnFullScreen (void)
{
    FSSpec              myFSSpec;
    Movie               myMovie =NIL;
    short               myRefNum =0;
    SFTypeList          myTypeList ={MovieFileType, 0, 0, 0};
    StandardFileReply   myReply;
    long                myFlags =fullScreenDontChangeMenuBar
                                                 | fullScreenAllowEvents;
    OSErr               myErr =noErr;
 
    StandardGetFilePreview(NIL, 1, myTypeList, &myReply);
    if (!myReply.sfGood)
        goto bail;
 
    // make an FSSpec record
    FSMakeFSSpec(myReply.sfFile.vRefNum, myReply.sfFile.parID,
                                          myReply.sfFile.name, &myFSSpec);
    myErr =OpenMovieFile(&myFSSpec, &myRefNum, fsRdPerm);
    if (myErr !=noErr)
        goto bail;
    // now fetch the first movie from the file
    myErr =NewMovieFromFile(&myMovie, myRefNum, NIL, NIL,
                                                    newMovieActive, NIL);
    if (myErr !=noErr)
        goto bail;
 
    CloseMovieFile(myRefNum);
    // set up for full-screen display
    myErr =BeginFullScreen(&gRestoreState, NIL, 0, 0,
                                       &gFullScreenWindow, NIL, myFlags);
#if TARGET_OS_WIN32
    // on Windows, set a window procedure for the new window
    // and associate a port with that window
    QTMLSetWindowWndProc(gFullScreenWindow, QTFullScreen_HandleMessages);
    CreatePortAssociation(GetPortNativeWindow(gFullScreenWindow), NIL, 0L);
#endif
    SetMovieGWorld(myMovie, (CGrafPtr)gFullScreenWindow,
                            GetGWorldDevice((CGrafPtr)gFullScreenWindow));
    SetMovieBox(myMovie, &gFullScreenWindow->
portRect);
    // create the movie controller
    gMC =NewMovieController(myMovie, &gFullScreenWindow->
portRect, 0);

Version Notes

The Macintosh human interface guidelines suggest that the menu bar must always be present, and that information must always appear in windows. However, many multimedia applications have chosen to change the look and feel of the interface based on their needs. The number of details to keep track of when doing this continues to increase. To help solve this problem, QuickTime 2.1 added functions to put a graphics device into full screen mode. The key elements to displaying full screen movies are the calls BeginFullScreen and EndFullScreen, introduced in QuickTime 2.5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/


OSErr BeginFullScreen (
   Ptr          *restoreState,
   GDHandle     whichGD,
   short        *desiredWidth,
   short        *desiredHeight,
   WindowRef    *newWindow,
   RGBColor     *eraseColor,
   long         flags ){};

/*EndFullScreen

Ends full-screen mode for a graphics device.

OSErr EndFullScreen (
   Ptr     fullState,
   long    flags );
Parameters
fullState

The pointer to private state information returned by a previous call to BeginFullScreen.
flags

Reserved. Set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function restores the graphics device and other settings to the state specified by the private state information pointed to by the fullState parameter. The resulting state is that that was in effect prior to the immediately previous call to BeginFullScreen. The following code illustrates its use:OSErr QTFullScreen_RestoreScreen (void)
{
    OSErr       myErr =noErr;
 
#if TARGET_OS_WIN32
    DestroyPortAssociation((CGrafPtr)gFullScreenWindow);
#endif
    DisposeMovieController(gMC);
    myErr =EndFullScreen(gRestoreState, 0L);
 
    return(myErr);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr EndFullScreen (
   Ptr     fullState,
   long    flags ){};


/*GraphicsImportSetGraphicsMode

Sets the graphics transfer mode for an imported image.

ComponentResult GraphicsImportSetGraphicsMode (
   GraphicsImportComponent    ci,
   long                       graphicsMode,
   const RGBColor             *opColor );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
graphicsMode

The graphics transfer mode to use for drawing the image; see Graphics Transfer Modes.
opColor

A pointer to an RGBColor structure that describes the color to use for blending and transparent operations.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to specify the graphics transfer mode and color to use for blending and transparent operations.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

ComponentResult GraphicsImportSetGraphicsMode (
   GraphicsImportComponent    ci,
   long                       graphicsMode,
   const RGBColor             *opColor ){};


/*GraphicsImportGetMatrix

Returns the transformation matrix to be used for drawing an imported image.

ComponentResult GraphicsImportGetMatrix (
   GraphicsImportComponent    ci,
   MatrixRecord               *matrix );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
matrix

A pointer to a MatrixRecord structure that defines the transformation matrix that applies to the image.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The transformation matrix is initialized to the identity matrix when the graphics import component is instantiated.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetMatrix (
   GraphicsImportComponent    ci,
   MatrixRecord               *matrix ){};



/*GraphicsExportRequestSettings

Displays a dialog for the user to configure graphics exporter settings, if applicable.

ComponentResult GraphicsExportRequestSettings (
   GraphicsExportComponent    ci,
   ModalFilterYDUPP           filterProc,
   void                       *yourDataProc );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
filterProc

A ModalFilterYDProc callback. If you don't need one, pass NIL.
yourDataProc

An extra parameter that will be passed to the ModalFilterProc callback when it is called. If you don't need one, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Some graphics exporters don't support settings dialogs, and so don't implement this call. To find out whether a graphics exporter implements this call, you can use this code:CallComponentCanDo( myGraphicsExporter,
                    kGraphicsExportRequestSettingsSelect);

Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportRequestSettings (
   GraphicsExportComponent    ci,
   ModalFilterYDUPP           filterProc,
   void                       *yourDataProc ){};

/*GraphicsExportSetDepth

Defines the depth to use in a graphics export operation.

ComponentResult GraphicsExportSetDepth (
   GraphicsExportComponent    ci,
   long                       depth );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
depth

A value describing the depth of the image data. Some image file formats support more than one pixel depth.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The BMP, JPEG, Photoshop, PNG, PICT, QuickTime Image, TGA and TIFF graphics exporters support the depth setting. Some image file formats support more than one pixel depth.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetDepth (
   GraphicsExportComponent    ci,
   long                       depth ){};


/*MakeImageDescriptionForEffect

Returns an ImageDescription structure you can use to help create a sample description for an effect.

OSErr MakeImageDescriptionForEffect (
   OSType                    effectType,
   ImageDescriptionHandle    *idh );
Parameters
effectType

The four-character code identifying the type of effect to make an image description for. See Effects Codes.
idh

The handle of an ImageDescription structure. On entry, this parameter normally points to an ImageDescription structure whose contents are NIL. On return, the structure is correctly filled out for the selected effect type.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

To create a sample description, you create and fill out a data structure of type ImageDescription. This function simplifies this process. Only sample descriptions made with this function can be used in stacked effects, where one effect track acts as a source for another.

The following sample code creates a sample description:.// MakeImageDescriptionForEffect coding example
// Return a new image description with default and specified values.
ImageDescriptionHandle QTEffSeg_MakeSampleDescription (
                   OSType theEffectType, short theWidth, short theHeight)
{
    ImageDescriptionHandle      mySampleDesc =NIL;
#if USES_MAKE_IMAGE_DESC_FOR_EFFECT
    OSErr  myErr =noErr;
    // create a new sample description
    myErr =MakeImageDescriptionForEffect(theEffectType, &mySampleDesc);
    if (myErr !=noErr)
        return(NIL);
#else
    // create a new sample description
    mySampleDesc =(ImageDescriptionHandle)
                                 NewHandleClear(sizeof(ImageDescription));
    if (mySampleDesc ==NIL)
        return(NIL);
 
    // fill in the fields of the sample description
    (**mySampleDesc).cType =theEffectType;
    (**mySampleDesc).idSize =sizeof(ImageDescription);
    (**mySampleDesc).hRes =72L << 16;
    (**mySampleDesc).vRes =72L << 16;
    (**mySampleDesc).frameCount =1;
    (**mySampleDesc).depth =0;
    (**mySampleDesc).clutID =-1;
#endif
 
    (**mySampleDesc).vendor =kAppleManufacturer;
    (**mySampleDesc).temporalQuality =codecNormalQuality;
    (**mySampleDesc).spatialQuality =codecNormalQuality;
    (**mySampleDesc).width =theWidth;
    (**mySampleDesc).height =theHeight;
 
    return(mySampleDesc);
}

Version Notes

Introduced in QuickTime 4. Image descriptions built using sample code from earlier versions of QuickTime cannot be used when stacking effects.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/

OSErr MakeImageDescriptionForEffect (
   OSType                    effectType,
   ImageDescriptionHandle    *idh ){};



/*QTDismissStandardParameterDialog

Closes a standard parameter dialog box that was created using QTCreateStandardParameterDialog.

OSErr QTDismissStandardParameterDialog (
   QTParameterDialog    createdDialog );
Parameters
createdDialog

The reference to the standard parameters dialog box that is returned by QTCreateStandardParameterDialog.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function disposes of all memory associated with the dialog box.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTDismissStandardParameterDialog (
   QTParameterDialog    createdDialog ){};


/*QTIsStandardParameterDialogEvent

Determines if a Macintosh event is processed by a standard parameter dialog box created by QTCreateStandardParameterDialog.

OSErr QTIsStandardParameterDialogEvent (
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog );
Parameters
pEvent

The Macintosh event.
createdDialog

The reference to the standard parameters dialog box that is returned by QTCreateStandardParameterDialog.
Return Value

See below.
Discussion

After you create a standard parameter dialog box, pass every Macintosh event through this function to determine if your application should handle the event. Once the dialog box has been confirmed or cancelled by the user, you should no longer call this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTIsStandardParameterDialogEvent (
   EventRecord          *pEvent,
   QTParameterDialog    createdDialog ){};

/*QTStandardParameterDialogDoAction

Lets you change some of the default behaviors of the standard parameter dialog box.

OSErr QTStandardParameterDialogDoAction (
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params );
Parameters
createdDialog

The reference to the dialog box created by calling QTCreateStandardParameterDialog.
action

Determines which of the actions (see below) supported by this function will be performed. See these constants: 
pdActionSetAppleMenu
pdActionSetEditMenu
pdActionSetPreviewPicture
pdActionSetDialogTitle
pdActionGetSubPanelMenu
pdActionActivateSubPanel
pdActionConductStopAlert
params

Optional parameters to the action. The type passed in this parameter depends on the value of the action parameter.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function allows you to change some of the default behaviors of a standard parameter dialog box you create using the QTCreateStandardParameterDialog function. To choose which of the available customizations to perform, pass an action selector value in the action parameter and, optionally, a single parameter in params.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTStandardParameterDialogDoAction (
   QTParameterDialog    createdDialog,
   long                 action,
   void                 *params ){};

/*QTCreateStandardParameterDialog

Creates a dialog box that allows the user to choose an effect from the list of effects passed to the function.

OSErr QTCreateStandardParameterDialog (
   QTAtomContainer             effectList,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   QTParameterDialog           *createdDialog );
Parameters
effectList

A list of the effects that the user can choose from. In most cases you should call QTGetEffectsList to generate this list. If you pass NIL in this parameter, the function calls QTGetEffectsList to retrieve the list of all currently installed effects; this list is then presented to the user.
parameters

An effect description containing the default parameter values for the effect. If the effect named in the parameter description is in effectlist, that effect is displayed when the dialog is first shown and its parameter values are set from the parameter description. Pass in an empty atom container to have the dialog box display the first effect in the list, set to its default parameters. On return, this atom container holds an effect description for the effect selected by the user, including the parameter settings. This effect description can then be added to the media of an effect track. You will need to add source atoms to this container for effects that require sources.
dialogOptions

Options (see below) that control the behavior of the dialog. See these constants: 
pdOptionsCollectOneValue
pdOptionsAllowOptionalInterpolations
createdDialog

Returns a reference to the dialog box that is created by this function. You should pass this value only to QTIsStandardParameterDialogEvent and QTDismissStandardParameterDialog. 
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function creates and displays a standard parameter dialog box that allows the user to choose an effect from the list in the effectList parameter. The dialog box also allows the user to choose values for the parameters of the effect, to preview the effects as they choose and customize them, and to get more information about each effect. Your application must call the Mac OS function WaitNextEvent and QTIsStandardParameterDialogEvent to allow the user to interact with the dialog box that is shown. Note that the dialog box will remain hidden until the first event is processed by QTIsStandardParameterDialogEvent. At this point, the dialog box will be displayed. You can modify the default behavior of the dialog box that is created by calling QTStandardParameterDialogDoAction.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCreateStandardParameterDialog (
   QTAtomContainer             effectList,
   QTAtomContainer             parameters,
   QTParameterDialogOptions    dialogOptions,
   QTParameterDialog           *createdDialog ){};

/*QTGetEffectsList

Returns a QT atom container holding a list of the currently installed effects components.

OSErr QTGetEffectsList (
   QTAtomContainer        *returnedList,
   long                   minSources,
   long                   maxSources,
   QTEffectListOptions    getOptions );
Parameters
returnedList

If the function returns noErr, this parameter contains a newly created QT atom container holding a list of their currently installed effects. Any data stored in the parameter on entry is overwritten by the list of effects. It is the responsibility of the calling application to dispose of the storage by calling QTDisposeAtomContainer once the list is no longer required.
minSources

The minimum number of sources that an effect must have to be added to the list. Pass -1 as this parameter to specify no minimum.
maxSources

The maximum number of sources that an effect can have to be added to the list. Pass -1 as this parameter to specify no maximum. The minSources and maxSources parameters allow you to restrict which effects are returned in the list, by specifying the minimum and maximum number of sources that qualifying effects can have.
getOptions

Options (see below) that control which effects are added to the list. If you pass 0, the function includes every effect, except the "none" effect and any prohibited by the values of minSources and maxSources. See these constants: 
elOptionsIncludeNoneInList
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The returned list contains two atoms for each effect component. The first atom, of type kEffectNameAtom, contains the name of the effect. The second atom, of type kEffectTypeAtom, contains the type of the effect, which is the sub-type of the effect component. This list is sorted alphabetically on the names of the effects. You can constrain the list to certain types of effects, such as those that take two sources. Use this function to obtain a list of effects that you can pass to QTCreateStandardParameterDialog.
Special Considerations

This function can take a fairly long time to execute, as it searches the system for installed effects components. You will normally want to call this function once when your application starts, or after a pair of suspend and resume events.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTGetEffectsList (
   QTAtomContainer        *returnedList,
   long                   minSources,
   long                   maxSources,
   QTEffectListOptions    getOptions ){};


/*PrePrerollMovie

Sets up any necessary network connections to receive streaming content.

OSErr PrePrerollMovie (
   Movie                         m,
   TimeValue                     time,
   Fixed                         rate,
   MoviePrePrerollCompleteUPP    proc,
   void                          *refcon );
Parameters
m

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
time

The starting time of the movie segment to play.
rate

The rate at which you anticipate playing the movie. You specify the movie rate as a 32-bit, fixed-point number. Positive integers indicate forward rates and negative integers indicate reverse rates.
proc

The MoviePrePrerollCompleteProc callback you want called when pre-prerolling is complete. If a completion proc is specified, PrePrerollMovie operates asynchronously. You must call MoviesTask periodically during asynchronous operation. If no completion proc is specified, PrePrerollMovie operates synchronously.
refcon

A reference constant that is passed to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Before a movie is played, it is normally prerolled. During preroll, the Movie Toolbox tells the appropriate media handlers to load the movie data, allocate sound channels, start up image-decompression sequences, and so on. Before a movie that contains streaming content is prerolled, it must be pre-prerolled. This sets up any necessary network connections between the client and the server. If a movie contains streaming content (one or more 'strm' tracks), you must call this function before calling PrerollMovie. If the movie does not contain streaming content, calling this function has no effect. If your application calls PrerollMovie, it should always call this function first. If you play movies using a movie controller, you don't need to preroll or pre-preroll the movie explicitly; it is done for you automatically. If a completion proc is specified in the proc parameter, this function operates asynchronously; it returns almost immediately and calls the completion proc when pre-prerolling is complete.
Special Considerations

You must call MoviesTask periodically to grant time for pre-prerolling during asynchronous operation. If no completion proc is specified, this function operates synchronously; the function will not return until pre-prerolling is complete. This can take a long time, particularly if a dial-up network connection must be established.
Version Notes

Introduced in QuickTime 4. Beginning with QuickTime 4, your application should call this function any time it calls PrerollMovie.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr PrePrerollMovie (
   Movie                         m,
   TimeValue                     time,
   Fixed                         rate,
   MoviePrePrerollCompleteUPP    proc,
   void                          *refcon ){};


/*NewMoviePrePrerollCompleteUPP

Allocates a Universal Procedure Pointer for the MoviePrePrerollCompleteProc callback.

MoviePrePrerollCompleteUPP NewMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMoviePrePrerollCompleteProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MoviePrePrerollCompleteUPP NewMoviePrePrerollCompleteUPP (
   MoviePrePrerollCompleteProcPtr    userRoutine ){};


/*SetTrackVolume

Sets a track's current volume.

void SetTrackVolume (
   Track    theTrack,
   short    volume );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
volume

The current volume setting of the track represented as a 16-bit, fixed-point number. The high-order 8 bits contain the integer part of the value; the low-order 8 bits contain the fractional part. Volume values range from -1.0 to 1.0. Negative values play no sound but preserve the absolute value of the volume setting. You can use constants (see below) for full volume and no volume. See these constants: 
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackVolume (
   Track    theTrack,
   short    volume ){};




/*SGSetChannelOutput

Assigns an output to a channel.

ComponentResult SGSetChannelOutput (
   SeqGrabComponent    s,
   SGChannel           c,
   SGOutput            sgOut );
Parameters
s

The component instance that identifies your connection to the sequence grabber component. You obtain this value from OpenDefaultComponent or OpenComponent.
c

The connection identifier for the channel for this operation. You get this value from SGNewChannel or SGNewChannelFromComponent.
sgOut

Identifies the sequence grabber output for this operation. You obtain this identifier by calling SGNewOutput.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Use this function to assign an output to a channel. One output may be assigned to one or more channels. Note that when you call SGSetDataRef or SGSetDataOutput the sequence grabber component sets every channel to the specified file or container. If you want to use different outputs, you must use this function to assign the channels appropriately.
Version Notes

A sequence grabber output ties a sequence grabber channel to a specified data reference for the output of captured data. If you are capturing to a single movie file, you can continue to use SGSetDataOutput or SGSetDataRef to specify the sequence grabber's destination. However, if you want to capture movie data into several different files or data references, you must use sequence grabber outputs to do so. Even if you are using outputs, you must still use SGSetDataOutput or SGSetDataRef to identify where the sequence grabber should create the movie resource. You are responsible for creating outputs, assigning them to sequence grabber channels, and disposing of them when you are done.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SGSetChannelOutput (
   SeqGrabComponent    s,
   SGChannel           c,
   SGOutput            sgOut ){};




/*GetMovieDisplayBoundsRgn

Determines a movie's display boundary region.

RgnHandle GetMovieDisplayBoundsRgn (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A handle to a MacRegion structure that the function allocates. If the movie does not have a spatial representation at the current time, the function returns an empty region. If the function could not satisfy the request, it sets the returned handle to NIL.
Discussion

The display boundary region encloses all of a movie's enabled tracks after the track matrix, track clip, movie matrix, and movie clip have been applied to them. This region is in the display coordinate system of the movie's graphics world. The Movie Toolbox derives the display boundary region only from enabled tracks, and only from those tracks that are used in the current display mode (that is, movie, poster, or preview). The display boundary region is valid for the current movie time.
Special Considerations

Your application must dispose of the returned handle when it is done with it.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

RgnHandle GetMovieDisplayBoundsRgn (
   Movie    theMovie ){};






/*FDecompressImage

Decompresses a single-frame image into a pixel map structure, with added control over the decompression process.

OSErr FDecompressImage (
   Ptr                         data,
   ImageDescriptionHandle      desc,
   PixMapHandle                dst,
   const Rect                  *srcRect,
   MatrixRecordPtr             matrix,
   short                       mode,
   RgnHandle                   mask,
   PixMapHandle                matte,
   const Rect                  *matteRect,
   CodecQ                      accuracy,
   DecompressorComponent       codec,
   long                        bufferSize,
   ICMDataProcRecordPtr        dataProc,
   ICMProgressProcRecordPtr    progressProc );
Parameters
data

Points to the compressed image data. If the entire compressed image cannot be stored at this location, your application may provide a data-loading function (see the discussion of the dataProc parameter to this function). This pointer must contain a 32-bit clean address. 
desc

A handle to the ImageDescription structure that describes the compressed image.
dst

A handle to the pixel map where the decompressed image is to be displayed. Set the current graphics port to the port that contains this pixel map.
srcRect

A pointer to a rectangle defining the portion of the image to decompress. This rectangle must lie within the boundary rectangle of the compressed image, which is defined by (0,0) and ((**desc).width,(**desc).height). If you want to decompress the entire source image, set this parameter to NIL. If the parameter is NIL, the rectangle is set to the rectangle structure of the ImageDescription structure.
matrix

Points to a matrix structure that specifies how to transform the image during decompression. You can use the matrix structure to translate or scale the image during decompression. If you do not want to apply such effects, set the matrix parameter to NIL.
mode

The transfer mode for the operation; see Graphics Transfer Modes.
mask

A handle to a clipping region in the destination coordinate system. If specified, the decompressor applies this mask to the destination image. If you do not want to mask bits in the destination, set this parameter to NIL.
matte

A handle to a pixel map that contains a blend matte. You can use the blend matte to cause the decompressed image to be blended into the destination pixel map. The matte can be defined at any supported pixel depth; the matte depth need not correspond to the source or destination depths. However, the matte must be in the coordinate system of the source image. If you do not want to apply a blend matte, set this parameter to NIL.
matteRect

A pointer to a rectangle defining a portion of the blend matte to apply. If you do not want to use the entire matte referred to by the matte parameter, use this parameter to specify a rectangle within that matte. If specified, this rectangle must be the same size as the rectangle specified by the srcRect parameter. If you want to use the entire matte, or if you are not providing a blend matte, set this parameter to NIL.
accuracy

A constant (see below) that defines the desired compression accuracy. For a good display of still images, you should specify at least codecHighQuality. See these constants: 
codecMinQuality
codecLowQuality
codecNormalQuality
codecHighQuality
codecMaxQuality
codecLosslessQuality
codec

A decompressor identifier. Specify a particular decompressor by setting this parameter to its identifier. Alternatively, you may use a special identifier (see below). Specifying a component instance may be useful if you have previously set some parameter on a specific instance of a codec field and want to make sure that the specified instance is used for that operation. See these constants: 
bufferSize

The size of the buffer to be used by the data-loading function specified by the dataProc parameter. If you have not specified a data-loading function, set this parameter to 0.
dataProc

Points to an ICMDataProc data-loading callback. If there is not enough memory to store the compressed image, the compressor calls a function you provide that loads more compressed data. If you have not provided a data-unloading callback, set this parameter to NIL. In this case, the compressor expects that the entire compressed image is in the memory location specified by the data parameter.
progressProc

Points to an ICMProgressProc progress callback. During the compression operation, the compressor may occasionally call a function you provide in order to report its progress. If you have not provided a progress callback, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function gives your application greater control over the parameters that guide the decompression operation. If you find that you do not need this level of control, use DecompressImage. Note that this function is invoked through the StdPix function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr FDecompressImage (
   Ptr                         data,
   ImageDescriptionHandle      desc,
   PixMapHandle                dst,
   const Rect                  *srcRect,
   MatrixRecordPtr             matrix,
   short                       mode,
   RgnHandle                   mask,
   PixMapHandle                matte,
   const Rect                  *matteRect,
   CodecQ                      accuracy,
   DecompressorComponent       codec,
   long                        bufferSize,
   ICMDataProcRecordPtr        dataProc,
   ICMProgressProcRecordPtr    progressProc ){};


/*DrawPictureFile

Draws an image from a specified picture file in the current graphics port.

OSErr DrawPictureFile (
   short                       refNum,
   const Rect                  *frame,
   ICMProgressProcRecordPtr    progressProc );
Parameters
refNum

A file reference number for the source PICT file.
frame

A pointer to the rectangle into which the image is to be loaded. The compressor scales the source image to fit into this destination rectangle.
progressProc

Points to an ICMProgressProc callback. During the operation, the draw function may occasionally call a function you provide in order to report its progress; see ICMProgressProcRecord. If you have not provided a progress function, set this parameter to NIL. If you pass a value of -1, QuickTime provides a standard progress function.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function draws the picture that it finds in the picture file specified by the refNum parameter within the rectangle specified by the frame parameter. The Image Compression Manager performs any spooling that may be necessary when reading the picture file. Specify a clipping region appropriate for your picture before drawing it. If the clipping region is very large (as it is when a graphics port is initialized) and you want to scale the picture, the clipping region can become invalid when DrawPictureFile scales the clipping region, in which case your picture will not be drawn. On the other hand, if the graphics port specifies a small clipping region, part of your drawing may be clipped when DrawPictureFile draws it. Setting a clipping region equal to the port rectangle of the current graphics port always sets a valid clipping region.
Special Considerations

When it scales fonts, DrawPictureFile changes the size of the font instead of scaling the bits. However, the widths used by bitmap fonts are not always linear. For example, the 12-point width isn't exactly 1/2 of the 24-point width. This can cause lines of text to become slightly longer or shorter as the picture is scaled. The easiest way to avoid such problems is to specify a destination rectangle that is the same size as the bounding rectangle for the picture.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr DrawPictureFile (
   short                       refNum,
   const Rect                  *frame,
   ICMProgressProcRecordPtr    progressProc ){};

/*RTPMPFlush

Renamed RTPMPReset.

ComponentResult RTPMPFlush (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags,
   SInt32                *outFlags );
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPMPFlush (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags,
   SInt32                *outFlags ){};



/*RTPPBBeginPacketGroup

Tells a packet builder to create a new packet group.

ComponentResult RTPPBBeginPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   UInt32               inTimeStamp,
   RTPPacketGroupRef    *outPacketGroup );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inTimeStamp

A unsigned 32-bit integer containing the time stamp for this packet group.
outPacketGroup

On return, contains a pointer to a reference to the packet group. Use this data reference when creating a new packet or inserting data into a packet that belongs to this group.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

A media packetizer creates a packet group using this function. The data reference returned by this function is then used to create a series of packets that belong to this group. The data reference is also required when inserting data into packets.
Special Considerations

When the packet group is complete, call RTPPBEndPacketGroup.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBBeginPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   UInt32               inTimeStamp,
   RTPPacketGroupRef    *outPacketGroup ){};


/*RTPMPInitialize

Initializes a media packetizer component.

ComponentResult RTPMPInitialize (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags );
Parameters
rtpm

The component instance of the media packetizer.
inFlags

A signed 32-bit integer containing the flags (see below) you wish to pass to the packetizer at start-up. See these constants: 
kRTPMPRealtimeModeFlag
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The calling component must call this function before sending any data to a media packetizer or making any RTPMPSet calls. The calling component then calls RTPMPSetSampleData and RTPMPIdle repeatedly. The calling component passes sample data (obtained, for example, from GetMediaSample), to the media packetizer by calling RTPMPSetSampleData. If RTPMPSetSampleData or RTPMPIdle return the flag kRTPMPStillProcessingData, then the calling component should call RTPMPIdle; if not, it is free to call RTPMPSetSampleData again.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPMPInitialize (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags ){};

/*RTPPBBeginPacket

Tells a packet builder to create a new packet.

ComponentResult RTPPBBeginPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   UInt32               inPacketMediaDataLength,
   RTPPacketRef         *outPacket );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the new packet. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacketMediaDataLength

An unsigned 32-bit integer specifying the maximum length of data that will be inserted into this packet. This includes the data for all subsequent RTPPBAddPacketLiteralData, RTPPBAddPacketSampleData, and RTPPBAddPacketRepeatedData calls until the packet is closed. The value of this parameter may be larger, but must not be smaller, than the amount of data inserted in the packet.
outPacket

On return, contains a pointer to the packet. Use this reference to insert data into the packet.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The media packetizer uses this function to create each new packet, before inserting any literal, repeated, or sample data. A call to RTPPBBeginPacketGroup must be made before creating the first packet in a group. Data can be inserted into the packet using RTPPBAddPacketLiteralData, RTPPBAddPacketRepeatedData, or RTPPBAddPacketSampleData. When the packet is complete, call RTPPBEndPacket.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBBeginPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   UInt32               inPacketMediaDataLength,
   RTPPacketRef         *outPacket ){};

/*RTPPBEndPacket

Tells a packet builder that a packet is complete.

ComponentResult RTPPBEndPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   RTPPacketRef         inPacket,
   UInt32               inTransmissionTimeOffset,
   UInt32               inDuration );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the new packet. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacket

The RTP packet containing the data. This is normally a reference returned by RTPPBBeginPacket.
inTransmissionTimeOffset

The time offset at which the media sample data contained in this packet begins, in milliseconds. This offset is added to the RTP transmission time to determine when to send the packet.
inDuration

The duration of this packet, specified in milliseconds.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Call this function once when each packet is complete.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPPBEndPacket (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup,
   RTPPacketRef         inPacket,
   UInt32               inTransmissionTimeOffset,
   UInt32               inDuration ){};

/*RTPPBEndPacketGroup

Tells a packet builder component that a packet group is complete.

ComponentResult RTPPBEndPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

A data reference to the packet group being ended. This is normally a data reference returned by RTPPBBeginPacketGroup.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function should be called when all the packets in a group are complete and the media packetizer is ready either to create a new packet group or to terminate the stream.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBEndPacketGroup (
   RTPPacketBuilder     rtpb,
   SInt32               inFlags,
   RTPPacketGroupRef    inPacketGroup ){};



/*RTPMPReset

Allows a media packetizer to stop packetizing its current input, set its state to idle, and flush its input buffer.

ComponentResult RTPMPReset (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags );
Parameters
rtpm

The component instance of the media packetizer.
inFlags

A signed 32-bit integer containing any flags you are passing to the media packetizer. There are currently no defined flags.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You can use this function to stop the media packetizer and flush its input buffer when you wish to stop transmitting immediately, when you are skipping forward or backward in the stream, or if the network data connection is interrupted.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPMPReset (
   RTPMediaPacketizer    rtpm,
   SInt32                inFlags ){};

/*RTPMPGetInfo

Obtains information of various types from a media packetizer.

ComponentResult RTPMPGetInfo (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   void                  *ioParams );
Parameters
rtpm

The component instance of the media packetizer you want information from.
inSelector

The selector for the type information you want (see below). See these constants: 
kRTPMPPayloadTypeInfo
kRTPMPRTPTimeScaleInfo
kRTPMPRequiredSampleDescriptionInfo
kRTPMPMinPayloadSize
kRTPMPMinPacketDuration
kRTPMPSuggestedRepeatPktCountInfo
ioParams

A pointer to a data structure of the appropriate type to hold the information you are requesting. You need to allocate and dispose of this data structure.
Return Value

See Error Codes. Returns qtsBadSelectorErr if inSelector requests a selector you do not support. Returns noErr if there is no error.
Discussion

This function can be called at any time.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPMPGetInfo (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   void                  *ioParams ){};


/*RTPMPHasCharacteristic

Determines whether a media packetizer has a particular characteristic, such as whether it supports a user settings dialog.

ComponentResult RTPMPHasCharacteristic (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   Boolean               *outHasIt );
Parameters
rtpm

The component instance of the media packetizer.
inSelector

A selector for the characteristic you want to know about. See these constants: 
kRTPMPNoSampleDataRequiredCharacteristic
kRTPMPHasUserSettingsDialogCharacteristic
kRTPMPPrefersReliableTransportCharacteristic
kRTPMPRequiresOutOfBandDimensionsCharacteristic
outHasIt

On return, contains a Boolean value that is TRUE if the media packetizer has this characteristic, FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPMPHasCharacteristic (
   RTPMediaPacketizer    rtpm,
   OSType                inSelector,
   Boolean               *outHasIt ){};

/*RTPRssmIncrChunkRefCount

Tells the base reassembler to keep a copy of the most recent chunk after it has been sent.

ComponentResult RTPRssmIncrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk );
Parameters
rtpr

The component instance of the base reassembler.
inChunk

A pointer to the chunk record you want to preserve.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is used to assist in loss recovery, for example. You must call RTPRssmDecrChunkRefCount to release the chunk when you no longer need it.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmIncrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk ){};



/*RTPRssmSetCapabilities

Sets the capabilities of a streaming packet reassembler.

ComponentResult RTPRssmSetCapabilities (
   RTPReassembler    rtpr,
   SInt32            inFlags,
   SInt32            inFlagsMask );
Parameters
rtpr

The component instance of the base reassembler.
inFlags

A signed 32-bit integer containing the logical OR of all the flags (see below) you are setting. See these constants: 
kRTPRssmEveryPacketAChunkFlag
kRTPRssmQueueAndUseMarkerBitFlag
kRTPRssmTrackLostPacketsFlag
kRTPRssmNoReorderingRequiredFlag
inFlagsMask

Use this field to preserve the state of any flags you do not wish to alter. If a flag (see below) is set in this field, and is not set in the inFlags field, it will not be changed from its current setting.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your packet reassembler can call this function at any time.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmSetCapabilities (
   RTPReassembler    rtpr,
   SInt32            inFlags,
   SInt32            inFlagsMask ){};

/*RTPRssmInitialize

Called when the base reassembler is ready to have your packet reassembler begin handling media packets.

ComponentResult RTPRssmInitialize (
   RTPReassembler       rtpr,
   RTPRssmInitParams    *inInitParams );
Parameters
rtpr

The component instance of your packet reassembler
inInitParams

A pointer to an RTPRssmInitParams structure. Use the information contained in this structure to initialize your component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is not called when the base reassembler opens your component for payload registration information.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPRssmInitialize (
   RTPReassembler       rtpr,
   RTPRssmInitParams    *inInitParams ){};


/*RTPRssmNewStreamHandler

Opens a new stream handler and closes any currently-open stream handler.

ComponentResult RTPRssmNewStreamHandler (
   RTPReassembler             rtpr,
   OSType                     inSHType,
   SampleDescriptionHandle    inSampleDescription,
   TimeScale                  inSHTimeScale,
   ComponentInstance          *outHandler );
Parameters
rtpr

The component instance of the base reassembler.
inSHType

The stream handler type.
inSampleDescription

A handle to a SampleDescription structure appropriate for this media type. Pass in NIL if you don't know the media type yet. This structure is passed by reference; the caller is responsible for maintaining it.
inSHTimeScale

The time scale for the stream handler to use. Pass in 0 if the time scale is not yet known.
outHandler

On return, contains a pointer to the component instance of the stream handler that has been opened.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

You must pass in a valid SampleDescription structure and time scale before the stream handler can process packets. If you do not pass them as part of this function, do so using RTPRssmSetTimeScale and RTPRssmSetSampleDescription.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmNewStreamHandler (
   RTPReassembler             rtpr,
   OSType                     inSHType,
   SampleDescriptionHandle    inSampleDescription,
   TimeScale                  inSHTimeScale,
   ComponentInstance          *outHandler ){};


/*RTPRssmSetSampleDescription

Changes the SampleDescription structure being used by the stream handler; all subsequent samples will be marked with this new structure.

ComponentResult RTPRssmSetSampleDescription (
   RTPReassembler             rtpr,
   SampleDescriptionHandle    inSampleDescription );
Parameters
rtpr

The component instance of the base reassembler.
inSampleDescription

The handle of a SampleDescription structure to use. You are responsible for keeping the handle and the data structure valid during subsequent operations.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The SampleDescription structure is not passed on a per-packet basis, but a per-sample basis, so the SampleDescription structure should not be changed until a complete sample (sometimes called a "frame" or "chunk") has been reassembled.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmSetSampleDescription (
   RTPReassembler             rtpr,
   SampleDescriptionHandle    inSampleDescription ){};



/*RTPRssmSendPacketList

Called when the base reassembler is ready to send a sample or chunk based on a list of packets.

ComponentResult RTPRssmSendPacketList (
   RTPReassembler       rtpr,
   RTPRssmPacket        *inPacketListHead,
   const TimeValue64    *inLastChunkPresentationTime,
   SInt32               inFlags );
Parameters
rtpr

The component instance of your packet reassembler.
inPacketListHead

A pointer to the packet list.
inLastChunkPresentationTime

A pointer to a time value which specifies when to present this chunk, in units of the stream's time scale.
inFlags

A signed 32-bit integer containing any flags being passed (see below). See these constants: 
kRTPRssmLostSomePackets
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Implement this call if your packet reassembler needs to modify the packet list, or if it overrides the default handling of packet loss. If you do not implement this call, the base reassembler will adjust the packet parameters on all packets in the list, compute the chunk size, and send the chunk. If packet loss has occurred, all the packets will be discarded and the stream handler will be informed that the chunk has been lost.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmSendPacketList (
   RTPReassembler       rtpr,
   RTPRssmPacket        *inPacketListHead,
   const TimeValue64    *inLastChunkPresentationTime,
   SInt32               inFlags ){};


/*RTPRssmDecrChunkRefCount

Tells the base reassembler to dispose of a chunk that it has created or preserved for you.

ComponentResult RTPRssmDecrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk );
Parameters
rtpr

The component instance of the base reassembler component.
inChunk

A pointer to the chunk record to dispose.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If you have overridden RTPRssmSendPacketList behavior, and are instructing the base reassembler to construct chunks manually, your packet assembler must explicitly dispose of the chunks by calling either this function or RTPRssmSendChunkAndDecrRefCount. This function is also used to release a chunk you have preserved using RTPRssmIncrChunkRefCount.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmDecrChunkRefCount (
   RTPReassembler    rtpr,
   SHChunkRecord     *inChunk ){};


/*RTPRssmHasCharacteristic

Determines what features your reassembler supports.

ComponentResult RTPRssmHasCharacteristic (
   RTPReassembler    rtpr,
   OSType            inCharacteristic,
   Boolean           *outHasIt );
Parameters
rtpr

The component instance of your packet reassembler.
inCharacteristic

A constant that defines the characteristic being tested.
outHasIt

A pointer to a Boolean value that is TRUE if your packet reassembler has the characteristic, FALSE otherwise.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmHasCharacteristic (
   RTPReassembler    rtpr,
   OSType            inCharacteristic,
   Boolean           *outHasIt ){};


/*RTPRssmReset

Called to reset all packet reassembler and base reassembler variables for a new run of data.

ComponentResult RTPRssmReset (
   RTPReassembler    rtpr,
   SInt32            inFlags );
Parameters
rtpr

The component instance of your reassembler.
inFlags

A signed 32-bit integer containing any flags being passed. No flags are currently defined.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function differs from RTPRssmClearCachedPackets, which disposes of the packets but still retains the last sequence number and related information; this function resets all variables as if the reassembler were just opened.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPRssmReset (
   RTPReassembler    rtpr,
   SInt32            inFlags ){};

/*RTPRssmGetInfo

Obtains information about your packet reassembler.

ComponentResult RTPRssmGetInfo (
   RTPReassembler    rtpr,
   OSType            inSelector,
   void              *ioParams );
Parameters
rtpr

The component instance of your packet reassembler.
inSelector

A selector (see below) for the information desired. See these constants: 
kQTSSourceTrackIDInfo
kQTSSourceLayerInfo
kQTSSourceLanguageInfo
kQTSSourceTrackFlagsInfo
kQTSSourceDimensionsInfo
kQTSSourceVolumesInfo
kQTSSourceMatrixInfo
kQTSSourceClipRectInfo
kQTSSourceGraphicsModeInfo
kQTSSourceScaleInfo
kQTSSourceBoundingRectInfo
kQTSSourceUserDataInfo
kQTSSourceInputMapInfo
ioParams

A pointer to a data structure appropriate for the type of data requested (see below) . If your component understands the selector, write the requested information into the data structure this parameter points to.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Implement this function only for the selectors you understand. Delegate this function to the base reassembler for any other selectors. The base reassembler will correctly return an error if it doesn't understand the selector either.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/

ComponentResult RTPRssmGetInfo (
   RTPReassembler    rtpr,
   OSType            inSelector,
   void              *ioParams ){};


/*RTPPBAddPacketLiteralData

Passes literal data directly to a packet builder component.

ComponentResult RTPPBAddPacketLiteralData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   UInt8                       *inData,
   UInt32                      inDataLength,
   RTPPacketRepeatedDataRef    *outDataRef );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacket

The RTP packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacket.
inData

A pointer to the data you are passing.
inDataLength

An unsigned 32-bit integer containing the length, in bytes, of the data you are passing.
outDataRef

On return, contains a pointer to a data reference. Use this reference if you wish to later tell the packet builder to use this same data again, without having to literally pass the data again. Pass in NIL if you do not need the packet builder to repeat the data. If you do not pass in NIL, you must dispose of the data explicitly by calling RTPPBReleaseRepeatedData.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function will return a reference which can be used to specify the same data repeatedly without having to pass in the data again. This is done by calling RTPPBAddPacketRepeatedData with the reference which was returned by this function. For example, you can use this function to insert static header information into a packet prior to inserting media sample data. It will return a data reference you can use to insert the same static information into later packets.
Special Considerations

To specify media data to be placed in a packet, a media packetizer should call RTPPBAddPacketSampleData.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBAddPacketLiteralData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   UInt8                       *inData,
   UInt32                      inDataLength,
   RTPPacketRepeatedDataRef    *outDataRef ){};


/*RTPPBAddPacketSampleData

Commands a packet builder component to insert media sample data into a packet.

ComponentResult RTPPBAddPacketSampleData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   RTPMPSampleDataParams       *inSampleDataParams,
   UInt32                      inSampleOffset,
   UInt32                      inSampleDataLength,
   RTPPacketRepeatedDataRef    *outDataRef );
Parameters
rtpb

The component instance of the packet builder component.
inFlags

A signed 32-bit integer containing any flags you are passing. There are currently no defined flags.
inPacketGroup

The packet group containing the packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacketGroup.
inPacket

The RTP packet into which the data will be placed. This is normally a reference returned by RTPPBBeginPacket.
inSampleDataParams

A pointer to a RTPMPSampleDataParams structure for the sample data you are inserting.
inSampleOffset

A 32-bit unsigned integer containing the offset into the sample media, in bytes.
inSampleDataLength

A 32-bit unsigned integer specifying the number of bytes of media sample data to insert into the packet.
outDataRef

On return, contains a pointer to a data reference. Use this reference if you wish to later tell the packet builder to use this same sample data again, without having to literally pass the data again. Pass in NIL if you do not need the packet builder to repeat the data. If you do not pass in NIL , you must dispose of the data explicitly by calling RTPPBReleaseRepeatedData.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function will return a reference which can be used to specify the same data repeatedly without having to pass in the data again. The media packetizer specifies the offset into the media and the length of the sample to insert. You can insert data repeatedly by calling RTPPBAddPacketRepeatedData with the reference which was returned by RTPPBAddPacketLiteralData.
Special Considerations

When a reference is no longer needed, it should be disposed of by using the call RTPPBReleaseRepeatedData.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
ComponentResult RTPPBAddPacketSampleData (
   RTPPacketBuilder            rtpb,
   SInt32                      inFlags,
   RTPPacketGroupRef           inPacketGroup,
   RTPPacketRef                inPacket,
   RTPMPSampleDataParams       *inSampleDataParams,
   UInt32                      inSampleOffset,
   UInt32                      inSampleDataLength,
   RTPPacketRepeatedDataRef    *outDataRef ){};

/*GetTrackPict

Creates a QuickDraw picture from a specified track at a specified time.

PicHandle GetTrackPict (
   Track        theTrack,
   TimeValue    time );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
time

The time at which the image is taken.
Return Value

A handle to the specified picture. If the function could not create the picture, the returned handle is set to NIL.
Special Considerations

Your application must dispose of the returned picture handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

PicHandle GetTrackPict (
   Track        theTrack,
   TimeValue    time ){};


/*GetMoviePosterTime

Returns the poster's time in a movie.

TimeValue GetMoviePosterTime (
   Movie    theMovie );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

The time in the movie from which its poster is taken.
Discussion

Since a movie poster has no duration, it is defined by a point in time within the movie. The time value returned by GetMoviePosterTime is in the time coordinate system of the movie and represents the starting time for the movie frame that contains the poster image.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeValue GetMoviePosterTime (
   Movie    theMovie ){};

/*SCCompressImage

Compresses an image that is stored in a PixMap structure.

ComponentResult SCCompressImage (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc,
   Handle                    *data );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
src

A handle to the PixMap structure to be compressed.
srcRect

A pointer to a portion of the PixMap structure to compress as a Rect structure. This rectangle must be in the pixel map's coordinate system. If you want to compress the entire pixel map, set this parameter to NIL.
desc

A pointer to a handle to an ImageDescription structure. The standard dialog component creates an ImageDescription structure when it compresses the image, and returns a handle to that structure in the field referred to by this parameter. The component sizes that handle appropriately. Your application is responsible for disposing of that handle when you are done with it.
data

A pointer to a handle. The standard dialog component returns a handle to the compressed image data in the field referred to by this parameter. The component sizes that handle appropriately. Your application is responsible for disposing of that handle when you are done with it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCCompressImage (
   ComponentInstance         ci,
   PixMapHandle              src,
   const Rect                *srcRect,
   ImageDescriptionHandle    *desc,
   Handle                    *data ){};



/*NewSCModalFilterUPP

Allocates a Universal Procedure Pointer for the SCModalFilterProc callback.

SCModalFilterUPP NewSCModalFilterUPP (
   SCModalFilterProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewSCModalFilterProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
SCModalFilterUPP NewSCModalFilterUPP (
   SCModalFilterProcPtr    userRoutine ){};


/*NewTrackTransferUPP

Allocates a Universal Procedure Pointer for the TrackTransferProc callback.

TrackTransferUPP NewTrackTransferUPP (
   TrackTransferProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewTrackTransferProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TrackTransferUPP NewTrackTransferUPP (
   TrackTransferProcPtr    userRoutine ){};

/*SetTrackGWorld

Forces a track to draw into a particular graphics world, which may be different from that of the movie.

void SetTrackGWorld (
   Track               theTrack,
   CGrafPtr            port,
   GDHandle            gdh,
   TrackTransferUPP    proc,
   long                refCon );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
port

Points to the graphics port structure or graphics world to which to draw the track. Set this parameter to NIL to use the movie's graphics port.
gdh

A handle to the movie's graphics device structure. Set this parameter to NIL to use the current device. If the port parameter specifies a graphics world, set this parameter to NIL to use that graphics world's graphics device.
proc

A pointer to your TrackTransferProc callback. Set this parameter to NIL if you want to remove your callback.
refCon

A value to pass to your TrackTransferProc callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

After this function draws a track, it calls your transfer callback to copy the track to the actual movie graphics world. When your transfer callback is called, the current graphics world is set to the correct destination. You can also install a transfer callback and set the graphics world to NIL. In this case, the function calls your callback only as a notification that the track has been drawn; no transfer needs to take place.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTrackGWorld (
   Track               theTrack,
   CGrafPtr            port,
   GDHandle            gdh,
   TrackTransferUPP    proc,
   long                refCon ){};


/*QTRemoveChildren

Removes all the children of an atom from the specified atom container.

OSErr QTRemoveChildren (
   QTAtomContainer    container,
   QTAtom             atom );
Parameters
container

The atom container for this operation. The atom container must not be locked.
atom

The atom whose children should be removed. To remove all the atoms in the atom container, pass a value of kParentAtomIsContainer.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr QTRemoveChildren (
   QTAtomContainer    container,
   QTAtom             atom ){};


/*SetMediaPropertyAtom

Sets the property atom container of a media handler.

OSErr SetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    propertyAtom );
Parameters
theMedia

A reference to the media handler for this operation.
propertyAtom

Specifies a QT atom container that contains the property atoms for the track associated with the media handler.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function to set properties for the track associated with the specified media handler. The contents of the QT atom container are defined by the media handler. Here is some sample code that uses this function to define the background color for a sprite track:// SetMediaPropertyAtom coding example
// See "Discovering QuickTime," page 360
if (bWithBackgroundPicture) {
    QTAtomContainer         qtacTrackProperties;
    RGBColor                rgbcBackColor;
    rgbcBackColor.red =EndianU16_NtoB(0x8000);
    rgbcBackColor.green =EndianU16_NtoB(0);
    rgbcBackColor.blue =EndianU16_NtoB0(xffff);
    // create a new atom container for sprite track properties
    QTNewAtomContainer(&qtacTrackProperties);
    // add an atom for the background color property
    QTInsertChild(qtacTrackProperties, 0,
        kSpriteTrackPropertyBackgroundColor, 1, 1, sizeof(RGBColor),
        &rgbcBackColor, NIL);
    // set the sprite track's properties
    nErr =SetMediaPropertyAtom(media, qtacTrackProperties);
    QTDisposeAtomContainer(qtacTrackProperties);
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr SetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    propertyAtom ){};

/*DisposeImageCodecMPDrawBandUPP

Disposes of an ImageCodecMPDrawBandUPP pointer.

void DisposeImageCodecMPDrawBandUPP (
   ImageCodecMPDrawBandUPP    userUPP );
Parameters
userUPP

An ImageCodecMPDrawBandUPP pointer. See Universal Procedure Pointers.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
void DisposeImageCodecMPDrawBandUPP (
   ImageCodecMPDrawBandUPP    userUPP ){};






/*FlattenMovieDataToDataRef

Performs a flattening operation to a movie at a storage location.

Movie FlattenMovieDataToDataRef (
   Movie         theMovie,
   long          movieFlattenFlags,
   Handle        dataRef,
   OSType        dataRefType,
   OSType        creator,
   ScriptCode    scriptTag,
   long          createMovieFileFlags );
Parameters
theMovie

The movie passed into this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
movieFlattenFlags

Constants (see below) that control the process of adding movie data to the new container. QuickTime will read these flags later when it adds movies to the storage. Set unused flags to 0. See these constants: 
flattenAddMovieToDataFork
flattenDontInterleaveFlatten
flattenActiveTracksOnly
flattenCompressMovieResource
flattenForceMovieResourceBeforeMovieData
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
creator

The creator type of the new container (for example, 'TV0D', the creator type for Apple's movie player).
scriptTag

Constants (see below) that specify the script for the new container. See these constants: 
createMovieFileFlags

Constants (see below) that control file creation options. See these constants: 
createMovieFileDeleteCurFile
createMovieFileDontCreateMovie
createMovieFileDontOpenFile
Return Value

The identifier of the new movie. If the function could not create the movie, it sets the returned identifier to NIL.
Discussion

This function performs a flattening operation to the destination data reference.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
Movie FlattenMovieDataToDataRef (
   Movie         theMovie,
   long          movieFlattenFlags,
   Handle        dataRef,
   OSType        dataRefType,
   OSType        creator,
   ScriptCode    scriptTag,
   long          createMovieFileFlags ){};


/*QTMovieNeedsTimeTable

Returns whether a movie is being progressively downloaded.

OSErr QTMovieNeedsTimeTable (
   Movie      theMovie,
   Boolean    *needsTimeTable );
Parameters
theMovie

The movie for this operation. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
needsTimeTable

If TRUE, the movie is being progressively downloaded. If an error occurs, this parameter is set to FALSE.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

A movie can be progressively downloaded when its data is received over a network connection or other slow data channel. Progressive downloads are not necessary when the data for the movie is on a local disk. The Movie Toolbox creates a time table for a movie when either this function or GetMaxLoadedTimeInMovie is called for the movie, but the time table is used only by the toolbox and is not accessible to applications. The toolbox disposes of the time table when the download is complete.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTMovieNeedsTimeTable (
   Movie      theMovie,
   Boolean    *needsTimeTable ){};


/*UpdateMovieInStorage

Updates a movie at a storage location.

OSErr UpdateMovieInStorage (
   Movie          theMovie,
   DataHandler    dh );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
dh

The data handler component that was returned by CreateMovieStorage.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function, which is similar to OpenMovieStorage, replaces the content of the movie in the storage associated with the specified data handler.
Version Notes

Introduced in QuickTime 6. Supersedes UpdateMovieResource.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr UpdateMovieInStorage (
   Movie          theMovie,
   DataHandler    dh ){};

/*OpenMovieStorage

Opens a data handler for movie storage.

OSErr OpenMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   long           flags,
   DataHandler    *outDataHandler );
Parameters
dataRef

A handle to a QuickTime data reference.
dataRefType

The data reference type. See Data References.
flags

A constant (see below) that determines the reading and writing capabilities of the data handler. See these constants: 
kDataHCanRead
kDataHCanWrite
outDataHandler

A pointer to a field that is to receive the data handler for the opened movie file. Your application uses this value when calling other Movie Toolbox functions that work with movie files. If you pass NIL, the Movie Toolbox creates the movie storage but does not open it.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function is rarely used. It is an alternative to OpenMovieFile.
Version Notes

Introduced in QuickTime 6.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Movies.h*/
OSErr OpenMovieStorage (
   Handle         dataRef,
   OSType         dataRefType,
   long           flags,
   DataHandler    *outDataHandler ){};


/*MCGetControllerBoundsRgn

Returns the actual region occupied by the controller and its movie.

RgnHandle MCGetControllerBoundsRgn (
   MovieController    mc );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
Return Value

A handle to a MacRegion structure that reflects the size, shape, and location of the controller. Your application must dispose of this structure.
Discussion

As with MCGetControllerBoundsRect, this function returns a region even if the controller is hidden. Some movie controllers may not be rectangular in shape. If the movie is not attached to its controller, the boundary region encloses only the control portion of the controller.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
RgnHandle MCGetControllerBoundsRgn (
   MovieController    mc ){};

/*MCInvalidate

Invalidates a region of a movie controller's display.

ComponentResult MCInvalidate (
   MovieController    mc,
   WindowRef          w,
   RgnHandle          invalidRgn );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
w

A pointer to the window in which the movie controller and its movie are displayed, if the control portion of the controller is attached to the movie. If the controller is detached and in a separate window from the movie, specify one of the windows.
invalidRgn

A handle to a MacRegion structure that defines a region to invalidate.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/
ComponentResult MCInvalidate (
   MovieController    mc,
   WindowRef          w,
   RgnHandle          invalidRgn ){};



/*MCMovieChanged

Informs a movie controller component that your application has used the Movie Toolbox to change the characteristics of its associated movie.

ComponentResult MCMovieChanged (
   MovieController    mc,
   Movie              m );
Parameters
mc

The movie controller for the operation. You obtain this identifier from OpenComponent or OpenDefaultComponent, or from NewMovieController.
m

The movie that has been changed.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h, HIMovieView.h*/

ComponentResult MCMovieChanged (
   MovieController    mc,
   Movie              m ){};



/*GetMovieLoadState

Returns a value that indicates the state of a movie's loading process.

long GetMovieLoadState (
   Movie    theMovie );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
Return Value

A constant (see below) that indicates the movie's loading status.
Discussion

This function lets your code perform relative comparisons against movie loading milestones to determine if certain operations make sense. Its return values are ordered so that they conform to this rule:kMovieLoadStateError
< kMovieLoadStateLoading
< kMovieLoadStatePlayable
< kMovieLoadStateComplete

Special Considerations

Because of the "voting system" involved, an application checking for the load state should throttle its calling of the routine. Not calling GetMovieLoadState more often than every quarter of a second is a good place to start.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetMovieLoadState (
   Movie    theMovie ){};


/*SetMediaInputMap

Replaces the media's existing input map with a given input map.

OSErr SetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    inputMap );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
inputMap

The media input map for this operation. If the input map is set to NIL, the media's input map is reset to an empty input map.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

Use this function to specify the media you want to set so you can modify or empty its input map. It makes a copy of the input map passed to it. The following sample code illustrates how to update an input map, using this function and GetMediaInputMap:// SetMediaInputMap coding example
QTAtomContainer inputMap;
QTAtom inputAtom;
OSType inputType;
Media aVideoMedia =GetTrackMedia(aVideoTrack);
GetMediaInputMap (aVideoMedia, &inputMap);
QTInsertChild(inputMap, kParentAtomIsContainer, kTrackModifierInput,
        addedIndex, 0,0, nil, &inputAtom);
inputType =kTrackModifierTypeClip;
QTInsertChild (inputMap, inputAtom, kTrackModifierType, 1, 0,
        sizeof(inputType), &inputType, nil);
SetMediaInputMap(aVideoMedia, inputMap);
QTDisposeAtomContainer(inputMap);

Special Considerations

Use QTNewAtomContainer to create an empty input map.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

OSErr SetMediaInputMap (
   Media              theMedia,
   QTAtomContainer    inputMap ){};


/*AddTrackReference

Adds a new track reference to a track.

OSErr AddTrackReference (
   Track     theTrack,
   Track     refTrack,
   OSType    refType,
   long      *addedIndex );
Parameters
theTrack

Identifies the track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
refTrack

The track to be identified in the track reference.
refType

The type of reference.
addedIndex

A pointer to a long integer. The toolbox returns the index value assigned to the new track reference. If you don't want this information, set this parameter to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The following code snippet shows how AddTrackReference can be used to add a modifier track reference to a sprite track.// AddTrackReference coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddTrackReference (
   Track     theTrack,
   Track     refTrack,
   OSType    refType,
   long      *addedIndex ){};


/*GraphicsImportDoExportImageFileDialog

Presents a dialog box letting the user save an imported image in a foreign file format.

ComponentResult GraphicsImportDoExportImageFileDialog (
   GraphicsImportComponent    ci,
   const FSSpec               *inDefaultSpec,
   StringPtr                  prompt,
   ModalFilterYDUPP           filterProc,
   OSType                     *outExportedType,
   FSSpec                     *outExportedSpec,
   ScriptCode                 *outScriptTag );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
inDefaultSpec

A pointer to an FSSpec that suggests a default name for the file. If you don't want to suggest a default name, pass NIL.
prompt

A pointer to a prompt string that appears in the standard put dialog box; it may be NIL, in which case a default string is used.
filterProc

A modal filter function to be passed to the Mac OS function CustomPutFile; see Inside Macintosh: Files for more information. If you don't need to filter events, pass NIL.
outExportedType

A pointer to a variable that will receive the type of the export file that was chosen by the user. If you don't want this information, pass NIL. See File Types and Creators.
outExportedSpec

A pointer to a variable that will receive the FSSpec of the file that was written. If you don't want this information, pass NIL.
outScriptTag

A pointer to a variable that will receive the script system in which the exported file name is to be displayed. See Localization Codes. If you don't want this information, pass NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function presents the user with an extended Standard File dialog box that allows the image currently in use by the graphics import component to be exported to a file, in a format of the user's choice.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportDoExportImageFileDialog (
   GraphicsImportComponent    ci,
   const FSSpec               *inDefaultSpec,
   StringPtr                  prompt,
   ModalFilterYDUPP           filterProc,
   OSType                     *outExportedType,
   FSSpec                     *outExportedSpec,
   ScriptCode                 *outScriptTag ){};

/*GraphicsImportGetColorSyncProfile

Returns a ColorSync profile for an imported image, if one is embedded in the image file.

ComponentResult GraphicsImportGetColorSyncProfile (
   GraphicsImportComponent    ci,
   Handle                     *profile );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
profile

A pointer to receive a handle containing a ColorSync profile, or NIL if the image file does not contain one.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Some graphics importers don't implement this function. The caller is responsible for disposing of the returned handle.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetColorSyncProfile (
   GraphicsImportComponent    ci,
   Handle                     *profile ){};

/*QTVideoOutputSetClientName

Registers the name of an application or other software with an instance of a video output component.

ComponentResult QTVideoOutputSetClientName (
   QTVideoOutputComponent    vo,
   ConstStr255Param          str );
Parameters
vo

The instance of a video output component for the request. Your software obtains this reference when it calls OpenComponent or OpenDefaultComponent.
str

The name of the application or other software to be registered.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The name you specify with this function can later be used by QTVideoOutputGetCurrentClientName to specify which software has exclusive access to the video output device controlled by the component.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputSetClientName (
   QTVideoOutputComponent    vo,
   ConstStr255Param          str ){};


/*QTVideoOutputSetDisplayMode

Specifies the display mode to be used by a video output component.

ComponentResult QTVideoOutputSetDisplayMode (
   QTVideoOutputComponent    vo,
   long                      displayModeID );
Parameters
vo

The instance of a video output component for the request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
displayModeID

The ID of the display mode to use. The ID specifies a QT atom of type kQTVODisplayModeItem in the QT atom container returned by QTVideoOutputGetDisplayModeList.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When software changes the display mode with this function, the change does not take effect until the next time the software calls QTVideoOutputBegin for the video output component. This lets the software change other output settings before displaying the video.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputSetDisplayMode (
   QTVideoOutputComponent    vo,
   long                      displayModeID ){};


/*QTVideoOutputBegin

Obtains exclusive access to the video hardware controlled by a video output component.

ComponentResult QTVideoOutputBegin (
   QTVideoOutputComponent    vo );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error. If this function returns the videoOutputInUseErr result code that indicates that the video hardware is currently in use, your software can get the name of the application or other software that is using the hardware by calling QTVideoOutputGetCurrentClientName. You can then display an alert to the user that says that the video hardware is in use and specifies the name of the software using the video hardware.
Discussion

When your software calls this function, the video output component acquires exclusive access to the video hardware controlled by the specified video output component or returns the videoOutputInUseErr result code if the video hardware is currently in use. If the video hardware is available, the video output component also enables the display mode last set with QTVideoOutputSetDisplayMode and enables the video settings, if any, that were most recently specified by the user in a custom video configuration dialog box. If the video output component supports QTVideoOutputCustomConfigureDisplay, your software can call the function to display a custom video configuration dialog box. When your software no longer needs the video output component, release it by calling QTVideoOutputEnd.
Special Considerations

If your software needs to change the display mode, it must change it before calling this function. It cannot change the display mode between calls to this function and to QTVideoOutputEnd.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputBegin (
   QTVideoOutputComponent    vo ){};


/*QTVideoOutputGetGWorld

Returns a pointer to the graphics world used by a video output component.

ComponentResult QTVideoOutputGetGWorld (
   QTVideoOutputComponent    vo,
   GWorldPtr                 *gw );
Parameters
vo

The instance of a video output component for this request. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
gw

A pointer to the graphics world used by the video output component to display images.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If the pixel format of the graphics world is 1, 2, 4, 8, 16, or 32, your software can use either QuickDraw or QuickTime to draw graphics to it. If the graphics world has any other pixel format, your software must use QuickTime functions draw to it. Your software can pass the pointer returned by this function to the SetMovieGWorld, DecompressSequenceBegin, DecompressSequenceBeginS, DecompressImage, and FDecompressImage functions.

Your software can call QTVideoOutputGetGWorld only between calls to QTVideoOutputBegin and QTVideoOutputEnd. When your software calls QTVideoOutputEnd, the video output component automatically disposes of the graphics world. If your software needs to use the graphics world after calling QTVideoOutputEnd, it must call this function again after the next time it calls QTVideoOutputBegin.
Special Considerations

Your software must not dispose of the graphics world used by a video output component. The video output component automatically disposes of the graphics world when your software calls QTVideoOutputEnd.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputGetGWorld (
   QTVideoOutputComponent    vo,
   GWorldPtr                 *gw ){};


/*QTVideoOutputEnd

Releases access to the video hardware controlled by a video output component.

ComponentResult QTVideoOutputEnd (
   QTVideoOutputComponent    vo );
Parameters
vo

The instance of a video output component. Your software obtains this reference when calling OpenComponent or OpenDefaultComponent.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your software should release access to a video output component as soon as it is done using the video hardware controlled by the component. If you close the instance of a video output component that currently has exclusive access to video hardware, the video output component automatically calls this function to release the hardware.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult QTVideoOutputEnd (
   QTVideoOutputComponent    vo ){};

/*GetBestDeviceRect

Selects the deepest of all available graphics devices, while treating 16-bit and 32-bit screens as having equal depth.

OSErr GetBestDeviceRect (
   GDHandle    *gdh,
   Rect        *rp );
Parameters
gdh

A pointer to the handle of the rectangle for the chosen device. If you do not need the information in this parameter returned, specify NIL.
rp

A pointer to the rectangle that is adjusted for the height of the menu bar if the device is the main device. If you do not need the information in this parameter returned, specify NIL.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function does not center a rectangle on a device. Rather, it returns the rectangle for the best device. The following code sample illustrates its use:// GetBestDeviceRect coding example
// See "Discovering QuickTime," page 265
WindowRef MakeMyWindow (void)
{
    WindowRef   pMacWnd;
    Rect        rectWnd ={0, 0, 120, 160};
    Rect        rectBest;
    // figure out the best monitor for the window
    GetBestDeviceRect(NIL, &rectBest);
    // put the window in the top left corner of that monitor
    OffsetRect(&rectWnd, rectBest.left + 10, rectBest.top + 50);
    // create the window
    pMacWnd =NewCWindow(NIL, &rectWnd, "\pGrabber",
                            TRUE, noGrowDocProc, (WindowRef)-1, TRUE, 0);
    // set the port to the new window
    SetPort(pMacWnd);
    return pMacWnd;
}

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr GetBestDeviceRect (
   GDHandle    *gdh,
   Rect        *rp ){};


/*DisposeCallBack

Disposes of a callback event.

void DisposeCallBack (
   QTCallBack    cb );
Parameters
cb

The callback event for the operation. You obtain this value from NewCallBack.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

You should call this function when you are done with each callback event.
Special Considerations

Don't call this function at interrupt time.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeCallBack (
   QTCallBack    cb ){};


/*SetMovieMasterTimeBase

Assigns a master time base to a movie.

void SetMovieMasterTimeBase (
   Movie               theMovie,
   TimeBase            tb,
   const TimeRecord    *slaveZero );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
tb

The master time base to be assigned to this movie. Your application obtains this time base identifier from NewTimeBase.
slaveZero

A pointer to the time, in the time scale of the master time base, that corresponds to a 0 time value for the movie. This parameter allows you to set an offset between the movie and the master time base. Set this parameter to NIL if there is no offset.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMovieMasterTimeBase (
   Movie               theMovie,
   TimeBase            tb,
   const TimeRecord    *slaveZero ){};

/*SetTimeBaseValue

Sets the current time of a time base.

void SetTimeBaseValue (
   TimeBase     tb,
   TimeValue    t,
   TimeScale    s );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
t

The new time value.
s

The time scale of the new time value.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void SetTimeBaseValue (
   TimeBase     tb,
   TimeValue    t,
   TimeScale    s ){};

/*CallMeWhen

Schedules a callback event.

OSErr CallMeWhen (
   QTCallBack       cb,
   QTCallBackUPP    callBackProc,
   long             refCon,
   long             param1,
   long             param2,
   long             param3 );
Parameters
cb

The callback event for the operation. You obtain this identifier from NewCallBack.
callBackProc

Points to your callback function, described in QTCallBackProc.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
param1

Contains scheduling information. The Movie Toolbox interprets this parameter based on the value of the cbType parameter to NewCallBack. If cbType is set to callBackAtTime, the param1 parameter contains flags (see below) indicating when to invoke your callback function for this callback event. If the cbType parameter is set to callBackAtRate, param1 contains flags (see below) indicating when to invoke your callback function for this event. Be sure to set unused flags to 0.
param2

Contains scheduling information. The Movie Toolbox interprets this parameter based on the value of the cbType parameter to NewCallBack. If cbType is set to callBackAtTime, the param2 parameter contains the time value at which your callback function is to be invoked for this event. The param1 parameter contains flags affecting when the Movie Toolbox calls your function. If cbType is set to callBackAtRate, the param2 parameter contains the rate value at which your callback function is to be invoked for this event. The param1 parameter contains flags affecting when the Movie Toolbox calls your function.
param3

The time scale in which to interpret the time value that is stored in param3 if cbType is set to callBackAtTime.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call this function from your callback function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr CallMeWhen (
   QTCallBack       cb,
   QTCallBackUPP    callBackProc,
   long             refCon,
   long             param1,
   long             param2,
   long             param3 ){};


/*NewCallBack

Creates a new callback event.

QTCallBack NewCallBack (
   TimeBase    tb,
   short       cbType );
Parameters
tb

The callback event's time base. You obtain this identifier from NewTimeBase.
cbType

Constants (see below) that specify when the callback event is to be invoked. The value of this field governs how the Movie Toolbox interprets the data supplied in the param1, param2, and param3 parameters to the CallMeWhen function. In addition, if the high-order bit of the cbType parameter is set to 1 (this bit is defined by the callBackAtInterrupt flag), the event can be invoked at interrupt time. See these constants: 
callBackAtTime
callBackAtRate
callBackAtTimeJump
callBackAtExtremes
callBackAtInterrupt
Return Value

A pointer to a CallBackRecord structure containing the new callback event.
Special Considerations

The callback event created is not active until you schedule it by calling the CallMeWhen function. You must not call this function at interrupt time.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTCallBack NewCallBack (
   TimeBase    tb,
   short       cbType ){};

/*NewQTCallBackUPP

Allocates a Universal Procedure Pointer for the QTCallBackProc callback.

QTCallBackUPP NewQTCallBackUPP (
   QTCallBackProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewQTCallBackProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
QTCallBackUPP NewQTCallBackUPP (
   QTCallBackProcPtr    userRoutine ){};


/*HIMovieViewSetMovie

Sets the view's current movie.

OSStatus HIMovieViewSetMovie (
   HIViewRef inView,
   Movie inMovie );
Parameters
inView

The HIMovieView.
inMovie

The new movie to display.
Return Value

An error code. Returns noErr if there is no error.
Discussion

This routine sets the view's current movie.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
OSStatus HIMovieViewSetMovie (
   HIViewRef inView,
   Movie inMovie ){};

/*HIMovieViewChangeAttributes

Changes the views attributes.

OSStatus HIMovieViewChangeAttributes (
   HIViewRef inView,
   OptionBits inAttributesToSet,
   OptionBits inAttributesToClear );
Parameters
inView

The HIMovieView.
inAttributesToSet

Attributes to set.
inAttributesToClear

Attributes to clear.
Return Value

An error code. Returns noErr if there is no error.
Discussion

Setting an attribute takes precedence over clearing the attribute.
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
OSStatus HIMovieViewChangeAttributes (
   HIViewRef inView,
   OptionBits inAttributesToSet,
   OptionBits inAttributesToClear ){};


/*HIMovieViewGetControllerBarSize

Returns the size of the visible movie controller bar.

HISize HIMovieViewGetControllerBarSize (
   HIViewRef inView );
Parameters
inView

The HIMovieView.
Return Value

Undocumented.
Discussion

The size of the visible movie controller bar is returned. 
Availability
Available in Mac OS X v10.3 and later.
Declared In
Movies.h, HIMovieView.h*/
HISize HIMovieViewGetControllerBarSize (
   HIViewRef inView ){};


/*XMLParseDataRef

Undocumented

ComponentResult XMLParseDataRef (
   ComponentInstance    aParser,
   Handle               dataRef,
   OSType               dataRefType,
   long                 parseFlags,
   XMLDoc               *document );
Parameters
aParser

Undocumented
dataRef

Undocumented
dataRefType

Undocumented
parseFlags

Undocumented
document

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseDataRef (
   ComponentInstance    aParser,
   Handle               dataRef,
   OSType               dataRefType,
   long                 parseFlags,
   XMLDoc               *document ){};

/*MovieImportDataRef

Undocumented

ComponentResult MovieImportDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags );
Parameters
ci

A movie import component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

The data reference to the data to be imported.
dataRefType

The type of data reference in the dataRef parameter.
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
targetTrack

Undocumented
usedTrack

Undocumented
atTime

Undocumented
addedDuration

Undocumented
inFlags

Flags (see below) that control the behavior of this function. See these constants: 
movieImportCreateTrack
movieImportInParallel
movieImportMustUseTrack
movieImportWithIdle
outFlags

Flags (see below) that this function sets on return. See these constants: 
movieImportResultUsedMultipleTracks
movieImportResultNeedIdles
movieImportResultComplete
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieImportDataRef (
   MovieImportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   targetTrack,
   Track                   *usedTrack,
   TimeValue               atTime,
   TimeValue               *addedDuration,
   long                    inFlags,
   long                    *outFlags ){};

/*XMLParseDisposeXMLDoc

Undocumented

ComponentResult XMLParseDisposeXMLDoc (
   ComponentInstance    aParser,
   XMLDoc               document );
Parameters
aParser

Undocumented
document

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseDisposeXMLDoc (
   ComponentInstance    aParser,
   XMLDoc               document ){};



/*AddMovieSelection

Adds one or more tracks to a movie.

void AddMovieSelection (
   Movie    theMovie,
   Movie    src );
Parameters
theMovie

The destination movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
src

The source movie for this operation. AddMovieSelection adds the tracks from this movie to the destination movie. The function adds these tracks at the time specified by the current selection in the destination movie.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function scales the source movie so that it fits into the destination selection. If the current selection in the destination movie has a 0 duration, the Movie Toolbox adds the segment at the beginning of the current selection. The entire source movie is used regardless of the selection in the source movie. The Movie Toolbox removes any empty tracks from the destination movie after the add operation. If you have assigned a progress function to the destination movie, the Movie Toolbox calls that progress function during long add operations. Following is an example of using this function:// AddMovieSelection coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Special Considerations

Some Movie Toolbox functions can take a long time to execute. For example, if you call FlattenMovie and specify a large movie, the Movie Toolbox must read and write all the sample data for the movie. During such operations you may wish to display some kind of progress indicator to the user. A progress function is an application-defined function that you can create to track the progress of time-consuming activities and keep the user informed. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void AddMovieSelection (
   Movie    theMovie,
   Movie    src ){};


/*ScaleMovieSegment

Changes the duration of a segment of a movie.

OSErr ScaleMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    oldDuration,
   TimeValue    newDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, or NewMovieFromHandle.
startTime

The start of the segment. The oldDuration parameter specifies the segment's duration. This time value must be expressed in the movie's time scale.
oldDuration

The original duration of the segment in the source movie. This time value must be expressed in the movie's time scale.
newDuration

The new duration of the segment. This time value must be expressed in the movie's time scale. The function alters the segment to accommodate the new duration.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The Movie Toolbox scales the segment to accommodate the new duration.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr ScaleMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    oldDuration,
   TimeValue    newDuration ){};


/*GetDataHandler

Retrieves the best data handler component to use with a given data reference.

Component GetDataHandler (
   Handle    dataRef,
   OSType    dataHandlerSubType,
   long      flags );
Parameters
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by the dataHandlerSubType parameter.
dataHandlerSubType

Identifies both the type of data reference and, by implication, the component subtype value assigned to the data handler components that operate on data references of that type.
flags

Contains flags (see below) that indicate the way in which you intend to use the data handler component. Note that not all data handlers necessarily support all services; for example, some data handler components may not support streaming writes. Set the appropriate flags to 1. See these constants: 
kDataHCanRead
kDataHCanWrite
kDataHCanStreamingWrite
Return Value

The best data handler component conforming to the parameters passed in.
Discussion

Once you have used this function to get information about the best data handler component for your data reference, you can open and use the component using Component Manager functions. If the function returns a value of NIL, the toolbox was unable to find an appropriate data handler component. For more information about the error that caused a return of NIL, call GetMoviesError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
Component GetDataHandler (
   Handle    dataRef,
   OSType    dataHandlerSubType,
   long      flags ){};


/*DataHSetDataRefWithAnchor

Sets the data reference and anchor data reference for a data handler.

ComponentResult DataHSetDataRefWithAnchor (
   DataHandler    dh,
   Handle         anchorDataRef,
   OSType         dataRefType,
   Handle         dataRef );
Parameters
dh

A data handler component.
anchorDataRef

A handle to the anchor data reference.
dataRefType

The type of the data reference. Different types of containers may require different types of data references. For example, a reference to a memory-based movie may be a handle, while a reference to a file-based movie may be an alias. Apple's memory-based data handler for the Macintosh uses handles (and has a subtype value of 'hndl'), while the HFS data handler uses Alias Manager aliases (its subtype value is 'alis'). See Data References.
dataRef

A data reference handle. Your component should make a copy of its current data reference in a handle and return that handle in this field. The client program is responsible for disposing of that handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHSetDataRefWithAnchor (
   DataHandler    dh,
   Handle         anchorDataRef,
   OSType         dataRefType,
   Handle         dataRef ){};


/*DataHGetDataRefAsType

Retrieves a data handler component's current data reference of a given type.

ComponentResult DataHGetDataRefAsType (
   DataHandler    dh,
   OSType         requestedType,
   Handle         *dataRef );
Parameters
dh

A data handler component.
requestedType

The type of the data reference to retrieve; see Data References.
dataRef

A pointer to a data reference handle. Your component should make a copy of its current data reference in a handle and return that handle in this field. The client program is responsible for disposing of that handle. Different types of containers may require different types of data references. For example, a reference to a memory-based movie may be a handle, while a reference to a file-based movie may be an alias. Apple's memory-based data handler for the Macintosh uses handles (and has a subtype value of 'hndl'), while the HFS data handler uses Alias Manager aliases (its subtype value is 'alis'). See Data References.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHGetDataRefAsType (
   DataHandler    dh,
   OSType         requestedType,
   Handle         *dataRef ){};



/*XMLParseAddElement

Undocumented

ComponentResult XMLParseAddElement (
   ComponentInstance    aParser,
   char                 *elementName,
   UInt32               nameSpaceID,
   UInt32               *elementID,
   long                 elementFlags );
Parameters
aParser

Undocumented
elementName

Undocumented
nameSpaceID

Undocumented
elementID

Undocumented
elementFlags

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/

ComponentResult XMLParseAddElement (
   ComponentInstance    aParser,
   char                 *elementName,
   UInt32               nameSpaceID,
   UInt32               *elementID,
   long                 elementFlags ){};


/*XMLParseAddAttributeAndValue

Undocumented

ComponentResult XMLParseAddAttributeAndValue (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID,
   UInt32               attributeValueKind,
   void                 *attributeValueKindInfo );
Parameters
aParser

Undocumented
elementID

Undocumented
nameSpaceID

Undocumented
attributeName

Undocumented
attributeID

Undocumented
attributeValueKind

Undocumented
attributeValueKindInfo

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseAddAttributeAndValue (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID,
   UInt32               attributeValueKind,
   void                 *attributeValueKindInfo ){};



/*XMLParseAddAttribute

Undocumented

ComponentResult XMLParseAddAttribute (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID );
Parameters
aParser

Undocumented
elementID

Undocumented
nameSpaceID

Undocumented
attributeName

Undocumented
attributeID

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 5.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult XMLParseAddAttribute (
   ComponentInstance    aParser,
   UInt32               elementID,
   UInt32               nameSpaceID,
   char                 *attributeName,
   UInt32               *attributeID ){};


/*GetMediaSampleReference

Obtains reference information about samples that are stored in a movie data file.

OSErr GetMediaSampleReference (
   Media                      theMedia,
   long                       *dataOffset,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
dataOffset

A pointer to a long integer. GetMediaSampleReference updates the field referred to by this parameter with the offset to the sample data. This parameter is used differently by each media handler. For example, the hierarchical file system (HFS) media handler returns an offset into the file that contains the media data.
size

A pointer to a long integer. GetMediaSampleReference updates the field referred to by the size parameter with the number of bytes of sample data referred to by the reference. Set this parameter to NIL if you are not interested in this information.
time

The starting time of the sample reference to be retrieved. You must specify this value in the media's time scale.
sampleTime

A pointer to a time value. GetMediaSampleReference updates this time value to indicate the actual time of the returned sample data. (The returned time may differ from the time you specified with the time parameter. This will occur if the time you specified falls in the middle of a sample.) If you are not interested in this information, set this parameter to NIL.
durationPerSample

A pointer to a time value. The Movie Toolbox returns the duration of each sample in the media. This time value is expressed in the media's time scale. Set this parameter to 0 if you don't want this information.
sampleDescriptionH

A handle to a SampleDescription structure. GetMediaSampleReference returns the structure corresponding to the returned sample data. The function resizes this handle as appropriate. If you don't want the SampleDescription structure, set this parameter to NIL.
sampleDescriptionIndex

A pointer to a long integer. GetMediaSampleReference returns an index value to the SampleDescription structure that corresponds to the returned sample data. To retrieve the media sample description, pass this index in the descH parameter of GetMediaSampleDescription. If you don't want this information, set this parameter to NIL.
maxNumberOfSamples

The maximum number of samples to be returned. The Movie Toolbox does not return a reference that refers to more samples than you specify with this parameter. If you set this parameter to 0, the Movie Toolbox uses a value that is appropriate for the media and returns that value in the field referenced by the numberOfSamples parameter.
numberOfSamples

A pointer to a long integer. GetMediaSampleReference updates the field referred to by this parameter with the number of samples referred to by the returned reference. If you don't want this information, set this parameter to NIL.
sampleFlags

A pointer to a short integer in which GetMediaSampleReference returns flags (see below) that describe the samples referred to by the returned reference. Unused flags are set to 0. If you don't want this information, set this parameter to NIL. See these constants: 
mediaSampleNotSync
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaSampleReference (
   Media                      theMedia,
   long                       *dataOffset,
   long                       *size,
   TimeValue                  time,
   TimeValue                  *sampleTime,
   TimeValue                  *durationPerSample,
   SampleDescriptionHandle    sampleDescriptionH,
   long                       *sampleDescriptionIndex,
   long                       maxNumberOfSamples,
   long                       *numberOfSamples,
   short                      *sampleFlags ){};

/*AddMediaDataRef

Adds a data reference to a media.

OSErr AddMediaDataRef (
   Media     theMedia,
   short     *index,
   Handle    dataRef,
   OSType    dataRefType );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
index

A pointer to a short integer. The Movie Toolbox returns the index value that is assigned to the new data reference. Your application can use this index to identify the reference to other Movie Toolbox functions, such as GetMediaDataRef. If the Movie Toolbox cannot add the data reference to the media, it sets the returned index value to 0.
dataRef

The data reference. This parameter contains a handle to the information that identifies the file that contains this media's data. The type of information stored in that handle depends upon the value of the dataRefType parameter.
dataRefType

The type of data reference. If the data reference is an alias, you must set this parameter to rAliasType.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddMediaDataRef (
   Media     theMedia,
   short     *index,
   Handle    dataRef,
   OSType    dataRefType ){};

/*NewImageCodecMPDrawBandUPP

Allocates a Universal Procedure Pointer for the ImageCodecMPDrawBandProc callback.

ImageCodecMPDrawBandUPP NewImageCodecMPDrawBandUPP (
   ImageCodecMPDrawBandProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewImageCodecMPDrawBandProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/

ImageCodecMPDrawBandUPP NewImageCodecMPDrawBandUPP (
   ImageCodecMPDrawBandProcPtr    userRoutine ){};


/*ImageCodecGetBaseMPWorkFunction

Gets an image codec's ComponentMPWorkFunctionProc callback.

ComponentResult ImageCodecGetBaseMPWorkFunction (
   ComponentInstance             ci,
   ComponentMPWorkFunctionUPP    *workFunction,
   void                          **refCon,
   ImageCodecMPDrawBandUPP       drawProc,
   void                          *drawProcRefCon );
Parameters
ci

An image codec component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
workFunction

On return, a pointer to a ComponentMPWorkFunctionProc callback.
refCon

On return, a handle to the reference constant that is passed to the ComponentMPWorkFunctionProc callback.
drawProc

An ImageCodecMPDrawBandProc callback.
drawProcRefCon

A pointer to a reference constant that is passed to your ImageCodecMPDrawBandProc callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult ImageCodecGetBaseMPWorkFunction (
   ComponentInstance             ci,
   ComponentMPWorkFunctionUPP    *workFunction,
   void                          **refCon,
   ImageCodecMPDrawBandUPP       drawProc,
   void                          *drawProcRefCon ){};

/*SCDefaultPictFileSettings

Derives default compression settings for a Picture structure that is stored in a file.

ComponentResult SCDefaultPictFileSettings (
   ComponentInstance    ci,
   short                srcRef,
   short                motion );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
srcRef

A reference to the file to be analyzed.
motion

Specifies whether the image is part of a sequence. Set this parameter to TRUE if the image is part of a sequence; set it to FALSE if you are working with a single still image.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCDefaultPictFileSettings (
   ComponentInstance    ci,
   short                srcRef,
   short                motion ){};




/*SCSetTestImagePictFile

Sets the dialog box's test image from a Picture structure that is stored in a picture file.

ComponentResult SCSetTestImagePictFile (
   ComponentInstance    ci,
   short                testFileRef,
   Rect                 *testRect,
   short                testFlags );
Parameters
ci

Identifies your application's connection to a standard image-compression dialog component. You obtain this identifier from OpenDefaultComponent.
testFileRef

Identifies the file that contains the new test image. Your application is responsible for opening this file before calling this function. You must also close the file when you are done with it. You must clear the image or close your connection to the standard image-compression dialog component before you close the file. If the file contains a large image, the component may take some time to display the standard image-compression dialog box. In this case, the component displays the watch cursor while it loads the test image.
testRect

A pointer to a Rect structure. This rectangle specifies, in the coordinate system of the source image, the area of interest or point of interest in the test image. The area of interest defines a portion of the test image that is to be shown to the user in the dialog box. Use this parameter to direct the component to a specific portion of the test image. The component uses the value of the testFlags parameter to determine how it transforms large images before displaying them to the user.
testFlags

Constants (see below) that specify how the component is to display a test image that is larger than the test image portion of the dialog box. If you set this parameter to 0, the component uses a default method of its own choosing. In all cases, the component centers the area or point of interest in the test image portion of the dialog box, and then displays some part of the test image. See these constants: 
scPreferCropping
scPreferScaling
scPreferScalingAndCropping
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult SCSetTestImagePictFile (
   ComponentInstance    ci,
   short                testFileRef,
   Rect                 *testRect,
   short                testFlags ){};


/*MediaSetActive

Enables and disables media.

ComponentResult MediaSetActive (
   MediaHandler    mh,
   Boolean         enableMedia );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
enableMedia

A Boolean value that indicates whether your media is enabled or disabled. If this parameter is set to TRUE, your media is enabled; if the parameter is FALSE, your media is disabled.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your derived media handler should support this function if you perform your own scheduling or if your media handler uses significant amounts of temporary storage. If you are doing your own scheduling (that is, you have set the handlerNoScheduler flag to 1 in the flags parameter of the MediaSetHandlerCapabilities function), your media handler needs to keep account of the media's active state so that you can properly respond to Movie Toolbox requests. When your media is disabled, you may choose to dispose of temporary storage you have allocated, so that the storage is available to other programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetActive (
   MediaHandler    mh,
   Boolean         enableMedia ){};



/*MediaInitialize

Prepares a derived media handler component to provide access to its media.

ComponentResult MediaInitialize (
   MediaHandler              mh,
   GetMovieCompleteParams    *gmc );
Parameters
mh

The Toolbox's connection to your derived media handler. You can obtain this reference from GetMediaHandler.
gmc

A pointer to a GetMovieCompleteParams structure. You can obtain information about the current media from this structure. You should copy any values you need to save into your derived media handler's local data area. Because this data structure is owned by the Movie Toolbox, you do not need to worry about disposing of any of the data in it.
Return Value

See Error Codes. Returns noErr if there is no error. If you return an error, the Movie Toolbox disables the track that uses your media. In cases where your media has just been created, the Movie Toolbox immediately disposes of your media.
Discussion

This function gives your media handler an opportunity to get ready to support the Movie Toolbox. As part of these preparations, your derived media handler should report its capabilities to the base media handler by calling MediaSetHandlerCapabilities. You may choose to examine the data in the GetMovieCompleteParams structure; you may also save values from this structure. If you save references to structures (such as the matte pixel map), do not dispose of the memory associated with these structures. The Movie Toolbox owns these structures.

Note that the Movie Toolbox may call other functions supported by your media handler before it calls your MediaInitialize function. In particular, it may call your MediaGetMediaInfo and MediaPutMediaInfo functions. However, before the Movie Toolbox tries to do anything with the data in your media, it will call your MediaInitialize function. The Movie Toolbox loads the movie's data using functions that are supported by the base media handler; your media handler does not have to support those functions.
Special Considerations

All derived media handlers should support this function. In addition, if your media handler saves values from the GetMovieCompleteParams structure that may change, be sure to support the corresponding functions that allow the Movie Toolbox to report changes to your media handler. For example, if your handler saves the movie time scale from the movieScale field, you should also support the MediaSetMovieTimeScale function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaInitialize (
   MediaHandler              mh,
   GetMovieCompleteParams    *gmc ){};


/*MediaSetSoundLevelMeteringEnabled

Enables or disables sound level metering for a media handler.

ComponentResult MediaSetSoundLevelMeteringEnabled (
   MediaHandler    mh,
   Boolean         enable );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
enable

Pass TRUE to enable sound level metering, FALSE to disable it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundLevelMeteringEnabled (
   MediaHandler    mh,
   Boolean         enable ){};

/*MediaSetSoundEqualizerBands

Sets sound equalizer bands for a media handler.

ComponentResult MediaSetSoundEqualizerBands (
   MediaHandler                     mh,
   MediaEQSpectrumBandsRecordPtr    spectrumInfo );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
spectrumInfo

A pointer to a MediaEQSpectrumBandsRecord structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetSoundEqualizerBands (
   MediaHandler                     mh,
   MediaEQSpectrumBandsRecordPtr    spectrumInfo ){};


/*MediaDoIdleActions

Forces a media handler to perform its idle-time actions.

ComponentResult MediaDoIdleActions (
   MediaHandler    mh );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaDoIdleActions (
   MediaHandler    mh ){};

/*MediaGetSoundEqualizerBandLevels

Gets the sound equalizer band levels for a media handler.

ComponentResult MediaGetSoundEqualizerBandLevels (
   MediaHandler    mh,
   UInt8           *bandLevels );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
bandLevels

Undocumented
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaGetSoundEqualizerBandLevels (
   MediaHandler    mh,
   UInt8           *bandLevels ){};

/*GraphicsExportSetOutputHandle

Sets a handle to the output of a graphics export operation.

ComponentResult GraphicsExportSetOutputHandle (
   GraphicsExportComponent    ci,
   Handle                     h );
Parameters
ci

The component instance that identifies your connection to the graphics exporter component.
h

The output handle.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsExportSetOutputHandle (
   GraphicsExportComponent    ci,
   Handle                     h ){};

/*NewMovieProgressUPP

Allocates a Universal Procedure Pointer for the MovieProgressProc callback.

MovieProgressUPP NewMovieProgressUPP (
   MovieProgressProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewMovieProgressProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
MovieProgressUPP NewMovieProgressUPP (
   MovieProgressProcPtr    userRoutine ){};


/*MovieExportToDataRef

Allows an application to request that data be exported to a data reference instead of to a file.

ComponentResult MovieExportToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
dataRef

A handle to a data reference indicating where the data should be stored.
dataRefType

The type of the data reference. For exporting to a file, the dataRef is a Macintosh file alias and the dataRefType is rAliasType.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
onlyThisTrack

Identifies a track that is to be converted. This track identifier is supplied by the Movie Toolbox. If this parameter contains a track identifier, your component must convert only the specified track.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportToDataRef (
   MovieExportComponent    ci,
   Handle                  dataRef,
   OSType                  dataRefType,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration ){};

/*MovieExportSetProgressProc

Assigns a movie progress function.

ComponentResult MovieExportSetProgressProc (
   MovieExportComponent    ci,
   MovieProgressUPP        proc,
   long                    refcon );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
proc

A pointer to the application's MovieProgressProc callback. If this parameter is set to NIL, the application is removing its progress function. In this case, your component should stop calling the progress function.
refcon

A reference constant. Your component should pass this constant back to the application's progress function whenever you call that function. Use this parameter to point to a data structure containing any information the callback needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

These progress functions must support the same interface as Movie Toolbox progress functions. Note that this interface not only allows you to report progress to the application, but also allows the application to cancel the request.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportSetProgressProc (
   MovieExportComponent    ci,
   MovieProgressUPP        proc,
   long                    refcon ){};

/*DisposeMovieTrack

Removes a track from a movie.

void DisposeMovieTrack (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

The following code snippet illustrates the use of DisposeMovieTrack:// DisposeMovieTrack coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void DisposeMovieTrack (
   Track    theTrack ){};

/*DataHSetDataRef

Assigns a data reference to your data handler component.

ComponentResult DataHSetDataRef (
   DataHandler    dh,
   Handle         dataRef );
Parameters
dh

Identifies the calling program's connection to your data handler component.
dataRef

The data reference. This parameter contains a handle to the information that identifies the container in question. Different types of containers may require different types of data references. For example, a reference to a memory-based movie may be a handle, while a reference to a file-based movie may be an alias. For example, Apple's memory-based data handler for the Macintosh uses handles (and has a subtype value of 'hndl'), while the HFS data handler uses Alias Manager aliases (its subtype value is 'alis'). The client program is responsible for disposing of the handle, so your component must make a copy of it. See Data References.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows your application to assign your data handler's current data reference. All data handler components use data references to identify and locate a movie's container. Client programs can correlate data references with data handlers by matching the component's subtype value with the data reference type; the subtype value indicates the type of data reference the component supports. All data handlers with the same subtype value must support the same data reference type.
Special Considerations

Note that the type of data reference always corresponds to the type that your component supports, and that you specify in the component subtype value of your data handler. As a result, the client program does not provide a data reference type value (unlike the Movie Toolbox's data reference functions).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHSetDataRef (
   DataHandler    dh,
   Handle         dataRef ){};


/*GetMediaDataRefCount

Determines the number of data references in a media.

OSErr GetMediaDataRefCount (
   Media    theMedia,
   short    *count );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
count

A pointer to a field that is to receive the number of data references in the media.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaDataRefCount (
   Media    theMedia,
   short    *count ){};

/*DataHOpenForRead

Opens a data handler's current data reference for read-only access.

ComponentResult DataHOpenForRead (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After setting your component's current data reference by calling DataHSetDataRef, client programs call DataHOpenForRead to start reading from the data reference. Your component should open the data reference for read-only access. If the data reference is already open or cannot be opened, return an appropriate error code. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that the Movie Toolbox may try to read data from a data reference without calling your component's DataHOpenForRead function. If this happens, your component should open the data reference for read-only access, respond to the read request, and then leave the data reference open in anticipation of later read requests. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHOpenForRead (
   DataHandler    dh ){};


/*DataHCloseForWrite

Closes write-only access to its data reference.

ComponentResult DataHCloseForWrite (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Data handlers provide two distinct write facilities: DataHPutData is a simple synchronous interface that allows applications to append data to the end of a container, and DataHWrite is a more capable, asynchronous write function that is suitable for movie capture operations. Before writing data to a data reference, applications must call your component's DataHOpenForWrite function to open a write path to the container. DataHCloseForWrite closes that write path. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

A client program may close its connection to your component (by calling CloseComponent) without closing the write path. If this happens, your component should close the data reference before closing the connection. Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHCloseForWrite (
   DataHandler    dh ){};



/*DisposeDataHCompletionUPP

Disposes of a DataHCompletionUPP pointer.

void DisposeDataHCompletionUPP (
   DataHCompletionUPP    userUPP );
Parameters
userUPP

A DataHCompletionUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
void DisposeDataHCompletionUPP (
   DataHCompletionUPP    userUPP ){};



/*DataHCloseForRead

Closes read-only access to its data reference.

ComponentResult DataHCloseForRead (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Data handler components provide two basic read facilities: DataHGetData function is a fully synchronous read operation, while DataHScheduleData is asynchronous. Applications provide scheduling information when they call your component's DataHScheduleData function. When your component processes the queued request, it calls the application's data-handler completion function. Before any application can read data from a data reference, it must open read access to that reference by calling your component's DataHOpenForRead function. DataHCloseForRead closes that read access path.
Special Considerations

Note that a client program may close its connection to your component (by calling CloseComponent) without closing the read path. If this happens, your component should close the data reference before closing the connection.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHCloseForRead (
   DataHandler    dh ){};

/*DataHReadAsync

Undocumented

ComponentResult DataHReadAsync (
   DataHandler           dh,
   void                  *dataPtr,
   UInt32                dataSize,
   const wide            *dataOffset,
   DataHCompletionUPP    completion,
   long                  refCon );
Parameters
dh

A data handler component.
dataPtr

Undocumented
dataSize

Undocumented
dataOffset

Undocumented
completion

A pointer to a data-handler completion callback, described in DataHCompletionProc.
refCon

A reference constant to be passed to your callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 4.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHReadAsync (
   DataHandler           dh,
   void                  *dataPtr,
   UInt32                dataSize,
   const wide            *dataOffset,
   DataHCompletionUPP    completion,
   long                  refCon ){};



/*DataHGetFileSize

Returns the size, in bytes, of the current data reference.

ComponentResult DataHGetFileSize (
   DataHandler    dh,
   long           *fileSize );
Parameters
dh

Identifies the calling program's connection to your data handler component.
fileSize

A pointer to a long integer. Your component returns the size of the container corresponding to the current data reference, in bytes.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is operationally equivalent to the Mac OS File Manager's GetEOF function. Before writing data to a data reference, applications must call your component's DataHOpenForWrite function to open a write path to the container. DataHCloseForWrite closes that write path. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHGetFileSize (
   DataHandler    dh,
   long           *fileSize ){};

/*DataHOpenForWrite

Opens your component's current data reference for write-only access.

ComponentResult DataHOpenForWrite (
   DataHandler    dh );
Parameters
dh

Identifies the calling program's connection to your data handler component.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

After setting your component's current data reference by calling DataHSetDataRef, client programs call DataHOpenForWrite to start writing to the data reference. Your component should open the data reference for write-only access. If the data reference is already open or cannot be opened, return an appropriate error code. As is the case with DataHScheduleData, your component calls the application's data-handler completion function when you are done with the write request.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHOpenForWrite (
   DataHandler    dh ){};

/*NewDataHCompletionUPP

Allocates a Universal Procedure Pointer for the DataHCompletionProc callback.

DataHCompletionUPP NewDataHCompletionUPP (
   DataHCompletionProcPtr    userRoutine );
Parameters
userRoutine

A pointer to your application-defined function.
Return Value

A new UPP; see Universal Procedure Pointers.
Discussion

This function is used with Macintosh PowerPC systems. See Inside Macintosh: PowerPC System Software.
Version Notes

Introduced in QuickTime 4.1. Replaces NewDataHCompletionProc.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
DataHCompletionUPP NewDataHCompletionUPP (
   DataHCompletionProcPtr    userRoutine ){};

/*DataHWrite

Writes data to its current data reference.

ComponentResult DataHWrite (
   DataHandler           dh,
   Ptr                   data,
   long                  offset,
   long                  size,
   DataHCompletionUPP    completion,
   long                  refCon );
Parameters
dh

Identifies the calling program's connection to your data handler component.
data

Specifies a pointer to the data to be written. Client programs should lock the memory area holding this data, allowing your component's DataHWrite function to move memory.
offset

The offset (in bytes) to the location in the current data reference at which to write the data.
size

The number of bytes to write.
completion

A pointer to a data-handler completion function, described in DataHCompletionProc. The client program must provide a completion routine for all asynchronous write requests. For synchronous requests, client programs should set this parameter to NIL. When your data handler finishes with the client program's write request, your component must call this routine even if the request fails. Your component should pass the reference constant that the client program provided with the refCon parameter.
refCon

A reference constant that your data handler component should provide to the data-handler completion function specified with the completion parameter. For synchronous operations, client programs should set this parameter to 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function provides both a synchronous and an asynchronous write interface. Synchronous write operations work like the DataHPutData function; the data handler component returns control to the client program only after it has serviced the write request. Asynchronous write operations allow client programs to queue write requests. Your data handler queues the request and immediately returns control to the calling program. After your component actually writes the data, it calls the client program's data-handler completion function.
Special Considerations

Note that some data handlers may not support write operations. For example, some shared devices, such as a CD-ROM "jukebox," may be read-only devices. As a result, it is very important that your data handler correctly report its write capabilities to client programs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataHWrite (
   DataHandler           dh,
   Ptr                   data,
   long                  offset,
   long                  size,
   DataHCompletionUPP    completion,
   long                  refCon ){};


/*SetTrackDimensions

Establishes a track's source rectangle.

void SetTrackDimensions (
   Track    theTrack,
   Fixed    width,
   Fixed    height );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
width

A fixed-point number that specifies the width, in pixels, of the track's rectangle. This value corresponds to the x coordinate of the lower-right corner of the track's rectangle.
height

A fixed-point number that specifies the height, in pixels, of the track's rectangle. This value corresponds to the y coordinate of the lower-right corner of the track's rectangle.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

If you change the dimensions of an existing track, the media data is scaled to fit into the new rectangle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackDimensions (
   Track    theTrack,
   Fixed    width,
   Fixed    height ){};



/*TCGetDisplayOptions

Retrieves the text characteristics that apply to timecode information displayed in a movie.

HandlerError TCGetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
textOptions

A pointer to a TCTextOptions structure. This structure will receive font and style information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetDisplayOptions (
   MediaHandler        mh,
   TCTextOptionsPtr    textOptions ){};



/*TCSetSourceRef

Changes the source information in the timecode media sample reference.

HandlerError TCSetSourceRef (
   MediaHandler                 mh,
   TimeCodeDescriptionHandle    tcdH,
   UserData                     srefH );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
tcdH

Specifies a handle containing the timecode media sample reference that is to be updated.
srefH

Specifies a handle to the source information to be placed in the sample reference as a UserDataRecord structure. It is your application's responsibility to dispose of this structure when you are done with it.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCSetSourceRef (
   MediaHandler                 mh,
   TimeCodeDescriptionHandle    tcdH,
   UserData                     srefH ){};



/*TCTimeCodeToFrameNumber

Converts a timecode time value into its corresponding frame number.

HandlerError TCTimeCodeToFrameNumber (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   long              *frameNumber );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
tcdef

A pointer to the TimeCodeDef structure to use for the conversion.
tcrec

A pointer to the TimeCodeRecord structure containing the time value to convert.
frameNumber

A pointer to a field that is to receive the frame number that corresponds to the time value in the tcrec parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCTimeCodeToFrameNumber (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   long              *frameNumber ){};



/*TCSetTimeCodeFlags

Changes the flag that affects how the toolbox handles timecode information.

HandlerError TCSetTimeCodeFlags (
   MediaHandler    mh,
   long            flags,
   long            flagsMask );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
flags

The new flag value. See these constants: 
tcdfShowTimeCode
flagsMask

Specifies which of the flag values are to change. The media handler modifies only those flag values that correspond to bits that are set to 1 in this parameter. Use the flag values from the flags parameter. To turn off timecode display, set the tcdfShowTimeCode flag to 1 in the flagsMask parameter and to 0 in the flags parameter.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCSetTimeCodeFlags (
   MediaHandler    mh,
   long            flags,
   long            flagsMask ){};
/*TCTimeCodeToString

Converts a time value into a text string (HH:MM:SS:FF).

HandlerError TCTimeCodeToString (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   StringPtr         tcStr );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
tcdef

A pointer to the TimeCodeDef structure to use for the conversion.
tcrec

A pointer to the TimeCodeRecord structure to use for the conversion.
tcStr

A pointer to a text string that is to receive the converted time value.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

If the timecode uses the dropframe technique, the separators are semicolons (;) rather than colons (:).
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCTimeCodeToString (
   MediaHandler      mh,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec,
   StringPtr         tcStr ){};



/*SetTrackMatrix

Establishes a track's transformation matrix.

void SetTrackMatrix (
   Track                 theTrack,
   const MatrixRecord    *matrix );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
matrix

A pointer to a MatrixRecord structure that contains the track's new matrix. If you set this parameter to NIL, the Movie Toolbox uses the identity matrix.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTrackMatrix (
   Track                 theTrack,
   const MatrixRecord    *matrix ){};


/*ConvertTimeScale

Converts a time from one time scale into a time that is relative to another time scale.

void ConvertTimeScale (
   TimeRecord    *theTime,
   TimeScale     newScale );
Parameters
theTime

A pointer to a time structure that contains the time value to be converted. ConvertTimeScale replaces the contents of this time structure with the time value relative to the specified time scale.
newScale

The time scale for this operation.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

This function does not include the rate associated with the time value in the conversion; therefore, you should use this function when you want to convert time durations, but not when converting time values.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ConvertTimeScale (
   TimeRecord    *theTime,
   TimeScale     newScale ){};


/*TCFrameNumberToTimeCode

Converts a frame number into its corresponding timecode time value.

HandlerError TCFrameNumberToTimeCode (
   MediaHandler      mh,
   long              frameNumber,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
frameNumber

The frame number that is to be converted.
tcdef

A pointer to the TimeCodeDef structure to use for the conversion.
tcrec

A pointer to the TimeCodeRecord structure that is to receive the time value.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCFrameNumberToTimeCode (
   MediaHandler      mh,
   long              frameNumber,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcrec ){};

/*GetMediaNextInterestingTime

Searches for times of interest in a media.

void GetMediaNextInterestingTime (
   Media        theMedia,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration );
Parameters
theMedia

The media for this operation. Your application obtains this media identifier from such functions as NewTrackMedia and GetTrackMedia. See Media Identifiers.
interestingTimeFlags

Contains flags (see below) that determine the search criteria. Note that you may set only one of the nextTimeMediaSample, nextTimeMediaEdit or nextTimeSyncSample flags to 1. Set unused flags to 0. See these constants: 
nextTimeMediaSample
nextTimeMediaEdit
nextTimeSyncSample
nextTimeEdgeOK
time

Specifies a time value that establishes the starting point for the search. This time value must be expressed in the media's time scale.
rate

The search direction. Negative values cause the Movie Toolbox to search backward from the starting point specified in the time parameter. Other values cause a forward search.
interestingTime

A pointer to a time value. The Movie Toolbox returns the first time value it finds that meets the search criteria specified in the flags parameter. This time value is in the media's time scale. If there are no times that meet the search criteria you specify, the Movie Toolbox sets this value to -1. Set this parameter to NIL if you are not interested in this information.
interestingDuration

A pointer to a time value. The Movie Toolbox returns the duration of the interesting time. This time value is in the media's time coordinate system. Set this parameter to NIL if you don't want this information; this lets the function works faster.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Discussion

Some compression algorithms conserve space by eliminating duplication between consecutive frames in a sample. They do this by deriving frames from sync samples, which don't rely on preceding frames for content.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/

void GetMediaNextInterestingTime (
   Media        theMedia,
   short        interestingTimeFlags,
   TimeValue    time,
   Fixed        rate,
   TimeValue    *interestingTime,
   TimeValue    *interestingDuration ){};



/*TCGetTimeCodeAtTime

Returns a track's timecode information corresponding to a specific media time.

HandlerError TCGetTimeCodeAtTime (
   MediaHandler      mh,
   TimeValue         mediaTime,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcdata,
   UserData          *srcRefH );
Parameters
mh

The timecode media handler. You obtain this identifier by calling GetMediaHandler.
mediaTime

A time value for which you want to retrieve timecode information. This time value is expressed in the media's time coordinate system.
frameNum

A pointer to a field that is to receive the current frame number. Set this field to NIL if you don't want to retrieve the frame number.
tcdef

A pointer to a TimeCodeDef structure. The media handler returns the movie's timecode definition information. Set this parameter to NIL if you don't want this information.
tcdata

A pointer to a TimeCodeRecord structure. The media handler returns the current time value. Set this parameter to NIL if you don't want this information.
srcRefH

A pointer to a field that is to receive a handle containing the source information as a UserDataRecord structure. It is your responsibility to dispose of this structure when you are done with it. Set this field to NIL if you don't want this information.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
HandlerError TCGetTimeCodeAtTime (
   MediaHandler      mh,
   TimeValue         mediaTime,
   long              *frameNum,
   TimeCodeDef       *tcdef,
   TimeCodeRecord    *tcdata,
   UserData          *srcRefH ){};

/*MovieExportToFile

Exports data to a file, using a movie data export component.

ComponentResult MovieExportToFile (
   MovieExportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration );
Parameters
ci

A movie export component instance. Your software obtains this reference from OpenComponent or OpenDefaultComponent.
theFile

A pointer to the file that is to receive the converted movie data. This file's type value corresponds to your component's subtype value.
theMovie

The movie for this operation. This movie identifier is supplied by the Movie Toolbox. Your component may use this identifier to obtain sample data from the movie or to obtain information about the movie.
onlyThisTrack

Identifies a track that is to be converted. This track identifier is supplied by the Movie Toolbox. If this parameter contains a track identifier, your component must convert only the specified track.
startTime

The starting point of the track or movie segment to be converted. This time value is expressed in the movie's time coordinate system.
duration

The duration of the track or movie segment to be converted. This duration value is expressed in the movie's time coordinate system.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The requesting program or Movie Toolbox must create the destination file before calling this function. Furthermore, your component may not destroy any data in the destination file. If you cannot add data to the specified file, return an appropriate error. If your component can write data to a file, be sure to set the canMovieExportFiles flag in the componentFlags field of your component's ComponentDescription structure. Here is an example of using this function with a flattener component:// MovieExportToFile coding example
ComponentDescription desc;
Component flattener;
ComponentInstance qtvrExport =NIL;
desc.componentType =MovieExportType;
desc.componentSubType =MovieFileType;
desc.componentManufacturer =QTVRFlattenerType;
flattener =FindNextComponent(NIL, &desc);
if (flattener) qtvrExport =OpenComponent (flattener);
if (qtvrExport)
    MovieExportToFile (qtvrExport, &myFileSpec, myQTVRMovie, NIL, 0, 0);

Special Considerations

Your component must be prepared to perform this function at any time. You should not expect that any of your component's configuration functions will be called first.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult MovieExportToFile (
   MovieExportComponent    ci,
   const FSSpec            *theFile,
   Movie                   theMovie,
   Track                   onlyThisTrack,
   TimeValue               startTime,
   TimeValue               duration ){};

/*GetTrackID

Determines a track's unique track ID value.

long GetTrackID (
   Track    theTrack );
Parameters
theTrack

The track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
Return Value

The specified track's unique track ID value.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
long GetTrackID (
   Track    theTrack ){};


/*QTInsertChildren

Inserts a container of atoms as children of the specified parent atom.

OSErr QTInsertChildren (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomContainer    childrenContainer );
Parameters
container

The atom container that contains the parent atom. The atom container must not be locked.
parentAtom

The parent atom within the atom container.
childrenContainer

The atom container that contains the child atoms to be inserted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to insert a container of atoms as children of a parent atom in another atom container. Each child atom is inserted as the last atom of its type and is assigned a corresponding index. The ID of a child atom to be inserted must not duplicate that of an existing child atom of the same type. The following code shows how you can use this function to create a container, insert an atom, and insert another container as a child of the atom:// QTInsertChildren coding example
FailOSErr (QTInsertChild (outerContainer, kParentAtomIsContainer,
    kSpriteAtomType, spriteID, 0, 0, NIL, &newParentAtom));
FailOSErr (QTInsertChildren (outerContainer, newParentAtom,
    innerContainer));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTInsertChildren (
   QTAtomContainer    container,
   QTAtom             parentAtom,
   QTAtomContainer    childrenContainer ){};


/*DataCodecGetCompressBufferSize

Returns the maximum possible size of the compressed data that will be returned using the specified compressor component.

ComponentResult DataCodecGetCompressBufferSize (
   DataCodecComponent    dc,
   UInt32                srcSize,
   UInt32                *dstSize );
Parameters
dc

The compressor component to used.
srcSize

The size in bytes of the data being compressed.
dstSize

A pointer to the maximum size of the compressed data that will be returned.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

The actual size of the compressed data will likely be smaller than the size you initially have to allocate, so after you compress the data you should shrink the compressed data handle down to the actual data size. When compressing a movie, allocate an extra ten 32-bit integers of space to store the compressed movie resource header information, as shown in the following code sample:unsigned long compressedSize;
Handle compressedData;
DataCodecGetCompressBufferSize(dataCompressor, movieResourceSize, &compressedSize);
compressedData =NewHandle(compressedSize + (10 * sizeof(UInt32)));

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataCodecGetCompressBufferSize (
   DataCodecComponent    dc,
   UInt32                srcSize,
   UInt32                *dstSize ){};


/*DataCodecCompress

Compresses data using the specified compressor component.

ComponentResult DataCodecCompress (
   DataCodecComponent    dc,
   void                  *srcData,
   UInt32                srcSize,
   void                  *dstData,
   UInt32                dstBufferSize,
   UInt32                *actualDstSize,
   UInt32                *decompressSlop );
Parameters
dc

The compressor component to used.
srcData

A pointer to the data to be compressed.
srcSize

The size of the data to be compressed, in bytes.
dstData

A pointer to the buffer in which to store the compressed data.
dstBufferSize

The size of the buffer in which to store the compressed data, in bytes.
actualDstSize

The size of the compressed data that was created, in bytes.
decompressSlop

The number of bytes that should be added to the decompression buffer size if decompression occurs in place.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Before calling this function, you should call DataCodecGetCompressBufferSize to obtain the maximum possible size of the compressed data that will be returned. You can then use this value as the value of the dstBufferSize parameter. Note that a buffer for compressed data that is the same size as the uncompressed data may not be large enough: in some cases, the size of the compressed data can be larger than the size of the decompressed data. When you compress data, you should store the size of data before compression at the beginning of the file, immediately before the compressed data. This allows you to obtain the size of the decompressed data and allocate the buffer for storing the decompressed data before calling DataCodecDecompress.
Special Considerations

You can compress sprites by calling this function. If you do, you must include the uncompressed size of the sample at the beginning of the sample, before the compressed data, and store the component subtype of the data compressor used to compress the sprite in the decompressorType field of the sample's SpriteDescription structure. You can also compress QuickDraw 3D media samples by calling this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeComponents.h*/
ComponentResult DataCodecCompress (
   DataCodecComponent    dc,
   void                  *srcData,
   UInt32                srcSize,
   void                  *dstData,
   UInt32                dstBufferSize,
   UInt32                *actualDstSize,
   UInt32                *decompressSlop ){};


/*QTCopyAtomDataToHandle

Copies the specified leaf atom's data to a handle.

OSErr QTCopyAtomDataToHandle (
   QTAtomContainer    container,
   QTAtom             atom,
   Handle             targetHandle );
Parameters
container

The atom container that contains the leaf atom.
atom

The leaf atom whose data should be copied.
targetHandle

A handle. On return, the handle contains the atom's data. The handle must not be locked. This function resizes the handle, if necessary.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function, passing an initialized handle, to retrieve a copy of a leaf atom's data.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCopyAtomDataToHandle (
   QTAtomContainer    container,
   QTAtom             atom,
   Handle             targetHandle ){};

/*CDSequenceEquivalentImageDescription

Reports whether two image descriptions are the same.

OSErr CDSequenceEquivalentImageDescription (
   ImageSequence             seqID,
   ImageDescriptionHandle    newDesc,
   Boolean                   *equivalent );
Parameters
seqID

Contains the unique sequence identifier that was returned by the DecompressSequenceBegin function.
newDesc

A handle to the ImageDescription structure structure that describes the compressed image.
equivalent

A pointer to a Boolean value. If the ImageDescriptionHandle provided in the newDesc parameter is equivalent to the ImageDescription structure currently in use by the image sequence, this value is set to TRUE. If the ImageDescriptionHandle is not equivalent, and therefore a new image sequence must be created to display an image using the new image description, this value is set to FALSE.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function allows an application to ask whether two image descriptions are the same. If they are, the decompressor does not have to create a new image decompression sequence to display those images.
Special Considerations

The Image Compression Manager can only implement part of this function by itself. There are some fields in the ImageDescription structure that it knows are irrelevant to the decompressor. If the Image Compression Manager determines that there are differences in fields that may be significant to the codec, it calls the function ImageCodecIsImageDescriptionEquivalent to ask the codec.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceEquivalentImageDescription (
   ImageSequence             seqID,
   ImageDescriptionHandle    newDesc,
   Boolean                   *equivalent ){};

/*QTCopyAtom

Copies an atom and its children to a new atom container.

OSErr QTCopyAtom (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomContainer    *targetContainer );
Parameters
container

The atom container that contains the atom to be copied.
atom

The atom to be copied. To duplicate the entire container, pass a value of kParentAtomIsContainer for the atom parameter.
targetContainer

A pointer to an uninitialized atom container data structure. On return, this parameter points to an atom container that contains a copy of the atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The caller is responsible for disposing of the new atom container by calling QTDisposeAtomContainer.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTCopyAtom (
   QTAtomContainer    container,
   QTAtom             atom,
   QTAtomContainer    *targetContainer ){};

/*GetMediaPropertyAtom

Retrieves the property atom container of a media handler.

OSErr GetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    *propertyAtom );
Parameters
theMedia

A reference to the media handler for this operation.
propertyAtom

A pointer to a QT atom container. On return, the atom container contains the property atoms for the track associated with the media handler.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You can call GetMediaPropertyAtom to retrieve the properties of the track associated with the specified media handler. The contents of the returned QT atom container are defined by the media handler.
Special Considerations

The caller is responsible for disposing of the QT atom container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr GetMediaPropertyAtom (
   Media              theMedia,
   QTAtomContainer    *propertyAtom ){};

/*QTReplaceAtom

Replaces the contents of an atom and its children with a different atom and its children.

OSErr QTReplaceAtom (
   QTAtomContainer    targetContainer,
   QTAtom             targetAtom,
   QTAtomContainer    replacementContainer,
   QTAtom             replacementAtom );
Parameters
targetContainer

The atom container that contains the atom to be replaced. The atom container must not be locked.
targetAtom

The atom to be replaced.
replacementContainer

The atom container that contains the replacement atom.
replacementAtom

The replacement atom.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

The target atom and the replacement atom must be of the same type. The target atom maintains its original atom ID. This function does not modify the replacement container.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTReplaceAtom (
   QTAtomContainer    targetContainer,
   QTAtom             targetAtom,
   QTAtomContainer    replacementContainer,
   QTAtom             replacementAtom ){};


/*QTRemoveAtom

Removes an atom and its children from the specified atom container.

OSErr QTRemoveAtom (
   QTAtomContainer    container,
   QTAtom             atom );
Parameters
container

The atom container for this operation. The atom container must not be locked.
atom

The atom to be removed from the container.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You call this function to remove a particular atom and its children from an atom container. To remove all the atoms in an atom container, you should use QTRemoveChildren.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr QTRemoveAtom (
   QTAtomContainer    container,
   QTAtom             atom ){};

/*SetMoviePosterTime

Sets the poster time for the movie.

void SetMoviePosterTime (
   Movie        theMovie,
   TimeValue    posterTime );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
posterTime

The starting time for the movie frame that contains the poster image, expressed in the movie's time coordinate system.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Since a movie poster is a still frame, it is defined by a point in time within the movie. 
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetMoviePosterTime (
   Movie        theMovie,
   TimeValue    posterTime ){};

/*InsertMovieSegment

Copies part of one movie to another.

OSErr InsertMovieSegment (
   Movie        srcMovie,
   Movie        dstMovie,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn );
Parameters
srcMovie

The source movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle. This function obtains the movie segment from the source movie specified in this parameter.
dstMovie

The destination movie for this operation. The function places a copy of the segment, which it obtained from the source movie, into this destination movie.
srcIn

The start of the segment in the source movie. This time value must be expressed in the source movie's time scale.
srcDuration

The duration of the segment in the source movie. This time value must be expressed in the source movie's time scale.
dstIn

A time value specifying where the segment is to be inserted. This time value must be expressed in the destination movie's time scale.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

If you are not copying data from one location in a movie to a different point in the same movie, this function may create new tracks, as appropriate. Before adding a track to the destination movie, the Movie Toolbox looks in the destination movie for tracks that have the same characteristics as the tracks in the source movie. The toolbox considers several characteristics when searching for an appropriate track, including track spatial dimensions, track matrix, track clipping region, track matte, alternate group affiliation, media time scale, media type, media language, and data reference (that is, referring to the same file). If the Movie Toolbox cannot find an appropriate track in the destination movie, it creates a new track with the proper characteristics.
Special Considerations

If you have assigned a progress function to the destination movie, the Movie Toolbox calls that progress function during long copy operations. Some Movie Toolbox functions can take a long time to execute. For example, if you call FlattenMovie and specify a large movie, the Movie Toolbox must read and write all the sample data for the movie. During such operations you may wish to display some kind of progress indicator to the user.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr InsertMovieSegment (
   Movie        srcMovie,
   Movie        dstMovie,
   TimeValue    srcIn,
   TimeValue    srcDuration,
   TimeValue    dstIn ){};

/*AddEmptyTrackToMovie

Duplicates a track from a movie into the same movie or into another movie.

OSErr AddEmptyTrackToMovie (
   Track     srcTrack,
   Movie     dstMovie,
   Handle    dataRef,
   OSType    dataRefType,
   Track     *dstTrack );
Parameters
srcTrack

The source track for this operation. Your application obtains this track identifier from such functions as NewMovieTrack and GetMovieTrack.
dstMovie

The destination movie for this operation. This can be the same movie as the source track or a different movie.
dataRef

A handle to the data reference. The type of information stored in the handle depends upon the data reference type specified by dataRefType.
dataRefType

The type of data reference; see Data References. If the data reference is an alias, you must set the parameter to rAliasType, indicating that the reference is an alias.
dstTrack

The newly created track's identifier is returned in this parameter. If AddEmptyTrackToMovie fails, the resulting track identifier is set to NIL.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

This function returns a newly created, empty track. The newly created track has the same media type and track settings as the specified track. However, no data is copied from the source track to the new track. To copy data from the source track to the new track, use InsertTrackSegment after calling AddEmptyTrackToMovie.
Version Notes

This function has been available since QuickTime 2.0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr AddEmptyTrackToMovie (
   Track     srcTrack,
   Movie     dstMovie,
   Handle    dataRef,
   OSType    dataRefType,
   Track     *dstTrack ){};



/*MediaSetHandlerCapabilities

Lets a derived media handler report its capabilities to the base media handler.

ComponentResult MediaSetHandlerCapabilities (
   MediaHandler    mh,
   long            flags,
   long            flagsMask );
Parameters
mh

A media handler. You can obtain this reference from GetMediaHandler.
flags

Flags (see below) that specify the capabilities of your derived media handler. This parameter contains a number of flags, each of which corresponds to a particular feature. You may work with more than one flag at a time. Be sure to set unused flags to 0. See these constants: 
handlerHasSpatial
handlerCanClip
handlerCanMatte
handlerCanTransferMode
handlerNeedsBuffer
handlerNoIdle
handlerNoScheduler
handlerWantsTime
handlerCGrafPortOnly
flagsMask

Indicates which flags in the flags parameter are to be considered in this operation. For each bit in the flags parameter that you want the base media handler to consider, you must set the corresponding bit in the flagsMask parameter to 1. Set unused flags to 0. This allows you to work with a single flag without altering the settings of other flags.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

Your media handler may call this function at any time. In general, you should call it from your MediaInitialize function , so that you report your capabilities to the base media handler before the Movie Toolbox starts working with your media. You may call this function again later, in response to changing conditions. For example, if your media handler receives a matrix that it cannot accommodate from the MediaSetMatrix function, you can allow the base media handler to handle your drawing by calling this function and setting the handlerNeedsBuffer flag in both the flags parameter and the flagsMask parameter to 1.
Special Considerations

Note that this function is provided by the base media handler; your media handler does not support this function.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MediaHandlers.h*/
ComponentResult MediaSetHandlerCapabilities (
   MediaHandler    mh,
   long            flags,
   long            flagsMask ){};

/*EqualMatrix

Compares two matrices and returns a result that indicates whether the matrices are equal.

Boolean EqualMatrix (
   const MatrixRecord    *m1,
   const MatrixRecord    *m2 );
Parameters
m1

A pointer to one matrix for the compare operation.
m2

A pointer to the other matrix for the compare operation.
Return Value

TRUE if the matrices are equal, FALSE otherwise.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
Boolean EqualMatrix (
   const MatrixRecord    *m1,
   const MatrixRecord    *m2 ){};


/*DisposeMovieProgressUPP

Disposes of a MovieProgressUPP pointer.

void DisposeMovieProgressUPP (
   MovieProgressUPP    userUPP );
Parameters
userUPP

A MovieProgressUPP pointer. See Universal Procedure Pointers.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 4.1.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void DisposeMovieProgressUPP (
   MovieProgressUPP    userUPP ){};


/*GraphicsImportExportImageFile

Saves an imported image in a foreign file format.

ComponentResult GraphicsImportExportImageFile (
   GraphicsImportComponent    ci,
   OSType                     fileType,
   OSType                     fileCreator,
   const FSSpec               *fss,
   ScriptCode                 scriptTag );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
fileType

The file type for the new image file, such as 'JPEG'. See File Types and Creators.
fileCreator

The file creator for the new image file. See File Types and Creators. You may pass 0, in which case a default file creator for this file type is used.
fss

A pointer to the FSSpec structure that identifies the file that is to receive the exported image.
scriptTag

The script system in which the file name is to be displayed; see Localization Codes. If you have established the name and location of the file using one of the Standard File Package functions, use the script code returned in the reply record (reply.sfScript). Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript. See Inside Macintosh: Files for more information about script specifications.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates a new file containing the image currently in use by the graphics import component. The new file is compressed in a format corresponding to the provided file type. If a non-identity matrix has been applied to the graphics import component, this matrix is applied to the image before export. Since most image formats don't support nonzero top-left coordinates, the matrix is temporarily adjusted to ensure that the exported image's bounds have top-left coordinates at (0,0). If the matrix does not map the graphics import component's source rectangle to a rectangle, there will be extra white space left around the image.
Special Considerations

Graphics import components can save data in several formats, including QuickDraw pictures and QuickTime Image files. This capability is only needed by applications that perform file format translation. Applications that only wish to draw the image can use GraphicsImportDraw.
Version Notes

In QuickTime 3, the supported export file types are kQTFileTypePicture, kQTFileTypeQuickTimeImage, kQTFileTypeBMP, kQTFileTypeJPEG, and kQTFileTypePhotoShop. QuickTime 4 uses graphics exporter components to implement image export.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportExportImageFile (
   GraphicsImportComponent    ci,
   OSType                     fileType,
   OSType                     fileCreator,
   const FSSpec               *fss,
   ScriptCode                 scriptTag ){};

/*GraphicsImportGetExportImageTypeList

Returns information about available export formats for a graphics importer.

ComponentResult GraphicsImportGetExportImageTypeList (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr );
Parameters
ci

The component instance that identifies your connection to the graphics importer component.
qtAtomContainerPtr

A pointer to a QuickTime atom container that is to receive the type list.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function creates and returns a QuickTime atom container of type 'expo' containing information about the file types that can be exported by the graphics import component. For each file type, the atom container contains the following child atoms: 'ftyp', the exported file type; 'mime'[atom], the MIME type for this format (optional); 'ext ', the suggested file extension for this format; and 'desc', a human-readable name for this format. The 'ftyp' atom contains an OSType; the other atoms contain nonterminated strings.
Special Considerations

It is the responsibility of the caller to dispose of the 'expo' atom container.
Version Notes

In QuickTime 3, the supported export file types are kQTFileTypePicture, kQTFileTypeQuickTimeImage, kQTFileTypeBMP, kQTFileTypeJPEG, and kQTFileTypePhotoShop. In QuickTime 4, the generic graphics importer builds this atom container from the values returned by the installed graphics exporter components.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
ComponentResult GraphicsImportGetExportImageTypeList (
   GraphicsImportComponent    ci,
   void                       *qtAtomContainerPtr ){};

/*PlayMoviePreview

Plays a movie's preview.

void PlayMoviePreview (
   Movie                     theMovie,
   MoviePreviewCallOutUPP    callOutProc,
   long                      refcon );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
callOutProc

A pointer to a MoviePreviewCallOutProc callback in your application. The Movie Toolbox calls this function repeatedly while the movie preview is playing. You can use this function to stop the preview. If you don't want to assign a function, set this parameter to NIL.
refcon

A reference constant that the Movie Toolbox passes to your callback. Use this parameter to point to a data structure containing any information your callback needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

This function sets the movie into preview mode, plays the movie preview, sets the movie back to normal playback mode, and returns to your application. The Movie Toolbox plays the preview in the movie's graphics world. Note that if you call the GetMovieActiveSegment function from within your movie callout function, the Movie Toolbox will have changed the active movie segment to be the preview segment of the movie. The Movie Toolbox restores the active segment when the preview is done playing.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void PlayMoviePreview (
   Movie                     theMovie,
   MoviePreviewCallOutUPP    callOutProc,
   long                      refcon ){};


/*ShowMovieInformation

Displays a movie's information.

void ShowMovieInformation (
   Movie             theMovie,
   ModalFilterUPP    filterProc,
   long              refCon );
Parameters
theMovie

A movie identifier. Your application obtains this identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
filterProc

A Universal Procedure Pointer that accesses a ModalFilterProc callback.
refCon

A reference constant to be passed to your filter callback. Use this parameter to point to a data structure containing any information your function needs.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void ShowMovieInformation (
   Movie             theMovie,
   ModalFilterUPP    filterProc,
   long              refCon ){};

/*GetMovieSelection

Returns information about a movie's current selection.

void GetMovieSelection (
   Movie        theMovie,
   TimeValue    *selectionTime,
   TimeValue    *selectionDuration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
selectionTime

A pointer to a time value. The GetMovieSelection function places the starting time of the current selection into the field referred to by this parameter. Set this parameter to NIL if you don't want this information.
selectionDuration

A pointer to a time value. The GetMovieSelection function places the duration of the current selection into the field referred to by this parameter. Set this parameter to NIL if you don't want this information.
Return Value

You can access this function's error returns through GetMoviesError and GetMoviesStickyError.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void GetMovieSelection (
   Movie        theMovie,
   TimeValue    *selectionTime,
   TimeValue    *selectionDuration ){};

/*NAPlayNote

Plays a note with a specified pitch and velocity on the specified note channel.

ComponentResult NAPlayNote (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             pitch,
   long             velocity );
Parameters
na

You obtain the note allocator identifier from OpenComponent.
noteChannel

The note channel to play the note. You obtain the note channel identifier from the NANewNoteChannel or the NANewNoteChannelFromAtomicInstrument function.
pitch

The pitch at which to play the note. You can specify values as integer pitch values (0-127 where 60 is middle C) or fractional pitch values (256 (0x1.00) through 32767 (0x7F.FF)). If the pitch is a number from 0 to 127, then it is the MIDI pitch, where 60 is middle C. If the pitch is a positive number above 65535, then the value is a fixed-point pitch value. Thus, microtonal values can be specified. Negative values are not defined and should not be used.
velocity

The velocity with which the key is struck. Typically, this translates directly to volume, but on many synthesizers this also subtly alters the timbre of the tone. A value of 0 is silence; a value of 127 is maximum force.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NAPlayNote (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             pitch,
   long             velocity ){};


/*NAStuffToneDescription

Initializes a tone description structure with the details of a General MIDI note channel.

ComponentResult NAStuffToneDescription (
   NoteAllocator      na,
   long               gmNumber,
   ToneDescription    *td );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
gmNumber

A General MIDI instrument number.
td

On return, an initialized tone description. The instrument name field will be filled in with the string name for the instrument.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NAStuffToneDescription (
   NoteAllocator      na,
   long               gmNumber,
   ToneDescription    *td ){};

/*NANewNoteChannelFromAtomicInstrument

Requests a new note channel for an atomic instrument.

ComponentResult NANewNoteChannelFromAtomicInstrument (
   NoteAllocator          na,
   AtomicInstrumentPtr    instrument,
   long                   flags,
   NoteChannel            *outChannel );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
instrument

A pointer to the atomic instrument. This may be a dereferenced locked QT atom container.
flags

Flags (see below) that specify details of initializing a part with an atomic instrument. See these constants: 
kSetAtomicInstKeepOriginalInstrument
kSetAtomicInstShareAcrossParts
kSetAtomicInstCallerTosses
kSetAtomicInstDontPreprocess
outChannel

On return, a pointer to an identifier for a new note channel or NIL if the function fails to create a note channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function takes a note allocator identifier in the na parameter and a pointer to the atomic instrument you are requesting a new channel for in the instrument parameter. Among other things, you can specify how to handle the expanded sample with the flags parameter. The function returns the note channel allocated for the instrument in the outChannel parameter, or NIL if an error occurs.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NANewNoteChannelFromAtomicInstrument (
   NoteAllocator          na,
   AtomicInstrumentPtr    instrument,
   long                   flags,
   NoteChannel            *outChannel ){};


/*NANewNoteChannel

Requests a new note channel with the qualities described in a NoteRequest structure.

ComponentResult NANewNoteChannel (
   NoteAllocator    na,
   NoteRequest      *noteRequest,
   NoteChannel      *outCh
annel );
Parameters
na

You obtain the note allocator identifier from the Component Manager's OpenComponent function.
noteRequest

A pointer to a NoteRequest structure.
outChannel

On return, a pointer to an identifier for a new note channel or NIL if the function fails to create a note channel.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function searches all available music components for the instrument that best matches the specifications in the ToneDescription structure that is contained within the noteRequest parameter. If an error occurs, the new note channel is initialized to NIL. The caller can request an instrument that is not currently allocated to a part. In that case, this function may return a value in outChannel, even though the request cannot initially be satisfied. The note channel may become valid at a later time, as other note channels are released or other music components are registered.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NANewNoteChannel (
   NoteAllocator    na,
   NoteRequest      *noteRequest,
   NoteChannel      *outChannel ){};


/*NADisposeNoteChannel

Deletes a specified note channel.

ComponentResult NADisposeNoteChannel (
   NoteAllocator    na,
   NoteChannel      noteChannel );
Parameters
na

You obtain the note allocator identifier by calling OpenComponent.
noteChannel

Note channel to be disposed. You obtain the note channel identifier from NANewNoteChannel or NANewNoteChannelFromAtomicInstrument.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NADisposeNoteChannel (
   NoteAllocator    na,
   NoteChannel      noteChannel ){};



/*NAPickInstrument

Presents a user interface for picking an instrument.

ComponentResult NAPickInstrument (
   NoteAllocator      na,
   ModalFilterUPP     filterProc,
   StringPtr          prompt,
   ToneDescription    *sd,
   unsigned long      flags,
   long               refCon,
   long               reserved1,
   long               reserved2 );
Parameters
na

You obtain the note allocator identifier by calling OpenComponent.
filterProc

Pointer to a ModalFilterProc callback.
prompt

A pointer to the dialog box prompt "New Instrument".
sd

On entry, the tone description of the instrument that appears in the picker dialog box. On return, a tone description of the instrument the user selected.
flags

Flags (see below) that determine whether to display the picker dialog box and what instruments appear for selection. If the kPickDontMix flag is set, the dialog box does not display a mix of synthesizer part types. For example, if the current instrument is a drum, only available drums appear in the dialog box. The kPickSameSynth flag allows selections only within the current synthesizer. The kPickUserInsts flag allows user modifiable instruments to appear. The kPickEditAllowPick flag is used only with NAPickEditInstrument. See these constants: 
kPickDontMix
kPickSameSynth
kPickUserInsts
refCon

A reference constant value. The Movie Toolbox passes this reference constant to your ModalFilterProc callback each time it calls it. Use this parameter to point to a data structure containing any information your callback needs.
reserved1

Must contain 0.
reserved2

Must contain 0.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NAPickInstrument (
   NoteAllocator      na,
   ModalFilterUPP     filterProc,
   StringPtr          prompt,
   ToneDescription    *sd,
   unsigned long      flags,
   long               refCon,
   long               reserved1,
   long               reserved2 ){};


/*NASetController

Changes the controller setting on a note channel to a specified value.

ComponentResult NASetController (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             controllerNumber,
   long             controllerValue );
Parameters
na

You obtain the note allocator identifier by calling OpenComponent.
noteChannel

Note channel on which to change controller. You obtain the note channel identifier from NANewNoteChannel or NANewNoteChannelFromAtomicInstrument.
controllerNumber

The controller to set; see Music Controllers.
controllerValue

Value for controller setting; typically 0 (0x00.00) to 32767 (0x7F.FF).
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult NASetController (
   NoteAllocator    na,
   NoteChannel      noteChannel,
   long             controllerNumber,
   long             controllerValue ){};


/*TuneGetStatus

Returns an initialized structure describing the state of the tune player instance.

ComponentResult TuneGetStatus (
   TunePlayer    tp,
   TuneStatus    *status );
Parameters
tp

A tune player identifier, obtained from OpenComponent or OpenDefaultComponent.
status

A pointer to an initialized TuneStatus structure.
Return Value

See Error Codes. Returns noErr if there is no error.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/
ComponentResult TuneGetStatus (
   TunePlayer    tp,
   TuneStatus    *status ){};



/*TuneSetHeader

Prepares the tune player to accept subsequent music event sequences by defining one or more parts to be used by sequence Note events.

ComponentResult TuneSetHeader (
   TunePlayer       tp,
   unsigned long    *header );
Parameters
tp

A tune player identifier, obtained from OpenComponent or OpenDefaultComponent.
header

A pointer to a list of instruments that will be used in subsequent calls to the TuneQueue function. The list can include events with subtypes of kGeneralEventNoteRequest, kGeneralEventPartKey, kGeneralEventAtomicInstrument, kGeneralEventMIDIChannel, and kGeneralEventUsedNotes. It can also include atomic instruments. The list is terminated by a marker event of subtype kMarkerEventEnd. See QTMA Events.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function is the first QuickTime music architecture call to play a music sequence. The header parameter points to one or more initialized General events and atomic instruments. Only one call to this function is required. Each call to this function resets the tune player.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
QuickTimeMusic.h*/

ComponentResult TuneSetHeader (
   TunePlayer       tp,
   unsigned long    *header ){};







/*CDSequenceSetTimeBase

Sets a time base for a decompression sequence.

OSErr CDSequenceSetTimeBase (
   ImageSequence    seqID,
   void             *base );
Parameters
seqID

A unique sequence identifier that was returned by CompressSequenceBegin.
base

A pointer to the time base for this operation. Your application obtains this time base identifier from NewTimeBase.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

When you run a visual effect outside a movie, you must designate a time base that will be used when the effect is run. The following code illustrates this use of CDSequenceSetTimeBase:// CDSequenceSetTimeBase coding example
// See "Discovering QuickTime," page 310
timeBase =NewTimeBase();
SetTimeBaseRate(timeBase, 0);
CDSequenceSetTimeBase(gEffectSequenceID, timeBase);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCompression.h*/
OSErr CDSequenceSetTimeBase (
   ImageSequence    seqID,
   void             *base ){};

/*SetTimeBaseRate

Sets the rate of a time base.

void SetTimeBaseRate (
   TimeBase    tb,
   Fixed       r );
Parameters
tb

The time base for this operation. Your application obtains this time base identifier from NewTimeBase.
r

The rate of the time base.
Return Value

You can access error returns from this function through GetMoviesError and GetMoviesStickyError. See Error Codes.
Discussion

Rates may be set to negative values. Negative rates cause time to move backward for the time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
void SetTimeBaseRate (
   TimeBase    tb,
   Fixed       r ){};

/*NewTimeBase

Obtains a new time base.

TimeBase NewTimeBase ( void );
Return Value

The ID of the new time base.
Discussion

This function sets the rate of the time base to 0, the start time to its minimum value, the time value to 0, and the stop time to its maximum value. The function assigns the default clock component to the new time base.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
TimeBase NewTimeBase ( void ){};

/*DeleteMovieSegment

Removes a specified segment from a movie.

OSErr DeleteMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    duration );
Parameters
theMovie

The movie for this operation. Your application obtains this movie identifier from such functions as NewMovie, NewMovieFromFile, and NewMovieFromHandle.
startTime

A time value specifying the starting point of the segment to be deleted.
duration

A time value that specifies the duration of the segment to be deleted.
Return Value

You can access Movie Toolbox error returns through GetMoviesError and GetMoviesStickyError, as well as in the function result. See Error Codes.
Discussion

You identify the segment to remove by specifying its starting time and duration. The following code snippet shows DeleteMovieSegment being used while adding a modifier track to a movie.// DeleteMovieSegment coding example
// See "Discovering QuickTime," page 363
Movie           movie1;
TimeValue       lOldDuration;
Movie           movie2;
long            lIndex, lOrigTrackCount, lReferenceIndex;
Track           track, trackSprite;
// get the first track in original movie and position at the start
trackSprite =GetMovieIndTrack(movie1, 1);
SetMovieSelection(movie1, 0, 0);
// remove all tracks except video in modifier movie
for (lIndex =1; lIndex <=GetMovieTrackCount(movie2); lIndex++) {
    Track       track =GetMovieIndTrack(movie2, lIndex);
    OSType      dwType;
    GetMediaHandlerDescription(GetTrackMedia(track),
                                &dwType, NIL, NIL);
    if (dwType !=VideoMediaType) {
        DisposeMovieTrack(track);
        lIndex--;
    }
}
// add the modifier track to original movie
lOldDuration =GetMovieDuration(movie1);
AddMovieSelection(movie1, movie2);
DisposeMovie(movie2);
// truncate the movie to the length of the original track
DeleteMovieSegment(movie1, lOldDuration,
                    GetMovieDuration(movie1) - lOldDuration);
// associate the modifier track with the original sprite track
track =GetMovieIndTrack(movie1, lOrigTrackCount + 1);
AddTrackReference(trackSprite, track, kTrackModifierReference,
                    &lReferenceIndex);

Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Movies.h*/
OSErr DeleteMovieSegment (
   Movie        theMovie,
   TimeValue    startTime,
   TimeValue    duration ){};




/*CurveAddAtomToVectorStream

Adds an atom to a vector data stream.

ComponentResult CurveAddAtomToVectorStream (
   ComponentInstance    effect,
   OSType               atomType,
   Size                 atomSize,
   void                 *pAtomData,
   Handle               vectorStream );
Parameters
effect

The instance of the QuickTime vector codec component for the request. Your software obtains this reference when calling the Component Manager's OpenComponent or OpenDefaultComponent function.
atomType

The type of atom to add to the vector data stream.
atomSize

The size of the data for the atom.
pAtomData

A pointer to the data for the atom.
vectorStream

A handle to the vector data stream to which to add the atom.
Return Value

See Error Codes. Returns noErr if there is no error.
Discussion

This function adds the atom to the end of the specified vector data stream and resizes the vector data stream handle.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ImageCodec.h*/
ComponentResult CurveAddAtomToVectorStream (
   ComponentInstance    effect,
   OSType               atomType,
   Size                 atomSize,
   void                 *pAtomData,
   Handle               vectorStream ){};



/*Data Types and Constants

All of the new data types and constants in this header file are listed alphabetically, with links to documentation and abstracts, if available.ICMCompressionFrameOptionsRef	
ICMCompressionPassModeFlags	
ICMCompressionSessionOptionsRef	
ICMCompressionSessionRef	
ICMCompressorSessionRef	
ICMCompressorSourceFrameRef	
ICMDataRateLimit	
ICMDecompressionFrameOptionsRef	
ICMDecompressionSessionOptionsRef	
ICMDecompressionSessionRef	
ICMDecompressionTrackingCallback	
ICMDecompressionTrackingCallbackRecord	
ICMDecompressionTrackingFlags	
ICMEncodedFrameOutputCallback	
ICMEncodedFrameOutputRecord	
ICMEncodedFrameRef	
ICMFieldMode	
ICMFrameType	
ICMMultiPassCopyDataAtTimeStampCallback	
ICMMultiPassGetTimeStampCallback	
ICMMultiPassReleaseCallback	
ICMMultiPassSetDataAtTimeStampCallback	
ICMMultiPassStorageCallbacks	
ICMMultiPassStorageCreationFlags	
ICMMultiPassStorageRef	
ICMMultiPassStorageStep	
ICMMutableEncodedFrameRef	
ICMNonScheduledDisplayTime	
ICMSourceTrackingCallback	
ICMSourceTrackingCallbackRecord	
ICMSourceTrackingFlags	
ICMValidTimeFlags	
MediaSampleFlags	
QTVisualContextImageAvailableCallback	
QTVisualContextRef	
codecCompletionDecoded	Codec has decoded this frame; if it is cancelled and rescheduled, set icmFrameAlreadyDecoded in ICMFrameTimeRecord.flags.
codecCompletionNotDisplayable	The frame may still be scheduled for decode, but will not be able to be displayed because the buffer containing it will need to be recycled to display earlier frames..
codecCompletionNotDrawn	Set in conjunction with codecCompletionDest to indicate that the frame was not drawn.
codecInfoDoesMultiPass	Codec can perform multi-pass compression.
codecInfoDoesReorder	Codec can rearrange frames during compression.
icmFrameAlreadyDecoded	
icmFrameTimeDecodeImmediately	
icmFrameTimeDoNotDisplay	
icmFrameTimeHasDecodeTime	Indicates that decodeTime is valid.
icmFrameTimeIsNonScheduledDisplayTime	
kDVCPROHD1080i50CodecType	
kDVCPROHD1080i60CodecType	
kDVCPROHD720pCodecType	
kH264CodecType	
kICMCompressionFrameOptionsPropertyID_-
ForceKeyFrame	Boolean, ReadWrite.
kICMCompressionFrameOptionsPropertyID_FrameType	ICMFrameType, ReadWrite.
kICMCompressionPassMode_NoSourceFrames	
kICMCompressionPassMode_-
NotReadyToOutputEncodedFrames	
kICMCompressionPassMode_OutputEncodedFrames	
kICMCompressionPassMode_ReadFromMultiPassStorage	
kICMCompressionPassMode_WriteToMultiPassStorage	
kICMCompressionSessionOptionsPropertyID_-
AllowAsyncCompletion	Enables the compressor to call the encoded-frame callback from a different thread. By default this option is FALSE, which means that the compressor must call the encoded-frame callback from the same thread as ICMCompressionSessionEncodeFrame and ICMCompressionSession-
CompleteFrames. Also 'asok'.
kICMCompressionSessionOptionsPropertyID_-
AllowFrameReordering	Enables frame reordering. To encode B-frames a compressor must reorder frames, which may mean that the order in which they are emitted and stored (the decode order) may be different from the order in which they are presented to the compressor (the display order). By default, frame reordering is disabled. To encode using B-frames, you must enable frame reordering by passing TRUE in this property. Also 'b ok'.
kICMCompressionSessionOptionsPropertyID_-
AllowFrameTimeChanges	Enables the compressor to modify frame times, improving its performance. Some compressors are able to identify and coalesce runs of identical frames and emit single frames with longer duration, or emit frames at a different frame rate from the original. By default, this flag is set to FALSE, which forces the compressor to emit one encoded frame for every source frame and to preserve frame display times. This option replaces the practice of having compressors return special high similarity values to indicate that frames can be dropped. Also '+ ok'.
kICMCompressionSessionOptionsPropertyID_-
AllowTemporalCompression	Enables temporal compression of P-frames and B-frames. By default, temporal compression is disabled. Also 'p ok'.
kICMCompressionSessionOptionsPropertyID_-
AverageDataRate	The long-term desired average data rate in bytes per second. This is not an absolute limit. The default data rate is zero, indicating that the setting of kICMCompressionSessionOptionsPropertyID_-
Quality should determine the size of compressed data. Data rate settings have effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'aver'.
kICMCompressionSessionOptionsPropertyID_-
CPUTimeBudget	UInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
CleanAperture	Native-endian CleanApertureImageDescription-
Extension, ReadWrite.
kICMCompressionSessionOptionsPropertyID_ColorTable	The color table for compression, used with indexed-color depths. Clients who are passed this property are responsible for disposing the returned CTabHandle. Also 'clut'.
kICMCompressionSessionOptionsPropertyID_-
CompressorComponent	Sets a specific compressor component or component instance to be used, or passes one of the wildcards anyCodec, bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. Pass this option to force the Image Compression Manager to use a specific compressor component or compressor component instance. To allow the Image Compression Manager to choose the compressor component, set the compressorComponent to anyCodec (the default), bestSpeedCodec, bestFidelityCodec, or bestCompressionCodec. If you pass in a component instance that you opened, the ICM will not close that instance; you must do so after the compression session is released. Also 'imco'.
kICMCompressionSessionOptionsPropertyID_-
CompressorSettings	A handle containing compressor settings. The compressor will be configured with these settings (by a call to ImageCodecSetSettings) during the ICMCompressionSessionCreate process. Also 'cost'.
kICMCompressionSessionOptionsPropertyID_-
DataRateLimitCount	UInt32, Read.
kICMCompressionSessionOptionsPropertyID_-
DataRateLimits	Zero, one, or two hard limits on data rate. Each hard limit is described by a data size in bytes and a duration in seconds. It requires that the total size of compressed data for any contiguous segment of that duration (in decode time) must not exceed the data size. By default, no data rate limits are set. When setting this property, the inPropValueSize parameter should be the number of data rate limits multiplied by sizeof(ICMDataRateLimit). Data rate settings have an effect only when timing information is provided for source frames. Some codecs do not accept limiting to specified data rates. Also 'hard'.
kICMCompressionSessionOptionsPropertyID_Depth	UInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
DurationsNeeded	Indicates that durations of emitted frames are needed. If this option is set and source frames are provided with times but not durations, then frames will be delayed so that durations can be calculated as the difference between one frame's time stamp and the next frame's time stamp. By default, this flag is FALSE, so frames will not be delayed in order to calculate durations. If you pass encoded frames to AddMediaSampleFromEncodedFrame, you must set this flag to TRUE. Also 'need'.
kICMCompressionSessionOptionsPropertyID_-
ExpectedFrameRate	Fixed, ReadWrite.
kICMCompressionSessionOptionsPropertyID_FieldInfo	FieldInfoImageDescription-
Extension2, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MaxDataRateLimits	UInt32, Read.
kICMCompressionSessionOptionsPropertyID_-
MaxFrameDelayCount	The maximum frame delay count is the maximum number of frames that a compressor is allowed to hold before it must output a compressed frame. This value limits the number of frames that may be held in the compression window. If the maximum frame delay count is M, then before the call to encode frame N returns, frame N-M must have been emitted. The default value is kICMUnlimitedFrameDelayCount, which sets no limit on the compression window. Also 'cwin'.
kICMCompressionSessionOptionsPropertyID_-
MaxFrameDelayTime	TimeValue64, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MaxKeyFrameInterval	The maximum interval between key frames, also known as the key frame rate. Compressors are allowed to generate key frames more frequently if this would result in more efficient compression. The default key frame interval is 0, which indicates that the compressor should choose where to place all key frames. This differs from previous practice, in which a key frame rate of zero disabled temporal compression. Also 'kyfr'.
kICMCompressionSessionOptionsPropertyID_-
MaxPartialSyncFrameInterval	SInt32, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
MultiPassStorage	A multipass compression client must provide a storage location for multipass data. Pass ICMMultiPassStorageCreate-
WithTemporaryFile to make the ICM store multipass data in a temporary file. Pass ICMMultiPassStorageCreate-
WithCallbacks to manage the storage yourself. Note that the amount of multipass data to be stored can be substantial; it could be greater than the size of the output movie file. If this property is not NULL, the client must call ICMCompressionSessionBeginPass and ICMCompressionSessionEndPass around groups of calls to ICMCompressionSessionEncodeFrame. By default, this property is NULL and multipass compression is not enabled. The compression session options object retains the multipass storage object when one is set. Also 'imps'.
kICMCompressionSessionOptionsPropertyID_-
PixelAspectRatio	Native-endian PixelAspectRatioImageDescription-
Extension, ReadWrite.
kICMCompressionSessionOptionsPropertyID_Quality	The compression quality. This value is always used to set the spatial quality; if temporal compression is enabled, it is also used to set temporal quality. The default quality is codecNormalQuality. Also 'qual'.
kICMCompressionSessionOptionsPropertyID_-
ScalingMode	OSType, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
SourceFrameCount	UInt64, ReadWrite.
kICMCompressionSessionOptionsPropertyID_-
WasCompressed	Indicates that the source was previously compressed. This property is an optional information hint to the compressor; by default it is FALSE. Also 'wasc'.
kICMCompressionSessionPropertyID_-
CompressorPixelBufferAttributes	The compressor's pixel buffer attributes for the compression session. You can use these to create a pixel buffer pool for source pixel buffers. This is not the same as the sourcePixelBufferAttributes property passed to ICMCompressionSessionCreate. Getting this property does not change its retain count. Also 'batt'.
kICMCompressionSessionPropertyID_ImageDescription	The image description for a compression session. For some codecs, the image description may not be available before the first frame is compressed. Multiple calls to retrieve this property will return the same handle. The ICM will dispose of this handle when the compression session is disposed; the caller must not dispose of it. Also 'idsc'.
kICMCompressionSessionPropertyID_PixelBufferPool	A pool that can provide ideal source pixel buffers for a compression session. The compression session creates this pixel buffer pool based on the compressor's pixel buffer attributes and any pixel buffer attributes passed in to ICMCompressionSessionCreate. If the source pixel buffer attributes and the compressor pixel buffer attributes can not be reconciled, the pool is based on the source pixel buffer attributes and the ICM converts each CVPixelBuffer internally. Also 'pool'.
kICMCompressionSessionPropertyID_TimeScale	The time scale for the compression session. Also 'tscl'.
kICMDecompressionFrameOptionsPropertyID_-
DestinationPixelBuffer	CVPixelBufferRef, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_Accuracy	CodecQ, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
DecompressorComponent	DecompressorComponent, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
DisplayOrderRequired	Boolean, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
FieldMode	ICMFieldMode, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
MaxBufferCount	UInt32, ReadWrite.
kICMDecompressionSessionOptionsPropertyID_-
OutputAheadTime	TimeRecord, ReadWrite.
kICMDecompressionSessionPropertyID_-
NonScheduledDisplayDirection	Fixed, ReadWrite.
kICMDecompressionSessionPropertyID_-
NonScheduledDisplayTime	ICMNonScheduledDisplayTime, ReadWrite.
kICMDecompressionSessionPropertyID_PixelBufferPool	CVPixelBufferPoolRef, Read.
kICMDecompressionSessionPropertyID_-
PixelBufferPoolIsShared	Boolean, Read.
kICMDecompressionTracking_EmittingFrame	
kICMDecompressionTracking_FrameDecoded	
kICMDecompressionTracking_FrameDropped	
kICMDecompressionTracking_FrameNeedsRequeueing	
kICMDecompressionTracking_LastCall	
kICMDecompressionTracking_ReleaseSourceData	
kICMFieldMode_BothFields	
kICMFieldMode_BottomFieldOnly	
kICMFieldMode_DeinterlaceFields	
kICMFieldMode_TopFieldOnly	
kICMFrameType_B	
kICMFrameType_I	
kICMFrameType_P	
kICMFrameType_Unknown	
kICMImageDescriptionPropertyID_ClassicTrackHeight	Fixed, Read.
kICMImageDescriptionPropertyID_ClassicTrackWidth	Fixed, Read.
kICMImageDescriptionPropertyID_CleanAperture	Native-endian CleanApertureImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_DisplayHeight	SInt32, Read.
kICMImageDescriptionPropertyID_DisplayWidth	SInt32, Read.
kICMImageDescriptionPropertyID_EncodedHeight	SInt32, ReadWrite.
kICMImageDescriptionPropertyID_EncodedWidth	SInt32, ReadWrite.
kICMImageDescriptionPropertyID_FieldInfo	FieldInfoImageDescription-
Extension2, ReadWrite.
kICMImageDescriptionPropertyID_GammaLevel	Fixed, ReadWrite.
kICMImageDescriptionPropertyID_NCLCColorInfo	Native-endian NCLCColorInfoImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_PixelAspectRatio	Native-endian PixelAspectRatioImageDescription-
Extension, ReadWrite.
kICMImageDescriptionPropertyID_-
ProductionDisplayHeight	SInt32, Read.
kICMImageDescriptionPropertyID_-
ProductionDisplayWidth	SInt32, Read.
kICMImageDescriptionPropertyID_RowBytes	SInt32, ReadWrite.
kICMMultiPassStorageCallbacksVersionOne	
kICMMultiPassStorage_DoNotDeleteWhenDone	
kICMMultiPassStorage_GetFirstTimeStamp	
kICMMultiPassStorage_GetLastTimeStamp	
kICMMultiPassStorage_GetNextTimeStamp	
kICMMultiPassStorage_GetPreviousTimeStamp	
kICMScalingMode_Letterbox	The clean aperture of the source frames is scaled to fit inside the clean aperture of the destination, preserving the original display aspect ratio. If the display aspect ratios are different, the source frames are centered with black bars above and below, or to the left and right.
kICMScalingMode_StretchCleanAperture	The clean aperture of the source frames is scaled to the clean aperture of the destination.
kICMScalingMode_StretchProductionAperture	The full width and height of source frames is scaled to the full width and height of the destination. This is the default if no other scaling mode is specified.
kICMScalingMode_Trim	The clean aperture of the source frames is scaled to cover the clean aperture of the destination, preserving the original display aspect ratio. If the display aspect ratios are different, the source frames are centered and cropped.
kICMSourceTracking_CopiedPixelBuffer	
kICMSourceTracking_FrameTimeWasChanged	
kICMSourceTracking_FrameWasDropped	
kICMSourceTracking_FrameWasEncoded	
kICMSourceTracking_FrameWasMerged	
kICMSourceTracking_LastCall	
kICMSourceTracking_ReleasedPixelBuffer	
kICMUnlimitedCPUTimeBudget	No CPU time limit on compression.
kICMUnlimitedFrameDelayCount	No limit on the number of frames in the compression window.
kICMUnlimitedFrameDelayTime	No time limit on the frames in the compression window.
kICMValidTime_DecodeDurationIsValid	
kICMValidTime_DecodeTimeStampIsValid	
kICMValidTime_DisplayDurationIsValid	The time value passed in displayDuration is valid.
kICMValidTime_DisplayOffsetIsValid	
kICMValidTime_DisplayTimeStampIsValid	The time value passed in displayTimeStamp is valid.
kQTPropertyClass_ICMCompressionFrameOptions	
kQTPropertyClass_ICMCompressionSession	Class identifier for compression session properties. Also 'icse'.
kQTPropertyClass_ICMCompressionSessionOptions	Class identifier for compression session option object properties. Also 'icso'.
kQTPropertyClass_ICMDecompressionFrameOptions	
kQTPropertyClass_ICMDecompressionSession	
kQTPropertyClass_ICMDecompressionSessionOptions	
kQTPropertyClass_ImageDescription	Class identifier for image description properties.
kQTVisualContextExpectedReadAheadKey	A CFNumberRef that defines the number of seconds ahead of real time that the client expects to pull images out of a visual context.
kQTVisualContextOutputColorSpaceKey	
kQTVisualContextPixelBufferAttributesKey	A CFDictionaryRef that defines the dictionary containing pixel buffer attributes. See kICMCompressionSessionPropertyID_-
PixelBufferPool in ICM Compression Session Properties.
kQTVisualContextTargetDimensionsKey	A CFDictionaryRef that defines the dictionary containing kQTVisualContextTargetDimensions_-
WidthKey and kQTVisualContextTargetDimensions_-
HeightKey values (see below).
kQTVisualContextTargetDimensions_HeightKey	A CFNumberRef that defines the height, in pixels, of the rendering target.
kQTVisualContextTargetDimensions_WidthKey	A CFNumberRef that defines the width, in pixels, of the rendering target.
kQTVisualContextTypeKey	
kQTVisualContextType_OpenGLTexture	The value of kQTVisualContextTypeKey for OpenGL texture visual contexts.
kQTVisualContextType_PixelBuffer	The value of kQTVisualContextTypeKey for pixel buffer visual contexts.
kQTVisualContextWorkingColorSpaceKey	

Movies.h

A variety of new functions in Movies.h support high-resolution audio, a new metadata format, a new sample table API, the ability to create movies from properties, and other features of QuickTime 7.
Functions

All of the new functions in this header file are listed alphabetically, with links to documentation and abstracts, if available.AddMediaSample2	Adds sample data and a description to a media.
AddMediaSampleFromEncodedFrame	Adds sample data and description from an encoded frame to a media.
AddSampleTableToMedia	Adds a sample table to a media.
CopyMediaMutableSampleTable	Obtains information about sample references in a media in the form of a sample table.
DisposeQTTrackPropertyListenerUPP	Disposes a track property listener UPP.
ExtendMediaDecodeDurationToDisplayEndTime	Prepares a media for the addition of a completely new sequence of samples by ensuring that the media display end time is not later than the media decode end time.
GetMediaAdvanceDecodeTime	Returns the advance decode time of a media.
GetMediaDataSizeTime64	Determines the size, in bytes, of the sample data in a media segment.
GetMediaDecodeDuration	Returns the decode duration of a media.
GetMediaDisplayDuration	Returns the display duration of a media.
GetMediaDisplayEndTime	Returns the display end time of a media.
GetMediaDisplayStartTime	Returns the display start time of a media.
GetMediaNextInterestingDecodeTime	Searches for decode times of interest in a media.
GetMediaNextInterestingDisplayTime	Searches for display times of interest in a media.
GetMediaSample2	Retrieves sample data from a media file.
GetMovieAudioBalance	Returns the balance value for the audio mix of a movie currently playing.
GetMovieAudioContext	Returns the current audio context for a movie.
GetMovieAudioFrequencyLevels	Returns the current frequency meter levels of a movie mix.
GetMovieAudioFrequencyMeteringBandFrequencies	Returns the chosen middle frequency for each band in the configured frequency metering of a particular movie mix.
GetMovieAudioFrequencyMeteringNumBands	Returns the number of frequency bands being metered for a movie's specified audio mix.
GetMovieAudioGain	Returns the gain value for the audio mix of a movie currently playing.
GetMovieAudioMute	Returns the mute value for the audio mix of a movie currently playing.
GetMovieAudioVolumeLevels	Returns the current volume meter levels of a movie.
GetMovieAudioVolumeMeteringEnabled	Returns the enabled or disabled status of volume metering of a particular audio mix of a movie.
GetMovieVisualBrightness	Returns the brightness adjustment for the movie.
GetMovieVisualContext	Returns the current visual context for a movie.
GetMovieVisualContrast	Returns the contrast adjustment for the movie.
GetMovieVisualHue	Returns the hue adjustment for the movie.
GetMovieVisualSaturation	Returns the color saturation adjustment for the movie.
GetTrackAudioGain	Returns the gain value for the audio mix of a track currently playing.
GetTrackAudioMute	Returns the mute value for the audio mix of a track currently playing.
GetTrackAudioVolumeLevels	
GetTrackAudioVolumeMeteringEnabled	
GetTrackEditRate64	Returns the rate of the track edit of a specified track at an indicated time.
InvokeQTTrackPropertyListenerUPP	Invokes the specified property listener of a track.
MediaContainsDisplayOffsets	Tests whether a media contains display offsets.
MediaDecodeTimeToSampleNum	Finds the sample for a specified decode time.
MediaDisplayTimeToSampleNum	Finds the sample number for a specified display time.
MovieAudioExtractionBegin	Begins a movie audio extraction session.
MovieAudioExtractionEnd	Ends a movie audio extraction session.
MovieAudioExtractionFillBuffer	Extracts audio from a movie.
MovieAudioExtractionGetProperty	Gets a property of a movie audio extraction session.
MovieAudioExtractionGetPropertyInfo	Gets information about a property of a movie audio extraction session.
MovieAudioExtractionSetProperty	Sets a property of a movie audio extraction session.
NewMovieFromProperties	Creates a new movie using movie properties.
NewQTTrackPropertyListenerUPP	Creates a new callback to monitor a track property.
QTAddTrackPropertyListener	Installs a callback to monitor a track property.
QTAudioContextCreateForAudioDevice	Creates a QTAudioContext object that encapsulates a connection to a CoreAudio output device.
QTAudioContextRelease	
QTAudioContextRetain	
QTCopyMediaMetaData	Retains a media's metadata object and returns it.
QTCopyMovieMetaData	Retains a movie's metadata object and returns it.
QTCopyTrackMetaData	Retains a track's metadata object and returns it.
QTGetTrackProperty	Returns the value of a specific track property.
QTGetTrackPropertyInfo	Returns information about the properties of a track.
QTMetaDataAddItem	Adds an inline metadata item to the metadata storage format.
QTMetaDataGetItemCountWithKey	
QTMetaDataGetItemProperty	Returns a property of a metadata item.
QTMetaDataGetItemPropertyInfo	Returns information about a property of a metadata item.
QTMetaDataGetItemValue	Returns the value of a metadata item from an item identifier.
QTMetaDataGetNextItem	Returns the next metadata item corresponding to a specified key.
QTMetaDataGetProperty	Returns a property of a metadata object.
QTMetaDataGetPropertyInfo	Returns information about a property of a metadata object.
QTMetaDataRelease	Decrements the retain count of a metadata object.
QTMetaDataRemoveItem	Removes a metadata item from a storage format.
QTMetaDataRemoveItemsWithKey	Removes metadata items with a specific key from the storage format.
QTMetaDataRetain	Increments the retain count of a metadata object.
QTMetaDataSetItem	Sets the value of the metadata item from the item identifier.
QTMetaDataSetItemProperty	Sets a property of a metadata item.
QTMetaDataSetProperty	Sets a property of a metadata object.
QTRemoveTrackPropertyListener	Removes a track property monitoring callback
QTSampleTableAddSampleDescription	Adds a sample description to a sample table, returning a sample description ID that can be used to refer to it.
QTSampleTableAddSampleReferences	Adds sample references to a sample table.
QTSampleTableCopySampleDescription	Retrieves a sample description from a sample table.
QTSampleTableCreateMutable	Creates a new, empty sample table.
QTSampleTableCreateMutableCopy	Copies a sample table.
QTSampleTableGetDataOffset	Returns the data offset of a sample.
QTSampleTableGetDataSizePerSample	Returns the data size of a sample.
QTSampleTableGetDecodeDuration	Returns the decode duration of a sample.
QTSampleTableGetDisplayOffset	Returns the offset from decode time to display time of a sample.
QTSampleTableGetNextAttributeChange	Finds the next sample number at which one or more of a set of given sample attributes change.
QTSampleTableGetNumberOfSamples	Returns the number of samples in a sample table.
QTSampleTableGetProperty	Returns the value of a specific sample table property.
QTSampleTableGetPropertyInfo	Returns information about the properties of a sample table.
QTSampleTableGetSampleDescriptionID	Returns the sample description ID of a sample.
QTSampleTableGetSampleFlags	Returns the media sample flags of a sample.
QTSampleTableGetTimeScale	Returns the timescale of a sample table.
QTSampleTableGetTypeID	Returns the CFTypeID value for the current sample table.
QTSampleTableRelease	Decrements the retain count of a sample table.
QTSampleTableReplaceRange	Replaces a range of samples in a sample table with a range of samples from another sample table.
QTSampleTableRetain	Increments the retain count of a sample table.
QTSampleTableSetProperty	Sets the value of a specific sample table property.
QTSampleTableSetTimeScale	Changes the timescale of a sample table.
QTSetTrackProperty	Sets the value of a specific track property.
QTSoundDescriptionConvert	Converts a sound description from one version to another.
QTSoundDescriptionCreate	Creates a sound description structure of the requested kind from an AudioStreamBasicDescription, optional audio channel layout, and optional magic cookie.
QTSoundDescriptionGetProperty	Gets a particular property of a sound description.
QTSoundDescriptionGetPropertyInfo	Gets information about a particular property of a sound description.
QTSoundDescriptionSetProperty	Sets a particular property of a sound description.
SampleNumToMediaDecodeTime	Finds the decode time for a specified sample.
SampleNumToMediaDisplayTime	Finds the display time for a specified sample.
SetMovieAudioBalance	Sets the balance level for the mixed audio output of a movie.
SetMovieAudioContext	Targets a movie to render into an audio context.
SetMovieAudioFrequencyMeteringNumBands	Configures frequency metering for a particular audio mix in a movie.
SetMovieAudioGain	Sets the audio gain level for the mixed audio output of a movie, altering the perceived volume of the movie's playback.
SetMovieAudioMute	Sets the mute value for the audio mix of a movie currently playing.
SetMovieAudioVolumeMeteringEnabled	Enables or disables volume metering of a particular audio mix of a movie.
SetMovieVisualBrightness	Sets the brightness adjustment for the movie.
SetMovieVisualContext	Targets a movie to render into a visual context.
SetMovieVisualContrast	Sets the contrast adjustment for the movie.
SetMovieVisualHue	Sets the hue adjustment for the movie.
SetMovieVisualSaturation	Sets the color saturation adjustment for the movie.
SetTrackAudioGain	Sets the audio gain level for the audio output of a track, altering the perceived volume of the track's playback.
SetTrackAudioMute	Mutes or unmutes the audio output of a track.
SetTrackAudioVolumeMeteringEnabled	
TrackTimeToMediaDisplayTime	Converts a track's time value to a display time value that is appropriate to the track's media, using the track's edit list.*/
const CFStringRef kQTVisualContextOutputColorSpaceKey;

/*initializing and Terminating QTML and QuickTime

Before your program can perform any QuickTime operations, you must initialize the QuickTime Media Layer and then QuickTime itself. The first is accomplished by calling a routine named InitializeQTML, the second with EnterMovies.

InitializeQTML must be called at the very beginning of your program, before any other QuickTime call. The recommended place to call it is in your WinMain function, before creating your main window. The function is defined as follows:OSErr InitializeQTML (long flag);*/
OSErr InitializeQTML (long flag){};

