#include <SpeechRecognition/SpeechRecognition.h>

/*SRCloseRecognitionSystem

Closes a recognition system when your application is finished using it (for example, just before your application quits).

OSErr SRCloseRecognitionSystem (
   SRRecognitionSystem system
);
Parameters
system

A recognition system. 
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

The SRCloseRecognitionSystem function closes the recognition system specified by the system parameter. If any speech objects are still attached to that recognition system, they are disposed of and any references you have to those objects are thereby rendered invalid. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRCloseRecognitionSystem (
   SRRecognitionSystem system
){};


/*SRStartListening

Starts a recognizer listening and reporting results to your application.

OSErr SRStartListening (
   SRRecognizer recognizer
);
Parameters
recognizer

A recognizer. 
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

The SRStartListening function instructs the recognizer specified by the recognizer parameter to begin processing sound from its speech source and reporting its results to your application (either using Apple events or through a speech recognition callback routine).

You must already have built a language model and attached it to the recognizer (by calling the SRSetLanguageModel function) before you call SRStartListening. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/

OSErr SRStartListening (
   SRRecognizer recognizer
){};

/*SROpenRecognitionSystem

Opens a recognition system.

OSErr SROpenRecognitionSystem (
   SRRecognitionSystem * system,
   OSType systemID
);
Parameters
system

On return, a reference to the recognition system having the specified system ID. 
systemID

A recognition system ID.
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

Generally, you should open a single recognition system when your application starts up and close it (by calling the function SRCloseRecognitionSystem) before your application exits. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SROpenRecognitionSystem (
   SRRecognitionSystem * system,
   OSType systemID
){};


/*SRStopListening

Stops a recognizer listening and reporting results to your application.

OSErr SRStopListening (
   SRRecognizer recognizer
);
Parameters
recognizer

A recognizer. 
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

The SRStopListening function instructs the recognizer specified by the recognizer parameter to stop processing sound from its speech source and reporting its results to your application. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRStopListening (
   SRRecognizer recognizer
){};

/*SRGetProperty

Gets the current value of a property of a speech object.

OSErr SRGetProperty (
   SRSpeechObject srObject,
   OSType selector,
   void * property,
   Size * propertyLen
);
Parameters
srObject

A speech object. 
selector

A property selector. See “Recognizer Properties”, “Recognizer Listen Key Properties”, “Language Object Properties”, and “Recognition System Properties” for lists of the available property selectors. 
property

A pointer to a buffer into which the value of the specified property is to be copied. 
propertyLen

On entry, a pointer to the length, in bytes, of the specified buffer. If the value is of a fixed size, then propertyLen should point to a variable of type Size that specifies that size. If the size of the value can vary (for example, if the value is a string), then propertyLen should point to a variable of type Size that specifies the number of bytes in the buffer pointed to by the property parameter.

On return, if the buffer is large enough to hold the returned property value and no error occurs, SRGetProperty sets propertyLen to the total number of bytes in the value of the specified property. If the buffer is not large enough to hold the returned property value, SRGetProperty sets propertyLen to the number of bytes required to store the requested property and returns the kSRBufferTooSmall error code.
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

Not all selectors are valid for all types of speech objects. If the selector you specify does not specify a property of the specified speech object, SRGetProperty returns the result code kSRCantGetProperty.

If SRGetProperty returns an object reference, you must make sure to release that object reference (by calling SRReleaseObject) when you are finished using it. Most selectors do not cause SRGetProperty to return object references. For example, passing the selector kSRSpelling causes SRGetProperty to return a buffer of text, not an object reference. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRGetProperty (
   SRSpeechObject srObject,
   OSType selector,
   void * property,
   Size * propertyLen
){};

/*SRSetLanguageModel

Sets a recognizer’s active language model.

OSErr SRSetLanguageModel (
   SRRecognizer recognizer,
   SRLanguageModel languageModel
);
Parameters
recognizer

A recognizer. 
languageModel

The language model you wish to become the active model for the specified recognizer. 
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

If no other references exist to the language model currently in use by the specified recognizer, calling SRSetLanguageModel with a different language model causes the current one to be released. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRSetLanguageModel (
   SRRecognizer recognizer,
   SRLanguageModel languageModel
){};


/*SRNewRecognizer

Creates a new recognizer.

OSErr SRNewRecognizer (
   SRRecognitionSystem system,
   SRRecognizer * recognizer,
   OSType sourceID
);
Parameters
system

A recognition system. 
recognizer

On return, a reference to a new recognizer associated with the specified recognition system and using the specified speech source. 
sourceID

A speech source ID. See “Speech Source Constants”.
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

SRNewRecognizer may need to load substantial amounts of data from disk into memory. As a result, you might want to change the cursor to the watch cursor before you call SRNewRecognizer.

You should call the SRReleaseObject function to release the object reference returned by SRNewRecognizer when you are done using it. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h */
OSErr SRNewRecognizer (
   SRRecognitionSystem system,
   SRRecognizer * recognizer,
   OSType sourceID
){};





/*SRAddText

Adds text to the contents of a language object.

OSErr SRAddText (
   SRLanguageObject base,
   const void * text,
   Size textLength,
   long refCon
);
Parameters
base

A language object to which to add the text. 
text

A pointer to a buffer that contains the words or phrase to add to the contents of the specified language object. 
textLength

The size, in bytes, of the specified text.
refCon

An application-defined reference constant. The value of the reference constant property of the new word or phrase representing the specified text is set to this value. 
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

The SRAddText function is useful for phrases, paths, and language models. If the base parameter specifies a path or language model, SRAddText is equivalent to calling SRNewPhrase, SRAddLanguageObject, and SRReleaseObject for the phrase specified by the text parameter and calling SRSetProperty to reset the value of the reference constant property of the new phrase.

If the base parameter specifies a phrase, SRAddText is equivalent to calling SRNewPhrase, SRAddLanguageObject, and SRReleaseObject for each distinguishable word in the text parameter and calling SRSetProperty to set the value of the reference constant property of the new words. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRAddText (
   SRLanguageObject base,
   const void * text,
   Size textLength,
   long refCon
){};


/*SRNewLanguageModel

Creates a new language model.

OSErr SRNewLanguageModel (
   SRRecognitionSystem system,
   SRLanguageModel * model,
   const void * name,
   Size nameLength
);
Parameters
system

A recognition system. 
model

On return, a reference to a new empty language model associated with the specified recognition system. 
name

A pointer to a buffer that contains the name of the language model. The name of the language model should be unique among all the language models your application creates, and it should be comprehensible to users. (For example, a language model that defined a list of names might be called “«Names»”).

The convention that language model names begin with the character “«” and end with the character “»” is adopted to support future utilities that display the names of language models to the user (perhaps as part of showing the user what he or she can say).
nameLength

The size, in bytes, of the specified name.
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

You can add language objects (that is, words, phrases, paths, and other language models) to a language model by calling the SRAddText and SRAddLanguageObject functions.

SRNewLanguageModel sets the reference count of the specified language model to 1. You should call the SRReleaseObject function to release the language model reference returned by SRNewLanguageModel when you are done using it.

You can get or set the name of an existing language model by calling the SRGetProperty or SRSetProperty functions with the kSRSpelling property selector. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRNewLanguageModel (
   SRRecognitionSystem system,
   SRLanguageModel * model,
   const void * name,
   Size nameLength
){};

/*SRSetProperty

Sets the value of a property of a speech object.

OSErr SRSetProperty (
   SRSpeechObject srObject,
   OSType selector,
   const void * property,
   Size propertyLen
);
Parameters
srObject

A speech object. 
selector

A property selector. See “Recognizer Properties”, “Recognizer Listen Key Properties”, “Language Object Properties”, and “Recognition System Properties” for lists of the available property selectors.
property

A pointer to a buffer containing the value to which the specified property is to be set. 
propertyLen

The length, in bytes, of the specified buffer.
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

The SRSetProperty function sets the value of the property of the speech object specified by the srObject parameter to the value specified through the property parameter. The selector parameter specifies which property is to be set and the propertyLen parameter specifies it size, in bytes.

Not all properties can be set. If you attempt to set a property that cannot be set, SRSetProperty returns the result code kSRCantSetProperty or kSRBadSelector as its function result. 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRSetProperty (
   SRSpeechObject srObject,
   OSType selector,
   const void * property,
   Size propertyLen
){};

/*SRReleaseObject

Releases a speech object.

OSErr SRReleaseObject (
   SRSpeechObject srObject
);
Parameters
srObject

A speech object. 
Return Value

A result code. See “Speech Recognition Manager Result Codes”.
Discussion

If there are no other remaining references to the object, SRReleaseObject disposes of the memory occupied by the object.

Your application should balance every function call that returns an object reference with a call to SRReleaseObject. This means that every call to a function whose name begins with SRNew or SRGet that successfully returns an object reference must be balanced with a call to SRReleaseObject.

In addition, you should call SRReleaseObject to release references to SRSearchResult objects that are passed to your application (via an Apple event handler or a callback routine). 
Availability
Available in CarbonLib 1.0 and later when Speech Recognition 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
SpeechRecognition.h*/
OSErr SRReleaseObject (
   SRSpeechObject srObject
){};









