#include <stdio.h>
#include <string.h>
#include <ADD/string.h>
#include <sys/types.h>


/*STRMODE(3)               BSD Library Functions Manual               STRMODE(3)

NAME
     strmode -- convert inode status information into a symbolic string

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <string.h>

     void
     strmode(mode_t mode, char *bp);

DESCRIPTION
     The strmode() function converts a file mode (the type and permission
     information associated with an inode, see stat(2)) into a symbolic string
     which is stored in the location referenced by bp.  This stored string is
     eleven characters in length plus a trailing NUL.

     The first character is the inode type, and will be one of the following:

           -     regular file
           b     block special
           c     character special
           d     directory
           l     symbolic link
           p     fifo
           s     socket
           w     whiteout
           ?     unknown inode type

     The next nine characters encode three sets of permissions, in three char-characters
     acters each.  The first three characters are the permissions for the
     owner of the file, the second three for the group the file belongs to,
     and the third for the ``other'', or default, set of users.

     Permission checking is done as specifically as possible.  If read permis-permission
     sion is denied to the owner of a file in the first set of permissions,
     the owner of the file will not be able to read the file.  This is true
     even if the owner is in the file's group and the group permissions allow
     reading or the ``other'' permissions allow reading.

     If the first character of the three character set is an ``r'', the file
     is readable for that set of users; if a dash ``-'', it is not readable.

     If the second character of the three character set is a ``w'', the file
     is writable for that set of users; if a dash ``-'', it is not writable.

     The third character is the first of the following characters that apply:

     S     If the character is part of the owner permissions and the file is
           not executable or the directory is not searchable by the owner, and
           the set-user-id bit is set.

     S     If the character is part of the group permissions and the file is
           not executable or the directory is not searchable by the group, and
           the set-group-id bit is set.

     T     If the character is part of the other permissions and the file is
           not executable or the directory is not searchable by others, and
           the ``sticky'' (S_ISVTX) bit is set.

     s     If the character is part of the owner permissions and the file is
           executable or the directory searchable by the owner, and the set-setuser-id
           user-id bit is set.

     s     If the character is part of the group permissions and the file is
           executable or the directory searchable by the group, and the set-setgroup-id
           group-id bit is set.

     t     If the character is part of the other permissions and the file is
           executable or the directory searchable by others, and the
           ``sticky'' (S_ISVTX) bit is set.

     x     The file is executable or the directory is searchable.

     -     None of the above apply.

     The last character is a plus sign ``+'' if any there are any alternate or
     additional access control methods associated with the inode, otherwise it
     will be a space.

SEE ALSO
     chmod(1), find(1), stat(2), getmode(3), setmode(3)

HISTORY
     The strmode() function first appeared in 4.4BSD.

BSD                              July 28, 1994                             BSD*/
 void   strmode(mode_t mode, char *bp){
printf ("strmode",mode,*bp);
};


/*STRLCPY(3)               BSD Library Functions Manual               STRLCPY(3)

NAME
     strlcpy, strlcat -- size-bounded string copying and concatenation

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <string.h>

     size_t
     strlcpy(char *dst, const char *src, size_t size);

     size_t
     strlcat(char *dst, const char *src, size_t size);

DESCRIPTION
     The strlcpy() and strlcat() functions copy and concatenate strings
     respectively.  They are designed to be safer, more consistent, and less
     error prone replacements for strncpy(3) and strncat(3).  Unlike those
     functions, strlcpy() and strlcat() take the full size of the buffer (not
     just the length) and guarantee to NUL-terminate the result (as long as
     size is larger than 0 or, in the case of strlcat(), as long as there is
     at least one byte free in dst).  Note that you should include a byte for
     the NUL in size.  Also note that strlcpy() and strlcat() only operate on
     true ``C'' strings.  This means that for strlcpy() src must be NUL-termi-nated NUL-terminated
     nated and for strlcat() both src and dst must be NUL-terminated.

     The strlcpy() function copies up to size - 1 characters from the NUL-ter-minated NUL-terminated
     minated string src to dst, NUL-terminating the result.

     The strlcat() function appends the NUL-terminated string src to the end
     of dst.  It will append at most size - strlen(dst) - 1 bytes, NUL-termi-nating NUL-terminating
     nating the result.

RETURN VALUES
     The strlcpy() and strlcat() functions return the total length of the
     string they tried to create.  For strlcpy() that means the length of src.
     For strlcat() that means the initial length of dst plus the length of
     src.  While this may seem somewhat confusing it was done to make trunca-tion truncation
     tion detection simple.

     Note however, that if strlcat() traverses size characters without finding
     a NUL, the length of the string is considered to be size and the destina-tion destination
     tion string will not be NUL-terminated (since there was no space for the
     NUL).  This keeps strlcat() from running off the end of a string.  In
     practice this should not happen (as it means that either size is incor-rect incorrect
     rect or that dst is not a proper ``C'' string).  The check exists to pre-vent prevent
     vent potential security problems in incorrect code.

EXAMPLES
     The following code fragment illustrates the simple case:

           char *s, *p, buf[BUFSIZ];

           ...

           (void)strlcpy(buf, s, sizeof(buf));
           (void)strlcat(buf, p, sizeof(buf));

     To detect truncation, perhaps while building a pathname, something like
     the following might be used:

           char *dir, *file, pname[MAXPATHLEN];

           ...

           if (strlcpy(pname, dir, sizeof(pname)) >= sizeof(pname))
                   goto toolong;
           if (strlcat(pname, file, sizeof(pname)) >= sizeof(pname))
                   goto toolong;

     Since we know how many characters we copied the first time, we can speed
     things up a bit by using a copy instead of an append:

           char *dir, *file, pname[MAXPATHLEN];
           size_t n;

           ...

           n = strlcpy(pname, dir, sizeof(pname));
           if (n >= sizeof(pname))
                   goto toolong;
           if (strlcpy(pname + n, file, sizeof(pname) - n) >= sizeof(pname) - n)
                   goto toolong;

     However, one may question the validity of such optimizations, as they
     defeat the whole purpose of strlcpy() and strlcat().  As a matter of
     fact, the first version of this manual page got it wrong.

SEE ALSO
     snprintf(3), strncat(3), strncpy(3)

HISTORY
     The strlcpy() and strlcat() functions first appeared in OpenBSD 2.4, and
     made their appearance in FreeBSD 3.3.

BSD                              June 22, 1998                             BSD*/
  size_t strlcpy(char *dst, const char *src, size_t size){
printf ("strlcpy",*dst,*src,size);
};


