#ifndef ADD_SYS_TIME_H
#define ADD_SYS_TIME_H
#include <sys/time.h>
#include <sys/cdefs.h>
#include <sys/_types.h>

#include <APPLE/sys/time.h>


/*void microtime(struct timeval *tv);

Declared In: <sys/time.h>

Dependency: com.apple.kernel.bsd

This function returns a timeval struct containing the current wall clock time*/

void microtime(struct timeval *tv); 

/*Handling Version Dependencies

Many time-related functions such as clock_get_uptime changed as a result of the transition to KPIs in Mac OS X v.10.4. While these changes result in a cleaner interface, this can prove challenging if you need to make a kernel extension that needs to obtain time information across multiple versions of Mac OS X in a kernel extension that would otherwise have no version dependencies (such as an I/O Kit KEXT).

Here is a list of time-related functions that are available in both pre-KPI and KPI versions of Mac OS X:
uint64_t mach_absolute_time(void);

Declared In: <mach/mach_time.h>

Dependency: com.apple.kernel.mach

This function returns a Mach absolute time value for the current wall clock time in units of uint64_t.
void microtime(struct timeval *tv);

Declared In: <sys/time.h>

Dependency: com.apple.kernel.bsd

This function returns a timeval struct containing the current wall clock time.
void microuptime(struct timeval *tv);

Declared In: <sys/time.h>

Dependency: com.apple.kernel.bsd

This function returns a timeval struct containing the current uptime.
void nanotime(struct timespec *ts);

Declared In: <sys/time.h>

Dependency: com.apple.kernel.bsd

This function returns a timespec struct containing the current wall clock time.
void nanouptime(struct timespec *ts);

Declared In: <sys/time.h>

Dependency: com.apple.kernel.bsd

This function returns a timespec struct containing the current uptime.

Note: The structure declarations for struct timeval and struct timespec differ between 10.3 and 10.4 in their use of int, int32_t, and long data types. However, because the structure packing for the underlying data types is identical in the 32-bit world, these structures are assignment compatible.


In addition to these APIs, the functionality marked __APPLE_API_UNSTABLE in <mach/time_value.h> was adopted as-is in Mac OS X v.10.4 and is no longer marked unstable.*/
void nanotime(struct timespec *ts);


#endif

