//inclu

#ifndef APPLEEVENTS_H
#define APPLEEVENTS_H


#ifndef COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef AEDATAMODEL_H
#include <AE/AEDataModel.h>
#endif

#ifndef AEINTERACTION_H
//#include <HIToolbox/AEInteraction.h> //hys
#endif

#include <AvailabilityMacros.h>
//#include <HYS/AE/AppleEvents.h>
#include <APPLE/AE/AppleEvents.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Event ID Constants

Specify the event ID for an Apple event.

enum {
   kAEOpenApplication            = 'oapp',
   kAEReopenApplication          = 'rapp',
   kAEOpenDocuments              = 'odoc',
   kAEPrintDocuments             = 'pdoc',
   kAEOpenContents               = 'ocon',
   kAEQuitApplication            = 'quit',
   kAEAnswer                     = 'ansr',
   kAEApplicationDied            = 'obit',
   kAEShowPreferences            = 'pref'
};
Constants
kAEOpenApplication

Event that launches an application.

Available in Mac OS X v10.0 and later.
kAEReopenApplication

Event that reopens an application. Sent, for example, when your application is running and a user clicks your application icon in the Dock.

Available in Mac OS X v10.0 and later.
kAEOpenDocuments

Event that provides an application with a list of documents to open. Sent, for example, when a selects one or more documents for your application in the Finder and double-clicks them.

See also the constant keyAESearchText in the enum “keyAEPropData”.

Available in Mac OS X v10.0 and later.
kAEPrintDocuments

Event that provides an application with a list of documents to print.

Available in Mac OS X v10.0 and later.
kAEOpenContents

Event that provides an application with dragged content, such as text or an image. Sent, for example, when a user drags an image file onto your application’s icon in the Dock. The application can use the content as desired—for example, if no document is currently open, it might open a new document and insert the provided text or image.

For more information, see “Handling Apple Events Sent by the Mac OS” in “Responding to Apple Events” in Apple Events Programming Guide.

Available in Mac OS X v10.4 and later.
kAEQuitApplication

Event that causes the application to quit.

Available in Mac OS X v10.0 and later.
kAEAnswer

Event that is a reply Apple event.

Available in Mac OS X v10.0 and later.
kAEApplicationDied

Event sent by the Process Manager to an application that launched another application when the launched application quits or terminates.

Available in Mac OS X v10.0 and later.
kAEShowPreferences

Event sent by the Mac OS X to a process when the user chooses the Preferences item for that process.

Carbon applications that handle the Preferences command can install an Apple event handler for this event, but they more commonly install a Carbon event handler for kEventCommandProcess and check for the kHICommandPreferences command ID.

Available in Mac OS X v10.0 and later.
Discussion

Apple events are identified by their event class and event ID attributes. The event ID is the attribute that identifies the particular Apple event within its event class. In conjunction with the event class, the event ID uniquely identifies the Apple event and communicates what action the Apple event should perform. The event ID appears in the where field of the event record for an Apple event. For example, an event with ID kAEOpenApplication and class kCoreEventClass is an event sent by the Mac OS that launches an application.

Only a small number of event IDs are shown here. For a more complete listing, see the Apple Event Manager and Open Scripting Architecture header files.
AppkeEvents.h*/
enum {
   kAEOpenApplication            = 'oapp',
   kAEReopenApplication          = 'rapp',
   kAEOpenDocuments              = 'odoc',
   kAEPrintDocuments             = 'pdoc',
   kAEOpenContents               = 'ocon',
   kAEQuitApplication            = 'quit',
   kAEAnswer                     = 'ansr',
   kAEApplicationDied            = 'obit',
   kAEShowPreferences            = 'pref'
};


/*Event Class Constants

Specify the event class for an Apple event.

enum {
   kCoreEventClass = 'aevt'
};
Constants
kCoreEventClass

An Apple event sent by the Mac OS; applications that present a graphical interface to the user should be able to any events sent by the Mac OS that apply to the application.

Available in Mac OS X v10.0 and later.
Discussion

Apple events are identified by their event class and event ID attributes, each of which specifies an arbitrary four-character code. The event class appears in the message field of the event record for an Apple event. For example, certain Apple events that are sent by the Mac OS have the value 'aevt' in the message fields of their event records. This value can be represented with the constant kCoreEventClass.

Groups of related Apple events are known as suites. For example, the common events that most applications support are grouped in the Standard Suite. The Standard Suite includes the events of the Core suite (open application , reopen, open contents, open documents, print documents, and quit), as well as such events as count, delete, and make. Suites may use a common event class, but doing so is not required, and does not result in any special treatment by AppleScript or the Apple Event Manager.

AppleScript defines suites that provide terminology for Text, Database, Macintosh Connectivity, and other types of related operations. The terms defined in the AppleScript suite itself make up the largest suite. These terms are global to AppleScript, and are available to your application, even if your 'aete' resource doesn’t explicitly include them
AppleEvents.h*/
enum {
   kCoreEventClass = 'aevt'
};




/*Keyword Parameter Constants

Specify keyword values for Apple event parameters, as well as information for the AEManagerInfo function to retrieve. Some common key word values are shown here.

enum {
   keyDirectObject = '----',
   keyErrorNumber = 'errn',
   keyErrorString = 'errs',
   keyProcessSerialNumber = 'psn ',
   keyPreDispatch = 'phac',
   keySelectProc = 'selh',
   keyAERecorderCount = 'recr',
   keyAEVersion = 'vers'
};
Constants
keyDirectObject

Direct parameter. Usually specifies the data to be acted upon by the target application.

Available in Mac OS X v10.0 and later.
keyErrorNumber

Error number. Often used to extract error information from a reply Apple event.

Available in Mac OS X v10.0 and later.
keyErrorString

Error string. Often used to extract error information from a reply Apple event to display to the user.

Available in Mac OS X v10.0 and later.
keyProcessSerialNumber

Process serial number. See also AEManagerInfo.

Available in Mac OS X v10.0 and later.
keyPreDispatch

A predispatch handler (an Apple event handler that the Apple Event Manager calls immediately before it dispatches an Apple event). See also Managing Special Handler Dispatch Tables.

Available in Mac OS X v10.0 and later.
keySelectProc

You pass this value in the functionClass parameter of the AEManagerInfo function to disable the Object Support Library. Disabling the Object Support Library is not recommended.

Available in Mac OS X v10.0 and later.
keyAERecorderCount

Used with the keyword parameter of the AEManagerInfo function. If you pass this value, on return, the result parameter supplies the number of processes that are currently recording Apple events.

Available with version 1.0.1 and later.
keyAEVersion

Used with the keyword parameter of the AEManagerInfo function. If you pass this value, on return, the result parameter supplies version information for the Apple Event Manager, in NumVersion format.

Available with version 1.0.1 and later.
Discussion

These constants are keyword constants for Apple event parameters. An Apple event consists of attributes (which identify the Apple event and denote its task) and, often, parameters (which contain information to be used by the target application). Taken together, the attributes of an Apple event denote the task to be performed on any data specified in the Apple events parameters.

Keywords are arbitrary names used by the Apple Event Manager to keep track of various descriptors. Your application cannot examine the contents of an Apple event directly. Instead, you call Apple Event Manager routines such as those described in Getting Data or Descriptors From Apple Events to request attributes and parameters by keyword.

See also Keyword Attribute Constants.
AppleEvents.h*/
enum {
   keyDirectObject = '----',
   keyErrorNumber = 'errn',
   keyErrorString = 'errs',
   keyProcessSerialNumber = 'psn ',
   keyPreDispatch = 'phac',
   keySelectProc = 'selh',
   keyAERecorderCount = 'recr',
   keyAEVersion = 'vers'
};




/*AEInstallEventHandler

Adds an entry for an event handler to an Apple event dispatch table.

OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventID parameter. See AEEventClass.
theAEEventID

The event ID for the Apple event or events to dispatch to this event handler. The Discussion section describes interactions between this parameter and the theAEEventClass parameter. See AEEventID.
handler

A universal procedure pointer to the Apple event handler function to install. See AEEventHandlerUPP.
handlerRefcon

A reference constant. The Apple Event Manager passes this value to the handler each time it calls it. If your handler doesn’t require a reference constant, pass 0 for this parameter.
isSysHandler

Specifies the Apple event dispatch table to add the handler to. Pass TRUE to add the handler to the system dispatch table or FALSE to add the handler to your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The parameters theAEEventClass and theAEEventID specify the event class and event ID of the Apple events handled by the handler for this dispatch table entry. If there is already an entry in the specified dispatch table for the same event class and event ID, it is replaced. For these parameters, you must provide one of the following combinations:
the event class and event ID of a single Apple event to dispatch to the handler (for example, an event class of kAECoreSuite and an event ID of kAEDelete so that a specific kind of delete event is dispatched to the handler) 
the typeWildCard constant for theAEEventClass and an event ID for theAEEventID, which indicates that Apple events from all event classes whose event IDs match theAEEventID should be dispatched to the handler (for example, an event class of typeWildCard and an event ID of kAEDelete so that for all event classes, the delete event is dispatched to the handler) 
an event class for theAEEventClass and the typeWildCard constant for theAEEventID, which indicates that all events from the specified event class should be dispatched to the handler (for example, an event class of kAECoreSuite and an event ID of typeWildCard so that all events for the core suite are dispatched to the handler) 
the typeWildCard constant for both the theAEEventClass and theAEEventID parameters, which indicates that all Apple events should be dispatched to the handler

If you use the typeWildCard constant for either the theAEEventClass or the theAEEventID parameter (or for both parameters), the corresponding handler must return the error errAEEventNotHandled if it does not handle a particular event.

If an Apple event dispatch table contains one entry for an event class and a specific event ID, and also contains another entry that is identical except that it specifies a wildcard value for either the event class or the event ID, the Apple Event Manager dispatches the more specific entry. For example, if an Apple event dispatch table includes one entry that specifies the event class as kAECoreSuite and the event ID as kAEDelete, and another entry that specifies the event class as kAECoreSuite and the event ID as typeWildCard, the Apple Event Manager dispatches the Apple event handler associated with the entry that specifies the event ID as kAEDelete.

In addition to the Apple event handler dispatch tables, applications can add entries to special handler dispatch tables, as described in “Managing Special Handler Dispatch Tables”. 
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
extern OSErr AEInstallEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   long handlerRefcon,
   Boolean isSysHandler
);

//function

/*AEGetEventHandler

Gets an event handler from an Apple event dispatch table.

OSErr AEGetEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP * handler,
   long * handlerRefcon,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the desired handler. See AEEventClass.
theAEEventID

The event ID for the desired handler. See AEEventID.
handler

A universal procedure pointer. On return, a pointer to the specified handler, if a dispatch table entry exists that exactly matches the values supplied in the parameters theAEEventClass and theAEEventID.

If you use the typeWildCard constant for either or both of these parameters, AEGetEventHandler will return an error unless an entry exists that specifies typeWildCard in exactly the same way. For example, if you specify typeWildCard in both the theAEEventClass parameter and the theAEEventID parameter, the Apple Event Manager will not return the first handler for any event class and event ID in the dispatch table; instead, it will only return a handler if an entry exists that specifies type typeWildCard for both the event class and the event ID.

For an explanation of wildcard values, see the Discussion section for AEInstallEventHandler.

See AEEventHandlerUPP.
handlerRefcon

A pointer to a reference constant. On return, the reference constant from the dispatch table entry for the specified handler. The reference constant may have a value of 0.
isSysHandler

Specifies the Apple event dispatch table to get the handler from. Pass TRUE to get the handler from the system dispatch table or FALSE to get the handler from your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.

In Mac OS 7.1 through 9.x and Mac OS X version v10.2 and later, AEGetEventHandler returns errAEHandlerNotInstalled when there’s not an exact match, even if a wildcard handler is installed that could handle the event. Mac OS X version v10.0.x and v10.1.x will return the wildcard handler.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AEGetEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP * handler,
   long * handlerRefcon,
   Boolean isSysHandler
);

/*AERemoveEventHandler

Removes an event handler entry from an Apple event dispatch table.

OSErr AERemoveEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   Boolean isSysHandler
);
Parameters
theAEEventClass

The event class for the handler to remove. See AEEventClass.
theAEEventID

The event ID for the handler to remove. See AEEventID.
handler

A universal procedure pointer to the handler to remove. Although the parameters theAEEventClass and theAEEventID are sufficient to identify the handler, you can identify the handler explicitly as a safeguard. If you pass NULL for this parameter, the Apple Event Manager relies solely on the event class and event ID to identify the handler.

If you use the typeWildCard constant for either or both of the event class and event ID parameters, AERemoveEventHandler will return an error unless an entry exists that specifies typeWildCard in exactly the same way. For example, if you specify typeWildCard in both the theAEEventClass parameter and the theAEEventID parameter, AERemoveEventHandler will not remove the first handler for any event class and event ID in the dispatch table; instead, it will only remove a handler if an entry exists that specifies type typeWildCard for both the event class and the event ID.

For an explanation of wildcard values, see the Discussion section for AEInstallEventHandler.

See AEEventHandlerUPP.
isSysHandler

Specifies the Apple event dispatch table to remove the handler from. Pass TRUE to remove the handler from the system dispatch table or FALSE to remove the handler from your application’s dispatch table. See Version Notes for related information.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive events—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AppleEvents.h*/
OSErr AERemoveEventHandler (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   AEEventHandlerUPP handler,
   Boolean isSysHandler
);

#ifdef __cplusplus
}
#endif
#endif