#ifndef FIXMATH_H
#define FIXMATH_H

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>
//#include <HYS/CarbonCore/FixMath.h>
#include <APPLE/CarbonCore/FixMath.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ff
You can use the ff macro to convert an integer to a Fixed number.

#define ff(a) ((Fixed)(a) << 16)
a 
An integer to be converted to a Fixed number. 
macro result 
A Fixed number having the same value as the integer. 
DESCRIPTION
The ff macro converts an integer a to a Fixed number. This macro name is shorthand notation for the IntToFixed macro, and provides identical functionality.

SEE ALSO
For an example of how to use the ff macro, see the section "Converting Number Formats" beginning on page 8-26.

The IntToFixed macro is described in the previous section.*/
#define ff(a) ((Fixed)(a) << 16)

/*FloatToFixed
You can use the FloatToFixed macro to convert a floating-point number to a Fixed number.

#define FloatToFixed(a) ((Fixed)((float) (a) * fixed1))
a 
A floating-point number to be converted to a Fixed number. 
macro result 
The closest Fixed number to the floating-point number. 
SPECIAL CONSIDERATIONS
QuickDraw GX also defines a shorthand version of this macro. The FloatToFixed macro can also be coded as fl(a).

SEE ALSO
The fl macro is described next.*/

#define FloatToFixed(a) ((Fixed)((float) (a) * fixed1))


/*fixed1


enum {
   fixed1 = 0x00010000,
   fract1 = 0x40000000,
   positiveInfinity = 0x7FFFFFFF,
   negativeInfinity = 0x80000000
};
Constants
fixed1

Available in Mac OS X v10.0 and later.
fract1

Available in Mac OS X v10.0 and later.
positiveInfinity

Available in Mac OS X v10.0 and later.
negativeInfinity

Available in Mac OS X v10.0 and later.*/

enum {
   fixed1 = 0x00010000,
   fract1 = 0x40000000,
   positiveInfinity = 0x7FFFFFFF,
   negativeInfinity = 0x80000000
};

//function

/*X2Fix

Converts an Extended number to a Fixed number.

Fixed X2Fix (
   double x
);
Parameters
x

The Extended number to be converted to a Fixed number. 
Return Value

The best Fixed approximation of the Extended number x. If x is greater than the maximum representable Fixed number, the X2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, X2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed X2Fix (
   double x
);

/*Fix2X

Converts a Fixed number to an Extended number.

double Fix2X (
   Fixed x
);
Parameters
x

The Fixed number to be converted to an Extended number. 
Return Value

The Extended equivalent of the Fixed number x. 
Special Considerations

Fix2X does not move memory; you can call it at interrupt time.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
double Fix2X (
   Fixed x
);
/*Long2Fix

Converts a LongInt number to a Fixed number.

Fixed Long2Fix (
   long x
);
Parameters
x

The long integer to be converted to a Fixed number. 
Return Value

The Fixed number equivalent to the long integer x. If x is greater than the maximum representable fixed-point number, the Long2Fix function returns $7FFFFFFF. If x is less than the negative number with the highest absolute value, Long2Fix returns $80000000. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed Long2Fix (
   long x
);

/*FixRatio

Obtains the Fixed equivalent of a fraction.

Fixed FixRatio (
   short numer,
   short denom
);
Parameters
numer

The numerator of the fraction. 
denom

The denominator of the fraction.
Return Value

The Fixed equivalent of the fraction numer/denom. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed FixRatio (
   short numer,
   short denom
);

/*Fix2Long

Converts a Fixed number to a LongInt number.

long Fix2Long (
   Fixed x
);
Parameters
x

The Fixed number to be converted to a long integer. 
Return Value

The long integer nearest to the Fixed number x. If x is halfway between two integers (0.5), it is rounded to the integer with the higher absolute value. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

long Fix2Long (
   Fixed x
);

/*FixMul

Multiplies a variable of type Fixed with another variable of type Fixed or with a variable of type Fract or LongInt.

Fixed FixMul (
   Fixed a,
   Fixed b
);
Parameters
a

The first operand, which can be a variable of type Fixed or a variable of type Fract or LongInt. 
b

The second operand, which can be a variable of type Fixed or a variable of type Fract or LongInt.
Return Value

The product of the numbers in a and b. At least one of a and b should be a variable of type Fixed. 

The returned value is in the format of a LongInt if one of a or b is a LongInt. It is a Fract number if one of a or b is Fract. It is a Fixed number if both a and b are Fixed numbers.

Overflows are set to the maximum representable value with the correct sign ($80000000 for negative results and $7FFFFFFF for positive results).

Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/

Fixed FixMul (
   Fixed a,
   Fixed b
);

/*FixRound

Rounds a fixed-point number to the nearest integer.

short FixRound (
   Fixed x
);
Parameters
x

The Fixed number to be rounded. 
Return Value

The Integer number nearest the Fixed number x. If the value is halfway between two integers (0.5), it is rounded up. Thus, 4.5 is rounded to 5, and –3.5 is rounded to –3. 
Discussion

To round a negative Fixed number so that values halfway between two integers are rounded to the number with the higher absolute value, negate the number, round it, and then negate it again. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
short FixRound (
   Fixed x
);

/*FixDiv

Divides two variables of the same type (Fixed, Fract, or LongInt) or to divide a LongInt or Fract number by a Fixed number.

Fixed FixDiv (
   Fixed x,
   Fixed y
);
Parameters
x

The first operand, which can be a variable of type Fixed or a variable of type Fract or LongInt. 
y

The second operand, which can be a variable of type Fixed or it can be a variable of the same type as the variable in parameter x.
Return Value

The quotient of the numbers in x and y. If the y parameter is in the format of a Fixed number, then the x parameter can be in the format of a Fixed, Fract, or LongInt number. If the y parameter is in the format of a Fract or LongInt number, then the x parameter must be in the same format. 

The returned value is in the format of a Fixed number if both x and y are both Fixed numbers, both Fract numbers, or both LongInt numbers. Otherwise, the returned value is the same type as the number in the x parameter.

Division by zero results in $8000000 if x is negative, and $7FFFFFFF otherwise; thus the special case 0/0 yields $7FFFFFFF.

Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed FixDiv (
   Fixed x,
   Fixed y
);

/*FracCos

Obtains a fast approximation of the cosine of a Fixed number.

Fract FracCos (
   Fixed x
);
Parameters
x

The Fixed number expressed in radians, whose cosine is to be calculated. 
Return Value

The cosine, expressed in radians, of the Fixed number x. 
Discussion

The approximation of p/4 used to compute the cosine is the hexadecimal value 0.C910, making the approximation of p equal to 3.1416015625, while p itself equals 3.14159265.... Despite the approximation of p, the cosine value obtained is usually correct to several decimal places. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fract FracCos (
   Fixed x
);

/*Frac2Fix

Converts a Fract number to a Fixed number.

Fixed Frac2Fix (
   Fract x
);
Parameters
x

The Fract number to be converted to a Fixed number. 
Return Value

The Fixed number that best approximates the Fract number x. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fixed Frac2Fix (
   Fract x
);

/*FracSin

Obtains a fast approximation of the sine of a Fixed number.

Fract FracSin (
   Fixed x
);
Parameters
x

The Fixed number expressed in radians, whose sine is to be calculated. 
Return Value

The sine, expressed in radians, of the Fixed number x. 
Discussion

The approximation of p/4 used to compute the sine is the hexadecimal value 0.C910, making the approximation of p equal to 3.1416015625, while p itself equals 3.14159265.... Despite the approximation of p, the sine value obtained is usually correct to several decimal places. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
FixMath.h*/
Fract FracSin (
   Fixed x
);

#ifdef __cplusplus
}
#endif

#endif