#ifndef GESTALT_H
#define GESTALT_H



#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef FILES_H
#include <CarbonCore/Files.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Folder Manager Attribute Selectors

Specify feature availability information for the Folder Manager.

enum {
   gestaltFindFolderAttr = 'fold',
   gestaltFindFolderPresent = 0,
   gestaltFolderDescSupport = 1,
   gestaltFolderMgrFollowsAliasesWhenResolving = 2,
   gestaltFolderMgrSupportsExtendedCalls = 3,
   gestaltFolderMgrSupportsDomains = 4,
   gestaltFolderMgrSupportsFSCalls = 5
};

Constants
gestaltFindFolderAttr

The selector you pass to the Gestalt function to determine the FindFolder function attributes.

Available in Mac OS X v10.0 and later.
gestaltFindFolderPresent

Available in Mac OS X v10.0 and later.
gestaltFolderDescSupport

If this bit is set, the extended Folder Manager functionality supporting folder descriptors and routings is available. This bit is set for versions of the Mac OS starting with Mac OS 8.

Available in Mac OS X v10.0 and later.
gestaltFolderMgrFollowsAliasesWhenResolving

Available in Mac OS X v10.0 and later.
gestaltFolderMgrSupportsExtendedCalls

Available in Mac OS X v10.0 and later.
gestaltFolderMgrSupportsDomains

Available in Mac OS X v10.0 and later.
gestaltFolderMgrSupportsFSCalls

Available in Mac OS X v10.0 and later.
Discussion

Before calling any Folder Manager functions, your application should pass the selector gestaltFindFolderAttr to the Gestalt function to determine which Folder Manager functions are available.*/
enum {
   gestaltFindFolderAttr = 'fold',
   gestaltFindFolderPresent = 0,
   gestaltFolderDescSupport = 1,
   gestaltFolderMgrFollowsAliasesWhenResolving = 2,
   gestaltFolderMgrSupportsExtendedCalls = 3,
   gestaltFolderMgrSupportsDomains = 4,
   gestaltFolderMgrSupportsFSCalls = 5
};

/*ATSUI Attribute Selectors

Specify feature availability for Apple Type Services for Unicode Imaging.

enum {
   gestaltATSUFeatures = 'uisf',
   gestaltATSUTrackingFeature = 0x00000001,
   gestaltATSUMemoryFeature = 0x00000001,
   gestaltATSUFallbacksFeature = 0x00000001,
   gestaltATSUGlyphBoundsFeature = 0x00000001,
   gestaltATSULineControlFeature = 0x00000001,
   gestaltATSULayoutCreateAndCopyFeature = 0x00000001,
   gestaltATSULayoutCacheClearFeature = 0x00000001,
   gestaltATSUTextLocatorUsageFeature = 0x00000002,
   gestaltATSULowLevelOrigFeatures = 0x00000004,
   gestaltATSUFallbacksObjFeatures = 0x00000008,
   gestaltATSUIgnoreLeadingFeature = 0x00000008,
   gestaltATSUByCharacterClusterFeature = 0x00000010,
   gestaltATSUAscentDescentControlsFeature = 0x00000010,
   gestaltATSUHighlightInactiveTextFeature = 0x00000010,
   gestaltATSUPositionToCursorFeature = 0x00000010,
   gestaltATSUBatchBreakLinesFeature = 0x00000010,
   gestaltATSUTabSupportFeature = 0x00000010,
   gestaltATSUDirectAccess = 0x00000010,
   gestaltATSUDecimalTabFeature  = 0x00000020,
   gestaltATSUBiDiCursorPositionFeature = 0x00000020,
   gestaltATSUNearestCharLineBreakFeature = 0x00000020,
   gestaltATSUHighlightColorControlFeature = 0x00000020,
   gestaltATSUUnderlineOptionsStyleFeature = 0x00000020,
   gestaltATSUStrikeThroughStyleFeature = 0x00000020,
   gestaltATSUDropShadowStyleFeature = 0x00000020
};

Constants
gestaltATSUFeatures

Specifies the ATSUI features available on the user’s system. You pass this selector to the Gestalt function. On return, the Gestalt function passes back a value that represents the features available in the version of ATSUI installed on the user’s system.

Available in Mac OS X v10.0 and later.
gestaltATSUTrackingFeature

If the bit specified by this mask constant is set, the functions ATSUCountFontTracking and ATSUGetIndFontTracking are available.

Available beginning with ATSUI 1.1. 
gestaltATSUMemoryFeature

If the bit specified by this mask is set, the functions ATSUCreateMemorySetting, ATSUSetCurrentMemorySetting, ATSUGetCurrentMemorySetting, and ATSUDisposeMemorySetting are available.

Available beginning with ATSUI 1.1.
gestaltATSUFallbacksFeature

If the bit specified by this mask is set, the functions ATSUSetFontFallbacks and ATSUGetFontFallbacks are available.

Available beginning with ATSUI 1.1.
gestaltATSUGlyphBoundsFeature

If the bit specified by this mask is set, the function ATSUGetGlyphBounds is available.

Available beginning with ATSU 1.1.
gestaltATSULineControlFeature

If the bit specified by this mask is set, the functions ATSUCopyLineControls, ATSUSetLineControls, ATSUGetLineControl, ATSUGetAllLineControls, and ATSUClearLineControls are available.

Available beginning with ATSUI 1.1.
gestaltATSULayoutCreateAndCopyFeature

If the bit specified by this mask is set, the function ATSUCreateAndCopyTextLayout is available.

Available beginning with ATSUI 1.1.
gestaltATSULayoutCacheClearFeature

If the bit specified by this mask is set, the function ATSUClearLayoutCache is available.

Available beginning with ATSUI 1.1. 
gestaltATSUTextLocatorUsageFeature

If the bit specified by this mask is set, the text-break locator attribute is available for both style and text layout objects.

Available beginning with ATSUI 1.2.
gestaltATSULowLevelOrigFeatures

If the bit specified by this mask is set, the low-level features introduced in ATSUI version 2.0 are available.

Available in Mac OS X v10.0 and later.
gestaltATSUFallbacksObjFeatures

If the bit specified by this mask is set, ATSUFontFallbacks objects are available.

Available beginning with ATSUI version 2.3.
gestaltATSUIgnoreLeadingFeature

If the bit specified by this mask is set, the line layout option (kATSIgnoreFontLeadingTag) to ignore the font leading value is available.

Available beginning with ATSUI version 2.3.
gestaltATSUByCharacterClusterFeature

If the bit specified by this mask is set, ATSUI cursor movement types are available.

Available beginning with ATSUI version 2.4.
gestaltATSUAscentDescentControlsFeature

If the bit specified by this mask is set, ascent and descent controls (kATSUDescentTag and kATSUAscentTag) are available.

Available beginning with ATSUI version 2.4.
gestaltATSUHighlightInactiveTextFeature

If the bit specified by this mask is set, the highlight inactive text feature is available.

Available beginning with ATSUI version 2.4.
gestaltATSUPositionToCursorFeature

If the bit specified by this mask is set, the position-to-cursor feature is available.

Available beginning with ATSUI version 2.4.
gestaltATSUBatchBreakLinesFeature

If the bit specified by this mask is set, the ATSUBatchBreakLines function is available.

Available beginning with ATSUI version 2.4.
gestaltATSUTabSupportFeature

If the bit specified by this mask is set, support for tabs is available.

Available beginning with ATSUI version 2.4.
gestaltATSUDirectAccess

If the bit specified by this mask is set, ATSU direct-access functions are available. These functions let you access glyph information directly.

Available beginning with ATSUI version 2.4.
gestaltATSUDecimalTabFeature

If the bit specified by this mask is set, your application can set a decimal tab character.

Available beginning with ATSUI version 2.5.
gestaltATSUBiDiCursorPositionFeature

If the bit specified by this mask is set, support for bidirectional cursor positioning is available.

Available beginning with ATSUI version 2.5.
gestaltATSUNearestCharLineBreakFeature

If the bit specified by this mask is set, the nearest character line break feature is available.

Available beginning with ATSUI version 2.5.
gestaltATSUHighlightColorControlFeature

If the bit specified by this mask is set, your application can control highlight color.

Available beginning with ATSUI version 2.5.
gestaltATSUUnderlineOptionsStyleFeature

If the bit specified by this mask is set, underline options are available.

Available beginning with ATSUI version 2.5.
gestaltATSUStrikeThroughStyleFeature

If the bit specified by this mask is set, strike through styles are available.

Available beginning with ATSUI version 2.5.
gestaltATSUDropShadowStyleFeature

If the bit specified by this mask is set, drop shadow features are available.

Available beginning with ATSUI version 2.5.
Discussion

You can pass the gestaltATSUFeature selector to the Gestalt function to obtain a value that specifies which ATSUI features are available on the user’s system. 

You can pass the gestaltATSUVersion selector to the Gestalt function to determine which version of ATSUI is installed on the user’s system. See ATSUI Version Selectors for more information*/
enum {
   gestaltATSUFeatures = 'uisf',
   gestaltATSUTrackingFeature = 0x00000001,
   gestaltATSUMemoryFeature = 0x00000001,
   gestaltATSUFallbacksFeature = 0x00000001,
   gestaltATSUGlyphBoundsFeature = 0x00000001,
   gestaltATSULineControlFeature = 0x00000001,
   gestaltATSULayoutCreateAndCopyFeature = 0x00000001,
   gestaltATSULayoutCacheClearFeature = 0x00000001,
   gestaltATSUTextLocatorUsageFeature = 0x00000002,
   gestaltATSULowLevelOrigFeatures = 0x00000004,
   gestaltATSUFallbacksObjFeatures = 0x00000008,
   gestaltATSUIgnoreLeadingFeature = 0x00000008,
   gestaltATSUByCharacterClusterFeature = 0x00000010,
   gestaltATSUAscentDescentControlsFeature = 0x00000010,
   gestaltATSUHighlightInactiveTextFeature = 0x00000010,
   gestaltATSUPositionToCursorFeature = 0x00000010,
   gestaltATSUBatchBreakLinesFeature = 0x00000010,
   gestaltATSUTabSupportFeature = 0x00000010,
   gestaltATSUDirectAccess = 0x00000010,
   gestaltATSUDecimalTabFeature  = 0x00000020,
   gestaltATSUBiDiCursorPositionFeature = 0x00000020,
   gestaltATSUNearestCharLineBreakFeature = 0x00000020,
   gestaltATSUHighlightColorControlFeature = 0x00000020,
   gestaltATSUUnderlineOptionsStyleFeature = 0x00000020,
   gestaltATSUStrikeThroughStyleFeature = 0x00000020,
   gestaltATSUDropShadowStyleFeature = 0x00000020
};

/*File System Manager Version Selector

Specifies version information for the File System Manager.

enum {
   gestaltFSMVersion = 'fsm '
};
Constants
gestaltFSMVersion

Pass this selector to the Gestalt function to determine the version of the HFS External File Systems Manager (FSM).

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltFSMVersion = 'fsm '
};

/*AppleScript Attribute Selectors

Specify feature availability information for AppleScript.

enum {
   gestaltAppleScriptAttr = 'ascr',
   gestaltAppleScriptPresent = 0,
   gestaltAppleScriptPowerPCSupport = 1
};
Constants
gestaltAppleScriptAttr

A selector you pass to the Gestalt function. If AppleScript is not present, the Gestalt function returns an error value; otherwise, it returns noErr and supplies, in the response parameter, a 32-bit value whose bits specify which AppleScript features are available.

The only bit currently in use specifies whether AppleScript is present. You can test this bit with the constant gestaltAppleScriptPresent.

Available in Mac OS X v10.0 and later.
gestaltAppleScriptPresent

A Gestalt attribute constant. If the bit specified by this constant is set in the response parameter value supplied by Gestalt for the gestaltAppleScriptAttr selector, AppleScript is present.

Available in Mac OS X v10.0 and later.
gestaltAppleScriptPowerPCSupport

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltAppleScriptAttr = 'ascr',
   gestaltAppleScriptPresent = 0,
   gestaltAppleScriptPowerPCSupport = 1
};

/*Finder Attribute Selectors

Specify feature availability for the Finder.

enum {
   gestaltFinderAttr = 'fndr',
   gestaltFinderDropEvent = 0,
   gestaltFinderMagicPlacement = 1,
   gestaltFinderCallsAEProcess = 2,
   gestaltOSLCompliantFinder = 3,
   gestaltFinderSupports4GBVolumes = 4,
   gestaltFinderHasClippings = 6,
   gestaltFinderFullDragManagerSupport = 7,
   gestaltFinderFloppyRootComments = 8,
   gestaltFinderLargeAndNotSavedFlavorsOK = 9,
   gestaltFinderUsesExtensibleFolderManager = 10,
   gestaltFinderUnderstandsRedirectedDesktopFolder = 11
};*/
enum {
   gestaltFinderAttr = 'fndr',
   gestaltFinderDropEvent = 0,
   gestaltFinderMagicPlacement = 1,
   gestaltFinderCallsAEProcess = 2,
   gestaltOSLCompliantFinder = 3,
   gestaltFinderSupports4GBVolumes = 4,
   gestaltFinderHasClippings = 6,
   gestaltFinderFullDragManagerSupport = 7,
   gestaltFinderFloppyRootComments = 8,
   gestaltFinderLargeAndNotSavedFlavorsOK = 9,
   gestaltFinderUsesExtensibleFolderManager = 10,
   gestaltFinderUnderstandsRedirectedDesktopFolder = 11
};



/*Appearance Manager Version Selector

Specifies version information for the Appearance Manager.

enum {
   gestaltAppearanceVersion = 'apvr'
};
Constants
gestaltAppearanceVersion

The Gestalt selector passed to determine which version of the Appearance Manager is installed. If this selector exists, Appearance Manager 1.0.1 (or later) is installed. The version number of the currently installed Appearance Manager is returned in the low-order word of the result in binary code decimal format (for example, version 1.0.1 would be 0x0101). If this selector does not exist but gestaltAppearanceAttr does, Appearance Manager 1.0 is installed.

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltAppearanceVersion = 'apvr'
};

/*Power Manager Attribute Selectors

Specify feature availability for the Power Manager.

enum {
   gestaltPowerMgrAttr = 'powr',
   gestaltPMgrExists = 0,
   gestaltPMgrCPUIdle = 1,
   gestaltPMgrSCC = 2,
   gestaltPMgrSound = 3,
   gestaltPMgrDispatchExists = 4,
   gestaltPMgrSupportsAVPowerStateAtSleepWake = 5
};
Constants
gestaltPowerMgrAttr

The Gestalt selector you pass to determine which Power Manager capabilities are available.

Available in Mac OS X v10.0 and later.
gestaltPMgrExists

If true, the Power Manager is present.

Available in Mac OS X v10.0 and later.
gestaltPMgrCPUIdle

If true the CPU is capable of going into a low–power-consumption state. 

Available in Mac OS X v10.0 and later.
gestaltPMgrSCC

If true, it is possible to stop the SCC clock, thus effectively turning off the serial ports. 

Available in Mac OS X v10.0 and later.
gestaltPMgrSound

If true, it is possible to turn off power to the sound circuits.

Available in Mac OS X v10.0 and later.
gestaltPMgrDispatchExists

If true, Dispatch is present.

Available in Mac OS X v10.0 and later.
gestaltPMgrSupportsAVPowerStateAtSleepWake

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltPowerMgrAttr = 'powr',
   gestaltPMgrExists = 0,
   gestaltPMgrCPUIdle = 1,
   gestaltPMgrSCC = 2,
   gestaltPMgrSound = 3,
   gestaltPMgrDispatchExists = 4,
   gestaltPMgrSupportsAVPowerStateAtSleepWake = 5
};

/*Classic Compatibility Attribute Selectors

Specify feature availability for the Classic environment.

enum {
   gestaltMacOSCompatibilityBoxAttr = 'bbox',
   gestaltMacOSCompatibilityBoxPresent = 0,
   gestaltMacOSCompatibilityBoxHasSerial = 1,
   gestaltMacOSCompatibilityBoxless = 2
};*/
enum {
   gestaltMacOSCompatibilityBoxAttr = 'bbox',
   gestaltMacOSCompatibilityBoxPresent = 0,
   gestaltMacOSCompatibilityBoxHasSerial = 1,
   gestaltMacOSCompatibilityBoxless = 2
};

/*Display Manager Attribute Selectors

Specify feature availability for the Display Manager.

enum {
   gestaltDisplayMgrAttr = 'dply',
   gestaltDisplayMgrPresent = 0,
   gestaltDisplayMgrCanSwitchMirrored = 2,
   gestaltDisplayMgrSetDepthNotifies = 3,
   gestaltDisplayMgrCanConfirm = 4,
   gestaltDisplayMgrColorSyncAware = 5,
   gestaltDisplayMgrGeneratesProfiles = 6,
   gestaltDisplayMgrSleepNotifies = 7
};
Constants
gestaltDisplayMgrAttr

The Gestalt selector you pass to determine which Display Manager attributes are present.

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrPresent

If true, the Display Manager is present.

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrCanSwitchMirrored

If true, the Display Manager can switch modes on mirrored displays.

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrSetDepthNotifies

If true, and you have registered for notification and you will be notified of depth mode changes.

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrCanConfirm

Not yet supported. Most commonly comes up for display modes that are not marked kModeSafe. There is currently no system support for trying an unsafe mode and then restoring if the user does not confirm. When this is supported, this bit will be set.

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrColorSyncAware

If true, Display Manager supports profiles for displays. 

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrGeneratesProfiles

Available in Mac OS X v10.0 and later.
gestaltDisplayMgrSleepNotifies

Available in Mac OS X v10.2 and later.
Discussion

Before calling any function dependent upon the Display Manager, your application should pass the selector gestaltDisplayMgrAttr to the Gestalt function to determine the Display Manager attributes that are present.*/
enum {
   gestaltDisplayMgrAttr = 'dply',
   gestaltDisplayMgrPresent = 0,
   gestaltDisplayMgrCanSwitchMirrored = 2,
   gestaltDisplayMgrSetDepthNotifies = 3,
   gestaltDisplayMgrCanConfirm = 4,
   gestaltDisplayMgrColorSyncAware = 5,
   gestaltDisplayMgrGeneratesProfiles = 6,
   gestaltDisplayMgrSleepNotifies = 7
};

/*QuickDraw Attribute Selectors

Specify feature availability information for QuickDraw.

enum {
   gestaltQuickdrawFeatures = 'qdrw',
   gestaltHasColor = 0,
   gestaltHasDeepGWorlds = 1,
   gestaltHasDirectPixMaps = 2,
   gestaltHasGrayishTextOr = 3,
   gestaltSupportsMirroring = 4,
   gestaltQDHasLongRowBytes = 5
};
Constants
gestaltQuickdrawFeatures

The selector you pass to the Gestalt function to determine the QuickDraw features.

Available in Mac OS X v10.0 and later.
gestaltHasColor

Available in Mac OS X v10.0 and later.
gestaltHasDeepGWorlds

Available in Mac OS X v10.0 and later.
gestaltHasDirectPixMaps

Available in Mac OS X v10.0 and later.
gestaltHasGrayishTextOr

Available in Mac OS X v10.0 and later.
gestaltSupportsMirroring

Available in Mac OS X v10.0 and later.
gestaltQDHasLongRowBytes

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltQuickdrawFeatures = 'qdrw',
   gestaltHasColor = 0,
   gestaltHasDeepGWorlds = 1,
   gestaltHasDirectPixMaps = 2,
   gestaltHasGrayishTextOr = 3,
   gestaltSupportsMirroring = 4,
   gestaltQDHasLongRowBytes = 5
};


/*Display Manager Version Selector

Specifies version information for the Display Manager.

enum {
   gestaltDisplayMgrVers = 'dplv'
};
Constants
gestaltDisplayMgrVers

The Gestalt selector you pass to determine what version of the Display Manager is present. For example, a Gestalt result may be 0x00020500, which means that the Display Manager version 2.5 is present.

Available in Mac OS X v10.0 and later.
Discussion

To determine the version of the current Display Manager, your application should pass the selector gestaltDisplayMgrVers to the Gestalt function.*/
enum {
   gestaltDisplayMgrVers = 'dplv'
};


/*Dialog Manager Attribute Selectors

Specify feature availability for the Dialog Manager.

enum {
   gestaltDITLExtAttr = 'ditl',
   gestaltDITLExtPresent = 0,
   gestaltDITLExtSupportsIctb = 1
};
Constants
gestaltDITLExtAttr

Available in Mac OS X v10.0 and later.
gestaltDITLExtPresent

If this flag bit is TRUE, then the Dialog Manager extensions included in System 7 are available. 

Available in Mac OS X v10.0 and later.
gestaltDITLExtSupportsIctb

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltDITLExtAttr = 'ditl',
   gestaltDITLExtPresent = 0,
   gestaltDITLExtSupportsIctb = 1
};


/*Preemptive Function Atrribute Selectors

Specify feature availability information for preemptive system software functions.

enum {
   gestaltMPCallableAPIsAttr = 'mpsc',
   gestaltMPFileManager = 0,
   gestaltMPDeviceManager = 1,
   gestaltMPTrapCalls = 2
};
Constants
gestaltMPCallableAPIsAttr

The Gestalt selector passed to determine the availability of preemptive system software functions. The Gestalt function produces a 32-bit value that you should test to determine which what type of preemptive calls are allowed. 

Available in Mac OS X v10.0 and later.
gestaltMPFileManager

If this bit is set, you can call preemptively safe File Manager functions.

Available in Mac OS X v10.0 and later.
gestaltMPDeviceManager

If this bit is set, you can call preemptively safe Device Manager function.

Available in Mac OS X v10.0 and later.
gestaltMPTrapCalls

Available in Mac OS X v10.0 and later.
Discussion

Before calling any Mac OS system software functions from a preemptive task , you should call the Gestalt function with the gestaltMPCallableAPIsAttr selector set to determine which preemptively safe system calls are allowed. 

Note that for functions that are shared between managers (for example, PBCloseSync), you should check the bit that is appropriate for the manager you want to call. 
Version Notes

Introduced with Multiprocessing Services 2.1*/
enum {
   gestaltMPCallableAPIsAttr = 'mpsc',
   gestaltMPFileManager = 0,
   gestaltMPDeviceManager = 1,
   gestaltMPTrapCalls = 2
};


/*Code Fragment Manager Attribute Selectors

Specify feature availability information for the Code Fragment Manager.

enum {
   gestaltCFMAttr = 'cfrg',
   gestaltCFMPresent = 0,
   gestaltCFMPresentMask = 0x0001,
   gestaltCFM99Present = 2,
   gestaltCFM99PresentMask = 0x0004
};*/
enum {
   gestaltCFMAttr = 'cfrg',
   gestaltCFMPresent = 0,
   gestaltCFMPresentMask = 0x0001,
   gestaltCFM99Present = 2,
   gestaltCFM99PresentMask = 0x0004
};


/*File System Attribute Selectors

Specify feature availability for the file system.

enum {
   gestaltFSAttr = 'fs  ',
   gestaltFullExtFSDispatching = 0,
   gestaltHasFSSpecCalls = 1,
   gestaltHasFileSystemManager = 2,
   gestaltFSMDoesDynamicLoad = 3,
   gestaltFSSupports4GBVols = 4,
   gestaltFSSupports2TBVols = 5,
   gestaltHasExtendedDiskInit = 6,
   gestaltDTMgrSupportsFSM = 7,
   gestaltFSNoMFSVols = 8,
   gestaltFSSupportsHFSPlusVols = 9,
   gestaltFSIncompatibleDFA82 = 10
};
Constants
gestaltFSAttr

A selector you pass to the Gestalt function. If the Gestalt function returns noErr, the response parameter contains a 32-bit value specifying the features of the file system.

Available in Mac OS X v10.0 and later.
gestaltFullExtFSDispatching

If this bit is set in the response parameter, all of the functions selected through the _HFSDispatch trap are available to external file systems. If this bit is clear, the File Manager checks the selector passed to _HFSDispatch and ensures that it is valid; if the selector is invalid, the result code paramErr is returned to the caller. If this bit is set, no such validity checking is performed. See the Guide to the File System Manager for more information on external file systems.

Available in Mac OS X v10.0 and later.
gestaltHasFSSpecCalls

If this bit is set in the response parameter, the operating environment provides the file system specification (FSSpec) versions of the basic file-manipulation functions, as well as the FSMakeFSSpec function.

Available in Mac OS X v10.0 and later.
gestaltHasFileSystemManager

If this bit is set in the response parameter, the File System Manager is present. See the Guide to the File System Manager for more information about the File System Manager. 

Available in Mac OS X v10.0 and later.
gestaltFSMDoesDynamicLoad

If this bit is set in the response parameter, the File System Manager supports dynamic loading of external file system code resources.

Available in Mac OS X v10.0 and later.
gestaltFSSupports4GBVols

If this bit is set in the response parameter, the file system supports 4 gigabyte volumes.

Available in Mac OS X v10.0 and later.
gestaltFSSupports2TBVols

If this bit is set in the response parameter, the file system supports 2 terabyte volumes.

Available in Mac OS X v10.0 and later.
gestaltHasExtendedDiskInit

If this bit is set in the response parameter, the extended Disk Initialization Package functions are present. These are the DIXFormat, DIXZero, or DIReformat functions. See the Guide to the File System Manager for more information about the Disk Initialization Package interfaces.

Available in Mac OS X v10.0 and later.
gestaltDTMgrSupportsFSM

If this bit is set in the response parameter, the desktop database supports File System Manager-based foreign file systems.

Available in Mac OS X v10.0 and later.
gestaltFSNoMFSVols

If this bit is set in the response parameter, the file system does not support MFS volumes. 

Available in Mac OS X v10.0 and later.
gestaltFSSupportsHFSPlusVols

If this bit is set in the response parameter, the file system supports HFS Plus volumes. 

Available in Mac OS X v10.0 and later.
gestaltFSIncompatibleDFA82

If this bit is set in the response parameter, VCB and FCB structures are changed; DFA 8.2 is incompatible.

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltFSAttr = 'fs  ',
   gestaltFullExtFSDispatching = 0,
   gestaltHasFSSpecCalls = 1,
   gestaltHasFileSystemManager = 2,
   gestaltFSMDoesDynamicLoad = 3,
   gestaltFSSupports4GBVols = 4,
   gestaltFSSupports2TBVols = 5,
   gestaltHasExtendedDiskInit = 6,
   gestaltDTMgrSupportsFSM = 7,
   gestaltFSNoMFSVols = 8,
   gestaltFSSupportsHFSPlusVols = 9,
   gestaltFSIncompatibleDFA82 = 10
};

/*Memory Attribute Selectors

Specify feature availability information for memory.

enum {
   gestaltOSAttr = 'os  ',
   gestaltSysZoneGrowable = 0,
   gestaltLaunchCanReturn = 1,
   gestaltLaunchFullFileSpec = 2,
   gestaltLaunchControl = 3,
   gestaltTempMemSupport = 4,
   gestaltRealTempMemory = 5,
   gestaltTempMemTracked = 6,
   gestaltIPCSupport = 7,
   gestaltSysDebuggerSupport = 8,
   gestaltNativeProcessMgrBit = 19,
   gestaltAltivecRegistersSwappedCorrectlyBit = 20
};
Constants
gestaltOSAttr

The Gestalt selector you pass to determine general Operating System attributes, such as whether temporary memory handles are real handles. The low-order bits of the response parameter are interpreted as bit flags. A flag is set to 1 to indicate that the corresponding feature is available. Currently, the following bits are significant.

Available in Mac OS X v10.0 and later.
gestaltSysZoneGrowable

Available in Mac OS X v10.0 and later.
gestaltLaunchCanReturn

If this bit is set, the _Launch trap macro can return to the caller. The _Launch trap macro in system software version 7.0 (and in earlier versions running MultiFinder) gives your application the option to continue running after it launches another application. In earlier versions of system software not running MultiFinder, the _Launch trap macro forces the launching application to quit.

Available in Mac OS X v10.0 and later.
gestaltLaunchFullFileSpec

If this bit is set, the launchControlFlags field supports control flags in addition to the launchContinue flag, and if the _Launch trap can process the launchAppSpec, launchProcessSN, launchPreferredSize, launchMinimumSize, launchAvailableSize, and launchAppParameters fields in the launch parameter block.

Available in Mac OS X v10.0 and later.
gestaltLaunchControl

If this bit is set, the Process Manager is available.

Available in Mac OS X v10.0 and later.
gestaltTempMemSupport

If true, there is temporary memory support.

Available in Mac OS X v10.0 and later.
gestaltRealTempMemory

If true, temporary memory handles are real.

Available in Mac OS X v10.0 and later.
gestaltTempMemTracked

If true, temporary memory handles are tracked.

Available in Mac OS X v10.0 and later.
gestaltIPCSupport

Available in Mac OS X v10.0 and later.
gestaltSysDebuggerSupport

Available in Mac OS X v10.0 and later.
gestaltNativeProcessMgrBit

Available in Mac OS X v10.0 and later.
gestaltAltivecRegistersSwappedCorrectlyBit

Available in Mac OS X v10.2 and later.*/
enum {
   gestaltOSAttr = 'os  ',
   gestaltSysZoneGrowable = 0,
   gestaltLaunchCanReturn = 1,
   gestaltLaunchFullFileSpec = 2,
   gestaltLaunchControl = 3,
   gestaltTempMemSupport = 4,
   gestaltRealTempMemory = 5,
   gestaltTempMemTracked = 6,
   gestaltIPCSupport = 7,
   gestaltSysDebuggerSupport = 8,
   gestaltNativeProcessMgrBit = 19,
   gestaltAltivecRegistersSwappedCorrectlyBit = 20
};


/*Icon Services Attribute Selectors

Specify feature availability for Icon Services.

enum {
   gestaltIconUtilitiesAttr = 'icon',
   gestaltIconUtilitiesPresent = 0,
   gestaltIconUtilitiesHas48PixelIcons = 1,
   gestaltIconUtilitiesHas32BitIcons = 2,
   gestaltIconUtilitiesHas8BitDeepMasks = 3,
   gestaltIconUtilitiesHasIconServices = 4
};
Constants
gestaltIconUtilitiesAttr

The Gestalt selector passed to determine which features of Icon Services are present. The Gestalt function produces a 32-bit value whose bits you should test to determine which Icon Services features are available.

Note: available in System 7.0, despite gestalt.

Available in Mac OS X v10.0 and later.
gestaltIconUtilitiesPresent

True if icon utilities are present. 

Available in Mac OS X v10.0 and later.
gestaltIconUtilitiesHas48PixelIcons

True if 48x48 icons are supported by IconUtilities.

Available in Mac OS X v10.0 and later.
gestaltIconUtilitiesHas32BitIcons

True if 32-bit deep icons are supported.

Available in Mac OS X v10.0 and later.
gestaltIconUtilitiesHas8BitDeepMasks

True if 8-bit deep masks are supported.

Available in Mac OS X v10.0 and later.
gestaltIconUtilitiesHasIconServices

True if IconServices is present. 

Available in Mac OS X v10.0 and later.
Discussion

Before calling any Icon Services functions, your application should pass the selector gestaltIconUtilitiesAttr to the Gestalt function.*/
enum {
   gestaltIconUtilitiesAttr = 'icon',
   gestaltIconUtilitiesPresent = 0,
   gestaltIconUtilitiesHas48PixelIcons = 1,
   gestaltIconUtilitiesHas32BitIcons = 2,
   gestaltIconUtilitiesHas8BitDeepMasks = 3,
   gestaltIconUtilitiesHasIconServices = 4
};

/*Thread Manager Attribute Selectors

Specify feature availability information for the Thread Manager.

enum {
   gestaltThreadMgrAttr = 'thds',
   gestaltThreadMgrPresent = 0,
   gestaltSpecificMatchSupport = 1,
   gestaltThreadsLibraryPresent = 2
};
Constants
gestaltThreadMgrAttr

Available in Mac OS X v10.0 and later.
gestaltThreadMgrPresent

This bit is set if the Thread Manager is present.

Available in Mac OS X v10.0 and later.
gestaltSpecificMatchSupport

This bit is set if the Thread Manager supports the allocation of threads based on an exact match with the requested stack size. If this bit is not set, the Thread Manager allocates threads based on the closest match to the requested stack size.

Available in Mac OS X v10.0 and later.
gestaltThreadsLibraryPresent

This bit is set if the native version of the threads library has been loaded.

Available in Mac OS X v10.0 and later.
Discussion

Before calling any function dependent upon the Thread Manager, your application should pass the selector gestaltThreadMgrAttr to the Gestalt function to determine the Thread Manager attributes that are present.*/
enum {
   gestaltThreadMgrAttr = 'thds',
   gestaltThreadMgrPresent = 0,
   gestaltSpecificMatchSupport = 1,
   gestaltThreadsLibraryPresent = 2
};


/*Drag Manager Attribute Selectors

Specify feature availability information for the Drag Manager.

enum {
   gestaltDragMgrAttr = 'drag',
   gestaltDragMgrPresent = 0,
   gestaltDragMgrFloatingWind = 1,
   gestaltPPCDragLibPresent = 2,
   gestaltDragMgrHasImageSupport = 3,
   gestaltCanStartDragInFloatWindow = 4,
   gestaltSetDragImageUpdates = 5
};
Constants
gestaltDragMgrAttr

The Gestalt selector passed to determine what features of the Drag Manager are present. Passing the gestaltDragMgrAttr constant produces a 32-bit value whose bits you should test to determine what Drag Manager functionality is available.

Available in Mac OS X v10.0 and later.
gestaltDragMgrPresent

If the bit specified by this mask is set, the Drag Manager functions are available.

Available in Mac OS X v10.0 and later.
gestaltDragMgrFloatingWind

If the bit specified by this mask is set, the Drag Manager floating window support functions are available.

Available in Mac OS X v10.0 and later.
gestaltPPCDragLibPresent

If the bit specified by this mask is set, the Drag Manager PPC Drag Library functions are available.

Available in Mac OS X v10.0 and later.
gestaltDragMgrHasImageSupport

If the bit specified by this mask is set, the Drag Manager image support functions are available.

Available in Mac OS X v10.0 and later.
gestaltCanStartDragInFloatWindow

If the bit specified by this mask is set, the Drag Manager can start a drag in a floating window.

Available in Mac OS X v10.0 and later.
gestaltSetDragImageUpdates

Available in Mac OS X v10.1 and later.*/

enum {
   gestaltDragMgrAttr = 'drag',
   gestaltDragMgrPresent = 0,
   gestaltDragMgrFloatingWind = 1,
   gestaltPPCDragLibPresent = 2,
   gestaltDragMgrHasImageSupport = 3,
   gestaltCanStartDragInFloatWindow = 4,
   gestaltSetDragImageUpdates = 5
};


/*QuickDraw Version Selectors

Specify version information for QuickDraw.

enum {
   gestaltQuickdrawVersion = 'qd  ',
   gestaltOriginalQD = 0x0000,
   gestalt8BitQD = 0x0100,
   gestalt32BitQD = 0x0200,
   gestalt32BitQD11 = 0x0201,
   gestalt32BitQD12 = 0x0220,
   gestalt32BitQD13 = 0x0230,
   gestaltAllegroQD = 0x0250,
   gestaltMacOSXQD = 0x0300
};
Constants
gestaltQuickdrawVersion

The Gestalt selector you pass to determine what version of QuickDraw is present. For QuickDraw Text, the Gestalt selector you pass to determine what version of QuickDraw Text is present.

Available in Mac OS X v10.0 and later.
gestaltOriginalQD

Available in Mac OS X v10.0 and later.
gestalt8BitQD

Available in Mac OS X v10.0 and later.
gestalt32BitQD

Available in Mac OS X v10.0 and later.
gestalt32BitQD11

Available in Mac OS X v10.0 and later.
gestalt32BitQD12

Available in Mac OS X v10.0 and later.
gestalt32BitQD13

Available in Mac OS X v10.0 and later.
gestaltAllegroQD

Available in Mac OS X v10.0 and later.
gestaltMacOSXQD

Available in Mac OS X v10.0 and later.
Discussion

The version of QuickDraw is encoded as a revision number in the low-order word of the return value. The high-order byte represents the major revision number, and the low-order byte represents the minor revision number. For example, version 1.3 of 32-Bit QuickDraw represents QuickDraw revision 2.3; its response value is $0230.

Values having a major revision number of 1 or 2 indicate that Color QuickDraw is available, in either the 8-bit or 32-bit version. These results do not, however, indicate whether a color monitor is attached to the system. You must use high-level QuickDraw functions to obtain that information.*/

enum {
   gestaltQuickdrawVersion = 'qd  ',
   gestaltOriginalQD = 0x0000,
   gestalt8BitQD = 0x0100,
   gestalt32BitQD = 0x0200,
   gestalt32BitQD11 = 0x0201,
   gestalt32BitQD12 = 0x0220,
   gestalt32BitQD13 = 0x0230,
   gestaltAllegroQD = 0x0250,
   gestaltMacOSXQD = 0x0300
};



/*QuickTime VR Version Selector

Specifies version information for QuickTime VR.

enum {
   gestaltQTVRMgrVers = 'qtvv'
};*/

enum {
   gestaltQTVRMgrVers = 'qtvv'
};


/*QuickTime VR Feature Selectors

Specify feature availability information for QuickTime VR.

enum {
   gestaltQTVRMgrAttr = 'qtvr',
   gestaltQTVRMgrPresent = 0,
   gestaltQTVRObjMoviesPresent = 1,
   gestaltQTVRCylinderPanosPresent = 2,
   gestaltQTVRCubicPanosPresent = 3
};*/

enum {
   gestaltQTVRMgrAttr = 'qtvr',
   gestaltQTVRMgrPresent = 0,
   gestaltQTVRObjMoviesPresent = 1,
   gestaltQTVRCylinderPanosPresent = 2,
   gestaltQTVRCubicPanosPresent = 3
};

/*Carbon Version Selector

Specifies version information for Carbon.

enum {
   gestaltCarbonVersion = 'cbon'
};*/
enum {
   gestaltCarbonVersion = 'cbon'
};


/*Appearance Manager Attribute Selectors

Specify feature availability information for the Appearance Manager.

enum {
   gestaltAppearanceAttr = 'appr',
   gestaltAppearanceExists = 0,
   gestaltAppearanceCompatMode = 1
};
Constants
gestaltAppearanceAttr

The Gestalt selector passed to determine whether the Appearance Manager is present. Produces a 32-bit value whose bits you should test to determine which Appearance Manager features are available.

Available in Mac OS X v10.0 and later.
gestaltAppearanceExists

If this bit is set, Appearance Manager functions are available. To determine which version of the Appearance Manager is installed, check for the presence of the Gestalt selector gestaltAppearanceVersion. If this bit is not set, Appearance Manager functions are not available. 

Available in Mac OS X v10.0 and later.
gestaltAppearanceCompatMode

If this bit is set, systemwide platinum appearance is off. When systemwide platinum appearance is off, the Appearance Manager does not auto-map standard System 7 definition functions to their Mac OS 8 equivalents (for those applications that have not called RegisterAppearanceClient). If this bit is not set, systemwide platinum appearance is on, and the Appearance Manager auto-maps standard System 7 definition functions to their Mac OS 8 equivalents for all applications.

Available in Mac OS X v10.0 and later.
Discussion

Before calling any functions dependent upon the Appearance Manager’s presence, your application should pass the selector gestaltAppearanceAttr to the Gestalt function to determine whether the Appearance Manager is present. To determine which version of the Appearance Manager is installed, your application should check for the presence of the Gestalt selector gestaltAppearanceVersion.*/
enum {
   gestaltAppearanceAttr = 'appr',
   gestaltAppearanceExists = 0,
   gestaltAppearanceCompatMode = 1
};

/*QuickTime Attribute Selectors

Specify feature availability information for QuickTime.

enum {
   gestaltQuickTimeFeatures = 'qtrs',
   gestaltPPCQuickTimeLibPresent = 0
};*/
enum {
   gestaltQuickTimeFeatures = 'qtrs',
   gestaltPPCQuickTimeLibPresent = 0
};

/*Processor Type Selector

Specifies information about the type of microprocessor.

enum {
   gestaltProcessorType = 'proc',
   gestalt68000 = 1,
   gestalt68010 = 2,
   gestalt68020 = 3,
   gestalt68030 = 4,
   gestalt68040 = 5
};
Constants
gestaltProcessorType

The selector you pass to the Gestalt function to determine the type of microprocessor currently running.

Available in Mac OS X v10.0 and later.
gestalt68000

Available in Mac OS X v10.0 and later.
gestalt68010

Available in Mac OS X v10.0 and later.
gestalt68020

Available in Mac OS X v10.0 and later.
gestalt68030

Available in Mac OS X v10.0 and later.
gestalt68040

Available in Mac OS X v10.0 and later.*/

enum {
   gestaltProcessorType = 'proc',
   gestalt68000 = 1,
   gestalt68010 = 2,
   gestalt68020 = 3,
   gestalt68030 = 4,
   gestalt68040 = 5
};


/*Native CPU Selectors

Specify the native CPU type or family.

enum {
   gestaltNativeCPUtype = 'cput',
   gestaltNativeCPUfamily = 'cpuf',
   gestaltCPU68000 = 0,
   gestaltCPU68010 = 1,
   gestaltCPU68020 = 2,
   gestaltCPU68030 = 3,
   gestaltCPU68040 = 4,
   gestaltCPU601 = 0x0101,
   gestaltCPU603 = 0x0103,
   gestaltCPU604 = 0x0104,
   gestaltCPU603e = 0x0106,
   gestaltCPU603ev = 0x0107,
   gestaltCPU750 = 0x0108,
   gestaltCPU604e = 0x0109,
   gestaltCPU604ev = 0x010A,
   gestaltCPUG4 = 0x010C,
   gestaltCPUG47450 = 0x0110
};
Constants
gestaltNativeCPUtype

The selector you pass to the Gestalt function to determine the native CPU type.

Available in Mac OS X v10.0 and later.
gestaltNativeCPUfamily

Available in Mac OS X v10.0 and later.
gestaltCPU68000

Available in Mac OS X v10.0 and later.
gestaltCPU68010

Available in Mac OS X v10.0 and later.
gestaltCPU68020

Available in Mac OS X v10.0 and later.
gestaltCPU68030

Available in Mac OS X v10.0 and later.
gestaltCPU68040

Available in Mac OS X v10.0 and later.
gestaltCPU601

Available in Mac OS X v10.0 and later.
gestaltCPU603

Available in Mac OS X v10.0 and later.
gestaltCPU604

Available in Mac OS X v10.0 and later.
gestaltCPU603e

Available in Mac OS X v10.0 and later.
gestaltCPU603ev

Available in Mac OS X v10.0 and later.
gestaltCPU750

Available in Mac OS X v10.0 and later.
gestaltCPU604e

Available in Mac OS X v10.0 and later.
gestaltCPU604ev

Available in Mac OS X v10.0 and later.
gestaltCPUG4

Available in Mac OS X v10.0 and later.
gestaltCPUG47450

Available in Mac OS X v10.2 and later.
Discussion

The use of these selectors is no longer recommended. You can use the gestaltSysArchitecture selector to determine whether your application is running on a PowerPC or Intel-based Macintosh. If you are trying to determine whether you can use a particular processor feature, you should check directly for that feature using a BSD library function such as sysctl or sysctlbyname. For more information, see Mac OS X Man Pages.*/
enum {
   gestaltNativeCPUtype = 'cput',
   gestaltNativeCPUfamily = 'cpuf',
   gestaltCPU68000 = 0,
   gestaltCPU68010 = 1,
   gestaltCPU68020 = 2,
   gestaltCPU68030 = 3,
   gestaltCPU68040 = 4,
   gestaltCPU601 = 0x0101,
   gestaltCPU603 = 0x0103,
   gestaltCPU604 = 0x0104,
   gestaltCPU603e = 0x0106,
   gestaltCPU603ev = 0x0107,
   gestaltCPU750 = 0x0108,
   gestaltCPU604e = 0x0109,
   gestaltCPU604ev = 0x010A,
   gestaltCPUG4 = 0x010C,
   gestaltCPUG47450 = 0x0110
};


/*Apple Event Manager Attribute Selectors

Specify feature availability information for the Apple Event Manager.

enum {
   gestaltAppleEventsAttr = 'evnt',
   gestaltAppleEventsPresent = 0,
   gestaltScriptingSupport = 1,
   gestaltOSLInSystem = 2,
   gestaltSupportsApplicationURL = 4
};
Constants
gestaltAppleEventsAttr

A selector you pass to the Gestalt function. If the Apple Event Manager is not present, the Gestalt function returns an error value; otherwise, it returns noErr and supplies, in the response parameter, a 32-bit value whose bits specify which features of the Apple Event Manager are available.

Available in Mac OS X v10.0 and later.
gestaltAppleEventsPresent

A Gestalt attribute constant. If the bit specified by this constant is set in the response parameter value supplied by Gestalt for the gestaltAppleEventsAttr selector, the Apple Event Manager is present and installed in the system.

Available in Mac OS X v10.0 and later.
gestaltScriptingSupport

A Gestalt attribute constant. If the bit specified by this constant is set in the response parameter value supplied by Gestalt for the gestaltAppleEventsAttr selector, the Open Scripting Architecture (OSA) is available to provide scripting support. The OSA is described in “Scripting Components”.

Available in Mac OS X v10.0 and later.
gestaltOSLInSystem

A Gestalt attribute constant. If the bit specified by this constant is set in the response parameter value supplied by Gestalt for the gestaltAppleEventsAttr selector, the Object Support Library (OSL) is part of the system. 

Available in Mac OS X v10.0 and later.
gestaltSupportsApplicationURL

Available in Mac OS X v10.1 and later.*/

enum {
   gestaltAppleEventsAttr = 'evnt',
   gestaltAppleEventsPresent = 0,
   gestaltScriptingSupport = 1,
   gestaltOSLInSystem = 2,
   gestaltSupportsApplicationURL = 4
};


/*Standard File Attribute Selectors

Specify feature availabity information for Standard File.

enum {
   gestaltStandardFileAttr = 'stdf',
   gestaltStandardFile58 = 0,
   gestaltStandardFileTranslationAware = 1,
   gestaltStandardFileHasColorIcons = 2,
   gestaltStandardFileUseGenericIcons = 3,
   gestaltStandardFileHasDynamicVolumeAllocation = 4
};
Constants
gestaltStandardFileAttr

The selector you pass to the Gestalt function to determine the Standard File Package attributes.

Available in Mac OS X v10.0 and later.
gestaltStandardFile58

If the gestaltStandardFile58 flag bit is set, you can call the four new procedures—StandardPutFile, StandardGetFile, CustomPutFile, and CustomGetFile—introduced with System 7. (The name of the constant reflects the enabling of selectors 5 through 8 on the trap macro that handles the Standard File Package.)

Available in Mac OS X v10.0 and later.
gestaltStandardFileTranslationAware

Available in Mac OS X v10.0 and later.
gestaltStandardFileHasColorIcons

Available in Mac OS X v10.0 and later.
gestaltStandardFileUseGenericIcons

Available in Mac OS X v10.0 and later.
gestaltStandardFileHasDynamicVolumeAllocation

Available in Mac OS X v10.0 and later.*/

enum {
   gestaltStandardFileAttr = 'stdf',
   gestaltStandardFile58 = 0,
   gestaltStandardFileTranslationAware = 1,
   gestaltStandardFileHasColorIcons = 2,
   gestaltStandardFileUseGenericIcons = 3,
   gestaltStandardFileHasDynamicVolumeAllocation = 4
};


/*Image Compression Manager Version Selector

Specifies the version of the Image Compression Manager.

enum {
   gestaltCompressionMgr = 'icmp'
};
Constants
gestaltCompressionMgr

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltCompressionMgr = 'icmp'
};


/*Menu Manager Selectors in Mac OS 8.5

Specify version and feature availability information for the Menu Manager in Mac OS 8.5

enum {
   gestaltMenuMgrAttr = 'menu',
   gestaltMenuMgrPresent = (1L << 0),
   gestaltMenuMgrPresentBit = 0,
   gestaltMenuMgrAquaLayoutBit = 1,
   gestaltMenuMgrMultipleItemsWithCommandIDBit = 2,
   gestaltMenuMgrRetainsIconRefBit = 3,
   gestaltMenuMgrSendsMenuBoundsToDefProcBit = 4,
   gestaltMenuMgrMoreThanFiveMenusDeepBit = 5,
   gestaltMenuMgrPresentMask = (1L << gestaltMenuMgrPresentBit),
   gestaltMenuMgrAquaLayoutMask = (1L << gestaltMenuMgrAquaLayoutBit),
   gestaltMenuMgrMultipleItemsWithCommandIDMask = (1L << gestaltMenuMgrMultipleItemsWithCommandIDBit),
   gestaltMenuMgrRetainsIconRefMask = (1L << gestaltMenuMgrRetainsIconRefBit),
   gestaltMenuMgrSendsMenuBoundsToDefProcMask = (1L << gestaltMenuMgrSendsMenuBoundsToDefProcBit),
   gestaltMenuMgrMoreThanFiveMenusDeepMask = (1L << gestaltMenuMgrMoreThanFiveMenusDeepBit)
};
Constants
gestaltMenuMgrAttr

The Gestalt selector passed to determine what features of the Menu Manager are present. This selector is available with Mac OS 8.5 and later. Passing gestaltMenuMgrAttr produces a 32-bit value whose bits you should test to determine what Menu Manager functionality is available.

Available in Mac OS X v10.0 and later.
gestaltMenuMgrPresent

If the bit specified by this mask is set, the Menu Manager functionality for Appearance Manager 1.1 is available. This bit is set for Mac OS 8.5 and later.

Available in Mac OS X v10.0 and later.
gestaltMenuMgrPresentBit

Available in Mac OS X v10.0 and later.
gestaltMenuMgrAquaLayoutBit

Available in Mac OS X v10.0 and later.
gestaltMenuMgrMultipleItemsWithCommandIDBit

Available in Mac OS X v10.0 and later.
gestaltMenuMgrRetainsIconRefBit

Available in Mac OS X v10.0 and later.
gestaltMenuMgrSendsMenuBoundsToDefProcBit

Available in Mac OS X v10.0 and later.
gestaltMenuMgrMoreThanFiveMenusDeepBit

Available in Mac OS X v10.2 and later.
gestaltMenuMgrPresentMask

Available in Mac OS X v10.0 and later.
gestaltMenuMgrAquaLayoutMask

Available in Mac OS X v10.0 and later.
gestaltMenuMgrMultipleItemsWithCommandIDMask

Available in Mac OS X v10.0 and later.
gestaltMenuMgrRetainsIconRefMask

Available in Mac OS X v10.0 and later.
gestaltMenuMgrSendsMenuBoundsToDefProcMask

Available in Mac OS X v10.0 and later.
gestaltMenuMgrMoreThanFiveMenusDeepMask

Available in Mac OS X v10.2 and later.
Discussion

Before calling any Menu Manager functions, your application should pass the selector gestaltMenuMgrAttr to the Gestalt function to determine which Menu Manager functions are available.*/
enum {
   gestaltMenuMgrAttr = 'menu',
   gestaltMenuMgrPresent = (1L << 0),
   gestaltMenuMgrPresentBit = 0,
   gestaltMenuMgrAquaLayoutBit = 1,
   gestaltMenuMgrMultipleItemsWithCommandIDBit = 2,
   gestaltMenuMgrRetainsIconRefBit = 3,
   gestaltMenuMgrSendsMenuBoundsToDefProcBit = 4,
   gestaltMenuMgrMoreThanFiveMenusDeepBit = 5,
   gestaltMenuMgrPresentMask = (1L << gestaltMenuMgrPresentBit),
   gestaltMenuMgrAquaLayoutMask = (1L << gestaltMenuMgrAquaLayoutBit),
   gestaltMenuMgrMultipleItemsWithCommandIDMask = (1L << gestaltMenuMgrMultipleItemsWithCommandIDBit),
   gestaltMenuMgrRetainsIconRefMask = (1L << gestaltMenuMgrRetainsIconRefBit),
   gestaltMenuMgrSendsMenuBoundsToDefProcMask = (1L << gestaltMenuMgrSendsMenuBoundsToDefProcBit),
   gestaltMenuMgrMoreThanFiveMenusDeepMask = (1L << gestaltMenuMgrMoreThanFiveMenusDeepBit)
};


/*QuickTime Version Selectors

Specify version information for QuickTime.

enum {
   gestaltQuickTimeVersion = 'qtim',
   gestaltQuickTime = 'qtim'
};
Constants
gestaltQuickTimeVersion

The selector you pass to the Gestalt function to determine the QuickTime version.

Available in Mac OS X v10.0 and later.
gestaltQuickTime

Available in Mac OS X v10.0 and later.*/
enum {
   gestaltQuickTimeVersion = 'qtim',
   gestaltQuickTime = 'qtim'
};



/*System Version Selectors


Specifies version information for the operating system.

enum {
   gestaltSystemVersion = 'sysv'
   gestaltSystemVersionMajor     = 'sys1',
   gestaltSystemVersionMinor     = 'sys2',
   gestaltSystemVersionBugFix    = 'sys3'
};
Constants
gestaltSystemVersion

The selector you pass to the Gestalt function to determine the version number of the currently active System file. For systems prior to Mac OS X, the version is represented as four hexadecimal digits in the low-order word of the return value. For example, if your application is running in version 7.0.1, then Gestalt returns the value 0x0701. Ignore the high-order word of the returned value. For Mac OS X versions, the representation is as shown in Table 1.
Table 1  The representation of Mac OS X versions by the Gestalt Manager
Mac OS X Version	
Representation 

10.0	
0x1000

10.1	
0x1010

10.2	
0x1020

10.3	
0x1030

10.4	
0x1040


If the values of the minor or bug fix revision are larger than 9, then gestaltSystemVersion will substitute the value 9 for them. For example, Mac OS X 10.3.15 will be returned as 0x1039, and Mac OS X 10.10.5 will return 0x1095.

A better way to obtain version information in Mac OS X is to read the system version information from the following file:

/System/Library/CoreServices/SystemVersion.plist

Never infer the existence of certain hardware or software features from the responses that Gestalt returns when you pass it this selector.

Available in Mac OS X v10.0 and later.
gestaltSystemVersionMajor

The major system version number. For example, in 10.4.7, this would be the decimal value 10. 

Available in Mac OS X v10.4 and later.
gestaltSystemVersionMinor

The minor system version number. For example, in 10.4.7, this would be the decimal value 4. 

Available in Mac OS X v10.4 and later.
gestaltSystemVersionBugFix

The bug fix version number. For example, in 10.4.7, this would be the decimal value 7. 

Available in Mac OS X v10.4 and later.*/
enum {
   gestaltSystemVersion = 'sysv',
   gestaltSystemVersionMajor     = 'sys1',
   gestaltSystemVersionMinor     = 'sys2',
   gestaltSystemVersionBugFix    = 'sys3'
};

//function

/*Gestalt

Obtains information about the operating environment.

OSErr Gestalt (
   OSType selector,
   long * response
);
Parameters
selector

The selector code for the information you need. You can provide any of the four-character sequences defined in Gestalt Manager Constants.
response

On input, Gestalt interprets this parameter as an address at which it is to place the result returned by the selector function. Gestalt ignores any information already at this address. 

On return, a pointer to the requested information whose format depends on the selector code specified in the selector parameter. Note that the Gestalt function returns the response from all selectors in a long word, which occupies 4 bytes. When not all 4 bytes are needed, the significant information appears in the low-order byte or bytes.
Return Value

A result code. See Gestalt Manager Result Codes.
Discussion

The Apple-defined selector codes fall into two categories: environmental selectors, which supply specific environmental information you can use to control the behavior of your application, and informational selectors, which cant supply information you can use to determine what hardware or software features are available. You can use one of the selector codes defined by Apple or a selector code defined by a third-party product.

Selectors with the suffix Attr return a 32-bit response value in which the individual bits represent specific attributes. The constants listed for these response values represent bit numbers. 
Special Considerations

When passed one of the Apple-defined selector codes, the Gestalt function does not move or purge memory and therefore may be called even at interrupt time. However, selector functions associated with non-Apple selector codes might move or purge memory, and third-party software can alter the Apple-defined selector functions. Therefore, it is safest always to assume that Gestalt could move or purge memory.
Version Notes

The ROMVersion and machineType selectors are not supported in Carbon.

In general, the Gestalt function returns a different result when called from a Carbon application running in Mac OS X than it returns when called from a Classic application in Mac OS X, because these are different environments. For example, Carbon does not use a ROM, so calling Gestalt from a Carbon application on a beige G3 Macintosh computer and passing the ROMVersion selector returns a different result than Gestalt returns for a Classic application on the same computer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr Gestalt (
   OSType selector,
   long * response
);

/*NewGestaltValue

Installs a new Gestalt selector code and a value that Gestalt returns for that selector.

OSErr NewGestaltValue (
   OSType selector,
   long newValue
);
Parameters
selector

The selector code you want to add. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
newValue

The value to return for the new selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You call the function NewGestaltValue when the specified selector is not already installed and you don't want to override an existing value.

In Mac OS X, the new selector and value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr NewGestaltValue (
   OSType selector,
   long newValue
);

/*ReplaceGestaltValue

Replaces the value that the function Gestalt returns for a specified selector code with the value provided to the function.

OSErr ReplaceGestaltValue (
   OSType selector,
   long replacementValue
);
Parameters
selector

The selector code you want to add. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
replacementValue

The replacement Gestalt value for the selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You use the function ReplaceGestaltValue to replace an existing value. You should not call this function to introduce a value that doesn't already exist; instead call the function NewGestaltValue.

In Mac OS X, the selector and replacement value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr ReplaceGestaltValue (
   OSType selector,
   long replacementValue
);

/*SetGestaltValue

Sets the value the function Gestalt will return for a specified selector code, installing the selector if it was not already installed.

OSErr SetGestaltValue (
   OSType selector,
   long newValue
);
Parameters
selector

The selector code you want to set. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
newValue

The new Gestalt value for the selector code.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

You use SetGestaltValue to establish a value for a selector, without regard to whether the selector was already installed.

In Mac OS X, the selector and new value are on a per-context basis. That means they are available only to the application or other code that installs them. You cannot use this function to make information available to another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr SetGestaltValue (
   OSType selector,
   long newValue
);

/*DeleteGestaltValue

Deletes a Gestalt selector code so that it is no longer recognized by Gestalt.

OSErr DeleteGestaltValue (
   OSType selector
);
Parameters
selector

The selector code you want to delete. This should be a four-character sequence similar to those defined in “Gestalt Manager Constants”.
Return Value

A result code. See “Gestalt Manager Result Codes”.
Discussion

After calling this function, subsequent query or replacement calls for the selector code will fail as if the selector had never been installed. 

In Mac OS X, the selector is on a per-context basis. You cannot use this function to affect another process. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Gestalt.h*/
OSErr DeleteGestaltValue (
   OSType selector
);

#ifdef __cplusplus
}
#endif

#endif