#ifndef MACERRORS_H
#define MACERRORS_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

//#include <HYS/CarbonCore/MacErrors.h>
#include <APPLE/CarbonCore/MacErrors.h>
#include <AvailabilityMacros.h>



#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Resolving and Creating Object Specifier Records Result Codes 
noErr	0	No error
paramErr	-50	Parameter error (for example, value of handler pointer is NIL or odd)
eLenErr	-92	Buffer too big to send
memFullErr	-108	Not enough room in heap zone
userCanceledErr	-128	User canceled an operation
procNotFound	-600	No eligible process with specified process serial number
bufferIsSmall	-607	Buffer is too small
noOutstandingHLE	-608	No outstanding high-level event
connectionInvalid	-609	Nonexistent signature or session ID
noUserInteractionAllowed	-610	Background application sends event requiring authentication
noPortErr	-903	Client hasn't set 'SIZE' resource to indicate awareness of high-level events
destPortErr	-906	Server hasn't set 'SIZE' resource to indicate awareness of high-level events, or else is not present
sessClosedErr	-917	The kAEDontReconnect flag in the sendMode parameter was set, and the server quit and then restarted
errAECoercionFail	-1700	Data could not be coerced to the requested descriptor type
errAEDescNotFound	-1701	Descriptor record was not found
errAECorruptData	-1702	Data in an Apple event could not be read
errAEWrongDataType	-1703	Wrong descriptor type
errAENotAEDesc	-1704	Not a valid descriptor record
errAEBadListItem	-1705	Operation involving a list item failed
errAENewerVersion	-1706	Need a newer version of the Apple Event Manager
errAENotAppleEvent	-1707	Event is not an Apple event
errAEEventNotHandled	-1708	Event wasn't handled by an Apple event handler
errAEReplyNotValid	-1709	AEResetTimer was passed an invalid reply
errAEUnknownSendMode	-1710	Invalid sending mode was passed
errAEWaitCanceled	-1711	User canceled out of wait loop for reply or receipt
errAETimeout	-1712	Apple event timed out
errAENoUserInteraction	-1713	No user interaction allowed
errAENotASpecialFunction	-1714	The keyword is not valid for a special function
errAEParamMissed	-1715	Handler cannot understand a parameter the client considers required
errAEUnknownAddressType	-1716	Unknown Apple event address type
errAEHandlerNotFound	-1717	No handler found for an Apple event or a coercion, or no object callback function found
errAEReplyNotArrived	-1718	Reply has not yet arrived
errAEIllegalIndex	-1719	Not a valid list index
errAEImpossibleRange	-1720	The range is not valid because it is impossible for a range to include the first and last objects that were specified; an example is a range in which the offset of the first object is greater than the offset of the last object
errAEWrongNumberArgs	-1721	The number of operands provided for the kAENOT logical operator is not 1
errAEAccessorNotFound	-1723	There is no object accessor function for the specified object class and token descriptor type
errAENoSuchLogical	-1725	The logical operator in a logical descriptor record is not kAEAND, kAEOR, or kAENOT
errAEBadTestKey	-1726	The descriptor record in a test key is neither a comparison descriptor record nor a logical descriptor record
errAENotAnObjectSpec	-1727	The objSpecifier parameter of AEResolve is not an object specifier record
errAENoSuchObject	-1728 	A run-time resolution error, for example: object specifier record asked for the third element, but there are only 2.
errAENegativeCount	-1729 	Object-counting function returned negative value
errAEEmptyListContainer	-1730	The container for an Apple event object is specified by an empty list
errAEUnknownObjectType	-1731	Descriptor type of token returned by AEResolve is not known to server application 
errAERecordingIsAlreadyOn	-1732	Attempt to turn recording on when it is already on*/

enum {
//noErr	=0,	//No error
//paramErr=	-50,//Parameter error (for example, value of handler pointer is NIL or odd)
//eLenErr=	-92,	//Buffer too big to send
//memFullErr	=-108,//	Not enough room in heap zone
//userCanceledErr=	-128,//User canceled an operation
//procNotFound=	-600,//	No eligible process with specified process serial number
bufferIsSmall	=-607,//	Buffer is too small
noOutstandingHLE	=-608,	//No outstanding high-level event
connectionInvalid	=-609,	//Nonexistent signature or session ID
noUserInteractionAllowed	=-610,	//Background application sends event requiring authentication
//noPortErr	=-903,//	Client hasn't set 'SIZE' resource to indicate awareness of high-level events
//destPortErr=	-906,	//Server hasn't set 'SIZE' resource to indicate awareness of high-level events, or else is not present
//sessClosedErr	=-917,	//The kAEDontReconnect flag in the sendMode parameter was set, and the server quit and then restarted
//errAECoercionFail	=-1700,	//Data could not be coerced to the requested descriptor type
//errAEDescNotFound=	-1701,	//Descriptor record was not found
//errAECorruptData	=-1702,//	Data in an Apple event could not be read
//errAEWrongDataType	=-1703,	//Wrong descriptor type
//errAENotAEDesc	=-1704,	//Not a valid descriptor record
//errAEBadListItem	=-1705,	//Operation involving a list item failed
//errAENewerVersion=	-1706,	//Need a newer version of the Apple Event Manager
//errAENotAppleEvent=	-1707,	//Event is not an Apple event
//errAEEventNotHandled=	-1708	,//Event wasn't handled by an Apple event handler
//errAEReplyNotValid=	-1709,//	AEResetTimer was passed an invalid reply
//errAEUnknownSendMode	=-1710	,//Invalid sending mode was passed
//errAEWaitCanceled	=-1711,	//User canceled out of wait loop for reply or receipt
//errAETimeout	=-1712	,//Apple event timed out
//errAENoUserInteraction=	-1713	,//No user interaction allowed
//errAENotASpecialFunction	=-1714	,//The keyword is not valid for a special function
//errAEParamMissed=	-1715	,//Handler cannot understand a parameter the client considers required
//errAEUnknownAddressType	=-1716,	//Unknown Apple event address type
//errAEHandlerNotFound=	-1717	,//No handler found for an Apple event or a coercion, or no object callback function found
//errAEReplyNotArrived	=-1718,	//Reply has not yet arrived
//errAEIllegalIndex	=-1719	,//Not a valid list index
//errAEImpossibleRange	=-1720,	//The range is not valid because it is impossible for a range to include the first and last objects that were specified; an example is a range in which the offset of the first object is greater than the offset of the last object
//errAEWrongNumberArgs=	-1721	,//The number of operands provided for the kAENOT logical operator is not 1
//errAEAccessorNotFound	=-1723	,//There is no object accessor function for the specified object class and token descriptor type
//errAENoSuchLogical	=-1725	,//The logical operator in a logical descriptor record is not kAEAND, kAEOR, or kAENOT
//errAEBadTestKey	=-1726,	//The descriptor record in a test key is neither a comparison descriptor record nor a logical descriptor record
//errAENotAnObjectSpec=	-1727,	//The objSpecifier parameter of AEResolve is not an object specifier record
//errAENoSuchObject	=-1728 ,	//A run-time resolution error, for example: object specifier record asked for the third element, but there are only 2.
//errAENegativeCount=	-1729 ,	//Object-counting function returned negative value
//errAEEmptyListContainer=	-1730	,//The container for an Apple event object is specified by an empty list
//errAEUnknownObjectType=	-1731	,//Descriptor type of token returned by AEResolve is not known to server application 
//errAERecordingIsAlreadyOn	=-1732	,//Attempt to turn recording on when it is already on*/
};



/*Sound Input Manager Result Codes 
noErr	0	No error
abortErr	-27	Asynchronous recording was cancelled
permErr	-54	Attempt to open locked file for writing
userCanceledErr	-128	User canceled the operation 
siNoSoundInHardware	-220	No sound input hardware available
siBadSoundInDevice	-221	Invalid sound input device
siNoBufferSpecified	-222	No buffer specified
siInvalidCompression	-223	Invalid compression type
siHardDriveTooSlow	-224	Hard drive too slow to record
siInvalidSampleRate	-225	Invalid sample rate
siInvalidSampleSize	-226	Invalid sample size
siDeviceBusyErr	-227	Sound input device is busy
siBadDeviceName	-228	Invalid device name
siBadRefNum	-229	Invalid reference number
siInputDeviceErr	-230	Input device hardware failure
siUnknownInfoType	-231	Unknown type of information
siUnknownQuality 	-232	Unknown quality*/
enum  {
//noErr	=0	,//No error
//abortErr=-27	,//Asynchronous recording was cancelled
//permErr=	-54	,//Attempt to open locked file for writing
//userCanceledErr=	-128	,//User canceled the operation 
siNoSoundInHardware	=-220	,//No sound input hardware available
//siBadSoundInDevice=	-221	,//Invalid sound input device
siNoBufferSpecified	=-222	,//No buffer specified
//siInvalidCompression	=-223	,//Invalid compression type
siHardDriveTooSlow	=-224	,//Hard drive too slow to record
siInvalidSampleRate=	-225	,//Invalid sample rate
siInvalidSampleSize=	-226	,//Invalid sample size
siDeviceBusyErr	=-227	,//Sound input device is busy
siBadDeviceName=	-228	,//Invalid device name
siBadRefNum	=-229	,//Invalid reference number
siInputDeviceErr	=-230	,//Input device hardware failure
siUnknownInfoType	=-231	,//Unknown type of information
//siUnknownQuality =	-232	,//Unknown quality
};

/*Text Encoding Conversion Manager Result Codes

The most common result codes returned by Text Encoding Conversion Manager are listed below.
Result Code	Value	Description
kTextUnsupportedEncodingErr	-8738	
The encoding or mapping is not supported for this function by the current set of tables or plug-ins.
kTextMalformedInputErr	-8739	
The text input contains a sequence that is not legal in the specified encoding, such as a DBCS high byte followed by an invalid low byte (0x8120 in Shift-JIS). 
kTextUndefinedElementErr	-8740	
The text input contains a code point that is undefined in the specified encoding. The function did not completely convert the input string. You can resume conversion from a point beyond the offending character, or take some other action.
kTECMissingTableErr	-8745	
The specified encoding is partially supported, but a specific table required for this function is missing.
kTECTableChecksumErr	-8746	
A specific table required for this function has a checksum error, indicating that it has become corrupted.
kTECTableFormatErr	-8747	
The table format is either invalid or it cannot be handled by the current version of the code. The function did not convert the string
kTECCorruptConverterErr	-8748	
The converter object is invalid. Returned by the Text Encoding Converter functions only. 
kTECNoConversionPathErr	-8749	
The converter supports both the source and target encodings, but cannot convert between them either directly or indirectly. Returned by the Text Encoding Converter functions only. 
kTECBufferBelowMinimumSizeErr	-8750	
The output text buffer is too small to accommodate the result of processing of the first input text element. No part of the input string was processed.
kTECArrayFullErr	-8751	
The supplied TextEncodingRun, ScriptCodeRun, or UnicodeMapping array is too small, and the input was not completely converted. Call the function again with another output buffer—or with the same output buffer after copying its contents—to convert the remainder of the string
kTECPartialCharErr	-8753	
The input text ends in the middle of a multibyte character and conversion stopped. Append the unconverted input from this call to the beginning of the subsequent input text and call the function again.
kTECUnmappableElementErr	-8754	
An input text element cannot be mapped to the specified output encoding(s) using the specified options. For the Unicode Converter, this error can occur only if kUnicodeUseFallbacksBit control flag is not set. 
kTECIncompleteElementErr	-8755	
The input text ends with a text element that might be incomplete, or contains a text element that is too long for the internal buffers. 
kTECDirectionErr	-8756	
An error, such as a direction stack overflow, occurred in directionality processing.
kTECGlobalsUnavailableErr	-8770	
Global variables have already been deallocated, premature termination. The function did not convert the string.
kTECItemUnavailableErr	-8771	
An item (for example, a name) is not available for the specified region (and encoding, if relevant).
kTECUsedFallbacksStatus	-8783	
The function has completely converted the input string to the specified target using one or more fallbacks. For the Unicode Converter, this status code can only occur if the kUnicodeUseFallbacksBit control flag is set.
kTECNeedFlushStatus	-8784	
The application disposed of a converter object by calling TECDisposeConverter, but there is still text contained in internal buffers. Returned by the Text Encoding Converter functions only. 
kTECOutputBufferFullStatus	-8785	
The converter successfully converted part of the input text, but the output buffer was not large enough to accommodate the entire input text after conversion. Convert the remaining text beginning from the position where the conversion stopped.*/
enum {
kTextUnsupportedEncodingErr =	-8738	,
//The encoding or mapping is not supported for this function by the current set of tables or plug-ins.
kTextMalformedInputErr	=-8739	,
//The text input contains a sequence that is not legal in the specified encoding, such as a DBCS high byte followed by an invalid low byte (0x8120 in Shift-JIS). 
kTextUndefinedElementErr=	-8740	,
//The text input contains a code point that is undefined in the specified encoding. The function did not completely convert the input string. You can resume conversion from a point beyond the offending character, or take some other action.
kTECMissingTableErr	=-8745	,
//The specified encoding is partially supported, but a specific table required for this function is missing.
kTECTableChecksumErr	=-8746	,
//A specific table required for this function has a checksum error, indicating that it has become corrupted.
kTECTableFormatErr	=-8747	,
//The table format is either invalid or it cannot be handled by the current version of the code. The function did not convert the string
kTECCorruptConverterErr	=-8748	,
//The converter object is invalid. Returned by the Text Encoding Converter functions only. 
kTECNoConversionPathErr	=-8749	,
//The converter supports both the source and target encodings, but cannot convert between them either directly or indirectly. Returned by the Text Encoding Converter functions only. 
kTECBufferBelowMinimumSizeErr	=-8750	,
//The output text buffer is too small to accommodate the result of processing of the first input text element. No part of the input string was processed.
kTECArrayFullErr	=-8751	,
//The supplied TextEncodingRun, ScriptCodeRun, or UnicodeMapping array is too small, and the input was not completely converted. Call the function again with another output buffer—or with the same output buffer after copying its contents—to convert the remainder of the string
kTECPartialCharErr	=-8753	,
//The input text ends in the middle of a multibyte character and conversion stopped. Append the unconverted input from this call to the beginning of the subsequent input text and call the function again.
kTECUnmappableElementErr	=-8754	,
//An input text element cannot be mapped to the specified output encoding(s) using the specified options. For the Unicode Converter, this error can occur only if kUnicodeUseFallbacksBit control flag is not set. 
kTECIncompleteElementErr	=-8755	,
//The input text ends with a text element that might be incomplete, or contains a text element that is too long for the internal buffers. 
kTECDirectionErr	=-8756	,
//An error, such as a direction stack overflow, occurred in directionality processing.
kTECGlobalsUnavailableErr=	-8770	,
//Global variables have already been deallocated, premature termination. The function did not convert the string.
kTECItemUnavailableErr=	-8771	,
//An item (for example, a name) is not available for the specified region (and encoding, if relevant).
kTECUsedFallbacksStatus	=-8783	,
//The function has completely converted the input string to the specified target using one or more fallbacks. For the Unicode Converter, this status code can only occur if the kUnicodeUseFallbacksBit control flag is set.
kTECNeedFlushStatus=	-8784	,
//The application disposed of a converter object by calling TECDisposeConverter, but there is still text contained in internal buffers. Returned by the Text Encoding Converter functions only. 
kTECOutputBufferFullStatus=	-8785	,
//The converter successfully converted part of the input text, but the output buffer was not large enough to accommodate the entire input text after conversion. Convert the remaining text beginning from the position where the conversion stopped
};

/*QuickDraw Result Codes

The table below lists the result codes specific to QuickDraw.
Result Code	Value	Description
updPixMemErr	-125	
Insufficient memory to update a pixmap.
noMemForPictPlaybackErr	-145	
Insufficient memory for drawing the picture.
pixMapTooDeepErr	-148	
Pixel map is deeper than 1 bit per pixel.
nsStackErr	-149	
Insufficient stack
cMatchErr	-150	
Color2Index failed to find an index.
cTempMemErr	-151	
Failed to allocate memory for temporary structures.
cNoMemErr	-152	
Failed to allocate memory for structures.
cRangeErr	-153	
Range error on color table requests.
cProtectErr	-154	
ColorTable structure entry protection violation.
cDevErr	-155	
Invalid type of graphics device.
cResErr	-156	
Invalid resolution for MakeITable.
cDepthErr	-157	
Invalid pixel depth.
rgnTooBigErr	-500	
Bitmap too large to convert to a region.
kQDNoPalette	-3950	
kQDNoColorHWCursorSupport	-3951	
kQDCursorAlreadyRegistered	-3952	
kQDCursorNotRegistered	-3953	
kQDCorruptPICTDataErr	-3954	*/
enum {
pdPixMemErr	=-125	,
//Insufficient memory to update a pixmap.
noMemForPictPlaybackErr=	-145	,
//Insufficient memory for drawing the picture.
pixMapTooDeepErr	=-148	,
//Pixel map is deeper than 1 bit per pixel.
nsStackErr	=-149	,
//Insufficient stack
cMatchErr	=-150	,
//Color2Index failed to find an index.
cTempMemErr	=-151	,
//Failed to allocate memory for temporary structures.
cNoMemErr	=-152	,
//Failed to allocate memory for structures.
cRangeErr	=-153	,
//Range error on color table requests.
cProtectErr	=-154	,
//ColorTable structure entry protection violation.
cDevErr=	-155	,
//Invalid type of graphics device.
cResErr	=-156,	
//Invalid resolution for MakeITable.
cDepthErr	=-157,	
//Invalid pixel depth.
rgnTooBigErr	=-500	,
//Bitmap too large to convert to a region.
kQDNoPalette	=-3950	,
kQDNoColorHWCursorSupport=	-3951	,
kQDCursorAlreadyRegistered	=-3952	,
kQDCursorNotRegistered	=-3953	,
kQDCorruptPICTDataErr	=-3954
};


/*Display Manager. Result Codes

The table below lists the result codes that are specific to the Display Manager. 
Result Code	Value	Description
kDMGenErr	-6220	
An indeterminate error occurred.
kDMMirroringOnAlready	-6221	
Video mirroring is already enabled.
kDMWrongNumberOfDisplays	-6222	
Wrong number of displays.
kDMMirroringBlocked	-6223	
Video is blocked.
kDMCantBlock	-6224	
Video mirroring is already enabled and can’t be blocked; use DMUnMirrorDevice, then call DMBlockMirroring again.
kDMMirroringNotOn	-6225	
Video mirroring is not currently enabled.
kSysSWTooOld	-6226	
Some piece of system software is too old for the Display Manager to operate.
kDMSWNotInitializedErr	-6227	
The required pieces of system software are not initialized.
kDMDriverNotDisplayMgrAwareErr	-6228	
The video driver for the display does not support the Display Manager.
kDMNotFoundErr	-6229	
kDMDisplayNotFoundErr	-6229	
There are no GDevice structures for displays in the device list.
kDMDisplayAlreadyInstalledErr	-6230	
The display is already in the device list and can’t be added.
kDMNoDeviceTableclothErr	-6231	
kDMMainDisplayCannotMoveErr	-6231	
kDMFoundErr	-6232	
Item found*/
enum {
kDMGenErr	=-6220,	//An indeterminate error occurred.
kDMMirroringOnAlready	=-6221,	//Video mirroring is already enabled.
kDMWrongNumberOfDisplays=	-6222,	//Wrong number of displays.
kDMMirroringBlocked	=-6223,	//Video is blocked.
kDMCantBlock=	-6224,	//Video mirroring is already enabled and can’t be blocked; use DMUnMirrorDevice, then call DMBlockMirroring again.
kDMMirroringNotOn=	-6225,	//Video mirroring is not currently enabled.
kSysSWTooOld	=-6226	,//Some piece of system software is too old for the Display Manager to operate.
kDMSWNotInitializedErr	=-6227,	//The required pieces of system software are not initialized.
kDMDriverNotDisplayMgrAwareErr	=-6228,	//The video driver for the display does not support the Display Manager.
kDMNotFoundErr=	-6229	,
kDMDisplayNotFoundErr=	-6229	,//There are no GDevice structures for displays in the device list.
kDMDisplayAlreadyInstalledErr=	-6230	,//The display is already in the device list and can’t be added.
kDMNoDeviceTableclothErr	=-6231,	
kDMMainDisplayCannotMoveErr	=-6231	,
kDMFoundErr	=-6232	
};


/* Sound Result Codes
 noErr	0	No error
userCanceledErr	-128	User canceled the operation
noHardwareErr	-200	Required sound hardware not available
notEnoughHardwareErr	-201	Insufficient hardware available
queueFull	-203	No room in the queue
resProblem	-204	Problem loading the resource
badChannel	-205	Channel is corrupt or unusable
badFormat	-206	Resource is corrupt or unusable
notEnoughBufferSpace	-207	Insufficient memory available
badFileFormat	-208	File is corrupt or unusable, or not AIFF or AIFF-C
channelBusy	-209	Channel is busy
buffersTooSmall	-210	Buffer is too small
siBadSoundInDevice	-221	Invalid sound input device
siInvalidCompression	-223	Invalid compression type
siUnknownQuality	-232	Unknown quality
synthOpenFailed	-241	Could not open another speech synthesizer channel*/
enum {
// noErr=	0	,
//userCanceledErr	=-128	,
noHardwareErr	=-200	,
//notEnoughHardwareErr=	-201	,
queueFull	=-203	,
//resProblem	=-204,	
//badChannel	=-205,	
//badFormat	=-206,	
notEnoughBufferSpace	=-207	,
badFileFormat	=-208	,
channelBusy	=-209	,
buffersTooSmall	=-210	,
siBadSoundInDevice	=-221	,
siInvalidCompression	=-223	,
siUnknownQuality	=-232,
//synthOpenFailed	=-241	
};

/*Common Streaming Error Codes

Here is a list of common streaming error codes. Applications that play streaming movies should deal gracefully with these errors.// Streaming errors
-5400    // qtsBadSelectorErr
-5401    // qtsBadStateErr
-5402    // qtsBadDataErr
-5403    // qtsUnsupportedDataTypeErr
-5404    // qtsUnsupportedRateErr
-5405    // qtsUnsupportedFeatureErr
-5406    // qtsTooMuchDataErr
 
// Network errors
-5420    // connection failed (couldn't connect to the server)
 
// Open Transport errors, Macintosh only: -3150 to -3180, -3200 to -3285,
// plus the full range of OT error codes in file OpenTransport.h
 
-3150    // kOTBadAddressErr; a bad address was specified
-3170    // kOTBadNameErr; couldn't do name lookup
 
// Open Transport errors, Windows only
10061    // couldn't connect to server
 
// Streaming can return all QuickTime and Macintosh Toolbox errors.
// Common error codes returned include:
 
// QuickTime errors
-223    // siInvalidCompression; codec not installed
// Windows-specific errors when component is loading
-2092   // componentDllEntryNotFoundErr
 
// RTSP errors
// Most of these error codes are the same as for HTTP.
// These errors are usually generated from the server.
3xx    // redirect
400    // bad request
401    // unauthorized
402    // payment required
403    // forbidden
404    // not found (specified movie not found on server side)
405    // method not allowed
406    // not acceptable
407    // proxy authentication required
408    // request time-out
409    // conflict
410    // gone
411    // length required
412    // precondition failed
413    // request entity too large
414    // request URI too large
415    // unsupported media type
451    // parameter not understood
452    // conference not found
453    // not enough bandwidth
454    // session not founds
455    // method not valid in this state
456    // header field not valid for resource
457    // invalid range
458    // parameter is read only
459    // aggregate operation not allowed
460    // only aggregate operation allowed
461    // unsupported transport
462    // destination unreachable
500    // internal server error
501    // not implemented
502    // bad gateway
503    // service unavailable
504    // gateway timeout
505    // version not supported
551    // option not supported
*/ 
enum {
qtsBadSelectorErr =-5400    ,// qtsBadSelectorErr
qtsBadStateErr =-5401   , // qtsBadStateErr
qtsBadDataErr =-5402    ,// qtsBadDataErr
qtsUnsupportedDataTypeErr =-5403,    // qtsUnsupportedDataTypeErr
qtsUnsupportedRateErr =-5404    ,// qtsUnsupportedRateErr
qtsUnsupportedFeatureErr= -5405 ,   // qtsUnsupportedFeatureErr
qtsTooMuchDataErr =-5406    // qtsTooMuchDataErr
};




/*Device Manager Result Codes

The table below shows the most common result codes returned by the Device Manager.
Result Code	Value	Description
controlErr	-17	
Driver does not respond to this control request 
statusErr	-18	
Driver does not respond to this status request 
readErr	-19	
Driver does not respond to read requests 
writErr	-20	
Driver does not respond to write requests 
badUnitErr	-21	
Driver reference number does not match unit table 
unitEmptyErr	-22	
Driver reference number specifies a nil handle in unit table 
openErr	-23	
Requested read/write permission does not match driver's open permission 
closErr	-24	
Driver unable to complete close request 
dRemovErr	-25	
Tried to remove an open driver
dInstErr	-26	
DrvrInstall couldn't find driver in resources
abortErr	-27	
IO call aborted by KillIO
iIOAbort	-27	
iIOAbortErr	-27	
IO abort error (Printing Manager)
notOpenErr	-28	
Driver not open 
unitTblFullErr	-29	
Unit table has no more entries
dceExtErr	-30	
dce extension error
offLinErr	-65	
r/w requested for an off-line drive
fontSubErr	-66	
Font substitution occurred
noNybErr	-66	
Couldn't find 5 nybbles in 200 tries
noAdrMkErr	-67	
Couldn't find valid addr mark
dataVerErr	-68	
Read verify compare failed
badCksmErr	-69	
addr mark checksum didn't check
badBtSlpErr	-70	
bad addr mark bit slip nibbles
noDtaMkErr	-71	
couldn't find a data mark header
badDCksum	-72	
bad data mark checksum
badDBtSlp	-73	
bad data mark bit slip nibbles
wrUnderrun	-74	
write underrun occurred
cantStepErr	-75	
step handshake failed
tk0BadErr	-76	
track 0 detect doesn't change
initIWMErr	-77	
unable to initialize IWM
twoSideErr	-78	
tried to read 2nd side on a 1-sided drive
spdAdjErr	-79	
unable to correctly adjust disk speed
seekErr	-80	
track number wrong on address mark
sectNFErr	-81	
sector number never found on a track
fmt1Err	-82	
can't find sector 0 after track format
fmt2Err	-83	
can't get enough sync
clkRdErr	-85	
unable to read same clock value twice
clkWrErr	-86	
time written did not verify
prWrErr	-87	
parameter ram written didn't read-verify
prInitErr	-88	
InitUtil found the parameter ram uninitialized
rcvrErr	-89	
SCC receiver error (framing; parity; OR)
breakRecd	-90	
Break received (SCC)
ddpSktErr	-91	
error in soket number
eMultiErr	-91	
Multicast address error ddpSktErr
ddpLenErr	-92	
data length too big
eLenErr	-92	
Length error ddpLenErr
noBridgeErr	-93	
no network bridge for non-local send
lapProtErr	-94	
error in attaching/detaching protocol
excessCollsns	-95	
excessive collisions on write
portNotPwr	-96	
serial port not currently powered
portInUse	-97	
driver Open error code (port is in use)
portNotCf	-98	
driver Open error code (parameter RAM not configured for this connection)
nrLockedErr	-2536	
nrNotEnoughMemoryErr	-2537	
nrInvalidNodeErr	-2538	
nrNotFoundErr	-2539	
nrNotCreatedErr	-2540	
nrNameErr	-2541	
nrNotSlotDeviceErr	-2542	
nrDataTruncatedErr	-2543	
nrPowerErr	-2544	
nrPowerSwitchAbortErr	-2545	
nrTypeMismatchErr	-2546	
nrNotModifiedErr	-2547	
nrOverrunErr	-2548	
nrResultCodeBase	-2549	
nrPathNotFound	-2550	
a path component lookup failed
nrPathBufferTooSmall	-2551	
buffer for path is too small
nrInvalidEntryIterationOp	-2552	
invalid entry iteration operation
nrPropertyAlreadyExists	-2553	
property already exists
nrIterationDone	-2554	
iteration operation is done
nrExitedIteratorScope	-2555	
outer scope of iterator was exited
nrTransactionAborted	-2556	
transaction was aborted
nrCallNotSupported	-2557	
This call is not available or supported on this machine*/
enum {
controlErr	=-17	,
statusErr	=-18	,
readErr	=-19	,
writErr	=-20	,
badUnitErr=	-21	,
unitEmptyErr=	-22	,
openErr	=-23	,
closErr	=-24	,
dRemovErr	=-25	,
dInstErr	=-26	,
abortErr	=-27	,
iIOAbort	=-27	,
iIOAbortErr=	-27	,
notOpenErr	=-28	,
unitTblFullErr	=-29	,
dceExtErr	=-30	,
offLinErr	=-65	,
fontSubErr=	-66	,
noNybErr	=-66	,
noAdrMkErr	=-67	,
dataVerErr	=-68	,
badCksmErr	=-69	,
badBtSlpErr	=-70	,
noDtaMkErr	=-71	,
badDCksum	=-72	,
badDBtSlp	=-73	,
wrUnderrun	=-74	,
cantStepErr	=-75	,
tk0BadErr	=-76	,
initIWMErr	=-77	,
twoSideErr=	-78	,
spdAdjErr	=-79	,
seekErr	=-80	,
sectNFErr	=-81	,
fmt1Err	=-82	,
fmt2Err	=-83	,
clkRdErr	=-85	,
clkWrErr	=-86	,
prWrErr	=-87	,
prInitErr	=-88	,
rcvrErr	=-89	,
breakRecd	=-90	,
ddpSktErr	=-91	,
eMultiErr	=-91	,
ddpLenErr=	-92	,
eLenErr	=-92	,
noBridgeErr=	-93	,
lapProtErr	=-94	,
excessCollsns=	-95	,
portNotPwr	=-96	,
portInUse=	-97	,
portNotCf=	-98	,
nrLockedErr	=-2536	,
nrNotEnoughMemoryErr=	-2537	,
nrInvalidNodeErr	=-2538	,
nrNotFoundErr	=-2539	,
nrNotCreatedErr	=-2540	,
nrNameErr	=-2541	,
nrNotSlotDeviceErr=	-2542,	
nrDataTruncatedErr	=-2543	,
nrPowerErr	=-2544	,
nrPowerSwitchAbortErr	=-2545	,
nrTypeMismatchErr	=-2546	,
nrNotModifiedErr	=-2547	,
nrOverrunErr	=-2548	,
nrResultCodeBase	=-2549	,
nrPathNotFound	=-2550	,
nrPathBufferTooSmall	=-2551	,
nrInvalidEntryIterationOp	=-2552	,
nrPropertyAlreadyExists	=-2553	,
nrIterationDone	=-2554	,
nrExitedIteratorScope	=-2555	,
nrTransactionAborted	=-2556	,
nrCallNotSupported	=-2557	
};

/* Game Sprockets Result Codes

The most common result codes returned by Game Sprockets are listed below.
Result Code	Value	Description
noErr	0	
No error
kNSpInitializationFailedErr	-30360	
NetSprocket could not be initialized
kNSpAlreadyInitializedErr	-30361	
NetSprocket has already been initialized
kNSpTopologyNotSupportedErr	-30362	
The requested topology is unimplemented, or invalid value
kNSpProtocolNotAvailableErr	-30366	
A protocol reference indicated a protocol that is unavailable
kNSpInvalidGameRefErr	-30367	
An invalid game reference was passed
kNSpInvalidParameterErr	-30369	
A generic parameter error occurred
kNSpOTNotPresentErr	-30370	
Open Transport is not installed or not installed correctly
kNSpOTVersionTooOldErr	-30371	
The version of Open Transport available is too old to use with NetSprocket
kNSpMemAllocationErr	-30373	
NetSprocket has run out of memory
kNSpAlreadyAdvertisingErr	-30374	
The game is already being advertised on the specified protocol
kNSpNotAdvertisingErr	-30376	
The game is not being advertised at this time
kNSpInvalidAddressErr	-30377	
An invalid address was passed
kNSpFreeQExhaustedErr	-30378	
NetSprocket has exhausted its allocated queue elements and new messages will be dropped
kNSpRemovePlayerFailedErr	-30379	
Your attempt to remove a player failed
kNSpAddressInUseErr	-30380	
You are attempting to use an address that is already in use
kNSpCreateGroupFailedErr	-30388	
The attempt to create a group failed
kNSpTimeoutErr	-30393	
A time out error has occurred
kNSpGameTerminatedErr	-30394	
An attempt to terminate the game has failed
kNSpConnectFailedErr	-30395	
A connection attempt has failed
kNSpSendFailedErr	-30396	
An attempt to send a message has failed
kNSpMessageTooBigErr	-30397	
The message you wanted to send was too long 
kNSpCantBlockErr	-30398	
The player you sent a message to is not playing the game
kNSpJoinFailedErr	-30399	
The attempt to join the game failed 
kISpInternalErr	-30420	
Internal error.
kISpSystemListErr	-30421	
Operation is not allowed a system-maintained element list.
kISpBufferToSmallErr	-30422	
The buffer is too small.
kISpElementInListErr	-30423	
The element is already in the element list.
kISpElementNotInListErr	-30424	
The element is not in the element list.
kISpSystemInactiveErr	-30425	
InputSprocket is currently inactive.
kISpDeviceInactiveErr	-30426	
The device is currently inactive.
kISpSystemActiveErr	-30427	
Input Sprocket is currently active.
kISpDeviceActiveErr	-30428	
The device is currently active.
kISpListBusyErr	-30429	
The element list is marked as busy.
kDSpNotInitializedErr	-30440	
DSpStartup has not yet been called.
kDSpSystemSWTooOldErr	-30441	
System software too old.
kDSpInvalidContextErr	-30442	
Invalid context reference.
kDSpInvalidAttributesErr	-30443	
Some field in an attributes structure has an invalid value.
kDSpContextAlreadyReservedErr	-30444	
The context is already reserved.
kDSpContextNotReservedErr	-30445	
The context is not reserved.
kDSpContextNotFoundErr	-30446	
DrawSprocket couldn’t find the context.
kDSpFrameRateNotReadyErr	-30447	
Not enough time has passed for DrawSprocket to calculate a frame rate.
kDSpConfirmSwitchWarning	-30448	
The gameMustConfirmSwitch flag is set.
kDSpInternalErr	-30449	
Corrupted DrawSprocket or other error.
kDSpStereoContextErr	-30450	
DrawSprocket attempted to process a stereo context. (DrawSprocket no longer supports GoggleSprocket.)*/
enum {
//noErr	=0	,
kNSpInitializationFailedErr	=-30360	,
kNSpAlreadyInitializedErr	=-30361	,
kNSpTopologyNotSupportedErr=	-30362	,
kNSpProtocolNotAvailableErr=	-30366	,
kNSpInvalidGameRefErr	=-30367	,
kNSpInvalidParameterErr	=-30369	,
kNSpOTNotPresentErr	=-30370	,
kNSpOTVersionTooOldErr=	-30371	,
kNSpMemAllocationErr	=-30373	,
kNSpAlreadyAdvertisingErr=	-30374	,
kNSpNotAdvertisingErr	=-30376	,
kNSpInvalidAddressErr	=-30377	,
kNSpFreeQExhaustedErr	=-30378	,
kNSpRemovePlayerFailedErr=	-30379	,
kNSpAddressInUseErr	=-30380	,
kNSpCreateGroupFailedErr=	-30388	,
kNSpTimeoutErr	=-30393	,
kNSpGameTerminatedErr=	-30394	,
kNSpConnectFailedErr	=-30395	,
kNSpSendFailedErr	=-30396	,
kNSpMessageTooBigErr=	-30397	,
kNSpCantBlockErr	=-30398	,
kNSpJoinFailedErr	=-30399	,
kISpInternalErr	=-30420	,
kISpSystemListErr	=-30421	,
kISpBufferToSmallErr	=-30422	,
kISpElementInListErr	=-30423	,
kISpElementNotInListErr=	-30424	,
kISpSystemInactiveErr	=-30425	,
kISpDeviceInactiveErr	=-30426	,
kISpSystemActiveErr	=-30427	,
kISpDeviceActiveErr	=-30428	,
kISpListBusyErr	=-30429	,
kDSpNotInitializedErr	=-30440	,
kDSpSystemSWTooOldErr	=-30441	,
kDSpInvalidContextErr	=-30442	,
kDSpInvalidAttributesErr	=-30443	,
kDSpContextAlreadyReservedErr=	-30444	,
kDSpContextNotReservedErr	=-30445	,
kDSpContextNotFoundErr	=-30446	,
kDSpFrameRateNotReadyErr	=-30447	,
kDSpConfirmSwitchWarning	=-30448	,
kDSpInternalErr	=-30449	,
kDSpStereoContextErr	=-30450	,
};



/* Drag Manager Result Codes

The table below lists the most common result codes returned by the Drag Manager.
Result Code	Value	Description
badDragRefErr	-1850	
Unknown drag reference
badDragItemErr	-1851	
Unknown drag item reference
badDragFlavorErr	-1852	
Unknown flavor type
duplicateFlavorErr	-1853	
Flavor type already exists
cantGetFlavorErr	-1854	
Error while trying to get flavor data
duplicateHandlerErr	-1855	
Handler already exists
handlerNotFoundErr	-1856	
Handler not found
dragNotAcceptedErr	-1857	
Drag was not accepted by receiver
unsupportedForPlatformErr	-1858	
Call is for PowerPC only
noSuitableDisplaysErr	-1859	
No displays support translucency
badImageRgnErr	-1860	
Bad translucent image region
badImageErr	-1861	
Bad translucent image PixMap
nonDragOriginatorErr	-1862	
Illegal attempt to access originator only data*/
enum {
badDragRefErr	=-1850	,
badDragItemErr=	-1851,	
badDragFlavorErr	=-1852	,
duplicateFlavorErr	=-1853	,
cantGetFlavorErr	=-1854	,
duplicateHandlerErr	=-1855	,
handlerNotFoundErr	=-1856	,
dragNotAcceptedErr	=-1857	,
unsupportedForPlatformErr=	-1858	,
noSuitableDisplaysErr	=-1859	,
badImageRgnErr=	-1860	,
badImageErr	=-1861	,
nonDragOriginatorErr	=-1862	
};

/*Gestalt Manager  Result Codes

The most common result codes returned by the Gestalt Manager are listed below.
Result Code	Value	Description
gestaltUnknownErr	-5550	
Specifies an unknown error.
gestaltUndefSelectorErr	-5551	
Specifies an undefined selector was passed to the Gestalt Manager.
gestaltDupSelectorErr	-5552	
Specifies you tried to add an entry that already existed.
gestaltLocationErr	-5553	
Specifies the gestalt function ptr was not in the system heap.*/
enum {
gestaltUnknownErr	=-5550	,
gestaltUndefSelectorErr=	-5551,	
gestaltDupSelectorErr=	-5552	,
gestaltLocationErr	=-5553	
};

/*Memory Manager  Result Codes

The most common result codes returned by the Memory Manager are listed below.
Result Code	Value	Description
menuPrgErr	84	
A menu was purged.
negZcbFreeErr	33	
A heap has been corrupted.
memROZErr	-99	
Operation on a read-only zone.
memFullErr	-108	
Not enough memory in heap.
nilHandleErr	-109	
Handle argument is NULL.
memAdrErr	-110	
Address is odd or out of range.
memWZErr	-111	
Attempt to operate on a free block.
memPurErr	-112	
Attempt to purge a locked or unpurgeable block.
memAZErr	-113	
Address in zone check failed.
memPCErr	-114	
Pointer check failed.
memBCErr	-115	
Block check failed.
memSCErr	-116	
Size check failed.
memLockedErr	-117	
Block is locked.*/
enum {
menuPrgErr	=84	,
negZcbFreeErr	=33	,
memROZErr	=-99	,
memFullErr	=-108	,
nilHandleErr	=-109	,
memAdrErr	=-110	,
memWZErr	=-111	,
memPurErr	=-112	,
memAZErr	=-113	,
memPCErr	=-114	,
memBCErr	=-115	,
memSCErr	=-116	,
memLockedErr	=-117	
};

/*Code Fragment Manager Result Codes

The most common result codes returned by Code Fragment Manager are listed in the table below. The Code Fragment Manager may also return
 paramErr (-50).
Result Code	Value	Description
cfragContextIDErr	-2800	
The context ID was not valid.
cfragFirstErrCode	-2800	
The first value in the range of CFM errors.
cfragConnectionIDErr	-2801	
The connection ID was not valid.
cfragNoSymbolErr	-2802	
The specified symbol was not found.
cfragNoSectionErr	-2803	
The specified section was not found.
cfragNoLibraryErr	-2804	
The named library was not found.
cfragDupRegistrationErr	-2805	
The registration name was already in use.
cfragFragmentFormatErr	-2806	
A fragment's container format is unknown.
cfragUnresolvedErr	-2807	
A fragment had "hard" unresolved imports.
cfragNoPositionErr	-2808	
The registration insertion point was not found.
cfragNoPrivateMemErr	-2809	
Out of memory for internal bookkeeping.
cfragNoClientMemErr	-2810	
Out of memory for fragment mapping or section instances.
cfragNoIDsErr	-2811	
No more CFM IDs for contexts, connections, etc.
cfragInitOrderErr	-2812	
cfragImportTooOldErr	-2813	
An import library was too old for a client.
cfragImportTooNewErr	-2814	
An import library was too new for a client.
cfragInitLoopErr	-2815	
Circularity in required initialization order.
cfragInitAtBootErr	-2816	
A boot library has an initialization function. (System 7 only)
cfragCFMStartupErr	-2818	
Internal error during CFM initialization.
cfragCFMInternalErr	-2819	
An internal inconsistency has been detected.
cfragFragmentCorruptErr	-2820	
A fragment's container was corrupt (known format).
cfragInitFunctionErr	-2821	
A fragment's initialization routine returned an error.
cfragNoApplicationErr	-2822	
No application member found in the cfrg resource.
cfragArchitectureErr	-2823	
A fragment has an unacceptable architecture.
cfragFragmentUsageErr	-2824	
A semantic error in usage of the fragment.
cfragFileSizeErr	-2825	
A file was too large to be mapped.
cfragNotClosureErr	-2826	
The closure ID was actually a connection ID.
cfragNoRegistrationErr	-2827	
The registration name was not found.
cfragContainerIDErr	-2828	
The fragment container ID was not valid.
cfragClosureIDErr	-2829	
The closure ID was not valid.
cfragAbortClosureErr	-2830	
Used by notification handlers to abort a closure.
cfragOutputLengthErr	-2831	
An output parameter is too small to hold the value.
cfragMapFileErr	-2851	
A file could not be mapped.
cfragExecFileRefErr	-2854	
Bundle does not have valid executable file.
cfragStdFolderErr	-2855	
Could not find standard CFM folder.
cfragRsrcForkErr	-2856	
Resource fork could not be opened.
cfragCFragRsrcErr	-2857	
'cfrg' resource could not be loaded.
cfragFirstReservedCode	-2897	
Reserved value for internal warnings.
cfragReservedCode_3	-2897	
Reserved value for internal warnings.
cfragReservedCode_2	-2898	
Reserved value for internal warnings.
cfragLastErrCode	-2899	
The last value in the range of CFM errors.
cfragReservedCode_1	-2899	*/
enum {
cfragContextIDErr	=-2800	,
cfragFirstErrCode	=-2800	,
cfragConnectionIDErr	=-2801	,
cfragNoSymbolErr	=-2802	,
cfragNoSectionErr	=-2803	,
cfragNoLibraryErr	=-2804	,
cfragDupRegistrationErr=	-2805	,
cfragFragmentFormatErr=	-2806	,
cfragUnresolvedErr	=-2807	,
cfragNoPositionErr	=-2808	,
cfragNoPrivateMemErr=	-2809	,
cfragNoClientMemErr=	-2810	,
cfragNoIDsErr	=-2811	,
cfragInitOrderErr=	-2812	,
cfragImportTooOldErr	=-2813	,
cfragImportTooNewErr	=-2814	,
cfragInitLoopErr	=-2815	,
cfragInitAtBootErr	=-2816	,
cfragCFMStartupErr	=-2818	,
cfragCFMInternalErr	=-2819	,
cfragFragmentCorruptErr=	-2820	,
cfragInitFunctionErr	=-2821	,
cfragNoApplicationErr=	-2822	,
cfragArchitectureErr	=-2823	,
cfragFragmentUsageErr=	-2824	,
cfragFileSizeErr	=-2825	,
cfragNotClosureErr	=-2826	,
cfragNoRegistrationErr=	-2827	,
cfragContainerIDErr	=-2828	,
cfragClosureIDErr	=-2829	,
cfragAbortClosureErr	=-2830	,
cfragOutputLengthErr	=-2831	,
cfragMapFileErr	=-2851	,
cfragExecFileRefErr	=-2854	,
cfragStdFolderErr	=-2855	,
cfragRsrcForkErr	=-2856	,
cfragCFragRsrcErr	=-2857	,
cfragFirstReservedCode	=-2897	,
cfragReservedCode_3	=-2897	,
cfragReservedCode_2	=-2898	,
cfragLastErrCode	=-2899	,
cfragReservedCode_1=	-2899	
};


/*Component Manager  Result Codes

The most common result codes returned by Component Manager are listed below.
Result Code	Value	Description
noErr	0	
No error
resFNotFound	-193	
Resource file not found
invalidComponentID	-3000	
Speech channel is uninitialized or bad

Invalid component ID
validInstancesExist	-3001	
This component has open connections
componentNotCaptured	-3002	
This component has not been captured
componentDontRegister	-3003	
unresolvedComponentDLLErr	-3004	
retryComponentRegistrationErr	-3005	
badComponentSelector	-2147450878	
Component does not support the specified request code
badComponentInstance	-2147450879	
Invalid component passed to Component Manager
*/
enum {
resFNotFound	=-193	,
invalidComponentID	=-3000	,
validInstancesExist	=-3001	,
componentNotCaptured	=-3002	,
componentDontRegister	=-3003	,
unresolvedComponentDLLErr=	-3004	,
retryComponentRegistrationErr	=-3005	,
badComponentSelector=	-2147450878	,
};



/* Open Transport Result Codes

The most common result codes returned by Open Transport are listed below.
Result Code	Value	Description
kOTNoError	0	
No Error occurred
kOTBadAddressErr	-3150	
XTI2OSStatus(TBADADDR) A Bad address was specified
kOTBadOptionErr	-3151	
XTI2OSStatus(TBADOPT) A Bad option was specified
kOTAccessErr	-3152	
XTI2OSStatus(TACCES) Missing access permission
kOTBadReferenceErr	-3153	
XTI2OSStatus(TBADF) Bad provider reference
kOTNoAddressErr	-3154	
XTI2OSStatus(TNOADDR) No address was specified
kOTOutStateErr	-3155	
XTI2OSStatus(TOUTSTATE) Call issued in wrong state
kOTBadSequenceErr	-3156	
XTI2OSStatus(TBADSEQ) Sequence specified does not exist
kOTSysErrorErr	-3157	
XTI2OSStatus(TSYSERR) A system error occurred
kOTLookErr	-3158	
XTI2OSStatus(TLOOK) An event occurred - call Look()
kOTBadDataErr	-3159	
XTI2OSStatus(TBADDATA) An illegal amount of data was specified
kOTBufferOverflowErr	-3160	
XTI2OSStatus(TBUFOVFLW) Passed buffer not big enough
kOTFlowErr	-3161	
XTI2OSStatus(TFLOW) Provider is flow-controlled
kOTNoDataErr	-3162	
XTI2OSStatus(TNODATA) No data available for reading
kOTNoDisconnectErr	-3163	
XTI2OSStatus(TNODIS) No disconnect indication available
kOTNoUDErrErr	-3164	
XTI2OSStatus(TNOUDERR) No Unit Data Error indication available
kOTBadFlagErr	-3165	
XTI2OSStatus(TBADFLAG) A Bad flag value was supplied
kOTNoReleaseErr	-3166	
XTI2OSStatus(TNOREL) No orderly release indication available
kOTNotSupportedErr	-3167	
XTI2OSStatus(TNOTSUPPORT) Command is not supported
kOTStateChangeErr	-3168	
XTI2OSStatus(TSTATECHNG) State is changing - try again later
kOTNoStructureTypeErr	-3169	
XTI2OSStatus(TNOSTRUCTYPE) Bad structure type requested for OTAlloc
kOTBadNameErr	-3170	
XTI2OSStatus(TBADNAME) A bad endpoint name was supplied
kOTBadQLenErr	-3171	
XTI2OSStatus(TBADQLEN) A Bind to an in-use addr with qlen > 0
kOTAddressBusyErr	-3172	
XTI2OSStatus(TADDRBUSY) Address requested is already in use
kOTIndOutErr	-3173	
XTI2OSStatus(TINDOUT) Accept failed because of pending listen
kOTProviderMismatchErr	-3174	
XTI2OSStatus(TPROVMISMATCH) Tried to accept on incompatible endpoint
kOTResQLenErr	-3175	
XTI2OSStatus(TRESQLEN)
kOTResAddressErr	-3176	
XTI2OSStatus(TRESADDR)
kOTQFullErr	-3177	
XTI2OSStatus(TQFULL)
kOTProtocolErr	-3178	
XTI2OSStatus(TPROTO) An unspecified provider error occurred
kOTBadSyncErr	-3179	
XTI2OSStatus(TBADSYNC) A synchronous call at interrupt time
kOTCanceledErr	-3180	
XTI2OSStatus(TCANCELED) The command was cancelled
kEPERMErr	-3200	
Permission denied
kENOENTErr	-3201	
No such file or directory
kOTNotFoundErr	-3201	
OT generic not found error
kENORSRCErr	-3202	
No such resource
kEINTRErr	-3203	
Interrupted system service
kEIOErr	-3204	
I/O error
kENXIOErr	-3205	
No such device or address
kEBADFErr	-3208	
Bad file number
kEAGAINErr	-3210	
Try operation again later
kENOMEMErr	-3211	
Not enough space
kOTOutOfMemoryErr	-3211	
OT ran out of memory, may be a temporary
kEACCESErr	-3212	
Permission denied
kEFAULTErr	-3213	
Bad address
kEBUSYErr	-3215	
Device or resource busy
kEEXISTErr	-3216	
File exists
kOTDuplicateFoundErr	-3216	
OT generic duplicate found error
kENODEVErr	-3218	
No such device
kEINVALErr	-3221	
Invalid argument
kENOTTYErr	-3224	
Not a character device
kEPIPEErr	-3231	
Broken pipe
kERANGEErr	-3233	
Message size too large for STREAM
kEDEADLKErr	-3234	
or a deadlock would occur
kEWOULDBLOCKErr	-3234	
Call would block, so was aborted
kEALREADYErr	-3236	
kENOTSOCKErr	-3237	
Socket operation on non-socket
kEDESTADDRREQErr	-3238	
Destination address required
kEMSGSIZEErr	-3239	
Message too long
kEPROTOTYPEErr	-3240	
Protocol wrong type for socket
kENOPROTOOPTErr	-3241	
Protocol not available
kEPROTONOSUPPORTErr	-3242	
Protocol not supported
kESOCKTNOSUPPORTErr	-3243	
Socket type not supported
kEOPNOTSUPPErr	-3244	
Operation not supported on socket
kEADDRINUSEErr	-3247	
Address already in use
kEADDRNOTAVAILErr	-3248	
Can't assign requested address
kENETDOWNErr	-3249	
Network is down
kENETUNREACHErr	-3250	
Network is unreachable
kENETRESETErr	-3251	
Network dropped connection on reset
kECONNABORTEDErr	-3252	
Software caused connection abort
kECONNRESETErr	-3253	
Connection reset by peer
kENOBUFSErr	-3254	
No buffer space available
kEISCONNErr	-3255	
Socket is already connected
kENOTCONNErr	-3256	
Socket is not connected
kESHUTDOWNErr	-3257	
Can't send after socket shutdown
kETOOMANYREFSErr	-3258	
Too many references: can't splice
kETIMEDOUTErr	-3259	
Connection timed out
kECONNREFUSEDErr	-3260	
Connection refused
kEHOSTDOWNErr	-3263	
Host is down
kEHOSTUNREACHErr	-3264	
No route to host
kEPROTOErr	-3269	
kETIMEErr	-3270	
kENOSRErr	-3271	
kEBADMSGErr	-3272	
kECANCELErr	-3273	
kENOSTRErr	-3274	
kENODATAErr	-3275	
kEINPROGRESSErr	-3276	
kESRCHErr	-3277	
kENOMSGErr	-3278	
kOTClientNotInittedErr	-3279	
kOTPortHasDiedErr	-3280	
kOTPortWasEjectedErr	-3281	
kOTBadConfigurationErr	-3282	
kOTConfigurationChangedErr	-3283	
kOTUserRequestedErr	-3284	
kOTPortLostConnection	-3285	
kModemOutOfMemory	-14000	
kModemPreferencesMissing	-14001	
kModemScriptMissing	-14002	
*/
enum {
kOTNoError=	-0,
kOTBadAddressErr=	-3150	,
kOTBadOptionErr=	-3151,
kOTAccessErr	=-3152	,
kOTBadReferenceErr=	-3153	,
kOTNoAddressErr	=-3154	,
kOTOutStateErr	=-3155	,
kOTBadSequenceErr=	-3156	,
kOTSysErrorErr	=-3157	,
kOTLookErr	=-3158	,
kOTBadDataErr	=-3159	,
kOTBufferOverflowErr=	-3160	,
kOTFlowErr	=-3161	,
kOTNoDataErr	=-3162	,
kOTNoDisconnectErr	=-3163	,
kOTNoUDErrErr=	-3164	,
kOTBadFlagErr	=-3165	,
kOTNoReleaseErr=	-3166,
kOTNotSupportedErr=	-3167	,
kOTStateChangeErr	=-3168	,
kOTNoStructureTypeErr=	-3169,
kOTBadNameErr	=-3170	,
kOTBadQLenErr	=-3171	,
kOTAddressBusyErr	=-3172	,
kOTIndOutErr	=-3173	,
kOTProviderMismatchErr=	-3174	,
kOTResQLenErr=	-3175	,
kOTResAddressErr=	-3176	,
kOTQFullErr=	-3177	,
kOTProtocolErr=	-3178	,
kOTBadSyncErr	=-3179	,
kOTCanceledErr	=-3180	,
kEPERMErr	=-3200	,
kENOENTErr	=-3201	,
kOTNotFoundErr	=-3201	,
kENORSRCErr	=-3202	,
kEINTRErr	=-3203	,
kEIOErr	=-3204	,
kENXIOErr	=-3205	,
kEBADFErr	=-3208	,
kEAGAINErr	=-3210	,
kENOMEMErr	=-3211	,
kOTOutOfMemoryErr	=-3211	,
kEACCESErr	=-3212	,
kEFAULTErr	=-3213	,
kEBUSYErr	=-3215	,
kEEXISTErr	=-3216	,
kOTDuplicateFoundErr	=-3217,
kENODEVErr	=-3218	,
kEINVALErr	=-3221	,
kENOTTYErr	=-3224	,
kEPIPEErr	=-3231	,
kERANGEErr=	-3233,
kEDEADLKErr=	-3234,
kEWOULDBLOCKErr=	-3234	,
kEALREADYErr	=-3236	,
kENOTSOCKErr	=-3237	,
kEDESTADDRREQErr	=-3238	,
kEMSGSIZEErr	=-3239	,
kEPROTOTYPEErr=	-3240,
kENOPROTOOPTErr=	-3241,
kEPROTONOSUPPORTErr	=-3242	,
kESOCKTNOSUPPORTErr	=-3243	,
kEOPNOTSUPPErr=	-3244	,
kEADDRINUSEErr	=-3247	,
kEADDRNOTAVAILErr	=-3248	,
kENETDOWNErr	=-3249	,
kENETUNREACHErr	=-3250	,
kENETRESETErr	=-3251	,
kECONNABORTEDErr=	-3252	,
kECONNRESETErr	=-3253	,
kENOBUFSErr	=-3254	,
kEISCONNErr	=-3255	,
kENOTCONNErr=	-3256	,
kESHUTDOWNErr=	-3257	,
kETOOMANYREFSErr=	-3258	,
kETIMEDOUTErr	=-3259	,
kECONNREFUSEDErr=	-3260	,
kEHOSTDOWNErr	=-3263	,
kEHOSTUNREACHErr=	-3264	,
kEPROTOErr	=-3269	,
kETIMEErr	=-3270	,
kENOSRErr=	-3271,
kEBADMSGErr=	-3272	,
kECANCELErr=	-3273	,
kENOSTRErr	=-3274	,
kENODATAErr	=-3275	,
kEINPROGRESSErr=	-3276,
kESRCHErr	=-3277	,
kENOMSGErr	=-3278	,
kOTClientNotInittedErr=	-3279	,
kOTPortHasDiedErr	=-3280	,
kOTPortWasEjectedErr=	-3281	,
kOTBadConfigurationErr=	-3282	,
kOTConfigurationChangedErr=	-3283	,
kOTUserRequestedErr	=-3284	,
kOTPortLostConnection	=-3285	,
kModemOutOfMemory	=-14000	,
kModemPreferencesMissing	=-14001	,
kModemScriptMissing	=-14002
}; 

/*Control Manager Result Codes

The table below lists the result codes returned by Control Manager functions. 
Result Code	Value	Description
controlPropertyInvalid	-5603	
You called SetControlProperty, GetControlProperty, or a similar function with an illegal property creator OSType.
controlPropertyNotFoundErr	-5604	
The property tag and creator combination does not exist for the specified control. 
errMessageNotSupported	-30580	
In general, this return value means a control, window, or menu definition does not support the message/event that underlies an API call. For example, if you call GetControlFeatures on a control whose control definition function doesn’t support “new messages” (the new group of CDEF messages that came into existence with the Appearance Manager on Mac OS 8), GetControlFeatures will return this error.
errDataNotSupported	-30581	
Returned from GetControlData and SetControlData if the control doesn’t support the tag name and/or part code that is passed in. It can also be returned from other functions that are essentially wrappers around GetControlData and SetControlData (such as SetControlFontStyle).
errControlDoesntSupportFocus	-30582	
The control you passed to a focusing function (such as SetKeyboardFocus) doesn’t support focus. On Mac OS X, you’re likely to receive errCouldntSetFocus or eventNotHandledErr i instead.
errWindowDoesntSupportFocus	-30583	
The specified window does not support focus. 
errUnknownControl	-30584	
This is a variant of (and serves the same purpose as) controlHandleInvalidErr. Various Control Manager functions return this error if one of the specified controls is NULL or otherwise invalid.
errCouldntSetFocus	-30585	
The focus couldn’t be set to a given control or advanced through a hierarchy of controls. This could be because the control doesn’t support focusing, the control isn’t currently embedded in a window, or you are attempting to advance focus in a window that contains no focusable controls. 
errNoRootControl	-30586	
No root control exists. Some examples of when you might receive this error include: 1) You called GetRootControl before anyone called CreateRootControl for a given non-compositing window. 2) You called a Control Manager function (such as ClearKeyboardFocus or AutoEmbedControl) that can only do its work if there’s a root control in the window, yet there’s no root control.
errRootAlreadyExists	-30587	
Returned by CreateRootControl if a root control already exists for the specified control. 
errInvalidPartCode	-30588	
The ControlPartCode you passed to a Control Manager function is out of range, invalid, or otherwise unsupported. For example, GetControlRegion returns errInvalidPartCode if you pass kControlNoPart.
errControlsAlreadyExist	-30589	
You called CreateRootControl after creating one or more non-root controls in a window, which is illegal; if you want an embedding hierarchy on a given window, you must call CreateRootControl before creating any other controls for a given window.This is never returned on Mac OS X, because a root control is created automatically (if it doesn’t already exist) the first time any nonroot control is created in a window.
errControlIsNotEmbedder	-30590	
The control does not support embedding. Returned, for example, by GetIndexedSubControl and EmbedControl.
errDataSizeMismatch	-30591	
You called GetControlData or SetControlData with a buffer whose size does not match the size of the data you are attempting to get or set.
errControlHiddenOrDisabled	-30592	
You called TrackControl, HandleControlClick, or a similar mouse tracking function, on a control that is invisible or disabled. You cannot track controls that are invisible or disabled.
errWindowRegionCodeInvalid	-30593	
The window region code is invalid.
errCantEmbedIntoSelf	-30594	
You called EmbedControl (or a similar function) with the same control in the parent and child parameters. In other words, you cannot embed a control into itself.
errCantEmbedRoot	-30595	
You attempted to embed the root control in another control. 
errItemNotControl	-30596	
You called GetDialogItemAsControl on a dialog item (such as a kHelpDialogItem) that is not represented by a control.
controlInvalidDataVersionErr	-30597	
You called GetControlData or SetControlData with a buffer that represents a versioned structure, but the version is unsupported by the control definition. This can happen with the Tabs control and the kControlTabInfoTag.
controlHandleInvalidErr	-30599	
The control reference passed in was invalid.*/
enum {
controlPropertyInvalid=	-5603	,
controlPropertyNotFoundErr	=-5604	,
errMessageNotSupported	=-30580	,
errDataNotSupported	=-30581	,
errControlDoesntSupportFocus	=-30582	,
errWindowDoesntSupportFocus	=-30583	,
errUnknownControl	=-30584	,
errCouldntSetFocus	=-30585	,
errNoRootControl	=-30586	,
errRootAlreadyExists	=-30587	,
errInvalidPartCode	=-30588	,
errControlsAlreadyExist=	-30589	,
errControlIsNotEmbedder=	-30590	,
errDataSizeMismatch	=-30591	,
errControlHiddenOrDisabled	=-30592	,
errWindowRegionCodeInvalid	=-30593	,
errCantEmbedIntoSelf	=-30594	,
errCantEmbedRoot	=-30595	,
errItemNotControl	=-30596	,
controlInvalidDataVersionErr	=-30597	,
controlHandleInvalidErr	=-30599	
};

/* Multiprocessing Services  Result Codes

The most common result codes returned by Multiprocessing Services are listed below.
Result Code	Value	Description
noErr	0	
No error
paramErr	-50	
Invalid value passed in a parameter. Your application passed an invalid parameter for dialog options.
memFullErr	-108	
Not enough memory

Not enough room in heap zone.

Not enough memory to speak
kMPTaskBlockedErr	-29291	
The desired task is blocked.
kMPTaskStoppedErr	-29292	
The desired task is stopped.
kMPDeletedErr	-29295	
The desired notification the function was waiting upon was deleted
kMPTimeoutErr	-29296	
The designated timeout interval passed before the function could take action.
kMPInsufficientResourcesErr	-29298	
Could not complete task due to unavailable Multiprocessing Services resources.

Note that many functions return this value as a general error when the desired action could not be performed.
kMPInvalidIDErr	-29299	
Invalid ID value (for example, an invalid message queue ID was passed to MPNotifyQueue*/
enum {
//noErr=	0	,
//paramErr=	-50	,
//memFullErr=	-108	,
kMPTaskBlockedErr	=-29291	,
kMPTaskStoppedErr	=-29292	,
kMPDeletedErr	=-29295	,
kMPTimeoutErr	=-29296	,
kMPInsufficientResourcesErr	=-29298	
};


/*SpeechSynthesis Result Codes

The most common result codes returned by Speech Synthesis Manager are listed below.
Result Code	Value	Description
noSynthFound	-240	
Could not find the specified speech synthesizer
synthOpenFailed	-241	
Could not open another speech synthesizer channel
synthNotReady	-242	
Speech synthesizer is still busy speaking
bufTooSmall	-243	
Output buffer is too small to hold result
voiceNotFound	-244	
Voice resource not found
incompatibleVoice	-245	
Specified voice cannot be used with synthesizer
badDictFormat	-246	
Pronunciation dictionary format error
badInputText	-247	
Raw phoneme text contains invalid characters*/
enum {
noSynthFound	=-240	,
synthOpenFailed	=-241	,
synthNotReady	=-242	,
bufTooSmall	=-243	,
voiceNotFound	=-244	,
incompatibleVoice	=-245	,
badDictFormat	=-246	,
badInputText	=-247	
};


/*Memory Management Utilities  Result Codes

The most common result codes returned by Memory Management Utilities are listed in the table below. Memory Management Utilities may also return the following errors:
noErr (0)
paramErr (-50)
prWrErr (-87)
prInitErr (-88)
memROZErr (-99)
memFullErr (-108)
nilHandleErr (-109)
memWZErr (-111)
memPurErr (-112)
memBCErr (-115)
memLockedErr (-117)
notEnoughMemoryErr (-620)
notHeldErr (-621)
cannotMakeContiguousErr (-622)
notLockedErr (-623)
interruptsMaskedErr (-624)
cannotDeferErr (-625)
Result Code	Value	Description
qErr	-1	
Queue element not found during deletion.
vTypErr	-2	
Invalid queue element.
corErr	-3	
Core routine number out of range
unimpErr	-4	
Unimplemented core routine.
SlpTypeErr	-5	
Invalid queue element.
hwParamErr	-502	
Processor does not support flushing a range.


 Show TOC*/
enum {
qErr =	-1,
vTypErr	=-2,	
corErr	=-3	,
unimpErr =	-4	,
SlpTypeErr	=-5,
hwParamErr=	-502	
};
/*Error Codes

Identify errors generated while executing QuickTime calls.

// General QuickTime errors
couldNotResolveDataRef                =-2000
badImageDescription                   =-2001
badPublicMovieAtom                    =-2002
cantFindHandler                       =-2003
cantOpenHandler                       =-2004
badComponentType                      =-2005
noMediaHandler                        =-2006
noDataHandler                         =-2007
invalidMedia                          =-2008
invalidTrack                          =-2009
invalidMovie                          =-2010
invalidSampleTable                    =-2011
invalidDataRef                        =-2012
invalidHandler                        =-2013
invalidDuration                       =-2014
invalidTime                           =-2015
cantPutPublicMovieAtom                =-2016
badEditList                           =-2017
mediaTypesDontMatch                   =-2018
progressProcAborted                   =-2019
movieToolboxUninitialized             =-2020
noRecordOfApp                         =-2020
wfFileNotFound                        =-2021
cantCreateSingleForkFile              =-2022
invalidEditState                      =-2023
nonMatchingEditState                  =-2024
staleEditState                        =-2025
userDataItemNotFound                  =-2026
maxSizeToGrowTooSmall                 =-2027
badTrackIndex                         =-2028
trackIDNotFound                       =-2029
trackNotInMovie                       =-2030
timeNotInTrack                        =-2031
timeNotInMedia                        =-2032
badEditIndex                          =-2033
internalQuickTimeError                =-2034
cantEnableTrack                       =-2035
invalidRect                           =-2036
invalidSampleNum                      =-2037
invalidChunkNum                       =-2038
invalidSampleDescIndex                =-2039
invalidChunkCache                     =-2040
invalidSampleDescription              =-2041
dataNotOpenForRead                    =-2042
dataNotOpenForWrite                   =-2043
dataAlreadyOpenForWrite               =-2044
dataAlreadyClosed                     =-2045
endOfDataReached                      =-2046
dataNoDataRef                         =-2047
noMovieFound                          =-2048
invalidDataRefContainer               =-2049
badDataRefIndex                       =-2050
noDefaultDataRef                      =-2051
couldNotUseAnExistingSample           =-2052
featureUnsupported                    =-2053
unsupportedAuxiliaryImportData        =-2057
auxiliaryExportDataUnavailable        =-2058
samplesAlreadyInMediaErr              =-2059
noSourceTreeFoundErr                  =-2060
sourceNotFoundErr                     =-2061
movieTextNotFoundErr                  =-2062
missingRequiredParameterErr           =-2063
invalidSpriteWorldPropertyErr         =-2064
invalidSpritePropertyErr              =-2065
gWorldsNotSameDepthAndSizeErr         =-2066
invalidSpriteIndexErr                 =-2067
invalidImageIndexErr                  =-2068
invalidSpriteIDErr                    =-2069
// QuickTime Music Architecture errors
internalComponentErr                  =-2070
notImplementedMusicOSErr              =-2071
cantSendToSynthesizerOSErr            =-2072
cantReceiveFromSynthesizerOSErr       =-2073
illegalVoiceAllocationOSErr           =-2074
illegalPartOSErr                      =-2075
illegalChannelOSErr                   =-2076
illegalKnobOSErr                      =-2077
illegalKnobValueOSErr                 =-2078
illegalInstrumentOSErr                =-2079
illegalControllerOSErr                =-2080
midiManagerAbsentOSErr                =-2081
synthesizerNotRespondingOSErr         =-2082
synthesizerOSErr                      =-2083
illegalNoteChannelOSErr               =-2084
noteChannelNotAllocatedOSErr          =-2085
tunePlayerFullOSErr                   =-2086
tuneParseOSErr                        =-2087
noExportProcAvailableErr              =-2089
videoOutputInUseErr                   =-2090
// Windows-specific errors
componentDllLoadErr                   =-2091
componentDllEntryNotFoundErr          =-2092
qtmlDllLoadErr                        =-2093
qtmlDllEntryNotFoundErr               =-2094
qtmlUninitialized                     =-2095
unsupportedOSErr                      =-2096
unsupportedProcessorErr               =-2097
noVideoTrackInMovieErr                =-2054
noSoundTrackInMovieErr                =-2055
soundSupportNotAvailableErr           =-2056
// QT atom errors
cannotFindAtomErr                     =-2101
notLeafAtomErr                        =-2102
atomsNotOfSameTypeErr                 =-2103
atomIndexInvalidErr                   =-2104
duplicateAtomTypeAndIDErr             =-2105
invalidAtomErr                        =-2106
invalidAtomContainerErr               =-2107
invalidAtomTypeErr                    =-2108
cannotBeLeafAtomErr                   =-2109
// Data access errors
pathTooLongErr                        =-2110
emptyPathErr                          =-2111
noPathMappingErr                      =-2112
pathNotVerifiedErr                    =-2113
unknownFormatErr                      =-2114
wackBadFileErr                        =-2115
wackForkNotFoundErr                   =-2116
wackBadMetaDataErr                    =-2117
qfcbNotFoundErr                       =-2118
qfcbNotCreatedErr                     =-2119
AAPNotCreatedErr                      =-2120
AAPNotFoundErr                        =-2121
ASDBadHeaderErr                       =-2122
ASDBadForkErr                         =-2123
ASDEntryNotFoundErr                   =-2124
fileOffsetTooBigErr                   =-2125
notAllowedToSaveMovieErr              =-2126
qtNetworkAlreadyAllocatedErr          =-2127
urlDataHHTTPProtocolErr               =-2129
urlDataHHTTPNoNetDriverErr            =-2130
urlDataHHTTPURLErr                    =-2131
urlDataHHTTPRedirectErr               =-2132
urlDataHFTPProtocolErr                =-2133
urlDataHFTPShutdownErr                =-2134
urlDataHFTPBadUserErr                 =-2135
urlDataHFTPBadPasswordErr             =-2136
urlDataHFTPServerErr                  =-2137
urlDataHFTPDataConnectionErr          =-2138
urlDataHFTPNoDirectoryErr             =-2139
urlDataHFTPQuotaErr                   =-2140
urlDataHFTPPermissionsErr             =-2141
urlDataHFTPFilenameErr                =-2142
urlDataHFTPNoNetDriverErr             =-2143
urlDataHFTPBadNameListErr             =-2144
urlDataHFTPNeedPasswordErr            =-2145
urlDataHFTPNoPasswordErr              =-2146
urlDataHFTPServerDisconnectedErr      =-2147
urlDataHFTPURLErr                     =-2148
notEnoughDataErr                      =-2149
qtActionNotHandledErr                 =-2157
// Digitizing errors
digiUnimpErr                          =-2201
qtParamErr                            =-2202
matrixErr                             =-2203
notExactMatrixErr                     =-2204
noMoreKeyColorsErr                    =-2205
notExactSizeErr                       =-2206
badDepthErr                           =-2207
noDMAErr                              =-2208
badCallOrderErr                       =-2209
// Codec errors
codecErr                              =-8960
noCodecErr                            =-8961
codecUnimpErr                         =-8962
codecSizeErr                          =-8963
codecScreenBufErr                     =-8964
codecImageBufErr                      =-8965
codecSpoolErr                         =-8966
codecAbortErr                         =-8967
codecWouldOffscreenErr                =-8968
codecBadDataErr                       =-8969
codecDataVersErr                      =-8970
codecExtensionNotFoundErr             =-8971
scTypeNotFoundErr                     =-8971
codecConditionErr                     =-8972
codecOpenErr                          =-8973
codecCantWhenErr                      =-8974
codecCantQueueErr                     =-8975
codecNothingToBlitErr                 =-8976
codecNoMemoryPleaseWaitErr            =-8977
codecDisabledErr                      =-8978
codecNeedToFlushChainErr              =-8979
lockPortBitsBadSurfaceErr             =-8980
lockPortBitsWindowMovedErr            =-8981
lockPortBitsWindowResizedErr          =-8982
lockPortBitsWindowClippedErr          =-8983
lockPortBitsBadPortErr                =-8984
lockPortBitsSurfaceLostErr            =-8985
codecParameterDialogConfirm           =-8986
codecNeedAccessKeyErr                 =-8987
codecOffscreenFailedErr               =-8988
codecDroppedFrameErr                  =-8989
directXObjectAlreadyExists            =-8990
lockPortBitsWrongGDeviceErr           =-8991
codecOffscreenFailedPleaseRetryErr    =-8992
// Sequence Grabber errors
noDeviceForChannel                    =-9400,
grabTimeComplete                      =-9401,
cantDoThatInCurrentMode               =-9402,
notEnoughMemoryToGrab                 =-9403,
notEnoughDiskSpaceToGrab              =-9404,
couldntGetRequiredComponent           =-9405,
badSGChannel                          =-9406,
seqGrabInfoNotAvailable               =-9407,
deviceCantMeetRequest                 =-9408,
// Movie Controller errors
badControllerHeight                   =-9994,
editingNotAllowed                     =-9995,
controllerBoundsNotExact              =-9996,
cannotSetWidthOfAttachedController    =-9997,
controllerHasFixedHeight              =-9998,
cannotMoveAttachedController          =-9999
// QuickTime VR Errors
notAQTVRMovieErr                      =-30540
constraintReachedErr                  =-30541
callNotSupportedByNodeErr             =-30542
selectorNotSupportedByNodeErr         =-30543
invalidNodeIDErr                      =-30544
invalidViewStateErr                   =-30545
timeNotInViewErr                      =-30546
propertyNotSupportedByNodeErr         =-30547
settingNotSupportedByNodeErr          =-30548
limitReachedErr                       =-30549
invalidNodeFormatErr                  =-30550
invalidHotSpotIDErr                   =-30551
noMemoryNodeFailedInitialize          =-30552
streamingNodeNotReadyErr              =-30553
qtvrLibraryLoadErr                    =-30554
qtvrUninitialized                     =-30555
noRecordOfApp

A replica of the movieToolboxUninitialized error. 

Available in Mac OS X v10.0 and later.
cantCreateSingleForkFile

The file to be created already exists. 

Available in Mac OS X v10.0 and later.
componentDllLoadErr

Windows error returned when a component is loading. 

Available in Mac OS X v10.0 and later.
componentDllEntryNotFoundErr

Windows error returned when a component is loading. 

Available in Mac OS X v10.0 and later.
qtmlDllLoadErr

Windows error returned when the QuickTime Media Layer is loading. 

Available in Mac OS X v10.0 and later.
qtmlDllEntryNotFoundErr

Windows error returned when the QuickTime Media Layer is loading. 

Available in Mac OS X v10.0 and later.
digiUnimpErr

Digitizer feature is unimplemented. 

Available in Mac OS X v10.0 and later.
qtParamErr

Bad input parameter (out of range, for example). 

Available in Mac OS X v10.0 and later.
matrixErr

Bad matrix; the digitizer did nothing. 

Available in Mac OS X v10.0 and later.
notExactMatrixErr

Warning of a bad matrix; the digitizer did its best. 

Available in Mac OS X v10.0 and later.
noMoreKeyColorsErr

All the key indexes are in use. 

Available in Mac OS X v10.0 and later.
notExactSizeErr

Can't digitize to the exact size requested. 

Available in Mac OS X v10.0 and later.
badDepthErr

Can't digitize into the requested pixel depth. 

Available in Mac OS X v10.0 and later.
noDMAErr

Can't do DMA digitizing; that is, can't go to the requested destination. 

Available in Mac OS X v10.0 and later.
badCallOrderErr

A status call was made before being set up first. 

Available in Mac OS X v10.0 and later.
Discussion

The Movie Toolbox provides two error values to your application: the current error and the sticky error. The current error is the result code from the last Movie Toolbox function; it is updated each time your application calls a Movie Toolbox function. The sticky error value contains the first nonzero result code from any Movie Toolbox function that you called after having cleared the sticky error with ClearMoviesStickyError.*/
enum {
// General QuickTime errors
couldNotResolveDataRef                =-2000,
badImageDescription                   =-2001,
badPublicMovieAtom                    =-2002,
cantFindHandler                       =-2003,
cantOpenHandler                       =-2004,
badComponentType                      =-2005,
noMediaHandler                        =-2006,
noDataHandler                         =-2007,
invalidMedia                          =-2008,
invalidTrack                          =-2009,
invalidMovie                          =-2010,
invalidSampleTable                    =-2011,
invalidDataRef                        =-2012,
invalidHandler                        =-2013,
invalidDuration                       =-2014,
invalidTime                           =-2015,
cantPutPublicMovieAtom                =-2016,
badEditList                           =-2017,
mediaTypesDontMatch                   =-2018,
progressProcAborted                   =-2019,
movieToolboxUninitialized             =-2020,
noRecordOfApp                         =-2020,
wfFileNotFound                        =-2021,
cantCreateSingleForkFile              =-2022,
invalidEditState                      =-2023,
nonMatchingEditState                  =-2024,
staleEditState                        =-2025,
userDataItemNotFound                  =-2026,
maxSizeToGrowTooSmall                 =-2027,
badTrackIndex                         =-2028,
trackIDNotFound                       =-2029,
trackNotInMovie                       =-2030,
timeNotInTrack                        =-2031,
timeNotInMedia                        =-2032,
badEditIndex                          =-2033,
internalQuickTimeError                =-2034,
cantEnableTrack                       =-2035,
invalidRect                           =-2036,
invalidSampleNum                      =-2037,
invalidChunkNum                       =-2038,
invalidSampleDescIndex                =-2039,
invalidChunkCache                     =-2040,
invalidSampleDescription              =-2041,
dataNotOpenForRead                    =-2042,
dataNotOpenForWrite                   =-2043,
dataAlreadyOpenForWrite               =-2044,
dataAlreadyClosed                     =-2045,
endOfDataReached                      =-2046,
dataNoDataRef                         =-2047,
noMovieFound                          =-2048,
invalidDataRefContainer               =-2049,
badDataRefIndex                       =-2050,
noDefaultDataRef                      =-2051,
couldNotUseAnExistingSample           =-2052,
featureUnsupported                    =-2053,
unsupportedAuxiliaryImportData        =-2057,
auxiliaryExportDataUnavailable        =-2058,
samplesAlreadyInMediaErr              =-2059,
noSourceTreeFoundErr                  =-2060,
sourceNotFoundErr                     =-2061,
movieTextNotFoundErr                  =-2062,
missingRequiredParameterErr           =-2063,
invalidSpriteWorldPropertyErr         =-2064,
invalidSpritePropertyErr              =-2065,
gWorldsNotSameDepthAndSizeErr         =-2066,
invalidSpriteIndexErr                 =-2067,
invalidImageIndexErr                  =-2068,
invalidSpriteIDErr                    =-2069,
// QuickTime Music Architecture errors
internalComponentErr                  =-2070,
notImplementedMusicOSErr              =-2071,
cantSendToSynthesizerOSErr            =-2072,
cantReceiveFromSynthesizerOSErr       =-2073,
illegalVoiceAllocationOSErr           =-2074,
illegalPartOSErr                      =-2075,
illegalChannelOSErr                   =-2076,
illegalKnobOSErr                      =-2077,
illegalKnobValueOSErr                 =-2078,
illegalInstrumentOSErr                =-2079,
illegalControllerOSErr                =-2080,
midiManagerAbsentOSErr                =-2081,
synthesizerNotRespondingOSErr         =-2082,
synthesizerOSErr                      =-2083,
illegalNoteChannelOSErr               =-2084,
noteChannelNotAllocatedOSErr          =-2085,
tunePlayerFullOSErr                   =-2086,
tuneParseOSErr                        =-2087,
noExportProcAvailableErr              =-2089,
videoOutputInUseErr                   =-2090,
// Windows-specific errors
componentDllLoadErr                   =-2091,
componentDllEntryNotFoundErr          =-2092,
qtmlDllLoadErr                        =-2093,
qtmlDllEntryNotFoundErr               =-2094,
qtmlUninitialized                     =-2095,
unsupportedOSErr                      =-2096,
unsupportedProcessorErr               =-2097,
noVideoTrackInMovieErr                =-2054,
noSoundTrackInMovieErr                =-2055,
soundSupportNotAvailableErr           =-2056,
// QT atom errors
cannotFindAtomErr                     =-2101,
notLeafAtomErr                        =-2102,
atomsNotOfSameTypeErr                 =-2103,
atomIndexInvalidErr                   =-2104,
duplicateAtomTypeAndIDErr             =-2105,
invalidAtomErr                        =-2106,
invalidAtomContainerErr               =-2107,
invalidAtomTypeErr                    =-2108,
cannotBeLeafAtomErr                   =-2109,
// Data access errors
pathTooLongErr                        =-2110,
emptyPathErr                          =-2111,
noPathMappingErr                      =-2112,
pathNotVerifiedErr                    =-2113,
unknownFormatErr                      =-2114,
wackBadFileErr                        =-2115,
wackForkNotFoundErr                   =-2116,
wackBadMetaDataErr                    =-2117,
qfcbNotFoundErr                       =-2118,
qfcbNotCreatedErr                     =-2119,
AAPNotCreatedErr                      =-2120,
AAPNotFoundErr                        =-2121,
ASDBadHeaderErr                       =-2122,
ASDBadForkErr                         =-2123,
ASDEntryNotFoundErr                   =-2124,
fileOffsetTooBigErr                   =-2125,
notAllowedToSaveMovieErr              =-2126,
qtNetworkAlreadyAllocatedErr          =-2127,
urlDataHHTTPProtocolErr               =-2129,
urlDataHHTTPNoNetDriverErr            =-2130,
urlDataHHTTPURLErr                    =-2131,
urlDataHHTTPRedirectErr               =-2132,
urlDataHFTPProtocolErr                =-2133,
urlDataHFTPShutdownErr                =-2134,
urlDataHFTPBadUserErr                 =-2135,
urlDataHFTPBadPasswordErr             =-2136,
urlDataHFTPServerErr                  =-2137,
urlDataHFTPDataConnectionErr          =-2138,
urlDataHFTPNoDirectoryErr             =-2139,
urlDataHFTPQuotaErr                   =-2140,
urlDataHFTPPermissionsErr             =-2141,
urlDataHFTPFilenameErr                =-2142,
urlDataHFTPNoNetDriverErr             =-2143,
urlDataHFTPBadNameListErr             =-2144,
urlDataHFTPNeedPasswordErr            =-2145,
urlDataHFTPNoPasswordErr              =-2146,
urlDataHFTPServerDisconnectedErr      =-2147,
urlDataHFTPURLErr                     =-2148,
notEnoughDataErr                      =-2149,
qtActionNotHandledErr                 =-2157,
// Digitizing errors
digiUnimpErr                          =-2201,
qtParamErr                            =-2202,
matrixErr                             =-2203,
notExactMatrixErr                     =-2204,
noMoreKeyColorsErr                    =-2205,
notExactSizeErr                       =-2206,
badDepthErr                           =-2207,
noDMAErr                              =-2208,
badCallOrderErr                       =-2209,
// Codec errors
codecErr                              =-8960,
noCodecErr                            =-8961,
codecUnimpErr                         =-8962,
codecSizeErr                          =-8963,
codecScreenBufErr                     =-8964,
codecImageBufErr                      =-8965,
codecSpoolErr                         =-8966,
codecAbortErr                         =-8967,
codecWouldOffscreenErr                =-8968,
codecBadDataErr                       =-8969,
codecDataVersErr                      =-8970,
codecExtensionNotFoundErr             =-8971,
scTypeNotFoundErr                     =-8971,
codecConditionErr                     =-8972,
codecOpenErr                          =-8973,
codecCantWhenErr                      =-8974,
codecCantQueueErr                     =-8975,
codecNothingToBlitErr                 =-8976,
codecNoMemoryPleaseWaitErr            =-8977,
codecDisabledErr                      =-8978,
codecNeedToFlushChainErr              =-8979,
lockPortBitsBadSurfaceErr             =-8980,
lockPortBitsWindowMovedErr            =-8981,
lockPortBitsWindowResizedErr          =-8982,
lockPortBitsWindowClippedErr          =-8983,
lockPortBitsBadPortErr                =-8984,
lockPortBitsSurfaceLostErr            =-8985,
codecParameterDialogConfirm           =-8986,
codecNeedAccessKeyErr                 =-8987,
codecOffscreenFailedErr               =-8988,
codecDroppedFrameErr                  =-8989,
directXObjectAlreadyExists            =-8990,
lockPortBitsWrongGDeviceErr           =-8991,
codecOffscreenFailedPleaseRetryErr    =-8992,
// Sequence Grabber errors
noDeviceForChannel                    =-9400,
grabTimeComplete                      =-9401,
cantDoThatInCurrentMode               =-9402,
notEnoughMemoryToGrab                 =-9403,
notEnoughDiskSpaceToGrab              =-9404,
couldntGetRequiredComponent           =-9405,
badSGChannel                          =-9406,
seqGrabInfoNotAvailable               =-9407,
deviceCantMeetRequest                 =-9408,
// Movie Controller errors
badControllerHeight                   =-9994,
editingNotAllowed                     =-9995,
controllerBoundsNotExact              =-9996,
cannotSetWidthOfAttachedController    =-9997,
controllerHasFixedHeight              =-9998,
cannotMoveAttachedController          =-9999,
// QuickTime VR Errors
notAQTVRMovieErr                      =-30540,
constraintReachedErr                  =-30541,
callNotSupportedByNodeErr             =-30542,
selectorNotSupportedByNodeErr         =-30543,
invalidNodeIDErr                      =-30544,
invalidViewStateErr                   =-30545,
timeNotInViewErr                      =-30546,
propertyNotSupportedByNodeErr         =-30547,
settingNotSupportedByNodeErr          =-30548,
limitReachedErr                       =-30549,
invalidNodeFormatErr                  =-30550,
invalidHotSpotIDErr                   =-30551,
noMemoryNodeFailedInitialize          =-30552,
streamingNodeNotReadyErr              =-30553,
qtvrLibraryLoadErr                    =-30554,
qtvrUninitialized                     =-30555
};

/*Error Handling

Calling EnterMoviesOnThread indicates that QuickTime should perform additional thread-safety checks on components opened and operations performed on the thread. If you call a function that requires use of a non-thread-safe component, or requires access to the user interface, or performs another thread-unsafe operation, QuickTime returns a distinguished error (componentNotThreadSafeErr = -2098).

Not all QuickTime components are thread-safe, so your code should be designed to detect threading error messages and transfer necessary tasks to the main thread. For example, you might spawn a thread to import a list of image files. The thread would import all the image files that have thread-safe importer components and return a list of any unhandled cases to the main thread, which could then import any remaining image files in the foreground.

From the main thread, your application can call CSSetComponentsThreadMode, passing it kCSAcceptThreadSafeComponentsOnlyMode, to see if opening a movie or other QuickTime object will succeed when attempted from a preemptive thread. You can do this only with Mac OS X version 10.3 or later.*/
enum {
componentNotThreadSafeErr = -2098
};
/*File Manager Result Codes

The most common result codes returned by File Manager are listed below.Result Code	Value	Description
dirFulErr	-33	
File directory full
dskFulErr	-34	
Disk or volume full
nsvErr	-35	
Volume not found
ioErr	-36	
I/O error.
bdNamErr	-37	
Bad filename or volume name
fnOpnErr	-38	
File not open.
eofErr	-39	
Logical end-of-file reached.
posErr	-40	
Attempt to position mark before the start of the file.
mFulErr	-41	
Memory full (open) or file won't fit (load)
tmfoErr	-42	
Too many files open
fnfErr	-43	
File or directory not found; incomplete pathname
wPrErr	-44	
Volume is locked through hardware
fLckdErr	-45	
File is locked. 
vLckdErr	-46	
Volume is locked through software
fBsyErr	-47	
One or more files are open

File is busy

Directory is not empty.
dupFNErr	-48	
Duplicate filename and version

Destination file already exists

File found instead of folder
opWrErr	-49	
File already open for writing
paramErr	-50	
Invalid value passed in a parameter. Your application passed an invalid parameter for dialog options.
rfNumErr	-51	
Invalid reference number
gfpErr	-52	
Error during GetFPos, PBGetFPosSync or PBGetFPosAsync
volOffLinErr	-53	
Volume is offline
permErr	-54	
Attempt to open locked file for writing

Permissions error
volOnLinErr	-55	
Volume already online
nsDrvErr	-56	
No such drive
noMacDskErr	-57	
Not a Macintosh disk
extFSErr	-58	
Volume belongs to an external file system
fsRnErr	-59	
Problem during rename
badMDBErr	-60	
Bad master directory block
wrPermErr	-61	
Read/ write permission doesn’t allow writing.
lastDskErr	-64	
noDriveErr	-64	
Drive not installed
firstDskErr	-84	
dirNFErr	-120	
Directory not found or incomplete pathname
tmwdoErr	-121	
Too many working directories open
badMovErr	-122	
Attempt to move
wrgVolTypErr	-123	
Volume does not support Desktop Manager

Not an HFS volume
volGoneErr	-124	
Server volume has been disconnected
fsDSIntErr	-127	
non-hardware internal file system error
fsmFFSNotFoundErr	-431	
Foreign File system does not exist - new Pack2 could return this error too
fsmBusyFFSErr	-432	
File system is busy, cannot be removed
fsmBadFFSNameErr	-433	
Name length not 1 <= length <= 31
fsmBadFSDLenErr	-434	
FSD size incompatible with current FSM vers
fsmDuplicateFSIDErr	-435	
FSID already exists on InstallFS
fsmBadFSDVersionErr	-436	
FSM version incompatible with FSD
fsmNoAlternateStackErr	-437	
no alternate stack for HFS CI
fsmUnknownFSMMessageErr	-438	
unknown message passed to FSM
driverHardwareGoneErr	-503	
disk driver's hardware was disconnected
fidNotFound	-1300	
File ID not found
fidExists	-1301	
File ID already exists
notAFileErr	-1302	
Specified file is a directory
diffVolErr	-1303	
Files on different volumes
catChangedErr	-1304	
Catalog has changed and catalog position record may be invalid
sameFileErr	-1306	
Can’t exchange a file with itself
badFidErr	-1307	
File ID is dangling or doesn’t match with the file number
notARemountErr	-1308	
_Mount allows only remounts and doesn’t get one
fileBoundsErr	-1309	
File’s EOF, offset, mark or size is too big
fsDataTooBigErr	-1310	
File or volume is too big for system
volVMBusyErr	-1311	
Can’t eject because volume is in use by VM
badFCBErr	-1327	
FCBRecPtr is not valid
errFSUnknownCall	-1400	
Selector is not recognized by this file system
errFSBadFSRef	-1401	
An FSRef parameter was invalid. There are several possible causes:

The parameter was not optional, but the pointer was NULL.

The volume reference number contained within the FSRef does not match a currently mounted volume. This can happen if the volume was unmounted after the FSRef was created.

Some other private field inside the FSRef contains a value that could never be valid. If the field value could be valid, but doesn’t happen to match the existing volume or in-memory structures, a “not found” error would be returned instead.
errFSBadForkName	-1402	
A supplied fork name was invalid (i.e., was syntactically illegal for the given volume). For example, the fork name might contain characters that cannot be stored on the given volume (such as a colon on HFS volumes).

Some volume formats do not store fork names in Unicode. These volume formats will attempt to convert the Unicode name to the kind of encoding used by the volume format. If the name could not be converted, errFSBadForkName is returned.

Some volume formats only support a limited set of forks, such as the data and resource forks on HFS volumes. For those volumes, if any other fork name is passed, this error is returned.
errFSBadBuffer	-1403	
A non-optional buffer pointer was NULL , or its size was invalid for the type of data it was expected to contain. In a protected memory system, this could also mean the buffer space is not part of the address space for the calling process.
errFSBadForkRef	-1404	
A file reference number does not correspond to a fork opened with the FSOpenFork, PBOpenForkSync , or PBOpenForkAsync functions. This could be because that fork has already been closed. Or, you may have passed a referece number created with older APIs (e.g., by the PBHOpenDF functions). A value of zero is never a valid file reference number.
errFSBadInfoBitmap	-1405	
A FSCatalogInfoBitmap or FSVolumeInfoBitmap has one or more reserved or undefined bits set. This error code can also be returned if a defined bit is set, but the corresponding FSCatalogInfo or FSVolumeInfo field cannot be operated on with that call (for example, trying to use FSSetCatalogInfo to set the valence of a directory).
errFSMissingCatInfo	-1406	
A FSCatalogInfo pointer is NULL , but is not optional. Or, the FSCatalogInfo is optional and NULL, but the corresponding FSCatalogInfoBitmap is not zero (that is,the bitmap says that one or more of the FSCatalogInfo fields is being passed, but the supplied pointer was NULL).
errFSNotAFolder	-1407	
A parameter was expected to identify a folder, but it identified some other kind of object (e.g., a file) instead. This implies that the specified object exists, but is of the wrong type. For example, one of the parameters to FSCreateFileUnicode is an FSRef of the directory where the file will be created; if the FSRef actually refers to a file, this error is returned.
errFSForkNotFound	-1409	
An attempt to specify a fork of a given file or directory, but that particular fork does not exist.
errFSNameTooLong	-1410	
A file or fork name was too long. This means that the given name could never exist; this is different from a “file not found” or errFSForkNotFound error.
errFSMissingName	-1411	
A required file or fork name parameter was a NULL pointer, or the length of a filename was zero.
errFSBadPosMode	-1412	
Reserved or invalid bits in a positionMode field were set. For example, the FSReadFork call does not support newline mode, so setting the newline bit or a newline character in the positionMode parameter would cause this error.
errFSBadAllocFlags	-1413	
Reserved or invalid bits were set in an FSAllocationFlags parameter. 
errFSNoMoreItems	-1417	
There are no more items to return when enumerating a directory or searching a volume. Note that FSCatalogSearch returns this error, whereas the PBCatSearch functions would return eofErr.
errFSBadItemCount	-1418	
The maximumObjects parameter to FSGetCatalogInfoBulk or FSCatalogSearch was zero.
errFSBadSearchParams	-1419	
The search criteria to FSCatalogSearch are invalid or inconsistent.
errFSRefsDifferent	-1420	
The two FSRef structures passed to FSCompareFSRefs are for different files or directories. Note that a volume format may be able to compare the FSRef structures without searching for the files or directories, so this error may be returned even if one or both of the FSRef structures refers to non-existent objects.
errFSForkExists	-1421	
An attempt to create a fork, but that fork already exists.
errFSBadIteratorFlags	-1422	
The flags passed to FSOpenIterator are invalid.
errFSIteratorNotFound	-1423	
The value of an FSIterator parameter does not correspond to any currently open iterator.
errFSIteratorNotSupported	-1424	
The iterator flags or container of an FSIterator are not supported by that call. For example, in the initial release, the FSCatalogSearch call only supports an iterator whose container is in the volume’s root directory and whose flags are kFSIterateSubtree (i.e., an iterator for the entire volume’s contents). Similarly, in the initial release, FSGetCatalogInfoBulk only supports an iterator whose flags are kFSIterateFlat.
errFSQuotaExceeded	-1425	
The user’s quota of disk blocks has been exhausted
afpAccessDenied	-5000	
User does not have the correct access to the file

Directory cannot be shared
afpAuthContinue	-5001	
Further information required to complete AFPLogin call
afpBadUAM	-5002	
User authentication method is unknown
afpBadVersNum	-5003	
Workstation is using an AFP version that the server doesn’t recognize
afpBitmapErr	-5004	
Bitmap contained bits undefined for call
afpCantMove	-5005	
Move destination is offspring of source or root was specified
afpDenyConflict	-5006	
Requested user permission not possible
afpDirNotEmpty	-5007	
Cannot delete non-empty directory
afpDiskFull	-5008	
Insufficient free space on volume for operation
afpEofError	-5009	
Read beyond logical end-of-file
afpFileBusy	-5010	
Cannot delete an open file
afpFlatVol	-5011	
Cannot create directory on specified volume
afpItemNotFound	-5012	
Unknown user name/ user ID or missing comment / APPL entry
afpLockErr	-5013	
Some or all of requested range is locked by another user
afpMiscErr	-5014	
Unexpected error encountered during execution
afpNoMoreLocks	-5015	
No more ranges can be locked
afpNoServer	-5016	
Server is not responding
afpObjectExists	-5017	
Specified destination file or directory already exists
afpObjectNotFound	-5018	
Specified file or directory does not exist
afpParmErr	-5019	
A specified parameter was out of allowable range
afpRangeNotLocked	-5020	
Specified range was not locked
afpRangeOverlap	-5021	
Part of range is already locked
afpSessClosed	-5022	
Session closed
afpUserNotAuth	-5023	
User authentication failed (usually, password is not correct)
afpCallNotSupported	-5024	
Unsupported AFP call was made
afpObjectTypeErr	-5025	
A directory exists with that name

Directory not found

Folder locking not supported by volume

Object was a file, not a directory
afpTooManyFilesOpen	-5026	
Maximum open file coun reached
afpServerGoingDown	-5027	
Server is shutting down
afpCantRename	-5028	
AFPRename cannot rename volume
afpDirNotFound	-5029	
Unknown directory specified
afpIconTypeError	-5030	
Icon size specified is different from existing icon size
afpVolLocked	-5031	
Volume is read-only
afpObjectLocked	-5032	
Object is M/R/D/W inhibited
afpContainsSharedErr	-5033	
The directory contains a share point
afpIDNotFound	-5034	
File ID not found
afpIDExists	-5035	
File ID already exists
afpDiffVolErr	-5036	
afpCatalogChanged	-5037	
Catalog has changed and search cannot be resumed
afpSameObjectErr	-5038	
Source and destination files are the same
afpBadIDErr	-5039	
File ID not found
afpPwdSameErr	-5040	
Someone tried to change their password to the same password on a mandatory password change
afpPwdTooShortErr	-5041	
The password being set is too short: there is a minimum length that must be met or exceeded
afpPwdExpiredErr	-5042	
Password has expired on server
afpInsideSharedErr	-5043	
The directory is inside a shared directory
afpInsideTrashErr	-5044	
The folder being shared is inside the trash folder OR the shared folder is being moved into the trash folder
afpPwdNeedsChangeErr	-5045	
The password needs to be changed
afpPwdPolicyErr	-5046	
Password does not conform to server’s password policy
afpAlreadyLoggedInErr	-5047	
User has been authenticated but is already logged in from another machine (and that's not allowed on this server)
afpCallNotAllowed	-5048	
afpBadDirIDType	-5060	
Not a fixed directory ID volume
afpCantMountMoreSrvre	-5061	
Maximum number of volumes has been mounted
afpAlreadyMounted	-5062	
Volume already mounted
afpSameNodeErr	-5063	
Attempt to log on to a server running on the same machine*/
enum {
dirFulErr	=-33	,
dskFulErr	=-34	,
nsvErr	=-35	,
ioErr	=-36	,
bdNamErr=	-37	,
fnOpnErr	=-38	,
eofErr	=-39	,
posErr	=-40	,
mFulErr	=-41	,
tmfoErr	=-42	,
fnfErr	=-43	,
wPrErr	=-44	,
fLckdErr	=-45	,
vLckdErr	=-46	,
fBsyErr	=-47	,
dupFNErr	=-48	,
opWrErr	=-49	,
//paramErr	=-50	,
rfNumErr	=-51	,
gfpErr	=-52	,
volOffLinErr	=-53	,
permErr	=-54	,
volOnLinErr	=-55	,
nsDrvErr	=-56	,
noMacDskErr	=-57	,
extFSErr	=-58	,
fsRnErr	=-59	,
badMDBErr=	-60	,
wrPermErr=	-61	,
lastDskErr	=-64	,
noDriveErr=	-64	,
firstDskErr	=-84	,
dirNFErr	=-120,	
tmwdoErr	=-121,	
badMovErr=	-122	,
wrgVolTypErr=	-123	,
volGoneErr	=-124,	
fsDSIntErr	=-127	,
fsmFFSNotFoundErr	=-431	,
fsmBusyFFSErr	=-432	,
fsmBadFFSNameErr=	-433	,
fsmBadFSDLenErr	=-434	,
fsmDuplicateFSIDErr	=-435	,
fsmBadFSDVersionErr=	-436	,
fsmNoAlternateStackErr=	-437	,
fsmUnknownFSMMessageErr	=-438	,
driverHardwareGoneErr	=-503	,
fidNotFound	=-1300	,
fidExists	=-1301	,
notAFileErr	=-1302	,
diffVolErr	=-1303	,
catChangedErr=	-1304	,
sameFileErr	=-1306	,
badFidErr	=-1307	,
notARemountErr	=-1308	,
fileBoundsErr	=-1309	,
fsDataTooBigErr	=-1310	,
volVMBusyErr	=-1311	,
badFCBErr	=-1327	,
errFSUnknownCall	=-1400	,
errFSBadFSRef	=-1401	,
errFSBadForkName	=-1402	,
errFSBadBuffer	=-1403	,
errFSBadForkRef=	-1404	,
errFSBadInfoBitmap	=-1405	,
errFSMissingCatInfo	=-1406	,
errFSNotAFolder	=-1407	,
errFSForkNotFound	=-1409	,
errFSNameTooLong	=-1410	,
errFSMissingName	=-1411	,
errFSBadPosMode	=-1412	,
errFSBadAllocFlags	=-1413	,
errFSNoMoreItems	=-1417	,
errFSBadItemCount	=-1418	,
errFSBadSearchParams	=-1419	,
errFSRefsDifferent	=-1420	,
errFSForkExists	=-1421	,
errFSBadIteratorFlags	=-1422	,
errFSIteratorNotFound	=-1423	,
errFSIteratorNotSupported=	-1424	,
errFSQuotaExceeded	=-1425	,
afpAccessDenied	=-5000	,
afpAuthContinue	=-5001	,
afpBadUAM	=-5002	,
afpBadVersNum	=-5003	,
afpBitmapErr	=-5004	,
afpCantMove	=-5005	,
afpDenyConflict=	-5006	,
afpDirNotEmpty	=-5007	,
afpDiskFull	=-5008	,
afpEofError	=-5009	,
afpFileBusy	=-5010	,
afpFlatVol	=-5011	,
afpItemNotFound	=-5012	,
afpLockErr	=-5013	,
afpMiscErr	=-5014	,
afpNoMoreLocks=	-5015	,
afpNoServer	=-5016	,
afpObjectExists=	-5017,	
afpObjectNotFound	=-5018	,
afpParmErr	=-5019	,
afpRangeNotLocked	=-5020	,
afpRangeOverlap	=-5021	,
afpSessClosed	=-5022	,
afpUserNotAuth	=-5023	,
afpCallNotSupported	=-5024	,
afpObjectTypeErr	=-5025	,
afpTooManyFilesOpen=	-5026,	
afpServerGoingDown=	-5027,	
afpCantRename	=-5028	,
afpDirNotFound=	-5029	,
afpIconTypeError=	-5030	,
afpVolLocked	=-5031	,
afpObjectLocked	=-5032	,
afpContainsSharedErr=	-5033,	
afpIDNotFound	=-5034	,
afpIDExists	=-5035	,
afpDiffVolErr	=-5036	,
afpCatalogChanged=	-5037	,
afpSameObjectErr=	-5038	,
afpBadIDErr	=-5039	,
afpPwdSameErr	=-5040	,
afpPwdTooShortErr	=-5041	,
afpPwdExpiredErr	=-5042	,
afpInsideSharedErr	=-5043	,
afpInsideTrashErr	=-5044	,
afpPwdNeedsChangeErr=	-5045	,
afpPwdPolicyErr	=-5046	,
afpAlreadyLoggedInErr	=-5047	,
afpCallNotAllowed=	-5048	,
afpBadDirIDType=	-5060	,
afpCantMountMoreSrvre	=-5061	,
afpAlreadyMounted	=-5062	,
afpSameNodeErr	=-5063	
};





/* sound manager RESULT CODES
noErr	
0	
No error

notEnoughHardwareErr	
-201	
Insufficient hardware available

resProblem	
-204	
Problem loading the resource

badChannel	
-205	
Channel is corrupt or unusable

badFormat	
-206	
Resource is corrupt or unusable 

SEE ALSO*/

enum {
notEnoughHardwareErr	=-201	,
resProblem	=-204	,
badChannel	=-205	,
badFormat	=-206	
};
/*Window Manager Result Codes

The most common result codes returned by Window Manager are listed below.Result Code	Value	Description
noErr	0	
No error
paramErr	-50	
Invalid value passed in a parameter. Your application passed an invalid parameter for dialog options.
memFullErr	-108	
Not enough memory

Not enough room in heap zone.

Not enough memory to speak
resNotFound	-192	
Unable to read resource

Resource not found
errInvalidWindowPtr	-5600	
Invalid window pointer
errUnsupportedWindowAttributesForClass	-5601	
Attribute bits are inappropriate for the specified window class
errWindowDoesNotHaveProxy	-5602	
No proxy attached to window
errInvalidWindowProperty	-5603	
'appl' creator code not allowed
errWindowPropertyNotFound	-5604	
Specified property does not exist
errUnrecognizedWindowClass	-5605	
Unknown window class
errCorruptWindowDescription	-5606	
Incorrect size or version supplied in the BasicWindowDescription structure
errUserWantsToDragWindow	-5607	
Entire window is being dragged, not proxy icon
errWindowsAlreadyInitialized	-5608	
Called InitFloatingWindows twice, or called InitWindows and then InitFloatingWindows
errFloatingWindowsNotInitialized	-5609	
Called HideFloatingWindows or ShowFloatingWindows without calling InitFloatingWindows*/
enum {
paramErr=	-50	,
//memFullErr=	-108	,
resNotFound	=-192,	
errInvalidWindowPtr=	-5600	,
errUnsupportedWindowAttributesForClass=	-5601	,
errWindowDoesNotHaveProxy	=-5602	,
errInvalidWindowProperty	=-5603	,
errWindowPropertyNotFound	=-5604	,
errUnrecognizedWindowClass	=-5605	,
errCorruptWindowDescription	=-5606	,
errUserWantsToDragWindow	=-5607	,
errWindowsAlreadyInitialized	=-5608	,
errFloatingWindowsNotInitialized	=-5609	
};

/*OpenScripting Result Codes

The most common result codes returned by Open Scripting Architecture are listed in Table 1-1. Open Scripting Architecture may also return the result codes noErr (0), and badComponentInstance (-2147450879).Result Code	Value	Description
errOSACantCoerce	-1700	
A value can't be coerced to the desired type.
OSAMissingParameter	-1701	
A parameter is missing for a function invocation.
errOSACorruptData	-1702	
Some data could not be read.
errOSATypeError	-1703	
Same as errAEWrongDataType; wrong descriptor type.
OSAMessageNotUnderstood	-1708	
A message was sent to an object that didn't handle it.
OSAUndefinedHandler	-1717	
A function to be returned doesn't exist.
OSAIllegalIndex	-1719	
An index was out of range. Specialization of errOSACantAccess.
OSAIllegalRange	-1720	
The specified range is illegal. Specialization of errOSACantAccess.
OSAParameterMismatch	-1721	
The wrong number of parameters were passed to the function, or a parameter pattern cannot be matched.
OSAIllegalAccess	-1723	
A container can not have the requested object.
errOSACantAccess	-1728	
An object is not found in a container.
errOSARecordingIsAlreadyOn	-1732	
Recording is already on.

Available only in version 1.0.1 or greater.
errOSASystemError	-1750	
Scripting component error.
errOSAInvalidID	-1751	
Invalid script id.
errOSABadStorageType	-1752	
Script doesn’t seem to belong to AppleScript.
errOSAScriptError	-1753	
Script error.
errOSABadSelector	-1754	
Invalid selector given.
errOSASourceNotAvailable	-1756	
Invalid access.
errOSANoSuchDialect	-1757	
Source not available.
errOSADataFormatObsolete	-1758	
No such dialect.
errOSADataFormatTooNew	-1759	
Data couldn’t be read because its format is obsolete.
errOSAComponentMismatch	-1761	
Parameters are from two different components.
errOSACantOpenComponent	-1762	
Can't connect to system with that ID.
errOSAGeneralError	-2700	
No actual error code is to be returned.
errOSADivideByZero	-2701	
An attempt to divide by zero was made.
errOSANumericOverflow	-2702	
An integer or real value is too large to be represented.
errOSACantLaunch	-2703	
An application can't be launched, or when it is, remote and program linking is not enabled.
errOSAAppNotHighLevelEventAware	-2704	
An application can't respond to AppleEvents.
errOSACorruptTerminology	-2705	
An application's terminology resource is not readable.
errOSAStackOverflow	-2706	
The runtime stack overflowed.
errOSAInternalTableOverflow	-2707	
A runtime internal data structure overflowed.
errOSADataBlockTooLarge	-2708	
An intrinsic limitation is exceeded for the size of a value or data structure.
errOSACantGetTerminology	-2709	
Can’t get the event dictionary.
errOSACantCreate	-2710	
Can't make class <class identifier>.
OSASyntaxError	-2740	
A syntax error occured.
OSASyntaxTypeError	-2741	
Another form of syntax was expected.
OSATokenTooLong	-2742	
A name or number is too long to be parsed.
OSADuplicateParameter	-2750	
A formal parameter, local variable, or instance variable is specified more than once.
OSADuplicateProperty	-2751	
A formal parameter, local variable, or instance variable is specified more than once.
OSADuplicateHandler	-2752	
More than one handler is defined with the same name in a scope where the language doesn't allow it.
OSAUndefinedVariable	-2753	
A variable is accessed that has no value.
OSAInconsistentDeclarations	-2754	
A variable is declared inconsistently in the same scope, such as both local and global.
OSAControlFlowError	-2755	
An illegal control flow occurs in an application. For example, there is no catcher for the throw, or there was a non-lexical loop exit.
OSAIllegalAssign	-10003	
An object can never be set in a container
errOSACantAssign	-10006	
An object cannot be set in a container.*/
enum {
badComponentInstance  =-2147450879,
errOSACantCoerce	=-1700	,
OSAMissingParameter=	-1701,	
errOSACorruptData	=-1702	,
errOSATypeError	=-1703	,
OSAMessageNotUnderstood	=-1708,
OSAUndefinedHandler	= -1717	,
OSAIllegalIndex	=-1719	,
OSAIllegalRange	=-1720	,
OSAParameterMismatch	=-1721,	
OSAIllegalAccess	=-1723	,
errOSACantAccess	=-1728	,
errOSARecordingIsAlreadyOn	=-1732	,
errOSASystemError	=-1750	,
errOSAInvalidID	=-1751	,
errOSABadStorageType	=-1752	,
errOSAScriptError	=-1753	,
errOSABadSelector	=-1754	,
errOSASourceNotAvailable	=-1756	,
errOSANoSuchDialect	=-1757	,
errOSADataFormatObsolete=	-1758,	
errOSADataFormatTooNew=	-1759,	
errOSAComponentMismatch=	-1761,	
errOSACantOpenComponent=	-1762,	
errOSAGeneralError	=-2700	,
errOSADivideByZero=	-2701,	
errOSANumericOverflow	=-2702,	
errOSACantLaunch	=-2703	,
errOSAAppNotHighLevelEventAware=	-2704	,
errOSACorruptTerminology=	-2705	,
errOSAStackOverflow	=-2706	,
errOSAInternalTableOverflow	=-2707	,
errOSADataBlockTooLarge=	-2708	,
errOSACantGetTerminology=	-2709	,
errOSACantCreate	=-2710	,
OSASyntaxError	=-2740	,
OSASyntaxTypeError=	-2741,	
OSATokenTooLong	=-2742	,
OSADuplicateParameter=	-2750,	
OSADuplicateProperty=	-2751,
OSADuplicateHandler=	-2752,	
OSAUndefinedVariable=	-2753,	
OSAInconsistentDeclarations=	-2754	,
OSAControlFlowError=	-2755	,
OSAIllegalAssign	=-10003,
errOSACantAssign	=-10006
};

/*Return Value,

A result code. See “Window Manager Result Codes”. If you receive the error errUserWantsToDragWindow (–5607), your application should respond by calling the Window Manager function DragWindow. Errors are also returned from the Drag Manager, including userCanceledErr (–128).*/
enum {
 userCanceledErr  = -128

};
/*CarbonCore header file MacErrors.h.

For result codes for the AEBuild-related functions, see ??AEBuild Error Codes??.Result Code	Value	Description
noPortErr	-903	
Client hasn??t set 'SIZE' resource to indicate awareness of high-level events
destPortErr	-906	
Server hasn??t set 'SIZE' resource to indicate awareness of high-level events, or else is not present
sessClosedErr	-917	
The kAEDontReconnect flag in the sendMode parameter was set and the server quit, then restarted
errAECoercionFail	-1700	
Data could not be coerced to the requested descriptor type
errAEDescNotFound	-1701	
Descriptor was not found
errAECorruptData	-1702	
Data in an Apple event could not be read
errAEWrongDataType	-1703	
Wrong descriptor type
errAENotAEDesc	-1704	
Not a valid descriptor
errAEBadListItem	-1705	
Operation involving a list item failed
errAENewerVersion	-1706	
Need a newer version of the Apple Event Manager
errAENotAppleEvent	-1707	
The event is not in AppleEvent format.
errAEEventNotHandled	-1708	
Event wasn??t handled by an Apple event handler
errAEReplyNotValid	-1709	
AEResetTimer was passed an invalid repl
errAEUnknownSendMode	-1710	
Invalid sending mode was passed
errAEWaitCanceled	-1711	
User canceled out of wait loop for reply or receipt
errAETimeout	-1712	
Apple event timed out
errAENoUserInteraction	-1713	
No user interaction allowed
errAENotASpecialFunction	-1714	
Wrong keyword for a special function
errAEParamMissed	-1715	
A required parameter was not accessed.
errAEUnknownAddressType	-1716	
Unknown Apple event address type
errAEHandlerNotFound	-1717	
No handler found for an Apple event
errAEReplyNotArrived	-1718	
Reply has not yet arrived
errAEIllegalIndex	-1719	
Not a valid list index
errAEImpossibleRange	-1720	
The range is not valid because it is impossible for a range to include the first and last objects that were specified; an example is a range in which the offset of the first object is greater than the offset of the last object
errAEWrongNumberArgs	-1721	
The number of operands provided for the kAENOT logical operator is not 1
errAEAccessorNotFound	-1723	
There is no object accessor function for the specified object class and container type
errAENoSuchLogical	-1725	
The logical operator in a logical descriptor is not kAEAND, kAEOR, or kAENOT
errAEBadTestKey	-1726	
The descriptor in a test key is neither a comparison descriptor nor a logical descriptor
errAENotAnObjectSpec	??1727	
The objSpecifier parameter of AEResolve is not an object specifier
errAENoSuchObject	-1728	
Runtime resolution of an object failed.
errAENegativeCount	-1729	
An object-counting function returned a negative result
errAEEmptyListContainer	-1730	
The container for an Apple event object is specified by an empty list
errAEUnknownObjectType	-1731	
The object type isn??t recognized
errAERecordingIsAlreadyOn	-1732	
Recording is already on
errAEReceiveTerminate	-1733	
Break out of all levels of AEReceive to the topmost (1.1 or greater)
errAEReceiveEscapeCurrent	-1734	
Break out of lowest level only of AEReceive (1.1 or greater)
errAEEventFiltered	-1735	
Event has been filtered and should not be propagated (1.1 or greater)
errAEDuplicateHandler	-1736	
Attempt to install handler in table for identical class and ID (1.1 or greater)
errAEStreamBadNesting	-1737	
Nesting violation while streaming
errAEStreamAlreadyConverted	-1738	
Attempt to convert a stream that has already been converted
errAEDescIsNull	-1739	
Attempt to perform an invalid operation on a null descriptor
errAEBuildSyntaxError	-1740	
AEBuildDesc and related functions detected a syntax error
errAEBufferTooSmall	-1741	
Buffer for AEFlattenDesc too small
errASCantConsiderAndIgnore	-2720	
Can??t both consider and ignore <attribute>.
errASCantCompareMoreThan32k	-2721	
Can??t perform operation on text longer than 32K bytes.
errASTerminologyNestingTooDeep	-2760	
Tell statements are nested too deeply.
errASIllegalFormalParameter	-2761	
<name> is illegal as a formal parameter.
errASParameterNotForEvent	-2762	
<name> is not a parameter name for the event <event>.
errASNoResultReturned	-2763	
No result was returned for some argument of this expression. 
errAEEventFailed	-10000	
Apple event handler failed.
errAETypeError	-10001	
A descriptor type mismatch occurred.
errAEBadKeyForm	-10002	
Invalid key form.
errAENotModifiable	-10003	
Can't set <object or data> to <object or data>. Access not allowed.
errAEPrivilegeError	-10004	
A privilege violation occurred.
errAEReadDenied	-10005	
The read operation was not allowed.
errAEWriteDenied	-10006	
Can't set <object or data> to <object or data>. 
errAEIndexTooLarge	-10007	
The index of the event is too large to be valid.
errAENotAnElement	-10008	
The specified object is a property, not an element.
errAECantSupplyType	-10009	
Can??t supply the requested descriptor type for the data.
errAECantHandleClass	-10010	
The Apple event handler can??t handle objects of this class.
errAEInTransaction	-10011	
Couldn??t handle this command because it wasn??t part of the current transaction.
errAENoSuchTransaction	-10012	
The transaction to which this command belonged isn??t a valid transaction.
errAENoUserSelection	-10013	
There is no user selection.
errAENotASingleObject	-10014	
Handler only handles single objects.
errAECantUndo	-10015	
Can??t undo the previous Apple event or user action.
errAENotAnEnumMember	-10023	
Enumerated value in SetData is not allowed for this property
errAECantPutThatThere	-10024	
In make new, duplicate, etc. class can't be an element of container
errAEPropertiesClash	-10025	
Illegal combination of properties settings for SetData, make new, or duplicate
MacErrors.h*/
enum{
noPortErr	 = -903,
destPortErr=-906,
sessClosedErr=-917,
errAECoercionFail=	-1700,
errAEDescNotFound	=-1701	,
errAECorruptData	=-1702	,
errAEWrongDataType=	-1703,	
errAENotAEDesc	=-1704	,
errAEBadListItem	=-1705	,
errAENewerVersion	=-1706	,
errAENotAppleEvent	=-1707	,
errAEEventNotHandled	=-1708,	
errAEReplyNotValid	=-1709	,
errAEUnknownSendMode=	-1710,	
errAEWaitCanceled	=-1711	,
errAETimeout	=-1712	,
errAENoUserInteraction	=-1713	,
errAENotASpecialFunction=	-1714,	
errAEParamMissed	=-1715	,
errAEUnknownAddressType=	-1716	,
errAEHandlerNotFound=	-1717	,
errAEReplyNotArrived=	-1718	,
errAEIllegalIndex	       =-1719,
errAEImpossibleRange=	-1720,	
errAEWrongNumberArgs	=-1721,
errAEAccessorNotFound	=-1723,
errAENoSuchLogical	=-1725     ,
errAEBadTestKey             =-1726   ,
errAENotAnObjectSpec    =  -1727  ,
errAENoSuchObject         = -1728	,
errAENegativeCount	=-1729	,
errAEEmptyListContainer=	-1730,	
errAEUnknownObjectType=	-1731	,
errAERecordingIsAlreadyOn=	-1732	,
errAEReceiveTerminate	=-1733	,
errAEReceiveEscapeCurrent=	-1734,	
errAEEventFiltered	=-1735	,
errAEDuplicateHandler=	-1736,	
errAEStreamBadNesting	=-1737	,
errAEStreamAlreadyConverted	=-1738,	
errAEDescIsNull	=-1739	,
errAEBuildSyntaxError=	-1740,	
errAEBufferTooSmall	=-1741	,
errASCantConsiderAndIgnore=	-2720,	
errASCantCompareMoreThan32k=	-2721	,
errASTerminologyNestingTooDeep=	-2760	,
errASIllegalFormalParameter	=-2761	,
errASParameterNotForEvent	=-2762	,
errASNoResultReturned	=-2763	,
errAEEventFailed	=-10000	,
errAETypeError	=-10001	,
errAEBadKeyForm	=-10002	,
errAENotModifiable	=-10003	,
errAEPrivilegeError	=-10004	,
errAEReadDenied	=-10005	,
errAEWriteDenied	=-10006	,
errAEIndexTooLarge=	-10007,	
errAENotAnElement	=-10008	,
errAECantSupplyType=	-10009	,
errAECantHandleClass=	-10010	,
errAEInTransaction	=-10011	,
errAENoSuchTransaction=	-10012	,
errAENoUserSelection=	-10013	,
errAENotASingleObject=	-10014	,
errAECantUndo	=-10015	,
errAENotAnEnumMember	=-10023	,
errAECantPutThatThere	=-10024	,
errAEPropertiesClash	=-10025	
};

/*PPC Result Codes
 noErr	0	No error
paramErr	-50	Illegal parameter
memFullErr	-108	Not enough memory to load PPCBrowser package
userCanceledErr	-128	User decided not to conduct a session
notInitErr	-900	PPC Toolbox has not been initialized yet
nameTypeErr	-902	Invalid or inappropriate locationKindSelector in location name
noPortErr	-903	Unable to open port or bad port reference number
noGlobalsErr	-904	System unable to allocate memory, critical error
localOnlyErr	-905	Network activity is currently disabled
destPortErr	-906	Port does not exist at destination
sessTableErr	-907	PPC Toolbox is unable to create a session
noSessionErr	-908	Invalid session reference number
badReqErr	-909	Bad parameter or invalid state for this operation
portNameExistsErr	-910	Another port is already open with this name
noUserNameErr	-911	User name unknown on destination machine
userRejectErr	-912	Destination rejected the session request
noResponseErr	-915	Unable to contact application
portClosedErr	-916	The port was closed
sessClosedErr	-917	The session has closed
badPortNameErr	-919	PPC port record is invalid
noDefaultUserErr	-922	User has not specified owner name in Sharing Setup control panel
notLoggedInErr	-923	Default user reference number does not yet exist
noUserRefErr	-924	Unable to create a new user reference number
networkErr	-925	An error has occurred in the network
noInformErr	-926	PPCStart failed because target application did not have an inform pending
authFailErr	-927	User's password is wrong
noUserRecErr	-928	Invalid user reference number
badServiceMethodErr	-930	Service method is other than ppcServiceRealTime
badLocNameErr	-931	Location name is invalid
guestNotAllowedErr	-932	Destination port requires authentication
nbpDuplicate	-1027	Location name represents a duplicate on this computer
*/
enum {
// noErr=	0	,//No error
//paramErr=	-50	,//Illegal parameter
//memFullErr	=-108,	//Not enough memory to load PPCBrowser package
//userCanceledErr=	-128	,//User decided not to conduct a session
notInitErr	=-900,	//PPC Toolbox has not been initialized yet
nameTypeErr	=-902,//	Invalid or inappropriate locationKindSelector in location name
//noPortErr	=-903,	//Unable to open port or bad port reference number
noGlobalsErr	=-904,	//System unable to allocate memory, critical error
localOnlyErr=	-905	,//Network activity is currently disabled
//destPortErr	=-906	,//Port does not exist at destination
sessTableErr	=-907	,//PPC Toolbox is unable to create a session
//noSessionErr	=-908	,//Invalid session reference number
badReqErr	=-909,//	Bad parameter or invalid state for this operation
portNameExistsErr	=-910,//	Another port is already open with this name
noUserNameErr	=-911,//	User name unknown on destination machine
userRejectErr	=-912	,//Destination rejected the session request
noResponseErr	=-915,//	Unable to contact application
portClosedErr	=-916,	//The port was closed
//sessClosedErr=	-917,//	The session has closed
badPortNameErr=	-919,//	PPC port record is invalid
noDefaultUserErr=	-922,//	User has not specified owner name in Sharing Setup control panel
notLoggedInErr	=-923,	//Default user reference number does not yet exist
noUserRefErr=	-924	,//Unable to create a new user reference number
networkErr	=-925,	//An error has occurred in the network
noInformErr	=-926,	//PPCStart failed because target application did not have an inform pending
authFailErr	=-927,//	User's password is wrong
noUserRecErr=	-928,	//Invalid user reference number
badServiceMethodErr	=-930,	//Service method is other than ppcServiceRealTime
badLocNameErr	=-931,//	Location name is invalid
guestNotAllowedErr	=-932	,//Destination port requires authentication
nbpDuplicate=	-1027,	//Location name represents a duplicate on this computer
};

/*Menu Manager  Result Codes

The most common result codes returned by Menu Manager are listed below.
Result Code	Value	Description
noErr	0	
No error
paramErr	-50	
Invalid value passed in a parameter. 
memFullErr	-108	
Not enough memory

Not enough memory to speak
resNotFound	-192	
Unable to read resource

Resource not found
hmHelpManagerNotInited	-855	
Help Manager not set up 
menuPropertyInvalidErr	-5603	
You specified an Apple-reserved creator type in a menu property function. 
menuPropertyNotFoundErr	-5604	
The specified property creator/ID combination was not found.
menuNotFoundErr	-5620	
The specified menu or menu ID wasn't found
menuUsesSystemDefErr	-5621	
GetMenuDefinition failed because the menu uses the system menu definition.
menuItemNotFoundErr	-5622	
The specified menu item wasn't found
menuInvalidErr	-5623	
The menu reference passed to the function was invalid.*/
enum {
//noErr=	0	,
//No error
//paramErr	=-50	,
//Invalid value passed in a parameter. 
//memFullErr	=-108	,
//Not enough memory

//ot enough memory to speak
//resNotFound	=-192	,
//Unable to read resource

//Resource not found
hmHelpManagerNotInited	=-855	,
//Help Manager not set up 
menuPropertyInvalidErr	=-5603	,
//You specified an Apple-reserved creator type in a menu property function. 
menuPropertyNotFoundErr	=-5604	,
//The specified property creator/ID combination was not found.
menuNotFoundErr	=-5620	,
//The specified menu or menu ID wasn't found
menuUsesSystemDefErr	=-5621	,
//GetMenuDefinition failed because the menu uses the system menu definition.
menuItemNotFoundErr=	-5622	,
//The specified menu item wasn't found
menuInvalidErr=	-5623	,
};

/*Apple Type Services for Unicode Imaging  Result Codes

The most common result codes returned by Apple Type Services for Unicode Imaging are listed below.
Result Code	Value	Description
kATSUInvalidTextLayoutErr	-8790	
The ATSUI text layout object is not initialized or is in an otherwise invalid state.

Available beginning with ATSUI 1.0.
kATSUInvalidStyleErr	-8791	
The ATSUI style object is not initialized or in an otherwise invalid state.

Available beginning with ATSUI 1.0.
kATSUInvalidTextRangeErr	-8792	
The text range extends beyond the limits of the text layout object’s text range.

Available beginning with ATSUI 1.0.
kATSUFontsMatched	-8793	
One or more characters cannot be rendered with the assigned font, but can be rendered with a substitute font from among those currently active.

Available beginning with ATSUI 1.0. 
kATSUFontsNotMatched	-8794	
One or more characters can neither be rendered with the assigned font nor with any other currently active font.

Available beginning with ATSUI 1.0.
kATSUNoCorrespondingFontErr	-8795	
The font ID corresponds to an existing font that isn’t available to ATSUI.

Available beginning with ATSUI 1.0.
kATSUInvalidFontErr	-8796	
The font ID does not correspond to any installed font or ATSUI is unable to obtain the font data (as in the case of a protected font).

Available beginning with ATSUI 1.0.
kATSUInvalidAttributeValueErr	-8797	
The attribute value is invalid or undefined.

Available beginning with ATSIU 1.0.
kATSUInvalidAttributeSizeErr	-8798	
The allocated attribute value size is less than required.

Available beginning with ATSUI 1.0.
kATSUInvalidAttributeTagErr	-8799	
The tag is an ATSUI-reserved value or the wrong type of attribute tag (that is, a style run attribute tag instead of text layout attribute tag and vice versa).

Available beginning with ATSUI 1.0.
kATSUInvalidCacheErr	-8800	
Indicates an attempt to read style data from an invalid cache (that is, the format of the cached data does not match that used by ATSUI or the cached data is corrupt).

Available beginning with ATSUI 1.0.
kATSUNotSetErr	-8801	
The ATSUI style object’s attribute, font feature, font variation is not set; the ATSUI text layout object or single line’s attribute is not set; or a font name is not set.

Available beginning with ATSUI 1.0.
kATSUNoStyleRunsAssignedErr	-8802	
No style runs are assigned to the ATSUI text layout object.

Available beginning with ATSUI 1.1.
kATSUQuickDrawTextErr	-8803	
The QuickDraw function DrawText encountered an error rendering or measuring a line of text.

Available beginning with ATSUI 1.1.
kATSULowLevelErr	-8804	
Apple Type Services (ATS) encountered an error while performing an operation requested by ATSUI.

Available beginning with ATSUI 1.1.
kATSUNoFontCmapAvailableErr	-8805	
The 'CMAP' table cannot be accessed or synthesized for a font.

Available beginning with ATSUI 1.1.
kATSUNoFontScalerAvailableErr	-8806	
There is no font scaler available for a font.

Available beginning with ATSUI 1.1.
kATSUCoordinateOverflowErr	-8807	
The coordinate values passed to the function caused a coordinate overflow (greater than 32 KB).

Available beginning with ATSUI 1.1.
kATSULineBreakInWord	-8808	
The function ATSUBreakLine performed a line break within a word.

Available beginning with ATSUI 1.2.
kATSUBusyObjectErr	-8809	
An ATSUI object is being used by another thread.
kATSUInvalidFontFallbacksErr	-8900	
The ATSUFontFallback object is not initialized or is otherwise in an in valid state.
kATSUUnsupportedStreamFormatErr	-8901	
The data-flattening format is invalid or is not supported by this version of ATSUI.
kATSUBadStreamErr	-8902	
The data is not formatted as specified by the data-flattening format constant, or the data is corrupt.
kATSUOutputBufferTooSmallErr	-8903	
The output buffer is too small to contain the data output by the function.
kATSUInvalidCallInsideCallbackErr	-8904	
Your callback is making a call that could cause an infinite recursion.
kATSULastErr	-8959	
No ATSUI-related result codes may exceed this value. Result code values between kATSUInvalidTextLayoutErr and kATSULastErr are reserved.

Available beginning with ATSUI 1.0.*/
enum {
kATSUInvalidTextLayoutErr=	-8790	,
//The ATSUI text layout object is not initialized or is in an otherwise invalid state,

//Available beginning with ATSUI 1,0,
kATSUInvalidStyleErr =-8791	,
//The ATSUI style object is not initialized or in an otherwise invalid state,

//Available beginning with ATSUI 1,0,
kATSUInvalidTextRangeErr=	-8792	,
//The text range extends beyond the limits of the text layout object’s text range,

//Available beginning with ATSUI 1,0,
kATSUFontsMatched	=-8793	,
//One or more characters cannot be rendered with the assigned font, but can be rendered with a substitute font from among those currently active,

//Available beginning with ATSUI 1,0, 
kATSUFontsNotMatched	=-8794	,
//One or more characters can neither be rendered with the assigned font nor with any other currently active font,

//Available beginning with ATSUI 1,0,
kATSUNoCorrespondingFontErr	=-8795	,
//The font ID corresponds to an existing font that isn’t available to ATSUI,

//Available beginning with ATSUI 1,0,
kATSUInvalidFontErr	=-8796	,
//The font ID does not correspond to any installed font or ATSUI is unable to obtain the font data (as in the case of a protected font),

//Available beginning with ATSUI 1,0,
kATSUInvalidAttributeValueErr	=-8797	,
//The attribute value is invalid or undefined,

//Available beginning with ATSIU 1,0,
kATSUInvalidAttributeSizeErr	=-8798,	
//The allocated attribute value size is less than required,

//Available beginning with ATSUI 1,0,
kATSUInvalidAttributeTagErr=	-8799	,
//The tag is an ATSUI-reserved value or the wrong type of attribute tag (that is, a style run attribute tag instead of text layout attribute tag and vice versa),

//,,Available beginning with ATSUI 1,0,
kATSUInvalidCacheErr=	-8800	,
//Indicates an attempt to read style data from an invalid cache (that is, the format of the cached data does not match that used by ATSUI or the cached data is corrupt),

//Available beginning with ATSUI 1,0,
kATSUNotSetErr	=-8801	,
//The ATSUI style object’s attribute, font feature, font variation is not set; the ATSUI text layout object or single line’s attribute is not set; or a font name is not set,

//Available beginning with ATSUI 1,0,
kATSUNoStyleRunsAssignedErr	=-8802	,
//No style runs are assigned to the ATSUI text layout object,

//Available beginning with ATSUI 1,1,
kATSUQuickDrawTextErr=	-8803	,
//The QuickDraw function DrawText encountered an error rendering or measuring a line of text,

//Available beginning with ATSUI 1,1,
kATSULowLevelErr=	-8804	,
//Apple Type Services (ATS) encountered an error while performing an operation requested by ATSUI,

//Available beginning with ATSUI 1,1,
kATSUNoFontCmapAvailableErr=	-8805	,
//The 'CMAP' table cannot be accessed or synthesized for a font,

//Available beginning with ATSUI 1,1,
kATSUNoFontScalerAvailableErr=	-8806	,
//There is no font scaler available for a font,

//Available beginning with ATSUI 1,1,
kATSUCoordinateOverflowErr=	-8807	,
//The coordinate values passed to the function caused a coordinate overflow (greater than 32 KB),

//Available beginning with ATSUI 1,1,
kATSULineBreakInWord=	-8808	,
//The function ATSUBreakLine performed a line break within a word,

//Available beginning with ATSUI 1,2,
kATSUBusyObjectErr	=-8809	,
//An ATSUI object is being used by another thread,
kATSUInvalidFontFallbacksErr=	-8900	,
//The ATSUFontFallback object is not initialized or is otherwise in an in valid state,
kATSUUnsupportedStreamFormatErr	=-8901,
//The data-flattening format is invalid or is not supported by this version of ATSUI,
kATSUBadStreamErr=	-8902	,
//The data is not formatted as specified by the data-flattening format constant, or the data is corrupt,
kATSUOutputBufferTooSmallErr=	-8903	,
//The output buffer is too small to contain the data output by the function,
kATSUInvalidCallInsideCallbackErr	=-8904	,
//Your callback is making a call that could cause an infinite recursion,
kATSULastErr	=-8959	,
//No ATSUI-related result codes may exceed this value, Result code values between kATSUInvalidTextLayoutErr and kATSULastErr are reserved,
};

#include <APPLE/CarbonCore/MacErrors_E.h>

#ifdef __cplusplus
}
#endif

#endif