#ifndef CGFUNCTION_H
#define CGFUNCTION_H

#include <CoreGraphics/CGBase.h>
#include <CoreFoundation/CFBase.h>
//#include <HYS/CoreGraphics/CGFunction.h>
#include <APPLE/CoreGraphics/CGFunction.h>

/*CGFunctionEvaluateCallback

Defines a CGFunction evaluator callback type.

typedef void (*CGFunctionEvaluateCallback) (
   void *info,
   const float *inData,
   float *outData
);
   

If you name your function MyCGFunctionEvaluate, you would declare it like this:

void MyCGFunctionEvaluate (
   void *info,
   const float *inData,
   float *outData
);
Parameters
info

The info parameter passed to CGFunctionCreate.
inData

An array of floats. The size of the array is that specified by the domainDimension parameter passed to the CGFunctionCreate function.
outData

An array of floats. The size of the array is that specified by the rangeDimension parameter passed to the CGFunctionCreate function.
Discussion

The callback you supply is responsible for implementing the calculation of output values from the supplied input values. For example, if you want to implement a simple "squaring" function of one input argument to one output argument, your evaluation function might be:void evaluateSquare(void *info, const float *inData, float *outData)
{
    outData[0] = inData[0] * inData[0];
}*/
typedef void (*CGFunctionEvaluateCallback) (
   void *info,
   const float *inData,
   float *outData
);


/*CGFunctionCallbacks

Defines a structured type for a table of function pointers to CGFunction callbacks.

struct CGFunctionCallbacks
   {
   unsigned int version;
   CGFunctionEvaluateCallback evaluate;
   CGFunctionReleaseInfoCallback releaseInfo
};

typedef struct CGFunctionCallbacks CGFunctionCallbacks;
Fields
version

The structure version number. For this structure, the version should be 0.
evaluate

The callback that evaluates the function.
releaseInfo

If non-NULL, the callback used to release the info parameter passed to CGFunctionCreate.
Availability
Available in Mac OS X v10.2 and later.*/
struct CGFunctionCallbacks
   {
   unsigned int version;
   CGFunctionEvaluateCallback evaluate;
   CGFunctionReleaseInfoCallback releaseInfo;
};

typedef struct CGFunctionCallbacks CGFunctionCallbacks;

/*CGFunctionRef

Defines an opaque type that represents a callback function.

typedef struct CGFunction *CGFunctionRef;
Discussion

CGFunction provides a general facility for defining and using callback functions that take an arbitrary number of floating-point input values, and pass back an arbitrary number of floating-point output values.

If a Quartz function requires a callback of this type, the API reference for that function describes the callback's parameters and semantics.

In Mac OS X version 10.2 and later, CGFunctionRef is derived from CFTypeRef and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X version 10.2 and later.*/
typedef struct CGFunction *CGFunctionRef;

//function

/*CGFunctionCreate

Creates a Quartz function.

CGFunctionRef CGFunctionCreate (
   void *info,
   size_t domainDimension,
   const float *domain,
   size_t rangeDimension,
   const float *range,
   const CGFunctionCallbacks *callbacks
);
Parameters
info

A pointer to user-defined storage for data that you want to pass to your callbacks. You need to make sure that the data persists for as long as it’s needed, which can be beyond the scope in which the Quartz function is used. 
domainDimension

The number of inputs.
domain

An array of (2*domainDimension) floats used to specify the valid intervals of input values. For each k from 0 to (domainDimension - 1), domain[2*k] must be less than or equal to domain[2*k+1], and the kth input value will be clipped to lie in the interval domain[2*k] ≤ input[k] ≤ domain[2*k+1]. If this parameter is NULL, then the input values are not clipped.
rangeDimension

The number of outputs.
range

An array of (2*rangeDimension) floats that specifies the valid intervals of output values. For each k from 0 to (rangeDimension - 1), range[2*k] must be less than or equal to range[2*k+1], and the kth output value will be clipped to lie in the interval range[2*k] ≤ output[k] ≤ range[2*k+1]. If this parameter is NULL, then the output values are not clipped.
callbacks

A pointer to a callback function table. This table should contain pointers to the callbacks you provide to implement the semantics of this Quartz function. Quartz makes a copy of your table, so, for example, you could safely pass in a pointer to a structure on the stack.
Return Value

The new Quartz function. You are responsible for releasing this object using CGFunctionRelease.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGFunction.h*/

CGFunctionRef CGFunctionCreate (
   void *info,
   size_t domainDimension,
   const float *domain,
   size_t rangeDimension,
   const float *range,
   const CGFunctionCallbacks *callbacks
);

/*CGFunctionRelease

Decrements the retain count of a Quartz function.

void CGFunctionRelease (
   CGFunctionRef function
);
Parameters
function

The Quartz function to release.
Discussion

This function is equivalent to CFRelease, except that it does not cause an error if the function parameter is NULL.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGFunction.h*/
void CGFunctionRelease (
   CGFunctionRef function
);

#endif