#ifndef DIRSERVICESTYPES_H
#define	DIRSERVICESTYPES_H

//#include <HYS/DirectoryService/DirServicesTypes.h>
#include <APPLE/DirectoryService/DirServicesTypes.h>
#ifdef __cplusplus
extern "C" {
#endif

/*tAttributeValueListRef

A reference used to get attribute value entries.

typedef unsigned long tAttributeValueListRef;
Discussion

You receive a tAttributeValueListRef when you call dsGetAttributeEntry. Pass the reference to dsGetAttributeValue. Dispose of the reference by calling dsCloseAttributeValueList.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef unsigned long tAttributeValueListRef;

/*tAttributeListRef

A reference used to get attribute entries.

typedef unsigned long tAttributeListRef;
Discussion

You receive a tAttributeListRef by calling dsGetDirNodeInfo or dsGetRecordEntry.Pass the reference to dsGetAttributeEntry. Dispose of the reference by calling dsCloseAttributeList.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef unsigned long tAttributeListRef;

/*tDirNodeReference

A value returned when a node is opened.

typedef unsigned long tDirNodeReference;
Discussion

Open Directory functions that operate on nodes, records, and attributes require a tDirNodeReference as a parameter. Call dsOpenDirNode to open a node. Call dsCloseDirNode to close the node and dispose of the reference when you no longer need it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef unsigned long tDirNodeReference;

/*tContextData

A pointer to an arbitrary value used to exchange continuation data.

typedef void * tContextData;
Discussion

When the results of calling an Open Directory function exceed the size of the response buffer, the function returns a value of type tContextData. Your application can get the next buffer of results by calling the function again and passing the continuation data as a parameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef void * tContextData;

/*Pattern Matching Constants

Constants defined for pattern matching.

typedef enum {
eDSNoMatch1 = 0x0000,
eDSAnyMatch = 0x0001,
eDSBeginAppleReserve1 = 0x0002,
eDSEndAppleReserve1 = 0x1fff,
eDSExact = 0x2001,
eDSStartsWith = 0x2002,
eDSEndsWith = 0x2003,
eDSContains = 0x2004,
eDSLessThan = 0x2005,
eDSGreaterThan = 0x2006,
eDSLessEqual = 0x2007,
eDSGreaterEqual = 0x2008,
eDSWildCardPattern = 0x2009,
eDSRegularExpression = 0x200A,
eDSCompoundExpression = 0x200B,
eDSiExact = 0x2101,
eDSiStartsWith = 0x2102,
eDSiEndsWith = 0x2103,
eDSiContains = 0x2104,
eDSiLessThan = 0x2105,
eDSiGreaterThan = 0x2106,
eDSiLessEqual = 0x2107,
eDSiGreaterEqual = 0x2108,
eDSiWildCardPattern x x2109,
eDSiRegularExpression = 0x210A,
eDSiCompoundExpression = 0x210B,
eDSLocalNodeNames = x2200,
eDSSearchNodeName = x2201,
eDSConfigNodeName = 0x2202,
eDSLocalHostedNodes = 0x2203,
eDSAuthenticationSearchNodeName = 0x2201,
eDSContactsSearchNodeName = 0x2204,
eDSNetworkSearchNodeName = 0x2205,
eDSDefaultNetworkNodes = 0x2206,
dDSBeginPlugInCustom = 0x3000,
eDSEndPlugInCustom = 0x4fff,
eDSBeginAppleReserve2 = 0x5000,
eDSEndAppleReserve2 = 0xfffe,
eDSNoMatch2 = 0xffff
} tDirPatternMatch;
Constants
eDSNoMatch1

Reserved.

Available in Mac OS X v10.0 and later.
eDSAnyMatch

Matches any value.

Available in Mac OS X v10.0 and later.
eDSBeginAppleReserve1

Beginning of a range of values reserved for use by Apple Computer.

Available in Mac OS X v10.0 and later.
eDSEndAppleReserve1

End of a range of values reserved for use by Apple Computer.

Available in Mac OS X v10.0 and later.
eDSExact

Matches the specified value exactly (case sensitive).

Available in Mac OS X v10.0 and later.
eDSStartsWith

Matches values that start with the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSEndsWith

Matches values that end with the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSContains

Matches values that contain the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSLessThan

Matches values that are less than the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSGreaterThan

Matches values that are greater than the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSLessEqual

Matches values that are less than or equal to the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSGreaterEqual

Matches values that are greater than or equal to the specified value (case sensitive).

Available in Mac OS X v10.0 and later.
eDSWildCardPattern

Matches values using the specified wild card pattern (case sensitive).

Available in Mac OS X v10.0 and later.
eDSRegularExpression

Matches values using the specified regular expression (case sensitive).

Available in Mac OS X v10.0 and later.
eDSCompoundExpression

Accommodates an attribute search based on a pre-built compound expression.

Available in Mac OS X v10.2 and later.
eDSiExact

Matches the specified value exactly (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiStartsWith

Matches values that start with the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiEndsWith

Matches values that end with the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiContains

Matches values that contain the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiLessThan

Matches values that are less than the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiGreaterThan

Matches values that are greater than the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiLessEqual

Matches values that are less than or equal to the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiGreaterEqual

Matches values that are greater than or equal to the specified value (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiWildCardPattern

Matches values using the specified wild card pattern (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiRegularExpression

Matches values using the specified regular expression (case insensitive).

Available in Mac OS X v10.0 and later.
eDSiCompoundExpression

Accommodates an attribute search based on a pre-built compound expression (case insensitive).

Available in Mac OS X v10.2 and later.
eDSLocalNodeNames

Matches the local node name.

Available in Mac OS X v10.0 and later.
eDSSearchNodeName

Matches the node name that is to be used to authenticate the Open Directory client.

Available in Mac OS X v10.0 and later.
eDSConfigNodeName

Matches the configuration node. Used primarily by the Directory Access application for configuration purposes; not intended for use by developers.

Available in Mac OS X v10.0 and later.
eDSLocalHostedNodes

Matches NetInfo domains stored on this machine.

Available in Mac OS X v10.0 and later.
eDSAuthenticationSearchNodeName

Matches the node name that is to be used to authenticate an Open Directory client. (This is another name for eDSSearchNodeName.)

Available in Mac OS X v10.0 and later.
eDSContactsSearchNodeName

Matches the node name that is to be used for searching when authentication is not required; used by Address Book and Mail applications.

Available in Mac OS X v10.0 and later.
eDSNetworkSearchNodeName

Searches across all the nodes returned by eDSDefaultNetworkNodes.

Available in Mac OS X v10.2 and later.
eDSDefaultNetworkNodes

Matches the default network node.

Available in Mac OS X v10.2 and later.
dDSBeginPlugInCustom

Beginning of a range of values reserved for use by Open Directory plug-ins.

Available in Mac OS X v10.0 and later.
eDSEndPlugInCustom

End of a range of values reserved for use by Open Directory plug-ins.

Available in Mac OS X v10.0 and later.
eDSBeginAppleReserve2

Beginning of a range of values reserved for use by Apple Computer.

Available in Mac OS X v10.0 and later.
eDSEndAppleReserve2

End of a range of values reserved for use by Apple Computer.

Available in Mac OS X v10.0 and later.
eDSNoMatch2

Reserved.

Available in Mac OS X v10.0 and later.
Discussion

The tDirPatternMatch enumeration defines constants for use with Open Directory functions that look for pattern matches. A directory service is not required to support all types of pattern matching.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef enum {
eDSNoMatch1 = 0x0000,
eDSAnyMatch = 0x0001,
eDSBeginAppleReserve1 = 0x0002,
eDSEndAppleReserve1 = 0x1fff,
eDSExact = 0x2001,
eDSStartsWith = 0x2002,
eDSEndsWith = 0x2003,
eDSContains = 0x2004,
eDSLessThan = 0x2005,
eDSGreaterThan = 0x2006,
eDSLessEqual = 0x2007,
eDSGreaterEqual = 0x2008,
eDSWildCardPattern = 0x2009,
eDSRegularExpression = 0x200A,
eDSCompoundExpression = 0x200B,
eDSiExact = 0x2101,
eDSiStartsWith = 0x2102,
eDSiEndsWith = 0x2103,
eDSiContains = 0x2104,
eDSiLessThan = 0x2105,
eDSiGreaterThan = 0x2106,
eDSiLessEqual = 0x2107,
eDSiGreaterEqual = 0x2108,
eDSiWildCardPattern = 0x2109,
eDSiRegularExpression = 0x210A,
eDSiCompoundExpression = 0x210B,
eDSLocalNodeNames = 0x2200,
eDSSearchNodeName = 0x2201,
eDSConfigNodeName = 0x2202,
eDSLocalHostedNodes = 0x2203,
eDSAuthenticationSearchNodeName = 0x2201,
eDSContactsSearchNodeName = 0x2204,
eDSNetworkSearchNodeName = 0x2205,
eDSDefaultNetworkNodes = 0x2206,
dDSBeginPlugInCustom = 0x3000,
eDSEndPlugInCustom = 0x4fff,
eDSBeginAppleReserve2 = 0x5000,
eDSEndAppleReserve2 = 0xfffe,
eDSNoMatch2 = 0xffff
} tDirPatternMatch;

/*tDirStatus

typedef enum { 
    eDSNoErr = 0,  
    eDSOpenFailed = -14000, 
    eDSCloseFailed = -14001, 
    eDSOpenNodeFailed = -14002, 
    eDSBadDirRefences = -14003, 
    eDSNullRecordReference = -14004, 
    eDSMaxSessionsOpen = -14005, 
    eDSCannotAccessSession = -14006, 
    eDSDirSrvcNotOpened = -14007, 
    eDSNodeNotFound = -14008, 
    eDSUnknownNodeName = -14009,  
    eDSRegisterCustomFailed = -14010, 
    eDSGetCustomFailed = -14011, 
    eDSUnRegisterFailed = -14012,  
    eDSAllocationFailed = -14050, 
    eDSDeAllocateFailed = -14051, 
    eDSCustomBlockFailed = -14052, 
    eDSCustomUnblockFailed = -14053, 
    eDSCustomYieldFailed = -14054,  
    eDSCorruptBuffer = -14060, 
    eDSInvalidIndex = -14061, 
    eDSIndexOutOfRange = -14062, 
    eDSIndexNotFound = -14063, 
    eDSCorruptRecEntryData = -14065,  
    eDSRefSpaceFull = -14069, 
    eDSRefTableAllocError = -14070, 
    eDSInvalidReference = -14071, 
    eDSInvalidRefType = -14072, 
    eDSInvalidDirRef = -14073, 
    eDSInvalidNodeRef = -14074, 
    eDSInvalidRecordRef = -14075, 
    eDSInvalidAttrListRef = -14076, 
    eDSInvalidAttrValueRef = -14077, 
    eDSInvalidContinueData = -14078, 
    eDSInvalidBuffFormat = -14079, 
    eDSInvalidPatternMatchType = -14080, 
    eDSRefTableError = -14081, 
    eDSRefTableNilError = -14082, 
    eDSRefTableIndexOutOfBoundsError = -14083, 
    eDSRefTableEntryNilError = -14084, 
    eDSRefTableCSBPAllocError = -14085, 
    eDSRefTableFWAllocError = -14086,  
    eDSAuthFailed = -14090, 
    eDSAuthMethodNotSupported = -14091, 
    eDSAuthResponseBufTooSmall = -14092, 
    eDSAuthParameterError = -14093, 
    eDSAuthInBuffFormatError = -14094, 
    eDSAuthNoSuchEntity = -14095, 
    eDSAuthBadPassword = -14096, 
    eDSAuthContinueDataBad = -14097, 
    eDSAuthUnknownUser = -14098, 
    eDSAuthInvalidUserName = -14099, 
    eDSAuthCannotRecoverPasswd = -14100, 
    eDSAuthFailedClearTextOnly = -14101, 
    eDSAuthNoAuthServerFound = -14102, 
    eDSAuthServerError = -14103, 
    eDSInvalidContext = -14104, 
    eDSBadContextData = -14105,  
    eDSPermissionError = -14120, 
    eDSReadOnly = -14121, 
    eDSInvalidDomain = -14122, 
    eNetInfoError = -14123,  
    eDSInvalidRecordType = -14130, 
    eDSInvalidAttributeType = -14131, 
    eDSInvalidRecordName = -14133, 
    eDSAttributeNotFound = -14134, 
    eDSRecordAlreadyExists = -14135, 
    eDSRecordNotFound = -14136, 
    eDSAttributeDoesNotExist = -14137,  
    eDSNoStdMappingAvailable = -14140, 
    eDSInvalidNativeMapping = -14141, 
    eDSSchemaError = -14142, 
    eDSAttributeValueNotFound = -14143,  
    eDSVersionMismatch = -14149, 
    eDSPlugInConfigFileError = -14150, 
    eDSInvalidPlugInConfigData = -14151,  
    eDSAuthNewPasswordRequired = -14161, 
    eDSAuthPasswordExpired = -14162, 
    eDSAuthPasswordQualityCheckFailed = -14165, 
    eDSAuthAccountDisabled = -14167, 
    eDSAuthAccountExpired = -14168, 
    eDSAuthAccountInactive = -14169, 
    eDSAuthPasswordTooShort = -14170, 
    eDSAuthPasswordTooLong = -14171, 
    eDSAuthPasswordNeedsLetter = -14172, 
    eDSAuthPasswordNeedsDigit = -14173, 
    eDSAuthPasswordChangeTooSoon= -14174, 
    eDSAuthInvalidLogonHours = -14175, 
    eDSAuthInvalidComputer = -14176, 
    eDSAuthMasterUnreachable = -14177,  
    eDSNullParameter = -14200, 
    eDSNullDataBuff = -14201, 
    eDSNullNodeName = -14202, 
    eDSNullRecEntryPtr = -14203, 
    eDSNullRecName = -14204, 
    eDSNullRecNameList = -14205, 
    eDSNullRecType = -14206, 
    eDSNullRecTypeList = -14207, 
    eDSNullAttribute = -14208, 
    eDSNullAttributeAccess = -14209, 
    eDSNullAttributeValue = -14210, 
    eDSNullAttributeType = -14211, 
    eDSNullAttributeTypeList = -14212, 
    eDSNullAttributeControlPtr = -14213, 
    eDSNullAttributeRequestList = -14214, 
    eDSNullDataList = -14215, 
    eDSNullDirNodeTypeList = -14216, 
    eDSNullAutMethod = -14217, 
    eDSNullAuthStepData = -14218, 
    eDSNullAuthStepDataResp = -14219, 
    eDSNullNodeInfoTypeList = -14220, 
    eDSNullPatternMatch = -14221, 
    eDSNullNodeNamePattern = -14222, 
    eDSNullTargetArgument = -14223,  
    eDSEmptyParameter = -14230, 
    eDSEmptyBuffer = -14231, 
    eDSEmptyNodeName = -14232, 
    eDSEmptyRecordName = -14233, 
    eDSEmptyRecordNameList = -14234, 
    eDSEmptyRecordType = -14235, 
    eDSEmptyRecordTypeList = -14236, 
    eDSEmptyRecordEntry = -14237, 
    eDSEmptyPatternMatch = -14238, 
    eDSEmptyNodeNamePattern = -14239, 
    eDSEmptyAttribute = -14240, 
    eDSEmptyAttributeType = -14241, 
    eDSEmptyAttributeTypeList = -14242, 
    eDSEmptyAttributeValue = -14243, 
    eDSEmptyAttributeRequestList= -14244, 
    eDSEmptyDataList = -14245, 
    eDSEmptyNodeInfoTypeList = -14246, 
    eDSEmptyAuthMethod = -14247, 
    eDSEmptyAuthStepData = -14248, 
    eDSEmptyAuthStepDataResp = -14249, 
    eDSEmptyPattern2Match = -14250,  
    eDSBadDataNodeLength = -14255, 
    eDSBadDataNodeFormat = -14256, 
    eDSBadSourceDataNode = -14257, 
    eDSBadTargetDataNode = -14258,  
    eDSBufferTooSmall = -14260, 
    eDSUnknownMatchType = -14261, 
    eDSUnSupportedMatchType = -14262, 
    eDSInvalDataList = -14263, 
    eDSAttrListError = -14264,  
    eServerNotRunning = -14270, 
    eUnknownAPICall = -14271, 
    eUnknownServerError = -14272, 
    eUnknownPlugIn = -14273, 
    ePlugInDataError = -14274, 
    ePlugInNotFound = -14275, 
    ePlugInError = -14276, 
    ePlugInInitError = -14277, 
    ePlugInNotActive = -14278, 
    ePlugInFailedToInitialize = -14279, 
    ePlugInCallTimedOut = -14280,  
    eNoSearchNodesFound = -14290, 
    eSearchPathNotDefined = -14291, 
    eNotHandledByThisNode = -14292,  
    eIPCSendError = -14330, 
    eIPCReceiveError = -14331, 
    eServerReplyError = -14332,  
    eDSTCPSendError = -14350, 
    eDSTCPReceiveError = -14351, 
    eDSTCPVersionMismatch = -14352, 
    eDSIPUnreachable = -14353, 
    eDSUnknownHost = -14354,  
    ePluginHandlerNotLoaded = -14400, 
    eNoPluginsLoaded = -14402, 
    ePluginAlreadyLoaded = -14404, 
    ePluginVersionNotFound = -14406, 
    ePluginNameNotFound = -14408, 
    eNoPluginFactoriesFound = -14410, 
    ePluginConfigAvailNotFound = -14412, 
    ePluginConfigFileNotFound = -14414,  
    eCFMGetFileSysRepErr = -14450, 
    eCFPlugInGetBundleErr = -14452, 
    eCFBndleGetInfoDictErr = -14454, 
    eCFDictGetValueErr = -14456,  
    // Authentication Errors 
    eDSServerTimeout = -14470, 
    eDSContinue = -14471, 
    eDSInvalidHandle = -14472, 
    eDSSendFailed = -14473, 
    eDSReceiveFailed = -14474, 
    eDSBadPacket = -14475, 
    eDSInvalidTag = -14476, 
    eDSInvalidSession = -14477, 
    eDSInvalidName = -14478, 
    eDSUserUnknown = -14479, 
    eDSUnrecoverablePassword = -14480, 
    eDSAuthenticationFailed = -14481, 
    eDSBogusServer = -14482, 
    eDSOperationFailed = -14483, 
    eDSNotAuthorized = -14484, 
    eDSNetInfoError = -14485, 
    eDSContactMaster = -14486, 
    eDSServiceUnavailable = -14487,  
    eFWGetDirNodeNameErr1 = -14501, 
    eFWGetDirNodeNameErr2 = -14502, 
    eFWGetDirNodeNameErr3 = -14503, 
    eFWGetDirNodeNameErr4 = -14504,  
    // Errors received in the range -14700 : -14780 denote specific server errors. 
    // Contact Directory Services Server support when these errors are encountered 
    eParameterSendError = -14700, 
    eParameterReceiveError = -14720,  
    eServerSendError = -14740, 
    eServerReceiveError = -14760,  
    eMemoryError = -14900, 
    eMemoryAllocError = -14901, 
    eServerError = -14910, 
    eParameterError = -14915,  
    // Server response errors 
    // These errors indicate that the plug-in or server did not return the 
    // required data 
    eDataReceiveErr_NoDirRef = -14950, // No tDirReference returned 
    eDataReceiveErr_NoRecRef = -14951, // No tRecordReference returned 
    eDataReceiveErr_NoAttrListRef = -14952, // No tAttributeListRef returned 
    eDataReceiveErr_NoAttrValueListRef = -14953, // No tAttributeValueListRef returned 
    eDataReceiveErr_NoAttrEntry = -14954, // No tAttributeEntry returned 
    eDataReceiveErr_NoAttrValueEntry = -14955, // No tAttributeValueEntry returned 
    eDataReceiveErr_NoNodeCount = -14956, // No node Count returned 
    eDataReceiveErr_NoAttrCount = -14957, // No attribute count returned 
    eDataReceiveErr_NoRecEntry = -14958, // No tRecordEntry returned 
    eDataReceiveErr_NoRecEntryCount = -14959, // No record entry count returned 
    eDataReceiveErr_NoRecMatchCount = -14960, // No record match count returned 
    eDataReceiveErr_NoDataBuff = -14961, // No tDataBuffer returned 
    eDataReceiveErr_NoContinueData = -14962, // No continue data returned 
    eDataReceiveErr_NoNodeChangeToken = -14963, // No node Change Token returned  
    eNoLongerSupported = -14986, 
    eUndefinedError = -14987, 
    eNotYetImplemented = -14988,  
    eDSLastValue = -14999  
} tDirStatus;  
Constants
eDSSchemaError
The write operation failed because the result would conflict with the server's schema. For example, trying to remove a required attribute would return this error.
eDSAttributeValueNotFound
When using dsSetAttributeValue, dsRemoveAttributeValue, or dsGetAttributeValueByID the value with the specified ID was not found.
eDSVersionMismatch
A configuration file version is not compatible with this version of Directory Services or the plug-in that loaded it.
eDSAuthNewPasswordRequired
The administrator set a flag to force a password reset on the next login.
eDSAuthPasswordExpired
The password expiration date has passed so it must be reset.
eDSAuthPasswordQualityCheckFailed
New password rejected because it did not meet the password server�s quality requirements (for example, it was too short). This error only comes back when changing or setting the password, not when authenticating.
eDSAuthPasswordTooShort
New password rejected because it did not meet the password server�s minimum length requirements. This error only comes back when changing or setting the password, not when authenticating.
eDSAuthPasswordTooLong
New password rejected because it exceeded the password server�s maximum length limit. This error only comes back when changing or setting the password, not when authenticating.
eDSAuthPasswordNeedsLetter
New password rejected because it did not meet the password server�s quality requirements (did not contain a letter). This error only comes back when changing or setting the password, not when authenticating.
eDSAuthPasswordNeedsDigit
New password rejected because it did not meet the password server�s quality requirements (did not contain a digit). This error only comes back when changing or setting the password, not when authenticating.
eDSAuthAccountDisabled
The administrator set a flag to disable the account.
eDSAuthAccountExpired
The expiration date/time of the account passed so it is automatically disabled.
eDSAuthAccountInactive
The account was unused for a preset amount of time so it was automatically disabled.
eDSAuthMasterUnreachable
Unable to authenticate to make changes because the master server is unreachable.
Discussion 

Error codes returned from the Directory Services API.*/
typedef enum { 
    eDSNoErr = 0,  
    eDSOpenFailed = -14000, 
    eDSCloseFailed = -14001, 
    eDSOpenNodeFailed = -14002, 
    eDSBadDirRefences = -14003, 
    eDSNullRecordReference = -14004, 
    eDSMaxSessionsOpen = -14005, 
    eDSCannotAccessSession = -14006, 
    eDSDirSrvcNotOpened = -14007, 
    eDSNodeNotFound = -14008, 
    eDSUnknownNodeName = -14009,  
    eDSRegisterCustomFailed = -14010, 
    eDSGetCustomFailed = -14011, 
    eDSUnRegisterFailed = -14012,  
    eDSAllocationFailed = -14050, 
    eDSDeAllocateFailed = -14051, 
    eDSCustomBlockFailed = -14052, 
    eDSCustomUnblockFailed = -14053, 
    eDSCustomYieldFailed = -14054,  
    eDSCorruptBuffer = -14060, 
    eDSInvalidIndex = -14061, 
    eDSIndexOutOfRange = -14062, 
    eDSIndexNotFound = -14063, 
    eDSCorruptRecEntryData = -14065,  
    eDSRefSpaceFull = -14069, 
    eDSRefTableAllocError = -14070, 
    eDSInvalidReference = -14071, 
    eDSInvalidRefType = -14072, 
    eDSInvalidDirRef = -14073, 
    eDSInvalidNodeRef = -14074, 
    eDSInvalidRecordRef = -14075, 
    eDSInvalidAttrListRef = -14076, 
    eDSInvalidAttrValueRef = -14077, 
    eDSInvalidContinueData = -14078, 
    eDSInvalidBuffFormat = -14079, 
    eDSInvalidPatternMatchType = -14080, 
    eDSRefTableError = -14081, 
    eDSRefTableNilError = -14082, 
    eDSRefTableIndexOutOfBoundsError = -14083, 
    eDSRefTableEntryNilError = -14084, 
    eDSRefTableCSBPAllocError = -14085, 
    eDSRefTableFWAllocError = -14086,  
    eDSAuthFailed = -14090, 
    eDSAuthMethodNotSupported = -14091, 
    eDSAuthResponseBufTooSmall = -14092, 
    eDSAuthParameterError = -14093, 
    eDSAuthInBuffFormatError = -14094, 
    eDSAuthNoSuchEntity = -14095, 
    eDSAuthBadPassword = -14096, 
    eDSAuthContinueDataBad = -14097, 
    eDSAuthUnknownUser = -14098, 
    eDSAuthInvalidUserName = -14099, 
    eDSAuthCannotRecoverPasswd = -14100, 
    eDSAuthFailedClearTextOnly = -14101, 
    eDSAuthNoAuthServerFound = -14102, 
    eDSAuthServerError = -14103, 
    eDSInvalidContext = -14104, 
    eDSBadContextData = -14105,  
    eDSPermissionError = -14120, 
    eDSReadOnly = -14121, 
    eDSInvalidDomain = -14122, 
    eNetInfoError = -14123,  
    eDSInvalidRecordType = -14130, 
    eDSInvalidAttributeType = -14131, 
    eDSInvalidRecordName = -14133, 
    eDSAttributeNotFound = -14134, 
    eDSRecordAlreadyExists = -14135, 
    eDSRecordNotFound = -14136, 
    eDSAttributeDoesNotExist = -14137,  
    eDSNoStdMappingAvailable = -14140, 
    eDSInvalidNativeMapping = -14141, 
    eDSSchemaError = -14142, 
    eDSAttributeValueNotFound = -14143,  
    eDSVersionMismatch = -14149, 
    eDSPlugInConfigFileError = -14150, 
    eDSInvalidPlugInConfigData = -14151,  
    eDSAuthNewPasswordRequired = -14161, 
    eDSAuthPasswordExpired = -14162, 
    eDSAuthPasswordQualityCheckFailed = -14165, 
    eDSAuthAccountDisabled = -14167, 
    eDSAuthAccountExpired = -14168, 
    eDSAuthAccountInactive = -14169, 
    eDSAuthPasswordTooShort = -14170, 
    eDSAuthPasswordTooLong = -14171, 
    eDSAuthPasswordNeedsLetter = -14172, 
    eDSAuthPasswordNeedsDigit = -14173, 
    eDSAuthPasswordChangeTooSoon= -14174, 
    eDSAuthInvalidLogonHours = -14175, 
    eDSAuthInvalidComputer = -14176, 
    eDSAuthMasterUnreachable = -14177,  
    eDSNullParameter = -14200, 
    eDSNullDataBuff = -14201, 
    eDSNullNodeName = -14202, 
    eDSNullRecEntryPtr = -14203, 
    eDSNullRecName = -14204, 
    eDSNullRecNameList = -14205, 
    eDSNullRecType = -14206, 
    eDSNullRecTypeList = -14207, 
    eDSNullAttribute = -14208, 
    eDSNullAttributeAccess = -14209, 
    eDSNullAttributeValue = -14210, 
    eDSNullAttributeType = -14211, 
    eDSNullAttributeTypeList = -14212, 
    eDSNullAttributeControlPtr = -14213, 
    eDSNullAttributeRequestList = -14214, 
    eDSNullDataList = -14215, 
    eDSNullDirNodeTypeList = -14216, 
    eDSNullAutMethod = -14217, 
    eDSNullAuthStepData = -14218, 
    eDSNullAuthStepDataResp = -14219, 
    eDSNullNodeInfoTypeList = -14220, 
    eDSNullPatternMatch = -14221, 
    eDSNullNodeNamePattern = -14222, 
    eDSNullTargetArgument = -14223,  
    eDSEmptyParameter = -14230, 
    eDSEmptyBuffer = -14231, 
    eDSEmptyNodeName = -14232, 
    eDSEmptyRecordName = -14233, 
    eDSEmptyRecordNameList = -14234, 
    eDSEmptyRecordType = -14235, 
    eDSEmptyRecordTypeList = -14236, 
    eDSEmptyRecordEntry = -14237, 
    eDSEmptyPatternMatch = -14238, 
    eDSEmptyNodeNamePattern = -14239, 
    eDSEmptyAttribute = -14240, 
    eDSEmptyAttributeType = -14241, 
    eDSEmptyAttributeTypeList = -14242, 
    eDSEmptyAttributeValue = -14243, 
    eDSEmptyAttributeRequestList= -14244, 
    eDSEmptyDataList = -14245, 
    eDSEmptyNodeInfoTypeList = -14246, 
    eDSEmptyAuthMethod = -14247, 
    eDSEmptyAuthStepData = -14248, 
    eDSEmptyAuthStepDataResp = -14249, 
    eDSEmptyPattern2Match = -14250,  
    eDSBadDataNodeLength = -14255, 
    eDSBadDataNodeFormat = -14256, 
    eDSBadSourceDataNode = -14257, 
    eDSBadTargetDataNode = -14258,  
    eDSBufferTooSmall = -14260, 
    eDSUnknownMatchType = -14261, 
    eDSUnSupportedMatchType = -14262, 
    eDSInvalDataList = -14263, 
    eDSAttrListError = -14264,  
    eServerNotRunning = -14270, 
    eUnknownAPICall = -14271, 
    eUnknownServerError = -14272, 
    eUnknownPlugIn = -14273, 
    ePlugInDataError = -14274, 
    ePlugInNotFound = -14275, 
    ePlugInError = -14276, 
    ePlugInInitError = -14277, 
    ePlugInNotActive = -14278, 
    ePlugInFailedToInitialize = -14279, 
    ePlugInCallTimedOut = -14280,  
    eNoSearchNodesFound = -14290, 
    eSearchPathNotDefined = -14291, 
    eNotHandledByThisNode = -14292,  
    eIPCSendError = -14330, 
    eIPCReceiveError = -14331, 
    eServerReplyError = -14332,  
    eDSTCPSendError = -14350, 
    eDSTCPReceiveError = -14351, 
    eDSTCPVersionMismatch = -14352, 
    eDSIPUnreachable = -14353, 
    eDSUnknownHost = -14354,  
    ePluginHandlerNotLoaded = -14400, 
    eNoPluginsLoaded = -14402, 
    ePluginAlreadyLoaded = -14404, 
    ePluginVersionNotFound = -14406, 
    ePluginNameNotFound = -14408, 
    eNoPluginFactoriesFound = -14410, 
    ePluginConfigAvailNotFound = -14412, 
    ePluginConfigFileNotFound = -14414,  
    eCFMGetFileSysRepErr = -14450, 
    eCFPlugInGetBundleErr = -14452, 
    eCFBndleGetInfoDictErr = -14454, 
    eCFDictGetValueErr = -14456,  
    // Authentication Errors 
    eDSServerTimeout = -14470, 
    eDSContinue = -14471, 
    eDSInvalidHandle = -14472, 
    eDSSendFailed = -14473, 
    eDSReceiveFailed = -14474, 
    eDSBadPacket = -14475, 
    eDSInvalidTag = -14476, 
    eDSInvalidSession = -14477, 
    eDSInvalidName = -14478, 
    eDSUserUnknown = -14479, 
    eDSUnrecoverablePassword = -14480, 
    eDSAuthenticationFailed = -14481, 
    eDSBogusServer = -14482, 
    eDSOperationFailed = -14483, 
    eDSNotAuthorized = -14484, 
    eDSNetInfoError = -14485, 
    eDSContactMaster = -14486, 
    eDSServiceUnavailable = -14487,  
    eFWGetDirNodeNameErr1 = -14501, 
    eFWGetDirNodeNameErr2 = -14502, 
    eFWGetDirNodeNameErr3 = -14503, 
    eFWGetDirNodeNameErr4 = -14504,  
    // Errors received in the range -14700 : -14780 denote specific server errors. 
    // Contact Directory Services Server support when these errors are encountered 
    eParameterSendError = -14700, 
    eParameterReceiveError = -14720,  
    eServerSendError = -14740, 
    eServerReceiveError = -14760,  
    eMemoryError = -14900, 
    eMemoryAllocError = -14901, 
    eServerError = -14910, 
    eParameterError = -14915,  
    // Server response errors 
    // These errors indicate that the plug-in or server did not return the 
    // required data 
    eDataReceiveErr_NoDirRef = -14950, // No tDirReference returned 
    eDataReceiveErr_NoRecRef = -14951, // No tRecordReference returned 
    eDataReceiveErr_NoAttrListRef = -14952, // No tAttributeListRef returned 
    eDataReceiveErr_NoAttrValueListRef = -14953, // No tAttributeValueListRef returned 
    eDataReceiveErr_NoAttrEntry = -14954, // No tAttributeEntry returned 
    eDataReceiveErr_NoAttrValueEntry = -14955, // No tAttributeValueEntry returned 
    eDataReceiveErr_NoNodeCount = -14956, // No node Count returned 
    eDataReceiveErr_NoAttrCount = -14957, // No attribute count returned 
    eDataReceiveErr_NoRecEntry = -14958, // No tRecordEntry returned 
    eDataReceiveErr_NoRecEntryCount = -14959, // No record entry count returned 
    eDataReceiveErr_NoRecMatchCount = -14960, // No record match count returned 
    eDataReceiveErr_NoDataBuff = -14961, // No tDataBuffer returned 
    eDataReceiveErr_NoContinueData = -14962, // No continue data returned 
    eDataReceiveErr_NoNodeChangeToken = -14963, // No node Change Token returned  
    eNoLongerSupported = -14986, 
    eUndefinedError = -14987, 
    eNotYetImplemented = -14988,  
    eDSLastValue = -14999  
} tDirStatus;

/*tDataBuffer

A structure that provides a standard format for passing information between Open Directory and applications.

typedef struct
{
unsigned long fBufferSize;
unsigned long fBufferLength;
char fBufferData[1];
} tDataBuffer;
Fields
fBufferSize

Number of bytes allocated for this structure. The value of fBufferSize should be set when tDataBuffer is created.
fBufferLength

Number of meaningful bytes in fBufferData. You should call dsDataNodeSetLength to adjust this value each time you change the value of the fBufferData field.
fBufferData

Array of characters.
Discussion

A tDataBuffer structure is typically used to exchange strings, node names, and attribute types. Call dsDataBufferAllocate to allocate a data buffer. Call dsDataBufferDeAllocate to release the memory associated with a data buffer when it is no longer needed.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef struct
{
unsigned long fBufferSize;
unsigned long fBufferLength;
char fBufferData[1];
} tDataBuffer;

/*tDirReference

A value returned when an Open Directory session is opened.

typedef unsigned long tDirReference;
Discussion

You receive a tDirReference by calling by dsOpenDirService or dsOpenDirServiceProxy to open an Open Directory session. You call dsCloseDirService to close the session and dispose of the reference when you no longer need it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef unsigned long tDirReference;

/*tDataBufferPtr

A pointer to a value of type tDataBuffer.

typedef tDataBuffer *tDataBufferPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tDataBuffer *tDataBufferPtr;


/*tDataNode

A value of type tDataBuffer.

typedef tDataBuffer tDataNode;
Discussion

The tDataNode data type provides a standard format for passing information to Open Directory functions. It is typically used to contain strings, nodes, and attribute types that are exchanged between Open Directory and an Open Directory client.

See also tDataNodePtr.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tDataBuffer tDataNode;

/*tDataNodePtr

A pointer to a value of type tDataNode.

typedef tDataNode tDataNodePtr;
Discussion

Call dsDataNodeAllocateBlock or dsDataNodeAllocateString to allocate a data node.

Call dsDataNodeDeAllocate to release the memory associated with a data node when it is no longer needed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tDataNode tDataNodePtr;

/*tDataList

An ordered list of tDataNode structures.

typedef struct
{
unsigned long fDataNodeCount;
tDataNodePtr fDataListHead;
} tDataList;
Fields
fDataNodeCount

Number of data nodes in this data list structure.
fDataListHead

First pointer to a data node in this data list structure.
Discussion

This structure is used to represent lists of items, such as nodes, full pathnames, attribute type lists, and lists of record names. All items in a data list must be in UTF-8 format.

Do not manipulate tDataList structures directly. Instead, use the data list utility functions such as dsBuildFromPath, dsDataListAllocate, dsDataListGetNodeAlloc, dsAppendStringToListAlloc, and dsDataListDeallocate.

See also tDataListPtr.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef struct
{
unsigned long fDataNodeCount;
tDataNodePtr fDataListHead;
} tDataList;

/*tDataListPtr

A pointer to a value of type tDataList.

typedef tDataList *tDataListPtr;
Discussion

To allocate a data list, call dsDataListAllocate. To build a data list from one or more data nodes, call dsBuildListFromNodesAlloc; to build a data list from one or more C strings, call dsBuildListFromStrings. Or copy a data list by calling dsDataListCopyList.

To release the memory associated with a data list when it is no longer needed, call dsDataListDeallocate. If the data list is heap-based, you also need to call free().
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tDataList *tDataListPtr;

/*tRecordEntry

A structure used to store information about a record, including its name, type, and number of attributes.

typedef struct
{
unsigned long fReserved1;
tAccessControlEntry fReserved2;
unsigned long fRecordAttributeCount;
tDataNode fRecordNameAndType;
}   tRecordEntry;
Fields
fReserved1

Reserved.
fReserved2

Reserved.
fRecordAttributeCount

Number of attribute types.
fRecordNameAndType

Value of type tDataNode containing the record’s primary name in UTF-8 format and its type.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef struct
{
unsigned long fReserved1;
tAccessControlEntry fReserved2;
unsigned long fRecordAttributeCount;
tDataNode fRecordNameAndType;
}   tRecordEntry;


/*tRecordEntryPtr

A pointer to a value of type tRecordEntry.

typedef tRecordEntry *tRecordEntryPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tRecordEntry *tRecordEntryPtr;

/*tAttributeEntry

A structure used to store information about an attribute.

typedef struct
{
unsigned long fReserved1;
tAccessControlEntry fReserved2;
unsigned long fAttributeValueCount;
unsigned long fAttributeDataSize;
unsigned long fAttributeValueMaxSize;
tDataNode fAttributeSignature;
} tAttributeEntry;
typedef tAttributeEntry *tAttributeEntryPtr;
Fields
fReserved1

Reserved.
fReserved2

Reserved.
fAttributeValueCount

Number of values associated with this attribute.
fAttributeDataSize

Total byte count of all attribute values.
fAttributeValueMaxSize

Maximum size of a value of this attribute type.
fAttributeSignature

Byte sequence that uniquely represents this attribute type. The byte sequence is typically a collection of Unicode characters.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef struct
{
unsigned long fReserved1;
tAccessControlEntry fReserved2;
unsigned long fAttributeValueCount;
unsigned long fAttributeDataSize;
unsigned long fAttributeValueMaxSize;
tDataNode fAttributeSignature;
} tAttributeEntry;


/*tAttributeEntryPtr

A pointer to a tAttributeEntry structure.

typedef tAttributeEntry *tAttributeEntryPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tAttributeEntry *tAttributeEntryPtr;

/*tAttributeValueEntry

A structure used to get and set the value of an attribute by attribute value ID.

typedef struct
{
unsigned long fAttributeValueID;
tDataNode fAttributeValueData;
} tAttributeValueEntry;
Fields
fAttributeValueID

Unique ID for this attribute value.
fAttributeValueData

Value of type tDataNode containing the value of this attribute.
Declared In
DirectoryService/DirServicesTypes.h*/

typedef struct
{
unsigned long fAttributeValueID;
tDataNode fAttributeValueData;
} tAttributeValueEntry;


/*tAttributeValueEntryPtr

A pointer to a tAttributeValueEntry structure.

typedef tAttributeValueEntry *tAttributeValueEntryPtr;
Availability
Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesTypes.h*/
typedef tAttributeValueEntry *tAttributeValueEntryPtr;

#ifdef __cplusplus
}
#endif

#endif
