#import <Foundation/Foundation.h>

#import <DiscRecordingEngine/DRCoreNotifications.h>

@interface DRNotificationCenter : NSObject 

/*currentRunLoopCenter


Creates an initializes a DRNotificationCenter 
private

+ (DRNotificationCenter*) currentRunLoopCenter; 
Return Value

A shared DRNotificationCenter object. 
Discussion 

The instance returned sends Disc Recording notifications only to the current run loop. If you want to receive notifications on another run loop, this method must be called from that runloop.*/
+ (DRNotificationCenter*) currentRunLoopCenter; 

/*addObserver:selector:name:object:


Adds an observer to the receiver. 
private

- (void)addObserver:(id)observer selector:(SEL)aSelector 
        name:(NSString *)notificationName object:(id)anObject; 
Parameters
observer
The observer to send notifications to.
aSelector
The selector to call
notificationName
The notification to listen for
anObject
The object to limit notifications for.
Discussion 

Registers anObserver to receive notifications with the name notificationName and/or containing anObject. When a notification of name notificationName containing the object anObject is posted, anObserver receives an aSelector message with this notification as the argument. The method for the selector specified in aSelector must have one and only one argument. If notificationName is nil, the notification center notifies the observer of all notifications with an object matching anObject. If anObject is nil, the notification center notifies the observer of all notifications with the name notificationName.
The notification center does not retain anObserver or anObject. Therefore, you should always send removeObserver:name:object: to the notification center before releasing these objects.*/

- (void)addObserver:(id)observer selector:(SEL)aSelector 
        name:(NSString *)notificationName object:(id)anObject; 

/*removeObserver:name:object:


Removes anObserver from receiving notifications. 
private

- (void)removeObserver:(id)observer name:(NSString *)aName 
        object:(id)anObject; 
Parameters
observer
The observer to remove
aName
The notification the remove the observer from.
anObject
The object the observer was listening for.
Discussion 

Removes anObserver as the observer of notifications with the name notificationName and object anObject from the receiver. Be sure to invoke this method before deallocating the observer object or any object specified in addObserver:selector:name:object: .*/
- (void)removeObserver:(id)observer name:(NSString *)aName 
        object:(id)anObject; 


@end
