#import <Foundation/NSObject.h>

/*NSError Codes

NSError codes in the Cocoa error domain.

enum {
   NSFileNoSuchFileError = 4,
   NSFileLockingError = 255,
   NSFileReadUnknownError = 256,
   NSFileReadNoPermissionError = 257,
   NSFileReadInvalidFileNameError = 258,
   NSFileReadCorruptFileError = 259,
   NSFileReadNoSuchFileError = 260,
   NSFileReadInapplicableStringEncodingError = 261,
   NSFileReadUnsupportedSchemeError = 262,
   NSFileWriteUnknownError = 512,
   NSFileWriteNoPermissionError = 513,
   NSFileWriteInvalidFileNameError = 514,
   NSFileWriteInapplicableStringEncodingError = 517,
   NSFileWriteUnsupportedSchemeError = 518,
   NSFileWriteOutOfSpaceError = 640,
   NSKeyValueValidationError = 1024,
   NSFormattingError = 2048,
   NSUserCancelledError = 3072,
   
   NSFileErrorMinimum = 0,
   NSFileErrorMaximum = 1023,
   NSValidationErrorMinimum = 1024,
   NSValidationErrorMaximum = 2047,
   NSFormattingErrorMinimum = 2048,
   NSFormattingErrorMaximum = 2559
}
Constants
NSFileNoSuchFileError

File-system operation attempted on non-existent file

Available in Mac OS X v10.4 and later.
NSFileLockingError

Failure to get a lock on file

Available in Mac OS X v10.4 and later.
NSFileReadUnknownError

Read error, reason unknown

Available in Mac OS X v10.4 and later.
NSFileReadNoPermissionError

Read error because of a permission problem

Available in Mac OS X v10.4 and later.
NSFileReadInvalidFileNameError

Read error because of an invalid file name

Available in Mac OS X v10.4 and later.
NSFileReadCorruptFileError

Read error because of a corrupted file, bad format, or similar reason

Available in Mac OS X v10.4 and later.
NSFileReadNoSuchFileError

Read error because no such file was found

Available in Mac OS X v10.4 and later.
NSFileReadInapplicableStringEncodingError

Read error because the string encoding was not applicable.

Access the bad encoding from the userInfo dictionary using the NSStringEncodingErrorKey key.

Available in Mac OS X v10.4 and later.
NSFileReadUnsupportedSchemeError

Read error because the specified URL scheme is unsupported

Available in Mac OS X v10.4 and later.
NSFileWriteUnknownError

Write error, reason unknown

Available in Mac OS X v10.4 and later.
NSFileWriteNoPermissionError

Write error because of a permission problem

Available in Mac OS X v10.4 and later.
NSFileWriteInvalidFileNameError

Write error because of an invalid file name

Available in Mac OS X v10.4 and later.
NSFileWriteInapplicableStringEncodingError

Write error because the string encoding was not applicable.

Access the bad encoding from the userInfo dictionary using the NSStringEncodingErrorKey key.

Available in Mac OS X v10.4 and later.
NSFileWriteUnsupportedSchemeError

Write error because the specified URL scheme is unsupported

Available in Mac OS X v10.4 and later.
NSFileWriteOutOfSpaceError

Write error because of a lack of disk space

Available in Mac OS X v10.4 and later.
NSKeyValueValidationError

Key-value coding validation error

Available in Mac OS X v10.4 and later.
NSFormattingError

Formatting error (related to display of data)

Available in Mac OS X v10.4 and later.
NSUserCancelledError

The user cancelled the operation (for example, by pressing Command-period).

This code is for errors that do not require a dialog displayed and might be candidates for special-casing.

Available in Mac OS X v10.4 and later.
NSFileErrorMinimum

Marks the start of the range of error codes reserved for file errors

Available in Mac OS X v10.4 and later.
NSFileErrorMaximum

Marks the end of the range of error codes reserved for file errors

Available in Mac OS X v10.4 and later.
NSValidationErrorMinimum

Marks the start of the range of error codes reserved for validation errors.

Available in Mac OS X v10.4 and later.
NSValidationErrorMaximum

Marks the start and end of the range of error codes reserved for validation errors.

Available in Mac OS X v10.4 and later.
NSFormattingErrorMinimum

Marks the start of the range of error codes reserved for formatting errors.

Available in Mac OS X v10.4 and later.
NSFormattingErrorMaximum

Marks end of the range of error codes reserved for formatting errors.

Available in Mac OS X v10.4 and later.
Discussion

The constants in this enumeration are NSError code numbers in the Cocoa error domain (NSCocoaErrorDomain). Other frameworks, most notably the Application Kit, provide their own NSCocoaErrorDomain error codes. 

The enumeration constants beginning with NSFile indicate file-system errors or errors related to file I/O operations. Use the key NSFilePathErrorKey or the NSURLErrorKey (whichever is appropriate) to access the file-system path or URL in the userInfo dictionary of the NSError object.
Declared In
FoundationErrors.h*/
enum {
   NSFileNoSuchFileError = 4,
   NSFileLockingError = 255,
   NSFileReadUnknownError = 256,
   NSFileReadNoPermissionError = 257,
   NSFileReadInvalidFileNameError = 258,
   NSFileReadCorruptFileError = 259,
   NSFileReadNoSuchFileError = 260,
   NSFileReadInapplicableStringEncodingError = 261,
   NSFileReadUnsupportedSchemeError = 262,
   NSFileWriteUnknownError = 512,
   NSFileWriteNoPermissionError = 513,
   NSFileWriteInvalidFileNameError = 514,
   NSFileWriteInapplicableStringEncodingError = 517,
   NSFileWriteUnsupportedSchemeError = 518,
   NSFileWriteOutOfSpaceError = 640,
   NSKeyValueValidationError = 1024,
   NSFormattingError = 2048,
   NSUserCancelledError = 3072,
   NSFileErrorMinimum = 0,
   NSFileErrorMaximum = 1023,
   NSValidationErrorMinimum = 1024,
   NSValidationErrorMaximum = 2047,
   NSFormattingErrorMinimum = 2048,
   NSFormattingErrorMaximum = 2559
};

