 #ifndef __MACWINDOWS__
#define __MACWINDOWS__


#ifndef MACWINDOW_H
#define MACWINDOWS_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef APPEARANCE_H
#include <HIToolbox/Appearance.h>
#endif

#ifndef DRAG_H
#include <HIToolbox/Drag.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef HITOOLBAR_H
#include <HIToolbox/HIToolbar.h>
#endif

#ifndef HIGEOMETRY_H
#include <HIToolbox/HIGeometry.h> //hys
#endif

#ifndef QUICKDRAW_H
#include <QD/Quickdraw.h>//hys
#endif

//#include <HYS/HIToolbox/MacWindows.h>
#include <APPLE/HIToolbox/MacWindows.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Constants
CONST
   {window types}
   documentProc      = 0;  {movable, sizable window, no zoom box}
   dBoxProc          = 1;  {alert box or modal dialog box}
   plainDBox         = 2;  {plain box}
   altDBoxProc       = 3;  {plain box with shadow}
   noGrowDocProc     = 4;  {movable window, no size box or }
                           { zoom box}
   movableDBoxProc   = 5;  {movable modal dialog box}
   zoomDocProc       = 8;  {standard document window}
   zoomNoGrow        = 12; {zoomable, nonresizable window}
   rDocProc          = 16; {rounded-corner window}
   {window kinds}
   dialogKind        = 2;  {dialog or alert box window}
   userKind          = 8;  {window created by the application}
   {part codes returned by FindWindow}
   inDesk            = 0;  {none of the following}
   inMenuBar         = 1;  {in menu bar}
   inSysWindow       = 2;  {in desk accessory window}
   inContent         = 3;  {anywhere in content region except size }
                           { box if window is active, }
                           { anywhere including size box if window }
                           { is inactive}
   inDrag            = 4;  {in drag (title bar) region}
   inGrow            = 5;  {in size box (active window only)}
   inGoAway          = 6;  {in close box}
   inZoomIn          = 7;  {in zoom box (window in standard state)}
   inZoomOut         = 8;  {in zoom box (window in user state)}
   {axis constraints on DragGrayRgn}
   noConstraint      = 0;  {no constraints}
   hAxisOnly         = 1;  {move on horizontal axis only}
   vAxisOnly         = 2;  {move on vertical axis only}
   {window definition function task codes}
   wDraw       = 0;  {draw window frame}
   wHit        = 1;  {report where mouse-down occurred}
   wCalcRgns   = 2;  {calculate strucRgn and contRgn}
   wNew        = 3;  {perform additional initialization}
   wDispose    = 4;  {perform additional disposal tasks}
   wGrow       = 5;  {draw grow image during resizing}
   wDrawGIcon  = 6;  {draw size box and scroll bar outline}

   {window definition function wHit return codes}
   wNoHit      = 0;  {none of the following}
   wInContent  = 1;  {anywhere in content region except size }
                     { box if window is active, }
                     { anywhere including size box if window }
                     { is inactive}
   wInDrag     = 2;  {in drag (title bar) region}
   wInGrow     = 3;  {in size box (active window only)}
   wInGoAway   = 4;  {in close box}
   wInZoomIn   = 5;  {in zoom box (window in standard state)}
   wInZoomOut  = 6;  {in zoom box (window in user state)}
   {window color information table part codes}
   wContentColor     = 0;     {content region background}
   wFrameColor       = 1;     {window outline}
   wTextColor        = 2;     {window title and button text}
   wHiliteColor      = 3;     {reserved}
   wTitleBarColor    = 4;     {reserved}
   wHiliteColorLight = 5;     {lightest stripes in title bar }
                              { and lightest dimmed text}
   wHiliteColorDark  = 6;     {darkest stripes in title bar }
                              { and darkest dimmed text}
   wTitleBarLight    = 7;     {lightest parts of title bar background}
   wTitleBarDark     = 8;     {darkest parts of title bar background}
   wDialogLight      = 9;     {lightest element of dialog box frame}
   wDialogDark       = 10;    {darkest element of dialog box frame}
   wTingeLight       = 11;    {lightest window tinging}
   wTingeDark        = 12;    {darkest window tinging}
   {resource ID of desktop pattern}
   deskPatID         = 16;*/
enum {
  wContentColor     = 0,
};
/*Window Class Position Constants

Specify which window in the class to select. 

enum {
   kFirstWindowOfClass = -1,
   kLastWindowOfClass = 0
};
Constants
kFirstWindowOfClass

Select the first window in the class.

Available in Mac OS X v10.0 and later.
kLastWindowOfClass

Select the last window in the class.

Available in Mac OS X v10.0 and later.
Discussion

These constants describe special cases for the “behind” parameter in window creation calls.*/
enum {
   kFirstWindowOfClass = -1,
   kLastWindowOfClass = 0
};

/*Window Transition Action Constants

Specify the type of window action taking place. 

typedef UInt32 WindowTransitionAction;
enum {
   kWindowShowTransitionAction = 1,
   kWindowHideTransitionAction = 2,
   kWindowMoveTransitionAction = 3,
   kWindowResizeTransitionAction = 4
};
Constants
kWindowShowTransitionAction

Specifies that the animation display the window opening, that is, transitioning from a closed to an open state.

Available in Mac OS X v10.0 and later.
kWindowHideTransitionAction

Specifies that the animation display the window closing, that is, transitioning from an open to a closed state.

Available in Mac OS X v10.0 and later.
kWindowMoveTransitionAction

Moves the window. Use with the Slide transition effect. The inRect parameter contains the global coordinates of the window’s new structure bounds and cannot be NULL. (Available in Mac OS X, and in CarbonLib 1.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowResizeTransitionAction

Resizes the window. Use with the Slide transition effect. The inRect parameter contains the global coordinates of the window’s new structure bounds and cannot be NULL. (Available in Mac OS X and in CarbonLib 1.5 and later.)

Available in Mac OS X v10.0 and later.
Discussion

You may pass these WindowTransitionAction constants to the function TransitionWindow to specify the direction of the animation effect that is to be performed for a window.*/
typedef UInt32 WindowTransitionAction;
enum {
   kWindowShowTransitionAction = 1,
   kWindowHideTransitionAction = 2,
   kWindowMoveTransitionAction = 3,
   kWindowResizeTransitionAction = 4
};


/*Window Transition Effect Constants

Designate the type of transition effect to use to show or hide the window. 

typedef UInt32 WindowTransitionEffect;
enum {
   kWindowZoomTransitionEffect = 1,
   kWindowSheetTransitionEffect = 2,
   kWindowSlideTransitionEffect = 3,
   kWindowFadeTransitionEffect = 4,
   kWindowGenieTransitionEffect = 5
};
Constants
kWindowZoomTransitionEffect

Specifies an animation that displays the window zooming between the open and closed states. The direction of the animation, whether from open to closed, or closed to open, depends upon the WindowTransitionAction constant specified in conjunction with the WindowTransitionEffect constant; see“Window Transition Action Constants” for descriptions of possible values.

Available in Mac OS X v10.0 and later.
kWindowSheetTransitionEffect

Zoom in or out from the parent window. Use with TransitionWindowAndParent and Show or Hide transition actions. (Available in Mac OS X, and in CarbonLib 1.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowSlideTransitionEffect

Slide the window into its new position. Use with TransitionWindow and Move or Resize transition actions. (Available in Mac OS X and in CarbonLib 1.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowFadeTransitionEffect

Fade the window into or out of visibility. Use with the Show or Hide transition action. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kWindowGenieTransitionEffect

Use the Genie effect that the Dock uses to minimize or maximize a window to show or hide the window. Use with the Show or Hide transition action. (Available in Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
Discussion

You may pass this WindowTransitionEffect constant to the function TransitionWindow to specify the type of animation effect that is to be performed for a window.*/
typedef UInt32 WindowTransitionEffect;
enum {
   kWindowZoomTransitionEffect = 1,
   kWindowSheetTransitionEffect = 2,
   kWindowSlideTransitionEffect = 3,
   kWindowFadeTransitionEffect = 4,
   kWindowGenieTransitionEffect = 5
};



/*Window Feature Bits

Specify features available in a window. 

enum {
   kWindowCanGrow = (1 << 0),
   kWindowCanZoom = (1 << 1),
   kWindowCanCollapse = (1 << 2),
   kWindowIsModal = (1 << 3),
   kWindowCanGetWindowRegion = (1 << 4),
   kWindowIsAlert = (1 << 5),
   kWindowHasTitleBar = (1 << 6),
   kWindowSupportsDragHilite = (1 << 7),
   kWindowSupportsModifiedBit = (1 << 8),
   kWindowCanDrawInCurrentPort = (1 << 9),
   kWindowCanSetupProxyDragImage = (1 << 10),
   kWindowCanMeasureTitle = (1 << 11),
   kWindowWantsDisposeAtProcessDeath = (1 << 12),
   kWindowSupportsGetGrowImageRegion = (1 << 13),
   kWindowIsOpaque = (1 << 14),
   kWindowDefSupportsColorGrafPort = 0x40000002
};
Constants
kWindowCanGrow

If this bit (bit 0) is set, the window has a grow box (may not be visible).

Available in Mac OS X v10.0 and later.
kWindowCanZoom

If this bit (bit 1) is set, the window has a zoom box (may not be visible).

Available in Mac OS X v10.0 and later.
kWindowCanCollapse

If this bit (bit 2) is set, the window has a collapse box.

Available in Mac OS X v10.0 and later.
kWindowIsModal

If this bit (bit 3) is set, the window should behave as modal.

Available in Mac OS X v10.0 and later.
kWindowCanGetWindowRegion

If this bit (bit 4) is set, the window supports a call to GetWindowRegion. 

Available in Mac OS X v10.0 and later.
kWindowIsAlert

If this bit (bit 5) is set, the window is an alert box (may be movable or not). When this constant is added to kWindowIsModal, the user should be able to switch out of the application and move the alert box.

Available in Mac OS X v10.0 and later.
kWindowHasTitleBar

If this bit (bit 6) is set, the window has a title bar. 

Available in Mac OS X v10.0 and later.
kWindowSupportsDragHilite

If the bit specified by this mask is set, the window supports the kWindowMsgDragHilite message. (Mac OS 8.5 and later.) 

Available in Mac OS X v10.0 and later.
kWindowSupportsModifiedBit

If the bit specified by this mask is set, the window supports the kWindowMsgModified message. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowCanDrawInCurrentPort

If the bit specified by this mask is set, the window supports the kWindowMsgDrawInCurrentPort message. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowCanSetupProxyDragImage

If the bit specified by this mask is set, the window supports the kWindowMsgSetupProxyDragImage message. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowCanMeasureTitle

If the bit specified by this mask is set, the window supports the kWindowMsgMeasureTitle message. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowWantsDisposeAtProcessDeath

If the bit specified by this mask is set, the window definition function wants to receive a wDispose message for the window if it still exists when the application quits.

Previously, the Window Manager would send a wDispose message only if the application explicitly closed the window with calls to the CloseWindow or DisposeWindow functions. The Window Manager would delete a window that still existed when the application called ExitToShell without notifying the window definition function, as part of the destruction of the process.

Note that if a window has the kWindowWantsDisposeAtProcessDeath feature bit set, the Window Manager sends your window definition function a wDispose message for the window when the application exits for any cause, including if your application crashes.

A window might want to set this feature flag if it allocates data when it is initialized that lives outside of the application heap and that is not automatically disposed when the application quits. The wDispose message is sent very early in the termination process, so it is still safe for the window definition function to call the system back (for example, you may want to do this in order to dispose of any auxiliary data). However, to ensure compatibility and to create the minimum performance impact, the window definition function should try to do as little as possible after receiving a wDispose message sent during the termination process. (Mac OS 8.5 and later.)

This feature is only available on Mac OS 8.x and 9.x. It is not supported on Mac OS X.s

Available in Mac OS X v10.0 and later.
kWindowSupportsGetGrowImageRegion

(Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowIsOpaque

The window is opaque and therefore does not need an alpha channel (saves memory). (Mac OS X only.)

Available in Mac OS X v10.1 and later.
kWindowDefSupportsColorGrafPort

(Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
Discussion

For descriptions of the messages that correspond to these feature flags, see “Window Definition Message Constants”.*/
enum {
   kWindowCanGrow = (1 << 0),
   kWindowCanZoom = (1 << 1),
   kWindowCanCollapse = (1 << 2),
   kWindowIsModal = (1 << 3),
   kWindowCanGetWindowRegion = (1 << 4),
   kWindowIsAlert = (1 << 5),
   kWindowHasTitleBar = (1 << 6),
   kWindowSupportsDragHilite = (1 << 7),
   kWindowSupportsModifiedBit = (1 << 8),
   kWindowCanDrawInCurrentPort = (1 << 9),
   kWindowCanSetupProxyDragImage = (1 << 10),
   kWindowCanMeasureTitle = (1 << 11),
   kWindowWantsDisposeAtProcessDeath = (1 << 12),
   kWindowSupportsGetGrowImageRegion = (1 << 13),
   kWindowIsOpaque = (1 << 14),
   kWindowDefSupportsColorGrafPort = 0x40000002
};


/*Window Definition Hit Test Result Code Constants

Defines result constants to be used by window definition hit testing. 

typedef SInt16 WindowDefPartCode;
enum {
   wNoHit = 0,
   wInContent = 1,
   wInDrag = 2,
   wInGrow = 3,
   wInGoAway = 4,
   wInZoomIn = 5,
   wInZoomOut = 6,
   wInCollapseBox = 9,
   wInProxyIcon = 10,
   wInToolbarButton = 11,
   wInStructure = 13
};
Constants
wNoHit

The mouse-down event did not occur in the content region or the drag region of any active or inactive window or in the close, size, zoom, or collapse box of an active window. The return value wNoHit might also mean that the point isn’t in the window. The standard window definition functions, for example, return wNoHit if the point is in the window frame but not in the title bar.

Available in Mac OS X v10.0 and later.
wInContent

The mouse-down event occurred in the content region of an active or inactive window (with the exception of the size box).

Available in Mac OS X v10.0 and later.
wInDrag

The mouse-down event occurred in the drag region of an active or inactive window.

Available in Mac OS X v10.0 and later.
wInGrow

The mouse-down occurred in the size box of an active window.

Available in Mac OS X v10.0 and later.
wInGoAway

The mouse-down event occurred in the close box of an active window.

Available in Mac OS X v10.0 and later.
wInZoomIn

The mouse-down event occurred in the zoom box of an active window that is currently in the standard state.

Available in Mac OS X v10.0 and later.
wInZoomOut

The mouse-down event occurred in the zoom box of an active window that is currently in the user state.

Available in Mac OS X v10.0 and later.
wInCollapseBox

The mouse-down event occurred in the collapse box of an active window.

Available with Appearance Manager 1.0 and later.
wInProxyIcon

The mouse-down event occurred in the proxy icon of a window.

Available in Mac OS X v10.0 and later.
wInToolbarButton

The mouse-down event occurred in the toolbar button.

Available in Mac OS X v10.1 and later.
wInStructure

The mouse-down event occurred in the window’s structure region. 

Available in Mac OS X v10.1 and later.
Discussion

In response to the wHit message, your window definition function should return one of these constants.

Return the constants wInGrow, wInGoAway, wInZoomIn, wInZoomOut, and wInCollapseBox only if the window is active—by convention, the size box, close box, zoom box, and collapse box aren’t drawn if the window is inactive. In an inactive document window, for example, a mouse-down event in the part of the title bar that would contain the close box if the window were active is reported as wInDrag.

With the Mac OS 8.5 Window Manager and later, your window definition function may return the wInProxyIcon constant to report that a mouse-down event occurred in your window’s proxy icon.*/

typedef SInt16 WindowDefPartCode;
enum {
   wNoHit = 0,
   wInContent = 1,
   wInDrag = 2,
   wInGrow = 3,
   wInGoAway = 4,
   wInZoomIn = 5,
   wInZoomOut = 6,
   wInCollapseBox = 9,
   wInProxyIcon = 10,
   wInToolbarButton = 11,
   wInStructure = 13
};


/*Window Definition Message Constants

Defines messages sent to non Carbon Event–based window definitions.

enum {
   kWindowMsgDraw = 0,
   kWindowMsgHitTest = 1,
   kWindowMsgCalculateShape = 2,
   kWindowMsgInitialize = 3,
   kWindowMsgCleanUp = 4,
   kWindowMsgDrawGrowOutline = 5,
   kWindowMsgDrawGrowBox = 6
};
enum {
   kWindowMsgGetFeatures = 7,
   kWindowMsgGetRegion = 8
};
enum {
   kWindowMsgDragHilite = 9,
   kWindowMsgModified = 10,
   kWindowMsgDrawInCurrentPort = 11,
   kWindowMsgSetupProxyDragImage = 12,
   kWindowMsgStateChanged = 13,
   kWindowMsgMeasureTitle = 14
};
enum {
   kWindowMsgGetGrowImageRegion = 19
};
Constants
kWindowMsgDraw

Draw the window’s frame.

Available in Mac OS X v10.0 and later.
kWindowMsgHitTest

Report the location of a mouse-down event. 

Available in Mac OS X v10.0 and later.
kWindowMsgCalculateShape

Calculate the structure region and the content region.

Available in Mac OS X v10.0 and later.
kWindowMsgInitialize

Perform additional initialization.

Available in Mac OS X v10.0 and later.
kWindowMsgCleanUp

Perform additional disposal.

Available in Mac OS X v10.0 and later.
kWindowMsgDrawGrowOutline

Draw the dotted outline of the window that you see during a resizing operation.

Available in Mac OS X v10.0 and later.
kWindowMsgDrawGrowBox

Draw the outlines for the size box and the scroll bar.

Available in Mac OS X v10.0 and later.
kWindowMsgGetFeatures

Report the window’s features.

Available with Appearance Manager 1.0 and later.
kWindowMsgGetRegion

Report the location of a specific window region.

Available with Appearance Manager 1.0 and later.
kWindowMsgDragHilite

Redraw the window’s structure region to reflect the window’s validity as a drag-and-drop destination. The Window Manager passes an accompanying Boolean value in your window definition function’s param parameter. If the value passed is true, this indicates that the window’s structure region should be highlighted. If the value passed is false, the structure region should be unhighlighted. Your window definition function should return 0 as the function result. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowMsgModified

Track the window’s modification state. The Window Manager sends this message when the function SetWindowModified is called. The Window Manager passes an accompanying Boolean value in your window definition function’s param parameter. If the value passed is true, the document contained in the window has been modified. If the value passed is false, the document has been saved to disk. You should redraw the window’s structure region to reflect the new modification state, if appropriate. For example, system-defined document windows dim the proxy icon to indicate that the document has been modified by the user and cannot be moved at that time. Your window definition function should return 0 as the function result. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowMsgDrawInCurrentPort

Draw the window’s frame in the current graphics port. Other than restricting drawing to the current port, this message is similar to the pre–Mac OS 8.5 Window Manager window definition message constant wDraw. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowMsgSetupProxyDragImage

Create the image of the window’s proxy icon that the Drag Manager uses to represent the icon while it is being dragged. When your application calls the function TrackWindowProxyDrag, the Window Manager passes this message in your window definition function’s message parameter and an accompanying pointer to a structure of type SetupWindowProxyDragImageRec in the param parameter. Your window definition function is responsible for setting the contents of the structure to contain the data describing the proxy icon’s drag image. Your window definition function should return 0 as the function result. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowMsgStateChanged

Be informed that some aspect of the window’s public state has changed. The Window Manager passes this message in your window definition function’s message parameter and an accompanying flag in the param parameter that indicates what part of the window’s state has been altered. This message is simply a notification message—no response by the window definition function is required. Your window definition function should return 0 as the function result. The kWindowMsgStateChanged message is sent after the window’s internal data has been updated, but before any redraw occurs onscreen. A window definition function should not redraw the window frame in response to this message. If it is necessary to redraw the window frame, the Window Manager notifies the window definition function with a wDraw message. See “Window Definition State-Changed Constant” for descriptions of the values that the Window Manager can pass to specify the state change that has occurred. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowMsgMeasureTitle

Measure and return the ideal title width. The Window Manager passes this message in the window definition function’s message parameter and an accompanying pointer to a structure of type MeasureWindowTitleRec in the param parameter. Your window definition function is responsible for setting the contents of the structure to contain data describing the title width. You should return 0 as the function result. (Mac OS 8.5 and later.)

Available in Mac OS X v10.0 and later.
kWindowMsgGetGrowImageRegion

Obtain a region to XOR with window during grow or resize. Alter the GetGrowImageRegionRec structure passed with the message to the region to be XOR’d. (

Available in Carbon only.) 
Discussion

The Window Manager may pass one of these constants in the message parameter of your window definition function to specify the action that your function must perform. For descriptions of the feature bits that correspond to these messages, see “Window Feature Bits”. Other messages are reserved for internal use by the system.*/

enum {
   kWindowMsgDraw = 0,
   kWindowMsgHitTest = 1,
   kWindowMsgCalculateShape = 2,
   kWindowMsgInitialize = 3,
   kWindowMsgCleanUp = 4,
   kWindowMsgDrawGrowOutline = 5,
   kWindowMsgDrawGrowBox = 6
};
enum {
   kWindowMsgGetFeatures = 7,
   kWindowMsgGetRegion = 8
};
enum {
   kWindowMsgDragHilite = 9,
   kWindowMsgModified = 10,
   kWindowMsgDrawInCurrentPort = 11,
   kWindowMsgSetupProxyDragImage = 12,
   kWindowMsgStateChanged = 13,
   kWindowMsgMeasureTitle = 14
};
enum {
   kWindowMsgGetGrowImageRegion = 19
};




/*Window Definition Type Constants

Defines the type of custom window definition.

typedef UInt32 WindowDefType;
enum {
   kWindowDefProcPtr = 0,
   kWindowDefObjectClass = 1,
   kWindowDefProcID = 2,
   kWindowDefHIView = 3
};
Constants
kWindowDefProcPtr

The definition is procedure pointer–based.

Available in Mac OS X v10.0 and later.
kWindowDefObjectClass

The definition is a toolbox object. 

Available in Mac OS X v10.0 and later.
kWindowDefProcID

An ID that identifies a particular ‘WDEF’ and would typically be one of the constants described in “Appearance-Compliant Window Definition ID Constants”.

Available in Mac OS X v10.0 and later.
kWindowDefHIView

The definition is an HIView-based object. 

Available in Mac OS X v10.2 and later.*/
typedef UInt32 WindowDefType;
enum {
   kWindowDefProcPtr = 0,
   kWindowDefObjectClass = 1,
   kWindowDefProcID = 2,
   kWindowDefHIView = 3
};

/*Window Group Attributes

Define attributes for window groups. 

typedef UInt32 WindowGroupAttributes;
enum {
   kWindowGroupAttrSelectAsLayer = 1 << 0,
   kWindowGroupAttrMoveTogether = 1 << 1,
   kWindowGroupAttrLayerTogether = 1 << 2,
   kWindowGroupAttrSharedActivation = 1 << 3,
   kWindowGroupAttrHideOnCollapse = 1 << 4,
   kWindowGroupAttrFixedLevel = 1 << 5
};
Constants
kWindowGroupAttrSelectAsLayer

Makes the group behave somewhat as a layer of windows that move together. When any window in the group is brought to the front of the group, the entire group will also be brought to the front of the containing group’s child hierarchy. Use of this constant is not recommended; its behavior is rarely useful.

Available in Mac OS X v10.1 and later.
kWindowGroupAttrMoveTogether

The positions of the contents of this group with respect to each other cannot be changed. When one item moves, all other items are moved simultaneously.

Available in Mac OS X v10.1 and later.
kWindowGroupAttrLayerTogether

The z-order of the contents of this group with respect to each other cannot be changed. When one item changes z-order, all other items are moved simultaneously. For purposes of z-ordering, the group and all its subgroups are effectively treated as if they were a single window in the parent group of this group.

Available in Mac OS X v10.1 and later.
kWindowGroupAttrSharedActivation

The active state of the windows in this group is shared. The windows in the group are activated or deactivated according to the activation scope of the group, but when any window in the group changes activation, all other windows change to match.

Available in Mac OS X v10.0 and later.
kWindowGroupAttrHideOnCollapse

When any window in this group is collapsed, all other windows in this group are hidden. All subgroups of this group are also examined for this attribute, and any the windows of any subgroup with this attribute are also hidden. All windows will be shown again when the collapsed window is expanded.

Available in Mac OS X v10.1 and later.
kWindowGroupAttrFixedLevel

If this attribute is specified, this window group’s window level should be left unchanged. If this attribute is not specified, this window group’s window level will be promoted to a value equal to the level of the next fixed-level window group beneath it in the window group hierarchy. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
Version Notes

In Mac OS X v10.2.4 and later, the HIToolbox framework improved its use of the window group API so that showing a sheet on a window that was already grouped with another window would not break the existing grouping. To make this change work properly, applications that create their own window groups using the kWindowGroupAttrMoveTogether and kWindowGroupAttrLayerTogether attributes should also specify the kWindowGroupAttrHideOnCollapse and kWindowGroupAttrSharedActivation attributes.*/

typedef UInt32 WindowGroupAttributes;
enum {
   kWindowGroupAttrSelectAsLayer = 1 << 0,
   kWindowGroupAttrMoveTogether = 1 << 1,
   kWindowGroupAttrLayerTogether = 1 << 2,
   kWindowGroupAttrSharedActivation = 1 << 3,
   kWindowGroupAttrHideOnCollapse = 1 << 4,
   kWindowGroupAttrFixedLevel = 1 << 5
};

/*Window Kinds

Identify how a window was created.

enum {
   dialogKind = 2,
   userKind = 8,
   kDialogWindowKind = 2,
   kApplicationWindowKind = 8
};
Constants
dialogKind

Obsolete equivalent to kDialogWindowKind.

Available in Mac OS X v10.0 and later.
userKind

Obsolete equivalent to kApplicationWindowKind.

Available in Mac OS X v10.0 and later.
kDialogWindowKind

Identifies all dialog or alert windows, whether created by system software or, indirectly through the Dialog Manager, by your application. The Dialog Manager uses this field to track dialog and alert windows.

Available in Mac OS X v10.0 and later.
kApplicationWindowKind

Identifies a window created directly by your application.

Available in Mac OS X v10.0 and later.
Discussion

The Window Manager uses these constants in the windowKind field of a color window structure or window structure. Your application can use any value greater than 7.*/
enum {
   dialogKind = 2,
   userKind = 8,
   kDialogWindowKind = 2,
   kApplicationWindowKind = 8
};



/*WindowGroupRef

Represents a window group. 

typedef struct OpaqueWindowGroupRef * WindowGroupRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueWindowGroupRef * WindowGroupRef;


/*Table A-2 lists functions that are unsupported in Carbon and Mac OS X. 
Table A-2  Unsupported functions
Name 	
Porting Notes

CloseWindow	
The CloseWindow function is not supported because developers do not allocate their own memory for windows in Carbon. Use the DisposeWindow function to remove a window instead.

DrawNew	
Use ReshapeCustomWindow instead.

DisposeDeskHookUPP	
You cannot access the DeskHook global variable in Carbon. Therefore, Carbon does not support application-defined functions for drawing the desktop.

draggrayrgn	
Use DragGrayRgn instead.

dragwindow	
Use DragWindow instead.

findwindow	
Use FindWindow instead.

GetAuxWin	
Remove application reliance on AuxWinRec data structures; in the future, the information in these structures may be invalid or unavailable to applications.

GetWindowSpareFlag	
Use GetWindowAttributes instead.

GetCWMgrPort	
Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.

GetWMgrPort	
Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.

GetWindowContentRgn	
Use the GetWindowRegion function with the kWindowContentRgn selector instead.

GetWindowGoAwayFlag	
Use GetWindowAttributes instead.

GetWindowControlList	
Accessing the window control list is not supported in Carbon. Use the Control Manager's control embedding hierarchy functions (CreateRootControl, GetRootControl, EmbedControl, AutoEmbedControl, GetSuperControl, GetIndexedSubControl, and SetControlSupervisor) to determine control ordering instead.

GetWindowDataHandle	


GetWindowStructureRgn	
Use the GetWindowRegion function with the kWindowStructureRgn selector instead.

GetWindowTitleWidth	


GetWindowUpdateRgn	
Use the GetWindowRegion function with the kWindowUpdateRgn selector instead.

GetWindowZoomFlag	
You should instead call the function GetWindowAttributes and check the kWindowHorizontalZoomAttribute or kWindowVerticalZoomAttribute attributes.

getwtitle	
Use CopyWindowTitleAsCFString instead.

growwindow	
Use ResizeWindow instead.

InitWindows	
InitWindows is not supported in Carbon. There is no need to initialize the Window Manager because the shared library is loaded as needed.

InitFloatingWindows	
There is no need to initialize this Window Manager functionality because the shared library is loaded as needed.

InvalRect	
Calls InvalWindowRect, which takes a window pointer as an additional parameter.Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.

InvalRgn	
Calls InvalWindowRgn, which takes a window pointer as an additional parameter. Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.

InvokeDeskHookUPP	
You cannot access the DeskHook global variable in Carbon. Therefore, Carbon does not support application-defined functions for drawing the desktop.

newcwindow	
Use NewCWindow instead.

NewDeskHookUPP	
You cannot access the DeskHook global variable in Carbon. Therefore, Carbon does not support application-defined functions for drawing the desktop.

newwindow	
Use NewCWindow instead. 

pinrect	
Use PinRect instead.

SaveOld	
SaveOld is not available in Carbon. Use ReshapeCustomWindow instead.

SetDeskCPat	
You can no longer affect the desktop under Carbon, so SetDeskCPat has been removed from Carbon. There is no replacement function.

SetWinColor	
Use SetWindowContentColor.

SetWindowControlList	
Accessing the window control list is not supported in Carbon. Use the Control Manager's control embedding hierarchy functions (CreateRootControl, GetRootControl, EmbedControl, AutoEmbedControl, GetSuperControl, GetIndexedSubControl, and SetControlSupervisor) to determine control ordering instead

SetWindowDataHandle	


setwtitle	
Use SetWTitle or SetWindowTitleWithCFString instead. 

trackbox	
Use TrackBox instead.

trackgoaway	
Use TrackGoAway instead.

ValidRect	
Calls ValidWindowRect, which takes a window pointer as an additional parameter. Validation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.

ValidRgn	
Calls ValidWindowRgn, which takes a window pointer as an additional parameter. Validation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary./
//#define  CloseWindow DisposeWindow
//#define DrawNew	 ReshapeCustomWindow 
//#define draggrayrgn	  DragGrayRgn 
//#define dragwindow	 DragWindow 
//#define findwindow	 FindWindow 
//#define GetWindowSpareFlag	 GetWindowAttributes 
//#define GetWindowContentRgn	  kWindowContentRgn 
//#define GetWindowGoAwayFlag	 GetWindowAttributes
//#define GetWindowStructureRgn	kWindowStructureRgn 
//#define GetWindowUpdateRgn	  kWindowUpdateRgn
//#define GetWindowZoomFlag	GetWindowAttributes 
//#define getwtitle	CopyWindowTitleAsCFString 
//#define growwindow	 ResizeWindow 
//#define newcwindow	 NewCWindow 
//#define newwindow	 NewCWindow 
//#define pinrect	 PinRect 
//#define SaveOld	 ReshapeCustomWindow 
//#define SetWinColor	 SetWindowContentColor
//#define setwtitle	SetWTitle
// or SetWindowTitleWithCFString instead. 
//#define trackbox	 TrackBox 
//#define trackgoaway	 TrackGoAway

/*Table A-1  Deprecated functions
Name 	
Porting Notes

CalcVis	
If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead.

CalcVisBehind	
If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead.

CheckUpdate	
Generally not required. If you need to check for an update event, you can call the Carbon Event Manager function IsEventInQueue or FindSpecificEventInQueue.

ClipAbove	
If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead.

DragGrayRgn	
Can’t be used for live dragging. If you are implementing your own window dragging, use DragWindow instead. If you need to override window positioning during a drag, register a Carbon event handler for kEventWindowBoundsChanging. Okay to use if you’re dragging objects within a window. 

DragTheRgn	
Can’t be used for live dragging. If you are implementing your own window dragging, use DragWindow instead. If you need to override window positioning during a drag, register a Carbon event handler for kEventWindowBoundsChanging. Okay to use if you’re dragging objects within a window. 

DrawGrowIcon	
Obsolete in Carbon and should not be used.

GetGrayRgn	
Use GetAvailableWindowPositioningBounds if you want to determine where you can position your windows.

GetNewCWindow	
If you must get your window definition from a resource, use CreateWindowFromResource. Otherwise use CreateWindowFromNib or CreateNewWindow. 

GetNewWindow	
If you must get your window definition from a resource, use CreateWindowFromResource. Otherwise use CreateWindowFromNib or CreateNewWindow. 

GetWindowProxyFSSpec	
Use of file specifications is no longer recommended. Instead, use HIWindowGetProxyFSRef.

GetWTitle	
Use CopyWindowTitleAsCFString instead.

GetWVariant	
Use GetWindowAttributes instead.

GrowWindow	
Use ResizeWindow instead.

HiliteWindow	
If available, use the ActivateWindow function instead.

NewCWindow	
You should use CreateNewWindow instead.However, if you are still using the NewCWindow function in Carbon, note that you cannot pass your own storage in to the wStorage parameter.

NewWindow	
Use CreateNewWindow instead.In Carbon, you cannot pass your own storage in to the Storage parameter. In Carbon, NewWindow is functionally equivalent to the NewCWindow, in that NewWindow returns a color window instead of a monochrome window.Carbon does not support custom window definitions stored in 'WDEF' resources. If you want to specify a custom window definition for NewWindow, you must compile your definition function directly in your application and then register the function by calling RegisterWindowDefinition. When NewWindow gets a procID value that doesn't recognize, it checks a special mapping table to find the pointer that's registered for the resource ID embedded in the procID parameter. It then calls that function to implement your window. 

PaintOne	
If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead. 

PaintBehind	
If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead. 

SetWindowProxyFSSpec	
Use of file specifications is no longer recommended. Instead, use HIWindowSetProxyFSRef.

SetWTitle	
Use SetWindowTitleWithCFString instead.

ShowHide	
Use ShowWindow or HideWindow instead.*/

//#define CheckUpdate	IsEventInQueue
 // or FindSpecificEventInQueue.
//#define  GetGrayRgn	 GetAvailableWindowPositioningBound
//#define GetNewCWindow	  CreateWindowFromResource
//#define GetNewWindow	CreateWindowFromResource
//#define GetWindowProxyFSSpec	HIWindowGetProxyFSRef
#define GetWTitle	CopyWindowTitleAsCFString
//#define GetWVariant	 GetWindowAttributes
//#define GrowWindow	ResizeWindow 
//#define HiliteWindow	ActivateWindow
//#define NewCWindow	CreateNewWindow
//#define SetWindowProxyFSSpec	HIWindowSetProxyFSRef
#define SetWTitle	SetWindowTitleWithCFString
//#define ShowHide	ShowWindow 
//or HideWindow 

/*PropertyTag

Defines a window property tag. 

typedef OSType PropertyTag;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType PropertyTag;

/*PropertyCreator

Defines the creator of a window property. 

typedef OSType PropertyCreator;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType PropertyCreator;

/*Appearance-Compliant Window Definition ID Constants

Define different window kinds. 

enum {
   kWindowDocumentProc = 1024,
   kWindowGrowDocumentProc = 1025,
   kWindowVertZoomDocumentProc = 1026,
   kWindowVertZoomGrowDocumentProc = 1027,
   kWindowHorizZoomDocumentProc = 1028,
   kWindowHorizZoomGrowDocumentProc = 1029,
   kWindowFullZoomDocumentProc = 1030,
   kWindowFullZoomGrowDocumentProc = 1031
};
enum {
   kWindowPlainDialogProc = 1040,
   kWindowShadowDialogProc = 1041,
   kWindowModalDialogProc = 1042,
   kWindowMovableModalDialogProc = 1043,
   kWindowAlertProc = 1044,
   kWindowMovableAlertProc = 1045
};
enum {
   kWindowMovableModalGrowProc = 1046
};
enum {
   kWindowFloatProc = 1057,
   kWindowFloatGrowProc = 1059,
   kWindowFloatVertZoomProc = 1061,
   kWindowFloatVertZoomGrowProc = 1063,
   kWindowFloatHorizZoomProc = 1065,
   kWindowFloatHorizZoomGrowProc = 1067,
   kWindowFloatFullZoomProc = 1069,
   kWindowFloatFullZoomGrowProc = 1071
};
enum {
   kWindowFloatSideProc = 1073,
   kWindowFloatSideGrowProc = 1075,
   kWindowFloatSideVertZoomProc = 1077,
   kWindowFloatSideVertZoomGrowProc = 1079,
   kWindowFloatSideHorizZoomProc = 1081,
   kWindowFloatSideHorizZoomGrowProc = 1083,
   kWindowFloatSideFullZoomProc = 1085,
   kWindowFloatSideFullZoomGrowProc = 1087
};
enum {
   kWindowSheetProc = 1088,
   kWindowSheetAlertProc = 1120
};
enum {
   kWindowSimpleProc = 1104,
   kWindowSimpleFrameProc = 1105
};
Constants
kWindowDocumentProc

Appearance-compliant movable window with no size box or zoom box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is noGrowDocProc.

Available in Mac OS X v10.0 and later.
kWindowGrowDocumentProc

Appearance-compliant standard document window (movable window with size box). Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is documentProc.

Available in Mac OS X v10.0 and later.
kWindowVertZoomDocumentProc

Appearance-compliant window with vertical zoom box and no size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowVertZoomGrowDocumentProc

Appearance-compliant window with vertical zoom box and size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowHorizZoomDocumentProc

Appearance-compliant window with horizontal zoom box and no size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowHorizZoomGrowDocumentProc

Appearance-compliant window with horizontal zoom box and size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFullZoomDocumentProc

Appearance-compliant window with full zoom box and no size box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is zoomNoGrow.

Available in Mac OS X v10.0 and later.
kWindowFullZoomGrowDocumentProc

Appearance-compliant window with full zoom box and size box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is zoomDocProc.

Available in Mac OS X v10.0 and later.
kWindowPlainDialogProc

Appearance-compliant modeless dialog box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is plainDBox.

Available in Mac OS X v10.0 and later.
kWindowShadowDialogProc

Appearance-compliant modeless dialog box with shadow. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is altDBoxProc.

Available in Mac OS X v10.0 and later.
kWindowModalDialogProc

Appearance-compliant modal dialog box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is dBoxProc.

Available in Mac OS X v10.0 and later.
kWindowMovableModalDialogProc

Appearance-compliant movable modal dialog box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is movableDBoxProc.

Available in Mac OS X v10.0 and later.
kWindowAlertProc

Appearance-compliant alert box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowMovableAlertProc

Appearance-compliant movable alert box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowMovableModalGrowProc

Appearance-compliant movable modal dialog box with size box. Available with Appearance 1.0.1 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatProc

Appearance-compliant utility (floating) window with no size box or zoom box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatProc.

Available in Mac OS X v10.0 and later.
kWindowFloatGrowProc

Appearance-compliant utility (floating) window with a size box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatGrowProc.

Available in Mac OS X v10.0 and later.
kWindowFloatVertZoomProc

Appearance-compliant utility (floating) window with a vertical zoom box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatVertZoomGrowProc

Appearance-compliant utility (floating) window with a vertical zoom box and size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatHorizZoomProc

Appearance-compliant utility (floating) window with a horizontal zoom box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatHorizZoomGrowProc

Appearance-compliant utility (floating) window with a horizontal zoom box and size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatFullZoomProc

Appearance-compliant utility (floating) window with full zoom box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatZoomProc.

Available in Mac OS X v10.0 and later.
kWindowFloatFullZoomGrowProc

Appearance-compliant utility (floating) window with full zoom box and size box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatZoomGrowProc.

Available in Mac OS X v10.0 and later.
kWindowFloatSideProc

Appearance-compliant utility (floating) window with side title bar. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatSideProc.

Available in Mac OS X v10.0 and later.
kWindowFloatSideGrowProc

Appearance-compliant utility (floating) window with side title bar and size box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatSideGrowProc.

Available in Mac OS X v10.0 and later.
kWindowFloatSideVertZoomProc

Appearance-compliant utility (floating) window with side title bar and vertical zoom box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatSideVertZoomGrowProc

Appearance-compliant utility (floating) window with side title bar, vertical zoom box, and size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatSideHorizZoomProc

Appearance-compliant utility (floating) window with side title bar and horizontal zoom box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatSideHorizZoomGrowProc

Appearance-compliant utility (floating) window with side title bar, horizontal zoom box, and size box. Available with Appearance 1.0 and later. There is no corresponding pre-Appearance window definition ID.

Available in Mac OS X v10.0 and later.
kWindowFloatSideFullZoomProc

Appearance-compliant utility (floating) window with side title bar and full zoom box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatSideZoomProc.

Available in Mac OS X v10.0 and later.
kWindowFloatSideFullZoomGrowProc

Appearance-compliant utility (floating) window with side title bar, full zoom box, and size box. Available with Appearance 1.0 and later. The corresponding pre-Appearance window definition ID is floatSideZoomGrowProc.

Available in Mac OS X v10.0 and later.
kWindowSheetProc

A standard document sheet.

Available in Mac OS X v10.0 and later.
kWindowSheetAlertProc

An alert sheet. 

Available in Mac OS X v10.1 and later.
kWindowSimpleProc

A window that has no structure region; the content covers the entire window. 

Available in Mac OS X v10.0 and later.
kWindowSimpleFrameProc

A window that has a 1-pixel black frame as its structure. 

Available in Mac OS X v10.0 and later.*/

enum {
   kWindowDocumentProc = 1024,
   kWindowGrowDocumentProc = 1025,
   kWindowVertZoomDocumentProc = 1026,
   kWindowVertZoomGrowDocumentProc = 1027,
   kWindowHorizZoomDocumentProc = 1028,
   kWindowHorizZoomGrowDocumentProc = 1029,
   kWindowFullZoomDocumentProc = 1030,
   kWindowFullZoomGrowDocumentProc = 1031
};
enum {
   kWindowPlainDialogProc = 1040,
   kWindowShadowDialogProc = 1041,
   kWindowModalDialogProc = 1042,
   kWindowMovableModalDialogProc = 1043,
   kWindowAlertProc = 1044,
   kWindowMovableAlertProc = 1045
};
enum {
   kWindowMovableModalGrowProc = 1046
};
enum {
   kWindowFloatProc = 1057,
   kWindowFloatGrowProc = 1059,
   kWindowFloatVertZoomProc = 1061,
   kWindowFloatVertZoomGrowProc = 1063,
   kWindowFloatHorizZoomProc = 1065,
   kWindowFloatHorizZoomGrowProc = 1067,
   kWindowFloatFullZoomProc = 1069,
   kWindowFloatFullZoomGrowProc = 1071
};
enum {
   kWindowFloatSideProc = 1073,
   kWindowFloatSideGrowProc = 1075,
   kWindowFloatSideVertZoomProc = 1077,
   kWindowFloatSideVertZoomGrowProc = 1079,
   kWindowFloatSideHorizZoomProc = 1081,
   kWindowFloatSideHorizZoomGrowProc = 1083,
   kWindowFloatSideFullZoomProc = 1085,
   kWindowFloatSideFullZoomGrowProc = 1087
};
enum {
   kWindowSheetProc = 1088,
   kWindowSheetAlertProc = 1120
};
enum {
   kWindowSimpleProc = 1104,
   kWindowSimpleFrameProc = 1105
};

/*Window Part Code Constants

Indicate which part of the window was hit. 

typedef SInt16 WindowPartCode;
enum {
   inDesk = 0,
   inNoWindow = 0,
   inMenuBar = 1,
   inSysWindow = 2,
   inContent = 3,
   inDrag = 4,
   inGrow = 5,
   inGoAway = 6,
   inZoomIn = 7,
   inZoomOut = 8,
   inCollapseBox = 11,
   inProxyIcon = 12,
   inToolbarButton = 13,
   inStructure = 15
};
Constants
inDesk

The cursor is in the desktop region, not in the menu bar, a driver window, or any window that belongs to your application. When FindWindow returns inDesk, your application doesn’t need to do anything.

Available in Mac OS X v10.0 and later.
inNoWindow

The cursor is not in a window. 

Available in Mac OS X v10.0 and later.
inMenuBar

The user has pressed the mouse button while the cursor is in the menu bar. When FindWindow returns inMenuBar, your application typically adjusts its menus and then calls the Menu Manager function MenuSelect to let the user choose menu items.

Available in Mac OS X v10.0 and later.
inSysWindow

Not supported by Carbon.

Available in Mac OS X v10.0 and later.
inContent

The user has pressed the mouse button while the cursor is in the content area (excluding the size box in an active window) of one of your application’s windows. When FindWindow returns inContent, your application determines how to handle clicks in the content region.

Available in Mac OS X v10.0 and later.
inDrag

The user has pressed the mouse button while the cursor is in the drag region of a window. When FindWindow returns inDrag, your application typically calls DragWindow to let the user drag the window to a new location. 

Available in Mac OS X v10.0 and later.
inGrow

The user has pressed the mouse button while the cursor is in an active window’s size box. When FindWindow returns inGrow, your application typically calls ResizeWindow.

Available in Mac OS X v10.0 and later.
inGoAway

The user has pressed the mouse button while the cursor is in an active window’s close box. When FindWindow returns inGoAway, your application typically callsTrackGoAway to track mouse activity while the button is down and then calls its own function for closing a window if the user releases the button while the cursor is in the close box.

Available in Mac OS X v10.0 and later.
inZoomIn

The user has pressed the mouse button while the cursor is in the zoom box of an active window that is currently in the standard state. When FindWindow returns inZoomIn, your application typically calls TrackBox to track mouse activity while the button is down and then calls its own function for zooming a window if the user releases the button while the cursor is in the zoom box.

Available in Mac OS X v10.0 and later.
inZoomOut

The user has pressed the mouse button while the cursor is in the zoom box of an active window that is currently in the user state. When FindWindow returns inZoomOut, your application typically calls the function TrackBox to track mouse activity while the button is down. Your application then calls its own function for zooming a window if the user releases the button while the cursor is in the zoom box.

Available in Mac OS X v10.0 and later.
inCollapseBox

The user has pressed the mouse button while the cursor is in an active window’s collapse box. When FindWindow returns inCollapseBox, your application typically does nothing, because the system will collapse your window for you.

Available in Mac OS X v10.0 and later.
inProxyIcon

The user has pressed the mouse button while the cursor is in the proxy icon of a window. When FindWindow returns inProxyIcon, your application typically calls the function TrackWindowProxyDrag. 

Available in Mac OS X v10.0 and later.
inToolbarButton

The user has pressed the mouse button while the cursor is in the toolbar button. (Mac OS X only.)

Available in Mac OS X v10.1 and later.
inStructure

The user has pressed the mouse button while the cursor is in the window’s structure region. (Available on Mac OS X v10.1 and later.)

Available in Mac OS X v10.1 and later.
Discussion

When your application receives a mouse-down event, you typically call FindWindow, which returns an integer that specifies the location, in global coordinates, of the cursor at the time the user pressed the mouse button.*/

typedef SInt16 WindowPartCode;
enum {
   inDesk = 0,
   inNoWindow = 0,
   inMenuBar = 1,
   inSysWindow = 2,
   inContent = 3,
   inDrag = 4,
   inGrow = 5,
   inGoAway = 6,
   inZoomIn = 7,
   inZoomOut = 8,
   inCollapseBox = 11,
   inProxyIcon = 12,
   inToolbarButton = 13,
   inStructure = 15
};



/*Redefined API Names

Some names defined in the Macintosh application programming interfaces conflict with identical names in the Windows API. In these cases, the QTML header file QTMLMapNames.h avoids these conflicts by redefining the affected names with the prefix Mac added.

In Table 2-2, names listed in the first column refer to the original Macintosh function or data structure name; the second column gives the redefined or newly mapped names.
Table 3-1  Redefined API names
Original Macintosh API name	
Mapped name

AnimatePalette	
MacAnimatePalette

AppendMenu	
MacAppendMenu

CloseDriver	
MacCloseDriver

CloseWindow	
MacCloseWindow

CompareString	
MacCompareString

CopyRgn	
MacCopyRgn

DeleteMenu	
MacDeleteMenu

DrawMenuBar	
MacDrawMenuBar

DrawText	
MacDrawText

EqualRect	
MacEqualRect

EqualRgn	
MacEqualRgn

FillRect	
MacFillRect

FillRgn	
MacFillRgn

FindWindow	
MacFindWindow

FlushInstructionCache	
MacFlushInstructionCache

FrameRect	
MacFrameRect

FrameRgn	
MacFrameRgn

GetClassInfo	
MacGetClassInfo

GetCurrentThread	
MacGetCurrentThread

GetCursor	
MacGetCursor

GetDoubleClickTime	
MacGetDoubleClickTime

GetFileSize	
MacGetFileSize

GetItem	
MacGetItem

GetMenu	
MacGetMenu

GetNextWindow	
MacGetNextWindow

GetParent	
MacGetParent

GetPath	
MacGetPath

GetPixel	
MacGetPixel

InsertMenu	
MacInsertMenu

InsertMenuItem	
MacInsertMenuItem

InsetRect	
MacInsetRect

InvertRect	
MacInvertRect

InvertRgn	
MacInvertRgn

IsWindowVisible	
MacIsWindowVisible

LineTo	
MacLineTo

LoadResource	
MacLoadResource

MoveWindow	
MacMoveWindow

OffsetRect	
MacOffsetRect

OffsetRgn	
MacOffsetRgn

OpenDriver	
MacOpenDriver

PaintRgn	
MacPaintRgn

Polygon	
MacPolygon

PtInRect	
MacPtInRect

Region	
MacRegion

ReplaceText	
MacReplaceText

ResizePalette	
MacResizePalette

SendMessage	
MacSendMessage

SetCursor	
MacSetCursor

SetItem	
MacSetItem

SetPort	
MacSetPort

SetRect	
MacSetRect

SetRectRgn	
MacSetRectRgn

ShowCursor	
MacShowCursor

ShowWindow	
MacShowWindow

StartSound	
MacStartSound

StopSound	
MacStopSound

TokenType	
MacTokenType

UnionRect	
MacUnionRect

UnionRgn	
MacUnionRgn

XorRgn	
MacXorRgn*/

#define MacIsWindowVisible IsWindowVisible
#define MacShowWindow  ShowWindow
#define MacFindWindow FindWindow
/*Pre-Appearance Window Definition IDs

Older window definitions IDs used before the introduction of the Appearance Manager. 

enum {
   documentProc = 0,
   dBoxProc = 1,
   plainDBox = 2,
   altDBoxProc = 3,
   noGrowDocProc = 4,
   movableDBoxProc = 5,
   zoomDocProc = 8,
   zoomNoGrow = 12,
   rDocProc = 16,
   floatProc = 1985,
   floatGrowProc = 1987,
   floatZoomProc = 1989,
   floatZoomGrowProc = 1991,
   floatSideProc = 1993,
   floatSideGrowProc = 1995,
   floatSideZoomProc = 1997,
   floatSideZoomGrowProc = 1999
};
Constants
documentProc

Pre-Appearance document window (movable window with size box).

Available in Mac OS X v10.0 and later.
dBoxProc

Pre-Appearance modal dialog box.

Available in Mac OS X v10.0 and later.
plainDBox

Pre-Appearance modeless dialog box.

Available in Mac OS X v10.0 and later.
altDBoxProc

Pre-Appearance modeless dialog box with shadow.

Available in Mac OS X v10.0 and later.
noGrowDocProc

Pre-Appearance movable window with no size box or zoom box.

Available in Mac OS X v10.0 and later.
movableDBoxProc

Pre-Appearance movable modal dialog box.

Available in Mac OS X v10.0 and later.
zoomDocProc

Pre-Appearance movable window with size box and full zoom box.

Available in Mac OS X v10.0 and later.
zoomNoGrow

Pre-Appearance window with full zoom box and no size box.

Available in Mac OS X v10.0 and later.
rDocProc

Pre-Appearance rounded-corner window. You can control the diameter of curvature of a rounded-corner window (window type rDocProc) by adding one of these integers to the rDocProc constant:

rDocProc (diameters of curvature: 16, 16)

rDocProc + 2 (diameters of curvature: 4, 4)

rDocProc + 4 (diameters of curvature: 6, 6)

rDocProc + 6 (diameters of curvature: 10, 10)

Available in Mac OS X v10.0 and later.
floatProc

Pre-Appearance utility (floating) window with no size box or zoom box.

Available in Mac OS X v10.0 and later.
floatGrowProc

Pre-Appearance utility (floating) window with size box.

Available in Mac OS X v10.0 and later.
floatZoomProc

Pre-Appearance utility (floating) window with zoom box.

Available in Mac OS X v10.0 and later.
floatZoomGrowProc

Pre-Appearance utility (floating) window with size box and zoom box.

Available in Mac OS X v10.0 and later.
floatSideProc

Pre-Appearance utility (floating) window with side title bar and no size or zoom box.

Available in Mac OS X v10.0 and later.
floatSideGrowProc

Pre-Appearance utility (floating) window with side title bar and size box.

Available in Mac OS X v10.0 and later.
floatSideZoomProc

Pre-Appearance utility (floating) window with side title bar and zoom box.

Available in Mac OS X v10.0 and later.
floatSideZoomGrowProc

Pre-Appearance utility (floating) window with side title bar, size box, and zoom box.

Available in Mac OS X v10.0 and later.
Discussion

Note that window definition IDs are changed with Appearance Manager 1.0. The Window Manager now provides many new, standard, Appearance-compliant window types. See Inside Mac OS X: Window Manager Reference for more information. 

Your application typically supplies a window definition ID to a resource of type ‘WIND’ or to a window-creation function to specify which window definition function to use in creating the window. A variation code may also be used to describe variations of the same basic window.

The window definition ID is an integer that contains the resource ID of the window definition function in its upper 12 bits and a variation code in its lower 4 bits. For a given resource ID and variation code, the window definition ID is derived as follows: window definition ID = (16 x resource ID) + variation code. 

The window definition IDs for dialog boxes and utility (floating) windows pertain to the appearances of these windows only, not their behaviors. For example, if you want a utility window to have the proper behavior, that is, float, your application must provide for it. 

When mapping is enabled, standard pre-Appearance window definition function IDs will be mapped to their Appearance-compliant equivalents.*/
enum {
   documentProc = 0,
   dBoxProc = 1,
   plainDBox = 2,
   altDBoxProc = 3,
   noGrowDocProc = 4,
   movableDBoxProc = 5,
   zoomDocProc = 8,
   zoomNoGrow = 12,
   rDocProc = 16,
   floatProc = 1985,
   floatGrowProc = 1987,
   floatZoomProc = 1989,
   floatZoomGrowProc = 1991,
   floatSideProc = 1993,
   floatSideGrowProc = 1995,
   floatSideZoomProc = 1997,
   floatSideZoomGrowProc = 1999
};

/*System 7 Window Positioning Constants

Define window positioning constants used in 'WIND', 'DLOG', or 'ALRT' resources, as well as the StandardAlert function. 

enum {
   kWindowNoPosition = 0x0000,
   kWindowDefaultPosition = 0x0000,
   kWindowCenterMainScreen = 0x280A,
   kWindowAlertPositionMainScreen = 0x300A,
   kWindowStaggerMainScreen = 0x380A,
   kWindowCenterParentWindow = 0xA80A,
   kWindowAlertPositionParentWindow = 0xB00A,
   kWindowStaggerParentWindow = 0xB80A,
   kWindowCenterParentWindowScreen = 0x680A,
   kWindowAlertPositionParentWindowScreen = 0x700A,
   kWindowStaggerParentWindowScreen = 0x780A
};
Constants
kWindowNoPosition

No position.

Available in Mac OS X v10.0 and later.
kWindowDefaultPosition

Use the initial location.

Available in Mac OS X v10.0 and later.
kWindowCenterMainScreen

Center the window on the main screen.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionMainScreen

Place the window in the alert position on the main screen.

Available in Mac OS X v10.0 and later.
kWindowStaggerMainScreen

Stagger the window on the main screen.

Available in Mac OS X v10.0 and later.
kWindowCenterParentWindow

Center the window on the parent window.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionParentWindow

Place the window in the alert position on the parent window.

Available in Mac OS X v10.0 and later.
kWindowStaggerParentWindow

Stagger the window relative to the parent window.

Available in Mac OS X v10.0 and later.
kWindowCenterParentWindowScreen

Center the window on the parent window screen.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionParentWindowScreen

Place the window in the alert position on the parent window screen.

Available in Mac OS X v10.0 and later.
kWindowStaggerParentWindowScreen

Stagger the window on the parent window screen.

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants in the optional positioning specification field of the window resource and in the dialog resource to override the window position established by the rectangle specified for the window or dialog. These positioning constants are convenient when the user is creating new documents or when you are handling your own dialog boxes and alert boxes. 

These constants are passed into the StandardAlert function and are used in' WIND', 'DLOG’, and 'ALRT' templates. StandardAlert uses zero to specify the default position. Other calls use zero to specify “no position”. 

Do not pass these constants to theRepositionWindow function or store these constants in the BasicWindowDescription structure of a 'WIND' resource. 

The meaning of the terms used in the window positioning constant descriptions are as follows:
center

Centered both horizontally and vertically, relative either to a screen or to another window (if a window to be centered relative to another window is wider than the window that preceded it, it is pinned to the left edge; a narrower window is centered) 
stagger

Located 20 pixels to the right and 20 pixels below the upper-left corner of the last window (in the case of staggering relative to a screen, the first window is placed just below the menu bar at the left edge of the screen, and subsequent windows are placed on that screen relative to the first window)
alert position

Centered horizontally and placed in the “alert position” vertically, that is, with about one-fifth of the window or screen above the new window and the rest below 
parent window

Place in the position of the window in which the user was last working based on the frontmost window before the new window comes up.*/
enum {
   kWindowNoPosition = 0x0000,
   kWindowDefaultPosition = 0x0000,
   kWindowCenterMainScreen = 0x280A,
   kWindowAlertPositionMainScreen = 0x300A,
   kWindowStaggerMainScreen = 0x380A,
   kWindowCenterParentWindow = 0xA80A,
   kWindowAlertPositionParentWindow = 0xB00A,
   kWindowStaggerParentWindow = 0xB80A,
   kWindowCenterParentWindowScreen = 0x680A,
   kWindowAlertPositionParentWindowScreen = 0x700A,
   kWindowStaggerParentWindowScreen = 0x780A
};


/*Window Position Constants

Define where to place a window.

typedef UInt32 WindowPositionMethod;
enum {
   kWindowCenterOnMainScreen = 1,
   kWindowCenterOnParentWindow = 2,
   kWindowCenterOnParentWindowScreen = 3,
   kWindowCascadeOnMainScreen = 4,
   kWindowCascadeOnParentWindow = 5,
   kWindowCascadeOnParentWindowScreen = 6,
   kWindowCascadeStartAtParentWindowScreen = 10,
   kWindowAlertPositionOnMainScreen = 7,
   kWindowAlertPositionOnParentWindow = 8,
   kWindowAlertPositionOnParentWindowScreen = 9
};
Constants
kWindowCenterOnMainScreen

Center the window, both horizontally and vertically, on the screen that contains the menu bar.

Available in Mac OS X v10.0 and later.
kWindowCenterOnParentWindow

Center the window, both horizontally and vertically, on the parent window. If the window to be centered is wider than the parent window, its left edge is aligned with the parent window’s left edge. 

Available in Mac OS X v10.0 and later.
kWindowCenterOnParentWindowScreen

Center the window, both horizontally and vertically, on the screen containing the parent window. On Mac OS X v10.3 and later, the parent window may be the same as the positioned window. On CarbonLib and earlier versions of Mac OS X, the parent window must be different from the positioned window.

Available in Mac OS X v10.0 and later.
kWindowCascadeOnMainScreen

Place the window just below the menu bar at the left edge of the main screen. Subsequent windows are placed on the screen relative to the first window, such that the frame of the preceding window remains visible behind the current window. The exact amount by which windows are offset depends upon the dimensions of the window frame under a given appearance.

Available in Mac OS X v10.0 and later.
kWindowCascadeOnParentWindow

Place the window a distance below and to the right of the upper-left corner of the parent window such that the frame of the parent window remains visible behind the current window. The exact amount by which windows are offset depends upon the dimensions of the window frame under a given appearance.

Available in Mac OS X v10.0 and later.
kWindowCascadeOnParentWindowScreen

Place the window just below the menu bar at the left edge of the screen containing the parent window. Subsequent windows are placed on the screen relative to the first window, such that the frame of the preceding window remains visible behind the current window. The exact amount by which windows are offset depends upon the dimensions of the window frame under a given appearance. On Mac OS X v10.3 and later, the parent window may be the same as the positioned window. On CarbonLib and earlier versions of Mac OS X, the parent window must be different from the positioned window.

Available in Mac OS X v10.0 and later.
kWindowCascadeStartAtParentWindowScreen

Cascade the window on the screen containing the largest portion of its parent window, starting below and to the right of its parent window. The parent window must be different from the positioned window. (Available in Mac OS X v10.2 and CarbonLib 1.6 and later.)

Available in Mac OS X v10.2 and later.
kWindowAlertPositionOnMainScreen

Center the window horizontally and position it vertically on the screen that contains the menu bar, such that about one-fifth of the screen is above it. On Mac OS X v10.3 and later, the parent window may be the same as the positioned window. On CarbonLib and earlier versions of Mac OS X, the parent window must be different from the positioned window.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionOnParentWindow

Center the window horizontally and position it vertically such that about one-fifth of the parent window is above it.

Available in Mac OS X v10.0 and later.
kWindowAlertPositionOnParentWindowScreen

Center the window horizontally and position it vertically such that about one-fifth of the screen containing the parent window is above it.

Available in Mac OS X v10.0 and later.
Discussion

To specify the factors that determine how a window should be positioned, you supply one of these WindowPositionMethod constants to the function RepositionWindow or in the BasicWindowDescription structure of a resource of type ‘wind’. Do not confuse the WindowPositionMethod constants with the pre–Mac OS 8.5 Window Manager window positioning constants or use the WindowPositionMethod constants where the older constants are required (such as in the StandardAlert function or in 'WIND', 'DLOG', or 'ALRT' resources).*/

typedef UInt32 WindowPositionMethod;
enum {
   kWindowCenterOnMainScreen = 1,
   kWindowCenterOnParentWindow = 2,
   kWindowCenterOnParentWindowScreen = 3,
   kWindowCascadeOnMainScreen = 4,
   kWindowCascadeOnParentWindow = 5,
   kWindowCascadeOnParentWindowScreen = 6,
   kWindowCascadeStartAtParentWindowScreen = 10,
   kWindowAlertPositionOnMainScreen = 7,
   kWindowAlertPositionOnParentWindow = 8,
   kWindowAlertPositionOnParentWindowScreen = 9
};


/*Window Attributes

Define standard window attributes. 

typedef UInt32 WindowAttributes;
enum {
   kWindowNoAttributes = 0,
   kWindowCloseBoxAttribute = (1L << 0),
   kWindowHorizontalZoomAttribute = (1L << 1),
   kWindowVerticalZoomAttribute = (1L << 2),
   kWindowFullZoomAttribute = (kWindowVerticalZoomAttribute | kWindowHorizontalZoomAttribute),
   kWindowCollapseBoxAttribute = (1L << 3),
   kWindowResizableAttribute = (1L << 4),
   kWindowSideTitlebarAttribute = (1L << 5),
   kWindowToolbarButtonAttribute = (1L << 6),
   kWindowMetalAttribute = (1L << 8),
   kWindowNoTitleBarAttribute = (1L << 9),
   kWindowMetalNoContentSeparatorAttribute = (1L << 11),
   kWindowDoesNotCycleAttribute = (1L << 15),
   kWindowNoUpdatesAttribute = (1L << 16),
   kWindowNoActivatesAttribute = (1L << 17),
   kWindowOpaqueForEventsAttribute = (1L << 18),
   kWindowCompositingAttribute = (1L << 19),
   kWindowFrameworkScaledAttribute = (1L << 20),
   kWindowNoShadowAttribute = (1L << 21),
   kWindowAsyncDragAttribute = (1L << 23),
   kWindowHideOnSuspendAttribute = (1L << 24),
   kWindowStandardHandlerAttribute = (1L << 25),
   kWindowHideOnFullScreenAttribute = (1L << 26),
   kWindowInWindowMenuAttribute = (1L << 27),
   kWindowLiveResizeAttribute = (1L << 28),
   kWindowIgnoreClicksAttribute = (1L << 29),
   kWindowApplicationScaledAttribute = (1L << 30),
   kWindowNoConstrainAttribute = (unsigned long)(1L << 31),
   kWindowStandardDocumentAttributes = (kWindowCloseBoxAttribute | kWindowFullZoomAttribute
| kWindowCollapseBoxAttribute | kWindowResizableAttribute),
   kWindowStandardFloatingAttributes = (kWindowCloseBoxAttribute | kWindowCollapseBoxAttribute)
};
Constants
kWindowNoAttributes

If no bits are set, the window has none of the following attributes.

Available in Mac OS X v10.0 and later.
kWindowCloseBoxAttribute

If the bit specified by this mask is set, the window has a close box. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowHorizontalZoomAttribute

If the bit specified by this mask is set, the window changes width when zooming. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowVerticalZoomAttribute

If the bit specified by this mask is set, the window changes height when zooming. This attribute is available for windows of kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowFullZoomAttribute

If the bits specified by this mask are set, the window changes both width and height when zooming. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowCollapseBoxAttribute

If the bit specified by this mask is set, the window has a collapse box. This attribute is available for windows of the kDocumentWindowClass class and, on Mac OS 9, the kFloatingWindowClass and kUtilityWindowClass class. On Mac OS X, this attribute is not available for windows of the kFloatingWindowClass and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowResizableAttribute

If the bit specified by this mask is set, the window has a resize tab or box and is resizable. This attribute is available for windows of the kDocumentWindowClass, kMovableModalWindowClass, kFloatingWindowClass, kUtilityWindowClass, and kSheetWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowSideTitlebarAttribute

If the bit specified by this mask is set, the window has a side title bar. This attribute is available for windows of the kFloatingWindowClass and kUtilityWindowClass class. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowToolbarButtonAttribute

If the bit specified by this mask is set, the window has a toolbar button. This oblong clear button shows and hides the toolbar. This attribute is available for windows of the kDocumentWindowClass class on Mac OS X. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.1 and later.
kWindowMetalAttribute

If the bit specified by this mask is set, the window has a brushed-metal appearance. This attribute is available for document windows on Mac OS X v10.2 and later, and for floating windows on Mac OS X v10.3 and later. Drawers can also be metal, but dynamically adjust their appearance based on their parent window’s appearance; it is not necessary to specify this attribute for a metal drawer.

Available in Mac OS X v10.2 and later.
kWindowNoTitleBarAttribute

If the bit specified by this mask is set, the window’s title bar can be hidden. This attribute is available for windows of the kDocumentWindowClass, kFloatingWindowClass, and kUtilityWindowClass class on Mac OS X v10.4 and later. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.4 and later.
kWindowMetalNoContentSeparatorAttribute

If the bit specified by this mask is set, no border is drawn between the toolbar and window content. This attribute is available in Mac OS X v10.4 and later and is relevant only in metal windows; it is ignored in non-metal windows.

Available in Mac OS X v10.4 and later.
kWindowDoesNotCycleAttribute

If the bit specified by this mask is set, the window does not participate in window cycling invoked by Command-~ or the “Focus on Window” hot key defined in the Keyboards preference pane. This attribute is available for all windows on Mac OS X v10.2 and later.

Available in Mac OS X v10.3 and later.
kWindowNoUpdatesAttribute

If the bit specified by this mask is set, the window does not receive update events. This attribute is available for all windows.

Available in Mac OS X v10.0 and later.
kWindowNoActivatesAttribute

If the bit specified by this mask is set, the window does not receive activate events. This attribute is available for all windows.

Available in Mac OS X v10.0 and later.
kWindowOpaqueForEventsAttribute

If the bit specified by this mask is set, the window receives mouse events even for areas of the window that are transparent (that is, have an alpha channel component of zero). This attribute is available for windows of kOverlayWindowClass on Mac OS X v10.0 and v10.1, and available for all windows on Mac OS X v10.2 and later. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowCompositingAttribute

If the bit specified by this mask is set, the window uses HIView-based compositing, which means that the entire window is comprised of HIViews, and can be treated thusly. This attribute must be specified at window creation; the ChangeWindowAttributes function cannot be used to add this attribute after the window has been created. This attribute is available on Mac OS X v10.2 and later.

Available in Mac OS X v10.2 and later.
kWindowFrameworkScaledAttribute

If the bit specified by this mask is set, this window’s content is scaled to match the display scale factor. This attribute can only be used when kWindowCompositingAttribute is also enabled. When this attribute is enabled, you may not draw with QuickDraw in the window. If this attribute is enabled and if the scale factor is something other than 1.0, the window’s scale mode is kHIWindowScaleModeFrameworkScaled. If you specify this attribute and kWindowApplicationScaledAttribute, the kWindowApplicationScaledAttribute is ignored. You may only specify this attribute at window creation time. This attribute is available for all windows in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kWindowNoShadowAttribute

If the bit specified by this mask is set, the window has no shadow. This attribute is available for all windows on Mac OS X and is given automatically to windows of the kOverlayWindowClass class. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowHideOnSuspendAttribute

If the bit specified by this mask is set, the window is hidden automatically on suspend and shown on resume. This attribute available for all windows and is given automatically to windows of class kFloatingWindowClass, kHelpWindowClass, and kToolbarWindowClass. See “Window Class Constants” for descriptions of these classes.

Available in Mac OS X v10.0 and later.
kWindowAsyncDragAttribute

If the bit specified by this mask is set, the window server drags the window automatically. Your application should not call DragWindow for this window because DragWindow would fight with the Window Server for control. This attribute is ignored if the window is grouped with other windows in a window group that has the kWindowGroupAttrMoveTogether attribute. (Available for all windows on Mac OS X v10.3 and later.)

Available in Mac OS X v10.3 and later.
kWindowStandardHandlerAttribute

If the bit specified by this mask is set, the window supports the standard window event handler. The standard event handler provides standard actions for common window events. See Carbon Event Manager Programming Guide for more details. This attribute is available for all windows.

Available in Mac OS X v10.0 and later.
kWindowHideOnFullScreenAttribute

If the bit specified by this mask is set, the window is automatically hidden during fullscreen mode (when the menubar is invisible) and shown afterwards. Available for all windows. This attribute is automatically given to windows of the kUtilityWindowClass class. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowInWindowMenuAttribute

If the bit specified by this mask is set, the window title appears in the system-generated Window menu. This attribute is only available for windows of the kDocumentWindowClass class and is automatically given to windows of that class. See “Window Class Constants” for a description of this class.

Available in Mac OS X v10.0 and later.
kWindowLiveResizeAttribute

If the bit specified by this mask is set, the window supports live resizing. This attribute is available to all windows on Mac OS X.

Available in Mac OS X v10.0 and later.
kWindowIgnoreClicksAttribute

If the bit specified by this mask is set, the window never receives mouse events, even in areas that are opaque. Instead, clicks on the window are passed through to windows beneath it. This attribute is available for all windows on Mac OS X v10.2 and later.

Available in Mac OS X v10.2 and later.
kWindowApplicationScaledAttribute

If the bit specified by this mask is set, the details of resolution-independent scaling will be taken care of primarily by the application. This attribute is valid for compositing and non-compositing windows. Resolution-independent windows that draw with QuickDraw must use this attribute. If this attribute is enabled and if the scale factor is something other than 1.0, the window’s scale mode is kHIWindowScaleModeApplicationScaled. If you specify this attribute and kWindowFrameworkScaledAttribute, this attribute is ignored. You may only specify this attribute at window creation time. This attribute is available for all windows in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kWindowNoConstrainAttribute

If the bit specified by this mask is set, the window is not repositioned by the default kEventWindowConstrain handler in response to changes in monitor size, Dock position, and so on. This attribute is available for all windows on Mac OS X v10.1 and later, and CarbonLib v1.6 and later.

Available in Mac OS X v10.1 and later.
kWindowStandardDocumentAttributes

If the bits specified by this mask are set, the window has the attributes of a standard document window—that is, a close box, full zoom box, collapse box, and size box.

Available in Mac OS X v10.0 and later.
kWindowStandardFloatingAttributes

If the bits specified by this mask are set, the window has the attributes of a standard floating window—that is, a close box and collapse box.

Available in Mac OS X v10.0 and later.
Discussion

The WindowAttributes enumeration defines masks your application can use to set or test window feature bits. You can use these masks with the function CreateNewWindow to set window feature bits, thereby defining a window’s attributes, and with the function ChangeWindowAttributes to change a window’s attributes. You can also use these masks to test the window feature bits produced by the function GetWindowAttributes, thereby obtaining a window’s attributes.*/
typedef UInt32 WindowAttributes;
enum {
   kWindowNoAttributes = 0,
   kWindowCloseBoxAttribute = (1L << 0),
   kWindowHorizontalZoomAttribute = (1L << 1),
   kWindowVerticalZoomAttribute = (1L << 2),
   kWindowFullZoomAttribute = (kWindowVerticalZoomAttribute | kWindowHorizontalZoomAttribute),
   kWindowCollapseBoxAttribute = (1L << 3),
   kWindowResizableAttribute = (1L << 4),
   kWindowSideTitlebarAttribute = (1L << 5),
   kWindowToolbarButtonAttribute = (1L << 6),
   kWindowMetalAttribute = (1L << 8),
   kWindowNoTitleBarAttribute = (1L << 9),
   kWindowMetalNoContentSeparatorAttribute = (1L << 11),
   kWindowDoesNotCycleAttribute = (1L << 15),
   kWindowNoUpdatesAttribute = (1L << 16),
   kWindowNoActivatesAttribute = (1L << 17),
   kWindowOpaqueForEventsAttribute = (1L << 18),
   kWindowCompositingAttribute = (1L << 19),
   kWindowFrameworkScaledAttribute = (1L << 20),
   kWindowNoShadowAttribute = (1L << 21),
   kWindowAsyncDragAttribute = (1L << 23),
   kWindowHideOnSuspendAttribute = (1L << 24),
   kWindowStandardHandlerAttribute = (1L << 25),
   kWindowHideOnFullScreenAttribute = (1L << 26),
   kWindowInWindowMenuAttribute = (1L << 27),
   kWindowLiveResizeAttribute = (1L << 28),
   kWindowIgnoreClicksAttribute = (1L << 29),
   kWindowApplicationScaledAttribute = (1L << 30),
   kWindowNoConstrainAttribute = (unsigned long)(1L << 31),
   kWindowStandardDocumentAttributes = (kWindowCloseBoxAttribute | kWindowFullZoomAttribute
| kWindowCollapseBoxAttribute | kWindowResizableAttribute),
   kWindowStandardFloatingAttributes = (kWindowCloseBoxAttribute | kWindowCollapseBoxAttribute)
};

/*Window Region Constants

Define various window regions. 

typedef UInt16 WindowRegionCode;
enum {
   kWindowTitleBarRgn = 0,
   kWindowTitleTextRgn = 1,
   kWindowCloseBoxRgn = 2,
   kWindowZoomBoxRgn = 3,
   kWindowDragRgn = 5,
   kWindowGrowRgn = 6,
   kWindowCollapseBoxRgn = 7,
   kWindowTitleProxyIconRgn = 8,
   kWindowStructureRgn = 32,
   kWindowContentRgn = 33,
   kWindowUpdateRgn = 34,
   kWindowOpaqueRgn = 35,
   kWindowGlobalPortRgn = 40,
   kWindowToolbarButtonRgn = 41
};
Constants
kWindowTitleBarRgn

The entire area occupied by a window’s title bar, including the title text region.

Available in Mac OS X v10.0 and later.
kWindowTitleTextRgn

That portion of a window’s title bar that is occupied by the name of the window.

Available in Mac OS X v10.0 and later.
kWindowCloseBoxRgn

The area occupied by a window’s close box.

Available in Mac OS X v10.0 and later.
kWindowZoomBoxRgn

The area occupied by a window’s zoom box.

Available in Mac OS X v10.0 and later.
kWindowDragRgn

The draggable area of the window frame; this area includes the title bar and window outline and excludes the size box, close box, zoom box, and collapse box.

Available in Mac OS X v10.0 and later.
kWindowGrowRgn

The area occupied by a window’s size box.

Available in Mac OS X v10.0 and later.
kWindowCollapseBoxRgn

The area occupied by a window’s collapse box. 

Available in Mac OS X v10.0 and later.
kWindowTitleProxyIconRgn

Specifies the region in the window’s title area that contains the proxy icon. The proxy icon region is always located within the window’s title text region.

Available in Mac OS X v10.0 and later.
kWindowStructureRgn

The entire area occupied by a window, including the frame and content region; the window may be partially off-screen but its structure region does not change.

Available in Mac OS X v10.0 and later.
kWindowContentRgn

The window’s content region—the part of a window in which your application displays the contents of the window or dialog, including the size box and any controls. 

Available in Mac OS X v10.0 and later.
kWindowUpdateRgn

The window’s update region––the part of the window that needs to be redrawn. 

Available in Mac OS X v10.0 and later.
kWindowOpaqueRgn

Area of window considered to be opaque. Only valid for windows with alpha channels. (Mac OS X only)

Available in Mac OS X v10.0 and later.
kWindowGlobalPortRgn

Bounds of the window’s port in global coordinates; not affected by CollapseWindow.

Available in Mac OS X v10.0 and later.
kWindowToolbarButtonRgn

Bounds of the toolbar button area. (Available in Mac OS X v10.4 and later.)

Available in Mac OS X v10.4 and later.
Discussion

You can pass constants of type WindowRegionCode in the inRegionCode parameter of GetWindowRegion to obtain a handle to a specific window region. The WindowRegionCode constants are available with Appearance Manager 1.0 and later. 
Version Notes

With the Window Manager in Mac OS 8.5 and later, you may pass the kWindowTitleProxyIconRgn, kWindowStructureRgn, and kWindowContentRgn constants to the function GetWindowRegion.*/
typedef UInt16 WindowRegionCode;
enum {
   kWindowTitleBarRgn = 0,
   kWindowTitleTextRgn = 1,
   kWindowCloseBoxRgn = 2,
   kWindowZoomBoxRgn = 3,
   kWindowDragRgn = 5,
   kWindowGrowRgn = 6,
   kWindowCollapseBoxRgn = 7,
   kWindowTitleProxyIconRgn = 8,
   kWindowStructureRgn = 32,
   kWindowContentRgn = 33,
   kWindowUpdateRgn = 34,
   kWindowOpaqueRgn = 35,
   kWindowGlobalPortRgn = 40,
   kWindowToolbarButtonRgn = 41
};

/*Window Modality Options

Specify the modality of a window. 

typedef UInt32 WindowModality;
enum {
   kWindowModalityNone = 0,
   kWindowModalitySystemModal = 1,
   kWindowModalityAppModal = 2,
   kWindowModalityWindowModal = 3
};
Constants
kWindowModalityNone

A window does not prevent interaction with any other window in the system. 

Available in Mac OS X v10.0 and later.
kWindowModalitySystemModal

The window is system-modal. On Mac OS 9 and earlier, the user cannot perform any other action until the window is dismissed. On Mac OS X, this constant produces the same behavior as kWindowModalityAppModal, so there is no way to prevent the user from interacting with windows from other applications.

Available in Mac OS X v10.0 and later.
kWindowModalityAppModal

The window is application-modal; that is the user cannot perform any other action within the application until the window is dismissed. The user can switch to other applications, however. 

Available in Mac OS X v10.0 and later.
kWindowModalityWindowModal

The window is document-modal; the user cannot perform any other action within the current document window until the modal window associated with it is dismissed. The user can switch to other windows or applications, however. Sheets are document-modal. 

Available in Mac OS X v10.0 and later.*/
typedef UInt32 WindowModality;
enum {
   kWindowModalityNone = 0,
   kWindowModalitySystemModal = 1,
   kWindowModalityAppModal = 2,
   kWindowModalityWindowModal = 3
};

/*Window Class Constants

Indicates the class of a window. 

typedef UInt32 WindowClass;
enum {
   kAlertWindowClass = 1,
   kMovableAlertWindowClass = 2,
   kModalWindowClass = 3,
   kMovableModalWindowClass = 4,
   kFloatingWindowClass = 5,
   kDocumentWindowClass = 6,
   kUtilityWindowClass = 8,
   kHelpWindowClass = 10,
   kSheetWindowClass = 11,
   kToolbarWindowClass = 12,
   kPlainWindowClass = 13,
   kOverlayWindowClass = 14,
   kSheetAlertWindowClass = 15,
   kAltPlainWindowClass = 16,
   kDrawerWindowClass = 20,
   kAllWindowClasses = 0xFFFFFFFF
};
Constants
kAlertWindowClass

Identifies an alert box window. An alert window is used when the application needs the user's attention immediately. On Mac OS 9 and earlier, a visible alert window will prevent the user from switching to any other application. Use kThemeBrushAlertBackgroundActive to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kMovableAlertWindowClass

Identifies a movable alert box window. Generally, you should use this window class rather than kAlertWindowClass. Use kThemeBrushAlertBackgroundActive to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kModalWindowClass

Identifies a modal dialog box window. Use kThemeBrushDialogBackgroundActive to draw the background of modal dialog windows. Modal dialog windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kMovableModalWindowClass

Identifies a movable modal dialog box window. On Mac OS X and CarbonLib 1.3 and later, use kThemeBrushMovableModalBackground to draw the background of alert windows. Alert windows are initially placed in the modal window group, given a modality of kWindowModalityAppModal, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kFloatingWindowClass

Identifies a window that floats above all document windows. If your application assigns this constant to a window, the Window Manager ensures that the window has the proper floating behavior. Use kThemeBrushUtilityWindowBackgroundActive or kThemeBrushDocumentWindowBackground to draw the background of floating windows. Floating windows are initially placed in the floating window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeIndependent. Supported with Mac OS 8.6 and later.

Available in Mac OS X v10.0 and later.
kDocumentWindowClass

Identifies a document window or modeless dialog box window. Use kThemeBrushDocumentWindowBackground or your own custom drawing to draw the background of a document window. Document windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll.The Window Manager assigns this class to pre–Mac OS 8.5 Window Manager windows.

Available in Mac OS X v10.0 and later.
kUtilityWindowClass

Identifies a utility window. A utility window is similar to a floating window, but it floats above the windows of all applications rather than just above the windows of the application that creates it. Use kThemeBrushUtilityWindowBackgroundActive or kThemeBrushDocumentWindowBackground to draw the background of utility windows. Utility windows are initially placed in the utility window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeIndependent.

Available in CarbonLib 1.1 and later, and in Mac OS X.
kHelpWindowClass

Identifies a window used for help tags. It has no window frame. Typically you should use the Help Manager to display help tags, rather than creating a help tag window yourself. Help windows are initially placed in the help window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone.

Available in CarbonLib 1.1 and later, and in Mac OS X.
kSheetWindowClass

Identifies a sheet. (Mac OS X only.) Use kThemeBrushSheetBackgroundOpaque to draw an opaque background for sheet windows, or kThemeBrushSheetBackgroundTransparent to draw a transparent background (the transparent brush is only available in Mac OS X 10.1 and later). Sheet windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll.

Available in Mac OS X v10.0 and later.
kToolbarWindowClass

Identifies a toolbar window, which is used to display a palette of controls. A toolbar window is similar to a floating window, and like a floating window, is layered above all application windows except for alert and modal windows, but is layered beneath floating windows. Toolbar windows are initially placed in the toolbar window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone. (Available in CarbonLib 1.1 and later, and Mac OS X.)

Available in Mac OS X v10.0 and later.
kPlainWindowClass

Identifies a plain window, which has a single-pixel window frame. Plain windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Available in CarbonLib 1.2.5 and later, and Mac OS X.)

Available in Mac OS X v10.0 and later.
kOverlayWindowClass

Identifies an overlay window, which is a completely transparent window positioned above all other windows. Overlay windows are intended as a replacement for the pre-Carbon practice of drawing directly into the Window Manager port. By creating a full-screen overlay window and drawing into it, you can draw over any window in any application without disturbing the contents of the windows beneath your drawing. Overlay windows have a default handler for kEventWindowPaint that uses CGContextClearRect to clear the overlay window's alpha channel to zero. This ensures the initial transparency of the window. You can install your own kEventWindowPaint handler to do your own drawing; typically, you would call through to the default handler with CallNextEventHandler first, and then use QDBeginCGContext tocreate your own context for drawing. You can use either QuickDraw or Core Graphics to draw into an overlay window, but you must use Core Graphics to draw if you need any of your drawing to be non-opaque, since QuickDraw always sets the alpha channel of any pixels that it touches to 1.0. (QuickDraw is also deprecated in Mac OS X v10.4 and later.) You can also use the standard window event handler together with regular controls in an overlay window. When using the standard window event handler, you will probably want your kEventWindowPaint handler to return eventNotHandledErr (after calling the default handler with CallNextEventHandler first) so that after the Paint handler returns, the Window Manager will send a kEventWindowDrawContent event which the standard window event handler can respond to by drawing the controls in the window. Overlay windows are initially placed in the overlay window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeNone. (

Available in Mac OS X.)
kSheetAlertWindowClass

Identifies an alert sheet. Use kThemeBrushSheetBackgroundOpaque to draw an opaque background for sheet alert windows, or kThemeBrushSheetBackgroundTransparent to draw a transparent background (the transparent brush is only available in Mac OS X 10.1 and later). Sheet alert windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Mac OS X only.)

Available in Mac OS X v10.1 and later.
kAltPlainWindowClass

Identifies an alternate plain window, which is similar to a plain window but has a solid black shadow on its right and bottom sides. It is rarely used in modern Mac OS applications. Alternate plain windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. (Available in CarbonLib 1.3 and later and Mac OS X v10.1 and later.)

Available in Mac OS X v10.1 and later.
kDrawerWindowClass

Identifies a drawer. Use kThemeBrushDrawerBackground or kThemeBrushDocumentWindowBackground to draw the background of drawer windows. Drawer windows are initially placed in the document window group, given a modality of kWindowModalityNone, and given an activation scope of kWindowActivationScopeAll. Drawer windows should always be created using the compositing window attribute.(Mac OS X v10.2 and later)

Available in Mac OS X v10.2 and later.
kAllWindowClasses

Specifier used to designate all window classes. Used with GetFrontWindowOfClass, FindWindowOfClass, and GetNextWindowOfClass to indicate that there should be no restriction on the class of the returned window. Also used with GetWindowGroupOfClass to get the root window group.

Available in Mac OS X v10.0 and later.
Discussion

The WindowClass constants categorize windows into groups of like types. The grouping of windows facilitates the appropriate display (that is, both the look and the front-to-back ordering) and tracking of windows.

You can define a window’s class using the function CreateNewWindow and obtain a window’s class using the function GetWindowClass. You can change the class of certain windows by calling HIWindowChangeClass.*/
typedef UInt32 WindowClass;
enum {
   kAlertWindowClass = 1,
   kMovableAlertWindowClass = 2,
   kModalWindowClass = 3,
   kMovableModalWindowClass = 4,
   kFloatingWindowClass = 5,
   kDocumentWindowClass = 6,
   kUtilityWindowClass = 8,
   kHelpWindowClass = 10,
   kSheetWindowClass = 11,
   kToolbarWindowClass = 12,
   kPlainWindowClass = 13,
   kOverlayWindowClass = 14,
   kSheetAlertWindowClass = 15,
   kAltPlainWindowClass = 16,
   kDrawerWindowClass = 20,
   kAllWindowClasses = 0xFFFFFFFF
};

/*WindowRecord

Defines the window structure for a window.

struct WindowRecord {
   GrafPort port;
   SInt16 windowKind;
   Boolean visible;
   Boolean hilited;
   Boolean goAwayFlag;
   Boolean spareFlag;
   RgnHandle strucRgn;
   RgnHandle contRgn;
   RgnHandle updateRgn;
   Handle windowDefProc;
   Handle dataHandle;
   StringHandle titleHandle;
   SInt16 titleWidth;
   Handle controlList;
   WindowPeek nextWindow;
   PicHandle windowPic;
   SInt32 refCon;
};
typedef WindowRecord* WindowPeek;
Fields
Discussion

In Mac OS 8, you should use the color window structure instead of the window structure, since Color QuickDraw is always available with Mac OS 8. The WindowRecord structure is not recommended with Mac OS 8 and later. In Carbon, you should consider the window record to be opaque and access it only through accessor functions. 

Your application should use a window structure instead of a color window structure if Color QuickDraw is not available.The only difference between a color window structure and a window structure is that a color window structure contains a color graphics port, which allows use of color devices, while a window structure contains a monochrome graphics port. 

The data types that describe window structures, WindowRecord, WindowRef, and WindowPeek, are parallel to the data types that describe color window structure, and the fields in the monochrome window structure are identical to the fields in the color window structure. For information about the color window structure, see CWindowRecord.
Special Considerations
Availability
Available in Mac OS X v10.0 and later.*/

typedef struct WindowRecord  WindowRecord;
typedef WindowRecord* WindowPeek;

struct WindowRecord {
   GrafPort port;
   SInt16 windowKind;
   Boolean visible;
   Boolean hilited;
   Boolean goAwayFlag;
   Boolean spareFlag;
   RgnHandle strucRgn;
   RgnHandle contRgn;
   RgnHandle updateRgn;
   Handle windowDefProc;
   Handle dataHandle;
   StringHandle titleHandle;
   SInt16 titleWidth;
   Handle controlList;
   WindowPeek nextWindow;
   PicHandle windowPic;
   SInt32 refCon;
};

/*WindowDefProcPtr

Defines a pointer to a window definition callback function. Your window definition callback function determines how a window looks and behaves.

typedef long (*WindowDefProcPtr) (
   short varCode,
   WindowRef window,
   short message,
   long param
);

If you name your function MyWindowDefProc, you would declare it like this:

long MyWindowDefProc (
   short varCode,
   WindowRef window,
   short message,
   long param
);
Parameters
varCode

The window’s variation code. 
window

A pointer to the window’s window structure.
message

A value indicating the task to be performed. The message parameter contains one of the values defined in “Window Definition Message Constants”. Other messages are reserved for internal use by the system. The list in the discussion section that follows explains each of these tasks in detail.
param

Data associated with the task specified by the message parameter. If the task requires no data, this parameter is ignored. 
Return Value

Your window definition function should perform whatever task is specified by the message parameter and return a function result, if appropriate. If the task performed requires no result code, return 0. 
Discussion

Various Window Manager functions call a window definition function whenever they need to perform a window-dependent action, such as drawing the window on the screen. If you want to define new, nonstandard windows for your application, you must write a window definition function, compile it in your application, and either use RegisterWindowDefinition to register it with the system or call CreateCustomWindow to create the custom window directly.

Note that Carbon does not allow you to store custom window definitions in a 'WDEF' resource file as you could in preCarbon systems.

If you use RegisterWindowDefinition, the Window Manager calls the Resource Manager to access your window definition function with the given resource ID; see “Pre-Appearance Window Definition IDs” inWindow Manager Legacy Reference for a description of how window definition IDs are derived from resource IDs and variation codes. 

The Resource Manager reads your window definition function into memory and returns a handle to it. The Window Manager stores this handle in the windowDefProc field of the window structure. Later, when it needs to perform an action on the window, the Window Manager calls the window definition function and passes it the variation code as a parameter.

Your window definition function is responsible for
drawing the window frame 
reporting the region where mouse-down events occur 
calculating the window’s structure region and content region 
drawing the size box 
resizing the window frame when the user drags the size box 
reporting the window’s features or the location of a specific window region 
performing any customized initialization or disposal tasks 

The Window Manager defines the data type WindowDefUPP to identify the universal procedure pointer for this application-defined function:typedef UniversalProcPtr WindowDefUPP;


You typically use the NewWindowDefProc macro like this: WindowDefUPP myWindowDefUPP;
myWindowDefUPP = NewWindowDefProc(MyWindow);


You typically use the CallWindowDefProc macro like this: CallWindowDefProc (myWindowDefUPP, varCode, theWindow, message,  param);


The message parameter contains a value specifying the task to be performed by your window definition function. These tasks are:
Drawing the Window Frame 

When the Window Manager passes wDraw in the message parameter, your window definition function should respond by drawing the window frame in the current graphics port (which is the Window Manager port). The window part code to be drawn will be passed in the param parameter of your window definition function. Your window definition function should perform the following steps:
Change the current port from the WMgrPort to the WMgrCPort to allow the system to draw in the full range of RGB colors.
Update the pen attributes, text attributes, and bkPat fields in the WMgrCPort to the values of the corresponding fields in the WMgrPort. The Window Manager automatically transfers the vis and clip regions.
The parallelism of the WMgrPort and the WMgrCPort is maintained only by the window definition functions. All window definition functions that draw in the WMgrPort should follow the steps listed above even if the changed fields do not affect their operation.

You must make certain checks to determine exactly how to draw the frame. If the value of the visible field in the window structure is false, you should do nothing; otherwise, you should examine the param parameter and the status flags in the window structure:
If the value of param is 0, draw the entire window frame (including the size box, if your window definition function incorporates the size box into the frame). 
If the value of param is 0 and the hilited field in the window structure is true, highlight the frame to show that the window is active. If the value of the goAwayFlag field in the window structure is also true, draw a close box in the window frame. If the value of the spareFlag field in the window structure is also true, draw a zoom box in the window frame. 
If the value of the param parameter is wInGoAway, redraw the window’s close box, with or without highlighting as appropriate. 
If the value of the param parameter is wInZoom, redraw the window’s zoom box, with or without highlighting as appropriate.
If the value of the param parameter is wInCollapseBox, redraw the window’s collapse box, with or without highlighting as appropriate. 
You can call GetWindowWidgetHilite to determine whether the close, zoom, or collapse box is currently highlighted. This function returns the part code of the currently highlighted part, or zero if no part is highlighted. You should draw the indicated part with highlighting, and draw other parts with no highlighting. 

The window frame typically, but not necessarily, includes the window’s title, which should be displayed in the system font and system font size. The Window Manager port is already set to use the system font and system font size.

Nothing drawn outside the window’s structure region will be visible. 

Your window definition function should return 0 as the function result for this message. 
Reporting the Region of a Mouse-Down Event 

When the Window Manager passes wHit in the message parameter, your window definition function should respond by reporting the region of the specified mouse-down event. The mouse location (in global coordinates) of the window frame will be passed into the param parameter of your window definition function. The vertical coordinate is in the high-order word of the parameter, and the horizontal coordinate is in the low-order word. 

In response to the wHit message, your window definition function should return one of the constants defined in “Window Definition Hit Test Result Code Constants”.

In Mac OS 9, return the constants wInGrow, wInGoAway, wInZoomIn, wInZoomOut, and wInCollapseBox only if the window is active—by convention, the size box, close box, zoom box, and collapse box aren’t drawn if the window is inactive. In an inactive document window, for example, a mouse-down event in the part of the title bar that would contain the close box if the window were active is reported as wInDrag. In Mac OS X, your WDEF can return these part codes for inactive windows because these boxes are drawn even if the window is inactive.
Calculating Regions 

When the Window Manager passes wCalcRgns in the message parameter, your window definition function should respond by calculating the window’s structure and content regions based on the current graphics port’s port rectangle. These regions, whose handles are in the strucRgn and contRgn fields of the window structure, are in global coordinates. The Window Manager requests this operation only if the window is visible. The mouse location (in global coordinates) of the window frame will be passed into the param parameter of your window definition function.

Your window definition function should call IsWindowCollapsed to determine its collapse state. Then your window definition function can modify its structure and content regions as appropriate. Typically, a window’s content region is empty in a collapsed state.

When you calculate regions for your own type of window, do not alter the clip region or the visible region of the Window Manager port. The Window Manager and QuickDraw take care of this for you. Altering the Window Manager port’s clip region or visible region may damage other windows.

Your window definition function should return 0 as the function result for this message. 
Performing Additional Window Initialization 

When the Window Manager passes wNew in the message parameter, your window definition function should respond by performing any initialization that it may require. If the content region has an unusual shape, for example, you might allocate memory for the region and store the region handle in the dataHandle field of the window structure. The initialization function for a standard document window creates the wStateData structure for storing zooming data.

Your window definition function should ignore the param parameter and return 0 as the function result for this message. 
Performing Additional Window Disposal Actions 

When the Window Manager passes wDispose in the message parameter, your window definition function should respond by performing any additional tasks necessary for disposing of a window. You might, for example, release memory that was allocated by the initialization function. The dispose function for a standard document window disposes of the wStateData structure.

Your window definition function should ignore the param parameter and return 0 as the function result for this message. 
Drawing the Window’s Grow Image 

When the Window Manager passes wGrow in the message parameter, your window definition function should respond to being resized by drawing a dotted outline of the window in the current graphics port in the pen pattern and mode. (The pen pattern and mode are set up—as gray and notPatXor—to conform to Appearance-compliant human interface guidelines.)

A rectangle (in global coordinates) whose upper-left corner is aligned with the port rectangle of the window’s graphics port is passed into the param parameter of your window definition function. Your grow image should be sized appropriately for the specified rectangle. As the user drags the mouse, the Window Manager sends repeated wGrow messages, so that you can change your grow image to match the changing mouse location.

Your window definition function should return 0 as the function result for this message. 
Drawing the Size Box 

When the Window Manager passes wDrawGIcon in the message parameter, your window definition function should respond by drawing the size box in the content region if the window is active. If the window is inactive, your window definition function should draw whatever is appropriate to show that the window cannot currently be sized. Your window definition function may also draw scroll bar delimiter lines. Your window definition function should ignore the param parameter.

If the size box is located in the window frame, draw the size box in response to a wDraw message, not a wDrawGIcon message.

Your window definition function should return 0 as the function result for this message. 
Reporting Window Features 

When the Window Manager passes kWindowMsgGetFeatures in the message parameter, your window definition function should respond by setting the param parameter to reflect the features that your window supports. The value passed back in the param parameter should be comprised of one or more of the values defined in “Window Feature Bits”.

Your window definition function should return 1 as the function result for this message. 
Returning the Location of Window Regions 

When the Window Manager passes kWindowMsgGetRegion in the message parameter, your window definition function should respond by returning the location (in global coordinates) of the specified window region. A pointer to a window region structure will be passed in the param parameter. 

The window region structure is a structure of type GetWindowRegionRec. Your window definition function should return an operating system status (OSStatus) message as the function result for this message. The result code errWindowRegionCodeInvalid indicates that the window region passed in was not valid.

Application-defined window definition functions are changed with Appearance Manager 1.0 to support collapse boxes and feature reporting.*/

typedef long (*WindowDefProcPtr) (
   short varCode,
   WindowRef window,
   short message,
   long param
);



/*WindowDefUPP

Defines a UPP to a specified window definition.

typedef WindowDefProcPtr WindowDefUPP;
Discussion

For more information, see WindowDefProcPtr.*/
typedef WindowDefProcPtr WindowDefUPP;

/*WindowDefSpec

Defines a window definition.

struct WindowDefSpec {
   WindowDefType defType
   union {
      WindowDefUPP defProc;
      void * classRef;
      short procID;
      void * rootView;
   } u;
};
typedef struct WindowDefSpec WindowDefSpec;
typedef WindowDefSpec * WindowDefSpecPtr;
Fields
defType

The window definition type. See “Window Definition Type Constants” for a list of possible values.
u

A pointer to the window definition, depending on the constant passed into the defType field.
Availability
Available in Mac OS X v10.0 and later.*/

struct WindowDefSpec {
   WindowDefType defType;
   union {
      WindowDefUPP defProc;
      void * classRef;
      short procID;
      void * rootView;
   } u;
};
typedef struct WindowDefSpec WindowDefSpec;
typedef WindowDefSpec * WindowDefSpecPtr;

/*GetWindowRegionRec

Passed to window definitions in the kWindowMsgGetRegion message. 

struct GetWindowRegionRec {
   RgnHandle winRgn;
   WindowRegionCode regionCode;
};
typedef struct GetWindowRegionRec GetWindowRegionRec;
typedef GetWindowRegionRec * GetWindowRegionPtr;
Fields
winRgn

A handle to a window region based on the value specified in the regionCode field. Modify this region.
regionCode

A value representing a given window region; see “Window Region Constants”.
Special Considerations
Availability
Available in Mac OS X v10.0 and later.*/

struct GetWindowRegionRec {
   RgnHandle winRgn;
   WindowRegionCode regionCode;
};
typedef struct GetWindowRegionRec GetWindowRegionRec;
typedef GetWindowRegionRec * GetWindowRegionPtr;

/*HIWindowRef

Represents a window. 

typedef WindowRef HIWindowRef;
Availability
Available in Mac OS X v10.3 and later.*/
typedef WindowRef HIWindowRef;

//functions

/*GetFrontWindowOfClass

Obtains the frontmost window of a given class. 

WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindowClass

The class of the window you want to obtain. If you pass kAllWindowClasses, the function returns the frontmost window in the window list. 
mustBeVisible

If set to true, the function returns the frontmost visible window. If set to false, the function returns the frontmost window of the specified class, regardless of whether the window is visible.
Return Value

A reference to the frontmost window of the class specified by inWindowClass.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Carbon Porting Notes
Declared In
MacWindows.h*/
WindowRef GetFrontWindowOfClass (
   WindowClass inWindowClass,
   Boolean mustBeVisible
);

/*ShowWindow

Makes an invisible window visible.

void ShowWindow (
   WindowRef window
);
Parameters
window

The window that is to be made visible.
Discussion

The ShowWindow function makes an invisible window visible. If the specified window is already visible, ShowWindow has no effect. Your application typically creates a new window in an invisible state, performs any necessary setup of the content region, and then calls ShowWindow to make the window visible.

When you call ShowWindow to display a window that is invisible, the Window Manager draws the window frame and sends an event to request the application to draw the content region before the window becomes visible. For compositing windows, the Window Manager sends a kEventControlDraw event to each HIView in the window. For non-compositing windows, the Window Manager sends a kEventWindowDrawContent event. If a non-compositing window does not handle the kEventWindowDrawContent, the Window Manager shows the window and generates an update event to request your application to draw the content region.

If the newly visible window is the frontmost window, ShowWindow highlights it if it’s not already highlighted and generates an activate event to make it active. The ShowWindow function does not activate a window that is not frontmost on the desktop.

Because ShowWindow does not change the front-to-back ordering of windows, it is not the inverse of HideWindow. If you make the frontmost window invisible with HideWindow, andHideWindow has activated another window, you must call both ShowWindow and SelectWindow to bring the original window back to the front.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
#ifndef _WINUSER_
void ShowWindow (
   WindowRef window
);
#endif
/*SetWindowModified

Sets the modification state of the specified window.

OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);
Parameters
window

The window whose modification state is to be set.
modified

Pass true if the content of the window has been modified; otherwise, pass false.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application can use the functions SetWindowModified and IsWindowModified instead of maintaining its own separate record of the modification state of the content of a window. The modification state of a window is visually represented by a dot in the window’s close box. If the dot is present, the window is modified; if the dot is absent, the window is not modified.

Your application should distinguish between the modification state of the window and the modification state of the window’s contents, typically a document. The modification state of the window contents are what should affect SetWindowModified. For example, in the case of a word processing document, you call SetWindowModified (passing true in the modified parameter) whenever the user types new characters into the document. However, you do not call SetWindowModified when the user moves the window, because that change does not affect the document contents. If you need to track whether the window position has changed, you need to do this with your own flag. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowModified (
   WindowRef window,
   Boolean modified
);

/*SetWindowTitleWithCFString

Sets the window title to the contents of a Core Foundation string. 

OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);
Parameters
inWindow

The window whose title is to be set.
inString

The title to set. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowTitleWithCFString (
   WindowRef inWindow,
   CFStringRef inString
);

/*DisposeWindow

Removes a window.

void DisposeWindow (
   WindowRef window
);
Parameters
window

On input, the window to be closed.
Discussion

The DisposeWindow function reduces a window’s reference count by one. If the resulting reference count is zero, then DisposeWindow removes the window from the screen and deletes it from the window list, then releases the memory occupied by all structures associated with the window, including the window structure. 

Note that DisposeWindow assumes that any picture pointed to by the window structure field windowPic is data, not a resource, and it calls the QuickDraw function KillPicture to delete it. If your application uses a picture stored as a resource, you must release the resource or release the memory it occupies with the ReleaseResource function and set the windowPic field to NULL before closing the window.

Any pending update events for the window are discarded. If the window being removed is the frontmost window, the window behind it, if any, becomes the active window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DisposeWindow (
   WindowRef window
);

/*SetWindowProxyFSSpec

Associates a file with a window.

Not recommended

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);
Parameters
window

A pointer to the window with which the specified file is to be associated. 
inFile

Set the file system specification structure to contain the data for the file to associate with the specified window. You can obtain an FSSpec structure by calling the function GetWindowProxyFSSpec. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application should call the SetWindowProxyFSSpec function to establish a proxy icon for a given window. The creator code and file type of the file associated with a window determine the proxy icon that is displayed for the window.

Because the SetWindowProxyFSSpec function won’t work without a saved file, you must establish the initial proxy icon for a new, untitled window with the function SetWindowProxyCreatorAndType , which requires that you know the file type and creator code for the file, but does not require that the file have been saved.

See also the function SetWindowProxyAlias. 
Special Considerations

With Mac OS 8.5, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the SetWindowProxyFSSpec function.
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/

OSStatus SetWindowProxyFSSpec (
   WindowRef window,
   const FSSpec * inFile
);

/*SetWindowBounds

Sets a window’s size and position from the bounding rectangle of the specified window region.

OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);
Parameters
window

The window whose bounds are to be set.
regionCode

A constant specifying the region to be used in determining the window’s size and position. The only region codes allowed for this parameter are kWindowStructureRgn and kWindowContentRgn.
globalBounds

Set the rectangle to specify the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The SetWindowBounds function sets a window’s size and position to that specified by the rectangle that your application passes in the globalBounds parameter. After doing so, SetWindowBounds redraws the window, if the window is visible.

When you call the SetWindowBounds function, your application specifies whether the window’s content region or its structure region is more important in determining the window’s ultimate size and position. This distinction can be important with versions of the Mac OS running the Appearance Manager, since the total dimensions of a window—and, therefore, its spatial relationship to the rest of the screen—may vary from appearance to appearance. In general, you should specify kWindowStructureRgn for the regionCode parameter if how the window as a whole relates to a given monitor is more important than the exact positioning of its content on the screen. On the other hand, if you specify kWindowContentRgn for the regionCode parameter because the positioning of your application’s content is of greatest concern, then it is important to note that with some appearances some part of the window’s structure region or “frame” may extend past the edge of a monitor and not be displayed.

See also the function GetWindowBounds. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   const Rect * globalBounds
);

/*HideWindow

Makes a window invisible.

void HideWindow (
   WindowRef window
);
Parameters
window

The window that is to be made invisible.
Discussion

The HideWindow function make a visible window invisible. If you hide the frontmost window, HideWindow removes the highlighting, brings the window behind it to the front, highlights the new frontmost window, and generates the appropriate activate events.

To reverse the actions of HideWindow, you must call both ShowWindow, to make the window visible, and SelectWindow, to select it. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void HideWindow (
   WindowRef window
);



/*GetWindowBounds

Obtains the size and position of the bounding rectangle of the specified window region.

OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);
Parameters
window

The window whose bounds you want to obtain.
regionCode

A constant identifying the window region whose bounds you want to obtain. See “Window Region Constants” for a list of possible values.
globalBounds

A pointer to a structure of type Rect. On return, the rectangle contains the dimensions and position, in global coordinates, of the window region specified in the regionCode parameter. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use the GetWindowBounds function to obtain the bounding rectangle for the specified window region for the specified window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowBounds (
   WindowRef window,
   WindowRegionCode regionCode,
   Rect * globalBounds
);

/*SetWindowResizeLimits

Sets the maximum and minimum resize limits for windows. 

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);
Parameters
inWindow

The window whose maximum and minimum resize limits are to be set.
inMinLimits

The minimum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
inMaxLimits

The maximum limits. Pass NULL if you don’t want to set this limit. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus SetWindowResizeLimits (
   WindowRef inWindow,
   const HISize * inMinLimits,
   const HISize * inMaxLimits
);

/*CopyWindowTitleAsCFString

Copies the window title into a Core Foundation string.

OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);
Parameters
inWindow

The window whose title is to be copied.
outString

On output, the window’s title. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CopyWindowTitleAsCFString (
   WindowRef inWindow,
   CFStringRef * outString
);

/*CreateNewWindow

Creates a window from parameter data.

OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
windowClass

A constant that categorizes the class of window to be created. For certain classes, the window class can be altered after the window is created by calling HIWindowChangeClass. See “Window Class Constants” for a description of possible values for this parameter.
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes.
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region.
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateNewWindow function creates a window based on the attributes and class you specify in the attributes and windowClass parameters. CreateNewWindow sets the new window’s content region to the size and location specified by the rectangle passed in the bounds parameter, which in turn determines the dimensions of the entire window. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateNewWindow, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateNewWindow (
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);

/*RepositionWindow

Positions a window relative to another window or a display screen.

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);
Parameters
window

The window whose position you want to set.
parentWindow

A pointer to the “parent” window, as defined by your application. In cases where the window positioning method does not require a parent window, you should set the parentWindow parameter to NULL.
method

A constant specifying the window positioning method to be used; see “Window Position Constants” for descriptions of possible values. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Your application may call the RepositionWindow function to position any window, relative to another window or to a display screen. After positioning the window, RepositionWindow displays the window in its new position.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus RepositionWindow (
   WindowRef window,
   WindowRef parentWindow,
   WindowPositionMethod method
);

/*GetNextWindowOfClass

Obtains the next window in a given window group. 

WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);
Parameters
inWindow

The window at which to start.
inWindowClass

The class of window to obtain. If you pass kAllWindowClasses, the function returns the window directly behind the input window. If no windows exist behind the front window, the function returns NULL. 
mustBeVisible

If set to true, this function returns the next visible window of the specified window class. If set to false, this function returns the next window of the specified window class, regardless of whether it is visible.
Return Value

A reference for the next window of the specified class after the window specified by inWindow.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef GetNextWindowOfClass (
   WindowRef inWindow,
   WindowClass inWindowClass,
   Boolean mustBeVisible
);

/*GetWRefCon

Returns the reference constant from a window.

long GetWRefCon (
   WindowRef window
);
Parameters
window

The window whose reference constant is to be returned.
Return Value

The long integer data stored in the refCon field of the window structure specified in the window parameter. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
long GetWRefCon (
   WindowRef window
);

/*SetWRefCon

Sets the refCon field of a window.

void SetWRefCon (
   WindowRef window,
   long data
);
Parameters
window

The window whose refCon field is to be set.
data

On input, the data to be placed in the refCon field. 
Discussion

The SetWRefCon function places the specified data in the refCon field of the specified window structure. The refCon field is available to your application for any window-related data it needs to store. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWRefCon (
   WindowRef window,
   long data
);

/*HIWindowSetProxyFSRef

Sets the proxy icon for a window using an FSRef to a file system object.

OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);
Parameters
inWindow

The window whose proxy icon is to be set.
inRef

The file system object the window represents.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function determines the window’s proxy icon by asking Icon Services for the icon for the object specified by inRef.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowSetProxyFSRef (
   WindowRef inWindow,
   const FSRef * inRef
);

/*ActiveNonFloatingWindow

Returns the currently active nonfloating window. 

WindowRef ActiveNonFloatingWindow ();
Return Value

A reference to the active window.
Discussion

Note that the active window is not necessarily the frontmost window, and it is not necessarily the window with user focus. Call GetUserFocusWindow to get the window that has user focus. For information on the GetUserFocusWindow function, see Carbon Event Manager Reference.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef ActiveNonFloatingWindow ();

/*FrontNonFloatingWindow

Returns to the application the frontmost visible window that is not a floating window.

WindowRef FrontNonFloatingWindow ();
Return Value

The first visible window in the window list that is of a nonfloating class. See “Window Class Constants” for a description of window classes.
Discussion

Your application should call the FrontNonFloatingWindow function when you want to identify the frontmost visible window that is not a floating window. If you want to identify the frontmost visible window, whether floating or not, your application should call the function FrontWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontNonFloatingWindow ();

/*IsWindowModified

Obtains the modification state of the specified window.

Boolean IsWindowModified (
   WindowRef window
);
Parameters
window

The window whose modification state is to be obtained.
Return Value

true if the content of the window has been modified; otherwise, false. Newly created windows start out with their modification state automatically set to true. 
Discussion

Your application can use the functions IsWindowModified and SetWindowModified instead of maintaining its own separate record of the modification state of the content of a window. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowModified (
   WindowRef window
);

/*SelectWindow

Makes a window active.

void SelectWindow (
   WindowRef window
);
Parameters
window

The window that is to be made active.
Discussion

The SelectWindow function removes highlighting from the previously active window, brings the specified window to the front, highlights it, and generates the activate events to deactivate the previously active window and activate the specified window. If the specified window is already active, SelectWindow has no effect. Call SelectWindow when the user presses the mouse button while the cursor is in the content region of an inactive window.

Even if the specified window is invisible, SelectWindow brings the window to the front, activates the window, and deactivates the previously active window. Note that in this case, no active window is visible on the screen. If you do select an invisible window, be sure to call ShowWindow immediately to make the window visible (and accessible to the user). 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SelectWindow (
   WindowRef window
);

/*HIWindowGetProxyFSRef

Obtains the FSRef used to determine the proxy icon for a window.

OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
);
Parameters
inWindow

The window whose proxy FSRef is to be obtained.
outRef

On exit, the FSRef for the window’s proxy icon.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the specified window’s proxy icon has been specified using HIWindowSetProxyFSRef or SetWindowProxyAlias, HIWindowGetProxyFSRef returns noErr and a valid FSRef for the window’s proxy icon. If the window has no proxy icon, or if the icon was specified by calling SetWindowProxyCreatorAndType or SetWindowProxyIcon, this function returns an error.
Availability
Available in Mac OS X v10.4 and later. 
Declared In
MacWindows.h*/
OSStatus HIWindowGetProxyFSRef (
   WindowRef inWindow,
   FSRef * outRef
);

/*SetPortWindowPort

Sets the current graphics port to the window’s port.

void SetPortWindowPort (
   WindowRef window
);
Parameters
window

The window whose graphics port is to be set.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetPortWindowPort (
   WindowRef window
);

/*SizeWindow

Sets the size of a window. 

void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
);
Parameters
window

The window whose size is to be set.
w

On input, the new window width, in pixels. 
h

On input, the new window height, in pixels.
fUpdate

On input, a Boolean value that specifies whether any newly created area of the content region is to be accumulated into the update region (true) or not (false). You ordinarily pass a value of true to ensure that the area is updated. If you pass false, you’re responsible for maintaining the update region yourself. For a composited window, this parameter is ignored, and any views that intersect the newly exposed area of the window are automatically invalidated. For more information on adding rectangles to and removing rectangles from the update region, see InvalWindowRect and ValidWindowRect. 
Discussion

The SizeWindow function changes the size of the window’s graphics port rectangle to the dimensions specified by the w and h parameters, or does nothing if the values of w and h are both 0. The Window Manager redraws the window in the new size, recentering the title and truncating it if necessary.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SizeWindow (
   WindowRef window,
   short w,
   short h,
   Boolean fUpdate
);

/*GetWindowPort

Gets the window’s color graphics port.

CGrafPtr GetWindowPort (
   WindowRef window
);
Parameters
window

The window whose color graphics port is to be obtained.
Return Value

A pointer to the window’s color graphics port. See the QuickDraw Manager documentation for a description of the CGrafPtr data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
CGrafPtr GetWindowPort (
   WindowRef window
);

/*InvalWindowRect

Adds a rectangle to a window’s update region.

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to be updated.
bounds

Set this structure to specify, in local coordinates, a rectangle to be added to the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRect function informs the Window Manager that an area of a window should be redrawn.

See also the functions ValidWindowRect and InvalWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRect (
   WindowRef window,
   const Rect * bounds
);


/*MoveWindow

Moves a window on the desktop.

void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
);
Parameters
window

The window that is to be moved on the desktop.
hGlobal

On input, the new location, in global coordinates, of the left edge of the window’s port rectangle. 
vGlobal

On input, the new location, in global coordinates, of the top edge of the window’s port rectangle.
front

On input, a Boolean value specifying whether the window is to become the frontmost, active window. If the value of the front parameter is false, MoveWindow does not change its plane or status. If the value of the front parameter is true and the window isn’t active, MoveWindow makes it active by calling the SelectWindow function.
Discussion

The MoveWindow function moves the specified window to the location specified by the hGlobal and vGlobal parameters, without changing the window’s size. The upper-left corner of the window’s port rectangle is placed at the point (vGlobal, hGlobal). The local coordinates of the upper-left corner are unaffected.

Your application doesn’t normally call MoveWindow. When the user drags a window by dragging its title bar, you can call DragWindow which in turn calls MoveWindow when the user releases the mouse button. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void MoveWindow (
   WindowRef window,
   short hGlobal,
   short vGlobal,
   Boolean front
);

/*BringToFront

Brings a window to the front.

void BringToFront (
   WindowRef window
);
Parameters
window

The window that is to be brought to the front.
Discussion

The BringToFront function puts the specified window at the beginning of the window list and redraws the window in front of all others on the screen. It does not change the window’s highlighting or make it active.

Your application does not ordinarily call BringToFront. The user interface guidelines specify that the frontmost window should be the active window. To bring a window to the front and make it active, call the function SelectWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void BringToFront (
   WindowRef window
);


/*GetNextWindow

Returns the next window in a window list.

WindowRef GetNextWindow (
   WindowRef window
);
Parameters
window

The window to start from.
Return Value

The next window in a window list.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetNextWindow (
   WindowRef window
);

/*FrontWindow

Identifies the frontmost visible window.

WindowRef FrontWindow ();
Return Value

The first visible window in the window list. If there are no visible windows, FrontWindow returns NULL.
Discussion

Most applications should use call ActiveNonFloatingWindow or FrontNonFloatingWindow instead of FrontWindow because ActiveNonFloatingWindow and FrontNonFloatingWindow return the active and frontmost document window, respectively, skipping over other types of windows that may be in front of the active document, such as the menubar window, floating windows, help tags and toolbars.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowRef FrontWindow ();

/*CreateStandardWindowMenu

Creates a standard window menu for your application. 

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);
Parameters
inOptions

Option bits. Pass 0 or kWindowMenuIncludeRotate. For information on the kWindowMenuIncludeRotate constant, see “Rotating Window Menu Item Constant”.
outMenu

On output, a new menu reference that contains the standard window menu items and commands. 
Return Value

A result code. See “Window Manager Result Codes”. An operating system status code.
Discussion

You can call this function to create a window menu for your application. To register a window to be tracked by this menu, you either create your window with CreateNewWindow, passing the kWindowInWindowMenuAttribute, or you can use ChangeWindowAttributes after the window is created. The Toolbox takes care of acting on the standard items such as zoom and minimize, as well as bringing selected windows to the front. All you need to do is insert the menu in your menu bar (typically at the end of your menu list) and register your windows, and the Toolbox does the rest.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateStandardWindowMenu (
   OptionBits inOptions,
   MenuRef * outMenu
);

/*GetWindowResizeLimits

Returns the minimum and maximum content sizes for a window. 

OSStatus GetWindowResizeLimits (
   WindowRef inWindow,
   HISize * outMinLimits,
   HISize * outMaxLimits
);
Parameters
inWindow

The window whose minimum and maximum content sizes are to be obtained.
outMinLimits

On return, the window’s minimum content size. Pass NULL if you don’t want this information. For information on the HISize data type, see HIGeometry.h.
outMaxLimits

On return, the window’s maximum content size. Pass NULL if you don’t want this information. For information on the HISize data type, see HIGeometry.h.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/

OSStatus GetWindowResizeLimits (
   WindowRef inWindow,
   HISize * outMinLimits,
   HISize * outMaxLimits
);

/*GetWindowPortBounds

Obtains the bounds of the window port. 

Rect * GetWindowPortBounds (
   WindowRef window,
   Rect * bounds
);
Parameters
window

The window whose port bounds you want.
bounds

A pointer to a Rect structure. On return, the Rect structure contains the bounds of the window port.
Return Value

The same value (pointer to a Rect structure) that was passed to GetWindowPortBounds in the bounds parameter.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Rect * GetWindowPortBounds (
   WindowRef window,
   Rect * bounds
);

/*DragWindow

Moves a window on the screen when the user drags it by its drag region.

void DragWindow (
   WindowRef window,
   Point startPt,
   const Rect * boundsRect
);
Parameters
window

The window that is to be dragged.
startPt

On input, the location, in global coordinates, of the cursor at the time the user pressed the mouse button. Your application retrieves this point from the where field of the event structure. 
boundsRect

On input, a pointer to a rectangle, given in global coordinates, that limits the region to which a window can be dragged. If the mouse button is released when the cursor is outside the limits of boundsRect, DragWindow returns without moving the window (or, if it was inactive, without making it the active window).

In CarbonLib and Mac OS X, this parameter can be NULL to indicate that there are no restrictions on window movement. This parameter is ignored by CarbonLib and Mac OS X v10.0 through v10.2; it is obeyed in Mac OX v10.3 and later.
Discussion

The DragWindow function moves the window around the screen, following the movement of the cursor until the user releases the mouse button. If the Command key was not pressed when the mouse button was pressed, DragWindow calls SelectWindow to make the window active before it drags the window. If the Command key was pressed when the mouse button was pressed, DragWindow moves the window without making it active.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void DragWindow (
   WindowRef window,
   Point startPt,
   const Rect * boundsRect
);

/*IsWindowVisible

Indicates whether the window frame is currently visible.

Boolean IsWindowVisible (
   WindowRef window
);
Parameters
window

The window to query.
Return Value

A Boolean value indicating whether or not the window is visible. If true, the window is visible. If false, the window is invisible. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean IsWindowVisible (
   WindowRef window
);

/*ShowHide

Sets a window’s visibility.

Not recommended

void ShowHide (
   WindowRef window,
   Boolean showFlag
);
Parameters
window

On input, a pointer to the window structure. 
showFlag

On input, a Boolean value that specifies its visibility: true makes a window visible; false makes it invisible. 
Discussion

The ShowHide function sets a window’s visibility to the status specified by the showFlag parameter. If the value of showFlag is true, ShowHide makes the window visible if it’s not already visible and has no effect if it’s already visible. If the value of showFlag is false, ShowHide makes the window invisible if it’s not already invisible and has no effect if it’s already invisible.

The ShowHide function never changes the highlighting or front-to-back ordering of windows and generates no activate events.

Use ShowHide only where you need more control than that provided by HideWindow and ShowWindow. Do not, for example, use ShowHide to hide the active window without making another window active. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use ShowWindow or HideWindow instead.
Declared In
MacWindows.h*/

void ShowHide (
   WindowRef window,
   Boolean showFlag
);

/*GrowWindow

Allows the user to change the size of a window.

Not recommended

long GrowWindow (
   WindowRef window,
   Point startPt,
   const Rect * bBox
);
Parameters
window

On input, a pointer to the window structure of the window to drag. 
startPt

On input, the location of the cursor at the time the mouse button was first pressed, in global coordinates. Your application retrieves this point from the where field of the event structure. 
bBox

On input, a pointer to a rectangle structure that specifies the limits on the vertical and horizontal measurements of the port rectangle, in pixels.

Although the bBox parameter gives the address of a structure which is in the form of the Rect data type, the four numbers in the structure represent lengths, not screen coordinates. The top, left, bottom, and right fields of the bBox parameter specify the minimum vertical measurement (top), the minimum horizontal measurement (left), the maximum vertical measurement (bottom), and the maximum horizontal measurement (right).

The minimum measurements must be large enough to allow a manageable rectangle 64 pixels on a side is typical. Because the user cannot ordinarily move the cursor off the screen, you can safely set the upper bounds to the largest possible length (65,535 pixels) when you’re using GrowWindow to follow cursor movements.

Return Value

A long integer that specifies the new dimensions, in pixels, of the resulting window: the height in the high-order word of the returned long-integer value and the width in the low-order word. A return value of 0 means that the new size is the same as the size of the current port rectangle. 
Discussion

The GrowWindow function displays an outline (grow image) of the window as the user moves the cursor to make the window larger or smaller; it handles all user interaction until the user releases the mouse button. After calling GrowWindow, you call the function SizeWindow to change the size of the window.

The GrowWindow function moves a dotted-line image of the window’s right and lower edges around the screen, following the movements of the cursor until the mouse button is released. You can use the functions HiWord and LoWord, described in the Mathematical and Logical Utilities Reference , to retrieve only the high-order and low-order words, respectively. 
Special Considerations

In non-Carbon implementations of GrowWindow on Mac OS 8 and 9, the maximum size that the specified window is allowed to grow to is actually one less than the values specified in the bBox parameter. For example, if you pass the values 500 in the bBox.bottom field and 600 in the bBox.right field, the maximum height and width of the window would actually be 499 and 599, respectively.

However, in Carbon, the maximum height and width allowed for the specified window is equal to the values passed in the bBox.bottom and bBox.right fields, respectively.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use ResizeWindow instead.
Declared In
MacWindows.h*/

long GrowWindow (
   WindowRef window,
   Point startPt,
   const Rect * bBox
);

/*BeginUpdate

Starts updating a window when you receive an update event for that window.

void BeginUpdate (
   WindowRef window
);
Parameters
window

The window that is to be updated when an update event is received. Your application gets this information from the message field in the update event structure.
Discussion

The BeginUpdate function limits the visible region of the window’s graphics port to the intersection of the visible region and the update region it then sets the window’s update region to an empty region. After calling BeginUpdate, your application redraws either the entire content region or only the visible region. In either case, only the parts of the window that require updating are actually redrawn on the screen.

Every call to BeginUpdate must be matched with a subsequent call to EndUpdate after your application redraws the content region. BeginUpdate and EndUpdate can’t be nested. That is, you must call EndUpdate before the next call to BeginUpdate. 
Special Considerations

On classic Mac OS, if you don’t call BeginUpdate when you receive an update event, the Event Manager continues to send update events until you do. On Mac OS X, you only receive one update event. If you don’t call BeginUpdate, you won’t receive any further update events until the window is invalidated again.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void BeginUpdate (
   WindowRef window
);

/*EndUpdate

Finishes updating a window.

void EndUpdate (
   WindowRef window
);
Parameters
window

The window for which updating is to be finished.
Discussion

The EndUpdate function restores the normal visible region of a window’s graphics port. When you receive an update event for a window, you call BeginUpdate, redraw the update region, and then call EndUpdate. Each call to BeginUpdate must be balanced by a subsequent call to EndUpdate. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void EndUpdate (
   WindowRef window
);

/*FindWindow

Maps the location of the cursor to a part of the screen or a region of a window when your application receives a mouse-down event.

WindowPartCode FindWindow (
   Point thePoint,
   WindowRef * window
);
Parameters
thePoint

The point, in global coordinates, where the mouse-down event occurred. Your application retrieves this information from the where field of the event structure. 
window

A pointer to the window in which the mouse-down event occurred. FindWindow produces NULL if the mouse-down event occurred outside a window.
Return Value

The location of the cursor when the user pressed the mouse button; see “Window Part Code Constants”. See the description of the WindowPartCode data type.
Discussion

You typically call the function FindWindow whenever you receive a mouse-down event. The FindWindow function helps you dispatch the event by reporting whether the cursor was in the menu bar or in a window when the mouse button was pressed. If the cursor was in a window, the function will produce both a pointer to the window and a constant that identifies the region of the window in which the event occurred.

If you are using the Carbon event handlers to handle events, a faster way of getting the window and part that received a mouse-down event is to get the kEventParamWindowRef and kEventParamWindowPartCode parameters from the event.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowPartCode FindWindow (
   Point thePoint,
   WindowRef * window
);

/*SetWindowProperty

Associates an arbitrary piece of data with a window.

OSStatus SetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 propertySize,
   const void * propertyBuffer
);
Parameters
window

The window with which data is to be associated.
propertyCreator

The creator code (typically, the application’s signature) of the data to be associated. 
propertyTag

A value identifying the data to be associated. You define the tag your application uses to identify the data; this code is not to be confused with the file type for the data. 
propertySize

The size of the data to be associated. 
propertyBuffer

A pointer to the data to be associated. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Data set with the SetWindowProperty function may be obtained with the function GetWindowProperty and removed with the function RemoveWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus SetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 propertySize,
   const void * propertyBuffer
);

/*GetWindowProperty

Obtains a piece of data that is associated with a window.

OSStatus GetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);
Parameters
window

The window to be examined for associated data.
propertyCreator

The creator code (typically, the application’s signature) of the associated data to be obtained. 
propertyTag

The application-defined code identifying the associated data to be obtained. 
bufferSize

The size of the associated data to be obtained. If the size of the data is unknown, use the function GetWindowPropertySize to get the data’s size. If the size specified does not match the actual size of the property, GetWindowProperty only retrieves data up to the size specified or up to the actual size of the property, whichever is smaller, and an error is returned. 
actualSize

On input, a pointer to a value. On return, the value specifies the actual size of the obtained data. You may pass NULL for the actualSize parameter if you are not interested in this information.
propertyBuffer

On input, a pointer to a buffer. On return, this buffer contains a copy of the data that is associated with the specified window. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The data retrieved by the GetWindowProperty function must have been previously associated with the window with the function SetWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag,
   UInt32 bufferSize,
   UInt32 * actualSize,
   void * propertyBuffer
);

/*TrackGoAway

Tracks the cursor when the user presses the mouse button while the cursor is in the close box.

Boolean TrackGoAway (
   WindowRef window,
   Point thePt
);
Parameters
window

On input, the window in which the mouse-down event occurred.
thePt

On input, the location of the cursor at the time the mouse button was pressed. Your application receives this point from the where field of the event structure. 
Return Value

When the mouse button is released, TrackGoAway removes the highlighting from the close box and returns true if the cursor is within the close region and false if it is not. 
Discussion

The TrackGoAway function tracks cursor activity when the user presses the mouse button while the cursor is in the close box, retaining control until the user releases the mouse button. While the button is down, TrackGoAway highlights the close box as long as the cursor is in the close region.

Your application calls the TrackGoAway function when it receives a result code of inGoAway from FindWindow. If TrackGoAway returns true, your application calls its own function for closing a window, which can call DisposeWindow to remove the window from the screen. If TrackGoAway returns false, your application does nothing. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean TrackGoAway (
   WindowRef window,
   Point thePt
);

/*TrackBox

Tracks clicks in the collapse, close, size, and zoom boxes, and clicks of the toolbar button.

Boolean TrackBox (
   WindowRef window,
   Point thePt,
   WindowPartCode partCode
);
Parameters
window

The window in which the mouse button was pressed.
thePt

On input, the location of the cursor when the mouse button was pressed. Your application receives this point from the where field in the event structure. 
partCode

On input, the part code (inZoomIn, inZoomOut, inGoAway, inGrow, inCollapseBox, or inToolbarButton) returned by FindWindow; see “Part Identifier Constants”. 
Return Value

A Boolean whose value is true if the specified part was clicked; otherwise, false. If TrackBox returns true, it also removes highlighting from the specified part.
Discussion

The TrackBox function tracks the cursor when the user presses the mouse button while the cursor is in the specified part, retaining control until the mouse button is released. While the button is down, TrackBox highlights the part while the cursor is in the part’s region.

When the mouse button is released, TrackBox removes the highlighting from the part and returns true if the cursor is within the part’s region and false if it is not.

If TrackBox returns true after tracking the close box, your application should close the window. If TrackBox returns true after tracking the grow box, your application should call ResizeWindow. If TrackBox returns true after tracking the collapse box, your application should call CollapseWindow. When tracking the toolbar button, your application should call ShowHideWindowToolbar.

Your application calls the TrackBox function when it receives a result code of inZoomIn or inZoomOut from the function FindWindow. If TrackBox returns true, your application calculates the standard state, if necessary, and calls the function ZoomWindow to zoom the window. If TrackBox returns false, your application does nothing.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

Boolean TrackBox (
   WindowRef window,
   Point thePt,
   WindowPartCode partCode
);

/*ZoomWindow

Zooms the window when the user has pressed and released the mouse button with the cursor in the zoom box.

void ZoomWindow (
   WindowRef window,
   WindowPartCode partCode,
   Boolean front
);
Parameters
window

The window that is to be zoomed.
partCode

On input, the part code (either inZoomIn or inZoomOut) returned by the FindWindow function; see “Part Identifier Constants”. 
front

On return, a Boolean value that determines whether the window is to be brought to the front. If the value of front is true, the window necessarily becomes the frontmost, active window. If the value of front is false, the window’s position in the window list does not change. Note that if a window was active before it was zoomed, it remains active even if the value of front is false. 
Discussion

The ZoomWindow function zooms a window in or out, depending on the value of the partCode parameter. Your application calls ZoomWindow, passing it the part code returned by FindWindow, when it receives a result of true from TrackBox. The ZoomWindow function then changes the window’s port rectangle to either the user state (if the part code is inZoomIn) or the standard state (if the part code is inZoomOut), as stored in the window state structure, described in the section WStateData.

If the part code is inZoomOut, your application ordinarily calculates and sets the standard state before calling ZoomWindow.

For best results, call the QuickDraw function EraseRect, passing the window’s graphics port as the port rectangle, before calling ZoomWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void ZoomWindow (
   WindowRef window,
   WindowPartCode partCode,
   Boolean front
);

/*InvalRect

Adds a rectangle to a window’s update region.

Unsupported

void InvalRect (
   const Rect *badRect
);
Parameters
badRect

On input, a pointer to a rectangle, in local coordinates, that is to be added to a window’s update region. 
Discussion

The InvalRect function adds a specified rectangle to the update region of the window whose graphics port is the current port. Specify the rectangle in local coordinates. 

Both your application and the Window Manager use the InvalRect function. When the user enlarges a window, for example, the Window Manager uses InvalRect to add the newly created content region to the update region. Your application uses InvalRect to add the two rectangles formerly occupied by the scroll bars in the smaller content area. 
Availability
Unsupported.
Carbon Porting Notes

Calls InvalWindowRect, which takes a window pointer as an additional parameter.

Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/

void InvalRect (
   const Rect *badRect
);

/*ActivateWindow

Activates or deactivates a window. 

OSStatus ActivateWindow (
   WindowRef inWindow,
   Boolean inActivate
);
Parameters
inWindow

The window to activate or deactivate.
inActivate

Pass true to activate the window, false otherwise. 
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ActivateWindow (
   WindowRef inWindow,
   Boolean inActivate
);

/*SetWindowClass

Sets the class of a window.

OSStatus SetWindowClass (
   WindowRef window,
   WindowClass inClass
);
Parameters
window

The window whose class you want to set.
inClass

The class that is to be set. See “Window Class Constants” for a list of possible window classes. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

A window’s class categorizes the window for purposes of display (that is, both the window’s appearance and its display ordering) and tracking.

Instead of calling this function, you should call SetWindowGroup to move a window into the group of the desired class.
Availability
Available in CarbonLib 1.1 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowClass (
   WindowRef window,
   WindowClass inClass
);

/*GetGrayRgn

Returns a handle to the current desktop region.

Not recommended

RgnHandle GetGrayRgn ();
Parameters
Return Value

A handle to the current desktop region from the global variable GrayRgn. See the QuickDraw Manager documentation for a description of the RgnHandle data type.
Discussion

When your application calls DragWindow to let the user drag a window, it can use GetGrayRgn to set the limiting rectangle to the entire desktop area. The desktop region represents all available screen space, that is, the desktop area displayed by all monitors attached to the computer. 
Special Considerations

Your application should not modify the desktop region.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use GetAvailableWindowPositioningBounds if you want to determine where you can position your windows.
Declared In
MacWindows.h*/
RgnHandle GetGrayRgn ();

/*SetWindowGroupParent

Sets a window group to be the parent of another window group. 

OSStatus SetWindowGroupParent (
   WindowGroupRef inGroup,
   WindowGroupRef inNewGroup
);
Parameters
inGroup

The window group whose parent window group is to be set. The specified window group cannot contain any windows at the time of this call. 
inNewGroup

The window group that is to be the parent of inGroup. For information on this data type, see WindowGroupRef.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You can nest groups within each other using this function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetWindowGroupParent (
   WindowGroupRef inGroup,
   WindowGroupRef inNewGroup
);


/*SetWindowGroup

Assigns a window to a window group. 

OSStatus SetWindowGroup (
   WindowRef inWindow,
   WindowGroupRef inNewGroup
);
Parameters
inWindow

The window that is to be assigned to a window group.
inNewGroup

The window group. For information on this data type, see WindowGroupRef.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus SetWindowGroup (
   WindowRef inWindow,
   WindowGroupRef inNewGroup
);

/*GetWindowGroup

Obtains the window group associated with a window. 

WindowGroupRef GetWindowGroup (
   WindowRef inWindow
);
Parameters
inWindow

The window whose window group is to be obtained.
Return Value

The window group reference for the window specified by inWindow. For information on this data type, see WindowGroupRef.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
WindowGroupRef GetWindowGroup (
   WindowRef inWindow
);

/*CreateWindowGroup

Creates a window group. 

OSStatus CreateWindowGroup (
   WindowGroupAttributes inAttributes,
   WindowGroupRef * outGroup
);
Parameters
inAttributes

Attributes for the new window group. See “Window Group Attributes” for a listing of possible attributes.
outGroup

For information on this data type, see “WindowGroupRef”.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateWindowGroup (
   WindowGroupAttributes inAttributes,
   WindowGroupRef * outGroup
);

/*HIWindowFlush

Flushes any dirty areas a window might have.

OSStatus HIWindowFlush (
   WindowRef window
);
Parameters
window

The window to flush.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

This function allows you to manually flush dirty areas of a window to the screen. This is the preferred way to flush window buffers in Mac OS X v10.3 and later. If called for a composited window, this function also renders any views in the window that are invalid.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacWindows.h*/

OSStatus HIWindowFlush (
   WindowRef window
);

/*GetWindowRegion

Obtains a handle to a specific window region.

OSStatus GetWindowRegion (
   WindowRef window,
   WindowRegionCode inRegionCode,
   RgnHandle ioWinRgn
);
Parameters
window

The window for which a window region handle is to be obtained.
inRegionCode

A constant representing the window region whose handle you want to obtain; see “Window Region Constants” for a list of possible values. 
ioWinRgn

On input, a handle to a region created by your application. On return, the handle is set to the specified window region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The GetWindowRegion function produces a handle to a window definition function’s window region in response to a kWindowMsgGetRegion message. The visibility of the window is unimportant for GetWindowRegion to work correctly. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowRegion (
   WindowRef window,
   WindowRegionCode inRegionCode,
   RgnHandle ioWinRgn
);

/*InvalWindowRgn

Adds a region to a window’s update region.

OSStatus InvalWindowRgn (
   WindowRef window,
   RgnHandle region
);
Parameters
window

The window containing the region that you want to update.
region

Set this region to specify, in local coordinates, the area to be added to the window’s update region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The InvalWindowRgn function informs the Window Manager that an area of a window should be redrawn.

See also the functions InvalWindowRect and ValidWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus InvalWindowRgn (
   WindowRef window,
   RgnHandle region
);

/*PaintBehind

Redraws a series of windows in the window list.

Not recommended

void PaintBehind (
   WindowRef startWindow,
   RgnHandle clobberedRgn
);
Parameters
startWindow

On input, a pointer to the window’s complete window structure. 
clobberedRgn

On input, a handle to the region that has become invalid. 
Discussion

The Window Manager calls the PaintBehind function; your application does not normally need to. PaintBehind calls PaintOne for startWindow and all the windows behind startWindow, clipped to clobberedRgn. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

If you are using this function to redraw your own floating windows, you should just use the standard floating window class instead. 
Declared In
MacWindows.h*/
void PaintBehind (
   WindowRef startWindow,
   RgnHandle clobberedRgn
);

/*CreateWindowFromResource

Creates a window from 'wind' resource data.

OSStatus CreateWindowFromResource (
   SInt16 resID,
   WindowRef * outWindow
);
Parameters
resID

The resource ID of a resource of type ‘wind’. Pass in the ID of the 'wind' resource to be used to create the window. 
outWindow

On input, a pointer to a value of type WindowRef. On return, the window pointer points to the newly created window.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The CreateWindowFromResource function loads a window from a 'wind' resource. The Window Manager creates the window invisibly and places it at the front of the window’s window group. After calling CreateWindowFromResource, you should set any desired associated data—using Window Manager or Control Manager accessor functions—then call the function TransitionWindow or ShowWindow to display the window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus CreateWindowFromResource (
   SInt16 resID,
   WindowRef * outWindow
);


/*GetWindowFromPort

Gets a window reference from a CGrafPtr data type.

WindowRef GetWindowFromPort (
   CGrafPtr port
);
Parameters
port

The port to query.
Return Value

The window reference obtained from the port specified by port, or NULL if the port parameter is not actually attached to a window.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowRef GetWindowFromPort (
   CGrafPtr port
);

/*GetWindowKind

Returns a window’s window kind.

short GetWindowKind (
   WindowRef window
);
Parameters
window

The window whose window kind is to be returned.
Return Value

An integer representing the window kind; see “Window Kinds”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
short GetWindowKind (
   WindowRef window
);

/*NewWindowDefUPP

Creates a new UPP for a window definition.

WindowDefUPP NewWindowDefUPP (
   WindowDefProcPtr userRoutine
);
Parameters
userRoutine

For information, see WindowDefProcPtr. 
Return Value

For a description of the WindowDefUPP data type, see WindowDefUPP.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

WindowDefUPP NewWindowDefUPP (
   WindowDefProcPtr userRoutine
);

/*DisposeWindowDefUPP

Disposes of the UPP for your window definition.

void DisposeWindowDefUPP (
   WindowDefUPP userUPP
);
Parameters
userUPP

The UPP that is to be disposed of. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

void DisposeWindowDefUPP (
   WindowDefUPP userUPP
);

/*CreateCustomWindow

Creates a custom window based on a registered toolbox object class or a custom window root view. 

OSStatus CreateCustomWindow (
   const WindowDefSpec * def,
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);
Parameters
def

For information on this data type, see WindowDefSpec.
windowClass

The class the custom window should belong to. This value determines the layer ordering of the custom window. 
attributes

Attributes for the window. See “Window Attributes” for a list of possible attributes. 
contentBounds

Pointer to a Rect structure in global coordinates indicating the dimensions of the window’s content region. 
outWindow

On return, the newly-created window.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateCustomWindow (
   const WindowDefSpec * def,
   WindowClass windowClass,
   WindowAttributes attributes,
   const Rect * contentBounds,
   WindowRef * outWindow
);

/*GetWMgrPort

Gets a pointer to the monochrome Window Manager port on a system that does not support Color QuickDraw. 

Unsupported

void GetWMgrPort (
   GrafPtr *wPort
);
Parameters
wPort

On output, a monochrome Window Manager port. 
Discussion

The GetWMgrPort function places a pointer to the Window Manager port in the value referenced through the parameter wPort. The Window Manager port is a graphics port that occupies all of the main screen. Never draw directly into either of the Window Manager ports except from a window definition function. If you need to draw to the screen, create a new graphics port with OpenPort or OpenCPort and use that instead. 
Special Considerations

Do not change any regions of the Window Manager port. If you do, the Window Manager might not handle overlapping windows properly.
Carbon Porting Notes

Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.
Declared In
MacWindows.h*/

void GetWMgrPort (
   GrafPtr *wPort
);


/*GetCWMgrPort

Gets a pointer to the color Window Manager port on a system that supports Color QuickDraw. 

Unsupported

void GetCWMgrPort (
   CGrafPtr *wMgrCPort
);
Parameters
wMgrCPort

On output, a Color Window Manager port. 
Discussion

The GetCWMgrPort function places a pointer to the color Window Manager port in the value referenced through the parameter wMgrCPort. The GetCWMgrPort function is available only on computers with Color QuickDraw.

The Window Manager port is a graphics port that occupies all of the main screen. Ordinarily, your application doesn’t need to access the Window Manager port.

Never draw directly into either of the Window Manager ports except from a window definition function. If you need to draw to the screen, create a new graphics port with OpenPort or OpenCPort and use that instead. 
Special Considerations

Do not change any regions of the Window Manager port. If you do, the Window Manager might not handle overlapping windows properly. 
Carbon Porting Notes

Carbon does not support accessing the Window Manager port. You should draw into your own graphics port instead.
Declared In
MacWindows.h*/

void GetCWMgrPort (
   CGrafPtr *wMgrCPort
);

/*GetWindowGoAwayFlag

Indicates whether or not a window has a close box.

Unsupported

Boolean GetWindowGoAwayFlag (
   WindowRef window
);
Parameters
window

On input, a pointer to the window. 
Return Value

A Boolean value. If true, the window has a close box. If false, the window does not have a close box. 
Availability
Carbon Porting Notes

Use GetWindowAttributes instead. 
Declared In
MacWindows.h*/

Boolean GetWindowGoAwayFlag (
   WindowRef window
);

/*PinRect

Returns the point within the specified rectangle that is closest to the specified point.

long PinRect (
   const Rect * theRect,
   Point thePt
);
Parameters
theRect

On input, a pointer to a rectangle in which the point is to be contained. 
thePt

On input, a pointer to the point to be contained. 
Return Value

A long integer that specifies a point within the specified rectangle that is as close as possible to the specified point. (The high-order word of the returned long integer is the vertical coordinate; the low-order word is the horizontal coordinate. 
Discussion

DragGrayRgn uses the PinRect function to contain a point within a specified rectangle. If the specified point is within the rectangle, PinRect returns the point itself. If not, then
if the horizontal position is to the left of the rectangle, PinRect returns the left edge as the horizontal coordinate 
if the horizontal position is to the right of the rectangle, PinRect returns the right edge minus 1 as the horizontal coordinate 
if the vertical position is above the rectangle, PinRect returns the top edge as the vertical coordinate 
if the vertical position is below the rectangle, PinRect returns the bottom edge minus 1 as the vertical coordinate 

The 1 is subtracted when the point is below or to the right of the rectangle so that a pixel drawn at that point lies within the rectangle.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

long PinRect (
   const Rect * theRect,
   Point thePt
);

/*GetWVariant

Returns a window’s variation code.

Not recommended

short GetWVariant (
   WindowRef window
);
Parameters
window

On input, a pointer to the window structure. 
Return Value

A short integer that specifies the variation code of the specified window. Depending on the window definition function, the result of GetWVariant can represent one of the standard variation codes or a variation code defined by your own window definition function. 
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use GetWindowAttributes instead.
Declared In
MacWindows.h*/

short GetWVariant (
   WindowRef window
);

/*ShowSheetWindow

Shows a sheet window using appropriate visual effects.

OSStatus ShowSheetWindow (
   WindowRef inSheet,
   WindowRef inParentWindow
);
Parameters
inSheet

The window sheet that is to be shown.
inParentWindow

The parent of the window specified by inSheet.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/

OSStatus ShowSheetWindow (
   WindowRef inSheet,
   WindowRef inParentWindow
);

/*HideSheetWindow

Hides a sheet window using appropriate visual effects.

OSStatus HideSheetWindow (
   WindowRef inSheet
);
Parameters
inSheet

The window sheet that is to be hidden.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus HideSheetWindow (
   WindowRef inSheet
);

/*SetWindowStandardState

Sets a window’s standard zoom rectangle. 

void SetWindowStandardState (
   WindowRef window,
   const Rect * rect
);
Parameters
window

The window whose standard zoom rectangle is to be set.
rect

On input, a rectangle (in global coordinates) representing the window’s standard zoom rectangle. A window’s standard zoom rectangle is the window content bounds when the window is zoomed out to its largest extent.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWindowStandardState (
   WindowRef window,
   const Rect * rect
);

/*ValidWindowRect

Removes a rectangle from a window’s update region.

OSStatus ValidWindowRect (
   WindowRef window,
   const Rect * bounds
);
Parameters
window

The window containing the rectangle you want to remove from the update region.
bounds

Set this structure to specify, in local coordinates, a rectangle to be removed from the window’s update region. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The ValidWindowRect function informs the Window Manager that an area of a window no longer needs to be redrawn. The ValidWindowRect function is similar to the ValidRect function, but ValidWindowRect allows the window that it operates upon to be explicitly specified, instead of operating on the current graphics port, so ValidWindowRect does not require the graphics port to be set before its use.

See also the functions InvalWindowRect and ValidWindowRgn. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ValidWindowRect (
   WindowRef window,
   const Rect * bounds
);

/*GetWindowUpdateRgn


Unsupported

void GetWindowUpdateRgn (
   WindowRef window,
   RgnHandle r
);
Parameters
window
r
Availability
Carbon Porting Notes

Use the GetWindowRegion function with the kWindowUpdateRgn selector instead.
Declared In
MacWindows.h*/
void GetWindowUpdateRgn (
   WindowRef window,
   RgnHandle r
);

/*InvalRgn

Adds a region to a window’s update region.

Unsupported

void InvalRgn (
   RgnHandle badRgn
);
Parameters
badRgn

On input, the region, in local coordinates, that is to be added to a window’s update region. 
Discussion

The InvalRgn function adds a specified region to the update region of the window whose graphics port is the current port. Specify the region in local coordinates. 
Availability
Unsupported.
Carbon Porting Notes

Call InvalWindowRgn, which takes a window pointer as an additional parameter. Invalidation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/
void InvalRgn (
   RgnHandle badRgn
);

/*SetThemeWindowBackground

Sets a window’s background theme.

OSStatus SetThemeWindowBackground (
   WindowRef inWindow,
   ThemeBrush inBrush
   Boolean inUpdate
);
Parameters
inWindow

The window whose background theme is to be set.
inBrush

The theme brush that determines how the window background is painted. For information on theme brushes, see the Appearance Manager documentation.
inUpdate

A Boolean whose value is true if you want the window to be redrawn immediately using the new background brush; otherwise, false.
Return Value

A result code. See “Window Manager Result Codes” for a list of possible values.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus SetThemeWindowBackground (
   WindowRef inWindow,
   ThemeBrush inBrush,
   Boolean inUpdate
);

/*GetNewWindow

Creates a new monochrome window from a window resource. 

Not recommended

WindowRef GetNewWindow (
   short windowID,
   void * wStorage,
   WindowRef behind
);
Parameters
windowID

On input, the resource ID of the 'WIND' resource that defines the properties of the window. 
wStorage

On input, a pointer to memory space for the window structure. If you specify a value of null for wStorage, the GetNewWindow function allocates the window structure as a nonrelocatable object in the heap. You can reduce the chances of heap fragmentation by allocating the memory your application needs for window structures early in your initialization code. Whenever you need to create a window, you can allocate memory from your own block and pass a pointer to it in the wStorage parameter. 
behind

On input, a pointer to the window that appears immediately in front of the new window on the desktop. To place a new window in front of all other windows on the desktop, specify a value of (WindowRef)-1l. When you place a window in front of all others, GetNewWindow removes the highlighting from the previously active window, highlights the newly created window, and generates the appropriate activate events. Note that if you create an invisible window in front of all others on the desktop, the user sees no active window until you make the new window visible (or make another window active). To place a new window behind all other windows, specify a value of null. 
Return Value

A pointer to the newly created color window structure. See the QuickDraw Manager documentation for a description of the WindowRef data type.
Discussion

The GetNewWindow function takes the same parameters as GetNewCWindow and returns a value of type WindowRef. The only difference is that it creates a monochrome graphics port, not a color graphics port, regardless of the presence of a corresponding ' wctb ' resource (it loads the resource but doesn’t use it). The window structure and graphics port structure that describe monochrome and color graphics ports are the same size and can be used interchangeably in most Window Manager functions. 

The GetNewWindow function creates a new window from the specified window resource and returns a pointer to the newly created window structure. You can use the returned window pointer to refer to this window in most Window Manager functions. If GetNewWindow is unable to read the window or window definition function from the resource file, it returns null.

If the window’s definition function (specified in the window resource) is not already in memory, GetNewWindow reads it into memory and stores a handle to it in the window structure. It allocates space in the application heap for the structure and content regions of the window. 

To create the window, GetNewWindow retrieves the window characteristics from the window resource and then calls the function NewWindow, passing the characteristics as parameters. 
Special Considerations

If you let the Window Manager create the window structure in your application’s heap, call DisposeWindow to dispose of the window structure. If you allocated the memory for the window structure yourself and passed a pointer to the storage to GetNewWindow, use CloseWindow to close the window and the appropriate disposal function (determined by how you have allocated memory) to dispose of the window structure.
Version Notes

The GetNewWindow function was originally implemented prior to Color QuickDraw. In Mac OS 8, you should call the Color QuickDraw function GetNewCWindow instead of GetNewWindow to programmatically create a window, because Color QuickDraw is always available in Mac OS 8. Use of this function is not recommended with Mac OS 8 and later. GetNewWindow is described here only for completeness.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

If you must get your window definition from a resource, use CreateWindowFromResource. Otherwise use CreateWindowFromNib or CreateNewWindow.
Declared In
MacWindows.h*/
WindowRef GetNewWindow (
   short windowID,
   void * wStorage,
   WindowRef behind
);

/*RemoveWindowProxy

Dissociates a file from a window.

OSStatus RemoveWindowProxy (
   WindowRef window
);
Parameters
window

The window for which you want to remove the associated file.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The RemoveWindowProxy function redraws the window title bar after removing all data associated with a given file, including the proxy icon, path menu, and file data. 
Special Considerations

On Mac OS 8.x and Mac OS 9.x, you must save and restore the current graphics port—by calling the QuickDraw functions GetPort and SetPort—around each call to the RemoveWindowProxy function.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus RemoveWindowProxy (
   WindowRef window
);

/*TransitionWindow

Shows, hides, moves, or resizes a window with appropriate animation and sound.

OSStatus TransitionWindow (
   WindowRef inWindow,
   WindowTransitionEffect inEffect,
   WindowTransitionAction inAction,
   const Rect * inRect
);
Parameters
inWindow

The window on which to act.
inEffect

The type of visual effect to use. TransitionWindow supports the Zoom, Slide, Fade, and Genie transition effects. The Slide effect is supported on Mac OS X and in CarbonLib 1.5 and later. The Fade and Genie effects are supported on Mac OS X v10.3 and later. See “Window Transition Effect Constants” for constants and descriptions of these effects.
inAction

The action to take. TransitionWindow supports the Show, Hide, Move, and Resize actions. The Move and Resize actions are supported on Mac OS X and in CarbonLib 1.5 and later. See “Window Transition Action Constants” for possible values.
inRect

A screen rect in global coordinates, or NULL for some transition actions.The interpretation of the rect is dependent on the transition action. For details, see the documentation for each action.

If you pass kWindowShowTransitionAction in the action parameter then, before calling TransitionWindow, set the rectangle to specify the dimensions and position, in global coordinates, of the area from which the zoom is to start. If you pass NULL, TransitionWindow uses the center of the display screen as the source rectangle.

If you pass kWindowHideTransitionAction in the action parameter then, before calling TransitionWindow, set the rectangle to specify the dimensions and position, in global coordinates, of the area at which the zoom is to end.

If you pass NULL, TransitionWindow uses the center of the display screen as the destination rectangle.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The TransitionWindow function displays an animation of a window’s transition between the open and closed states, such as that displayed by the Finder. TransitionWindow uses the rectangle specified in the rect parameter for one end of the animation (the source or the destination of the zoom, depending upon whether the window is being shown or hidden, respectively) and the window’s current size and position for the other end of the animation. TransitionWindow also plays sounds appropriate to the current theme for the opening and closing actions. 

Your application may use TransitionWindow instead of the functions ShowWindow and HideWindow. Like these pre–Mac OS 8.5 Window Manager functions, TransitionWindow generates the appropriate update and active events when it shows and hides windows. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus TransitionWindow (
   WindowRef inWindow,
   WindowTransitionEffect inEffect,
   WindowTransitionAction inAction,
   const Rect * inRect
);

/*GetWindowProxyFSSpec

Obtains a file system specification structure for the file that is associated with a window.

Not recommended

OSStatus GetWindowProxyFSSpec (
   WindowRef window,
   FSSpec * outFile
);
Parameters
window

A pointer to the window for which you wish to determine the associated file. 
outFile

On input, a pointer to an FSSpec structure. On return, this structure contains a copy of the file system specification data for the file associated with the specified window. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You can use the GetWindowProxyFSSpec function to obtain identifying information about a proxy file: its volume reference number, directory ID, and file name. 

See also the function SetWindowProxyFSSpec. 
Version Notes

This function is available with Mac OS 8.5 and later.
Availability
Not recommended. Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Use of file specifications is no longer recommended. An alternate API that uses FSRef types is preferred.
Declared In
MacWindows.h*/
OSStatus GetWindowProxyFSSpec (
   WindowRef window,
   FSSpec * outFile
);

/*SetWindowDockTileMenu

Associates a pop-up menu with a window. 

OSStatus SetWindowDockTileMenu (
   WindowRef inWindow,
   MenuRef inMenu
);
Parameters
inWindow

The window with which a pop-up menu is to be associated.
inMenu

The pop-up menu that is to be associated with the window specified by inWindow
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You specify a dock tile menu if you want to be able to present special selections when the user activates the pop-up menu associated with the window’s minimized dock tile. 
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetWindowDockTileMenu (
   WindowRef inWindow,
   MenuRef inMenu
);

/*MoveWindowStructure

Positions a window relative to its structure region.

OSStatus MoveWindowStructure (
   WindowRef window,
   short hGlobal,
   short vGlobal
);
Parameters
window

The window that is to be moved.
hGlobal

A value specifying the horizontal position, in global coordinates, to which the left edge of the window’s structure region is to be moved. 
vGlobal

A value specifying the vertical position, in global coordinates, to which the top edge of the window’s structure region is to be moved.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The MoveWindowStructure function moves the specified window, but does not change the window’s size. When your application calls MoveWindowStructure, the positioning of the specified window is determined by the positioning of its structure region. This is in contrast to the MoveWindow function, where the positioning of the window’s content region determines the positioning of the window. After moving the window, MoveWindowStructure displays the window in its new position.

Note that your application should not call the MoveWindowStructure function to position a window when the user drags the window by its drag region. When the user drags the window, your application should call the pre–Mac OS 8.5 Window Manager function DragWindow. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus MoveWindowStructure (
   WindowRef window,
   short hGlobal,
   short vGlobal
);

/*ChangeWindowAttributes

Changes a window’s attributes. 

OSStatus ChangeWindowAttributes (
   WindowRef window,
   WindowAttributes setTheseAttributes,
   WindowAttributes clearTheseAttributes
);
Parameters
window

The window whose attributes you want to change.
setTheseAttributes

The attributes you want to set. Pass kWindowNoAttributes if you do not want to set any attributes. See “Window Attributes” for a list of window attributes.
clearTheseAttributes

The attributes you want to clear (if any). Pass kWindowNoAttributes if you do not want to clear any attributes. See “Window Attributes” for a list of window attributes.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the changed attributes affect the visible window’s frame, the window regions are recalculated and the window is redrawn.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ChangeWindowAttributes (
   WindowRef window,
   WindowAttributes setTheseAttributes,
   WindowAttributes clearTheseAttributes
);

/*CreateQDContextForCollapsedWindowDockTile

Obtains a CGrafPtr for a collapsed window’s tile in the dock.

OSStatus CreateQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr * outContext
);
Parameters
inWindow

The window whose CGrafPtr is to be obtained.
outContext

On output, a pointer to the window’s CGrafPtr.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus CreateQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr * outContext
);

/*ReleaseQDContextForCollapsedWindowDockTile

Releases a port and other state created by CreateQDContextForCollapsedWindowDockTile.

OSStatus ReleaseQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr inContext
);
Parameters
inWindow

The window whose port is to be released.
inContext

The port that is to be released.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

You must call this function instead of calling DisposePort directly, or you may leak system resources.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ReleaseQDContextForCollapsedWindowDockTile (
   WindowRef inWindow,
   CGrafPtr inContext
);

/*IsWindowCollapsed

Determines whether a window is currently collapsed.

Boolean IsWindowCollapsed (
   WindowRef window
);
Parameters
window

The window to be examined.
Return Value

If true, the window is collapsed. If false, the window is expanded. 
Discussion

On Mac OS 9, only window definition functions that return the feature bit kWindowCanCollapse in response to a kWindowGetFeatures message support this function; for more information, see GetWindowFeatures. Typically, a window’s content region is empty in a collapsed state. On Mac OS X, the presence or absence of the kWindowCollapseBoxAttribute attribute determines whether a window can be collapsed.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Boolean IsWindowCollapsed (
   WindowRef window
);

/*GetSheetWindowParent

Obtains the parent window of a sheet. 

OSStatus GetSheetWindowParent (
   WindowRef inSheet,
   WindowRef * outParentWindow
);
Parameters
inSheet

The window sheet whose parent is to be obtained.
outParentWindow

A pointer to the reference for the parent of the window sheet specified by inSheet.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetSheetWindowParent (
   WindowRef inSheet,
   WindowRef * outParentWindow
);

/*SendBehind

Moves one window behind another.

void SendBehind (
   WindowRef window,
   WindowRef behindWindow
);
Parameters
window

The window to be moved.
behindWindow

On input, a pointer to the window that is to be in front of the moved window.
Discussion

The SendBehind function moves the window pointed to by the parameter window behind the window pointed to by the parameter behindWindow. If the move exposes previously obscured windows or parts of windows, SendBehind redraws the frames as necessary and generates the appropriate update events to have any newly exposed content areas redrawn.

If the value of behindWindow is NULL, SendBehind sends the window to be moved behind all other windows on the desktop. If the window to be moved is the active window, SendBehind removes its highlighting, highlights the newly exposed frontmost window, and generates the appropriate activate events.

Do not use SendBehind to deactivate a window after you’ve made a new window active with the function SelectWindow. The SelectWindow function automatically deactivates the previously active window.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SendBehind (
   WindowRef window,
   WindowRef behindWindow
);

/*SetWindowKind

Sets a window’s window kind.

void SetWindowKind (
   WindowRef window,
   short kind
);
Parameters
window

The window whose window kind is to be set.
kind

An integer representing the window kind.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
void SetWindowKind (
   WindowRef window,
   short kind
);

/*ValidRect

Removes a rectangle from a window’s update region.

Unsupported

void ValidRect (
   const Rect *goodRect
);
Parameters
goodRect

On input, a pointer to a rectangle, in local coordinates, to be removed from a window’s update region. 
Discussion

The ValidRect function removes a specified rectangle from the update region of the window whose graphics port is the current port. Specify the rectangle in local coordinates. 

Your application uses ValidRect to tell the Window Manager that it has already drawn a rectangle and to cancel any updates accumulated for that area. You can thereby improve response time by reducing redundant redrawing.

Suppose, for example, that you’ve resized a window that contains a size box and scroll bars. Depending on the dimensions of the newly sized window, the new size box and scroll bar areas may or may not have been accumulated into the window’s update region. After calling SizeWindow, you can redraw the size box or scroll bars immediately and then call ValidRect for the areas they occupy. If they were in fact accumulated into the update region, ValidRect removes them so that you do not have to redraw them with the next update event. 
Availability
Unsupported.
Carbon Porting Notes

Calls ValidWindowRect, which takes a window pointer as an additional parameter. Validation works on windows, not ports, and because windows are not ports in Carbon, this change is necessary.
Declared In
MacWindows.h*/
void ValidRect (
   const Rect *goodRect
);

/*UpdateCollapsedWindowDockTile

Updates the image of a window in the dock to the current contents of the window.

OSStatus UpdateCollapsedWindowDockTile (
   WindowRef inWindow
);
Parameters
inWindow

The window whose image is to be updated.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Use this function for periodic updates, not for animation purposes. If you want animation, use CreateQDContextForCollapsedWindowDockTile.
Availability
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus UpdateCollapsedWindowDockTile (
   WindowRef inWindow
);

/*GetWindowClass

Obtains the class of a window.

OSStatus GetWindowClass (
   WindowRef window,
   WindowClass * outClass
);
Parameters
window

The window whose class you want to obtain.
outClass

On input, a pointer to a value of type WindowClass. On return, this value identifies the class of the specified window. See “Window Class Constants” for a list of possible window classes. In Mac OS 8 and Mac OS 9, for windows not originally created by CreateNewWindow, the class pointed to by the outClass parameter is always identified by the constant kDocumentWindowClass. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

Call SetWindowClass to change a window’s class after the window is created.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus GetWindowClass (
   WindowRef window,
   WindowClass * outClass
);

/*IsWindowActive

Indicates whether the specified window is active. 

Boolean IsWindowActive (
   WindowRef inWindow
);
Parameters
inWindow

The window to query.
Return Value

Returns true if the window is active, false otherwise.
Discussion

Whether a window is considered active is determined by its activation scope, highlighting, and z-order. For windows that have an activation scope of kWindowActivationScopeAll, a window is active if it is the window returned by the ActiveNonFloatingWindow function or if it is in the same window group as the window returned by ActiveNonFloatingWindow and the window group has the kWindowGroupAttrSharedActivation attribute. For windows that have some other activation scope, the window is active if its window frame is highlighted and the window is the frontmost window in its window group.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
Boolean IsWindowActive (
   WindowRef inWindow
);

/*RemoveWindowProperty

Removes a piece of data that is associated with a window.

OSStatus RemoveWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag
);
Parameters
window

The window whose data is to be removed.
propertyCreator

The creator code (typically, the application’s signature) of the associated data to be removed. 
propertyTag

The application-defined code identifying the associated data to be removed. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The data removed by the RemoveWindowProperty function must have been previously associated with the window with the function SetWindowProperty. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus RemoveWindowProperty (
   WindowRef window,
   PropertyCreator propertyCreator,
   PropertyTag propertyTag
);

/*ValidWindowRgn

Removes a region from a window’s update region.

OSStatus ValidWindowRgn (
   WindowRef window,
   RgnHandle region
);
Parameters
window

The window containing the region you want to remove from the update region.
region

Set this region to specify, in local coordinates, the area to be removed from the window’s update region.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

The ValidWindowRgn function informs the Window Manager that an area of a window no longer needs to be redrawn. The ValidWindowRgn function is similar to the ValidRgn function, but ValidWindowRgn allows the window that it operates upon to be explicitly specified, instead of operating on the current graphics port, so ValidWindowRgn does not require the graphics port to be set before its use. 

See also the functions InvalWindowRgn and ValidWindowRect. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.5 or later.
Available in Mac OS X v10.0 and later.
Declared In
MacWindows.h*/
OSStatus ValidWindowRgn (
   WindowRef window,
   RgnHandle region
);

/*HIWindowChangeClass

Changes the look and feel of an existing window.

OSStatus HIWindowChangeClass (
   WindowRef window,
   WindowClass inClass
);
Parameters
window

The window whose class you want to change.
inClass

The new class that is to be applied to the window. See “Window Class Constants” for a list of possible window classes. 
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

HIWindowChangeClass changes the class of a window. Unlike SetWindowClass, HIWindowChangeClass effectively changes the look and behavior of the window all at once.

This function can convert a window between kDocumentWindowClass, kFloatingWindowClass, kUtilityWindowClass, and kMovableModalWindowClass only. It cannot, for example, change a document window into a plain window.

The attributes of the window are adjusted to contain only those that are allowed for the new class. It is the caller’s responsibility to adjust them further, as necessary, after HIWindowChangeClass returns.
Availability
Available in Mac OS X v10.3 and later.
Declared In
MacWindows.h*/
OSStatus HIWindowChangeClass (
   WindowRef window,
   WindowClass inClass
);

/*SetDrawerParent

Sets the parent window for a drawer. 

OSStatus SetDrawerParent (
   WindowRef inDrawerWindow,
   WindowRef inParent
);
Parameters
inDrawerWindow

The drawer window whose parent window is to be set.
inParent

The window that is to be set as the parent of the window specified by inDrawerWindow.
Return Value

A result code. See “Window Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus SetDrawerParent (
   WindowRef inDrawerWindow,
   WindowRef inParent
);

/*ToggleDrawer

Toggles the drawer state.

OSStatus ToggleDrawer (
   WindowRef inDrawerWindow
);
Parameters
inDrawerWindow

The drawer window whose drawer state is to be toggled.
Return Value

A result code. See “Window Manager Result Codes”.
Discussion

If the drawer is currently open or opening, this function closes the drawer. If the drawer is currently closed or closing, this function opens the drawer.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
MacWindows.h*/
OSStatus ToggleDrawer (
   WindowRef inDrawerWindow
);

/*GetAuxWin

Obtains a handle to a window’s auxiliary window structure.

Unsupported

Boolean GetAuxWin (
   WindowRef window,
   AuxWinHandle *awHndl
);
Parameters
window

On input, a pointer to the window structure. 
awHndl

On output, a handle to the auxiliary window structure. 
Return Value

Returns a Boolean value that reports whether or not the window has an auxiliary window structure. If the window has no auxiliary window structure, it returns a value of false. If window is NULL, the function returns the system default and true. 
Discussion

The GetAuxWin function sets the value referenced through the parameter awHndl to contain a handle to the auxiliary window structure. If the window has no auxiliary window structure, GetAuxWin places the default auxiliary window structure in the value referenced through awHndl. 
Version Notes

This function is not recommended with Appearance Manager 1.0 and later.

When the Appearance Manager is available and you are using standard windows, most of the fields of the auxiliary window structure are ignored. In the future, standard system windows may not have entries in the auxiliary window list. If you are creating your own window definition function, GetAuxWin can still be used.
Carbon Porting Notes

Remove application reliance on AuxWinRec data structures; in the future, the information in these structures may be invalid or unavailable to applications.
Declared In
MacWindows.h*/
Boolean GetAuxWin (
   WindowRef window,
   AuxWinHandle *awHndl
);

#ifdef __cplusplus
}
#endif

#endif

#endif

