#ifndef  SCSITASKLIB_H
#define  SCSITASKLIB_H

#include <HYS/IOKit/scsi/SCSITaskLib.h>
#include <IOKit/scsi/SCSITask.h>
#include <IOKit/scsi/SCSICommandDefinitions.h>
#include <IOKit/scsi/SCSICmds_INQUIRY_Definitions.h>
#include <IOKit/scsi/SCSICmds_REQUEST_SENSE_Defs.h>
#include <CoreFoundation/CFPlugIn.h>
#include <CoreFoundation/CFPlugInCOM.h>
#include <IOKit/IOReturn.h>
#include <IOKit/IOTypes.h>
#include <IOKit/IOCFPlugIn.h>


#ifdef __cplusplus
extern "C" {
#endif

/*kIOPropertySCSITaskUserClientDevice

#define kIOPropertySCSITaskUserClientDevice "SCSITaskUserClientDevice" 
Discussion 

I/O Registry property for the SCSI Task User Client. This property identifies an SCSITask enabled device.*/
#define kIOPropertySCSITaskUserClientDevice "SCSITaskUserClientDevice" 

/*kIOMMCDeviceInterfaceID

#define kIOMMCDeviceInterfaceID \ 
    CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x1F, 0x65, 0x11, 0x06, 0x23, 0xCC, 0x11, 0xD5, \ 
    0xBB, 0xDB, 0x00, 0x30, 0x65, 0x70, 0x48, 0x66) 
Discussion 

InterfaceID for MMCDeviceInterface.*/

#define kIOMMCDeviceInterfaceID \ 
    CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x1F, 0x65, 0x11, 0x06, 0x23, 0xCC, 0x11, 0xD5, \ 
    0xBB, 0xDB, 0x00, 0x30, 0x65, 0x70, 0x48, 0x66) 


/*kIOMMCDeviceUserClientTypeID

#define kIOMMCDeviceUserClientTypeID \ 
    CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x97, 0xAB, 0xCF, 0x2C, 0x23, 0xCC, 0x11, 0xD5, \ 
    0xA0, 0xE8, 0x00, 0x30, 0x65, 0x70, 0x48, 0x66) 
Discussion 

Factory ID for creating an MMC Device User Client.*/
#define kIOMMCDeviceUserClientTypeID \ 
    CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x97, 0xAB, 0xCF, 0x2C, 0x23, 0xCC, 0x11, 0xD5, \ 
    0xA0, 0xE8, 0x00, 0x30, 0x65, 0x70, 0x48, 0x66) 


/*kIOSCSITaskDeviceInterfaceID

#define kIOSCSITaskDeviceInterfaceID \ 
    CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x1B, 0xBC, 0x41, 0x32, 0x08, 0xA5, 0x11, 0xD5, \ 
    0x90, 0xED, 0x00, 0x30, 0x65, 0x7D, 0x05, 0x2A) 
Discussion 

InterfaceID for SCSITaskDeviceInterface.*/

#define kIOSCSITaskDeviceInterfaceID \ 
    CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x1B, 0xBC, 0x41, 0x32, 0x08, 0xA5, 0x11, 0xD5, \ 
    0x90, 0xED, 0x00, 0x30, 0x65, 0x7D, 0x05, 0x2A) 



/*kIOSCSITaskDeviceUserClientTypeID

#define kIOSCSITaskDeviceUserClientTypeID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x7D, 0x66, 0x67, 0x8E, 0x08, 0xA2, 0x11, 0xD5, \ 
    0xA1, 0xB8, 0x00, 0x30, 0x65, 0x7D, 0x05, 0x2A) 
Discussion 

Factory ID for creating an SCSITask Device User Client.*/

#define kIOSCSITaskDeviceUserClientTypeID CFUUIDGetConstantUUIDWithBytes(NULL, \ 
    0x7D, 0x66, 0x67, 0x8E, 0x08, 0xA2, 0x11, 0xD5, \ 
    0xA1, 0xB8, 0x00, 0x30, 0x65, 0x7D, 0x05, 0x2A) 

/*kIOPropertySCSITaskDeviceCategory

#define kIOPropertySCSITaskDeviceCategory "SCSITaskDeviceCategory" 
Discussion 

I/O Registry property for the SCSITaskUserClient. This category identifies which type of device and interface to the device is used in conjunction with the SCSITaskUserClient.*/
#define kIOPropertySCSITaskDeviceCategory "SCSITaskDeviceCategory" 

/*kIOPropertySCSITaskAuthoringDevice

#define kIOPropertySCSITaskAuthoringDevice "SCSITaskAuthoringDevice" 
Discussion 

I/O Registry property for the SCSI Task User Client. This property identifies an SCSITask enabled device capable of authoring.*/
#define kIOPropertySCSITaskAuthoringDevice "SCSITaskAuthoringDevice" 


typedef struct SCSITasInterface{
IUNKNOWN_C_GUTS;

/*ExecuteTaskAsync


Method to execute the SCSITask asynchronously. 
IOReturn ( *ExecuteTaskAsync ) (
    void *task );  
Parameters
task
Pointer to an instance of an SCSITaskInterface.
Return Value

Returns kIOReturnSuccess, kIOReturnError, or kIOReturnNotPermitted if the client has not called AddCallbackDispatcherToRunLoop on the SCSITaskDeviceInterface. 
Discussion 

This method can be used to execute the SCSITask asynchronously.*/
IOReturn ( *ExecuteTaskAsync ) (
    void *task );  

/*SetTimeoutDuration


Method to set the timeout duration for the SCSITask. 
IOReturn ( *SetTimeoutDuration ) (
    void *task,
    UInt32 inTimeoutDurationMS );  
Parameters
task
Pointer to an instance of an SCSITaskInterface.
inTimeoutDurationMS
UInt32 representing the timeout in milliseconds.
Return Value

Returns kIOReturnSucces or kIOReturnError. 
Discussion 

This method can be used to set the timeout duration for the SCSITask. The timeout duration is counted in milliseconds. A value of zero is equivalent to "Wait Forever", but on some buses, this isn't possible, so ULONG_MAX is used.*/
IOReturn ( *SetTimeoutDuration ) (
    void *task,
    UInt32 inTimeoutDurationMS );  

/*SetCommandDescriptorBlock


Method to set the task's SCSICommandDescriptorBlock. 
IOReturn ( *SetCommandDescriptorBlock ) (
    void *task,
    UInt8 *inCDB,
    UInt8 inSize );  
Parameters
task
Pointer to an instance of an SCSITaskInterface.
inCDB
Pointer to an array of values to be stored in the SCSITask's SCSICommandDescriptorBlock.
inSize
The size of the array inCDB. Valid values are 6, 10, 12, and 16 which have enums defined in SCSITask.h.
Return Value

Returns kIOReturnSuccess or kIOReturnError. 
Discussion 

This method can be used to set the SCSITasks' SCSICommandDescriptorBlock.*/
IOReturn ( *SetCommandDescriptorBlock ) (
    void *task,
    UInt8 *inCDB,
    UInt8 inSize );  
/*SetScatterGatherEntries


Method to set the task's scatter-gather list entries. 
IOReturn ( *SetScatterGatherEntries ) (
    void *task, 
    IOVirtualRange *inScatterGatherList, 
    UInt8 inScatterGatherEntries, 
    UInt64 inTransferCount, 
    UInt8 inTransferDirection );  
Parameters
task
Pointer to an instance of an SCSITaskInterface.
inScatterGatherList
Pointer to an array of IOVirtualRanges.
inScatterGatherEntries
The size of the inScatterGatherList array.
inTransferCount
The TOTAL amount of data to transfer. The length of all the entries in the scatter-gather list should at least add up to the amount in inTransferCount.
inTransferDirection
The transfer direction as defined in SCSITask.h. Valid values are kSCSIDataTransfer_NoDataTransfer, kSCSIDataTransfer_FromTargetToInitiator, and kSCSIDataTransfer_FromInitiatorToTarget.
Return Value

Returns kIOReturnSucces or kIOReturnError. 
Discussion 

This method can be used to set the SCSITask's scatter-gather list entries. Scatter-gather lists are represented as an array of IOVirtualRanges. The IOVirtualRange structure has two elements, the address of the buffer and the length of the buffer.*/
IOReturn ( *SetScatterGatherEntries ) (
    void *task, 
    IOVirtualRange *inScatterGatherList, 
    UInt8 inScatterGatherEntries, 
    UInt64 inTransferCount, 
    UInt8 inTransferDirection );  

/*&ExecuteTaskSync


Method to execute the SCSITask synchronously. 
IOReturn ( *ExecuteTaskSync ) (
    void *task, 
    SCSI_Sense_Data *senseDataBuffer, 
    SCSITaskStatus *outStatus, 
    UInt64 *realizedTransferCount );  
Parameters
task
Pointer to an instance of an SCSITaskInterface.
senseDataBuffer
Pointer to a buffer for REQUEST_SENSE data. May be NULL if caller does not wish to have sense data returned. If caller has previously called SetAutoSenseDataBuffer(), this parameter is ignored.
outStatus
Pointer to an SCSITaskStatus. May be NULL if caller does not wish to have task status returned.
realizedTransferCount
Pointer to an UInt64 which reflects how much data was actually transferred. May be NULL if caller does not wish to know how many bytes were transferred.
Return Value

Returns kIOReturnSuccess or kIOReturnError. 
Discussion 

This method can be used to execute the SCSITask synchronously.*/
IOReturn ( *ExecuteTaskSync ) (
    void *task, 
    SCSI_Sense_Data *senseDataBuffer, 
    SCSITaskStatus *outStatus, 
    UInt64 *realizedTransferCount );  

} SCSITaskInterface;

/////////
typedef struct SCSITaskDeviceInterface{
IUNKNOWN_C_GUTS;
/*CreateSCSITask
Method to create SCSITasks. 
SCSITaskInterface ** ( *CreateSCSITask )(
    void *self );  
Parameters
self
Pointer to a SCSITaskDeviceInterface instance.
Return Value

Returns a handle to an instance of a SCSITaskInterface or NULL if one could not be allocated. 
Discussion 

Once a SCSITaskDeviceInterface is opened, the client may request exclusive access to the device. Once the client has successfully gained exclusive access, it becomes the Logical Unit Driver. It then can use this method to allocate SCSITasks to be sent to the device.*/
SCSITaskInterface ** ( *CreateSCSITask )(
    void *self );
/*ObtainExclusiveAccess


Method to obtain exclusive access to the device so that SCSITasks can be sent to it. 
IOReturn ( *ObtainExclusiveAccess ) (
    void *self );  
Parameters
self
Pointer to a SCSITaskDeviceInterface instance.
Return Value

Returns kIOReturnSuccess if exclusive access was granted, else if media is still mounted it returns kIOReturnBusy. If another client already has exclusive access, kIOReturnExclusiveAccess is returned. 
Discussion 

Once a SCSITaskDeviceInterface is opened, the client may request exclusive access to the device. Once the client has successfully gained exclusive access, it becomes the Logical Unit Driver and all in-kernel Logical Unit Drivers are quiesced.*/
IOReturn ( *ObtainExclusiveAccess ) (
    void *self );  
/*ReleaseExclusiveAccess


Method to release exclusive access to the device so that other clients can send commands to it. 
IOReturn ( *ReleaseExclusiveAccess ) (
    void *self );  
Parameters
self
Pointer to a SCSITaskDeviceInterface instance.
Return Value

Returns kIOReturnSuccess if exclusive access was released, else some appropriate error. 
Discussion 

Once a SCSITaskDeviceInterface is opened, the client may request exclusive access to the device. Once the client has successfully gained exclusive access, it becomes the Logical Unit Driver and all in-kernel Logical Unit Drivers (if any are matched on the device) are quiesced. This method releases this access and unquiesces the in-kernel drivers (if any).*/
IOReturn ( *ReleaseExclusiveAccess ) (
    void *self );  


} SCSITaskDeviceInterface;



typedef struct MMCDeviceInterface{
IUNKNOWN_C_GUTS;
/*GetSCSITaskDeviceInterface


Gets a handle to the SCSITaskDeviceInterface without closing the user client connection which was initiated by IOCreateCFPlugInForService. 
SCSITaskDeviceInterface ** ( *GetSCSITaskDeviceInterface )(
    void *self );  
Parameters
self
Pointer to an MMCDeviceInterface for one IOService.
Return Value

Returns a handle to a SCSITaskDeviceInterface if successful, otherwise NULL. 
Discussion 

Once an MMCDeviceInterface is opened the client may use this function to get a handle to the interface used to create and send SCSITasks directly to the device.*/
SCSITaskDeviceInterface ** ( *GetSCSITaskDeviceInterface )(
    void *self );  

}MMCDeviceInterface;






#ifdef __cplusplus
}
#endif



#endif 
