#ifndef INK_H
#define INK_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef HITOOLBOX_H
#include <HIToolbox/HIToolbox.h>
#endif

#include <AvailabilityMacros.h>

//#include <HYS/Ink/Ink.h>
#include <APPLE/Ink/Ink.h>
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Recognition Modes

Specify how to interpret Ink input for an application.

enum InkRecognitionType{
   kInkRecognitionNone     = 0,
   kInkRecognitionText     = 1,
   kInkRecognitionGesture     = 1 << 1,
   kInkRecognitionDefault     = 3
};
typedef unsigned long     InkRecognitionType;
Constants
kInkRecognitionNone

Specifies to turn off Ink recognition.

Available in Mac OS X v10.3 and later.
kInkRecognitionText

Specifies to allow interpretation of Ink input as text.

Available in Mac OS X v10.3 and later.
kInkRecognitionGesture

Specifies to allow interpretation of Ink input as gestures.

Available in Mac OS X v10.3 and later.
kInkRecognitionDefault

Specifies the default setting, which is to interpret Ink input as text or gestures.

Available in Mac OS X v10.3 and later.
Discussion

The recognition type constants are used as arguments for the function InkSetApplicationRecognitionMode. You can use these constants to specify that Ink Services interprets input as both text and gestures or as either type individuall*/
enum {
   kInkRecognitionNone     = 0,
   kInkRecognitionText     = 1,
   kInkRecognitionGesture     = 1 << 1,
   kInkRecognitionDefault     = 3
};
typedef unsigned long     InkRecognitionType;


/*Application Modes

Specify an Ink input mode to use for an application.

enum {
   kInkWriteNowhereInApp     = 'nowa',
   kInkWriteAnywhereInApp     = 'anya'
};
typedef FourCharCode     InkApplicationModeType;
Constants
kInkWriteNowhereInApp

Specifies not to allow Ink input in your application.

Available in Mac OS X v10.3 and later.
kInkWriteAnywhereInApp

Specifies to allow Ink input anywhere onscreen for your application.

Available in Mac OS X v10.3 and later.
Discussion

You can supply these constants as parameters to the function InkSetApplicationWritingMode. If the user has not enabled Ink or if there is not an Ink input device available, then calling InkSetApplicationWritingMode with the parameter kInkWriteAnywhereInApp has no effect.*/
enum {
   kInkWriteNowhereInApp     = 'nowa',
   kInkWriteAnywhereInApp     = 'anya'
};
typedef FourCharCode     InkApplicationModeType;


/*Drawing Modes

Specify what Ink Services should draw.

enum {
   kInkDrawNothing = 0,
   kInkDrawInkOnly = 1,
   kInkDrawInkAndWritingGuides= 2
};
typedef unsigned long InkDrawingModeType;
Constants
kInkDrawNothing

Specifies not to draw Ink or the writing guides.

Available in Mac OS X v10.3 and later.
kInkDrawInkOnly

Specifies to draw Ink but not the writing guides.

Available in Mac OS X v10.3 and later.
kInkDrawInkAndWritingGuides

Specifies to draw both the Ink and the writing guides. This is the default.

Available in Mac OS X v10.3 and later.
Discussion

You can pass these constants as parameters to the function InkSetDrawingMode.*/
enum {
   kInkDrawNothing = 0,
   kInkDrawInkOnly = 1,
   kInkDrawInkAndWritingGuides= 2
};
typedef unsigned long InkDrawingModeType;


/*InkAlternateCount

Defines a data type that specifies the number of alternate text interpretations of an Ink phrase.

typedef unsigned long     InkAlternateCount;
Discussion

Values of type InkAlternateCount are returned by the function InkTextAlternatesCount and passed as a parameter to the function InkTextCreateCFString.
Availability
Available in Mac OS X v10.3 and later.*/
typedef unsigned long     InkAlternateCount;

/*Ink Source Types

Specify sources for an Ink data stream.

enum unsigned long InkSourceType{
   kInkSourceUser                    = 1,
   kInkSourceApplication                      = 2
};
Constants
kInkSourceUser

Specifies the Ink source from direct user input.

Available in Mac OS X v10.3 and later.
kInkSourceApplication

Specifies the Ink source from the application.

Available in Mac OS X v10.3 and later.
Discussion

You can use these constants to specify which data stream is currently being controlled by calls to the functions InkTerminateCurrentPhrase and InkSetPhraseTerminationMode. You can control phrase termination for both the user-input data stream (kInkSourceUser) and an application-input data stream (kInkSourceApplication) independently.*/
typedef unsigned long InkSourceType;
enum {
   kInkSourceUser                    = 1,
   kInkSourceApplication                      = 2
};

/*Editing Gestures

Define editing actions.

enum InkGestureKind {
   kInkGestureUndo     = 'undo',
   kInkGestureCut     = 'cut ',
   kInkGestureCopy     = 'copy',
   kInkGesturePaste     = 'past',
   kInkGestureClear     = 'cler',
   kInkGestureSelectAll     = 'sall',
   kInkGestureLeftSpace     = 'lspc',
   kInkGestureRightSpace     = 'rspc',
   kInkGestureTab     = 'tab ',
   kInkGestureLeftReturn     = 'lrtn',
   kInkGestureRightReturn     = 'rrtn',
   kInkGestureDelete     = 'del ',
   kInkGestureEscape     = 'esc ',
   kInkGestureJoin     = 'join'
};
typedef FourCharCode     InkGestureKind;
Constants
kInkGestureUndo

Specifies to undo the last action.

Available in Mac OS X v10.3 and later.
kInkGestureCut

Specifies to cut.

Available in Mac OS X v10.3 and later.
kInkGestureCopy

Specifies to copy.

Available in Mac OS X v10.3 and later.
kInkGesturePaste

Specifies to paste.

Available in Mac OS X v10.3 and later.
kInkGestureClear

Specifies to clear. 

Available in Mac OS X v10.3 and later.
kInkGestureSelectAll

Specifies to select all items in the area that has user focus. 

Available in Mac OS X v10.3 and later.
kInkGestureLeftSpace

Specifies to insert a single space character. The “left” distinction indicates that the gesture is drawn with the long, horizontal tail is on the left side. 

Available in Mac OS X v10.3 and later.
kInkGestureRightSpace

Specifies to insert a single space character. The “right” distinction indicates that the gesture is drawn with the long, horizontal tail is on the right side. 

Available in Mac OS X v10.3 and later.
kInkGestureTab

Specifies to insert a tab character. 

Available in Mac OS X v10.3 and later.
kInkGestureLeftReturn

Specifies to insert a return (new line) character. The “left” distinction indicates that the gesture is drawn with the small angle-bracket pointing to the left side. 

Available in Mac OS X v10.3 and later.
kInkGestureRightReturn

Specifies to insert a return (new line) character. The “right” distinction indicates that the gesture is drawn with the small angle-bracket pointing to the right side. 

Available in Mac OS X v10.3 and later.
kInkGestureDelete

Specifies to delete. This corresponds to pressing the Delete key. 

Available in Mac OS X v10.3 and later.
kInkGestureEscape

This corresponds to pressing the Escape key.

Available in Mac OS X v10.3 and later.
kInkGestureJoin

Specifies to join two words into a single word, eliding the space between them, and may be applied to editable objects other than text. The gesture is similar in shape to the letter “v”. The joined words are the ones closest to the top-most points of the gesture. This is a tentative, always targeted, gesture, meaning that the system treats the associated Ink tentatively as a gesture until your application either confirms the Ink is indeed a gesture or returns eventNotHandledErr, informing the system the Ink is not a gesture.

Available in Mac OS X v10.3 and later.
Discussion

These constants are returned in the Carbon event parameter kEventParamInkGestureKind. The Carbon event class for this parameter is kEventClassInk and the event kind is kEventInkGesture. The constants define the complete set of gestures recognized by Ink Services. When a gesture event is received by your application, your application should determine the gesture kind and then take appropriate action. For more details, see Using Ink Services in Your Application.*/
enum  {
   kInkGestureUndo     = 'undo',
   kInkGestureCut     = 'cut ',
   kInkGestureCopy     = 'copy',
   kInkGesturePaste     = 'past',
   kInkGestureClear     = 'cler',
   kInkGestureSelectAll     = 'sall',
   kInkGestureLeftSpace     = 'lspc',
   kInkGestureRightSpace     = 'rspc',
   kInkGestureTab     = 'tab ',
   kInkGestureLeftReturn     = 'lrtn',
   kInkGestureRightReturn     = 'rrtn',
   kInkGestureDelete     = 'del ',
   kInkGestureEscape     = 'esc ',
   kInkGestureJoin     = 'join'
};
typedef FourCharCode     InkGestureKind;

/*Phrase Termination Modes

Defines the conditions under which an Ink phrase should be terminated.

enum InkTerminationType{
   kInkTerminationNone = 0,
   kInkTerminationTimeOut = 1,
   kInkTerminationOutOfProximity = 1 << 1,
   kInkTerminationRecognizerHorizontalBreak = 1 << 2,
   kInkTerminationRecognizerVerticalBreak = 1 << 3,
   kInkTerminationStroke = 1 << 4,
   kInkTerminationAll = (unsigned long) 0xFFFFFFFF,
   kInkTerminationDefault = 0x0F
};
typedef unsigned long         InkTerminationType;
Constants
kInkTerminationNone

Specifies to inhibit automatic phrase termination by Ink Services.

Available in Mac OS X v10.3 and later.
kInkTerminationTimeOut

Specifies to terminate a phrase when all of the following are true: 
The user stops writing and lifts the stylus
The user keeps the stylus within the proximity range of the tablet
The user does not resume writing within the period of time defined by the user in the Ink pane of System Preferences

Available in Mac OS X v10.3 and later.
kInkTerminationOutOfProximity

Specifies to terminate a phrase when the user stops writing and lifts the stylus entirely out of the proximity range of the tablet. This is on by default. However, users can turn off proximity termination in the Ink pane of System Preferences if they find it interferes with their writing style.

If the user turns off proximity termination, your application can’t turn it on even if you call the function InkSetPhraseTerminationMode with the parameter kInkTerminationOutOfProximity.

Available in Mac OS X v10.3 and later.
kInkTerminationRecognizerHorizontalBreak

Specifies to terminate a phrase when the user leaves a large horizontal space between words (approximately two character widths or more).

Available in Mac OS X v10.3 and later.
kInkTerminationRecognizerVerticalBreak

Specifies to terminate a phrase when the user finishes one line and begins writing on the next.

Available in Mac OS X v10.3 and later.
kInkTerminationStroke

Causes phrases to be terminated at the end of every stroke (whenever the pen is lifted from the tablet while writing). Only useful for single-stroke gesture input, not for text.

Available in Mac OS X v10.4 and later.
kInkTerminationAll

Specifies to restore automatic phrase termination by Ink Services. In this case, Ink Services uses all of the termination modes (except kInkTerminationNone) described previously. Deprecated in Mac OS X v10.4. As of Mac OS X v10.4, this value is overridden to behave like kInkTerminationDefault.

Available in Mac OS X v10.3 and later.
kInkTerminationDefault

Restores default phrase termination matching the current user settings (kInkTerminationTimeOut | kInkTerminationOutOfProximity | kInkTerminationRecognizerHorizontalBreak | kInkTerminationRecognizerVerticalBreak). See also kInkTerminationOutOfProximity.

Available in Mac OS X v10.4 and later.
Discussion

An Ink phrase (represented as an InkTextRef in your application) is typically a word in a Roman language. Ink Services uses phrases to determine when to erase onscreen Ink and initiate recognition. You can pass Ink phrase termination constants as arguments to the function InkSetPhraseTerminationMode. You can combine two or more constants to obtain precise control over phrase termination.*/
enum{
   kInkTerminationNone = 0,
   kInkTerminationTimeOut = 1,
   kInkTerminationOutOfProximity = 1 << 1,
   kInkTerminationRecognizerHorizontalBreak = 1 << 2,
   kInkTerminationRecognizerVerticalBreak = 1 << 3,
   kInkTerminationStroke = 1 << 4,
   kInkTerminationAll = (unsigned long) 0xFFFFFFFF,
   kInkTerminationDefault = 0x0F
};
typedef unsigned long         InkTerminationType;

/*InkTextRef

Defines a data type for a reference to an opaque Ink text object.

typedef     struct OpaqueInkTextRef * InkTextRef;
Discussion

You must use the Core Foundation functions CFRetain and CFRelease to manage the retention and release of Ink text objects. When an Ink text reference is obtained from a Carbon event, it is guaranteed to persist only for the life of the event handler. If your application needs to use the Ink text object at some later time, you must call the function CFRetain, passing the object you want to retain as a parameter.
Availability
Available in Mac OS X v10.3 and later.*/
typedef     struct OpaqueInkTextRef * InkTextRef;

/*InkPoint

Contains data that describes an Ink point. 

struct InkPoint {
   HIPoint             point;
   TabletPointRec      tabletPointData;
   UInt32              keyModifiers;
};
typedef struct InkPoint      InkPoint;
typedef InkPoint *      InkPointPtr;
Fields
point

Defines a point in floating-point coordinates. These values are generally in global coordinates, with full sub-pixel accuracy. This coordinate is what you obtain for a mouse event from the Carbon event parameter kEventParamMouseLocation, which also contains a typeHIPoint value.
tabletPointData

A tablet point structure that contains pressure, tilt, rotation, and coordinate (in tablet space) data for a pen. The pressure value is a measure of how hard the pen is being pressed, ranging from 0 to 65535. Some tablet manufacturers allow users to adjust pen sensitivity. In these cases, the zero value always corresponds to the threshold set by the user, and the pressure value is relative to that threshold. See Carbon Event Manager Reference for information on the TabletPointRec data type.
keyModifiers

A value that specifies the keyboard modifier key that is pressed when the point is sampled. This value is in the same form as that used by the Carbon Event Manager for the event parameter kEventParamKeyModifiers. 
Discussion

An InkPoint data structure contains an essentially complete set of per-point data. Ink Services currently only requires the point's (x,y) coordinates and pressure to perform recognition and to draw the ink, but future recognition services may require other information from the TabletPointRec.
Availability
Available in Mac OS X v10.3 and later.*/
struct InkPoint {
   HIPoint             point;
   TabletPointRec      tabletPointData;
   UInt32              keyModifiers;
};
typedef struct InkPoint      InkPoint;
typedef InkPoint *      InkPointPtr;

//func

/*InkSetPhraseTerminationMode

Sets the conditions that define a phrase termination.

void     InkSetPhraseTerminationMode(
   InkSourceType iSource,
   InkTerminationType iAllowedTerminationTypes
);
Parameters
iSource

An “Ink Source Types” constant that specifies the source of the Ink data stream. You can use one of these constants to get independent control over termination of data originating with the user versus data that is passed from your application to Ink Services. To manage phrase termination for user input, pass the constant kInkSourceUser. To manage phrase termination for application input (that is recognized using the function InkAddStrokeToCurrentPhrase, pass the constant kInkSourceApplication.
iAllowedTerminationTypes

A constant that specifies the conditions which define a phrase termination. To turn off automatic phrase termination, pass kInkTerminationNone. You can restore the default phrase termination behavior by passing the constant kInkTerminationDefault. See “Phrase Termination Modes” for more information on the constants you can supply.
Discussion

The default behavior is for Ink Services to terminate a phrase when one of the following events occur: 
The user removes the stylus from the proximity of the tablet
A specified period of time elapses in which the stylus is not pressed to the tablet (The user can control the period of time in the Ink preferences pane.)
The user writes sufficiently far away from the previous Ink—either horizontally, or on a new line

You can use the function InkSetPhraseTerminationMode if your application does not want the default behavior or wants complete control over when Ink phrases are terminated. If you turn off automatic phrase termination, you must make sure you manage phrase termination appropriately for your application.

For example, if you want to force Ink drawn in a specific input window to be treated as a single phrase until the user presses a “finished-writing” button, you would call InkSetPhraseTerminationMode with the parameter kInkTerminationNone to turn off automatic phrase termination. Then you would need to install a Carbon event handler for the event kEventInkPoint. Your handler would examine the kEventInkPoint events, notice when a pen-down event occurs on the “finished-writing” button, and then terminate the phrase by calling the function InkTerminateCurrentPhrase. See Using Ink Services in Your Application for details on writing code to handle phrase termination.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkSetPhraseTerminationMode(
   InkSourceType iSource,
   InkTerminationType iAllowedTerminationTypes
);

/*InkTextCreateCFString

Obtains the string associated with a text interpretation of an Ink phrase.

CFStringRef         InkTextCreateCFString(
   InkTextRef iTextRef,
   InkAlternateCount iIndex
);
Parameters
iTextRef

On input, a reference to the Ink text object that specifies the Ink word for which you want to create a string. You must obtain an Ink text object reference (InkTextRef) through your application’s Ink event handler. Your handler must take care of the Carbon event class kEventClassInk and the event kind kEventInkText. The event parameter kEventParamInkTextRef that you obtain from this event kind is a reference to an Ink text object.
iIndex

The index that specfies the text interpretation for which you want to obtain a CFString. Text interpretations are stored in an array in ranked order, with the most-likely interpretation at index zero.
Return Value

A CFStringRef that specifies an interpretation for the given Ink text phrase. Returns NULL if the index you provide is invalid. Your application is responsible for releasing the returned CFStringRef.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
CFStringRef         InkTextCreateCFString(
   InkTextRef iTextRef,
   InkAlternateCount iIndex
);

/*InkTerminateCurrentPhrase

Terminates the current phrase.

void     InkTerminateCurrentPhrase (
   InkSourceType iSource
);
Parameters
iSource

An “Ink Source Types” constant that specifies the source of the Ink data stream.To terminate a phrase that originates from application input (that is recognized using the function InkAddStrokeToCurrentPhrase), pass the constant kInkSourceApplication.

If you are managing phrase termination that originates from direct user input, you can pass the constant kInkSourceUser. Note that this function is normally not used in this fashion, as most applications can let Ink Services terminate such phrases automatically.
Discussion

You do not need to call this function unless you have turned off automatic phrase termination (by calling the function InkSetPhraseTerminationMode) and have set up your application to manage phrase termination. When you call the function InkTerminateCurrentPhrase, any Ink drawn by Ink Services is erased. If your application handles phrase termination, it can still take advantage of the recognition service provided by Ink Services.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkTerminateCurrentPhrase (
   InkSourceType iSource
);

/*InkTextInsertAlternatesInMenu

Inserts a list of alternate text interpretations into a menu.

ItemCount        InkTextInsertAlternatesInMenu(
   InkTextRef iTextRef,
   MenuRef iMenuRef,
   MenuItemIndex iAfterItem
);
Parameters
iTextRef

On input, a reference to an Ink text object that specifies the Ink word for which you want to provide a list of alternate text interpretations. You must obtain an Ink text object reference (InkTextRef) through your application’s Ink event handler. Your handler must take care of the Carbon event class kEventClassInk and the event kind kEventInkText. The event parameter kEventParamInkTextRef that you obtain from this event kind is a reference to an Ink text object.
iMenuRef

A reference to the menu into which you want to insert the list of alternate text interpretations. Ink Services attaches menu event handlers to this menu, so you should use this MenuRef directly, rather than copy items from the menu reference to another menu.
iAfterItem

A value that specifies the menu item after which you want to insert the list of alternate text interpretations. If the specified menu item is 0, the text alternates are inserted at the head of the menu. If the specified menu item is greater than or equal to the existing number of menu items, the text alternates are appended to the end of the menu. Remember that the first item in a menu item array is numbered 1, not 0.
Return Value

Returns the number of menu items added to the menu. Returns 0 if the operation is not successful.
Discussion

The function InkTextInsertAlternatesInMenu allows your application to insert a list of text interpretations for a given Ink text phrase into an existing contextual menu. You should handle a list of alternate text interpretations as a standard contextual menu using the Menu Manager function ContextualMenuSelect. 

When a user selects an item from the list of alternates, the list of alternates maintained by Ink Services are reordered automatically. This means that if you call the function InkTextCreateCFString with the parameter iIndex set to 0, you obtain the newly selected item.

Thus the user’s choice persists in internal system data structures without requiring your application to call additional functions. However your application must update its own internal data structures appropriately. 

You must rebuild the menu to reflect the user’s choice. After the user makes a choice and then reopens the menu, you must make sure the newly-selected item shows up as the first item in the menu. The items in the menu should mirror the list of alternates maintained by Ink Services.

Upon return from the function ContextualMenuSelect, your application can determine if the user has made a selection by checking the value of the parameter outUserSelectionType. The value indicates the item that the user selected from the contextual menu. If there is a selection, your application can examine the outMenuID and outMenuItem parameters of the function ContextualMenuSelect, and use these values to obtain the alternate text interpretation by calling the Menu Manager function CopyMenuItemTextAsCFString. 

Menu items for a set of alternates whose first letter is an alphabetical character always include an alternate whose first letter is the opposite lettercase. Menu items for a set of alternates whose first letter is a non-alphabetical character do not include a lettercase alternate. 

When the menu items are reordered automatically, the text that was first in the list moves to the second or the third position, depending upon whether the first letter is alphabetical or non-alphabetical. For example, the following list of menu items:

crash, Crash, crush, crust, wrash

If the user chooses crush, the menu items are reordered as follows:

crush, Crush, crash, crust, wrash

Notice that the list of alternates is kept to a length of five. A lettercase alternate for crush is added to the menu while the uppercase alternate Crash is dropped.

For a non-alphabetic first character, however, such as a number, the original moves to the second position. So for the following menu:

1239, 1234, 1289, 1284

If the user chooses 1234, the menu becomes:

1234, 1239, 1289, 1284

If it is important for your application to maintain the original order of alternates, then it must use its own internal data structures to keep track of the original list.

See Using Ink Services in Your Application for details on writing code that uses the function InkTextInsertAlternatesInMenu to implement a correction model.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
ItemCount        InkTextInsertAlternatesInMenu(
   InkTextRef iTextRef,
   MenuRef iMenuRef,
   MenuItemIndex iAfterItem
);

/*InkAddStrokeToCurrentPhrase

Adds a stroke to the current Ink phrase.

void     InkAddStrokeToCurrentPhrase(
   unsigned long iPointCount,
   InkPoint *iPointArray
);
Parameters
iPointCount

The number of elements in the iPointArray array.
iPointArray

A pointer to an array of InkPoint structures that specify the path of the stylus, starting with the point that defines the first stylus-down location and ending with the point that defines the last stylus-down location.
Discussion

This function operates on the Ink source from the application, and not on that from direct user input. So there is no need to specify the Ink source as kInkSourceApplication. See “Ink Source Types” for more information on sources.

You do not need to call this function unless you have raw data to process or you have turned off automatic recognition (by calling the function InkSetApplicationWritingMode) and have set up your application to handle Ink input events itself. For example, you might need to handle Ink input if your application needs to acquire pen data in a device-specific manner.

If your application handles Ink input events, it can still take advantage of the recognition service provided by Ink Services. To do so, your application should call the function InkAddStrokeToCurrentPhase to add one stroke at a time to the current phrase. You then terminate the phrase at the appropriate time by calling the function InkTerminateCurrentPhrase. Note that calling InkAddStrokeToCurrentPhase adds a stroke to the current phrase, but does not draw the stroke. See Using Ink Services in Your Application for details on writing code that uses the function InkAddStrokeToCurrentPhase to implement deferred recognition.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkAddStrokeToCurrentPhrase(
   unsigned long iPointCount,
   InkPoint *iPointArray
);

/*InkSetDrawingMode

Controls what is drawn when the user writes. 

void InkSetDrawingMode(
InkDrawingModeType iDrawingMode
);
Parameters
iDrawingMode

A “Drawing Modes” constant that specifies the drawing mode to use for your application. The default (kInkDrawInkAndWritingGuides) is for Ink Services to draw both the Ink writing guides and the Ink. Pass kInkDrawInkOnly if you want Ink Services to draw only the Ink. Pass kInkDrawNothing to turn off drawing of both the Ink writing guides and the Ink.
Discussion

Normally Ink Services draws writing guides, similar in look to the alternating solid and broken lines used on many paper writing tablets. The Ink itself is drawn anti-aliased and grayscale. Your application can call the function InkSetDrawingMode to request that Ink Services not draw the writing guides or not draw either Ink or the writing guides. If Ink drawing is disabled, your application must receive the points (by installing a handler for kEventInkPoint events) and draw the Ink. 

You do not need to call the function InkSetDrawingMode to inhibit drawing if you called the function InkSetApplicationWritingMode, passing the value kInkWriteNowhereInApp. Also, Ink Services will not draw any point for which a kEventInkPoint Carbon event handler returns noErr.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/

void InkSetDrawingMode(
InkDrawingModeType iDrawingMode
);

/*InkDrawingModeType iDrawingMode
);

InkSetApplicationWritingMode

Controls where the user is allowed to write in the current application.

void InkSetApplicationWritingMode (
   InkApplicationWritingModeType iWriteWhere
   );
Parameters
iWriteWhere

An “Application Modes” constant that specifies the Ink writing mode to use for your application. Pass kInkWriteAnywhereInApp if you want your application to allow Ink input and recognition and to receive Ink events when the user writing mode is set to kInkWriteInkAwareOnly. When you call this function with the iWriteWhere parameter set to kInkWriteAnywhereInApp, your application can receive Ink events whose screen locations lie outside the application windows. Pass kInkWriteNowhereInApp to disable Ink input temporarily, such as when the user is using a paint tool. 
Discussion

You can call the function InkSetApplicationWritingMode to control when Ink input and recognition are allowed in your application. Using this function, you can turn Ink Services on or off for your application. Note that Ink input is available for your application only when your application is frontmost and when the user has turned on recognition in the Ink preferences pane.

If your application calls the function InkSetApplicationWritingMode with the parameter kInkWriteNowhereInApp to disable Ink Services management of pen events because you want to accumulate Ink data yourself, be aware that you may need to manage mouse event coalescing yourself. You can use the Carbon Event Manger function SetMouseCoalescingEnabled for this purpose. See Using Ink Services in Your Application for a discussion of mouse coalescing.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void InkSetApplicationWritingMode (
   InkApplicationWritingModeType iWriteWhere
   );

/*InkSetApplicationRecognitionMode

Specifies whether Ink input should be interpreted as text, gestures, both, or neither.

void     InkSetApplicationRecognitionMode(
   InkRecognitionType iRecognitionType
);
Parameters
iRecognitionType

The recognition mode you want Ink Services to use. Pass kInkRecognitionGesture to specify gesture recognition, kInkRecognitionText to specify text recognition, kInkRecognitionNone to turn off recognition, or kInkRecognitionDefault (which is kInkRecognitionGesture | kInkRecognitionText) to specify both gesture and text recognition. See “Recognition Modes” for more information on the constants you can supply. 
Discussion

This function only affects recognition of Ink that originates from the user. It does not affect recognition of Ink that originates from your application, and is recognized using the function InkAddStrokeToCurrentPhrase. Note that only text recognition (not gesture recognition) is performed on an Ink data stream that originates from your application.
Availability
Not available in CarbonLib 1.x.
Available in Mac OS X v10.3 and later.
Declared In
Ink.h*/
void     InkSetApplicationRecognitionMode(
   InkRecognitionType iRecognitionType
);

#ifdef __cplusplus
}
#endif

#endif