#ifndef NAVIGATION_H
#define NAVIGATION_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef TRANSLATION_H
#include <HIToolbox/Translation.h>
#endif

#ifndef MACWINDOWS_H
#include <HIToolbox/MacWindows.h>
#endif

//#include <HYS/NavigationServices/Navigation.h>
#include <APPLE/NavigationServices/Navigation.h>
#include <AvailabilityMacros.h>
#include <CarbonCore/MacTypes.h>//hys

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*NavMenuItemSpec Version Constant

Represents the current version of the NavMenuItemSpec structure.

enum {
   kNavMenuItemSpecVersion = 0
};*/
enum {
   kNavMenuItemSpecVersion = 0
};

/*(Custom Control Settings

Provide constants that allow you to control various aspects of the active dialog.

typedef SInt32 NavCustomControlMessage;
enum {
   kNavCtlShowDesktop = 0,
   kNavCtlSortBy = 1,
   kNavCtlSortOrder = 2,
   kNavCtlScrollHome = 3,
   kNavCtlScrollEnd = 4,
   kNavCtlPageUp = 5,
   kNavCtlPageDown = 6,
   kNavCtlGetLocation = 7,
   kNavCtlSetLocation = 8,
   kNavCtlGetSelection = 9,
   kNavCtlSetSelection = 10,
   kNavCtlShowSelection = 11,
   kNavCtlOpenSelection = 12,
   kNavCtlEjectVolume = 13,
   kNavCtlNewFolder = 14,
   kNavCtlCancel = 15,
   kNavCtlAccept = 16,
   kNavCtlIsPreviewShowing = 17,
   kNavCtlAddControl = 18,
   kNavCtlAddControlList = 19,
   kNavCtlGetFirstControlID = 20,
   kNavCtlSelectCustomType = 21,
   kNavCtlSelectAllType = 22,
   kNavCtlGetEditFileName = 23,
   kNavCtlSetEditFileName = 24,
   kNavCtlSelectEditFileName = 25,
   kNavCtlBrowserSelectAll = 26,
   kNavCtlGotoParent = 27,
   kNavCtlSetActionState = 28,
   kNavCtlBrowserRedraw = 29,
   kNavCtlTerminate = 30
};
Constants
kNavCtlShowDesktop

Tells Navigation Services to change the browser list location to the desktop.

Available in Mac OS X v10.0 and later.
kNavCtlSortBy

Alerts Navigation Services that your application is setting a sort key in the browser list. In addition to the kNavCtlSortBy constant, your application passes one of the NavSortKeyField constants in the parms parameter of the function NavCustomControl. For a description of the NavSortKeyField constants, see “File Sorting Constants”.

Available in Mac OS X v10.0 and later.
kNavCtlSortOrder

Alerts Navigation Services that your application is setting sort order, either ascending or descending, in the browser list. In addition to passing the kNavCtlSortOrder constant, your application must pass one of the NavSortOrder constants in the parms parameter of the NavCustomControl function. For a description of the NavSortOrder constants, see “Sort Order Constants”.

Available in Mac OS X v10.0 and later.
kNavCtlScrollHome

Tells Navigation Services to scroll the browser to the top of the file list.

Available in Mac OS X v10.0 and later.
kNavCtlScrollEnd

Tells Navigation Services to scroll the browser to the bottom of the file list.

Available in Mac OS X v10.0 and later.
kNavCtlPageUp

Tells Navigation Services to scroll the browser up one page length as a result of the user clicking the scroll bar above the scroll box.

Available in Mac OS X v10.0 and later.
kNavCtlPageDown

Tells Navigation Services to scroll the browser down one page length as a result of the user clicking the scroll bar below the scroll box.

Available in Mac OS X v10.0 and later.
kNavCtlGetLocation

Tells Navigation Services to return the current location. Navigation Services reports the current location by setting a pointer to an AEDesc structure in the param field of the structure of type NavCBRec that you specified in your event-handling function. 

Available in Mac OS X v10.0 and later.
kNavCtlSetLocation

Tells Navigation Services that your application wishes to set the location being viewed in the browser list. In addition to specifying the kNavCtlSetLocation constant, your application passes a pointer to an AEDesc structure describing the new location in the parms parameter of the NavCustomControl function.

Available in Mac OS X v10.0 and later.
kNavCtlGetSelection

Tells Navigation Services to return the selected item or items in the browser. When you specify this constant, Navigation Services returns a pointer to an AEDesc structure describing the selected item(s) in the param field of the structure of type NavCBRec that you specified in your event-handling function. If the user deselects the current selection, the AEDescList returned by Navigation Services contains an empty reference. You can account for this case by using the function AECountItems and checking for a zero count.

Available in Mac OS X v10.0 and later.
kNavCtlSetSelection

Tells Navigation Services to change the browser list selection. In addition to specifying the kNavCtlSetSelection constant, your application must pass a pointer to an AEDescList structure describing the selection in the parms parameter of the NavCustomControl function. If you want to deselect the current selection without making a new selection, pass NULL for the pointer. Note: If you specify this constant, Navigation Services notifies your event-handling function by setting the kNavCBSelectEntry constant twice; once when the previous selection is deselected, and once when the new selection is made.

Available in Mac OS X v10.0 and later.
kNavCtlShowSelection

Tells Navigation Services to make the current selection visible in the browser list if the selection has been scrolled out of sight by the user.

Available in Mac OS X v10.0 and later.
kNavCtlOpenSelection

Tells Navigation Services to open the current selection.

Available in Mac OS X v10.0 and later.
kNavCtlEjectVolume

Tells Navigation Services to eject a volume. In addition to specifying this constant, you pass a pointer to the volume reference number (vRefNum) of the volume to be ejected in the parms parameter of the NavCustomControl function.

Available in Mac OS X v10.0 and later.
kNavCtlNewFolder

Tells Navigation Services to create a new folder in the current browser location. In addition to specifying the kNavCtlNewFolder constant, your application passes a string representing the name of the new folder in the parms parameter of the NavCustomControl function. 

Available in Mac OS X v10.0 and later.
kNavCtlCancel

Tells Navigation Services to dismiss the Open or Save dialog as if the user had pressed the Cancel button.

Available in Mac OS X v10.0 and later.
kNavCtlAccept

Tells Navigation Services to close the Open or Save dialog as if the user had pressed the Open or Save button. Navigation Services does not act on this constant if there is no current selection.

Available in Mac OS X v10.0 and later.
kNavCtlIsPreviewShowing

Asks Navigation Services if the preview area is currently available. If you specify this constant, Navigation Services sets a pointer to a Boolean value in the param field of the NavCBRec structure that you specified in your event-handling function. This value is true if the preview area is available, false otherwise.

Available in Mac OS X v10.0 and later.
kNavCtlAddControl

Tells Navigation Services to add one application-defined control to Open or Save dialogs. In addition to sending this message, your application passes a control handle in the parms parameter of the NavCustomControl function. Design the control in local coordinates.

Note: To avoid any unnecessary flickering or redrawing, ensure the control is initially invisible before specifying this constant. You may set the control to visible after Navigation Services supplies the kNavCBStart constant, described in “Event Messages”, in the param field of the NavCBRec structure. If the user resizes the dialog, your application must move the control because it is not maintained by Navigation Services. If you use the kNavCtlAddControlList constant (described next) and you supply a 'DITL' resource, you avoid the need to move the control yourself.

Available in Mac OS X v10.0 and later.
kNavCtlAddControlList

Tells Navigation Services to add a list of application-defined dialog items to Open or Save dialogs. In addition to specifying this constant, your application passes a handle to a dialog item list or 'DITL' resource in the parms parameter of the NavCustomControl function. Design the 'DITL' resource in local coordinates. Navigation Services adds the custom items relative to the upper left corner of the customization area. If the user resizes the dialog, your custom items are moved automatically.

Available in Mac OS X v10.0 and later.
kNavCtlGetFirstControlID

Asks Navigation Services to help you identify the first custom control in the dialog, in order to determine which custom control item was selected by the user. Navigation Services returns a pointer to a 16-bit integer that indicates the item number of the first custom control in the param field of the structure of type NavCBRec that you specified in your event-handling function. In your event-handling function, use the Dialog Manager function FindDialogItem to find out which item was selected. The FindDialogItem function returns 0 for the first item, 1 for the second and so on. To get the proper item number, add 1 to the FindDialogItem function result. The Open or Save dialog’s standard controls precede yours, so use the formula (itemHit - yourFirstItem + 1) to determine which of your items was selected. Your application should not depend on any hardcoded value for the number of items, since this value is likely to change in the future.

Be sure to test the result from FindDialogItem to ensure that it describes a control that you defined. Your application must not respond to any controls that do not belong to it. 

Available in Mac OS X v10.0 and later.
kNavCtlSelectCustomType

Tells Navigation Services to set one of your custom menu items in the Show pop-up menu or the Format pop-up menu as the default selection. This is useful if you want to override the default pop-up menu selection. In addition to specifying this constant, pass a pointer to a NavMenuItem structure in the parms parameter of the NavCustomControl function. This structure describes the item you wish to have selected.

Available in Mac OS X v10.0 and later.
kNavCtlSelectAllType

Tells Navigation Services to override the default menu item in the Type pop-up menu. By specifying one of the NavPopupMenuItem constants, described in“Menu Item Selection Constants”, in the parms parameter of the NavCustomControl function, you can set the default item to All [AppName] Documents, All Readable Documents or All Documents.

Available in Mac OS X v10.0 and later.
kNavCtlGetEditFileName

Tells Navigation Services to return the name of the file to be saved by a file-saving function. This would be useful if you wanted to automatically add an extension to the filename, for example. When you send this message, the parms parameter of the NavCustomControl function returns a StringPtr to a Pascal string containing the filename. Note that in Carbon, you can use the NavDialogGetSaveFileName function to obtain a Unicode string containing the filename.

Available in Mac OS X v10.0 and later.
kNavCtlSetEditFileName

Tells Navigation Services that your application wishes to set the name of the file to be saved by a file-saving function. Your application normally specifies the KNavCtlSetEditFileName constant after modifying the filename obtained by specifying the kNavCtlGetEditFileName constant. In addition to specifying the kNavCtlSetEditFileName constant, your application passes a StringPtr to a Pascal string containing the filename in the parms parameter of the NavCustomControl function. Note that you can set the filename with a Unicode string by calling the NavDialogSetSaveFileName function.

Available in Mac OS X v10.0 and later.
kNavCtlSelectEditFileName

(Navigation Services 1.1 or later) Tells Navigation Services to display the name of the file to be saved by the function with some or all of the filename string highlighted for selection. In addition to specifying the kNavCtlSelectEditFileName constant, your application passes a Control Manager structure of type ControlEditTextSelectionRec in the parms parameter of the NavCustomControl function in order to specify which part of the filename string to highlight. For more information on the ControlEditTextSelectionRec structure, see Inside Mac OS X: Control Manager Reference.

Available in Mac OS X v10.0 and later.
kNavCtlBrowserSelectAll

(Navigation Services 2.0 or later.) Tells Navigation Services to select all files in the browser list.

Available in Mac OS X v10.0 and later.
kNavCtlGotoParent

(Navigation Services 2.0 or later.) Tells Navigation Services to navigate to the parent folder or volume of the current selection.

Available in Mac OS X v10.0 and later.
kNavCtlSetActionState

(Navigation Services 2.0 or later.) Prevents Navigation Services from handling certain user actions, such as opening or saving files. This is useful if you want to prevent the dismissal of a dialog until certain conditions are met, for example. Specify which actions to prevent by passing one or more of the constants defined by the NavActionState enumeration, described in “Action State Constants”.

Available in Mac OS X v10.0 and later.
kNavCtlBrowserRedraw

(Navigation Services 2.0 or later.) Tells Navigation Services to refresh the browser list.

Available in Mac OS X v10.0 and later.
kNavCtlTerminate

(Navigation Services 2.0 or later.) Tells Navigation Services to dismiss the current dialog. This constant is similar to kNavCtlCancel, except that using kNavCtlTerminate does not return an error code.

Available in Mac OS X v10.0 and later.
Discussion

The NavCustomControlMessage data type defines constants that your application can pass in the selector parameter of the function NavCustomControl to control various aspects of the active dialog.*/
typedef SInt32 NavCustomControlMessage;
enum {
   kNavCtlShowDesktop = 0,
   kNavCtlSortBy = 1,
   kNavCtlSortOrder = 2,
   kNavCtlScrollHome = 3,
   kNavCtlScrollEnd = 4,
   kNavCtlPageUp = 5,
   kNavCtlPageDown = 6,
   kNavCtlGetLocation = 7,
   kNavCtlSetLocation = 8,
   kNavCtlGetSelection = 9,
   kNavCtlSetSelection = 10,
   kNavCtlShowSelection = 11,
   kNavCtlOpenSelection = 12,
   kNavCtlEjectVolume = 13,
   kNavCtlNewFolder = 14,
   kNavCtlCancel = 15,
   kNavCtlAccept = 16,
   kNavCtlIsPreviewShowing = 17,
   kNavCtlAddControl = 18,
   kNavCtlAddControlList = 19,
   kNavCtlGetFirstControlID = 20,
   kNavCtlSelectCustomType = 21,
   kNavCtlSelectAllType = 22,
   kNavCtlGetEditFileName = 23,
   kNavCtlSetEditFileName = 24,
   kNavCtlSelectEditFileName = 25,
   kNavCtlBrowserSelectAll = 26,
   kNavCtlGotoParent = 27,
   kNavCtlSetActionState = 28,
   kNavCtlBrowserRedraw = 29,
   kNavCtlTerminate = 30
};

/*NavReplyRecord Version Constant

Represents the current version of the NavReplyRecord structure.

enum {
   kNavReplyRecordVersion = 2
};*/

enum {
   kNavReplyRecordVersion = 2
};

/*NavDialogCreationOptions Version Constant

Represents the current version of the NavDialogCreationOptions structure.

enum {
   kNavDialogCreationOptionsVersion = 0
};*/

enum {
   kNavDialogCreationOptionsVersion = 0
};


/*Generic File Signature Constant

Defines a generic creator code.

enum {
   kNavGenericSignature = '****'
};
Constants
kNavGenericSignature

Tells Navigation Services to display all files of a specified type, regardless of the file’s creator code.

Available in Mac OS X v10.0 and later.
Discussion

To specify that your application can open all files of a given type (such as 'TEXT', for example), specify the kNavGenericSignature constant in the componentSignature field of the structure of type NavTypeList that you pass to a function that creates a file-opening dialog, such as NavCreateGetFileDialog. You can also pass this constant in the inFileCreator parameter of the function NavCreatePutFileDialog in order to override the types of files appearing in the Format pop-up menu.
Version Notes

Added in Navigation Services 2.0*/
enum {
   kNavGenericSignature = '****'
};


/*NavTypeList

Defines a list of file types that your application is capable of opening. 

struct NavTypeList {
   OSType componentSignature;
   short reserved;
   short osTypeCount;
   OSType osType[1];
};
typedef struct NavTypeList NavTypeList;
typedef NavTypeList * NavTypeListPtr;
Fields
componentSignature

A four character code specifying your application signature. If you want your application to be able to open all files of the types you specify in the osType field (regardless of which application created them), specify the kNavGenericSignature constant in this field.
reserved

Reserved.
osTypeCount

A number indicating how many file types are defined in the osType field.
osType

A list of file types your application can open.
Discussion

Your application uses the NavTypeList structure to define a list of file types that your application is capable of opening. Your application passes a pointer to this list to Navigation Services functions that display Open or Save dialogs. You may create this list dynamically or reference a Translation Manager 'open' resource.

For more information on the 'open' resource and the Translation Manager, see the “Translation Manager” chapter in Inside Macintosh: More Macintosh Toolbox. 
Availability
Available in Mac OS X v10.0 and later.*/
struct NavTypeList {
   OSType componentSignature;
   short reserved;
   short osTypeCount;
   OSType osType[1];
};
typedef struct NavTypeList NavTypeList;
typedef NavTypeList * NavTypeListPtr;
typedef  NavTypeListPtr * NavTypeListHandle ;

/*Translation Options

Let you specify how files are translated.

typedef UInt32 NavTranslationOptions;
enum {
   kNavTranslateInPlace = 0,
   kNavTranslateCopy = 1
};
Constants
kNavTranslateInPlace

Tells Navigation Services to replace the source file with the translation. This setting is the default for Save dialogs.

Available in Mac OS X v10.0 and later.
kNavTranslateCopy

Tells Navigation Services to create a translated copy of the source file. This setting is the default for Open dialogs. The NavCompleteSave function always uses this setting under automatic translation.

Available in Mac OS X v10.0 and later.
Discussion

Your application passes one of the NavTranslationOptions constants to the howToTranslate parameter to specify how files are to be translated by the function NavTranslateFile.*/
typedef UInt32 NavTranslationOptions;
enum {
   kNavTranslateInPlace = 0,
   kNavTranslateCopy = 1
};


/*NavReplyRecord

Contains information about user interaction with a dialog.

struct NavReplyRecord {
   UInt16 version;
   Boolean validRecord;
   Boolean replacing;
   Boolean isStationery;
   Boolean translationNeeded;
   AEDescList selection;
   ScriptCode keyScript;
   FileTranslationSpecArrayHandle fileTranslation;
   UInt32 reserved1;
   CFStringRef saveFileName;
   Boolean saveFileExtensionHidden;
   UInt8 reserved2;
   char reserved[225];
};
typedef struct NavReplyRecord NavReplyRecord;
Fields
version

Identifies the version of this structure. The structure version is represented by the constant kNavReplyRecordVersion.
validRecord

A Boolean value of true if the user closes a dialog by pressing Return or Enter, or by clicking the default button in an Open or Save dialog. If this field is false, all other fields are unused and do not contain valid data.
replacing

A Boolean value of true if the user chooses to save a file by replacing an existing file (thereby necessitating the removal or renaming of the existing file).
isStationery

A Boolean value informing your application whether the file about to be saved should be saved as a stationery document.
translationNeeded

A Boolean value indicating whether translation was or will be needed for files selected in Open and Save dialogs.
selection

For a file-opening or file-choosing dialog, this is an Apple event descriptor list (AEDescList) containing references to items selected by the user. Navigation Services creates this list, which is automatically disposed of when your application calls the NavDisposeReply function. Some dialogs may return one or more items; you can determine the number of items in the list by calling the Apple Event Manager function AECountItems. Each selected HFS file object is described in an AEDesc structure of type 'typeFSS' or 'typeFSRef'. You can coerce this descriptor into a file reference to perform operations such as opening the file. If you use one of the Carbon-compliant dialog creation functions described in“Choosing Files, Folders and Volumes” and “Saving Files”, the descriptor is of type 'typeFSS' on Mac OS 8 or 9; on Mac OS X systems, this descriptor is of type 'typeFSRef'.File-saving dialogs always return a single descriptor in the list. If you use the NavCreatePutFileDialog function, this descriptor specifies the directory where the file is to be saved. You can obtain the name for the save file from the saveFileName field. 
keyScript

The keyboard script system used for the filename.
fileTranslation

A handle to a Translation Manager structure of type FileTranslationSpec. This structure contains a corresponding translation array for each file reference returned in the selection field. When opening files, Navigation Services performs the translation automatically unless you set the kNavDontAutoTranslate flag in the dialogOptionFlags field of the NavDialogCreationOptions structure. When Navigation Services performs an automatic translation, the FileTranslationSpec structure is strictly for the Translation Manager’s use. If you turn off automatic translation, your application may use the FileTranslationSpec structure for your own translation scheme. If the user chooses a translation for a saved file, the FileTranslationSpec structure contains a single translation reference for the saved file and the translationNeeded field of the NavReplyRecord structure is set to true. The handle to the FileTranslationSpec structure is locked, so you can safely use dereferenced pointers. 
reserved1

Reserved.
saveFileName

If the reply record is filled out by a dialog created with the NavCreatePutFileDialog function, this field contains a string specifying the name of a file to be saved. This field contains the entire name of the file, regardless of whether or not any file extension is visible to the user. You can identify the directory in which the file is to be saved by checking the selection field.

This field was added in structure version 1. 
saveFileExtensionHidden

A Boolean value indicating whether the extension on the name of the saved file should be hidden. Once the file has been saved, the client call the NavCompleteSave function. NavCompleteSave hides the extension on the file. However, the client needs to know that the extension is hidden so that it can display the document name correctly in the user interface, such as in window titles and menus. This field is only used if the client has requested extension preservation using the kNavPreserveSaveFileExtension dialog option flag. This field was added in structure version 2.
reserved2

Reserved.
reserved

Reserved.
Discussion

Navigation Services uses the NavReplyRecord structure to provide your application with information about the user’s interactions with a Navigation Services dialog. If the dialog is created with the Carbon-compliant NavCreate...Dialog functions, you obtain the NavReplyRecord by calling the NavDialogGetReply function after your event-handling function receives the kNavCBUserAction event. If you create the dialog using one of the older functions, you pass the address of a NavReplyRecord directly to the function that invokes the dialog. When your application is through using the structure, remember to dispose of it by calling the function NavDisposeReply. 
Availability
Available in Mac OS X v10.0 and later.*/
struct NavReplyRecord {
   UInt16 version;
   Boolean validRecord;
   Boolean replacing;
   Boolean isStationery;
   Boolean translationNeeded;
   AEDescList selection;
   ScriptCode keyScript;
   FileTranslationSpecArrayHandle fileTranslation;
   UInt32 reserved1;
   CFStringRef saveFileName;
   Boolean saveFileExtensionHidden;
   UInt8 reserved2;
   char reserved[225];
};
typedef struct NavReplyRecord NavReplyRecord;

/*NavEventDataInfo

Provides event??handling data to your application.

union NavEventDataInfo {
   EventRecord * event;
   void * param;
};
typedef union NavEventDataInfo NavEventDataInfo;
Fields
event

A pointer to the EventRecord structure describing an event to be handled by your event-handling function. 
param

A pointer to additional event data. In most cases, this data consists of an Apple event descriptor list (AEDescList) for the file or files affected by the event described in the event field. For example, if the event consists of the user making a selection in the browser list, the AEDescList specifies the file or files selected.
Availability
Available in Mac OS X v10.0 and later.*/
union NavEventDataInfo {
   EventRecord * event;
   void * param;
};
typedef union NavEventDataInfo NavEventDataInfo;


/*Save Changes Requests

Describe the condition that prompts a Save Changes dialog.

typedef UInt32 NavAskSaveChangesAction;
enum {
   kNavSaveChangesClosingDocument = 1,
   kNavSaveChangesQuittingApplication = 2,
   kNavSaveChangesOther = 0
};
Constants
kNavSaveChangesClosingDocument

Requests a Save Changes alert that asks the user whether to save changes when closing a document.

Available in Mac OS X v10.0 and later.
kNavSaveChangesQuittingApplication

Requests a Save Changes alert that asks the user whether to save changes when quitting your application.

Available in Mac OS X v10.0 and later.
kNavSaveChangesOther

Requests a Save Changes alert that asks the user whether to save changes at some time other than closing or quitting. This is useful when your application prompts the user to save documents at timed intervals, for example.

Available in Mac OS X v10.0 and later.
Discussion

Your application requests a Save Changes alert by specifying one of the following constants, defined by the NavAskSaveChangesAction data type, in the inAction parameter of the function NavCreatePutFileDialog.*/

typedef UInt32 NavAskSaveChangesAction;
enum {
   kNavSaveChangesClosingDocument = 1,
   kNavSaveChangesQuittingApplication = 2,
   kNavSaveChangesOther = 0
};

/*NavEventData

Contains event data for Navigation Services dialogs.

struct NavEventData {
   NavEventDataInfo eventDataParms;
   SInt16 itemHit;
};
typedef struct NavEventData NavEventData;
Fields
eventDataParms

A structure of type NavEventDataInfo.
itemHit

A signed integer value. On return, this value represents the item number of the dialog item last clicked by the user. If the user clicks something other than a valid Navigation Services-generated control item, this value is -1.
Discussion

The NavEventData structure is passed to your application-defined event-handling or preview function in the eventData field of the NavCBRec structure.

The NavEventData structure contains a structure of type NavEventDataInfo. In Navigation Services 1.1 or later, the NavEventData structure also contains a field describing the dialog item last clicked by the user.
Version Notes

itemHit field added in Navigation Services 1.1.
Availability
Available in Mac OS X v10.0 and later.*/
struct NavEventData {
   NavEventDataInfo eventDataParms;
   SInt16 itemHit;
};
typedef struct NavEventData NavEventData;



/*NavDialogRef

An opaque reference to an instance of a Navigation Services dialog.

typedef struct __NavDialog * NavDialogRef;
Discussion

Your application obtains a NavDialogRef by calling one of the dialog creation functions described in ??Choosing Files, Folders and Volumes?? and ??Saving Files??. Once you obtain a valid reference, you pass it to other functions in order to display and process dialogs. When you are completely finished using the reference, dispose of it by calling the function NavDialogDispose. This data type is available in CarbonLib 1.1 and later and in Mac OS X. It replaces the NavContext data type previously used by Navigation Services. 
Availability
Available in Mac OS X v10.0 and later*/
typedef struct __NavDialog * NavDialogRef;


/*User Actions

typedef UInt32 NavUserAction;
enum {
   kNavUserActionNone = 0,
   kNavUserActionCancel = 1,
   kNavUserActionOpen = 2,
   kNavUserActionSaveAs = 3,
   kNavUserActionChoose = 4,
   kNavUserActionNewFolder = 5,
   kNavUserActionSaveChanges = 6,
   kNavUserActionDontSaveChanges = 7,
   kNavUserActionDiscardChanges = 8,
   kNavUserActionReviewDocuments = 9,
   kNavUserActionDiscardDocuments = 10
};
Constants
kNavUserActionNone

The dialog is still running or was terminated programmatically.

Available in Mac OS X v10.0 and later.
kNavUserActionCancel

The user pressed the Cancel button.

Available in Mac OS X v10.0 and later.
kNavUserActionOpen

The user pressed the Open button in a file-opening dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionSaveAs

The user pressed the Save button in a file-saving dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionChoose

The user pressed the Choose button in a Choose dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionNewFolder

The user pressed the New Folder button in a New Folder dialog and Navigation Services created a folder.

Available in Mac OS X v10.0 and later.
kNavUserActionSaveChanges

The user pressed the Save button in a Save Changes dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionDontSaveChanges

The user pressed the Don??t Save button in a Save Changes dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionDiscardChanges

The user pressed the Discard button in a Discard Changes dialog.

Available in Mac OS X v10.0 and later.
kNavUserActionReviewDocuments

The user clicked the Review Unsaved button in the Review Documents dialog (used only on Mac OS X).

Available in Mac OS X v10.1 and later.
kNavUserActionDiscardDocuments

The user clicked the Discard Changes button in the Review Documents dialog (used only on Mac OS X).

Available in Mac OS X v10.1 and later.
Discussion

Navigation Services passes one of the constants defined by the NavUserAction enumeration to your application in the userAction field of a NavCBRec structure in order to indicate which action was taken by the user during a Navigation Services dialog.*/

typedef UInt32 NavUserAction;
enum {
   kNavUserActionNone = 0,
   kNavUserActionCancel = 1,
   kNavUserActionOpen = 2,
   kNavUserActionSaveAs = 3,
   kNavUserActionChoose = 4,
   kNavUserActionNewFolder = 5,
   kNavUserActionSaveChanges = 6,
   kNavUserActionDontSaveChanges = 7,
   kNavUserActionDiscardChanges = 8,
   kNavUserActionReviewDocuments = 9,
   kNavUserActionDiscardDocuments = 10
};


/*NavCBRec

Provides information you can use for event-handling and customization.

struct NavCBRec {
   UInt16 version;
   NavDialogRef context;
   WindowRef window;
   Rect customRect;
   Rect previewRect;
   NavEventData eventData;
   NavUserAction userAction;
   char reserved[218];
};
typedef struct NavCBRec NavCBRec;
typedef NavCBRec * NavCBRecPtr;
Fields
version

Identifies the version of this structure. This value is defined by the kNavCBRecVersion constant.
context

An opaque object identifying the dialog instance. 
window

An opaque object identifying the dialog??s window.
customRect

A local coordinate rectangle describing the customization area available to your application. This determines how much room your application has to install custom controls.
previewRect

A local coordinate rectangle describing the preview area available to your application??s preview function. The minimum size is 145 pixels wide by 118 pixels high.
eventData

A structure of type NavEventData. This structure provides event-specific data to your NavEventProcPtr function.
userAction

A constant specifying the action taken by the user, generating a kNavCBUserAction event. See ??User Actions?? for a description of the possible values for this field.

This field is available in CarbonLib 1.1 and later or in Mac OS X version 10.0 and later.
reserved

Reserved.*/
struct NavCBRec {
   UInt16 version;
   NavDialogRef context;
   WindowRef window;
   Rect customRect;
   Rect previewRect;
   NavEventData eventData;
   NavUserAction userAction;
   char reserved[218];
};
typedef struct NavCBRec NavCBRec;
typedef NavCBRec * NavCBRecPtr;

/*NavPreviewProcPtr

A pointer to a preview function that displays custom file previews.

typedef Boolean (*NavPreviewProcPtr)
(
   NavCBRecPtr callBackParms,
   void * callBackUD);

If you name your function MyNavPreviewProc, you would declare it like this:

Boolean MyNavPreviewProc (
   NavCBRecPtr callBackParms,
   void * callBackUD);
Parameters
callBackParms

A pointer to a NavCBRec structure. Navigation Services uses this structure to provide data needed for your function to draw the preview.
callBackUD

A pointer to a value set by your application when it calls a Navigation Services function such as NavCreateGetFileDialog. When Navigation Services calls your preview function, the callBackUD value is passed back to your application in this parameter. 
Return Value

A Boolean value. Your application returns true if your preview function successfully draws the custom file preview. If your preview function returns false, Navigation Services displays the preview if the file contains a valid 'pnot' resource. If your preview function returns false and a 'pnot' resource is not available, Navigation Services displays a blank preview area.
Discussion

Register your preview function by passing the resulting Universal Procedure Pointer (UPP) in the previewProc parameter of a Navigation Services dialog creation function. You obtain this UPP by calling the function NewNavPreviewUPP and passing a pointer to your preview-drawing function. When the user selects a file, Navigation Services calls your preview-drawing function. Your preview function, in turn, calls the function NavCustomControl to determine if the preview area is visible and, if so, what its dimensions are.*/
typedef Boolean (*NavPreviewProcPtr)
(
   NavCBRecPtr callBackParms,
   void * callBackUD);


/*NavPreviewUPP

Defines a universal procedure pointer (UPP) to an application-defined preview function.

typedef NavPreviewProcPtr NavPreviewUPP;
Discussion

For more information, see the description of the NavPreviewProcPtr callback function.*/
typedef NavPreviewProcPtr NavPreviewUPP;










/*Event Messages

Define messages sent to your event-handling function.

typedef SInt32 NavEventCallbackMessage;
enum {
   kNavCBEvent = 0,
   kNavCBCustomize = 1,
   kNavCBStart = 2,
   kNavCBTerminate = 3,
   kNavCBAdjustRect = 4,
   kNavCBNewLocation = 5,
   kNavCBShowDesktop = 6,
   kNavCBSelectEntry = 7,
   kNavCBPopupMenuSelect = 8,
   kNavCBAccept = 9,
   kNavCBCancel = 10,
   kNavCBAdjustPreview = 11,
   kNavCBUserAction = 12,
   kNavCBOpenSelection = (long)x80000000
};
Constants
kNavCBEvent

Tells your application that an event has occurred (including an idle event), which provides an opportunity for your application to track controls, update other windows, and so forth. Your application can obtain the event record describing this event from the event field of the NavCBRec structure. The kNavCBEvent constant is the only message that needs to be processed by most applications that do not customize Open and Save dialogs.

Available in Mac OS X v10.0 and later.
kNavCBCustomize

Tells your application to supply a dialog customization request. The customRect field of the NavCBRec structure defines a rectangle in the local coordinates of the dialog; the top-left coordinates define the anchor point for a customization rectangle. If you want to customize the dialog, your application responds to the kNavCBCustomize message by setting a value in the customRect field that completes the dimensions of the customization rectangle. After your application responds, Navigation Services inspects the customRect field to determine if the requested dimensions result in a dialog that can fit on the screen. If the dimensions are too large, then Navigation Services responds by setting the rectangle to the largest size that the screen can accommodate. Your application can continue to "negotiate" by examining the customRect field and requesting a different size until Navigation Services provides an acceptable rectangle value, at which time you should create your custom control or item list. The minimum size for the customization area is 400 pixels wide by 40 pixels high.

Note: Don??t add new dialog items until your application receives the kNavCBStart event message constant.

Available in Mac OS X v10.0 and later.
kNavCBStart

Tells your application that a dialog is ready to be displayed. After receiving the kNavCBCustomize event message constant, your event-handling function should wait for the kNavCBStart event message constant to ensure that your application can safely add dialog items. No additional data is provided to your application with this constant.

Available in Mac OS X v10.0 and later.
kNavCBTerminate

Tells your application that the dialog is about to be closed, which means you must remove any user-interface items that were created in response to the kNavCBStart message. You can determine which user action closed the dialog by checking the userAction field of the NavCBRec structure.

Available in Mac OS X v10.0 and later.
kNavCBAdjustRect

Tells your application that the dialog has been resized and the customization rectangle has been accordingly resized. Use the customRect field from the NavCBRec structure to determine the new customization rectangle size. Your application does not need to offset the controls; Navigation Services moves them automatically. Your application is responsible for any redrawing of the controls or handling events beyond moving the controls, however.

Available in Mac OS X v10.0 and later.
kNavCBNewLocation

Tells your application that a new location is being viewed in the dialog. The param field of the NavCBRec structure contains a pointer to an AEDesc structure of type 'typeFSS' describing the new location. This pointer is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBShowDesktop

Tells your application that the Open or Save dialog is showing the desktop view, consisting of the composite of all desktop folders from all mounted volumes. The param field of the NavCBRec structure contains a pointer to an AEDescList structure identifying the desktop location. This pointer is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBSelectEntry

Tells your application that an entry in the browser list has been selected or deselected by the user. The param field of the NavEventDataInfo structure contains a pointer to an AEDescList record of type 'typeFSS' identifying the current selection. If the user deselects the current selection, the AEDescList record contains an empty reference. This pointer is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBPopupMenuSelect

Tells your application that a selection was made from the Open dialog??s Show pop-up menu or Save dialog??s Format pop-up menu. TheNavCBRec.eventData.eventDataParms.param field contains a pointer to a NavMenuItemSpec structure describing the pop-up menu item selected. If the dialog was created using the Carbon-only NavCreateXXXDialog APIs, then the menuType field of the NavMenuItemSpec structure is set to the index into the client's CFArray of popupExtension strings in the NavDialogCreationOptions structure. This data is valid only during the execution of your event-handling function.

Available in Mac OS X v10.0 and later.
kNavCBAccept

Tells your application that the user has pressed the Accept button.

Available in Mac OS X v10.0 and later.
kNavCBCancel

Tells your application that the user has pressed the Cancel button.

Available in Mac OS X v10.0 and later.
kNavCBAdjustPreview

Tells your application that the user has toggled the preview area on or off. The param field of the NavCBRec structure contains a pointer to a Boolean value of true if the preview area is toggled on and false if toggled off. This information is useful if your application creates custom controls in the preview area.

Available in Mac OS X v10.0 and later.
kNavCBUserAction

(Available only in CarbonLib 1.1 and later and in Mac OS X version 10.0 and later.) Tells your application that the user has taken an action. To determine which action the user took, call the NavDialogGetUserAction function.

Available in Mac OS X v10.0 and later.
kNavCBOpenSelection

(Navigation Services 2.0 or later.) Tells your application that the user has opened a file or chosen a file object. After detecting this constant, you can call the NavCustomControl function and specify one of the NavActionState constants, described in ??Action State Constants??, in order to block the opening or choosing action.

Available in Mac OS X v10.0 and later.*/
typedef SInt32 NavEventCallbackMessage;
enum {
   kNavCBEvent = 0,
   kNavCBCustomize = 1,
   kNavCBStart = 2,
   kNavCBTerminate = 3,
   kNavCBAdjustRect = 4,
   kNavCBNewLocation = 5,
   kNavCBShowDesktop = 6,
   kNavCBSelectEntry = 7,
   kNavCBPopupMenuSelect = 8,
   kNavCBAccept = 9,
   kNavCBCancel = 10,
   kNavCBAdjustPreview = 11,
   kNavCBUserAction = 12,
   kNavCBOpenSelection = (long)'x80000000'
};

/*NavEventProcPtr

A pointer to an event-handling function that handles events such as window updating and resizing.

typedef void (*NavEventProcPtr) (
   NavEventCallbackMessage callBackSelector,
   NavCBRecPtr callBackParms,
   void * callBackUD);

If you name your function MyNavEventProc, you would declare it like this:

void MyNavEventProc (
   NavEventCallbackMessage callBackSelector,
   NavCBRecPtr callBackParms,
   void * callBackUD);
Parameters
callBackSelector

One of the values specified by the NavEventCallbackMessage data type. These values indicate which type of event your function must respond to. For a description of the constants that represent these values, see ??Event Messages??. 
callBackParms

A pointer to a NavCBRec structure. Your application uses the data supplied in this structure to process the event.
callBackUD

A pointer to a value set by your application when it calls a Navigation Services dialog creation function. When Navigation Services calls your event-handling function, the callBackUD value is passed back to your application in this parameter. 
Discussion

Register your event-handling function by passing a Universal Procedure Pointer (UPP) in the eventProc parameter of a Navigation Services dialog creation function. You obtain this UPP by calling the function NewNavEventUPP and passing a pointer to your event-handling function. If you determine that an event is appropriate for your event-handling function, you can call other functions to handle custom control drawing.

When events involve controls, your event-handling function must respond to events only for your application-defined controls. To determine which control is affected by an event, pass the kNavCtlGetFirstControlID constant, described in ??Custom Control Settings??, in the selector parameter of the function NavCustomControl.*/
typedef void (*NavEventProcPtr) (
   NavEventCallbackMessage callBackSelector,
   NavCBRecPtr callBackParms,
   void * callBackUD);


/*Object Filtering Constants

Inform you which part of a dialog contains object being filtered.

typedef SInt16 NavFilterModes;
enum {
   kNavFilteringBrowserList = 0,
   kNavFilteringFavorites = 1,
   kNavFilteringRecents = 2,
   kNavFilteringShortCutVolumes = 3,
   kNavFilteringLocationPopup = 4
};
Constants
kNavFilteringBrowserList

The browser list contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringFavorites

The Favorites pop-up menu contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringRecents

The Recent pop-up menu contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringShortCutVolumes

The Shortcuts pop-up menu contains the object being filtered.

Available in Mac OS X v10.0 and later.
kNavFilteringLocationPopup

The object being filtered is the path described by the Location menu.

Available in Mac OS X v10.0 and later.
Discussion

Navigation Services passes one of the constants defined by the NavFilterModes data type to the filterMode parameter of your application-defined filter function to tell your application whether the browser list or one of the navigation option pop-up menus contains the object currently being filtered.*/
typedef SInt16 NavFilterModes;
enum {
   kNavFilteringBrowserList = 0,
   kNavFilteringFavorites = 1,
   kNavFilteringRecents = 2,
   kNavFilteringShortCutVolumes = 3,
   kNavFilteringLocationPopup = 4
};


/*NavObjectFilterProcPtr

A pointer to a filter function that determines whether file objects should be displayed in the browser list and navigation menus.

typedef Boolean (*NavObjectFilterProcPtr)
(
   AEDesc * theItem,
   void * info,
   void * callBackUD,
   NavFilterModes filterMode);

If you name your function MyNavObjectFilterProc, you would declare it like this:

Boolean MyNavObjectFilterProc (
   AEDesc * theItem,
   void * info,
   void * callBackUD,
   NavFilterModes filterMode);
Parameters
theItem

A pointer to an Apple event descriptor structure (AEDesc). Navigation Services uses this structure to provide information about the object being passed to your filter function. Always check the Apple event descriptor type before deciding if an object needs to be filtered. Never assume that an object is a file specification, because the browser or pop-up menus may contain objects of other types. Make sure that your function only returns false if it recognizes the object. 
info

A pointer to a NavFileOrFolderInfo structure. Navigation Services uses this structure to provide file or folder information about the item being passed to your filter function. This information is only valid for objects of descriptor types 'typeFSS' or 'typeFSRef'. 
callBackUD

A pointer to a value set by your application when it calls a Navigation Services dialog creation function. When Navigation Services calls your filter function, the callBackUD value is passed back to your application in this parameter.
filterMode

A value representing which list of objects is currently being filtered. For a description of the constants used to represent these values, see ??Object Filtering Constants??. 
Return Value

A Boolean value. If your application returns true, Navigation Services displays the object. If your application returns false, Navigation Services displays the object as dimmed. 
Discussion

Register your filter function by passing a Universal Procedure Pointer (UPP) in the filterProc parameter of a dialog creation function. You obtain this UPP by calling the function NewNavObjectFilterUPP and passing a pointer to your filter function. Navigation Services calls your filter function to determine whether a file object should be displayed in the browser list or the pop-up menus.

If you use a filter function in conjunction with built-in translation, you should provide a list of file types to inform Navigation Services which document types your application can open. You can do so using the following methods:
Call the NavDialogSetFilterTypeIdentifiers function on an existing dialog to filter by uniform type identifiers. This method is preferable in Mac OS X v10.4 and later. 
Provide a list of allowable OSType file types in the inTypeList parameter of a file-opening function such as NavCreateGetFileDialog

If you provide a list of file types, your filter callback is called only for the files that match the specified type list. For example, if you wanted to enable only text files below a certain size, you could use NavDialogSetFilterTypeIdentifiers to enable only text files, and then use a filter callback to screen for file size. You should make sure that your filter callback doesn??t automatically eliminate a document type in the filter list (for example, if the list allows JPEG files and the callback eliminates everything but PICT files). This is to ensure that the user can always see some files when a particular file type is selected from the Enable popup menu. 

If your filter function returns a result of true, Navigation Services displays the object. Note that this is the opposite of Standard File filter functions.*/
typedef Boolean (*NavObjectFilterProcPtr)
(
   AEDesc * theItem,
   void * info,
   void * callBackUD,
   NavFilterModes filterMode);




/*NavEventUPP

Defines a universal procedure pointer (UPP) to an application-defined event??handling function.

typedef NavEventProcPtr NavEventUPP;
Discussion

For more information, see the description of the NavEventProcPtr callback function.*/
typedef NavEventProcPtr NavEventUPP;


/*NavObjectFilterUPP

Defines a universal procedure pointer (UPP) to an application-defined filter function.

typedef NavObjectFilterProcPtr NavObjectFilterUPP;
Discussion

For more information, see the description of the NavObjectFilterProcPtr callback function.*/
typedef NavObjectFilterProcPtr NavObjectFilterUPP;









/*NavDialogRef

An opaque reference to an instance of a Navigation Services dialog.

typedef struct __NavDialog * NavDialogRef;
Discussion

Your application obtains a NavDialogRef by calling one of the dialog creation functions described in ??Choosing Files, Folders and Volumes?? and ??Saving Files??. Once you obtain a valid reference, you pass it to other functions in order to display and process dialogs. When you are completely finished using the reference, dispose of it by calling the function NavDialogDispose. This data type is available in CarbonLib 1.1 and later and in Mac OS X. It replaces the NavContext data type previously used by Navigation Services. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 NavDialogOptionFlags;
enum {
   kNavDefaultNavDlogOptions = 0x000000E4,
   kNavNoTypePopup = 0x00000001,
   kNavDontAutoTranslate = 0x00000002,
   kNavDontAddTranslateItems = 0x00000004,
   kNavAllFilesInPopup = 0x00000010,
   kNavAllowStationery = 0x00000020,
   kNavAllowPreviews = 0x00000040,
   kNavAllowMultipleFiles = 0x00000080,
   kNavAllowInvisibleFiles = 0x00000100,
   kNavDontResolveAliases = 0x00000200,
   kNavSelectDefaultLocation = 0x00000400,
   kNavSelectAllReadableItem = 0x00000800,
   kNavSupportPackages = 0x00001000,
   kNavAllowOpenPackages = 0x00002000,
   kNavDontAddRecents = 0x00004000,
   kNavDontUseCustomFrame = 0x00008000,
   kNavDontConfirmReplacement = 0x00010000,
   kNavPreserveSaveFileExtension = 0x00020000
};typedef struct __NavDialog * NavDialogRef;

/*alog Configuration Options

Specify dialog configuration options.

typedef UInt32 NavDialogOptionFlags;
enum {
   kNavDefaultNavDlogOptions = 0x000000E4,
   kNavNoTypePopup = 0x00000001,
   kNavDontAutoTranslate = 0x00000002,
   kNavDontAddTranslateItems = 0x00000004,
   kNavAllFilesInPopup = 0x00000010,
   kNavAllowStationery = 0x00000020,
   kNavAllowPreviews = 0x00000040,
   kNavAllowMultipleFiles = 0x00000080,
   kNavAllowInvisibleFiles = 0x00000100,
   kNavDontResolveAliases = 0x00000200,
   kNavSelectDefaultLocation = 0x00000400,
   kNavSelectAllReadableItem = 0x00000800,
   kNavSupportPackages = 0x00001000,
   kNavAllowOpenPackages = 0x00002000,
   kNavDontAddRecents = 0x00004000,
   kNavDontUseCustomFrame = 0x00008000,
   kNavDontConfirmReplacement = 0x00010000,
   kNavPreserveSaveFileExtension = 0x00020000
};
Constants
kNavDefaultNavDlogOptions

Tells Navigation Services to use default configuration options. These default options include:
no custom control titles
no banner or prompt message
automatic resolution of aliases
support for file previews
no display of invisible file objects
support for multiple file selection
support for stationery
no package support
all chosen items added to Recent list
customization area is framed

Available in Mac OS X v10.0 and later.
kNavNoTypePopup

Tells Navigation Services not to display the Show pop-up menu in the Open dialog or the Format pop-up menu in the Save dialog.

Available in Mac OS X v10.0 and later.
kNavDontAutoTranslate

Tells Navigation Services not to do automatic file translation. Normally a file chosen in an Open dialog that requires translation is automatically translated. Navigation Services informs your application that a file needs translating by setting the translationNeeded field of the NavReplyRecord structure to true. A translation specification array specified in the fileTranslation field of the NavReplyRecord structure contains the associated translation specification records. When you set the kNavDontAutoTranslate flag, your application is responsible for translation, either by calling the function NavTranslate or by performing the translation itself.

Available in Mac OS X v10.0 and later.
kNavDontAddTranslateItems

Tells Navigation Services not to display file translation options in the Show pop-up menu.

Available in Mac OS X v10.0 and later.
kNavAllFilesInPopup

Tells Navigation Services to add a pop-up menu item called All Documents, so the user can see a display of all files in the current directory.

Available in Mac OS X v10.0 and later.
kNavAllowStationery

Tells Navigation Services to display a Stationery Option command in the Format pop-up menu of Save dialogs, so users can choose to save a file as a document or as stationery. This is a default option.

Available in Mac OS X v10.0 and later.
kNavAllowPreviews

Tells Navigation Services to provide previews, when available, of selected files. This is a default option.

Available in Mac OS X v10.0 and later.
kNavAllowMultipleFiles

Tells Navigation Services to allow users to select and open multiple files in the browser list by shift-clicking or using the Select All command. If you don??t specify this constant, users can select multiple files for drag-and-drop operations, but the default button (normally titled Open) is disabled when multiple items are selected. Note that the user cannot add folders or volumes to a multiple selection.

Available in Mac OS X v10.0 and later.
kNavAllowInvisibleFiles

Tells Navigation Services to show invisible file objects in the browser list.

Available in Mac OS X v10.0 and later.
kNavDontResolveAliases

Tells Navigation Services not to resolve any alias selected by the user. If the user selects an alias with this option set, the file system specification returned by Navigation Services designates the alias file instead of its referenced original.

Available in Mac OS X v10.0 and later.
kNavSelectDefaultLocation

Tells Navigation Services to select the default location in the browser list. By default, Navigation Services will open the browser list with the default location displayed, not selected. For example, if you define the System Folder as the default location and specify the kNavSelectDefaultLocation constant, the System Folder appears as the current selection in the browser list. Without this constant, the browser list displays the contents of the System Folder.

Available in Mac OS X v10.0 and later.
kNavSelectAllReadableItem

Tells Navigation Services to show All Readable Documents as the default selection in the Show pop-up menu when the Open dialog is first displayed. If you do not specify this constant, Navigation Services shows the All [AppName] Documents menu item as the default selection in the Show pop-up menu when the Open dialog is first displayed.

Available in Mac OS X v10.0 and later.
kNavSupportPackages

(Available in Navigation Services 2.0 and later.) Tells Navigation Services to allow packages to be displayed in the browser list.

Available in Mac OS X v10.0 and later.
kNavAllowOpenPackages

(Available in Navigation Services 2.0 and later.) Tells Navigation Services to allow packages to be opened and navigated in the browser list.

Available in Mac OS X v10.0 and later.
kNavDontAddRecents

(Available in Navigation Services 2.0 and later.) Tells Navigation Services not to add file objects to the Recent list after a dialog is closed. This is useful if you want to allow users to choose long lists of items without cluttering up the Recent list.

Available in Mac OS X v10.0 and later.
kNavDontUseCustomFrame

(Available in Navigation Services 2.0 and later.) Tells Navigation Services not to draw a bevelled border around the customization area. The border is drawn by default, so you must specify this constant if you want to turn it off.

Note: Keep in mind that turning off the border may affect the placement of any controls you create in the customization area. This means your controls may appear differently in different versions of Navigation Services.

Available in Mac OS X v10.0 and later.
kNavDontConfirmReplacement

(Mac OS X only.) Tells Navigation Services not to display an alert when the user attempts to save a file over another file with the same name.

Available in Mac OS X v10.0 and later.
kNavPreserveSaveFileExtension

(Available in Navigation Services 3.1 and later.) Tells Navigation Services that the extension in the default filename should be preserved between dialog invocations and is initially hidden.

Available in Mac OS X v10.1 and later.*/

/*NavObjectFilterUPP

Defines a universal procedure pointer (UPP) to an application-defined filter function.

typedef NavObjectFilterProcPtr NavObjectFilterUPP;
Discussion

For more information, see the description of the NavObjectFilterProcPtr callback function.*/
struct NavDialogCreationOptions {
   UInt16 version;
   NavDialogOptionFlags optionFlags;
   Point location;
   CFStringRef clientName;
   CFStringRef windowTitle;
   CFStringRef actionButtonLabel;
   CFStringRef cancelButtonLabel;
   CFStringRef saveFileName;
   CFStringRef message;
   UInt32 preferenceKey;
   CFArrayRef popupExtension;
   WindowModality modality;
   WindowRef parentWindow;
   char reserved[16];
};
typedef struct NavDialogCreationOptions NavDialogCreationOptions;


/*NavEventUPP

Defines a universal procedure pointer (UPP) to an application-defined event–handling function.

typedef NavEventProcPtr NavEventUPP;
Discussion

For more information, see the description of the NavEventProcPtr callback function.*/
typedef NavEventProcPtr NavEventUPP;

/*NavMenuItemSpec

Defines additional items in an Open dialog’s Show pop-up menu or a Save dialog’s Format pop-up menu. 

struct NavMenuItemSpec {
   UInt16 version;
   OSType menuCreator;
   OSType menuType;
   Str255 menuItemName;
   char reserved[245];
};
typedef struct NavMenuItemSpec          NavMenuItemSpec;
typedef NavMenuItemSpec *               NavMenuItemSpecArrayPtr;
typedef NavMenuItemSpecArrayPtr *       NavMenuItemSpecArrayHandle;
typedef NavMenuItemSpecArrayPtr         NavMenuItemSpecPtr;
typedef NavMenuItemSpecArrayHandle      NavMenuItemSpecHandle;
Fields
version

Identifies the version of this structure. Be sure to specify the kNavMenuItemSpecVersion constant in this field.
menuCreator

A unique value set by your application. Navigation Services passes this value back to your application to identify the application type of the selected menu item.
menuType

A unique value set by your application. Navigation Services passes this value back to your application to identify the type of the selected menu item. Values from -1 to 10 are reserved for Navigation Services.
menuItemName

The item name that appears in the pop-up menu.
reserved

Reserved for future use.
Discussion

For information about file creators and file types, see Inside Macintosh: Macintosh Toolbox Essentials. 
Availability
Available in Mac OS X v10.0 and later.*/
struct NavMenuItemSpec {
   UInt16 version;
   OSType menuCreator;
   OSType menuType;
   Str255 menuItemName;
   char reserved[245];
};
typedef struct NavMenuItemSpec          NavMenuItemSpec;
typedef NavMenuItemSpec *               NavMenuItemSpecArrayPtr;
typedef NavMenuItemSpecArrayPtr *       NavMenuItemSpecArrayHandle;
typedef NavMenuItemSpecArrayPtr         NavMenuItemSpecPtr;
typedef NavMenuItemSpecArrayHandle      NavMenuItemSpecHandle;


/*NavDialogOptions

Contains dialog box configuration settings.

Not recommended

struct NavDialogOptions {
   UInt16 version;
   NavDialogOptionFlags dialogOptionFlags;
   Point location;
   Str255 clientName;
   Str255 windowTitle;
   Str255 actionButtonLabel;
   Str255 cancelButtonLabel;
   Str255 savedFileName;
   Str255 message;
   UInt32 preferenceKey;
   NavMenuItemSpecArrayHandle popupExtension;
   char reserved[494];
};
typedef struct NavDialogOptions NavDialogOptions;
Fields
version

Identifies the version of this structure. Be sure to specify the kNavDialogOptionsVersion constant in this field.
dialogOptionFlags

One of several constants defined by the NavDialogOptionFlags data type as described in “Dialog Configuration Options”. 
location

The upper-left location of the dialog box (in global coordinates). If you set the dialogOptionFlags field to NULL or set this field to (-1,-1), then the dialog box appears in the same location as when last closed. The size and location of the dialog box is persistent, but defaults to opening in the middle of the main screen if any portion is not visible when opened at the persistent location and size.
clientName

A string that identifies your application in the dialog box window title.
windowTitle

A string that you can provide to override the default window title.
actionButtonLabel

An alternative button title for the dialog box’s action button. If you do not specify a title, the button will use the default label (Open or Save, for example.
cancelButtonLabel

An alternative button title for the Cancel button in dialog boxes.
savedFileName

The default filename for a saved file.
message

The string for the banner, or prompt, below the browser list. This message can provide more descriptive instructions for the user. If you don’t provide a message string, the browser list expands to fill that area.
preferenceKey

An application-defined value that identifies which set of dialog box preferences Navigation Services should use. If your application maintains multiple sets of preferences for a particular type of dialog box, you can determine which set is active by specifying the appropriate value in the preferenceKey field. For example, an application may allow one set of preferences when it calls the function NavGetFile to open text files and a different set of preferences when opening movie files. If you do not wish to provide a preference key, specify NULL for the preferenceKey value.
popupExtension

A handle to one or more structures of type NavMenuItemSpec used to add extra menu items to the Show pop-up menu in an Open dialog box or the Format pop-up menu in Save dialog boxes. Using NavMenuItemSpec structures allows your application to add additional document types to be opened or saved, or different ways of saving a file (with or without line breaks, for example).
reserved

Reserved for future use.
Carbon Porting Notes

The NavDialogCreationOptions structure is the recommended replacement for the NavDialogOptions structure. NavDialogCreationOptions uses CFStrings instead of Pascal strings, thereby adding support for Unicode. In addition, NavDialogCreationOptions adds fields for controlling window modality and setting the parent window (necessary for sheets on OS X). 
Availability
Available in Mac OS X v10.0 and later.*/
struct NavDialogOptions {
   UInt16 version;
   NavDialogOptionFlags dialogOptionFlags;
   Point location;
   Str255 clientName;
   Str255 windowTitle;
   Str255 actionButtonLabel;
   Str255 cancelButtonLabel;
   Str255 savedFileName;
   Str255 message;
   UInt32 preferenceKey;
   NavMenuItemSpecArrayHandle popupExtension;
   char reserved[494];
};
typedef struct NavDialogOptions NavDialogOptions;

/*NavFileOrFolderInfo

Contains file or folder information for use by your application-defined filter function.

struct NavFileOrFolderInfo {
   UInt16 version
   Boolean isFolder
   Boolean visible
   UInt32 creationDate
   UInt32 modificationDate
   union {
      struct {
         Boolean locked;
         Boolean resourceOpen;
         Boolean dataOpen;
         Boolean reserved1;
         UInt32 dataSize;
         UInt32 resourceSize;
         FInfo finderInfo;
         FXInfo finderXInfo;
      } fileInfo;
      struct {
         Boolean shareable;
         Boolean sharePoint;
         Boolean mounted;
         Boolean readable;
         Boolean writeable;
         Boolean reserved2;
         UInt32 numberOfFiles;
         DInfo finderDInfo;
         DXInfo finderDXInfo;
         OSType folderType;
         OSType folderCreator;
         char reserved3[206];
      } folderInfo;
   } fileAndFolder;
};
typedef struct NavFileOrFolderInfo NavFileOrFolderInfo;
Fields
version

Identifies the version of this structure.
isFolder

A Boolean value. If this value is set to true, the object being described is a folder or volume; otherwise, the value is set to false. An alias to a folder or volume returns true. Check for the kIsAlias constant in the fileAndFolder.folderInfo.finderDInfo field to determine whether an object is an alias.
visible

A Boolean value. If this value is set to true, the object being described is visible in the browser list; otherwise, the value is set to false.
creationDate

The creation date of the object being described.
modificationDate

The modification date of the object being described.
fileAndFolder.fileInfo.locked

If isFolder is false, a Boolean value indicating whether the file is locked.
fileAndFolder.fileInfo.resourceOpen

If isFolder is false, a Boolean value indicating whether the resource fork of the file is open.
fileAndFolder.fileInfo.dataOpen

If isFolder is false, a Boolean value indicating whether the data fork of the file is open.
fileAndFolder.fileInfo.reserved1

Reserved.
fileAndFolder.fileInfo.dataSize

If isFolder is false, the size of the file’s data fork.
fileAndFolder.fileInfo.resourceSize

If isFolder is false, the size of the file’s resource fork.
fileAndFolder.fileInfo.finderInfo

If isFolder is false, a structure specifying further information about the file. See the Finder Interface documentation for more information on the FInfo structure.
fileAndFolder.fileInfo.finderXInfo

If isFolder is false, a structure specifying extended Finder information for the file. See the Finder Interface documentation for more information on the FXInfo structure.
fileAndFolder.folderInfo.shareable

If isFolder is true, a Boolean value indicating whether the folder is shareable.
fileAndFolder.folderInfo.sharePoint

If isFolder is true, a Boolean value indicating whether the folder is a share point.
fileAndFolder.folderInfo.mounted

If isFolder is true, a Boolean value indicating whether the folder is mounted.
fileAndFolder.folderInfo.readable

If isFolder is true, a Boolean value indicating whether the folder is readable.
fileAndFolder.folderInfo.writeable

If isFolder is true, a Boolean value indicating whether the folder is writeable.
fileAndFolder.folderInfo.reserved2

Reserved.
fileAndFolder.folderInfo.numberOfFiles

If isFolder is true, the number of files in the folder.
fileAndFolder.folderInfo.finderDInfo

If isFolder is true, a directory information structure describing the folder. See the Finder Interface documentation for further information on the DInfo structure.
fileAndFolder.folderInfo.finderDXInfo

If isFolder is true, an extended directory information structure describing the folder. See the Finder Interface documentation for further information on the DXInfo structure.
fileAndFolder.folderInfo.folderType

If isFolder is true, the package type (for structure version 1 or greater).
fileAndFolder.folderInfo.folderCreator

If isFolder is true, the creator code for the package (for structure version 1 or greater).
Discussion

The NavFileOrFolderInfo structure contains file or folder information for use by your application-defined filter function. Your filter function can determine whether the currently selected object is a file by checking the isFolder field of the NavFileOrFolderInfo structure for the value false. After making this determination, you can obtain more information about the object from the structure specified in the fileAndFolder field. 
Special Considerations

The information in this structure is valid only for HFS file objects.
Availability
Available in Mac OS X v10.0 and later.*/

struct NavFileOrFolderInfo {
   UInt16 version;
   Boolean isFolder;
   Boolean visible;
   UInt32 creationDate;
   UInt32 modificationDate;
   union {
      struct {
         Boolean locked;
         Boolean resourceOpen;
         Boolean dataOpen;
         Boolean reserved1;
         UInt32 dataSize;
         UInt32 resourceSize;
         FInfo finderInfo;
         FXInfo finderXInfo;
      } fileInfo;
      struct {
         Boolean shareable;
         Boolean sharePoint;
         Boolean mounted;
         Boolean readable;
         Boolean writeable;
         Boolean reserved2;
         UInt32 numberOfFiles;
         DInfo finderDInfo;
         DXInfo finderDXInfo;
         OSType folderType;
         OSType folderCreator;
         char reserved3[206];
      } folderInfo;
   } fileAndFolder;
};
typedef struct NavFileOrFolderInfo NavFileOrFolderInfo;

/*Save Changes Actions

Describe the user response to a Save Changes dialog.

typedef UInt32 NavAskSaveChangesResult;
enum {
   kNavAskSaveChangesSave = 1,
   kNavAskSaveChangesCancel = 2,
   kNavAskSaveChangesDontSave = 3
};
Constants
kNavAskSaveChangesSave

User clicked the Save button.

Available in Mac OS X v10.0 and later.
kNavAskSaveChangesCancel

User clicked the Cancel button.

Available in Mac OS X v10.0 and later.
kNavAskSaveChangesDontSave

User clicked the Don’t Save button.

Available in Mac OS X v10.0 and later.
Discussion

When you create a Save dialog using the function NavCreatePutFileDialog, you obtain the user’s response by calling NavDialogGetReply, specifying a NavReplyRecord structure in the outReply parameter. On completion, this structure contains a value represented by one of the constants defined by the NavAskSaveChangesResult data type.*/

typedef UInt32 NavAskSaveChangesResult;
enum {
   kNavAskSaveChangesSave = 1,
   kNavAskSaveChangesCancel = 2,
   kNavAskSaveChangesDontSave = 3
};

//function

/*NavDialogDispose

Disposes of a dialog reference.

void NavDialogDispose (
   NavDialogRef inDialog
);
Parameters
inDialog

A Navigation Services dialog reference previously obtained by your application. 
Discussion

Use this function to dispose of a dialog reference when you are completely finished with its associated dialog. You may call NavDialogDispose from within your application-defined event-handling function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

void NavDialogDispose (
   NavDialogRef inDialog
);

/*NewNavObjectFilterUPP

Creates a new universal procedure pointer to your application-defined filter function.

NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your filter function. 
Return Value

On return, a universal procedure pointer (UPP) to the filter function. See the description of the NavObjectFilterUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavObjectFilterUPP NewNavObjectFilterUPP (
   NavObjectFilterProcPtr userRoutine
);

/*NavCreateChooseFileDialog

Creates a Choose File dialog, which prompts the user to select a single file as the target of an operation.

OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying a creator signature and a list of file types to show in the Choose File dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your application??s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application??s preview function. You may specify NULL if you don??t need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application??s filter function. You may specify NULL if you don??t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose File dialog, A pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See ??Navigation Services Result Codes??. A result code.
Discussion

Once you have successfully created the Choose File dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseFile function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavDisposeReply

Releases the memory allocated for a NavReplyRecord structure after your application has finished using the structure.

OSErr NavDisposeReply (
   NavReplyRecord * reply
);
Parameters
reply

A pointer to a structure of type NavReplyRecord that your application has created.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

If your application calls a Navigation Services function that uses a structure of type NavReplyRecord, you must use the NavDisposeReply function afterward to release the memory allotted for the NavReplyRecord structure. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSErr NavDisposeReply (
   NavReplyRecord * reply
);

/*NavDialogRun

Displays a previously created dialog.

OSStatus NavDialogRun (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created Navigation Services dialog. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

You must create a dialog before displaying it. To create a dialog, call one of the NavCreate...Dialog functions described in “Choosing Files, Folders and Volumes” and “Saving Files”. If you specify an application-modal or system-modal dialog, the NavDialogRun function returns after the dialog is dismissed. If you specify a window-modal dialog (sheet) or a modeless dialog, the NavDialogRun function returns immediately; in order to know when the dialog has been dismissed, you must supply an event-handling function and watch for the kNavCBUserAction event. 

After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. 
Version Notes

On Mac OS 9 and earlier, all Navigation Services dialogs are modal, even if a window-modal or modeless dialog is requested. However, the kNavCBUserAction event is still sent to your event-handling function. It is possible to use a single programming model on both Mac OS 9 and on Mac OS X, provided you assume that the NavDialogRun function returns immediately after displaying the dialog.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogRun (
   NavDialogRef inDialog
);

/*NavDialogGetReply

Reports the results of a dialog session (unless cancelled or programmatically terminated).

OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply
);
Parameters
inDialog

A reference to a previously created dialog. 
outReply

A pointer to a reply record you allocate to be filled out by Navigation Services. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

Call this function when you obtain a value other than kNavUserActionCancel or kNavUserActionNone from the NavDialogGetUserAction function. Upon completion of the NavDialogGetReply function, Navigation Services fills out the specified reply record with information about the dialog session. When you are finished with the reply record, remember to dispose of it by calling the NavDisposeReply function. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavDialogGetReply (
   NavDialogRef inDialog,
   NavReplyRecord * outReply
);

/*NavGetDefaultDialogCreationOptions

Determines the default attributes or behavior for dialogs. 

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions
);
Parameters
outOptions

A pointer to a NavDialogCreationOptions structure that you provide. On return, Navigation Services fills out the structure with default dialog configuration values.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function gives you a simple way to initialize a NavDialogCreationOptions structure and set default options before creating a Navigation Services dialog. After you create the NavDialogCreationOptions structure, you can change the configuration options before you call one of the dialog creation functions. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavGetDefaultDialogCreationOptions (
   NavDialogCreationOptions * outOptions
);

/*NewNavEventUPP

Creates a new universal procedure pointer to your application-defined event–handling function.

NavEventUPP NewNavEventUPP (
   NavEventProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your event–handling function. 
Return Value

On return, a universal procedure pointer (UPP) to the event–handling function. See the description of the NavEventUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
NavEventUPP NewNavEventUPP (
   NavEventProcPtr userRoutine
);

/*NavCreateChooseObjectDialog

Creates a Choose Object dialog, which prompts the user to select a file. folder or volume.

OSStatus NavCreateChooseObjectDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on preview functions, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose Object dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Choose Object dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseObject function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseObjectDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavDialogGetUserAction

Reports the user action taken to dismiss a dialog.

NavUserAction NavDialogGetUserAction (
   NavDialogRef inDialog
);
Parameters
inDialog

A reference to a previously created dialog. 
Return Value

One of the constants defined by the NavUserAction enumeration. This value indicates the user action that dismissed the dialog. See “User Actions” for a description of the values that may be returned here.
Discussion

If the dialog has not been dismissed or if the dialog was terminated by using the kNavCtlTerminate selector with the NavCustomControl function, the NavDialogGetUserAction function returns the kNavUserActionNone constant. When you obtain a value other than kNavUserActionCancel or kNavUserActionNone after returning from a file-handling dialog, Navigation Services fills out a reply record that you can obtain with the NavDialogGetReply function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

NavUserAction NavDialogGetUserAction (
   NavDialogRef inDialog
);

/*NavCreateGetFileDialog

Creates an Open dialog, which prompts the user to select a file or files to be opened.

OSStatus NavCreateGetFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inTypeList

A structure specifying an application signature and a list of file types to show in the Open dialog.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inPreviewProc

A Universal Procedure Pointer (UPP) to your application’s preview function. You may specify NULL if you don’t need to register a preview function. For more information on creating a preview function, see NavPreviewProcPtr.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on creating a filter function, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of an Open dialog instance, this value specifies a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Open dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavGetFile function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavCreateGetFileDialog (
   const NavDialogCreationOptions * inOptions,
   NavTypeListHandle inTypeList,
   NavEventUPP inEventProc,
   NavPreviewUPP inPreviewProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavCreateAskReviewDocumentsDialog

Creates a Review Changes dialog, which notifies the user of multiple unsaved documents and gives the user the option to review them.

OSStatus NavCreateAskReviewDocumentsDialog (
   const NavDialogCreationOptions * inOptions,
   UInt32 inDocumentCount,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inDocumentCount

The number of documents needing review. This number appears in the text presented to the user. If the total number of unsaved documents is unknown, specify 0; Navigation Services uses a general message. You should not specify 1; this alert should be used only when more than one document needs review. For more information, see Inside Mac OS X: Aqua Human Interface Guidelines.
inEventProc

A universal procedure pointer (UPP) to an application-defined event-handling function.You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inClientData

A pointer to an application-defined value that is passed back to all callback functions.
outDialog

Upon successful completion, a reference to the created dialog. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

The Review Changes dialog tells the user how many unsaved documents there are and asks the user to choose one of the following options:
review the unsaved documents
don't save any documents
cancel

Use of this dialog is appropriate when an application is quitting and there is more than one unsaved document. It is supported only on Mac OS X; prior to Mac O X, this dialog is not part of the application quit sequence. 

Upon successful creation, the dialog is not visible; to present and run the dialog, call the NavDialogRun function. After the dialog is complete, dispose of it with the NavDialogDispose function. Upon dismissal of the dialog, the user’s action is set to one of the following actions: kNavUserActionReviewDocuments, kNavUserActionDiscardDocuments, or kNavUserActionCancel. You can obtain this reply by calling the NavDialogGetReply.
Availability
Not available in CarbonLib.
Available in Mac OS X 10.1 and later.
Declared In
Navigation.h*/
OSStatus NavCreateAskReviewDocumentsDialog (
   const NavDialogCreationOptions * inOptions,
   UInt32 inDocumentCount,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavCreateAskSaveChangesDialog

Creates a dialog that asks the user whether to save changes.

OSStatus NavCreateAskSaveChangesDialog (
   const NavDialogCreationOptions * inOptions,
   NavAskSaveChangesAction inAction,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inAction

A value indicating whether the user is closing a document or quitting the application and thereby determines the message displayed to the user. To provide a customized message for the dialog, specify a non-NULL value in the message field of the structure provided in the inOptions parameter.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of the Save Changes dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

This function creates a Save Changes dialog, which your application should display when the user attempts to close a document or quit the application with unsaved changes. The Save Changes dialog allows the user to choose one of the following options:
save the changes
discard the unsaved changes
cancel the operation

Once you have successfully created the Save Changes dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, dispose of it by calling the NavDialogDispose function.

If there is more than one document with unsaved changes when the user attempts to quit your application, you should display a Review Changes dialog instead. You can create a Review Changes dialog with the NavCreateAskReviewDocumentsDialog function.

This function replaces the NavAskSaveChanges function and adds support for Unicode and new window modalities.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateAskSaveChangesDialog (
   const NavDialogCreationOptions * inOptions,
   NavAskSaveChangesAction inAction,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavCompleteSave

Completes a save operation and performs any needed translation on the file.

OSErr NavCompleteSave (
   NavReplyRecord * reply,
   NavTranslationOptions howToTranslate
);
Parameters
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavCompleteSave call. 
howToTranslate

A pointer to a structure of type NavTranslationOptions. Pass one of two values to specify how to perform any needed translation. For a description of the constants you can use to represent these values, see “Translation Options”. Translating in-place causes the source file to be replaced by the translation. Translating to a copy results in a file name followed by the string “(converted)” to avoid unwanted replacement. If you call the NavCompleteSave function in response to a Save a Copy command, you should pass the kNavTranslateInPlace constant in this parameter. 
Return Value

A result code. See “Navigation Services Result Codes”. Since this function performs any needed translation, it may return a translation error.
Discussion

You should always call NavCompleteSave to complete any file saving operation performed with the NavCreatePutFileDialog function. NavCompleteSave performs any needed translation, so you do not have to use the function NavTranslateFile when saving. If you wish to turn off automatic translation, set to false the value of the translationNeeded field of the NavReplyRecord structure you pass in the reply parameter of the NavPutFile function. If you turn off automatic translation, your application is responsible for any required translation.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSErr NavCompleteSave (
   NavReplyRecord * reply,
   NavTranslationOptions howToTranslate
);

/*NavCreatePutFileDialog

Creates a Save dialog, which prompts the user for the name and location of a file to be saved.

OSStatus NavCreatePutFileDialog (
   const NavDialogCreationOptions * inOptions,
   OSType inFileType,
   OSType inFileCreator,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inFileType

A four-character code specifying a file type for the file to be saved.
inFileCreator

A four-character code specifying a creator signature for the file to be saved. If you want to change or remove the top default item in the Format menu, pass kNavGenericSignature.
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Save dialog, a pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Save dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavPutFile function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSStatus NavCreatePutFileDialog (
   const NavDialogCreationOptions * inOptions,
   OSType inFileType,
   OSType inFileCreator,
   NavEventUPP inEventProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavGetDefaultDialogOptions

Determines the default attributes or behavior for dialog boxes. 

Not recommended

OSErr NavGetDefaultDialogOptions (
   NavDialogOptions * dialogOptions
);
Parameters
dialogOptions

A pointer to a structure of type NavDialogOptions. On return, Navigation Services fills out the structure with default option values that your application can change as needed.
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function gives you a simple way to initialize a structure of type NavDialogOptions and set the default dialog box options before calling one of the dialog box display functions. After you create the NavDialogOptions structure, you can supply it with the NavDialogOptions constants, described in “Dialog Configuration Options”, to change the configuration options. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends that you adopt the dialog creation functions (NavCreate...Dialog); you pass these functions a NavDialogCreationOptions structure rather than a NavDialogOptions structure.
Declared In
Navigation.h*/
OSErr NavGetDefaultDialogOptions (
   NavDialogOptions * dialogOptions
);

/*NavGetFile

Displays a dialog box that prompts the user to select a file or files to be opened. 

Not recommended

OSErr NavGetFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavGetFile, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services defaults to the last location visited during a call to the NavGetFile function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavGetFile call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavGetFile, set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Open dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr. 
previewProc

A Universal Procedure Pointer (UPP) to your application-defined preview function. Obtain this UPP by calling the function NewNavPreviewUPP. A preview function allows your application to draw previews or to override Navigation Services previews. For more information on preview functions, see NavPreviewProcPtr. 
filterProc

A Universal Procedure Pointer (UPP) to your application-defined filter function. Obtain this UPP by calling the function NewNavObjectFilterUPP. An application-defined filter function determines if a volume, directory, or file should be displayed in the browser list or pop-up menus. For more information on filter functions, see NavObjectFilterProcPtr. 
typeList

A handle to a structure of type NavTypeList. Before calling, set up this structure to declare file types that your application can open.
callBackUD

A pointer to a value set by your application. When the NavGetFile function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

After your application calls the NavGetFile function to display an Open dialog box and the user selects one or more files and clicks the Open button, NavGetFile closes the dialog box and returns references to the files to be opened in the NavReplyRecord structure. Your application should check the validRecord field of the NavReplyRecord structure; if this field is set to true, your application should open the files specified in the selection field of the NavReplyRecord structure.

Always dispose of the NavReplyRecord structure after completing the file opening operation by calling the function NavDisposeReply. If you fail to use the NavDisposeReply function, memory used for the NavReplyRecord structure remains allocated and unavailable.

If you use the Show pop-up menu in an Open dialog box, your application must provide adequate kind strings to describe its native file types. For more information on kind strings, see Inside Macintosh: More Macintosh Toolbox.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateGetFileDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavGetFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
);

/*DisposeNavEventUPP

Disposes of a UPP to an application-defined event–handling function.

void DisposeNavEventUPP (
   NavEventUPP userUPP
);
Parameters
userUPP

The UPP to dispose of. 
Discussion

For more information on event–handling functions, see NavEventProcPtr.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
void DisposeNavEventUPP (
   NavEventUPP userUPP
);

/*NavChooseFile

Creates a simple dialog box that prompts the user to select a file.

Not recommended

OSErr NavChooseFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavChooseFile, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services displays the last location visited during a call to the NavChooseFile function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavChooseFile call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavChooseFile, you can set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Choose a File dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr. 
previewProc

A Universal Procedure Pointer (UPP) to your application-defined preview function. Obtain this UPP by calling the function NewNavPreviewUPP. A preview function allows your application to draw previews or to override Navigation Services previews. For more information on preview functions, see NavPreviewProcPtr. 
filterProc

A Universal Procedure Pointer (UPP) to your application-defined filter function. Obtain this UPP by calling the function NewNavObjectFilterUPP. An application-defined filter function determines if a volume, directory, or file should be displayed in the browser list or pop-up menus. For more information on filter functions, see NavObjectFilterProcPtr. 
typeList

A handle to a structure of type NavTypeList. Before calling NavChooseFile, you can set up this structure to declare file types that your application can open.
callBackUD

A pointer to a value set by your application. When the NavChooseFile function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function allows the user to choose a single file, such as a preferences file, for an action other than opening. The NavChooseFile function is similar to NavGetFile, but is limited to selecting a single file.

The dialog box displayed by the NavChooseFile function does not display a Show menu. If you wish to control the files displayed by the browser list or the pop-up menus, you must specify a list of file types in the typeList parameter or specify a filter function in the filterProc parameter. If you specify a list of file types in the typeList parameter, the NavChooseFile function ignores the signature field of the NavTypeList structure. This means that all files of the types specified in the list of file types will be displayed, regardless of their application signature.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateChooseFileDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavChooseFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavPreviewUPP previewProc,
   NavObjectFilterUPP filterProc,
   NavTypeListHandle typeList,
   void * callBackUD
);

/*DisposeNavObjectFilterUPP

Disposes of a UPP to an application-defined filter function.

void DisposeNavObjectFilterUPP (
   NavObjectFilterUPP userUPP
);
Parameters
userUPP

The UPP to dispose of. 
Discussion

For more information on filter functions, see NavObjectFilterProcPtr.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
void DisposeNavObjectFilterUPP (
   NavObjectFilterUPP userUPP
);

/*DisposeNavPreviewUPP

Disposes of a UPP to an application-defined preview function.

void DisposeNavPreviewUPP (
   NavPreviewUPP userUPP
);
Parameters
userUPP

The UPP to dispose of. 
Discussion

For more information on preview functions, see NavPreviewProcPtr.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

void DisposeNavPreviewUPP (
   NavPreviewUPP userUPP
);

/*NewNavPreviewUPP

Creates a new universal procedure pointer to your application-defined preview function.

NavPreviewUPP NewNavPreviewUPP (
   NavPreviewProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your preview function. 
Return Value

On return, a universal procedure pointer (UPP) to the preview function. See the description of the NavPreviewUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

NavPreviewUPP NewNavPreviewUPP (
   NavPreviewProcPtr userRoutine
);

/*NavCustomControl

Allows your application to control various settings in Navigation Services dialogs.

OSErr NavCustomControl (
   NavDialogRef dialog,
   NavCustomControlMessage selector,
   void * parms
);
Parameters
dialog

A Navigation Services dialog reference. You can obtain this value from the context field of the structure of type NavCBRec specified in the callBackParms parameter of your event-handling function.
selector

A value of type NavCustomControlMessage. Pass one or more of the constants representing the possible values used to control various aspects of the active dialog. For a description of these constants, see “Custom Control Settings”. 
parms

A pointer to a configuration value. Some of the control setting constants passed in the selector parameter require that you provide an additional configuration value. For a description of which constants require configuration values, see “Custom Control Settings”. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

If you provide an event-handling function and an event occurs in a Navigation Services dialog, Navigation Services calls your event-handling function and specifies one of the constants described in “Event Messages” in the param field of a NavCBRec structure. Navigation Services specifies this structure in the callBackParms parameter of your event-handling function. When Navigation Services supplies the kNavCBStart constant in the param field, your application can call the NavCustomControl function and pass one of the constants described in “Custom Control Settings” to control various aspects of the active Navigation Services dialog. For example, your application can tell Navigation Services to sort the browser list by date by calling the NavCustomControl function and passing the kNavCtlSortBy constant in the selector parameter and a pointer to the kNavSortDateField configuration constant in the parms parameter. (Some of the NavCustomControlMessage constants do not require a corresponding configuration constant.)

Note that your application can call the NavCustomControl function from within its event-handling function or its preview-drawing function. 
Special Considerations

Navigation Services does not accept calls to the NavCustomControl function until an appropriate dialog box is fully initialized and displayed. Always check for the kNavCBStart constant, described in “Event Messages”, in the param field of the NavCBRec structure before calling the NavCustomControl function.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/

OSErr NavCustomControl (
   NavDialogRef dialog,
   NavCustomControlMessage selector,
   void * parms
);

/*NavPutFile

Displays a Save dialog box. 

Not recommended

OSErr NavPutFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   OSType fileType,
   OSType fileCreator,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavPutFile, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services displays the last location visited during a call to the NavPutFile function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavPutFile call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavPutFile, you can set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings.
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Save dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr.
fileType

A four-character code. Pass the file type code for the document to be saved.
fileCreator

A four-character code. Pass the file creator code for the document to be saved. Under Navigation Services 2.0 or later, you may pass the “Generic File Signature Constant” constant if you want to override the types of files appearing in the Format popup.
callBackUD

A pointer to a value set by your application. When the NavPutFile function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”. Note: If you specify the kNavDontResolveAliases constant as a dialog box option, as described in “Dialog Configuration Options”, before calling the NavPutFile function, Navigation Services returns a paramErr (-50).
Discussion

After your application calls the NavPutFile function to display a Save dialog box and the user selects a location, enters a filename, and clicks OK, NavPutFile closes the dialog box and returns references to the file to be saved in the NavReplyRecord structure. Your application should check the validRecord field of the NavReplyRecord structure; if this field is set to true, your application should save the file and call the function NavCompleteSave. 

If you specify the Format pop-up menu in a dialog box displayed by the NavPutFile function, your application must provide adequate kind strings to describe the file types available. If the user uses the Format menu to save a file to a format other than the file’s native format, Navigation Services translates the file automatically. If you wish to turn off automatic translation, set to false the value of the translationNeeded field of the NavReplyRecord structure you pass in the reply parameter. If you turn off automatic translation, your application is responsible for any required translation.
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreatePutFileDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/

OSErr NavPutFile (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   OSType fileType,
   OSType fileCreator,
   void * callBackUD
);

/*NavAskSaveChanges

Displays a Save Changes alert box. 

Not recommended

OSErr NavAskSaveChanges (
   NavDialogOptions * dialogOptions,
   NavAskSaveChangesAction action,
   NavAskSaveChangesResult * reply,
   NavEventUPP eventProc,
   void * callBackUD
);
Parameters
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavAskSaveChanges, set up this structure to specify dialog box settings. When calling NavAskSaveChanges, the clientName and savedFileName fields are the only two fields you must supply with values. 
action

A value of type NavAskSaveChangesAction. Pass a constant describing the user action that prompted the Save Changes alert box. For a description of the constants, see “Save Changes Requests”. 
reply

A pointer to a value of type NavAskSaveChangesResult. On return, the value describes the user’s response to the Save Changes alert box. For a description of the constants used to represent possible responses, see “Save Changes Actions”. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the Save Changes alert box is not movable. For more information on event-handling functions, see NavEventProcPtr. 
callBackUD

A pointer to a value set by your application. When the NavAskSaveChanges function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function is useful when your application needs to display an alert when the user attempts to close a document or an application with unsaved changes. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateAskSaveChangesDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavAskSaveChanges (
   NavDialogOptions * dialogOptions,
   NavAskSaveChangesAction action,
   NavAskSaveChangesResult * reply,
   NavEventUPP eventProc,
   void * callBackUD
);

/*NavCreateChooseFolderDialog

Creates a Choose Folder dialog, which prompts the user to select a folder as the target of an operation.

OSStatus NavCreateChooseFolderDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);
Parameters
inOptions

A pointer to a structure specifying options that control the appearance and behavior of the dialog. 
inEventProc

A Universal Procedure Pointer (UPP) to your application’s event-handling function. You are strongly advised to create and register an event-handling function, as described in NavEventProcPtr. You must have an event-handling function in order to create modeless or window-modal (sheet) dialogs. Specify NULL in this parameter if you do not implement an event-handling function.
inFilterProc

A Universal Procedure Pointer (UPP) to your application’s filter function. You may specify NULL if you don’t need to register a filter function. For more information on filter functions, see NavObjectFilterProcPtr.
inClientData

A pointer to an application-defined value that is passed back to all callback functions. You can use this value to provide context information, for example. You may pass NULL in this parameter. 
outDialog

On successful creation of a Choose Folder dialog, A pointer to a Navigation Services dialog reference that you can pass to the NavDialogRun function. 
Return Value

A result code. See “Navigation Services Result Codes”. A result code.
Discussion

Once you have successfully created the Choose Folder dialog, you display it by calling the NavDialogRun function. After the user interacts with the dialog, you can obtain information about the dialog session by calling the NavDialogGetReply function. When you are finished with the dialog, you should dispose of it by calling the NavDialogDispose function.

This function replaces the NavChooseFolder function and adds support for Unicode and new window modalities. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X 10.0 and later.
Declared In
Navigation.h*/
OSStatus NavCreateChooseFolderDialog (
   const NavDialogCreationOptions * inOptions,
   NavEventUPP inEventProc,
   NavObjectFilterUPP inFilterProc,
   void * inClientData,
   NavDialogRef * outDialog
);

/*NavChooseFolder

Displays a dialog box that prompts the user to choose a folder or volume.

Not recommended

OSErr NavChooseFolder (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavObjectFilterUPP filterProc,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavChooseFolder, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services displays the last location visited during a call to the NavChooseFolder function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavChooseFolder call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavChooseFolder, set up this structure to specify dialog box settings. If you pass NULL in this parameter, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr. 
filterProc

A Universal Procedure Pointer (UPP) to your application-defined filter function. Obtain this UPP by calling the function NewNavObjectFilterUPP. An application-defined filter function determines if a volume, directory, or file should be displayed in the browser list or pop-up menus. For more information on filter functions, see NavObjectFilterProcPtr. 
callBackUD

A pointer to a value set by your application. When the NavChooseFolder function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function provides a way for your application to prompt the user to select a folder or volume. This might be useful if you need to install application files, for example. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateChooseFolderDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/
OSErr NavChooseFolder (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavObjectFilterUPP filterProc,
   void * callBackUD
);

/*NavChooseObject

Displays a dialog box that prompts the user to choose a file, folder, or volume.

Not recommended

OSErr NavChooseObject (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavObjectFilterUPP filterProc,
   void * callBackUD
);
Parameters
defaultLocation

A pointer to an Apple event descriptor structure (AEDesc). Before calling NavChooseObject, you can set up a structure of AEDesc type 'typeFSS' to specify a default location to be viewed. If you pass NULL in this parameter, Navigation Services displays the last location visited during a call to the NavChooseObject function. If the file system specification in the AEDesc structure does not describe a directory or volume, Navigation Services uses the desktop as the default location. 
reply

A pointer to a structure of type NavReplyRecord. Upon return, Navigation Services uses this structure to provide data to your application about the results of your NavChooseObject call. 
dialogOptions

A pointer to a structure of type NavDialogOptions. Before calling NavChooseObject, set up this structure to specify dialog box settings. If you do not provide this structure, Navigation Services uses the defaults for all options. See “Dialog Configuration Options” for a description of the default settings. 
eventProc

A Universal Procedure Pointer (UPP) to your application-defined event-handling function. You obtain this UPP by calling the function NewNavEventUPP. Implementing an event-handling function allows your application to update windows after the user moves or resizes the dialog box. If you pass NULL in this parameter, the dialog box is not movable or resizable. For more information on event-handling functions, see NavEventProcPtr. 
filterProc

A Universal Procedure Pointer (UPP) to your application-defined filter function. Obtain this UPP by calling the function NewNavObjectFilterUPP. An application-defined filter function determines if a volume, directory, or file should be displayed in the browser list or pop-up menus. For more information on filter functions, see NavObjectFilterProcPtr. 
callBackUD

A pointer to a value set by your application. When the NavChooseObject function calls your event-handling function, the callBackUD value is passed back to your application. 
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function is useful when you need to display a dialog box that prompts the user to choose a file object that might be a file, folder, or volume. If you want the user to choose a specific type of file object, you should use the function designed for that type of object; to select a file, for example, use the function NavChooseFile. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

Apple recommends you use the function NavCreateChooseObjectDialog in order to take advantage of Mac OS X features like Unicode, long filenames and enhanced modality.
Declared In
Navigation.h*/

OSErr NavChooseObject (
   AEDesc * defaultLocation,
   NavReplyRecord * reply,
   NavDialogOptions * dialogOptions,
   NavEventUPP eventProc,
   NavObjectFilterUPP filterProc,
   void * callBackUD
);

/*NavLoad

Pre-loads the Navigation Services shared library.

Unsupported

OSErr NavLoad ();
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

Use this function to pre-load the Navigation Services library. Pre-loading increases the memory used by your application, but it provides the best performance when using Navigation Services functions. If you don’t use the NavLoad function, the Navigation Services shared library may not be loaded until your application calls one of the Navigation Services functions. If you use the NavLoad function, you must call the function NavUnload if you want to release reserved memory prior to quitting. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present. Not available in Mac OS X. 
Declared In
Navigation.h*/
OSErr NavLoad ();

/*NavUnload

Unloads the Navigation Services shared library.

Unsupported

OSErr NavUnload ();
Return Value

A result code. See “Navigation Services Result Codes”.
Discussion

This function allows your application to unload the Navigation Services library and release the memory reserved for it. If you use the function NavLoad to load the Navigation Services library, you must call the NavUnload function if you want to release reserved memory prior to quitting. 
Availability
Available in CarbonLib 1.0 and later when Navigation Services 1.0 or later is present. Not available in Mac OS X. 
Declared In
Navigation.h*/
OSErr NavUnload ();

/*NavServicesAvailable

Reports whether the Navigation Services library is available on the user’s system.

Boolean NavServicesAvailable ();
Return Value

A Boolean value. This function returns true if Navigation Services is available, false if not. 
Discussion

Use this function before attempting to use Navigation Services on Mac OS 8 and Mac OS 9. It is not necessary to call this function on Mac OS X, as Navigation Services is always available.
Special Considerations

There is a known problem with Navigation Services 1.0 that occurs if you call NavServicesAvailable more than once without the Appearance Manager being installed. Make sure that you check for the presence of the Appearance Manager before calling NavServicesAvailable.
Version Notes

Available in Navigation Services 1.0 and later.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Navigation.h*/


Boolean NavServicesAvailable ();
// #define NavServicesAvailable()  (true)

#ifdef __cplusplus
}
#endif

#endif